/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gephi.algorithms.shortestpath.BellmanFordShortestPathAlgorithm;
import org.gephi.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.tools.spi.MouseClickEventListener;
import org.gephi.tools.spi.NodeClickEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.ShortestPathPanel;
import org.gephi.visualization.VizController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ShortestPath
implements Tool {
    private ToolEventListener[] listeners;
    private ShortestPathPanel shortestPathPanel;
    private Color color = Color.RED;
    private boolean settingEdgeSourceColor;
    private Node sourceNode;

    public void select() {
        this.settingEdgeSourceColor = !VizController.getInstance().getVizModel().isEdgeHasUniColor();
        VizController.getInstance().getVizModel().setEdgeHasUniColor(true);
        VizController.getInstance().getVizConfig().setEnableAutoSelect(false);
    }

    public void unselect() {
        this.listeners = null;
        this.sourceNode = null;
        this.shortestPathPanel = null;
        VizController.getInstance().getVizModel().setEdgeHasUniColor(this.settingEdgeSourceColor);
        VizController.getInstance().getVizConfig().setEnableAutoSelect(true);
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[2];
        this.listeners[0] = new NodeClickEventListener(){

            public void clickNodes(Node[] nodes) {
                Node n = nodes[0];
                if (ShortestPath.this.sourceNode == null) {
                    ShortestPath.this.sourceNode = n;
                    ShortestPath.this.shortestPathPanel.setResult("");
                    ShortestPath.this.shortestPathPanel.setStatus(NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.status2"));
                } else if (n != ShortestPath.this.sourceNode) {
                    ShortestPath.this.color = ShortestPath.this.shortestPathPanel.getColor();
                    Node targetNode = n;
                    GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
                    GraphModel gm = gc.getGraphModel();
                    Object algorithm = gm.isDirected() ? new BellmanFordShortestPathAlgorithm(gm.getDirectedGraphVisible(), ShortestPath.this.sourceNode) : new DijkstraShortestPathAlgorithm(gm.getGraphVisible(), ShortestPath.this.sourceNode);
                    algorithm.compute();
                    double distance = (Double)algorithm.getDistances().get(targetNode);
                    if (distance != Double.POSITIVE_INFINITY) {
                        targetNode.setColor(ShortestPath.this.color);
                        VizController.getInstance().selectNode(targetNode);
                        Edge predecessorEdge = algorithm.getPredecessorIncoming(targetNode);
                        Node predecessor = algorithm.getPredecessor(targetNode);
                        while (predecessorEdge != null && predecessor != ShortestPath.this.sourceNode) {
                            predecessorEdge.setColor(ShortestPath.this.color);
                            VizController.getInstance().selectEdge(predecessorEdge);
                            predecessor.setColor(ShortestPath.this.color);
                            VizController.getInstance().selectNode(predecessor);
                            predecessorEdge = algorithm.getPredecessorIncoming(predecessor);
                            predecessor = algorithm.getPredecessor(predecessor);
                        }
                        predecessorEdge.setColor(ShortestPath.this.color);
                        VizController.getInstance().selectEdge(predecessorEdge);
                        ShortestPath.this.sourceNode.setColor(ShortestPath.this.color);
                        VizController.getInstance().selectNode(ShortestPath.this.sourceNode);
                        ShortestPath.this.shortestPathPanel.setResult(NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.result", (Object)distance));
                    } else {
                        ShortestPath.this.shortestPathPanel.setResult(NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.noresult"));
                    }
                    ShortestPath.this.sourceNode = null;
                    ShortestPath.this.shortestPathPanel.setStatus(NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.status1"));
                }
            }
        };
        this.listeners[1] = new MouseClickEventListener(){

            public void mouseClick(int[] positionViewport, float[] position3d) {
                if (ShortestPath.this.sourceNode != null) {
                    ShortestPath.this.shortestPathPanel.setStatus(NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.status1"));
                    ShortestPath.this.sourceNode = null;
                } else {
                    VizController.getInstance().resetSelection();
                }
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                ShortestPath.this.shortestPathPanel = new ShortestPathPanel();
                ShortestPath.this.shortestPathPanel.setColor(ShortestPath.this.color);
                ShortestPath.this.shortestPathPanel.setStatus(NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.status1"));
                return ShortestPath.this.shortestPathPanel;
            }

            public String getName() {
                return NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.name");
            }

            public Icon getIcon() {
                return new ImageIcon(this.getClass().getResource("/org/gephi/tools/plugin/resources/shortestpath.png"));
            }

            public String getDescription() {
                return NbBundle.getMessage(ShortestPath.class, (String)"ShortestPath.description");
            }

            public int getPosition() {
                return 140;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }
}

