/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.interactive.completers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import jline.console.completer.Completer;
import jline.internal.Preconditions;

public class StringsCompleter
implements Completer {
    private SortedSet<String> strings = new TreeSet<String>();

    public StringsCompleter() {
    }

    public StringsCompleter(Collection<String> strings) {
        Preconditions.checkNotNull(strings);
        this.getStrings().addAll(strings);
    }

    public StringsCompleter(String ... strings) {
        this(Arrays.asList(strings));
    }

    public SortedSet<String> getStrings() {
        return this.strings;
    }

    public void setStrings(SortedSet<String> strings) {
        this.strings = strings;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        if (buffer == null) {
            candidates.addAll(this.getStrings());
        } else {
            String match;
            Iterator iterator = this.getStrings().tailSet(buffer).iterator();
            while (iterator.hasNext() && (match = (String)iterator.next()).startsWith(buffer)) {
                candidates.add(match);
            }
        }
        return candidates.isEmpty() ? -1 : 0;
    }
}

