/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.validation;

import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class ValidationException
extends DataIntegrityViolationException {
    private static final long serialVersionUID = 1L;
    public static final Class<? extends RuntimeException> VALIDATION_EXCEPTION_TYPE;
    private final String fullMessage;
    private final Errors errors;

    public ValidationException(String msg, Errors errors) {
        super(msg);
        this.fullMessage = ValidationException.formatErrors(errors, msg);
        this.errors = errors;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public String getMessage() {
        return this.fullMessage;
    }

    public static String formatErrors(Errors errors, String msg) {
        String ls = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        if (msg != null) {
            b.append(msg).append(" : ").append(ls);
        }
        for (ObjectError error : errors.getAllErrors()) {
            b.append(ls).append(" - ").append(error).append(ls);
        }
        return b.toString();
    }

    public static RuntimeException newInstance(String message, Errors errors) {
        return (RuntimeException)DefaultGroovyMethods.newInstance(VALIDATION_EXCEPTION_TYPE, (Object[])new Object[]{message, errors});
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (ClassUtils.isPresent((String)"grails.validation.ValidationException", (ClassLoader)cl)) {
            Class<ValidationException> validationExceptionType;
            try {
                validationExceptionType = ClassUtils.forName((String)"grails.validation.ValidationException", (ClassLoader)cl);
            }
            catch (Throwable e) {
                validationExceptionType = ValidationException.class;
            }
            VALIDATION_EXCEPTION_TYPE = validationExceptionType;
        } else {
            VALIDATION_EXCEPTION_TYPE = ValidationException.class;
        }
    }
}

