/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs3.engine.CacheStatus;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.Stats;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class LateralCacheNoWaitFacade<K, V>
extends AbstractAuxiliaryCache<K, V> {
    private static final Log log = LogManager.getLog(LateralCacheNoWaitFacade.class);
    public LateralCacheNoWait<K, V>[] noWaits;
    private final String cacheName;
    private ILateralCacheListener<K, V> listener;
    private final ILateralCacheAttributes lateralCacheAttributes;
    private boolean disposed = false;

    public LateralCacheNoWaitFacade(ILateralCacheListener<K, V> listener, LateralCacheNoWait<K, V>[] noWaits, ILateralCacheAttributes cattr) {
        log.debug("CONSTRUCTING NO WAIT FACADE");
        this.listener = listener;
        this.noWaits = noWaits;
        this.cacheName = cattr.getCacheName();
        this.lateralCacheAttributes = cattr;
    }

    public boolean containsNoWait(LateralCacheNoWait<K, V> noWait) {
        Optional<LateralCacheNoWait> optional = Arrays.stream(this.noWaits).filter(nw -> noWait.equals(nw)).findFirst();
        return optional.isPresent();
    }

    public synchronized boolean addNoWait(LateralCacheNoWait<K, V> noWait) {
        if (noWait == null) {
            return false;
        }
        if (this.containsNoWait(noWait)) {
            log.debug("No Wait already contained, [{0}]", noWait);
            return false;
        }
        LateralCacheNoWait[] newArray = new LateralCacheNoWait[this.noWaits.length + 1];
        System.arraycopy(this.noWaits, 0, newArray, 0, this.noWaits.length);
        newArray[this.noWaits.length] = noWait;
        this.noWaits = newArray;
        return true;
    }

    public synchronized boolean removeNoWait(LateralCacheNoWait<K, V> noWait) {
        if (noWait == null) {
            return false;
        }
        int position = -1;
        for (int i = 0; i < this.noWaits.length; ++i) {
            if (!noWait.equals(this.noWaits[i])) continue;
            position = i;
            break;
        }
        if (position == -1) {
            return false;
        }
        LateralCacheNoWait[] newArray = new LateralCacheNoWait[this.noWaits.length - 1];
        System.arraycopy(this.noWaits, 0, newArray, 0, position);
        if (this.noWaits.length != position) {
            System.arraycopy(this.noWaits, position + 1, newArray, position, this.noWaits.length - position - 1);
        }
        this.noWaits = newArray;
        return true;
    }

    @Override
    public void update(ICacheElement<K, V> ce) throws IOException {
        log.debug("updating through lateral cache facade, noWaits.length = {0}", this.noWaits.length);
        for (LateralCacheNoWait<K, V> nw : this.noWaits) {
            nw.update(ce);
        }
    }

    @Override
    public ICacheElement<K, V> get(K key) {
        Optional<ICacheElement> optional = Arrays.stream(this.noWaits).map(nw -> nw.get(key)).filter(obj -> obj != null).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> keys) {
        if (keys != null && !keys.isEmpty()) {
            Map<Object, ICacheElement> elements = keys.stream().collect(Collectors.toMap(key -> key, key -> this.get(key))).entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(entry -> entry.getKey(), entry -> (ICacheElement)entry.getValue()));
            return elements;
        }
        return new HashMap();
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String pattern) {
        HashMap<K, ICacheElement<K, V>> elements = new HashMap<K, ICacheElement<K, V>>();
        for (LateralCacheNoWait<K, V> nw : this.noWaits) {
            elements.putAll(nw.getMatching(pattern));
        }
        return elements;
    }

    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> allKeys = new HashSet<K>();
        for (LateralCacheNoWait<K, V> nw : this.noWaits) {
            Set<K> keys;
            if (nw == null || (keys = nw.getKeySet()) == null) continue;
            allKeys.addAll(keys);
        }
        return allKeys;
    }

    @Override
    public boolean remove(K key) {
        Arrays.stream(this.noWaits).forEach(nw -> nw.remove(key));
        return false;
    }

    @Override
    public void removeAll() {
        Arrays.stream(this.noWaits).forEach(nw -> nw.removeAll());
    }

    @Override
    public void dispose() {
        try {
            if (this.listener != null) {
                this.listener.dispose();
                this.listener = null;
            }
            Arrays.stream(this.noWaits).forEach(nw -> nw.dispose());
        }
        finally {
            this.disposed = true;
        }
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.LATERAL_CACHE;
    }

    @Override
    public String getCacheName() {
        return "";
    }

    @Override
    public CacheStatus getStatus() {
        if (this.disposed) {
            return CacheStatus.DISPOSED;
        }
        if (this.noWaits.length == 0 || this.listener != null) {
            return CacheStatus.ALIVE;
        }
        List statii = Arrays.stream(this.noWaits).map(nw -> nw.getStatus()).collect(Collectors.toList());
        if (statii.contains((Object)CacheStatus.ALIVE)) {
            return CacheStatus.ALIVE;
        }
        if (statii.contains((Object)CacheStatus.ERROR)) {
            return CacheStatus.ERROR;
        }
        return CacheStatus.DISPOSED;
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.lateralCacheAttributes;
    }

    public String toString() {
        return "LateralCacheNoWaitFacade: " + this.cacheName;
    }

    @Override
    public String getEventLoggingExtraInfo() {
        return "Lateral Cache No Wait";
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait Facade");
        ArrayList elems = new ArrayList();
        if (this.noWaits != null) {
            elems.add(new StatElement<Integer>("Number of No Waits", this.noWaits.length));
            for (LateralCacheNoWait<K, V> lcnw : this.noWaits) {
                if (lcnw == null) continue;
                IStats sStats = lcnw.getStatistics();
                elems.addAll(sStats.getStatElements());
            }
        }
        stats.setStatElements(elems);
        return stats;
    }
}

