/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"arrayElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "createArrayOf", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "nullable", "", "resolve"})
public final class ArrayUtilsKt {
    @NotNull
    public static final ConeKotlinType createArrayOf(@NotNull ConeTypeProjection $this$createArrayOf, boolean nullable) {
        ConeKotlinType type2;
        Intrinsics.checkNotNullParameter($this$createArrayOf, "$this$createArrayOf");
        if ($this$createArrayOf instanceof ConeKotlinTypeProjection && (type2 = ConeTypesKt.lowerBoundIfFlexible(((ConeKotlinTypeProjection)$this$createArrayOf).getType())) instanceof ConeClassLikeType && type2.getNullability() != ConeNullability.NULLABLE) {
            ClassId primitiveArrayId;
            ClassId classId = ((ConeClassLikeType)type2).getLookupTag().getClassId();
            ClassId classId2 = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().get(classId);
            if (classId2 == null) {
                classId2 = primitiveArrayId = StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().get(classId);
            }
            if (primitiveArrayId != null) {
                return TypeConstructionUtilsKt.constructClassLikeType(primitiveArrayId, new ConeTypeProjection[0], nullable);
            }
        }
        return TypeConstructionUtilsKt.constructClassLikeType(StandardClassIds.INSTANCE.getArray(), new ConeTypeProjection[]{$this$createArrayOf}, nullable);
    }

    public static /* synthetic */ ConeKotlinType createArrayOf$default(ConeTypeProjection coneTypeProjection, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ArrayUtilsKt.createArrayOf(coneTypeProjection, bl);
    }

    @Nullable
    public static final ConeKotlinType arrayElementType(@NotNull ConeKotlinType $this$arrayElementType) {
        ClassId elementType;
        Intrinsics.checkNotNullParameter($this$arrayElementType, "$this$arrayElementType");
        ConeKotlinType type2 = ConeTypesKt.lowerBoundIfFlexible($this$arrayElementType);
        if (!(type2 instanceof ConeClassLikeType)) {
            return null;
        }
        ClassId classId = ((ConeClassLikeType)type2).getLookupTag().getClassId();
        if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getArray())) {
            ConeTypeProjection coneTypeProjection = ArraysKt.first(type2.getTypeArguments());
            if (coneTypeProjection == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection");
            }
            return ((ConeKotlinTypeProjection)coneTypeProjection).getType();
        }
        ClassId classId2 = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().get(classId);
        if (classId2 == null) {
            classId2 = elementType = StandardClassIds.INSTANCE.getElementTypeByUnsignedArrayType().get(classId);
        }
        if (elementType != null) {
            return TypeConstructionUtilsKt.constructClassLikeType(elementType, new ConeTypeProjection[0], false);
        }
        return null;
    }
}

