/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.ExecutionResult;
import org.jetbrains.kotlin.ir.interpreter.Next;
import org.jetbrains.kotlin.ir.interpreter.ReturnLabel;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.stack.Stack;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J1\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0002\b\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValueOf;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "equalTo", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "evaluate", "Lorg/jetbrains/kotlin/ir/interpreter/ExecutionResult;", "stack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Stack;", "interpret", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lkotlin/ExtensionFunctionType;", "ir.interpreter"})
public final class EnumValueOf
extends IntrinsicBase {
    @NotNull
    public static final EnumValueOf INSTANCE;

    @Override
    public boolean equalTo(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
        String fqName2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(irFunction2));
        return (Intrinsics.areEqual(fqName2, "kotlin.enumValueOf") || StringsKt.endsWith$default(fqName2, ".valueOf", false, 2, null)) && irFunction2.getValueParameters().size() == 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult evaluate(@NotNull IrFunction irFunction2, @NotNull Stack stack, @NotNull Function1<? super IrElement, ? extends ExecutionResult> interpret2) {
        block15: {
            String enumEntryName;
            IrClass enumClass2;
            block14: {
                IrEnumEntry enumEntry;
                Object object;
                Object v2;
                block13: {
                    void $this$filterIsInstanceTo$iv$iv;
                    IrClass irClass2;
                    Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
                    Intrinsics.checkNotNullParameter(stack, "stack");
                    Intrinsics.checkNotNullParameter(interpret2, "interpret");
                    String string2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable(irFunction2));
                    switch (string2.hashCode()) {
                        case -395253382: {
                            if (string2.equals("kotlin.enumValueOf")) {
                                irClass2 = stack.getVariable((IrSymbol)CollectionsKt.first(irFunction2.getTypeParameters()).getSymbol()).getState().getIrClass();
                                break;
                            }
                        }
                        default: {
                            IrDeclarationParent irDeclarationParent = irFunction2.getParent();
                            if (irDeclarationParent == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                            }
                            irClass2 = (IrClass)irDeclarationParent;
                        }
                    }
                    enumClass2 = irClass2;
                    enumEntryName = StateKt.asString(stack.getVariable(CollectionsKt.first(irFunction2.getValueParameters()).getSymbol()).getState());
                    Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IrEnumEntry)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        IrEnumEntry it = (IrEnumEntry)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getName().asString(), enumEntryName)) continue;
                        if (found$iv) {
                            v2 = null;
                            break block13;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v2 = !found$iv ? null : single$iv;
                }
                if ((object = (enumEntry = (IrEnumEntry)v2)) == null || (object = interpret2.invoke((IrElement)object)) == null) break block14;
                Object $this$check$iv = object;
                ReturnLabel toCheckLabel$iv = ReturnLabel.REGULAR;
                boolean $i$f$check = false;
                if (((ExecutionResult)$this$check$iv).getReturnLabel() != toCheckLabel$iv) {
                    Object it = $this$check$iv;
                    boolean bl = false;
                    return it;
                }
                object = $this$check$iv;
                if (object != null) break block15;
            }
            throw (Throwable)new IllegalArgumentException("No enum constant " + IrUtilsKt.getFqNameWhenAvailable(enumClass2) + '.' + enumEntryName);
        }
        return Next.INSTANCE;
    }

    private EnumValueOf() {
        super(null);
    }

    static {
        EnumValueOf enumValueOf;
        INSTANCE = enumValueOf = new EnumValueOf();
    }
}

