/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.RangeType;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.ExplicitReceivers;
import org.jetbrains.kotlin.js.translate.callTranslator.RangeCheckTranslator$WhenMappings;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J(\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\r\u001a\u0004\u0018\u00010\u00062\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/js/translate/callTranslator/RangeCheckTranslator;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "translateAsIntRangeCheck", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "lower", "upper", "kind", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/RangeKind;", "subject", "translateAsLongRangeCheck", "translateAsRangeCheck", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "receivers", "Lorg/jetbrains/kotlin/js/translate/callTranslator/ExplicitReceivers;", "js.translator"})
public final class RangeCheckTranslator {
    private final TranslationContext context;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JsExpression translateAsRangeCheck(@NotNull ResolvedCall<? extends FunctionDescriptor> resolvedCall2, @NotNull ExplicitReceivers receivers) {
        JsExpression jsExpression;
        JsExpression lower2;
        List<JsExpression> list2;
        List<JsExpression> qualifier;
        List<JsExpression> list3;
        void rangeType;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(receivers, "receivers");
        FunctionDescriptor calledFunction = resolvedCall2.getResultingDescriptor();
        if (Intrinsics.areEqual(calledFunction.getName().asString(), "contains") ^ true || !(calledFunction.getContainingDeclaration() instanceof ClassDescriptor)) {
            return null;
        }
        JsExpression jsExpression2 = receivers.getExtensionOrDispatchReceiver();
        if (!(jsExpression2 instanceof JsExpression.JsExpressionHasArguments)) {
            jsExpression2 = null;
        }
        JsExpression.JsExpressionHasArguments jsExpressionHasArguments = (JsExpression.JsExpressionHasArguments)jsExpression2;
        if (jsExpressionHasArguments == null) {
            return null;
        }
        JsExpression.JsExpressionHasArguments invocation = jsExpressionHasArguments;
        Pair<RangeType, RangeKind> pair = MetadataProperties.getRange(invocation);
        if (pair == null) {
            return null;
        }
        Object object = pair;
        RangeType rangeType2 = ((Pair)object).component1();
        RangeKind rangeKind = ((Pair)object).component2();
        if (rangeKind == RangeKind.UNTIL || rangeType == RangeType.INT) {
            if (invocation.getArguments().size() != 2) {
                return null;
            }
            list3 = invocation.getArguments();
        } else {
            if (!(invocation instanceof JsInvocation)) {
                return null;
            }
            JsExpression jsExpression3 = ((JsInvocation)invocation).getQualifier();
            if (!(jsExpression3 instanceof JsNameRef)) {
                jsExpression3 = null;
            }
            JsNameRef jsNameRef = (JsNameRef)jsExpression3;
            if (jsNameRef == null) {
                return null;
            }
            qualifier = jsNameRef;
            JsExpression jsExpression4 = ((JsNameRef)((Object)qualifier)).getQualifier();
            if (jsExpression4 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue(jsExpression4, "qualifier.qualifier ?: return null");
            JsExpression receiver = jsExpression4;
            if (((JsInvocation)invocation).getArguments().size() != 1) {
                return null;
            }
            JsExpression[] jsExpressionArray = new JsExpression[2];
            jsExpressionArray[0] = receiver;
            List<JsExpression> list4 = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkNotNullExpressionValue(list4, "invocation.arguments");
            jsExpressionArray[1] = CollectionsKt.single(list4);
            list3 = CollectionsKt.listOf(jsExpressionArray);
        }
        qualifier = list2 = list3;
        boolean bl = false;
        object = qualifier.get(0);
        qualifier = list2;
        bl = false;
        JsExpression upper = qualifier.get(1);
        lower2 = this.context.cacheExpressionIfNeeded(lower2);
        upper = this.context.cacheExpressionIfNeeded(upper);
        Object object2 = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)resolvedCall2.getValueArguments().values());
        if (object2 == null || (object2 = object2.getArguments()) == null || (object2 = (ValueArgument)CollectionsKt.singleOrNull(object2)) == null || (object2 = object2.getArgumentExpression()) == null) {
            return null;
        }
        Object subjectPsi = object2;
        JsExpression jsExpression5 = this.context.cacheExpressionIfNeeded(Translation.translateAsExpression((KtExpression)subjectPsi, this.context));
        Intrinsics.checkNotNullExpressionValue(jsExpression5, "context.cacheExpressionI\u2026ion(subjectPsi, context))");
        JsExpression subject = jsExpression5;
        switch (RangeCheckTranslator$WhenMappings.$EnumSwitchMapping$0[rangeType.ordinal()]) {
            case 1: {
                jsExpression = this.translateAsIntRangeCheck(lower2, upper, rangeKind, subject);
                break;
            }
            case 2: {
                jsExpression = this.translateAsLongRangeCheck(lower2, upper, rangeKind, subject);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jsExpression;
    }

    private final JsExpression translateAsIntRangeCheck(JsExpression lower2, JsExpression upper, RangeKind kind, JsExpression subject) {
        JsBinaryOperation jsBinaryOperation;
        JsBinaryOperation jsBinaryOperation2 = JsAstUtils.lessThanEq(lower2, subject);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation2, "JsAstUtils.lessThanEq(lower, subject)");
        JsBinaryOperation lowerCheck = jsBinaryOperation2;
        switch (RangeCheckTranslator$WhenMappings.$EnumSwitchMapping$1[kind.ordinal()]) {
            case 1: {
                jsBinaryOperation = JsAstUtils.lessThanEq(subject, upper);
                break;
            }
            case 2: {
                jsBinaryOperation = JsAstUtils.lessThan(subject, upper);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "when (kind) {\n          \u2026subject, upper)\n        }");
        JsBinaryOperation upperCheck = jsBinaryOperation;
        MetadataProperties.setSynthetic(lowerCheck, true);
        MetadataProperties.setSynthetic(upperCheck, true);
        JsBinaryOperation jsBinaryOperation3 = JsAstUtils.and(lowerCheck, upperCheck);
        boolean bl = false;
        boolean bl2 = false;
        JsBinaryOperation $this$apply = jsBinaryOperation3;
        boolean bl3 = false;
        MetadataProperties.setSynthetic($this$apply, true);
        JsBinaryOperation jsBinaryOperation4 = jsBinaryOperation3;
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation4, "JsAstUtils.and(lowerChec\u2026pply { synthetic = true }");
        return jsBinaryOperation4;
    }

    private final JsExpression translateAsLongRangeCheck(JsExpression lower2, JsExpression upper, RangeKind kind, JsExpression subject) {
        JsInvocation jsInvocation;
        JsInvocation jsInvocation2 = JsAstUtils.invokeMethod(lower2, "lessThanOrEqual", subject);
        boolean bl = false;
        boolean bl2 = false;
        JsInvocation $this$apply = jsInvocation2;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$apply, SideEffectKind.PURE);
        JsInvocation jsInvocation3 = jsInvocation2;
        Intrinsics.checkNotNullExpressionValue(jsInvocation3, "JsAstUtils.invokeMethod(\u2026s = SideEffectKind.PURE }");
        JsInvocation lowerCheck = jsInvocation3;
        switch (RangeCheckTranslator$WhenMappings.$EnumSwitchMapping$2[kind.ordinal()]) {
            case 1: {
                jsInvocation = JsAstUtils.invokeMethod(subject, "lessThanOrEqual", upper);
                break;
            }
            case 2: {
                jsInvocation = JsAstUtils.invokeMethod(subject, "lessThan", upper);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue(jsInvocation, "when (kind) {\n          \u2026ssThan\", upper)\n        }");
        JsInvocation upperCheck = jsInvocation;
        MetadataProperties.setSideEffects(upperCheck, SideEffectKind.PURE);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.and(lowerCheck, upperCheck);
        Intrinsics.checkNotNullExpressionValue(jsBinaryOperation, "JsAstUtils.and(lowerCheck, upperCheck)");
        return jsBinaryOperation;
    }

    public RangeCheckTranslator(@NotNull TranslationContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }
}

