/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.repository;

import java.io.File;
import java.net.MalformedURLException;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.file.FileResource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.url.URLResource;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;

public final class ResourceHelper {
    public static boolean equals(Resource res2, File f) {
        if (res2 == null && f == null) {
            return true;
        }
        if (res2 == null || f == null) {
            return false;
        }
        if (res2 instanceof FileResource) {
            return new File(res2.getName()).equals(f);
        }
        if (res2 instanceof URLResource) {
            try {
                return f.toURI().toURL().toExternalForm().equals(res2.getName());
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    public static long getLastModifiedOrDefault(Resource res2) {
        long last = res2.getLastModified();
        if (last > 0L) {
            return last;
        }
        Message.debug("impossible to get date for " + res2 + ": using 'now'");
        return System.currentTimeMillis();
    }
}

