/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableColumnModel;
import mediathek.config.MVConfig;
import mediathek.tool.models.TModel;
import mediathek.tool.table.WidthAdjuster;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MVTable
extends JTable {
    private static final String FELDTRENNER = "|";
    private static final String SORT_ASCENDING = "ASCENDING";
    private static final String SORT_DESCENDING = "DESCENDING";
    private static final Logger logger = LogManager.getLogger();
    protected final int[] breite;
    protected final int[] reihe;
    public boolean useSmallSenderIcons;
    protected int maxSpalten;
    protected int indexSpalte;
    protected int[] selRows;
    protected int[] selIndexes;
    protected int selRow = -1;
    protected boolean[] spaltenAnzeigen;
    protected MVConfig.Configs nrDatenSystem;
    protected MVConfig.Configs iconAnzeigenStr;
    protected MVConfig.Configs iconKleinStr;
    protected List<? extends RowSorter.SortKey> listeSortKeys;
    private Font defaultFont = UIManager.getDefaults().getFont("Table.font");
    private boolean showSenderIcon;
    private boolean lineBreak = true;

    public MVTable() {
        this.setAutoCreateRowSorter(true);
        this.setAutoResizeMode(0);
        this.setupTableType();
        this.getTableHeader().addMouseListener(new WidthAdjuster(this));
        this.breite = new int[this.maxSpalten];
        Arrays.fill(this.breite, -1);
        this.reihe = new int[this.maxSpalten];
        Arrays.fill(this.reihe, -1);
        if (this.iconAnzeigenStr != null) {
            this.showSenderIcon = Boolean.parseBoolean(MVConfig.get(this.iconAnzeigenStr));
        }
        if (this.iconKleinStr != null) {
            this.useSmallSenderIcons = Boolean.parseBoolean(MVConfig.get(this.iconKleinStr));
        }
        this.loadDefaultFontSize();
        this.setHeight();
    }

    protected void loadDefaultFontSize() {
    }

    protected void saveDefaultFontSize() {
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font newFont) {
        this.defaultFont = newFont;
        this.saveDefaultFontSize();
    }

    private RowSorter.SortKey sortKeyLesen(String s2, String strSortOrder) {
        RowSorter.SortKey sk;
        try {
            int column = Integer.parseInt(s2);
            SortOrder order = switch (strSortOrder) {
                case SORT_ASCENDING -> SortOrder.ASCENDING;
                case SORT_DESCENDING -> SortOrder.DESCENDING;
                default -> throw new IndexOutOfBoundsException("UNDEFINED SORT KEY");
            };
            sk = new RowSorter.SortKey(column, order);
        }
        catch (Exception ex) {
            return null;
        }
        return sk;
    }

    public boolean showSenderIcons() {
        return this.showSenderIcon;
    }

    public void setShowIcon(boolean newVal) {
        this.showSenderIcon = newVal;
    }

    protected abstract void setupTableType();

    public boolean isLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(boolean lb) {
        this.lineBreak = lb;
    }

    public void invertSelection() {
        ListSelectionModel mdl = this.getSelectionModel();
        int[] selected = this.getSelectedRows();
        mdl.setValueIsAdjusting(true);
        mdl.setSelectionInterval(0, this.getRowCount() - 1);
        for (int i : selected) {
            mdl.removeSelectionInterval(i, i);
        }
        mdl.setValueIsAdjusting(false);
    }

    private int getSizeArea() {
        FontMetrics fm = this.getFontMetrics(this.getDefaultFont());
        int height = fm.getHeight();
        int sizeArea = this.lineBreak ? 4 * height : height;
        return sizeArea;
    }

    public void setHeight() {
        int sizeArea = this.getSizeArea();
        FontMetrics fm = this.getFontMetrics(this.getDefaultFont());
        int size = fm.getHeight() + 5;
        if (this.showSenderIcon) {
            if (this.useSmallSenderIcons) {
                if (size < 18) {
                    size = 20;
                }
            } else if (size < 30) {
                size = 36;
            }
        }
        this.setRowHeight(Math.max(size, sizeArea));
    }

    public void initTabelle() {
        try {
            if (this.nrDatenSystem == null) {
                return;
            }
            String b = "";
            String r = "";
            String s2 = "";
            String upDown = "";
            boolean ok = false;
            if (!MVConfig.get(this.nrDatenSystem).isEmpty()) {
                RowSorter.SortKey sk;
                ok = true;
                String strNrDatenSystem = MVConfig.get(this.nrDatenSystem);
                int f1 = strNrDatenSystem.indexOf(FELDTRENNER);
                if (f1 != -1) {
                    int f3;
                    b = strNrDatenSystem.substring(0, f1);
                    int f2 = strNrDatenSystem.indexOf(FELDTRENNER, f1 + 1);
                    if (f2 != -1) {
                        r = strNrDatenSystem.substring(f1 + 1, f2);
                    }
                    if ((f3 = strNrDatenSystem.indexOf(FELDTRENNER, f2 + 1)) != -1) {
                        s2 = strNrDatenSystem.substring(f2 + 1, f3);
                        upDown = strNrDatenSystem.substring(f3 + 1);
                    }
                }
                if (!this.arrLesen(b, this.breite)) {
                    ok = false;
                }
                if (!this.arrLesen(r, this.reihe)) {
                    ok = false;
                }
                if ((sk = this.sortKeyLesen(s2, upDown)) != null) {
                    ArrayList<RowSorter.SortKey> listSortKeys_ = new ArrayList<RowSorter.SortKey>();
                    listSortKeys_.add(sk);
                    this.getRowSorter().setSortKeys(listSortKeys_);
                }
            }
            if (ok) {
                this.setSpaltenEinAus(this.breite, this.spaltenAnzeigen);
                this.setSpalten();
                this.setHeight();
            } else {
                this.resetTabelle();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean anzeigen(int i, boolean[] spaltenAnzeigen) {
        return spaltenAnzeigen[i];
    }

    protected void setSpaltenEinAus(int[] nr, boolean[] spaltenAnzeigen) {
        for (int i = 0; i < spaltenAnzeigen.length; ++i) {
            spaltenAnzeigen[i] = nr[i] > 0;
        }
    }

    boolean[] getSpaltenEinAus(boolean[] spaltenAnzeigen, int MAX_ELEM) {
        for (int i = 0; i < MAX_ELEM; ++i) {
            spaltenAnzeigen[i] = true;
        }
        return spaltenAnzeigen;
    }

    public void fireTableDataChanged(boolean setSpalten) {
        if (setSpalten) {
            this.getSelected();
        }
        ((TModel)this.getModel()).fireTableDataChanged();
        if (setSpalten) {
            this.setSelected();
        }
    }

    public void scrollToSelection() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            int i = this.getSelectedRow();
            if (i < 0) {
                i = 0;
                this.setRowSelectionInterval(i, i);
            }
            if (i >= rowCount) {
                i = rowCount - 1;
            }
            this.scrollToSelection(i);
        }
    }

    private void scrollToSelection(int rowIndex) {
        Container container = this.getParent();
        if (!(container instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)container;
        Rectangle rect = this.getCellRect(rowIndex, 0, true);
        Rectangle viewRect = viewport.getViewRect();
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    public void getSelected() {
        this.selRow = this.getSelectedRow();
        this.selRows = this.getSelectedRows();
    }

    protected void setSelected() {
        if (this.selRows != null && this.selRows.length > 0) {
            this.selectionModel.setValueIsAdjusting(true);
            for (int selectedRow : this.selRows) {
                if (selectedRow >= this.getRowCount()) continue;
                this.addRowSelectionInterval(selectedRow, selectedRow);
            }
            this.selectionModel.setValueIsAdjusting(false);
        }
    }

    protected void changeColumnWidth2() {
        TableColumnModel model = this.getColumnModel();
        for (int i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
            int colIndex = this.convertColumnIndexToView(i);
            if (this.breite[i] == 0) {
                model.getColumn(colIndex).setMinWidth(0);
                model.getColumn(colIndex).setPreferredWidth(0);
                model.getColumn(colIndex).setMaxWidth(0);
                continue;
            }
            model.getColumn(colIndex).setMinWidth(10);
            model.getColumn(colIndex).setMaxWidth(3000);
            model.getColumn(colIndex).setPreferredWidth(this.breite[i]);
        }
    }

    protected void changeColumnWidth() {
        for (int i = 0; i < this.breite.length && i < this.getColumnCount(); ++i) {
            if (!this.anzeigen(i, this.spaltenAnzeigen)) {
                this.breite[i] = 0;
                continue;
            }
            if (this.breite[i] != 0) continue;
            this.breite[i] = 100;
        }
    }

    public void spaltenEinAus() {
        this.getSpalten();
        this.changeColumnWidth();
        this.changeColumnWidth2();
        this.validate();
    }

    public void getSpalten() {
        int i;
        this.getSelected();
        for (i = 0; i < this.reihe.length && i < this.getModel().getColumnCount(); ++i) {
            this.reihe[i] = this.convertColumnIndexToModel(i);
        }
        for (i = 0; i < this.breite.length && i < this.getModel().getColumnCount(); ++i) {
            this.breite[i] = this.getColumnModel().getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        this.listeSortKeys = this.getRowSorter() != null ? this.getRowSorter().getSortKeys() : null;
    }

    public void setSpalten() {
        try {
            this.changeColumnWidth();
            TableColumnModel model = this.getColumnModel();
            this.changeColumnWidth2();
            for (int i = 0; i < this.reihe.length && i < this.getColumnCount(); ++i) {
                model.moveColumn(this.convertColumnIndexToView(this.reihe[i]), i);
            }
            if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
                this.getRowSorter().setSortKeys(this.listeSortKeys);
            }
            this.setSelected();
            this.validate();
        }
        catch (Exception ex) {
            logger.error("setSpalten", (Throwable)ex);
        }
    }

    public void resetTabelle() {
        this.listeSortKeys = null;
        this.getRowSorter().setSortKeys(null);
        this.setRowSorter(null);
        this.setAutoCreateRowSorter(true);
        this.spaltenAusschalten();
        this.setSpaltenEinAus(this.breite, this.spaltenAnzeigen);
        this.setSpalten();
        this.setHeight();
    }

    protected abstract void spaltenAusschalten();

    public void tabelleNachDatenSchreiben() {
        int i;
        String s2 = "";
        String upDown = "";
        int[] reihe_ = new int[this.maxSpalten];
        int[] breite_ = new int[this.maxSpalten];
        for (int i2 = 0; i2 < reihe_.length && i2 < this.getModel().getColumnCount(); ++i2) {
            reihe_[i2] = this.convertColumnIndexToModel(i2);
        }
        TableColumnModel model = this.getColumnModel();
        for (i = 0; i < breite_.length && i < this.getModel().getColumnCount(); ++i) {
            breite_[i] = model.getColumn(this.convertColumnIndexToView(i)).getWidth();
        }
        Object b = Integer.toString(breite_[0]);
        Object r = Integer.toString(reihe_[0]);
        for (i = 1; i < this.breite.length; ++i) {
            b = (String)b + "," + breite_[i];
            r = (String)r + "," + reihe_[i];
        }
        this.listeSortKeys = this.getRowSorter().getSortKeys();
        if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
            RowSorter.SortKey sk = this.listeSortKeys.get(0);
            s2 = String.valueOf(sk.getColumn());
            upDown = sk.getSortOrder() == SortOrder.ASCENDING ? SORT_ASCENDING : SORT_DESCENDING;
        }
        MVConfig.add(this.nrDatenSystem, (String)b + FELDTRENNER + (String)r + FELDTRENNER + s2 + FELDTRENNER + upDown);
        if (this.iconAnzeigenStr != null) {
            MVConfig.add(this.iconAnzeigenStr, String.valueOf(this.showSenderIcon));
        }
        if (this.iconKleinStr != null) {
            MVConfig.add(this.iconKleinStr, String.valueOf(this.useSmallSenderIcons));
        }
    }

    private boolean arrLesen(String s2, int[] arr) {
        if (this.maxSpalten != this.countString(s2)) {
            return false;
        }
        for (int i = 0; i < this.maxSpalten; ++i) {
            String sub;
            if (s2.isEmpty()) continue;
            if (s2.contains(",")) {
                sub = s2.substring(0, s2.indexOf(44));
                s2 = s2.replaceFirst(sub + ",", "");
            } else {
                sub = s2;
                s2 = "";
            }
            try {
                arr[i] = Integer.parseInt(sub);
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    private int countString(String s2) {
        int ret = 0;
        for (int i = 0; i < s2.length(); ++i) {
            if (s2.charAt(i) != ',') continue;
            ++ret;
        }
        return ++ret;
    }
}

