/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.dedication.Dedication;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemDedication
extends AbstractPSystem {
    private final Dedication dedication;
    private final String keepLetter;

    public PSystemDedication(Dedication dedication, String keepLetter) {
        this.dedication = dedication;
        this.keepLetter = keepLetter;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        HColor backcolor = HColorUtils.WHITE;
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, this.getMetadata(), null, ClockwiseTopRightBottomLeft.none(), backcolor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                BufferedImage bufferedImage = PSystemDedication.this.dedication.getBufferedImage(PSystemDedication.this.keepLetter);
                if (bufferedImage != null) {
                    ug.draw(new UImage(new PixelImage(bufferedImage, AffineTransformType.TYPE_BILINEAR)));
                }
            }
        });
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Dedication)");
    }
}

