/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.search;

import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.semanticweb.owlapi.model.OWLObject;

public class SearchMetadata
implements Comparable<SearchMetadata> {
    private SearchCategory category;
    private String groupDescription;
    private OWLObject subject;
    private String subjectRendering;
    private String searchString;

    public SearchMetadata(SearchCategory category, String groupDescription, OWLObject subject, String subjectRendering, String searchString) {
        this.category = category;
        this.groupDescription = groupDescription;
        this.subject = subject;
        this.subjectRendering = subjectRendering;
        this.searchString = searchString;
    }

    public SearchCategory getCategory() {
        return this.category;
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public OWLObject getSubject() {
        return this.subject;
    }

    public String getSubjectRendering() {
        return this.subjectRendering;
    }

    public boolean isSearchStringEntityRendering() {
        return this.category == SearchCategory.DISPLAY_NAME;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public StyledString getStyledSearchSearchString() {
        return new StyledString(this.searchString);
    }

    @Override
    public int compareTo(SearchMetadata o) {
        int catDiff = this.category.compareTo(o.category);
        if (catDiff != 0) {
            return catDiff;
        }
        int typeDiff = this.groupDescription.compareTo(o.groupDescription);
        if (typeDiff != 0) {
            return typeDiff;
        }
        int subjectRenderingDiff = this.subjectRendering.compareTo(o.subjectRendering);
        if (subjectRenderingDiff != 0) {
            return subjectRenderingDiff;
        }
        int subjectDiff = this.subject.compareTo((Object)o.subject);
        if (subjectDiff != 0) {
            return subjectDiff;
        }
        return this.searchString.compareTo(o.searchString);
    }
}

