/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.Builder;

public class BuilderImportsDeclaration
implements Builder<OWLImportsDeclaration> {
    @Nonnull
    protected final OWLDataFactory df;
    private IRI iri;

    public BuilderImportsDeclaration(@Nonnull OWLImportsDeclaration expected, OWLDataFactory df) {
        this(df);
        this.withImportedOntology(expected.getIRI());
    }

    @Inject
    public BuilderImportsDeclaration(OWLDataFactory df) {
        this.df = OWLAPIPreconditions.checkNotNull(df);
    }

    @Nonnull
    public BuilderImportsDeclaration withImportedOntology(IRI arg) {
        this.iri = arg;
        return this;
    }

    @Override
    public OWLImportsDeclaration buildObject() {
        return this.df.getOWLImportsDeclaration(this.getIRI());
    }

    @Nonnull
    public IRI getIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.iri);
    }

    @Override
    public List<OWLOntologyChange> applyChanges(OWLOntology o) {
        ArrayList<OWLOntologyChange> list = new ArrayList<OWLOntologyChange>();
        list.add(new AddImport(o, this.buildObject()));
        return list;
    }
}

