/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.CompilationException;
import com.eteks.parser.DefaultSyntax;
import com.eteks.parser.DoubleInterpreter;
import com.eteks.parser.Interpreter;
import com.eteks.parser.Parser;
import com.eteks.parser.Syntax;
import java.util.Stack;
import java.util.StringTokenizer;

public class CalculatorParser
extends Parser {
    private static Syntax defaultSyntax;
    private static Interpreter defaultInterpreter;
    private Syntax syntax;
    protected static final int LEXICAL_VOID = 0;
    protected static final int LEXICAL_WHITE_SPACE = 1;
    protected static final int LEXICAL_LITERAL = 2;
    protected static final int LEXICAL_UNARY_OPERATOR = 3;
    protected static final int LEXICAL_BINARY_OPERATOR = 4;
    protected static final int LEXICAL_COMMON_FUNCTION = 5;
    protected static final int LEXICAL_OPENING_BRACKET = 6;
    protected static final int LEXICAL_CLOSING_BRACKET = 7;
    protected static final int LEXICAL_SYNONYMOUS_OPERATOR = 8;
    private static final byte N_START = 0;
    private static final byte N_CL_BR = 1;
    private static final byte N_C_FCT = 2;
    private static final byte N_END = 3;
    private static final byte ADD_BINARY_OP = 1;
    private static final byte ADD_LITERAL = 2;
    private static final byte ADD_COMMON_FCT = 3;
    private static final byte ADD_OPEN_BRACKET = 4;
    private static final byte CHECK_CLOSE_BRACKET = 5;
    private static final byte ADD_UNARY_OP = 6;
    private static final byte CHECK_END = 7;
    private static final byte[][] shortSyntaxGraph;
    private static final byte[][] syntaxGraph;
    private static final byte[][] transitionGraph;
    private static final int PRIORITY_OPENING_BRACKET = -1;
    private static final int PRIORITY_COMMON_FUNCTION = 0x7FFFFFFD;
    private static final int PRIORITY_CLOSING_BRACKET = 0x7FFFFFFE;
    private static final int PRIORITY_OPERAND = Integer.MAX_VALUE;

    public CalculatorParser() {
        if (defaultSyntax == null) {
            defaultSyntax = new DefaultSyntax();
        }
        this.syntax = defaultSyntax;
    }

    public CalculatorParser(Syntax syntax) {
        this.syntax = syntax;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public double computeExpression(String string) throws CompilationException {
        if (defaultInterpreter == null) {
            defaultInterpreter = new DoubleInterpreter();
        }
        Object object = this.computeExpression(string, defaultInterpreter);
        return (Double)object;
    }

    public Object computeExpression(String string, Interpreter interpreter) throws CompilationException {
        ElemCal elemCal = (ElemCal)this.parseExpression(string, 0, new StackCal(interpreter), null);
        return elemCal.operatorKeyOrOperand;
    }

    protected Parser.Lexical getLexical(String string, int n, Object object) throws CompilationException {
        Object object2;
        Object object3;
        if (n >= string.length()) {
            return new Parser.Lexical(0, "", null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length() && this.syntax.getWhiteSpaceCharacters() != null && this.syntax.getWhiteSpaceCharacters().indexOf(string.charAt(n)) != -1) {
            stringBuffer.append(string.charAt(n++));
        }
        if (stringBuffer.length() > 0) {
            return new Parser.Lexical(1, stringBuffer.toString(), null);
        }
        char c = string.charAt(n);
        if (c == this.syntax.getOpeningBracket()) {
            return new Parser.Lexical(6, String.valueOf(c), null);
        }
        if (c == this.syntax.getClosingBracket()) {
            return new Parser.Lexical(7, String.valueOf(c), null);
        }
        String string2 = string.substring(n);
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, this.syntax.getDelimiters());
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 == null || !string2.startsWith(string3)) {
            string3 = null;
            for (int i = 0; i < string2.length(); ++i) {
                object3 = string2.substring(0, i + 1);
                if (this.syntax.getUnaryOperatorKey((String)object3) == null && this.syntax.getBinaryOperatorKey((String)object3) == null) continue;
                string3 = object3;
            }
            if (string3 == null) {
                throw new CompilationException(8, n);
            }
        }
        if ((object2 = this.syntax.getCommonFunctionKey(string3)) != null) {
            return new Parser.Lexical(5, string3, object2);
        }
        object2 = this.syntax.getUnaryOperatorKey(string3);
        if (object2 != null) {
            if (this.syntax.getBinaryOperatorKey(string3) != null) {
                return new Parser.Lexical(8, string3, null);
            }
            return new Parser.Lexical(3, string3, object2);
        }
        object2 = this.syntax.getBinaryOperatorKey(string3);
        if (object2 != null) {
            return new Parser.Lexical(4, string3, object2);
        }
        object3 = this.syntax.getLiteral(string2, stringBuffer);
        if (object3 != null) {
            return new Parser.Lexical(2, stringBuffer.toString(), object3);
        }
        throw new CompilationException(8, n, string3);
    }

    protected int getBoundNode(int n, Parser.Lexical lexical, int n2, Stack stack, Object object) throws CompilationException {
        int n3 = (this.syntax.isShortSyntax() ? shortSyntaxGraph : syntaxGraph)[lexical.getCode()][n];
        if (n3 == -1) {
            throw new CompilationException(8, n2);
        }
        this.executeTransition(transitionGraph[lexical.getCode()][n], n2, lexical, stack);
        return n3 == 3 ? Integer.MAX_VALUE : n3;
    }

    private void executeTransition(byte by, int n, Parser.Lexical lexical, Stack stack) throws CompilationException {
        switch (by) {
            case 1: {
                this.addBinaryOperator(lexical, stack);
                break;
            }
            case 2: {
                this.addLiteral(lexical, stack);
                break;
            }
            case 3: {
                this.addCommonFunction(lexical, stack);
                break;
            }
            case 4: {
                this.addOpeningBracket(stack);
                break;
            }
            case 5: {
                this.checkClosingBracket(n, stack);
                break;
            }
            case 6: {
                this.addUnaryOperator(lexical, stack);
                break;
            }
            case 7: {
                this.checkEnd(n, stack);
            }
        }
    }

    private void addBinaryOperator(Parser.Lexical lexical, Stack stack) {
        Object object = lexical.getValue() != null ? lexical.getValue() : this.syntax.getBinaryOperatorKey(lexical.getExtractedString());
        int n = this.syntax.getBinaryOperatorPriority(object);
        while (stack.size() > 1 && ((ElemCal)stack.elementAt((int)(stack.size() - 2))).priority >= n) {
            stack.pop();
        }
        ElemCal elemCal = (ElemCal)stack.peek();
        elemCal.priority = n;
        elemCal.operatorType = 4;
        elemCal.binaryOperatorFirstOperand = elemCal.operatorKeyOrOperand;
        elemCal.operatorKeyOrOperand = object;
    }

    private void addLiteral(Parser.Lexical lexical, Stack stack) {
        stack.push(new ElemCal(Integer.MAX_VALUE, 2, lexical.getValue()));
    }

    private void addCommonFunction(Parser.Lexical lexical, Stack stack) {
        stack.push(new ElemCal(0x7FFFFFFD, 5, lexical.getValue()));
    }

    private void addOpeningBracket(Stack stack) {
        stack.push(new ElemCal(-1, 0, null));
    }

    private void checkClosingBracket(int n, Stack stack) throws CompilationException {
        while (!stack.empty() && ((ElemCal)stack.peek()).priority != -1) {
            stack.pop();
        }
        if (stack.empty()) {
            throw new CompilationException(9, n);
        }
        ((ElemCal)stack.peek()).priority = 0x7FFFFFFE;
    }

    private void addUnaryOperator(Parser.Lexical lexical, Stack stack) {
        Object object = lexical.getValue() != null ? lexical.getValue() : this.syntax.getUnaryOperatorKey(lexical.getExtractedString());
        stack.push(new ElemCal(0x7FFFFFFD, 3, object));
    }

    private void checkEnd(int n, Stack stack) throws CompilationException {
        ElemCal elemCal = null;
        while (!stack.empty()) {
            elemCal = (ElemCal)stack.peek();
            if (elemCal.priority <= -1) break;
            stack.pop();
        }
        if (!stack.empty()) {
            throw new CompilationException(8, n);
        }
        stack.push(elemCal);
    }

    static {
        shortSyntaxGraph = new byte[][]{{-1, 3, -1}, {0, 1, 0}, {1, -1, -1}, {0, -1, 0}, {-1, 0, -1}, {2, -1, -1}, {0, -1, 0}, {-1, 1, -1}, {0, 0, 0}};
        syntaxGraph = new byte[][]{{-1, 3, -1}, {0, 1, 2}, {1, -1, -1}, {0, -1, -1}, {-1, 0, -1}, {2, -1, -1}, {0, -1, 0}, {-1, 1, -1}, {0, 0, -1}};
        transitionGraph = new byte[][]{{0, 7, 0}, {0, 0, 0}, {2, 0, 0}, {6, 0, 6}, {0, 1, 0}, {3, 0, 0}, {4, 0, 4}, {0, 5, 0}, {6, 1, 6}};
    }

    private static class StackCal
    extends Stack {
        private Interpreter interpreter;

        public StackCal(Interpreter interpreter) {
            this.interpreter = interpreter;
        }

        public Object pop() {
            ElemCal elemCal = (ElemCal)super.pop();
            if (!this.empty() && elemCal.operatorKeyOrOperand != null) {
                ElemCal elemCal2 = (ElemCal)this.peek();
                if (elemCal2.operatorKeyOrOperand == null) {
                    elemCal2.operatorKeyOrOperand = elemCal.operatorKeyOrOperand;
                } else {
                    switch (elemCal2.operatorType) {
                        case 3: {
                            elemCal2.operatorKeyOrOperand = this.interpreter.getUnaryOperatorValue(elemCal2.operatorKeyOrOperand, elemCal.operatorKeyOrOperand);
                            break;
                        }
                        case 4: {
                            elemCal2.operatorKeyOrOperand = this.interpreter.getBinaryOperatorValue(elemCal2.operatorKeyOrOperand, elemCal2.binaryOperatorFirstOperand, elemCal.operatorKeyOrOperand);
                            break;
                        }
                        case 5: {
                            elemCal2.operatorKeyOrOperand = this.interpreter.getCommonFunctionValue(elemCal2.operatorKeyOrOperand, elemCal.operatorKeyOrOperand);
                        }
                    }
                }
            }
            return elemCal;
        }

        public Object push(Object object) {
            ElemCal elemCal = (ElemCal)object;
            if (elemCal.operatorType == 2) {
                elemCal.operatorKeyOrOperand = this.interpreter.getLiteralValue(elemCal.operatorKeyOrOperand);
            }
            return super.push(object);
        }
    }

    private static class ElemCal {
        int priority;
        int operatorType;
        Object binaryOperatorFirstOperand;
        Object operatorKeyOrOperand;

        public ElemCal(int n, int n2, Object object) {
            this.priority = n;
            this.operatorType = n2;
            this.operatorKeyOrOperand = object;
        }
    }
}

