// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32L15xxE.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32l15xxe

// STM32L15xxE
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32L15xxE"
)

// Interrupt numbers.
const (
	IRQ_PVD           = 1  //
	IRQ_TAMPER_STAMP  = 2  // Flash
	IRQ_RTC_WKUP      = 3  // General-purpose timers
	IRQ_FLASH         = 4  // General-purpose I/Os
	IRQ_RCC           = 5  // Serial peripheral interface
	IRQ_EXTI0         = 6  // Flash
	IRQ_EXTI1         = 7  // Flash
	IRQ_EXTI2         = 8  // Flash
	IRQ_EXTI3         = 9  // Flash
	IRQ_EXTI4         = 10 // Flash
	IRQ_DMA1_Channel1 = 11 // Direct memory access controller //
	IRQ_DMA1_Channel2 = 12 // Direct memory access controller //
	IRQ_DMA1_Channel3 = 13 // Direct memory access controller //
	IRQ_DMA1_Channel4 = 14 // Direct memory access controller //
	IRQ_DMA1_Channel5 = 15 // Direct memory access controller //
	IRQ_DMA1_Channel6 = 16 // Direct memory access controller //
	IRQ_DMA1_Channel7 = 17 // Direct memory access controller //
	IRQ_DAC           = 21 // Digital-to-analog converter
	IRQ_COMP_CA       = 22 // Comparators
	IRQ_EXTI9_5       = 23 // Flash
	IRQ_LCD           = 24 // Routing interface
	IRQ_TIM9          = 25 // Window watchdog
	IRQ_TIM10         = 26 // Basic timers
	IRQ_TIM11         = 27 //
	IRQ_TIM2          = 28 // General-purpose timers
	IRQ_TIM3          = 29 //
	IRQ_TIM4          = 30 //
	IRQ_I2C1_EV       = 31 // Liquid crystal display controller
	IRQ_I2C1_ER       = 32 // Liquid crystal display controller
	IRQ_I2C2_EV       = 33 // Power control
	IRQ_I2C2_ER       = 34 // Power control
	IRQ_SPI1          = 35 //
	IRQ_SPI2          = 36 //
	IRQ_USART1        = 37 // Analog-to-digital converter
	IRQ_USART2        = 38 // Nested Vectored Interrupt Controller
	IRQ_USART3        = 39 // Debug support
	IRQ_EXTI15_10     = 40 // Flash
	IRQ_RTC_Alarm     = 41 // General-purpose timers
	IRQ_TIM6          = 43 // Universal serial bus full-speed device interface
	IRQ_TIM7          = 44 //
	IRQ_TIM5          = 45 // Universal synchronous asynchronous receiver transmitter
	IRQ_SPI3          = 46 // General-purpose timers //
	IRQ_DMA2_CH1      = 47 // External interrupt/event controller
	IRQ_DMA2_CH2      = 48 // External interrupt/event controller
	IRQ_DMA2_CH3      = 49 // External interrupt/event controller
	IRQ_DMA2_CH4      = 50 // External interrupt/event controller
	IRQ_DMA2_CH5      = 51 // External interrupt/event controller
	IRQ_COMP_ACQ      = 53 // Comparators
	IRQ_max           = 53 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_TAMPER_STAMP, "TAMPER_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel1, "DMA1_Channel1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel2, "DMA1_Channel2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel3, "DMA1_Channel3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel4, "DMA1_Channel4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel5, "DMA1_Channel5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel6, "DMA1_Channel6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_Channel7, "DMA1_Channel7_IRQHandler")
	_ = interrupt.Register(IRQ_DAC, "DAC_IRQHandler")
	_ = interrupt.Register(IRQ_COMP_CA, "COMP_CA_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_LCD, "LCD_IRQHandler")
	_ = interrupt.Register(IRQ_TIM9, "TIM9_IRQHandler")
	_ = interrupt.Register(IRQ_TIM10, "TIM10_IRQHandler")
	_ = interrupt.Register(IRQ_TIM11, "TIM11_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_Alarm, "RTC_Alarm_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6, "TIM6_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH1, "DMA2_CH1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH2, "DMA2_CH2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH3, "DMA2_CH3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH4, "DMA2_CH4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH5, "DMA2_CH5_IRQHandler")
	_ = interrupt.Register(IRQ_COMP_ACQ, "COMP_ACQ_IRQHandler")
)

// Peripherals.
var (
	ADC      = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))    // Analog-to-digital converter
	TIM6     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))    // Basic timers
	C_ADC    = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012700)))    // Common ADC registers
	COMP     = (*COMP_Type)(unsafe.Pointer(uintptr(0x40007c00)))   // Comparators
	CRC      = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))    // CRC calculation unit
	DBG      = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))    // Debug support
	DAC      = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))    // Digital-to-analog converter
	DMA1     = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))    // Direct memory access controller
	EXTI     = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))   // External interrupt/event controller
	Flash    = (*Flash_Type)(unsafe.Pointer(uintptr(0x40023c00)))  // Flash
	GPIOE    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))   // General-purpose I/Os
	GPIOA    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))   // General-purpose I/Os
	GPIOB    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))   // General-purpose I/Os
	TIM9     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010800)))    // General-purpose timers
	TIM10    = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010c00)))    // General-purpose timers
	TIM3     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))    // General-purpose timers
	IWDG     = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))   // Independent watchdog
	I2C1     = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))    // Inter-integrated circuit
	LCD      = (*LCD_Type)(unsafe.Pointer(uintptr(0x40002400)))    // Liquid crystal display controller
	NVIC     = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e000)))   // Nested Vectored Interrupt Controller
	PWR      = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))    // Power control
	RTC      = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))    // Real-time clock
	RCC      = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))    // Reset and clock control
	RI       = (*RI_Type)(unsafe.Pointer(uintptr(0x40007c04)))     // Routing interface
	SPI2     = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))    // Serial peripheral interface
	SYSCFG   = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000))) // System configuration controller
	USB      = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))    // Universal serial bus full-speed device interface
	USB_SRAM = (*USB_Type)(unsafe.Pointer(uintptr(0x40006000)))    // Universal serial bus full-speed device interface
	USART3   = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))  // Universal synchronous asynchronous receiver transmitter
	WWDG     = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))   // Window watchdog
	TIM7     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))    // Basic timers
	DMA2     = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))    // Direct memory access controller
	GPIOC    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))   // General-purpose I/Os
	GPIOD    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))   // General-purpose I/Os
	GPIOH    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))   // General-purpose I/Os
	GPIOF    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))   // General-purpose I/Os
	GPIOG    = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))   // General-purpose I/Os
	TIM11    = (*TIM_Type)(unsafe.Pointer(uintptr(0x40011000)))    // General-purpose timers
	TIM2     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))    // General-purpose timers
	TIM4     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))    // General-purpose timers
	TIM5     = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))    // General-purpose timers
	I2C2     = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))    // Inter-integrated circuit
	SPI1     = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))    // Serial peripheral interface
	SPI3     = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013c00)))    // Serial peripheral interface
	USART2   = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))  // Universal synchronous asynchronous receiver transmitter
	USART1   = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))  // Universal synchronous asynchronous receiver transmitter
)

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	SMPR3 volatile.Register32 // 0x14
	JOFR1 volatile.Register32 // 0x18
	JOFR2 volatile.Register32 // 0x1C
	JOFR3 volatile.Register32 // 0x20
	JOFR4 volatile.Register32 // 0x24
	HTR   volatile.Register32 // 0x28
	LTR   volatile.Register32 // 0x2C
	SQR1  volatile.Register32 // 0x30
	SQR2  volatile.Register32 // 0x34
	SQR3  volatile.Register32 // 0x38
	SQR4  volatile.Register32 // 0x3C
	SQR5  volatile.Register32 // 0x40
	JSQR  volatile.Register32 // 0x44
	JDR1  volatile.Register32 // 0x48
	JDR2  volatile.Register32 // 0x4C
	JDR3  volatile.Register32 // 0x50
	JDR4  volatile.Register32 // 0x54
	DR    volatile.Register32 // 0x58
	SMPR0 volatile.Register32 // 0x5C
}

// Basic timers
type TIM_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	_    [4]byte
	DIER volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	EGR  volatile.Register32 // 0x14
	_    [12]byte
	CNT  volatile.Register32 // 0x24
	PSC  volatile.Register32 // 0x28
	ARR  volatile.Register32 // 0x2C
}

// Comparators
type COMP_Type struct {
	CSR volatile.Register32 // 0x0
}

// CRC calculation unit
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// Debug support
type DBG_Type struct {
	DBGMCU_IDCODE  volatile.Register32 // 0x0
	DBGMCU_CR      volatile.Register32 // 0x4
	DBGMCU_APB1_FZ volatile.Register32 // 0x8
	DBGMCU_APB2_FZ volatile.Register32 // 0xC
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	PECR    volatile.Register32 // 0x4
	PDKEYR  volatile.Register32 // 0x8
	PEKEYR  volatile.Register32 // 0xC
	PRGKEYR volatile.Register32 // 0x10
	OPTKEYR volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	OBR     volatile.Register32 // 0x1C
	WRPR1   volatile.Register32 // 0x20
	_       [92]byte
	WRPR2   volatile.Register32 // 0x80
	WRPR3   volatile.Register32 // 0x84
}

// General-purpose I/Os
type GPIO_Type struct {
	_        [4294965248]byte
	MODER    volatile.Register32 // 0xFFFFF800
	OTYPER   volatile.Register32 // 0xFFFFF804
	OSPEEDER volatile.Register32 // 0xFFFFF808
	PUPDR    volatile.Register32 // 0xFFFFF80C
	IDR      volatile.Register32 // 0xFFFFF810
	ODR      volatile.Register32 // 0xFFFFF814
	BSRR     volatile.Register32 // 0xFFFFF818
	LCKR     volatile.Register32 // 0xFFFFF81C
	AFRL     volatile.Register32 // 0xFFFFF820
	AFRH     volatile.Register32 // 0xFFFFF824
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
}

// Liquid crystal display controller
type LCD_Type struct {
	CR       volatile.Register32 // 0x0
	FCR      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	CLR      volatile.Register32 // 0xC
	_        [4]byte
	RAM_COM0 volatile.Register32 // 0x14
	_        [4]byte
	RAM_COM1 volatile.Register32 // 0x1C
	_        [4]byte
	RAM_COM2 volatile.Register32 // 0x24
	_        [4]byte
	RAM_COM3 volatile.Register32 // 0x2C
	_        [4]byte
	RAM_COM4 volatile.Register32 // 0x34
	_        [4]byte
	RAM_COM5 volatile.Register32 // 0x3C
	_        [4]byte
	RAM_COM6 volatile.Register32 // 0x44
	_        [4]byte
	RAM_COM7 volatile.Register32 // 0x4C
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	_     [4]byte
	ICTR  volatile.Register32 // 0x4
	_     [248]byte
	ISER0 volatile.Register32 // 0x100
	ISER1 volatile.Register32 // 0x104
	_     [120]byte
	ICER0 volatile.Register32 // 0x180
	ICER1 volatile.Register32 // 0x184
	_     [120]byte
	ISPR0 volatile.Register32 // 0x200
	ISPR1 volatile.Register32 // 0x204
	_     [120]byte
	ICPR0 volatile.Register32 // 0x280
	ICPR1 volatile.Register32 // 0x284
	_     [120]byte
	IABR0 volatile.Register32 // 0x300
	IABR1 volatile.Register32 // 0x304
	_     [248]byte
	IPR0  volatile.Register32 // 0x400
	IPR1  volatile.Register32 // 0x404
	IPR2  volatile.Register32 // 0x408
	IPR3  volatile.Register32 // 0x40C
	IPR4  volatile.Register32 // 0x410
	IPR5  volatile.Register32 // 0x414
	IPR6  volatile.Register32 // 0x418
	IPR7  volatile.Register32 // 0x41C
	IPR8  volatile.Register32 // 0x420
	IPR9  volatile.Register32 // 0x424
	IPR10 volatile.Register32 // 0x428
	IPR11 volatile.Register32 // 0x42C
	IPR12 volatile.Register32 // 0x430
	IPR13 volatile.Register32 // 0x434
	_     [2760]byte
	STIR  volatile.Register32 // 0xF00
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// Reset and clock control
type RCC_Type struct {
	CR        volatile.Register32 // 0x0
	ICSCR     volatile.Register32 // 0x4
	CFGR      volatile.Register32 // 0x8
	CIR       volatile.Register32 // 0xC
	AHBRSTR   volatile.Register32 // 0x10
	APB2RSTR  volatile.Register32 // 0x14
	APB1RSTR  volatile.Register32 // 0x18
	AHBENR    volatile.Register32 // 0x1C
	APB2ENR   volatile.Register32 // 0x20
	APB1ENR   volatile.Register32 // 0x24
	AHBLPENR  volatile.Register32 // 0x28
	APB2LPENR volatile.Register32 // 0x2C
	APB1LPENR volatile.Register32 // 0x30
	CSR       volatile.Register32 // 0x34
}

// Routing interface
type RI_Type struct {
	ICR    volatile.Register32 // 0x0
	ASCR1  volatile.Register32 // 0x4
	ASCR2  volatile.Register32 // 0x8
	HYSCR1 volatile.Register32 // 0xC
	HYSCR2 volatile.Register32 // 0x10
	HYSCR3 volatile.Register32 // 0x14
	HYSCR4 volatile.Register32 // 0x18
	ASMR1  volatile.Register32 // 0x1C
	CMR1   volatile.Register32 // 0x20
	CICR1  volatile.Register32 // 0x24
	ASMR2  volatile.Register32 // 0x28
	CMR2   volatile.Register32 // 0x2C
	CICR2  volatile.Register32 // 0x30
	ASMR3  volatile.Register32 // 0x34
	CMR3   volatile.Register32 // 0x38
	CICR3  volatile.Register32 // 0x3C
	ASMR4  volatile.Register32 // 0x40
	CMR4   volatile.Register32 // 0x44
	CICR4  volatile.Register32 // 0x48
	ASMR5  volatile.Register32 // 0x4C
	CMR5   volatile.Register32 // 0x50
	CICR5  volatile.Register32 // 0x54
}

// Serial peripheral interface
type SPI_Type struct {
	_       [63488]byte
	CR1     volatile.Register32 // 0xF800
	CR2     volatile.Register32 // 0xF804
	SR      volatile.Register32 // 0xF808
	DR      volatile.Register32 // 0xF80C
	CRCPR   volatile.Register32 // 0xF810
	RXCRCR  volatile.Register32 // 0xF814
	TXCRCR  volatile.Register32 // 0xF818
	I2SCFGR volatile.Register32 // 0xF81C
	I2SPR   volatile.Register32 // 0xF820
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	USB_EP0R volatile.Register32 // 0x0
	USB_EP1R volatile.Register32 // 0x4
	USB_EP2R volatile.Register32 // 0x8
	USB_EP3R volatile.Register32 // 0xC
	USB_EP4R volatile.Register32 // 0x10
	USB_EP5R volatile.Register32 // 0x14
	USB_EP6R volatile.Register32 // 0x18
	USB_EP7R volatile.Register32 // 0x1C
	_        [32]byte
	USB_CNTR volatile.Register32 // 0x40
	ISTR     volatile.Register32 // 0x44
	FNR      volatile.Register32 // 0x48
	DADDR    volatile.Register32 // 0x4C
	BTABLE   volatile.Register32 // 0x50
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	_    [61440]byte
	SR   volatile.Register32 // 0xF000
	DR   volatile.Register32 // 0xF004
	BRR  volatile.Register32 // 0xF008
	CR1  volatile.Register32 // 0xF00C
	CR2  volatile.Register32 // 0xF010
	CR3  volatile.Register32 // 0xF014
	GTPR volatile.Register32 // 0xF018
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Bitfields for ADC: Analog-to-digital converter
const (
	// SR: status register
	ADC_SR_JCNR_Pos  = 0x9   // Position of JCNR field.
	ADC_SR_JCNR_Msk  = 0x200 // Bit mask of JCNR field.
	ADC_SR_JCNR      = 0x200 // Bit JCNR.
	ADC_SR_RCNR_Pos  = 0x8   // Position of RCNR field.
	ADC_SR_RCNR_Msk  = 0x100 // Bit mask of RCNR field.
	ADC_SR_RCNR      = 0x100 // Bit RCNR.
	ADC_SR_ADONS_Pos = 0x6   // Position of ADONS field.
	ADC_SR_ADONS_Msk = 0x40  // Bit mask of ADONS field.
	ADC_SR_ADONS     = 0x40  // Bit ADONS.
	ADC_SR_OVR_Pos   = 0x5   // Position of OVR field.
	ADC_SR_OVR_Msk   = 0x20  // Bit mask of OVR field.
	ADC_SR_OVR       = 0x20  // Bit OVR.
	ADC_SR_STRT_Pos  = 0x4   // Position of STRT field.
	ADC_SR_STRT_Msk  = 0x10  // Bit mask of STRT field.
	ADC_SR_STRT      = 0x10  // Bit STRT.
	ADC_SR_JSTRT_Pos = 0x3   // Position of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8   // Bit mask of JSTRT field.
	ADC_SR_JSTRT     = 0x8   // Bit JSTRT.
	ADC_SR_JEOC_Pos  = 0x2   // Position of JEOC field.
	ADC_SR_JEOC_Msk  = 0x4   // Bit mask of JEOC field.
	ADC_SR_JEOC      = 0x4   // Bit JEOC.
	ADC_SR_EOC_Pos   = 0x1   // Position of EOC field.
	ADC_SR_EOC_Msk   = 0x2   // Bit mask of EOC field.
	ADC_SR_EOC       = 0x2   // Bit EOC.
	ADC_SR_AWD_Pos   = 0x0   // Position of AWD field.
	ADC_SR_AWD_Msk   = 0x1   // Bit mask of AWD field.
	ADC_SR_AWD       = 0x1   // Bit AWD.

	// CR1: control register 1
	ADC_CR1_OVRIE_Pos   = 0x1a      // Position of OVRIE field.
	ADC_CR1_OVRIE_Msk   = 0x4000000 // Bit mask of OVRIE field.
	ADC_CR1_OVRIE       = 0x4000000 // Bit OVRIE.
	ADC_CR1_RES_Pos     = 0x18      // Position of RES field.
	ADC_CR1_RES_Msk     = 0x3000000 // Bit mask of RES field.
	ADC_CR1_AWDEN_Pos   = 0x17      // Position of AWDEN field.
	ADC_CR1_AWDEN_Msk   = 0x800000  // Bit mask of AWDEN field.
	ADC_CR1_AWDEN       = 0x800000  // Bit AWDEN.
	ADC_CR1_JAWDEN_Pos  = 0x16      // Position of JAWDEN field.
	ADC_CR1_JAWDEN_Msk  = 0x400000  // Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN      = 0x400000  // Bit JAWDEN.
	ADC_CR1_PDI_Pos     = 0x11      // Position of PDI field.
	ADC_CR1_PDI_Msk     = 0x20000   // Bit mask of PDI field.
	ADC_CR1_PDI         = 0x20000   // Bit PDI.
	ADC_CR1_PDD_Pos     = 0x10      // Position of PDD field.
	ADC_CR1_PDD_Msk     = 0x10000   // Bit mask of PDD field.
	ADC_CR1_PDD         = 0x10000   // Bit PDD.
	ADC_CR1_DISCNUM_Pos = 0xd       // Position of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000    // Bit mask of DISCNUM field.
	ADC_CR1_JDISCEN_Pos = 0xc       // Position of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000    // Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN     = 0x1000    // Bit JDISCEN.
	ADC_CR1_DISCEN_Pos  = 0xb       // Position of DISCEN field.
	ADC_CR1_DISCEN_Msk  = 0x800     // Bit mask of DISCEN field.
	ADC_CR1_DISCEN      = 0x800     // Bit DISCEN.
	ADC_CR1_JAUTO_Pos   = 0xa       // Position of JAUTO field.
	ADC_CR1_JAUTO_Msk   = 0x400     // Bit mask of JAUTO field.
	ADC_CR1_JAUTO       = 0x400     // Bit JAUTO.
	ADC_CR1_AWDSGL_Pos  = 0x9       // Position of AWDSGL field.
	ADC_CR1_AWDSGL_Msk  = 0x200     // Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL      = 0x200     // Bit AWDSGL.
	ADC_CR1_SCAN_Pos    = 0x8       // Position of SCAN field.
	ADC_CR1_SCAN_Msk    = 0x100     // Bit mask of SCAN field.
	ADC_CR1_SCAN        = 0x100     // Bit SCAN.
	ADC_CR1_JEOCIE_Pos  = 0x7       // Position of JEOCIE field.
	ADC_CR1_JEOCIE_Msk  = 0x80      // Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE      = 0x80      // Bit JEOCIE.
	ADC_CR1_AWDIE_Pos   = 0x6       // Position of AWDIE field.
	ADC_CR1_AWDIE_Msk   = 0x40      // Bit mask of AWDIE field.
	ADC_CR1_AWDIE       = 0x40      // Bit AWDIE.
	ADC_CR1_EOCIE_Pos   = 0x5       // Position of EOCIE field.
	ADC_CR1_EOCIE_Msk   = 0x20      // Bit mask of EOCIE field.
	ADC_CR1_EOCIE       = 0x20      // Bit EOCIE.
	ADC_CR1_AWDCH_Pos   = 0x0       // Position of AWDCH field.
	ADC_CR1_AWDCH_Msk   = 0x1f      // Bit mask of AWDCH field.

	// CR2: control register 2
	ADC_CR2_SWSTART_Pos  = 0x1e       // Position of SWSTART field.
	ADC_CR2_SWSTART_Msk  = 0x40000000 // Bit mask of SWSTART field.
	ADC_CR2_SWSTART      = 0x40000000 // Bit SWSTART.
	ADC_CR2_EXTEN_Pos    = 0x1c       // Position of EXTEN field.
	ADC_CR2_EXTEN_Msk    = 0x30000000 // Bit mask of EXTEN field.
	ADC_CR2_EXTSEL_Pos   = 0x18       // Position of EXTSEL field.
	ADC_CR2_EXTSEL_Msk   = 0xf000000  // Bit mask of EXTSEL field.
	ADC_CR2_JSWSTART_Pos = 0x16       // Position of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000   // Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART     = 0x400000   // Bit JSWSTART.
	ADC_CR2_JEXTEN_Pos   = 0x14       // Position of JEXTEN field.
	ADC_CR2_JEXTEN_Msk   = 0x300000   // Bit mask of JEXTEN field.
	ADC_CR2_JEXTSEL_Pos  = 0x10       // Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk  = 0xf0000    // Bit mask of JEXTSEL field.
	ADC_CR2_ALIGN_Pos    = 0xb        // Position of ALIGN field.
	ADC_CR2_ALIGN_Msk    = 0x800      // Bit mask of ALIGN field.
	ADC_CR2_ALIGN        = 0x800      // Bit ALIGN.
	ADC_CR2_EOCS_Pos     = 0xa        // Position of EOCS field.
	ADC_CR2_EOCS_Msk     = 0x400      // Bit mask of EOCS field.
	ADC_CR2_EOCS         = 0x400      // Bit EOCS.
	ADC_CR2_DDS_Pos      = 0x9        // Position of DDS field.
	ADC_CR2_DDS_Msk      = 0x200      // Bit mask of DDS field.
	ADC_CR2_DDS          = 0x200      // Bit DDS.
	ADC_CR2_DMA_Pos      = 0x8        // Position of DMA field.
	ADC_CR2_DMA_Msk      = 0x100      // Bit mask of DMA field.
	ADC_CR2_DMA          = 0x100      // Bit DMA.
	ADC_CR2_DELS_Pos     = 0x4        // Position of DELS field.
	ADC_CR2_DELS_Msk     = 0x70       // Bit mask of DELS field.
	ADC_CR2_ADC_CFG_Pos  = 0x2        // Position of ADC_CFG field.
	ADC_CR2_ADC_CFG_Msk  = 0x4        // Bit mask of ADC_CFG field.
	ADC_CR2_ADC_CFG      = 0x4        // Bit ADC_CFG.
	ADC_CR2_CONT_Pos     = 0x1        // Position of CONT field.
	ADC_CR2_CONT_Msk     = 0x2        // Bit mask of CONT field.
	ADC_CR2_CONT         = 0x2        // Bit CONT.
	ADC_CR2_ADON_Pos     = 0x0        // Position of ADON field.
	ADC_CR2_ADON_Msk     = 0x1        // Bit mask of ADON field.
	ADC_CR2_ADON         = 0x1        // Bit ADON.

	// SMPR1: sample time register 1
	ADC_SMPR1_SampletimebitsSMPx_x_Pos = 0x0        // Position of SampletimebitsSMPx_x field.
	ADC_SMPR1_SampletimebitsSMPx_x_Msk = 0xffffffff // Bit mask of SampletimebitsSMPx_x field.

	// SMPR2: sample time register 2
	ADC_SMPR2_SampletimebitsSMPx_x_Pos = 0x0        // Position of SampletimebitsSMPx_x field.
	ADC_SMPR2_SampletimebitsSMPx_x_Msk = 0xffffffff // Bit mask of SampletimebitsSMPx_x field.

	// SMPR3: sample time register 3
	ADC_SMPR3_SampletimebitsSMPx_x_Pos = 0x0        // Position of SampletimebitsSMPx_x field.
	ADC_SMPR3_SampletimebitsSMPx_x_Msk = 0xffffffff // Bit mask of SampletimebitsSMPx_x field.

	// JOFR1: injected channel data offset register           x
	ADC_JOFR1_JOFFSET1_Pos = 0x0   // Position of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Msk = 0xfff // Bit mask of JOFFSET1 field.

	// JOFR2: injected channel data offset register           x
	ADC_JOFR2_JOFFSET2_Pos = 0x0   // Position of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Msk = 0xfff // Bit mask of JOFFSET2 field.

	// JOFR3: injected channel data offset register           x
	ADC_JOFR3_JOFFSET3_Pos = 0x0   // Position of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Msk = 0xfff // Bit mask of JOFFSET3 field.

	// JOFR4: injected channel data offset register           x
	ADC_JOFR4_JOFFSET4_Pos = 0x0   // Position of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Msk = 0xfff // Bit mask of JOFFSET4 field.

	// HTR: watchdog higher threshold           register
	ADC_HTR_HT_Pos = 0x0   // Position of HT field.
	ADC_HTR_HT_Msk = 0xfff // Bit mask of HT field.

	// LTR: watchdog lower threshold           register
	ADC_LTR_LT_Pos = 0x0   // Position of LT field.
	ADC_LTR_LT_Msk = 0xfff // Bit mask of LT field.

	// SQR1: regular sequence register 1
	ADC_SQR1_L_Pos    = 0x14     // Position of L field.
	ADC_SQR1_L_Msk    = 0xf00000 // Bit mask of L field.
	ADC_SQR1_SQ28_Pos = 0xf      // Position of SQ28 field.
	ADC_SQR1_SQ28_Msk = 0xf8000  // Bit mask of SQ28 field.
	ADC_SQR1_SQ27_Pos = 0xa      // Position of SQ27 field.
	ADC_SQR1_SQ27_Msk = 0x7c00   // Bit mask of SQ27 field.
	ADC_SQR1_SQ26_Pos = 0x5      // Position of SQ26 field.
	ADC_SQR1_SQ26_Msk = 0x3e0    // Bit mask of SQ26 field.
	ADC_SQR1_SQ25_Pos = 0x0      // Position of SQ25 field.
	ADC_SQR1_SQ25_Msk = 0x1f     // Bit mask of SQ25 field.

	// SQR2: regular sequence register 2
	ADC_SQR2_SQ24_Pos = 0x19       // Position of SQ24 field.
	ADC_SQR2_SQ24_Msk = 0x3e000000 // Bit mask of SQ24 field.
	ADC_SQR2_SQ23_Pos = 0x14       // Position of SQ23 field.
	ADC_SQR2_SQ23_Msk = 0x1f00000  // Bit mask of SQ23 field.
	ADC_SQR2_SQ22_Pos = 0xf        // Position of SQ22 field.
	ADC_SQR2_SQ22_Msk = 0xf8000    // Bit mask of SQ22 field.
	ADC_SQR2_SQ21_Pos = 0xa        // Position of SQ21 field.
	ADC_SQR2_SQ21_Msk = 0x7c00     // Bit mask of SQ21 field.
	ADC_SQR2_SQ20_Pos = 0x5        // Position of SQ20 field.
	ADC_SQR2_SQ20_Msk = 0x3e0      // Bit mask of SQ20 field.
	ADC_SQR2_SQ19_Pos = 0x0        // Position of SQ19 field.
	ADC_SQR2_SQ19_Msk = 0x1f       // Bit mask of SQ19 field.

	// SQR3: regular sequence register 3
	ADC_SQR3_SQ18_Pos = 0x19       // Position of SQ18 field.
	ADC_SQR3_SQ18_Msk = 0x3e000000 // Bit mask of SQ18 field.
	ADC_SQR3_SQ17_Pos = 0x14       // Position of SQ17 field.
	ADC_SQR3_SQ17_Msk = 0x1f00000  // Bit mask of SQ17 field.
	ADC_SQR3_SQ16_Pos = 0xf        // Position of SQ16 field.
	ADC_SQR3_SQ16_Msk = 0xf8000    // Bit mask of SQ16 field.
	ADC_SQR3_SQ15_Pos = 0xa        // Position of SQ15 field.
	ADC_SQR3_SQ15_Msk = 0x7c00     // Bit mask of SQ15 field.
	ADC_SQR3_SQ14_Pos = 0x5        // Position of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x3e0      // Bit mask of SQ14 field.
	ADC_SQR3_SQ13_Pos = 0x0        // Position of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x1f       // Bit mask of SQ13 field.

	// SQR4: regular sequence register 4
	ADC_SQR4_SQ12_Pos = 0x19       // Position of SQ12 field.
	ADC_SQR4_SQ12_Msk = 0x3e000000 // Bit mask of SQ12 field.
	ADC_SQR4_SQ11_Pos = 0x14       // Position of SQ11 field.
	ADC_SQR4_SQ11_Msk = 0x1f00000  // Bit mask of SQ11 field.
	ADC_SQR4_SQ10_Pos = 0xf        // Position of SQ10 field.
	ADC_SQR4_SQ10_Msk = 0xf8000    // Bit mask of SQ10 field.
	ADC_SQR4_SQ9_Pos  = 0xa        // Position of SQ9 field.
	ADC_SQR4_SQ9_Msk  = 0x7c00     // Bit mask of SQ9 field.
	ADC_SQR4_SQ8_Pos  = 0x5        // Position of SQ8 field.
	ADC_SQR4_SQ8_Msk  = 0x3e0      // Bit mask of SQ8 field.
	ADC_SQR4_SQ7_Pos  = 0x0        // Position of SQ7 field.
	ADC_SQR4_SQ7_Msk  = 0x1f       // Bit mask of SQ7 field.

	// SQR5: regular sequence register 5
	ADC_SQR5_SQ6_Pos = 0x19       // Position of SQ6 field.
	ADC_SQR5_SQ6_Msk = 0x3e000000 // Bit mask of SQ6 field.
	ADC_SQR5_SQ5_Pos = 0x14       // Position of SQ5 field.
	ADC_SQR5_SQ5_Msk = 0x1f00000  // Bit mask of SQ5 field.
	ADC_SQR5_SQ4_Pos = 0xf        // Position of SQ4 field.
	ADC_SQR5_SQ4_Msk = 0xf8000    // Bit mask of SQ4 field.
	ADC_SQR5_SQ3_Pos = 0xa        // Position of SQ3 field.
	ADC_SQR5_SQ3_Msk = 0x7c00     // Bit mask of SQ3 field.
	ADC_SQR5_SQ2_Pos = 0x5        // Position of SQ2 field.
	ADC_SQR5_SQ2_Msk = 0x3e0      // Bit mask of SQ2 field.
	ADC_SQR5_SQ1_Pos = 0x0        // Position of SQ1 field.
	ADC_SQR5_SQ1_Msk = 0x1f       // Bit mask of SQ1 field.

	// JSQR: injected sequence register
	ADC_JSQR_JL_Pos   = 0x14     // Position of JL field.
	ADC_JSQR_JL_Msk   = 0x300000 // Bit mask of JL field.
	ADC_JSQR_JSQ4_Pos = 0xf      // Position of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000  // Bit mask of JSQ4 field.
	ADC_JSQR_JSQ3_Pos = 0xa      // Position of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00   // Bit mask of JSQ3 field.
	ADC_JSQR_JSQ2_Pos = 0x5      // Position of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0    // Bit mask of JSQ2 field.
	ADC_JSQR_JSQ1_Pos = 0x0      // Position of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f     // Bit mask of JSQ1 field.

	// JDR1: injected data register x
	ADC_JDR1_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR2: injected data register x
	ADC_JDR2_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR3: injected data register x
	ADC_JDR3_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// JDR4: injected data register x
	ADC_JDR4_JDATA_Pos = 0x0    // Position of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff // Bit mask of JDATA field.

	// DR: regular data register
	ADC_DR_RegularDATA_Pos = 0x0    // Position of RegularDATA field.
	ADC_DR_RegularDATA_Msk = 0xffff // Bit mask of RegularDATA field.

	// SMPR0: sample time register 0
	ADC_SMPR0_SampletimebitsSMPx_x_Pos = 0x0        // Position of SampletimebitsSMPx_x field.
	ADC_SMPR0_SampletimebitsSMPx_x_Msk = 0xffffffff // Bit mask of SampletimebitsSMPx_x field.
)

// Bitfields for TIM6: Basic timers
const (
	// CR1: TIM6 control register 1
	TIM_CR1_ARPE_Pos = 0x7  // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80 // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80 // Bit ARPE.
	TIM_CR1_OPM_Pos  = 0x3  // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8  // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8  // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2  // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4  // Bit mask of URS field.
	TIM_CR1_URS      = 0x4  // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1  // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2  // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2  // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0  // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1  // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1  // Bit CEN.

	// CR2: TIM6 control register 2
	TIM_CR2_MMS_Pos = 0x4  // Position of MMS field.
	TIM_CR2_MMS_Msk = 0x70 // Bit mask of MMS field.

	// DIER: TIM6 DMA/Interrupt enable           register
	TIM_DIER_UDE_Pos = 0x8   // Position of UDE field.
	TIM_DIER_UDE_Msk = 0x100 // Bit mask of UDE field.
	TIM_DIER_UDE     = 0x100 // Bit UDE.
	TIM_DIER_UIE_Pos = 0x0   // Position of UIE field.
	TIM_DIER_UIE_Msk = 0x1   // Bit mask of UIE field.
	TIM_DIER_UIE     = 0x1   // Bit UIE.

	// SR: TIM6 status register
	TIM_SR_UIF_Pos = 0x0 // Position of UIF field.
	TIM_SR_UIF_Msk = 0x1 // Bit mask of UIF field.
	TIM_SR_UIF     = 0x1 // Bit UIF.

	// EGR: TIM6 event generation register
	TIM_EGR_UG_Pos = 0x0 // Position of UG field.
	TIM_EGR_UG_Msk = 0x1 // Bit mask of UG field.
	TIM_EGR_UG     = 0x1 // Bit UG.

	// CNT: TIM6 counter
	TIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// PSC: TIM6 prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: TIM6 auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.
)

// Bitfields for COMP: Comparators
const (
	// CSR: comparator control and status           register
	COMP_CSR_TSUSP_Pos     = 0x1f       // Position of TSUSP field.
	COMP_CSR_TSUSP_Msk     = 0x80000000 // Bit mask of TSUSP field.
	COMP_CSR_TSUSP         = 0x80000000 // Bit TSUSP.
	COMP_CSR_CAIF_Pos      = 0x1e       // Position of CAIF field.
	COMP_CSR_CAIF_Msk      = 0x40000000 // Bit mask of CAIF field.
	COMP_CSR_CAIF          = 0x40000000 // Bit CAIF.
	COMP_CSR_CAIE_Pos      = 0x1d       // Position of CAIE field.
	COMP_CSR_CAIE_Msk      = 0x20000000 // Bit mask of CAIE field.
	COMP_CSR_CAIE          = 0x20000000 // Bit CAIE.
	COMP_CSR_RCH13_Pos     = 0x1c       // Position of RCH13 field.
	COMP_CSR_RCH13_Msk     = 0x10000000 // Bit mask of RCH13 field.
	COMP_CSR_RCH13         = 0x10000000 // Bit RCH13.
	COMP_CSR_FCH8_Pos      = 0x1b       // Position of FCH8 field.
	COMP_CSR_FCH8_Msk      = 0x8000000  // Bit mask of FCH8 field.
	COMP_CSR_FCH8          = 0x8000000  // Bit FCH8.
	COMP_CSR_FCH3_Pos      = 0x1a       // Position of FCH3 field.
	COMP_CSR_FCH3_Msk      = 0x4000000  // Bit mask of FCH3 field.
	COMP_CSR_FCH3          = 0x4000000  // Bit FCH3.
	COMP_CSR_OUTSEL_Pos    = 0x15       // Position of OUTSEL field.
	COMP_CSR_OUTSEL_Msk    = 0xe00000   // Bit mask of OUTSEL field.
	COMP_CSR_INSEL_Pos     = 0x12       // Position of INSEL field.
	COMP_CSR_INSEL_Msk     = 0x1c0000   // Bit mask of INSEL field.
	COMP_CSR_WNDWE_Pos     = 0x11       // Position of WNDWE field.
	COMP_CSR_WNDWE_Msk     = 0x20000    // Bit mask of WNDWE field.
	COMP_CSR_WNDWE         = 0x20000    // Bit WNDWE.
	COMP_CSR_VREFOUTEN_Pos = 0x10       // Position of VREFOUTEN field.
	COMP_CSR_VREFOUTEN_Msk = 0x10000    // Bit mask of VREFOUTEN field.
	COMP_CSR_VREFOUTEN     = 0x10000    // Bit VREFOUTEN.
	COMP_CSR_CMP2OUT_Pos   = 0xd        // Position of CMP2OUT field.
	COMP_CSR_CMP2OUT_Msk   = 0x2000     // Bit mask of CMP2OUT field.
	COMP_CSR_CMP2OUT       = 0x2000     // Bit CMP2OUT.
	COMP_CSR_SPEED_Pos     = 0xc        // Position of SPEED field.
	COMP_CSR_SPEED_Msk     = 0x1000     // Bit mask of SPEED field.
	COMP_CSR_SPEED         = 0x1000     // Bit SPEED.
	COMP_CSR_CMP1OUT_Pos   = 0x7        // Position of CMP1OUT field.
	COMP_CSR_CMP1OUT_Msk   = 0x80       // Bit mask of CMP1OUT field.
	COMP_CSR_CMP1OUT       = 0x80       // Bit CMP1OUT.
	COMP_CSR_SW1_Pos       = 0x5        // Position of SW1 field.
	COMP_CSR_SW1_Msk       = 0x20       // Bit mask of SW1 field.
	COMP_CSR_SW1           = 0x20       // Bit SW1.
	COMP_CSR_CMP1EN_Pos    = 0x4        // Position of CMP1EN field.
	COMP_CSR_CMP1EN_Msk    = 0x10       // Bit mask of CMP1EN field.
	COMP_CSR_CMP1EN        = 0x10       // Bit CMP1EN.
	COMP_CSR_PD400K_Pos    = 0x3        // Position of PD400K field.
	COMP_CSR_PD400K_Msk    = 0x8        // Bit mask of PD400K field.
	COMP_CSR_PD400K        = 0x8        // Bit PD400K.
	COMP_CSR_PD10K_Pos     = 0x2        // Position of PD10K field.
	COMP_CSR_PD10K_Msk     = 0x4        // Bit mask of PD10K field.
	COMP_CSR_PD10K         = 0x4        // Bit PD10K.
	COMP_CSR_PU400K_Pos    = 0x1        // Position of PU400K field.
	COMP_CSR_PU400K_Msk    = 0x2        // Bit mask of PU400K field.
	COMP_CSR_PU400K        = 0x2        // Bit PU400K.
	COMP_CSR_PU10K_Pos     = 0x0        // Position of PU10K field.
	COMP_CSR_PU10K_Msk     = 0x1        // Bit mask of PU10K field.
	COMP_CSR_PU10K         = 0x1        // Bit PU10K.
)

// Bitfields for CRC: CRC calculation unit
const (
	// DR: Data register
	CRC_DR_Data_register_Pos = 0x0        // Position of Data_register field.
	CRC_DR_Data_register_Msk = 0xffffffff // Bit mask of Data_register field.

	// IDR: Independent data register
	CRC_IDR_Independent_data_register_Pos = 0x0  // Position of Independent_data_register field.
	CRC_IDR_Independent_data_register_Msk = 0x7f // Bit mask of Independent_data_register field.

	// CR: Control register
	CRC_CR_RESET_Pos = 0x0 // Position of RESET field.
	CRC_CR_RESET_Msk = 0x1 // Bit mask of RESET field.
	CRC_CR_RESET     = 0x1 // Bit RESET.
)

// Bitfields for DBG: Debug support
const (
	// DBGMCU_IDCODE: IDCODE
	DBG_DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBG_DBGMCU_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBG_DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBG_DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// DBGMCU_CR: Control Register
	DBG_DBGMCU_CR_DBG_SLEEP_Pos              = 0x0      // Position of DBG_SLEEP field.
	DBG_DBGMCU_CR_DBG_SLEEP_Msk              = 0x1      // Bit mask of DBG_SLEEP field.
	DBG_DBGMCU_CR_DBG_SLEEP                  = 0x1      // Bit DBG_SLEEP.
	DBG_DBGMCU_CR_DBG_STOP_Pos               = 0x1      // Position of DBG_STOP field.
	DBG_DBGMCU_CR_DBG_STOP_Msk               = 0x2      // Bit mask of DBG_STOP field.
	DBG_DBGMCU_CR_DBG_STOP                   = 0x2      // Bit DBG_STOP.
	DBG_DBGMCU_CR_DBG_STANDBY_Pos            = 0x2      // Position of DBG_STANDBY field.
	DBG_DBGMCU_CR_DBG_STANDBY_Msk            = 0x4      // Bit mask of DBG_STANDBY field.
	DBG_DBGMCU_CR_DBG_STANDBY                = 0x4      // Bit DBG_STANDBY.
	DBG_DBGMCU_CR_TRACE_IOEN_Pos             = 0x5      // Position of TRACE_IOEN field.
	DBG_DBGMCU_CR_TRACE_IOEN_Msk             = 0x20     // Bit mask of TRACE_IOEN field.
	DBG_DBGMCU_CR_TRACE_IOEN                 = 0x20     // Bit TRACE_IOEN.
	DBG_DBGMCU_CR_TRACE_MODE_Pos             = 0x6      // Position of TRACE_MODE field.
	DBG_DBGMCU_CR_TRACE_MODE_Msk             = 0xc0     // Bit mask of TRACE_MODE field.
	DBG_DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x10     // Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x10000  // Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_CR_DBG_I2C2_SMBUS_TIMEOUT     = 0x10000  // Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBG_DBGMCU_CR_DBG_TIM8_STOP_Pos          = 0x11     // Position of DBG_TIM8_STOP field.
	DBG_DBGMCU_CR_DBG_TIM8_STOP_Msk          = 0x20000  // Bit mask of DBG_TIM8_STOP field.
	DBG_DBGMCU_CR_DBG_TIM8_STOP              = 0x20000  // Bit DBG_TIM8_STOP.
	DBG_DBGMCU_CR_DBG_TIM5_STOP_Pos          = 0x12     // Position of DBG_TIM5_STOP field.
	DBG_DBGMCU_CR_DBG_TIM5_STOP_Msk          = 0x40000  // Bit mask of DBG_TIM5_STOP field.
	DBG_DBGMCU_CR_DBG_TIM5_STOP              = 0x40000  // Bit DBG_TIM5_STOP.
	DBG_DBGMCU_CR_DBG_TIM6_STOP_Pos          = 0x13     // Position of DBG_TIM6_STOP field.
	DBG_DBGMCU_CR_DBG_TIM6_STOP_Msk          = 0x80000  // Bit mask of DBG_TIM6_STOP field.
	DBG_DBGMCU_CR_DBG_TIM6_STOP              = 0x80000  // Bit DBG_TIM6_STOP.
	DBG_DBGMCU_CR_DBG_TIM7_STOP_Pos          = 0x14     // Position of DBG_TIM7_STOP field.
	DBG_DBGMCU_CR_DBG_TIM7_STOP_Msk          = 0x100000 // Bit mask of DBG_TIM7_STOP field.
	DBG_DBGMCU_CR_DBG_TIM7_STOP              = 0x100000 // Bit DBG_TIM7_STOP.

	// DBGMCU_APB1_FZ: Debug MCU APB1 Freeze registe
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos          = 0x0       // Position of DBG_TIM2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk          = 0x1       // Bit mask of DBG_TIM2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM2_STOP              = 0x1       // Bit DBG_TIM2_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos          = 0x1       // Position of DBG_TIM3_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk          = 0x2       // Bit mask of DBG_TIM3_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM3_STOP              = 0x2       // Bit DBG_TIM3_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos          = 0x2       // Position of DBG_TIM4_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk          = 0x4       // Bit mask of DBG_TIM4_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM4_STOP              = 0x4       // Bit DBG_TIM4_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos          = 0x3       // Position of DBG_TIM5_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk          = 0x8       // Bit mask of DBG_TIM5_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM5_STOP              = 0x8       // Bit DBG_TIM5_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos          = 0x4       // Position of DBG_TIM6_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk          = 0x10      // Bit mask of DBG_TIM6_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM6_STOP              = 0x10      // Bit DBG_TIM6_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos          = 0x5       // Position of DBG_TIM7_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk          = 0x20      // Bit mask of DBG_TIM7_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM7_STOP              = 0x20      // Bit DBG_TIM7_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos         = 0x6       // Position of DBG_TIM12_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk         = 0x40      // Bit mask of DBG_TIM12_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM12_STOP             = 0x40      // Bit DBG_TIM12_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos         = 0x7       // Position of DBG_TIM13_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk         = 0x80      // Bit mask of DBG_TIM13_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM13_STOP             = 0x80      // Bit DBG_TIM13_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_TIM14_STOP_Pos         = 0x8       // Position of DBG_TIM14_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM14_STOP_Msk         = 0x100     // Bit mask of DBG_TIM14_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_TIM14_STOP             = 0x100     // Bit DBG_TIM14_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos          = 0xb       // Position of DBG_WWDG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk          = 0x800     // Bit mask of DBG_WWDG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_WWDG_STOP              = 0x800     // Bit DBG_WWDG_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP_Pos         = 0xc       // Position of DBG_IWDEG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP_Msk         = 0x1000    // Bit mask of DBG_IWDEG_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_IWDEG_STOP             = 0x1000    // Bit DBG_IWDEG_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Pos = 0x15      // Position of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT_Msk = 0x200000  // Bit mask of DBG_J2C1_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C1_SMBUS_TIMEOUT     = 0x200000  // Bit DBG_J2C1_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Pos = 0x16      // Position of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT_Msk = 0x400000  // Bit mask of DBG_J2C2_SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C2_SMBUS_TIMEOUT     = 0x400000  // Bit DBG_J2C2_SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Pos  = 0x17      // Position of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT_Msk  = 0x800000  // Bit mask of DBG_J2C3SMBUS_TIMEOUT field.
	DBG_DBGMCU_APB1_FZ_DBG_J2C3SMBUS_TIMEOUT      = 0x800000  // Bit DBG_J2C3SMBUS_TIMEOUT.
	DBG_DBGMCU_APB1_FZ_DBG_CAN1_STOP_Pos          = 0x19      // Position of DBG_CAN1_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN1_STOP_Msk          = 0x2000000 // Bit mask of DBG_CAN1_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN1_STOP              = 0x2000000 // Bit DBG_CAN1_STOP.
	DBG_DBGMCU_APB1_FZ_DBG_CAN2_STOP_Pos          = 0x1a      // Position of DBG_CAN2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN2_STOP_Msk          = 0x4000000 // Bit mask of DBG_CAN2_STOP field.
	DBG_DBGMCU_APB1_FZ_DBG_CAN2_STOP              = 0x4000000 // Bit DBG_CAN2_STOP.

	// DBGMCU_APB2_FZ: Debug MCU APB2 Freeze registe
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos  = 0x0     // Position of DBG_TIM1_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk  = 0x1     // Bit mask of DBG_TIM1_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM1_STOP      = 0x1     // Bit DBG_TIM1_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos  = 0x1     // Position of DBG_TIM8_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk  = 0x2     // Bit mask of DBG_TIM8_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM8_STOP      = 0x2     // Bit DBG_TIM8_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP_Pos  = 0x10    // Position of DBG_TIM9_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP_Msk  = 0x10000 // Bit mask of DBG_TIM9_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM9_STOP      = 0x10000 // Bit DBG_TIM9_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP_Pos = 0x11    // Position of DBG_TIM10_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP_Msk = 0x20000 // Bit mask of DBG_TIM10_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM10_STOP     = 0x20000 // Bit DBG_TIM10_STOP.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP_Pos = 0x12    // Position of DBG_TIM11_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP_Msk = 0x40000 // Bit mask of DBG_TIM11_STOP field.
	DBG_DBGMCU_APB2_FZ_DBG_TIM11_STOP     = 0x40000 // Bit DBG_TIM11_STOP.
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.
	DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_CR_TSEL2_Pos     = 0x13       // Position of TSEL2 field.
	DAC_CR_TSEL2_Msk     = 0x380000   // Bit mask of TSEL2 field.
	DAC_CR_TEN2_Pos      = 0x12       // Position of TEN2 field.
	DAC_CR_TEN2_Msk      = 0x40000    // Bit mask of TEN2 field.
	DAC_CR_TEN2          = 0x40000    // Bit TEN2.
	DAC_CR_BOFF2_Pos     = 0x11       // Position of BOFF2 field.
	DAC_CR_BOFF2_Msk     = 0x20000    // Bit mask of BOFF2 field.
	DAC_CR_BOFF2         = 0x20000    // Bit BOFF2.
	DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_CR_TSEL1_Pos     = 0x3        // Position of TSEL1 field.
	DAC_CR_TSEL1_Msk     = 0x38       // Bit mask of TSEL1 field.
	DAC_CR_TEN1_Pos      = 0x2        // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4        // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4        // Bit TEN1.
	DAC_CR_BOFF1_Pos     = 0x1        // Position of BOFF1 field.
	DAC_CR_BOFF1_Msk     = 0x2        // Bit mask of BOFF1 field.
	DAC_CR_BOFF1         = 0x2        // Bit BOFF1.
	DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1        // Bit EN1.

	// SWTRIGR: software trigger register
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2     = 0x2 // Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.

	// DHR12R1: channel1 12-bit right-aligned data holding           register
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: channel1 12-bit left aligned data holding           register
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: channel1 8-bit right aligned data holding           register
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DHR12R2: channel2 12-bit right aligned data holding           register
	DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DHR12L2: channel2 12-bit left aligned data holding           register
	DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DHR8R2: channel2 8-bit right-aligned data holding           register
	DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DHR12RD: Dual DAC 12-bit right-aligned data holding           register
	DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.

	// DHR12LD: DUAL DAC 12-bit left aligned data holding           register
	DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.

	// DHR8RD: DUAL DAC 8-bit right aligned data holding           register
	DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.

	// DOR1: channel1 data output register
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DOR2: channel2 data output register
	DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// SR: status register
	DAC_SR_DMAUDR2_Pos = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2     = 0x20000000 // Bit DMAUDR2.
	DAC_SR_DMAUDR1_Pos = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1     = 0x2000     // Bit DMAUDR1.
)

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	DMA_ISR_TEIF7_Pos = 0x1b      // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000 // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7     = 0x8000000 // Bit TEIF7.
	DMA_ISR_HTIF7_Pos = 0x1a      // Position of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000 // Bit mask of HTIF7 field.
	DMA_ISR_HTIF7     = 0x4000000 // Bit HTIF7.
	DMA_ISR_TCIF7_Pos = 0x19      // Position of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000 // Bit mask of TCIF7 field.
	DMA_ISR_TCIF7     = 0x2000000 // Bit TCIF7.
	DMA_ISR_GIF7_Pos  = 0x18      // Position of GIF7 field.
	DMA_ISR_GIF7_Msk  = 0x1000000 // Bit mask of GIF7 field.
	DMA_ISR_GIF7      = 0x1000000 // Bit GIF7.
	DMA_ISR_TEIF6_Pos = 0x17      // Position of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000  // Bit mask of TEIF6 field.
	DMA_ISR_TEIF6     = 0x800000  // Bit TEIF6.
	DMA_ISR_HTIF6_Pos = 0x16      // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000  // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6     = 0x400000  // Bit HTIF6.
	DMA_ISR_TCIF6_Pos = 0x15      // Position of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000  // Bit mask of TCIF6 field.
	DMA_ISR_TCIF6     = 0x200000  // Bit TCIF6.
	DMA_ISR_GIF6_Pos  = 0x14      // Position of GIF6 field.
	DMA_ISR_GIF6_Msk  = 0x100000  // Bit mask of GIF6 field.
	DMA_ISR_GIF6      = 0x100000  // Bit GIF6.
	DMA_ISR_TEIF5_Pos = 0x13      // Position of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000   // Bit mask of TEIF5 field.
	DMA_ISR_TEIF5     = 0x80000   // Bit TEIF5.
	DMA_ISR_HTIF5_Pos = 0x12      // Position of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000   // Bit mask of HTIF5 field.
	DMA_ISR_HTIF5     = 0x40000   // Bit HTIF5.
	DMA_ISR_TCIF5_Pos = 0x11      // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000   // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5     = 0x20000   // Bit TCIF5.
	DMA_ISR_GIF5_Pos  = 0x10      // Position of GIF5 field.
	DMA_ISR_GIF5_Msk  = 0x10000   // Bit mask of GIF5 field.
	DMA_ISR_GIF5      = 0x10000   // Bit GIF5.
	DMA_ISR_TEIF4_Pos = 0xf       // Position of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000    // Bit mask of TEIF4 field.
	DMA_ISR_TEIF4     = 0x8000    // Bit TEIF4.
	DMA_ISR_HTIF4_Pos = 0xe       // Position of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000    // Bit mask of HTIF4 field.
	DMA_ISR_HTIF4     = 0x4000    // Bit HTIF4.
	DMA_ISR_TCIF4_Pos = 0xd       // Position of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000    // Bit mask of TCIF4 field.
	DMA_ISR_TCIF4     = 0x2000    // Bit TCIF4.
	DMA_ISR_GIF4_Pos  = 0xc       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk  = 0x1000    // Bit mask of GIF4 field.
	DMA_ISR_GIF4      = 0x1000    // Bit GIF4.
	DMA_ISR_TEIF3_Pos = 0xb       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800     // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3     = 0x800     // Bit TEIF3.
	DMA_ISR_HTIF3_Pos = 0xa       // Position of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400     // Bit mask of HTIF3 field.
	DMA_ISR_HTIF3     = 0x400     // Bit HTIF3.
	DMA_ISR_TCIF3_Pos = 0x9       // Position of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200     // Bit mask of TCIF3 field.
	DMA_ISR_TCIF3     = 0x200     // Bit TCIF3.
	DMA_ISR_GIF3_Pos  = 0x8       // Position of GIF3 field.
	DMA_ISR_GIF3_Msk  = 0x100     // Bit mask of GIF3 field.
	DMA_ISR_GIF3      = 0x100     // Bit GIF3.
	DMA_ISR_TEIF2_Pos = 0x7       // Position of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80      // Bit mask of TEIF2 field.
	DMA_ISR_TEIF2     = 0x80      // Bit TEIF2.
	DMA_ISR_HTIF2_Pos = 0x6       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40      // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2     = 0x40      // Bit HTIF2.
	DMA_ISR_TCIF2_Pos = 0x5       // Position of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20      // Bit mask of TCIF2 field.
	DMA_ISR_TCIF2     = 0x20      // Bit TCIF2.
	DMA_ISR_GIF2_Pos  = 0x4       // Position of GIF2 field.
	DMA_ISR_GIF2_Msk  = 0x10      // Bit mask of GIF2 field.
	DMA_ISR_GIF2      = 0x10      // Bit GIF2.
	DMA_ISR_TEIF1_Pos = 0x3       // Position of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8       // Bit mask of TEIF1 field.
	DMA_ISR_TEIF1     = 0x8       // Bit TEIF1.
	DMA_ISR_HTIF1_Pos = 0x2       // Position of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4       // Bit mask of HTIF1 field.
	DMA_ISR_HTIF1     = 0x4       // Bit HTIF1.
	DMA_ISR_TCIF1_Pos = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1     = 0x2       // Bit TCIF1.
	DMA_ISR_GIF1_Pos  = 0x0       // Position of GIF1 field.
	DMA_ISR_GIF1_Msk  = 0x1       // Bit mask of GIF1 field.
	DMA_ISR_GIF1      = 0x1       // Bit GIF1.

	// IFCR: interrupt flag clear register
	DMA_IFCR_CTEIF7_Pos = 0x1b      // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000 // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7     = 0x8000000 // Bit CTEIF7.
	DMA_IFCR_CHTIF7_Pos = 0x1a      // Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7     = 0x4000000 // Bit CHTIF7.
	DMA_IFCR_CTCIF7_Pos = 0x19      // Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000 // Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7     = 0x2000000 // Bit CTCIF7.
	DMA_IFCR_CGIF7_Pos  = 0x18      // Position of CGIF7 field.
	DMA_IFCR_CGIF7_Msk  = 0x1000000 // Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7      = 0x1000000 // Bit CGIF7.
	DMA_IFCR_CTEIF6_Pos = 0x17      // Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000  // Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6     = 0x800000  // Bit CTEIF6.
	DMA_IFCR_CHTIF6_Pos = 0x16      // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000  // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6     = 0x400000  // Bit CHTIF6.
	DMA_IFCR_CTCIF6_Pos = 0x15      // Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000  // Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6     = 0x200000  // Bit CTCIF6.
	DMA_IFCR_CGIF6_Pos  = 0x14      // Position of CGIF6 field.
	DMA_IFCR_CGIF6_Msk  = 0x100000  // Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6      = 0x100000  // Bit CGIF6.
	DMA_IFCR_CTEIF5_Pos = 0x13      // Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000   // Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5     = 0x80000   // Bit CTEIF5.
	DMA_IFCR_CHTIF5_Pos = 0x12      // Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000   // Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5     = 0x40000   // Bit CHTIF5.
	DMA_IFCR_CTCIF5_Pos = 0x11      // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000   // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5     = 0x20000   // Bit CTCIF5.
	DMA_IFCR_CGIF5_Pos  = 0x10      // Position of CGIF5 field.
	DMA_IFCR_CGIF5_Msk  = 0x10000   // Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5      = 0x10000   // Bit CGIF5.
	DMA_IFCR_CTEIF4_Pos = 0xf       // Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000    // Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4     = 0x8000    // Bit CTEIF4.
	DMA_IFCR_CHTIF4_Pos = 0xe       // Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000    // Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4     = 0x4000    // Bit CHTIF4.
	DMA_IFCR_CTCIF4_Pos = 0xd       // Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000    // Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4     = 0x2000    // Bit CTCIF4.
	DMA_IFCR_CGIF4_Pos  = 0xc       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk  = 0x1000    // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4      = 0x1000    // Bit CGIF4.
	DMA_IFCR_CTEIF3_Pos = 0xb       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800     // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3     = 0x800     // Bit CTEIF3.
	DMA_IFCR_CHTIF3_Pos = 0xa       // Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400     // Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3     = 0x400     // Bit CHTIF3.
	DMA_IFCR_CTCIF3_Pos = 0x9       // Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200     // Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3     = 0x200     // Bit CTCIF3.
	DMA_IFCR_CGIF3_Pos  = 0x8       // Position of CGIF3 field.
	DMA_IFCR_CGIF3_Msk  = 0x100     // Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3      = 0x100     // Bit CGIF3.
	DMA_IFCR_CTEIF2_Pos = 0x7       // Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80      // Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2     = 0x80      // Bit CTEIF2.
	DMA_IFCR_CHTIF2_Pos = 0x6       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40      // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2     = 0x40      // Bit CHTIF2.
	DMA_IFCR_CTCIF2_Pos = 0x5       // Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20      // Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2     = 0x20      // Bit CTCIF2.
	DMA_IFCR_CGIF2_Pos  = 0x4       // Position of CGIF2 field.
	DMA_IFCR_CGIF2_Msk  = 0x10      // Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2      = 0x10      // Bit CGIF2.
	DMA_IFCR_CTEIF1_Pos = 0x3       // Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8       // Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1     = 0x8       // Bit CTEIF1.
	DMA_IFCR_CHTIF1_Pos = 0x2       // Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4       // Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1     = 0x4       // Bit CHTIF1.
	DMA_IFCR_CTCIF1_Pos = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1     = 0x2       // Bit CTCIF1.
	DMA_IFCR_CGIF1_Pos  = 0x0       // Position of CGIF1 field.
	DMA_IFCR_CGIF1_Msk  = 0x1       // Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1      = 0x1       // Bit CGIF1.

	// CCR1: channel x configuration           register
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.

	// CNDTR1: channel x number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: channel x peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: channel x memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: channel x configuration           register
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.

	// CNDTR2: channel x number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: channel x peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: channel x memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: channel x configuration           register
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.

	// CNDTR3: channel x number of data           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: channel x peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: channel x memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: channel x configuration           register
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.

	// CNDTR4: channel x number of data           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: channel x peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: channel x memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: channel x configuration           register
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.

	// CNDTR5: channel x number of data           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: channel x peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: channel x memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: channel x configuration           register
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.

	// CNDTR6: channel x number of data           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: channel x peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: channel x memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: channel x configuration           register
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.

	// CNDTR7: channel x number of data           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: channel x peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: channel x memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: IMR
	EXTI_IMR_MR_Pos = 0x0      // Position of MR field.
	EXTI_IMR_MR_Msk = 0x7fffff // Bit mask of MR field.

	// EMR: EMR
	EXTI_EMR_MR_Pos = 0x0      // Position of MR field.
	EXTI_EMR_MR_Msk = 0x7fffff // Bit mask of MR field.

	// RTSR: RTSR
	EXTI_RTSR_TR_Pos = 0x0      // Position of TR field.
	EXTI_RTSR_TR_Msk = 0x7fffff // Bit mask of TR field.

	// FTSR: FTSR
	EXTI_FTSR_TR_Pos = 0x0      // Position of TR field.
	EXTI_FTSR_TR_Msk = 0x7fffff // Bit mask of TR field.

	// SWIER: SWIER
	EXTI_SWIER_SWIER_Pos = 0x0      // Position of SWIER field.
	EXTI_SWIER_SWIER_Msk = 0x7fffff // Bit mask of SWIER field.

	// PR: PR
	EXTI_PR_PR_Pos = 0x0      // Position of PR field.
	EXTI_PR_PR_Msk = 0x7fffff // Bit mask of PR field.
)

// Bitfields for Flash: Flash
const (
	// ACR: Access control register
	Flash_ACR_LATENCY_Pos  = 0x0  // Position of LATENCY field.
	Flash_ACR_LATENCY_Msk  = 0x1  // Bit mask of LATENCY field.
	Flash_ACR_LATENCY      = 0x1  // Bit LATENCY.
	Flash_ACR_PRFTEN_Pos   = 0x1  // Position of PRFTEN field.
	Flash_ACR_PRFTEN_Msk   = 0x2  // Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN       = 0x2  // Bit PRFTEN.
	Flash_ACR_ACC64_Pos    = 0x2  // Position of ACC64 field.
	Flash_ACR_ACC64_Msk    = 0x4  // Bit mask of ACC64 field.
	Flash_ACR_ACC64        = 0x4  // Bit ACC64.
	Flash_ACR_SLEEP_PD_Pos = 0x3  // Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk = 0x8  // Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD     = 0x8  // Bit SLEEP_PD.
	Flash_ACR_RUN_PD_Pos   = 0x4  // Position of RUN_PD field.
	Flash_ACR_RUN_PD_Msk   = 0x10 // Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD       = 0x10 // Bit RUN_PD.

	// PECR: Program/erase control register
	Flash_PECR_PELOCK_Pos       = 0x0     // Position of PELOCK field.
	Flash_PECR_PELOCK_Msk       = 0x1     // Bit mask of PELOCK field.
	Flash_PECR_PELOCK           = 0x1     // Bit PELOCK.
	Flash_PECR_PRGLOCK_Pos      = 0x1     // Position of PRGLOCK field.
	Flash_PECR_PRGLOCK_Msk      = 0x2     // Bit mask of PRGLOCK field.
	Flash_PECR_PRGLOCK          = 0x2     // Bit PRGLOCK.
	Flash_PECR_OPTLOCK_Pos      = 0x2     // Position of OPTLOCK field.
	Flash_PECR_OPTLOCK_Msk      = 0x4     // Bit mask of OPTLOCK field.
	Flash_PECR_OPTLOCK          = 0x4     // Bit OPTLOCK.
	Flash_PECR_PROG_Pos         = 0x3     // Position of PROG field.
	Flash_PECR_PROG_Msk         = 0x8     // Bit mask of PROG field.
	Flash_PECR_PROG             = 0x8     // Bit PROG.
	Flash_PECR_DATA_Pos         = 0x4     // Position of DATA field.
	Flash_PECR_DATA_Msk         = 0x10    // Bit mask of DATA field.
	Flash_PECR_DATA             = 0x10    // Bit DATA.
	Flash_PECR_FTDW_Pos         = 0x8     // Position of FTDW field.
	Flash_PECR_FTDW_Msk         = 0x100   // Bit mask of FTDW field.
	Flash_PECR_FTDW             = 0x100   // Bit FTDW.
	Flash_PECR_ERASE_Pos        = 0x9     // Position of ERASE field.
	Flash_PECR_ERASE_Msk        = 0x200   // Bit mask of ERASE field.
	Flash_PECR_ERASE            = 0x200   // Bit ERASE.
	Flash_PECR_FPRG_Pos         = 0xa     // Position of FPRG field.
	Flash_PECR_FPRG_Msk         = 0x400   // Bit mask of FPRG field.
	Flash_PECR_FPRG             = 0x400   // Bit FPRG.
	Flash_PECR_PARALLELBANK_Pos = 0xf     // Position of PARALLELBANK field.
	Flash_PECR_PARALLELBANK_Msk = 0x8000  // Bit mask of PARALLELBANK field.
	Flash_PECR_PARALLELBANK     = 0x8000  // Bit PARALLELBANK.
	Flash_PECR_EOPIE_Pos        = 0x10    // Position of EOPIE field.
	Flash_PECR_EOPIE_Msk        = 0x10000 // Bit mask of EOPIE field.
	Flash_PECR_EOPIE            = 0x10000 // Bit EOPIE.
	Flash_PECR_ERRIE_Pos        = 0x11    // Position of ERRIE field.
	Flash_PECR_ERRIE_Msk        = 0x20000 // Bit mask of ERRIE field.
	Flash_PECR_ERRIE            = 0x20000 // Bit ERRIE.
	Flash_PECR_OBL_LAUNCH_Pos   = 0x12    // Position of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH_Msk   = 0x40000 // Bit mask of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH       = 0x40000 // Bit OBL_LAUNCH.

	// PDKEYR: Power down key register
	Flash_PDKEYR_PDKEYR_Pos = 0x0        // Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff // Bit mask of PDKEYR field.

	// PEKEYR: Program/erase key register
	Flash_PEKEYR_PEKEYR_Pos = 0x0        // Position of PEKEYR field.
	Flash_PEKEYR_PEKEYR_Msk = 0xffffffff // Bit mask of PEKEYR field.

	// PRGKEYR: Program memory key register
	Flash_PRGKEYR_PRGKEYR_Pos = 0x0        // Position of PRGKEYR field.
	Flash_PRGKEYR_PRGKEYR_Msk = 0xffffffff // Bit mask of PRGKEYR field.

	// OPTKEYR: Option byte key register
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// SR: Status register
	Flash_SR_BSY_Pos        = 0x0    // Position of BSY field.
	Flash_SR_BSY_Msk        = 0x1    // Bit mask of BSY field.
	Flash_SR_BSY            = 0x1    // Bit BSY.
	Flash_SR_EOP_Pos        = 0x1    // Position of EOP field.
	Flash_SR_EOP_Msk        = 0x2    // Bit mask of EOP field.
	Flash_SR_EOP            = 0x2    // Bit EOP.
	Flash_SR_ENDHV_Pos      = 0x2    // Position of ENDHV field.
	Flash_SR_ENDHV_Msk      = 0x4    // Bit mask of ENDHV field.
	Flash_SR_ENDHV          = 0x4    // Bit ENDHV.
	Flash_SR_READY_Pos      = 0x3    // Position of READY field.
	Flash_SR_READY_Msk      = 0x8    // Bit mask of READY field.
	Flash_SR_READY          = 0x8    // Bit READY.
	Flash_SR_WRPERR_Pos     = 0x8    // Position of WRPERR field.
	Flash_SR_WRPERR_Msk     = 0x100  // Bit mask of WRPERR field.
	Flash_SR_WRPERR         = 0x100  // Bit WRPERR.
	Flash_SR_PGAERR_Pos     = 0x9    // Position of PGAERR field.
	Flash_SR_PGAERR_Msk     = 0x200  // Bit mask of PGAERR field.
	Flash_SR_PGAERR         = 0x200  // Bit PGAERR.
	Flash_SR_SIZERR_Pos     = 0xa    // Position of SIZERR field.
	Flash_SR_SIZERR_Msk     = 0x400  // Bit mask of SIZERR field.
	Flash_SR_SIZERR         = 0x400  // Bit SIZERR.
	Flash_SR_OPTVERR_Pos    = 0xb    // Position of OPTVERR field.
	Flash_SR_OPTVERR_Msk    = 0x800  // Bit mask of OPTVERR field.
	Flash_SR_OPTVERR        = 0x800  // Bit OPTVERR.
	Flash_SR_OPTVERRUSR_Pos = 0xc    // Position of OPTVERRUSR field.
	Flash_SR_OPTVERRUSR_Msk = 0x1000 // Bit mask of OPTVERRUSR field.
	Flash_SR_OPTVERRUSR     = 0x1000 // Bit OPTVERRUSR.

	// OBR: Option byte register
	Flash_OBR_RDPRT_Pos      = 0x0      // Position of RDPRT field.
	Flash_OBR_RDPRT_Msk      = 0xff     // Bit mask of RDPRT field.
	Flash_OBR_BOR_LEV_Pos    = 0x10     // Position of BOR_LEV field.
	Flash_OBR_BOR_LEV_Msk    = 0xf0000  // Bit mask of BOR_LEV field.
	Flash_OBR_IWDG_SW_Pos    = 0x14     // Position of IWDG_SW field.
	Flash_OBR_IWDG_SW_Msk    = 0x100000 // Bit mask of IWDG_SW field.
	Flash_OBR_IWDG_SW        = 0x100000 // Bit IWDG_SW.
	Flash_OBR_NRTS_STOP_Pos  = 0x15     // Position of NRTS_STOP field.
	Flash_OBR_NRTS_STOP_Msk  = 0x200000 // Bit mask of NRTS_STOP field.
	Flash_OBR_NRTS_STOP      = 0x200000 // Bit NRTS_STOP.
	Flash_OBR_NRST_STDBY_Pos = 0x16     // Position of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Msk = 0x400000 // Bit mask of NRST_STDBY field.
	Flash_OBR_NRST_STDBY     = 0x400000 // Bit NRST_STDBY.
	Flash_OBR_BFB2_Pos       = 0x17     // Position of BFB2 field.
	Flash_OBR_BFB2_Msk       = 0x800000 // Bit mask of BFB2 field.
	Flash_OBR_BFB2           = 0x800000 // Bit BFB2.

	// WRPR1: Write protection register
	Flash_WRPR1_WRP1_Pos = 0x0        // Position of WRP1 field.
	Flash_WRPR1_WRP1_Msk = 0xffffffff // Bit mask of WRP1 field.

	// WRPR2: Write protection register
	Flash_WRPR2_WRP2_Pos = 0x0        // Position of WRP2 field.
	Flash_WRPR2_WRP2_Msk = 0xffffffff // Bit mask of WRP2 field.

	// WRPR3: Write protection register
	Flash_WRPR3_WRP3_Pos = 0x0        // Position of WRP3 field.
	Flash_WRPR3_WRP3_Msk = 0xffffffff // Bit mask of WRP3 field.
)

// Bitfields for GPIOE: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDER: GPIO port output speed           register
	GPIO_OSPEEDER_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDER_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDER_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDER_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDER_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDER_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDER_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDER_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDER_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDER_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDER_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDER_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDER_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDER_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDER_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDER_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDER_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDER_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDER_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDER_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDER_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDER_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDER_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDER_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDER_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDER_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDER_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDER_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDER_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDER_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDER_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDER_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: AFRL
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: CR1
	I2C_CR1_SWRST_Pos     = 0xf    // Position of SWRST field.
	I2C_CR1_SWRST_Msk     = 0x8000 // Bit mask of SWRST field.
	I2C_CR1_SWRST         = 0x8000 // Bit SWRST.
	I2C_CR1_ALERT_Pos     = 0xd    // Position of ALERT field.
	I2C_CR1_ALERT_Msk     = 0x2000 // Bit mask of ALERT field.
	I2C_CR1_ALERT         = 0x2000 // Bit ALERT.
	I2C_CR1_PEC_Pos       = 0xc    // Position of PEC field.
	I2C_CR1_PEC_Msk       = 0x1000 // Bit mask of PEC field.
	I2C_CR1_PEC           = 0x1000 // Bit PEC.
	I2C_CR1_POS_Pos       = 0xb    // Position of POS field.
	I2C_CR1_POS_Msk       = 0x800  // Bit mask of POS field.
	I2C_CR1_POS           = 0x800  // Bit POS.
	I2C_CR1_ACK_Pos       = 0xa    // Position of ACK field.
	I2C_CR1_ACK_Msk       = 0x400  // Bit mask of ACK field.
	I2C_CR1_ACK           = 0x400  // Bit ACK.
	I2C_CR1_STOP_Pos      = 0x9    // Position of STOP field.
	I2C_CR1_STOP_Msk      = 0x200  // Bit mask of STOP field.
	I2C_CR1_STOP          = 0x200  // Bit STOP.
	I2C_CR1_START_Pos     = 0x8    // Position of START field.
	I2C_CR1_START_Msk     = 0x100  // Bit mask of START field.
	I2C_CR1_START         = 0x100  // Bit START.
	I2C_CR1_NOSTRETCH_Pos = 0x7    // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80   // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x80   // Bit NOSTRETCH.
	I2C_CR1_ENGC_Pos      = 0x6    // Position of ENGC field.
	I2C_CR1_ENGC_Msk      = 0x40   // Bit mask of ENGC field.
	I2C_CR1_ENGC          = 0x40   // Bit ENGC.
	I2C_CR1_ENPEC_Pos     = 0x5    // Position of ENPEC field.
	I2C_CR1_ENPEC_Msk     = 0x20   // Bit mask of ENPEC field.
	I2C_CR1_ENPEC         = 0x20   // Bit ENPEC.
	I2C_CR1_ENARP_Pos     = 0x4    // Position of ENARP field.
	I2C_CR1_ENARP_Msk     = 0x10   // Bit mask of ENARP field.
	I2C_CR1_ENARP         = 0x10   // Bit ENARP.
	I2C_CR1_SMBTYPE_Pos   = 0x3    // Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk   = 0x8    // Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE       = 0x8    // Bit SMBTYPE.
	I2C_CR1_SMBUS_Pos     = 0x1    // Position of SMBUS field.
	I2C_CR1_SMBUS_Msk     = 0x2    // Bit mask of SMBUS field.
	I2C_CR1_SMBUS         = 0x2    // Bit SMBUS.
	I2C_CR1_PE_Pos        = 0x0    // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1    // Bit mask of PE field.
	I2C_CR1_PE            = 0x1    // Bit PE.

	// CR2: CR2
	I2C_CR2_LAST_Pos    = 0xc    // Position of LAST field.
	I2C_CR2_LAST_Msk    = 0x1000 // Bit mask of LAST field.
	I2C_CR2_LAST        = 0x1000 // Bit LAST.
	I2C_CR2_DMAEN_Pos   = 0xb    // Position of DMAEN field.
	I2C_CR2_DMAEN_Msk   = 0x800  // Bit mask of DMAEN field.
	I2C_CR2_DMAEN       = 0x800  // Bit DMAEN.
	I2C_CR2_ITBUFEN_Pos = 0xa    // Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400  // Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN     = 0x400  // Bit ITBUFEN.
	I2C_CR2_ITEVTEN_Pos = 0x9    // Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200  // Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN     = 0x200  // Bit ITEVTEN.
	I2C_CR2_ITERREN_Pos = 0x8    // Position of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100  // Bit mask of ITERREN field.
	I2C_CR2_ITERREN     = 0x100  // Bit ITERREN.
	I2C_CR2_FREQ_Pos    = 0x0    // Position of FREQ field.
	I2C_CR2_FREQ_Msk    = 0x3f   // Bit mask of FREQ field.

	// OAR1: OAR1
	I2C_OAR1_ADDMODE_Pos = 0xf    // Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000 // Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE     = 0x8000 // Bit ADDMODE.
	I2C_OAR1_ADD_8_9_Pos = 0x8    // Position of ADD_8_9 field.
	I2C_OAR1_ADD_8_9_Msk = 0x300  // Bit mask of ADD_8_9 field.
	I2C_OAR1_ADD_1_7_Pos = 0x1    // Position of ADD_1_7 field.
	I2C_OAR1_ADD_1_7_Msk = 0xfe   // Bit mask of ADD_1_7 field.
	I2C_OAR1_ADD_0_Pos   = 0x0    // Position of ADD_0 field.
	I2C_OAR1_ADD_0_Msk   = 0x1    // Bit mask of ADD_0 field.
	I2C_OAR1_ADD_0       = 0x1    // Bit ADD_0.

	// OAR2: OAR2
	I2C_OAR2_ADD2_Pos   = 0x1  // Position of ADD2 field.
	I2C_OAR2_ADD2_Msk   = 0xfe // Bit mask of ADD2 field.
	I2C_OAR2_ENDUAL_Pos = 0x0  // Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1  // Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL     = 0x1  // Bit ENDUAL.

	// DR: DR
	I2C_DR_DR_Pos = 0x0  // Position of DR field.
	I2C_DR_DR_Msk = 0xff // Bit mask of DR field.

	// SR1: SR1
	I2C_SR1_SMBALERT_Pos = 0xf    // Position of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000 // Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT     = 0x8000 // Bit SMBALERT.
	I2C_SR1_TIMEOUT_Pos  = 0xe    // Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk  = 0x4000 // Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT      = 0x4000 // Bit TIMEOUT.
	I2C_SR1_PECERR_Pos   = 0xc    // Position of PECERR field.
	I2C_SR1_PECERR_Msk   = 0x1000 // Bit mask of PECERR field.
	I2C_SR1_PECERR       = 0x1000 // Bit PECERR.
	I2C_SR1_OVR_Pos      = 0xb    // Position of OVR field.
	I2C_SR1_OVR_Msk      = 0x800  // Bit mask of OVR field.
	I2C_SR1_OVR          = 0x800  // Bit OVR.
	I2C_SR1_AF_Pos       = 0xa    // Position of AF field.
	I2C_SR1_AF_Msk       = 0x400  // Bit mask of AF field.
	I2C_SR1_AF           = 0x400  // Bit AF.
	I2C_SR1_ARLO_Pos     = 0x9    // Position of ARLO field.
	I2C_SR1_ARLO_Msk     = 0x200  // Bit mask of ARLO field.
	I2C_SR1_ARLO         = 0x200  // Bit ARLO.
	I2C_SR1_BERR_Pos     = 0x8    // Position of BERR field.
	I2C_SR1_BERR_Msk     = 0x100  // Bit mask of BERR field.
	I2C_SR1_BERR         = 0x100  // Bit BERR.
	I2C_SR1_TxE_Pos      = 0x7    // Position of TxE field.
	I2C_SR1_TxE_Msk      = 0x80   // Bit mask of TxE field.
	I2C_SR1_TxE          = 0x80   // Bit TxE.
	I2C_SR1_RxNE_Pos     = 0x6    // Position of RxNE field.
	I2C_SR1_RxNE_Msk     = 0x40   // Bit mask of RxNE field.
	I2C_SR1_RxNE         = 0x40   // Bit RxNE.
	I2C_SR1_STOPF_Pos    = 0x4    // Position of STOPF field.
	I2C_SR1_STOPF_Msk    = 0x10   // Bit mask of STOPF field.
	I2C_SR1_STOPF        = 0x10   // Bit STOPF.
	I2C_SR1_ADD10_Pos    = 0x3    // Position of ADD10 field.
	I2C_SR1_ADD10_Msk    = 0x8    // Bit mask of ADD10 field.
	I2C_SR1_ADD10        = 0x8    // Bit ADD10.
	I2C_SR1_BTF_Pos      = 0x2    // Position of BTF field.
	I2C_SR1_BTF_Msk      = 0x4    // Bit mask of BTF field.
	I2C_SR1_BTF          = 0x4    // Bit BTF.
	I2C_SR1_ADDR_Pos     = 0x1    // Position of ADDR field.
	I2C_SR1_ADDR_Msk     = 0x2    // Bit mask of ADDR field.
	I2C_SR1_ADDR         = 0x2    // Bit ADDR.
	I2C_SR1_SB_Pos       = 0x0    // Position of SB field.
	I2C_SR1_SB_Msk       = 0x1    // Bit mask of SB field.
	I2C_SR1_SB           = 0x1    // Bit SB.

	// SR2: SR2
	I2C_SR2_PEC_Pos        = 0x8    // Position of PEC field.
	I2C_SR2_PEC_Msk        = 0xff00 // Bit mask of PEC field.
	I2C_SR2_DUALF_Pos      = 0x7    // Position of DUALF field.
	I2C_SR2_DUALF_Msk      = 0x80   // Bit mask of DUALF field.
	I2C_SR2_DUALF          = 0x80   // Bit DUALF.
	I2C_SR2_SMBHOST_Pos    = 0x6    // Position of SMBHOST field.
	I2C_SR2_SMBHOST_Msk    = 0x40   // Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST        = 0x40   // Bit SMBHOST.
	I2C_SR2_SMBDEFAULT_Pos = 0x5    // Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20   // Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT     = 0x20   // Bit SMBDEFAULT.
	I2C_SR2_GENCALL_Pos    = 0x4    // Position of GENCALL field.
	I2C_SR2_GENCALL_Msk    = 0x10   // Bit mask of GENCALL field.
	I2C_SR2_GENCALL        = 0x10   // Bit GENCALL.
	I2C_SR2_TRA_Pos        = 0x2    // Position of TRA field.
	I2C_SR2_TRA_Msk        = 0x4    // Bit mask of TRA field.
	I2C_SR2_TRA            = 0x4    // Bit TRA.
	I2C_SR2_BUSY_Pos       = 0x1    // Position of BUSY field.
	I2C_SR2_BUSY_Msk       = 0x2    // Bit mask of BUSY field.
	I2C_SR2_BUSY           = 0x2    // Bit BUSY.
	I2C_SR2_MSL_Pos        = 0x0    // Position of MSL field.
	I2C_SR2_MSL_Msk        = 0x1    // Bit mask of MSL field.
	I2C_SR2_MSL            = 0x1    // Bit MSL.

	// CCR: CCR
	I2C_CCR_F_S_Pos  = 0xf    // Position of F_S field.
	I2C_CCR_F_S_Msk  = 0x8000 // Bit mask of F_S field.
	I2C_CCR_F_S      = 0x8000 // Bit F_S.
	I2C_CCR_DUTY_Pos = 0xe    // Position of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000 // Bit mask of DUTY field.
	I2C_CCR_DUTY     = 0x4000 // Bit DUTY.
	I2C_CCR_CCR_Pos  = 0x0    // Position of CCR field.
	I2C_CCR_CCR_Msk  = 0xfff  // Bit mask of CCR field.

	// TRISE: TRISE
	I2C_TRISE_TRISE_Pos = 0x0  // Position of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f // Bit mask of TRISE field.
)

// Bitfields for LCD: Liquid crystal display controller
const (
	// CR: control register
	LCD_CR_MUX_SEG_Pos = 0x7  // Position of MUX_SEG field.
	LCD_CR_MUX_SEG_Msk = 0x80 // Bit mask of MUX_SEG field.
	LCD_CR_MUX_SEG     = 0x80 // Bit MUX_SEG.
	LCD_CR_BIAS_Pos    = 0x5  // Position of BIAS field.
	LCD_CR_BIAS_Msk    = 0x60 // Bit mask of BIAS field.
	LCD_CR_DUTY_Pos    = 0x2  // Position of DUTY field.
	LCD_CR_DUTY_Msk    = 0x1c // Bit mask of DUTY field.
	LCD_CR_VSEL_Pos    = 0x1  // Position of VSEL field.
	LCD_CR_VSEL_Msk    = 0x2  // Bit mask of VSEL field.
	LCD_CR_VSEL        = 0x2  // Bit VSEL.
	LCD_CR_LCDEN_Pos   = 0x0  // Position of LCDEN field.
	LCD_CR_LCDEN_Msk   = 0x1  // Bit mask of LCDEN field.
	LCD_CR_LCDEN       = 0x1  // Bit LCDEN.

	// FCR: frame control register
	LCD_FCR_PS_Pos     = 0x16      // Position of PS field.
	LCD_FCR_PS_Msk     = 0x3c00000 // Bit mask of PS field.
	LCD_FCR_DIV_Pos    = 0x12      // Position of DIV field.
	LCD_FCR_DIV_Msk    = 0x3c0000  // Bit mask of DIV field.
	LCD_FCR_BLINK_Pos  = 0x10      // Position of BLINK field.
	LCD_FCR_BLINK_Msk  = 0x30000   // Bit mask of BLINK field.
	LCD_FCR_BLINKF_Pos = 0xd       // Position of BLINKF field.
	LCD_FCR_BLINKF_Msk = 0xe000    // Bit mask of BLINKF field.
	LCD_FCR_CC_Pos     = 0xa       // Position of CC field.
	LCD_FCR_CC_Msk     = 0x1c00    // Bit mask of CC field.
	LCD_FCR_DEAD_Pos   = 0x7       // Position of DEAD field.
	LCD_FCR_DEAD_Msk   = 0x380     // Bit mask of DEAD field.
	LCD_FCR_PON_Pos    = 0x4       // Position of PON field.
	LCD_FCR_PON_Msk    = 0x70      // Bit mask of PON field.
	LCD_FCR_UDDIE_Pos  = 0x3       // Position of UDDIE field.
	LCD_FCR_UDDIE_Msk  = 0x8       // Bit mask of UDDIE field.
	LCD_FCR_UDDIE      = 0x8       // Bit UDDIE.
	LCD_FCR_SOFIE_Pos  = 0x1       // Position of SOFIE field.
	LCD_FCR_SOFIE_Msk  = 0x2       // Bit mask of SOFIE field.
	LCD_FCR_SOFIE      = 0x2       // Bit SOFIE.
	LCD_FCR_HD_Pos     = 0x0       // Position of HD field.
	LCD_FCR_HD_Msk     = 0x1       // Bit mask of HD field.
	LCD_FCR_HD         = 0x1       // Bit HD.

	// SR: status register
	LCD_SR_FCRSF_Pos = 0x5  // Position of FCRSF field.
	LCD_SR_FCRSF_Msk = 0x20 // Bit mask of FCRSF field.
	LCD_SR_FCRSF     = 0x20 // Bit FCRSF.
	LCD_SR_RDY_Pos   = 0x4  // Position of RDY field.
	LCD_SR_RDY_Msk   = 0x10 // Bit mask of RDY field.
	LCD_SR_RDY       = 0x10 // Bit RDY.
	LCD_SR_UDD_Pos   = 0x3  // Position of UDD field.
	LCD_SR_UDD_Msk   = 0x8  // Bit mask of UDD field.
	LCD_SR_UDD       = 0x8  // Bit UDD.
	LCD_SR_UDR_Pos   = 0x2  // Position of UDR field.
	LCD_SR_UDR_Msk   = 0x4  // Bit mask of UDR field.
	LCD_SR_UDR       = 0x4  // Bit UDR.
	LCD_SR_SOF_Pos   = 0x1  // Position of SOF field.
	LCD_SR_SOF_Msk   = 0x2  // Bit mask of SOF field.
	LCD_SR_SOF       = 0x2  // Bit SOF.
	LCD_SR_ENS_Pos   = 0x0  // Position of ENS field.
	LCD_SR_ENS_Msk   = 0x1  // Bit mask of ENS field.
	LCD_SR_ENS       = 0x1  // Bit ENS.

	// CLR: clear register
	LCD_CLR_UDDC_Pos = 0x3 // Position of UDDC field.
	LCD_CLR_UDDC_Msk = 0x8 // Bit mask of UDDC field.
	LCD_CLR_UDDC     = 0x8 // Bit UDDC.
	LCD_CLR_SOFC_Pos = 0x1 // Position of SOFC field.
	LCD_CLR_SOFC_Msk = 0x2 // Bit mask of SOFC field.
	LCD_CLR_SOFC     = 0x2 // Bit SOFC.

	// RAM_COM0: display memory
	LCD_RAM_COM0_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM0_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM0_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM0_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM0_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM0_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM0_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM0_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM0_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM0_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM0_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM0_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM0_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM0_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM0_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM0_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM0_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM0_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM0_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM0_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM0_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM0_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM0_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM0_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM0_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM0_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM0_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM0_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM0_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM0_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM0_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM0_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM0_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM0_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM0_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM0_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM0_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM0_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM0_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM0_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM0_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM0_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM0_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM0_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM0_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM0_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM0_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM0_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM0_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM0_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM0_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM0_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM0_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM0_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM0_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM0_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM0_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM0_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM0_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM0_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM0_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM0_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM0_S11     = 0x800      // Bit S11.
	LCD_RAM_COM0_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM0_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM0_S10     = 0x400      // Bit S10.
	LCD_RAM_COM0_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM0_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM0_S09     = 0x200      // Bit S09.
	LCD_RAM_COM0_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM0_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM0_S08     = 0x100      // Bit S08.
	LCD_RAM_COM0_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM0_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM0_S07     = 0x80       // Bit S07.
	LCD_RAM_COM0_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM0_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM0_S06     = 0x40       // Bit S06.
	LCD_RAM_COM0_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM0_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM0_S05     = 0x20       // Bit S05.
	LCD_RAM_COM0_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM0_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM0_S04     = 0x10       // Bit S04.
	LCD_RAM_COM0_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM0_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM0_S03     = 0x8        // Bit S03.
	LCD_RAM_COM0_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM0_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM0_S02     = 0x4        // Bit S02.
	LCD_RAM_COM0_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM0_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM0_S01     = 0x2        // Bit S01.
	LCD_RAM_COM0_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM0_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM0_S00     = 0x1        // Bit S00.

	// RAM_COM1: display memory
	LCD_RAM_COM1_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM1_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM1_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM1_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM1_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM1_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM1_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM1_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM1_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM1_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM1_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM1_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM1_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM1_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM1_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM1_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM1_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM1_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM1_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM1_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM1_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM1_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM1_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM1_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM1_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM1_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM1_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM1_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM1_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM1_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM1_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM1_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM1_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM1_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM1_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM1_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM1_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM1_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM1_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM1_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM1_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM1_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM1_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM1_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM1_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM1_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM1_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM1_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM1_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM1_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM1_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM1_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM1_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM1_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM1_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM1_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM1_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM1_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM1_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM1_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM1_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM1_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM1_S11     = 0x800      // Bit S11.
	LCD_RAM_COM1_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM1_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM1_S10     = 0x400      // Bit S10.
	LCD_RAM_COM1_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM1_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM1_S09     = 0x200      // Bit S09.
	LCD_RAM_COM1_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM1_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM1_S08     = 0x100      // Bit S08.
	LCD_RAM_COM1_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM1_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM1_S07     = 0x80       // Bit S07.
	LCD_RAM_COM1_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM1_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM1_S06     = 0x40       // Bit S06.
	LCD_RAM_COM1_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM1_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM1_S05     = 0x20       // Bit S05.
	LCD_RAM_COM1_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM1_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM1_S04     = 0x10       // Bit S04.
	LCD_RAM_COM1_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM1_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM1_S03     = 0x8        // Bit S03.
	LCD_RAM_COM1_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM1_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM1_S02     = 0x4        // Bit S02.
	LCD_RAM_COM1_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM1_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM1_S01     = 0x2        // Bit S01.
	LCD_RAM_COM1_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM1_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM1_S00     = 0x1        // Bit S00.

	// RAM_COM2: display memory
	LCD_RAM_COM2_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM2_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM2_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM2_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM2_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM2_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM2_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM2_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM2_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM2_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM2_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM2_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM2_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM2_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM2_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM2_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM2_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM2_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM2_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM2_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM2_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM2_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM2_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM2_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM2_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM2_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM2_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM2_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM2_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM2_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM2_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM2_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM2_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM2_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM2_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM2_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM2_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM2_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM2_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM2_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM2_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM2_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM2_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM2_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM2_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM2_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM2_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM2_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM2_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM2_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM2_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM2_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM2_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM2_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM2_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM2_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM2_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM2_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM2_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM2_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM2_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM2_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM2_S11     = 0x800      // Bit S11.
	LCD_RAM_COM2_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM2_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM2_S10     = 0x400      // Bit S10.
	LCD_RAM_COM2_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM2_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM2_S09     = 0x200      // Bit S09.
	LCD_RAM_COM2_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM2_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM2_S08     = 0x100      // Bit S08.
	LCD_RAM_COM2_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM2_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM2_S07     = 0x80       // Bit S07.
	LCD_RAM_COM2_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM2_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM2_S06     = 0x40       // Bit S06.
	LCD_RAM_COM2_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM2_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM2_S05     = 0x20       // Bit S05.
	LCD_RAM_COM2_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM2_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM2_S04     = 0x10       // Bit S04.
	LCD_RAM_COM2_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM2_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM2_S03     = 0x8        // Bit S03.
	LCD_RAM_COM2_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM2_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM2_S02     = 0x4        // Bit S02.
	LCD_RAM_COM2_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM2_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM2_S01     = 0x2        // Bit S01.
	LCD_RAM_COM2_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM2_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM2_S00     = 0x1        // Bit S00.

	// RAM_COM3: display memory
	LCD_RAM_COM3_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM3_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM3_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM3_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM3_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM3_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM3_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM3_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM3_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM3_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM3_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM3_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM3_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM3_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM3_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM3_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM3_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM3_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM3_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM3_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM3_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM3_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM3_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM3_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM3_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM3_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM3_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM3_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM3_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM3_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM3_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM3_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM3_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM3_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM3_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM3_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM3_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM3_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM3_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM3_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM3_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM3_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM3_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM3_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM3_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM3_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM3_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM3_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM3_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM3_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM3_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM3_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM3_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM3_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM3_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM3_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM3_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM3_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM3_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM3_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM3_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM3_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM3_S11     = 0x800      // Bit S11.
	LCD_RAM_COM3_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM3_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM3_S10     = 0x400      // Bit S10.
	LCD_RAM_COM3_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM3_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM3_S09     = 0x200      // Bit S09.
	LCD_RAM_COM3_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM3_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM3_S08     = 0x100      // Bit S08.
	LCD_RAM_COM3_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM3_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM3_S07     = 0x80       // Bit S07.
	LCD_RAM_COM3_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM3_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM3_S06     = 0x40       // Bit S06.
	LCD_RAM_COM3_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM3_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM3_S05     = 0x20       // Bit S05.
	LCD_RAM_COM3_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM3_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM3_S04     = 0x10       // Bit S04.
	LCD_RAM_COM3_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM3_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM3_S03     = 0x8        // Bit S03.
	LCD_RAM_COM3_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM3_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM3_S02     = 0x4        // Bit S02.
	LCD_RAM_COM3_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM3_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM3_S01     = 0x2        // Bit S01.
	LCD_RAM_COM3_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM3_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM3_S00     = 0x1        // Bit S00.

	// RAM_COM4: display memory
	LCD_RAM_COM4_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM4_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM4_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM4_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM4_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM4_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM4_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM4_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM4_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM4_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM4_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM4_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM4_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM4_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM4_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM4_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM4_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM4_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM4_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM4_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM4_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM4_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM4_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM4_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM4_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM4_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM4_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM4_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM4_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM4_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM4_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM4_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM4_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM4_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM4_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM4_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM4_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM4_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM4_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM4_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM4_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM4_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM4_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM4_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM4_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM4_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM4_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM4_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM4_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM4_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM4_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM4_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM4_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM4_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM4_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM4_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM4_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM4_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM4_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM4_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM4_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM4_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM4_S11     = 0x800      // Bit S11.
	LCD_RAM_COM4_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM4_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM4_S10     = 0x400      // Bit S10.
	LCD_RAM_COM4_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM4_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM4_S09     = 0x200      // Bit S09.
	LCD_RAM_COM4_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM4_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM4_S08     = 0x100      // Bit S08.
	LCD_RAM_COM4_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM4_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM4_S07     = 0x80       // Bit S07.
	LCD_RAM_COM4_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM4_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM4_S06     = 0x40       // Bit S06.
	LCD_RAM_COM4_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM4_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM4_S05     = 0x20       // Bit S05.
	LCD_RAM_COM4_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM4_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM4_S04     = 0x10       // Bit S04.
	LCD_RAM_COM4_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM4_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM4_S03     = 0x8        // Bit S03.
	LCD_RAM_COM4_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM4_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM4_S02     = 0x4        // Bit S02.
	LCD_RAM_COM4_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM4_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM4_S01     = 0x2        // Bit S01.
	LCD_RAM_COM4_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM4_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM4_S00     = 0x1        // Bit S00.

	// RAM_COM5: display memory
	LCD_RAM_COM5_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM5_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM5_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM5_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM5_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM5_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM5_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM5_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM5_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM5_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM5_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM5_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM5_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM5_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM5_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM5_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM5_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM5_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM5_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM5_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM5_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM5_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM5_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM5_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM5_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM5_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM5_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM5_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM5_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM5_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM5_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM5_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM5_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM5_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM5_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM5_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM5_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM5_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM5_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM5_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM5_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM5_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM5_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM5_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM5_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM5_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM5_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM5_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM5_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM5_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM5_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM5_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM5_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM5_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM5_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM5_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM5_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM5_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM5_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM5_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM5_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM5_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM5_S11     = 0x800      // Bit S11.
	LCD_RAM_COM5_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM5_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM5_S10     = 0x400      // Bit S10.
	LCD_RAM_COM5_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM5_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM5_S09     = 0x200      // Bit S09.
	LCD_RAM_COM5_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM5_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM5_S08     = 0x100      // Bit S08.
	LCD_RAM_COM5_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM5_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM5_S07     = 0x80       // Bit S07.
	LCD_RAM_COM5_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM5_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM5_S06     = 0x40       // Bit S06.
	LCD_RAM_COM5_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM5_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM5_S05     = 0x20       // Bit S05.
	LCD_RAM_COM5_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM5_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM5_S04     = 0x10       // Bit S04.
	LCD_RAM_COM5_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM5_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM5_S03     = 0x8        // Bit S03.
	LCD_RAM_COM5_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM5_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM5_S02     = 0x4        // Bit S02.
	LCD_RAM_COM5_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM5_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM5_S01     = 0x2        // Bit S01.
	LCD_RAM_COM5_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM5_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM5_S00     = 0x1        // Bit S00.

	// RAM_COM6: display memory
	LCD_RAM_COM6_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM6_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM6_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM6_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM6_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM6_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM6_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM6_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM6_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM6_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM6_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM6_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM6_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM6_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM6_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM6_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM6_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM6_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM6_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM6_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM6_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM6_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM6_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM6_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM6_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM6_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM6_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM6_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM6_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM6_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM6_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM6_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM6_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM6_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM6_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM6_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM6_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM6_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM6_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM6_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM6_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM6_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM6_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM6_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM6_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM6_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM6_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM6_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM6_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM6_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM6_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM6_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM6_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM6_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM6_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM6_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM6_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM6_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM6_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM6_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM6_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM6_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM6_S11     = 0x800      // Bit S11.
	LCD_RAM_COM6_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM6_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM6_S10     = 0x400      // Bit S10.
	LCD_RAM_COM6_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM6_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM6_S09     = 0x200      // Bit S09.
	LCD_RAM_COM6_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM6_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM6_S08     = 0x100      // Bit S08.
	LCD_RAM_COM6_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM6_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM6_S07     = 0x80       // Bit S07.
	LCD_RAM_COM6_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM6_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM6_S06     = 0x40       // Bit S06.
	LCD_RAM_COM6_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM6_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM6_S05     = 0x20       // Bit S05.
	LCD_RAM_COM6_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM6_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM6_S04     = 0x10       // Bit S04.
	LCD_RAM_COM6_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM6_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM6_S03     = 0x8        // Bit S03.
	LCD_RAM_COM6_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM6_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM6_S02     = 0x4        // Bit S02.
	LCD_RAM_COM6_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM6_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM6_S01     = 0x2        // Bit S01.
	LCD_RAM_COM6_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM6_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM6_S00     = 0x1        // Bit S00.

	// RAM_COM7: display memory
	LCD_RAM_COM7_S31_Pos = 0x1f       // Position of S31 field.
	LCD_RAM_COM7_S31_Msk = 0x80000000 // Bit mask of S31 field.
	LCD_RAM_COM7_S31     = 0x80000000 // Bit S31.
	LCD_RAM_COM7_S30_Pos = 0x1e       // Position of S30 field.
	LCD_RAM_COM7_S30_Msk = 0x40000000 // Bit mask of S30 field.
	LCD_RAM_COM7_S30     = 0x40000000 // Bit S30.
	LCD_RAM_COM7_S29_Pos = 0x1d       // Position of S29 field.
	LCD_RAM_COM7_S29_Msk = 0x20000000 // Bit mask of S29 field.
	LCD_RAM_COM7_S29     = 0x20000000 // Bit S29.
	LCD_RAM_COM7_S28_Pos = 0x1c       // Position of S28 field.
	LCD_RAM_COM7_S28_Msk = 0x10000000 // Bit mask of S28 field.
	LCD_RAM_COM7_S28     = 0x10000000 // Bit S28.
	LCD_RAM_COM7_S27_Pos = 0x1b       // Position of S27 field.
	LCD_RAM_COM7_S27_Msk = 0x8000000  // Bit mask of S27 field.
	LCD_RAM_COM7_S27     = 0x8000000  // Bit S27.
	LCD_RAM_COM7_S26_Pos = 0x1a       // Position of S26 field.
	LCD_RAM_COM7_S26_Msk = 0x4000000  // Bit mask of S26 field.
	LCD_RAM_COM7_S26     = 0x4000000  // Bit S26.
	LCD_RAM_COM7_S25_Pos = 0x19       // Position of S25 field.
	LCD_RAM_COM7_S25_Msk = 0x2000000  // Bit mask of S25 field.
	LCD_RAM_COM7_S25     = 0x2000000  // Bit S25.
	LCD_RAM_COM7_S24_Pos = 0x18       // Position of S24 field.
	LCD_RAM_COM7_S24_Msk = 0x1000000  // Bit mask of S24 field.
	LCD_RAM_COM7_S24     = 0x1000000  // Bit S24.
	LCD_RAM_COM7_S23_Pos = 0x17       // Position of S23 field.
	LCD_RAM_COM7_S23_Msk = 0x800000   // Bit mask of S23 field.
	LCD_RAM_COM7_S23     = 0x800000   // Bit S23.
	LCD_RAM_COM7_S22_Pos = 0x16       // Position of S22 field.
	LCD_RAM_COM7_S22_Msk = 0x400000   // Bit mask of S22 field.
	LCD_RAM_COM7_S22     = 0x400000   // Bit S22.
	LCD_RAM_COM7_S21_Pos = 0x15       // Position of S21 field.
	LCD_RAM_COM7_S21_Msk = 0x200000   // Bit mask of S21 field.
	LCD_RAM_COM7_S21     = 0x200000   // Bit S21.
	LCD_RAM_COM7_S20_Pos = 0x14       // Position of S20 field.
	LCD_RAM_COM7_S20_Msk = 0x100000   // Bit mask of S20 field.
	LCD_RAM_COM7_S20     = 0x100000   // Bit S20.
	LCD_RAM_COM7_S19_Pos = 0x13       // Position of S19 field.
	LCD_RAM_COM7_S19_Msk = 0x80000    // Bit mask of S19 field.
	LCD_RAM_COM7_S19     = 0x80000    // Bit S19.
	LCD_RAM_COM7_S18_Pos = 0x12       // Position of S18 field.
	LCD_RAM_COM7_S18_Msk = 0x40000    // Bit mask of S18 field.
	LCD_RAM_COM7_S18     = 0x40000    // Bit S18.
	LCD_RAM_COM7_S17_Pos = 0x11       // Position of S17 field.
	LCD_RAM_COM7_S17_Msk = 0x20000    // Bit mask of S17 field.
	LCD_RAM_COM7_S17     = 0x20000    // Bit S17.
	LCD_RAM_COM7_S16_Pos = 0x10       // Position of S16 field.
	LCD_RAM_COM7_S16_Msk = 0x10000    // Bit mask of S16 field.
	LCD_RAM_COM7_S16     = 0x10000    // Bit S16.
	LCD_RAM_COM7_S15_Pos = 0xf        // Position of S15 field.
	LCD_RAM_COM7_S15_Msk = 0x8000     // Bit mask of S15 field.
	LCD_RAM_COM7_S15     = 0x8000     // Bit S15.
	LCD_RAM_COM7_S14_Pos = 0xe        // Position of S14 field.
	LCD_RAM_COM7_S14_Msk = 0x4000     // Bit mask of S14 field.
	LCD_RAM_COM7_S14     = 0x4000     // Bit S14.
	LCD_RAM_COM7_S13_Pos = 0xd        // Position of S13 field.
	LCD_RAM_COM7_S13_Msk = 0x2000     // Bit mask of S13 field.
	LCD_RAM_COM7_S13     = 0x2000     // Bit S13.
	LCD_RAM_COM7_S12_Pos = 0xc        // Position of S12 field.
	LCD_RAM_COM7_S12_Msk = 0x1000     // Bit mask of S12 field.
	LCD_RAM_COM7_S12     = 0x1000     // Bit S12.
	LCD_RAM_COM7_S11_Pos = 0xb        // Position of S11 field.
	LCD_RAM_COM7_S11_Msk = 0x800      // Bit mask of S11 field.
	LCD_RAM_COM7_S11     = 0x800      // Bit S11.
	LCD_RAM_COM7_S10_Pos = 0xa        // Position of S10 field.
	LCD_RAM_COM7_S10_Msk = 0x400      // Bit mask of S10 field.
	LCD_RAM_COM7_S10     = 0x400      // Bit S10.
	LCD_RAM_COM7_S09_Pos = 0x9        // Position of S09 field.
	LCD_RAM_COM7_S09_Msk = 0x200      // Bit mask of S09 field.
	LCD_RAM_COM7_S09     = 0x200      // Bit S09.
	LCD_RAM_COM7_S08_Pos = 0x8        // Position of S08 field.
	LCD_RAM_COM7_S08_Msk = 0x100      // Bit mask of S08 field.
	LCD_RAM_COM7_S08     = 0x100      // Bit S08.
	LCD_RAM_COM7_S07_Pos = 0x7        // Position of S07 field.
	LCD_RAM_COM7_S07_Msk = 0x80       // Bit mask of S07 field.
	LCD_RAM_COM7_S07     = 0x80       // Bit S07.
	LCD_RAM_COM7_S06_Pos = 0x6        // Position of S06 field.
	LCD_RAM_COM7_S06_Msk = 0x40       // Bit mask of S06 field.
	LCD_RAM_COM7_S06     = 0x40       // Bit S06.
	LCD_RAM_COM7_S05_Pos = 0x5        // Position of S05 field.
	LCD_RAM_COM7_S05_Msk = 0x20       // Bit mask of S05 field.
	LCD_RAM_COM7_S05     = 0x20       // Bit S05.
	LCD_RAM_COM7_S04_Pos = 0x4        // Position of S04 field.
	LCD_RAM_COM7_S04_Msk = 0x10       // Bit mask of S04 field.
	LCD_RAM_COM7_S04     = 0x10       // Bit S04.
	LCD_RAM_COM7_S03_Pos = 0x3        // Position of S03 field.
	LCD_RAM_COM7_S03_Msk = 0x8        // Bit mask of S03 field.
	LCD_RAM_COM7_S03     = 0x8        // Bit S03.
	LCD_RAM_COM7_S02_Pos = 0x2        // Position of S02 field.
	LCD_RAM_COM7_S02_Msk = 0x4        // Bit mask of S02 field.
	LCD_RAM_COM7_S02     = 0x4        // Bit S02.
	LCD_RAM_COM7_S01_Pos = 0x1        // Position of S01 field.
	LCD_RAM_COM7_S01_Msk = 0x2        // Bit mask of S01 field.
	LCD_RAM_COM7_S01     = 0x2        // Bit S01.
	LCD_RAM_COM7_S00_Pos = 0x0        // Position of S00 field.
	LCD_RAM_COM7_S00_Msk = 0x1        // Bit mask of S00 field.
	LCD_RAM_COM7_S00     = 0x1        // Bit S00.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ICTR: Interrupt Controller Type           Register
	NVIC_ICTR_INTLINESNUM_Pos = 0x0 // Position of INTLINESNUM field.
	NVIC_ICTR_INTLINESNUM_Msk = 0xf // Bit mask of INTLINESNUM field.

	// ISER0: Interrupt Set-Enable Register
	NVIC_ISER0_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER1: Interrupt Set-Enable Register
	NVIC_ISER1_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER0: Interrupt Clear-Enable           Register
	NVIC_ICER0_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER1: Interrupt Clear-Enable           Register
	NVIC_ICER1_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR0: Interrupt Set-Pending Register
	NVIC_ISPR0_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR1: Interrupt Set-Pending Register
	NVIC_ISPR1_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR0: Interrupt Clear-Pending           Register
	NVIC_ICPR0_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR1: Interrupt Clear-Pending           Register
	NVIC_ICPR1_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IABR0: Interrupt Active Bit Register
	NVIC_IABR0_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR1: Interrupt Active Bit Register
	NVIC_IABR1_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IPR0: Interrupt Priority Register
	NVIC_IPR0_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR1: Interrupt Priority Register
	NVIC_IPR1_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR2: Interrupt Priority Register
	NVIC_IPR2_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR3: Interrupt Priority Register
	NVIC_IPR3_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR4: Interrupt Priority Register
	NVIC_IPR4_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR5: Interrupt Priority Register
	NVIC_IPR5_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR6: Interrupt Priority Register
	NVIC_IPR6_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR7: Interrupt Priority Register
	NVIC_IPR7_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR8: Interrupt Priority Register
	NVIC_IPR8_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR9: Interrupt Priority Register
	NVIC_IPR9_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR10: Interrupt Priority Register
	NVIC_IPR10_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR11: Interrupt Priority Register
	NVIC_IPR11_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR12: Interrupt Priority Register
	NVIC_IPR12_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR13: Interrupt Priority Register
	NVIC_IPR13_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// STIR: Software Triggered Interrupt           Register
	NVIC_STIR_INTID_Pos = 0x0   // Position of INTID field.
	NVIC_STIR_INTID_Msk = 0x1ff // Bit mask of INTID field.
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	PWR_CR_LPRUN_Pos  = 0xe    // Position of LPRUN field.
	PWR_CR_LPRUN_Msk  = 0x4000 // Bit mask of LPRUN field.
	PWR_CR_LPRUN      = 0x4000 // Bit LPRUN.
	PWR_CR_VOS_Pos    = 0xb    // Position of VOS field.
	PWR_CR_VOS_Msk    = 0x1800 // Bit mask of VOS field.
	PWR_CR_FWU_Pos    = 0xa    // Position of FWU field.
	PWR_CR_FWU_Msk    = 0x400  // Bit mask of FWU field.
	PWR_CR_FWU        = 0x400  // Bit FWU.
	PWR_CR_ULP_Pos    = 0x9    // Position of ULP field.
	PWR_CR_ULP_Msk    = 0x200  // Bit mask of ULP field.
	PWR_CR_ULP        = 0x200  // Bit ULP.
	PWR_CR_DBP_Pos    = 0x8    // Position of DBP field.
	PWR_CR_DBP_Msk    = 0x100  // Bit mask of DBP field.
	PWR_CR_DBP        = 0x100  // Bit DBP.
	PWR_CR_PLS_Pos    = 0x5    // Position of PLS field.
	PWR_CR_PLS_Msk    = 0xe0   // Bit mask of PLS field.
	PWR_CR_PVDE_Pos   = 0x4    // Position of PVDE field.
	PWR_CR_PVDE_Msk   = 0x10   // Bit mask of PVDE field.
	PWR_CR_PVDE       = 0x10   // Bit PVDE.
	PWR_CR_CSBF_Pos   = 0x3    // Position of CSBF field.
	PWR_CR_CSBF_Msk   = 0x8    // Bit mask of CSBF field.
	PWR_CR_CSBF       = 0x8    // Bit CSBF.
	PWR_CR_CWUF_Pos   = 0x2    // Position of CWUF field.
	PWR_CR_CWUF_Msk   = 0x4    // Bit mask of CWUF field.
	PWR_CR_CWUF       = 0x4    // Bit CWUF.
	PWR_CR_PDDS_Pos   = 0x1    // Position of PDDS field.
	PWR_CR_PDDS_Msk   = 0x2    // Bit mask of PDDS field.
	PWR_CR_PDDS       = 0x2    // Bit PDDS.
	PWR_CR_LPSDSR_Pos = 0x0    // Position of LPSDSR field.
	PWR_CR_LPSDSR_Msk = 0x1    // Bit mask of LPSDSR field.
	PWR_CR_LPSDSR     = 0x1    // Bit LPSDSR.

	// CSR: power control/status register
	PWR_CSR_EWUP3_Pos       = 0xa   // Position of EWUP3 field.
	PWR_CSR_EWUP3_Msk       = 0x400 // Bit mask of EWUP3 field.
	PWR_CSR_EWUP3           = 0x400 // Bit EWUP3.
	PWR_CSR_EWUP2_Pos       = 0x9   // Position of EWUP2 field.
	PWR_CSR_EWUP2_Msk       = 0x200 // Bit mask of EWUP2 field.
	PWR_CSR_EWUP2           = 0x200 // Bit EWUP2.
	PWR_CSR_EWUP1_Pos       = 0x8   // Position of EWUP1 field.
	PWR_CSR_EWUP1_Msk       = 0x100 // Bit mask of EWUP1 field.
	PWR_CSR_EWUP1           = 0x100 // Bit EWUP1.
	PWR_CSR_REGLPF_Pos      = 0x5   // Position of REGLPF field.
	PWR_CSR_REGLPF_Msk      = 0x20  // Bit mask of REGLPF field.
	PWR_CSR_REGLPF          = 0x20  // Bit REGLPF.
	PWR_CSR_VOSF_Pos        = 0x4   // Position of VOSF field.
	PWR_CSR_VOSF_Msk        = 0x10  // Bit mask of VOSF field.
	PWR_CSR_VOSF            = 0x10  // Bit VOSF.
	PWR_CSR_VREFINTRDYF_Pos = 0x3   // Position of VREFINTRDYF field.
	PWR_CSR_VREFINTRDYF_Msk = 0x8   // Bit mask of VREFINTRDYF field.
	PWR_CSR_VREFINTRDYF     = 0x8   // Bit VREFINTRDYF.
	PWR_CSR_PVDO_Pos        = 0x2   // Position of PVDO field.
	PWR_CSR_PVDO_Msk        = 0x4   // Bit mask of PVDO field.
	PWR_CSR_PVDO            = 0x4   // Bit PVDO.
	PWR_CSR_SBF_Pos         = 0x1   // Position of SBF field.
	PWR_CSR_SBF_Msk         = 0x2   // Bit mask of SBF field.
	PWR_CSR_SBF             = 0x2   // Bit SBF.
	PWR_CSR_WUF_Pos         = 0x0   // Position of WUF field.
	PWR_CSR_WUF_Msk         = 0x1   // Bit mask of WUF field.
	PWR_CSR_WUF             = 0x1   // Bit WUF.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_COE_Pos     = 0x17     // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000 // Bit mask of COE field.
	RTC_CR_COE         = 0x800000 // Bit COE.
	RTC_CR_OSEL_Pos    = 0x15     // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000 // Bit mask of OSEL field.
	RTC_CR_POL_Pos     = 0x14     // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000 // Bit mask of POL field.
	RTC_CR_POL         = 0x100000 // Bit POL.
	RTC_CR_COSEL_Pos   = 0x13     // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000  // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000  // Bit COSEL.
	RTC_CR_BKP_Pos     = 0x12     // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000  // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000  // Bit BKP.
	RTC_CR_SUB1H_Pos   = 0x11     // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000  // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000  // Bit SUB1H.
	RTC_CR_ADD1H_Pos   = 0x10     // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000  // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000  // Bit ADD1H.
	RTC_CR_TSIE_Pos    = 0xf      // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000   // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000   // Bit TSIE.
	RTC_CR_WUTIE_Pos   = 0xe      // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000   // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000   // Bit WUTIE.
	RTC_CR_ALRBIE_Pos  = 0xd      // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000   // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000   // Bit ALRBIE.
	RTC_CR_ALRAIE_Pos  = 0xc      // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000   // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000   // Bit ALRAIE.
	RTC_CR_TSE_Pos     = 0xb      // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800    // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800    // Bit TSE.
	RTC_CR_WUTE_Pos    = 0xa      // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400    // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400    // Bit WUTE.
	RTC_CR_ALRBE_Pos   = 0x9      // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200    // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200    // Bit ALRBE.
	RTC_CR_ALRAE_Pos   = 0x8      // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100    // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100    // Bit ALRAE.
	RTC_CR_DCE_Pos     = 0x7      // Position of DCE field.
	RTC_CR_DCE_Msk     = 0x80     // Bit mask of DCE field.
	RTC_CR_DCE         = 0x80     // Bit DCE.
	RTC_CR_FMT_Pos     = 0x6      // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40     // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40     // Bit FMT.
	RTC_CR_BYPSHAD_Pos = 0x5      // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20     // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20     // Bit BYPSHAD.
	RTC_CR_REFCKON_Pos = 0x4      // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10     // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10     // Bit REFCKON.
	RTC_CR_TSEDGE_Pos  = 0x3      // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8      // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8      // Bit TSEDGE.
	RTC_CR_WCKSEL_Pos  = 0x0      // Position of WCKSEL field.
	RTC_CR_WCKSEL_Msk  = 0x7      // Bit mask of WCKSEL field.

	// ISR: initialization and status           register
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.
	RTC_ISR_TAMP3F_Pos  = 0xf     // Position of TAMP3F field.
	RTC_ISR_TAMP3F_Msk  = 0x8000  // Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F      = 0x8000  // Bit TAMP3F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_WUTF_Pos    = 0xa     // Position of WUTF field.
	RTC_ISR_WUTF_Msk    = 0x400   // Bit mask of WUTF field.
	RTC_ISR_WUTF        = 0x400   // Bit WUTF.
	RTC_ISR_ALRBF_Pos   = 0x9     // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk   = 0x200   // Bit mask of ALRBF field.
	RTC_ISR_ALRBF       = 0x200   // Bit ALRBF.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ISR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ISR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// CALIBR: calibration register
	RTC_CALIBR_DCS_Pos = 0x7  // Position of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80 // Bit mask of DCS field.
	RTC_CALIBR_DCS     = 0x80 // Bit DCS.
	RTC_CALIBR_DC_Pos  = 0x0  // Position of DC field.
	RTC_CALIBR_DC_Msk  = 0x1f // Bit mask of DC field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: TSTR
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAFCR: tamper and alternate function configuration           register
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12    // Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000 // Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE     = 0x40000 // Bit ALARMOUTTYPE.
	RTC_TAFCR_TAMPPUDIS_Pos    = 0xf     // Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk    = 0x8000  // Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS        = 0x8000  // Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPRCH_Pos     = 0xd     // Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk     = 0x6000  // Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPFLT_Pos      = 0xb     // Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk      = 0x1800  // Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFREQ_Pos     = 0x8     // Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk     = 0x700   // Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPTS_Pos       = 0x7     // Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk       = 0x80    // Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS           = 0x80    // Bit TAMPTS.
	RTC_TAFCR_TAMP3TRG_Pos     = 0x6     // Position of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG_Msk     = 0x40    // Bit mask of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG         = 0x40    // Bit TAMP3TRG.
	RTC_TAFCR_TAMP3E_Pos       = 0x5     // Position of TAMP3E field.
	RTC_TAFCR_TAMP3E_Msk       = 0x20    // Bit mask of TAMP3E field.
	RTC_TAFCR_TAMP3E           = 0x20    // Bit TAMP3E.
	RTC_TAFCR_TAMP2TRG_Pos     = 0x4     // Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk     = 0x10    // Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG         = 0x10    // Bit TAMP2TRG.
	RTC_TAFCR_TAMP2E_Pos       = 0x3     // Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk       = 0x8     // Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E           = 0x8     // Bit TAMP2E.
	RTC_TAFCR_TAMPIE_Pos       = 0x2     // Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk       = 0x4     // Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE           = 0x4     // Bit TAMPIE.
	RTC_TAFCR_TAMP1ETRG_Pos    = 0x1     // Position of TAMP1ETRG field.
	RTC_TAFCR_TAMP1ETRG_Msk    = 0x2     // Bit mask of TAMP1ETRG field.
	RTC_TAFCR_TAMP1ETRG        = 0x2     // Bit TAMP1ETRG.
	RTC_TAFCR_TAMP1E_Pos       = 0x0     // Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk       = 0x1     // Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E           = 0x1     // Bit TAMP1E.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP5R: backup register
	RTC_BKP5R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP6R: backup register
	RTC_BKP6R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP7R: backup register
	RTC_BKP7R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP8R: backup register
	RTC_BKP8R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP9R: backup register
	RTC_BKP9R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP10R: backup register
	RTC_BKP10R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP11R: backup register
	RTC_BKP11R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP12R: backup register
	RTC_BKP12R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP13R: backup register
	RTC_BKP13R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP14R: backup register
	RTC_BKP14R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP15R: backup register
	RTC_BKP15R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP16R: backup register
	RTC_BKP16R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP17R: backup register
	RTC_BKP17R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP18R: backup register
	RTC_BKP18R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP19R: backup register
	RTC_BKP19R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP20R: backup register
	RTC_BKP20R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP20R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP21R: backup register
	RTC_BKP21R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP21R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP22R: backup register
	RTC_BKP22R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP22R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP23R: backup register
	RTC_BKP23R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP23R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP24R: backup register
	RTC_BKP24R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP24R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP25R: backup register
	RTC_BKP25R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP25R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP26R: backup register
	RTC_BKP26R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP26R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP27R: backup register
	RTC_BKP27R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP27R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP28R: backup register
	RTC_BKP28R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP28R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP29R: backup register
	RTC_BKP29R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP29R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP30R: backup register
	RTC_BKP30R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP30R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP31R: backup register
	RTC_BKP31R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP31R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_RTCPRE1_Pos = 0x1e       // Position of RTCPRE1 field.
	RCC_CR_RTCPRE1_Msk = 0x40000000 // Bit mask of RTCPRE1 field.
	RCC_CR_RTCPRE1     = 0x40000000 // Bit RTCPRE1.
	RCC_CR_RTCPRE0_Pos = 0x1d       // Position of RTCPRE0 field.
	RCC_CR_RTCPRE0_Msk = 0x20000000 // Bit mask of RTCPRE0 field.
	RCC_CR_RTCPRE0     = 0x20000000 // Bit RTCPRE0.
	RCC_CR_CSSON_Pos   = 0x1c       // Position of CSSON field.
	RCC_CR_CSSON_Msk   = 0x10000000 // Bit mask of CSSON field.
	RCC_CR_CSSON       = 0x10000000 // Bit CSSON.
	RCC_CR_PLLRDY_Pos  = 0x19       // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk  = 0x2000000  // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY      = 0x2000000  // Bit PLLRDY.
	RCC_CR_PLLON_Pos   = 0x18       // Position of PLLON field.
	RCC_CR_PLLON_Msk   = 0x1000000  // Bit mask of PLLON field.
	RCC_CR_PLLON       = 0x1000000  // Bit PLLON.
	RCC_CR_HSEBYP_Pos  = 0x12       // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk  = 0x40000    // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP      = 0x40000    // Bit HSEBYP.
	RCC_CR_HSERDY_Pos  = 0x11       // Position of HSERDY field.
	RCC_CR_HSERDY_Msk  = 0x20000    // Bit mask of HSERDY field.
	RCC_CR_HSERDY      = 0x20000    // Bit HSERDY.
	RCC_CR_HSEON_Pos   = 0x10       // Position of HSEON field.
	RCC_CR_HSEON_Msk   = 0x10000    // Bit mask of HSEON field.
	RCC_CR_HSEON       = 0x10000    // Bit HSEON.
	RCC_CR_MSIRDY_Pos  = 0x9        // Position of MSIRDY field.
	RCC_CR_MSIRDY_Msk  = 0x200      // Bit mask of MSIRDY field.
	RCC_CR_MSIRDY      = 0x200      // Bit MSIRDY.
	RCC_CR_MSION_Pos   = 0x8        // Position of MSION field.
	RCC_CR_MSION_Msk   = 0x100      // Bit mask of MSION field.
	RCC_CR_MSION       = 0x100      // Bit MSION.
	RCC_CR_HSIRDY_Pos  = 0x1        // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk  = 0x2        // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY      = 0x2        // Bit HSIRDY.
	RCC_CR_HSION_Pos   = 0x0        // Position of HSION field.
	RCC_CR_HSION_Msk   = 0x1        // Bit mask of HSION field.
	RCC_CR_HSION       = 0x1        // Bit HSION.

	// ICSCR: Internal clock sources calibration           register
	RCC_ICSCR_MSITRIM_Pos  = 0x18       // Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk  = 0xff000000 // Bit mask of MSITRIM field.
	RCC_ICSCR_MSICAL_Pos   = 0x10       // Position of MSICAL field.
	RCC_ICSCR_MSICAL_Msk   = 0xff0000   // Bit mask of MSICAL field.
	RCC_ICSCR_MSIRANGE_Pos = 0xd        // Position of MSIRANGE field.
	RCC_ICSCR_MSIRANGE_Msk = 0xe000     // Bit mask of MSIRANGE field.
	RCC_ICSCR_HSITRIM_Pos  = 0x8        // Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk  = 0x1f00     // Bit mask of HSITRIM field.
	RCC_ICSCR_HSICAL_Pos   = 0x0        // Position of HSICAL field.
	RCC_ICSCR_HSICAL_Msk   = 0xff       // Bit mask of HSICAL field.

	// CFGR: Clock configuration register
	RCC_CFGR_MCOPRE_Pos = 0x1c       // Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000 // Bit mask of MCOPRE field.
	RCC_CFGR_MCOSEL_Pos = 0x18       // Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0x7000000  // Bit mask of MCOSEL field.
	RCC_CFGR_PLLDIV_Pos = 0x16       // Position of PLLDIV field.
	RCC_CFGR_PLLDIV_Msk = 0xc00000   // Bit mask of PLLDIV field.
	RCC_CFGR_PLLMUL_Pos = 0x12       // Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk = 0x3c0000   // Bit mask of PLLMUL field.
	RCC_CFGR_PLLSRC_Pos = 0x10       // Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk = 0x10000    // Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC     = 0x10000    // Bit PLLSRC.
	RCC_CFGR_PPRE2_Pos  = 0xb        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk  = 0x3800     // Bit mask of PPRE2 field.
	RCC_CFGR_PPRE1_Pos  = 0x8        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk  = 0x700      // Bit mask of PPRE1 field.
	RCC_CFGR_HPRE_Pos   = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk   = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_SWS_Pos    = 0x2        // Position of SWS field.
	RCC_CFGR_SWS_Msk    = 0xc        // Bit mask of SWS field.
	RCC_CFGR_SW_Pos     = 0x0        // Position of SW field.
	RCC_CFGR_SW_Msk     = 0x3        // Bit mask of SW field.

	// CIR: Clock interrupt register
	RCC_CIR_CSSC_Pos     = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk     = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC         = 0x800000 // Bit CSSC.
	RCC_CIR_LSECSSC_Pos  = 0x16     // Position of LSECSSC field.
	RCC_CIR_LSECSSC_Msk  = 0x400000 // Bit mask of LSECSSC field.
	RCC_CIR_LSECSSC      = 0x400000 // Bit LSECSSC.
	RCC_CIR_MSIRDYC_Pos  = 0x15     // Position of MSIRDYC field.
	RCC_CIR_MSIRDYC_Msk  = 0x200000 // Bit mask of MSIRDYC field.
	RCC_CIR_MSIRDYC      = 0x200000 // Bit MSIRDYC.
	RCC_CIR_PLLRDYC_Pos  = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk  = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC      = 0x100000 // Bit PLLRDYC.
	RCC_CIR_HSERDYC_Pos  = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk  = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC      = 0x80000  // Bit HSERDYC.
	RCC_CIR_HSIRDYC_Pos  = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk  = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC      = 0x40000  // Bit HSIRDYC.
	RCC_CIR_LSERDYC_Pos  = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk  = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC      = 0x20000  // Bit LSERDYC.
	RCC_CIR_LSIRDYC_Pos  = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk  = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC      = 0x10000  // Bit LSIRDYC.
	RCC_CIR_LSECSSIE_Pos = 0xe      // Position of LSECSSIE field.
	RCC_CIR_LSECSSIE_Msk = 0x4000   // Bit mask of LSECSSIE field.
	RCC_CIR_LSECSSIE     = 0x4000   // Bit LSECSSIE.
	RCC_CIR_MSIRDYIE_Pos = 0xd      // Position of MSIRDYIE field.
	RCC_CIR_MSIRDYIE_Msk = 0x2000   // Bit mask of MSIRDYIE field.
	RCC_CIR_MSIRDYIE     = 0x2000   // Bit MSIRDYIE.
	RCC_CIR_PLLRDYIE_Pos = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE     = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_HSERDYIE_Pos = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE     = 0x800    // Bit HSERDYIE.
	RCC_CIR_HSIRDYIE_Pos = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE     = 0x400    // Bit HSIRDYIE.
	RCC_CIR_LSERDYIE_Pos = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE     = 0x200    // Bit LSERDYIE.
	RCC_CIR_LSIRDYIE_Pos = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE     = 0x100    // Bit LSIRDYIE.
	RCC_CIR_CSSF_Pos     = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk     = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF         = 0x80     // Bit CSSF.
	RCC_CIR_LSECSSF_Pos  = 0x6      // Position of LSECSSF field.
	RCC_CIR_LSECSSF_Msk  = 0x40     // Bit mask of LSECSSF field.
	RCC_CIR_LSECSSF      = 0x40     // Bit LSECSSF.
	RCC_CIR_MSIRDYF_Pos  = 0x5      // Position of MSIRDYF field.
	RCC_CIR_MSIRDYF_Msk  = 0x20     // Bit mask of MSIRDYF field.
	RCC_CIR_MSIRDYF      = 0x20     // Bit MSIRDYF.
	RCC_CIR_PLLRDYF_Pos  = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk  = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF      = 0x10     // Bit PLLRDYF.
	RCC_CIR_HSERDYF_Pos  = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk  = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF      = 0x8      // Bit HSERDYF.
	RCC_CIR_HSIRDYF_Pos  = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk  = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF      = 0x4      // Bit HSIRDYF.
	RCC_CIR_LSERDYF_Pos  = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk  = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF      = 0x2      // Bit LSERDYF.
	RCC_CIR_LSIRDYF_Pos  = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk  = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF      = 0x1      // Bit LSIRDYF.

	// AHBRSTR: AHB peripheral reset register
	RCC_AHBRSTR_DMA2RST_Pos  = 0x19      // Position of DMA2RST field.
	RCC_AHBRSTR_DMA2RST_Msk  = 0x2000000 // Bit mask of DMA2RST field.
	RCC_AHBRSTR_DMA2RST      = 0x2000000 // Bit DMA2RST.
	RCC_AHBRSTR_DMA1RST_Pos  = 0x18      // Position of DMA1RST field.
	RCC_AHBRSTR_DMA1RST_Msk  = 0x1000000 // Bit mask of DMA1RST field.
	RCC_AHBRSTR_DMA1RST      = 0x1000000 // Bit DMA1RST.
	RCC_AHBRSTR_FLITFRST_Pos = 0xf       // Position of FLITFRST field.
	RCC_AHBRSTR_FLITFRST_Msk = 0x8000    // Bit mask of FLITFRST field.
	RCC_AHBRSTR_FLITFRST     = 0x8000    // Bit FLITFRST.
	RCC_AHBRSTR_CRCRST_Pos   = 0xc       // Position of CRCRST field.
	RCC_AHBRSTR_CRCRST_Msk   = 0x1000    // Bit mask of CRCRST field.
	RCC_AHBRSTR_CRCRST       = 0x1000    // Bit CRCRST.
	RCC_AHBRSTR_GPIOGRST_Pos = 0x7       // Position of GPIOGRST field.
	RCC_AHBRSTR_GPIOGRST_Msk = 0x80      // Bit mask of GPIOGRST field.
	RCC_AHBRSTR_GPIOGRST     = 0x80      // Bit GPIOGRST.
	RCC_AHBRSTR_GPIOFRST_Pos = 0x6       // Position of GPIOFRST field.
	RCC_AHBRSTR_GPIOFRST_Msk = 0x40      // Bit mask of GPIOFRST field.
	RCC_AHBRSTR_GPIOFRST     = 0x40      // Bit GPIOFRST.
	RCC_AHBRSTR_GPIOHRST_Pos = 0x5       // Position of GPIOHRST field.
	RCC_AHBRSTR_GPIOHRST_Msk = 0x20      // Bit mask of GPIOHRST field.
	RCC_AHBRSTR_GPIOHRST     = 0x20      // Bit GPIOHRST.
	RCC_AHBRSTR_GPIOERST_Pos = 0x4       // Position of GPIOERST field.
	RCC_AHBRSTR_GPIOERST_Msk = 0x10      // Bit mask of GPIOERST field.
	RCC_AHBRSTR_GPIOERST     = 0x10      // Bit GPIOERST.
	RCC_AHBRSTR_GPIODRST_Pos = 0x3       // Position of GPIODRST field.
	RCC_AHBRSTR_GPIODRST_Msk = 0x8       // Bit mask of GPIODRST field.
	RCC_AHBRSTR_GPIODRST     = 0x8       // Bit GPIODRST.
	RCC_AHBRSTR_GPIOCRST_Pos = 0x2       // Position of GPIOCRST field.
	RCC_AHBRSTR_GPIOCRST_Msk = 0x4       // Bit mask of GPIOCRST field.
	RCC_AHBRSTR_GPIOCRST     = 0x4       // Bit GPIOCRST.
	RCC_AHBRSTR_GPIOBRST_Pos = 0x1       // Position of GPIOBRST field.
	RCC_AHBRSTR_GPIOBRST_Msk = 0x2       // Bit mask of GPIOBRST field.
	RCC_AHBRSTR_GPIOBRST     = 0x2       // Bit GPIOBRST.
	RCC_AHBRSTR_GPIOARST_Pos = 0x0       // Position of GPIOARST field.
	RCC_AHBRSTR_GPIOARST_Msk = 0x1       // Bit mask of GPIOARST field.
	RCC_AHBRSTR_GPIOARST     = 0x1       // Bit GPIOARST.

	// APB2RSTR: APB2 peripheral reset register
	RCC_APB2RSTR_USART1RST_Pos = 0xe    // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000 // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x4000 // Bit USART1RST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc    // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000 // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000 // Bit SPI1RST.
	RCC_APB2RSTR_ADC1RST_Pos   = 0x9    // Position of ADC1RST field.
	RCC_APB2RSTR_ADC1RST_Msk   = 0x200  // Bit mask of ADC1RST field.
	RCC_APB2RSTR_ADC1RST       = 0x200  // Bit ADC1RST.
	RCC_APB2RSTR_TM11RST_Pos   = 0x4    // Position of TM11RST field.
	RCC_APB2RSTR_TM11RST_Msk   = 0x10   // Bit mask of TM11RST field.
	RCC_APB2RSTR_TM11RST       = 0x10   // Bit TM11RST.
	RCC_APB2RSTR_TM10RST_Pos   = 0x3    // Position of TM10RST field.
	RCC_APB2RSTR_TM10RST_Msk   = 0x8    // Bit mask of TM10RST field.
	RCC_APB2RSTR_TM10RST       = 0x8    // Bit TM10RST.
	RCC_APB2RSTR_TIM9RST_Pos   = 0x2    // Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk   = 0x4    // Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST       = 0x4    // Bit TIM9RST.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0    // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1    // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x1    // Bit SYSCFGRST.

	// APB1RSTR: APB1 peripheral reset register
	RCC_APB1RSTR_COMPRST_Pos   = 0x1f       // Position of COMPRST field.
	RCC_APB1RSTR_COMPRST_Msk   = 0x80000000 // Bit mask of COMPRST field.
	RCC_APB1RSTR_COMPRST       = 0x80000000 // Bit COMPRST.
	RCC_APB1RSTR_DACRST_Pos    = 0x1d       // Position of DACRST field.
	RCC_APB1RSTR_DACRST_Msk    = 0x20000000 // Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST        = 0x20000000 // Bit DACRST.
	RCC_APB1RSTR_PWRRST_Pos    = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk    = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST        = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_USBRST_Pos    = 0x17       // Position of USBRST field.
	RCC_APB1RSTR_USBRST_Msk    = 0x800000   // Bit mask of USBRST field.
	RCC_APB1RSTR_USBRST        = 0x800000   // Bit USBRST.
	RCC_APB1RSTR_I2C2RST_Pos   = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk   = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST       = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_I2C1RST_Pos   = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk   = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST       = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_USART3RST_Pos = 0x12       // Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000    // Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST     = 0x40000    // Bit USART3RST.
	RCC_APB1RSTR_USART2RST_Pos = 0x11       // Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000    // Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST     = 0x20000    // Bit USART2RST.
	RCC_APB1RSTR_SPI3RST_Pos   = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk   = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST       = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR_SPI2RST_Pos   = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk   = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST       = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_WWDRST_Pos    = 0xb        // Position of WWDRST field.
	RCC_APB1RSTR_WWDRST_Msk    = 0x800      // Bit mask of WWDRST field.
	RCC_APB1RSTR_WWDRST        = 0x800      // Bit WWDRST.
	RCC_APB1RSTR_LCDRST_Pos    = 0x9        // Position of LCDRST field.
	RCC_APB1RSTR_LCDRST_Msk    = 0x200      // Bit mask of LCDRST field.
	RCC_APB1RSTR_LCDRST        = 0x200      // Bit LCDRST.
	RCC_APB1RSTR_TIM7RST_Pos   = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk   = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST       = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_TIM6RST_Pos   = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk   = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST       = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM5RST_Pos   = 0x3        // Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk   = 0x8        // Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST       = 0x8        // Bit TIM5RST.
	RCC_APB1RSTR_TIM4RST_Pos   = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk   = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST       = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR_TIM3RST_Pos   = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk   = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST       = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM2RST_Pos   = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk   = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST       = 0x1        // Bit TIM2RST.

	// AHBENR: AHB peripheral clock enable           register
	RCC_AHBENR_DMA2EN_Pos   = 0x19      // Position of DMA2EN field.
	RCC_AHBENR_DMA2EN_Msk   = 0x2000000 // Bit mask of DMA2EN field.
	RCC_AHBENR_DMA2EN       = 0x2000000 // Bit DMA2EN.
	RCC_AHBENR_DMA1EN_Pos   = 0x18      // Position of DMA1EN field.
	RCC_AHBENR_DMA1EN_Msk   = 0x1000000 // Bit mask of DMA1EN field.
	RCC_AHBENR_DMA1EN       = 0x1000000 // Bit DMA1EN.
	RCC_AHBENR_FLITFEN_Pos  = 0xf       // Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk  = 0x8000    // Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN      = 0x8000    // Bit FLITFEN.
	RCC_AHBENR_CRCEN_Pos    = 0xc       // Position of CRCEN field.
	RCC_AHBENR_CRCEN_Msk    = 0x1000    // Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN        = 0x1000    // Bit CRCEN.
	RCC_AHBENR_GPIOPGEN_Pos = 0x7       // Position of GPIOPGEN field.
	RCC_AHBENR_GPIOPGEN_Msk = 0x80      // Bit mask of GPIOPGEN field.
	RCC_AHBENR_GPIOPGEN     = 0x80      // Bit GPIOPGEN.
	RCC_AHBENR_GPIOPFEN_Pos = 0x6       // Position of GPIOPFEN field.
	RCC_AHBENR_GPIOPFEN_Msk = 0x40      // Bit mask of GPIOPFEN field.
	RCC_AHBENR_GPIOPFEN     = 0x40      // Bit GPIOPFEN.
	RCC_AHBENR_GPIOPHEN_Pos = 0x5       // Position of GPIOPHEN field.
	RCC_AHBENR_GPIOPHEN_Msk = 0x20      // Bit mask of GPIOPHEN field.
	RCC_AHBENR_GPIOPHEN     = 0x20      // Bit GPIOPHEN.
	RCC_AHBENR_GPIOPEEN_Pos = 0x4       // Position of GPIOPEEN field.
	RCC_AHBENR_GPIOPEEN_Msk = 0x10      // Bit mask of GPIOPEEN field.
	RCC_AHBENR_GPIOPEEN     = 0x10      // Bit GPIOPEEN.
	RCC_AHBENR_GPIOPDEN_Pos = 0x3       // Position of GPIOPDEN field.
	RCC_AHBENR_GPIOPDEN_Msk = 0x8       // Bit mask of GPIOPDEN field.
	RCC_AHBENR_GPIOPDEN     = 0x8       // Bit GPIOPDEN.
	RCC_AHBENR_GPIOPCEN_Pos = 0x2       // Position of GPIOPCEN field.
	RCC_AHBENR_GPIOPCEN_Msk = 0x4       // Bit mask of GPIOPCEN field.
	RCC_AHBENR_GPIOPCEN     = 0x4       // Bit GPIOPCEN.
	RCC_AHBENR_GPIOPBEN_Pos = 0x1       // Position of GPIOPBEN field.
	RCC_AHBENR_GPIOPBEN_Msk = 0x2       // Bit mask of GPIOPBEN field.
	RCC_AHBENR_GPIOPBEN     = 0x2       // Bit GPIOPBEN.
	RCC_AHBENR_GPIOPAEN_Pos = 0x0       // Position of GPIOPAEN field.
	RCC_AHBENR_GPIOPAEN_Msk = 0x1       // Bit mask of GPIOPAEN field.
	RCC_AHBENR_GPIOPAEN     = 0x1       // Bit GPIOPAEN.

	// APB2ENR: APB2 peripheral clock enable           register
	RCC_APB2ENR_USART1EN_Pos = 0xe    // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000 // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x4000 // Bit USART1EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc    // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000 // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000 // Bit SPI1EN.
	RCC_APB2ENR_ADC1EN_Pos   = 0x9    // Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk   = 0x200  // Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN       = 0x200  // Bit ADC1EN.
	RCC_APB2ENR_TIM11EN_Pos  = 0x4    // Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk  = 0x10   // Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN      = 0x10   // Bit TIM11EN.
	RCC_APB2ENR_TIM10EN_Pos  = 0x3    // Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk  = 0x8    // Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN      = 0x8    // Bit TIM10EN.
	RCC_APB2ENR_TIM9EN_Pos   = 0x2    // Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk   = 0x4    // Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN       = 0x4    // Bit TIM9EN.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0    // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1    // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x1    // Bit SYSCFGEN.

	// APB1ENR: APB1 peripheral clock enable           register
	RCC_APB1ENR_COMPEN_Pos   = 0x1f       // Position of COMPEN field.
	RCC_APB1ENR_COMPEN_Msk   = 0x80000000 // Bit mask of COMPEN field.
	RCC_APB1ENR_COMPEN       = 0x80000000 // Bit COMPEN.
	RCC_APB1ENR_DACEN_Pos    = 0x1d       // Position of DACEN field.
	RCC_APB1ENR_DACEN_Msk    = 0x20000000 // Bit mask of DACEN field.
	RCC_APB1ENR_DACEN        = 0x20000000 // Bit DACEN.
	RCC_APB1ENR_PWREN_Pos    = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk    = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN        = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_USBEN_Pos    = 0x17       // Position of USBEN field.
	RCC_APB1ENR_USBEN_Msk    = 0x800000   // Bit mask of USBEN field.
	RCC_APB1ENR_USBEN        = 0x800000   // Bit USBEN.
	RCC_APB1ENR_I2C2EN_Pos   = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk   = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN       = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_I2C1EN_Pos   = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk   = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN       = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_USART3EN_Pos = 0x12       // Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN     = 0x40000    // Bit USART3EN.
	RCC_APB1ENR_USART2EN_Pos = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN     = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_SPI3EN_Pos   = 0xf        // Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk   = 0x8000     // Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN       = 0x8000     // Bit SPI3EN.
	RCC_APB1ENR_SPI2EN_Pos   = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk   = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN       = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_WWDGEN_Pos   = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk   = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN       = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_LCDEN_Pos    = 0x9        // Position of LCDEN field.
	RCC_APB1ENR_LCDEN_Msk    = 0x200      // Bit mask of LCDEN field.
	RCC_APB1ENR_LCDEN        = 0x200      // Bit LCDEN.
	RCC_APB1ENR_TIM7EN_Pos   = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk   = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN       = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_TIM6EN_Pos   = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk   = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN       = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM5EN_Pos   = 0x3        // Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk   = 0x8        // Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN       = 0x8        // Bit TIM5EN.
	RCC_APB1ENR_TIM4EN_Pos   = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk   = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN       = 0x4        // Bit TIM4EN.
	RCC_APB1ENR_TIM3EN_Pos   = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk   = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN       = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM2EN_Pos   = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk   = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN       = 0x1        // Bit TIM2EN.

	// AHBLPENR: AHB peripheral clock enable in low power           mode register
	RCC_AHBLPENR_DMA2LPEN_Pos  = 0x19      // Position of DMA2LPEN field.
	RCC_AHBLPENR_DMA2LPEN_Msk  = 0x2000000 // Bit mask of DMA2LPEN field.
	RCC_AHBLPENR_DMA2LPEN      = 0x2000000 // Bit DMA2LPEN.
	RCC_AHBLPENR_DMA1LPEN_Pos  = 0x18      // Position of DMA1LPEN field.
	RCC_AHBLPENR_DMA1LPEN_Msk  = 0x1000000 // Bit mask of DMA1LPEN field.
	RCC_AHBLPENR_DMA1LPEN      = 0x1000000 // Bit DMA1LPEN.
	RCC_AHBLPENR_SRAMLPEN_Pos  = 0x10      // Position of SRAMLPEN field.
	RCC_AHBLPENR_SRAMLPEN_Msk  = 0x10000   // Bit mask of SRAMLPEN field.
	RCC_AHBLPENR_SRAMLPEN      = 0x10000   // Bit SRAMLPEN.
	RCC_AHBLPENR_FLITFLPEN_Pos = 0xf       // Position of FLITFLPEN field.
	RCC_AHBLPENR_FLITFLPEN_Msk = 0x8000    // Bit mask of FLITFLPEN field.
	RCC_AHBLPENR_FLITFLPEN     = 0x8000    // Bit FLITFLPEN.
	RCC_AHBLPENR_CRCLPEN_Pos   = 0xc       // Position of CRCLPEN field.
	RCC_AHBLPENR_CRCLPEN_Msk   = 0x1000    // Bit mask of CRCLPEN field.
	RCC_AHBLPENR_CRCLPEN       = 0x1000    // Bit CRCLPEN.
	RCC_AHBLPENR_GPIOGLPEN_Pos = 0x7       // Position of GPIOGLPEN field.
	RCC_AHBLPENR_GPIOGLPEN_Msk = 0x80      // Bit mask of GPIOGLPEN field.
	RCC_AHBLPENR_GPIOGLPEN     = 0x80      // Bit GPIOGLPEN.
	RCC_AHBLPENR_GPIOFLPEN_Pos = 0x6       // Position of GPIOFLPEN field.
	RCC_AHBLPENR_GPIOFLPEN_Msk = 0x40      // Bit mask of GPIOFLPEN field.
	RCC_AHBLPENR_GPIOFLPEN     = 0x40      // Bit GPIOFLPEN.
	RCC_AHBLPENR_GPIOHLPEN_Pos = 0x5       // Position of GPIOHLPEN field.
	RCC_AHBLPENR_GPIOHLPEN_Msk = 0x20      // Bit mask of GPIOHLPEN field.
	RCC_AHBLPENR_GPIOHLPEN     = 0x20      // Bit GPIOHLPEN.
	RCC_AHBLPENR_GPIOELPEN_Pos = 0x4       // Position of GPIOELPEN field.
	RCC_AHBLPENR_GPIOELPEN_Msk = 0x10      // Bit mask of GPIOELPEN field.
	RCC_AHBLPENR_GPIOELPEN     = 0x10      // Bit GPIOELPEN.
	RCC_AHBLPENR_GPIODLPEN_Pos = 0x3       // Position of GPIODLPEN field.
	RCC_AHBLPENR_GPIODLPEN_Msk = 0x8       // Bit mask of GPIODLPEN field.
	RCC_AHBLPENR_GPIODLPEN     = 0x8       // Bit GPIODLPEN.
	RCC_AHBLPENR_GPIOCLPEN_Pos = 0x2       // Position of GPIOCLPEN field.
	RCC_AHBLPENR_GPIOCLPEN_Msk = 0x4       // Bit mask of GPIOCLPEN field.
	RCC_AHBLPENR_GPIOCLPEN     = 0x4       // Bit GPIOCLPEN.
	RCC_AHBLPENR_GPIOBLPEN_Pos = 0x1       // Position of GPIOBLPEN field.
	RCC_AHBLPENR_GPIOBLPEN_Msk = 0x2       // Bit mask of GPIOBLPEN field.
	RCC_AHBLPENR_GPIOBLPEN     = 0x2       // Bit GPIOBLPEN.
	RCC_AHBLPENR_GPIOALPEN_Pos = 0x0       // Position of GPIOALPEN field.
	RCC_AHBLPENR_GPIOALPEN_Msk = 0x1       // Bit mask of GPIOALPEN field.
	RCC_AHBLPENR_GPIOALPEN     = 0x1       // Bit GPIOALPEN.

	// APB2LPENR: APB2 peripheral clock enable in low power           mode register
	RCC_APB2LPENR_USART1LPEN_Pos = 0xe    // Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x4000 // Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN     = 0x4000 // Bit USART1LPEN.
	RCC_APB2LPENR_SPI1LPEN_Pos   = 0xc    // Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk   = 0x1000 // Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN       = 0x1000 // Bit SPI1LPEN.
	RCC_APB2LPENR_ADC1LPEN_Pos   = 0x9    // Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk   = 0x200  // Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN       = 0x200  // Bit ADC1LPEN.
	RCC_APB2LPENR_TIM11LPEN_Pos  = 0x4    // Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk  = 0x10   // Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN      = 0x10   // Bit TIM11LPEN.
	RCC_APB2LPENR_TIM10LPEN_Pos  = 0x3    // Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk  = 0x8    // Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN      = 0x8    // Bit TIM10LPEN.
	RCC_APB2LPENR_TIM9LPEN_Pos   = 0x2    // Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk   = 0x4    // Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN       = 0x4    // Bit TIM9LPEN.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0x0    // Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x1    // Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN     = 0x1    // Bit SYSCFGLPEN.

	// APB1LPENR: APB1 peripheral clock enable in low power           mode register
	RCC_APB1LPENR_COMPLPEN_Pos   = 0x1f       // Position of COMPLPEN field.
	RCC_APB1LPENR_COMPLPEN_Msk   = 0x80000000 // Bit mask of COMPLPEN field.
	RCC_APB1LPENR_COMPLPEN       = 0x80000000 // Bit COMPLPEN.
	RCC_APB1LPENR_DACLPEN_Pos    = 0x1d       // Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk    = 0x20000000 // Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN        = 0x20000000 // Bit DACLPEN.
	RCC_APB1LPENR_PWRLPEN_Pos    = 0x1c       // Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk    = 0x10000000 // Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN        = 0x10000000 // Bit PWRLPEN.
	RCC_APB1LPENR_USBLPEN_Pos    = 0x17       // Position of USBLPEN field.
	RCC_APB1LPENR_USBLPEN_Msk    = 0x800000   // Bit mask of USBLPEN field.
	RCC_APB1LPENR_USBLPEN        = 0x800000   // Bit USBLPEN.
	RCC_APB1LPENR_I2C2LPEN_Pos   = 0x16       // Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk   = 0x400000   // Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN       = 0x400000   // Bit I2C2LPEN.
	RCC_APB1LPENR_I2C1LPEN_Pos   = 0x15       // Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk   = 0x200000   // Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN       = 0x200000   // Bit I2C1LPEN.
	RCC_APB1LPENR_USART3LPEN_Pos = 0x12       // Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk = 0x40000    // Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN     = 0x40000    // Bit USART3LPEN.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11       // Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000    // Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN     = 0x20000    // Bit USART2LPEN.
	RCC_APB1LPENR_SPI2LPEN_Pos   = 0xe        // Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk   = 0x4000     // Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN       = 0x4000     // Bit SPI2LPEN.
	RCC_APB1LPENR_WWDGLPEN_Pos   = 0xb        // Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk   = 0x800      // Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN       = 0x800      // Bit WWDGLPEN.
	RCC_APB1LPENR_LCDLPEN_Pos    = 0x9        // Position of LCDLPEN field.
	RCC_APB1LPENR_LCDLPEN_Msk    = 0x200      // Bit mask of LCDLPEN field.
	RCC_APB1LPENR_LCDLPEN        = 0x200      // Bit LCDLPEN.
	RCC_APB1LPENR_TIM7LPEN_Pos   = 0x5        // Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk   = 0x20       // Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN       = 0x20       // Bit TIM7LPEN.
	RCC_APB1LPENR_TIM6LPEN_Pos   = 0x4        // Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk   = 0x10       // Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN       = 0x10       // Bit TIM6LPEN.
	RCC_APB1LPENR_TIM4LPEN_Pos   = 0x2        // Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk   = 0x4        // Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN       = 0x4        // Bit TIM4LPEN.
	RCC_APB1LPENR_TIM3LPEN_Pos   = 0x1        // Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk   = 0x2        // Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN       = 0x2        // Bit TIM3LPEN.
	RCC_APB1LPENR_TIM2LPEN_Pos   = 0x0        // Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk   = 0x1        // Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN       = 0x1        // Bit TIM2LPEN.

	// CSR: Control/status register
	RCC_CSR_LPWRSTF_Pos  = 0x1f       // Position of LPWRSTF field.
	RCC_CSR_LPWRSTF_Msk  = 0x80000000 // Bit mask of LPWRSTF field.
	RCC_CSR_LPWRSTF      = 0x80000000 // Bit LPWRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_IWDGRSTF_Pos = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF     = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_PINRSTF_Pos  = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk  = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF      = 0x4000000  // Bit PINRSTF.
	RCC_CSR_OBLRSTF_Pos  = 0x19       // Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk  = 0x2000000  // Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF      = 0x2000000  // Bit OBLRSTF.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_RTCRST_Pos   = 0x17       // Position of RTCRST field.
	RCC_CSR_RTCRST_Msk   = 0x800000   // Bit mask of RTCRST field.
	RCC_CSR_RTCRST       = 0x800000   // Bit RTCRST.
	RCC_CSR_RTCEN_Pos    = 0x16       // Position of RTCEN field.
	RCC_CSR_RTCEN_Msk    = 0x400000   // Bit mask of RTCEN field.
	RCC_CSR_RTCEN        = 0x400000   // Bit RTCEN.
	RCC_CSR_RTCSEL_Pos   = 0x10       // Position of RTCSEL field.
	RCC_CSR_RTCSEL_Msk   = 0x30000    // Bit mask of RTCSEL field.
	RCC_CSR_LSECSSD_Pos  = 0xc        // Position of LSECSSD field.
	RCC_CSR_LSECSSD_Msk  = 0x1000     // Bit mask of LSECSSD field.
	RCC_CSR_LSECSSD      = 0x1000     // Bit LSECSSD.
	RCC_CSR_LSECSSON_Pos = 0xb        // Position of LSECSSON field.
	RCC_CSR_LSECSSON_Msk = 0x800      // Bit mask of LSECSSON field.
	RCC_CSR_LSECSSON     = 0x800      // Bit LSECSSON.
	RCC_CSR_LSEBYP_Pos   = 0xa        // Position of LSEBYP field.
	RCC_CSR_LSEBYP_Msk   = 0x400      // Bit mask of LSEBYP field.
	RCC_CSR_LSEBYP       = 0x400      // Bit LSEBYP.
	RCC_CSR_LSERDY_Pos   = 0x9        // Position of LSERDY field.
	RCC_CSR_LSERDY_Msk   = 0x200      // Bit mask of LSERDY field.
	RCC_CSR_LSERDY       = 0x200      // Bit LSERDY.
	RCC_CSR_LSEON_Pos    = 0x8        // Position of LSEON field.
	RCC_CSR_LSEON_Msk    = 0x100      // Bit mask of LSEON field.
	RCC_CSR_LSEON        = 0x100      // Bit LSEON.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.
)

// Bitfields for RI: Routing interface
const (
	// ICR: RI input capture register
	RI_ICR_IC4_Pos    = 0x15     // Position of IC4 field.
	RI_ICR_IC4_Msk    = 0x200000 // Bit mask of IC4 field.
	RI_ICR_IC4        = 0x200000 // Bit IC4.
	RI_ICR_IC3_Pos    = 0x14     // Position of IC3 field.
	RI_ICR_IC3_Msk    = 0x100000 // Bit mask of IC3 field.
	RI_ICR_IC3        = 0x100000 // Bit IC3.
	RI_ICR_IC2_Pos    = 0x13     // Position of IC2 field.
	RI_ICR_IC2_Msk    = 0x80000  // Bit mask of IC2 field.
	RI_ICR_IC2        = 0x80000  // Bit IC2.
	RI_ICR_IC1_Pos    = 0x12     // Position of IC1 field.
	RI_ICR_IC1_Msk    = 0x40000  // Bit mask of IC1 field.
	RI_ICR_IC1        = 0x40000  // Bit IC1.
	RI_ICR_TIM_Pos    = 0x10     // Position of TIM field.
	RI_ICR_TIM_Msk    = 0x30000  // Bit mask of TIM field.
	RI_ICR_IC4IOS_Pos = 0xc      // Position of IC4IOS field.
	RI_ICR_IC4IOS_Msk = 0xf000   // Bit mask of IC4IOS field.
	RI_ICR_IC3IOS_Pos = 0x8      // Position of IC3IOS field.
	RI_ICR_IC3IOS_Msk = 0xf00    // Bit mask of IC3IOS field.
	RI_ICR_IC2IOS_Pos = 0x4      // Position of IC2IOS field.
	RI_ICR_IC2IOS_Msk = 0xf0     // Bit mask of IC2IOS field.
	RI_ICR_IC1IOS_Pos = 0x0      // Position of IC1IOS field.
	RI_ICR_IC1IOS_Msk = 0xf      // Bit mask of IC1IOS field.

	// ASCR1: RI analog switches control register           1
	RI_ASCR1_SCM_Pos        = 0x1f       // Position of SCM field.
	RI_ASCR1_SCM_Msk        = 0x80000000 // Bit mask of SCM field.
	RI_ASCR1_SCM            = 0x80000000 // Bit SCM.
	RI_ASCR1_CH30GR11_4_Pos = 0x1e       // Position of CH30GR11_4 field.
	RI_ASCR1_CH30GR11_4_Msk = 0x40000000 // Bit mask of CH30GR11_4 field.
	RI_ASCR1_CH30GR11_4     = 0x40000000 // Bit CH30GR11_4.
	RI_ASCR1_CH29GR11_3_Pos = 0x1d       // Position of CH29GR11_3 field.
	RI_ASCR1_CH29GR11_3_Msk = 0x20000000 // Bit mask of CH29GR11_3 field.
	RI_ASCR1_CH29GR11_3     = 0x20000000 // Bit CH29GR11_3.
	RI_ASCR1_CH28GR11_2_Pos = 0x1c       // Position of CH28GR11_2 field.
	RI_ASCR1_CH28GR11_2_Msk = 0x10000000 // Bit mask of CH28GR11_2 field.
	RI_ASCR1_CH28GR11_2     = 0x10000000 // Bit CH28GR11_2.
	RI_ASCR1_CH27GR11_1_Pos = 0x1b       // Position of CH27GR11_1 field.
	RI_ASCR1_CH27GR11_1_Msk = 0x8000000  // Bit mask of CH27GR11_1 field.
	RI_ASCR1_CH27GR11_1     = 0x8000000  // Bit CH27GR11_1.
	RI_ASCR1_VCOMP_Pos      = 0x1a       // Position of VCOMP field.
	RI_ASCR1_VCOMP_Msk      = 0x4000000  // Bit mask of VCOMP field.
	RI_ASCR1_VCOMP          = 0x4000000  // Bit VCOMP.
	RI_ASCR1_CH25_Pos       = 0x19       // Position of CH25 field.
	RI_ASCR1_CH25_Msk       = 0x2000000  // Bit mask of CH25 field.
	RI_ASCR1_CH25           = 0x2000000  // Bit CH25.
	RI_ASCR1_CH24_Pos       = 0x18       // Position of CH24 field.
	RI_ASCR1_CH24_Msk       = 0x1000000  // Bit mask of CH24 field.
	RI_ASCR1_CH24           = 0x1000000  // Bit CH24.
	RI_ASCR1_CH23_Pos       = 0x17       // Position of CH23 field.
	RI_ASCR1_CH23_Msk       = 0x800000   // Bit mask of CH23 field.
	RI_ASCR1_CH23           = 0x800000   // Bit CH23.
	RI_ASCR1_CH22_Pos       = 0x16       // Position of CH22 field.
	RI_ASCR1_CH22_Msk       = 0x400000   // Bit mask of CH22 field.
	RI_ASCR1_CH22           = 0x400000   // Bit CH22.
	RI_ASCR1_CH21GR7_4_Pos  = 0x15       // Position of CH21GR7_4 field.
	RI_ASCR1_CH21GR7_4_Msk  = 0x200000   // Bit mask of CH21GR7_4 field.
	RI_ASCR1_CH21GR7_4      = 0x200000   // Bit CH21GR7_4.
	RI_ASCR1_CH20GR7_3_Pos  = 0x14       // Position of CH20GR7_3 field.
	RI_ASCR1_CH20GR7_3_Msk  = 0x100000   // Bit mask of CH20GR7_3 field.
	RI_ASCR1_CH20GR7_3      = 0x100000   // Bit CH20GR7_3.
	RI_ASCR1_CH19GR7_2_Pos  = 0x13       // Position of CH19GR7_2 field.
	RI_ASCR1_CH19GR7_2_Msk  = 0x80000    // Bit mask of CH19GR7_2 field.
	RI_ASCR1_CH19GR7_2      = 0x80000    // Bit CH19GR7_2.
	RI_ASCR1_CH18GR7_1_Pos  = 0x12       // Position of CH18GR7_1 field.
	RI_ASCR1_CH18GR7_1_Msk  = 0x40000    // Bit mask of CH18GR7_1 field.
	RI_ASCR1_CH18GR7_1      = 0x40000    // Bit CH18GR7_1.
	RI_ASCR1_CH31GR7_1_Pos  = 0x10       // Position of CH31GR7_1 field.
	RI_ASCR1_CH31GR7_1_Msk  = 0x10000    // Bit mask of CH31GR7_1 field.
	RI_ASCR1_CH31GR7_1      = 0x10000    // Bit CH31GR7_1.
	RI_ASCR1_CH15GR9_2_Pos  = 0xf        // Position of CH15GR9_2 field.
	RI_ASCR1_CH15GR9_2_Msk  = 0x8000     // Bit mask of CH15GR9_2 field.
	RI_ASCR1_CH15GR9_2      = 0x8000     // Bit CH15GR9_2.
	RI_ASCR1_CH14GR9_1_Pos  = 0xe        // Position of CH14GR9_1 field.
	RI_ASCR1_CH14GR9_1_Msk  = 0x4000     // Bit mask of CH14GR9_1 field.
	RI_ASCR1_CH14GR9_1      = 0x4000     // Bit CH14GR9_1.
	RI_ASCR1_CH13GR8_4_Pos  = 0xd        // Position of CH13GR8_4 field.
	RI_ASCR1_CH13GR8_4_Msk  = 0x2000     // Bit mask of CH13GR8_4 field.
	RI_ASCR1_CH13GR8_4      = 0x2000     // Bit CH13GR8_4.
	RI_ASCR1_CH12GR8_3_Pos  = 0xc        // Position of CH12GR8_3 field.
	RI_ASCR1_CH12GR8_3_Msk  = 0x1000     // Bit mask of CH12GR8_3 field.
	RI_ASCR1_CH12GR8_3      = 0x1000     // Bit CH12GR8_3.
	RI_ASCR1_CH11GR8_2_Pos  = 0xb        // Position of CH11GR8_2 field.
	RI_ASCR1_CH11GR8_2_Msk  = 0x800      // Bit mask of CH11GR8_2 field.
	RI_ASCR1_CH11GR8_2      = 0x800      // Bit CH11GR8_2.
	RI_ASCR1_CH10GR8_1_Pos  = 0xa        // Position of CH10GR8_1 field.
	RI_ASCR1_CH10GR8_1_Msk  = 0x400      // Bit mask of CH10GR8_1 field.
	RI_ASCR1_CH10GR8_1      = 0x400      // Bit CH10GR8_1.
	RI_ASCR1_CH9GR3_2_Pos   = 0x9        // Position of CH9GR3_2 field.
	RI_ASCR1_CH9GR3_2_Msk   = 0x200      // Bit mask of CH9GR3_2 field.
	RI_ASCR1_CH9GR3_2       = 0x200      // Bit CH9GR3_2.
	RI_ASCR1_CH8GR3_1_Pos   = 0x8        // Position of CH8GR3_1 field.
	RI_ASCR1_CH8GR3_1_Msk   = 0x100      // Bit mask of CH8GR3_1 field.
	RI_ASCR1_CH8GR3_1       = 0x100      // Bit CH8GR3_1.
	RI_ASCR1_CH7GR2_2_Pos   = 0x7        // Position of CH7GR2_2 field.
	RI_ASCR1_CH7GR2_2_Msk   = 0x80       // Bit mask of CH7GR2_2 field.
	RI_ASCR1_CH7GR2_2       = 0x80       // Bit CH7GR2_2.
	RI_ASCR1_CH6GR2_1_Pos   = 0x6        // Position of CH6GR2_1 field.
	RI_ASCR1_CH6GR2_1_Msk   = 0x40       // Bit mask of CH6GR2_1 field.
	RI_ASCR1_CH6GR2_1       = 0x40       // Bit CH6GR2_1.
	RI_ASCR1_COMP1_SW1_Pos  = 0x5        // Position of COMP1_SW1 field.
	RI_ASCR1_COMP1_SW1_Msk  = 0x20       // Bit mask of COMP1_SW1 field.
	RI_ASCR1_COMP1_SW1      = 0x20       // Bit COMP1_SW1.
	RI_ASCR1_CH31GR11_5_Pos = 0x4        // Position of CH31GR11_5 field.
	RI_ASCR1_CH31GR11_5_Msk = 0x10       // Bit mask of CH31GR11_5 field.
	RI_ASCR1_CH31GR11_5     = 0x10       // Bit CH31GR11_5.
	RI_ASCR1_CH3GR1_4_Pos   = 0x3        // Position of CH3GR1_4 field.
	RI_ASCR1_CH3GR1_4_Msk   = 0x8        // Bit mask of CH3GR1_4 field.
	RI_ASCR1_CH3GR1_4       = 0x8        // Bit CH3GR1_4.
	RI_ASCR1_CH2GR1_3_Pos   = 0x2        // Position of CH2GR1_3 field.
	RI_ASCR1_CH2GR1_3_Msk   = 0x4        // Bit mask of CH2GR1_3 field.
	RI_ASCR1_CH2GR1_3       = 0x4        // Bit CH2GR1_3.
	RI_ASCR1_CH1GR1_2_Pos   = 0x1        // Position of CH1GR1_2 field.
	RI_ASCR1_CH1GR1_2_Msk   = 0x2        // Bit mask of CH1GR1_2 field.
	RI_ASCR1_CH1GR1_2       = 0x2        // Bit CH1GR1_2.
	RI_ASCR1_CH0GR1_1_Pos   = 0x0        // Position of CH0GR1_1 field.
	RI_ASCR1_CH0GR1_1_Msk   = 0x1        // Bit mask of CH0GR1_1 field.
	RI_ASCR1_CH0GR1_1       = 0x1        // Bit CH0GR1_1.

	// ASCR2: RI analog switches control register           2
	RI_ASCR2_GR5_4_Pos  = 0x1d       // Position of GR5_4 field.
	RI_ASCR2_GR5_4_Msk  = 0x20000000 // Bit mask of GR5_4 field.
	RI_ASCR2_GR5_4      = 0x20000000 // Bit GR5_4.
	RI_ASCR2_GR6_4_Pos  = 0x1c       // Position of GR6_4 field.
	RI_ASCR2_GR6_4_Msk  = 0x10000000 // Bit mask of GR6_4 field.
	RI_ASCR2_GR6_4      = 0x10000000 // Bit GR6_4.
	RI_ASCR2_GR6_3_Pos  = 0x1b       // Position of GR6_3 field.
	RI_ASCR2_GR6_3_Msk  = 0x8000000  // Bit mask of GR6_3 field.
	RI_ASCR2_GR6_3      = 0x8000000  // Bit GR6_3.
	RI_ASCR2_GR7_7_Pos  = 0x1a       // Position of GR7_7 field.
	RI_ASCR2_GR7_7_Msk  = 0x4000000  // Bit mask of GR7_7 field.
	RI_ASCR2_GR7_7      = 0x4000000  // Bit GR7_7.
	RI_ASCR2_GR7_6_Pos  = 0x19       // Position of GR7_6 field.
	RI_ASCR2_GR7_6_Msk  = 0x2000000  // Bit mask of GR7_6 field.
	RI_ASCR2_GR7_6      = 0x2000000  // Bit GR7_6.
	RI_ASCR2_GR7_5_Pos  = 0x18       // Position of GR7_5 field.
	RI_ASCR2_GR7_5_Msk  = 0x1000000  // Bit mask of GR7_5 field.
	RI_ASCR2_GR7_5      = 0x1000000  // Bit GR7_5.
	RI_ASCR2_GR2_5_Pos  = 0x17       // Position of GR2_5 field.
	RI_ASCR2_GR2_5_Msk  = 0x800000   // Bit mask of GR2_5 field.
	RI_ASCR2_GR2_5      = 0x800000   // Bit GR2_5.
	RI_ASCR2_GR2_4_Pos  = 0x16       // Position of GR2_4 field.
	RI_ASCR2_GR2_4_Msk  = 0x400000   // Bit mask of GR2_4 field.
	RI_ASCR2_GR2_4      = 0x400000   // Bit GR2_4.
	RI_ASCR2_GR2_3_Pos  = 0x15       // Position of GR2_3 field.
	RI_ASCR2_GR2_3_Msk  = 0x200000   // Bit mask of GR2_3 field.
	RI_ASCR2_GR2_3      = 0x200000   // Bit GR2_3.
	RI_ASCR2_GR9_4_Pos  = 0x14       // Position of GR9_4 field.
	RI_ASCR2_GR9_4_Msk  = 0x100000   // Bit mask of GR9_4 field.
	RI_ASCR2_GR9_4      = 0x100000   // Bit GR9_4.
	RI_ASCR2_GR9_3_Pos  = 0x13       // Position of GR9_3 field.
	RI_ASCR2_GR9_3_Msk  = 0x80000    // Bit mask of GR9_3 field.
	RI_ASCR2_GR9_3      = 0x80000    // Bit GR9_3.
	RI_ASCR2_GR3_5_Pos  = 0x12       // Position of GR3_5 field.
	RI_ASCR2_GR3_5_Msk  = 0x40000    // Bit mask of GR3_5 field.
	RI_ASCR2_GR3_5      = 0x40000    // Bit GR3_5.
	RI_ASCR2_GR3_4_Pos  = 0x11       // Position of GR3_4 field.
	RI_ASCR2_GR3_4_Msk  = 0x20000    // Bit mask of GR3_4 field.
	RI_ASCR2_GR3_4      = 0x20000    // Bit GR3_4.
	RI_ASCR2_GR3_3_Pos  = 0x10       // Position of GR3_3 field.
	RI_ASCR2_GR3_3_Msk  = 0x10000    // Bit mask of GR3_3 field.
	RI_ASCR2_GR3_3      = 0x10000    // Bit GR3_3.
	RI_ASCR2_GR4_3_Pos  = 0xb        // Position of GR4_3 field.
	RI_ASCR2_GR4_3_Msk  = 0x800      // Bit mask of GR4_3 field.
	RI_ASCR2_GR4_3      = 0x800      // Bit GR4_3.
	RI_ASCR2_GR4_2_Pos  = 0xa        // Position of GR4_2 field.
	RI_ASCR2_GR4_2_Msk  = 0x400      // Bit mask of GR4_2 field.
	RI_ASCR2_GR4_2      = 0x400      // Bit GR4_2.
	RI_ASCR2_GR4_1_Pos  = 0x9        // Position of GR4_1 field.
	RI_ASCR2_GR4_1_Msk  = 0x200      // Bit mask of GR4_1 field.
	RI_ASCR2_GR4_1      = 0x200      // Bit GR4_1.
	RI_ASCR2_GR5_3_Pos  = 0x8        // Position of GR5_3 field.
	RI_ASCR2_GR5_3_Msk  = 0x100      // Bit mask of GR5_3 field.
	RI_ASCR2_GR5_3      = 0x100      // Bit GR5_3.
	RI_ASCR2_GR5_2_Pos  = 0x7        // Position of GR5_2 field.
	RI_ASCR2_GR5_2_Msk  = 0x80       // Bit mask of GR5_2 field.
	RI_ASCR2_GR5_2      = 0x80       // Bit GR5_2.
	RI_ASCR2_GR5_1_Pos  = 0x6        // Position of GR5_1 field.
	RI_ASCR2_GR5_1_Msk  = 0x40       // Bit mask of GR5_1 field.
	RI_ASCR2_GR5_1      = 0x40       // Bit GR5_1.
	RI_ASCR2_GR6_2_Pos  = 0x5        // Position of GR6_2 field.
	RI_ASCR2_GR6_2_Msk  = 0x20       // Bit mask of GR6_2 field.
	RI_ASCR2_GR6_2      = 0x20       // Bit GR6_2.
	RI_ASCR2_GR6_1_Pos  = 0x4        // Position of GR6_1 field.
	RI_ASCR2_GR6_1_Msk  = 0x10       // Bit mask of GR6_1 field.
	RI_ASCR2_GR6_1      = 0x10       // Bit GR6_1.
	RI_ASCR2_GR10_4_Pos = 0x3        // Position of GR10_4 field.
	RI_ASCR2_GR10_4_Msk = 0x8        // Bit mask of GR10_4 field.
	RI_ASCR2_GR10_4     = 0x8        // Bit GR10_4.
	RI_ASCR2_GR10_3_Pos = 0x2        // Position of GR10_3 field.
	RI_ASCR2_GR10_3_Msk = 0x4        // Bit mask of GR10_3 field.
	RI_ASCR2_GR10_3     = 0x4        // Bit GR10_3.
	RI_ASCR2_GR10_2_Pos = 0x1        // Position of GR10_2 field.
	RI_ASCR2_GR10_2_Msk = 0x2        // Bit mask of GR10_2 field.
	RI_ASCR2_GR10_2     = 0x2        // Bit GR10_2.
	RI_ASCR2_GR10_1_Pos = 0x0        // Position of GR10_1 field.
	RI_ASCR2_GR10_1_Msk = 0x1        // Bit mask of GR10_1 field.
	RI_ASCR2_GR10_1     = 0x1        // Bit GR10_1.

	// HYSCR1: RI hysteresis control register           1
	RI_HYSCR1_PB_Pos = 0x10       // Position of PB field.
	RI_HYSCR1_PB_Msk = 0xffff0000 // Bit mask of PB field.
	RI_HYSCR1_PA_Pos = 0x0        // Position of PA field.
	RI_HYSCR1_PA_Msk = 0xffff     // Bit mask of PA field.

	// HYSCR2: RI hysteresis control register           2
	RI_HYSCR2_PD_Pos = 0x10       // Position of PD field.
	RI_HYSCR2_PD_Msk = 0xffff0000 // Bit mask of PD field.
	RI_HYSCR2_PC_Pos = 0x0        // Position of PC field.
	RI_HYSCR2_PC_Msk = 0xffff     // Bit mask of PC field.

	// HYSCR3: RI hysteresis control register           3
	RI_HYSCR3_PF_Pos = 0x10       // Position of PF field.
	RI_HYSCR3_PF_Msk = 0xffff0000 // Bit mask of PF field.
	RI_HYSCR3_PE_Pos = 0x0        // Position of PE field.
	RI_HYSCR3_PE_Msk = 0xffff     // Bit mask of PE field.

	// HYSCR4: Hysteresis control register
	RI_HYSCR4_PG_Pos = 0x0    // Position of PG field.
	RI_HYSCR4_PG_Msk = 0xffff // Bit mask of PG field.

	// ASMR1: Analog switch mode register
	RI_ASMR1_PA_Pos = 0x0    // Position of PA field.
	RI_ASMR1_PA_Msk = 0xffff // Bit mask of PA field.

	// CMR1: Channel mask register
	RI_CMR1_PA_Pos = 0x0    // Position of PA field.
	RI_CMR1_PA_Msk = 0xffff // Bit mask of PA field.

	// CICR1: Channel identification for capture           register
	RI_CICR1_PA_Pos = 0x0    // Position of PA field.
	RI_CICR1_PA_Msk = 0xffff // Bit mask of PA field.

	// ASMR2: Analog switch mode register
	RI_ASMR2_PB_Pos = 0x0    // Position of PB field.
	RI_ASMR2_PB_Msk = 0xffff // Bit mask of PB field.

	// CMR2: Channel mask register
	RI_CMR2_PB_Pos = 0x0    // Position of PB field.
	RI_CMR2_PB_Msk = 0xffff // Bit mask of PB field.

	// CICR2: Channel identification for capture           register
	RI_CICR2_PB_Pos = 0x0    // Position of PB field.
	RI_CICR2_PB_Msk = 0xffff // Bit mask of PB field.

	// ASMR3: Analog switch mode register
	RI_ASMR3_PC_Pos = 0x0    // Position of PC field.
	RI_ASMR3_PC_Msk = 0xffff // Bit mask of PC field.

	// CMR3: Channel mask register
	RI_CMR3_PC_Pos = 0x0    // Position of PC field.
	RI_CMR3_PC_Msk = 0xffff // Bit mask of PC field.

	// CICR3: Channel identification for capture           register
	RI_CICR3_PC_Pos = 0x0    // Position of PC field.
	RI_CICR3_PC_Msk = 0xffff // Bit mask of PC field.

	// ASMR4: Analog switch mode register
	RI_ASMR4_PF_Pos = 0x0    // Position of PF field.
	RI_ASMR4_PF_Msk = 0xffff // Bit mask of PF field.

	// CMR4: Channel mask register
	RI_CMR4_PF_Pos = 0x0    // Position of PF field.
	RI_CMR4_PF_Msk = 0xffff // Bit mask of PF field.

	// CICR4: Channel identification for capture           register
	RI_CICR4_PF_Pos = 0x0    // Position of PF field.
	RI_CICR4_PF_Msk = 0xffff // Bit mask of PF field.

	// ASMR5: Analog switch mode register
	RI_ASMR5_PG_Pos = 0x0    // Position of PG field.
	RI_ASMR5_PG_Msk = 0xffff // Bit mask of PG field.

	// CMR5: Channel mask register
	RI_CMR5_PG_Pos = 0x0    // Position of PG field.
	RI_CMR5_PG_Msk = 0xffff // Bit mask of PG field.

	// CICR5: Channel identification for capture           register
	RI_CICR5_PG_Pos = 0x0    // Position of PG field.
	RI_CICR5_PG_Msk = 0xffff // Bit mask of PG field.
)

// Bitfields for SPI2: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_TXEIE_Pos   = 0x7  // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80 // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80 // Bit TXEIE.
	SPI_CR2_RXNEIE_Pos  = 0x6  // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40 // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40 // Bit RXNEIE.
	SPI_CR2_ERRIE_Pos   = 0x5  // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20 // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20 // Bit ERRIE.
	SPI_CR2_FRF_Pos     = 0x4  // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10 // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10 // Bit FRF.
	SPI_CR2_SSOE_Pos    = 0x2  // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4  // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4  // Bit SSOE.
	SPI_CR2_TXDMAEN_Pos = 0x1  // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2  // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2  // Bit TXDMAEN.
	SPI_CR2_RXDMAEN_Pos = 0x0  // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1  // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1  // Bit RXDMAEN.

	// SR: status register
	SPI_SR_TIFRFE_Pos = 0x8   // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100 // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100 // Bit TIFRFE.
	SPI_SR_BSY_Pos    = 0x7   // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80  // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80  // Bit BSY.
	SPI_SR_OVR_Pos    = 0x6   // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40  // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40  // Bit OVR.
	SPI_SR_MODF_Pos   = 0x5   // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20  // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20  // Bit MODF.
	SPI_SR_CRCERR_Pos = 0x4   // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10  // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10  // Bit CRCERR.
	SPI_SR_UDR_Pos    = 0x3   // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8   // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8   // Bit UDR.
	SPI_SR_CHSIDE_Pos = 0x2   // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4   // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4   // Bit CHSIDE.
	SPI_SR_TXE_Pos    = 0x1   // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2   // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2   // Bit TXE.
	SPI_SR_RXNE_Pos   = 0x0   // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1   // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1   // Bit RXNE.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa   // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400 // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400 // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRMP: memory remap register
	SYSCFG_MEMRMP_MEM_MODE_Pos  = 0x0   // Position of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Msk  = 0x3   // Bit mask of MEM_MODE field.
	SYSCFG_MEMRMP_BOOT_MODE_Pos = 0x8   // Position of BOOT_MODE field.
	SYSCFG_MEMRMP_BOOT_MODE_Msk = 0x300 // Bit mask of BOOT_MODE field.

	// PMC: peripheral mode configuration           register
	SYSCFG_PMC_USB_PU_Pos = 0x0 // Position of USB_PU field.
	SYSCFG_PMC_USB_PU_Msk = 0x1 // Bit mask of USB_PU field.
	SYSCFG_PMC_USB_PU     = 0x1 // Bit USB_PU.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.
)

// Bitfields for USB: Universal serial bus full-speed device interface
const (
	// USB_EP0R: endpoint 0 register
	USB_USB_EP0R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP0R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP0R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP0R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP0R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP0R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP0R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP0R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP0R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP0R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP0R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP0R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP0R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP0R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP0R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP0R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP0R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP0R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP0R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP0R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP0R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP0R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP0R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP0R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP0R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP0R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP1R: endpoint 1 register
	USB_USB_EP1R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP1R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP1R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP1R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP1R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP1R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP1R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP1R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP1R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP1R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP1R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP1R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP1R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP1R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP1R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP1R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP1R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP1R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP1R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP1R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP1R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP1R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP1R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP1R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP1R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP1R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP2R: endpoint 2 register
	USB_USB_EP2R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP2R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP2R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP2R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP2R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP2R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP2R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP2R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP2R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP2R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP2R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP2R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP2R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP2R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP2R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP2R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP2R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP2R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP2R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP2R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP2R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP2R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP2R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP2R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP2R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP2R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP3R: endpoint 3 register
	USB_USB_EP3R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP3R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP3R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP3R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP3R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP3R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP3R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP3R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP3R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP3R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP3R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP3R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP3R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP3R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP3R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP3R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP3R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP3R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP3R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP3R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP3R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP3R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP3R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP3R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP3R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP3R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP4R: endpoint 4 register
	USB_USB_EP4R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP4R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP4R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP4R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP4R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP4R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP4R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP4R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP4R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP4R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP4R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP4R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP4R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP4R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP4R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP4R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP4R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP4R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP4R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP4R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP4R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP4R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP4R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP4R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP4R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP4R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP5R: endpoint 5 register
	USB_USB_EP5R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP5R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP5R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP5R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP5R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP5R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP5R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP5R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP5R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP5R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP5R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP5R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP5R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP5R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP5R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP5R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP5R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP5R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP5R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP5R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP5R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP5R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP5R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP5R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP5R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP5R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP6R: endpoint 6 register
	USB_USB_EP6R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP6R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP6R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP6R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP6R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP6R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP6R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP6R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP6R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP6R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP6R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP6R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP6R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP6R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP6R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP6R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP6R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP6R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP6R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP6R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP6R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP6R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP6R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP6R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP6R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP6R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP7R: endpoint 7 register
	USB_USB_EP7R_EA_Pos      = 0x0    // Position of EA field.
	USB_USB_EP7R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_USB_EP7R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_USB_EP7R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_USB_EP7R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_USB_EP7R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_USB_EP7R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_USB_EP7R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_USB_EP7R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_USB_EP7R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_USB_EP7R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_USB_EP7R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_USB_EP7R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_USB_EP7R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_USB_EP7R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_USB_EP7R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_USB_EP7R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_USB_EP7R_SETUP       = 0x800  // Bit SETUP.
	USB_USB_EP7R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_USB_EP7R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_USB_EP7R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_USB_EP7R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_USB_EP7R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_USB_EP7R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_USB_EP7R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_USB_EP7R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_CNTR: control register
	USB_USB_CNTR_FRES_Pos    = 0x0    // Position of FRES field.
	USB_USB_CNTR_FRES_Msk    = 0x1    // Bit mask of FRES field.
	USB_USB_CNTR_FRES        = 0x1    // Bit FRES.
	USB_USB_CNTR_PDWN_Pos    = 0x1    // Position of PDWN field.
	USB_USB_CNTR_PDWN_Msk    = 0x2    // Bit mask of PDWN field.
	USB_USB_CNTR_PDWN        = 0x2    // Bit PDWN.
	USB_USB_CNTR_LPMODE_Pos  = 0x2    // Position of LPMODE field.
	USB_USB_CNTR_LPMODE_Msk  = 0x4    // Bit mask of LPMODE field.
	USB_USB_CNTR_LPMODE      = 0x4    // Bit LPMODE.
	USB_USB_CNTR_FSUSP_Pos   = 0x3    // Position of FSUSP field.
	USB_USB_CNTR_FSUSP_Msk   = 0x8    // Bit mask of FSUSP field.
	USB_USB_CNTR_FSUSP       = 0x8    // Bit FSUSP.
	USB_USB_CNTR_RESUME_Pos  = 0x4    // Position of RESUME field.
	USB_USB_CNTR_RESUME_Msk  = 0x10   // Bit mask of RESUME field.
	USB_USB_CNTR_RESUME      = 0x10   // Bit RESUME.
	USB_USB_CNTR_ESOFM_Pos   = 0x8    // Position of ESOFM field.
	USB_USB_CNTR_ESOFM_Msk   = 0x100  // Bit mask of ESOFM field.
	USB_USB_CNTR_ESOFM       = 0x100  // Bit ESOFM.
	USB_USB_CNTR_SOFM_Pos    = 0x9    // Position of SOFM field.
	USB_USB_CNTR_SOFM_Msk    = 0x200  // Bit mask of SOFM field.
	USB_USB_CNTR_SOFM        = 0x200  // Bit SOFM.
	USB_USB_CNTR_RESETM_Pos  = 0xa    // Position of RESETM field.
	USB_USB_CNTR_RESETM_Msk  = 0x400  // Bit mask of RESETM field.
	USB_USB_CNTR_RESETM      = 0x400  // Bit RESETM.
	USB_USB_CNTR_SUSPM_Pos   = 0xb    // Position of SUSPM field.
	USB_USB_CNTR_SUSPM_Msk   = 0x800  // Bit mask of SUSPM field.
	USB_USB_CNTR_SUSPM       = 0x800  // Bit SUSPM.
	USB_USB_CNTR_WKUPM_Pos   = 0xc    // Position of WKUPM field.
	USB_USB_CNTR_WKUPM_Msk   = 0x1000 // Bit mask of WKUPM field.
	USB_USB_CNTR_WKUPM       = 0x1000 // Bit WKUPM.
	USB_USB_CNTR_ERRM_Pos    = 0xd    // Position of ERRM field.
	USB_USB_CNTR_ERRM_Msk    = 0x2000 // Bit mask of ERRM field.
	USB_USB_CNTR_ERRM        = 0x2000 // Bit ERRM.
	USB_USB_CNTR_PMAOVRM_Pos = 0xe    // Position of PMAOVRM field.
	USB_USB_CNTR_PMAOVRM_Msk = 0x4000 // Bit mask of PMAOVRM field.
	USB_USB_CNTR_PMAOVRM     = 0x4000 // Bit PMAOVRM.
	USB_USB_CNTR_CTRM_Pos    = 0xf    // Position of CTRM field.
	USB_USB_CNTR_CTRM_Msk    = 0x8000 // Bit mask of CTRM field.
	USB_USB_CNTR_CTRM        = 0x8000 // Bit CTRM.

	// ISTR: interrupt status register
	USB_ISTR_EP_ID_Pos  = 0x0    // Position of EP_ID field.
	USB_ISTR_EP_ID_Msk  = 0xf    // Bit mask of EP_ID field.
	USB_ISTR_DIR_Pos    = 0x4    // Position of DIR field.
	USB_ISTR_DIR_Msk    = 0x10   // Bit mask of DIR field.
	USB_ISTR_DIR        = 0x10   // Bit DIR.
	USB_ISTR_ESOF_Pos   = 0x8    // Position of ESOF field.
	USB_ISTR_ESOF_Msk   = 0x100  // Bit mask of ESOF field.
	USB_ISTR_ESOF       = 0x100  // Bit ESOF.
	USB_ISTR_SOF_Pos    = 0x9    // Position of SOF field.
	USB_ISTR_SOF_Msk    = 0x200  // Bit mask of SOF field.
	USB_ISTR_SOF        = 0x200  // Bit SOF.
	USB_ISTR_RESET_Pos  = 0xa    // Position of RESET field.
	USB_ISTR_RESET_Msk  = 0x400  // Bit mask of RESET field.
	USB_ISTR_RESET      = 0x400  // Bit RESET.
	USB_ISTR_SUSP_Pos   = 0xb    // Position of SUSP field.
	USB_ISTR_SUSP_Msk   = 0x800  // Bit mask of SUSP field.
	USB_ISTR_SUSP       = 0x800  // Bit SUSP.
	USB_ISTR_WKUP_Pos   = 0xc    // Position of WKUP field.
	USB_ISTR_WKUP_Msk   = 0x1000 // Bit mask of WKUP field.
	USB_ISTR_WKUP       = 0x1000 // Bit WKUP.
	USB_ISTR_ERR_Pos    = 0xd    // Position of ERR field.
	USB_ISTR_ERR_Msk    = 0x2000 // Bit mask of ERR field.
	USB_ISTR_ERR        = 0x2000 // Bit ERR.
	USB_ISTR_PMAOVR_Pos = 0xe    // Position of PMAOVR field.
	USB_ISTR_PMAOVR_Msk = 0x4000 // Bit mask of PMAOVR field.
	USB_ISTR_PMAOVR     = 0x4000 // Bit PMAOVR.
	USB_ISTR_CTR_Pos    = 0xf    // Position of CTR field.
	USB_ISTR_CTR_Msk    = 0x8000 // Bit mask of CTR field.
	USB_ISTR_CTR        = 0x8000 // Bit CTR.

	// FNR: frame number register
	USB_FNR_FN_Pos   = 0x0    // Position of FN field.
	USB_FNR_FN_Msk   = 0x7ff  // Bit mask of FN field.
	USB_FNR_LSOF_Pos = 0xb    // Position of LSOF field.
	USB_FNR_LSOF_Msk = 0x1800 // Bit mask of LSOF field.
	USB_FNR_LCK_Pos  = 0xd    // Position of LCK field.
	USB_FNR_LCK_Msk  = 0x2000 // Bit mask of LCK field.
	USB_FNR_LCK      = 0x2000 // Bit LCK.
	USB_FNR_RXDM_Pos = 0xe    // Position of RXDM field.
	USB_FNR_RXDM_Msk = 0x4000 // Bit mask of RXDM field.
	USB_FNR_RXDM     = 0x4000 // Bit RXDM.
	USB_FNR_RXDP_Pos = 0xf    // Position of RXDP field.
	USB_FNR_RXDP_Msk = 0x8000 // Bit mask of RXDP field.
	USB_FNR_RXDP     = 0x8000 // Bit RXDP.

	// DADDR: device address
	USB_DADDR_ADD_Pos = 0x0  // Position of ADD field.
	USB_DADDR_ADD_Msk = 0x7f // Bit mask of ADD field.
	USB_DADDR_EF_Pos  = 0x7  // Position of EF field.
	USB_DADDR_EF_Msk  = 0x80 // Bit mask of EF field.
	USB_DADDR_EF      = 0x80 // Bit EF.

	// BTABLE: Buffer table address
	USB_BTABLE_BTABLE_Pos = 0x3    // Position of BTABLE field.
	USB_BTABLE_BTABLE_Msk = 0xfff8 // Bit mask of BTABLE field.
)

// Bitfields for USART3: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	USART_SR_CTS_Pos  = 0x9   // Position of CTS field.
	USART_SR_CTS_Msk  = 0x200 // Bit mask of CTS field.
	USART_SR_CTS      = 0x200 // Bit CTS.
	USART_SR_LBD_Pos  = 0x8   // Position of LBD field.
	USART_SR_LBD_Msk  = 0x100 // Bit mask of LBD field.
	USART_SR_LBD      = 0x100 // Bit LBD.
	USART_SR_TXE_Pos  = 0x7   // Position of TXE field.
	USART_SR_TXE_Msk  = 0x80  // Bit mask of TXE field.
	USART_SR_TXE      = 0x80  // Bit TXE.
	USART_SR_TC_Pos   = 0x6   // Position of TC field.
	USART_SR_TC_Msk   = 0x40  // Bit mask of TC field.
	USART_SR_TC       = 0x40  // Bit TC.
	USART_SR_RXNE_Pos = 0x5   // Position of RXNE field.
	USART_SR_RXNE_Msk = 0x20  // Bit mask of RXNE field.
	USART_SR_RXNE     = 0x20  // Bit RXNE.
	USART_SR_IDLE_Pos = 0x4   // Position of IDLE field.
	USART_SR_IDLE_Msk = 0x10  // Bit mask of IDLE field.
	USART_SR_IDLE     = 0x10  // Bit IDLE.
	USART_SR_ORE_Pos  = 0x3   // Position of ORE field.
	USART_SR_ORE_Msk  = 0x8   // Bit mask of ORE field.
	USART_SR_ORE      = 0x8   // Bit ORE.
	USART_SR_NF_Pos   = 0x2   // Position of NF field.
	USART_SR_NF_Msk   = 0x4   // Bit mask of NF field.
	USART_SR_NF       = 0x4   // Bit NF.
	USART_SR_FE_Pos   = 0x1   // Position of FE field.
	USART_SR_FE_Msk   = 0x2   // Bit mask of FE field.
	USART_SR_FE       = 0x2   // Bit FE.
	USART_SR_PE_Pos   = 0x0   // Position of PE field.
	USART_SR_PE_Msk   = 0x1   // Bit mask of PE field.
	USART_SR_PE       = 0x1   // Bit PE.

	// DR: Data register
	USART_DR_DR_Pos = 0x0   // Position of DR field.
	USART_DR_DR_Msk = 0x1ff // Bit mask of DR field.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// CR1: Control register 1
	USART_CR1_OVER8_Pos  = 0xf    // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000 // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000 // Bit OVER8.
	USART_CR1_UE_Pos     = 0xd    // Position of UE field.
	USART_CR1_UE_Msk     = 0x2000 // Bit mask of UE field.
	USART_CR1_UE         = 0x2000 // Bit UE.
	USART_CR1_M_Pos      = 0xc    // Position of M field.
	USART_CR1_M_Msk      = 0x1000 // Bit mask of M field.
	USART_CR1_M          = 0x1000 // Bit M.
	USART_CR1_WAKE_Pos   = 0xb    // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800  // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800  // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa    // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400  // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400  // Bit PCE.
	USART_CR1_PS_Pos     = 0x9    // Position of PS field.
	USART_CR1_PS_Msk     = 0x200  // Bit mask of PS field.
	USART_CR1_PS         = 0x200  // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8    // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100  // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100  // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7    // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80   // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80   // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6    // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40   // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40   // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5    // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20   // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20   // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4    // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10   // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10   // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3    // Position of TE field.
	USART_CR1_TE_Msk     = 0x8    // Bit mask of TE field.
	USART_CR1_TE         = 0x8    // Bit TE.
	USART_CR1_RE_Pos     = 0x2    // Position of RE field.
	USART_CR1_RE_Msk     = 0x4    // Bit mask of RE field.
	USART_CR1_RE         = 0x4    // Bit RE.
	USART_CR1_RWU_Pos    = 0x1    // Position of RWU field.
	USART_CR1_RWU_Msk    = 0x2    // Bit mask of RWU field.
	USART_CR1_RWU        = 0x2    // Bit RWU.
	USART_CR1_SBK_Pos    = 0x0    // Position of SBK field.
	USART_CR1_SBK_Msk    = 0x1    // Bit mask of SBK field.
	USART_CR1_SBK        = 0x1    // Bit SBK.

	// CR2: Control register 2
	USART_CR2_LINEN_Pos = 0xe    // Position of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000 // Bit mask of LINEN field.
	USART_CR2_LINEN     = 0x4000 // Bit LINEN.
	USART_CR2_STOP_Pos  = 0xc    // Position of STOP field.
	USART_CR2_STOP_Msk  = 0x3000 // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos = 0xb    // Position of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800  // Bit mask of CLKEN field.
	USART_CR2_CLKEN     = 0x800  // Bit CLKEN.
	USART_CR2_CPOL_Pos  = 0xa    // Position of CPOL field.
	USART_CR2_CPOL_Msk  = 0x400  // Bit mask of CPOL field.
	USART_CR2_CPOL      = 0x400  // Bit CPOL.
	USART_CR2_CPHA_Pos  = 0x9    // Position of CPHA field.
	USART_CR2_CPHA_Msk  = 0x200  // Bit mask of CPHA field.
	USART_CR2_CPHA      = 0x200  // Bit CPHA.
	USART_CR2_LBCL_Pos  = 0x8    // Position of LBCL field.
	USART_CR2_LBCL_Msk  = 0x100  // Bit mask of LBCL field.
	USART_CR2_LBCL      = 0x100  // Bit LBCL.
	USART_CR2_LBDIE_Pos = 0x6    // Position of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40   // Bit mask of LBDIE field.
	USART_CR2_LBDIE     = 0x40   // Bit LBDIE.
	USART_CR2_LBDL_Pos  = 0x5    // Position of LBDL field.
	USART_CR2_LBDL_Msk  = 0x20   // Bit mask of LBDL field.
	USART_CR2_LBDL      = 0x20   // Bit LBDL.
	USART_CR2_ADD_Pos   = 0x0    // Position of ADD field.
	USART_CR2_ADD_Msk   = 0xf    // Bit mask of ADD field.

	// CR3: Control register 3
	USART_CR3_ONEBIT_Pos = 0xb   // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800 // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT     = 0x800 // Bit ONEBIT.
	USART_CR3_CTSIE_Pos  = 0xa   // Position of CTSIE field.
	USART_CR3_CTSIE_Msk  = 0x400 // Bit mask of CTSIE field.
	USART_CR3_CTSIE      = 0x400 // Bit CTSIE.
	USART_CR3_CTSE_Pos   = 0x9   // Position of CTSE field.
	USART_CR3_CTSE_Msk   = 0x200 // Bit mask of CTSE field.
	USART_CR3_CTSE       = 0x200 // Bit CTSE.
	USART_CR3_RTSE_Pos   = 0x8   // Position of RTSE field.
	USART_CR3_RTSE_Msk   = 0x100 // Bit mask of RTSE field.
	USART_CR3_RTSE       = 0x100 // Bit RTSE.
	USART_CR3_DMAT_Pos   = 0x7   // Position of DMAT field.
	USART_CR3_DMAT_Msk   = 0x80  // Bit mask of DMAT field.
	USART_CR3_DMAT       = 0x80  // Bit DMAT.
	USART_CR3_DMAR_Pos   = 0x6   // Position of DMAR field.
	USART_CR3_DMAR_Msk   = 0x40  // Bit mask of DMAR field.
	USART_CR3_DMAR       = 0x40  // Bit DMAR.
	USART_CR3_SCEN_Pos   = 0x5   // Position of SCEN field.
	USART_CR3_SCEN_Msk   = 0x20  // Bit mask of SCEN field.
	USART_CR3_SCEN       = 0x20  // Bit SCEN.
	USART_CR3_NACK_Pos   = 0x4   // Position of NACK field.
	USART_CR3_NACK_Msk   = 0x10  // Bit mask of NACK field.
	USART_CR3_NACK       = 0x10  // Bit NACK.
	USART_CR3_HDSEL_Pos  = 0x3   // Position of HDSEL field.
	USART_CR3_HDSEL_Msk  = 0x8   // Bit mask of HDSEL field.
	USART_CR3_HDSEL      = 0x8   // Bit HDSEL.
	USART_CR3_IRLP_Pos   = 0x2   // Position of IRLP field.
	USART_CR3_IRLP_Msk   = 0x4   // Bit mask of IRLP field.
	USART_CR3_IRLP       = 0x4   // Bit IRLP.
	USART_CR3_IREN_Pos   = 0x1   // Position of IREN field.
	USART_CR3_IREN_Msk   = 0x2   // Bit mask of IREN field.
	USART_CR3_IREN       = 0x2   // Bit IREN.
	USART_CR3_EIE_Pos    = 0x0   // Position of EIE field.
	USART_CR3_EIE_Msk    = 0x1   // Bit mask of EIE field.
	USART_CR3_EIE        = 0x1   // Bit EIE.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos    = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk    = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI        = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB1_Pos = 0x8   // Position of WDGTB1 field.
	WWDG_CFR_WDGTB1_Msk = 0x100 // Bit mask of WDGTB1 field.
	WWDG_CFR_WDGTB1     = 0x100 // Bit WDGTB1.
	WWDG_CFR_WDGTB0_Pos = 0x7   // Position of WDGTB0 field.
	WWDG_CFR_WDGTB0_Msk = 0x80  // Bit mask of WDGTB0 field.
	WWDG_CFR_WDGTB0     = 0x80  // Bit WDGTB0.
	WWDG_CFR_W_Pos      = 0x0   // Position of W field.
	WWDG_CFR_W_Msk      = 0x7f  // Bit mask of W field.

	// SR: SR
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)
