/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.SSLConf;
import org.apache.tomcat.util.net.openssl.OpenSSLConfCmd;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLConf
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(OpenSSLConf.class);
    private static final StringManager sm = StringManager.getManager(OpenSSLConf.class);
    private final List<OpenSSLConfCmd> commands = new ArrayList<OpenSSLConfCmd>();

    public void addCmd(OpenSSLConfCmd openSSLConfCmd) {
        this.commands.add(openSSLConfCmd);
    }

    public List<OpenSSLConfCmd> getCommands() {
        return this.commands;
    }

    public boolean check(long l) throws Exception {
        boolean bl = true;
        Iterator<OpenSSLConfCmd> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            int n;
            OpenSSLConfCmd openSSLConfCmd;
            OpenSSLConfCmd openSSLConfCmd2 = openSSLConfCmd = iterator.next();
            String string = openSSLConfCmd2.getName();
            String string2 = openSSLConfCmd2.getValue();
            if (string == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{string2}));
                bl = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("opensslconf.checkCommand", new Object[]{string, string2}));
            }
            try {
                n = SSLConf.check((long)l, (String)string, (String)string2);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("opensslconf.checkFailed"));
                return false;
            }
            if (n <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{string, string2, Integer.toString(n)}));
                bl = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("opensslconf.resultCommand", new Object[]{string, string2, Integer.toString(n)}));
        }
        if (!bl) {
            log.error((Object)sm.getString("opensslconf.checkFailed"));
        }
        return bl;
    }

    public boolean apply(long l, long l2) throws Exception {
        int n;
        boolean bl = true;
        SSLConf.assign((long)l, (long)l2);
        Iterator<OpenSSLConfCmd> iterator = this.commands.iterator();
        while (iterator.hasNext()) {
            OpenSSLConfCmd openSSLConfCmd;
            OpenSSLConfCmd openSSLConfCmd2 = openSSLConfCmd = iterator.next();
            String string = openSSLConfCmd2.getName();
            String string2 = openSSLConfCmd2.getValue();
            if (string == null) {
                log.error((Object)sm.getString("opensslconf.noCommandName", new Object[]{string2}));
                bl = false;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("opensslconf.applyCommand", new Object[]{string, string2}));
            }
            try {
                n = SSLConf.apply((long)l, (String)string, (String)string2);
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("opensslconf.applyFailed"));
                return false;
            }
            if (n <= 0) {
                log.error((Object)sm.getString("opensslconf.failedCommand", new Object[]{string, string2, Integer.toString(n)}));
                bl = false;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("opensslconf.resultCommand", new Object[]{string, string2, Integer.toString(n)}));
        }
        n = SSLConf.finish((long)l);
        if (n <= 0) {
            log.error((Object)sm.getString("opensslconf.finishFailed", new Object[]{Integer.toString(n)}));
            bl = false;
        }
        if (!bl) {
            log.error((Object)sm.getString("opensslconf.applyFailed"));
        }
        return bl;
    }
}

