DeclareGlobalFunction( "MAJORANA_NClosedSetUp" );

DeclareGlobalFunction( "MAJORANA_NClosedNullspace" );

#! @Chapter Majorana representations
#! @Section The n-closed function

#! A Majorana algebra $V$ generated by a set of axes $A$ is called $n$-closed if
#! it is spanned as a vector space by products of elements of $A$ of length at most $n$.
#! As most known Majorana algebras are $2$-closed, the function <Ref Func="MajoranaRepresentation"/>
#! only attempts to construct the $2$-closed part.
#!
#! If it is not successful then the output is a partial Majorana representation,
#! i.e. a Majorana representation with some missing algebra products.
#! In this case, the function <Ref Func="MAJORANA_IsComplete"/>
#! returns false.
#!
#! If the user wishes, they may then pass this incomplete Majorana representation to the
#! function <Ref Func="NClosedMajoranaRepresentation"/> in order to attempt construction
#! of the $3$-closed part. This process may then be repeated as many times as the
#! user wishes.

#! @Arguments rep
#! @Description Takes as its input an incomplete Majorana representation rep that has been
#! generated using the function <Ref Func="MajoranaRepresentation"/>. Again runs the
#! main algorithm in order to attempt construction of the $3$-closed part of the algebra.
#! If the function <Ref Func="NClosedMajoranaRepresentation"/> is called $n$ times on the same
#! Majorana representation rep then this representation will be the $n + 2$-closed part of the algebra.
DeclareGlobalFunction( "NClosedMajoranaRepresentation" );
