/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import cc.arduino.utils.network.FileDownloaderCache;
import cc.arduino.utils.network.HttpConnectionManager;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Observable;
import java.util.Optional;
import javax.script.ScriptException;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import processing.app.helpers.FileUtils;

public class FileDownloader
extends Observable {
    private static Logger log = LogManager.getLogger(FileDownloader.class);
    private Status status;
    private long initialSize;
    private Long downloadSize = null;
    private long downloaded;
    private final URL downloadUrl;
    private final File outputFile;
    private final boolean allowCache;
    private Exception error;

    public FileDownloader(URL url, File file, boolean allowCache) {
        this.downloadUrl = url;
        this.outputFile = file;
        this.allowCache = allowCache;
        this.downloaded = 0L;
        this.initialSize = 0L;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public Long getDownloadSize() {
        return this.downloadSize;
    }

    public void setDownloadSize(Long downloadSize) {
        this.downloadSize = downloadSize;
        this.setChanged();
        this.notifyObservers();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    private void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
        this.setChanged();
        this.notifyObservers();
    }

    public float getProgress() {
        if (this.downloadSize == null) {
            return 0.0f;
        }
        if (this.downloadSize == 0L) {
            return 100.0f;
        }
        return (float)this.downloaded / (float)this.downloadSize.longValue() * 100.0f;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.setChanged();
        this.notifyObservers();
    }

    public void download(boolean noResume) throws InterruptedException {
        if ("file".equals(this.downloadUrl.getProtocol())) {
            this.saveLocalFile();
        } else {
            this.downloadFile(noResume);
        }
    }

    private void saveLocalFile() {
        try {
            Files.write(this.outputFile.toPath(), Files.readAllBytes(Paths.get(this.downloadUrl.getPath(), new String[0])), new OpenOption[0]);
            this.setStatus(Status.COMPLETE);
        }
        catch (Exception e) {
            this.setStatus(Status.ERROR);
            this.setError(e);
        }
    }

    public static void invalidateFiles(URL ... filesUrl) {
        Arrays.stream(filesUrl).forEach(url -> {
            try {
                FileDownloaderCache.getFileCached(url).ifPresent(fileCached -> {
                    try {
                        log.info("Invalidate this file {} that comes from {}", (Object)fileCached.getLocalPath(), (Object)fileCached.getRemoteURL());
                        fileCached.invalidateCache();
                    }
                    catch (Exception e) {
                        log.warn("Fail to invalidate cache", (Throwable)e);
                    }
                });
            }
            catch (IOException | NoSuchMethodException | URISyntaxException | ScriptException e) {
                log.warn("Fail to get the file cached during the file invalidation", (Throwable)e);
            }
        });
    }

    private void downloadFile(boolean noResume) throws InterruptedException {
        try {
            this.setStatus(Status.CONNECTING);
            Optional<FileDownloaderCache.FileCached> fileCachedOpt = FileDownloaderCache.getFileCached(this.downloadUrl, this.allowCache);
            if (fileCachedOpt.isPresent()) {
                FileDownloaderCache.FileCached fileCached = fileCachedOpt.get();
                Optional<File> fileFromCache = this.getFileCached(fileCached);
                if (fileCached.isNotChange() && fileFromCache.isPresent()) {
                    log.info("The file will be taken from the cache {}", fileFromCache);
                    FileUtils.copyFile(fileFromCache.get(), this.outputFile);
                } else {
                    this.openConnectionAndFillTheFile(noResume);
                    fileCached.updateCacheFile(this.outputFile);
                }
            } else {
                this.openConnectionAndFillTheFile(noResume);
            }
            this.setStatus(Status.COMPLETE);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCELLED);
            throw e;
        }
        catch (SocketTimeoutException e) {
            this.setStatus(Status.CONNECTION_TIMEOUT_ERROR);
            this.setError(e);
            log.error("The request went in socket timeout", (Throwable)e);
        }
        catch (Exception e) {
            this.setStatus(Status.ERROR);
            this.setError(e);
            log.error("The request stop", (Throwable)e);
        }
    }

    private Optional<File> getFileCached(FileDownloaderCache.FileCached fileCached) {
        try {
            Optional<File> fileFromCache = fileCached.getFileFromCache();
            if (fileFromCache.isPresent()) {
                log.info("No need to download using cached file: {}", (Object)fileCached);
                return fileFromCache;
            }
            log.info("The file in the cache is not in the path or the md5 validation failed: path={}, file exist={}, md5 validation={}", (Object)fileCached.getLocalPath(), (Object)fileCached.exists(), (Object)fileCached.md5Check());
        }
        catch (Exception e) {
            log.warn("Cannot get the file from the cache, will be downloaded a new one ", (Throwable)e);
        }
        log.info("The file is change {}", (Object)fileCached);
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConnectionAndFillTheFile(boolean noResume) throws Exception {
        HttpURLConnection connection;
        int resp;
        this.initialSize = this.outputFile.length();
        if (noResume && this.initialSize > 0L) {
            Files.deleteIfExists(this.outputFile.toPath());
            this.initialSize = 0L;
        }
        if ((resp = (connection = new HttpConnectionManager(this.downloadUrl).makeConnection(c -> this.setDownloaded(0L))).getResponseCode()) < 200 || resp >= 300) {
            Files.deleteIfExists(this.outputFile.toPath());
            throw new IOException("Received invalid http status code from server: " + resp);
        }
        RandomAccessFile randomAccessOutputFile = null;
        try {
            randomAccessOutputFile = new RandomAccessFile(this.outputFile, "rw");
            randomAccessOutputFile.seek(this.initialSize);
            this.readStreamCopyTo(randomAccessOutputFile, connection);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(randomAccessOutputFile);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)randomAccessOutputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStreamCopyTo(RandomAccessFile randomAccessOutputFile, HttpURLConnection connection) throws Exception {
        InputStream stream = null;
        try {
            int read;
            long len = connection.getContentLength();
            if (len >= 0L) {
                this.setDownloadSize(len);
            }
            this.setStatus(Status.DOWNLOADING);
            stream = connection.getInputStream();
            byte[] buffer = new byte[10240];
            while (this.status == Status.DOWNLOADING && (read = stream.read(buffer)) != -1) {
                randomAccessOutputFile.write(buffer, 0, read);
                this.setDownloaded(this.getDownloaded() + (long)read);
                if (!Thread.interrupted()) continue;
                randomAccessOutputFile.close();
                throw new InterruptedException();
            }
            if (this.getDownloadSize() != null && this.getDownloaded() < this.getDownloadSize()) {
                throw new Exception("Incomplete download");
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)stream);
    }

    private void setError(Exception e) {
        this.error = e;
    }

    public Exception getError() {
        return this.error;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETE;
    }

    public static enum Status {
        CONNECTING,
        CONNECTION_TIMEOUT_ERROR,
        DOWNLOADING,
        COMPLETE,
        CANCELLED,
        ERROR;

    }
}

