/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.Calendar;
import org.apache.batik.anim.dom.SVGOMAnimationElement;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.bridge.SVGAnimationElementBridge;
import org.apache.batik.dom.events.DOMTimeEvent;
import org.apache.batik.dom.svg.IdContainer;
import org.apache.batik.dom.svg.SVGOMUseShadowRoot;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class AnimationSupport {
    public static void fireTimeEvent(EventTarget eventTarget, String string, Calendar calendar, int n) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)((Node)((Object)eventTarget)).getOwnerDocument());
        DOMTimeEvent dOMTimeEvent = (DOMTimeEvent)documentEvent.createEvent("TimeEvent");
        dOMTimeEvent.initTimeEventNS("http://www.w3.org/2001/xml-events", string, null, n);
        dOMTimeEvent.setTimestamp(calendar.getTime().getTime());
        eventTarget.dispatchEvent((Event)dOMTimeEvent);
    }

    public static TimedElement getTimedElementById(String string, Node node) {
        Element element = AnimationSupport.getElementById(string, node);
        if (element instanceof SVGOMAnimationElement) {
            SVGAnimationElementBridge sVGAnimationElementBridge = (SVGAnimationElementBridge)((SVGOMAnimationElement)element).getSVGContext();
            return sVGAnimationElementBridge.getTimedElement();
        }
        return null;
    }

    public static EventTarget getEventTargetById(String string, Node node) {
        return (EventTarget)((Object)AnimationSupport.getElementById(string, node));
    }

    protected static Element getElementById(String string, Node node) {
        Node node2 = node.getParentNode();
        while (node2 != null) {
            node = node2;
            if (node instanceof SVGOMUseShadowRoot) {
                node2 = ((SVGOMUseShadowRoot)node).getCSSParentNode();
                continue;
            }
            node2 = node.getParentNode();
        }
        if (node instanceof IdContainer) {
            return ((IdContainer)node).getElementById(string);
        }
        return null;
    }
}

