/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.revwalk.FIFORevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;

final class DelayRevQueue
extends Generator {
    private static final int OVER_SCAN = 6;
    private final Generator pending;
    private final FIFORevQueue delay;
    private int size;

    DelayRevQueue(Generator g2) {
        this.pending = g2;
        this.delay = new FIFORevQueue();
    }

    @Override
    int outputType() {
        return this.pending.outputType();
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (this.size < 6 && (c = this.pending.next()) != null) {
            this.delay.add(c);
            ++this.size;
        }
        c = this.delay.next();
        if (c == null) {
            return null;
        }
        --this.size;
        return c;
    }
}

