/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class InferConsts
implements CompilerPass {
    private final AbstractCompiler compiler;

    InferConsts(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node js) {
        ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new SyntacticScopeCreator(this.compiler));
        collector.process(js);
        for (Var v : collector.getAllSymbols()) {
            this.considerVar(v, collector.getReferences(v));
        }
        AbstractScope globalExternsScope = new SyntacticScopeCreator(this.compiler).createScope(externs, (AbstractScope)null);
        for (Var v : globalExternsScope.getAllSymbols()) {
            this.considerVar(v, null);
        }
    }

    private void considerVar(Var v, ReferenceCollection refCollection) {
        Node nameNode = v.getNameNode();
        JSDocInfo docInfo = v.getJSDocInfo();
        if (docInfo != null && docInfo.isConstant()) {
            nameNode.setDeclaredConstantVar(true);
        } else if (nameNode != null && nameNode.getParent().isConst()) {
            nameNode.setDeclaredConstantVar(true);
        } else if (nameNode != null && this.compiler.getCodingConvention().isConstant(nameNode.getString())) {
            nameNode.setDeclaredConstantVar(true);
        }
        if (InferConsts.isInferredConst(v, refCollection)) {
            nameNode.setInferredConstantVar(true);
        }
    }

    private static boolean isInferredConst(Var v, ReferenceCollection refCollection) {
        Node nameNode = v.getNameNode();
        if (nameNode == null || refCollection == null || !refCollection.isAssignedOnceInLifetime()) {
            return false;
        }
        Token declarationType = v.declarationType();
        switch (declarationType) {
            case LET: {
                return !nameNode.getParent().isLet() || nameNode.hasChildren();
            }
            case CONST: 
            case CATCH: 
            case CLASS: 
            case PARAM_LIST: 
            case FUNCTION: {
                return true;
            }
            case IMPORT: {
                return false;
            }
            case VAR: {
                return refCollection.firstReferenceIsAssigningDeclaration() && refCollection.isWellDefined();
            }
        }
        throw new IllegalStateException("Unrecognized declaration type " + (Object)((Object)declarationType));
    }
}

