/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.LatticeElement;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MaybeReachingVariableUse
extends DataFlowAnalysis<Node, ReachingUses> {
    private final Set<Var> escaped = new HashSet<Var>();
    private final Map<String, Var> allVarsInFn = new HashMap<String, Var>();

    MaybeReachingVariableUse(ControlFlowGraph<Node> cfg, Scope jsScope, AbstractCompiler compiler, SyntacticScopeCreator scopeCreator) {
        super(cfg, new ReachingUsesJoinOp());
        ArrayList<Var> orderedVars = new ArrayList<Var>();
        MaybeReachingVariableUse.computeEscaped((Scope)jsScope.getParent(), this.escaped, compiler, scopeCreator);
        NodeUtil.getAllVarsDeclaredInFunction(this.allVarsInFn, orderedVars, compiler, scopeCreator, (Scope)jsScope.getParent());
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    ReachingUses createEntryLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses createInitialEstimateLattice() {
        return new ReachingUses();
    }

    @Override
    ReachingUses flowThrough(Node n, ReachingUses input) {
        ReachingUses output = new ReachingUses(input);
        boolean conditional = this.hasExceptionHandler(n);
        this.computeMayUse(n, n, output, conditional);
        return output;
    }

    private boolean hasExceptionHandler(Node cfgNode) {
        List branchEdges = this.getCfg().getOutEdges(cfgNode);
        for (DiGraph.DiGraphEdge diGraphEdge : branchEdges) {
            if (diGraphEdge.getValue() != ControlFlowGraph.Branch.ON_EX) continue;
            return true;
        }
        return false;
    }

    private void computeMayUse(Node n, Node cfgNode, ReachingUses output, boolean conditional) {
        switch (n.getToken()) {
            case BLOCK: 
            case ROOT: 
            case FUNCTION: {
                return;
            }
            case NAME: {
                if (NodeUtil.isLhsByDestructuring(n)) {
                    if (!conditional) {
                        this.removeFromUseIfLocal(n.getString(), output);
                    }
                } else {
                    this.addToUseIfLocal(n.getString(), cfgNode, output);
                }
                return;
            }
            case WHILE: 
            case DO: 
            case IF: 
            case FOR: {
                Node condExpr = NodeUtil.getConditionExpression(n);
                this.computeMayUse(condExpr, cfgNode, output, conditional);
                return;
            }
            case FOR_IN: 
            case FOR_OF: 
            case FOR_AWAIT_OF: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (NodeUtil.isNameDeclaration(lhs) && (lhs = lhs.getLastChild()).isDestructuringLhs()) {
                    lhs = lhs.getFirstChild();
                }
                if (lhs.isName() && !conditional) {
                    this.removeFromUseIfLocal(lhs.getString(), output);
                } else if (lhs.isDestructuringPattern()) {
                    this.computeMayUse(lhs, cfgNode, output, true);
                }
                this.computeMayUse(rhs, cfgNode, output, conditional);
                return;
            }
            case AND: 
            case OR: 
            case COALESCE: 
            case OPTCHAIN_GETPROP: 
            case OPTCHAIN_GETELEM: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case OPTCHAIN_CALL: {
                for (Node c = n.getLastChild(); c != n.getFirstChild(); c = c.getPrevious()) {
                    this.computeMayUse(c, cfgNode, output, true);
                }
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case HOOK: {
                this.computeMayUse(n.getLastChild(), cfgNode, output, true);
                this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                return;
            }
            case VAR: 
            case LET: 
            case CONST: {
                Node varName = n.getFirstChild();
                Preconditions.checkState(n.hasChildren(), "AST should be normalized", (Object)n);
                if (varName.isDestructuringLhs()) {
                    this.computeMayUse(varName.getFirstChild(), cfgNode, output, conditional);
                    this.computeMayUse(varName.getSecondChild(), cfgNode, output, conditional);
                } else if (varName.hasChildren()) {
                    this.computeMayUse(varName.getFirstChild(), cfgNode, output, conditional);
                    if (!conditional) {
                        this.removeFromUseIfLocal(varName.getString(), output);
                    }
                }
                return;
            }
            case DEFAULT_VALUE: {
                if (n.getFirstChild().isDestructuringPattern()) {
                    this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                    this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                    break;
                }
                if (n.getFirstChild().isName()) {
                    if (!conditional) {
                        this.removeFromUseIfLocal(n.getFirstChild().getString(), output);
                    }
                    this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                    break;
                }
                this.computeMayUse(n.getSecondChild(), cfgNode, output, true);
                this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                break;
            }
            default: {
                if (NodeUtil.isAssignmentOp(n) && n.getFirstChild().isName()) {
                    Node name = n.getFirstChild();
                    if (!conditional) {
                        this.removeFromUseIfLocal(name.getString(), output);
                    }
                    if (!n.isAssign()) {
                        this.addToUseIfLocal(name.getString(), cfgNode, output);
                    }
                    this.computeMayUse(name.getNext(), cfgNode, output, conditional);
                    break;
                }
                if (n.isAssign() && n.getFirstChild().isDestructuringPattern()) {
                    this.computeMayUse(n.getFirstChild(), cfgNode, output, conditional);
                    this.computeMayUse(n.getSecondChild(), cfgNode, output, conditional);
                    break;
                }
                for (Node c = n.getLastChild(); c != null; c = c.getPrevious()) {
                    this.computeMayUse(c, cfgNode, output, conditional);
                }
            }
        }
    }

    private void addToUseIfLocal(String name, Node node, ReachingUses use) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.mayUseMap.put(var, node);
        }
    }

    private void removeFromUseIfLocal(String name, ReachingUses use) {
        Var var = this.allVarsInFn.get(name);
        if (var == null) {
            return;
        }
        if (!this.escaped.contains(var)) {
            use.mayUseMap.removeAll(var);
        }
    }

    Collection<Node> getUses(String name, Node defNode) {
        DiGraph.DiGraphNode n = this.getCfg().getNode(defNode);
        Preconditions.checkNotNull(n);
        DataFlowAnalysis.FlowState state = (DataFlowAnalysis.FlowState)n.getAnnotation();
        return ((ReachingUses)state.getOut()).mayUseMap.get(this.allVarsInFn.get(name));
    }

    private static class ReachingUsesJoinOp
    implements JoinOp<ReachingUses> {
        private ReachingUsesJoinOp() {
        }

        @Override
        public ReachingUses apply(List<ReachingUses> from) {
            ReachingUses result = new ReachingUses();
            for (ReachingUses uses : from) {
                result.mayUseMap.putAll(uses.mayUseMap);
            }
            return result;
        }
    }

    static final class ReachingUses
    implements LatticeElement {
        final Multimap<Var, Node> mayUseMap;

        public ReachingUses() {
            this.mayUseMap = HashMultimap.create();
        }

        public ReachingUses(ReachingUses other) {
            this.mayUseMap = MultimapBuilder.hashKeys().hashSetValues().build((Multimap)other.mayUseMap);
        }

        public boolean equals(Object other) {
            return other instanceof ReachingUses && ((ReachingUses)other).mayUseMap.equals(this.mayUseMap);
        }

        public int hashCode() {
            return this.mayUseMap.hashCode();
        }
    }
}

