/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractScope;
import com.google.javascript.jscomp.BasicBlock;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Reference;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.ReferenceCollection;
import com.google.javascript.jscomp.ReferenceMap;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class VariableReferenceCheck
implements HotSwapCompilerPass {
    static final DiagnosticType EARLY_REFERENCE = DiagnosticType.warning("JSC_REFERENCE_BEFORE_DECLARE", "Variable referenced before declaration: {0}");
    static final DiagnosticType EARLY_EXPORTS_REFERENCE = DiagnosticType.error("JSC_EXPORTS_REFERENCE_BEFORE_ASSIGN", "Illegal reference to `exports` before assignment `exports = ...`");
    static final DiagnosticType REDECLARED_VARIABLE = DiagnosticType.warning("JSC_REDECLARED_VARIABLE", "Redeclared variable: {0}");
    static final DiagnosticType EARLY_REFERENCE_ERROR = DiagnosticType.error("JSC_REFERENCE_BEFORE_DECLARE_ERROR", "Illegal variable reference before declaration: {0}");
    static final DiagnosticType REASSIGNED_CONSTANT = DiagnosticType.error("JSC_REASSIGNED_CONSTANT", "Constant reassigned: {0}");
    static final DiagnosticType REDECLARED_VARIABLE_ERROR = DiagnosticType.error("JSC_REDECLARED_VARIABLE_ERROR", "Illegal redeclared variable: {0}");
    static final DiagnosticType DECLARATION_NOT_DIRECTLY_IN_BLOCK = DiagnosticType.error("JSC_DECLARATION_NOT_DIRECTLY_IN_BLOCK", "Block-scoped declaration not directly within block: {0}");
    static final DiagnosticType UNUSED_LOCAL_ASSIGNMENT = DiagnosticType.disabled("JSC_UNUSED_LOCAL_ASSIGNMENT", "Value assigned to local variable {0} is never read");
    private final AbstractCompiler compiler;
    private final boolean forTranspileOnly;
    private final boolean checkUnusedLocals;
    private final Set<BasicBlock> blocksWithDeclarations = new HashSet<BasicBlock>();
    private static final ImmutableSet<Token> BLOCKLESS_DECLARATION_FORBIDDEN_STATEMENTS = Sets.immutableEnumSet((Enum)Token.IF, (Enum[])new Token[]{Token.FOR, Token.FOR_IN, Token.FOR_OF, Token.FOR_AWAIT_OF, Token.WHILE});

    public VariableReferenceCheck(AbstractCompiler compiler) {
        this(compiler, false);
    }

    VariableReferenceCheck(AbstractCompiler compiler, boolean forTranspileOnly) {
        this.compiler = compiler;
        this.forTranspileOnly = forTranspileOnly;
        this.checkUnusedLocals = compiler.getOptions().enables(DiagnosticGroup.forType(UNUSED_LOCAL_ASSIGNMENT));
    }

    private boolean shouldProcess(Node root) {
        if (!this.forTranspileOnly) {
            return true;
        }
        if (this.compiler.getOptions().getLanguageIn().toFeatureSet().contains(FeatureSet.ES6)) {
            for (Node singleRoot : root.children()) {
                if (!TranspilationPasses.isScriptEs6OrHigher(singleRoot)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.shouldProcess(root)) {
            new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior(), new SyntacticScopeCreator(this.compiler)).process(externs, root);
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        if (!this.forTranspileOnly || this.compiler.getOptions().getLanguageIn().toFeatureSet().contains(FeatureSet.ES6) && TranspilationPasses.isScriptEs6OrHigher(scriptRoot)) {
            new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior(), new SyntacticScopeCreator(this.compiler)).hotSwapScript(scriptRoot, originalRoot);
        }
    }

    private Reference lookForHoistedFunction(List<Reference> references) {
        for (Reference reference : references) {
            if (!reference.isHoistedFunction()) continue;
            this.blocksWithDeclarations.add(reference.getBasicBlock());
            return reference;
        }
        return null;
    }

    private void checkBlocklessDeclaration(Var v, Reference reference, Node referenceNode) {
        if (!reference.isVarDeclaration() && reference.getGrandparent().isAddedBlock() && BLOCKLESS_DECLARATION_FORBIDDEN_STATEMENTS.contains((Object)reference.getGrandparent().getParent().getToken())) {
            this.compiler.report(JSError.make(referenceNode, DECLARATION_NOT_DIRECTLY_IN_BLOCK, v.getName()));
        }
    }

    private boolean checkRedeclaration(Var v, Reference reference, Node referenceNode, Reference hoistedFn, BasicBlock basicBlock) {
        boolean allowDupe = VarCheck.hasDuplicateDeclarationSuppression(this.compiler, referenceNode, v.getNameNode());
        boolean letConstShadowsVar = v.getParentNode().isVar() && (reference.isLetDeclaration() || reference.isConstDeclaration());
        boolean isVarNodeSameAsReferenceNode = v.getNode() == reference.getNode();
        boolean shadowCatchVar = v.getParentNode().isCatch() && !isVarNodeSameAsReferenceNode;
        boolean shadowParam = v.isParam() && NodeUtil.isBlockScopedDeclaration(referenceNode) && v.getScope() == reference.getScope().getParent();
        boolean shadowDetected = false;
        if (!allowDupe) {
            for (BasicBlock declaredBlock : this.blocksWithDeclarations) {
                DiagnosticType diagnosticType;
                if (!declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                shadowDetected = true;
                Node warningNode = referenceNode;
                if (v.isLet() || v.isConst() || v.isClass() || letConstShadowsVar || shadowCatchVar || shadowParam || v.isImport()) {
                    diagnosticType = REDECLARED_VARIABLE_ERROR;
                } else {
                    if (reference.getNode().getParent().isCatch() || allowDupe) {
                        return false;
                    }
                    DiagnosticType diagnosticType2 = diagnosticType = ((Scope)v.getScope()).isGlobal() ? VarCheck.VAR_MULTIPLY_DECLARED_ERROR : REDECLARED_VARIABLE;
                    if (isVarNodeSameAsReferenceNode && hoistedFn != null && v.getName().equals(hoistedFn.getNode().getString())) {
                        warningNode = hoistedFn.getNode();
                    }
                }
                this.compiler.report(JSError.make(warningNode, diagnosticType, v.getName(), v.getInput() != null ? v.getInput().getName() : "??"));
                return true;
            }
        }
        if (!shadowDetected && (letConstShadowsVar || shadowCatchVar) && v.getScope() == reference.getScope()) {
            this.compiler.report(JSError.make(referenceNode, REDECLARED_VARIABLE_ERROR, v.getName()));
            return true;
        }
        return false;
    }

    private boolean checkEarlyReference(Var v, Reference reference, Node referenceNode) {
        if (!referenceNode.isFromExterns()) {
            if (v.isVar()) {
                Node curr;
                for (curr = reference.getParent(); curr.isOr() && curr.getParent().getFirstChild() == curr; curr = curr.getParent()) {
                }
                if (curr.isName() && curr.getString().equals(v.getName())) {
                    return false;
                }
            }
            if (reference.getScope().hasSameContainerScope((Scope)v.getScope()) && !v.getName().equals("goog")) {
                this.compiler.report(JSError.make(reference.getNode(), v.isGoogModuleExports() ? EARLY_EXPORTS_REFERENCE : (v.isLet() || v.isConst() || v.isClass() || v.isParam() ? EARLY_REFERENCE_ERROR : EARLY_REFERENCE), v.getName()));
                return true;
            }
        }
        return false;
    }

    private void checkForUnusedLocalVar(Var v, Reference unusedAssignment) {
        Node lhs;
        Node rhs;
        Node statement;
        if (!v.isLocal()) {
            return;
        }
        JSDocInfo jsDoc = NodeUtil.getBestJSDocInfo(unusedAssignment.getNode());
        if (jsDoc != null && jsDoc.hasTypedefType()) {
            return;
        }
        boolean inGoogScope = false;
        Scope s = (Scope)v.getScope();
        if (s.isFunctionBlockScope()) {
            Node function = s.getRootNode().getParent();
            Node callee = function.getPrevious();
            boolean bl = inGoogScope = callee != null && callee.matchesQualifiedName("goog.scope");
        }
        if (inGoogScope) {
            return;
        }
        if (s.isModuleScope() && NodeUtil.isNameDeclaration(statement = NodeUtil.getEnclosingStatement(v.getNode())) && (rhs = (lhs = statement.getFirstChild()).getFirstChild()) != null && (NodeUtil.isCallTo(rhs, "goog.forwardDeclare") || NodeUtil.isCallTo(rhs, "goog.requireType") || NodeUtil.isCallTo(rhs, "goog.require") || rhs.isQualifiedName())) {
            return;
        }
        this.compiler.report(JSError.make(unusedAssignment.getNode(), UNUSED_LOCAL_ASSIGNMENT, v.getName()));
    }

    private class ReferenceCheckingBehavior
    implements ReferenceCollectingCallback.Behavior {
        private final Set<String> varsInFunctionBody = new HashSet<String>();

        private ReferenceCheckingBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceMap referenceMap) {
            Scope scope;
            if (t.inGlobalScope()) {
                VariableReferenceCheck.this.compiler.updateGlobalVarReferences(((ReferenceCollectingCallback.ReferenceMapWrapper)referenceMap).getRawReferenceMap(), t.getScopeRoot());
                referenceMap = VariableReferenceCheck.this.compiler.getGlobalVarReferences();
            }
            if ((scope = t.getScope()).isFunctionBlockScope()) {
                this.varsInFunctionBody.clear();
                for (Var v : scope.getVarIterable()) {
                    this.varsInFunctionBody.add(v.getName());
                }
            }
            for (Var v : scope.getVarIterable()) {
                ReferenceCollection referenceCollection = referenceMap.getReferences(v);
                if (referenceCollection == null) continue;
                if (scope.getRootNode().isFunction() && v.isDefaultParam()) {
                    this.checkDefaultParam(v, scope, this.varsInFunctionBody);
                }
                if (scope.getRootNode().isFunction()) {
                    this.checkShadowParam(v, scope, referenceCollection.references);
                }
                this.checkVar(v, referenceCollection.references);
            }
            if (scope.hasOwnImplicitSlot(AbstractScope.ImplicitVar.EXPORTS)) {
                this.checkGoogModuleExports(scope.makeImplicitVar(AbstractScope.ImplicitVar.EXPORTS), referenceMap);
            }
        }

        private void checkDefaultParam(Var param, final Scope scope, final Set<String> varsInFunctionBody) {
            NodeTraversal.traverse(VariableReferenceCheck.this.compiler, param.getParentNode().getSecondChild(), new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (!NodeUtil.isReferenceName(n)) {
                        return;
                    }
                    String refName = n.getString();
                    if (varsInFunctionBody.contains(refName) && !scope.hasSlot(refName)) {
                        VariableReferenceCheck.this.compiler.report(JSError.make(n, EARLY_REFERENCE_ERROR, refName));
                    }
                }
            });
        }

        private void checkShadowParam(Var v, Scope functionScope, List<Reference> references) {
            Var maybeParam = (Var)functionScope.getVar(v.getName());
            if (maybeParam != null && maybeParam.isParam() && maybeParam.getScope() == functionScope) {
                for (Reference r : references) {
                    if (!r.isVarDeclaration() && !r.isHoistedFunction() || r.getNode() == v.getNameNode()) continue;
                    VariableReferenceCheck.this.compiler.report(JSError.make(r.getNode(), REDECLARED_VARIABLE, v.getName()));
                }
            }
        }

        private void checkGoogModuleExports(Var exportsVar, ReferenceMap referenceMap) {
            ReferenceCollection references = referenceMap.getReferences(exportsVar);
            if (references == null || references.isNeverAssigned()) {
                return;
            }
            for (Reference reference : references.references) {
                if (reference.isLvalue()) break;
                VariableReferenceCheck.this.checkEarlyReference(exportsVar, reference, reference.getNode());
            }
        }

        private void checkVar(Var v, List<Reference> references) {
            VariableReferenceCheck.this.blocksWithDeclarations.clear();
            boolean hasSeenDeclaration = false;
            boolean hasErrors = false;
            boolean isRead = false;
            Reference unusedAssignment = null;
            Reference hoistedFn = VariableReferenceCheck.this.lookForHoistedFunction(references);
            if (hoistedFn != null) {
                hasSeenDeclaration = true;
            }
            for (Reference reference : references) {
                boolean isAssignment;
                if (reference == hoistedFn) continue;
                Node referenceNode = reference.getNode();
                BasicBlock basicBlock = reference.getBasicBlock();
                boolean isDeclaration = reference.isDeclaration();
                boolean bl = isAssignment = isDeclaration || reference.isLvalue();
                if (isDeclaration) {
                    hasSeenDeclaration = true;
                    hasErrors = VariableReferenceCheck.this.checkRedeclaration(v, reference, referenceNode, hoistedFn, basicBlock);
                    VariableReferenceCheck.this.blocksWithDeclarations.add(basicBlock);
                    VariableReferenceCheck.this.checkBlocklessDeclaration(v, reference, referenceNode);
                    if (reference.getGrandparent().isExport()) {
                        isRead = true;
                    }
                } else {
                    if (!hasSeenDeclaration) {
                        hasErrors = VariableReferenceCheck.this.checkEarlyReference(v, reference, referenceNode);
                    }
                    if (!hasErrors && v.isConst() && reference.isLvalue()) {
                        VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, REASSIGNED_CONSTANT, v.getName()));
                    }
                    if ((v.isLet() || v.isConst()) && v.getScope() == reference.getScope() && NodeUtil.isEnhancedFor(reference.getScope().getRootNode())) {
                        VariableReferenceCheck.this.compiler.report(JSError.make(referenceNode, EARLY_REFERENCE_ERROR, v.getName()));
                    }
                }
                if (isAssignment) {
                    boolean lhsOfForInLoop;
                    Reference decl = references.get(0);
                    Node declNode = decl.getNode();
                    Node gp = declNode.getGrandparent();
                    boolean bl2 = lhsOfForInLoop = gp.isForIn() && gp.getFirstFirstChild() == declNode;
                    if (decl.getScope().isLocal() && (decl.isVarDeclaration() || decl.isLetDeclaration() || decl.isConstDeclaration()) && !decl.getNode().isFromExterns() && !lhsOfForInLoop) {
                        unusedAssignment = reference;
                    }
                    if (!reference.getParent().isDec() && !reference.getParent().isInc() && !NodeUtil.isCompoundAssignmentOp(reference.getParent()) || !NodeUtil.isExpressionResultUsed(reference.getNode())) continue;
                    isRead = true;
                    continue;
                }
                isRead = true;
            }
            if (VariableReferenceCheck.this.checkUnusedLocals && unusedAssignment != null && !isRead && !hasErrors) {
                VariableReferenceCheck.this.checkForUnusedLocalVar(v, unusedAssignment);
            }
        }
    }
}

