/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.disambiguate.PropertyClustering;
import com.google.javascript.rhino.jstype.JSType;
import java.util.BitSet;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

final class FlatType {
    private final Arity arity;
    @Nullable
    private final JSType typeSingle;
    @Nullable
    private final ImmutableSet<FlatType> typeUnion;
    private final int id;
    private final LinkedHashSet<PropertyClustering> associatedProps = new LinkedHashSet();
    private final BitSet subtypeIds = new BitSet();
    private boolean invalidating = false;

    static FlatType createForSingle(JSType single, int id) {
        Preconditions.checkNotNull(single);
        Preconditions.checkArgument(!single.isNullType());
        Preconditions.checkArgument(!single.isVoidType());
        Preconditions.checkArgument(!single.isNoType());
        Preconditions.checkArgument(!single.isUnknownType());
        Preconditions.checkArgument(!single.isTemplatizedType());
        Preconditions.checkArgument(!single.isUnionType());
        Preconditions.checkArgument(id >= 0);
        return new FlatType(single, id);
    }

    static FlatType createForUnion(ImmutableSet<FlatType> union, int id) {
        Preconditions.checkArgument(union.size() > 1);
        for (FlatType alt : union) {
            Preconditions.checkArgument(alt.hasArity(Arity.SINGLE));
        }
        Preconditions.checkArgument(id >= 0);
        return new FlatType(union, id);
    }

    @VisibleForTesting
    static FlatType createForTesting(int id) {
        Preconditions.checkArgument(id < 0);
        return new FlatType((JSType)null, id);
    }

    private FlatType(JSType single, int id) {
        this.id = id;
        this.arity = Arity.SINGLE;
        this.typeUnion = null;
        this.typeSingle = single;
    }

    private FlatType(ImmutableSet<FlatType> union, int id) {
        this.id = id;
        this.arity = Arity.UNION;
        this.typeUnion = union;
        this.typeSingle = null;
    }

    Arity getArity() {
        return this.arity;
    }

    boolean hasArity(Arity x) {
        return this.arity.equals((Object)x);
    }

    JSType getTypeSingle() {
        return Preconditions.checkNotNull(this.typeSingle);
    }

    ImmutableSet<FlatType> getTypeUnion() {
        return Preconditions.checkNotNull(this.typeUnion);
    }

    int getId() {
        return this.id;
    }

    LinkedHashSet<PropertyClustering> getAssociatedProps() {
        return this.associatedProps;
    }

    BitSet getSubtypeIds() {
        return this.subtypeIds;
    }

    boolean isInvalidating() {
        return this.invalidating;
    }

    void setInvalidating() {
        this.invalidating = true;
    }

    @DoNotCall
    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("type_single", this.typeSingle).add("type_union", this.typeUnion).toString();
    }

    static enum Arity {
        SINGLE,
        UNION;

    }
}

