/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.instrumentation;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.debugging.sourcemap.Base64VLQ;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstManipulations;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@GwtIncompatible
final class ProductionCoverageInstrumentationCallback
implements NodeTraversal.Callback {
    private final String instrumentationArrayName;
    private final AbstractCompiler compiler;
    private final ParameterMapping parameterMapping;
    private static final String ANONYMOUS_FUNCTION_NAME = "<Anonymous>";
    private final Deque<String> functionNameStack = new ArrayDeque<String>();

    public ProductionCoverageInstrumentationCallback(AbstractCompiler compiler, String instrumentationArrayName) {
        this.compiler = compiler;
        this.parameterMapping = new ParameterMapping();
        this.instrumentationArrayName = instrumentationArrayName;
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (!n.isRoot() && !Objects.equals(t.getSourceName(), n.getSourceFileName())) {
            return false;
        }
        if (n.isFunction()) {
            String fnName = NodeUtil.getBestLValueName(NodeUtil.getBestLValue(n));
            fnName = fnName == null ? ANONYMOUS_FUNCTION_NAME : fnName;
            this.functionNameStack.push(fnName);
        }
        if (this.functionNameStack.isEmpty()) {
            this.functionNameStack.push(ANONYMOUS_FUNCTION_NAME);
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal traversal, Node node, Node parent) {
        String fileName = traversal.getSourceName();
        String sourceFileName = node.getSourceFileName();
        String functionName = this.functionNameStack.peek();
        switch (node.getToken()) {
            case FUNCTION: {
                this.functionNameStack.pop();
                this.instrumentBlockNode(node.getLastChild(), fileName, functionName, Type.FUNCTION);
                break;
            }
            case IF: {
                Node ifFalseNode;
                Node ifTrueNode = node.getSecondChild();
                this.instrumentBlockNode(ifTrueNode, sourceFileName, functionName, Type.BRANCH);
                if (node.getChildCount() == 2) {
                    this.addElseBlock(node);
                }
                if (!NodeUtil.isEmptyBlock(ifFalseNode = node.getLastChild()) && (!ifFalseNode.hasChildren() || ifFalseNode.getFirstChild().isIf())) break;
                this.instrumentBlockNode(ifFalseNode, sourceFileName, functionName, Type.BRANCH_DEFAULT);
                break;
            }
            case SWITCH: {
                boolean hasDefaultCase = false;
                for (Node c = node.getSecondChild(); c != null; c = c.getNext()) {
                    if (c.isDefaultCase()) {
                        this.instrumentBlockNode(c.getLastChild(), sourceFileName, functionName, Type.BRANCH_DEFAULT);
                        hasDefaultCase = true;
                        continue;
                    }
                    this.instrumentBlockNode(c.getLastChild(), sourceFileName, functionName, Type.BRANCH);
                }
                if (hasDefaultCase) break;
                Node defaultBlock = IR.block();
                defaultBlock.useSourceInfoIfMissingFromForTree(node);
                Node defaultCase = IR.defaultCase(defaultBlock).useSourceInfoIfMissingFromForTree(node);
                node.addChildToBack(defaultCase);
                this.instrumentBlockNode(defaultBlock, sourceFileName, functionName, Type.BRANCH_DEFAULT);
                break;
            }
            case HOOK: {
                Node ifTernaryIsTrueExpression = node.getSecondChild();
                Node ifTernaryIsFalseExpression = node.getLastChild();
                this.addInstrumentationNodeWithComma(ifTernaryIsTrueExpression, sourceFileName, functionName, Type.BRANCH);
                this.addInstrumentationNodeWithComma(ifTernaryIsFalseExpression, sourceFileName, functionName, Type.BRANCH);
                this.compiler.reportChangeToEnclosingScope(node);
                break;
            }
            case OR: 
            case AND: 
            case COALESCE: {
                Node secondExpression = node.getLastChild();
                this.addInstrumentationNodeWithComma(secondExpression, sourceFileName, functionName, Type.BRANCH);
                this.compiler.reportChangeToEnclosingScope(node);
                break;
            }
            default: {
                if (!NodeUtil.isLoopStructure(node)) break;
                Node blockNode = NodeUtil.getLoopCodeBlock(node);
                Preconditions.checkNotNull(blockNode);
                this.instrumentBlockNode(blockNode, sourceFileName, functionName, Type.BRANCH);
            }
        }
    }

    private void addInstrumentationNodeWithComma(Node originalNode, String fileName, String functionName, Type type) {
        Node parentNode = originalNode.getParent();
        Node cloneOfOriginal = originalNode.cloneTree();
        Node newInstrumentationNode = this.newInstrumentationNode(cloneOfOriginal, fileName, functionName, type);
        Node childOfInstrumentationNode = newInstrumentationNode.removeFirstChild();
        Node infusedExp = AstManipulations.fuseExpressions(childOfInstrumentationNode, cloneOfOriginal);
        parentNode.replaceChild(originalNode, infusedExp);
    }

    private void instrumentBlockNode(Node block, String fileName, String fnName, Type type) {
        block.addChildToFront(this.newInstrumentationNode(block, fileName, fnName, type));
        this.compiler.reportChangeToEnclosingScope(block);
    }

    private Node newInstrumentationNode(Node node, String fileName, String fnName, Type type) {
        int lineNo = node.getLineno();
        int columnNo = node.getCharno();
        if (node.isBlock()) {
            lineNo = node.getParent().getLineno();
            columnNo = node.getParent().getCharno();
        }
        String encodedParam = this.parameterMapping.getEncodedParam(fileName, fnName, type, lineNo, columnNo);
        Node prop = IR.getprop(IR.name(this.instrumentationArrayName), IR.string("push"));
        Node functionCall = IR.call(prop, IR.string(encodedParam));
        Node exprNode = IR.exprResult(functionCall);
        return exprNode.useSourceInfoIfMissingFromForTree(node);
    }

    private Node addElseBlock(Node node) {
        Node defaultBlock = IR.block();
        node.addChildToBack(defaultBlock);
        return defaultBlock.useSourceInfoIfMissingFromForTree(node);
    }

    public VariableMap getInstrumentationMapping() {
        return this.parameterMapping.getParamMappingAsVariableMap();
    }

    private static final class ParameterMapping {
        private final Map<String, String> paramValueEncodings = new HashMap<String, String>();
        private final Map<String, Integer> fileNameToIndex = new LinkedHashMap<String, Integer>();
        private final Map<String, Integer> functionNameToIndex = new LinkedHashMap<String, Integer>();
        private final Map<String, Integer> typeToIndex = new LinkedHashMap<String, Integer>();
        private long nextUniqueIdentifier = 0L;

        ParameterMapping() {
        }

        private String getEncodedParam(String fileName, String functionName, Type type, int lineNo, int colNo) {
            this.fileNameToIndex.putIfAbsent(fileName, this.fileNameToIndex.size());
            this.functionNameToIndex.putIfAbsent(functionName, this.functionNameToIndex.size());
            this.typeToIndex.putIfAbsent(type.name(), this.typeToIndex.size());
            StringBuilder sb = new StringBuilder();
            try {
                Base64VLQ.encode(sb, this.fileNameToIndex.get(fileName));
                Base64VLQ.encode(sb, this.functionNameToIndex.get(functionName));
                Base64VLQ.encode(sb, this.typeToIndex.get(type.name()));
                Base64VLQ.encode(sb, lineNo);
                Base64VLQ.encode(sb, colNo);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            String encodedParam = sb.toString();
            if (!this.paramValueEncodings.containsKey(encodedParam)) {
                long uniqueIdentifier = this.generateUniqueIdentifier();
                if (uniqueIdentifier > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Unique Identifier exceeds value of Integer.MAX_VALUE, could not encode with Base 64 VLQ");
                }
                sb = new StringBuilder();
                try {
                    Base64VLQ.encode(sb, Math.toIntExact(uniqueIdentifier));
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                this.paramValueEncodings.put(encodedParam, sb.toString());
            }
            return this.paramValueEncodings.get(encodedParam);
        }

        private long generateUniqueIdentifier() {
            ++this.nextUniqueIdentifier;
            return this.nextUniqueIdentifier;
        }

        private VariableMap getParamMappingAsVariableMap() {
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            this.paramValueEncodings.put(gson.toJson(this.fileNameToIndex.keySet()), " FileNames");
            this.paramValueEncodings.put(gson.toJson(this.functionNameToIndex.keySet()), " FunctionNames");
            this.paramValueEncodings.put(gson.toJson(this.typeToIndex.keySet()), " Types");
            VariableMap preInversedMap = new VariableMap(this.paramValueEncodings);
            ImmutableMap<String, String> inversedMap = preInversedMap.getNewNameToOriginalNameMap();
            return new VariableMap(inversedMap);
        }
    }

    private static enum Type {
        FUNCTION,
        BRANCH,
        BRANCH_DEFAULT;

    }
}

