/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;

final class RequireAliasGenerator
implements Iterable<String> {
    private static final ImmutableSet<String> SKIPLISTED_ALIASES = RequireAliasGenerator.createSkiplistedAliases();
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private final ImmutableList<String> parts;
    private final boolean capitalize;

    private static ImmutableSet<String> createSkiplistedAliases() {
        ImmutableSet<String> seeds = ImmutableSet.of("", "array", "event", "map", "math", "object", new String[]{"promise", "set", "string", "thenable"});
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String seed : seeds) {
            builder.add(RequireAliasGenerator.captializeFirstChar(seed));
            builder.add(Ascii.toLowerCase(seed));
        }
        return builder.build();
    }

    static Iterable<String> over(String namespace) {
        return new RequireAliasGenerator(namespace);
    }

    private RequireAliasGenerator(String namespace) {
        this.parts = ImmutableList.copyOf(DOT_SPLITTER.split(namespace)).reverse();
        this.capitalize = Ascii.isUpperCase(((String)this.parts.get(0)).charAt(0));
    }

    @Override
    public Iterator<String> iterator() {
        return new NameIterator();
    }

    private static String captializeFirstChar(String w) {
        if (w.isEmpty() || Ascii.isUpperCase(w.charAt(0))) {
            return w;
        }
        return Ascii.toUpperCase(w.charAt(0)) + w.substring(1);
    }

    private final class NameIterator
    extends AbstractIterator<String> {
        private String concat = "";
        private int index = 0;
        private int suffix = 0;

        private NameIterator() {
        }

        @Override
        protected String computeNext() {
            String next;
            do {
                next = this.computeNextWithoutFiltering();
            } while (SKIPLISTED_ALIASES.contains(next));
            return next;
        }

        private String computeNextWithoutFiltering() {
            if (this.index >= RequireAliasGenerator.this.parts.size()) {
                return this.concat + this.suffix++;
            }
            String part = (String)RequireAliasGenerator.this.parts.get(this.index++);
            if (RequireAliasGenerator.this.capitalize) {
                part = RequireAliasGenerator.captializeFirstChar(part);
            }
            this.concat = part + RequireAliasGenerator.captializeFirstChar(this.concat);
            return this.concat;
        }
    }
}

