/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.ExifWriterTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SaveLocationsMenu
extends JMenu
implements ActionListener,
MenuConstants {
    private static final I18n i18n = I18nFactory.getI18n(SaveLocationsMenu.class);
    private JMenuItem saveOneLocationItem;
    private JMenuItem saveSelectedLocationsItem;
    private JMenuItem saveAllLocationsItem;
    private ImageInfo currentImage;
    private ImagesTableModel tableModel;
    private int[] selectedRows;

    public SaveLocationsMenu(boolean backgroundTask, ImagesTable imagesTable, ImageInfo currentImage) {
        super(SAVE_LOCATIONS);
        this.populate(backgroundTask, imagesTable, currentImage);
    }

    public void populate(boolean backgroundTask, ImagesTable imagesTable, ImageInfo theCurrentImage) {
        boolean itemEnabled;
        this.removeAll();
        this.currentImage = theCurrentImage;
        this.tableModel = (ImagesTableModel)imagesTable.getModel();
        this.selectedRows = imagesTable.getSelectedRows();
        this.setEnabled(Exiftool.isAvailable());
        boolean menuEnabled = false;
        if (this.currentImage != null) {
            this.saveOneLocationItem = new JMenuItem(SAVE_THIS_LOCATION);
            itemEnabled = !backgroundTask && this.currentImage.hasNewLocation();
            menuEnabled |= itemEnabled;
            this.saveOneLocationItem.setEnabled(itemEnabled);
            this.saveOneLocationItem.addActionListener(this);
            this.add(this.saveOneLocationItem);
        }
        this.saveSelectedLocationsItem = new JMenuItem(SAVE_SELECTED_LOCATIONS);
        itemEnabled = false;
        int index = 0;
        while (index < this.selectedRows.length) {
            if (this.tableModel.getImageInfo(this.selectedRows[index]).hasNewLocation()) {
                itemEnabled = !backgroundTask;
                break;
            }
            ++index;
        }
        menuEnabled |= itemEnabled;
        this.saveSelectedLocationsItem.setEnabled(itemEnabled);
        this.saveSelectedLocationsItem.addActionListener(this);
        this.add(this.saveSelectedLocationsItem);
        this.saveAllLocationsItem = new JMenuItem(SAVE_ALL_LOCATIONS);
        itemEnabled = false;
        index = 0;
        while (index < this.tableModel.getRowCount()) {
            if (this.tableModel.getImageInfo(index).hasNewLocation()) {
                itemEnabled = !backgroundTask;
                break;
            }
            ++index;
        }
        this.saveAllLocationsItem.setEnabled(itemEnabled);
        this.saveAllLocationsItem.addActionListener(this);
        this.add(this.saveAllLocationsItem);
        this.setEnabled(menuEnabled |= itemEnabled);
    }

    private void saveLocations(List<ImageInfo> images) {
        TaskExecutor.execute(new ExifWriterTask(i18n.tr("Save new locations"), this.tableModel, images));
    }

    private void saveOneLocation() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.currentImage);
        this.saveLocations(images);
    }

    private void saveSelectedLocations() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            ImageInfo candidate = this.tableModel.getImageInfo(this.selectedRows[index]);
            if (candidate.hasNewLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        this.saveLocations(images);
    }

    private void saveAllLocations() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            ImageInfo candidate = this.tableModel.getImageInfo(index);
            if (candidate.hasNewLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        this.saveLocations(images);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.saveOneLocationItem) {
            this.saveOneLocation();
        } else if (event.getSource() == this.saveSelectedLocationsItem) {
            this.saveSelectedLocations();
        } else if (event.getSource() == this.saveAllLocationsItem) {
            this.saveAllLocations();
        }
    }
}

