/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font;

import com.jogamp.common.net.Uri;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.IntObjectHashMap;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.cache.TempJarCache;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.font.FontFactory;
import com.jogamp.graph.font.FontSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class UbuntuFontLoader
implements FontSet {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static final Uri.Encoded jarSubDir = Uri.Encoded.cast((String)"atomic/");
    private static final Uri.Encoded jarName = Uri.Encoded.cast((String)"jogl-fonts-p0.jar");
    private static final String absFontPath = "jogamp/graph/font/fonts/ubuntu/";
    private static final FontSet fontLoader = new UbuntuFontLoader();
    static final String[] availableFontFileNames = new String[]{"Ubuntu-R.ttf", "Ubuntu-RI.ttf", "Ubuntu-B.ttf", "Ubuntu-BI.ttf", "Ubuntu-L.ttf", "Ubuntu-LI.ttf", "Ubuntu-M.ttf", "Ubuntu-MI.ttf"};
    private static boolean attemptedJARLoading = false;
    private static boolean useTempJARCache = false;

    public static final FontSet get() {
        return fontLoader;
    }

    private UbuntuFontLoader() {
    }

    static boolean is(int n, int n2) {
        return 0 != (n & n2);
    }

    @Override
    public Font getDefault() throws IOException {
        return this.get(0, 0);
    }

    @Override
    public Font get(int n, int n2) throws IOException {
        Font font = (Font)fontMap.get(n << 8 | n2);
        if (font != null) {
            return font;
        }
        switch (n) {
            case 0: 
            case 3: 
            case 4: {
                if (UbuntuFontLoader.is(n2, 4)) {
                    if (UbuntuFontLoader.is(n2, 8)) {
                        font = this.abspath(availableFontFileNames[3], n, n2);
                        break;
                    }
                    font = this.abspath(availableFontFileNames[2], n, n2);
                    break;
                }
                if (UbuntuFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[1], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[0], n, n2);
                break;
            }
            case 1: {
                if (UbuntuFontLoader.is(n2, 8)) {
                    font = this.abspath(availableFontFileNames[5], n, n2);
                    break;
                }
                font = this.abspath(availableFontFileNames[4], n, n2);
                break;
            }
            case 2: {
                font = UbuntuFontLoader.is(n2, 8) ? this.abspath(availableFontFileNames[6], n, n2) : this.abspath(availableFontFileNames[7], n, n2);
            }
        }
        return font;
    }

    private synchronized Font abspath(String string, int n, int n2) throws IOException {
        Object object;
        if (!attemptedJARLoading) {
            attemptedJARLoading = true;
            Platform.initSingleton();
            if (TempJarCache.isInitialized()) {
                try {
                    object = JarUtil.getRelativeOf(UbuntuFontLoader.class, (Uri.Encoded)jarSubDir, (Uri.Encoded)jarName);
                    Exception exception = AccessController.doPrivileged(new PrivilegedAction<Exception>(){

                        @Override
                        public Exception run() {
                            try {
                                TempJarCache.addResources(UbuntuFontLoader.class, (Uri)object);
                                useTempJARCache = true;
                                return null;
                            }
                            catch (Exception exception) {
                                return exception;
                            }
                        }
                    });
                    if (null != exception) {
                        throw exception;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Caught " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        try {
            object = this.abspathImpl(absFontPath + string, n, n2);
            if (null != object) {
                return object;
            }
            throw new IOException(String.format("Problem loading font %s, stream %s%s", string, absFontPath, string));
        }
        catch (Exception exception) {
            throw new IOException(String.format("Problem loading font %s, stream %s%s", string, absFontPath, string), exception);
        }
    }

    private Font abspathImpl(final String string, int n, int n2) throws IOException {
        InputStream inputStream;
        Object object;
        if (useTempJARCache) {
            object = new Exception[]{null};
            inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>((Exception[])object){
                final /* synthetic */ Exception[] val$privErr;
                {
                    this.val$privErr = exceptionArray;
                }

                @Override
                public InputStream run() {
                    try {
                        Uri uri = TempJarCache.getResourceUri((String)string);
                        return null != uri ? uri.toURL().openConnection().getInputStream() : null;
                    }
                    catch (Exception exception) {
                        this.val$privErr[0] = exception;
                        return null;
                    }
                }
            });
            if (null != object[0]) {
                throw new IOException((Throwable)object[0]);
            }
        } else {
            object = IOUtil.getResource((String)string, (ClassLoader)this.getClass().getClassLoader(), null);
            InputStream inputStream2 = inputStream = null != object ? ((URLConnection)object).getInputStream() : null;
        }
        if (null != inputStream && null != (object = FontFactory.get(inputStream, true))) {
            fontMap.put(n << 8 | n2, object);
            return object;
        }
        return null;
    }
}

