/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.EditRelationAction;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class RecentRelationsAction
extends JosmAction
implements UndoRedoHandler.CommandQueueListener {
    private final SideButton editButton;
    private final BasicArrowButton arrow;
    private final Shortcut shortcut;
    private final LaunchEditorAction launchAction;

    public RecentRelationsAction(SideButton editButton) {
        super(RecentRelationsAction.class.getName(), null, null, null, false, true);
        this.editButton = editButton;
        this.arrow = editButton.createArrow(this);
        this.arrow.setToolTipText(I18n.tr("List of recent relations", new Object[0]));
        UndoRedoHandler.getInstance().addCommandQueueListener(this);
        this.enableArrow();
        this.shortcut = Shortcut.registerShortcut("relationeditor:editrecentrelation", I18n.tr("Relation Editor: {0}", I18n.tr("Open recent relation", new Object[0])), 27, 5005);
        this.launchAction = new LaunchEditorAction();
        MainApplication.registerActionShortcut(this.launchAction, this.shortcut);
    }

    public void enableArrow() {
        if (this.arrow != null) {
            this.arrow.setVisible(RecentRelationsAction.getLastRelation() != null);
        }
    }

    public static Relation getLastRelation() {
        List<Relation> recentRelations = RecentRelationsAction.getRecentRelationsOnActiveLayer();
        if (recentRelations == null || recentRelations.isEmpty()) {
            return null;
        }
        return recentRelations.stream().filter(RecentRelationsAction::isRelationListable).findFirst().orElse(null);
    }

    public static boolean isRelationListable(Relation relation) {
        return relation != null && !relation.isDeleted() && MainApplication.getLayerManager().getEditDataSet().containsRelation(relation);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RecentRelationsPopupMenu.launch(this.editButton, this.shortcut.getKeyStroke());
    }

    @Override
    public void commandChanged(int queueSize, int redoSize) {
        this.enableArrow();
    }

    @Override
    protected void updateEnabledState() {
        this.enableArrow();
    }

    @Override
    public void destroy() {
        MainApplication.unregisterActionShortcut(this.launchAction, this.shortcut);
        UndoRedoHandler.getInstance().removeCommandQueueListener(this);
        super.destroy();
    }

    public static List<Relation> getRecentRelationsOnActiveLayer() {
        if (!MainApplication.isDisplayingMapView()) {
            return Collections.emptyList();
        }
        Layer activeLayer = MainApplication.getLayerManager().getActiveLayer();
        if (!(activeLayer instanceof OsmDataLayer)) {
            return Collections.emptyList();
        }
        return ((OsmDataLayer)activeLayer).getRecentRelations();
    }

    static class RecentRelationsMenuItem
    extends JMenuItem
    implements ActionListener {
        private final transient Relation relation;

        RecentRelationsMenuItem(Relation relation) {
            super(relation.getDisplayName(DefaultNameFormatter.getInstance()));
            this.relation = relation;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditRelationAction.launchEditor(this.relation);
        }
    }

    static class RecentRelationsPopupMenu
    extends JPopupMenu {
        RecentRelationsPopupMenu(List<Relation> recentRelations, KeyStroke keystroke) {
            boolean first = true;
            for (Relation relation : recentRelations) {
                if (!RecentRelationsAction.isRelationListable(relation)) continue;
                RecentRelationsMenuItem menuItem = new RecentRelationsMenuItem(relation);
                if (first) {
                    menuItem.setAccelerator(keystroke);
                    first = false;
                }
                menuItem.setIcon(ImageProvider.getPadded(relation, ImageProvider.ImageSizes.MENU.getImageDimension()));
                this.add(menuItem);
            }
        }

        static void launch(Component parent, KeyStroke keystroke) {
            if (parent.isShowing()) {
                Rectangle r = parent.getBounds();
                new RecentRelationsPopupMenu(RecentRelationsAction.getRecentRelationsOnActiveLayer(), keystroke).show(parent, r.x, r.y + r.height);
            }
        }
    }

    static class LaunchEditorAction
    extends AbstractAction {
        LaunchEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditRelationAction.launchEditor(RecentRelationsAction.getLastRelation());
        }
    }
}

