/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.interpreter;

import java.io.ByteArrayOutputStream;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.RootNode;
import org.jruby.ir.IRBuilder;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRTranslator;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRBreakJump;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.ManyVarsDynamicScope;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class Interpreter
extends IRTranslator<IRubyObject, IRubyObject> {
    public static final Logger LOG = LoggerFactory.getLogger(Interpreter.class);
    public static final String ROOT = "<main>";
    static int interpInstrsCount = 0;

    public static void dumpStats() {
        if ((IRRuntimeHelpers.isDebug() || IRRuntimeHelpers.inProfileMode()) && interpInstrsCount > 10000) {
            LOG.info("-- Interpreted instructions: {}", interpInstrsCount);
        }
    }

    @Override
    protected IRubyObject execute(Ruby runtime2, IRScriptBody irScope, IRubyObject self2) {
        StaticScope scope;
        RubyModule currModule;
        InterpreterContext ic = irScope.getInterpreterContext();
        if (IRRuntimeHelpers.shouldPrintIR(runtime2)) {
            ByteArrayOutputStream baos = IRDumper.printIR(irScope, false);
            LOG.info("Printing simple IR for " + irScope.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
        }
        ThreadContext context = runtime2.getCurrentContext();
        String name2 = ROOT;
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info("Executing {}", ic);
        }
        if ((currModule = (scope = ic.getStaticScope()).getModule()) == null) {
            currModule = context.getRuntime().getObject();
        }
        scope.setModule(currModule);
        IRRuntimeHelpers.prepareScriptScope(context, scope);
        context.preNodeEval(self2);
        context.setCurrentVisibility(Visibility.PRIVATE);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_ROOT(context, self2, ic, currModule, name2);
            return iRubyObject;
        }
        catch (IRBreakJump bj) {
            throw IRException.BREAK_LocalJumpError.getException(context.runtime);
        }
        finally {
            irScope.cleanupAfterExecution();
            Interpreter.dumpStats();
            context.popScope();
            context.postNodeEval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, String name2) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(ThreadContext context, IRubyObject self2, InterpreterContext ic, RubyModule clazz, IRubyObject[] args2, String name2, Block blockArg) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, null, self2, ic, clazz, name2, args2, blockArg);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(ThreadContext context, Block block, IRubyObject self2, InterpreterContext ic, IRubyObject[] args2, String name2, Block blockArg) {
        try {
            ThreadContext.pushBacktrace(context, name2, ic.getFileName(), context.getLine());
            IRubyObject iRubyObject = ic.getEngine().interpret(context, block, self2, ic, null, name2, args2, blockArg);
            return iRubyObject;
        }
        finally {
            ThreadContext.popBacktrace(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalSimple(ThreadContext context, RubyModule under, IRubyObject self2, RubyString src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime2 = context.runtime;
        DynamicScope parentScope = context.getCurrentScope();
        ManyVarsDynamicScope evalScope = new ManyVarsDynamicScope(runtime2.getStaticScopeFactory().newEvalScope(parentScope.getStaticScope()), parentScope);
        evalScope.getStaticScope().setModule(under);
        context.pushEvalSimpleFrame(self2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, file2, lineNumber, "(eval)", Block.NULL_BLOCK, evalType);
            return iRubyObject;
        }
        finally {
            context.popFrame();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IRubyObject evalCommon(ThreadContext context, DynamicScope evalScope, IRubyObject self2, IRubyObject src, String file2, int lineNumber, String name2, Block blockArg, EvalType evalType) {
        StaticScope ss = evalScope.getStaticScope();
        InterpreterContext ic = Interpreter.prepareIC(context, evalScope, src, file2, lineNumber, evalType);
        evalScope.setEvalType(evalType);
        context.pushScope(evalScope);
        try {
            evalScope.growIfNeeded();
            IRubyObject iRubyObject = Interpreter.INTERPRET_EVAL(context, self2, ic, ic.getStaticScope().getModule(), IRubyObject.NULL_ARRAY, name2, blockArg);
            return iRubyObject;
        }
        finally {
            evalScope.clearEvalType();
            context.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self2, IRubyObject src, Binding binding2) {
        Ruby runtime2 = context.runtime;
        DynamicScope evalScope = binding2.getEvalScope(runtime2);
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject iRubyObject = Interpreter.evalCommon(context, evalScope, self2, src, binding2.getFile(), binding2.getLine(), binding2.getMethod(), binding2.getFrame().getBlock(), EvalType.BINDING_EVAL);
            return iRubyObject;
        }
        finally {
            context.postEvalWithBinding(binding2, lastFrame);
        }
    }

    private static InterpreterContext prepareIC(ThreadContext context, DynamicScope evalScope, IRubyObject src, String file2, int lineNumber, EvalType evalType) {
        Ruby runtime2 = context.runtime;
        IRScope containingIRScope = evalScope.getStaticScope().getEnclosingScope().getIRScope();
        RootNode rootNode = (RootNode)runtime2.parseEval(src.convertToString().getByteList(), file2, evalScope, lineNumber);
        StaticScope staticScope = evalScope.getStaticScope();
        IREvalScript script = new IREvalScript(runtime2.getIRManager(), containingIRScope, file2, lineNumber, staticScope, evalType);
        if (staticScope.getOverlayModuleForRead() != null || staticScope.getIRScope().maybeUsingRefinements()) {
            script.setIsMaybeUsingRefinements();
        }
        staticScope.setIRScope(script);
        InterpreterContext ic = IRBuilder.topIRBuilder(runtime2.getIRManager(), script).buildEvalRoot(rootNode);
        if (IRRuntimeHelpers.isDebug()) {
            LOG.info(script.debugOutput(), new Object[0]);
        }
        return ic;
    }
}

