/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.util;

import java.util.List;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyContext;
import org.jetbrains.kotlin.org.apache.ivy.util.Checks;
import org.jetbrains.kotlin.org.apache.ivy.util.DefaultMessageLogger;
import org.jetbrains.kotlin.org.apache.ivy.util.MessageLogger;
import org.jetbrains.kotlin.org.apache.ivy.util.StringUtils;

public final class Message {
    private static boolean showedInfo = false;
    private static MessageLogger defaultLogger = new DefaultMessageLogger(2);

    public static MessageLogger getDefaultLogger() {
        return defaultLogger;
    }

    public static void setDefaultLogger(MessageLogger logger) {
        Checks.checkNotNull(logger, "logger");
        defaultLogger = logger;
    }

    private static MessageLogger getLogger() {
        return IvyContext.getContext().getMessageLogger();
    }

    public static void debug(String msg) {
        Message.getLogger().debug(msg);
    }

    public static void verbose(String msg) {
        Message.getLogger().verbose(msg);
    }

    public static void info(String msg) {
        Message.getLogger().info(msg);
    }

    public static void rawinfo(String msg) {
        Message.getLogger().rawinfo(msg);
    }

    public static void deprecated(String msg) {
        Message.getLogger().deprecated(msg);
    }

    public static void warn(String msg) {
        Message.getLogger().warn(msg);
    }

    public static void error(String msg) {
        Message.getLogger().error(msg);
    }

    public static List<String> getProblems() {
        return Message.getLogger().getProblems();
    }

    public static void sumupProblems() {
        Message.getLogger().sumupProblems();
    }

    public static void progress() {
        Message.getLogger().progress();
    }

    public static void endProgress(String msg) {
        Message.getLogger().endProgress(msg);
    }

    private Message() {
    }

    public static void debug(String message2, Throwable t) {
        if (t == null) {
            Message.debug(message2);
        } else {
            Message.debug(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void verbose(String message2, Throwable t) {
        if (t == null) {
            Message.verbose(message2);
        } else {
            Message.verbose(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void info(String message2, Throwable t) {
        if (t == null) {
            Message.info(message2);
        } else {
            Message.info(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void warn(String message2, Throwable t) {
        if (t == null) {
            Message.warn(message2);
        } else {
            Message.warn(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void error(String message2, Throwable t) {
        if (t == null) {
            Message.error(message2);
        } else {
            Message.error(message2 + " (" + t.getClass().getName() + ": " + t.getMessage() + ")");
            Message.debug(t);
        }
    }

    public static void debug(Throwable t) {
        Message.debug(StringUtils.getStackTrace(t));
    }
}

