/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util.pid;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;
import java.util.function.Supplier;

public class JnaPidFactory {
    private static Supplier<String> instance;

    public static Supplier<String> getInstance() {
        return instance;
    }

    static {
        try {
            if (Platform.isLinux()) {
                CLibrary.INSTANCE.getpid();
                instance = () -> String.valueOf(CLibrary.INSTANCE.getpid());
            } else if (Platform.isWindows()) {
                try {
                    Kernel32.INSTANCE.GetCurrentProcessId();
                    instance = () -> String.valueOf(Kernel32.INSTANCE.GetCurrentProcessId());
                }
                catch (Throwable cle) {
                    instance = () -> null;
                }
            } else {
                instance = () -> null;
            }
        }
        catch (Throwable cle) {
            instance = () -> null;
        }
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int getpid();
    }
}

