/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextBlockJson
extends AbstractTextBlock
implements TextBlockBackcolored {
    private final List<Line> lines = new ArrayList<Line>();
    private final ISkinParam skinParam;
    private double totalWidth;
    private final JsonValue root;

    public TextBlockJson(ISkinParam skinParam, JsonValue root, List<String> highlighted) {
        this.skinParam = skinParam;
        this.root = root;
        if (root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)root) {
                String key = member.getName();
                String value = this.getShortString(member.getValue());
                TextBlock block1 = this.getTextBlock(key);
                TextBlock block2 = this.getTextBlock(value);
                this.lines.add(new Line(block1, block2, this.isHighlighted(key, highlighted)));
            }
        }
        if (root instanceof JsonArray) {
            int i = 0;
            for (JsonValue value : (JsonArray)root) {
                TextBlock block2 = this.getTextBlock(this.getShortString(value));
                this.lines.add(new Line(block2, this.isHighlighted("" + i, highlighted)));
                ++i;
            }
        }
    }

    private boolean isHighlighted(String key, List<String> highlighted) {
        for (String tmp : highlighted) {
            if (!tmp.trim().equals("\"" + key + "\"")) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                ++size;
            }
        }
        if (this.root instanceof JsonArray) {
            for (JsonValue value : (JsonArray)this.root) {
                ++size;
            }
        }
        return size;
    }

    private String getShortString(JsonValue value) {
        if (value.isString()) {
            return value.asString();
        }
        if (value.isNull()) {
            return "<U+2400>";
        }
        if (value.isNumber()) {
            return value.toString();
        }
        if (value.isBoolean()) {
            if (value.isTrue()) {
                return "<U+2611> true";
            }
            return "<U+2610> false";
        }
        return "   ";
    }

    public List<JsonValue> children() {
        ArrayList<JsonValue> result = new ArrayList<JsonValue>();
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                JsonValue value = member.getValue();
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    result.add(value);
                    continue;
                }
                result.add(null);
            }
        }
        if (this.root instanceof JsonArray) {
            for (JsonValue value : (JsonArray)this.root) {
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    result.add(value);
                    continue;
                }
                result.add(null);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> keys() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                String key = member.getName();
                result.add(key);
            }
        }
        if (this.root instanceof JsonArray) {
            int i = 0;
            for (JsonValue value : (JsonArray)this.root) {
                result.add("" + i);
                ++i;
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidthColA(stringBounder) + this.getWidthColB(stringBounder), this.getTotalHeight(stringBounder));
    }

    public double getWidthColA(StringBounder stringBounder) {
        double width = 0.0;
        for (Line line : this.lines) {
            width = Math.max(width, line.b1.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    public double getWidthColB(StringBounder stringBounder) {
        double width = 0.0;
        for (Line line : this.lines) {
            if (line.b2 == null) continue;
            width = Math.max(width, line.b2.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D fullDim = this.calculateDimension(stringBounder);
        double trueWidth = Math.max(fullDim.getWidth(), this.totalWidth);
        double widthColA = this.getWidthColA(stringBounder);
        double y = 0.0;
        ug = this.getStyle().applyStrokeAndLineColor(ug, this.skinParam.getIHtmlColorSet());
        for (Line line : this.lines) {
            UGraphic ugline = ug.apply(UTranslate.dy(y));
            double heightOfRow = line.getHeightOfRow(stringBounder);
            if (line.highlighted) {
                URectangle back = new URectangle(trueWidth - 2.0, heightOfRow).rounded(4.0);
                HColor yellow = this.skinParam.getIHtmlColorSet().getColorIfValid("#ccff02");
                ugline.apply(yellow).apply(yellow.bg()).apply(new UTranslate(1.5, 0.0)).draw(back);
            }
            if (y > 0.0) {
                ugline.draw(ULine.hline(trueWidth));
            }
            double posColA = (widthColA - line.b1.calculateDimension(stringBounder).getWidth()) / 2.0;
            line.b1.drawU(ugline.apply(UTranslate.dx(posColA)));
            if (line.b2 != null) {
                line.b2.drawU(ugline.apply(UTranslate.dx(widthColA)));
                ugline.apply(UTranslate.dx(widthColA)).draw(ULine.vline(heightOfRow));
            }
            y += heightOfRow;
        }
        if (y == 0.0) {
            y = 15.0;
        }
        if (trueWidth == 0.0) {
            trueWidth = 30.0;
        }
        URectangle full = new URectangle(trueWidth, y).rounded(10.0);
        ug.apply(new UStroke(1.5)).draw(full);
    }

    private double getTotalHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Line line : this.lines) {
            height += line.getHeightOfRow(stringBounder);
        }
        return height;
    }

    private TextBlock getTextBlock(String key) {
        Display display = Display.getWithNewlines(key);
        FontConfiguration fontConfiguration = this.getStyle().getFontConfiguration(this.skinParam.getIHtmlColorSet());
        TextBlock result = display.create7(fontConfiguration, HorizontalAlignment.LEFT, this.skinParam, CreoleMode.NO_CREOLE);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    private Style getStyle() {
        return StyleSignature.of(SName.root, SName.element, SName.jsonDiagram).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }

    static class Line {
        final TextBlock b1;
        final TextBlock b2;
        final boolean highlighted;

        Line(TextBlock b1, TextBlock b2, boolean highlighted) {
            this.b1 = b1;
            this.b2 = b2;
            this.highlighted = highlighted;
        }

        Line(TextBlock b1, boolean highlighted) {
            this(b1, null, highlighted);
        }

        double getHeightOfRow(StringBounder stringBounder) {
            double height = this.b1.calculateDimension(stringBounder).getHeight();
            if (this.b2 == null) {
                return height;
            }
            return Math.max(height, this.b2.calculateDimension(stringBounder).getHeight());
        }
    }
}

