/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project.ToTaskDraw;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.draw.AbstractTaskDraw;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDrawDiamond
extends AbstractTaskDraw {
    public TaskDrawDiamond(TimeScale timeScale, double y, String prettyDisplay, Day start, ISkinParam skinParam, Task task, ToTaskDraw toTaskDraw) {
        super(timeScale, y, prettyDisplay, start, skinParam, task, toTaskDraw);
    }

    @Override
    protected Style getStyle() {
        Style style = StyleSignature.of(SName.root, SName.element, SName.ganttDiagram, SName.milestone).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        return style;
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        return this.getHeightTask();
    }

    @Override
    public final void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.prettyDisplay).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        double titleHeight = title.calculateDimension(ug.getStringBounder()).getHeight();
        double h = (2.0 + this.getShapeHeight() - titleHeight) / 2.0;
        double endingPosition = this.timeScale.getStartingPosition(this.start) + this.getHeightTask();
        title.drawU(ug.apply(new UTranslate(endingPosition, h)));
    }

    @Override
    public void drawU(UGraphic ug1) {
        double startPos = this.timeScale.getStartingPosition(this.start);
        ug1 = this.applyColors(ug1);
        UGraphic ug2 = ug1.apply(new UTranslate(startPos + 2.0, 2.0));
        this.drawShape(ug2);
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        return ug.apply(this.getLineColor()).apply(this.getBackgroundColor().bg());
    }

    private void drawShape(UGraphic ug) {
        ug.draw(this.getDiamond());
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        return null;
    }

    @Override
    public FingerPrint getFingerPrint() {
        double h = this.getHeightTask();
        double startPos = this.timeScale.getStartingPosition(this.start);
        return new FingerPrint(startPos, this.getY(), startPos + h, this.getY() + h);
    }

    private UShape getDiamond() {
        double h = this.getHeightTask() - 4.0;
        UPolygon result = new UPolygon();
        result.addPoint(h / 2.0, 0.0);
        result.addPoint(h, h / 2.0);
        result.addPoint(h / 2.0, h);
        result.addPoint(0.0, h / 2.0);
        return result;
    }
}

