/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.svek.PortGeometry;

public class Ports {
    private final Map<String, PortGeometry> ids = new LinkedHashMap<String, PortGeometry>();

    public void addThis(Ports other) {
        this.ids.putAll(other.ids);
    }

    public static String encodePortNameToId(String portName) {
        return "p" + SignatureUtils.getMD5Hex(portName);
    }

    public String toString() {
        return this.ids.toString();
    }

    public Ports translateY(double deltaY) {
        Ports result = new Ports();
        for (Map.Entry<String, PortGeometry> ent : this.ids.entrySet()) {
            result.ids.put(ent.getKey(), ent.getValue().translateY(deltaY));
        }
        return result;
    }

    public void add(String portName, double position, double height) {
        if (portName == null) {
            throw new IllegalArgumentException();
        }
        String id = Ports.encodePortNameToId(portName);
        this.ids.put(id, new PortGeometry(position, height));
    }

    public Map<String, PortGeometry> getAllWithEncodedPortId() {
        return this.ids;
    }
}

