/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class NameConflictTreeWalk
extends TreeWalk {
    private static final int TREE_MODE = FileMode.TREE.getBits();
    private boolean fastMinHasMatch;
    private AbstractTreeIterator dfConflict;

    public NameConflictTreeWalk(Repository repo) {
        super(repo);
    }

    public NameConflictTreeWalk(@Nullable Repository repo, ObjectReader or) {
        super(repo, or);
    }

    public NameConflictTreeWalk(ObjectReader or) {
        super(or);
    }

    @Override
    AbstractTreeIterator min() throws CorruptObjectException {
        AbstractTreeIterator minRef;
        block4: {
            block0: while (true) {
                minRef = this.fastMin();
                if (this.fastMinHasMatch) {
                    return minRef;
                }
                if (!NameConflictTreeWalk.isTree(minRef)) break block4;
                if (!this.skipEntry(minRef)) break;
                AbstractTreeIterator[] abstractTreeIteratorArray = this.trees;
                int n = abstractTreeIteratorArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block0;
                    AbstractTreeIterator t = abstractTreeIteratorArray[n2];
                    if (t.matches == minRef) {
                        t.next(1);
                        t.matches = null;
                    }
                    ++n2;
                }
                break;
            }
            return minRef;
        }
        return this.combineDF(minRef);
    }

    private AbstractTreeIterator fastMin() {
        this.fastMinHasMatch = true;
        int i = 0;
        AbstractTreeIterator minRef = this.trees[i];
        while (minRef.eof() && ++i < this.trees.length) {
            minRef = this.trees[i];
        }
        if (minRef.eof()) {
            return minRef;
        }
        boolean hasConflict = false;
        minRef.matches = minRef;
        while (++i < this.trees.length) {
            AbstractTreeIterator t = this.trees[i];
            if (t.eof()) continue;
            int cmp = t.pathCompare(minRef);
            if (cmp < 0) {
                if (this.fastMinHasMatch && NameConflictTreeWalk.isTree(minRef) && !NameConflictTreeWalk.isTree(t) && NameConflictTreeWalk.nameEqual(minRef, t)) {
                    t.matches = minRef;
                    hasConflict = true;
                    continue;
                }
                this.fastMinHasMatch = false;
                t.matches = t;
                minRef = t;
                continue;
            }
            if (cmp == 0) {
                t.matches = minRef;
                continue;
            }
            if (this.fastMinHasMatch && NameConflictTreeWalk.isTree(t) && !NameConflictTreeWalk.isTree(minRef) && NameConflictTreeWalk.nameEqual(t, minRef)) {
                for (int k = 0; k < i; ++k) {
                    AbstractTreeIterator p = this.trees[k];
                    if (p.matches != minRef) continue;
                    p.matches = t;
                }
                t.matches = t;
                minRef = t;
                hasConflict = true;
                continue;
            }
            this.fastMinHasMatch = false;
        }
        if (hasConflict && this.fastMinHasMatch && this.dfConflict == null) {
            this.dfConflict = minRef;
        }
        return minRef;
    }

    private static boolean nameEqual(AbstractTreeIterator a, AbstractTreeIterator b) {
        return a.pathCompare(b, TREE_MODE) == 0;
    }

    private static boolean isTree(AbstractTreeIterator p) {
        return FileMode.TREE.equals(p.mode);
    }

    private boolean skipEntry(AbstractTreeIterator minRef) throws CorruptObjectException {
        for (AbstractTreeIterator t : this.trees) {
            int cmp;
            if (t.matches == minRef || t.first()) continue;
            int stepsBack = 0;
            do {
                ++stepsBack;
                t.back(1);
                cmp = t.pathCompare(minRef, 0);
                if (cmp != 0) continue;
                t.next(stepsBack);
                return true;
            } while (cmp >= 0 && !t.first());
            t.next(stepsBack);
        }
        return false;
    }

    private AbstractTreeIterator combineDF(AbstractTreeIterator minRef) throws CorruptObjectException {
        AbstractTreeIterator treeMatch = null;
        block0: for (AbstractTreeIterator t : this.trees) {
            int cmp;
            if (t.matches == minRef || t.eof()) continue;
            while ((cmp = t.pathCompare(minRef, TREE_MODE)) < 0) {
                ++t.matchShift;
                t.next(1);
                if (!t.eof()) continue;
                t.back(t.matchShift);
                t.matchShift = 0;
                continue block0;
            }
            if (cmp == 0) {
                t.matches = minRef;
                treeMatch = t;
                continue;
            }
            if (t.matchShift == 0) continue;
            t.back(t.matchShift);
            t.matchShift = 0;
        }
        if (treeMatch != null) {
            for (AbstractTreeIterator t : this.trees) {
                if (t.matches != minRef) continue;
                t.matches = treeMatch;
            }
            if (this.dfConflict == null) {
                this.dfConflict = treeMatch;
            }
            return treeMatch;
        }
        return minRef;
    }

    @Override
    void popEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t = this.trees[i];
            if (t.matches != ch) continue;
            if (t.matchShift == 0) {
                t.next(1);
            } else {
                t.back(t.matchShift);
                t.matchShift = 0;
            }
            t.matches = null;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void skipEntriesEqual() throws CorruptObjectException {
        AbstractTreeIterator ch = this.currentHead;
        for (int i = 0; i < this.trees.length; ++i) {
            AbstractTreeIterator t = this.trees[i];
            if (t.matches != ch) continue;
            if (t.matchShift == 0) {
                t.skip();
            } else {
                t.back(t.matchShift);
                t.matchShift = 0;
            }
            t.matches = null;
        }
        if (ch == this.dfConflict) {
            this.dfConflict = null;
        }
    }

    @Override
    void stopWalk() throws IOException {
        if (!this.needsStopWalk()) {
            return;
        }
        while (true) {
            AbstractTreeIterator t;
            if ((t = this.min()).eof()) {
                if (this.depth > 0) {
                    this.exitSubtree();
                    this.popEntriesEqual();
                    continue;
                }
                return;
            }
            this.currentHead = t;
            this.skipEntriesEqual();
        }
    }

    private boolean needsStopWalk() {
        for (AbstractTreeIterator t : this.trees) {
            if (!t.needsStopWalk()) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectoryFileConflict() {
        return this.dfConflict != null;
    }
}

