// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC176x5x_v0.2.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,lpc176x5x

// LPC176x/LPC175x M3
//

package nxp

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "LPC176x5x"
)

// Interrupt numbers.
const (
	IRQ_WDT         = 0  // Watchdog Timer (WDT)
	IRQ_TIMER0      = 1  // Timer0/1/2/3
	IRQ_TIMER1      = 2  //
	IRQ_TIMER2      = 3  //
	IRQ_TIMER3      = 4  //
	IRQ_UART0       = 5  // UART0/2/3
	IRQ_UART1       = 6  // UART1
	IRQ_UART2       = 7  //
	IRQ_UART3       = 8  //
	IRQ_PWM1        = 9  // Pulse Width Modulators (PWM1)
	IRQ_I2C0        = 10 // I2C bus interface
	IRQ_I2C1        = 11 //
	IRQ_I2C2        = 12 //
	IRQ_SPI         = 13 // SPI
	IRQ_SSP0        = 14 // SSP controller
	IRQ_SSP1        = 15 // SSP1 controller
	IRQ_PLL0        = 16 // System and clock control
	IRQ_RTC         = 17 // Real Time Clock (RTC)
	IRQ_EINT0       = 18 // System and clock control
	IRQ_EINT1       = 19 // System and clock control
	IRQ_EINT2       = 20 // System and clock control
	IRQ_EINT3       = 21 // System and clock control
	IRQ_ADC         = 22 // Analog-to-Digital Converter (ADC)
	IRQ_BOD         = 23 // System and clock control
	IRQ_USB         = 24 // USB device/host/OTG controller
	IRQ_CAN         = 25 // CAN1 controller
	IRQ_DMA         = 26 // General purpose DMA controller
	IRQ_I2S         = 27 // I2S interface
	IRQ_ENET        = 28 // Ethernet
	IRQ_RIT         = 29 // Repetitive Interrupt Timer (RIT)
	IRQ_MCPWM       = 30 // Motor Control PWM
	IRQ_QEI         = 31 // Quadrature Encoder Interface (QEI)
	IRQ_PLL1        = 32 // System and clock control
	IRQ_USBActivity = 33 // USB device/host/OTG controller
	IRQ_CANActivity = 34 // Central CAN controller
	IRQ_max         = 34 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WDT, "WDT_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER0, "TIMER0_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER1, "TIMER1_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER2, "TIMER2_IRQHandler")
	_ = interrupt.Register(IRQ_TIMER3, "TIMER3_IRQHandler")
	_ = interrupt.Register(IRQ_UART0, "UART0_IRQHandler")
	_ = interrupt.Register(IRQ_UART1, "UART1_IRQHandler")
	_ = interrupt.Register(IRQ_UART2, "UART2_IRQHandler")
	_ = interrupt.Register(IRQ_UART3, "UART3_IRQHandler")
	_ = interrupt.Register(IRQ_PWM1, "PWM1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C0, "I2C0_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1, "I2C1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2, "I2C2_IRQHandler")
	_ = interrupt.Register(IRQ_SPI, "SPI_IRQHandler")
	_ = interrupt.Register(IRQ_SSP0, "SSP0_IRQHandler")
	_ = interrupt.Register(IRQ_SSP1, "SSP1_IRQHandler")
	_ = interrupt.Register(IRQ_PLL0, "PLL0_IRQHandler")
	_ = interrupt.Register(IRQ_RTC, "RTC_IRQHandler")
	_ = interrupt.Register(IRQ_EINT0, "EINT0_IRQHandler")
	_ = interrupt.Register(IRQ_EINT1, "EINT1_IRQHandler")
	_ = interrupt.Register(IRQ_EINT2, "EINT2_IRQHandler")
	_ = interrupt.Register(IRQ_EINT3, "EINT3_IRQHandler")
	_ = interrupt.Register(IRQ_ADC, "ADC_IRQHandler")
	_ = interrupt.Register(IRQ_BOD, "BOD_IRQHandler")
	_ = interrupt.Register(IRQ_USB, "USB_IRQHandler")
	_ = interrupt.Register(IRQ_CAN, "CAN_IRQHandler")
	_ = interrupt.Register(IRQ_DMA, "DMA_IRQHandler")
	_ = interrupt.Register(IRQ_I2S, "I2S_IRQHandler")
	_ = interrupt.Register(IRQ_ENET, "ENET_IRQHandler")
	_ = interrupt.Register(IRQ_RIT, "RIT_IRQHandler")
	_ = interrupt.Register(IRQ_MCPWM, "MCPWM_IRQHandler")
	_ = interrupt.Register(IRQ_QEI, "QEI_IRQHandler")
	_ = interrupt.Register(IRQ_PLL1, "PLL1_IRQHandler")
	_ = interrupt.Register(IRQ_USBActivity, "USBActivity_IRQHandler")
	_ = interrupt.Register(IRQ_CANActivity, "CANActivity_IRQHandler")
)

// Peripherals.
var (
	WDT        = (*WDT_Type)(unsafe.Pointer(uintptr(0x40000000)))        // Watchdog Timer (WDT)
	TIMER0     = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40004000)))     // Timer0/1/2/3
	TIMER1     = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40008000)))     // Timer0/1/2/3
	UART0      = (*UART0_Type)(unsafe.Pointer(uintptr(0x4000c000)))      // UART0/2/3
	UART1      = (*UART1_Type)(unsafe.Pointer(uintptr(0x40010000)))      // UART1
	PWM1       = (*PWM_Type)(unsafe.Pointer(uintptr(0x40018000)))        // Pulse Width Modulators (PWM1)
	I2C0       = (*I2C_Type)(unsafe.Pointer(uintptr(0x4001c000)))        // I2C bus interface
	SPI        = (*SPI_Type)(unsafe.Pointer(uintptr(0x40020000)))        // SPI
	RTC        = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))        // Real Time Clock (RTC)
	GPIOINT    = (*GPIOINT_Type)(unsafe.Pointer(uintptr(0x40028080)))    // GPIO
	PINCONNECT = (*PINCONNECT_Type)(unsafe.Pointer(uintptr(0x4002c000))) // Pin connect block
	SSP1       = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40030000)))       // SSP1 controller
	ADC        = (*ADC_Type)(unsafe.Pointer(uintptr(0x40034000)))        // Analog-to-Digital Converter (ADC)
	CANAFRAM   = (*CANAFRAM_Type)(unsafe.Pointer(uintptr(0x40038000)))   // CAN acceptance filter RAM
	CANAF      = (*CANAF_Type)(unsafe.Pointer(uintptr(0x4003c000)))      // CAN controller acceptance filter
	CCAN       = (*CCAN_Type)(unsafe.Pointer(uintptr(0x40040000)))       // Central CAN controller
	CAN1       = (*CAN_Type)(unsafe.Pointer(uintptr(0x40044000)))        // CAN1 controller
	SSP0       = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40088000)))       // SSP controller
	DAC        = (*DAC_Type)(unsafe.Pointer(uintptr(0x4008c000)))        // Digital-to-Analog Converter (DAC)
	TIMER2     = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40090000)))     // Timer0/1/2/3
	TIMER3     = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40094000)))     // Timer0/1/2/3
	UART2      = (*UART0_Type)(unsafe.Pointer(uintptr(0x40098000)))      // UART0/2/3
	UART3      = (*UART0_Type)(unsafe.Pointer(uintptr(0x4009c000)))      // UART0/2/3
	I2S        = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a8000)))        // I2S interface
	RITIMER    = (*RIT_Type)(unsafe.Pointer(uintptr(0x400b0000)))        // Repetitive Interrupt Timer (RIT)
	MCPWM      = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x400b8000)))      // Motor Control PWM
	QEI        = (*QEI_Type)(unsafe.Pointer(uintptr(0x400bc000)))        // Quadrature Encoder Interface (QEI)
	SYSCON     = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x400fc000)))     // System and clock control
	EMAC       = (*ETHERNET_Type)(unsafe.Pointer(uintptr(0x50000000)))   // Ethernet
	GPDMA      = (*GPDMA_Type)(unsafe.Pointer(uintptr(0x50004000)))      // General purpose DMA controller
	USB        = (*USB_Type)(unsafe.Pointer(uintptr(0x50008000)))        // USB device/host/OTG controller
	GPIO       = (*GPIO_Type)(unsafe.Pointer(uintptr(0x2009c000)))       // General Purpose I/O
	CAN2       = (*CAN_Type)(unsafe.Pointer(uintptr(0x40048000)))        // CAN1 controller
	I2C1       = (*I2C_Type)(unsafe.Pointer(uintptr(0x4005c000)))        // I2C bus interface
	I2C2       = (*I2C_Type)(unsafe.Pointer(uintptr(0x400a0000)))        // I2C bus interface
)

// Watchdog Timer (WDT)
type WDT_Type struct {
	MOD    volatile.Register32 // 0x0
	TC     volatile.Register32 // 0x4
	FEED   volatile.Register32 // 0x8
	TV     volatile.Register32 // 0xC
	CLKSEL volatile.Register32 // 0x10
}

// Timer0/1/2/3
type TIMER0_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR   [4]volatile.Register32 // 0x18
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [8]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
}

// UART0/2/3
type UART0_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// UART1
type UART1_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// Pulse Width Modulators (PWM1)
type PWM_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR0  volatile.Register32    // 0x18
	MR1  volatile.Register32    // 0x1C
	MR2  volatile.Register32    // 0x20
	MR3  volatile.Register32    // 0x24
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [12]byte
	MR4  volatile.Register32 // 0x40
	MR5  volatile.Register32 // 0x44
	MR6  volatile.Register32 // 0x48
	PCR  volatile.Register32 // 0x4C
	LER  volatile.Register32 // 0x50
	_    [28]byte
	CTCR volatile.Register32 // 0x70
}

// I2C bus interface
type I2C_Type struct {
	CONSET      volatile.Register32    // 0x0
	STAT        volatile.Register32    // 0x4
	DAT         volatile.Register32    // 0x8
	ADR0        volatile.Register32    // 0xC
	SCLH        volatile.Register32    // 0x10
	SCLL        volatile.Register32    // 0x14
	CONCLR      volatile.Register32    // 0x18
	MMCTRL      volatile.Register32    // 0x1C
	ADR1        volatile.Register32    // 0x20
	ADR2        volatile.Register32    // 0x24
	ADR3        volatile.Register32    // 0x28
	DATA_BUFFER volatile.Register32    // 0x2C
	MASK        [4]volatile.Register32 // 0x30
}

// SPI
type SPI_Type struct {
	CR  volatile.Register32 // 0x0
	SR  volatile.Register32 // 0x4
	DR  volatile.Register32 // 0x8
	CCR volatile.Register32 // 0xC
	_   [12]byte
	INT volatile.Register32 // 0x1C
}

// Real Time Clock (RTC)
type RTC_Type struct {
	ILR         volatile.Register32 // 0x0
	_           [4]byte
	CCR         volatile.Register32 // 0x8
	CIIR        volatile.Register32 // 0xC
	AMR         volatile.Register32 // 0x10
	CTIME0      volatile.Register32 // 0x14
	CTIME1      volatile.Register32 // 0x18
	CTIME2      volatile.Register32 // 0x1C
	SEC         volatile.Register32 // 0x20
	MIN         volatile.Register32 // 0x24
	HRS         volatile.Register32 // 0x28
	DOM         volatile.Register32 // 0x2C
	DOW         volatile.Register32 // 0x30
	DOY         volatile.Register32 // 0x34
	MONTH       volatile.Register32 // 0x38
	YEAR        volatile.Register32 // 0x3C
	CALIBRATION volatile.Register32 // 0x40
	GPREG0      volatile.Register32 // 0x44
	GPREG1      volatile.Register32 // 0x48
	GPREG2      volatile.Register32 // 0x4C
	GPREG3      volatile.Register32 // 0x50
	GPREG4      volatile.Register32 // 0x54
	RTC_AUXEN   volatile.Register32 // 0x58
	RTC_AUX     volatile.Register32 // 0x5C
	ASEC        volatile.Register32 // 0x60
	AMIN        volatile.Register32 // 0x64
	AHRS        volatile.Register32 // 0x68
	ADOM        volatile.Register32 // 0x6C
	ADOW        volatile.Register32 // 0x70
	ADOY        volatile.Register32 // 0x74
	AMON        volatile.Register32 // 0x78
	AYRS        volatile.Register32 // 0x7C
}

// GPIO
type GPIOINT_Type struct {
	STATUS volatile.Register32 // 0x0
	STATR0 volatile.Register32 // 0x4
	STATF0 volatile.Register32 // 0x8
	CLR0   volatile.Register32 // 0xC
	ENR0   volatile.Register32 // 0x10
	ENF0   volatile.Register32 // 0x14
	_      [12]byte
	STATR2 volatile.Register32 // 0x24
	STATF2 volatile.Register32 // 0x28
	CLR2   volatile.Register32 // 0x2C
	ENR2   volatile.Register32 // 0x30
	ENF2   volatile.Register32 // 0x34
}

// Pin connect block
type PINCONNECT_Type struct {
	PINSEL0     volatile.Register32 // 0x0
	PINSEL1     volatile.Register32 // 0x4
	PINSEL2     volatile.Register32 // 0x8
	PINSEL3     volatile.Register32 // 0xC
	PINSEL4     volatile.Register32 // 0x10
	_           [8]byte
	PINSEL7     volatile.Register32 // 0x1C
	_           [4]byte
	PINSEL9     volatile.Register32 // 0x24
	PINSEL10    volatile.Register32 // 0x28
	_           [20]byte
	PINMODE0    volatile.Register32 // 0x40
	PINMODE1    volatile.Register32 // 0x44
	PINMODE2    volatile.Register32 // 0x48
	PINMODE3    volatile.Register32 // 0x4C
	PINMODE4    volatile.Register32 // 0x50
	_           [8]byte
	PINMODE7    volatile.Register32 // 0x5C
	_           [4]byte
	PINMODE9    volatile.Register32 // 0x64
	PINMODE_OD0 volatile.Register32 // 0x68
	PINMODE_OD1 volatile.Register32 // 0x6C
	PINMODE_OD2 volatile.Register32 // 0x70
	PINMODE_OD3 volatile.Register32 // 0x74
	PINMODE_OD4 volatile.Register32 // 0x78
	I2CPADCFG   volatile.Register32 // 0x7C
}

// SSP1 controller
type SSP1_Type struct {
	CR0   volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	DR    volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	CPSR  volatile.Register32 // 0x10
	IMSC  volatile.Register32 // 0x14
	RIS   volatile.Register32 // 0x18
	MIS   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	DMACR volatile.Register32 // 0x24
}

// Analog-to-Digital Converter (ADC)
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	_     [4]byte
	INTEN volatile.Register32    // 0xC
	DR    [8]volatile.Register32 // 0x10
	STAT  volatile.Register32    // 0x30
	TRM   volatile.Register32    // 0x34
}

// CAN acceptance filter RAM
type CANAFRAM_Type struct {
	MASK [512]volatile.Register32 // 0x0
}

// CAN controller acceptance filter
type CANAF_Type struct {
	AFMR       volatile.Register32 // 0x0
	SFF_SA     volatile.Register32 // 0x4
	SFF_GRP_SA volatile.Register32 // 0x8
	EFF_SA     volatile.Register32 // 0xC
	EFF_GRP_SA volatile.Register32 // 0x10
	ENDOFTABLE volatile.Register32 // 0x14
	LUTERRAD   volatile.Register32 // 0x18
	LUTERR     volatile.Register32 // 0x1C
	FCANIE     volatile.Register32 // 0x20
	FCANIC0    volatile.Register32 // 0x24
	FCANIC1    volatile.Register32 // 0x28
}

// Central CAN controller
type CCAN_Type struct {
	TXSR volatile.Register32 // 0x0
	RXSR volatile.Register32 // 0x4
	MSR  volatile.Register32 // 0x8
}

// CAN1 controller
type CAN_Type struct {
	MOD  volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	GSR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
	IER  volatile.Register32 // 0x10
	BTR  volatile.Register32 // 0x14
	EWL  volatile.Register32 // 0x18
	SR   volatile.Register32 // 0x1C
	RFS  volatile.Register32 // 0x20
	RID  volatile.Register32 // 0x24
	RDA  volatile.Register32 // 0x28
	RDB  volatile.Register32 // 0x2C
	TFI1 volatile.Register32 // 0x30
	TID1 volatile.Register32 // 0x34
	TDA1 volatile.Register32 // 0x38
	TDB1 volatile.Register32 // 0x3C
	TFI2 volatile.Register32 // 0x40
	TID2 volatile.Register32 // 0x44
	TDA2 volatile.Register32 // 0x48
	TDB2 volatile.Register32 // 0x4C
	TFI3 volatile.Register32 // 0x50
	TID3 volatile.Register32 // 0x54
	TDA3 volatile.Register32 // 0x58
	TDB3 volatile.Register32 // 0x5C
}

// Digital-to-Analog Converter (DAC)
type DAC_Type struct {
	CR     volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	CNTVAL volatile.Register32 // 0x8
}

// I2S interface
type I2S_Type struct {
	DAO       volatile.Register32 // 0x0
	DAI       volatile.Register32 // 0x4
	TXFIFO    volatile.Register32 // 0x8
	RXFIFO    volatile.Register32 // 0xC
	STATE     volatile.Register32 // 0x10
	DMA1      volatile.Register32 // 0x14
	DMA2      volatile.Register32 // 0x18
	IRQ       volatile.Register32 // 0x1C
	TXRATE    volatile.Register32 // 0x20
	RXRATE    volatile.Register32 // 0x24
	TXBITRATE volatile.Register32 // 0x28
	RXBITRATE volatile.Register32 // 0x2C
	TXMODE    volatile.Register32 // 0x30
	RXMODE    volatile.Register32 // 0x34
}

// Repetitive Interrupt Timer (RIT)
type RIT_Type struct {
	COMPVAL volatile.Register32 // 0x0
	MASK    volatile.Register32 // 0x4
	CTRL    volatile.Register32 // 0x8
	COUNTER volatile.Register32 // 0xC
}

// Motor Control PWM
type MCPWM_Type struct {
	CON        volatile.Register32    // 0x0
	CON_SET    volatile.Register32    // 0x4
	CON_CLR    volatile.Register32    // 0x8
	CAPCON     volatile.Register32    // 0xC
	CAPCON_SET volatile.Register32    // 0x10
	CAPCON_CLR volatile.Register32    // 0x14
	TC         [3]volatile.Register32 // 0x18
	LIM        [3]volatile.Register32 // 0x24
	MAT        [3]volatile.Register32 // 0x30
	DT         volatile.Register32    // 0x3C
	CP         volatile.Register32    // 0x40
	CAP        [3]volatile.Register32 // 0x44
	INTEN      volatile.Register32    // 0x50
	INTEN_SET  volatile.Register32    // 0x54
	INTEN_CLR  volatile.Register32    // 0x58
	CNTCON     volatile.Register32    // 0x5C
	CNTCON_SET volatile.Register32    // 0x60
	CNTCON_CLR volatile.Register32    // 0x64
	INTF       volatile.Register32    // 0x68
	INTF_SET   volatile.Register32    // 0x6C
	INTF_CLR   volatile.Register32    // 0x70
	CAP_CLR    volatile.Register32    // 0x74
}

// Quadrature Encoder Interface (QEI)
type QEI_Type struct {
	CON     volatile.Register32 // 0x0
	STAT    volatile.Register32 // 0x4
	CONF    volatile.Register32 // 0x8
	POS     volatile.Register32 // 0xC
	MAXPOS  volatile.Register32 // 0x10
	CMPOS0  volatile.Register32 // 0x14
	CMPOS1  volatile.Register32 // 0x18
	CMPOS2  volatile.Register32 // 0x1C
	INXCNT  volatile.Register32 // 0x20
	INXCMP0 volatile.Register32 // 0x24
	LOAD    volatile.Register32 // 0x28
	TIME    volatile.Register32 // 0x2C
	VEL     volatile.Register32 // 0x30
	CAP     volatile.Register32 // 0x34
	VELCOMP volatile.Register32 // 0x38
	FILTER  volatile.Register32 // 0x3C
	_       [3992]byte
	IEC     volatile.Register32 // 0xFD8
	IES     volatile.Register32 // 0xFDC
	INTSTAT volatile.Register32 // 0xFE0
	IE      volatile.Register32 // 0xFE4
	CLR     volatile.Register32 // 0xFE8
	SET     volatile.Register32 // 0xFEC
}

// System and clock control
type SYSCON_Type struct {
	FLASHCFG     volatile.Register32 // 0x0
	_            [124]byte
	PLL0CON      volatile.Register32 // 0x80
	PLL0CFG      volatile.Register32 // 0x84
	PLL0STAT     volatile.Register32 // 0x88
	PLL0FEED     volatile.Register32 // 0x8C
	_            [16]byte
	PLL1CON      volatile.Register32 // 0xA0
	PLL1CFG      volatile.Register32 // 0xA4
	PLL1STAT     volatile.Register32 // 0xA8
	PLL1FEED     volatile.Register32 // 0xAC
	_            [16]byte
	PCON         volatile.Register32 // 0xC0
	PCONP        volatile.Register32 // 0xC4
	_            [60]byte
	CCLKCFG      volatile.Register32 // 0x104
	USBCLKCFG    volatile.Register32 // 0x108
	CLKSRCSEL    volatile.Register32 // 0x10C
	CANSLEEPCLR  volatile.Register32 // 0x110
	CANWAKEFLAGS volatile.Register32 // 0x114
	_            [40]byte
	EXTINT       volatile.Register32 // 0x140
	_            [4]byte
	EXTMODE      volatile.Register32 // 0x148
	EXTPOLAR     volatile.Register32 // 0x14C
	_            [48]byte
	RSID         volatile.Register32 // 0x180
	_            [28]byte
	SCS          volatile.Register32 // 0x1A0
	_            [4]byte
	PCLKSEL0     volatile.Register32 // 0x1A8
	PCLKSEL1     volatile.Register32 // 0x1AC
	_            [16]byte
	USBINTST     volatile.Register32 // 0x1C0
	DMACREQSEL   volatile.Register32 // 0x1C4
	CLKOUTCFG    volatile.Register32 // 0x1C8
}

// Ethernet
type ETHERNET_Type struct {
	MAC1               volatile.Register32 // 0x0
	MAC2               volatile.Register32 // 0x4
	IPGT               volatile.Register32 // 0x8
	IPGR               volatile.Register32 // 0xC
	CLRT               volatile.Register32 // 0x10
	MAXF               volatile.Register32 // 0x14
	SUPP               volatile.Register32 // 0x18
	TEST               volatile.Register32 // 0x1C
	MCFG               volatile.Register32 // 0x20
	MCMD               volatile.Register32 // 0x24
	MADR               volatile.Register32 // 0x28
	MWTD               volatile.Register32 // 0x2C
	MRDD               volatile.Register32 // 0x30
	MIND               volatile.Register32 // 0x34
	_                  [8]byte
	SA0                volatile.Register32 // 0x40
	SA1                volatile.Register32 // 0x44
	SA2                volatile.Register32 // 0x48
	_                  [180]byte
	COMMAND            volatile.Register32 // 0x100
	STATUS             volatile.Register32 // 0x104
	RXDESCRIPTOR       volatile.Register32 // 0x108
	RXSTATUS           volatile.Register32 // 0x10C
	RXDESCRIPTORNUMBER volatile.Register32 // 0x110
	RXPRODUCEINDEX     volatile.Register32 // 0x114
	RXCONSUMEINDEX     volatile.Register32 // 0x118
	TXDESCRIPTOR       volatile.Register32 // 0x11C
	TXSTATUS           volatile.Register32 // 0x120
	TXDESCRIPTORNUMBER volatile.Register32 // 0x124
	TXPRODUCEINDEX     volatile.Register32 // 0x128
	TXCONSUMEINDEX     volatile.Register32 // 0x12C
	_                  [40]byte
	TSV0               volatile.Register32 // 0x158
	TSV1               volatile.Register32 // 0x15C
	RSV                volatile.Register32 // 0x160
	_                  [12]byte
	FLOWCONTROLCOUNTER volatile.Register32 // 0x170
	FLOWCONTROLSTATUS  volatile.Register32 // 0x174
	_                  [136]byte
	RXFILTERCTRL       volatile.Register32 // 0x200
	RXFILTERWOLSTATUS  volatile.Register32 // 0x204
	RXFILTERWOLCLEAR   volatile.Register32 // 0x208
	_                  [4]byte
	HASHFILTERL        volatile.Register32 // 0x210
	HASHFILTERH        volatile.Register32 // 0x214
	_                  [3528]byte
	INTSTATUS          volatile.Register32 // 0xFE0
	INTENABLE          volatile.Register32 // 0xFE4
	INTCLEAR           volatile.Register32 // 0xFE8
	INTSET             volatile.Register32 // 0xFEC
	_                  [4]byte
	POWERDOWN          volatile.Register32 // 0xFF4
}

// General purpose DMA controller
type GPDMA_Type struct {
	INTSTAT       volatile.Register32 // 0x0
	INTTCSTAT     volatile.Register32 // 0x4
	INTTCCLEAR    volatile.Register32 // 0x8
	INTERRSTAT    volatile.Register32 // 0xC
	INTERRCLR     volatile.Register32 // 0x10
	RAWINTTCSTAT  volatile.Register32 // 0x14
	RAWINTERRSTAT volatile.Register32 // 0x18
	ENBLDCHNS     volatile.Register32 // 0x1C
	SOFTBREQ      volatile.Register32 // 0x20
	SOFTSREQ      volatile.Register32 // 0x24
	SOFTLBREQ     volatile.Register32 // 0x28
	SOFTLSREQ     volatile.Register32 // 0x2C
	CONFIG        volatile.Register32 // 0x30
	SYNC          volatile.Register32 // 0x34
	_             [200]byte
	SRCADDR0      volatile.Register32 // 0x100
	DESTADDR0     volatile.Register32 // 0x104
	LLI0          volatile.Register32 // 0x108
	CONTROL0      volatile.Register32 // 0x10C
	CONFIG0       volatile.Register32 // 0x110
	_             [12]byte
	SRCADDR1      volatile.Register32 // 0x120
	DESTADDR1     volatile.Register32 // 0x124
	LLI1          volatile.Register32 // 0x128
	CONTROL1      volatile.Register32 // 0x12C
	CONFIG1       volatile.Register32 // 0x130
	_             [12]byte
	SRCADDR2      volatile.Register32 // 0x140
	DESTADDR2     volatile.Register32 // 0x144
	LLI2          volatile.Register32 // 0x148
	CONTROL2      volatile.Register32 // 0x14C
	CONFIG2       volatile.Register32 // 0x150
	_             [12]byte
	SRCADDR3      volatile.Register32 // 0x160
	DESTADDR3     volatile.Register32 // 0x164
	LLI3          volatile.Register32 // 0x168
	CONTROL3      volatile.Register32 // 0x16C
	CONFIG3       volatile.Register32 // 0x170
	_             [12]byte
	SRCADDR4      volatile.Register32 // 0x180
	DESTADDR4     volatile.Register32 // 0x184
	LLI4          volatile.Register32 // 0x188
	CONTROL4      volatile.Register32 // 0x18C
	CONFIG4       volatile.Register32 // 0x190
	_             [12]byte
	SRCADDR5      volatile.Register32 // 0x1A0
	DESTADDR5     volatile.Register32 // 0x1A4
	LLI5          volatile.Register32 // 0x1A8
	CONTROL5      volatile.Register32 // 0x1AC
	CONFIG5       volatile.Register32 // 0x1B0
	_             [12]byte
	SRCADDR6      volatile.Register32 // 0x1C0
	DESTADDR6     volatile.Register32 // 0x1C4
	LLI6          volatile.Register32 // 0x1C8
	CONTROL6      volatile.Register32 // 0x1CC
	CONFIG6       volatile.Register32 // 0x1D0
	_             [12]byte
	SRCADDR7      volatile.Register32 // 0x1E0
	DESTADDR7     volatile.Register32 // 0x1E4
	LLI7          volatile.Register32 // 0x1E8
	CONTROL7      volatile.Register32 // 0x1EC
	CONFIG7       volatile.Register32 // 0x1F0
}

// USB device/host/OTG controller
type USB_Type struct {
	_            [220]byte
	RXPLEN       volatile.Register32 // 0xDC
	_            [32]byte
	INTST        volatile.Register32 // 0x100
	INTEN        volatile.Register32 // 0x104
	INTSET       volatile.Register32 // 0x108
	INTCLR       volatile.Register32 // 0x10C
	STCTRL       volatile.Register32 // 0x110
	TMR          volatile.Register32 // 0x114
	_            [232]byte
	DEVINTST     volatile.Register32 // 0x200
	DEVINTEN     volatile.Register32 // 0x204
	DEVINTCLR    volatile.Register32 // 0x208
	DEVINTSET    volatile.Register32 // 0x20C
	CMDCODE      volatile.Register32 // 0x210
	CMDDATA      volatile.Register32 // 0x214
	RXDATA       volatile.Register32 // 0x218
	TXDATA       volatile.Register32 // 0x21C
	_            [4]byte
	TXPLEN       volatile.Register32 // 0x224
	CTRL         volatile.Register32 // 0x228
	DEVINTPRI    volatile.Register32 // 0x22C
	EPINTST      volatile.Register32 // 0x230
	EPINTEN      volatile.Register32 // 0x234
	EPINTCLR     volatile.Register32 // 0x238
	EPINTSET     volatile.Register32 // 0x23C
	EPINTPRI     volatile.Register32 // 0x240
	REEP         volatile.Register32 // 0x244
	EPIND        volatile.Register32 // 0x248
	MAXPSIZE     volatile.Register32 // 0x24C
	DMARST       volatile.Register32 // 0x250
	DMARCLR      volatile.Register32 // 0x254
	DMARSET      volatile.Register32 // 0x258
	_            [36]byte
	UDCAH        volatile.Register32 // 0x280
	EPDMAST      volatile.Register32 // 0x284
	EPDMAEN      volatile.Register32 // 0x288
	EPDMADIS     volatile.Register32 // 0x28C
	DMAINTST     volatile.Register32 // 0x290
	DMAINTEN     volatile.Register32 // 0x294
	_            [8]byte
	EOTINTST     volatile.Register32 // 0x2A0
	EOTINTCLR    volatile.Register32 // 0x2A4
	EOTINTSET    volatile.Register32 // 0x2A8
	NDDRINTST    volatile.Register32 // 0x2AC
	NDDRINTCLR   volatile.Register32 // 0x2B0
	NDDRINTSET   volatile.Register32 // 0x2B4
	SYSERRINTST  volatile.Register32 // 0x2B8
	SYSERRINTCLR volatile.Register32 // 0x2BC
	SYSERRINTSET volatile.Register32 // 0x2C0
	_            [60]byte
	I2C_RX       volatile.Register32 // 0x300
	I2C_STS      volatile.Register32 // 0x304
	I2C_CTL      volatile.Register32 // 0x308
	I2C_CLKHI    volatile.Register32 // 0x30C
	I2C_CLKLO    volatile.Register32 // 0x310
	_            [3296]byte
	USBCLKCTRL   volatile.Register32 // 0xFF4
	USBCLKST     volatile.Register32 // 0xFF8
}

// General Purpose I/O
type GPIO_Type struct {
	DIR0  volatile.Register32 // 0x0
	_     [12]byte
	MASK0 volatile.Register32 // 0x10
	PIN0  volatile.Register32 // 0x14
	SET0  volatile.Register32 // 0x18
	CLR0  volatile.Register32 // 0x1C
	DIR1  volatile.Register32 // 0x20
	_     [12]byte
	MASK1 volatile.Register32 // 0x30
	PIN1  volatile.Register32 // 0x34
	SET1  volatile.Register32 // 0x38
	CLR1  volatile.Register32 // 0x3C
	DIR2  volatile.Register32 // 0x40
	_     [12]byte
	MASK2 volatile.Register32 // 0x50
	PIN2  volatile.Register32 // 0x54
	SET2  volatile.Register32 // 0x58
	CLR2  volatile.Register32 // 0x5C
	DIR3  volatile.Register32 // 0x60
	_     [12]byte
	MASK3 volatile.Register32 // 0x70
	PIN3  volatile.Register32 // 0x74
	SET3  volatile.Register32 // 0x78
	CLR3  volatile.Register32 // 0x7C
	DIR4  volatile.Register32 // 0x80
	_     [12]byte
	MASK4 volatile.Register32 // 0x90
	PIN4  volatile.Register32 // 0x94
	SET4  volatile.Register32 // 0x98
	CLR4  volatile.Register32 // 0x9C
}

// Bitfields for WDT: Watchdog Timer (WDT)
const (
	// MOD: Watchdog mode register. This register determines the basic mode and status of the Watchdog Timer.
	WDT_MOD_WDEN_Pos        = 0x0        // Position of WDEN field.
	WDT_MOD_WDEN_Msk        = 0x1        // Bit mask of WDEN field.
	WDT_MOD_WDEN            = 0x1        // Bit WDEN.
	WDT_MOD_WDEN_STOP       = 0x0        // The watchdog timer is stopped.
	WDT_MOD_WDEN_RUN        = 0x1        // The watchdog timer is running.
	WDT_MOD_WDRESET_Pos     = 0x1        // Position of WDRESET field.
	WDT_MOD_WDRESET_Msk     = 0x2        // Bit mask of WDRESET field.
	WDT_MOD_WDRESET         = 0x2        // Bit WDRESET.
	WDT_MOD_WDRESET_NORESET = 0x0        // A watchdog timeout will not cause a chip reset.
	WDT_MOD_WDRESET_RESET   = 0x1        // A watchdog timeout will cause a chip reset.
	WDT_MOD_WDTOF_Pos       = 0x2        // Position of WDTOF field.
	WDT_MOD_WDTOF_Msk       = 0x4        // Bit mask of WDTOF field.
	WDT_MOD_WDTOF           = 0x4        // Bit WDTOF.
	WDT_MOD_WDINT_Pos       = 0x3        // Position of WDINT field.
	WDT_MOD_WDINT_Msk       = 0x8        // Bit mask of WDINT field.
	WDT_MOD_WDINT           = 0x8        // Bit WDINT.
	WDT_MOD_RESERVED_Pos    = 0x4        // Position of RESERVED field.
	WDT_MOD_RESERVED_Msk    = 0xfffffff0 // Bit mask of RESERVED field.

	// TC: Watchdog timer constant register. The value in this register determines the time-out value.
	WDT_TC_Count_Pos = 0x0        // Position of Count field.
	WDT_TC_Count_Msk = 0xffffffff // Bit mask of Count field.

	// FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
	WDT_FEED_Feed_Pos = 0x0  // Position of Feed field.
	WDT_FEED_Feed_Msk = 0xff // Bit mask of Feed field.

	// TV: Watchdog timer value register. This register reads out the current value of the Watchdog timer.
	WDT_TV_Count_Pos = 0x0        // Position of Count field.
	WDT_TV_Count_Msk = 0xffffffff // Bit mask of Count field.

	// CLKSEL: Watchdog clock select register.
	WDT_CLKSEL_CLKSEL_Pos    = 0x0        // Position of CLKSEL field.
	WDT_CLKSEL_CLKSEL_Msk    = 0x3        // Bit mask of CLKSEL field.
	WDT_CLKSEL_CLKSEL_IRC    = 0x0        // IRC
	WDT_CLKSEL_CLKSEL_PCLK   = 0x1        // Peripheral clock
	WDT_CLKSEL_CLKSEL_RTCOSC = 0x2        // RTC oscillator
	WDT_CLKSEL_RESERVED_Pos  = 0x1        // Position of RESERVED field.
	WDT_CLKSEL_RESERVED_Msk  = 0x7ffffffe // Bit mask of RESERVED field.
	WDT_CLKSEL_LOCK_Pos      = 0x1f       // Position of LOCK field.
	WDT_CLKSEL_LOCK_Msk      = 0x80000000 // Bit mask of LOCK field.
	WDT_CLKSEL_LOCK          = 0x80000000 // Bit LOCK.
	WDT_CLKSEL_LOCK_UNLOCKED = 0x0        // This bit is set to 0 on any reset. It cannot be cleared by software.
	WDT_CLKSEL_LOCK_LOCKED   = 0x1        // Software can set this bit to 1 at any time. Once WDLOCK is set, the bits of this register 										cannot be modified.
)

// Bitfields for TIMER0: Timer0/1/2/3
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
	TIMER0_IR_MR0INT_Pos   = 0x0        // Position of MR0INT field.
	TIMER0_IR_MR0INT_Msk   = 0x1        // Bit mask of MR0INT field.
	TIMER0_IR_MR0INT       = 0x1        // Bit MR0INT.
	TIMER0_IR_MR1INT_Pos   = 0x1        // Position of MR1INT field.
	TIMER0_IR_MR1INT_Msk   = 0x2        // Bit mask of MR1INT field.
	TIMER0_IR_MR1INT       = 0x2        // Bit MR1INT.
	TIMER0_IR_MR2INT_Pos   = 0x2        // Position of MR2INT field.
	TIMER0_IR_MR2INT_Msk   = 0x4        // Bit mask of MR2INT field.
	TIMER0_IR_MR2INT       = 0x4        // Bit MR2INT.
	TIMER0_IR_MR3INT_Pos   = 0x3        // Position of MR3INT field.
	TIMER0_IR_MR3INT_Msk   = 0x8        // Bit mask of MR3INT field.
	TIMER0_IR_MR3INT       = 0x8        // Bit MR3INT.
	TIMER0_IR_CR0INT_Pos   = 0x4        // Position of CR0INT field.
	TIMER0_IR_CR0INT_Msk   = 0x10       // Bit mask of CR0INT field.
	TIMER0_IR_CR0INT       = 0x10       // Bit CR0INT.
	TIMER0_IR_CR1INT_Pos   = 0x5        // Position of CR1INT field.
	TIMER0_IR_CR1INT_Msk   = 0x20       // Bit mask of CR1INT field.
	TIMER0_IR_CR1INT       = 0x20       // Bit CR1INT.
	TIMER0_IR_RESERVED_Pos = 0x6        // Position of RESERVED field.
	TIMER0_IR_RESERVED_Msk = 0xffffffc0 // Bit mask of RESERVED field.

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
	TIMER0_TCR_CEN_Pos      = 0x0        // Position of CEN field.
	TIMER0_TCR_CEN_Msk      = 0x1        // Bit mask of CEN field.
	TIMER0_TCR_CEN          = 0x1        // Bit CEN.
	TIMER0_TCR_CRST_Pos     = 0x1        // Position of CRST field.
	TIMER0_TCR_CRST_Msk     = 0x2        // Bit mask of CRST field.
	TIMER0_TCR_CRST         = 0x2        // Bit CRST.
	TIMER0_TCR_RESERVED_Pos = 0x2        // Position of RESERVED field.
	TIMER0_TCR_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	TIMER0_TC_TC_Pos = 0x0        // Position of TC field.
	TIMER0_TC_TC_Msk = 0xffffffff // Bit mask of TC field.

	// PR: Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC.
	TIMER0_PR_PM_Pos = 0x0        // Position of PM field.
	TIMER0_PR_PM_Msk = 0xffffffff // Bit mask of PM field.

	// PC: Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
	TIMER0_PC_PC_Pos = 0x0        // Position of PC field.
	TIMER0_PC_PC_Msk = 0xffffffff // Bit mask of PC field.

	// MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
	TIMER0_MCR_MR0I_Pos                  = 0x0        // Position of MR0I field.
	TIMER0_MCR_MR0I_Msk                  = 0x1        // Bit mask of MR0I field.
	TIMER0_MCR_MR0I                      = 0x1        // Bit MR0I.
	TIMER0_MCR_MR0I_INTERRUPT_IS_GENERAT = 0x1        // Interrupt is generated when MR0 matches the value in the TC.
	TIMER0_MCR_MR0I_INTERRUPT_IS_DISABLE = 0x0        // Interrupt is disabled
	TIMER0_MCR_MR0R_Pos                  = 0x1        // Position of MR0R field.
	TIMER0_MCR_MR0R_Msk                  = 0x2        // Bit mask of MR0R field.
	TIMER0_MCR_MR0R                      = 0x2        // Bit MR0R.
	TIMER0_MCR_MR0R_TC_WILL_BE_RESET_IF_ = 0x1        // TC will be reset if MR0 matches it.
	TIMER0_MCR_MR0R_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR0S_Pos                  = 0x2        // Position of MR0S field.
	TIMER0_MCR_MR0S_Msk                  = 0x4        // Bit mask of MR0S field.
	TIMER0_MCR_MR0S                      = 0x4        // Bit MR0S.
	TIMER0_MCR_MR0S_TC_AND_PC_WILL_BE_ST = 0x1        // TC and PC will be stopped and TCR[0] will be set to 0 if MR0 matches the TC.
	TIMER0_MCR_MR0S_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR1I_Pos                  = 0x3        // Position of MR1I field.
	TIMER0_MCR_MR1I_Msk                  = 0x8        // Bit mask of MR1I field.
	TIMER0_MCR_MR1I                      = 0x8        // Bit MR1I.
	TIMER0_MCR_MR1I_INTERRUPT_IS_GENERAT = 0x1        // Interrupt is generated when MR1 matches the value in the TC.
	TIMER0_MCR_MR1I_INTERRUPT_IS_DISABLE = 0x0        // Interrupt is disabled.
	TIMER0_MCR_MR1R_Pos                  = 0x4        // Position of MR1R field.
	TIMER0_MCR_MR1R_Msk                  = 0x10       // Bit mask of MR1R field.
	TIMER0_MCR_MR1R                      = 0x10       // Bit MR1R.
	TIMER0_MCR_MR1R_TC_WILL_BE_RESET_IF_ = 0x1        // TC will be reset if MR1 matches it.
	TIMER0_MCR_MR1R_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR1S_Pos                  = 0x5        // Position of MR1S field.
	TIMER0_MCR_MR1S_Msk                  = 0x20       // Bit mask of MR1S field.
	TIMER0_MCR_MR1S                      = 0x20       // Bit MR1S.
	TIMER0_MCR_MR1S_TC_AND_PC_WILL_BE_ST = 0x1        // TC and PC will be stopped and TCR[0] will be set to 0 if MR1 matches the TC.
	TIMER0_MCR_MR1S_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR2I_Pos                  = 0x6        // Position of MR2I field.
	TIMER0_MCR_MR2I_Msk                  = 0x40       // Bit mask of MR2I field.
	TIMER0_MCR_MR2I                      = 0x40       // Bit MR2I.
	TIMER0_MCR_MR2I_INTERRUPT_IS_GENERAT = 0x1        // Interrupt is generated when MR2 matches the value in the TC.
	TIMER0_MCR_MR2I_INTERRUPT_IS_DISABLE = 0x0        // Interrupt is disabled
	TIMER0_MCR_MR2R_Pos                  = 0x7        // Position of MR2R field.
	TIMER0_MCR_MR2R_Msk                  = 0x80       // Bit mask of MR2R field.
	TIMER0_MCR_MR2R                      = 0x80       // Bit MR2R.
	TIMER0_MCR_MR2R_TC_WILL_BE_RESET_IF_ = 0x1        // TC will be reset if MR2 matches it.
	TIMER0_MCR_MR2R_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR2S_Pos                  = 0x8        // Position of MR2S field.
	TIMER0_MCR_MR2S_Msk                  = 0x100      // Bit mask of MR2S field.
	TIMER0_MCR_MR2S                      = 0x100      // Bit MR2S.
	TIMER0_MCR_MR2S_TC_AND_PC_WILL_BE_ST = 0x1        // TC and PC will be stopped and TCR[0] will be set to 0 if MR2 matches the TC
	TIMER0_MCR_MR2S_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR3I_Pos                  = 0x9        // Position of MR3I field.
	TIMER0_MCR_MR3I_Msk                  = 0x200      // Bit mask of MR3I field.
	TIMER0_MCR_MR3I                      = 0x200      // Bit MR3I.
	TIMER0_MCR_MR3I_INTERRUPT_IS_GENERAT = 0x1        // Interrupt is generated when MR3 matches the value in the TC.
	TIMER0_MCR_MR3I_THIS_INTERRUPT_IS_DI = 0x0        // This interrupt is disabled
	TIMER0_MCR_MR3R_Pos                  = 0xa        // Position of MR3R field.
	TIMER0_MCR_MR3R_Msk                  = 0x400      // Bit mask of MR3R field.
	TIMER0_MCR_MR3R                      = 0x400      // Bit MR3R.
	TIMER0_MCR_MR3R_TC_WILL_BE_RESET_IF_ = 0x1        // TC will be reset if MR3 matches it.
	TIMER0_MCR_MR3R_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_MR3S_Pos                  = 0xb        // Position of MR3S field.
	TIMER0_MCR_MR3S_Msk                  = 0x800      // Bit mask of MR3S field.
	TIMER0_MCR_MR3S                      = 0x800      // Bit MR3S.
	TIMER0_MCR_MR3S_TC_AND_PC_WILL_BE_ST = 0x1        // TC and PC will be stopped and TCR[0] will be set to 0 if MR3 matches the TC.
	TIMER0_MCR_MR3S_FEATURE_DISABLED_    = 0x0        // Feature disabled.
	TIMER0_MCR_RESERVED_Pos              = 0xc        // Position of RESERVED field.
	TIMER0_MCR_RESERVED_Msk              = 0xfffff000 // Bit mask of RESERVED field.

	// MR: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
	TIMER0_MR_MATCH_Pos = 0x0        // Position of MATCH field.
	TIMER0_MR_MATCH_Msk = 0xffffffff // Bit mask of MATCH field.

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
	TIMER0_CCR_CAP0RE_Pos     = 0x0        // Position of CAP0RE field.
	TIMER0_CCR_CAP0RE_Msk     = 0x1        // Bit mask of CAP0RE field.
	TIMER0_CCR_CAP0RE         = 0x1        // Bit CAP0RE.
	TIMER0_CCR_CAP0RE_ENABLE  = 0x1        // A sequence of 0 then 1 on CAPn.0 will cause CR0 to be loaded with the contents of TC.
	TIMER0_CCR_CAP0RE_DISABLE = 0x0        // This feature is disabled.
	TIMER0_CCR_CAP0FE_Pos     = 0x1        // Position of CAP0FE field.
	TIMER0_CCR_CAP0FE_Msk     = 0x2        // Bit mask of CAP0FE field.
	TIMER0_CCR_CAP0FE         = 0x2        // Bit CAP0FE.
	TIMER0_CCR_CAP0FE_ENABLE  = 0x1        // A sequence of 1 then 0 on CAPn.0 will cause CR0 to be loaded with the contents of TC.
	TIMER0_CCR_CAP0FE_DISABLE = 0x0        // This feature is disabled.
	TIMER0_CCR_CAP0I_Pos      = 0x2        // Position of CAP0I field.
	TIMER0_CCR_CAP0I_Msk      = 0x4        // Bit mask of CAP0I field.
	TIMER0_CCR_CAP0I          = 0x4        // Bit CAP0I.
	TIMER0_CCR_CAP0I_ENABLE   = 0x1        // A CR0 load due to a CAPn.0 event will generate an interrupt.
	TIMER0_CCR_CAP0I_DISABLE  = 0x0        // This feature is disabled.
	TIMER0_CCR_CAP1RE_Pos     = 0x3        // Position of CAP1RE field.
	TIMER0_CCR_CAP1RE_Msk     = 0x8        // Bit mask of CAP1RE field.
	TIMER0_CCR_CAP1RE         = 0x8        // Bit CAP1RE.
	TIMER0_CCR_CAP1RE_ENABLE  = 0x1        // A sequence of 0 then 1 on CAPn.1 will cause CR1 to be loaded with the contents of TC.
	TIMER0_CCR_CAP1RE_DISABLE = 0x0        // This feature is disabled.
	TIMER0_CCR_CAP1FE_Pos     = 0x4        // Position of CAP1FE field.
	TIMER0_CCR_CAP1FE_Msk     = 0x10       // Bit mask of CAP1FE field.
	TIMER0_CCR_CAP1FE         = 0x10       // Bit CAP1FE.
	TIMER0_CCR_CAP1FE_ENABLE  = 0x1        // A sequence of 1 then 0 on CAPn.1 will cause CR1 to be loaded with the contents of TC.
	TIMER0_CCR_CAP1FE_DISABLE = 0x0        // This feature is disabled.
	TIMER0_CCR_CAP1I_Pos      = 0x5        // Position of CAP1I field.
	TIMER0_CCR_CAP1I_Msk      = 0x20       // Bit mask of CAP1I field.
	TIMER0_CCR_CAP1I          = 0x20       // Bit CAP1I.
	TIMER0_CCR_CAP1I_ENABLE   = 0x1        // A CR1 load due to a CAPn.1 event will generate an interrupt.
	TIMER0_CCR_CAP1I_DISABLE  = 0x0        // This feature is disabled.
	TIMER0_CCR_RESERVED_Pos   = 0x6        // Position of RESERVED field.
	TIMER0_CCR_RESERVED_Msk   = 0xffffffc0 // Bit mask of RESERVED field.

	// CR: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CAPn.0 input.
	TIMER0_CR_CAP_Pos = 0x0        // Position of CAP field.
	TIMER0_CR_CAP_Msk = 0xffffffff // Bit mask of CAP field.

	// EMR: External Match Register. The EMR controls the external match pins.
	TIMER0_EMR_EM0_Pos                   = 0x0        // Position of EM0 field.
	TIMER0_EMR_EM0_Msk                   = 0x1        // Bit mask of EM0 field.
	TIMER0_EMR_EM0                       = 0x1        // Bit EM0.
	TIMER0_EMR_EM1_Pos                   = 0x1        // Position of EM1 field.
	TIMER0_EMR_EM1_Msk                   = 0x2        // Bit mask of EM1 field.
	TIMER0_EMR_EM1                       = 0x2        // Bit EM1.
	TIMER0_EMR_EM2_Pos                   = 0x2        // Position of EM2 field.
	TIMER0_EMR_EM2_Msk                   = 0x4        // Bit mask of EM2 field.
	TIMER0_EMR_EM2                       = 0x4        // Bit EM2.
	TIMER0_EMR_EM3_Pos                   = 0x3        // Position of EM3 field.
	TIMER0_EMR_EM3_Msk                   = 0x8        // Bit mask of EM3 field.
	TIMER0_EMR_EM3                       = 0x8        // Bit EM3.
	TIMER0_EMR_EMC0_Pos                  = 0x4        // Position of EMC0 field.
	TIMER0_EMR_EMC0_Msk                  = 0x30       // Bit mask of EMC0 field.
	TIMER0_EMR_EMC0_DO_NOTHING_          = 0x0        // Do Nothing.
	TIMER0_EMR_EMC0_CLEAR_THE_CORRESPOND = 0x1        // Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC0_SET_THE_CORRESPONDIN = 0x2        // Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC0_TOGGLE_THE_CORRESPON = 0x3        // Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC1_Pos                  = 0x6        // Position of EMC1 field.
	TIMER0_EMR_EMC1_Msk                  = 0xc0       // Bit mask of EMC1 field.
	TIMER0_EMR_EMC1_DO_NOTHING_          = 0x0        // Do Nothing.
	TIMER0_EMR_EMC1_CLEAR_THE_CORRESPOND = 0x1        // Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC1_SET_THE_CORRESPONDIN = 0x2        // Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC1_TOGGLE_THE_CORRESPON = 0x3        // Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC2_Pos                  = 0x8        // Position of EMC2 field.
	TIMER0_EMR_EMC2_Msk                  = 0x300      // Bit mask of EMC2 field.
	TIMER0_EMR_EMC2_DO_NOTHING_          = 0x0        // Do Nothing.
	TIMER0_EMR_EMC2_CLEAR_THE_CORRESPOND = 0x1        // Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC2_SET_THE_CORRESPONDIN = 0x2        // Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC2_TOGGLE_THE_CORRESPON = 0x3        // Toggle the corresponding External Match bit/output.
	TIMER0_EMR_EMC3_Pos                  = 0xa        // Position of EMC3 field.
	TIMER0_EMR_EMC3_Msk                  = 0xc00      // Bit mask of EMC3 field.
	TIMER0_EMR_EMC3_DO_NOTHING_          = 0x0        // Do Nothing.
	TIMER0_EMR_EMC3_CLEAR_THE_CORRESPOND = 0x1        // Clear the corresponding External Match bit/output to 0 (MATn.m pin is LOW if pinned out).
	TIMER0_EMR_EMC3_SET_THE_CORRESPONDIN = 0x2        // Set the corresponding External Match bit/output to 1 (MATn.m pin is HIGH if pinned out).
	TIMER0_EMR_EMC3_TOGGLE_THE_CORRESPON = 0x3        // Toggle the corresponding External Match bit/output.
	TIMER0_EMR_RESERVED_Pos              = 0xc        // Position of RESERVED field.
	TIMER0_EMR_RESERVED_Msk              = 0xfffff000 // Bit mask of RESERVED field.

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	TIMER0_CTCR_CTMODE_Pos                 = 0x0        // Position of CTMODE field.
	TIMER0_CTCR_CTMODE_Msk                 = 0x3        // Bit mask of CTMODE field.
	TIMER0_CTCR_CTMODE_TIMER_MODE_EVERY_RI = 0x0        // Timer Mode: every rising PCLK edge
	TIMER0_CTCR_CTMODE_RISING              = 0x1        // Counter Mode: TC is incremented on rising edges on the CAP input selected by bits 3:2.
	TIMER0_CTCR_CTMODE_FALLING             = 0x2        // Counter Mode: TC is incremented on falling edges on the CAP input selected by bits 3:2.
	TIMER0_CTCR_CTMODE_DUALEDGE            = 0x3        // Counter Mode: TC is incremented on both edges on the CAP input selected by bits 3:2.
	TIMER0_CTCR_CINSEL_Pos                 = 0x2        // Position of CINSEL field.
	TIMER0_CTCR_CINSEL_Msk                 = 0xc        // Bit mask of CINSEL field.
	TIMER0_CTCR_CINSEL_CAPN_0_FOR_TIMERN   = 0x0        // CAPn.0 for TIMERn
	TIMER0_CTCR_CINSEL_CAPN_1_FOR_TIMERN   = 0x1        // CAPn.1 for TIMERn
	TIMER0_CTCR_RESERVED_Pos               = 0x4        // Position of RESERVED field.
	TIMER0_CTCR_RESERVED_Msk               = 0xfffffff0 // Bit mask of RESERVED field.
)

// Bitfields for UART0: UART0/2/3
const (
	// RBR: Receiver Buffer Register. Contains the next received character to be read (DLAB =0).
	UART0_RBR_RBR_Pos      = 0x0        // Position of RBR field.
	UART0_RBR_RBR_Msk      = 0xff       // Bit mask of RBR field.
	UART0_RBR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_RBR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// THR: Transmit Holding Regiter. The next character to be transmitted is written here (DLAB =0).
	UART0_THR_THR_Pos      = 0x0        // Position of THR field.
	UART0_THR_THR_Msk      = 0xff       // Bit mask of THR field.
	UART0_THR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_THR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DLL: Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
	UART0_DLL_DLLSB_Pos    = 0x0        // Position of DLLSB field.
	UART0_DLL_DLLSB_Msk    = 0xff       // Bit mask of DLLSB field.
	UART0_DLL_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_DLL_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
	UART0_DLM_DLMSB_Pos    = 0x0        // Position of DLMSB field.
	UART0_DLM_DLMSB_Msk    = 0xff       // Bit mask of DLMSB field.
	UART0_DLM_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_DLM_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// IER: Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART interrupts (DLAB =0).
	UART0_IER_RBRIE_Pos                      = 0x0        // Position of RBRIE field.
	UART0_IER_RBRIE_Msk                      = 0x1        // Bit mask of RBRIE field.
	UART0_IER_RBRIE                          = 0x1        // Bit RBRIE.
	UART0_IER_RBRIE_DISABLE_THE_RDA_INTE     = 0x0        // Disable the RDA interrupts.
	UART0_IER_RBRIE_ENABLE_THE_RDA_INTER     = 0x1        // Enable the RDA interrupts.
	UART0_IER_THREIE_Pos                     = 0x1        // Position of THREIE field.
	UART0_IER_THREIE_Msk                     = 0x2        // Bit mask of THREIE field.
	UART0_IER_THREIE                         = 0x2        // Bit THREIE.
	UART0_IER_THREIE_DISABLE_THE_THRE_INT    = 0x0        // Disable the THRE interrupts.
	UART0_IER_THREIE_ENABLE_THE_THRE_INTE    = 0x1        // Enable the THRE interrupts.
	UART0_IER_RXIE_Pos                       = 0x2        // Position of RXIE field.
	UART0_IER_RXIE_Msk                       = 0x4        // Bit mask of RXIE field.
	UART0_IER_RXIE                           = 0x4        // Bit RXIE.
	UART0_IER_RXIE_DISABLE_THE_RX_LINE_      = 0x0        // Disable the RX line status interrupts.
	UART0_IER_RXIE_ENABLE_THE_RX_LINE_S      = 0x1        // Enable the RX line status interrupts.
	UART0_IER_RESERVED_Pos                   = 0x3        // Position of RESERVED field.
	UART0_IER_RESERVED_Msk                   = 0xf8       // Bit mask of RESERVED field.
	UART0_IER_ABEOINTEN_Pos                  = 0x8        // Position of ABEOINTEN field.
	UART0_IER_ABEOINTEN_Msk                  = 0x100      // Bit mask of ABEOINTEN field.
	UART0_IER_ABEOINTEN                      = 0x100      // Bit ABEOINTEN.
	UART0_IER_ABEOINTEN_DISABLE_END_OF_AUTO_ = 0x0        // Disable end of auto-baud Interrupt.
	UART0_IER_ABEOINTEN_ENABLE_END_OF_AUTO_B = 0x1        // Enable end of auto-baud Interrupt.
	UART0_IER_ABTOINTEN_Pos                  = 0x9        // Position of ABTOINTEN field.
	UART0_IER_ABTOINTEN_Msk                  = 0x200      // Bit mask of ABTOINTEN field.
	UART0_IER_ABTOINTEN                      = 0x200      // Bit ABTOINTEN.
	UART0_IER_ABTOINTEN_DISABLE_AUTO_BAUD_TI = 0x0        // Disable auto-baud time-out Interrupt.
	UART0_IER_ABTOINTEN_ENABLE_AUTO_BAUD_TIM = 0x1        // Enable auto-baud time-out Interrupt.
	UART0_IER_RESERVED_Pos                   = 0xa        // Position of RESERVED field.
	UART0_IER_RESERVED_Msk                   = 0xfffffc00 // Bit mask of RESERVED field.

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	UART0_IIR_INTSTATUS_Pos                  = 0x0        // Position of INTSTATUS field.
	UART0_IIR_INTSTATUS_Msk                  = 0x1        // Bit mask of INTSTATUS field.
	UART0_IIR_INTSTATUS                      = 0x1        // Bit INTSTATUS.
	UART0_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0        // At least one interrupt is pending.
	UART0_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1        // No interrupt is pending.
	UART0_IIR_INTID_Pos                      = 0x1        // Position of INTID field.
	UART0_IIR_INTID_Msk                      = 0xe        // Bit mask of INTID field.
	UART0_IIR_INTID_1_RECEIVE_LINE_S         = 0x3        // 1   - Receive Line Status (RLS).
	UART0_IIR_INTID_2A__RECEIVE_DATA_AV      = 0x2        // 2a - Receive Data Available (RDA).
	UART0_IIR_INTID_2B__CHARACTER_TIME_      = 0x6        // 2b - Character Time-out Indicator (CTI).
	UART0_IIR_INTID_3_THRE_INTERRUPT         = 0x1        // 3   - THRE Interrupt
	UART0_IIR_RESERVED_Pos                   = 0x4        // Position of RESERVED field.
	UART0_IIR_RESERVED_Msk                   = 0x30       // Bit mask of RESERVED field.
	UART0_IIR_FIFOENABLE_Pos                 = 0x6        // Position of FIFOENABLE field.
	UART0_IIR_FIFOENABLE_Msk                 = 0xc0       // Bit mask of FIFOENABLE field.
	UART0_IIR_ABEOINT_Pos                    = 0x8        // Position of ABEOINT field.
	UART0_IIR_ABEOINT_Msk                    = 0x100      // Bit mask of ABEOINT field.
	UART0_IIR_ABEOINT                        = 0x100      // Bit ABEOINT.
	UART0_IIR_ABTOINT_Pos                    = 0x9        // Position of ABTOINT field.
	UART0_IIR_ABTOINT_Msk                    = 0x200      // Bit mask of ABTOINT field.
	UART0_IIR_ABTOINT                        = 0x200      // Bit ABTOINT.
	UART0_IIR_RESERVED_Pos                   = 0xa        // Position of RESERVED field.
	UART0_IIR_RESERVED_Msk                   = 0xfffffc00 // Bit mask of RESERVED field.

	// FCR: FIFO Control Register. Controls UART FIFO usage and modes.
	UART0_FCR_FIFOEN_Pos                     = 0x0        // Position of FIFOEN field.
	UART0_FCR_FIFOEN_Msk                     = 0x1        // Bit mask of FIFOEN field.
	UART0_FCR_FIFOEN                         = 0x1        // Bit FIFOEN.
	UART0_FCR_FIFOEN_UARTN_FIFOS_ARE_DISA    = 0x0        // UARTn FIFOs are disabled. Must not be used in the application.
	UART0_FCR_FIFOEN_ACTIVE_HIGH_ENABLE_F    = 0x1        // Active high enable for both UARTn Rx and TX FIFOs and UnFCR[7:1] access. This bit must be set for proper UART operation. Any transition on this bit will automatically clear the related UART FIFOs.
	UART0_FCR_RXFIFORES_Pos                  = 0x1        // Position of RXFIFORES field.
	UART0_FCR_RXFIFORES_Msk                  = 0x2        // Bit mask of RXFIFORES field.
	UART0_FCR_RXFIFORES                      = 0x2        // Bit RXFIFORES.
	UART0_FCR_RXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0        // No impact on either of UARTn FIFOs.
	UART0_FCR_RXFIFORES_WRITING_A_LOGIC_1_TO = 0x1        // Writing a logic 1 to UnFCR[1] will clear all bytes in UARTn Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART0_FCR_TXFIFORES_Pos                  = 0x2        // Position of TXFIFORES field.
	UART0_FCR_TXFIFORES_Msk                  = 0x4        // Bit mask of TXFIFORES field.
	UART0_FCR_TXFIFORES                      = 0x4        // Bit TXFIFORES.
	UART0_FCR_TXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0        // No impact on either of UARTn FIFOs.
	UART0_FCR_TXFIFORES_WRITING_A_LOGIC_1_TO = 0x1        // Writing a logic 1 to UnFCR[2] will clear all bytes in UARTn TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART0_FCR_DMAMODE_Pos                    = 0x3        // Position of DMAMODE field.
	UART0_FCR_DMAMODE_Msk                    = 0x8        // Bit mask of DMAMODE field.
	UART0_FCR_DMAMODE                        = 0x8        // Bit DMAMODE.
	UART0_FCR_RESERVED_Pos                   = 0x4        // Position of RESERVED field.
	UART0_FCR_RESERVED_Msk                   = 0x30       // Bit mask of RESERVED field.
	UART0_FCR_RXTRIGLVL_Pos                  = 0x6        // Position of RXTRIGLVL field.
	UART0_FCR_RXTRIGLVL_Msk                  = 0xc0       // Bit mask of RXTRIGLVL field.
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_0_1_C  = 0x0        // Trigger level 0 (1 character or 0x01).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_1_4_C  = 0x1        // Trigger level 1 (4 characters or 0x04).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_2_8_C  = 0x2        // Trigger level 2 (8 characters or 0x08).
	UART0_FCR_RXTRIGLVL_TRIGGER_LEVEL_3_14_  = 0x3        // Trigger level 3 (14 characters or 0x0E).
	UART0_FCR_RESERVED_Pos                   = 0x8        // Position of RESERVED field.
	UART0_FCR_RESERVED_Msk                   = 0xffffff00 // Bit mask of RESERVED field.

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	UART0_LCR_WLS_Pos                   = 0x0        // Position of WLS field.
	UART0_LCR_WLS_Msk                   = 0x3        // Bit mask of WLS field.
	UART0_LCR_WLS_5_BIT_CHARACTER_LENG  = 0x0        // 5-bit character length
	UART0_LCR_WLS_6_BIT_CHARACTER_LENG  = 0x1        // 6-bit character length
	UART0_LCR_WLS_7_BIT_CHARACTER_LENG  = 0x2        // 7-bit character length
	UART0_LCR_WLS_8_BIT_CHARACTER_LENG  = 0x3        // 8-bit character length
	UART0_LCR_SBS_Pos                   = 0x2        // Position of SBS field.
	UART0_LCR_SBS_Msk                   = 0x4        // Bit mask of SBS field.
	UART0_LCR_SBS                       = 0x4        // Bit SBS.
	UART0_LCR_SBS_1_STOP_BIT_           = 0x0        // 1 stop bit.
	UART0_LCR_SBS_2_STOP_BITS_1_5_IF_   = 0x1        // 2 stop bits (1.5 if UnLCR[1:0]=00).
	UART0_LCR_PE_Pos                    = 0x3        // Position of PE field.
	UART0_LCR_PE_Msk                    = 0x8        // Bit mask of PE field.
	UART0_LCR_PE                        = 0x8        // Bit PE.
	UART0_LCR_PE_DISABLE_PARITY_GENER   = 0x0        // Disable parity generation and checking.
	UART0_LCR_PE_ENABLE_PARITY_GENERA   = 0x1        // Enable parity generation and checking.
	UART0_LCR_PS_Pos                    = 0x4        // Position of PS field.
	UART0_LCR_PS_Msk                    = 0x30       // Bit mask of PS field.
	UART0_LCR_PS_ODD_PARITY_NUMBER_O    = 0x0        // Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART0_LCR_PS_EVEN_PARITY_NUMBER_    = 0x1        // Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART0_LCR_PS_FORCED_1_STICK_PARIT   = 0x2        // Forced 1 stick parity.
	UART0_LCR_PS_FORCED_0_STICK_PARIT   = 0x3        // Forced 0 stick parity.
	UART0_LCR_BC_Pos                    = 0x6        // Position of BC field.
	UART0_LCR_BC_Msk                    = 0x40       // Bit mask of BC field.
	UART0_LCR_BC                        = 0x40       // Bit BC.
	UART0_LCR_BC_DISABLE_BREAK_TRANSM   = 0x0        // Disable break transmission.
	UART0_LCR_BC_ENABLE_BREAK_TRANSMI   = 0x1        // Enable break transmission. Output pin UARTn TXD is forced to logic 0 when UnLCR[6] is active high.
	UART0_LCR_DLAB_Pos                  = 0x7        // Position of DLAB field.
	UART0_LCR_DLAB_Msk                  = 0x80       // Bit mask of DLAB field.
	UART0_LCR_DLAB                      = 0x80       // Bit DLAB.
	UART0_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0        // Disable access to Divisor Latches.
	UART0_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1        // Enable access to Divisor Latches.
	UART0_LCR_RESERVED_Pos              = 0x8        // Position of RESERVED field.
	UART0_LCR_RESERVED_Msk              = 0xffffff00 // Bit mask of RESERVED field.

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	UART0_LSR_RDR_Pos        = 0x0        // Position of RDR field.
	UART0_LSR_RDR_Msk        = 0x1        // Bit mask of RDR field.
	UART0_LSR_RDR            = 0x1        // Bit RDR.
	UART0_LSR_RDR_EMPTY      = 0x0        // The UARTn receiver FIFO is empty.
	UART0_LSR_RDR_NOTEMPTY   = 0x1        // The UARTn receiver FIFO is not empty.
	UART0_LSR_OE_Pos         = 0x1        // Position of OE field.
	UART0_LSR_OE_Msk         = 0x2        // Bit mask of OE field.
	UART0_LSR_OE             = 0x2        // Bit OE.
	UART0_LSR_OE_INACTIVE    = 0x0        // Overrun error status is inactive.
	UART0_LSR_OE_ACTIVE      = 0x1        // Overrun error status is active.
	UART0_LSR_PE_Pos         = 0x2        // Position of PE field.
	UART0_LSR_PE_Msk         = 0x4        // Bit mask of PE field.
	UART0_LSR_PE             = 0x4        // Bit PE.
	UART0_LSR_PE_INACTIVE    = 0x0        // Parity error status is inactive.
	UART0_LSR_PE_ACTIVE      = 0x1        // Parity error status is active.
	UART0_LSR_FE_Pos         = 0x3        // Position of FE field.
	UART0_LSR_FE_Msk         = 0x8        // Bit mask of FE field.
	UART0_LSR_FE             = 0x8        // Bit FE.
	UART0_LSR_FE_INACTIVE    = 0x0        // Framing error status is inactive.
	UART0_LSR_FE_ACTIVE      = 0x1        // Framing error status is active.
	UART0_LSR_BI_Pos         = 0x4        // Position of BI field.
	UART0_LSR_BI_Msk         = 0x10       // Bit mask of BI field.
	UART0_LSR_BI             = 0x10       // Bit BI.
	UART0_LSR_BI_INACTIVE    = 0x0        // Break interrupt status is inactive.
	UART0_LSR_BI_ACTIVE      = 0x1        // Break interrupt status is active.
	UART0_LSR_THRE_Pos       = 0x5        // Position of THRE field.
	UART0_LSR_THRE_Msk       = 0x20       // Bit mask of THRE field.
	UART0_LSR_THRE           = 0x20       // Bit THRE.
	UART0_LSR_THRE_VALIDDATA = 0x0        // UnTHR contains valid data.
	UART0_LSR_THRE_EMPTY     = 0x1        // UnTHR is empty.
	UART0_LSR_TEMT_Pos       = 0x6        // Position of TEMT field.
	UART0_LSR_TEMT_Msk       = 0x40       // Bit mask of TEMT field.
	UART0_LSR_TEMT           = 0x40       // Bit TEMT.
	UART0_LSR_TEMT_VALIDDATA = 0x0        // UnTHR and/or the UnTSR contains valid data.
	UART0_LSR_TEMT_EMPTY     = 0x1        // UnTHR and the UnTSR are empty.
	UART0_LSR_RXFE_Pos       = 0x7        // Position of RXFE field.
	UART0_LSR_RXFE_Msk       = 0x80       // Bit mask of RXFE field.
	UART0_LSR_RXFE           = 0x80       // Bit RXFE.
	UART0_LSR_RXFE_NOERROR   = 0x0        // UnRBR contains no UARTn RX errors or UnFCR[0]=0.
	UART0_LSR_RXFE_ERRORS    = 0x1        // UARTn RBR contains at least one UARTn RX error.
	UART0_LSR_RESERVED_Pos   = 0x8        // Position of RESERVED field.
	UART0_LSR_RESERVED_Msk   = 0xffffff00 // Bit mask of RESERVED field.

	// SCR: Scratch Pad Register. 8-bit temporary storage for software.
	UART0_SCR_PAD_Pos      = 0x0        // Position of PAD field.
	UART0_SCR_PAD_Msk      = 0xff       // Bit mask of PAD field.
	UART0_SCR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_SCR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	UART0_ACR_START_Pos                        = 0x0        // Position of START field.
	UART0_ACR_START_Msk                        = 0x1        // Bit mask of START field.
	UART0_ACR_START                            = 0x1        // Bit START.
	UART0_ACR_START_AUTO_BAUD_STOP_AUTO        = 0x0        // Auto-baud stop (auto-baud is not running).
	UART0_ACR_START_AUTO_BAUD_START_AUT        = 0x1        // Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART0_ACR_MODE_Pos                         = 0x1        // Position of MODE field.
	UART0_ACR_MODE_Msk                         = 0x2        // Bit mask of MODE field.
	UART0_ACR_MODE                             = 0x2        // Bit MODE.
	UART0_ACR_MODE_MODE_0_                     = 0x0        // Mode 0.
	UART0_ACR_MODE_MODE_1_                     = 0x1        // Mode 1.
	UART0_ACR_AUTORESTART_Pos                  = 0x2        // Position of AUTORESTART field.
	UART0_ACR_AUTORESTART_Msk                  = 0x4        // Bit mask of AUTORESTART field.
	UART0_ACR_AUTORESTART                      = 0x4        // Bit AUTORESTART.
	UART0_ACR_AUTORESTART_NO_RESTART_          = 0x0        // No restart.
	UART0_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1        // Restart in case of time-out (counter restarts at next UARTn Rx falling edge)
	UART0_ACR_RESERVED_Pos                     = 0x3        // Position of RESERVED field.
	UART0_ACR_RESERVED_Msk                     = 0xf8       // Bit mask of RESERVED field.
	UART0_ACR_ABEOINTCLR_Pos                   = 0x8        // Position of ABEOINTCLR field.
	UART0_ACR_ABEOINTCLR_Msk                   = 0x100      // Bit mask of ABEOINTCLR field.
	UART0_ACR_ABEOINTCLR                       = 0x100      // Bit ABEOINTCLR.
	UART0_ACR_ABEOINTCLR_NO_IMPACT_            = 0x0        // No impact.
	UART0_ACR_ABEOINTCLR_CLEAR_THE_CORRESPOND  = 0x1        // Clear the corresponding interrupt in the IIR.
	UART0_ACR_ABTOINTCLR_Pos                   = 0x9        // Position of ABTOINTCLR field.
	UART0_ACR_ABTOINTCLR_Msk                   = 0x200      // Bit mask of ABTOINTCLR field.
	UART0_ACR_ABTOINTCLR                       = 0x200      // Bit ABTOINTCLR.
	UART0_ACR_ABTOINTCLR_NO_IMPACT_            = 0x0        // No impact.
	UART0_ACR_ABTOINTCLR_CLEAR_THE_CORRESPOND  = 0x1        // Clear the corresponding interrupt in the IIR.
	UART0_ACR_RESERVED_Pos                     = 0xa        // Position of RESERVED field.
	UART0_ACR_RESERVED_Msk                     = 0xfffffc00 // Bit mask of RESERVED field.

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	UART0_FDR_DIVADDVAL_Pos = 0x0        // Position of DIVADDVAL field.
	UART0_FDR_DIVADDVAL_Msk = 0xf        // Bit mask of DIVADDVAL field.
	UART0_FDR_MULVAL_Pos    = 0x4        // Position of MULVAL field.
	UART0_FDR_MULVAL_Msk    = 0xf0       // Bit mask of MULVAL field.
	UART0_FDR_RESERVED_Pos  = 0x8        // Position of RESERVED field.
	UART0_FDR_RESERVED_Msk  = 0xffffff00 // Bit mask of RESERVED field.

	// TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
	UART0_TER_RESERVED_Pos = 0x0        // Position of RESERVED field.
	UART0_TER_RESERVED_Msk = 0x7f       // Bit mask of RESERVED field.
	UART0_TER_TXEN_Pos     = 0x7        // Position of TXEN field.
	UART0_TER_TXEN_Msk     = 0x80       // Bit mask of TXEN field.
	UART0_TER_TXEN         = 0x80       // Bit TXEN.
	UART0_TER_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_TER_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	UART0_RS485CTRL_NMMEN_Pos                  = 0x0        // Position of NMMEN field.
	UART0_RS485CTRL_NMMEN_Msk                  = 0x1        // Bit mask of NMMEN field.
	UART0_RS485CTRL_NMMEN                      = 0x1        // Bit NMMEN.
	UART0_RS485CTRL_NMMEN_DISABLED             = 0x0        // RS-485/EIA-485 Normal Multidrop Mode (NMM) is disabled.
	UART0_RS485CTRL_NMMEN_ENABLED              = 0x1        // RS-485/EIA-485 Normal Multidrop Mode (NMM) is enabled. In this mode, an address is detected when a received byte has the parity bit = 1, generating a received data interrupt. See Section 18.6.16 RS-485/EIA-485 modes of operation.
	UART0_RS485CTRL_RXDIS_Pos                  = 0x1        // Position of RXDIS field.
	UART0_RS485CTRL_RXDIS_Msk                  = 0x2        // Bit mask of RXDIS field.
	UART0_RS485CTRL_RXDIS                      = 0x2        // Bit RXDIS.
	UART0_RS485CTRL_RXDIS_ENABLED              = 0x0        // The receiver is enabled.
	UART0_RS485CTRL_RXDIS_DISABLED             = 0x1        // The receiver is disabled.
	UART0_RS485CTRL_AADEN_Pos                  = 0x2        // Position of AADEN field.
	UART0_RS485CTRL_AADEN_Msk                  = 0x4        // Bit mask of AADEN field.
	UART0_RS485CTRL_AADEN                      = 0x4        // Bit AADEN.
	UART0_RS485CTRL_AADEN_DISABLED             = 0x0        // Auto Address Detect (AAD) is disabled.
	UART0_RS485CTRL_AADEN_ENABLED              = 0x1        // Auto Address Detect (AAD) is enabled.
	UART0_RS485CTRL_RESERVED_Pos               = 0x3        // Position of RESERVED field.
	UART0_RS485CTRL_RESERVED_Msk               = 0x8        // Bit mask of RESERVED field.
	UART0_RS485CTRL_RESERVED                   = 0x8        // Bit RESERVED.
	UART0_RS485CTRL_DCTRL_Pos                  = 0x4        // Position of DCTRL field.
	UART0_RS485CTRL_DCTRL_Msk                  = 0x10       // Bit mask of DCTRL field.
	UART0_RS485CTRL_DCTRL                      = 0x10       // Bit DCTRL.
	UART0_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0        // Disable Auto Direction Control.
	UART0_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1        // Enable Auto Direction Control.
	UART0_RS485CTRL_OINV_Pos                   = 0x5        // Position of OINV field.
	UART0_RS485CTRL_OINV_Msk                   = 0x20       // Bit mask of OINV field.
	UART0_RS485CTRL_OINV                       = 0x20       // Bit OINV.
	UART0_RS485CTRL_OINV_DIRLOW                = 0x0        // The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	UART0_RS485CTRL_OINV_DIRHIGH               = 0x1        // The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	UART0_RS485CTRL_RESERVED_Pos               = 0x6        // Position of RESERVED field.
	UART0_RS485CTRL_RESERVED_Msk               = 0xffffffc0 // Bit mask of RESERVED field.

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	UART0_RS485ADRMATCH_ADRMATCH_Pos = 0x0        // Position of ADRMATCH field.
	UART0_RS485ADRMATCH_ADRMATCH_Msk = 0xff       // Bit mask of ADRMATCH field.
	UART0_RS485ADRMATCH_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_RS485ADRMATCH_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// RS485DLY: RS-485/EIA-485 direction control delay.
	UART0_RS485DLY_DLY_Pos      = 0x0        // Position of DLY field.
	UART0_RS485DLY_DLY_Msk      = 0xff       // Bit mask of DLY field.
	UART0_RS485DLY_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART0_RS485DLY_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.
)

// Bitfields for UART1: UART1
const (
	// RBR: DLAB =0 Receiver Buffer Register. Contains the next received character to be read.
	UART1_RBR_RBR_Pos      = 0x0        // Position of RBR field.
	UART1_RBR_RBR_Msk      = 0xff       // Bit mask of RBR field.
	UART1_RBR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_RBR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// THR: DLAB =0. Transmit Holding Register. The next character to be transmitted is written here.
	UART1_THR_THR_Pos      = 0x0        // Position of THR field.
	UART1_THR_THR_Msk      = 0xff       // Bit mask of THR field.
	UART1_THR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_THR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DLL: DLAB =1. Divisor Latch LSB. Least significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.
	UART1_DLL_DLLSB_Pos    = 0x0        // Position of DLLSB field.
	UART1_DLL_DLLSB_Msk    = 0xff       // Bit mask of DLLSB field.
	UART1_DLL_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_DLL_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DLM: DLAB =1. Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.
	UART1_DLM_DLMSB_Pos    = 0x0        // Position of DLMSB field.
	UART1_DLM_DLMSB_Msk    = 0xff       // Bit mask of DLMSB field.
	UART1_DLM_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_DLM_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// IER: DLAB =0. Interrupt Enable Register. Contains individual interrupt enable bits for the 7 potential UART1 interrupts.
	UART1_IER_RBRIE_Pos                   = 0x0        // Position of RBRIE field.
	UART1_IER_RBRIE_Msk                   = 0x1        // Bit mask of RBRIE field.
	UART1_IER_RBRIE                       = 0x1        // Bit RBRIE.
	UART1_IER_RBRIE_DISABLE_THE_RDA_INTE  = 0x0        // Disable the RDA interrupts.
	UART1_IER_RBRIE_ENABLE_THE_RDA_INTER  = 0x1        // Enable the RDA interrupts.
	UART1_IER_THREIE_Pos                  = 0x1        // Position of THREIE field.
	UART1_IER_THREIE_Msk                  = 0x2        // Bit mask of THREIE field.
	UART1_IER_THREIE                      = 0x2        // Bit THREIE.
	UART1_IER_THREIE_DISABLE_THE_THRE_INT = 0x0        // Disable the THRE interrupts.
	UART1_IER_THREIE_ENABLE_THE_THRE_INTE = 0x1        // Enable the THRE interrupts.
	UART1_IER_RXIE_Pos                    = 0x2        // Position of RXIE field.
	UART1_IER_RXIE_Msk                    = 0x4        // Bit mask of RXIE field.
	UART1_IER_RXIE                        = 0x4        // Bit RXIE.
	UART1_IER_RXIE_DISABLE_THE_RX_LINE_   = 0x0        // Disable the RX line status interrupts.
	UART1_IER_RXIE_ENABLE_THE_RX_LINE_S   = 0x1        // Enable the RX line status interrupts.
	UART1_IER_MSIE_Pos                    = 0x3        // Position of MSIE field.
	UART1_IER_MSIE_Msk                    = 0x8        // Bit mask of MSIE field.
	UART1_IER_MSIE                        = 0x8        // Bit MSIE.
	UART1_IER_MSIE_DISABLE_THE_MODEM_IN   = 0x0        // Disable the modem interrupt.
	UART1_IER_MSIE_ENABLE_THE_MODEM_INT   = 0x1        // Enable the modem interrupt.
	UART1_IER_RESERVED_Pos                = 0x4        // Position of RESERVED field.
	UART1_IER_RESERVED_Msk                = 0x70       // Bit mask of RESERVED field.
	UART1_IER_CTSIE_Pos                   = 0x7        // Position of CTSIE field.
	UART1_IER_CTSIE_Msk                   = 0x80       // Bit mask of CTSIE field.
	UART1_IER_CTSIE                       = 0x80       // Bit CTSIE.
	UART1_IER_CTSIE_DISABLE_THE_CTS_INTE  = 0x0        // Disable the CTS interrupt.
	UART1_IER_CTSIE_ENABLE_THE_CTS_INTER  = 0x1        // Enable the CTS interrupt.
	UART1_IER_ABEOIE_Pos                  = 0x8        // Position of ABEOIE field.
	UART1_IER_ABEOIE_Msk                  = 0x100      // Bit mask of ABEOIE field.
	UART1_IER_ABEOIE                      = 0x100      // Bit ABEOIE.
	UART1_IER_ABEOIE_DISABLE_END_OF_AUTO_ = 0x0        // Disable end of auto-baud Interrupt.
	UART1_IER_ABEOIE_ENABLE_END_OF_AUTO_B = 0x1        // Enable end of auto-baud Interrupt.
	UART1_IER_ABTOIE_Pos                  = 0x9        // Position of ABTOIE field.
	UART1_IER_ABTOIE_Msk                  = 0x200      // Bit mask of ABTOIE field.
	UART1_IER_ABTOIE                      = 0x200      // Bit ABTOIE.
	UART1_IER_ABTOIE_DISABLE_AUTO_BAUD_TI = 0x0        // Disable auto-baud time-out Interrupt.
	UART1_IER_ABTOIE_ENABLE_AUTO_BAUD_TIM = 0x1        // Enable auto-baud time-out Interrupt.
	UART1_IER_RESERVED_Pos                = 0xa        // Position of RESERVED field.
	UART1_IER_RESERVED_Msk                = 0xfffffc00 // Bit mask of RESERVED field.

	// IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
	UART1_IIR_INTSTATUS_Pos                  = 0x0        // Position of INTSTATUS field.
	UART1_IIR_INTSTATUS_Msk                  = 0x1        // Bit mask of INTSTATUS field.
	UART1_IIR_INTSTATUS                      = 0x1        // Bit INTSTATUS.
	UART1_IIR_INTSTATUS_AT_LEAST_ONE_INTERRU = 0x0        // At least one interrupt is pending.
	UART1_IIR_INTSTATUS_NO_INTERRUPT_IS_PEND = 0x1        // No interrupt is pending.
	UART1_IIR_INTID_Pos                      = 0x1        // Position of INTID field.
	UART1_IIR_INTID_Msk                      = 0xe        // Bit mask of INTID field.
	UART1_IIR_INTID_RLS                      = 0x3        // 1   - Receive Line Status (RLS).
	UART1_IIR_INTID_RDA                      = 0x2        // 2a - Receive Data Available (RDA).
	UART1_IIR_INTID_CTI                      = 0x6        // 2b - Character Time-out Indicator (CTI).
	UART1_IIR_INTID_THRE                     = 0x1        // 3   - THRE Interrupt.
	UART1_IIR_INTID_MODEM                    = 0x0        // 4   - Modem Interrupt.
	UART1_IIR_RESERVED_Pos                   = 0x4        // Position of RESERVED field.
	UART1_IIR_RESERVED_Msk                   = 0x30       // Bit mask of RESERVED field.
	UART1_IIR_FIFOENABLE_Pos                 = 0x6        // Position of FIFOENABLE field.
	UART1_IIR_FIFOENABLE_Msk                 = 0xc0       // Bit mask of FIFOENABLE field.
	UART1_IIR_ABEOINT_Pos                    = 0x8        // Position of ABEOINT field.
	UART1_IIR_ABEOINT_Msk                    = 0x100      // Bit mask of ABEOINT field.
	UART1_IIR_ABEOINT                        = 0x100      // Bit ABEOINT.
	UART1_IIR_ABTOINT_Pos                    = 0x9        // Position of ABTOINT field.
	UART1_IIR_ABTOINT_Msk                    = 0x200      // Bit mask of ABTOINT field.
	UART1_IIR_ABTOINT                        = 0x200      // Bit ABTOINT.
	UART1_IIR_RESERVED_Pos                   = 0xa        // Position of RESERVED field.
	UART1_IIR_RESERVED_Msk                   = 0xfffffc00 // Bit mask of RESERVED field.

	// FCR: FIFO Control Register. Controls UART1 FIFO usage and modes.
	UART1_FCR_FIFOEN_Pos                     = 0x0        // Position of FIFOEN field.
	UART1_FCR_FIFOEN_Msk                     = 0x1        // Bit mask of FIFOEN field.
	UART1_FCR_FIFOEN                         = 0x1        // Bit FIFOEN.
	UART1_FCR_FIFOEN_MUST_NOT_BE_USED_IN_    = 0x0        // Must not be used in the application.
	UART1_FCR_FIFOEN_ACTIVE_HIGH_ENABLE_F    = 0x1        // Active high enable for both UART1 Rx and TX FIFOs and FCR[7:1] access. This bit must be set for proper UART1 operation. Any transition on this bit will automatically clear the UART1 FIFOs.
	UART1_FCR_RXFIFORES_Pos                  = 0x1        // Position of RXFIFORES field.
	UART1_FCR_RXFIFORES_Msk                  = 0x2        // Bit mask of RXFIFORES field.
	UART1_FCR_RXFIFORES                      = 0x2        // Bit RXFIFORES.
	UART1_FCR_RXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0        // No impact on either of UART1 FIFOs.
	UART1_FCR_RXFIFORES_WRITING_A_LOGIC_1_TO = 0x1        // Writing a logic 1 to FCR[1] will clear all bytes in UART1 Rx FIFO, reset the pointer logic. This bit is self-clearing.
	UART1_FCR_TXFIFORES_Pos                  = 0x2        // Position of TXFIFORES field.
	UART1_FCR_TXFIFORES_Msk                  = 0x4        // Bit mask of TXFIFORES field.
	UART1_FCR_TXFIFORES                      = 0x4        // Bit TXFIFORES.
	UART1_FCR_TXFIFORES_NO_IMPACT_ON_EITHER_ = 0x0        // No impact on either of UART1 FIFOs.
	UART1_FCR_TXFIFORES_WRITING_A_LOGIC_1_TO = 0x1        // Writing a logic 1 to FCR[2] will clear all bytes in UART1 TX FIFO, reset the pointer logic. This bit is self-clearing.
	UART1_FCR_DMAMODE_Pos                    = 0x3        // Position of DMAMODE field.
	UART1_FCR_DMAMODE_Msk                    = 0x8        // Bit mask of DMAMODE field.
	UART1_FCR_DMAMODE                        = 0x8        // Bit DMAMODE.
	UART1_FCR_RESERVED_Pos                   = 0x4        // Position of RESERVED field.
	UART1_FCR_RESERVED_Msk                   = 0x30       // Bit mask of RESERVED field.
	UART1_FCR_RXTRIGLVL_Pos                  = 0x6        // Position of RXTRIGLVL field.
	UART1_FCR_RXTRIGLVL_Msk                  = 0xc0       // Bit mask of RXTRIGLVL field.
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_0_1_C  = 0x0        // Trigger level 0 (1 character or 0x01).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_1_4_C  = 0x1        // Trigger level 1 (4 characters or 0x04).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_2_8_C  = 0x2        // Trigger level 2 (8 characters or 0x08).
	UART1_FCR_RXTRIGLVL_TRIGGER_LEVEL_3_14_  = 0x3        // Trigger level 3 (14 characters or 0x0E).
	UART1_FCR_RESERVED_Pos                   = 0x8        // Position of RESERVED field.
	UART1_FCR_RESERVED_Msk                   = 0xffffff00 // Bit mask of RESERVED field.

	// LCR: Line Control Register. Contains controls for frame formatting and break generation.
	UART1_LCR_WLS_Pos                   = 0x0        // Position of WLS field.
	UART1_LCR_WLS_Msk                   = 0x3        // Bit mask of WLS field.
	UART1_LCR_WLS_5_BIT_CHARACTER_LENG  = 0x0        // 5-bit character length.
	UART1_LCR_WLS_6_BIT_CHARACTER_LENG  = 0x1        // 6-bit character length.
	UART1_LCR_WLS_7_BIT_CHARACTER_LENG  = 0x2        // 7-bit character length.
	UART1_LCR_WLS_8_BIT_CHARACTER_LENG  = 0x3        // 8-bit character length.
	UART1_LCR_SBS_Pos                   = 0x2        // Position of SBS field.
	UART1_LCR_SBS_Msk                   = 0x4        // Bit mask of SBS field.
	UART1_LCR_SBS                       = 0x4        // Bit SBS.
	UART1_LCR_SBS_1_STOP_BIT_           = 0x0        // 1 stop bit.
	UART1_LCR_SBS_2_STOP_BITS_1_5_IF_   = 0x1        // 2 stop bits (1.5 if LCR[1:0]=00).
	UART1_LCR_PE_Pos                    = 0x3        // Position of PE field.
	UART1_LCR_PE_Msk                    = 0x8        // Bit mask of PE field.
	UART1_LCR_PE                        = 0x8        // Bit PE.
	UART1_LCR_PE_DISABLE_PARITY_GENER   = 0x0        // Disable parity generation and checking.
	UART1_LCR_PE_ENABLE_PARITY_GENERA   = 0x1        // Enable parity generation and checking.
	UART1_LCR_PS_Pos                    = 0x4        // Position of PS field.
	UART1_LCR_PS_Msk                    = 0x30       // Bit mask of PS field.
	UART1_LCR_PS_ODD_PARITY_NUMBER_O    = 0x0        // Odd parity. Number of 1s in the transmitted character and the attached parity bit will be odd.
	UART1_LCR_PS_EVEN_PARITY_NUMBER_    = 0x1        // Even Parity. Number of 1s in the transmitted character and the attached parity bit will be even.
	UART1_LCR_PS_FORCED1STICK_PAR       = 0x2        // Forced 1 stick parity.
	UART1_LCR_PS_FORCED0STICK_PAR       = 0x3        // Forced 0 stick parity.
	UART1_LCR_BC_Pos                    = 0x6        // Position of BC field.
	UART1_LCR_BC_Msk                    = 0x40       // Bit mask of BC field.
	UART1_LCR_BC                        = 0x40       // Bit BC.
	UART1_LCR_BC_DISABLE_BREAK_TRANSM   = 0x0        // Disable break transmission.
	UART1_LCR_BC_ENABLE_BREAK_TRANSMI   = 0x1        // Enable break transmission. Output pin UART1 TXD is forced to logic 0 when LCR[6] is active high.
	UART1_LCR_DLAB_Pos                  = 0x7        // Position of DLAB field.
	UART1_LCR_DLAB_Msk                  = 0x80       // Bit mask of DLAB field.
	UART1_LCR_DLAB                      = 0x80       // Bit DLAB.
	UART1_LCR_DLAB_DISABLE_ACCESS_TO_DI = 0x0        // Disable access to Divisor Latches.
	UART1_LCR_DLAB_ENABLE_ACCESS_TO_DIV = 0x1        // Enable access to Divisor Latches.
	UART1_LCR_RESERVED_Pos              = 0x8        // Position of RESERVED field.
	UART1_LCR_RESERVED_Msk              = 0xffffff00 // Bit mask of RESERVED field.

	// MCR: Modem Control Register. Contains controls for flow control handshaking and loopback mode.
	UART1_MCR_DTRCTRL_Pos                = 0x0        // Position of DTRCTRL field.
	UART1_MCR_DTRCTRL_Msk                = 0x1        // Bit mask of DTRCTRL field.
	UART1_MCR_DTRCTRL                    = 0x1        // Bit DTRCTRL.
	UART1_MCR_RTSCTRL_Pos                = 0x1        // Position of RTSCTRL field.
	UART1_MCR_RTSCTRL_Msk                = 0x2        // Bit mask of RTSCTRL field.
	UART1_MCR_RTSCTRL                    = 0x2        // Bit RTSCTRL.
	UART1_MCR_RESERVED_Pos               = 0x2        // Position of RESERVED field.
	UART1_MCR_RESERVED_Msk               = 0xc        // Bit mask of RESERVED field.
	UART1_MCR_LMS_Pos                    = 0x4        // Position of LMS field.
	UART1_MCR_LMS_Msk                    = 0x10       // Bit mask of LMS field.
	UART1_MCR_LMS                        = 0x10       // Bit LMS.
	UART1_MCR_LMS_DISABLE_MODEM_LOOPBA   = 0x0        // Disable modem loopback mode.
	UART1_MCR_LMS_ENABLE_MODEM_LOOPBAC   = 0x1        // Enable modem loopback mode.
	UART1_MCR_RESERVED_Pos               = 0x5        // Position of RESERVED field.
	UART1_MCR_RESERVED_Msk               = 0x20       // Bit mask of RESERVED field.
	UART1_MCR_RESERVED                   = 0x20       // Bit RESERVED.
	UART1_MCR_RTSEN_Pos                  = 0x6        // Position of RTSEN field.
	UART1_MCR_RTSEN_Msk                  = 0x40       // Bit mask of RTSEN field.
	UART1_MCR_RTSEN                      = 0x40       // Bit RTSEN.
	UART1_MCR_RTSEN_DISABLE_AUTO_RTS_FLO = 0x0        // Disable auto-rts flow control.
	UART1_MCR_RTSEN_ENABLE_AUTO_RTS_FLOW = 0x1        // Enable auto-rts flow control.
	UART1_MCR_CTSEN_Pos                  = 0x7        // Position of CTSEN field.
	UART1_MCR_CTSEN_Msk                  = 0x80       // Bit mask of CTSEN field.
	UART1_MCR_CTSEN                      = 0x80       // Bit CTSEN.
	UART1_MCR_CTSEN_DISABLE_AUTO_CTS_FLO = 0x0        // Disable auto-cts flow control.
	UART1_MCR_CTSEN_ENABLE_AUTO_CTS_FLOW = 0x1        // Enable auto-cts flow control.
	UART1_MCR_RESERVED_Pos               = 0x8        // Position of RESERVED field.
	UART1_MCR_RESERVED_Msk               = 0xffffff00 // Bit mask of RESERVED field.

	// LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
	UART1_LSR_RDR_Pos            = 0x0        // Position of RDR field.
	UART1_LSR_RDR_Msk            = 0x1        // Bit mask of RDR field.
	UART1_LSR_RDR                = 0x1        // Bit RDR.
	UART1_LSR_RDR_EMPTY          = 0x0        // The UART1 receiver FIFO is empty.
	UART1_LSR_RDR_NOTEMPTY       = 0x1        // The UART1 receiver FIFO is not empty.
	UART1_LSR_OE_Pos             = 0x1        // Position of OE field.
	UART1_LSR_OE_Msk             = 0x2        // Bit mask of OE field.
	UART1_LSR_OE                 = 0x2        // Bit OE.
	UART1_LSR_OE_INACTIVE        = 0x0        // Overrun error status is inactive.
	UART1_LSR_OE_ACTIVE          = 0x1        // Overrun error status is active.
	UART1_LSR_PE_Pos             = 0x2        // Position of PE field.
	UART1_LSR_PE_Msk             = 0x4        // Bit mask of PE field.
	UART1_LSR_PE                 = 0x4        // Bit PE.
	UART1_LSR_PE_INACTIVE        = 0x0        // Parity error status is inactive.
	UART1_LSR_PE_ACTIVE          = 0x1        // Parity error status is active.
	UART1_LSR_FE_Pos             = 0x3        // Position of FE field.
	UART1_LSR_FE_Msk             = 0x8        // Bit mask of FE field.
	UART1_LSR_FE                 = 0x8        // Bit FE.
	UART1_LSR_FE_INACTIVE        = 0x0        // Framing error status is inactive.
	UART1_LSR_FE_ACTIVE          = 0x1        // Framing error status is active.
	UART1_LSR_BI_Pos             = 0x4        // Position of BI field.
	UART1_LSR_BI_Msk             = 0x10       // Bit mask of BI field.
	UART1_LSR_BI                 = 0x10       // Bit BI.
	UART1_LSR_BI_INACTIVE        = 0x0        // Break interrupt status is inactive.
	UART1_LSR_BI_ACTIVE          = 0x1        // Break interrupt status is active.
	UART1_LSR_THRE_Pos           = 0x5        // Position of THRE field.
	UART1_LSR_THRE_Msk           = 0x20       // Bit mask of THRE field.
	UART1_LSR_THRE               = 0x20       // Bit THRE.
	UART1_LSR_THRE_VALID         = 0x0        // THR contains valid data.
	UART1_LSR_THRE_THR_IS_EMPTY_ = 0x1        // THR is empty.
	UART1_LSR_TEMT_Pos           = 0x6        // Position of TEMT field.
	UART1_LSR_TEMT_Msk           = 0x40       // Bit mask of TEMT field.
	UART1_LSR_TEMT               = 0x40       // Bit TEMT.
	UART1_LSR_TEMT_VALID         = 0x0        // THR and/or the TSR contains valid data.
	UART1_LSR_TEMT_EMPTY         = 0x1        // THR and the TSR are empty.
	UART1_LSR_RXFE_Pos           = 0x7        // Position of RXFE field.
	UART1_LSR_RXFE_Msk           = 0x80       // Bit mask of RXFE field.
	UART1_LSR_RXFE               = 0x80       // Bit RXFE.
	UART1_LSR_RXFE_NOERROR       = 0x0        // RBR contains no UART1 RX errors or FCR[0]=0.
	UART1_LSR_RXFE_ERRORS        = 0x1        // UART1 RBR contains at least one UART1 RX error.
	UART1_LSR_RESERVED_Pos       = 0x8        // Position of RESERVED field.
	UART1_LSR_RESERVED_Msk       = 0xffffff00 // Bit mask of RESERVED field.

	// MSR: Modem Status Register. Contains handshake signal status flags.
	UART1_MSR_DCTS_Pos                  = 0x0        // Position of DCTS field.
	UART1_MSR_DCTS_Msk                  = 0x1        // Bit mask of DCTS field.
	UART1_MSR_DCTS                      = 0x1        // Bit DCTS.
	UART1_MSR_DCTS_NO_CHANGE_DETECTED_O = 0x0        // No change detected on modem input, CTS.
	UART1_MSR_DCTS_STATE_CHANGE_DETECTE = 0x1        // State change detected on modem input, CTS.
	UART1_MSR_DDSR_Pos                  = 0x1        // Position of DDSR field.
	UART1_MSR_DDSR_Msk                  = 0x2        // Bit mask of DDSR field.
	UART1_MSR_DDSR                      = 0x2        // Bit DDSR.
	UART1_MSR_DDSR_NO_CHANGE_DETECTED_O = 0x0        // No change detected on modem input, DSR.
	UART1_MSR_DDSR_STATE_CHANGE_DETECTE = 0x1        // State change detected on modem input, DSR.
	UART1_MSR_TERI_Pos                  = 0x2        // Position of TERI field.
	UART1_MSR_TERI_Msk                  = 0x4        // Bit mask of TERI field.
	UART1_MSR_TERI                      = 0x4        // Bit TERI.
	UART1_MSR_TERI_NO_CHANGE_DETECTED_O = 0x0        // No change detected on modem input, RI.
	UART1_MSR_TERI_LOW_TO_HIGH_TRANSITI = 0x1        // Low-to-high transition detected on RI.
	UART1_MSR_DDCD_Pos                  = 0x3        // Position of DDCD field.
	UART1_MSR_DDCD_Msk                  = 0x8        // Bit mask of DDCD field.
	UART1_MSR_DDCD                      = 0x8        // Bit DDCD.
	UART1_MSR_DDCD_NO_CHANGE_DETECTED_O = 0x0        // No change detected on modem input, DCD.
	UART1_MSR_DDCD_STATE_CHANGE_DETECTE = 0x1        // State change detected on modem input, DCD.
	UART1_MSR_CTS_Pos                   = 0x4        // Position of CTS field.
	UART1_MSR_CTS_Msk                   = 0x10       // Bit mask of CTS field.
	UART1_MSR_CTS                       = 0x10       // Bit CTS.
	UART1_MSR_DSR_Pos                   = 0x5        // Position of DSR field.
	UART1_MSR_DSR_Msk                   = 0x20       // Bit mask of DSR field.
	UART1_MSR_DSR                       = 0x20       // Bit DSR.
	UART1_MSR_RI_Pos                    = 0x6        // Position of RI field.
	UART1_MSR_RI_Msk                    = 0x40       // Bit mask of RI field.
	UART1_MSR_RI                        = 0x40       // Bit RI.
	UART1_MSR_DCD_Pos                   = 0x7        // Position of DCD field.
	UART1_MSR_DCD_Msk                   = 0x80       // Bit mask of DCD field.
	UART1_MSR_DCD                       = 0x80       // Bit DCD.
	UART1_MSR_RESERVED_Pos              = 0x8        // Position of RESERVED field.
	UART1_MSR_RESERVED_Msk              = 0xffffff00 // Bit mask of RESERVED field.

	// SCR: Scratch Pad Register. 8-bit temporary storage for software.
	UART1_SCR_Pad_Pos      = 0x0        // Position of Pad field.
	UART1_SCR_Pad_Msk      = 0xff       // Bit mask of Pad field.
	UART1_SCR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_SCR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
	UART1_ACR_START_Pos                        = 0x0        // Position of START field.
	UART1_ACR_START_Msk                        = 0x1        // Bit mask of START field.
	UART1_ACR_START                            = 0x1        // Bit START.
	UART1_ACR_START_STOP                       = 0x0        // Auto-baud stop (auto-baud is not running).
	UART1_ACR_START_START                      = 0x1        // Auto-baud start (auto-baud is running). Auto-baud run bit. This bit is automatically cleared after auto-baud completion.
	UART1_ACR_MODE_Pos                         = 0x1        // Position of MODE field.
	UART1_ACR_MODE_Msk                         = 0x2        // Bit mask of MODE field.
	UART1_ACR_MODE                             = 0x2        // Bit MODE.
	UART1_ACR_MODE_MODE_0_                     = 0x0        // Mode 0.
	UART1_ACR_MODE_MODE_1_                     = 0x1        // Mode 1.
	UART1_ACR_AUTORESTART_Pos                  = 0x2        // Position of AUTORESTART field.
	UART1_ACR_AUTORESTART_Msk                  = 0x4        // Bit mask of AUTORESTART field.
	UART1_ACR_AUTORESTART                      = 0x4        // Bit AUTORESTART.
	UART1_ACR_AUTORESTART_NO_RESTART           = 0x0        // No restart
	UART1_ACR_AUTORESTART_RESTART_IN_CASE_OF_T = 0x1        // Restart in case of time-out (counter restarts at next UART1 Rx falling edge)
	UART1_ACR_RESERVED_Pos                     = 0x3        // Position of RESERVED field.
	UART1_ACR_RESERVED_Msk                     = 0xf8       // Bit mask of RESERVED field.
	UART1_ACR_ABEOINTCLR_Pos                   = 0x8        // Position of ABEOINTCLR field.
	UART1_ACR_ABEOINTCLR_Msk                   = 0x100      // Bit mask of ABEOINTCLR field.
	UART1_ACR_ABEOINTCLR                       = 0x100      // Bit ABEOINTCLR.
	UART1_ACR_ABEOINTCLR_WRITING_A_0_HAS_NO_I  = 0x0        // Writing a 0 has no impact.
	UART1_ACR_ABEOINTCLR_WRITING_A_1_WILL_CLE  = 0x1        // Writing a 1 will clear the corresponding interrupt in the IIR.
	UART1_ACR_ABTOINTCLR_Pos                   = 0x9        // Position of ABTOINTCLR field.
	UART1_ACR_ABTOINTCLR_Msk                   = 0x200      // Bit mask of ABTOINTCLR field.
	UART1_ACR_ABTOINTCLR                       = 0x200      // Bit ABTOINTCLR.
	UART1_ACR_ABTOINTCLR_WRITING_A_0_HAS_NO_I  = 0x0        // Writing a 0 has no impact.
	UART1_ACR_ABTOINTCLR_WRITING_A_1_WILL_CLE  = 0x1        // Writing a 1 will clear the corresponding interrupt in the IIR.
	UART1_ACR_RESERVED_Pos                     = 0xa        // Position of RESERVED field.
	UART1_ACR_RESERVED_Msk                     = 0xfffffc00 // Bit mask of RESERVED field.

	// FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
	UART1_FDR_DIVADDVAL_Pos = 0x0        // Position of DIVADDVAL field.
	UART1_FDR_DIVADDVAL_Msk = 0xf        // Bit mask of DIVADDVAL field.
	UART1_FDR_MULVAL_Pos    = 0x4        // Position of MULVAL field.
	UART1_FDR_MULVAL_Msk    = 0xf0       // Bit mask of MULVAL field.
	UART1_FDR_RESERVED_Pos  = 0x8        // Position of RESERVED field.
	UART1_FDR_RESERVED_Msk  = 0xffffff00 // Bit mask of RESERVED field.

	// TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
	UART1_TER_RESERVED_Pos = 0x0        // Position of RESERVED field.
	UART1_TER_RESERVED_Msk = 0x7f       // Bit mask of RESERVED field.
	UART1_TER_TXEN_Pos     = 0x7        // Position of TXEN field.
	UART1_TER_TXEN_Msk     = 0x80       // Bit mask of TXEN field.
	UART1_TER_TXEN         = 0x80       // Bit TXEN.
	UART1_TER_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_TER_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
	UART1_RS485CTRL_NMMEN_Pos                  = 0x0        // Position of NMMEN field.
	UART1_RS485CTRL_NMMEN_Msk                  = 0x1        // Bit mask of NMMEN field.
	UART1_RS485CTRL_NMMEN                      = 0x1        // Bit NMMEN.
	UART1_RS485CTRL_NMMEN_DISABLED_            = 0x0        // Disabled.
	UART1_RS485CTRL_NMMEN_ENABLED_IN_THIS_MOD  = 0x1        // Enabled. In this mode, an address is detected when a received byte causes the UART to set the parity error and generate an interrupt.
	UART1_RS485CTRL_RXDIS_Pos                  = 0x1        // Position of RXDIS field.
	UART1_RS485CTRL_RXDIS_Msk                  = 0x2        // Bit mask of RXDIS field.
	UART1_RS485CTRL_RXDIS                      = 0x2        // Bit RXDIS.
	UART1_RS485CTRL_RXDIS_ENABLED_             = 0x0        // Enabled.
	UART1_RS485CTRL_RXDIS_DISABLED_            = 0x1        // Disabled.
	UART1_RS485CTRL_AADEN_Pos                  = 0x2        // Position of AADEN field.
	UART1_RS485CTRL_AADEN_Msk                  = 0x4        // Bit mask of AADEN field.
	UART1_RS485CTRL_AADEN                      = 0x4        // Bit AADEN.
	UART1_RS485CTRL_AADEN_DISABLED_            = 0x0        // Disabled.
	UART1_RS485CTRL_AADEN_ENABLED_             = 0x1        // Enabled.
	UART1_RS485CTRL_SEL_Pos                    = 0x3        // Position of SEL field.
	UART1_RS485CTRL_SEL_Msk                    = 0x8        // Bit mask of SEL field.
	UART1_RS485CTRL_SEL                        = 0x8        // Bit SEL.
	UART1_RS485CTRL_SEL_RTS_IF_DIRECTION_CO    = 0x0        // RTS. If direction control is enabled (bit DCTRL = 1), pin RTS is used for direction control.
	UART1_RS485CTRL_SEL_DTR_IF_DIRECTION_CO    = 0x1        // DTR. If direction control is enabled (bit DCTRL = 1), pin DTR is used for direction control.
	UART1_RS485CTRL_DCTRL_Pos                  = 0x4        // Position of DCTRL field.
	UART1_RS485CTRL_DCTRL_Msk                  = 0x10       // Bit mask of DCTRL field.
	UART1_RS485CTRL_DCTRL                      = 0x10       // Bit DCTRL.
	UART1_RS485CTRL_DCTRL_DISABLE_AUTO_DIRECTI = 0x0        // Disable Auto Direction Control.
	UART1_RS485CTRL_DCTRL_ENABLE_AUTO_DIRECTIO = 0x1        // Enable Auto Direction Control.
	UART1_RS485CTRL_OINV_Pos                   = 0x5        // Position of OINV field.
	UART1_RS485CTRL_OINV_Msk                   = 0x20       // Bit mask of OINV field.
	UART1_RS485CTRL_OINV                       = 0x20       // Bit OINV.
	UART1_RS485CTRL_OINV_LOW_THE_DIRECTION_C   = 0x0        // LOW. The direction control pin will be driven to logic 0 when the transmitter has data to be sent. It will be driven to logic 1 after the last bit of data has been transmitted.
	UART1_RS485CTRL_OINV_HIGH_THE_DIRECTION_   = 0x1        // HIGH. The direction control pin will be driven to logic 1 when the transmitter has data to be sent. It will be driven to logic 0 after the last bit of data has been transmitted.
	UART1_RS485CTRL_RESERVED_Pos               = 0x6        // Position of RESERVED field.
	UART1_RS485CTRL_RESERVED_Msk               = 0xffffffc0 // Bit mask of RESERVED field.

	// RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
	UART1_RS485ADRMATCH_ADRMATCH_Pos = 0x0        // Position of ADRMATCH field.
	UART1_RS485ADRMATCH_ADRMATCH_Msk = 0xff       // Bit mask of ADRMATCH field.
	UART1_RS485ADRMATCH_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_RS485ADRMATCH_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// RS485DLY: RS-485/EIA-485 direction control delay.
	UART1_RS485DLY_DLY_Pos      = 0x0        // Position of DLY field.
	UART1_RS485DLY_DLY_Msk      = 0xff       // Bit mask of DLY field.
	UART1_RS485DLY_RESERVED_Pos = 0x8        // Position of RESERVED field.
	UART1_RS485DLY_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.
)

// Bitfields for PWM1: Pulse Width Modulators (PWM1)
const (
	// IR: Interrupt Register. The IR can be written to clear interrupts, or read to identify which PWM interrupt sources are pending.
	PWM_IR_PWMMR0INT_Pos  = 0x0        // Position of PWMMR0INT field.
	PWM_IR_PWMMR0INT_Msk  = 0x1        // Bit mask of PWMMR0INT field.
	PWM_IR_PWMMR0INT      = 0x1        // Bit PWMMR0INT.
	PWM_IR_PWMMR1INT_Pos  = 0x1        // Position of PWMMR1INT field.
	PWM_IR_PWMMR1INT_Msk  = 0x2        // Bit mask of PWMMR1INT field.
	PWM_IR_PWMMR1INT      = 0x2        // Bit PWMMR1INT.
	PWM_IR_PWMMR2INT_Pos  = 0x2        // Position of PWMMR2INT field.
	PWM_IR_PWMMR2INT_Msk  = 0x4        // Bit mask of PWMMR2INT field.
	PWM_IR_PWMMR2INT      = 0x4        // Bit PWMMR2INT.
	PWM_IR_PWMMR3INT_Pos  = 0x3        // Position of PWMMR3INT field.
	PWM_IR_PWMMR3INT_Msk  = 0x8        // Bit mask of PWMMR3INT field.
	PWM_IR_PWMMR3INT      = 0x8        // Bit PWMMR3INT.
	PWM_IR_PWMCAP0INT_Pos = 0x4        // Position of PWMCAP0INT field.
	PWM_IR_PWMCAP0INT_Msk = 0x10       // Bit mask of PWMCAP0INT field.
	PWM_IR_PWMCAP0INT     = 0x10       // Bit PWMCAP0INT.
	PWM_IR_PWMCAP1INT_Pos = 0x5        // Position of PWMCAP1INT field.
	PWM_IR_PWMCAP1INT_Msk = 0x20       // Bit mask of PWMCAP1INT field.
	PWM_IR_PWMCAP1INT     = 0x20       // Bit PWMCAP1INT.
	PWM_IR_RESERVED_Pos   = 0x6        // Position of RESERVED field.
	PWM_IR_RESERVED_Msk   = 0xc0       // Bit mask of RESERVED field.
	PWM_IR_PWMMR4INT_Pos  = 0x8        // Position of PWMMR4INT field.
	PWM_IR_PWMMR4INT_Msk  = 0x100      // Bit mask of PWMMR4INT field.
	PWM_IR_PWMMR4INT      = 0x100      // Bit PWMMR4INT.
	PWM_IR_PWMMR5INT_Pos  = 0x9        // Position of PWMMR5INT field.
	PWM_IR_PWMMR5INT_Msk  = 0x200      // Bit mask of PWMMR5INT field.
	PWM_IR_PWMMR5INT      = 0x200      // Bit PWMMR5INT.
	PWM_IR_PWMMR6INT_Pos  = 0xa        // Position of PWMMR6INT field.
	PWM_IR_PWMMR6INT_Msk  = 0x400      // Bit mask of PWMMR6INT field.
	PWM_IR_PWMMR6INT      = 0x400      // Bit PWMMR6INT.
	PWM_IR_RESERVED_Pos   = 0xb        // Position of RESERVED field.
	PWM_IR_RESERVED_Msk   = 0xfffff800 // Bit mask of RESERVED field.

	// TCR: Timer Control Register. The TCR is used to control the Timer Counter functions.
	PWM_TCR_CE_Pos                     = 0x0        // Position of CE field.
	PWM_TCR_CE_Msk                     = 0x1        // Bit mask of CE field.
	PWM_TCR_CE                         = 0x1        // Bit CE.
	PWM_TCR_CE_THE_PWM_TIMER_COUNTE    = 0x1        // The PWM Timer Counter and PWM Prescale Counter are enabled for counting.
	PWM_TCR_CE_THE_COUNTERS_ARE_DIS    = 0x0        // The counters are disabled.
	PWM_TCR_CR_Pos                     = 0x1        // Position of CR field.
	PWM_TCR_CR_Msk                     = 0x2        // Bit mask of CR field.
	PWM_TCR_CR                         = 0x2        // Bit CR.
	PWM_TCR_CR_THE_PWM_TIMER_COUNTE    = 0x1        // The PWM Timer Counter and the PWM Prescale Counter are synchronously reset on the next positive edge of PCLK. The counters remain reset until this bit is returned to zero.
	PWM_TCR_CR_CLEAR_RESET_            = 0x0        // Clear reset.
	PWM_TCR_RESERVED_Pos               = 0x2        // Position of RESERVED field.
	PWM_TCR_RESERVED_Msk               = 0x4        // Bit mask of RESERVED field.
	PWM_TCR_RESERVED                   = 0x4        // Bit RESERVED.
	PWM_TCR_PWMEN_Pos                  = 0x3        // Position of PWMEN field.
	PWM_TCR_PWMEN_Msk                  = 0x8        // Bit mask of PWMEN field.
	PWM_TCR_PWMEN                      = 0x8        // Bit PWMEN.
	PWM_TCR_PWMEN_PWM_MODE_IS_ENABLED_ = 0x1        // PWM mode is enabled (counter resets to 1). PWM mode causes the shadow registers to operate in connection with the Match registers. A program write to a Match register will not have an effect on the Match result until the corresponding bit in PWMLER has been set, followed by the occurrence of a PWM Match 0 event. Note that the PWM Match register that determines the PWM rate (PWM Match Register 0 - MR0) must be set up prior to the PWM being enabled. Otherwise a Match event will not occur to cause shadow register contents to become effective.
	PWM_TCR_PWMEN_TIMER_MODE_IS_ENABLE = 0x0        // Timer mode is enabled (counter resets to 0).
	PWM_TCR_MDIS_Pos                   = 0x4        // Position of MDIS field.
	PWM_TCR_MDIS_Msk                   = 0x10       // Bit mask of MDIS field.
	PWM_TCR_MDIS                       = 0x10       // Bit MDIS.
	PWM_TCR_MDIS_MASTER_USE_PWM0_IS_   = 0x1        // Master use. PWM0 is the master, and both PWMs are enabled for counting.
	PWM_TCR_MDIS_INDIVIDUAL_USE_THE_   = 0x0        // Individual use. The PWMs are used independently, and the individual Counter Enable bits are used to control the PWMs.
	PWM_TCR_RESERVED_Pos               = 0x5        // Position of RESERVED field.
	PWM_TCR_RESERVED_Msk               = 0xffffffe0 // Bit mask of RESERVED field.

	// TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
	PWM_TC_TC_Pos = 0x0        // Position of TC field.
	PWM_TC_TC_Msk = 0xffffffff // Bit mask of TC field.

	// PR: Prescale Register. Determines how often the PWM counter is incremented.
	PWM_PR_PM_Pos = 0x0        // Position of PM field.
	PWM_PR_PM_Msk = 0xffffffff // Bit mask of PM field.

	// PC: Prescale Counter. Prescaler for the main PWM counter.
	PWM_PC_PC_Pos = 0x0        // Position of PC field.
	PWM_PC_PC_Msk = 0xffffffff // Bit mask of PC field.

	// MCR: Match Control Register. The MCR is used to control whether an interrupt is generated and if the PWM counter is reset when a Match occurs.
	PWM_MCR_PWMMR0I_Pos                 = 0x0        // Position of PWMMR0I field.
	PWM_MCR_PWMMR0I_Msk                 = 0x1        // Bit mask of PWMMR0I field.
	PWM_MCR_PWMMR0I                     = 0x1        // Bit PWMMR0I.
	PWM_MCR_PWMMR0I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR0I_INTERRUPT_ON_PWMMR0 = 0x1        // Interrupt on PWMMR0: an interrupt is generated when PWMMR0 matches the value in the PWMTC.
	PWM_MCR_PWMMR0R_Pos                 = 0x1        // Position of PWMMR0R field.
	PWM_MCR_PWMMR0R_Msk                 = 0x2        // Bit mask of PWMMR0R field.
	PWM_MCR_PWMMR0R                     = 0x2        // Bit PWMMR0R.
	PWM_MCR_PWMMR0R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR0R_RESET_ON_PWMMR0_THE = 0x1        // Reset on PWMMR0: the PWMTC will be reset if PWMMR0 matches it.
	PWM_MCR_PWMMR0S_Pos                 = 0x2        // Position of PWMMR0S field.
	PWM_MCR_PWMMR0S_Msk                 = 0x4        // Bit mask of PWMMR0S field.
	PWM_MCR_PWMMR0S                     = 0x4        // Bit PWMMR0S.
	PWM_MCR_PWMMR0S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR0S_STOP_ON_PWMMR0_THE_ = 0x1        // Stop on PWMMR0: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR0 matches the PWMTC.
	PWM_MCR_PWMMR1I_Pos                 = 0x3        // Position of PWMMR1I field.
	PWM_MCR_PWMMR1I_Msk                 = 0x8        // Bit mask of PWMMR1I field.
	PWM_MCR_PWMMR1I                     = 0x8        // Bit PWMMR1I.
	PWM_MCR_PWMMR1I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR1I_INTERRUPT_ON_PWMMR1 = 0x1        // Interrupt on PWMMR1: an interrupt is generated when PWMMR1 matches the value in the PWMTC.
	PWM_MCR_PWMMR1R_Pos                 = 0x4        // Position of PWMMR1R field.
	PWM_MCR_PWMMR1R_Msk                 = 0x10       // Bit mask of PWMMR1R field.
	PWM_MCR_PWMMR1R                     = 0x10       // Bit PWMMR1R.
	PWM_MCR_PWMMR1R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR1R_RESET_ON_PWMMR1_THE = 0x1        // Reset on PWMMR1: the PWMTC will be reset if PWMMR1 matches it.
	PWM_MCR_PWMMR1S_Pos                 = 0x5        // Position of PWMMR1S field.
	PWM_MCR_PWMMR1S_Msk                 = 0x20       // Bit mask of PWMMR1S field.
	PWM_MCR_PWMMR1S                     = 0x20       // Bit PWMMR1S.
	PWM_MCR_PWMMR1S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR1S_STOP_ON_PWMMR1_THE_ = 0x1        // Stop on PWMMR1: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR1 matches the PWMTC.
	PWM_MCR_PWMMR2I_Pos                 = 0x6        // Position of PWMMR2I field.
	PWM_MCR_PWMMR2I_Msk                 = 0x40       // Bit mask of PWMMR2I field.
	PWM_MCR_PWMMR2I                     = 0x40       // Bit PWMMR2I.
	PWM_MCR_PWMMR2I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR2I_INTERRUPT_ON_PWMMR2 = 0x1        // Interrupt on PWMMR2: an interrupt is generated when PWMMR2 matches the value in the PWMTC.
	PWM_MCR_PWMMR2R_Pos                 = 0x7        // Position of PWMMR2R field.
	PWM_MCR_PWMMR2R_Msk                 = 0x80       // Bit mask of PWMMR2R field.
	PWM_MCR_PWMMR2R                     = 0x80       // Bit PWMMR2R.
	PWM_MCR_PWMMR2R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR2R_RESET_ON_PWMMR2_THE = 0x1        // Reset on PWMMR2: the PWMTC will be reset if PWMMR2 matches it.
	PWM_MCR_PWMMR2S_Pos                 = 0x8        // Position of PWMMR2S field.
	PWM_MCR_PWMMR2S_Msk                 = 0x100      // Bit mask of PWMMR2S field.
	PWM_MCR_PWMMR2S                     = 0x100      // Bit PWMMR2S.
	PWM_MCR_PWMMR2S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR2S_STOP_ON_PWMMR2_THE_ = 0x1        // Stop on PWMMR2: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR0 matches the PWMTC.
	PWM_MCR_PWMMR3I_Pos                 = 0x9        // Position of PWMMR3I field.
	PWM_MCR_PWMMR3I_Msk                 = 0x200      // Bit mask of PWMMR3I field.
	PWM_MCR_PWMMR3I                     = 0x200      // Bit PWMMR3I.
	PWM_MCR_PWMMR3I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR3I_INTERRUPT_ON_PWMMR3 = 0x1        // Interrupt on PWMMR3: an interrupt is generated when PWMMR3 matches the value in the PWMTC.
	PWM_MCR_PWMMR3R_Pos                 = 0xa        // Position of PWMMR3R field.
	PWM_MCR_PWMMR3R_Msk                 = 0x400      // Bit mask of PWMMR3R field.
	PWM_MCR_PWMMR3R                     = 0x400      // Bit PWMMR3R.
	PWM_MCR_PWMMR3R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR3R_RESET_ON_PWMMR3_THE = 0x1        // Reset on PWMMR3: the PWMTC will be reset if PWMMR3 matches it.
	PWM_MCR_PWMMR3S_Pos                 = 0xb        // Position of PWMMR3S field.
	PWM_MCR_PWMMR3S_Msk                 = 0x800      // Bit mask of PWMMR3S field.
	PWM_MCR_PWMMR3S                     = 0x800      // Bit PWMMR3S.
	PWM_MCR_PWMMR3S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR3S_STOP_ON_PWMMR3_THE_ = 0x1        // Stop on PWMMR3: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR0 matches the PWMTC.
	PWM_MCR_PWMMR4I_Pos                 = 0xc        // Position of PWMMR4I field.
	PWM_MCR_PWMMR4I_Msk                 = 0x1000     // Bit mask of PWMMR4I field.
	PWM_MCR_PWMMR4I                     = 0x1000     // Bit PWMMR4I.
	PWM_MCR_PWMMR4I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR4I_INTERRUPT_ON_PWMMR4 = 0x1        // Interrupt on PWMMR4: an interrupt is generated when PWMMR4 matches the value in the PWMTC.
	PWM_MCR_PWMMR4R_Pos                 = 0xd        // Position of PWMMR4R field.
	PWM_MCR_PWMMR4R_Msk                 = 0x2000     // Bit mask of PWMMR4R field.
	PWM_MCR_PWMMR4R                     = 0x2000     // Bit PWMMR4R.
	PWM_MCR_PWMMR4R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR4R_RESET_ON_PWMMR4_THE = 0x1        // Reset on PWMMR4: the PWMTC will be reset if PWMMR4 matches it.
	PWM_MCR_PWMMR4S_Pos                 = 0xe        // Position of PWMMR4S field.
	PWM_MCR_PWMMR4S_Msk                 = 0x4000     // Bit mask of PWMMR4S field.
	PWM_MCR_PWMMR4S                     = 0x4000     // Bit PWMMR4S.
	PWM_MCR_PWMMR4S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR4S_STOP_ON_PWMMR4_THE_ = 0x1        // Stop on PWMMR4: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR4 matches the PWMTC.
	PWM_MCR_PWMMR5I_Pos                 = 0xf        // Position of PWMMR5I field.
	PWM_MCR_PWMMR5I_Msk                 = 0x8000     // Bit mask of PWMMR5I field.
	PWM_MCR_PWMMR5I                     = 0x8000     // Bit PWMMR5I.
	PWM_MCR_PWMMR5I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR5I_INTERRUPT_ON_PWMMR5 = 0x1        // Interrupt on PWMMR5: an interrupt is generated when PWMMR5 matches the value in the PWMTC.
	PWM_MCR_PWMMR5R_Pos                 = 0x10       // Position of PWMMR5R field.
	PWM_MCR_PWMMR5R_Msk                 = 0x10000    // Bit mask of PWMMR5R field.
	PWM_MCR_PWMMR5R                     = 0x10000    // Bit PWMMR5R.
	PWM_MCR_PWMMR5R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR5R_RESET_ON_PWMMR5_THE = 0x1        // Reset on PWMMR5: the PWMTC will be reset if PWMMR5 matches it.
	PWM_MCR_PWMMR5S_Pos                 = 0x11       // Position of PWMMR5S field.
	PWM_MCR_PWMMR5S_Msk                 = 0x20000    // Bit mask of PWMMR5S field.
	PWM_MCR_PWMMR5S                     = 0x20000    // Bit PWMMR5S.
	PWM_MCR_PWMMR5S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR5S_STOP_ON_PWMMR5_THE_ = 0x1        // Stop on PWMMR5: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR5 matches the PWMTC.
	PWM_MCR_PWMMR6I_Pos                 = 0x12       // Position of PWMMR6I field.
	PWM_MCR_PWMMR6I_Msk                 = 0x40000    // Bit mask of PWMMR6I field.
	PWM_MCR_PWMMR6I                     = 0x40000    // Bit PWMMR6I.
	PWM_MCR_PWMMR6I_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR6I_INTERRUPT_ON_PWMMR6 = 0x1        // Interrupt on PWMMR6: an interrupt is generated when PWMMR6 matches the value in the PWMTC.
	PWM_MCR_PWMMR6R_Pos                 = 0x13       // Position of PWMMR6R field.
	PWM_MCR_PWMMR6R_Msk                 = 0x80000    // Bit mask of PWMMR6R field.
	PWM_MCR_PWMMR6R                     = 0x80000    // Bit PWMMR6R.
	PWM_MCR_PWMMR6R_DISABLED_           = 0x0        // Disabled.
	PWM_MCR_PWMMR6R_RESET_ON_PWMMR6_THE = 0x1        // Reset on PWMMR6: the PWMTC will be reset if PWMMR6 matches it.
	PWM_MCR_PWMMR6S_Pos                 = 0x14       // Position of PWMMR6S field.
	PWM_MCR_PWMMR6S_Msk                 = 0x100000   // Bit mask of PWMMR6S field.
	PWM_MCR_PWMMR6S                     = 0x100000   // Bit PWMMR6S.
	PWM_MCR_PWMMR6S_DISABLED            = 0x0        // Disabled
	PWM_MCR_PWMMR6S_STOP_ON_PWMMR6_THE_ = 0x1        // Stop on PWMMR6: the PWMTC and PWMPC will be stopped and PWMTCR bit 0 will be set to 0 if PWMMR6 matches the PWMTC.
	PWM_MCR_RESERVED_Pos                = 0x15       // Position of RESERVED field.
	PWM_MCR_RESERVED_Msk                = 0xffe00000 // Bit mask of RESERVED field.

	// MR0: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
	PWM_MR_MATCH_Pos = 0x0        // Position of MATCH field.
	PWM_MR_MATCH_Msk = 0xffffffff // Bit mask of MATCH field.

	// CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated for a capture event.
	PWM_CCR_CAP0_R_Pos                 = 0x0        // Position of CAP0_R field.
	PWM_CCR_CAP0_R_Msk                 = 0x1        // Bit mask of CAP0_R field.
	PWM_CCR_CAP0_R                     = 0x1        // Bit CAP0_R.
	PWM_CCR_CAP0_R_DISABLED_THIS_FEATU = 0x0        // Disabled. This feature is disabled.
	PWM_CCR_CAP0_R_RISING_EDGE_A_SYNCH = 0x1        // Rising edge. A synchronously sampled rising edge on PWMn_CAP0 will cause CR0 to be loaded with the contents of the TC.
	PWM_CCR_CAP0_F_Pos                 = 0x1        // Position of CAP0_F field.
	PWM_CCR_CAP0_F_Msk                 = 0x2        // Bit mask of CAP0_F field.
	PWM_CCR_CAP0_F                     = 0x2        // Bit CAP0_F.
	PWM_CCR_CAP0_F_DISABLED_THIS_FEATU = 0x0        // Disabled. This feature is disabled.
	PWM_CCR_CAP0_F_FALLING_EDGE_A_SYNC = 0x1        // Falling edge. A synchronously sampled falling edge on PWMn_CAP0 will cause CR0 to be loaded with the contents of TC.
	PWM_CCR_CAP0_I_Pos                 = 0x2        // Position of CAP0_I field.
	PWM_CCR_CAP0_I_Msk                 = 0x4        // Bit mask of CAP0_I field.
	PWM_CCR_CAP0_I                     = 0x4        // Bit CAP0_I.
	PWM_CCR_CAP0_I_DISABLED_THIS_FEATU = 0x0        // Disabled. This feature is disabled.
	PWM_CCR_CAP0_I_INTERRUPT_A_CR0_LOA = 0x1        // Interrupt. A CR0 load due to a PWMn_CAP0 event will generate an interrupt.
	PWM_CCR_CAP1_R_Pos                 = 0x3        // Position of CAP1_R field.
	PWM_CCR_CAP1_R_Msk                 = 0x8        // Bit mask of CAP1_R field.
	PWM_CCR_CAP1_R                     = 0x8        // Bit CAP1_R.
	PWM_CCR_CAP1_R_DISABLED_THIS_FEATU = 0x0        // Disabled. This feature is disabled.
	PWM_CCR_CAP1_R_RISING_EDGE_A_SYNCH = 0x1        // Rising edge. A synchronously sampled rising edge on PWMn_CAP1 will cause CR1 to be loaded with the contents of the TC.
	PWM_CCR_CAP1_F_Pos                 = 0x4        // Position of CAP1_F field.
	PWM_CCR_CAP1_F_Msk                 = 0x10       // Bit mask of CAP1_F field.
	PWM_CCR_CAP1_F                     = 0x10       // Bit CAP1_F.
	PWM_CCR_CAP1_F_DISABLED_THIS_FEATU = 0x0        // Disabled. This feature is disabled.
	PWM_CCR_CAP1_F_FALLING_EDGE_A_SYNC = 0x1        // Falling edge. A synchronously sampled falling edge on PWMn_CAP1 will cause CR1 to be loaded with the contents of TC.
	PWM_CCR_CAP1_I_Pos                 = 0x5        // Position of CAP1_I field.
	PWM_CCR_CAP1_I_Msk                 = 0x20       // Bit mask of CAP1_I field.
	PWM_CCR_CAP1_I                     = 0x20       // Bit CAP1_I.
	PWM_CCR_CAP1_I_DISABLED_THIS_FEATU = 0x0        // Disabled. This feature is disabled.
	PWM_CCR_CAP1_I_INTERRUPT_A_CR1_LOA = 0x1        // Interrupt. A CR1 load due to a PWMn_CAP1 event will generate an interrupt.
	PWM_CCR_RESERVED_Pos               = 0x6        // Position of RESERVED field.
	PWM_CCR_RESERVED_Msk               = 0xffffffc0 // Bit mask of RESERVED field.

	// CR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
	PWM_CR_RESERVED_Pos                 = 0x0        // Position of RESERVED field.
	PWM_CR_RESERVED_Msk                 = 0x3        // Bit mask of RESERVED field.
	PWM_CR_PWMSEL2_Pos                  = 0x2        // Position of PWMSEL2 field.
	PWM_CR_PWMSEL2_Msk                  = 0x4        // Bit mask of PWMSEL2 field.
	PWM_CR_PWMSEL2                      = 0x4        // Bit PWMSEL2.
	PWM_CR_PWMSEL2_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_CR_PWMSEL2_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_CR_PWMSEL3_Pos                  = 0x3        // Position of PWMSEL3 field.
	PWM_CR_PWMSEL3_Msk                  = 0x8        // Bit mask of PWMSEL3 field.
	PWM_CR_PWMSEL3                      = 0x8        // Bit PWMSEL3.
	PWM_CR_PWMSEL3_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_CR_PWMSEL3_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_CR_PWMSEL4_Pos                  = 0x4        // Position of PWMSEL4 field.
	PWM_CR_PWMSEL4_Msk                  = 0x10       // Bit mask of PWMSEL4 field.
	PWM_CR_PWMSEL4                      = 0x10       // Bit PWMSEL4.
	PWM_CR_PWMSEL4_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_CR_PWMSEL4_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_CR_PWMSEL5_Pos                  = 0x5        // Position of PWMSEL5 field.
	PWM_CR_PWMSEL5_Msk                  = 0x20       // Bit mask of PWMSEL5 field.
	PWM_CR_PWMSEL5                      = 0x20       // Bit PWMSEL5.
	PWM_CR_PWMSEL5_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_CR_PWMSEL5_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_CR_PWMSEL6_Pos                  = 0x6        // Position of PWMSEL6 field.
	PWM_CR_PWMSEL6_Msk                  = 0x40       // Bit mask of PWMSEL6 field.
	PWM_CR_PWMSEL6                      = 0x40       // Bit PWMSEL6.
	PWM_CR_PWMSEL6_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_CR_PWMSEL6_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_CR_RESERVED_Pos                 = 0x7        // Position of RESERVED field.
	PWM_CR_RESERVED_Msk                 = 0x180      // Bit mask of RESERVED field.
	PWM_CR_PWMENA1_Pos                  = 0x9        // Position of PWMENA1 field.
	PWM_CR_PWMENA1_Msk                  = 0x200      // Bit mask of PWMENA1 field.
	PWM_CR_PWMENA1                      = 0x200      // Bit PWMENA1.
	PWM_CR_PWMENA1_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_CR_PWMENA1_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_CR_PWMENA2_Pos                  = 0xa        // Position of PWMENA2 field.
	PWM_CR_PWMENA2_Msk                  = 0x400      // Bit mask of PWMENA2 field.
	PWM_CR_PWMENA2                      = 0x400      // Bit PWMENA2.
	PWM_CR_PWMENA2_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_CR_PWMENA2_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_CR_PWMENA3_Pos                  = 0xb        // Position of PWMENA3 field.
	PWM_CR_PWMENA3_Msk                  = 0x800      // Bit mask of PWMENA3 field.
	PWM_CR_PWMENA3                      = 0x800      // Bit PWMENA3.
	PWM_CR_PWMENA3_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_CR_PWMENA3_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_CR_PWMENA4_Pos                  = 0xc        // Position of PWMENA4 field.
	PWM_CR_PWMENA4_Msk                  = 0x1000     // Bit mask of PWMENA4 field.
	PWM_CR_PWMENA4                      = 0x1000     // Bit PWMENA4.
	PWM_CR_PWMENA4_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_CR_PWMENA4_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_CR_PWMENA5_Pos                  = 0xd        // Position of PWMENA5 field.
	PWM_CR_PWMENA5_Msk                  = 0x2000     // Bit mask of PWMENA5 field.
	PWM_CR_PWMENA5                      = 0x2000     // Bit PWMENA5.
	PWM_CR_PWMENA5_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_CR_PWMENA5_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_CR_PWMENA6_Pos                  = 0xe        // Position of PWMENA6 field.
	PWM_CR_PWMENA6_Msk                  = 0x4000     // Bit mask of PWMENA6 field.
	PWM_CR_PWMENA6                      = 0x4000     // Bit PWMENA6.
	PWM_CR_PWMENA6_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_CR_PWMENA6_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_CR_RESERVED_Pos                 = 0xf        // Position of RESERVED field.
	PWM_CR_RESERVED_Msk                 = 0xffff8000 // Bit mask of RESERVED field.

	// MR4: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
	PWM_MR_MATCH_Pos = 0x0        // Position of MATCH field.
	PWM_MR_MATCH_Msk = 0xffffffff // Bit mask of MATCH field.

	// PCR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
	PWM_PCR_RESERVED_Pos                 = 0x0        // Position of RESERVED field.
	PWM_PCR_RESERVED_Msk                 = 0x3        // Bit mask of RESERVED field.
	PWM_PCR_PWMSEL2_Pos                  = 0x2        // Position of PWMSEL2 field.
	PWM_PCR_PWMSEL2_Msk                  = 0x4        // Bit mask of PWMSEL2 field.
	PWM_PCR_PWMSEL2                      = 0x4        // Bit PWMSEL2.
	PWM_PCR_PWMSEL2_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_PCR_PWMSEL2_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_PCR_PWMSEL3_Pos                  = 0x3        // Position of PWMSEL3 field.
	PWM_PCR_PWMSEL3_Msk                  = 0x8        // Bit mask of PWMSEL3 field.
	PWM_PCR_PWMSEL3                      = 0x8        // Bit PWMSEL3.
	PWM_PCR_PWMSEL3_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_PCR_PWMSEL3_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_PCR_PWMSEL4_Pos                  = 0x4        // Position of PWMSEL4 field.
	PWM_PCR_PWMSEL4_Msk                  = 0x10       // Bit mask of PWMSEL4 field.
	PWM_PCR_PWMSEL4                      = 0x10       // Bit PWMSEL4.
	PWM_PCR_PWMSEL4_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_PCR_PWMSEL4_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_PCR_PWMSEL5_Pos                  = 0x5        // Position of PWMSEL5 field.
	PWM_PCR_PWMSEL5_Msk                  = 0x20       // Bit mask of PWMSEL5 field.
	PWM_PCR_PWMSEL5                      = 0x20       // Bit PWMSEL5.
	PWM_PCR_PWMSEL5_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_PCR_PWMSEL5_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_PCR_PWMSEL6_Pos                  = 0x6        // Position of PWMSEL6 field.
	PWM_PCR_PWMSEL6_Msk                  = 0x40       // Bit mask of PWMSEL6 field.
	PWM_PCR_PWMSEL6                      = 0x40       // Bit PWMSEL6.
	PWM_PCR_PWMSEL6_SINGLE_EDGE_CONTROLL = 0x0        // Single edge controlled mode is selected.
	PWM_PCR_PWMSEL6_DOUBLE_EDGE_CONTROLL = 0x1        // Double edge controlled mode is selected.
	PWM_PCR_RESERVED_Pos                 = 0x7        // Position of RESERVED field.
	PWM_PCR_RESERVED_Msk                 = 0x180      // Bit mask of RESERVED field.
	PWM_PCR_PWMENA1_Pos                  = 0x9        // Position of PWMENA1 field.
	PWM_PCR_PWMENA1_Msk                  = 0x200      // Bit mask of PWMENA1 field.
	PWM_PCR_PWMENA1                      = 0x200      // Bit PWMENA1.
	PWM_PCR_PWMENA1_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_PCR_PWMENA1_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_PCR_PWMENA2_Pos                  = 0xa        // Position of PWMENA2 field.
	PWM_PCR_PWMENA2_Msk                  = 0x400      // Bit mask of PWMENA2 field.
	PWM_PCR_PWMENA2                      = 0x400      // Bit PWMENA2.
	PWM_PCR_PWMENA2_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_PCR_PWMENA2_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_PCR_PWMENA3_Pos                  = 0xb        // Position of PWMENA3 field.
	PWM_PCR_PWMENA3_Msk                  = 0x800      // Bit mask of PWMENA3 field.
	PWM_PCR_PWMENA3                      = 0x800      // Bit PWMENA3.
	PWM_PCR_PWMENA3_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_PCR_PWMENA3_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_PCR_PWMENA4_Pos                  = 0xc        // Position of PWMENA4 field.
	PWM_PCR_PWMENA4_Msk                  = 0x1000     // Bit mask of PWMENA4 field.
	PWM_PCR_PWMENA4                      = 0x1000     // Bit PWMENA4.
	PWM_PCR_PWMENA4_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_PCR_PWMENA4_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_PCR_PWMENA5_Pos                  = 0xd        // Position of PWMENA5 field.
	PWM_PCR_PWMENA5_Msk                  = 0x2000     // Bit mask of PWMENA5 field.
	PWM_PCR_PWMENA5                      = 0x2000     // Bit PWMENA5.
	PWM_PCR_PWMENA5_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_PCR_PWMENA5_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_PCR_PWMENA6_Pos                  = 0xe        // Position of PWMENA6 field.
	PWM_PCR_PWMENA6_Msk                  = 0x4000     // Bit mask of PWMENA6 field.
	PWM_PCR_PWMENA6                      = 0x4000     // Bit PWMENA6.
	PWM_PCR_PWMENA6_THE_PWM_OUTPUT_IS_DI = 0x0        // The PWM output is disabled.
	PWM_PCR_PWMENA6_THE_PWM_OUTPUT_IS_EN = 0x1        // The PWM output is enabled.
	PWM_PCR_RESERVED_Pos                 = 0xf        // Position of RESERVED field.
	PWM_PCR_RESERVED_Msk                 = 0xffff8000 // Bit mask of RESERVED field.

	// LER: Load Enable Register. Enables use of updated PWM match values.
	PWM_LER_MAT0LATCHEN_Pos = 0x0        // Position of MAT0LATCHEN field.
	PWM_LER_MAT0LATCHEN_Msk = 0x1        // Bit mask of MAT0LATCHEN field.
	PWM_LER_MAT0LATCHEN     = 0x1        // Bit MAT0LATCHEN.
	PWM_LER_MAT1LATCHEN_Pos = 0x1        // Position of MAT1LATCHEN field.
	PWM_LER_MAT1LATCHEN_Msk = 0x2        // Bit mask of MAT1LATCHEN field.
	PWM_LER_MAT1LATCHEN     = 0x2        // Bit MAT1LATCHEN.
	PWM_LER_MAT2LATCHEN_Pos = 0x2        // Position of MAT2LATCHEN field.
	PWM_LER_MAT2LATCHEN_Msk = 0x4        // Bit mask of MAT2LATCHEN field.
	PWM_LER_MAT2LATCHEN     = 0x4        // Bit MAT2LATCHEN.
	PWM_LER_MAT3LATCHEN_Pos = 0x3        // Position of MAT3LATCHEN field.
	PWM_LER_MAT3LATCHEN_Msk = 0x8        // Bit mask of MAT3LATCHEN field.
	PWM_LER_MAT3LATCHEN     = 0x8        // Bit MAT3LATCHEN.
	PWM_LER_MAT4LATCHEN_Pos = 0x4        // Position of MAT4LATCHEN field.
	PWM_LER_MAT4LATCHEN_Msk = 0x10       // Bit mask of MAT4LATCHEN field.
	PWM_LER_MAT4LATCHEN     = 0x10       // Bit MAT4LATCHEN.
	PWM_LER_MAT5LATCHEN_Pos = 0x5        // Position of MAT5LATCHEN field.
	PWM_LER_MAT5LATCHEN_Msk = 0x20       // Bit mask of MAT5LATCHEN field.
	PWM_LER_MAT5LATCHEN     = 0x20       // Bit MAT5LATCHEN.
	PWM_LER_MAT6LATCHEN_Pos = 0x6        // Position of MAT6LATCHEN field.
	PWM_LER_MAT6LATCHEN_Msk = 0x40       // Bit mask of MAT6LATCHEN field.
	PWM_LER_MAT6LATCHEN     = 0x40       // Bit MAT6LATCHEN.
	PWM_LER_RESERVED_Pos    = 0x7        // Position of RESERVED field.
	PWM_LER_RESERVED_Msk    = 0xffffff80 // Bit mask of RESERVED field.

	// CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
	PWM_CTCR_MOD_Pos                  = 0x0        // Position of MOD field.
	PWM_CTCR_MOD_Msk                  = 0x3        // Bit mask of MOD field.
	PWM_CTCR_MOD_TIMER_MODE_THE_TC_I  = 0x0        // Timer Mode: the TC is incremented when the Prescale Counter matches the Prescale register.
	PWM_CTCR_MOD_RISING_EDGE_COUNTER_ = 0x1        // Rising edge counter Mode: the TC is incremented on rising edges of the PWM_CAP input selected by bits 3:2.
	PWM_CTCR_MOD_FALLING_EDGE_COUNTER = 0x2        // Falling edge counter Mode: the TC is incremented on falling edges of the PWM_CAP input selected by bits 3:2.
	PWM_CTCR_MOD_DUAL_EDGE_COUNTER_MO = 0x3        // Dual edge counter Mode: the TC is incremented on both edges of the PWM_CAP input selected by bits 3:2.
	PWM_CTCR_CIS_Pos                  = 0x2        // Position of CIS field.
	PWM_CTCR_CIS_Msk                  = 0xc        // Bit mask of CIS field.
	PWM_CTCR_CIS_FOR_PWM0_00_EQ_PWM0_ = 0x0        // For PWM0: 00 = PWM0_CAP0 (Other combinations are reserved) For PWM1: 00 = PWM1_CAP0, 01 = PWM1_CAP1 (Other combinations are reserved)
	PWM_CTCR_RESERVED_Pos             = 0x4        // Position of RESERVED field.
	PWM_CTCR_RESERVED_Msk             = 0xfffffff0 // Bit mask of RESERVED field.
)

// Bitfields for I2C0: I2C bus interface
const (
	// CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
	I2C_CONSET_RESERVED_Pos = 0x0        // Position of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	I2C_CONSET_AA_Pos       = 0x2        // Position of AA field.
	I2C_CONSET_AA_Msk       = 0x4        // Bit mask of AA field.
	I2C_CONSET_AA           = 0x4        // Bit AA.
	I2C_CONSET_SI_Pos       = 0x3        // Position of SI field.
	I2C_CONSET_SI_Msk       = 0x8        // Bit mask of SI field.
	I2C_CONSET_SI           = 0x8        // Bit SI.
	I2C_CONSET_STO_Pos      = 0x4        // Position of STO field.
	I2C_CONSET_STO_Msk      = 0x10       // Bit mask of STO field.
	I2C_CONSET_STO          = 0x10       // Bit STO.
	I2C_CONSET_STA_Pos      = 0x5        // Position of STA field.
	I2C_CONSET_STA_Msk      = 0x20       // Bit mask of STA field.
	I2C_CONSET_STA          = 0x20       // Bit STA.
	I2C_CONSET_I2EN_Pos     = 0x6        // Position of I2EN field.
	I2C_CONSET_I2EN_Msk     = 0x40       // Bit mask of I2EN field.
	I2C_CONSET_I2EN         = 0x40       // Bit I2EN.
	I2C_CONSET_RESERVED_Pos = 0x7        // Position of RESERVED field.
	I2C_CONSET_RESERVED_Msk = 0xffffff80 // Bit mask of RESERVED field.

	// STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
	I2C_STAT_RESERVED_Pos = 0x0        // Position of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0x7        // Bit mask of RESERVED field.
	I2C_STAT_Status_Pos   = 0x3        // Position of Status field.
	I2C_STAT_Status_Msk   = 0xf8       // Bit mask of Status field.
	I2C_STAT_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_STAT_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
	I2C_DAT_Data_Pos     = 0x0        // Position of Data field.
	I2C_DAT_Data_Msk     = 0xff       // Bit mask of Data field.
	I2C_DAT_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_DAT_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	I2C_ADR0_GC_Pos       = 0x0        // Position of GC field.
	I2C_ADR0_GC_Msk       = 0x1        // Bit mask of GC field.
	I2C_ADR0_GC           = 0x1        // Bit GC.
	I2C_ADR0_Address_Pos  = 0x1        // Position of Address field.
	I2C_ADR0_Address_Msk  = 0xfe       // Bit mask of Address field.
	I2C_ADR0_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_ADR0_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
	I2C_SCLH_SCLH_Pos     = 0x0        // Position of SCLH field.
	I2C_SCLH_SCLH_Msk     = 0xffff     // Bit mask of SCLH field.
	I2C_SCLH_RESERVED_Pos = 0x10       // Position of RESERVED field.
	I2C_SCLH_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. SCLL and SCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
	I2C_SCLL_SCLL_Pos     = 0x0        // Position of SCLL field.
	I2C_SCLL_SCLL_Msk     = 0xffff     // Bit mask of SCLL field.
	I2C_SCLL_RESERVED_Pos = 0x10       // Position of RESERVED field.
	I2C_SCLL_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
	I2C_CONCLR_RESERVED_Pos = 0x0        // Position of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	I2C_CONCLR_AAC_Pos      = 0x2        // Position of AAC field.
	I2C_CONCLR_AAC_Msk      = 0x4        // Bit mask of AAC field.
	I2C_CONCLR_AAC          = 0x4        // Bit AAC.
	I2C_CONCLR_SIC_Pos      = 0x3        // Position of SIC field.
	I2C_CONCLR_SIC_Msk      = 0x8        // Bit mask of SIC field.
	I2C_CONCLR_SIC          = 0x8        // Bit SIC.
	I2C_CONCLR_RESERVED_Pos = 0x4        // Position of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x10       // Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED     = 0x10       // Bit RESERVED.
	I2C_CONCLR_STAC_Pos     = 0x5        // Position of STAC field.
	I2C_CONCLR_STAC_Msk     = 0x20       // Bit mask of STAC field.
	I2C_CONCLR_STAC         = 0x20       // Bit STAC.
	I2C_CONCLR_I2ENC_Pos    = 0x6        // Position of I2ENC field.
	I2C_CONCLR_I2ENC_Msk    = 0x40       // Bit mask of I2ENC field.
	I2C_CONCLR_I2ENC        = 0x40       // Bit I2ENC.
	I2C_CONCLR_RESERVED_Pos = 0x7        // Position of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0x80       // Bit mask of RESERVED field.
	I2C_CONCLR_RESERVED     = 0x80       // Bit RESERVED.
	I2C_CONCLR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_CONCLR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// MMCTRL: Monitor mode control register.
	I2C_MMCTRL_MM_ENA_Pos                     = 0x0        // Position of MM_ENA field.
	I2C_MMCTRL_MM_ENA_Msk                     = 0x1        // Bit mask of MM_ENA field.
	I2C_MMCTRL_MM_ENA                         = 0x1        // Bit MM_ENA.
	I2C_MMCTRL_MM_ENA_MONITOR_MODE_DISABLE    = 0x0        // Monitor mode disabled.
	I2C_MMCTRL_MM_ENA_THE_I_2C_MODULE_WILL    = 0x1        // The I 2C module will enter monitor mode. In this mode the SDA output will be forced high. This will prevent the I2C module from outputting data of any kind (including ACK) onto the I2C data bus. Depending on the state of the ENA_SCL bit, the output may be also forced high, preventing the module from having control over the I2C clock line.
	I2C_MMCTRL_ENA_SCL_Pos                    = 0x1        // Position of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL_Msk                    = 0x2        // Bit mask of ENA_SCL field.
	I2C_MMCTRL_ENA_SCL                        = 0x2        // Bit ENA_SCL.
	I2C_MMCTRL_ENA_SCL_WHEN_THIS_BIT_IS_CLE   = 0x0        // When this bit is cleared to 0, the SCL output will be forced high when the module is in monitor mode. As described above, this will prevent the module from having any control over the I2C clock line.
	I2C_MMCTRL_ENA_SCL_WHEN_THIS_BIT_IS_SET   = 0x1        // When this bit is set, the I2C module may exercise the same control over the clock line that it would in normal operation. This means that, acting as a slave peripheral, the I2C module can stretch the clock line (hold it low) until it has had time to respond to an I2C interrupt.[1]
	I2C_MMCTRL_MATCH_ALL_Pos                  = 0x2        // Position of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL_Msk                  = 0x4        // Bit mask of MATCH_ALL field.
	I2C_MMCTRL_MATCH_ALL                      = 0x4        // Bit MATCH_ALL.
	I2C_MMCTRL_MATCH_ALL_WHEN_THIS_BIT_IS_CLE = 0x0        // When this bit is cleared, an interrupt will only be generated when a match occurs to one of the (up-to) four address registers described above.   That is, the module will respond as a normal slave as far as address-recognition is concerned.
	I2C_MMCTRL_MATCH_ALL_WHEN_THIS_BIT_IS_SET = 0x1        // When this bit is set to 1 and the I2C is in monitor mode, an interrupt will be generated on ANY address received. This will enable the part to monitor all traffic on the bus.
	I2C_MMCTRL_RESERVED_Pos                   = 0x3        // Position of RESERVED field.
	I2C_MMCTRL_RESERVED_Msk                   = 0xfffffff8 // Bit mask of RESERVED field.

	// ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
	I2C_ADR_GC_Pos       = 0x0        // Position of GC field.
	I2C_ADR_GC_Msk       = 0x1        // Bit mask of GC field.
	I2C_ADR_GC           = 0x1        // Bit GC.
	I2C_ADR_Address_Pos  = 0x1        // Position of Address field.
	I2C_ADR_Address_Msk  = 0xfe       // Bit mask of Address field.
	I2C_ADR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_ADR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
	I2C_DATA_BUFFER_Data_Pos     = 0x0        // Position of Data field.
	I2C_DATA_BUFFER_Data_Msk     = 0xff       // Bit mask of Data field.
	I2C_DATA_BUFFER_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_DATA_BUFFER_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// MASK: I2C Slave address mask register
	I2C_MASK_RESERVED_Pos = 0x0        // Position of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0x1        // Bit mask of RESERVED field.
	I2C_MASK_RESERVED     = 0x1        // Bit RESERVED.
	I2C_MASK_MASK_Pos     = 0x1        // Position of MASK field.
	I2C_MASK_MASK_Msk     = 0xfe       // Bit mask of MASK field.
	I2C_MASK_RESERVED_Pos = 0x8        // Position of RESERVED field.
	I2C_MASK_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.
)

// Bitfields for SPI: SPI
const (
	// CR: SPI Control Register. This register controls the operation of the SPI.
	SPI_CR_RESERVED_Pos                   = 0x0        // Position of RESERVED field.
	SPI_CR_RESERVED_Msk                   = 0x3        // Bit mask of RESERVED field.
	SPI_CR_BITENABLE_Pos                  = 0x2        // Position of BITENABLE field.
	SPI_CR_BITENABLE_Msk                  = 0x4        // Bit mask of BITENABLE field.
	SPI_CR_BITENABLE                      = 0x4        // Bit BITENABLE.
	SPI_CR_BITENABLE_THE_SPI_CONTROLLER_S = 0x1        // The SPI controller sends and receives the number of bits selected by bits 11:8.
	SPI_CR_CPHA_Pos                       = 0x3        // Position of CPHA field.
	SPI_CR_CPHA_Msk                       = 0x8        // Bit mask of CPHA field.
	SPI_CR_CPHA                           = 0x8        // Bit CPHA.
	SPI_CR_CPHA_FIRST_EDGE                = 0x0        // Data is sampled on the first clock edge of SCK. A transfer starts and ends with activation and deactivation of the SSEL signal.
	SPI_CR_CPHA_SECOND_EDGE               = 0x1        // Data is sampled on the second clock edge of the SCK. A transfer starts with the first clock edge, and ends with the last sampling edge when the SSEL signal is active.
	SPI_CR_CPOL_Pos                       = 0x4        // Position of CPOL field.
	SPI_CR_CPOL_Msk                       = 0x10       // Bit mask of CPOL field.
	SPI_CR_CPOL                           = 0x10       // Bit CPOL.
	SPI_CR_CPOL_SCK_IS_ACTIVE_HIGH_       = 0x0        // SCK is active high.
	SPI_CR_CPOL_SCK_IS_ACTIVE_LOW_        = 0x1        // SCK is active low.
	SPI_CR_MSTR_Pos                       = 0x5        // Position of MSTR field.
	SPI_CR_MSTR_Msk                       = 0x20       // Bit mask of MSTR field.
	SPI_CR_MSTR                           = 0x20       // Bit MSTR.
	SPI_CR_MSTR_SLAVE                     = 0x0        // The SPI operates in Slave mode.
	SPI_CR_MSTR_MASTER                    = 0x1        // The SPI operates in Master mode.
	SPI_CR_LSBF_Pos                       = 0x6        // Position of LSBF field.
	SPI_CR_LSBF_Msk                       = 0x40       // Bit mask of LSBF field.
	SPI_CR_LSBF                           = 0x40       // Bit LSBF.
	SPI_CR_LSBF_MSB                       = 0x0        // SPI data is transferred MSB (bit 7) first.
	SPI_CR_LSBF_LSB                       = 0x1        // SPI data is transferred LSB (bit 0) first.
	SPI_CR_SPIE_Pos                       = 0x7        // Position of SPIE field.
	SPI_CR_SPIE_Msk                       = 0x80       // Bit mask of SPIE field.
	SPI_CR_SPIE                           = 0x80       // Bit SPIE.
	SPI_CR_SPIE_INTBLOCK                  = 0x0        // SPI interrupts are inhibited.
	SPI_CR_SPIE_HWINT                     = 0x1        // A hardware interrupt is generated each time the SPIF or MODF bits are activated.
	SPI_CR_BITS_Pos                       = 0x8        // Position of BITS field.
	SPI_CR_BITS_Msk                       = 0xf00      // Bit mask of BITS field.
	SPI_CR_BITS_8_BITS_PER_TRANSFER       = 0x8        // 8 bits per transfer
	SPI_CR_BITS_9_BITS_PER_TRANSFER       = 0x9        // 9 bits per transfer
	SPI_CR_BITS_10_BITS_PER_TRANSFER      = 0xa        // 10 bits per transfer
	SPI_CR_BITS_11_BITS_PER_TRANSFER      = 0xb        // 11 bits per transfer
	SPI_CR_BITS_12_BITS_PER_TRANSFER      = 0xc        // 12 bits per transfer
	SPI_CR_BITS_13_BITS_PER_TRANSFER      = 0xd        // 13 bits per transfer
	SPI_CR_BITS_14_BITS_PER_TRANSFER      = 0xe        // 14 bits per transfer
	SPI_CR_BITS_15_BITS_PER_TRANSFER      = 0xf        // 15 bits per transfer
	SPI_CR_BITS_16_BITS_PER_TRANSFER      = 0x0        // 16 bits per transfer
	SPI_CR_RESERVED_Pos                   = 0xc        // Position of RESERVED field.
	SPI_CR_RESERVED_Msk                   = 0xfffff000 // Bit mask of RESERVED field.

	// SR: SPI Status Register. This register shows the status of the SPI.
	SPI_SR_RESERVED_Pos = 0x0        // Position of RESERVED field.
	SPI_SR_RESERVED_Msk = 0x7        // Bit mask of RESERVED field.
	SPI_SR_ABRT_Pos     = 0x3        // Position of ABRT field.
	SPI_SR_ABRT_Msk     = 0x8        // Bit mask of ABRT field.
	SPI_SR_ABRT         = 0x8        // Bit ABRT.
	SPI_SR_MODF_Pos     = 0x4        // Position of MODF field.
	SPI_SR_MODF_Msk     = 0x10       // Bit mask of MODF field.
	SPI_SR_MODF         = 0x10       // Bit MODF.
	SPI_SR_ROVR_Pos     = 0x5        // Position of ROVR field.
	SPI_SR_ROVR_Msk     = 0x20       // Bit mask of ROVR field.
	SPI_SR_ROVR         = 0x20       // Bit ROVR.
	SPI_SR_WCOL_Pos     = 0x6        // Position of WCOL field.
	SPI_SR_WCOL_Msk     = 0x40       // Bit mask of WCOL field.
	SPI_SR_WCOL         = 0x40       // Bit WCOL.
	SPI_SR_SPIF_Pos     = 0x7        // Position of SPIF field.
	SPI_SR_SPIF_Msk     = 0x80       // Bit mask of SPIF field.
	SPI_SR_SPIF         = 0x80       // Bit SPIF.
	SPI_SR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SPI_SR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// DR: SPI Data Register. This bi-directional register provides the transmit and receive data for the SPI. Transmit data is provided to the SPI0 by writing to this register. Data received by the SPI0 can be read from this register.
	SPI_DR_DATALOW_Pos  = 0x0        // Position of DATALOW field.
	SPI_DR_DATALOW_Msk  = 0xff       // Bit mask of DATALOW field.
	SPI_DR_DATAHIGH_Pos = 0x8        // Position of DATAHIGH field.
	SPI_DR_DATAHIGH_Msk = 0xff00     // Bit mask of DATAHIGH field.
	SPI_DR_RESERVED_Pos = 0x10       // Position of RESERVED field.
	SPI_DR_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// CCR: SPI Clock Counter Register. This register controls the frequency of a master's SCK0.
	SPI_CCR_COUNTER_Pos  = 0x0        // Position of COUNTER field.
	SPI_CCR_COUNTER_Msk  = 0xff       // Bit mask of COUNTER field.
	SPI_CCR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SPI_CCR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// INT: SPI Interrupt Flag. This register contains the interrupt flag for the SPI interface.
	SPI_INT_SPIF_Pos     = 0x0        // Position of SPIF field.
	SPI_INT_SPIF_Msk     = 0x1        // Bit mask of SPIF field.
	SPI_INT_SPIF         = 0x1        // Bit SPIF.
	SPI_INT_RESERVED_Pos = 0x1        // Position of RESERVED field.
	SPI_INT_RESERVED_Msk = 0xfe       // Bit mask of RESERVED field.
	SPI_INT_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SPI_INT_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.
)

// Bitfields for RTC: Real Time Clock (RTC)
const (
	// ILR: Interrupt Location Register
	RTC_ILR_RTCCIF_Pos   = 0x0        // Position of RTCCIF field.
	RTC_ILR_RTCCIF_Msk   = 0x1        // Bit mask of RTCCIF field.
	RTC_ILR_RTCCIF       = 0x1        // Bit RTCCIF.
	RTC_ILR_RTCALF_Pos   = 0x1        // Position of RTCALF field.
	RTC_ILR_RTCALF_Msk   = 0x2        // Bit mask of RTCALF field.
	RTC_ILR_RTCALF       = 0x2        // Bit RTCALF.
	RTC_ILR_RESERVED_Pos = 0x15       // Position of RESERVED field.
	RTC_ILR_RESERVED_Msk = 0xffe00000 // Bit mask of RESERVED field.

	// CCR: Clock Control Register
	RTC_CCR_CLKEN_Pos                     = 0x0        // Position of CLKEN field.
	RTC_CCR_CLKEN_Msk                     = 0x1        // Bit mask of CLKEN field.
	RTC_CCR_CLKEN                         = 0x1        // Bit CLKEN.
	RTC_CCR_CLKEN_THE_TIME_COUNTERS_AR_1  = 0x1        // The time counters are enabled.
	RTC_CCR_CLKEN_THE_TIME_COUNTERS_AR_0  = 0x0        // The time counters are disabled so that they may be initialized.
	RTC_CCR_CTCRST_Pos                    = 0x1        // Position of CTCRST field.
	RTC_CCR_CTCRST_Msk                    = 0x2        // Bit mask of CTCRST field.
	RTC_CCR_CTCRST                        = 0x2        // Bit CTCRST.
	RTC_CCR_CTCRST_RESET                  = 0x1        // When one, the elements in the internal oscillator divider are reset, and remain reset until CCR[1] is changed to zero. This is the divider that generates the 1 Hz clock from the 32.768 kHz crystal. The state of the divider is not visible to software.
	RTC_CCR_CTCRST_NO_EFFECT_             = 0x0        // No effect.
	RTC_CCR_RESERVED_Pos                  = 0x2        // Position of RESERVED field.
	RTC_CCR_RESERVED_Msk                  = 0xc        // Bit mask of RESERVED field.
	RTC_CCR_CCALEN_Pos                    = 0x4        // Position of CCALEN field.
	RTC_CCR_CCALEN_Msk                    = 0x10       // Bit mask of CCALEN field.
	RTC_CCR_CCALEN                        = 0x10       // Bit CCALEN.
	RTC_CCR_CCALEN_THE_CALIBRATION_COUN_1 = 0x1        // The calibration counter is disabled and reset to zero.
	RTC_CCR_CCALEN_THE_CALIBRATION_COUN_0 = 0x0        // The calibration counter is enabled and counting, using the 1 Hz clock. When the calibration counter is equal to the value of the CALIBRATION register, the counter resets and repeats counting up to the value of the CALIBRATION register. See Section 30.6.4.2 and  Section 30.6.5.
	RTC_CCR_RESERVED_Pos                  = 0x5        // Position of RESERVED field.
	RTC_CCR_RESERVED_Msk                  = 0xffffffe0 // Bit mask of RESERVED field.

	// CIIR: Counter Increment Interrupt Register
	RTC_CIIR_IMSEC_Pos    = 0x0        // Position of IMSEC field.
	RTC_CIIR_IMSEC_Msk    = 0x1        // Bit mask of IMSEC field.
	RTC_CIIR_IMSEC        = 0x1        // Bit IMSEC.
	RTC_CIIR_IMMIN_Pos    = 0x1        // Position of IMMIN field.
	RTC_CIIR_IMMIN_Msk    = 0x2        // Bit mask of IMMIN field.
	RTC_CIIR_IMMIN        = 0x2        // Bit IMMIN.
	RTC_CIIR_IMHOUR_Pos   = 0x2        // Position of IMHOUR field.
	RTC_CIIR_IMHOUR_Msk   = 0x4        // Bit mask of IMHOUR field.
	RTC_CIIR_IMHOUR       = 0x4        // Bit IMHOUR.
	RTC_CIIR_IMDOM_Pos    = 0x3        // Position of IMDOM field.
	RTC_CIIR_IMDOM_Msk    = 0x8        // Bit mask of IMDOM field.
	RTC_CIIR_IMDOM        = 0x8        // Bit IMDOM.
	RTC_CIIR_IMDOW_Pos    = 0x4        // Position of IMDOW field.
	RTC_CIIR_IMDOW_Msk    = 0x10       // Bit mask of IMDOW field.
	RTC_CIIR_IMDOW        = 0x10       // Bit IMDOW.
	RTC_CIIR_IMDOY_Pos    = 0x5        // Position of IMDOY field.
	RTC_CIIR_IMDOY_Msk    = 0x20       // Bit mask of IMDOY field.
	RTC_CIIR_IMDOY        = 0x20       // Bit IMDOY.
	RTC_CIIR_IMMON_Pos    = 0x6        // Position of IMMON field.
	RTC_CIIR_IMMON_Msk    = 0x40       // Bit mask of IMMON field.
	RTC_CIIR_IMMON        = 0x40       // Bit IMMON.
	RTC_CIIR_IMYEAR_Pos   = 0x7        // Position of IMYEAR field.
	RTC_CIIR_IMYEAR_Msk   = 0x80       // Bit mask of IMYEAR field.
	RTC_CIIR_IMYEAR       = 0x80       // Bit IMYEAR.
	RTC_CIIR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	RTC_CIIR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// AMR: Alarm Mask Register
	RTC_AMR_AMRSEC_Pos   = 0x0        // Position of AMRSEC field.
	RTC_AMR_AMRSEC_Msk   = 0x1        // Bit mask of AMRSEC field.
	RTC_AMR_AMRSEC       = 0x1        // Bit AMRSEC.
	RTC_AMR_AMRMIN_Pos   = 0x1        // Position of AMRMIN field.
	RTC_AMR_AMRMIN_Msk   = 0x2        // Bit mask of AMRMIN field.
	RTC_AMR_AMRMIN       = 0x2        // Bit AMRMIN.
	RTC_AMR_AMRHOUR_Pos  = 0x2        // Position of AMRHOUR field.
	RTC_AMR_AMRHOUR_Msk  = 0x4        // Bit mask of AMRHOUR field.
	RTC_AMR_AMRHOUR      = 0x4        // Bit AMRHOUR.
	RTC_AMR_AMRDOM_Pos   = 0x3        // Position of AMRDOM field.
	RTC_AMR_AMRDOM_Msk   = 0x8        // Bit mask of AMRDOM field.
	RTC_AMR_AMRDOM       = 0x8        // Bit AMRDOM.
	RTC_AMR_AMRDOW_Pos   = 0x4        // Position of AMRDOW field.
	RTC_AMR_AMRDOW_Msk   = 0x10       // Bit mask of AMRDOW field.
	RTC_AMR_AMRDOW       = 0x10       // Bit AMRDOW.
	RTC_AMR_AMRDOY_Pos   = 0x5        // Position of AMRDOY field.
	RTC_AMR_AMRDOY_Msk   = 0x20       // Bit mask of AMRDOY field.
	RTC_AMR_AMRDOY       = 0x20       // Bit AMRDOY.
	RTC_AMR_AMRMON_Pos   = 0x6        // Position of AMRMON field.
	RTC_AMR_AMRMON_Msk   = 0x40       // Bit mask of AMRMON field.
	RTC_AMR_AMRMON       = 0x40       // Bit AMRMON.
	RTC_AMR_AMRYEAR_Pos  = 0x7        // Position of AMRYEAR field.
	RTC_AMR_AMRYEAR_Msk  = 0x80       // Bit mask of AMRYEAR field.
	RTC_AMR_AMRYEAR      = 0x80       // Bit AMRYEAR.
	RTC_AMR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	RTC_AMR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// CTIME0: Consolidated Time Register 0
	RTC_CTIME0_SECONDS_Pos  = 0x0        // Position of SECONDS field.
	RTC_CTIME0_SECONDS_Msk  = 0x3f       // Bit mask of SECONDS field.
	RTC_CTIME0_RESERVED_Pos = 0x6        // Position of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xc0       // Bit mask of RESERVED field.
	RTC_CTIME0_MINUTES_Pos  = 0x8        // Position of MINUTES field.
	RTC_CTIME0_MINUTES_Msk  = 0x3f00     // Bit mask of MINUTES field.
	RTC_CTIME0_RESERVED_Pos = 0xe        // Position of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xc000     // Bit mask of RESERVED field.
	RTC_CTIME0_HOURS_Pos    = 0x10       // Position of HOURS field.
	RTC_CTIME0_HOURS_Msk    = 0x1f0000   // Bit mask of HOURS field.
	RTC_CTIME0_RESERVED_Pos = 0x15       // Position of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xe00000   // Bit mask of RESERVED field.
	RTC_CTIME0_DOW_Pos      = 0x18       // Position of DOW field.
	RTC_CTIME0_DOW_Msk      = 0x7000000  // Bit mask of DOW field.
	RTC_CTIME0_RESERVED_Pos = 0x1b       // Position of RESERVED field.
	RTC_CTIME0_RESERVED_Msk = 0xf8000000 // Bit mask of RESERVED field.

	// CTIME1: Consolidated Time Register 1
	RTC_CTIME1_DOM_Pos      = 0x0        // Position of DOM field.
	RTC_CTIME1_DOM_Msk      = 0x1f       // Bit mask of DOM field.
	RTC_CTIME1_RESERVED_Pos = 0x5        // Position of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xe0       // Bit mask of RESERVED field.
	RTC_CTIME1_MONTH_Pos    = 0x8        // Position of MONTH field.
	RTC_CTIME1_MONTH_Msk    = 0xf00      // Bit mask of MONTH field.
	RTC_CTIME1_RESERVED_Pos = 0xc        // Position of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xf000     // Bit mask of RESERVED field.
	RTC_CTIME1_YEAR_Pos     = 0x10       // Position of YEAR field.
	RTC_CTIME1_YEAR_Msk     = 0xfff0000  // Bit mask of YEAR field.
	RTC_CTIME1_RESERVED_Pos = 0x1c       // Position of RESERVED field.
	RTC_CTIME1_RESERVED_Msk = 0xf0000000 // Bit mask of RESERVED field.

	// CTIME2: Consolidated Time Register 2
	RTC_CTIME2_DOY_Pos      = 0x0        // Position of DOY field.
	RTC_CTIME2_DOY_Msk      = 0xfff      // Bit mask of DOY field.
	RTC_CTIME2_RESERVED_Pos = 0xc        // Position of RESERVED field.
	RTC_CTIME2_RESERVED_Msk = 0xfffff000 // Bit mask of RESERVED field.

	// SEC: Seconds Counter
	RTC_SEC_SECONDS_Pos  = 0x0        // Position of SECONDS field.
	RTC_SEC_SECONDS_Msk  = 0x3f       // Bit mask of SECONDS field.
	RTC_SEC_RESERVED_Pos = 0x6        // Position of RESERVED field.
	RTC_SEC_RESERVED_Msk = 0xffffffc0 // Bit mask of RESERVED field.

	// MIN: Minutes Register
	RTC_MIN_MINUTES_Pos  = 0x0        // Position of MINUTES field.
	RTC_MIN_MINUTES_Msk  = 0x3f       // Bit mask of MINUTES field.
	RTC_MIN_RESERVED_Pos = 0x6        // Position of RESERVED field.
	RTC_MIN_RESERVED_Msk = 0xffffffc0 // Bit mask of RESERVED field.

	// HRS: Hours Register
	RTC_HRS_HOURS_Pos    = 0x0        // Position of HOURS field.
	RTC_HRS_HOURS_Msk    = 0x1f       // Bit mask of HOURS field.
	RTC_HRS_RESERVED_Pos = 0x5        // Position of RESERVED field.
	RTC_HRS_RESERVED_Msk = 0xffffffe0 // Bit mask of RESERVED field.

	// DOM: Day of Month Register
	RTC_DOM_DOM_Pos      = 0x0        // Position of DOM field.
	RTC_DOM_DOM_Msk      = 0x1f       // Bit mask of DOM field.
	RTC_DOM_RESERVED_Pos = 0x5        // Position of RESERVED field.
	RTC_DOM_RESERVED_Msk = 0xffffffe0 // Bit mask of RESERVED field.

	// DOW: Day of Week Register
	RTC_DOW_DOW_Pos      = 0x0        // Position of DOW field.
	RTC_DOW_DOW_Msk      = 0x7        // Bit mask of DOW field.
	RTC_DOW_RESERVED_Pos = 0x3        // Position of RESERVED field.
	RTC_DOW_RESERVED_Msk = 0xfffffff8 // Bit mask of RESERVED field.

	// DOY: Day of Year Register
	RTC_DOY_DOY_Pos      = 0x0        // Position of DOY field.
	RTC_DOY_DOY_Msk      = 0x1ff      // Bit mask of DOY field.
	RTC_DOY_RESERVED_Pos = 0x9        // Position of RESERVED field.
	RTC_DOY_RESERVED_Msk = 0xfffffe00 // Bit mask of RESERVED field.

	// MONTH: Months Register
	RTC_MONTH_MONTH_Pos    = 0x0        // Position of MONTH field.
	RTC_MONTH_MONTH_Msk    = 0xf        // Bit mask of MONTH field.
	RTC_MONTH_RESERVED_Pos = 0x4        // Position of RESERVED field.
	RTC_MONTH_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// YEAR: Years Register
	RTC_YEAR_YEAR_Pos     = 0x0        // Position of YEAR field.
	RTC_YEAR_YEAR_Msk     = 0xfff      // Bit mask of YEAR field.
	RTC_YEAR_RESERVED_Pos = 0xc        // Position of RESERVED field.
	RTC_YEAR_RESERVED_Msk = 0xfffff000 // Bit mask of RESERVED field.

	// CALIBRATION: Calibration Value Register
	RTC_CALIBRATION_CALVAL_Pos                  = 0x0     // Position of CALVAL field.
	RTC_CALIBRATION_CALVAL_Msk                  = 0x1ffff // Bit mask of CALVAL field.
	RTC_CALIBRATION_CALDIR_Pos                  = 0x11    // Position of CALDIR field.
	RTC_CALIBRATION_CALDIR_Msk                  = 0x20000 // Bit mask of CALDIR field.
	RTC_CALIBRATION_CALDIR                      = 0x20000 // Bit CALDIR.
	RTC_CALIBRATION_CALDIR_BACKWARD_CALIBRATION = 0x1     // Backward calibration. When CALVAL is equal to the calibration counter, the RTC timers will stop incrementing for 1 second.
	RTC_CALIBRATION_CALDIR_FORWARD_CALIBRATION_ = 0x0     // Forward calibration. When CALVAL is equal to the calibration counter, the RTC timers will jump by 2 seconds.

	// GPREG0: General Purpose Register 0
	RTC_GPREG_GP_Pos = 0x0        // Position of GP field.
	RTC_GPREG_GP_Msk = 0xffffffff // Bit mask of GP field.

	// RTC_AUXEN: RTC Auxiliary Enable register
	RTC_RTC_AUXEN_RESERVED_Pos   = 0x0        // Position of RESERVED field.
	RTC_RTC_AUXEN_RESERVED_Msk   = 0xf        // Bit mask of RESERVED field.
	RTC_RTC_AUXEN_RTC_OSCFEN_Pos = 0x4        // Position of RTC_OSCFEN field.
	RTC_RTC_AUXEN_RTC_OSCFEN_Msk = 0x10       // Bit mask of RTC_OSCFEN field.
	RTC_RTC_AUXEN_RTC_OSCFEN     = 0x10       // Bit RTC_OSCFEN.
	RTC_RTC_AUXEN_RESERVED_Pos   = 0x5        // Position of RESERVED field.
	RTC_RTC_AUXEN_RESERVED_Msk   = 0xffffffe0 // Bit mask of RESERVED field.

	// RTC_AUX: RTC Auxiliary control register
	RTC_RTC_AUX_RESERVED_Pos  = 0x0        // Position of RESERVED field.
	RTC_RTC_AUX_RESERVED_Msk  = 0xf        // Bit mask of RESERVED field.
	RTC_RTC_AUX_RTC_OSCF_Pos  = 0x4        // Position of RTC_OSCF field.
	RTC_RTC_AUX_RTC_OSCF_Msk  = 0x10       // Bit mask of RTC_OSCF field.
	RTC_RTC_AUX_RTC_OSCF      = 0x10       // Bit RTC_OSCF.
	RTC_RTC_AUX_RESERVED_Pos  = 0x5        // Position of RESERVED field.
	RTC_RTC_AUX_RESERVED_Msk  = 0x20       // Bit mask of RESERVED field.
	RTC_RTC_AUX_RESERVED      = 0x20       // Bit RESERVED.
	RTC_RTC_AUX_RTC_PDOUT_Pos = 0x6        // Position of RTC_PDOUT field.
	RTC_RTC_AUX_RTC_PDOUT_Msk = 0x40       // Bit mask of RTC_PDOUT field.
	RTC_RTC_AUX_RTC_PDOUT     = 0x40       // Bit RTC_PDOUT.
	RTC_RTC_AUX_RESERVED_Pos  = 0x7        // Position of RESERVED field.
	RTC_RTC_AUX_RESERVED_Msk  = 0xffffff80 // Bit mask of RESERVED field.

	// ASEC: Alarm value for Seconds
	RTC_ASEC_SECONDS_Pos  = 0x0        // Position of SECONDS field.
	RTC_ASEC_SECONDS_Msk  = 0x3f       // Bit mask of SECONDS field.
	RTC_ASEC_RESERVED_Pos = 0x6        // Position of RESERVED field.
	RTC_ASEC_RESERVED_Msk = 0xffffffc0 // Bit mask of RESERVED field.

	// AMIN: Alarm value for Minutes
	RTC_AMIN_MINUTES_Pos  = 0x0        // Position of MINUTES field.
	RTC_AMIN_MINUTES_Msk  = 0x3f       // Bit mask of MINUTES field.
	RTC_AMIN_RESERVED_Pos = 0x6        // Position of RESERVED field.
	RTC_AMIN_RESERVED_Msk = 0xffffffc0 // Bit mask of RESERVED field.

	// AHRS: Alarm value for Hours
	RTC_AHRS_HOURS_Pos    = 0x0        // Position of HOURS field.
	RTC_AHRS_HOURS_Msk    = 0x1f       // Bit mask of HOURS field.
	RTC_AHRS_RESERVED_Pos = 0x5        // Position of RESERVED field.
	RTC_AHRS_RESERVED_Msk = 0xffffffe0 // Bit mask of RESERVED field.

	// ADOM: Alarm value for Day of Month
	RTC_ADOM_DOM_Pos      = 0x0        // Position of DOM field.
	RTC_ADOM_DOM_Msk      = 0x1f       // Bit mask of DOM field.
	RTC_ADOM_RESERVED_Pos = 0x5        // Position of RESERVED field.
	RTC_ADOM_RESERVED_Msk = 0xffffffe0 // Bit mask of RESERVED field.

	// ADOW: Alarm value for Day of Week
	RTC_ADOW_DOW_Pos      = 0x0        // Position of DOW field.
	RTC_ADOW_DOW_Msk      = 0x7        // Bit mask of DOW field.
	RTC_ADOW_RESERVED_Pos = 0x3        // Position of RESERVED field.
	RTC_ADOW_RESERVED_Msk = 0xfffffff8 // Bit mask of RESERVED field.

	// ADOY: Alarm value for Day of Year
	RTC_ADOY_DOY_Pos      = 0x0        // Position of DOY field.
	RTC_ADOY_DOY_Msk      = 0x1ff      // Bit mask of DOY field.
	RTC_ADOY_RESERVED_Pos = 0x9        // Position of RESERVED field.
	RTC_ADOY_RESERVED_Msk = 0xfffffe00 // Bit mask of RESERVED field.

	// AMON: Alarm value for Months
	RTC_AMON_MONTH_Pos    = 0x0        // Position of MONTH field.
	RTC_AMON_MONTH_Msk    = 0xf        // Bit mask of MONTH field.
	RTC_AMON_RESERVED_Pos = 0x4        // Position of RESERVED field.
	RTC_AMON_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// AYRS: Alarm value for Year
	RTC_AYRS_YEAR_Pos     = 0x0        // Position of YEAR field.
	RTC_AYRS_YEAR_Msk     = 0xfff      // Bit mask of YEAR field.
	RTC_AYRS_RESERVED_Pos = 0xc        // Position of RESERVED field.
	RTC_AYRS_RESERVED_Msk = 0xfffff000 // Bit mask of RESERVED field.
)

// Bitfields for GPIOINT: GPIO
const (
	// STATUS: GPIO overall Interrupt Status.
	GPIOINT_STATUS_P0INT_Pos                  = 0x0        // Position of P0INT field.
	GPIOINT_STATUS_P0INT_Msk                  = 0x1        // Bit mask of P0INT field.
	GPIOINT_STATUS_P0INT                      = 0x1        // Bit P0INT.
	GPIOINT_STATUS_P0INT_NO_PENDING_INTERRUPT = 0x0        // No pending interrupts on Port 0.
	GPIOINT_STATUS_P0INT_AT_LEAST_ONE_PENDING = 0x1        // At least one pending interrupt on Port 0.
	GPIOINT_STATUS_RESERVED_Pos               = 0x1        // Position of RESERVED field.
	GPIOINT_STATUS_RESERVED_Msk               = 0x2        // Bit mask of RESERVED field.
	GPIOINT_STATUS_RESERVED                   = 0x2        // Bit RESERVED.
	GPIOINT_STATUS_P2INT_Pos                  = 0x2        // Position of P2INT field.
	GPIOINT_STATUS_P2INT_Msk                  = 0x4        // Bit mask of P2INT field.
	GPIOINT_STATUS_P2INT                      = 0x4        // Bit P2INT.
	GPIOINT_STATUS_P2INT_NO_PENDING_INTERRUPT = 0x0        // No pending interrupts on Port 2.
	GPIOINT_STATUS_P2INT_AT_LEAST_ONE_PENDING = 0x1        // At least one pending interrupt on Port 2.
	GPIOINT_STATUS_RESERVED_Pos               = 0x2        // Position of RESERVED field.
	GPIOINT_STATUS_RESERVED_Msk               = 0xfffffffc // Bit mask of RESERVED field.

	// STATR0: GPIO Interrupt Status for Rising edge for Port 0.
	GPIOINT_STATR0_P0_0REI_Pos  = 0x0        // Position of P0_0REI field.
	GPIOINT_STATR0_P0_0REI_Msk  = 0x1        // Bit mask of P0_0REI field.
	GPIOINT_STATR0_P0_0REI      = 0x1        // Bit P0_0REI.
	GPIOINT_STATR0_P0_1REI_Pos  = 0x1        // Position of P0_1REI field.
	GPIOINT_STATR0_P0_1REI_Msk  = 0x2        // Bit mask of P0_1REI field.
	GPIOINT_STATR0_P0_1REI      = 0x2        // Bit P0_1REI.
	GPIOINT_STATR0_P0_2REI_Pos  = 0x2        // Position of P0_2REI field.
	GPIOINT_STATR0_P0_2REI_Msk  = 0x4        // Bit mask of P0_2REI field.
	GPIOINT_STATR0_P0_2REI      = 0x4        // Bit P0_2REI.
	GPIOINT_STATR0_P0_3REI_Pos  = 0x3        // Position of P0_3REI field.
	GPIOINT_STATR0_P0_3REI_Msk  = 0x8        // Bit mask of P0_3REI field.
	GPIOINT_STATR0_P0_3REI      = 0x8        // Bit P0_3REI.
	GPIOINT_STATR0_P0_4REI_Pos  = 0x4        // Position of P0_4REI field.
	GPIOINT_STATR0_P0_4REI_Msk  = 0x10       // Bit mask of P0_4REI field.
	GPIOINT_STATR0_P0_4REI      = 0x10       // Bit P0_4REI.
	GPIOINT_STATR0_P0_5REI_Pos  = 0x5        // Position of P0_5REI field.
	GPIOINT_STATR0_P0_5REI_Msk  = 0x20       // Bit mask of P0_5REI field.
	GPIOINT_STATR0_P0_5REI      = 0x20       // Bit P0_5REI.
	GPIOINT_STATR0_P0_6REI_Pos  = 0x6        // Position of P0_6REI field.
	GPIOINT_STATR0_P0_6REI_Msk  = 0x40       // Bit mask of P0_6REI field.
	GPIOINT_STATR0_P0_6REI      = 0x40       // Bit P0_6REI.
	GPIOINT_STATR0_P0_7REI_Pos  = 0x7        // Position of P0_7REI field.
	GPIOINT_STATR0_P0_7REI_Msk  = 0x80       // Bit mask of P0_7REI field.
	GPIOINT_STATR0_P0_7REI      = 0x80       // Bit P0_7REI.
	GPIOINT_STATR0_P0_8REI_Pos  = 0x8        // Position of P0_8REI field.
	GPIOINT_STATR0_P0_8REI_Msk  = 0x100      // Bit mask of P0_8REI field.
	GPIOINT_STATR0_P0_8REI      = 0x100      // Bit P0_8REI.
	GPIOINT_STATR0_P0_9REI_Pos  = 0x9        // Position of P0_9REI field.
	GPIOINT_STATR0_P0_9REI_Msk  = 0x200      // Bit mask of P0_9REI field.
	GPIOINT_STATR0_P0_9REI      = 0x200      // Bit P0_9REI.
	GPIOINT_STATR0_P0_10REI_Pos = 0xa        // Position of P0_10REI field.
	GPIOINT_STATR0_P0_10REI_Msk = 0x400      // Bit mask of P0_10REI field.
	GPIOINT_STATR0_P0_10REI     = 0x400      // Bit P0_10REI.
	GPIOINT_STATR0_P0_11REI_Pos = 0xb        // Position of P0_11REI field.
	GPIOINT_STATR0_P0_11REI_Msk = 0x800      // Bit mask of P0_11REI field.
	GPIOINT_STATR0_P0_11REI     = 0x800      // Bit P0_11REI.
	GPIOINT_STATR0_P0_12REI_Pos = 0xc        // Position of P0_12REI field.
	GPIOINT_STATR0_P0_12REI_Msk = 0x1000     // Bit mask of P0_12REI field.
	GPIOINT_STATR0_P0_12REI     = 0x1000     // Bit P0_12REI.
	GPIOINT_STATR0_P0_13REI_Pos = 0xd        // Position of P0_13REI field.
	GPIOINT_STATR0_P0_13REI_Msk = 0x2000     // Bit mask of P0_13REI field.
	GPIOINT_STATR0_P0_13REI     = 0x2000     // Bit P0_13REI.
	GPIOINT_STATR0_P0_14REI_Pos = 0xe        // Position of P0_14REI field.
	GPIOINT_STATR0_P0_14REI_Msk = 0x4000     // Bit mask of P0_14REI field.
	GPIOINT_STATR0_P0_14REI     = 0x4000     // Bit P0_14REI.
	GPIOINT_STATR0_P0_15REI_Pos = 0xf        // Position of P0_15REI field.
	GPIOINT_STATR0_P0_15REI_Msk = 0x8000     // Bit mask of P0_15REI field.
	GPIOINT_STATR0_P0_15REI     = 0x8000     // Bit P0_15REI.
	GPIOINT_STATR0_P0_16REI_Pos = 0x10       // Position of P0_16REI field.
	GPIOINT_STATR0_P0_16REI_Msk = 0x10000    // Bit mask of P0_16REI field.
	GPIOINT_STATR0_P0_16REI     = 0x10000    // Bit P0_16REI.
	GPIOINT_STATR0_P0_17REI_Pos = 0x11       // Position of P0_17REI field.
	GPIOINT_STATR0_P0_17REI_Msk = 0x20000    // Bit mask of P0_17REI field.
	GPIOINT_STATR0_P0_17REI     = 0x20000    // Bit P0_17REI.
	GPIOINT_STATR0_P0_18REI_Pos = 0x12       // Position of P0_18REI field.
	GPIOINT_STATR0_P0_18REI_Msk = 0x40000    // Bit mask of P0_18REI field.
	GPIOINT_STATR0_P0_18REI     = 0x40000    // Bit P0_18REI.
	GPIOINT_STATR0_P0_19REI_Pos = 0x13       // Position of P0_19REI field.
	GPIOINT_STATR0_P0_19REI_Msk = 0x80000    // Bit mask of P0_19REI field.
	GPIOINT_STATR0_P0_19REI     = 0x80000    // Bit P0_19REI.
	GPIOINT_STATR0_P0_20REI_Pos = 0x14       // Position of P0_20REI field.
	GPIOINT_STATR0_P0_20REI_Msk = 0x100000   // Bit mask of P0_20REI field.
	GPIOINT_STATR0_P0_20REI     = 0x100000   // Bit P0_20REI.
	GPIOINT_STATR0_P0_21REI_Pos = 0x15       // Position of P0_21REI field.
	GPIOINT_STATR0_P0_21REI_Msk = 0x200000   // Bit mask of P0_21REI field.
	GPIOINT_STATR0_P0_21REI     = 0x200000   // Bit P0_21REI.
	GPIOINT_STATR0_P0_22REI_Pos = 0x16       // Position of P0_22REI field.
	GPIOINT_STATR0_P0_22REI_Msk = 0x400000   // Bit mask of P0_22REI field.
	GPIOINT_STATR0_P0_22REI     = 0x400000   // Bit P0_22REI.
	GPIOINT_STATR0_P0_23REI_Pos = 0x17       // Position of P0_23REI field.
	GPIOINT_STATR0_P0_23REI_Msk = 0x800000   // Bit mask of P0_23REI field.
	GPIOINT_STATR0_P0_23REI     = 0x800000   // Bit P0_23REI.
	GPIOINT_STATR0_P0_24REI_Pos = 0x18       // Position of P0_24REI field.
	GPIOINT_STATR0_P0_24REI_Msk = 0x1000000  // Bit mask of P0_24REI field.
	GPIOINT_STATR0_P0_24REI     = 0x1000000  // Bit P0_24REI.
	GPIOINT_STATR0_P0_25REI_Pos = 0x19       // Position of P0_25REI field.
	GPIOINT_STATR0_P0_25REI_Msk = 0x2000000  // Bit mask of P0_25REI field.
	GPIOINT_STATR0_P0_25REI     = 0x2000000  // Bit P0_25REI.
	GPIOINT_STATR0_P0_26REI_Pos = 0x1a       // Position of P0_26REI field.
	GPIOINT_STATR0_P0_26REI_Msk = 0x4000000  // Bit mask of P0_26REI field.
	GPIOINT_STATR0_P0_26REI     = 0x4000000  // Bit P0_26REI.
	GPIOINT_STATR0_P0_27REI_Pos = 0x1b       // Position of P0_27REI field.
	GPIOINT_STATR0_P0_27REI_Msk = 0x8000000  // Bit mask of P0_27REI field.
	GPIOINT_STATR0_P0_27REI     = 0x8000000  // Bit P0_27REI.
	GPIOINT_STATR0_P0_28REI_Pos = 0x1c       // Position of P0_28REI field.
	GPIOINT_STATR0_P0_28REI_Msk = 0x10000000 // Bit mask of P0_28REI field.
	GPIOINT_STATR0_P0_28REI     = 0x10000000 // Bit P0_28REI.
	GPIOINT_STATR0_P0_29REI_Pos = 0x1d       // Position of P0_29REI field.
	GPIOINT_STATR0_P0_29REI_Msk = 0x20000000 // Bit mask of P0_29REI field.
	GPIOINT_STATR0_P0_29REI     = 0x20000000 // Bit P0_29REI.
	GPIOINT_STATR0_P0_30REI_Pos = 0x1e       // Position of P0_30REI field.
	GPIOINT_STATR0_P0_30REI_Msk = 0x40000000 // Bit mask of P0_30REI field.
	GPIOINT_STATR0_P0_30REI     = 0x40000000 // Bit P0_30REI.
	GPIOINT_STATR0_RESERVED_Pos = 0x1f       // Position of RESERVED field.
	GPIOINT_STATR0_RESERVED_Msk = 0x80000000 // Bit mask of RESERVED field.
	GPIOINT_STATR0_RESERVED     = 0x80000000 // Bit RESERVED.

	// STATF0: GPIO Interrupt Status for Falling edge for Port 0.
	GPIOINT_STATF0_P0_0FEI_Pos  = 0x0        // Position of P0_0FEI field.
	GPIOINT_STATF0_P0_0FEI_Msk  = 0x1        // Bit mask of P0_0FEI field.
	GPIOINT_STATF0_P0_0FEI      = 0x1        // Bit P0_0FEI.
	GPIOINT_STATF0_P0_1FEI_Pos  = 0x1        // Position of P0_1FEI field.
	GPIOINT_STATF0_P0_1FEI_Msk  = 0x2        // Bit mask of P0_1FEI field.
	GPIOINT_STATF0_P0_1FEI      = 0x2        // Bit P0_1FEI.
	GPIOINT_STATF0_P0_2FEI_Pos  = 0x2        // Position of P0_2FEI field.
	GPIOINT_STATF0_P0_2FEI_Msk  = 0x4        // Bit mask of P0_2FEI field.
	GPIOINT_STATF0_P0_2FEI      = 0x4        // Bit P0_2FEI.
	GPIOINT_STATF0_P0_3FEI_Pos  = 0x3        // Position of P0_3FEI field.
	GPIOINT_STATF0_P0_3FEI_Msk  = 0x8        // Bit mask of P0_3FEI field.
	GPIOINT_STATF0_P0_3FEI      = 0x8        // Bit P0_3FEI.
	GPIOINT_STATF0_P0_4FEI_Pos  = 0x4        // Position of P0_4FEI field.
	GPIOINT_STATF0_P0_4FEI_Msk  = 0x10       // Bit mask of P0_4FEI field.
	GPIOINT_STATF0_P0_4FEI      = 0x10       // Bit P0_4FEI.
	GPIOINT_STATF0_P0_5FEI_Pos  = 0x5        // Position of P0_5FEI field.
	GPIOINT_STATF0_P0_5FEI_Msk  = 0x20       // Bit mask of P0_5FEI field.
	GPIOINT_STATF0_P0_5FEI      = 0x20       // Bit P0_5FEI.
	GPIOINT_STATF0_P0_6FEI_Pos  = 0x6        // Position of P0_6FEI field.
	GPIOINT_STATF0_P0_6FEI_Msk  = 0x40       // Bit mask of P0_6FEI field.
	GPIOINT_STATF0_P0_6FEI      = 0x40       // Bit P0_6FEI.
	GPIOINT_STATF0_P0_7FEI_Pos  = 0x7        // Position of P0_7FEI field.
	GPIOINT_STATF0_P0_7FEI_Msk  = 0x80       // Bit mask of P0_7FEI field.
	GPIOINT_STATF0_P0_7FEI      = 0x80       // Bit P0_7FEI.
	GPIOINT_STATF0_P0_8FEI_Pos  = 0x8        // Position of P0_8FEI field.
	GPIOINT_STATF0_P0_8FEI_Msk  = 0x100      // Bit mask of P0_8FEI field.
	GPIOINT_STATF0_P0_8FEI      = 0x100      // Bit P0_8FEI.
	GPIOINT_STATF0_P0_9FEI_Pos  = 0x9        // Position of P0_9FEI field.
	GPIOINT_STATF0_P0_9FEI_Msk  = 0x200      // Bit mask of P0_9FEI field.
	GPIOINT_STATF0_P0_9FEI      = 0x200      // Bit P0_9FEI.
	GPIOINT_STATF0_P0_10FEI_Pos = 0xa        // Position of P0_10FEI field.
	GPIOINT_STATF0_P0_10FEI_Msk = 0x400      // Bit mask of P0_10FEI field.
	GPIOINT_STATF0_P0_10FEI     = 0x400      // Bit P0_10FEI.
	GPIOINT_STATF0_P0_11FEI_Pos = 0xb        // Position of P0_11FEI field.
	GPIOINT_STATF0_P0_11FEI_Msk = 0x800      // Bit mask of P0_11FEI field.
	GPIOINT_STATF0_P0_11FEI     = 0x800      // Bit P0_11FEI.
	GPIOINT_STATF0_P0_12FEI_Pos = 0xc        // Position of P0_12FEI field.
	GPIOINT_STATF0_P0_12FEI_Msk = 0x1000     // Bit mask of P0_12FEI field.
	GPIOINT_STATF0_P0_12FEI     = 0x1000     // Bit P0_12FEI.
	GPIOINT_STATF0_P0_13FEI_Pos = 0xd        // Position of P0_13FEI field.
	GPIOINT_STATF0_P0_13FEI_Msk = 0x2000     // Bit mask of P0_13FEI field.
	GPIOINT_STATF0_P0_13FEI     = 0x2000     // Bit P0_13FEI.
	GPIOINT_STATF0_P0_14FEI_Pos = 0xe        // Position of P0_14FEI field.
	GPIOINT_STATF0_P0_14FEI_Msk = 0x4000     // Bit mask of P0_14FEI field.
	GPIOINT_STATF0_P0_14FEI     = 0x4000     // Bit P0_14FEI.
	GPIOINT_STATF0_P0_15FEI_Pos = 0xf        // Position of P0_15FEI field.
	GPIOINT_STATF0_P0_15FEI_Msk = 0x8000     // Bit mask of P0_15FEI field.
	GPIOINT_STATF0_P0_15FEI     = 0x8000     // Bit P0_15FEI.
	GPIOINT_STATF0_P0_16FEI_Pos = 0x10       // Position of P0_16FEI field.
	GPIOINT_STATF0_P0_16FEI_Msk = 0x10000    // Bit mask of P0_16FEI field.
	GPIOINT_STATF0_P0_16FEI     = 0x10000    // Bit P0_16FEI.
	GPIOINT_STATF0_P0_17FEI_Pos = 0x11       // Position of P0_17FEI field.
	GPIOINT_STATF0_P0_17FEI_Msk = 0x20000    // Bit mask of P0_17FEI field.
	GPIOINT_STATF0_P0_17FEI     = 0x20000    // Bit P0_17FEI.
	GPIOINT_STATF0_P0_18FEI_Pos = 0x12       // Position of P0_18FEI field.
	GPIOINT_STATF0_P0_18FEI_Msk = 0x40000    // Bit mask of P0_18FEI field.
	GPIOINT_STATF0_P0_18FEI     = 0x40000    // Bit P0_18FEI.
	GPIOINT_STATF0_P0_19FEI_Pos = 0x13       // Position of P0_19FEI field.
	GPIOINT_STATF0_P0_19FEI_Msk = 0x80000    // Bit mask of P0_19FEI field.
	GPIOINT_STATF0_P0_19FEI     = 0x80000    // Bit P0_19FEI.
	GPIOINT_STATF0_P0_20FEI_Pos = 0x14       // Position of P0_20FEI field.
	GPIOINT_STATF0_P0_20FEI_Msk = 0x100000   // Bit mask of P0_20FEI field.
	GPIOINT_STATF0_P0_20FEI     = 0x100000   // Bit P0_20FEI.
	GPIOINT_STATF0_P0_21FEI_Pos = 0x15       // Position of P0_21FEI field.
	GPIOINT_STATF0_P0_21FEI_Msk = 0x200000   // Bit mask of P0_21FEI field.
	GPIOINT_STATF0_P0_21FEI     = 0x200000   // Bit P0_21FEI.
	GPIOINT_STATF0_P0_22FEI_Pos = 0x16       // Position of P0_22FEI field.
	GPIOINT_STATF0_P0_22FEI_Msk = 0x400000   // Bit mask of P0_22FEI field.
	GPIOINT_STATF0_P0_22FEI     = 0x400000   // Bit P0_22FEI.
	GPIOINT_STATF0_P0_23FEI_Pos = 0x17       // Position of P0_23FEI field.
	GPIOINT_STATF0_P0_23FEI_Msk = 0x800000   // Bit mask of P0_23FEI field.
	GPIOINT_STATF0_P0_23FEI     = 0x800000   // Bit P0_23FEI.
	GPIOINT_STATF0_P0_24FEI_Pos = 0x18       // Position of P0_24FEI field.
	GPIOINT_STATF0_P0_24FEI_Msk = 0x1000000  // Bit mask of P0_24FEI field.
	GPIOINT_STATF0_P0_24FEI     = 0x1000000  // Bit P0_24FEI.
	GPIOINT_STATF0_P0_25FEI_Pos = 0x19       // Position of P0_25FEI field.
	GPIOINT_STATF0_P0_25FEI_Msk = 0x2000000  // Bit mask of P0_25FEI field.
	GPIOINT_STATF0_P0_25FEI     = 0x2000000  // Bit P0_25FEI.
	GPIOINT_STATF0_P0_26FEI_Pos = 0x1a       // Position of P0_26FEI field.
	GPIOINT_STATF0_P0_26FEI_Msk = 0x4000000  // Bit mask of P0_26FEI field.
	GPIOINT_STATF0_P0_26FEI     = 0x4000000  // Bit P0_26FEI.
	GPIOINT_STATF0_P0_27FEI_Pos = 0x1b       // Position of P0_27FEI field.
	GPIOINT_STATF0_P0_27FEI_Msk = 0x8000000  // Bit mask of P0_27FEI field.
	GPIOINT_STATF0_P0_27FEI     = 0x8000000  // Bit P0_27FEI.
	GPIOINT_STATF0_P0_28FEI_Pos = 0x1c       // Position of P0_28FEI field.
	GPIOINT_STATF0_P0_28FEI_Msk = 0x10000000 // Bit mask of P0_28FEI field.
	GPIOINT_STATF0_P0_28FEI     = 0x10000000 // Bit P0_28FEI.
	GPIOINT_STATF0_P0_29FEI_Pos = 0x1d       // Position of P0_29FEI field.
	GPIOINT_STATF0_P0_29FEI_Msk = 0x20000000 // Bit mask of P0_29FEI field.
	GPIOINT_STATF0_P0_29FEI     = 0x20000000 // Bit P0_29FEI.
	GPIOINT_STATF0_P0_30FEI_Pos = 0x1e       // Position of P0_30FEI field.
	GPIOINT_STATF0_P0_30FEI_Msk = 0x40000000 // Bit mask of P0_30FEI field.
	GPIOINT_STATF0_P0_30FEI     = 0x40000000 // Bit P0_30FEI.
	GPIOINT_STATF0_RESERVED_Pos = 0x1f       // Position of RESERVED field.
	GPIOINT_STATF0_RESERVED_Msk = 0x80000000 // Bit mask of RESERVED field.
	GPIOINT_STATF0_RESERVED     = 0x80000000 // Bit RESERVED.

	// CLR0: GPIO Interrupt Clear.
	GPIOINT_CLR0_P0_0CI_Pos   = 0x0        // Position of P0_0CI field.
	GPIOINT_CLR0_P0_0CI_Msk   = 0x1        // Bit mask of P0_0CI field.
	GPIOINT_CLR0_P0_0CI       = 0x1        // Bit P0_0CI.
	GPIOINT_CLR0_P0_1CI_Pos   = 0x1        // Position of P0_1CI field.
	GPIOINT_CLR0_P0_1CI_Msk   = 0x2        // Bit mask of P0_1CI field.
	GPIOINT_CLR0_P0_1CI       = 0x2        // Bit P0_1CI.
	GPIOINT_CLR0_P0_2CI_Pos   = 0x2        // Position of P0_2CI field.
	GPIOINT_CLR0_P0_2CI_Msk   = 0x4        // Bit mask of P0_2CI field.
	GPIOINT_CLR0_P0_2CI       = 0x4        // Bit P0_2CI.
	GPIOINT_CLR0_P0_3CI_Pos   = 0x3        // Position of P0_3CI field.
	GPIOINT_CLR0_P0_3CI_Msk   = 0x8        // Bit mask of P0_3CI field.
	GPIOINT_CLR0_P0_3CI       = 0x8        // Bit P0_3CI.
	GPIOINT_CLR0_P0_4CI_Pos   = 0x4        // Position of P0_4CI field.
	GPIOINT_CLR0_P0_4CI_Msk   = 0x10       // Bit mask of P0_4CI field.
	GPIOINT_CLR0_P0_4CI       = 0x10       // Bit P0_4CI.
	GPIOINT_CLR0_P0_5CI_Pos   = 0x5        // Position of P0_5CI field.
	GPIOINT_CLR0_P0_5CI_Msk   = 0x20       // Bit mask of P0_5CI field.
	GPIOINT_CLR0_P0_5CI       = 0x20       // Bit P0_5CI.
	GPIOINT_CLR0_P0_6CI_Pos   = 0x6        // Position of P0_6CI field.
	GPIOINT_CLR0_P0_6CI_Msk   = 0x40       // Bit mask of P0_6CI field.
	GPIOINT_CLR0_P0_6CI       = 0x40       // Bit P0_6CI.
	GPIOINT_CLR0_P0_7CI_Pos   = 0x7        // Position of P0_7CI field.
	GPIOINT_CLR0_P0_7CI_Msk   = 0x80       // Bit mask of P0_7CI field.
	GPIOINT_CLR0_P0_7CI       = 0x80       // Bit P0_7CI.
	GPIOINT_CLR0_P0_8CI_Pos   = 0x8        // Position of P0_8CI field.
	GPIOINT_CLR0_P0_8CI_Msk   = 0x100      // Bit mask of P0_8CI field.
	GPIOINT_CLR0_P0_8CI       = 0x100      // Bit P0_8CI.
	GPIOINT_CLR0_P0_9CI_Pos   = 0x9        // Position of P0_9CI field.
	GPIOINT_CLR0_P0_9CI_Msk   = 0x200      // Bit mask of P0_9CI field.
	GPIOINT_CLR0_P0_9CI       = 0x200      // Bit P0_9CI.
	GPIOINT_CLR0_P0_10CI_Pos  = 0xa        // Position of P0_10CI field.
	GPIOINT_CLR0_P0_10CI_Msk  = 0x400      // Bit mask of P0_10CI field.
	GPIOINT_CLR0_P0_10CI      = 0x400      // Bit P0_10CI.
	GPIOINT_CLR0_P0_11CI_Pos  = 0xb        // Position of P0_11CI field.
	GPIOINT_CLR0_P0_11CI_Msk  = 0x800      // Bit mask of P0_11CI field.
	GPIOINT_CLR0_P0_11CI      = 0x800      // Bit P0_11CI.
	GPIOINT_CLR0_P0_12CI_Pos  = 0xc        // Position of P0_12CI field.
	GPIOINT_CLR0_P0_12CI_Msk  = 0x1000     // Bit mask of P0_12CI field.
	GPIOINT_CLR0_P0_12CI      = 0x1000     // Bit P0_12CI.
	GPIOINT_CLR0_P0_13CI_Pos  = 0xd        // Position of P0_13CI field.
	GPIOINT_CLR0_P0_13CI_Msk  = 0x2000     // Bit mask of P0_13CI field.
	GPIOINT_CLR0_P0_13CI      = 0x2000     // Bit P0_13CI.
	GPIOINT_CLR0_P0_14CI_Pos  = 0xe        // Position of P0_14CI field.
	GPIOINT_CLR0_P0_14CI_Msk  = 0x4000     // Bit mask of P0_14CI field.
	GPIOINT_CLR0_P0_14CI      = 0x4000     // Bit P0_14CI.
	GPIOINT_CLR0_P0_15CI_Pos  = 0xf        // Position of P0_15CI field.
	GPIOINT_CLR0_P0_15CI_Msk  = 0x8000     // Bit mask of P0_15CI field.
	GPIOINT_CLR0_P0_15CI      = 0x8000     // Bit P0_15CI.
	GPIOINT_CLR0_P0_16CI_Pos  = 0x10       // Position of P0_16CI field.
	GPIOINT_CLR0_P0_16CI_Msk  = 0x10000    // Bit mask of P0_16CI field.
	GPIOINT_CLR0_P0_16CI      = 0x10000    // Bit P0_16CI.
	GPIOINT_CLR0_P0_17CI_Pos  = 0x11       // Position of P0_17CI field.
	GPIOINT_CLR0_P0_17CI_Msk  = 0x20000    // Bit mask of P0_17CI field.
	GPIOINT_CLR0_P0_17CI      = 0x20000    // Bit P0_17CI.
	GPIOINT_CLR0_P0_18CI_Pos  = 0x12       // Position of P0_18CI field.
	GPIOINT_CLR0_P0_18CI_Msk  = 0x40000    // Bit mask of P0_18CI field.
	GPIOINT_CLR0_P0_18CI      = 0x40000    // Bit P0_18CI.
	GPIOINT_CLR0_P0_19CI_Pos  = 0x13       // Position of P0_19CI field.
	GPIOINT_CLR0_P0_19CI_Msk  = 0x80000    // Bit mask of P0_19CI field.
	GPIOINT_CLR0_P0_19CI      = 0x80000    // Bit P0_19CI.
	GPIOINT_CLR0_P0_20CI_Pos  = 0x14       // Position of P0_20CI field.
	GPIOINT_CLR0_P0_20CI_Msk  = 0x100000   // Bit mask of P0_20CI field.
	GPIOINT_CLR0_P0_20CI      = 0x100000   // Bit P0_20CI.
	GPIOINT_CLR0_P0_21CI_Pos  = 0x15       // Position of P0_21CI field.
	GPIOINT_CLR0_P0_21CI_Msk  = 0x200000   // Bit mask of P0_21CI field.
	GPIOINT_CLR0_P0_21CI      = 0x200000   // Bit P0_21CI.
	GPIOINT_CLR0_P0_22CI_Pos  = 0x16       // Position of P0_22CI field.
	GPIOINT_CLR0_P0_22CI_Msk  = 0x400000   // Bit mask of P0_22CI field.
	GPIOINT_CLR0_P0_22CI      = 0x400000   // Bit P0_22CI.
	GPIOINT_CLR0_P0_23CI_Pos  = 0x17       // Position of P0_23CI field.
	GPIOINT_CLR0_P0_23CI_Msk  = 0x800000   // Bit mask of P0_23CI field.
	GPIOINT_CLR0_P0_23CI      = 0x800000   // Bit P0_23CI.
	GPIOINT_CLR0_P0_24CI_Pos  = 0x18       // Position of P0_24CI field.
	GPIOINT_CLR0_P0_24CI_Msk  = 0x1000000  // Bit mask of P0_24CI field.
	GPIOINT_CLR0_P0_24CI      = 0x1000000  // Bit P0_24CI.
	GPIOINT_CLR0_P0_25CI_Pos  = 0x19       // Position of P0_25CI field.
	GPIOINT_CLR0_P0_25CI_Msk  = 0x2000000  // Bit mask of P0_25CI field.
	GPIOINT_CLR0_P0_25CI      = 0x2000000  // Bit P0_25CI.
	GPIOINT_CLR0_P0_26CI_Pos  = 0x1a       // Position of P0_26CI field.
	GPIOINT_CLR0_P0_26CI_Msk  = 0x4000000  // Bit mask of P0_26CI field.
	GPIOINT_CLR0_P0_26CI      = 0x4000000  // Bit P0_26CI.
	GPIOINT_CLR0_P0_27CI_Pos  = 0x1b       // Position of P0_27CI field.
	GPIOINT_CLR0_P0_27CI_Msk  = 0x8000000  // Bit mask of P0_27CI field.
	GPIOINT_CLR0_P0_27CI      = 0x8000000  // Bit P0_27CI.
	GPIOINT_CLR0_P0_28CI_Pos  = 0x1c       // Position of P0_28CI field.
	GPIOINT_CLR0_P0_28CI_Msk  = 0x10000000 // Bit mask of P0_28CI field.
	GPIOINT_CLR0_P0_28CI      = 0x10000000 // Bit P0_28CI.
	GPIOINT_CLR0_P0_29CI_Pos  = 0x1d       // Position of P0_29CI field.
	GPIOINT_CLR0_P0_29CI_Msk  = 0x20000000 // Bit mask of P0_29CI field.
	GPIOINT_CLR0_P0_29CI      = 0x20000000 // Bit P0_29CI.
	GPIOINT_CLR0_P0_30CI_Pos  = 0x1e       // Position of P0_30CI field.
	GPIOINT_CLR0_P0_30CI_Msk  = 0x40000000 // Bit mask of P0_30CI field.
	GPIOINT_CLR0_P0_30CI      = 0x40000000 // Bit P0_30CI.
	GPIOINT_CLR0_RESERVED_Pos = 0x1f       // Position of RESERVED field.
	GPIOINT_CLR0_RESERVED_Msk = 0x80000000 // Bit mask of RESERVED field.
	GPIOINT_CLR0_RESERVED     = 0x80000000 // Bit RESERVED.

	// ENR0: GPIO Interrupt Enable for Rising edge for Port 0.
	GPIOINT_ENR0_P0_0ER_Pos   = 0x0        // Position of P0_0ER field.
	GPIOINT_ENR0_P0_0ER_Msk   = 0x1        // Bit mask of P0_0ER field.
	GPIOINT_ENR0_P0_0ER       = 0x1        // Bit P0_0ER.
	GPIOINT_ENR0_P0_1ER_Pos   = 0x1        // Position of P0_1ER field.
	GPIOINT_ENR0_P0_1ER_Msk   = 0x2        // Bit mask of P0_1ER field.
	GPIOINT_ENR0_P0_1ER       = 0x2        // Bit P0_1ER.
	GPIOINT_ENR0_P0_2ER_Pos   = 0x2        // Position of P0_2ER field.
	GPIOINT_ENR0_P0_2ER_Msk   = 0x4        // Bit mask of P0_2ER field.
	GPIOINT_ENR0_P0_2ER       = 0x4        // Bit P0_2ER.
	GPIOINT_ENR0_P0_3ER_Pos   = 0x3        // Position of P0_3ER field.
	GPIOINT_ENR0_P0_3ER_Msk   = 0x8        // Bit mask of P0_3ER field.
	GPIOINT_ENR0_P0_3ER       = 0x8        // Bit P0_3ER.
	GPIOINT_ENR0_P0_4ER_Pos   = 0x4        // Position of P0_4ER field.
	GPIOINT_ENR0_P0_4ER_Msk   = 0x10       // Bit mask of P0_4ER field.
	GPIOINT_ENR0_P0_4ER       = 0x10       // Bit P0_4ER.
	GPIOINT_ENR0_P0_5ER_Pos   = 0x5        // Position of P0_5ER field.
	GPIOINT_ENR0_P0_5ER_Msk   = 0x20       // Bit mask of P0_5ER field.
	GPIOINT_ENR0_P0_5ER       = 0x20       // Bit P0_5ER.
	GPIOINT_ENR0_P0_6ER_Pos   = 0x6        // Position of P0_6ER field.
	GPIOINT_ENR0_P0_6ER_Msk   = 0x40       // Bit mask of P0_6ER field.
	GPIOINT_ENR0_P0_6ER       = 0x40       // Bit P0_6ER.
	GPIOINT_ENR0_P0_7ER_Pos   = 0x7        // Position of P0_7ER field.
	GPIOINT_ENR0_P0_7ER_Msk   = 0x80       // Bit mask of P0_7ER field.
	GPIOINT_ENR0_P0_7ER       = 0x80       // Bit P0_7ER.
	GPIOINT_ENR0_P0_8ER_Pos   = 0x8        // Position of P0_8ER field.
	GPIOINT_ENR0_P0_8ER_Msk   = 0x100      // Bit mask of P0_8ER field.
	GPIOINT_ENR0_P0_8ER       = 0x100      // Bit P0_8ER.
	GPIOINT_ENR0_P0_9ER_Pos   = 0x9        // Position of P0_9ER field.
	GPIOINT_ENR0_P0_9ER_Msk   = 0x200      // Bit mask of P0_9ER field.
	GPIOINT_ENR0_P0_9ER       = 0x200      // Bit P0_9ER.
	GPIOINT_ENR0_P0_10ER_Pos  = 0xa        // Position of P0_10ER field.
	GPIOINT_ENR0_P0_10ER_Msk  = 0x400      // Bit mask of P0_10ER field.
	GPIOINT_ENR0_P0_10ER      = 0x400      // Bit P0_10ER.
	GPIOINT_ENR0_P0_11ER_Pos  = 0xb        // Position of P0_11ER field.
	GPIOINT_ENR0_P0_11ER_Msk  = 0x800      // Bit mask of P0_11ER field.
	GPIOINT_ENR0_P0_11ER      = 0x800      // Bit P0_11ER.
	GPIOINT_ENR0_P0_12ER_Pos  = 0xc        // Position of P0_12ER field.
	GPIOINT_ENR0_P0_12ER_Msk  = 0x1000     // Bit mask of P0_12ER field.
	GPIOINT_ENR0_P0_12ER      = 0x1000     // Bit P0_12ER.
	GPIOINT_ENR0_P0_13ER_Pos  = 0xd        // Position of P0_13ER field.
	GPIOINT_ENR0_P0_13ER_Msk  = 0x2000     // Bit mask of P0_13ER field.
	GPIOINT_ENR0_P0_13ER      = 0x2000     // Bit P0_13ER.
	GPIOINT_ENR0_P0_14ER_Pos  = 0xe        // Position of P0_14ER field.
	GPIOINT_ENR0_P0_14ER_Msk  = 0x4000     // Bit mask of P0_14ER field.
	GPIOINT_ENR0_P0_14ER      = 0x4000     // Bit P0_14ER.
	GPIOINT_ENR0_P0_15ER_Pos  = 0xf        // Position of P0_15ER field.
	GPIOINT_ENR0_P0_15ER_Msk  = 0x8000     // Bit mask of P0_15ER field.
	GPIOINT_ENR0_P0_15ER      = 0x8000     // Bit P0_15ER.
	GPIOINT_ENR0_P0_16ER_Pos  = 0x10       // Position of P0_16ER field.
	GPIOINT_ENR0_P0_16ER_Msk  = 0x10000    // Bit mask of P0_16ER field.
	GPIOINT_ENR0_P0_16ER      = 0x10000    // Bit P0_16ER.
	GPIOINT_ENR0_P0_17ER_Pos  = 0x11       // Position of P0_17ER field.
	GPIOINT_ENR0_P0_17ER_Msk  = 0x20000    // Bit mask of P0_17ER field.
	GPIOINT_ENR0_P0_17ER      = 0x20000    // Bit P0_17ER.
	GPIOINT_ENR0_P0_18ER_Pos  = 0x12       // Position of P0_18ER field.
	GPIOINT_ENR0_P0_18ER_Msk  = 0x40000    // Bit mask of P0_18ER field.
	GPIOINT_ENR0_P0_18ER      = 0x40000    // Bit P0_18ER.
	GPIOINT_ENR0_P0_19ER_Pos  = 0x13       // Position of P0_19ER field.
	GPIOINT_ENR0_P0_19ER_Msk  = 0x80000    // Bit mask of P0_19ER field.
	GPIOINT_ENR0_P0_19ER      = 0x80000    // Bit P0_19ER.
	GPIOINT_ENR0_P0_20ER_Pos  = 0x14       // Position of P0_20ER field.
	GPIOINT_ENR0_P0_20ER_Msk  = 0x100000   // Bit mask of P0_20ER field.
	GPIOINT_ENR0_P0_20ER      = 0x100000   // Bit P0_20ER.
	GPIOINT_ENR0_P0_21ER_Pos  = 0x15       // Position of P0_21ER field.
	GPIOINT_ENR0_P0_21ER_Msk  = 0x200000   // Bit mask of P0_21ER field.
	GPIOINT_ENR0_P0_21ER      = 0x200000   // Bit P0_21ER.
	GPIOINT_ENR0_P0_22ER_Pos  = 0x16       // Position of P0_22ER field.
	GPIOINT_ENR0_P0_22ER_Msk  = 0x400000   // Bit mask of P0_22ER field.
	GPIOINT_ENR0_P0_22ER      = 0x400000   // Bit P0_22ER.
	GPIOINT_ENR0_P0_23ER_Pos  = 0x17       // Position of P0_23ER field.
	GPIOINT_ENR0_P0_23ER_Msk  = 0x800000   // Bit mask of P0_23ER field.
	GPIOINT_ENR0_P0_23ER      = 0x800000   // Bit P0_23ER.
	GPIOINT_ENR0_P0_24ER_Pos  = 0x18       // Position of P0_24ER field.
	GPIOINT_ENR0_P0_24ER_Msk  = 0x1000000  // Bit mask of P0_24ER field.
	GPIOINT_ENR0_P0_24ER      = 0x1000000  // Bit P0_24ER.
	GPIOINT_ENR0_P0_25ER_Pos  = 0x19       // Position of P0_25ER field.
	GPIOINT_ENR0_P0_25ER_Msk  = 0x2000000  // Bit mask of P0_25ER field.
	GPIOINT_ENR0_P0_25ER      = 0x2000000  // Bit P0_25ER.
	GPIOINT_ENR0_P0_26ER_Pos  = 0x1a       // Position of P0_26ER field.
	GPIOINT_ENR0_P0_26ER_Msk  = 0x4000000  // Bit mask of P0_26ER field.
	GPIOINT_ENR0_P0_26ER      = 0x4000000  // Bit P0_26ER.
	GPIOINT_ENR0_P0_27ER_Pos  = 0x1b       // Position of P0_27ER field.
	GPIOINT_ENR0_P0_27ER_Msk  = 0x8000000  // Bit mask of P0_27ER field.
	GPIOINT_ENR0_P0_27ER      = 0x8000000  // Bit P0_27ER.
	GPIOINT_ENR0_P0_28ER_Pos  = 0x1c       // Position of P0_28ER field.
	GPIOINT_ENR0_P0_28ER_Msk  = 0x10000000 // Bit mask of P0_28ER field.
	GPIOINT_ENR0_P0_28ER      = 0x10000000 // Bit P0_28ER.
	GPIOINT_ENR0_P0_29ER_Pos  = 0x1d       // Position of P0_29ER field.
	GPIOINT_ENR0_P0_29ER_Msk  = 0x20000000 // Bit mask of P0_29ER field.
	GPIOINT_ENR0_P0_29ER      = 0x20000000 // Bit P0_29ER.
	GPIOINT_ENR0_P0_30ER_Pos  = 0x1e       // Position of P0_30ER field.
	GPIOINT_ENR0_P0_30ER_Msk  = 0x40000000 // Bit mask of P0_30ER field.
	GPIOINT_ENR0_P0_30ER      = 0x40000000 // Bit P0_30ER.
	GPIOINT_ENR0_RESERVED_Pos = 0x1f       // Position of RESERVED field.
	GPIOINT_ENR0_RESERVED_Msk = 0x80000000 // Bit mask of RESERVED field.
	GPIOINT_ENR0_RESERVED     = 0x80000000 // Bit RESERVED.

	// ENF0: GPIO Interrupt Enable for Falling edge for Port 0.
	GPIOINT_ENF0_P0_0EF_Pos   = 0x0        // Position of P0_0EF field.
	GPIOINT_ENF0_P0_0EF_Msk   = 0x1        // Bit mask of P0_0EF field.
	GPIOINT_ENF0_P0_0EF       = 0x1        // Bit P0_0EF.
	GPIOINT_ENF0_P0_1EF_Pos   = 0x1        // Position of P0_1EF field.
	GPIOINT_ENF0_P0_1EF_Msk   = 0x2        // Bit mask of P0_1EF field.
	GPIOINT_ENF0_P0_1EF       = 0x2        // Bit P0_1EF.
	GPIOINT_ENF0_P0_2EF_Pos   = 0x2        // Position of P0_2EF field.
	GPIOINT_ENF0_P0_2EF_Msk   = 0x4        // Bit mask of P0_2EF field.
	GPIOINT_ENF0_P0_2EF       = 0x4        // Bit P0_2EF.
	GPIOINT_ENF0_P0_3EF_Pos   = 0x3        // Position of P0_3EF field.
	GPIOINT_ENF0_P0_3EF_Msk   = 0x8        // Bit mask of P0_3EF field.
	GPIOINT_ENF0_P0_3EF       = 0x8        // Bit P0_3EF.
	GPIOINT_ENF0_P0_4EF_Pos   = 0x4        // Position of P0_4EF field.
	GPIOINT_ENF0_P0_4EF_Msk   = 0x10       // Bit mask of P0_4EF field.
	GPIOINT_ENF0_P0_4EF       = 0x10       // Bit P0_4EF.
	GPIOINT_ENF0_P0_5EF_Pos   = 0x5        // Position of P0_5EF field.
	GPIOINT_ENF0_P0_5EF_Msk   = 0x20       // Bit mask of P0_5EF field.
	GPIOINT_ENF0_P0_5EF       = 0x20       // Bit P0_5EF.
	GPIOINT_ENF0_P0_6EF_Pos   = 0x6        // Position of P0_6EF field.
	GPIOINT_ENF0_P0_6EF_Msk   = 0x40       // Bit mask of P0_6EF field.
	GPIOINT_ENF0_P0_6EF       = 0x40       // Bit P0_6EF.
	GPIOINT_ENF0_P0_7EF_Pos   = 0x7        // Position of P0_7EF field.
	GPIOINT_ENF0_P0_7EF_Msk   = 0x80       // Bit mask of P0_7EF field.
	GPIOINT_ENF0_P0_7EF       = 0x80       // Bit P0_7EF.
	GPIOINT_ENF0_P0_8EF_Pos   = 0x8        // Position of P0_8EF field.
	GPIOINT_ENF0_P0_8EF_Msk   = 0x100      // Bit mask of P0_8EF field.
	GPIOINT_ENF0_P0_8EF       = 0x100      // Bit P0_8EF.
	GPIOINT_ENF0_P0_9EF_Pos   = 0x9        // Position of P0_9EF field.
	GPIOINT_ENF0_P0_9EF_Msk   = 0x200      // Bit mask of P0_9EF field.
	GPIOINT_ENF0_P0_9EF       = 0x200      // Bit P0_9EF.
	GPIOINT_ENF0_P0_10EF_Pos  = 0xa        // Position of P0_10EF field.
	GPIOINT_ENF0_P0_10EF_Msk  = 0x400      // Bit mask of P0_10EF field.
	GPIOINT_ENF0_P0_10EF      = 0x400      // Bit P0_10EF.
	GPIOINT_ENF0_P0_11EF_Pos  = 0xb        // Position of P0_11EF field.
	GPIOINT_ENF0_P0_11EF_Msk  = 0x800      // Bit mask of P0_11EF field.
	GPIOINT_ENF0_P0_11EF      = 0x800      // Bit P0_11EF.
	GPIOINT_ENF0_P0_12EF_Pos  = 0xc        // Position of P0_12EF field.
	GPIOINT_ENF0_P0_12EF_Msk  = 0x1000     // Bit mask of P0_12EF field.
	GPIOINT_ENF0_P0_12EF      = 0x1000     // Bit P0_12EF.
	GPIOINT_ENF0_P0_13EF_Pos  = 0xd        // Position of P0_13EF field.
	GPIOINT_ENF0_P0_13EF_Msk  = 0x2000     // Bit mask of P0_13EF field.
	GPIOINT_ENF0_P0_13EF      = 0x2000     // Bit P0_13EF.
	GPIOINT_ENF0_P0_14EF_Pos  = 0xe        // Position of P0_14EF field.
	GPIOINT_ENF0_P0_14EF_Msk  = 0x4000     // Bit mask of P0_14EF field.
	GPIOINT_ENF0_P0_14EF      = 0x4000     // Bit P0_14EF.
	GPIOINT_ENF0_P0_15EF_Pos  = 0xf        // Position of P0_15EF field.
	GPIOINT_ENF0_P0_15EF_Msk  = 0x8000     // Bit mask of P0_15EF field.
	GPIOINT_ENF0_P0_15EF      = 0x8000     // Bit P0_15EF.
	GPIOINT_ENF0_P0_16EF_Pos  = 0x10       // Position of P0_16EF field.
	GPIOINT_ENF0_P0_16EF_Msk  = 0x10000    // Bit mask of P0_16EF field.
	GPIOINT_ENF0_P0_16EF      = 0x10000    // Bit P0_16EF.
	GPIOINT_ENF0_P0_17EF_Pos  = 0x11       // Position of P0_17EF field.
	GPIOINT_ENF0_P0_17EF_Msk  = 0x20000    // Bit mask of P0_17EF field.
	GPIOINT_ENF0_P0_17EF      = 0x20000    // Bit P0_17EF.
	GPIOINT_ENF0_P0_18EF_Pos  = 0x12       // Position of P0_18EF field.
	GPIOINT_ENF0_P0_18EF_Msk  = 0x40000    // Bit mask of P0_18EF field.
	GPIOINT_ENF0_P0_18EF      = 0x40000    // Bit P0_18EF.
	GPIOINT_ENF0_P0_19EF_Pos  = 0x13       // Position of P0_19EF field.
	GPIOINT_ENF0_P0_19EF_Msk  = 0x80000    // Bit mask of P0_19EF field.
	GPIOINT_ENF0_P0_19EF      = 0x80000    // Bit P0_19EF.
	GPIOINT_ENF0_P0_20EF_Pos  = 0x14       // Position of P0_20EF field.
	GPIOINT_ENF0_P0_20EF_Msk  = 0x100000   // Bit mask of P0_20EF field.
	GPIOINT_ENF0_P0_20EF      = 0x100000   // Bit P0_20EF.
	GPIOINT_ENF0_P0_21EF_Pos  = 0x15       // Position of P0_21EF field.
	GPIOINT_ENF0_P0_21EF_Msk  = 0x200000   // Bit mask of P0_21EF field.
	GPIOINT_ENF0_P0_21EF      = 0x200000   // Bit P0_21EF.
	GPIOINT_ENF0_P0_22EF_Pos  = 0x16       // Position of P0_22EF field.
	GPIOINT_ENF0_P0_22EF_Msk  = 0x400000   // Bit mask of P0_22EF field.
	GPIOINT_ENF0_P0_22EF      = 0x400000   // Bit P0_22EF.
	GPIOINT_ENF0_P0_23EF_Pos  = 0x17       // Position of P0_23EF field.
	GPIOINT_ENF0_P0_23EF_Msk  = 0x800000   // Bit mask of P0_23EF field.
	GPIOINT_ENF0_P0_23EF      = 0x800000   // Bit P0_23EF.
	GPIOINT_ENF0_P0_24EF_Pos  = 0x18       // Position of P0_24EF field.
	GPIOINT_ENF0_P0_24EF_Msk  = 0x1000000  // Bit mask of P0_24EF field.
	GPIOINT_ENF0_P0_24EF      = 0x1000000  // Bit P0_24EF.
	GPIOINT_ENF0_P0_25EF_Pos  = 0x19       // Position of P0_25EF field.
	GPIOINT_ENF0_P0_25EF_Msk  = 0x2000000  // Bit mask of P0_25EF field.
	GPIOINT_ENF0_P0_25EF      = 0x2000000  // Bit P0_25EF.
	GPIOINT_ENF0_P0_26EF_Pos  = 0x1a       // Position of P0_26EF field.
	GPIOINT_ENF0_P0_26EF_Msk  = 0x4000000  // Bit mask of P0_26EF field.
	GPIOINT_ENF0_P0_26EF      = 0x4000000  // Bit P0_26EF.
	GPIOINT_ENF0_P0_27EF_Pos  = 0x1b       // Position of P0_27EF field.
	GPIOINT_ENF0_P0_27EF_Msk  = 0x8000000  // Bit mask of P0_27EF field.
	GPIOINT_ENF0_P0_27EF      = 0x8000000  // Bit P0_27EF.
	GPIOINT_ENF0_P0_28EF_Pos  = 0x1c       // Position of P0_28EF field.
	GPIOINT_ENF0_P0_28EF_Msk  = 0x10000000 // Bit mask of P0_28EF field.
	GPIOINT_ENF0_P0_28EF      = 0x10000000 // Bit P0_28EF.
	GPIOINT_ENF0_P0_29EF_Pos  = 0x1d       // Position of P0_29EF field.
	GPIOINT_ENF0_P0_29EF_Msk  = 0x20000000 // Bit mask of P0_29EF field.
	GPIOINT_ENF0_P0_29EF      = 0x20000000 // Bit P0_29EF.
	GPIOINT_ENF0_P0_30EF_Pos  = 0x1e       // Position of P0_30EF field.
	GPIOINT_ENF0_P0_30EF_Msk  = 0x40000000 // Bit mask of P0_30EF field.
	GPIOINT_ENF0_P0_30EF      = 0x40000000 // Bit P0_30EF.
	GPIOINT_ENF0_RESERVED_Pos = 0x1f       // Position of RESERVED field.
	GPIOINT_ENF0_RESERVED_Msk = 0x80000000 // Bit mask of RESERVED field.
	GPIOINT_ENF0_RESERVED     = 0x80000000 // Bit RESERVED.

	// STATR2: GPIO Interrupt Status for Rising edge for Port 0.
	GPIOINT_STATR2_P2_0REI_Pos  = 0x0        // Position of P2_0REI field.
	GPIOINT_STATR2_P2_0REI_Msk  = 0x1        // Bit mask of P2_0REI field.
	GPIOINT_STATR2_P2_0REI      = 0x1        // Bit P2_0REI.
	GPIOINT_STATR2_P2_1REI_Pos  = 0x1        // Position of P2_1REI field.
	GPIOINT_STATR2_P2_1REI_Msk  = 0x2        // Bit mask of P2_1REI field.
	GPIOINT_STATR2_P2_1REI      = 0x2        // Bit P2_1REI.
	GPIOINT_STATR2_P2_2REI_Pos  = 0x2        // Position of P2_2REI field.
	GPIOINT_STATR2_P2_2REI_Msk  = 0x4        // Bit mask of P2_2REI field.
	GPIOINT_STATR2_P2_2REI      = 0x4        // Bit P2_2REI.
	GPIOINT_STATR2_P2_3REI_Pos  = 0x3        // Position of P2_3REI field.
	GPIOINT_STATR2_P2_3REI_Msk  = 0x8        // Bit mask of P2_3REI field.
	GPIOINT_STATR2_P2_3REI      = 0x8        // Bit P2_3REI.
	GPIOINT_STATR2_P2_4REI_Pos  = 0x4        // Position of P2_4REI field.
	GPIOINT_STATR2_P2_4REI_Msk  = 0x10       // Bit mask of P2_4REI field.
	GPIOINT_STATR2_P2_4REI      = 0x10       // Bit P2_4REI.
	GPIOINT_STATR2_P2_5REI_Pos  = 0x5        // Position of P2_5REI field.
	GPIOINT_STATR2_P2_5REI_Msk  = 0x20       // Bit mask of P2_5REI field.
	GPIOINT_STATR2_P2_5REI      = 0x20       // Bit P2_5REI.
	GPIOINT_STATR2_P2_6REI_Pos  = 0x6        // Position of P2_6REI field.
	GPIOINT_STATR2_P2_6REI_Msk  = 0x40       // Bit mask of P2_6REI field.
	GPIOINT_STATR2_P2_6REI      = 0x40       // Bit P2_6REI.
	GPIOINT_STATR2_P2_7REI_Pos  = 0x7        // Position of P2_7REI field.
	GPIOINT_STATR2_P2_7REI_Msk  = 0x80       // Bit mask of P2_7REI field.
	GPIOINT_STATR2_P2_7REI      = 0x80       // Bit P2_7REI.
	GPIOINT_STATR2_P2_8REI_Pos  = 0x8        // Position of P2_8REI field.
	GPIOINT_STATR2_P2_8REI_Msk  = 0x100      // Bit mask of P2_8REI field.
	GPIOINT_STATR2_P2_8REI      = 0x100      // Bit P2_8REI.
	GPIOINT_STATR2_P2_9REI_Pos  = 0x9        // Position of P2_9REI field.
	GPIOINT_STATR2_P2_9REI_Msk  = 0x200      // Bit mask of P2_9REI field.
	GPIOINT_STATR2_P2_9REI      = 0x200      // Bit P2_9REI.
	GPIOINT_STATR2_P2_10REI_Pos = 0xa        // Position of P2_10REI field.
	GPIOINT_STATR2_P2_10REI_Msk = 0x400      // Bit mask of P2_10REI field.
	GPIOINT_STATR2_P2_10REI     = 0x400      // Bit P2_10REI.
	GPIOINT_STATR2_P2_11REI_Pos = 0xb        // Position of P2_11REI field.
	GPIOINT_STATR2_P2_11REI_Msk = 0x800      // Bit mask of P2_11REI field.
	GPIOINT_STATR2_P2_11REI     = 0x800      // Bit P2_11REI.
	GPIOINT_STATR2_P2_12REI_Pos = 0xc        // Position of P2_12REI field.
	GPIOINT_STATR2_P2_12REI_Msk = 0x1000     // Bit mask of P2_12REI field.
	GPIOINT_STATR2_P2_12REI     = 0x1000     // Bit P2_12REI.
	GPIOINT_STATR2_P2_13REI_Pos = 0xd        // Position of P2_13REI field.
	GPIOINT_STATR2_P2_13REI_Msk = 0x2000     // Bit mask of P2_13REI field.
	GPIOINT_STATR2_P2_13REI     = 0x2000     // Bit P2_13REI.
	GPIOINT_STATR2_RESERVED_Pos = 0xe        // Position of RESERVED field.
	GPIOINT_STATR2_RESERVED_Msk = 0xffffc000 // Bit mask of RESERVED field.

	// STATF2: GPIO Interrupt Status for Falling edge for Port 0.
	GPIOINT_STATF2_P2_0FEI_Pos  = 0x0        // Position of P2_0FEI field.
	GPIOINT_STATF2_P2_0FEI_Msk  = 0x1        // Bit mask of P2_0FEI field.
	GPIOINT_STATF2_P2_0FEI      = 0x1        // Bit P2_0FEI.
	GPIOINT_STATF2_P2_1FEI_Pos  = 0x1        // Position of P2_1FEI field.
	GPIOINT_STATF2_P2_1FEI_Msk  = 0x2        // Bit mask of P2_1FEI field.
	GPIOINT_STATF2_P2_1FEI      = 0x2        // Bit P2_1FEI.
	GPIOINT_STATF2_P2_2FEI_Pos  = 0x2        // Position of P2_2FEI field.
	GPIOINT_STATF2_P2_2FEI_Msk  = 0x4        // Bit mask of P2_2FEI field.
	GPIOINT_STATF2_P2_2FEI      = 0x4        // Bit P2_2FEI.
	GPIOINT_STATF2_P2_3FEI_Pos  = 0x3        // Position of P2_3FEI field.
	GPIOINT_STATF2_P2_3FEI_Msk  = 0x8        // Bit mask of P2_3FEI field.
	GPIOINT_STATF2_P2_3FEI      = 0x8        // Bit P2_3FEI.
	GPIOINT_STATF2_P2_4FEI_Pos  = 0x4        // Position of P2_4FEI field.
	GPIOINT_STATF2_P2_4FEI_Msk  = 0x10       // Bit mask of P2_4FEI field.
	GPIOINT_STATF2_P2_4FEI      = 0x10       // Bit P2_4FEI.
	GPIOINT_STATF2_P2_5FEI_Pos  = 0x5        // Position of P2_5FEI field.
	GPIOINT_STATF2_P2_5FEI_Msk  = 0x20       // Bit mask of P2_5FEI field.
	GPIOINT_STATF2_P2_5FEI      = 0x20       // Bit P2_5FEI.
	GPIOINT_STATF2_P2_6FEI_Pos  = 0x6        // Position of P2_6FEI field.
	GPIOINT_STATF2_P2_6FEI_Msk  = 0x40       // Bit mask of P2_6FEI field.
	GPIOINT_STATF2_P2_6FEI      = 0x40       // Bit P2_6FEI.
	GPIOINT_STATF2_P2_7FEI_Pos  = 0x7        // Position of P2_7FEI field.
	GPIOINT_STATF2_P2_7FEI_Msk  = 0x80       // Bit mask of P2_7FEI field.
	GPIOINT_STATF2_P2_7FEI      = 0x80       // Bit P2_7FEI.
	GPIOINT_STATF2_P2_8FEI_Pos  = 0x8        // Position of P2_8FEI field.
	GPIOINT_STATF2_P2_8FEI_Msk  = 0x100      // Bit mask of P2_8FEI field.
	GPIOINT_STATF2_P2_8FEI      = 0x100      // Bit P2_8FEI.
	GPIOINT_STATF2_P2_9FEI_Pos  = 0x9        // Position of P2_9FEI field.
	GPIOINT_STATF2_P2_9FEI_Msk  = 0x200      // Bit mask of P2_9FEI field.
	GPIOINT_STATF2_P2_9FEI      = 0x200      // Bit P2_9FEI.
	GPIOINT_STATF2_P2_10FEI_Pos = 0xa        // Position of P2_10FEI field.
	GPIOINT_STATF2_P2_10FEI_Msk = 0x400      // Bit mask of P2_10FEI field.
	GPIOINT_STATF2_P2_10FEI     = 0x400      // Bit P2_10FEI.
	GPIOINT_STATF2_P2_11FEI_Pos = 0xb        // Position of P2_11FEI field.
	GPIOINT_STATF2_P2_11FEI_Msk = 0x800      // Bit mask of P2_11FEI field.
	GPIOINT_STATF2_P2_11FEI     = 0x800      // Bit P2_11FEI.
	GPIOINT_STATF2_P2_12FEI_Pos = 0xc        // Position of P2_12FEI field.
	GPIOINT_STATF2_P2_12FEI_Msk = 0x1000     // Bit mask of P2_12FEI field.
	GPIOINT_STATF2_P2_12FEI     = 0x1000     // Bit P2_12FEI.
	GPIOINT_STATF2_P2_13FEI_Pos = 0xd        // Position of P2_13FEI field.
	GPIOINT_STATF2_P2_13FEI_Msk = 0x2000     // Bit mask of P2_13FEI field.
	GPIOINT_STATF2_P2_13FEI     = 0x2000     // Bit P2_13FEI.
	GPIOINT_STATF2_RESERVED_Pos = 0xe        // Position of RESERVED field.
	GPIOINT_STATF2_RESERVED_Msk = 0xffffc000 // Bit mask of RESERVED field.

	// CLR2: GPIO Interrupt Clear.
	GPIOINT_CLR2_P2_0CI_Pos   = 0x0        // Position of P2_0CI field.
	GPIOINT_CLR2_P2_0CI_Msk   = 0x1        // Bit mask of P2_0CI field.
	GPIOINT_CLR2_P2_0CI       = 0x1        // Bit P2_0CI.
	GPIOINT_CLR2_P2_1CI_Pos   = 0x1        // Position of P2_1CI field.
	GPIOINT_CLR2_P2_1CI_Msk   = 0x2        // Bit mask of P2_1CI field.
	GPIOINT_CLR2_P2_1CI       = 0x2        // Bit P2_1CI.
	GPIOINT_CLR2_P2_2CI_Pos   = 0x2        // Position of P2_2CI field.
	GPIOINT_CLR2_P2_2CI_Msk   = 0x4        // Bit mask of P2_2CI field.
	GPIOINT_CLR2_P2_2CI       = 0x4        // Bit P2_2CI.
	GPIOINT_CLR2_P2_3CI_Pos   = 0x3        // Position of P2_3CI field.
	GPIOINT_CLR2_P2_3CI_Msk   = 0x8        // Bit mask of P2_3CI field.
	GPIOINT_CLR2_P2_3CI       = 0x8        // Bit P2_3CI.
	GPIOINT_CLR2_P2_4CI_Pos   = 0x4        // Position of P2_4CI field.
	GPIOINT_CLR2_P2_4CI_Msk   = 0x10       // Bit mask of P2_4CI field.
	GPIOINT_CLR2_P2_4CI       = 0x10       // Bit P2_4CI.
	GPIOINT_CLR2_P2_5CI_Pos   = 0x5        // Position of P2_5CI field.
	GPIOINT_CLR2_P2_5CI_Msk   = 0x20       // Bit mask of P2_5CI field.
	GPIOINT_CLR2_P2_5CI       = 0x20       // Bit P2_5CI.
	GPIOINT_CLR2_P2_6CI_Pos   = 0x6        // Position of P2_6CI field.
	GPIOINT_CLR2_P2_6CI_Msk   = 0x40       // Bit mask of P2_6CI field.
	GPIOINT_CLR2_P2_6CI       = 0x40       // Bit P2_6CI.
	GPIOINT_CLR2_P2_7CI_Pos   = 0x7        // Position of P2_7CI field.
	GPIOINT_CLR2_P2_7CI_Msk   = 0x80       // Bit mask of P2_7CI field.
	GPIOINT_CLR2_P2_7CI       = 0x80       // Bit P2_7CI.
	GPIOINT_CLR2_P2_8CI_Pos   = 0x8        // Position of P2_8CI field.
	GPIOINT_CLR2_P2_8CI_Msk   = 0x100      // Bit mask of P2_8CI field.
	GPIOINT_CLR2_P2_8CI       = 0x100      // Bit P2_8CI.
	GPIOINT_CLR2_P2_9CI_Pos   = 0x9        // Position of P2_9CI field.
	GPIOINT_CLR2_P2_9CI_Msk   = 0x200      // Bit mask of P2_9CI field.
	GPIOINT_CLR2_P2_9CI       = 0x200      // Bit P2_9CI.
	GPIOINT_CLR2_P2_10CI_Pos  = 0xa        // Position of P2_10CI field.
	GPIOINT_CLR2_P2_10CI_Msk  = 0x400      // Bit mask of P2_10CI field.
	GPIOINT_CLR2_P2_10CI      = 0x400      // Bit P2_10CI.
	GPIOINT_CLR2_P2_11CI_Pos  = 0xb        // Position of P2_11CI field.
	GPIOINT_CLR2_P2_11CI_Msk  = 0x800      // Bit mask of P2_11CI field.
	GPIOINT_CLR2_P2_11CI      = 0x800      // Bit P2_11CI.
	GPIOINT_CLR2_P2_12CI_Pos  = 0xc        // Position of P2_12CI field.
	GPIOINT_CLR2_P2_12CI_Msk  = 0x1000     // Bit mask of P2_12CI field.
	GPIOINT_CLR2_P2_12CI      = 0x1000     // Bit P2_12CI.
	GPIOINT_CLR2_P2_13CI_Pos  = 0xd        // Position of P2_13CI field.
	GPIOINT_CLR2_P2_13CI_Msk  = 0x2000     // Bit mask of P2_13CI field.
	GPIOINT_CLR2_P2_13CI      = 0x2000     // Bit P2_13CI.
	GPIOINT_CLR2_RESERVED_Pos = 0xe        // Position of RESERVED field.
	GPIOINT_CLR2_RESERVED_Msk = 0xffffc000 // Bit mask of RESERVED field.

	// ENR2: GPIO Interrupt Enable for Rising edge for Port 0.
	GPIOINT_ENR2_P2_0ER_Pos   = 0x0        // Position of P2_0ER field.
	GPIOINT_ENR2_P2_0ER_Msk   = 0x1        // Bit mask of P2_0ER field.
	GPIOINT_ENR2_P2_0ER       = 0x1        // Bit P2_0ER.
	GPIOINT_ENR2_P2_1ER_Pos   = 0x1        // Position of P2_1ER field.
	GPIOINT_ENR2_P2_1ER_Msk   = 0x2        // Bit mask of P2_1ER field.
	GPIOINT_ENR2_P2_1ER       = 0x2        // Bit P2_1ER.
	GPIOINT_ENR2_P2_2ER_Pos   = 0x2        // Position of P2_2ER field.
	GPIOINT_ENR2_P2_2ER_Msk   = 0x4        // Bit mask of P2_2ER field.
	GPIOINT_ENR2_P2_2ER       = 0x4        // Bit P2_2ER.
	GPIOINT_ENR2_P2_3ER_Pos   = 0x3        // Position of P2_3ER field.
	GPIOINT_ENR2_P2_3ER_Msk   = 0x8        // Bit mask of P2_3ER field.
	GPIOINT_ENR2_P2_3ER       = 0x8        // Bit P2_3ER.
	GPIOINT_ENR2_P2_4ER_Pos   = 0x4        // Position of P2_4ER field.
	GPIOINT_ENR2_P2_4ER_Msk   = 0x10       // Bit mask of P2_4ER field.
	GPIOINT_ENR2_P2_4ER       = 0x10       // Bit P2_4ER.
	GPIOINT_ENR2_P2_5ER_Pos   = 0x5        // Position of P2_5ER field.
	GPIOINT_ENR2_P2_5ER_Msk   = 0x20       // Bit mask of P2_5ER field.
	GPIOINT_ENR2_P2_5ER       = 0x20       // Bit P2_5ER.
	GPIOINT_ENR2_P2_6ER_Pos   = 0x6        // Position of P2_6ER field.
	GPIOINT_ENR2_P2_6ER_Msk   = 0x40       // Bit mask of P2_6ER field.
	GPIOINT_ENR2_P2_6ER       = 0x40       // Bit P2_6ER.
	GPIOINT_ENR2_P2_7ER_Pos   = 0x7        // Position of P2_7ER field.
	GPIOINT_ENR2_P2_7ER_Msk   = 0x80       // Bit mask of P2_7ER field.
	GPIOINT_ENR2_P2_7ER       = 0x80       // Bit P2_7ER.
	GPIOINT_ENR2_P2_8ER_Pos   = 0x8        // Position of P2_8ER field.
	GPIOINT_ENR2_P2_8ER_Msk   = 0x100      // Bit mask of P2_8ER field.
	GPIOINT_ENR2_P2_8ER       = 0x100      // Bit P2_8ER.
	GPIOINT_ENR2_P2_9ER_Pos   = 0x9        // Position of P2_9ER field.
	GPIOINT_ENR2_P2_9ER_Msk   = 0x200      // Bit mask of P2_9ER field.
	GPIOINT_ENR2_P2_9ER       = 0x200      // Bit P2_9ER.
	GPIOINT_ENR2_P2_10ER_Pos  = 0xa        // Position of P2_10ER field.
	GPIOINT_ENR2_P2_10ER_Msk  = 0x400      // Bit mask of P2_10ER field.
	GPIOINT_ENR2_P2_10ER      = 0x400      // Bit P2_10ER.
	GPIOINT_ENR2_P2_11ER_Pos  = 0xb        // Position of P2_11ER field.
	GPIOINT_ENR2_P2_11ER_Msk  = 0x800      // Bit mask of P2_11ER field.
	GPIOINT_ENR2_P2_11ER      = 0x800      // Bit P2_11ER.
	GPIOINT_ENR2_P2_12ER_Pos  = 0xc        // Position of P2_12ER field.
	GPIOINT_ENR2_P2_12ER_Msk  = 0x1000     // Bit mask of P2_12ER field.
	GPIOINT_ENR2_P2_12ER      = 0x1000     // Bit P2_12ER.
	GPIOINT_ENR2_P2_13ER_Pos  = 0xd        // Position of P2_13ER field.
	GPIOINT_ENR2_P2_13ER_Msk  = 0x2000     // Bit mask of P2_13ER field.
	GPIOINT_ENR2_P2_13ER      = 0x2000     // Bit P2_13ER.
	GPIOINT_ENR2_RESERVED_Pos = 0xe        // Position of RESERVED field.
	GPIOINT_ENR2_RESERVED_Msk = 0xffffc000 // Bit mask of RESERVED field.

	// ENF2: GPIO Interrupt Enable for Falling edge for Port 0.
	GPIOINT_ENF2_P2_0EF_Pos   = 0x0        // Position of P2_0EF field.
	GPIOINT_ENF2_P2_0EF_Msk   = 0x1        // Bit mask of P2_0EF field.
	GPIOINT_ENF2_P2_0EF       = 0x1        // Bit P2_0EF.
	GPIOINT_ENF2_P2_1EF_Pos   = 0x1        // Position of P2_1EF field.
	GPIOINT_ENF2_P2_1EF_Msk   = 0x2        // Bit mask of P2_1EF field.
	GPIOINT_ENF2_P2_1EF       = 0x2        // Bit P2_1EF.
	GPIOINT_ENF2_P2_2EF_Pos   = 0x2        // Position of P2_2EF field.
	GPIOINT_ENF2_P2_2EF_Msk   = 0x4        // Bit mask of P2_2EF field.
	GPIOINT_ENF2_P2_2EF       = 0x4        // Bit P2_2EF.
	GPIOINT_ENF2_P2_3EF_Pos   = 0x3        // Position of P2_3EF field.
	GPIOINT_ENF2_P2_3EF_Msk   = 0x8        // Bit mask of P2_3EF field.
	GPIOINT_ENF2_P2_3EF       = 0x8        // Bit P2_3EF.
	GPIOINT_ENF2_P2_4EF_Pos   = 0x4        // Position of P2_4EF field.
	GPIOINT_ENF2_P2_4EF_Msk   = 0x10       // Bit mask of P2_4EF field.
	GPIOINT_ENF2_P2_4EF       = 0x10       // Bit P2_4EF.
	GPIOINT_ENF2_P2_5EF_Pos   = 0x5        // Position of P2_5EF field.
	GPIOINT_ENF2_P2_5EF_Msk   = 0x20       // Bit mask of P2_5EF field.
	GPIOINT_ENF2_P2_5EF       = 0x20       // Bit P2_5EF.
	GPIOINT_ENF2_P2_6EF_Pos   = 0x6        // Position of P2_6EF field.
	GPIOINT_ENF2_P2_6EF_Msk   = 0x40       // Bit mask of P2_6EF field.
	GPIOINT_ENF2_P2_6EF       = 0x40       // Bit P2_6EF.
	GPIOINT_ENF2_P2_7EF_Pos   = 0x7        // Position of P2_7EF field.
	GPIOINT_ENF2_P2_7EF_Msk   = 0x80       // Bit mask of P2_7EF field.
	GPIOINT_ENF2_P2_7EF       = 0x80       // Bit P2_7EF.
	GPIOINT_ENF2_P2_8EF_Pos   = 0x8        // Position of P2_8EF field.
	GPIOINT_ENF2_P2_8EF_Msk   = 0x100      // Bit mask of P2_8EF field.
	GPIOINT_ENF2_P2_8EF       = 0x100      // Bit P2_8EF.
	GPIOINT_ENF2_P2_9EF_Pos   = 0x9        // Position of P2_9EF field.
	GPIOINT_ENF2_P2_9EF_Msk   = 0x200      // Bit mask of P2_9EF field.
	GPIOINT_ENF2_P2_9EF       = 0x200      // Bit P2_9EF.
	GPIOINT_ENF2_P2_10EF_Pos  = 0xa        // Position of P2_10EF field.
	GPIOINT_ENF2_P2_10EF_Msk  = 0x400      // Bit mask of P2_10EF field.
	GPIOINT_ENF2_P2_10EF      = 0x400      // Bit P2_10EF.
	GPIOINT_ENF2_P2_11EF_Pos  = 0xb        // Position of P2_11EF field.
	GPIOINT_ENF2_P2_11EF_Msk  = 0x800      // Bit mask of P2_11EF field.
	GPIOINT_ENF2_P2_11EF      = 0x800      // Bit P2_11EF.
	GPIOINT_ENF2_P2_12EF_Pos  = 0xc        // Position of P2_12EF field.
	GPIOINT_ENF2_P2_12EF_Msk  = 0x1000     // Bit mask of P2_12EF field.
	GPIOINT_ENF2_P2_12EF      = 0x1000     // Bit P2_12EF.
	GPIOINT_ENF2_P2_13EF_Pos  = 0xd        // Position of P2_13EF field.
	GPIOINT_ENF2_P2_13EF_Msk  = 0x2000     // Bit mask of P2_13EF field.
	GPIOINT_ENF2_P2_13EF      = 0x2000     // Bit P2_13EF.
	GPIOINT_ENF2_RESERVED_Pos = 0xe        // Position of RESERVED field.
	GPIOINT_ENF2_RESERVED_Msk = 0xffffc000 // Bit mask of RESERVED field.
)

// Bitfields for PINCONNECT: Pin connect block
const (
	// PINSEL0: Pin function select register 0.
	PINCONNECT_PINSEL0_P0_0_Pos       = 0x0        // Position of P0_0 field.
	PINCONNECT_PINSEL0_P0_0_Msk       = 0x3        // Bit mask of P0_0 field.
	PINCONNECT_PINSEL0_P0_0_GPIO_P0   = 0x0        // GPIO P0.0
	PINCONNECT_PINSEL0_P0_0_RD1       = 0x1        // RD1
	PINCONNECT_PINSEL0_P0_0_TXD3      = 0x2        // TXD3
	PINCONNECT_PINSEL0_P0_0_SDA1      = 0x3        // SDA1
	PINCONNECT_PINSEL0_P0_1_Pos       = 0x2        // Position of P0_1 field.
	PINCONNECT_PINSEL0_P0_1_Msk       = 0xc        // Bit mask of P0_1 field.
	PINCONNECT_PINSEL0_P0_1_GPIO_P0   = 0x0        // GPIO P0.1
	PINCONNECT_PINSEL0_P0_1_TD1       = 0x1        // TD1
	PINCONNECT_PINSEL0_P0_1_RXD3      = 0x2        // RXD3
	PINCONNECT_PINSEL0_P0_1_SCL1      = 0x3        // SCL1
	PINCONNECT_PINSEL0_P0_2_Pos       = 0x4        // Position of P0_2 field.
	PINCONNECT_PINSEL0_P0_2_Msk       = 0x30       // Bit mask of P0_2 field.
	PINCONNECT_PINSEL0_P0_2_GPIO_P0   = 0x0        // GPIO P0.2
	PINCONNECT_PINSEL0_P0_2_TXD0      = 0x1        // TXD0
	PINCONNECT_PINSEL0_P0_2_AD0       = 0x2        // AD0.7
	PINCONNECT_PINSEL0_P0_3_Pos       = 0x6        // Position of P0_3 field.
	PINCONNECT_PINSEL0_P0_3_Msk       = 0xc0       // Bit mask of P0_3 field.
	PINCONNECT_PINSEL0_P0_3_GPIO_P0   = 0x0        // GPIO P0.3.
	PINCONNECT_PINSEL0_P0_3_RXD0      = 0x1        // RXD0
	PINCONNECT_PINSEL0_P0_3_AD0       = 0x2        // AD0.6
	PINCONNECT_PINSEL0_P0_4_Pos       = 0x8        // Position of P0_4 field.
	PINCONNECT_PINSEL0_P0_4_Msk       = 0x300      // Bit mask of P0_4 field.
	PINCONNECT_PINSEL0_P0_4_GPIO_P0   = 0x0        // GPIO P0.4.
	PINCONNECT_PINSEL0_P0_4_I2SRX_CLK = 0x1        // I2SRX_CLK
	PINCONNECT_PINSEL0_P0_4_RD2       = 0x2        // RD2
	PINCONNECT_PINSEL0_P0_4_CAP2      = 0x3        // CAP2.0
	PINCONNECT_PINSEL0_P0_5_Pos       = 0xa        // Position of P0_5 field.
	PINCONNECT_PINSEL0_P0_5_Msk       = 0xc00      // Bit mask of P0_5 field.
	PINCONNECT_PINSEL0_P0_5_GPIO_P0   = 0x0        // GPIO P0.5.
	PINCONNECT_PINSEL0_P0_5_I2SRX_WS  = 0x1        // I2SRX_WS
	PINCONNECT_PINSEL0_P0_5_TD2       = 0x2        // TD2
	PINCONNECT_PINSEL0_P0_5_CAP2      = 0x3        // CAP2.1
	PINCONNECT_PINSEL0_P0_6_Pos       = 0xc        // Position of P0_6 field.
	PINCONNECT_PINSEL0_P0_6_Msk       = 0x3000     // Bit mask of P0_6 field.
	PINCONNECT_PINSEL0_P0_6_GPIO_P0   = 0x0        // GPIO P0.6.
	PINCONNECT_PINSEL0_P0_6_I2SRX_SDA = 0x1        // I2SRX_SDA
	PINCONNECT_PINSEL0_P0_6_SSEL1     = 0x2        // SSEL1
	PINCONNECT_PINSEL0_P0_6_MAT2      = 0x3        // MAT2.0
	PINCONNECT_PINSEL0_P0_7_Pos       = 0xe        // Position of P0_7 field.
	PINCONNECT_PINSEL0_P0_7_Msk       = 0xc000     // Bit mask of P0_7 field.
	PINCONNECT_PINSEL0_P0_7_GPIO_P0   = 0x0        // GPIO P0.7.
	PINCONNECT_PINSEL0_P0_7_I2STX_CLK = 0x1        // I2STX_CLK
	PINCONNECT_PINSEL0_P0_7_SCK1      = 0x2        // SCK1
	PINCONNECT_PINSEL0_P0_7_MAT2      = 0x3        // MAT2.1
	PINCONNECT_PINSEL0_P0_8_Pos       = 0x10       // Position of P0_8 field.
	PINCONNECT_PINSEL0_P0_8_Msk       = 0x30000    // Bit mask of P0_8 field.
	PINCONNECT_PINSEL0_P0_8_GPIO_P0   = 0x0        // GPIO P0.8.
	PINCONNECT_PINSEL0_P0_8_I2STX_WS  = 0x1        // I2STX_WS
	PINCONNECT_PINSEL0_P0_8_MISO1     = 0x2        // MISO1
	PINCONNECT_PINSEL0_P0_8_MAT2      = 0x3        // MAT2.2
	PINCONNECT_PINSEL0_P0_9_Pos       = 0x12       // Position of P0_9 field.
	PINCONNECT_PINSEL0_P0_9_Msk       = 0xc0000    // Bit mask of P0_9 field.
	PINCONNECT_PINSEL0_P0_9_GPIO_P0   = 0x0        // GPIO P0.9
	PINCONNECT_PINSEL0_P0_9_I2STX_SDA = 0x1        // I2STX_SDA
	PINCONNECT_PINSEL0_P0_9_MOSI1     = 0x2        // MOSI1
	PINCONNECT_PINSEL0_P0_9_MAT2      = 0x3        // MAT2.3
	PINCONNECT_PINSEL0_P0_10_Pos      = 0x14       // Position of P0_10 field.
	PINCONNECT_PINSEL0_P0_10_Msk      = 0x300000   // Bit mask of P0_10 field.
	PINCONNECT_PINSEL0_P0_10_GPIO_P0  = 0x0        // GPIO P0.10
	PINCONNECT_PINSEL0_P0_10_TXD2     = 0x1        // TXD2
	PINCONNECT_PINSEL0_P0_10_SDA2     = 0x2        // SDA2
	PINCONNECT_PINSEL0_P0_10_MAT3     = 0x3        // MAT3.0
	PINCONNECT_PINSEL0_P0_11_Pos      = 0x16       // Position of P0_11 field.
	PINCONNECT_PINSEL0_P0_11_Msk      = 0xc00000   // Bit mask of P0_11 field.
	PINCONNECT_PINSEL0_P0_11_GPIO_P0  = 0x0        // GPIO P0.11
	PINCONNECT_PINSEL0_P0_11_RXD2     = 0x1        // RXD2
	PINCONNECT_PINSEL0_P0_11_SCL2     = 0x2        // SCL2
	PINCONNECT_PINSEL0_P0_11_MAT3     = 0x3        // MAT3.1
	PINCONNECT_PINSEL0_RESERVED_Pos   = 0x18       // Position of RESERVED field.
	PINCONNECT_PINSEL0_RESERVED_Msk   = 0x3f000000 // Bit mask of RESERVED field.
	PINCONNECT_PINSEL0_P0_15_Pos      = 0x1e       // Position of P0_15 field.
	PINCONNECT_PINSEL0_P0_15_Msk      = 0xc0000000 // Bit mask of P0_15 field.
	PINCONNECT_PINSEL0_P0_15_GPIO_P0  = 0x0        // GPIO P0.15
	PINCONNECT_PINSEL0_P0_15_TXD1     = 0x1        // TXD1
	PINCONNECT_PINSEL0_P0_15_SCK0     = 0x2        // SCK0
	PINCONNECT_PINSEL0_P0_15_SCK      = 0x3        // SCK

	// PINSEL1: Pin function select register 1.
	PINCONNECT_PINSEL1_P0_16_Pos         = 0x0        // Position of P0_16 field.
	PINCONNECT_PINSEL1_P0_16_Msk         = 0x3        // Bit mask of P0_16 field.
	PINCONNECT_PINSEL1_P0_16_GPIO_P0     = 0x0        // GPIO P0.16
	PINCONNECT_PINSEL1_P0_16_RXD1        = 0x1        // RXD1
	PINCONNECT_PINSEL1_P0_16_SSEL0       = 0x2        // SSEL0
	PINCONNECT_PINSEL1_P0_16_SSEL        = 0x3        // SSEL
	PINCONNECT_PINSEL1_P0_17_Pos         = 0x2        // Position of P0_17 field.
	PINCONNECT_PINSEL1_P0_17_Msk         = 0xc        // Bit mask of P0_17 field.
	PINCONNECT_PINSEL1_P0_17_GPIO_P0     = 0x0        // GPIO P0.17
	PINCONNECT_PINSEL1_P0_17_CTS1        = 0x1        // CTS1
	PINCONNECT_PINSEL1_P0_17_MISO0       = 0x2        // MISO0
	PINCONNECT_PINSEL1_P0_17_MISO        = 0x3        // MISO
	PINCONNECT_PINSEL1_P0_18_Pos         = 0x4        // Position of P0_18 field.
	PINCONNECT_PINSEL1_P0_18_Msk         = 0x30       // Bit mask of P0_18 field.
	PINCONNECT_PINSEL1_P0_18_GPIO_P0     = 0x0        // GPIO P0.18
	PINCONNECT_PINSEL1_P0_18_DCD1        = 0x1        // DCD1
	PINCONNECT_PINSEL1_P0_18_MOSI0       = 0x2        // MOSI0
	PINCONNECT_PINSEL1_P0_18_MOSI        = 0x3        // MOSI
	PINCONNECT_PINSEL1_P0_19_Pos         = 0x6        // Position of P0_19 field.
	PINCONNECT_PINSEL1_P0_19_Msk         = 0xc0       // Bit mask of P0_19 field.
	PINCONNECT_PINSEL1_P0_19_GPIO_P0     = 0x0        // GPIO P0.19.
	PINCONNECT_PINSEL1_P0_19_DSR1        = 0x1        // DSR1
	PINCONNECT_PINSEL1_P0_19_SDA1        = 0x3        // SDA1
	PINCONNECT_PINSEL1_P0_20_Pos         = 0x8        // Position of P0_20 field.
	PINCONNECT_PINSEL1_P0_20_Msk         = 0x300      // Bit mask of P0_20 field.
	PINCONNECT_PINSEL1_P0_20_GPIO_P0     = 0x0        // GPIO P0.20.
	PINCONNECT_PINSEL1_P0_20_DTR1        = 0x1        // DTR1
	PINCONNECT_PINSEL1_P0_20_SCL1        = 0x3        // SCL1
	PINCONNECT_PINSEL1_P0_21_Pos         = 0xa        // Position of P0_21 field.
	PINCONNECT_PINSEL1_P0_21_Msk         = 0xc00      // Bit mask of P0_21 field.
	PINCONNECT_PINSEL1_P0_21_GPIO_PORT_0 = 0x0        // GPIO Port 0.21.
	PINCONNECT_PINSEL1_P0_21_RI1         = 0x1        // RI1
	PINCONNECT_PINSEL1_P0_21_RD1         = 0x3        // RD1
	PINCONNECT_PINSEL1_P0_22_Pos         = 0xc        // Position of P0_22 field.
	PINCONNECT_PINSEL1_P0_22_Msk         = 0x3000     // Bit mask of P0_22 field.
	PINCONNECT_PINSEL1_P0_22_GPIO_P0     = 0x0        // GPIO P0.22.
	PINCONNECT_PINSEL1_P0_22_RTS1        = 0x1        // RTS1
	PINCONNECT_PINSEL1_P0_22_TD1         = 0x3        // TD1
	PINCONNECT_PINSEL1_P0_23_Pos         = 0xe        // Position of P0_23 field.
	PINCONNECT_PINSEL1_P0_23_Msk         = 0xc000     // Bit mask of P0_23 field.
	PINCONNECT_PINSEL1_P0_23_GPIO_P0     = 0x0        // GPIO P0.23.
	PINCONNECT_PINSEL1_P0_23_AD0         = 0x1        // AD0.0
	PINCONNECT_PINSEL1_P0_23_I2SRX_CLK   = 0x2        // I2SRX_CLK
	PINCONNECT_PINSEL1_P0_23_CAP3        = 0x3        // CAP3.0
	PINCONNECT_PINSEL1_P0_24_Pos         = 0x10       // Position of P0_24 field.
	PINCONNECT_PINSEL1_P0_24_Msk         = 0x30000    // Bit mask of P0_24 field.
	PINCONNECT_PINSEL1_P0_24_GPIO_P0     = 0x0        // GPIO P0.24.
	PINCONNECT_PINSEL1_P0_24_AD0         = 0x1        // AD0.1
	PINCONNECT_PINSEL1_P0_24_I2SRX_WS    = 0x2        // I2SRX_WS
	PINCONNECT_PINSEL1_P0_24_CAP3        = 0x3        // CAP3.1
	PINCONNECT_PINSEL1_P0_25_Pos         = 0x12       // Position of P0_25 field.
	PINCONNECT_PINSEL1_P0_25_Msk         = 0xc0000    // Bit mask of P0_25 field.
	PINCONNECT_PINSEL1_P0_25_GPIO_P0     = 0x0        // GPIO P0.25
	PINCONNECT_PINSEL1_P0_25_AD0         = 0x1        // AD0.2
	PINCONNECT_PINSEL1_P0_25_I2SRX_SDA   = 0x2        // I2SRX_SDA
	PINCONNECT_PINSEL1_P0_25_TXD3        = 0x3        // TXD3
	PINCONNECT_PINSEL1_P0_26_Pos         = 0x14       // Position of P0_26 field.
	PINCONNECT_PINSEL1_P0_26_Msk         = 0x300000   // Bit mask of P0_26 field.
	PINCONNECT_PINSEL1_P0_26_GPIO_P0     = 0x0        // GPIO P0.26
	PINCONNECT_PINSEL1_P0_26_AD0         = 0x1        // AD0.3
	PINCONNECT_PINSEL1_P0_26_AOUT        = 0x2        // AOUT
	PINCONNECT_PINSEL1_P0_26_RXD3        = 0x3        // RXD3
	PINCONNECT_PINSEL1_P0_27_Pos         = 0x16       // Position of P0_27 field.
	PINCONNECT_PINSEL1_P0_27_Msk         = 0xc00000   // Bit mask of P0_27 field.
	PINCONNECT_PINSEL1_P0_27_GPIO_P0     = 0x0        // GPIO P0.27
	PINCONNECT_PINSEL1_P0_27_SDA0        = 0x1        // SDA0
	PINCONNECT_PINSEL1_P0_27_USB_SDA     = 0x2        // USB_SDA
	PINCONNECT_PINSEL1_P0_28_Pos         = 0x18       // Position of P0_28 field.
	PINCONNECT_PINSEL1_P0_28_Msk         = 0x3000000  // Bit mask of P0_28 field.
	PINCONNECT_PINSEL1_P0_28_GPIO_P0     = 0x0        // GPIO P0.28
	PINCONNECT_PINSEL1_P0_28_SCL0        = 0x1        // SCL0
	PINCONNECT_PINSEL1_P0_28_USB_SCL     = 0x2        // USB_SCL
	PINCONNECT_PINSEL1_P0_29_Pos         = 0x1a       // Position of P0_29 field.
	PINCONNECT_PINSEL1_P0_29_Msk         = 0xc000000  // Bit mask of P0_29 field.
	PINCONNECT_PINSEL1_P0_29_GPIO_P0     = 0x0        // GPIO P0.29
	PINCONNECT_PINSEL1_P0_29_USB_DP      = 0x1        // USB_D+
	PINCONNECT_PINSEL1_P0_30_Pos         = 0x1c       // Position of P0_30 field.
	PINCONNECT_PINSEL1_P0_30_Msk         = 0x30000000 // Bit mask of P0_30 field.
	PINCONNECT_PINSEL1_P0_30_GPIO_P0     = 0x0        // GPIO P0.30
	PINCONNECT_PINSEL1_P0_30_USB_DM      = 0x1        // USB_D-
	PINCONNECT_PINSEL1_RESERVED_Pos      = 0x1e       // Position of RESERVED field.
	PINCONNECT_PINSEL1_RESERVED_Msk      = 0xc0000000 // Bit mask of RESERVED field.

	// PINSEL2: Pin function select register 2.
	PINCONNECT_PINSEL2_P1_0_Pos           = 0x0        // Position of P1_0 field.
	PINCONNECT_PINSEL2_P1_0_Msk           = 0x3        // Bit mask of P1_0 field.
	PINCONNECT_PINSEL2_P1_0_GPIO_P1       = 0x0        // GPIO P1.0
	PINCONNECT_PINSEL2_P1_0_ENET_TXD0     = 0x1        // ENET_TXD0
	PINCONNECT_PINSEL2_P1_1_Pos           = 0x2        // Position of P1_1 field.
	PINCONNECT_PINSEL2_P1_1_Msk           = 0xc        // Bit mask of P1_1 field.
	PINCONNECT_PINSEL2_P1_1_GPIO_P1       = 0x0        // GPIO P1.1
	PINCONNECT_PINSEL2_P1_1_ENET_TXD1     = 0x1        // ENET_TXD1
	PINCONNECT_PINSEL2_RESERVED_Pos       = 0x4        // Position of RESERVED field.
	PINCONNECT_PINSEL2_RESERVED_Msk       = 0xf0       // Bit mask of RESERVED field.
	PINCONNECT_PINSEL2_P1_4_Pos           = 0x8        // Position of P1_4 field.
	PINCONNECT_PINSEL2_P1_4_Msk           = 0x300      // Bit mask of P1_4 field.
	PINCONNECT_PINSEL2_P1_4_GPIO_P1       = 0x0        // GPIO P1.4.
	PINCONNECT_PINSEL2_P1_4_ENET_TX_EN    = 0x1        // ENET_TX_EN
	PINCONNECT_PINSEL2_RESERVED_Pos       = 0xa        // Position of RESERVED field.
	PINCONNECT_PINSEL2_RESERVED_Msk       = 0xfc00     // Bit mask of RESERVED field.
	PINCONNECT_PINSEL2_P1_8_Pos           = 0x10       // Position of P1_8 field.
	PINCONNECT_PINSEL2_P1_8_Msk           = 0x30000    // Bit mask of P1_8 field.
	PINCONNECT_PINSEL2_P1_8_GPIO_P1       = 0x0        // GPIO P1.8.
	PINCONNECT_PINSEL2_P1_8_ENET_CRS      = 0x1        // ENET_CRS
	PINCONNECT_PINSEL2_P1_9_Pos           = 0x12       // Position of P1_9 field.
	PINCONNECT_PINSEL2_P1_9_Msk           = 0xc0000    // Bit mask of P1_9 field.
	PINCONNECT_PINSEL2_P1_9_GPIO_PORT_1   = 0x0        // GPIO Port 1.9
	PINCONNECT_PINSEL2_P1_9_ENET_RXD0     = 0x1        // ENET_RXD0
	PINCONNECT_PINSEL2_P1_10_Pos          = 0x14       // Position of P1_10 field.
	PINCONNECT_PINSEL2_P1_10_Msk          = 0x300000   // Bit mask of P1_10 field.
	PINCONNECT_PINSEL2_P1_10_GPIO_P1      = 0x0        // GPIO P1.10
	PINCONNECT_PINSEL2_P1_10_ENET_RXD1    = 0x1        // ENET_RXD1
	PINCONNECT_PINSEL2_RESERVED_Pos       = 0x18       // Position of RESERVED field.
	PINCONNECT_PINSEL2_RESERVED_Msk       = 0x3f000000 // Bit mask of RESERVED field.
	PINCONNECT_PINSEL2_P1_14_Pos          = 0x16       // Position of P1_14 field.
	PINCONNECT_PINSEL2_P1_14_Msk          = 0xc00000   // Bit mask of P1_14 field.
	PINCONNECT_PINSEL2_P1_14_GPIO_P1      = 0x0        // GPIO P1.14
	PINCONNECT_PINSEL2_P1_14_ENET_RX_ER   = 0x1        // ENET_RX_ER
	PINCONNECT_PINSEL2_RESERVED_Pos       = 0x18       // Position of RESERVED field.
	PINCONNECT_PINSEL2_RESERVED_Msk       = 0x3f000000 // Bit mask of RESERVED field.
	PINCONNECT_PINSEL2_P1_15_Pos          = 0x1e       // Position of P1_15 field.
	PINCONNECT_PINSEL2_P1_15_Msk          = 0xc0000000 // Bit mask of P1_15 field.
	PINCONNECT_PINSEL2_P1_15_GPIO_P1      = 0x0        // GPIO P1.15
	PINCONNECT_PINSEL2_P1_15_ENET_REF_CLK = 0x1        // ENET_REF_CLK

	// PINSEL3: Pin function select register 3.
	PINCONNECT_PINSEL3_P1_16_Pos         = 0x0        // Position of P1_16 field.
	PINCONNECT_PINSEL3_P1_16_Msk         = 0x3        // Bit mask of P1_16 field.
	PINCONNECT_PINSEL3_P1_16_GPIO_P1     = 0x0        // GPIO P1.16
	PINCONNECT_PINSEL3_P1_16_ENET_MDC    = 0x1        // ENET_MDC
	PINCONNECT_PINSEL3_P1_17_Pos         = 0x2        // Position of P1_17 field.
	PINCONNECT_PINSEL3_P1_17_Msk         = 0xc        // Bit mask of P1_17 field.
	PINCONNECT_PINSEL3_P1_17_GPIO_P1     = 0x0        // GPIO P1.17
	PINCONNECT_PINSEL3_P1_17_ENET_MDIO   = 0x1        // ENET_MDIO
	PINCONNECT_PINSEL3_P1_18_Pos         = 0x4        // Position of P1_18 field.
	PINCONNECT_PINSEL3_P1_18_Msk         = 0x30       // Bit mask of P1_18 field.
	PINCONNECT_PINSEL3_P1_18_GPIO_P1     = 0x0        // GPIO P1.18
	PINCONNECT_PINSEL3_P1_18_USB_UP_LED  = 0x1        // USB_UP_LED
	PINCONNECT_PINSEL3_P1_18_PWM1        = 0x2        // PWM1.1
	PINCONNECT_PINSEL3_P1_18_CAP1        = 0x3        // CAP1.0
	PINCONNECT_PINSEL3_P1_19_Pos         = 0x6        // Position of P1_19 field.
	PINCONNECT_PINSEL3_P1_19_Msk         = 0xc0       // Bit mask of P1_19 field.
	PINCONNECT_PINSEL3_P1_19_GPIO_P1     = 0x0        // GPIO P1.19.
	PINCONNECT_PINSEL3_P1_19_MCOA0       = 0x1        // MCOA0
	PINCONNECT_PINSEL3_P1_19_USB_PPWR    = 0x2        // USB_PPWR
	PINCONNECT_PINSEL3_P1_19_CAP1        = 0x3        // CAP1.1
	PINCONNECT_PINSEL3_P1_20_Pos         = 0x8        // Position of P1_20 field.
	PINCONNECT_PINSEL3_P1_20_Msk         = 0x300      // Bit mask of P1_20 field.
	PINCONNECT_PINSEL3_P1_20_GPIO_P1     = 0x0        // GPIO P1.20.
	PINCONNECT_PINSEL3_P1_20_MCI0        = 0x1        // MCI0
	PINCONNECT_PINSEL3_P1_20_PWM1        = 0x2        // PWM1.2
	PINCONNECT_PINSEL3_P1_20_SCK0        = 0x3        // SCK0
	PINCONNECT_PINSEL3_P1_21_Pos         = 0xa        // Position of P1_21 field.
	PINCONNECT_PINSEL3_P1_21_Msk         = 0xc00      // Bit mask of P1_21 field.
	PINCONNECT_PINSEL3_P1_21_GPIO_P1     = 0x0        // GPIO P1.21.
	PINCONNECT_PINSEL3_P1_21_MCABORT     = 0x1        // MCABORT
	PINCONNECT_PINSEL3_P1_21_PWM1        = 0x2        // PWM1.3
	PINCONNECT_PINSEL3_P1_21_SSEL0       = 0x3        // SSEL0
	PINCONNECT_PINSEL3_P1_22_Pos         = 0xc        // Position of P1_22 field.
	PINCONNECT_PINSEL3_P1_22_Msk         = 0x3000     // Bit mask of P1_22 field.
	PINCONNECT_PINSEL3_P1_22_GPIO_P1     = 0x0        // GPIO P1.22.
	PINCONNECT_PINSEL3_P1_22_MCOB0       = 0x1        // MCOB0
	PINCONNECT_PINSEL3_P1_22_USB_PWRD    = 0x2        // USB_PWRD
	PINCONNECT_PINSEL3_P1_22_MAT1        = 0x3        // MAT1.0
	PINCONNECT_PINSEL3_P1_23_Pos         = 0xe        // Position of P1_23 field.
	PINCONNECT_PINSEL3_P1_23_Msk         = 0xc000     // Bit mask of P1_23 field.
	PINCONNECT_PINSEL3_P1_23_GPIO_P1     = 0x0        // GPIO P1.23.
	PINCONNECT_PINSEL3_P1_23_MCI1        = 0x1        // MCI1
	PINCONNECT_PINSEL3_P1_23_PWM1        = 0x2        // PWM1.4
	PINCONNECT_PINSEL3_P1_23_MISO0       = 0x3        // MISO0
	PINCONNECT_PINSEL3_P1_24_Pos         = 0x10       // Position of P1_24 field.
	PINCONNECT_PINSEL3_P1_24_Msk         = 0x30000    // Bit mask of P1_24 field.
	PINCONNECT_PINSEL3_P1_24_GPIO_P1     = 0x0        // GPIO P1.24.
	PINCONNECT_PINSEL3_P1_24_MCI2        = 0x1        // MCI2
	PINCONNECT_PINSEL3_P1_24_PWM1        = 0x2        // PWM1.5
	PINCONNECT_PINSEL3_P1_24_MOSI0       = 0x3        // MOSI0
	PINCONNECT_PINSEL3_P1_25_Pos         = 0x12       // Position of P1_25 field.
	PINCONNECT_PINSEL3_P1_25_Msk         = 0xc0000    // Bit mask of P1_25 field.
	PINCONNECT_PINSEL3_P1_25_GPIO_P1     = 0x0        // GPIO P1.25
	PINCONNECT_PINSEL3_P1_25_MCOA1       = 0x1        // MCOA1
	PINCONNECT_PINSEL3_P1_25_MAT1        = 0x3        // MAT1.1
	PINCONNECT_PINSEL3_P1_26_Pos         = 0x14       // Position of P1_26 field.
	PINCONNECT_PINSEL3_P1_26_Msk         = 0x300000   // Bit mask of P1_26 field.
	PINCONNECT_PINSEL3_P1_26_GPIO_P1     = 0x0        // GPIO P1.26
	PINCONNECT_PINSEL3_P1_26_MCOB1       = 0x1        // MCOB1
	PINCONNECT_PINSEL3_P1_26_PWM1        = 0x2        // PWM1.6
	PINCONNECT_PINSEL3_P1_26_CAP0        = 0x3        // CAP0.0
	PINCONNECT_PINSEL3_P1_27_Pos         = 0x16       // Position of P1_27 field.
	PINCONNECT_PINSEL3_P1_27_Msk         = 0xc00000   // Bit mask of P1_27 field.
	PINCONNECT_PINSEL3_P1_27_GPIO_P1     = 0x0        // GPIO P1.27
	PINCONNECT_PINSEL3_P1_27_CLKOUT      = 0x1        // CLKOUT
	PINCONNECT_PINSEL3_P1_27_USB_OVRCR   = 0x2        // USB_OVRCR
	PINCONNECT_PINSEL3_P1_27_CAP0        = 0x3        // CAP0.1
	PINCONNECT_PINSEL3_P1_28_Pos         = 0x18       // Position of P1_28 field.
	PINCONNECT_PINSEL3_P1_28_Msk         = 0x3000000  // Bit mask of P1_28 field.
	PINCONNECT_PINSEL3_P1_28_GPIO_P1     = 0x0        // GPIO P1.28
	PINCONNECT_PINSEL3_P1_28_MCOA2       = 0x1        // MCOA2
	PINCONNECT_PINSEL3_P1_28_PCAP1       = 0x2        // PCAP1.0
	PINCONNECT_PINSEL3_P1_28_MAT0        = 0x3        // MAT0.0
	PINCONNECT_PINSEL3_P1_29_Pos         = 0x1a       // Position of P1_29 field.
	PINCONNECT_PINSEL3_P1_29_Msk         = 0xc000000  // Bit mask of P1_29 field.
	PINCONNECT_PINSEL3_P1_29_GPIO_P1     = 0x0        // GPIO P1.29
	PINCONNECT_PINSEL3_P1_29_MCOB2       = 0x1        // MCOB2
	PINCONNECT_PINSEL3_P1_29_PCAP1       = 0x2        // PCAP1.1
	PINCONNECT_PINSEL3_P1_29_MAT0        = 0x3        // MAT0.1
	PINCONNECT_PINSEL3_P1_30_Pos         = 0x1c       // Position of P1_30 field.
	PINCONNECT_PINSEL3_P1_30_Msk         = 0x30000000 // Bit mask of P1_30 field.
	PINCONNECT_PINSEL3_P1_30_GPIO_P1     = 0x0        // GPIO P1.30
	PINCONNECT_PINSEL3_P1_30_VBUS        = 0x2        // VBUS
	PINCONNECT_PINSEL3_P1_30_AD0         = 0x3        // AD0.4
	PINCONNECT_PINSEL3_P1_31_Pos         = 0x1e       // Position of P1_31 field.
	PINCONNECT_PINSEL3_P1_31_Msk         = 0xc0000000 // Bit mask of P1_31 field.
	PINCONNECT_PINSEL3_P1_31_GPIO_PORT_1 = 0x0        // GPIO Port 1.31
	PINCONNECT_PINSEL3_P1_31_SCK1        = 0x2        // SCK1
	PINCONNECT_PINSEL3_P1_31_AD0         = 0x3        // AD0.5

	// PINSEL4: Pin function select register 4
	PINCONNECT_PINSEL4_P2_0_Pos         = 0x0        // Position of P2_0 field.
	PINCONNECT_PINSEL4_P2_0_Msk         = 0x3        // Bit mask of P2_0 field.
	PINCONNECT_PINSEL4_P2_0_GPIO_P2     = 0x0        // GPIO P2.0
	PINCONNECT_PINSEL4_P2_0_PWM1        = 0x1        // PWM1.1
	PINCONNECT_PINSEL4_P2_0_TXD1        = 0x2        // TXD1
	PINCONNECT_PINSEL4_P2_1_Pos         = 0x2        // Position of P2_1 field.
	PINCONNECT_PINSEL4_P2_1_Msk         = 0xc        // Bit mask of P2_1 field.
	PINCONNECT_PINSEL4_P2_1_GPIO_P2     = 0x0        // GPIO P2.1
	PINCONNECT_PINSEL4_P2_1_PWM1        = 0x1        // PWM1.2
	PINCONNECT_PINSEL4_P2_1_RXD1        = 0x2        // RXD1
	PINCONNECT_PINSEL4_P2_2_Pos         = 0x4        // Position of P2_2 field.
	PINCONNECT_PINSEL4_P2_2_Msk         = 0x30       // Bit mask of P2_2 field.
	PINCONNECT_PINSEL4_P2_2_GPIO_P2     = 0x0        // GPIO P2.2
	PINCONNECT_PINSEL4_P2_2_PWM1        = 0x1        // PWM1.3
	PINCONNECT_PINSEL4_P2_2_CTS1        = 0x2        // CTS1
	PINCONNECT_PINSEL4_P2_3_Pos         = 0x6        // Position of P2_3 field.
	PINCONNECT_PINSEL4_P2_3_Msk         = 0xc0       // Bit mask of P2_3 field.
	PINCONNECT_PINSEL4_P2_3_GPIO_P2     = 0x0        // GPIO P2.3.
	PINCONNECT_PINSEL4_P2_3_PWM1        = 0x1        // PWM1.4
	PINCONNECT_PINSEL4_P2_3_DCD1        = 0x2        // DCD1
	PINCONNECT_PINSEL4_P2_4_Pos         = 0x8        // Position of P2_4 field.
	PINCONNECT_PINSEL4_P2_4_Msk         = 0x300      // Bit mask of P2_4 field.
	PINCONNECT_PINSEL4_P2_4_GPIO_P2     = 0x0        // GPIO P2.4.
	PINCONNECT_PINSEL4_P2_4_PWM1        = 0x1        // PWM1.5
	PINCONNECT_PINSEL4_P2_4_DSR1        = 0x2        // DSR1
	PINCONNECT_PINSEL4_P2_5_Pos         = 0xa        // Position of P2_5 field.
	PINCONNECT_PINSEL4_P2_5_Msk         = 0xc00      // Bit mask of P2_5 field.
	PINCONNECT_PINSEL4_P2_5_GPIO_P2     = 0x0        // GPIO P2.5.
	PINCONNECT_PINSEL4_P2_5_PWM1        = 0x1        // PWM1.6
	PINCONNECT_PINSEL4_P2_5_DTR1        = 0x2        // DTR1
	PINCONNECT_PINSEL4_P2_6_Pos         = 0xc        // Position of P2_6 field.
	PINCONNECT_PINSEL4_P2_6_Msk         = 0x3000     // Bit mask of P2_6 field.
	PINCONNECT_PINSEL4_P2_6_GPIO_P2     = 0x0        // GPIO P2.6.
	PINCONNECT_PINSEL4_P2_6_PCAP1       = 0x1        // PCAP1.0
	PINCONNECT_PINSEL4_P2_6_RI1         = 0x2        // RI1
	PINCONNECT_PINSEL4_P2_7_Pos         = 0xe        // Position of P2_7 field.
	PINCONNECT_PINSEL4_P2_7_Msk         = 0xc000     // Bit mask of P2_7 field.
	PINCONNECT_PINSEL4_P2_7_GPIO_P2     = 0x0        // GPIO P2.7.
	PINCONNECT_PINSEL4_P2_7_RD2         = 0x1        // RD2
	PINCONNECT_PINSEL4_P2_7_RTS1        = 0x2        // RTS1
	PINCONNECT_PINSEL4_P2_8_Pos         = 0x10       // Position of P2_8 field.
	PINCONNECT_PINSEL4_P2_8_Msk         = 0x30000    // Bit mask of P2_8 field.
	PINCONNECT_PINSEL4_P2_8_GPIO_P2     = 0x0        // GPIO P2.8.
	PINCONNECT_PINSEL4_P2_8_TD2         = 0x1        // TD2
	PINCONNECT_PINSEL4_P2_8_TXD2        = 0x2        // TXD2
	PINCONNECT_PINSEL4_P2_8_ENET_MDC    = 0x3        // ENET_MDC
	PINCONNECT_PINSEL4_P2_9_Pos         = 0x12       // Position of P2_9 field.
	PINCONNECT_PINSEL4_P2_9_Msk         = 0xc0000    // Bit mask of P2_9 field.
	PINCONNECT_PINSEL4_P2_9_GPIO_P2     = 0x0        // GPIO P2.9
	PINCONNECT_PINSEL4_P2_9_USB_CONNECT = 0x1        // USB_CONNECT
	PINCONNECT_PINSEL4_P2_9_RXD2        = 0x2        // RXD2
	PINCONNECT_PINSEL4_P2_9_ENET_MDIO   = 0x3        // ENET_MDIO
	PINCONNECT_PINSEL4_P2_10_Pos        = 0x14       // Position of P2_10 field.
	PINCONNECT_PINSEL4_P2_10_Msk        = 0x300000   // Bit mask of P2_10 field.
	PINCONNECT_PINSEL4_P2_10_GPIO_P2    = 0x0        // GPIO P2.10
	PINCONNECT_PINSEL4_P2_10_EINT0      = 0x1        // EINT0
	PINCONNECT_PINSEL4_P2_10_NMI        = 0x2        // NMI
	PINCONNECT_PINSEL4_P2_11_Pos        = 0x16       // Position of P2_11 field.
	PINCONNECT_PINSEL4_P2_11_Msk        = 0xc00000   // Bit mask of P2_11 field.
	PINCONNECT_PINSEL4_P2_11_GPIO_P2    = 0x0        // GPIO P2.11
	PINCONNECT_PINSEL4_P2_11_EINT1      = 0x1        // EINT1
	PINCONNECT_PINSEL4_P2_11_I2STX_CLK  = 0x3        // I2STX_CLK
	PINCONNECT_PINSEL4_P2_12_Pos        = 0x18       // Position of P2_12 field.
	PINCONNECT_PINSEL4_P2_12_Msk        = 0x3000000  // Bit mask of P2_12 field.
	PINCONNECT_PINSEL4_P2_12_GPIO_P2    = 0x0        // GPIO P2.12
	PINCONNECT_PINSEL4_P2_12_EINT2      = 0x1        // EINT2
	PINCONNECT_PINSEL4_P2_12_I2STX_WS   = 0x3        // I2STX_WS
	PINCONNECT_PINSEL4_P2_13_Pos        = 0x1a       // Position of P2_13 field.
	PINCONNECT_PINSEL4_P2_13_Msk        = 0xc000000  // Bit mask of P2_13 field.
	PINCONNECT_PINSEL4_P2_13_GPIO_P2    = 0x0        // GPIO P2.13
	PINCONNECT_PINSEL4_P2_13_EINT3      = 0x1        // EINT3
	PINCONNECT_PINSEL4_P2_13_I2STX_SDA  = 0x3        // I2STX_SDA
	PINCONNECT_PINSEL4_RESERVED_Pos     = 0x1c       // Position of RESERVED field.
	PINCONNECT_PINSEL4_RESERVED_Msk     = 0xf0000000 // Bit mask of RESERVED field.

	// PINSEL7: Pin function select register 7
	PINCONNECT_PINSEL7_RESERVED_Pos  = 0x0        // Position of RESERVED field.
	PINCONNECT_PINSEL7_RESERVED_Msk  = 0x3ffff    // Bit mask of RESERVED field.
	PINCONNECT_PINSEL7_P3_25_Pos     = 0x12       // Position of P3_25 field.
	PINCONNECT_PINSEL7_P3_25_Msk     = 0xc0000    // Bit mask of P3_25 field.
	PINCONNECT_PINSEL7_P3_25_GPIO_P3 = 0x0        // GPIO P3.25
	PINCONNECT_PINSEL7_P3_25_MAT0    = 0x2        // MAT0.0
	PINCONNECT_PINSEL7_P3_25_PWM1    = 0x3        // PWM1.2
	PINCONNECT_PINSEL7_P3_26_Pos     = 0x14       // Position of P3_26 field.
	PINCONNECT_PINSEL7_P3_26_Msk     = 0x300000   // Bit mask of P3_26 field.
	PINCONNECT_PINSEL7_P3_26_GPIO_P3 = 0x0        // GPIO P3.26
	PINCONNECT_PINSEL7_P3_26_STCLK   = 0x1        // STCLK
	PINCONNECT_PINSEL7_P3_26_MAT0    = 0x2        // MAT0.1
	PINCONNECT_PINSEL7_P3_26_PWM1    = 0x3        // PWM1.3
	PINCONNECT_PINSEL7_RESERVED_Pos  = 0x16       // Position of RESERVED field.
	PINCONNECT_PINSEL7_RESERVED_Msk  = 0xffc00000 // Bit mask of RESERVED field.

	// PINSEL9: Pin function select register 9
	PINCONNECT_PINSEL9_RESERVED_Pos  = 0x0        // Position of RESERVED field.
	PINCONNECT_PINSEL9_RESERVED_Msk  = 0xffffff   // Bit mask of RESERVED field.
	PINCONNECT_PINSEL9_P4_28_Pos     = 0x18       // Position of P4_28 field.
	PINCONNECT_PINSEL9_P4_28_Msk     = 0x3000000  // Bit mask of P4_28 field.
	PINCONNECT_PINSEL9_P4_28_GPIO_P4 = 0x0        // GPIO P4.28
	PINCONNECT_PINSEL9_P4_28_RX_MCLK = 0x1        // RX_MCLK
	PINCONNECT_PINSEL9_P4_28_MAT2    = 0x2        // MAT2.0
	PINCONNECT_PINSEL9_P4_28_TXD3    = 0x3        // TXD3
	PINCONNECT_PINSEL9_P4_29_Pos     = 0x1a       // Position of P4_29 field.
	PINCONNECT_PINSEL9_P4_29_Msk     = 0xc000000  // Bit mask of P4_29 field.
	PINCONNECT_PINSEL9_P4_29_GPIO_P4 = 0x0        // GPIO P4.29
	PINCONNECT_PINSEL9_P4_29_TX_MCLK = 0x1        // TX_MCLK
	PINCONNECT_PINSEL9_P4_29_MAT2    = 0x2        // MAT2.1
	PINCONNECT_PINSEL9_P4_29_RXD3    = 0x3        // RXD3
	PINCONNECT_PINSEL9_RESERVED_Pos  = 0x1c       // Position of RESERVED field.
	PINCONNECT_PINSEL9_RESERVED_Msk  = 0xf0000000 // Bit mask of RESERVED field.

	// PINSEL10: Pin function select register 10
	PINCONNECT_PINSEL10_RESERVED_Pos      = 0x0        // Position of RESERVED field.
	PINCONNECT_PINSEL10_RESERVED_Msk      = 0x7        // Bit mask of RESERVED field.
	PINCONNECT_PINSEL10_TPIUCTRL_Pos      = 0x3        // Position of TPIUCTRL field.
	PINCONNECT_PINSEL10_TPIUCTRL_Msk      = 0x8        // Bit mask of TPIUCTRL field.
	PINCONNECT_PINSEL10_TPIUCTRL          = 0x8        // Bit TPIUCTRL.
	PINCONNECT_PINSEL10_TPIUCTRL_DISABLED = 0x0        // Disabled. TPIU interface is disabled.
	PINCONNECT_PINSEL10_TPIUCTRL_ENABLED  = 0x1        // Enabled. TPIU interface is enabled. TPIU signals are available on the pins hosting them regardless of the PINSEL4 content.
	PINCONNECT_PINSEL10_RESERVED_Pos      = 0x4        // Position of RESERVED field.
	PINCONNECT_PINSEL10_RESERVED_Msk      = 0xfffffff0 // Bit mask of RESERVED field.

	// PINMODE0: Pin mode select register 0
	PINCONNECT_PINMODE0_P0_00MODE_Pos        = 0x0        // Position of P0_00MODE field.
	PINCONNECT_PINMODE0_P0_00MODE_Msk        = 0x3        // Bit mask of P0_00MODE field.
	PINCONNECT_PINMODE0_P0_00MODE_PULL_UP    = 0x0        // Pull-up. P0.0 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_00MODE_REPEATER   = 0x1        // Repeater. P0.0 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_00MODE_DISABLED   = 0x2        // Disabled. P0.0 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_00MODE_PULL_DOWN  = 0x3        // Pull-down. P0.0 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_01MODE_Pos        = 0x2        // Position of P0_01MODE field.
	PINCONNECT_PINMODE0_P0_01MODE_Msk        = 0xc        // Bit mask of P0_01MODE field.
	PINCONNECT_PINMODE0_P0_01MODE_PULL_UP    = 0x0        // Pull-up. P0.1 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_01MODE_REPEATER   = 0x1        // Repeater. P0.1 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_01MODE_DISABLED   = 0x2        // Disabled. P0.1 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_01MODE_PULL_DOWN  = 0x3        // Pull-down. P0.1 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_02MODE_Pos        = 0x4        // Position of P0_02MODE field.
	PINCONNECT_PINMODE0_P0_02MODE_Msk        = 0x30       // Bit mask of P0_02MODE field.
	PINCONNECT_PINMODE0_P0_02MODE_PULL_UP    = 0x0        // Pull-up. P0.2 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_02MODE_REPEATER   = 0x1        // Repeater. P0.2 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_02MODE_DISABLED   = 0x2        // Disabled. P0.2 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_02MODE_PULL_DOWN  = 0x3        // Pull-down. P0.2 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_03MODE_Pos        = 0x6        // Position of P0_03MODE field.
	PINCONNECT_PINMODE0_P0_03MODE_Msk        = 0xc0       // Bit mask of P0_03MODE field.
	PINCONNECT_PINMODE0_P0_03MODE_PULL_UP    = 0x0        // Pull-up. P0.3 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_03MODE_REPEATER   = 0x1        // Repeater. P0.3 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_03MODE_DISABLED   = 0x2        // Disabled. P0.3 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_03MODE_PULL_DOWN  = 0x3        // Pull-down. P0.3 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_04MODE_Pos        = 0x8        // Position of P0_04MODE field.
	PINCONNECT_PINMODE0_P0_04MODE_Msk        = 0x300      // Bit mask of P0_04MODE field.
	PINCONNECT_PINMODE0_P0_04MODE_PULL_UP    = 0x0        // Pull-up. P0.4 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_04MODE_REPEATER   = 0x1        // Repeater. P0.4 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_04MODE_DISABLED   = 0x2        // Disabled. P0.4 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_04MODE_PULL_DOWN  = 0x3        // Pull-down. P0.4 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_05MODE_Pos        = 0xa        // Position of P0_05MODE field.
	PINCONNECT_PINMODE0_P0_05MODE_Msk        = 0xc00      // Bit mask of P0_05MODE field.
	PINCONNECT_PINMODE0_P0_05MODE_PULL_UP    = 0x0        // Pull-up. P0.5 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_05MODE_REPEATER   = 0x1        // Repeater. P0.5 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_05MODE_DISABLED   = 0x2        // Disabled. P0.5 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_05MODE_PULL_DOWN  = 0x3        // Pull-down. P0.5 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_06MODE_Pos        = 0xc        // Position of P0_06MODE field.
	PINCONNECT_PINMODE0_P0_06MODE_Msk        = 0x3000     // Bit mask of P0_06MODE field.
	PINCONNECT_PINMODE0_P0_06MODE_PULL_UP    = 0x0        // Pull-up. P0.6 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_06MODE_DISABLED_1 = 0x1        // Disabled. Repeater. P0.6 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_06MODE_DISABLED_2 = 0x2        // Disabled. P0.6 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_06MODE_PULL_DOWN  = 0x3        // Pull-down. P0.6 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_07MODE_Pos        = 0xe        // Position of P0_07MODE field.
	PINCONNECT_PINMODE0_P0_07MODE_Msk        = 0xc000     // Bit mask of P0_07MODE field.
	PINCONNECT_PINMODE0_P0_07MODE_PULL_UP    = 0x0        // Pull-up. P0.7 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_07MODE_REPEATER   = 0x1        // Repeater. P0.7 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_07MODE_DISABLED   = 0x2        // Disabled. P0.7 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_07MODE_PULL_DOWN  = 0x3        // Pull-down. P0.7 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_08MODE_Pos        = 0x10       // Position of P0_08MODE field.
	PINCONNECT_PINMODE0_P0_08MODE_Msk        = 0x30000    // Bit mask of P0_08MODE field.
	PINCONNECT_PINMODE0_P0_08MODE_PULL_UP    = 0x0        // Pull-up. P0.8 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_08MODE_REPEATER   = 0x1        // Repeater. P0.8 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_08MODE_DISABLED   = 0x2        // Disabled. P0.8 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_08MODE_PULL_DOWN  = 0x3        // Pull-down. P0.8 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_09MODE_Pos        = 0x12       // Position of P0_09MODE field.
	PINCONNECT_PINMODE0_P0_09MODE_Msk        = 0xc0000    // Bit mask of P0_09MODE field.
	PINCONNECT_PINMODE0_P0_09MODE_PULL_UP    = 0x0        // Pull-up. P0.9 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_09MODE_REPEATER   = 0x1        // Repeater. P0.9 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_09MODE_DISABLED   = 0x2        // Disabled. P0.9 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_09MODE_PULL_DOWN  = 0x3        // Pull-down. P0.9 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_10MODE_Pos        = 0x14       // Position of P0_10MODE field.
	PINCONNECT_PINMODE0_P0_10MODE_Msk        = 0x300000   // Bit mask of P0_10MODE field.
	PINCONNECT_PINMODE0_P0_10MODE_PULL_UP    = 0x0        // Pull-up. P0.10 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_10MODE_REPEATER   = 0x1        // Repeater. P0.10 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_10MODE_DISABLED   = 0x2        // Disabled. P0.10 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_10MODE_PULL_DOWN  = 0x3        // Pull-down. P0.10 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_P0_11MODE_Pos        = 0x16       // Position of P0_11MODE field.
	PINCONNECT_PINMODE0_P0_11MODE_Msk        = 0xc00000   // Bit mask of P0_11MODE field.
	PINCONNECT_PINMODE0_P0_11MODE_PULL_UP    = 0x0        // Pull-up. P0.11 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_11MODE_REPEATER   = 0x1        // Repeater. P0.11 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_11MODE_DISABLED   = 0x2        // Disabled. P0.11 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_11MODE_PULL_DOWN  = 0x3        // Pull-down. P0.11 has a pull-down resistor enabled.
	PINCONNECT_PINMODE0_RESERVED_Pos         = 0x18       // Position of RESERVED field.
	PINCONNECT_PINMODE0_RESERVED_Msk         = 0x3f000000 // Bit mask of RESERVED field.
	PINCONNECT_PINMODE0_P0_15MODE_Pos        = 0x1e       // Position of P0_15MODE field.
	PINCONNECT_PINMODE0_P0_15MODE_Msk        = 0xc0000000 // Bit mask of P0_15MODE field.
	PINCONNECT_PINMODE0_P0_15MODE_PULL_UP    = 0x0        // Pull-up. P0.15 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE0_P0_15MODE_REPEATER   = 0x1        // Repeater. P0.15 pin has repeater mode enabled.
	PINCONNECT_PINMODE0_P0_15MODE_DISABLED   = 0x2        // Disabled. P0.15 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE0_P0_15MODE_PULL_DOWN  = 0x3        // Pull-down. P0.15 has a pull-down resistor enabled.

	// PINMODE1: Pin mode select register 1
	PINCONNECT_PINMODE1_P0_16MODE_Pos       = 0x0        // Position of P0_16MODE field.
	PINCONNECT_PINMODE1_P0_16MODE_Msk       = 0x3        // Bit mask of P0_16MODE field.
	PINCONNECT_PINMODE1_P0_16MODE_PULL_UP   = 0x0        // Pull-up. P0.16 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_16MODE_REPEATER  = 0x1        // Repeater. P0.16 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_16MODE_DISABLED  = 0x2        // Disabled. P0.16 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_16MODE_PULL_DOWN = 0x3        // Pull-down. P0.16 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_17MODE_Pos       = 0x2        // Position of P0_17MODE field.
	PINCONNECT_PINMODE1_P0_17MODE_Msk       = 0xc        // Bit mask of P0_17MODE field.
	PINCONNECT_PINMODE1_P0_17MODE_PULL_UP   = 0x0        // Pull-up. P0.17 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_17MODE_REPEATER  = 0x1        // Repeater. P0.17 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_17MODE_DISABLED  = 0x2        // Disabled. P0.17 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_17MODE_PULL_DOWN = 0x3        // Pull-down. P0.17 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_18MODE_Pos       = 0x4        // Position of P0_18MODE field.
	PINCONNECT_PINMODE1_P0_18MODE_Msk       = 0x30       // Bit mask of P0_18MODE field.
	PINCONNECT_PINMODE1_P0_18MODE_PULL_UP   = 0x0        // Pull-up. P0.18 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_18MODE_REPEATER  = 0x1        // Repeater. P0.18 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_18MODE_DISABLED  = 0x2        // Disabled. P0.18 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_18MODE_PULL_DOWN = 0x3        // Pull-down. P0.18 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_19MODE_Pos       = 0x6        // Position of P0_19MODE field.
	PINCONNECT_PINMODE1_P0_19MODE_Msk       = 0xc0       // Bit mask of P0_19MODE field.
	PINCONNECT_PINMODE1_P0_19MODE_PULL_UP   = 0x0        // Pull-up. P0.19 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_19MODE_REPEATER  = 0x1        // Repeater. P0.19 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_19MODE_DISABLED  = 0x2        // Disabled. P0.19 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_19MODE_PULL_DOWN = 0x3        // Pull-down. P0.19 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_20MODE_Pos       = 0x8        // Position of P0_20MODE field.
	PINCONNECT_PINMODE1_P0_20MODE_Msk       = 0x300      // Bit mask of P0_20MODE field.
	PINCONNECT_PINMODE1_P0_20MODE_PULL_UP   = 0x0        // Pull-up. P0.20 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_20MODE_REPEATER  = 0x1        // Repeater. P0.20 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_20MODE_DISABLED  = 0x2        // Disabled. P0.20 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_20MODE_PULL_DOWN = 0x3        // Pull-down. P0.20 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_21MODE_Pos       = 0xa        // Position of P0_21MODE field.
	PINCONNECT_PINMODE1_P0_21MODE_Msk       = 0xc00      // Bit mask of P0_21MODE field.
	PINCONNECT_PINMODE1_P0_21MODE_PULL_UP   = 0x0        // Pull-up. P0.21 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_21MODE_REPEATER  = 0x1        // Repeater. P0.21 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_21MODE_DISABLED  = 0x2        // Disabled. P0.21 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_21MODE_PULL_DOWN = 0x3        // Pull-down. P0.21 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_22MODE_Pos       = 0xc        // Position of P0_22MODE field.
	PINCONNECT_PINMODE1_P0_22MODE_Msk       = 0x3000     // Bit mask of P0_22MODE field.
	PINCONNECT_PINMODE1_P0_22MODE_PULL_UP   = 0x0        // Pull-up. P0.22 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_22MODE_REPEATER  = 0x1        // Repeater. P0.22 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_22MODE_DISABLED  = 0x2        // Disabled. P0.22 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_22MODE_PULL_DOWN = 0x3        // Pull-down. P0.22 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_23MODE_Pos       = 0xe        // Position of P0_23MODE field.
	PINCONNECT_PINMODE1_P0_23MODE_Msk       = 0xc000     // Bit mask of P0_23MODE field.
	PINCONNECT_PINMODE1_P0_23MODE_PULL_UP   = 0x0        // Pull-up. P0.23 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_23MODE_REPEATER  = 0x1        // Repeater. P0.23 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_23MODE_DISABLED  = 0x2        // Disabled. P0.23 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_23MODE_PULL_DOWN = 0x3        // Pull-down. P0.23 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_24MODE_Pos       = 0x10       // Position of P0_24MODE field.
	PINCONNECT_PINMODE1_P0_24MODE_Msk       = 0x30000    // Bit mask of P0_24MODE field.
	PINCONNECT_PINMODE1_P0_24MODE_PULL_UP   = 0x0        // Pull-up. P0.24 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_24MODE_REPEATER  = 0x1        // Repeater. P0.24 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_24MODE_DISABLED  = 0x2        // Disabled. P0.24 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_24MODE_PULL_DOWN = 0x3        // Pull-down. P0.24 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_25MODE_Pos       = 0x12       // Position of P0_25MODE field.
	PINCONNECT_PINMODE1_P0_25MODE_Msk       = 0xc0000    // Bit mask of P0_25MODE field.
	PINCONNECT_PINMODE1_P0_25MODE_PULL_UP   = 0x0        // Pull-up. P0.25 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_25MODE_REPEATER  = 0x1        // Repeater. P0.25 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_25MODE_DISABLED  = 0x2        // Disabled. P0.25 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_25MODE_PULL_DOWN = 0x3        // Pull-down. P0.25 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_P0_26MODE_Pos       = 0x14       // Position of P0_26MODE field.
	PINCONNECT_PINMODE1_P0_26MODE_Msk       = 0x300000   // Bit mask of P0_26MODE field.
	PINCONNECT_PINMODE1_P0_26MODE_PULL_UP   = 0x0        // Pull-up. P0.26 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE1_P0_26MODE_REPEATER  = 0x1        // Repeater. P0.26 pin has repeater mode enabled.
	PINCONNECT_PINMODE1_P0_26MODE_DISABLED  = 0x2        // Disabled. P0.26 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE1_P0_26MODE_PULL_DOWN = 0x3        // Pull-down. P0.26 has a pull-down resistor enabled.
	PINCONNECT_PINMODE1_RESERVED_Pos        = 0x16       // Position of RESERVED field.
	PINCONNECT_PINMODE1_RESERVED_Msk        = 0x3fc00000 // Bit mask of RESERVED field.
	PINCONNECT_PINMODE1_RESERVED_Pos        = 0x1e       // Position of RESERVED field.
	PINCONNECT_PINMODE1_RESERVED_Msk        = 0xc0000000 // Bit mask of RESERVED field.

	// PINMODE2: Pin mode select register 2
	PINCONNECT_PINMODE2_P1_00MODE_Pos       = 0x0        // Position of P1_00MODE field.
	PINCONNECT_PINMODE2_P1_00MODE_Msk       = 0x3        // Bit mask of P1_00MODE field.
	PINCONNECT_PINMODE2_P1_00MODE_PULL_UP   = 0x0        // Pull-up. P1.0 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_00MODE_REPEATER  = 0x1        // Repeater. P1.0 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_00MODE_DISABLED  = 0x2        // Disabled. P1.0 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_00MODE_PULL_DOWN = 0x3        // Pull-down. P1.0 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_P1_01MODE_Pos       = 0x2        // Position of P1_01MODE field.
	PINCONNECT_PINMODE2_P1_01MODE_Msk       = 0xc        // Bit mask of P1_01MODE field.
	PINCONNECT_PINMODE2_P1_01MODE_PULL_UP   = 0x0        // Pull-up. P1.1 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_01MODE_REPEATER  = 0x1        // Repeater. P1.1 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_01MODE_DISABLED  = 0x2        // Disabled. P1.1 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_01MODE_PULL_DOWN = 0x3        // Pull-down. P1.1 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_RESERVED_Pos        = 0x4        // Position of RESERVED field.
	PINCONNECT_PINMODE2_RESERVED_Msk        = 0xf0       // Bit mask of RESERVED field.
	PINCONNECT_PINMODE2_P1_04MODE_Pos       = 0x8        // Position of P1_04MODE field.
	PINCONNECT_PINMODE2_P1_04MODE_Msk       = 0x300      // Bit mask of P1_04MODE field.
	PINCONNECT_PINMODE2_P1_04MODE_PULL_UP   = 0x0        // Pull-up. P1.4 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_04MODE_REPEATER  = 0x1        // Repeater. P1.4 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_04MODE_DISABLED  = 0x2        // Disabled. P1.4 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_04MODE_PULL_DOWN = 0x3        // Pull-down. P1.4 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_RESERVED_Pos        = 0xa        // Position of RESERVED field.
	PINCONNECT_PINMODE2_RESERVED_Msk        = 0xfc00     // Bit mask of RESERVED field.
	PINCONNECT_PINMODE2_P1_08MODE_Pos       = 0x10       // Position of P1_08MODE field.
	PINCONNECT_PINMODE2_P1_08MODE_Msk       = 0x30000    // Bit mask of P1_08MODE field.
	PINCONNECT_PINMODE2_P1_08MODE_PULL_UP   = 0x0        // Pull-up. P1.8 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_08MODE_REPEATER  = 0x1        // Repeater. P1.8 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_08MODE_DISABLED  = 0x2        // Disabled. P1.8 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_08MODE_PULL_DOWN = 0x3        // Pull-down. P1.8 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_P1_09MODE_Pos       = 0x12       // Position of P1_09MODE field.
	PINCONNECT_PINMODE2_P1_09MODE_Msk       = 0xc0000    // Bit mask of P1_09MODE field.
	PINCONNECT_PINMODE2_P1_09MODE_PULL_UP   = 0x0        // Pull-up. P1.9 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_09MODE_REPEATER  = 0x1        // Repeater. P1.9 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_09MODE_DISABLED  = 0x2        // Disabled. P1.9 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_09MODE_PULL_DOWN = 0x3        // Pull-down. P1.9 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_P1_10MODE_Pos       = 0x14       // Position of P1_10MODE field.
	PINCONNECT_PINMODE2_P1_10MODE_Msk       = 0x300000   // Bit mask of P1_10MODE field.
	PINCONNECT_PINMODE2_P1_10MODE_PULL_UP   = 0x0        // Pull-up. P1.10 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_10MODE_REPEATER  = 0x1        // Repeater. P1.10 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_10MODE_DISABLED  = 0x2        // Disabled. P1.10 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_10MODE_PULL_DOWN = 0x3        // Pull-down. P1.10 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_RESERVED_Pos        = 0x16       // Position of RESERVED field.
	PINCONNECT_PINMODE2_RESERVED_Msk        = 0xfc00000  // Bit mask of RESERVED field.
	PINCONNECT_PINMODE2_P1_14MODE_Pos       = 0x1c       // Position of P1_14MODE field.
	PINCONNECT_PINMODE2_P1_14MODE_Msk       = 0x30000000 // Bit mask of P1_14MODE field.
	PINCONNECT_PINMODE2_P1_14MODE_PULL_UP   = 0x0        // Pull-up. P1.14 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_14MODE_REPEATER  = 0x1        // Repeater. P1.14 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_14MODE_DISABLED  = 0x2        // Disabled. P1.14 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_14MODE_PULL_DOWN = 0x3        // Pull-down. P1.14 has a pull-down resistor enabled.
	PINCONNECT_PINMODE2_P1_15MODE_Pos       = 0x1e       // Position of P1_15MODE field.
	PINCONNECT_PINMODE2_P1_15MODE_Msk       = 0xc0000000 // Bit mask of P1_15MODE field.
	PINCONNECT_PINMODE2_P1_15MODE_PULL_UP   = 0x0        // Pull-up. P1.15 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE2_P1_15MODE_REPEATER  = 0x1        // Repeater. P1.15 pin has repeater mode enabled.
	PINCONNECT_PINMODE2_P1_15MODE_DISABLED  = 0x2        // Disabled. P1.15 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE2_P1_15MODE_PULL_DOWN = 0x3        // Pull-down. P1.15 has a pull-down resistor enabled.

	// PINMODE3: Pin mode select register 3.
	PINCONNECT_PINMODE3_P1_16MODE_Pos       = 0x0        // Position of P1_16MODE field.
	PINCONNECT_PINMODE3_P1_16MODE_Msk       = 0x3        // Bit mask of P1_16MODE field.
	PINCONNECT_PINMODE3_P1_16MODE_PULL_UP   = 0x0        // Pull-up. P1.16 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_16MODE_REPEATER  = 0x1        // Repeater. P1.16 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_16MODE_DISABLED  = 0x2        // Disabled. P1.16 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_16MODE_PULL_DOWN = 0x3        // Pull-down. P1.16 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_17MODE_Pos       = 0x2        // Position of P1_17MODE field.
	PINCONNECT_PINMODE3_P1_17MODE_Msk       = 0xc        // Bit mask of P1_17MODE field.
	PINCONNECT_PINMODE3_P1_17MODE_PULL_UP   = 0x0        // Pull-up. P1.17 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_17MODE_REPEATER  = 0x1        // Repeater. P1.17 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_17MODE_DISABLED  = 0x2        // Disabled. P1.17 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_17MODE_PULL_DOWN = 0x3        // Pull-down. P1.17 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_18MODE_Pos       = 0x4        // Position of P1_18MODE field.
	PINCONNECT_PINMODE3_P1_18MODE_Msk       = 0x30       // Bit mask of P1_18MODE field.
	PINCONNECT_PINMODE3_P1_18MODE_PULL_UP   = 0x0        // Pull-up. P1.18 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_18MODE_REPEATER  = 0x1        // Repeater. P1.18 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_18MODE_DISABLED  = 0x2        // Disabled. P1.18 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_18MODE_PULL_DOWN = 0x3        // Pull-down. P1.18 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_19MODE_Pos       = 0x6        // Position of P1_19MODE field.
	PINCONNECT_PINMODE3_P1_19MODE_Msk       = 0xc0       // Bit mask of P1_19MODE field.
	PINCONNECT_PINMODE3_P1_19MODE_PULL_UP   = 0x0        // Pull-up. P1.19 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_19MODE_REPEATER  = 0x1        // Repeater. P1.19 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_19MODE_DISABLED  = 0x2        // Disabled. P1.19 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_19MODE_PULL_DOWN = 0x3        // Pull-down. P1.19 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_20MODE_Pos       = 0x8        // Position of P1_20MODE field.
	PINCONNECT_PINMODE3_P1_20MODE_Msk       = 0x300      // Bit mask of P1_20MODE field.
	PINCONNECT_PINMODE3_P1_20MODE_PULL_UP   = 0x0        // Pull-up. P1.20 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_20MODE_REPEATER  = 0x1        // Repeater. P1.20 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_20MODE_DISABLED  = 0x2        // Disabled. P1.20 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_20MODE_PULL_DOWN = 0x3        // Pull-down. P1.20 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_21MODE_Pos       = 0xa        // Position of P1_21MODE field.
	PINCONNECT_PINMODE3_P1_21MODE_Msk       = 0xc00      // Bit mask of P1_21MODE field.
	PINCONNECT_PINMODE3_P1_21MODE_PULL_UP   = 0x0        // Pull-up. P1.21 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_21MODE_REPEATER  = 0x1        // Repeater. P1.21 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_21MODE_DISABLED  = 0x2        // Disabled. P1.21 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_21MODE_PULL_DOWN = 0x3        // Pull-down. P1.21 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_22MODE_Pos       = 0xc        // Position of P1_22MODE field.
	PINCONNECT_PINMODE3_P1_22MODE_Msk       = 0x3000     // Bit mask of P1_22MODE field.
	PINCONNECT_PINMODE3_P1_22MODE_PULL_UP   = 0x0        // Pull-up. P1.22 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_22MODE_REPEATER  = 0x1        // Repeater. P1.22 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_22MODE_DISABLED  = 0x2        // Disabled. P1.22 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_22MODE_PULL_DOWN = 0x3        // Pull-down. P1.22 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_23MODE_Pos       = 0xe        // Position of P1_23MODE field.
	PINCONNECT_PINMODE3_P1_23MODE_Msk       = 0xc000     // Bit mask of P1_23MODE field.
	PINCONNECT_PINMODE3_P1_23MODE_PULL_UP   = 0x0        // Pull-up. P1.23 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_23MODE_REPEATER  = 0x1        // Repeater. P1.23 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_23MODE_DISABLED  = 0x2        // Disabled. P1.23 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_23MODE_PULL_DOWN = 0x3        // Pull-down. P1.23 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_24MODE_Pos       = 0x10       // Position of P1_24MODE field.
	PINCONNECT_PINMODE3_P1_24MODE_Msk       = 0x30000    // Bit mask of P1_24MODE field.
	PINCONNECT_PINMODE3_P1_24MODE_PULL_UP   = 0x0        // Pull-up. P1.24 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_24MODE_REPEATER  = 0x1        // Repeater. P1.24 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_24MODE_DISABLED  = 0x2        // Disabled. P1.24 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_24MODE_PULL_DOWN = 0x3        // Pull-down. P1.24 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_25MODE_Pos       = 0x12       // Position of P1_25MODE field.
	PINCONNECT_PINMODE3_P1_25MODE_Msk       = 0xc0000    // Bit mask of P1_25MODE field.
	PINCONNECT_PINMODE3_P1_25MODE_PULL_UP   = 0x0        // Pull-up. P1.25 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_25MODE_REPEATER  = 0x1        // Repeater. P1.25 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_25MODE_DISABLED  = 0x2        // Disabled. P1.25 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_25MODE_PULL_DOWN = 0x3        // Pull-down. P1.25 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_26MODE_Pos       = 0x14       // Position of P1_26MODE field.
	PINCONNECT_PINMODE3_P1_26MODE_Msk       = 0x300000   // Bit mask of P1_26MODE field.
	PINCONNECT_PINMODE3_P1_26MODE_PULL_UP   = 0x0        // Pull-up. P1.26 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_26MODE_REPEATER  = 0x1        // Repeater. P1.26 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_26MODE_DISABLED  = 0x2        // Disabled. P1.26 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_26MODE_PULL_DOWN = 0x3        // Pull-down. P1.26 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_27MODE_Pos       = 0x16       // Position of P1_27MODE field.
	PINCONNECT_PINMODE3_P1_27MODE_Msk       = 0xc00000   // Bit mask of P1_27MODE field.
	PINCONNECT_PINMODE3_P1_27MODE_PULL_UP   = 0x0        // Pull-up. P1.27 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_27MODE_REPEATER  = 0x1        // Repeater. P1.27 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_27MODE_DISABLED  = 0x2        // Disabled. P1.27 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_27MODE_PULL_DOWN = 0x3        // Pull-down. P1.27 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_28MODE_Pos       = 0x18       // Position of P1_28MODE field.
	PINCONNECT_PINMODE3_P1_28MODE_Msk       = 0x3000000  // Bit mask of P1_28MODE field.
	PINCONNECT_PINMODE3_P1_28MODE_PULL_UP   = 0x0        // Pull-up. P1.28 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_28MODE_REPEATER  = 0x1        // Repeater. P1.28 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_28MODE_DISABLED  = 0x2        // Disabled. P1.28 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_28MODE_PULL_DOWN = 0x3        // Pull-down. P1.28 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_29MODE_Pos       = 0x1a       // Position of P1_29MODE field.
	PINCONNECT_PINMODE3_P1_29MODE_Msk       = 0xc000000  // Bit mask of P1_29MODE field.
	PINCONNECT_PINMODE3_P1_29MODE_PULL_UP   = 0x0        // Pull-up. P1.29 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_29MODE_REPEATER  = 0x1        // Repeater. P1.29 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_29MODE_DISABLED  = 0x2        // Disabled. P1.29 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_29MODE_PULL_DOWN = 0x3        // Pull-down. P1.29 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_30MODE_Pos       = 0x1c       // Position of P1_30MODE field.
	PINCONNECT_PINMODE3_P1_30MODE_Msk       = 0x30000000 // Bit mask of P1_30MODE field.
	PINCONNECT_PINMODE3_P1_30MODE_PULL_UP   = 0x0        // Pull-up. P1.30 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_30MODE_REPEATER  = 0x1        // Repeater. P1.30 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_30MODE_DISABLED  = 0x2        // Disabled. P1.30 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_30MODE_PULL_DOWN = 0x3        // Pull-down. P1.30 has a pull-down resistor enabled.
	PINCONNECT_PINMODE3_P1_31MODE_Pos       = 0x1e       // Position of P1_31MODE field.
	PINCONNECT_PINMODE3_P1_31MODE_Msk       = 0xc0000000 // Bit mask of P1_31MODE field.
	PINCONNECT_PINMODE3_P1_31MODE_PULL_UP   = 0x0        // Pull-up. P1.31 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE3_P1_31MODE_REPEATER  = 0x1        // Repeater. P1.31 pin has repeater mode enabled.
	PINCONNECT_PINMODE3_P1_31MODE_DISABLED  = 0x2        // Disabled. P1.31 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE3_P1_31MODE_PULL_DOWN = 0x3        // Pull-down. P1.31 has a pull-down resistor enabled.

	// PINMODE4: Pin mode select register 4
	PINCONNECT_PINMODE4_P2_00MODE_Pos       = 0x0        // Position of P2_00MODE field.
	PINCONNECT_PINMODE4_P2_00MODE_Msk       = 0x3        // Bit mask of P2_00MODE field.
	PINCONNECT_PINMODE4_P2_00MODE_PULL_UP   = 0x0        // Pull-up. P2.0 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_00MODE_REPEATER  = 0x1        // Repeater. P2.0 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_00MODE_DISABLED  = 0x2        // Disabled. P2.0 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_00MODE_PULL_DOWN = 0x3        // Pull-down. P2.0 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_01MODE_Pos       = 0x2        // Position of P2_01MODE field.
	PINCONNECT_PINMODE4_P2_01MODE_Msk       = 0xc        // Bit mask of P2_01MODE field.
	PINCONNECT_PINMODE4_P2_01MODE_PULL_UP   = 0x0        // Pull-up. P2.1 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_01MODE_REPEATER  = 0x1        // Repeater. P2.1 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_01MODE_DISABLED  = 0x2        // Disabled. P2.1 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_01MODE_PULL_DOWN = 0x3        // Pull-down. P2.1 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_02MODE_Pos       = 0x4        // Position of P2_02MODE field.
	PINCONNECT_PINMODE4_P2_02MODE_Msk       = 0x30       // Bit mask of P2_02MODE field.
	PINCONNECT_PINMODE4_P2_02MODE_PULL_UP   = 0x0        // Pull-up. P2.2 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_02MODE_REPEATER  = 0x1        // Repeater. P2.2 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_02MODE_DISABLED  = 0x2        // Disabled. P2.2 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_02MODE_PULL_DOWN = 0x3        // Pull-down. P2.2 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_03MODE_Pos       = 0x6        // Position of P2_03MODE field.
	PINCONNECT_PINMODE4_P2_03MODE_Msk       = 0xc0       // Bit mask of P2_03MODE field.
	PINCONNECT_PINMODE4_P2_03MODE_PULL_UP   = 0x0        // Pull-up. P2.3 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_03MODE_REPEATER  = 0x1        // Repeater. P2.3 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_03MODE_DISABLED  = 0x2        // Disabled. P2.3 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_03MODE_PULL_DOWN = 0x3        // Pull-down. P2.3 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_04MODE_Pos       = 0x8        // Position of P2_04MODE field.
	PINCONNECT_PINMODE4_P2_04MODE_Msk       = 0x300      // Bit mask of P2_04MODE field.
	PINCONNECT_PINMODE4_P2_04MODE_PULL_UP   = 0x0        // Pull-up. P2.4 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_04MODE_REPEATER  = 0x1        // Repeater. P2.4 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_04MODE_DISABLED  = 0x2        // Disabled. P2.4 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_04MODE_PULL_DOWN = 0x3        // Pull-down. P2.4 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_05MODE_Pos       = 0xa        // Position of P2_05MODE field.
	PINCONNECT_PINMODE4_P2_05MODE_Msk       = 0xc00      // Bit mask of P2_05MODE field.
	PINCONNECT_PINMODE4_P2_05MODE_PULL_UP   = 0x0        // Pull-up. P2.5 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_05MODE_REPEATER  = 0x1        // Repeater. P2.5 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_05MODE_DISABLED  = 0x2        // Disabled. P2.5 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_05MODE_PULL_DOWN = 0x3        // Pull-down. P2.5 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_06MODE_Pos       = 0xc        // Position of P2_06MODE field.
	PINCONNECT_PINMODE4_P2_06MODE_Msk       = 0x3000     // Bit mask of P2_06MODE field.
	PINCONNECT_PINMODE4_P2_06MODE_PULL_UP   = 0x0        // Pull-up. P2.6 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_06MODE_REPEATER  = 0x1        // Repeater. P2.6 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_06MODE_DISABLED  = 0x2        // Disabled. P2.6 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_06MODE_PULL_DOWN = 0x3        // Pull-down. P2.6 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_07MODE_Pos       = 0xe        // Position of P2_07MODE field.
	PINCONNECT_PINMODE4_P2_07MODE_Msk       = 0xc000     // Bit mask of P2_07MODE field.
	PINCONNECT_PINMODE4_P2_07MODE_PULL_UP   = 0x0        // Pull-up. P2.7 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_07MODE_REPEATER  = 0x1        // Repeater. P2.7 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_07MODE_DISABLED  = 0x2        // Disabled. P2.7 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_07MODE_PULL_DOWN = 0x3        // Pull-down. P2.7 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_08MODE_Pos       = 0x10       // Position of P2_08MODE field.
	PINCONNECT_PINMODE4_P2_08MODE_Msk       = 0x30000    // Bit mask of P2_08MODE field.
	PINCONNECT_PINMODE4_P2_08MODE_PULL_UP   = 0x0        // Pull-up. P2.8 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_08MODE_REPEATER  = 0x1        // Repeater. P2.8 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_08MODE_DISABLED  = 0x2        // Disabled. P2.8 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_08MODE_PULL_DOWN = 0x3        // Pull-down. P2.8 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_09MODE_Pos       = 0x12       // Position of P2_09MODE field.
	PINCONNECT_PINMODE4_P2_09MODE_Msk       = 0xc0000    // Bit mask of P2_09MODE field.
	PINCONNECT_PINMODE4_P2_09MODE_PULL_UP   = 0x0        // Pull-up. P2.9 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_09MODE_REPEATER  = 0x1        // Repeater. P2.9 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_09MODE_DISABLED  = 0x2        // Disabled. P2.9 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_09MODE_PULL_DOWN = 0x3        // Pull-down. P2.9 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_10MODE_Pos       = 0x14       // Position of P2_10MODE field.
	PINCONNECT_PINMODE4_P2_10MODE_Msk       = 0x300000   // Bit mask of P2_10MODE field.
	PINCONNECT_PINMODE4_P2_10MODE_PULL_UP   = 0x0        // Pull-up. P2.10 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_10MODE_REPEATER  = 0x1        // Repeater. P2.10 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_10MODE_DISABLED  = 0x2        // Disabled. P2.10 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_10MODE_PULL_DOWN = 0x3        // Pull-down. P2.10 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_11MODE_Pos       = 0x16       // Position of P2_11MODE field.
	PINCONNECT_PINMODE4_P2_11MODE_Msk       = 0xc00000   // Bit mask of P2_11MODE field.
	PINCONNECT_PINMODE4_P2_11MODE_PULL_UP   = 0x0        // Pull-up. P2.11 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_11MODE_REPEATER  = 0x1        // Repeater. P2.11 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_11MODE_DISABLED  = 0x2        // Disabled. P2.11 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_11MODE_PULL_DOWN = 0x3        // Pull-down. P2.11 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_12MODE_Pos       = 0x18       // Position of P2_12MODE field.
	PINCONNECT_PINMODE4_P2_12MODE_Msk       = 0x3000000  // Bit mask of P2_12MODE field.
	PINCONNECT_PINMODE4_P2_12MODE_PULL_UP   = 0x0        // Pull-up. P2.12 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_12MODE_REPEATER  = 0x1        // Repeater. P2.12 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_12MODE_DISABLED  = 0x2        // Disabled. P2.12 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_12MODE_PULL_DOWN = 0x3        // Pull-down. P2.12 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_P2_13MODE_Pos       = 0x1a       // Position of P2_13MODE field.
	PINCONNECT_PINMODE4_P2_13MODE_Msk       = 0xc000000  // Bit mask of P2_13MODE field.
	PINCONNECT_PINMODE4_P2_13MODE_PULL_UP   = 0x0        // Pull-up. P2.13 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE4_P2_13MODE_REPEATER  = 0x1        // Repeater. P2.13 pin has repeater mode enabled.
	PINCONNECT_PINMODE4_P2_13MODE_DISABLED  = 0x2        // Disabled. P2.13 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE4_P2_13MODE_PULL_DOWN = 0x3        // Pull-down. P2.13 has a pull-down resistor enabled.
	PINCONNECT_PINMODE4_RESERVED_Pos        = 0x1c       // Position of RESERVED field.
	PINCONNECT_PINMODE4_RESERVED_Msk        = 0xf0000000 // Bit mask of RESERVED field.

	// PINMODE7: Pin mode select register 7
	PINCONNECT_PINMODE7_RESERVED_Pos        = 0x0        // Position of RESERVED field.
	PINCONNECT_PINMODE7_RESERVED_Msk        = 0x3ffff    // Bit mask of RESERVED field.
	PINCONNECT_PINMODE7_P3_25MODE_Pos       = 0x12       // Position of P3_25MODE field.
	PINCONNECT_PINMODE7_P3_25MODE_Msk       = 0xc0000    // Bit mask of P3_25MODE field.
	PINCONNECT_PINMODE7_P3_25MODE_PULL_UP   = 0x0        // Pull-up. P3.25 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE7_P3_25MODE_REPEATER  = 0x1        // Repeater. P3.25 pin has repeater mode enabled.
	PINCONNECT_PINMODE7_P3_25MODE_DISABLED  = 0x2        // Disabled. P3.25 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE7_P3_25MODE_PULL_DOWN = 0x3        // Pull-down. P3.25 has a pull-down resistor enabled.
	PINCONNECT_PINMODE7_P3_26MODE_Pos       = 0x14       // Position of P3_26MODE field.
	PINCONNECT_PINMODE7_P3_26MODE_Msk       = 0x300000   // Bit mask of P3_26MODE field.
	PINCONNECT_PINMODE7_P3_26MODE_PULL_UP   = 0x0        // Pull-up. P3.26 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE7_P3_26MODE_REPEATER  = 0x1        // Repeater. P3.26 pin has repeater mode enabled.
	PINCONNECT_PINMODE7_P3_26MODE_DISABLED  = 0x2        // Disabled. P3.26 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE7_P3_26MODE_PULL_DOWN = 0x3        // Pull-down. P3.26 has a pull-down resistor enabled.
	PINCONNECT_PINMODE7_RESERVED_Pos        = 0x16       // Position of RESERVED field.
	PINCONNECT_PINMODE7_RESERVED_Msk        = 0xffc00000 // Bit mask of RESERVED field.

	// PINMODE9: Pin mode select register 9
	PINCONNECT_PINMODE9_RESERVED_Pos        = 0x0        // Position of RESERVED field.
	PINCONNECT_PINMODE9_RESERVED_Msk        = 0xffffff   // Bit mask of RESERVED field.
	PINCONNECT_PINMODE9_P4_28MODE_Pos       = 0x18       // Position of P4_28MODE field.
	PINCONNECT_PINMODE9_P4_28MODE_Msk       = 0x3000000  // Bit mask of P4_28MODE field.
	PINCONNECT_PINMODE9_P4_28MODE_PULL_UP   = 0x0        // Pull-up. P4.28 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE9_P4_28MODE_REPEATER  = 0x1        // Repeater. P4.28 pin has repeater mode enabled.
	PINCONNECT_PINMODE9_P4_28MODE_DISABLED  = 0x2        // Disabled. P4.28 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE9_P4_28MODE_PULL_DOWN = 0x3        // Pull-down. P4.28 has a pull-down resistor enabled.
	PINCONNECT_PINMODE9_P4_29MODE_Pos       = 0x1a       // Position of P4_29MODE field.
	PINCONNECT_PINMODE9_P4_29MODE_Msk       = 0xc000000  // Bit mask of P4_29MODE field.
	PINCONNECT_PINMODE9_P4_29MODE_PULL_UP   = 0x0        // Pull-up. P4.29 pin has a pull-up resistor enabled.
	PINCONNECT_PINMODE9_P4_29MODE_REPEATER  = 0x1        // Repeater. P4.29 pin has repeater mode enabled.
	PINCONNECT_PINMODE9_P4_29MODE_DISABLED  = 0x2        // Disabled. P4.29 pin has neither pull-up nor pull-down.
	PINCONNECT_PINMODE9_P4_29MODE_PULL_DOWN = 0x3        // Pull-down. P4.29 has a pull-down resistor enabled.
	PINCONNECT_PINMODE9_RESERVED_Pos        = 0x1c       // Position of RESERVED field.
	PINCONNECT_PINMODE9_RESERVED_Msk        = 0xf0000000 // Bit mask of RESERVED field.

	// PINMODE_OD0: Open drain mode control register 0
	PINCONNECT_PINMODE_OD0_P0_00OD_Pos        = 0x0        // Position of P0_00OD field.
	PINCONNECT_PINMODE_OD0_P0_00OD_Msk        = 0x1        // Bit mask of P0_00OD field.
	PINCONNECT_PINMODE_OD0_P0_00OD            = 0x1        // Bit P0_00OD.
	PINCONNECT_PINMODE_OD0_P0_00OD_NORMAL     = 0x0        // Normal. P0.0 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_00OD_OPEN_DRAIN = 0x1        // Open-drain. P0.0 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_01OD_Pos        = 0x1        // Position of P0_01OD field.
	PINCONNECT_PINMODE_OD0_P0_01OD_Msk        = 0x2        // Bit mask of P0_01OD field.
	PINCONNECT_PINMODE_OD0_P0_01OD            = 0x2        // Bit P0_01OD.
	PINCONNECT_PINMODE_OD0_P0_01OD_NORMAL     = 0x0        // Normal. P0.1 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_01OD_OPEN_DRAIN = 0x1        // Open-drain. P0.1 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_02OD_Pos        = 0x2        // Position of P0_02OD field.
	PINCONNECT_PINMODE_OD0_P0_02OD_Msk        = 0x4        // Bit mask of P0_02OD field.
	PINCONNECT_PINMODE_OD0_P0_02OD            = 0x4        // Bit P0_02OD.
	PINCONNECT_PINMODE_OD0_P0_02OD_NORMAL     = 0x0        // Normal. P0.2 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_02OD_OPEN_DRAIN = 0x1        // Open-drain. P0.2 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_03OD_Pos        = 0x3        // Position of P0_03OD field.
	PINCONNECT_PINMODE_OD0_P0_03OD_Msk        = 0x8        // Bit mask of P0_03OD field.
	PINCONNECT_PINMODE_OD0_P0_03OD            = 0x8        // Bit P0_03OD.
	PINCONNECT_PINMODE_OD0_P0_03OD_NORMAL     = 0x0        // Normal. P0.3 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_03OD_OPEN_DRAIN = 0x1        // Open-drain. P0.3 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_04OD_Pos        = 0x4        // Position of P0_04OD field.
	PINCONNECT_PINMODE_OD0_P0_04OD_Msk        = 0x10       // Bit mask of P0_04OD field.
	PINCONNECT_PINMODE_OD0_P0_04OD            = 0x10       // Bit P0_04OD.
	PINCONNECT_PINMODE_OD0_P0_04OD_NORMAL     = 0x0        // Normal. P0.4 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_04OD_OPEN_DRAIN = 0x1        // Open-drain. P0.4 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_05OD_Pos        = 0x5        // Position of P0_05OD field.
	PINCONNECT_PINMODE_OD0_P0_05OD_Msk        = 0x20       // Bit mask of P0_05OD field.
	PINCONNECT_PINMODE_OD0_P0_05OD            = 0x20       // Bit P0_05OD.
	PINCONNECT_PINMODE_OD0_P0_05OD_NORMAL     = 0x0        // Normal. P0.5 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_05OD_OPEN_DRAIN = 0x1        // Open-drain. P0.5 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_06OD_Pos        = 0x6        // Position of P0_06OD field.
	PINCONNECT_PINMODE_OD0_P0_06OD_Msk        = 0x40       // Bit mask of P0_06OD field.
	PINCONNECT_PINMODE_OD0_P0_06OD            = 0x40       // Bit P0_06OD.
	PINCONNECT_PINMODE_OD0_P0_06OD_NORMAL     = 0x0        // Normal. P0.6 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_06OD_OPEN_DRAIN = 0x1        // Open-drain. P0.6 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_07OD_Pos        = 0x7        // Position of P0_07OD field.
	PINCONNECT_PINMODE_OD0_P0_07OD_Msk        = 0x80       // Bit mask of P0_07OD field.
	PINCONNECT_PINMODE_OD0_P0_07OD            = 0x80       // Bit P0_07OD.
	PINCONNECT_PINMODE_OD0_P0_07OD_NORMAL     = 0x0        // Normal. P0.7 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_07OD_OPEN_DRAIN = 0x1        // Open-drain. P0.7 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_08OD_Pos        = 0x8        // Position of P0_08OD field.
	PINCONNECT_PINMODE_OD0_P0_08OD_Msk        = 0x100      // Bit mask of P0_08OD field.
	PINCONNECT_PINMODE_OD0_P0_08OD            = 0x100      // Bit P0_08OD.
	PINCONNECT_PINMODE_OD0_P0_08OD_NORMAL     = 0x0        // Normal. P0.8 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_08OD_OPEN_DRAIN = 0x1        // Open-drain. P0.8 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_09OD_Pos        = 0x9        // Position of P0_09OD field.
	PINCONNECT_PINMODE_OD0_P0_09OD_Msk        = 0x200      // Bit mask of P0_09OD field.
	PINCONNECT_PINMODE_OD0_P0_09OD            = 0x200      // Bit P0_09OD.
	PINCONNECT_PINMODE_OD0_P0_09OD_NORMAL     = 0x0        // Normal. P0.9 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_09OD_OPEN_DRAIN = 0x1        // Open-drain. P0.9 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_10OD_Pos        = 0xa        // Position of P0_10OD field.
	PINCONNECT_PINMODE_OD0_P0_10OD_Msk        = 0x400      // Bit mask of P0_10OD field.
	PINCONNECT_PINMODE_OD0_P0_10OD            = 0x400      // Bit P0_10OD.
	PINCONNECT_PINMODE_OD0_P0_10OD_NORMAL     = 0x0        // Normal. P0.10 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_10OD_OPEN_DRAIN = 0x1        // Open-drain. P0.10 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_11OD_Pos        = 0xb        // Position of P0_11OD field.
	PINCONNECT_PINMODE_OD0_P0_11OD_Msk        = 0x800      // Bit mask of P0_11OD field.
	PINCONNECT_PINMODE_OD0_P0_11OD            = 0x800      // Bit P0_11OD.
	PINCONNECT_PINMODE_OD0_P0_11OD_NORMAL     = 0x0        // Normal. P0.11 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_11OD_OPEN_DRAIN = 0x1        // Open-drain. P0.11 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_RESERVED_Pos       = 0xc        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD0_RESERVED_Msk       = 0x7000     // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD0_P0_15OD_Pos        = 0xf        // Position of P0_15OD field.
	PINCONNECT_PINMODE_OD0_P0_15OD_Msk        = 0x8000     // Bit mask of P0_15OD field.
	PINCONNECT_PINMODE_OD0_P0_15OD            = 0x8000     // Bit P0_15OD.
	PINCONNECT_PINMODE_OD0_P0_15OD_NORMAL     = 0x0        // Normal. P0.15 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_15OD_OPEN_DRAIN = 0x1        // Open-drain. P0.15 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_16OD_Pos        = 0x10       // Position of P0_16OD field.
	PINCONNECT_PINMODE_OD0_P0_16OD_Msk        = 0x10000    // Bit mask of P0_16OD field.
	PINCONNECT_PINMODE_OD0_P0_16OD            = 0x10000    // Bit P0_16OD.
	PINCONNECT_PINMODE_OD0_P0_16OD_NORMAL     = 0x0        // Normal. P0.16 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_16OD_OPEN_DRAIN = 0x1        // Open-drain. P0.16 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_17OD_Pos        = 0x11       // Position of P0_17OD field.
	PINCONNECT_PINMODE_OD0_P0_17OD_Msk        = 0x20000    // Bit mask of P0_17OD field.
	PINCONNECT_PINMODE_OD0_P0_17OD            = 0x20000    // Bit P0_17OD.
	PINCONNECT_PINMODE_OD0_P0_17OD_NORMAL     = 0x0        // Normal. P0.17 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_17OD_OPEN_DRAIN = 0x1        // Open-drain. P0.17 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_18OD_Pos        = 0x12       // Position of P0_18OD field.
	PINCONNECT_PINMODE_OD0_P0_18OD_Msk        = 0x40000    // Bit mask of P0_18OD field.
	PINCONNECT_PINMODE_OD0_P0_18OD            = 0x40000    // Bit P0_18OD.
	PINCONNECT_PINMODE_OD0_P0_18OD_NORMAL     = 0x0        // Normal. P0.18 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_18OD_OPEN_DRAIN = 0x1        // Open-drain. P0.18 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_19OD_Pos        = 0x13       // Position of P0_19OD field.
	PINCONNECT_PINMODE_OD0_P0_19OD_Msk        = 0x80000    // Bit mask of P0_19OD field.
	PINCONNECT_PINMODE_OD0_P0_19OD            = 0x80000    // Bit P0_19OD.
	PINCONNECT_PINMODE_OD0_P0_19OD_NORMAL     = 0x0        // Normal. P0.19 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_19OD_OPEN_DRAIN = 0x1        // Open-drain. P0.19 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_20OD_Pos        = 0x14       // Position of P0_20OD field.
	PINCONNECT_PINMODE_OD0_P0_20OD_Msk        = 0x100000   // Bit mask of P0_20OD field.
	PINCONNECT_PINMODE_OD0_P0_20OD            = 0x100000   // Bit P0_20OD.
	PINCONNECT_PINMODE_OD0_P0_20OD_NORMAL     = 0x0        // Normal. P0.20 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_20OD_OPEN_DRAIN = 0x1        // Open-drain. P0.20 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_21OD_Pos        = 0x15       // Position of P0_21OD field.
	PINCONNECT_PINMODE_OD0_P0_21OD_Msk        = 0x200000   // Bit mask of P0_21OD field.
	PINCONNECT_PINMODE_OD0_P0_21OD            = 0x200000   // Bit P0_21OD.
	PINCONNECT_PINMODE_OD0_P0_21OD_NORMAL     = 0x0        // Normal. P0.21 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_21OD_OPEN_DRAIN = 0x1        // Open-drain. P0.21 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_22OD_Pos        = 0x16       // Position of P0_22OD field.
	PINCONNECT_PINMODE_OD0_P0_22OD_Msk        = 0x400000   // Bit mask of P0_22OD field.
	PINCONNECT_PINMODE_OD0_P0_22OD            = 0x400000   // Bit P0_22OD.
	PINCONNECT_PINMODE_OD0_P0_22OD_NORMAL     = 0x0        // Normal. P0.22 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_22OD_OPEN_DRAIN = 0x1        // Open-drain. P0.22 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_23OD_Pos        = 0x17       // Position of P0_23OD field.
	PINCONNECT_PINMODE_OD0_P0_23OD_Msk        = 0x800000   // Bit mask of P0_23OD field.
	PINCONNECT_PINMODE_OD0_P0_23OD            = 0x800000   // Bit P0_23OD.
	PINCONNECT_PINMODE_OD0_P0_23OD_NORMAL     = 0x0        // Normal. P0.23 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_23OD_OPEN_DRAIN = 0x1        // Open-drain. P0.23 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_24OD_Pos        = 0x18       // Position of P0_24OD field.
	PINCONNECT_PINMODE_OD0_P0_24OD_Msk        = 0x1000000  // Bit mask of P0_24OD field.
	PINCONNECT_PINMODE_OD0_P0_24OD            = 0x1000000  // Bit P0_24OD.
	PINCONNECT_PINMODE_OD0_P0_24OD_NORMAL     = 0x0        // Normal. P0.23 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_24OD_OPEN_DRAIN = 0x1        // Open-drain. P0.23 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_25OD_Pos        = 0x19       // Position of P0_25OD field.
	PINCONNECT_PINMODE_OD0_P0_25OD_Msk        = 0x2000000  // Bit mask of P0_25OD field.
	PINCONNECT_PINMODE_OD0_P0_25OD            = 0x2000000  // Bit P0_25OD.
	PINCONNECT_PINMODE_OD0_P0_25OD_NORMAL     = 0x0        // Normal. P0.25 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_25OD_OPEN_DRAIN = 0x1        // Open-drain. P0.25 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_26OD_Pos        = 0x1a       // Position of P0_26OD field.
	PINCONNECT_PINMODE_OD0_P0_26OD_Msk        = 0x4000000  // Bit mask of P0_26OD field.
	PINCONNECT_PINMODE_OD0_P0_26OD            = 0x4000000  // Bit P0_26OD.
	PINCONNECT_PINMODE_OD0_P0_26OD_NORMAL     = 0x0        // Normal. P0.26 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_26OD_OPEN_DRAIN = 0x1        // Open-drain. P0.26 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_RESERVED_Pos       = 0x1b       // Position of RESERVED field.
	PINCONNECT_PINMODE_OD0_RESERVED_Msk       = 0x18000000 // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD0_P0_29OD_Pos        = 0x1d       // Position of P0_29OD field.
	PINCONNECT_PINMODE_OD0_P0_29OD_Msk        = 0x20000000 // Bit mask of P0_29OD field.
	PINCONNECT_PINMODE_OD0_P0_29OD            = 0x20000000 // Bit P0_29OD.
	PINCONNECT_PINMODE_OD0_P0_29OD_NORMAL     = 0x0        // Normal. P0.29 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_29OD_OPEN_DRAIN = 0x1        // Open-drain. P0.29 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_P0_30OD_Pos        = 0x1e       // Position of P0_30OD field.
	PINCONNECT_PINMODE_OD0_P0_30OD_Msk        = 0x40000000 // Bit mask of P0_30OD field.
	PINCONNECT_PINMODE_OD0_P0_30OD            = 0x40000000 // Bit P0_30OD.
	PINCONNECT_PINMODE_OD0_P0_30OD_NORMAL     = 0x0        // Normal. P0.30 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD0_P0_30OD_OPEN_DRAIN = 0x1        // Open-drain. P0.30 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD0_RESERVED_Pos       = 0x1f       // Position of RESERVED field.
	PINCONNECT_PINMODE_OD0_RESERVED_Msk       = 0x80000000 // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD0_RESERVED           = 0x80000000 // Bit RESERVED.

	// PINMODE_OD1: Open drain mode control register 1
	PINCONNECT_PINMODE_OD1_P1_00OD_Pos        = 0x0        // Position of P1_00OD field.
	PINCONNECT_PINMODE_OD1_P1_00OD_Msk        = 0x1        // Bit mask of P1_00OD field.
	PINCONNECT_PINMODE_OD1_P1_00OD            = 0x1        // Bit P1_00OD.
	PINCONNECT_PINMODE_OD1_P1_00OD_NORMAL     = 0x0        // Normal. P1.0 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_00OD_OPEN_DRAIN = 0x1        // Open-drain. P1.0 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_01OD_Pos        = 0x1        // Position of P1_01OD field.
	PINCONNECT_PINMODE_OD1_P1_01OD_Msk        = 0x2        // Bit mask of P1_01OD field.
	PINCONNECT_PINMODE_OD1_P1_01OD            = 0x2        // Bit P1_01OD.
	PINCONNECT_PINMODE_OD1_P1_01OD_NORMAL     = 0x0        // Normal. P1.1 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_01OD_OPEN_DRAIN = 0x1        // Open-drain. P1.1 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_RESERVED_Pos       = 0x2        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD1_RESERVED_Msk       = 0xc        // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD1_P1_04OD_Pos        = 0x4        // Position of P1_04OD field.
	PINCONNECT_PINMODE_OD1_P1_04OD_Msk        = 0x10       // Bit mask of P1_04OD field.
	PINCONNECT_PINMODE_OD1_P1_04OD            = 0x10       // Bit P1_04OD.
	PINCONNECT_PINMODE_OD1_P1_04OD_NORMAL     = 0x0        // Normal. P1.4 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_04OD_OPEN_DRAIN = 0x1        // Open-drain. P1.4 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_RESERVED_Pos       = 0x5        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD1_RESERVED_Msk       = 0xe0       // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD1_P1_08OD_Pos        = 0x8        // Position of P1_08OD field.
	PINCONNECT_PINMODE_OD1_P1_08OD_Msk        = 0x100      // Bit mask of P1_08OD field.
	PINCONNECT_PINMODE_OD1_P1_08OD            = 0x100      // Bit P1_08OD.
	PINCONNECT_PINMODE_OD1_P1_08OD_NORMAL     = 0x0        // Normal. P1.8 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_08OD_OPEN_DRAIN = 0x1        // Open-drain. P1.8 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_09OD_Pos        = 0x9        // Position of P1_09OD field.
	PINCONNECT_PINMODE_OD1_P1_09OD_Msk        = 0x200      // Bit mask of P1_09OD field.
	PINCONNECT_PINMODE_OD1_P1_09OD            = 0x200      // Bit P1_09OD.
	PINCONNECT_PINMODE_OD1_P1_09OD_NORMAL     = 0x0        // Normal. P1.9 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_09OD_OPEN_DRAIN = 0x1        // Open-drain. P1.9 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_10OD_Pos        = 0xa        // Position of P1_10OD field.
	PINCONNECT_PINMODE_OD1_P1_10OD_Msk        = 0x400      // Bit mask of P1_10OD field.
	PINCONNECT_PINMODE_OD1_P1_10OD            = 0x400      // Bit P1_10OD.
	PINCONNECT_PINMODE_OD1_P1_10OD_NORMAL     = 0x0        // Normal. P1.10 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_10OD_OPEN_DRAIN = 0x1        // Open-drain. P1.10 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_RESERVED_Pos       = 0xb        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD1_RESERVED_Msk       = 0x3800     // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD1_P1_14OD_Pos        = 0xe        // Position of P1_14OD field.
	PINCONNECT_PINMODE_OD1_P1_14OD_Msk        = 0x4000     // Bit mask of P1_14OD field.
	PINCONNECT_PINMODE_OD1_P1_14OD            = 0x4000     // Bit P1_14OD.
	PINCONNECT_PINMODE_OD1_P1_14OD_NORMAL     = 0x0        // Normal. P1.14 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_14OD_OPEN_DRAIN = 0x1        // Open-drain. P1.14 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_15OD_Pos        = 0xf        // Position of P1_15OD field.
	PINCONNECT_PINMODE_OD1_P1_15OD_Msk        = 0x8000     // Bit mask of P1_15OD field.
	PINCONNECT_PINMODE_OD1_P1_15OD            = 0x8000     // Bit P1_15OD.
	PINCONNECT_PINMODE_OD1_P1_15OD_NORMAL     = 0x0        // Normal. P1.15 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_15OD_OPEN_DRAIN = 0x1        // Open-drain. P1.15 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_16OD_Pos        = 0x10       // Position of P1_16OD field.
	PINCONNECT_PINMODE_OD1_P1_16OD_Msk        = 0x10000    // Bit mask of P1_16OD field.
	PINCONNECT_PINMODE_OD1_P1_16OD            = 0x10000    // Bit P1_16OD.
	PINCONNECT_PINMODE_OD1_P1_16OD_NORMAL     = 0x0        // Normal. P1.16 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_16OD_OPEN_DRAIN = 0x1        // Open-drain. P1.16 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_17OD_Pos        = 0x11       // Position of P1_17OD field.
	PINCONNECT_PINMODE_OD1_P1_17OD_Msk        = 0x20000    // Bit mask of P1_17OD field.
	PINCONNECT_PINMODE_OD1_P1_17OD            = 0x20000    // Bit P1_17OD.
	PINCONNECT_PINMODE_OD1_P1_17OD_NORMAL     = 0x0        // Normal. P1.17 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_17OD_OPEN_DRAIN = 0x1        // Open-drain. P1.17 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_18OD_Pos        = 0x12       // Position of P1_18OD field.
	PINCONNECT_PINMODE_OD1_P1_18OD_Msk        = 0x40000    // Bit mask of P1_18OD field.
	PINCONNECT_PINMODE_OD1_P1_18OD            = 0x40000    // Bit P1_18OD.
	PINCONNECT_PINMODE_OD1_P1_18OD_NORMAL     = 0x0        // Normal. P1.18 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_18OD_OPEN_DRAIN = 0x1        // Open-drain. P1.18 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_19OD_Pos        = 0x13       // Position of P1_19OD field.
	PINCONNECT_PINMODE_OD1_P1_19OD_Msk        = 0x80000    // Bit mask of P1_19OD field.
	PINCONNECT_PINMODE_OD1_P1_19OD            = 0x80000    // Bit P1_19OD.
	PINCONNECT_PINMODE_OD1_P1_19OD_NORMAL     = 0x0        // Normal. P1.19 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_19OD_OPEN_DRAIN = 0x1        // Open-drain. P1.19 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_20OD_Pos        = 0x14       // Position of P1_20OD field.
	PINCONNECT_PINMODE_OD1_P1_20OD_Msk        = 0x100000   // Bit mask of P1_20OD field.
	PINCONNECT_PINMODE_OD1_P1_20OD            = 0x100000   // Bit P1_20OD.
	PINCONNECT_PINMODE_OD1_P1_20OD_NORMAL     = 0x0        // Normal. P1.20 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_20OD_OPEN_DRAIN = 0x1        // Open-drain. P1.20 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_21OD_Pos        = 0x15       // Position of P1_21OD field.
	PINCONNECT_PINMODE_OD1_P1_21OD_Msk        = 0x200000   // Bit mask of P1_21OD field.
	PINCONNECT_PINMODE_OD1_P1_21OD            = 0x200000   // Bit P1_21OD.
	PINCONNECT_PINMODE_OD1_P1_21OD_NORMAL     = 0x0        // Normal. P1.21 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_21OD_OPEN_DRAIN = 0x1        // Open-drain. P1.21 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_22OD_Pos        = 0x16       // Position of P1_22OD field.
	PINCONNECT_PINMODE_OD1_P1_22OD_Msk        = 0x400000   // Bit mask of P1_22OD field.
	PINCONNECT_PINMODE_OD1_P1_22OD            = 0x400000   // Bit P1_22OD.
	PINCONNECT_PINMODE_OD1_P1_22OD_NORMAL     = 0x0        // Normal. P1.22 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_22OD_OPEN_DRAIN = 0x1        // Open-drain. P1.22 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_23OD_Pos        = 0x17       // Position of P1_23OD field.
	PINCONNECT_PINMODE_OD1_P1_23OD_Msk        = 0x800000   // Bit mask of P1_23OD field.
	PINCONNECT_PINMODE_OD1_P1_23OD            = 0x800000   // Bit P1_23OD.
	PINCONNECT_PINMODE_OD1_P1_23OD_NORMAL     = 0x0        // Normal. P1.23 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_23OD_OPEN_DRAIN = 0x1        // Open-drain. P1.23 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_24OD_Pos        = 0x18       // Position of P1_24OD field.
	PINCONNECT_PINMODE_OD1_P1_24OD_Msk        = 0x1000000  // Bit mask of P1_24OD field.
	PINCONNECT_PINMODE_OD1_P1_24OD            = 0x1000000  // Bit P1_24OD.
	PINCONNECT_PINMODE_OD1_P1_24OD_NORMAL     = 0x0        // Normal. P1.24 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_24OD_OPEN_DRAIN = 0x1        // Open-drain. P1.24 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_25OD_Pos        = 0x19       // Position of P1_25OD field.
	PINCONNECT_PINMODE_OD1_P1_25OD_Msk        = 0x2000000  // Bit mask of P1_25OD field.
	PINCONNECT_PINMODE_OD1_P1_25OD            = 0x2000000  // Bit P1_25OD.
	PINCONNECT_PINMODE_OD1_P1_25OD_NORMAL     = 0x0        // Normal. P1.25 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_25OD_OPEN_DRAIN = 0x1        // Open-drain. P1.25 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_26OD_Pos        = 0x1a       // Position of P1_26OD field.
	PINCONNECT_PINMODE_OD1_P1_26OD_Msk        = 0x4000000  // Bit mask of P1_26OD field.
	PINCONNECT_PINMODE_OD1_P1_26OD            = 0x4000000  // Bit P1_26OD.
	PINCONNECT_PINMODE_OD1_P1_26OD_NORMAL     = 0x0        // Normal. P1.26 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_26OD_OPEN_DRAIN = 0x1        // Open-drain. P1.26 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_27OD_Pos        = 0x1b       // Position of P1_27OD field.
	PINCONNECT_PINMODE_OD1_P1_27OD_Msk        = 0x8000000  // Bit mask of P1_27OD field.
	PINCONNECT_PINMODE_OD1_P1_27OD            = 0x8000000  // Bit P1_27OD.
	PINCONNECT_PINMODE_OD1_P1_27OD_NORMAL     = 0x0        // Normal. P1.27 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_27OD_OPEN_DRAIN = 0x1        // Open-drain. P1.27 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_28OD_Pos        = 0x1c       // Position of P1_28OD field.
	PINCONNECT_PINMODE_OD1_P1_28OD_Msk        = 0x10000000 // Bit mask of P1_28OD field.
	PINCONNECT_PINMODE_OD1_P1_28OD            = 0x10000000 // Bit P1_28OD.
	PINCONNECT_PINMODE_OD1_P1_28OD_NORMAL     = 0x0        // Normal. P1.28 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_28OD_OPEN_DRAIN = 0x1        // Open-drain. P1.28 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_29OD_Pos        = 0x1d       // Position of P1_29OD field.
	PINCONNECT_PINMODE_OD1_P1_29OD_Msk        = 0x20000000 // Bit mask of P1_29OD field.
	PINCONNECT_PINMODE_OD1_P1_29OD            = 0x20000000 // Bit P1_29OD.
	PINCONNECT_PINMODE_OD1_P1_29OD_NORMAL     = 0x0        // Normal. P1.29 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_29OD_OPEN_DRAIN = 0x1        // Open-drain. P1.29 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_30OD_Pos        = 0x1e       // Position of P1_30OD field.
	PINCONNECT_PINMODE_OD1_P1_30OD_Msk        = 0x40000000 // Bit mask of P1_30OD field.
	PINCONNECT_PINMODE_OD1_P1_30OD            = 0x40000000 // Bit P1_30OD.
	PINCONNECT_PINMODE_OD1_P1_30OD_NORMAL     = 0x0        // Normal. P1.30 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_30OD_OPEN_DRAIN = 0x1        // Open-drain. P1.30 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD1_P1_31OD_Pos        = 0x1f       // Position of P1_31OD field.
	PINCONNECT_PINMODE_OD1_P1_31OD_Msk        = 0x80000000 // Bit mask of P1_31OD field.
	PINCONNECT_PINMODE_OD1_P1_31OD            = 0x80000000 // Bit P1_31OD.
	PINCONNECT_PINMODE_OD1_P1_31OD_NORMAL     = 0x0        // Normal. P1.31 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD1_P1_31OD_OPEN_DRAIN = 0x1        // Open-drain. P1.31 pin is in the open drain mode.

	// PINMODE_OD2: Open drain mode control register 2
	PINCONNECT_PINMODE_OD2_P2_00OD_Pos        = 0x0        // Position of P2_00OD field.
	PINCONNECT_PINMODE_OD2_P2_00OD_Msk        = 0x1        // Bit mask of P2_00OD field.
	PINCONNECT_PINMODE_OD2_P2_00OD            = 0x1        // Bit P2_00OD.
	PINCONNECT_PINMODE_OD2_P2_00OD_NORMAL     = 0x0        // Normal. P2.0 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_00OD_OPEN_DRAIN = 0x1        // Open-drain. P2.0 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_01OD_Pos        = 0x1        // Position of P2_01OD field.
	PINCONNECT_PINMODE_OD2_P2_01OD_Msk        = 0x2        // Bit mask of P2_01OD field.
	PINCONNECT_PINMODE_OD2_P2_01OD            = 0x2        // Bit P2_01OD.
	PINCONNECT_PINMODE_OD2_P2_01OD_NORMAL     = 0x0        // Normal. P2.1 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_01OD_OPEN_DRAIN = 0x1        // Open-drain. P2.1p in is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_02OD_Pos        = 0x2        // Position of P2_02OD field.
	PINCONNECT_PINMODE_OD2_P2_02OD_Msk        = 0x4        // Bit mask of P2_02OD field.
	PINCONNECT_PINMODE_OD2_P2_02OD            = 0x4        // Bit P2_02OD.
	PINCONNECT_PINMODE_OD2_P2_02OD_NORMAL     = 0x0        // Normal. P2.2 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_02OD_OPEN_DRAIN = 0x1        // Open-drain. P2.2 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_03OD_Pos        = 0x3        // Position of P2_03OD field.
	PINCONNECT_PINMODE_OD2_P2_03OD_Msk        = 0x8        // Bit mask of P2_03OD field.
	PINCONNECT_PINMODE_OD2_P2_03OD            = 0x8        // Bit P2_03OD.
	PINCONNECT_PINMODE_OD2_P2_03OD_NORMAL     = 0x0        // Normal. P2.3 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_03OD_OPEN_DRAIN = 0x1        // Open-drain. P2.3 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_04OD_Pos        = 0x4        // Position of P2_04OD field.
	PINCONNECT_PINMODE_OD2_P2_04OD_Msk        = 0x10       // Bit mask of P2_04OD field.
	PINCONNECT_PINMODE_OD2_P2_04OD            = 0x10       // Bit P2_04OD.
	PINCONNECT_PINMODE_OD2_P2_04OD_NORMAL     = 0x0        // Normal. P2.4 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_04OD_OPEN_DRAIN = 0x1        // Open-drain. P2.4 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_05OD_Pos        = 0x5        // Position of P2_05OD field.
	PINCONNECT_PINMODE_OD2_P2_05OD_Msk        = 0x20       // Bit mask of P2_05OD field.
	PINCONNECT_PINMODE_OD2_P2_05OD            = 0x20       // Bit P2_05OD.
	PINCONNECT_PINMODE_OD2_P2_05OD_NORMAL     = 0x0        // Normal. P2.5 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_05OD_OPEN_DRAIN = 0x1        // Open-drain. P2.5 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_06OD_Pos        = 0x6        // Position of P2_06OD field.
	PINCONNECT_PINMODE_OD2_P2_06OD_Msk        = 0x40       // Bit mask of P2_06OD field.
	PINCONNECT_PINMODE_OD2_P2_06OD            = 0x40       // Bit P2_06OD.
	PINCONNECT_PINMODE_OD2_P2_06OD_NORMAL     = 0x0        // Normal. P2.6 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_06OD_OPEN_DRAIN = 0x1        // Open-drain. P2.6 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_07OD_Pos        = 0x7        // Position of P2_07OD field.
	PINCONNECT_PINMODE_OD2_P2_07OD_Msk        = 0x80       // Bit mask of P2_07OD field.
	PINCONNECT_PINMODE_OD2_P2_07OD            = 0x80       // Bit P2_07OD.
	PINCONNECT_PINMODE_OD2_P2_07OD_NORMAL     = 0x0        // Normal. P2.7 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_07OD_OPEN_DRAIN = 0x1        // Open-drain. P2.7 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_08OD_Pos        = 0x8        // Position of P2_08OD field.
	PINCONNECT_PINMODE_OD2_P2_08OD_Msk        = 0x100      // Bit mask of P2_08OD field.
	PINCONNECT_PINMODE_OD2_P2_08OD            = 0x100      // Bit P2_08OD.
	PINCONNECT_PINMODE_OD2_P2_08OD_NORMAL     = 0x0        // Normal. P2.8 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_08OD_OPEN_DRAIN = 0x1        // Open-drain. P2.8 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_09OD_Pos        = 0x9        // Position of P2_09OD field.
	PINCONNECT_PINMODE_OD2_P2_09OD_Msk        = 0x200      // Bit mask of P2_09OD field.
	PINCONNECT_PINMODE_OD2_P2_09OD            = 0x200      // Bit P2_09OD.
	PINCONNECT_PINMODE_OD2_P2_09OD_NORMAL     = 0x0        // Normal. P2.9 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_09OD_OPEN_DRAIN = 0x1        // Open-drain. P2.9 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_10OD_Pos        = 0xa        // Position of P2_10OD field.
	PINCONNECT_PINMODE_OD2_P2_10OD_Msk        = 0x400      // Bit mask of P2_10OD field.
	PINCONNECT_PINMODE_OD2_P2_10OD            = 0x400      // Bit P2_10OD.
	PINCONNECT_PINMODE_OD2_P2_10OD_NORMAL     = 0x0        // Normal. P2.10 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_10OD_OPEN_DRAIN = 0x1        // Open-drain. P2.10 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_11OD_Pos        = 0xb        // Position of P2_11OD field.
	PINCONNECT_PINMODE_OD2_P2_11OD_Msk        = 0x800      // Bit mask of P2_11OD field.
	PINCONNECT_PINMODE_OD2_P2_11OD            = 0x800      // Bit P2_11OD.
	PINCONNECT_PINMODE_OD2_P2_11OD_NORMAL     = 0x0        // Normal. P2.11 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_11OD_OPEN_DRAIN = 0x1        // Open-drain. P2.11 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_12OD_Pos        = 0xc        // Position of P2_12OD field.
	PINCONNECT_PINMODE_OD2_P2_12OD_Msk        = 0x1000     // Bit mask of P2_12OD field.
	PINCONNECT_PINMODE_OD2_P2_12OD            = 0x1000     // Bit P2_12OD.
	PINCONNECT_PINMODE_OD2_P2_12OD_NORMAL     = 0x0        // Normal. P2.12 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_12OD_OPEN_DRAIN = 0x1        // Open-drain. P2.12 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_P2_13OD_Pos        = 0xd        // Position of P2_13OD field.
	PINCONNECT_PINMODE_OD2_P2_13OD_Msk        = 0x2000     // Bit mask of P2_13OD field.
	PINCONNECT_PINMODE_OD2_P2_13OD            = 0x2000     // Bit P2_13OD.
	PINCONNECT_PINMODE_OD2_P2_13OD_NORMAL     = 0x0        // Normal. P2.13 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD2_P2_13OD_OPEN_DRAIN = 0x1        // Open-drain. P2.13 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD2_RESERVED_Pos       = 0xe        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD2_RESERVED_Msk       = 0xffffc000 // Bit mask of RESERVED field.

	// PINMODE_OD3: Open drain mode control register 3
	PINCONNECT_PINMODE_OD3_RESERVED_Pos       = 0x0        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD3_RESERVED_Msk       = 0x1ffffff  // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD3_P3_25OD_Pos        = 0x19       // Position of P3_25OD field.
	PINCONNECT_PINMODE_OD3_P3_25OD_Msk        = 0x2000000  // Bit mask of P3_25OD field.
	PINCONNECT_PINMODE_OD3_P3_25OD            = 0x2000000  // Bit P3_25OD.
	PINCONNECT_PINMODE_OD3_P3_25OD_NORMAL     = 0x0        // Normal. P3.25 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD3_P3_25OD_OPEN_DRAIN = 0x1        // Open-drain. P3.25 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD3_P3_26OD_Pos        = 0x1a       // Position of P3_26OD field.
	PINCONNECT_PINMODE_OD3_P3_26OD_Msk        = 0x4000000  // Bit mask of P3_26OD field.
	PINCONNECT_PINMODE_OD3_P3_26OD            = 0x4000000  // Bit P3_26OD.
	PINCONNECT_PINMODE_OD3_RESERVED_Pos       = 0x1b       // Position of RESERVED field.
	PINCONNECT_PINMODE_OD3_RESERVED_Msk       = 0xf8000000 // Bit mask of RESERVED field.

	// PINMODE_OD4: Open drain mode control register 4
	PINCONNECT_PINMODE_OD4_RESERVED_Pos       = 0x0        // Position of RESERVED field.
	PINCONNECT_PINMODE_OD4_RESERVED_Msk       = 0xfffffff  // Bit mask of RESERVED field.
	PINCONNECT_PINMODE_OD4_P4_28OD_Pos        = 0x1c       // Position of P4_28OD field.
	PINCONNECT_PINMODE_OD4_P4_28OD_Msk        = 0x10000000 // Bit mask of P4_28OD field.
	PINCONNECT_PINMODE_OD4_P4_28OD            = 0x10000000 // Bit P4_28OD.
	PINCONNECT_PINMODE_OD4_P4_28OD_NORMAL     = 0x0        // Normal. P4.28 pin is in the normal (not open drain) mode.
	PINCONNECT_PINMODE_OD4_P4_28OD_OPEN_DRAIN = 0x1        // Open-drain. P4.28 pin is in the open drain mode.
	PINCONNECT_PINMODE_OD4_P4_29OD_Pos        = 0x1d       // Position of P4_29OD field.
	PINCONNECT_PINMODE_OD4_P4_29OD_Msk        = 0x20000000 // Bit mask of P4_29OD field.
	PINCONNECT_PINMODE_OD4_P4_29OD            = 0x20000000 // Bit P4_29OD.
	PINCONNECT_PINMODE_OD4_RESERVED_Pos       = 0x1e       // Position of RESERVED field.
	PINCONNECT_PINMODE_OD4_RESERVED_Msk       = 0xc0000000 // Bit mask of RESERVED field.

	// I2CPADCFG: I2C Pin Configuration register
	PINCONNECT_I2CPADCFG_SDADRV0_Pos            = 0x0        // Position of SDADRV0 field.
	PINCONNECT_I2CPADCFG_SDADRV0_Msk            = 0x1        // Bit mask of SDADRV0 field.
	PINCONNECT_I2CPADCFG_SDADRV0                = 0x1        // Bit SDADRV0.
	PINCONNECT_I2CPADCFG_SDADRV0_STANDARD       = 0x0        // Standard. The SDA0 pin is in the standard drive mode.
	PINCONNECT_I2CPADCFG_SDADRV0_FAST_MODE_PLUS = 0x1        // Fast-mode plus. The SDA0 pin is in Fast Mode Plus drive mode.
	PINCONNECT_I2CPADCFG_SDAI2C0_Pos            = 0x1        // Position of SDAI2C0 field.
	PINCONNECT_I2CPADCFG_SDAI2C0_Msk            = 0x2        // Bit mask of SDAI2C0 field.
	PINCONNECT_I2CPADCFG_SDAI2C0                = 0x2        // Bit SDAI2C0.
	PINCONNECT_I2CPADCFG_SDAI2C0_ENABLED        = 0x0        // Enabled. The SDA0 pin has I2C glitch filtering and slew rate control enabled.
	PINCONNECT_I2CPADCFG_SDAI2C0_DISABLED       = 0x1        // Disabled. The SDA0 pin has I2C glitch filtering and slew rate control disabled.
	PINCONNECT_I2CPADCFG_SCLDRV0_Pos            = 0x2        // Position of SCLDRV0 field.
	PINCONNECT_I2CPADCFG_SCLDRV0_Msk            = 0x4        // Bit mask of SCLDRV0 field.
	PINCONNECT_I2CPADCFG_SCLDRV0                = 0x4        // Bit SCLDRV0.
	PINCONNECT_I2CPADCFG_SCLDRV0_STANDARD       = 0x0        // Standard. The SCL0 pin is in the standard drive mode.
	PINCONNECT_I2CPADCFG_SCLDRV0_FAST_MODE_PLUS = 0x1        // Fast-mode plus. The SCL0 pin is in Fast Mode Plus drive mode.
	PINCONNECT_I2CPADCFG_SCLI2C0_Pos            = 0x3        // Position of SCLI2C0 field.
	PINCONNECT_I2CPADCFG_SCLI2C0_Msk            = 0x8        // Bit mask of SCLI2C0 field.
	PINCONNECT_I2CPADCFG_SCLI2C0                = 0x8        // Bit SCLI2C0.
	PINCONNECT_I2CPADCFG_SCLI2C0_ENABLED        = 0x0        // Enabled. The SCL0 pin has I2C glitch filtering and slew rate control enabled.
	PINCONNECT_I2CPADCFG_SCLI2C0_DISABLED       = 0x1        // Disabled. The SCL0 pin has I2C glitch filtering and slew rate control disabled.
	PINCONNECT_I2CPADCFG_RESERVED_Pos           = 0x4        // Position of RESERVED field.
	PINCONNECT_I2CPADCFG_RESERVED_Msk           = 0xfffffff0 // Bit mask of RESERVED field.
)

// Bitfields for SSP1: SSP1 controller
const (
	// CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
	SSP1_CR0_DSS_Pos                  = 0x0        // Position of DSS field.
	SSP1_CR0_DSS_Msk                  = 0xf        // Bit mask of DSS field.
	SSP1_CR0_DSS_4_BIT_TRANSFER       = 0x3        // 4-bit transfer
	SSP1_CR0_DSS_5_BIT_TRANSFER       = 0x4        // 5-bit transfer
	SSP1_CR0_DSS_6_BIT_TRANSFER       = 0x5        // 6-bit transfer
	SSP1_CR0_DSS_7_BIT_TRANSFER       = 0x6        // 7-bit transfer
	SSP1_CR0_DSS_8_BIT_TRANSFER       = 0x7        // 8-bit transfer
	SSP1_CR0_DSS_9_BIT_TRANSFER       = 0x8        // 9-bit transfer
	SSP1_CR0_DSS_10_BIT_TRANSFER      = 0x9        // 10-bit transfer
	SSP1_CR0_DSS_11_BIT_TRANSFER      = 0xa        // 11-bit transfer
	SSP1_CR0_DSS_12_BIT_TRANSFER      = 0xb        // 12-bit transfer
	SSP1_CR0_DSS_13_BIT_TRANSFER      = 0xc        // 13-bit transfer
	SSP1_CR0_DSS_14_BIT_TRANSFER      = 0xd        // 14-bit transfer
	SSP1_CR0_DSS_15_BIT_TRANSFER      = 0xe        // 15-bit transfer
	SSP1_CR0_DSS_16_BIT_TRANSFER      = 0xf        // 16-bit transfer
	SSP1_CR0_FRF_Pos                  = 0x4        // Position of FRF field.
	SSP1_CR0_FRF_Msk                  = 0x30       // Bit mask of FRF field.
	SSP1_CR0_FRF_SPI                  = 0x0        // SPI
	SSP1_CR0_FRF_TI                   = 0x1        // TI
	SSP1_CR0_FRF_MICROWIRE            = 0x2        // Microwire
	SSP1_CR0_FRF_THIS_COMBINATION_IS_ = 0x3        // This combination is not supported and should not be used.
	SSP1_CR0_CPOL_Pos                 = 0x6        // Position of CPOL field.
	SSP1_CR0_CPOL_Msk                 = 0x40       // Bit mask of CPOL field.
	SSP1_CR0_CPOL                     = 0x40       // Bit CPOL.
	SSP1_CR0_CPOL_BUS_LOW             = 0x0        // SSP controller maintains the bus clock low between frames.
	SSP1_CR0_CPOL_BUS_HIGH            = 0x1        // SSP controller maintains the bus clock high between frames.
	SSP1_CR0_CPHA_Pos                 = 0x7        // Position of CPHA field.
	SSP1_CR0_CPHA_Msk                 = 0x80       // Bit mask of CPHA field.
	SSP1_CR0_CPHA                     = 0x80       // Bit CPHA.
	SSP1_CR0_CPHA_FIRST_CLOCK         = 0x0        // SSP controller captures serial data on the first clock transition of the frame, that is, the transition away from the inter-frame state of the clock line.
	SSP1_CR0_CPHA_SECOND_CLOCK        = 0x1        // SSP controller captures serial data on the second clock transition of the frame, that is, the transition back to the inter-frame state of the clock line.
	SSP1_CR0_SCR_Pos                  = 0x8        // Position of SCR field.
	SSP1_CR0_SCR_Msk                  = 0xff00     // Bit mask of SCR field.
	SSP1_CR0_RESERVED_Pos             = 0x10       // Position of RESERVED field.
	SSP1_CR0_RESERVED_Msk             = 0xffff0000 // Bit mask of RESERVED field.

	// CR1: Control Register 1. Selects master/slave and other modes.
	SSP1_CR1_LBM_Pos      = 0x0        // Position of LBM field.
	SSP1_CR1_LBM_Msk      = 0x1        // Bit mask of LBM field.
	SSP1_CR1_LBM          = 0x1        // Bit LBM.
	SSP1_CR1_LBM_NORMAL   = 0x0        // During normal operation.
	SSP1_CR1_LBM_OUPTU    = 0x1        // Serial input is taken from the serial output (MOSI or MISO) rather than the serial input pin (MISO or MOSI respectively).
	SSP1_CR1_SSE_Pos      = 0x1        // Position of SSE field.
	SSP1_CR1_SSE_Msk      = 0x2        // Bit mask of SSE field.
	SSP1_CR1_SSE          = 0x2        // Bit SSE.
	SSP1_CR1_SSE_DISABLED = 0x0        // The SSP controller is disabled.
	SSP1_CR1_SSE_ENABLED  = 0x1        // The SSP controller will interact with other devices on the serial bus. Software should write the appropriate control information to the other SSP registers and interrupt controller registers, before setting this bit.
	SSP1_CR1_MS_Pos       = 0x2        // Position of MS field.
	SSP1_CR1_MS_Msk       = 0x4        // Bit mask of MS field.
	SSP1_CR1_MS           = 0x4        // Bit MS.
	SSP1_CR1_MS_MASTER    = 0x0        // The SSP controller acts as a master on the bus, driving the SCLK, MOSI, and SSEL lines and receiving the MISO line.
	SSP1_CR1_MS_SLAVE     = 0x1        // The SSP controller acts as a slave on the bus, driving MISO line and receiving SCLK, MOSI, and SSEL lines.
	SSP1_CR1_SOD_Pos      = 0x3        // Position of SOD field.
	SSP1_CR1_SOD_Msk      = 0x8        // Bit mask of SOD field.
	SSP1_CR1_SOD          = 0x8        // Bit SOD.
	SSP1_CR1_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SSP1_CR1_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
	SSP1_DR_DATA_Pos     = 0x0        // Position of DATA field.
	SSP1_DR_DATA_Msk     = 0xffff     // Bit mask of DATA field.
	SSP1_DR_RESERVED_Pos = 0x10       // Position of RESERVED field.
	SSP1_DR_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// SR: Status Register
	SSP1_SR_TFE_Pos      = 0x0        // Position of TFE field.
	SSP1_SR_TFE_Msk      = 0x1        // Bit mask of TFE field.
	SSP1_SR_TFE          = 0x1        // Bit TFE.
	SSP1_SR_TNF_Pos      = 0x1        // Position of TNF field.
	SSP1_SR_TNF_Msk      = 0x2        // Bit mask of TNF field.
	SSP1_SR_TNF          = 0x2        // Bit TNF.
	SSP1_SR_RNE_Pos      = 0x2        // Position of RNE field.
	SSP1_SR_RNE_Msk      = 0x4        // Bit mask of RNE field.
	SSP1_SR_RNE          = 0x4        // Bit RNE.
	SSP1_SR_RFF_Pos      = 0x3        // Position of RFF field.
	SSP1_SR_RFF_Msk      = 0x8        // Bit mask of RFF field.
	SSP1_SR_RFF          = 0x8        // Bit RFF.
	SSP1_SR_BSY_Pos      = 0x4        // Position of BSY field.
	SSP1_SR_BSY_Msk      = 0x10       // Bit mask of BSY field.
	SSP1_SR_BSY          = 0x10       // Bit BSY.
	SSP1_SR_RESERVED_Pos = 0x5        // Position of RESERVED field.
	SSP1_SR_RESERVED_Msk = 0xffffffe0 // Bit mask of RESERVED field.

	// CPSR: Clock Prescale Register
	SSP1_CPSR_CPSDVSR_Pos  = 0x0        // Position of CPSDVSR field.
	SSP1_CPSR_CPSDVSR_Msk  = 0xff       // Bit mask of CPSDVSR field.
	SSP1_CPSR_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SSP1_CPSR_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// IMSC: Interrupt Mask Set and Clear Register
	SSP1_IMSC_RORIM_Pos    = 0x0        // Position of RORIM field.
	SSP1_IMSC_RORIM_Msk    = 0x1        // Bit mask of RORIM field.
	SSP1_IMSC_RORIM        = 0x1        // Bit RORIM.
	SSP1_IMSC_RTIM_Pos     = 0x1        // Position of RTIM field.
	SSP1_IMSC_RTIM_Msk     = 0x2        // Bit mask of RTIM field.
	SSP1_IMSC_RTIM         = 0x2        // Bit RTIM.
	SSP1_IMSC_RXIM_Pos     = 0x2        // Position of RXIM field.
	SSP1_IMSC_RXIM_Msk     = 0x4        // Bit mask of RXIM field.
	SSP1_IMSC_RXIM         = 0x4        // Bit RXIM.
	SSP1_IMSC_TXIM_Pos     = 0x3        // Position of TXIM field.
	SSP1_IMSC_TXIM_Msk     = 0x8        // Bit mask of TXIM field.
	SSP1_IMSC_TXIM         = 0x8        // Bit TXIM.
	SSP1_IMSC_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SSP1_IMSC_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// RIS: Raw Interrupt Status Register
	SSP1_RIS_RORRIS_Pos   = 0x0        // Position of RORRIS field.
	SSP1_RIS_RORRIS_Msk   = 0x1        // Bit mask of RORRIS field.
	SSP1_RIS_RORRIS       = 0x1        // Bit RORRIS.
	SSP1_RIS_RTRIS_Pos    = 0x1        // Position of RTRIS field.
	SSP1_RIS_RTRIS_Msk    = 0x2        // Bit mask of RTRIS field.
	SSP1_RIS_RTRIS        = 0x2        // Bit RTRIS.
	SSP1_RIS_RXRIS_Pos    = 0x2        // Position of RXRIS field.
	SSP1_RIS_RXRIS_Msk    = 0x4        // Bit mask of RXRIS field.
	SSP1_RIS_RXRIS        = 0x4        // Bit RXRIS.
	SSP1_RIS_TXRIS_Pos    = 0x3        // Position of TXRIS field.
	SSP1_RIS_TXRIS_Msk    = 0x8        // Bit mask of TXRIS field.
	SSP1_RIS_TXRIS        = 0x8        // Bit TXRIS.
	SSP1_RIS_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SSP1_RIS_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// MIS: Masked Interrupt Status Register
	SSP1_MIS_RORMIS_Pos   = 0x0        // Position of RORMIS field.
	SSP1_MIS_RORMIS_Msk   = 0x1        // Bit mask of RORMIS field.
	SSP1_MIS_RORMIS       = 0x1        // Bit RORMIS.
	SSP1_MIS_RTMIS_Pos    = 0x1        // Position of RTMIS field.
	SSP1_MIS_RTMIS_Msk    = 0x2        // Bit mask of RTMIS field.
	SSP1_MIS_RTMIS        = 0x2        // Bit RTMIS.
	SSP1_MIS_RXMIS_Pos    = 0x2        // Position of RXMIS field.
	SSP1_MIS_RXMIS_Msk    = 0x4        // Bit mask of RXMIS field.
	SSP1_MIS_RXMIS        = 0x4        // Bit RXMIS.
	SSP1_MIS_TXMIS_Pos    = 0x3        // Position of TXMIS field.
	SSP1_MIS_TXMIS_Msk    = 0x8        // Bit mask of TXMIS field.
	SSP1_MIS_TXMIS        = 0x8        // Bit TXMIS.
	SSP1_MIS_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SSP1_MIS_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// ICR: SSPICR Interrupt Clear Register
	SSP1_ICR_RORIC_Pos    = 0x0        // Position of RORIC field.
	SSP1_ICR_RORIC_Msk    = 0x1        // Bit mask of RORIC field.
	SSP1_ICR_RORIC        = 0x1        // Bit RORIC.
	SSP1_ICR_RTIC_Pos     = 0x1        // Position of RTIC field.
	SSP1_ICR_RTIC_Msk     = 0x2        // Bit mask of RTIC field.
	SSP1_ICR_RTIC         = 0x2        // Bit RTIC.
	SSP1_ICR_RESERVED_Pos = 0x2        // Position of RESERVED field.
	SSP1_ICR_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// DMACR: SSP0 DMA control register
	SSP1_DMACR_RXDMAE_Pos   = 0x0        // Position of RXDMAE field.
	SSP1_DMACR_RXDMAE_Msk   = 0x1        // Bit mask of RXDMAE field.
	SSP1_DMACR_RXDMAE       = 0x1        // Bit RXDMAE.
	SSP1_DMACR_TXDMAE_Pos   = 0x1        // Position of TXDMAE field.
	SSP1_DMACR_TXDMAE_Msk   = 0x2        // Bit mask of TXDMAE field.
	SSP1_DMACR_TXDMAE       = 0x2        // Bit TXDMAE.
	SSP1_DMACR_RESERVED_Pos = 0x2        // Position of RESERVED field.
	SSP1_DMACR_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.
)

// Bitfields for ADC: Analog-to-Digital Converter (ADC)
const (
	// CR: A/D Control Register. The ADCR register must be written to select the operating mode before A/D conversion can occur.
	ADC_CR_SEL_Pos                    = 0x0        // Position of SEL field.
	ADC_CR_SEL_Msk                    = 0xff       // Bit mask of SEL field.
	ADC_CR_CLKDIV_Pos                 = 0x8        // Position of CLKDIV field.
	ADC_CR_CLKDIV_Msk                 = 0xff00     // Bit mask of CLKDIV field.
	ADC_CR_BURST_Pos                  = 0x10       // Position of BURST field.
	ADC_CR_BURST_Msk                  = 0x10000    // Bit mask of BURST field.
	ADC_CR_BURST                      = 0x10000    // Bit BURST.
	ADC_CR_BURST_BURST                = 0x1        // The AD converter does repeated conversions at up to 400 kHz, scanning (if necessary) through the pins selected by bits set to ones in the SEL field. The first conversion after the start corresponds to the least-significant 1 in the SEL field, then higher numbered 1-bits (pins) if applicable. Repeated conversions can be terminated by clearing this bit, but the conversion that's in progress when this bit is cleared will be completed. START bits must be 000 when BURST = 1 or conversions will not start.
	ADC_CR_BURST_SW                   = 0x0        // Conversions are software controlled and require 31 clocks.
	ADC_CR_RESERVED_Pos               = 0x11       // Position of RESERVED field.
	ADC_CR_RESERVED_Msk               = 0x1e0000   // Bit mask of RESERVED field.
	ADC_CR_PDN_Pos                    = 0x15       // Position of PDN field.
	ADC_CR_PDN_Msk                    = 0x200000   // Bit mask of PDN field.
	ADC_CR_PDN                        = 0x200000   // Bit PDN.
	ADC_CR_PDN_POWERED                = 0x1        // The A/D converter is operational.
	ADC_CR_PDN_POWERDOWN              = 0x0        // The A/D converter is in power-down mode.
	ADC_CR_RESERVED_Pos               = 0x16       // Position of RESERVED field.
	ADC_CR_RESERVED_Msk               = 0xc00000   // Bit mask of RESERVED field.
	ADC_CR_START_Pos                  = 0x18       // Position of START field.
	ADC_CR_START_Msk                  = 0x7000000  // Bit mask of START field.
	ADC_CR_START_NO_START_THIS_VALUE  = 0x0        // No start (this value should be used when clearing PDN to 0).
	ADC_CR_START_START_CONVERSION_NOW = 0x1        // Start conversion now.
	ADC_CR_START_P2_10                = 0x2        // Start conversion when the edge selected by bit 27 occurs on the P2[10] pin.
	ADC_CR_START_P1_27                = 0x3        // Start conversion when the edge selected by bit 27 occurs on the P1[27] pin.
	ADC_CR_START_MAT0_1               = 0x4        // Start conversion when the edge selected by bit 27 occurs on MAT0.1. Note that this does not require that the MAT0.1 function appear on a device pin.
	ADC_CR_START_MAT0_3               = 0x5        // Start conversion when the edge selected by bit 27 occurs on MAT0.3. Note that it is not possible to cause the MAT0.3 function to appear on a device pin.
	ADC_CR_START_MAT1_0               = 0x6        // Start conversion when the edge selected by bit 27 occurs on MAT1.0. Note that this does not require that the MAT1.0 function appear on a device pin.
	ADC_CR_START_MAT1_1               = 0x7        // Start conversion when the edge selected by bit 27 occurs on MAT1.1. Note that this does not require that the MAT1.1 function appear on a device pin.
	ADC_CR_EDGE_Pos                   = 0x1b       // Position of EDGE field.
	ADC_CR_EDGE_Msk                   = 0x8000000  // Bit mask of EDGE field.
	ADC_CR_EDGE                       = 0x8000000  // Bit EDGE.
	ADC_CR_EDGE_FALLLING              = 0x1        // Start conversion on a falling edge on the selected CAP/MAT signal.
	ADC_CR_EDGE_RISING                = 0x0        // Start conversion on a rising edge on the selected CAP/MAT signal.
	ADC_CR_RESERVED_Pos               = 0x1c       // Position of RESERVED field.
	ADC_CR_RESERVED_Msk               = 0xf0000000 // Bit mask of RESERVED field.

	// GDR: A/D Global Data Register. This register contains the ADC's DONE bit and the result of the most recent A/D conversion.
	ADC_GDR_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xf        // Bit mask of RESERVED field.
	ADC_GDR_RESULT_Pos   = 0x4        // Position of RESULT field.
	ADC_GDR_RESULT_Msk   = 0xfff0     // Bit mask of RESULT field.
	ADC_GDR_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0xff0000   // Bit mask of RESERVED field.
	ADC_GDR_CHN_Pos      = 0x18       // Position of CHN field.
	ADC_GDR_CHN_Msk      = 0x7000000  // Bit mask of CHN field.
	ADC_GDR_RESERVED_Pos = 0x1b       // Position of RESERVED field.
	ADC_GDR_RESERVED_Msk = 0x38000000 // Bit mask of RESERVED field.
	ADC_GDR_OVERRUN_Pos  = 0x1e       // Position of OVERRUN field.
	ADC_GDR_OVERRUN_Msk  = 0x40000000 // Bit mask of OVERRUN field.
	ADC_GDR_OVERRUN      = 0x40000000 // Bit OVERRUN.
	ADC_GDR_DONE_Pos     = 0x1f       // Position of DONE field.
	ADC_GDR_DONE_Msk     = 0x80000000 // Bit mask of DONE field.
	ADC_GDR_DONE         = 0x80000000 // Bit DONE.

	// INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
	ADC_INTEN_ADINTEN0_Pos      = 0x0        // Position of ADINTEN0 field.
	ADC_INTEN_ADINTEN0_Msk      = 0x1        // Bit mask of ADINTEN0 field.
	ADC_INTEN_ADINTEN0          = 0x1        // Bit ADINTEN0.
	ADC_INTEN_ADINTEN0_DISABLE  = 0x0        // Completion of a conversion on ADC channel 0 will not generate an interrupt.
	ADC_INTEN_ADINTEN0_ENABLE   = 0x1        // Completion of a conversion on ADC channel 0 will generate an interrupt.
	ADC_INTEN_ADINTEN1_Pos      = 0x1        // Position of ADINTEN1 field.
	ADC_INTEN_ADINTEN1_Msk      = 0x2        // Bit mask of ADINTEN1 field.
	ADC_INTEN_ADINTEN1          = 0x2        // Bit ADINTEN1.
	ADC_INTEN_ADINTEN1_DISABLE  = 0x0        // Completion of a conversion on ADC channel 1 will not generate an interrupt.
	ADC_INTEN_ADINTEN1_ENABLE   = 0x1        // Completion of a conversion on ADC channel 1 will generate an interrupt.
	ADC_INTEN_ADINTEN2_Pos      = 0x2        // Position of ADINTEN2 field.
	ADC_INTEN_ADINTEN2_Msk      = 0x4        // Bit mask of ADINTEN2 field.
	ADC_INTEN_ADINTEN2          = 0x4        // Bit ADINTEN2.
	ADC_INTEN_ADINTEN2_DISABLE  = 0x0        // Completion of a conversion on ADC channel 2 will not generate an interrupt.
	ADC_INTEN_ADINTEN2_ENABLE   = 0x1        // Completion of a conversion on ADC channel 2 will generate an interrupt.
	ADC_INTEN_ADINTEN3_Pos      = 0x3        // Position of ADINTEN3 field.
	ADC_INTEN_ADINTEN3_Msk      = 0x8        // Bit mask of ADINTEN3 field.
	ADC_INTEN_ADINTEN3          = 0x8        // Bit ADINTEN3.
	ADC_INTEN_ADINTEN3_DISABLE  = 0x0        // Completion of a conversion on ADC channel 3 will not generate an interrupt.
	ADC_INTEN_ADINTEN3_ENABLE   = 0x1        // Completion of a conversion on ADC channel 3 will generate an interrupt.
	ADC_INTEN_ADINTEN4_Pos      = 0x4        // Position of ADINTEN4 field.
	ADC_INTEN_ADINTEN4_Msk      = 0x10       // Bit mask of ADINTEN4 field.
	ADC_INTEN_ADINTEN4          = 0x10       // Bit ADINTEN4.
	ADC_INTEN_ADINTEN4_DISABLE  = 0x0        // Completion of a conversion on ADC channel 4 will not generate an interrupt.
	ADC_INTEN_ADINTEN4_ENABLE   = 0x1        // Completion of a conversion on ADC channel 4 will generate an interrupt.
	ADC_INTEN_ADINTEN5_Pos      = 0x5        // Position of ADINTEN5 field.
	ADC_INTEN_ADINTEN5_Msk      = 0x20       // Bit mask of ADINTEN5 field.
	ADC_INTEN_ADINTEN5          = 0x20       // Bit ADINTEN5.
	ADC_INTEN_ADINTEN5_DISABLE  = 0x0        // Completion of a conversion on ADC channel 5 will not generate an interrupt.
	ADC_INTEN_ADINTEN5_ENABLE   = 0x1        // Completion of a conversion on ADC channel 5 will generate an interrupt.
	ADC_INTEN_ADINTEN6_Pos      = 0x6        // Position of ADINTEN6 field.
	ADC_INTEN_ADINTEN6_Msk      = 0x40       // Bit mask of ADINTEN6 field.
	ADC_INTEN_ADINTEN6          = 0x40       // Bit ADINTEN6.
	ADC_INTEN_ADINTEN6_DISABLE  = 0x0        // Completion of a conversion on ADC channel 6 will not generate an interrupt.
	ADC_INTEN_ADINTEN6_ENABLE   = 0x1        // Completion of a conversion on ADC channel 6 will generate an interrupt.
	ADC_INTEN_ADINTEN7_Pos      = 0x7        // Position of ADINTEN7 field.
	ADC_INTEN_ADINTEN7_Msk      = 0x80       // Bit mask of ADINTEN7 field.
	ADC_INTEN_ADINTEN7          = 0x80       // Bit ADINTEN7.
	ADC_INTEN_ADINTEN7_DISABLE  = 0x0        // Completion of a conversion on ADC channel 7 will not generate an interrupt.
	ADC_INTEN_ADINTEN7_ENABLE   = 0x1        // Completion of a conversion on ADC channel 7 will generate an interrupt.
	ADC_INTEN_ADGINTEN_Pos      = 0x8        // Position of ADGINTEN field.
	ADC_INTEN_ADGINTEN_Msk      = 0x100      // Bit mask of ADGINTEN field.
	ADC_INTEN_ADGINTEN          = 0x100      // Bit ADGINTEN.
	ADC_INTEN_ADGINTEN_CHANNELS = 0x0        // Only the individual ADC channels enabled by ADINTEN7:0 will generate interrupts.
	ADC_INTEN_ADGINTEN_GLOBAL   = 0x1        // The global DONE flag in ADDR is enabled to generate an interrupt in addition to any individual ADC channels that are enabled to generate interrupts.
	ADC_INTEN_RESERVED_Pos      = 0x9        // Position of RESERVED field.
	ADC_INTEN_RESERVED_Msk      = 0xfffffe00 // Bit mask of RESERVED field.

	// DR: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
	ADC_DR_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ADC_DR_RESERVED_Msk = 0xf        // Bit mask of RESERVED field.
	ADC_DR_RESULT_Pos   = 0x4        // Position of RESULT field.
	ADC_DR_RESULT_Msk   = 0xfff0     // Bit mask of RESULT field.
	ADC_DR_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ADC_DR_RESERVED_Msk = 0x3fff0000 // Bit mask of RESERVED field.
	ADC_DR_OVERRUN_Pos  = 0x1e       // Position of OVERRUN field.
	ADC_DR_OVERRUN_Msk  = 0x40000000 // Bit mask of OVERRUN field.
	ADC_DR_OVERRUN      = 0x40000000 // Bit OVERRUN.
	ADC_DR_DONE_Pos     = 0x1f       // Position of DONE field.
	ADC_DR_DONE_Msk     = 0x80000000 // Bit mask of DONE field.
	ADC_DR_DONE         = 0x80000000 // Bit DONE.

	// STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt/DMA flag.
	ADC_STAT_DONE0_Pos    = 0x0        // Position of DONE0 field.
	ADC_STAT_DONE0_Msk    = 0x1        // Bit mask of DONE0 field.
	ADC_STAT_DONE0        = 0x1        // Bit DONE0.
	ADC_STAT_DONE1_Pos    = 0x1        // Position of DONE1 field.
	ADC_STAT_DONE1_Msk    = 0x2        // Bit mask of DONE1 field.
	ADC_STAT_DONE1        = 0x2        // Bit DONE1.
	ADC_STAT_DONE2_Pos    = 0x2        // Position of DONE2 field.
	ADC_STAT_DONE2_Msk    = 0x4        // Bit mask of DONE2 field.
	ADC_STAT_DONE2        = 0x4        // Bit DONE2.
	ADC_STAT_DONE3_Pos    = 0x3        // Position of DONE3 field.
	ADC_STAT_DONE3_Msk    = 0x8        // Bit mask of DONE3 field.
	ADC_STAT_DONE3        = 0x8        // Bit DONE3.
	ADC_STAT_DONE4_Pos    = 0x4        // Position of DONE4 field.
	ADC_STAT_DONE4_Msk    = 0x10       // Bit mask of DONE4 field.
	ADC_STAT_DONE4        = 0x10       // Bit DONE4.
	ADC_STAT_DONE5_Pos    = 0x5        // Position of DONE5 field.
	ADC_STAT_DONE5_Msk    = 0x20       // Bit mask of DONE5 field.
	ADC_STAT_DONE5        = 0x20       // Bit DONE5.
	ADC_STAT_DONE6_Pos    = 0x6        // Position of DONE6 field.
	ADC_STAT_DONE6_Msk    = 0x40       // Bit mask of DONE6 field.
	ADC_STAT_DONE6        = 0x40       // Bit DONE6.
	ADC_STAT_DONE7_Pos    = 0x7        // Position of DONE7 field.
	ADC_STAT_DONE7_Msk    = 0x80       // Bit mask of DONE7 field.
	ADC_STAT_DONE7        = 0x80       // Bit DONE7.
	ADC_STAT_OVERRUN0_Pos = 0x8        // Position of OVERRUN0 field.
	ADC_STAT_OVERRUN0_Msk = 0x100      // Bit mask of OVERRUN0 field.
	ADC_STAT_OVERRUN0     = 0x100      // Bit OVERRUN0.
	ADC_STAT_OVERRUN1_Pos = 0x9        // Position of OVERRUN1 field.
	ADC_STAT_OVERRUN1_Msk = 0x200      // Bit mask of OVERRUN1 field.
	ADC_STAT_OVERRUN1     = 0x200      // Bit OVERRUN1.
	ADC_STAT_OVERRUN2_Pos = 0xa        // Position of OVERRUN2 field.
	ADC_STAT_OVERRUN2_Msk = 0x400      // Bit mask of OVERRUN2 field.
	ADC_STAT_OVERRUN2     = 0x400      // Bit OVERRUN2.
	ADC_STAT_OVERRUN3_Pos = 0xb        // Position of OVERRUN3 field.
	ADC_STAT_OVERRUN3_Msk = 0x800      // Bit mask of OVERRUN3 field.
	ADC_STAT_OVERRUN3     = 0x800      // Bit OVERRUN3.
	ADC_STAT_OVERRUN4_Pos = 0xc        // Position of OVERRUN4 field.
	ADC_STAT_OVERRUN4_Msk = 0x1000     // Bit mask of OVERRUN4 field.
	ADC_STAT_OVERRUN4     = 0x1000     // Bit OVERRUN4.
	ADC_STAT_OVERRUN5_Pos = 0xd        // Position of OVERRUN5 field.
	ADC_STAT_OVERRUN5_Msk = 0x2000     // Bit mask of OVERRUN5 field.
	ADC_STAT_OVERRUN5     = 0x2000     // Bit OVERRUN5.
	ADC_STAT_OVERRUN6_Pos = 0xe        // Position of OVERRUN6 field.
	ADC_STAT_OVERRUN6_Msk = 0x4000     // Bit mask of OVERRUN6 field.
	ADC_STAT_OVERRUN6     = 0x4000     // Bit OVERRUN6.
	ADC_STAT_OVERRUN7_Pos = 0xf        // Position of OVERRUN7 field.
	ADC_STAT_OVERRUN7_Msk = 0x8000     // Bit mask of OVERRUN7 field.
	ADC_STAT_OVERRUN7     = 0x8000     // Bit OVERRUN7.
	ADC_STAT_ADINT_Pos    = 0x10       // Position of ADINT field.
	ADC_STAT_ADINT_Msk    = 0x10000    // Bit mask of ADINT field.
	ADC_STAT_ADINT        = 0x10000    // Bit ADINT.
	ADC_STAT_RESERVED_Pos = 0x11       // Position of RESERVED field.
	ADC_STAT_RESERVED_Msk = 0xfffe0000 // Bit mask of RESERVED field.

	// TRM: ADC trim register.
	ADC_TRM_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xf        // Bit mask of RESERVED field.
	ADC_TRM_ADCOFFS_Pos  = 0x4        // Position of ADCOFFS field.
	ADC_TRM_ADCOFFS_Msk  = 0xf0       // Bit mask of ADCOFFS field.
	ADC_TRM_TRIM_Pos     = 0x8        // Position of TRIM field.
	ADC_TRM_TRIM_Msk     = 0xf00      // Bit mask of TRIM field.
	ADC_TRM_RESERVED_Pos = 0xc        // Position of RESERVED field.
	ADC_TRM_RESERVED_Msk = 0xfffff000 // Bit mask of RESERVED field.
)

// Bitfields for CANAFRAM: CAN acceptance filter RAM
const (
	// MASK: CAN AF ram access register
	CANAFRAM_MASK_MASK_Pos = 0x0        // Position of MASK field.
	CANAFRAM_MASK_MASK_Msk = 0xffffffff // Bit mask of MASK field.
)

// Bitfields for CANAF: CAN controller acceptance filter
const (
	// AFMR: Acceptance Filter Register
	CANAF_AFMR_ACCOFF_Pos                 = 0x0        // Position of ACCOFF field.
	CANAF_AFMR_ACCOFF_Msk                 = 0x1        // Bit mask of ACCOFF field.
	CANAF_AFMR_ACCOFF                     = 0x1        // Bit ACCOFF.
	CANAF_AFMR_ACCBP_Pos                  = 0x1        // Position of ACCBP field.
	CANAF_AFMR_ACCBP_Msk                  = 0x2        // Bit mask of ACCBP field.
	CANAF_AFMR_ACCBP                      = 0x2        // Bit ACCBP.
	CANAF_AFMR_EFCAN_Pos                  = 0x2        // Position of EFCAN field.
	CANAF_AFMR_EFCAN_Msk                  = 0x4        // Bit mask of EFCAN field.
	CANAF_AFMR_EFCAN                      = 0x4        // Bit EFCAN.
	CANAF_AFMR_EFCAN_SOFTWARE_MUST_READ_A = 0x0        // Software must read all messages for all enabled IDs on all enabled CAN buses, from the receiving CAN controllers.
	CANAF_AFMR_EFCAN_THE_ACCEPTANCE_FILTE = 0x1        // The Acceptance Filter itself will take care of receiving and storing messages for selected Standard ID values on selected CAN buses. See Section 21.16 FullCAN mode on page 576.
	CANAF_AFMR_RESERVED_Pos               = 0x3        // Position of RESERVED field.
	CANAF_AFMR_RESERVED_Msk               = 0xfffffff8 // Bit mask of RESERVED field.

	// SFF_SA: Standard Frame Individual Start Address Register
	CANAF_SFF_SA_RESERVED_Pos = 0x0        // Position of RESERVED field.
	CANAF_SFF_SA_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	CANAF_SFF_SA_SFF_SA_Pos   = 0x2        // Position of SFF_SA field.
	CANAF_SFF_SA_SFF_SA_Msk   = 0x7fc      // Bit mask of SFF_SA field.
	CANAF_SFF_SA_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CANAF_SFF_SA_RESERVED_Msk = 0xfffff800 // Bit mask of RESERVED field.

	// SFF_GRP_SA: Standard Frame Group Start Address Register
	CANAF_SFF_GRP_SA_RESERVED_Pos   = 0x0        // Position of RESERVED field.
	CANAF_SFF_GRP_SA_RESERVED_Msk   = 0x3        // Bit mask of RESERVED field.
	CANAF_SFF_GRP_SA_SFF_GRP_SA_Pos = 0x2        // Position of SFF_GRP_SA field.
	CANAF_SFF_GRP_SA_SFF_GRP_SA_Msk = 0xffc      // Bit mask of SFF_GRP_SA field.
	CANAF_SFF_GRP_SA_RESERVED_Pos   = 0xc        // Position of RESERVED field.
	CANAF_SFF_GRP_SA_RESERVED_Msk   = 0xfffff000 // Bit mask of RESERVED field.

	// EFF_SA: Extended Frame Start Address Register
	CANAF_EFF_SA_RESERVED_Pos = 0x0        // Position of RESERVED field.
	CANAF_EFF_SA_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	CANAF_EFF_SA_EFF_SA_Pos   = 0x2        // Position of EFF_SA field.
	CANAF_EFF_SA_EFF_SA_Msk   = 0x7fc      // Bit mask of EFF_SA field.
	CANAF_EFF_SA_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CANAF_EFF_SA_RESERVED_Msk = 0xfffff800 // Bit mask of RESERVED field.

	// EFF_GRP_SA: Extended Frame Group Start Address Register
	CANAF_EFF_GRP_SA_RESERVED_Pos   = 0x0        // Position of RESERVED field.
	CANAF_EFF_GRP_SA_RESERVED_Msk   = 0x3        // Bit mask of RESERVED field.
	CANAF_EFF_GRP_SA_EFF_GRP_SA_Pos = 0x2        // Position of EFF_GRP_SA field.
	CANAF_EFF_GRP_SA_EFF_GRP_SA_Msk = 0xffc      // Bit mask of EFF_GRP_SA field.
	CANAF_EFF_GRP_SA_RESERVED_Pos   = 0xc        // Position of RESERVED field.
	CANAF_EFF_GRP_SA_RESERVED_Msk   = 0xfffff000 // Bit mask of RESERVED field.

	// ENDOFTABLE: End of AF Tables register
	CANAF_ENDOFTABLE_RESERVED_Pos   = 0x0        // Position of RESERVED field.
	CANAF_ENDOFTABLE_RESERVED_Msk   = 0x3        // Bit mask of RESERVED field.
	CANAF_ENDOFTABLE_ENDOFTABLE_Pos = 0x2        // Position of ENDOFTABLE field.
	CANAF_ENDOFTABLE_ENDOFTABLE_Msk = 0xffc      // Bit mask of ENDOFTABLE field.
	CANAF_ENDOFTABLE_RESERVED_Pos   = 0xc        // Position of RESERVED field.
	CANAF_ENDOFTABLE_RESERVED_Msk   = 0xfffff000 // Bit mask of RESERVED field.

	// LUTERRAD: LUT Error Address register
	CANAF_LUTERRAD_RESERVED_Pos = 0x0        // Position of RESERVED field.
	CANAF_LUTERRAD_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	CANAF_LUTERRAD_LUTERRAD_Pos = 0x2        // Position of LUTERRAD field.
	CANAF_LUTERRAD_LUTERRAD_Msk = 0x7fc      // Bit mask of LUTERRAD field.
	CANAF_LUTERRAD_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CANAF_LUTERRAD_RESERVED_Msk = 0xfffff800 // Bit mask of RESERVED field.

	// LUTERR: LUT Error Register
	CANAF_LUTERR_LUTERR_Pos   = 0x0        // Position of LUTERR field.
	CANAF_LUTERR_LUTERR_Msk   = 0x1        // Bit mask of LUTERR field.
	CANAF_LUTERR_LUTERR       = 0x1        // Bit LUTERR.
	CANAF_LUTERR_RESERVED_Pos = 0x1        // Position of RESERVED field.
	CANAF_LUTERR_RESERVED_Msk = 0xfffffffe // Bit mask of RESERVED field.

	// FCANIE: FullCAN interrupt enable register
	CANAF_FCANIE_FCANIE_Pos   = 0x0        // Position of FCANIE field.
	CANAF_FCANIE_FCANIE_Msk   = 0x1        // Bit mask of FCANIE field.
	CANAF_FCANIE_FCANIE       = 0x1        // Bit FCANIE.
	CANAF_FCANIE_RESERVED_Pos = 0x1        // Position of RESERVED field.
	CANAF_FCANIE_RESERVED_Msk = 0xfffffffe // Bit mask of RESERVED field.

	// FCANIC0: FullCAN interrupt and capture register0
	CANAF_FCANIC0_INTPND_Pos = 0x0        // Position of INTPND field.
	CANAF_FCANIC0_INTPND_Msk = 0xffffffff // Bit mask of INTPND field.

	// FCANIC1: FullCAN interrupt and capture register1
	CANAF_FCANIC1_IntPnd32_Pos = 0x0        // Position of IntPnd32 field.
	CANAF_FCANIC1_IntPnd32_Msk = 0xffffffff // Bit mask of IntPnd32 field.
)

// Bitfields for CCAN: Central CAN controller
const (
	// TXSR: CAN Central Transmit Status Register
	CCAN_TXSR_TS1_Pos      = 0x0        // Position of TS1 field.
	CCAN_TXSR_TS1_Msk      = 0x1        // Bit mask of TS1 field.
	CCAN_TXSR_TS1          = 0x1        // Bit TS1.
	CCAN_TXSR_TS2_Pos      = 0x1        // Position of TS2 field.
	CCAN_TXSR_TS2_Msk      = 0x2        // Bit mask of TS2 field.
	CCAN_TXSR_TS2          = 0x2        // Bit TS2.
	CCAN_TXSR_RESERVED_Pos = 0x2        // Position of RESERVED field.
	CCAN_TXSR_RESERVED_Msk = 0xfc       // Bit mask of RESERVED field.
	CCAN_TXSR_TBS1_Pos     = 0x8        // Position of TBS1 field.
	CCAN_TXSR_TBS1_Msk     = 0x100      // Bit mask of TBS1 field.
	CCAN_TXSR_TBS1         = 0x100      // Bit TBS1.
	CCAN_TXSR_TBS2_Pos     = 0x9        // Position of TBS2 field.
	CCAN_TXSR_TBS2_Msk     = 0x200      // Bit mask of TBS2 field.
	CCAN_TXSR_TBS2         = 0x200      // Bit TBS2.
	CCAN_TXSR_RESERVED_Pos = 0xa        // Position of RESERVED field.
	CCAN_TXSR_RESERVED_Msk = 0xfc00     // Bit mask of RESERVED field.
	CCAN_TXSR_TCS1_Pos     = 0x10       // Position of TCS1 field.
	CCAN_TXSR_TCS1_Msk     = 0x10000    // Bit mask of TCS1 field.
	CCAN_TXSR_TCS1         = 0x10000    // Bit TCS1.
	CCAN_TXSR_TCS2_Pos     = 0x11       // Position of TCS2 field.
	CCAN_TXSR_TCS2_Msk     = 0x20000    // Bit mask of TCS2 field.
	CCAN_TXSR_TCS2         = 0x20000    // Bit TCS2.
	CCAN_TXSR_RESERVED_Pos = 0x12       // Position of RESERVED field.
	CCAN_TXSR_RESERVED_Msk = 0xfffc0000 // Bit mask of RESERVED field.

	// RXSR: CAN Central Receive Status Register
	CCAN_RXSR_RS1_Pos      = 0x0        // Position of RS1 field.
	CCAN_RXSR_RS1_Msk      = 0x1        // Bit mask of RS1 field.
	CCAN_RXSR_RS1          = 0x1        // Bit RS1.
	CCAN_RXSR_RS2_Pos      = 0x1        // Position of RS2 field.
	CCAN_RXSR_RS2_Msk      = 0x2        // Bit mask of RS2 field.
	CCAN_RXSR_RS2          = 0x2        // Bit RS2.
	CCAN_RXSR_RESERVED_Pos = 0x2        // Position of RESERVED field.
	CCAN_RXSR_RESERVED_Msk = 0xfc       // Bit mask of RESERVED field.
	CCAN_RXSR_RB1_Pos      = 0x8        // Position of RB1 field.
	CCAN_RXSR_RB1_Msk      = 0x100      // Bit mask of RB1 field.
	CCAN_RXSR_RB1          = 0x100      // Bit RB1.
	CCAN_RXSR_RB2_Pos      = 0x9        // Position of RB2 field.
	CCAN_RXSR_RB2_Msk      = 0x200      // Bit mask of RB2 field.
	CCAN_RXSR_RB2          = 0x200      // Bit RB2.
	CCAN_RXSR_RESERVED_Pos = 0xa        // Position of RESERVED field.
	CCAN_RXSR_RESERVED_Msk = 0xfc00     // Bit mask of RESERVED field.
	CCAN_RXSR_DOS1_Pos     = 0x10       // Position of DOS1 field.
	CCAN_RXSR_DOS1_Msk     = 0x10000    // Bit mask of DOS1 field.
	CCAN_RXSR_DOS1         = 0x10000    // Bit DOS1.
	CCAN_RXSR_DOS2_Pos     = 0x11       // Position of DOS2 field.
	CCAN_RXSR_DOS2_Msk     = 0x20000    // Bit mask of DOS2 field.
	CCAN_RXSR_DOS2         = 0x20000    // Bit DOS2.
	CCAN_RXSR_RESERVED_Pos = 0x12       // Position of RESERVED field.
	CCAN_RXSR_RESERVED_Msk = 0xfffc0000 // Bit mask of RESERVED field.

	// MSR: CAN Central Miscellaneous Register
	CCAN_MSR_E1_Pos       = 0x0        // Position of E1 field.
	CCAN_MSR_E1_Msk       = 0x1        // Bit mask of E1 field.
	CCAN_MSR_E1           = 0x1        // Bit E1.
	CCAN_MSR_E2_Pos       = 0x1        // Position of E2 field.
	CCAN_MSR_E2_Msk       = 0x2        // Bit mask of E2 field.
	CCAN_MSR_E2           = 0x2        // Bit E2.
	CCAN_MSR_RESERVED_Pos = 0x2        // Position of RESERVED field.
	CCAN_MSR_RESERVED_Msk = 0xfc       // Bit mask of RESERVED field.
	CCAN_MSR_BS1_Pos      = 0x8        // Position of BS1 field.
	CCAN_MSR_BS1_Msk      = 0x100      // Bit mask of BS1 field.
	CCAN_MSR_BS1          = 0x100      // Bit BS1.
	CCAN_MSR_BS2_Pos      = 0x9        // Position of BS2 field.
	CCAN_MSR_BS2_Msk      = 0x200      // Bit mask of BS2 field.
	CCAN_MSR_BS2          = 0x200      // Bit BS2.
	CCAN_MSR_RESERVED_Pos = 0xa        // Position of RESERVED field.
	CCAN_MSR_RESERVED_Msk = 0xfffffc00 // Bit mask of RESERVED field.
)

// Bitfields for CAN1: CAN1 controller
const (
	// MOD: Controls the operating mode of the CAN Controller.
	CAN_MOD_RM_Pos                  = 0x0        // Position of RM field.
	CAN_MOD_RM_Msk                  = 0x1        // Bit mask of RM field.
	CAN_MOD_RM                      = 0x1        // Bit RM.
	CAN_MOD_RM_NORMAL_THE_CAN_CONTR = 0x0        // Normal.The CAN Controller is in the Operating Mode, and certain registers can not be written.
	CAN_MOD_RM_RESET_CAN_OPERATION  = 0x1        // Reset. CAN operation is disabled, writable registers can be written and the current transmission/reception of a message is aborted.
	CAN_MOD_LOM_Pos                 = 0x1        // Position of LOM field.
	CAN_MOD_LOM_Msk                 = 0x2        // Bit mask of LOM field.
	CAN_MOD_LOM                     = 0x2        // Bit LOM.
	CAN_MOD_LOM_NORMAL_THE_CAN_CONT = 0x0        // Normal. The CAN controller acknowledges a successfully received message on the CAN bus. The error counters are stopped at the current value.
	CAN_MOD_LOM_LISTEN_ONLY_THE_CON = 0x1        // Listen only. The controller gives no acknowledgment, even if a message is successfully received. Messages cannot be sent, and the controller operates in error passive mode. This mode is intended for software bit rate detection and hot plugging.
	CAN_MOD_STM_Pos                 = 0x2        // Position of STM field.
	CAN_MOD_STM_Msk                 = 0x4        // Bit mask of STM field.
	CAN_MOD_STM                     = 0x4        // Bit STM.
	CAN_MOD_STM_NORMAL_A_TRANSMITTE = 0x0        // Normal. A transmitted message must be acknowledged to be considered successful.
	CAN_MOD_STM_SELF_TEST_THE_CONTR = 0x1        // Self test. The controller will consider a Tx message successful even if there is no acknowledgment received. In this mode a full node test is possible without any other active node on the bus using the SRR bit in CANxCMR.
	CAN_MOD_TPM_Pos                 = 0x3        // Position of TPM field.
	CAN_MOD_TPM_Msk                 = 0x8        // Bit mask of TPM field.
	CAN_MOD_TPM                     = 0x8        // Bit TPM.
	CAN_MOD_TPM_CAN_ID_THE_TRANSMIT = 0x0        // CAN ID. The transmit priority for 3 Transmit Buffers depends on the CAN Identifier.
	CAN_MOD_TPM_LOCAL_PRIORITY_THE_ = 0x1        // Local priority. The transmit priority for 3 Transmit Buffers depends on the contents of the Tx Priority register within the Transmit Buffer.
	CAN_MOD_SM_Pos                  = 0x4        // Position of SM field.
	CAN_MOD_SM_Msk                  = 0x10       // Bit mask of SM field.
	CAN_MOD_SM                      = 0x10       // Bit SM.
	CAN_MOD_SM_WAKE_UP_NORMAL_OPER  = 0x0        // Wake-up. Normal operation.
	CAN_MOD_SM_SLEEP_THE_CAN_CONTR  = 0x1        // Sleep. The CAN controller enters Sleep Mode if no CAN interrupt is pending and there is no bus activity. See the Sleep Mode description Section 21.8.2 on page 565.
	CAN_MOD_RPM_Pos                 = 0x5        // Position of RPM field.
	CAN_MOD_RPM_Msk                 = 0x20       // Bit mask of RPM field.
	CAN_MOD_RPM                     = 0x20       // Bit RPM.
	CAN_MOD_RPM_LOW_ACTIVE_RD_INPUT = 0x0        // Low active. RD input is active Low (dominant bit = 0).
	CAN_MOD_RPM_HIGH_ACTIVE_RD_INPU = 0x1        // High active. RD input is active High (dominant bit = 1) -- reverse polarity.
	CAN_MOD_RESERVED_Pos            = 0x6        // Position of RESERVED field.
	CAN_MOD_RESERVED_Msk            = 0x40       // Bit mask of RESERVED field.
	CAN_MOD_RESERVED                = 0x40       // Bit RESERVED.
	CAN_MOD_TM_Pos                  = 0x7        // Position of TM field.
	CAN_MOD_TM_Msk                  = 0x80       // Bit mask of TM field.
	CAN_MOD_TM                      = 0x80       // Bit TM.
	CAN_MOD_TM_DISABLED_NORMAL_OPE  = 0x0        // Disabled. Normal operation.
	CAN_MOD_TM_ENABLED_THE_TD_PIN_  = 0x1        // Enabled. The TD pin will reflect the bit, detected on RD pin, with the next positive edge of the system clock.
	CAN_MOD_RESERVED_Pos            = 0x8        // Position of RESERVED field.
	CAN_MOD_RESERVED_Msk            = 0xffffff00 // Bit mask of RESERVED field.

	// CMR: Command bits that affect the state of the CAN Controller
	CAN_CMR_TR_Pos                   = 0x0        // Position of TR field.
	CAN_CMR_TR_Msk                   = 0x1        // Bit mask of TR field.
	CAN_CMR_TR                       = 0x1        // Bit TR.
	CAN_CMR_TR_ABSENT_NO_TRANSMISSI  = 0x0        // Absent.No transmission request.
	CAN_CMR_TR_PRESENT_THE_MESSAGE   = 0x1        // Present. The message, previously written to the CANxTFI, CANxTID, and optionally the CANxTDA and CANxTDB registers, is queued for transmission from the selected Transmit Buffer. If at two or all three of STB1, STB2 and STB3 bits are selected when TR=1 is written, Transmit Buffer will be selected based on the chosen priority scheme (for details see Section 21.5.3 Transmit Buffers (TXB))
	CAN_CMR_AT_Pos                   = 0x1        // Position of AT field.
	CAN_CMR_AT_Msk                   = 0x2        // Bit mask of AT field.
	CAN_CMR_AT                       = 0x2        // Bit AT.
	CAN_CMR_AT_NO_ACTION_DO_NOT_AB   = 0x0        // No action. Do not abort the transmission.
	CAN_CMR_AT_PRESENT_IF_NOT_ALRE   = 0x1        // Present. if not already in progress, a pending Transmission Request for the selected Transmit Buffer is cancelled.
	CAN_CMR_RRB_Pos                  = 0x2        // Position of RRB field.
	CAN_CMR_RRB_Msk                  = 0x4        // Bit mask of RRB field.
	CAN_CMR_RRB                      = 0x4        // Bit RRB.
	CAN_CMR_RRB_NO_ACTION_DO_NOT_RE  = 0x0        // No action. Do not release the receive buffer.
	CAN_CMR_RRB_RELEASED_THE_INFORM  = 0x1        // Released. The information in the Receive Buffer (consisting of CANxRFS, CANxRID, and if applicable the CANxRDA and CANxRDB registers) is released, and becomes eligible for replacement by the next received frame. If the next received frame is not available, writing this command clears the RBS bit in the Status Register(s).
	CAN_CMR_CDO_Pos                  = 0x3        // Position of CDO field.
	CAN_CMR_CDO_Msk                  = 0x8        // Bit mask of CDO field.
	CAN_CMR_CDO                      = 0x8        // Bit CDO.
	CAN_CMR_CDO_NO_ACTION_DO_NOT_CL  = 0x0        // No action. Do not clear the data overrun bit.
	CAN_CMR_CDO_CLEAR_THE_DATA_OVER  = 0x1        // Clear. The Data Overrun bit in Status Register(s) is cleared.
	CAN_CMR_SRR_Pos                  = 0x4        // Position of SRR field.
	CAN_CMR_SRR_Msk                  = 0x10       // Bit mask of SRR field.
	CAN_CMR_SRR                      = 0x10       // Bit SRR.
	CAN_CMR_SRR_ABSENT_NO_SELF_RECE  = 0x0        // Absent. No self reception request.
	CAN_CMR_SRR_PRESENT_THE_MESSAGE  = 0x1        // Present. The message, previously written to the CANxTFS, CANxTID, and optionally the CANxTDA and CANxTDB registers, is queued for transmission from the selected Transmit Buffer and received simultaneously. This differs from the TR bit above in that the receiver is not disabled during the transmission, so that it receives the message if its Identifier is recognized by the Acceptance Filter.
	CAN_CMR_STB1_Pos                 = 0x5        // Position of STB1 field.
	CAN_CMR_STB1_Msk                 = 0x20       // Bit mask of STB1 field.
	CAN_CMR_STB1                     = 0x20       // Bit STB1.
	CAN_CMR_STB1_NOT_SELECTED_TX_BUF = 0x0        // Not selected. Tx Buffer 1 is not selected for transmission.
	CAN_CMR_STB1_SELECTED_TX_BUFFER_ = 0x1        // Selected. Tx Buffer 1 is selected for transmission.
	CAN_CMR_STB2_Pos                 = 0x6        // Position of STB2 field.
	CAN_CMR_STB2_Msk                 = 0x40       // Bit mask of STB2 field.
	CAN_CMR_STB2                     = 0x40       // Bit STB2.
	CAN_CMR_STB2_NOT_SELECTED_TX_BUF = 0x0        // Not selected. Tx Buffer 2 is not selected for transmission.
	CAN_CMR_STB2_SELECTED_TX_BUFFER_ = 0x1        // Selected. Tx Buffer 2 is selected for transmission.
	CAN_CMR_STB3_Pos                 = 0x7        // Position of STB3 field.
	CAN_CMR_STB3_Msk                 = 0x80       // Bit mask of STB3 field.
	CAN_CMR_STB3                     = 0x80       // Bit STB3.
	CAN_CMR_STB3_NOT_SELECTED_TX_BUF = 0x0        // Not selected. Tx Buffer 3 is not selected for transmission.
	CAN_CMR_STB3_SELECTED_TX_BUFFER_ = 0x1        // Selected. Tx Buffer 3 is selected for transmission.
	CAN_CMR_RESERVED_Pos             = 0x8        // Position of RESERVED field.
	CAN_CMR_RESERVED_Msk             = 0xffffff00 // Bit mask of RESERVED field.

	// GSR: Global Controller Status and Error Counters. The error counters can only be written when RM in CANMOD is 1.
	CAN_GSR_RBS_Pos                 = 0x0        // Position of RBS field.
	CAN_GSR_RBS_Msk                 = 0x1        // Bit mask of RBS field.
	CAN_GSR_RBS                     = 0x1        // Bit RBS.
	CAN_GSR_RBS_EMPTY_NO_MESSAGE_IS = 0x0        // Empty. No message is available.
	CAN_GSR_RBS_FULL_AT_LEAST_ONE_C = 0x1        // Full. At least one complete message is received by the Double Receive Buffer and available in the CANxRFS, CANxRID, and if applicable the CANxRDA and CANxRDB registers. This bit is cleared by the Release Receive Buffer command in CANxCMR, if no subsequent received message is available.
	CAN_GSR_DOS_Pos                 = 0x1        // Position of DOS field.
	CAN_GSR_DOS_Msk                 = 0x2        // Bit mask of DOS field.
	CAN_GSR_DOS                     = 0x2        // Bit DOS.
	CAN_GSR_DOS_ABSENT_NO_DATA_OVER = 0x0        // Absent. No data overrun has occurred since the last Clear Data Overrun command was given/written to CANxCMR (or since Reset).
	CAN_GSR_DOS_OVERRUN_A_MESSAGE_W = 0x1        // Overrun. A message was lost because the preceding message to this CAN controller was not read and released quickly enough (there was not enough space for a new message in the Double Receive Buffer).
	CAN_GSR_TBS_Pos                 = 0x2        // Position of TBS field.
	CAN_GSR_TBS_Msk                 = 0x4        // Bit mask of TBS field.
	CAN_GSR_TBS                     = 0x4        // Bit TBS.
	CAN_GSR_TBS_LOCKED_AT_LEAST_ONE = 0x0        // Locked. At least one of the Transmit Buffers is not available for the CPU, i.e. at least one previously queued message for this CAN controller has not yet been sent, and therefore software should not write to the CANxTFI, CANxTID, CANxTDA, nor CANxTDB registers of that (those) Tx buffer(s).
	CAN_GSR_TBS_RELEASED_ALL_THREE_ = 0x1        // Released. All three Transmit Buffers are available for the CPU. No transmit message is pending for this CAN controller (in any of the 3 Tx buffers), and software may write to any of the CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_GSR_TCS_Pos                 = 0x3        // Position of TCS field.
	CAN_GSR_TCS_Msk                 = 0x8        // Bit mask of TCS field.
	CAN_GSR_TCS                     = 0x8        // Bit TCS.
	CAN_GSR_TCS_INCOMPLETE_AT_LEAST = 0x0        // Incomplete. At least one requested transmission has not been successfully completed yet.
	CAN_GSR_TCS_COMPLETE_ALL_REQUES = 0x1        // Complete. All requested transmission(s) has (have) been successfully completed.
	CAN_GSR_RS_Pos                  = 0x4        // Position of RS field.
	CAN_GSR_RS_Msk                  = 0x10       // Bit mask of RS field.
	CAN_GSR_RS                      = 0x10       // Bit RS.
	CAN_GSR_RS_IDLE_THE_CAN_CONTRO  = 0x0        // Idle. The CAN controller is idle.
	CAN_GSR_RS_RECEIVE_THE_CAN_CON  = 0x1        // Receive. The CAN controller is receiving a message.
	CAN_GSR_TS_Pos                  = 0x5        // Position of TS field.
	CAN_GSR_TS_Msk                  = 0x20       // Bit mask of TS field.
	CAN_GSR_TS                      = 0x20       // Bit TS.
	CAN_GSR_TS_IDLE_THE_CAN_CONTRO  = 0x0        // Idle. The CAN controller is idle.
	CAN_GSR_TS_TRANSMIT_THE_CAN_CO  = 0x1        // Transmit. The CAN controller is sending a message.
	CAN_GSR_ES_Pos                  = 0x6        // Position of ES field.
	CAN_GSR_ES_Msk                  = 0x40       // Bit mask of ES field.
	CAN_GSR_ES                      = 0x40       // Bit ES.
	CAN_GSR_ES_OK_BOTH_ERROR_COUNT  = 0x0        // OK. Both error counters are below the Error Warning Limit.
	CAN_GSR_ES_ERROR_ONE_OR_BOTH_O  = 0x1        // Error. One or both of the Transmit and Receive Error Counters has reached the limit set in the Error Warning Limit register.
	CAN_GSR_BS_Pos                  = 0x7        // Position of BS field.
	CAN_GSR_BS_Msk                  = 0x80       // Bit mask of BS field.
	CAN_GSR_BS                      = 0x80       // Bit BS.
	CAN_GSR_BS_BUS_ON_THE_CAN_CONT  = 0x0        // Bus-on. The CAN Controller is involved in bus activities
	CAN_GSR_BS_BUS_OFF_THE_CAN_CON  = 0x1        // Bus-off. The CAN controller is currently not involved/prohibited from bus activity because the Transmit Error Counter reached its limiting value of 255.
	CAN_GSR_RESERVED_Pos            = 0x8        // Position of RESERVED field.
	CAN_GSR_RESERVED_Msk            = 0xff00     // Bit mask of RESERVED field.
	CAN_GSR_RXERR_Pos               = 0x10       // Position of RXERR field.
	CAN_GSR_RXERR_Msk               = 0xff0000   // Bit mask of RXERR field.
	CAN_GSR_TXERR_Pos               = 0x18       // Position of TXERR field.
	CAN_GSR_TXERR_Msk               = 0xff000000 // Bit mask of TXERR field.

	// ICR: Interrupt status, Arbitration Lost Capture, Error Code Capture
	CAN_ICR_RI_Pos                        = 0x0        // Position of RI field.
	CAN_ICR_RI_Msk                        = 0x1        // Bit mask of RI field.
	CAN_ICR_RI                            = 0x1        // Bit RI.
	CAN_ICR_RI_RESET                      = 0x0        // Reset
	CAN_ICR_RI_SET                        = 0x1        // Set
	CAN_ICR_TI1_Pos                       = 0x1        // Position of TI1 field.
	CAN_ICR_TI1_Msk                       = 0x2        // Bit mask of TI1 field.
	CAN_ICR_TI1                           = 0x2        // Bit TI1.
	CAN_ICR_TI1_RESET                     = 0x0        // Reset
	CAN_ICR_TI1_SET                       = 0x1        // Set
	CAN_ICR_EI_Pos                        = 0x2        // Position of EI field.
	CAN_ICR_EI_Msk                        = 0x4        // Bit mask of EI field.
	CAN_ICR_EI                            = 0x4        // Bit EI.
	CAN_ICR_EI_RESET                      = 0x0        // Reset
	CAN_ICR_EI_SET                        = 0x1        // Set
	CAN_ICR_DOI_Pos                       = 0x3        // Position of DOI field.
	CAN_ICR_DOI_Msk                       = 0x8        // Bit mask of DOI field.
	CAN_ICR_DOI                           = 0x8        // Bit DOI.
	CAN_ICR_DOI_RESET                     = 0x0        // Reset
	CAN_ICR_DOI_SET                       = 0x1        // Set
	CAN_ICR_WUI_Pos                       = 0x4        // Position of WUI field.
	CAN_ICR_WUI_Msk                       = 0x10       // Bit mask of WUI field.
	CAN_ICR_WUI                           = 0x10       // Bit WUI.
	CAN_ICR_WUI_RESET                     = 0x0        // Reset
	CAN_ICR_WUI_SET                       = 0x1        // Set
	CAN_ICR_EPI_Pos                       = 0x5        // Position of EPI field.
	CAN_ICR_EPI_Msk                       = 0x20       // Bit mask of EPI field.
	CAN_ICR_EPI                           = 0x20       // Bit EPI.
	CAN_ICR_EPI_RESET                     = 0x0        // Reset
	CAN_ICR_EPI_SET                       = 0x1        // Set
	CAN_ICR_ALI_Pos                       = 0x6        // Position of ALI field.
	CAN_ICR_ALI_Msk                       = 0x40       // Bit mask of ALI field.
	CAN_ICR_ALI                           = 0x40       // Bit ALI.
	CAN_ICR_ALI_RESET                     = 0x0        // Reset
	CAN_ICR_ALI_SET                       = 0x1        // Set
	CAN_ICR_BEI_Pos                       = 0x7        // Position of BEI field.
	CAN_ICR_BEI_Msk                       = 0x80       // Bit mask of BEI field.
	CAN_ICR_BEI                           = 0x80       // Bit BEI.
	CAN_ICR_BEI_RESET                     = 0x0        // Reset
	CAN_ICR_BEI_SET                       = 0x1        // Set
	CAN_ICR_IDI_Pos                       = 0x8        // Position of IDI field.
	CAN_ICR_IDI_Msk                       = 0x100      // Bit mask of IDI field.
	CAN_ICR_IDI                           = 0x100      // Bit IDI.
	CAN_ICR_IDI_RESET                     = 0x0        // Reset
	CAN_ICR_IDI_SET                       = 0x1        // Set
	CAN_ICR_TI2_Pos                       = 0x9        // Position of TI2 field.
	CAN_ICR_TI2_Msk                       = 0x200      // Bit mask of TI2 field.
	CAN_ICR_TI2                           = 0x200      // Bit TI2.
	CAN_ICR_TI2_RESET                     = 0x0        // Reset
	CAN_ICR_TI2_SET                       = 0x1        // Set
	CAN_ICR_TI3_Pos                       = 0xa        // Position of TI3 field.
	CAN_ICR_TI3_Msk                       = 0x400      // Bit mask of TI3 field.
	CAN_ICR_TI3                           = 0x400      // Bit TI3.
	CAN_ICR_TI3_RESET                     = 0x0        // Reset
	CAN_ICR_TI3_SET                       = 0x1        // Set
	CAN_ICR_RESERVED_Pos                  = 0xb        // Position of RESERVED field.
	CAN_ICR_RESERVED_Msk                  = 0xf800     // Bit mask of RESERVED field.
	CAN_ICR_ERRBIT4_0_Pos                 = 0x10       // Position of ERRBIT4_0 field.
	CAN_ICR_ERRBIT4_0_Msk                 = 0x1f0000   // Bit mask of ERRBIT4_0 field.
	CAN_ICR_ERRDIR_Pos                    = 0x15       // Position of ERRDIR field.
	CAN_ICR_ERRDIR_Msk                    = 0x200000   // Bit mask of ERRDIR field.
	CAN_ICR_ERRDIR                        = 0x200000   // Bit ERRDIR.
	CAN_ICR_ERRDIR_ERROR_OCCURRED_DURIN_0 = 0x0        // Error occurred during transmitting.
	CAN_ICR_ERRDIR_ERROR_OCCURRED_DURIN_1 = 0x1        // Error occurred during receiving.
	CAN_ICR_ERRC1_0_Pos                   = 0x16       // Position of ERRC1_0 field.
	CAN_ICR_ERRC1_0_Msk                   = 0xc00000   // Bit mask of ERRC1_0 field.
	CAN_ICR_ERRC1_0_BIT_ERROR             = 0x0        // Bit error
	CAN_ICR_ERRC1_0_FORM_ERROR            = 0x1        // Form error
	CAN_ICR_ERRC1_0_STUFF_ERROR           = 0x2        // Stuff error
	CAN_ICR_ERRC1_0_OTHER_ERROR           = 0x3        // Other error
	CAN_ICR_ALCBIT_Pos                    = 0x18       // Position of ALCBIT field.
	CAN_ICR_ALCBIT_Msk                    = 0xff000000 // Bit mask of ALCBIT field.

	// IER: Interrupt Enable
	CAN_IER_RIE_Pos      = 0x0        // Position of RIE field.
	CAN_IER_RIE_Msk      = 0x1        // Bit mask of RIE field.
	CAN_IER_RIE          = 0x1        // Bit RIE.
	CAN_IER_TIE1_Pos     = 0x1        // Position of TIE1 field.
	CAN_IER_TIE1_Msk     = 0x2        // Bit mask of TIE1 field.
	CAN_IER_TIE1         = 0x2        // Bit TIE1.
	CAN_IER_EIE_Pos      = 0x2        // Position of EIE field.
	CAN_IER_EIE_Msk      = 0x4        // Bit mask of EIE field.
	CAN_IER_EIE          = 0x4        // Bit EIE.
	CAN_IER_DOIE_Pos     = 0x3        // Position of DOIE field.
	CAN_IER_DOIE_Msk     = 0x8        // Bit mask of DOIE field.
	CAN_IER_DOIE         = 0x8        // Bit DOIE.
	CAN_IER_WUIE_Pos     = 0x4        // Position of WUIE field.
	CAN_IER_WUIE_Msk     = 0x10       // Bit mask of WUIE field.
	CAN_IER_WUIE         = 0x10       // Bit WUIE.
	CAN_IER_EPIE_Pos     = 0x5        // Position of EPIE field.
	CAN_IER_EPIE_Msk     = 0x20       // Bit mask of EPIE field.
	CAN_IER_EPIE         = 0x20       // Bit EPIE.
	CAN_IER_ALIE_Pos     = 0x6        // Position of ALIE field.
	CAN_IER_ALIE_Msk     = 0x40       // Bit mask of ALIE field.
	CAN_IER_ALIE         = 0x40       // Bit ALIE.
	CAN_IER_BEIE_Pos     = 0x7        // Position of BEIE field.
	CAN_IER_BEIE_Msk     = 0x80       // Bit mask of BEIE field.
	CAN_IER_BEIE         = 0x80       // Bit BEIE.
	CAN_IER_IDIE_Pos     = 0x8        // Position of IDIE field.
	CAN_IER_IDIE_Msk     = 0x100      // Bit mask of IDIE field.
	CAN_IER_IDIE         = 0x100      // Bit IDIE.
	CAN_IER_TIE2_Pos     = 0x9        // Position of TIE2 field.
	CAN_IER_TIE2_Msk     = 0x200      // Bit mask of TIE2 field.
	CAN_IER_TIE2         = 0x200      // Bit TIE2.
	CAN_IER_TIE3_Pos     = 0xa        // Position of TIE3 field.
	CAN_IER_TIE3_Msk     = 0x400      // Bit mask of TIE3 field.
	CAN_IER_TIE3         = 0x400      // Bit TIE3.
	CAN_IER_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CAN_IER_RESERVED_Msk = 0xfffff800 // Bit mask of RESERVED field.

	// BTR: Bus Timing. Can only be written when RM in CANMOD is 1.
	CAN_BTR_BRP_Pos                  = 0x0        // Position of BRP field.
	CAN_BTR_BRP_Msk                  = 0x3ff      // Bit mask of BRP field.
	CAN_BTR_RESERVED_Pos             = 0xa        // Position of RESERVED field.
	CAN_BTR_RESERVED_Msk             = 0x3c00     // Bit mask of RESERVED field.
	CAN_BTR_SJW_Pos                  = 0xe        // Position of SJW field.
	CAN_BTR_SJW_Msk                  = 0xc000     // Bit mask of SJW field.
	CAN_BTR_TESG1_Pos                = 0x10       // Position of TESG1 field.
	CAN_BTR_TESG1_Msk                = 0xf0000    // Bit mask of TESG1 field.
	CAN_BTR_TESG2_Pos                = 0x14       // Position of TESG2 field.
	CAN_BTR_TESG2_Msk                = 0x700000   // Bit mask of TESG2 field.
	CAN_BTR_SAM_Pos                  = 0x17       // Position of SAM field.
	CAN_BTR_SAM_Msk                  = 0x800000   // Bit mask of SAM field.
	CAN_BTR_SAM                      = 0x800000   // Bit SAM.
	CAN_BTR_SAM_THE_BUS_IS_SAMPLED_O = 0x0        // The bus is sampled once (recommended for high speed buses)
	CAN_BTR_SAM_THE_BUS_IS_SAMPLED_3 = 0x1        // The bus is sampled 3 times (recommended for low to medium speed buses to filter spikes on the bus-line)
	CAN_BTR_RESERVED_Pos             = 0x18       // Position of RESERVED field.
	CAN_BTR_RESERVED_Msk             = 0xff000000 // Bit mask of RESERVED field.

	// EWL: Error Warning Limit. Can only be written when RM in CANMOD is 1.
	CAN_EWL_EWL_Pos      = 0x0        // Position of EWL field.
	CAN_EWL_EWL_Msk      = 0xff       // Bit mask of EWL field.
	CAN_EWL_RESERVED_Pos = 0x8        // Position of RESERVED field.
	CAN_EWL_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// SR: Status Register
	CAN_SR_RBS_1_Pos                  = 0x0        // Position of RBS_1 field.
	CAN_SR_RBS_1_Msk                  = 0x1        // Bit mask of RBS_1 field.
	CAN_SR_RBS_1                      = 0x1        // Bit RBS_1.
	CAN_SR_DOS_1_Pos                  = 0x1        // Position of DOS_1 field.
	CAN_SR_DOS_1_Msk                  = 0x2        // Bit mask of DOS_1 field.
	CAN_SR_DOS_1                      = 0x2        // Bit DOS_1.
	CAN_SR_TBS1_1_Pos                 = 0x2        // Position of TBS1_1 field.
	CAN_SR_TBS1_1_Msk                 = 0x4        // Bit mask of TBS1_1 field.
	CAN_SR_TBS1_1                     = 0x4        // Bit TBS1_1.
	CAN_SR_TBS1_1_LOCKED_SOFTWARE_CAN = 0x0        // Locked. Software cannot access the Tx Buffer 1 nor write to the corresponding CANxTFI, CANxTID, CANxTDA, and CANxTDB registers because a message is either waiting for transmission or is in transmitting process.
	CAN_SR_TBS1_1_RELEASED_SOFTWARE_M = 0x1        // Released. Software may write a message into the Transmit Buffer 1 and its CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_SR_TCS1_1_Pos                 = 0x3        // Position of TCS1_1 field.
	CAN_SR_TCS1_1_Msk                 = 0x8        // Bit mask of TCS1_1 field.
	CAN_SR_TCS1_1                     = 0x8        // Bit TCS1_1.
	CAN_SR_TCS1_1_INCOMPLETE_THE_PREV = 0x0        // Incomplete. The previously requested transmission for Tx Buffer 1 is not complete.
	CAN_SR_TCS1_1_COMPLETE_THE_PREVIO = 0x1        // Complete. The previously requested transmission for Tx Buffer 1 has been successfully completed.
	CAN_SR_RS_1_Pos                   = 0x4        // Position of RS_1 field.
	CAN_SR_RS_1_Msk                   = 0x10       // Bit mask of RS_1 field.
	CAN_SR_RS_1                       = 0x10       // Bit RS_1.
	CAN_SR_TS1_1_Pos                  = 0x5        // Position of TS1_1 field.
	CAN_SR_TS1_1_Msk                  = 0x20       // Bit mask of TS1_1 field.
	CAN_SR_TS1_1                      = 0x20       // Bit TS1_1.
	CAN_SR_TS1_1_IDLE_THERE_IS_NO_TR  = 0x0        // Idle. There is no transmission from Tx Buffer 1.
	CAN_SR_TS1_1_TRANSMIT_THE_CAN_CO  = 0x1        // Transmit. The CAN Controller is transmitting a message from Tx Buffer 1.
	CAN_SR_ES_1_Pos                   = 0x6        // Position of ES_1 field.
	CAN_SR_ES_1_Msk                   = 0x40       // Bit mask of ES_1 field.
	CAN_SR_ES_1                       = 0x40       // Bit ES_1.
	CAN_SR_BS_1_Pos                   = 0x7        // Position of BS_1 field.
	CAN_SR_BS_1_Msk                   = 0x80       // Bit mask of BS_1 field.
	CAN_SR_BS_1                       = 0x80       // Bit BS_1.
	CAN_SR_RBS_2_Pos                  = 0x8        // Position of RBS_2 field.
	CAN_SR_RBS_2_Msk                  = 0x100      // Bit mask of RBS_2 field.
	CAN_SR_RBS_2                      = 0x100      // Bit RBS_2.
	CAN_SR_DOS_2_Pos                  = 0x9        // Position of DOS_2 field.
	CAN_SR_DOS_2_Msk                  = 0x200      // Bit mask of DOS_2 field.
	CAN_SR_DOS_2                      = 0x200      // Bit DOS_2.
	CAN_SR_TBS2_2_Pos                 = 0xa        // Position of TBS2_2 field.
	CAN_SR_TBS2_2_Msk                 = 0x400      // Bit mask of TBS2_2 field.
	CAN_SR_TBS2_2                     = 0x400      // Bit TBS2_2.
	CAN_SR_TBS2_2_LOCKED_SOFTWARE_CAN = 0x0        // Locked. Software cannot access the Tx Buffer 2 nor write to the corresponding CANxTFI, CANxTID, CANxTDA, and CANxTDB registers because a message is either waiting for transmission or is in transmitting process.
	CAN_SR_TBS2_2_RELEASED_SOFTWARE_M = 0x1        // Released. Software may write a message into the Transmit Buffer 2 and its CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_SR_TCS2_2_Pos                 = 0xb        // Position of TCS2_2 field.
	CAN_SR_TCS2_2_Msk                 = 0x800      // Bit mask of TCS2_2 field.
	CAN_SR_TCS2_2                     = 0x800      // Bit TCS2_2.
	CAN_SR_TCS2_2_INCOMPLETE_THE_PREV = 0x0        // Incomplete. The previously requested transmission for Tx Buffer 2 is not complete.
	CAN_SR_TCS2_2_COMPLETE_THE_PREVIO = 0x1        // Complete. The previously requested transmission for Tx Buffer 2 has been successfully completed.
	CAN_SR_RS_2_Pos                   = 0xc        // Position of RS_2 field.
	CAN_SR_RS_2_Msk                   = 0x1000     // Bit mask of RS_2 field.
	CAN_SR_RS_2                       = 0x1000     // Bit RS_2.
	CAN_SR_TS2_2_Pos                  = 0xd        // Position of TS2_2 field.
	CAN_SR_TS2_2_Msk                  = 0x2000     // Bit mask of TS2_2 field.
	CAN_SR_TS2_2                      = 0x2000     // Bit TS2_2.
	CAN_SR_TS2_2_IDLE_THERE_IS_NO_TR  = 0x0        // Idle. There is no transmission from Tx Buffer 2.
	CAN_SR_TS2_2_TRANSMIT_THE_CAN_CO  = 0x1        // Transmit. The CAN Controller is transmitting a message from Tx Buffer 2.
	CAN_SR_ES_2_Pos                   = 0xe        // Position of ES_2 field.
	CAN_SR_ES_2_Msk                   = 0x4000     // Bit mask of ES_2 field.
	CAN_SR_ES_2                       = 0x4000     // Bit ES_2.
	CAN_SR_BS_2_Pos                   = 0xf        // Position of BS_2 field.
	CAN_SR_BS_2_Msk                   = 0x8000     // Bit mask of BS_2 field.
	CAN_SR_BS_2                       = 0x8000     // Bit BS_2.
	CAN_SR_RBS_3_Pos                  = 0x10       // Position of RBS_3 field.
	CAN_SR_RBS_3_Msk                  = 0x10000    // Bit mask of RBS_3 field.
	CAN_SR_RBS_3                      = 0x10000    // Bit RBS_3.
	CAN_SR_DOS_3_Pos                  = 0x11       // Position of DOS_3 field.
	CAN_SR_DOS_3_Msk                  = 0x20000    // Bit mask of DOS_3 field.
	CAN_SR_DOS_3                      = 0x20000    // Bit DOS_3.
	CAN_SR_TBS3_3_Pos                 = 0x12       // Position of TBS3_3 field.
	CAN_SR_TBS3_3_Msk                 = 0x40000    // Bit mask of TBS3_3 field.
	CAN_SR_TBS3_3                     = 0x40000    // Bit TBS3_3.
	CAN_SR_TBS3_3_LOCKED_SOFTWARE_CAN = 0x0        // Locked. Software cannot access the Tx Buffer 3 nor write to the corresponding CANxTFI, CANxTID, CANxTDA, and CANxTDB registers because a message is either waiting for transmission or is in transmitting process.
	CAN_SR_TBS3_3_RELEASED_SOFTWARE_M = 0x1        // Released. Software may write a message into the Transmit Buffer 3 and its CANxTFI, CANxTID, CANxTDA, and CANxTDB registers.
	CAN_SR_TCS3_3_Pos                 = 0x13       // Position of TCS3_3 field.
	CAN_SR_TCS3_3_Msk                 = 0x80000    // Bit mask of TCS3_3 field.
	CAN_SR_TCS3_3                     = 0x80000    // Bit TCS3_3.
	CAN_SR_TCS3_3_INCOMPLETE_THE_PREV = 0x0        // Incomplete. The previously requested transmission for Tx Buffer 3 is not complete.
	CAN_SR_TCS3_3_COMPLETE_THE_PREVIO = 0x1        // Complete. The previously requested transmission for Tx Buffer 3 has been successfully completed.
	CAN_SR_RS_3_Pos                   = 0x14       // Position of RS_3 field.
	CAN_SR_RS_3_Msk                   = 0x100000   // Bit mask of RS_3 field.
	CAN_SR_RS_3                       = 0x100000   // Bit RS_3.
	CAN_SR_TS3_3_Pos                  = 0x15       // Position of TS3_3 field.
	CAN_SR_TS3_3_Msk                  = 0x200000   // Bit mask of TS3_3 field.
	CAN_SR_TS3_3                      = 0x200000   // Bit TS3_3.
	CAN_SR_TS3_3_IDLE_THERE_IS_NO_TR  = 0x0        // Idle. There is no transmission from Tx Buffer 3.
	CAN_SR_TS3_3_TRANSMIT_THE_CAN_CO  = 0x1        // Transmit. The CAN Controller is transmitting a message from Tx Buffer 3.
	CAN_SR_ES_3_Pos                   = 0x16       // Position of ES_3 field.
	CAN_SR_ES_3_Msk                   = 0x400000   // Bit mask of ES_3 field.
	CAN_SR_ES_3                       = 0x400000   // Bit ES_3.
	CAN_SR_BS_3_Pos                   = 0x17       // Position of BS_3 field.
	CAN_SR_BS_3_Msk                   = 0x800000   // Bit mask of BS_3 field.
	CAN_SR_BS_3                       = 0x800000   // Bit BS_3.
	CAN_SR_RESERVED_Pos               = 0x18       // Position of RESERVED field.
	CAN_SR_RESERVED_Msk               = 0xff000000 // Bit mask of RESERVED field.

	// RFS: Receive frame status. Can only be written when RM in CANMOD is 1.
	CAN_RFS_IDINDEX_Pos  = 0x0        // Position of IDINDEX field.
	CAN_RFS_IDINDEX_Msk  = 0x3ff      // Bit mask of IDINDEX field.
	CAN_RFS_BP_Pos       = 0xa        // Position of BP field.
	CAN_RFS_BP_Msk       = 0x400      // Bit mask of BP field.
	CAN_RFS_BP           = 0x400      // Bit BP.
	CAN_RFS_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CAN_RFS_RESERVED_Msk = 0xf800     // Bit mask of RESERVED field.
	CAN_RFS_DLC_Pos      = 0x10       // Position of DLC field.
	CAN_RFS_DLC_Msk      = 0xf0000    // Bit mask of DLC field.
	CAN_RFS_RESERVED_Pos = 0x14       // Position of RESERVED field.
	CAN_RFS_RESERVED_Msk = 0x3ff00000 // Bit mask of RESERVED field.
	CAN_RFS_RTR_Pos      = 0x1e       // Position of RTR field.
	CAN_RFS_RTR_Msk      = 0x40000000 // Bit mask of RTR field.
	CAN_RFS_RTR          = 0x40000000 // Bit RTR.
	CAN_RFS_FF_Pos       = 0x1f       // Position of FF field.
	CAN_RFS_FF_Msk       = 0x80000000 // Bit mask of FF field.
	CAN_RFS_FF           = 0x80000000 // Bit FF.

	// RID: Received Identifier. Can only be written when RM in CANMOD is 1.
	CAN_RID_ID_Pos       = 0x0        // Position of ID field.
	CAN_RID_ID_Msk       = 0x7ff      // Bit mask of ID field.
	CAN_RID_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CAN_RID_RESERVED_Msk = 0xfffff800 // Bit mask of RESERVED field.

	// RDA: Received data bytes 1-4. Can only be written when RM in CANMOD is 1.
	CAN_RDA_DATA1_Pos = 0x0        // Position of DATA1 field.
	CAN_RDA_DATA1_Msk = 0xff       // Bit mask of DATA1 field.
	CAN_RDA_DATA2_Pos = 0x8        // Position of DATA2 field.
	CAN_RDA_DATA2_Msk = 0xff00     // Bit mask of DATA2 field.
	CAN_RDA_DATA3_Pos = 0x10       // Position of DATA3 field.
	CAN_RDA_DATA3_Msk = 0xff0000   // Bit mask of DATA3 field.
	CAN_RDA_DATA4_Pos = 0x18       // Position of DATA4 field.
	CAN_RDA_DATA4_Msk = 0xff000000 // Bit mask of DATA4 field.

	// RDB: Received data bytes 5-8. Can only be written when RM in CANMOD is 1.
	CAN_RDB_DATA5_Pos = 0x0        // Position of DATA5 field.
	CAN_RDB_DATA5_Msk = 0xff       // Bit mask of DATA5 field.
	CAN_RDB_DATA6_Pos = 0x8        // Position of DATA6 field.
	CAN_RDB_DATA6_Msk = 0xff00     // Bit mask of DATA6 field.
	CAN_RDB_DATA7_Pos = 0x10       // Position of DATA7 field.
	CAN_RDB_DATA7_Msk = 0xff0000   // Bit mask of DATA7 field.
	CAN_RDB_DATA8_Pos = 0x18       // Position of DATA8 field.
	CAN_RDB_DATA8_Msk = 0xff000000 // Bit mask of DATA8 field.

	// TFI1: Transmit frame info (Tx Buffer )
	CAN_TFI_PRIO_Pos     = 0x0        // Position of PRIO field.
	CAN_TFI_PRIO_Msk     = 0xff       // Bit mask of PRIO field.
	CAN_TFI_RESERVED_Pos = 0x8        // Position of RESERVED field.
	CAN_TFI_RESERVED_Msk = 0xff00     // Bit mask of RESERVED field.
	CAN_TFI_DLC_Pos      = 0x10       // Position of DLC field.
	CAN_TFI_DLC_Msk      = 0xf0000    // Bit mask of DLC field.
	CAN_TFI_RESERVED_Pos = 0x14       // Position of RESERVED field.
	CAN_TFI_RESERVED_Msk = 0x3ff00000 // Bit mask of RESERVED field.
	CAN_TFI_RTR_Pos      = 0x1e       // Position of RTR field.
	CAN_TFI_RTR_Msk      = 0x40000000 // Bit mask of RTR field.
	CAN_TFI_RTR          = 0x40000000 // Bit RTR.
	CAN_TFI_FF_Pos       = 0x1f       // Position of FF field.
	CAN_TFI_FF_Msk       = 0x80000000 // Bit mask of FF field.
	CAN_TFI_FF           = 0x80000000 // Bit FF.

	// TID1: Transmit Identifier (Tx Buffer)
	CAN_TID_ID_Pos       = 0x0        // Position of ID field.
	CAN_TID_ID_Msk       = 0x7ff      // Bit mask of ID field.
	CAN_TID_RESERVED_Pos = 0xb        // Position of RESERVED field.
	CAN_TID_RESERVED_Msk = 0xfffff800 // Bit mask of RESERVED field.

	// TDA1: Transmit data bytes 1-4 (Tx Buffer)
	CAN_TDA_DATA1_Pos = 0x0        // Position of DATA1 field.
	CAN_TDA_DATA1_Msk = 0xff       // Bit mask of DATA1 field.
	CAN_TDA_DATA2_Pos = 0x8        // Position of DATA2 field.
	CAN_TDA_DATA2_Msk = 0xff00     // Bit mask of DATA2 field.
	CAN_TDA_DATA3_Pos = 0x10       // Position of DATA3 field.
	CAN_TDA_DATA3_Msk = 0xff0000   // Bit mask of DATA3 field.
	CAN_TDA_DATA4_Pos = 0x18       // Position of DATA4 field.
	CAN_TDA_DATA4_Msk = 0xff000000 // Bit mask of DATA4 field.

	// TDB1: Transmit data bytes 5-8 (Tx Buffer )
	CAN_TDB_DATA5_Pos = 0x0        // Position of DATA5 field.
	CAN_TDB_DATA5_Msk = 0xff       // Bit mask of DATA5 field.
	CAN_TDB_DATA6_Pos = 0x8        // Position of DATA6 field.
	CAN_TDB_DATA6_Msk = 0xff00     // Bit mask of DATA6 field.
	CAN_TDB_DATA7_Pos = 0x10       // Position of DATA7 field.
	CAN_TDB_DATA7_Msk = 0xff0000   // Bit mask of DATA7 field.
	CAN_TDB_DATA8_Pos = 0x18       // Position of DATA8 field.
	CAN_TDB_DATA8_Msk = 0xff000000 // Bit mask of DATA8 field.
)

// Bitfields for DAC: Digital-to-Analog Converter (DAC)
const (
	// CR: D/A Converter Register. This register contains the digital value to be converted to analog and a power control bit.
	DAC_CR_RESERVED_Pos = 0x0        // Position of RESERVED field.
	DAC_CR_RESERVED_Msk = 0x3f       // Bit mask of RESERVED field.
	DAC_CR_VALUE_Pos    = 0x6        // Position of VALUE field.
	DAC_CR_VALUE_Msk    = 0xffc0     // Bit mask of VALUE field.
	DAC_CR_BIAS_Pos     = 0x10       // Position of BIAS field.
	DAC_CR_BIAS_Msk     = 0x10000    // Bit mask of BIAS field.
	DAC_CR_BIAS         = 0x10000    // Bit BIAS.
	DAC_CR_BIAS_FAST    = 0x0        // The settling time of the DAC is 1 us max, and the maximum current is 700 uA. This allows a maximum update rate of 1 MHz.
	DAC_CR_BIAS_SLOW    = 0x1        // The settling time of the DAC is 2.5 us and the maximum current is 350 uA. This allows a maximum update rate of 400 kHz.
	DAC_CR_RESERVED_Pos = 0x11       // Position of RESERVED field.
	DAC_CR_RESERVED_Msk = 0xfffe0000 // Bit mask of RESERVED field.

	// CTRL: DAC Control register. This register controls DMA and timer operation.
	DAC_CTRL_INT_DMA_REQ_Pos                  = 0x0        // Position of INT_DMA_REQ field.
	DAC_CTRL_INT_DMA_REQ_Msk                  = 0x1        // Bit mask of INT_DMA_REQ field.
	DAC_CTRL_INT_DMA_REQ                      = 0x1        // Bit INT_DMA_REQ.
	DAC_CTRL_INT_DMA_REQ_CLEAR_ON_ANY_WRITE_T = 0x0        // Clear on any write to the DACR register.
	DAC_CTRL_INT_DMA_REQ_SET_BY_HARDWARE_WHEN = 0x1        // Set by hardware when the timer times out.
	DAC_CTRL_DBLBUF_ENA_Pos                   = 0x1        // Position of DBLBUF_ENA field.
	DAC_CTRL_DBLBUF_ENA_Msk                   = 0x2        // Bit mask of DBLBUF_ENA field.
	DAC_CTRL_DBLBUF_ENA                       = 0x2        // Bit DBLBUF_ENA.
	DAC_CTRL_DBLBUF_ENA_DISABLE               = 0x0        // Disable
	DAC_CTRL_DBLBUF_ENA_ENABLE_WHEN_THIS_BI   = 0x1        // Enable. When this bit and the CNT_ENA bit are both set, the double-buffering feature in the DACR register will be enabled. Writes to the DACR register are written to a pre-buffer and then transferred to the DACR on the next time-out of the counter.
	DAC_CTRL_CNT_ENA_Pos                      = 0x2        // Position of CNT_ENA field.
	DAC_CTRL_CNT_ENA_Msk                      = 0x4        // Bit mask of CNT_ENA field.
	DAC_CTRL_CNT_ENA                          = 0x4        // Bit CNT_ENA.
	DAC_CTRL_CNT_ENA_DISABLE                  = 0x0        // Disable
	DAC_CTRL_CNT_ENA_ENABLE                   = 0x1        // Enable
	DAC_CTRL_DMA_ENA_Pos                      = 0x3        // Position of DMA_ENA field.
	DAC_CTRL_DMA_ENA_Msk                      = 0x8        // Bit mask of DMA_ENA field.
	DAC_CTRL_DMA_ENA                          = 0x8        // Bit DMA_ENA.
	DAC_CTRL_DMA_ENA_DISABLE                  = 0x0        // Disable
	DAC_CTRL_DMA_ENA_ENABLE_DMA_BURST_RE      = 0x1        // Enable. DMA Burst Request Input 7 is enabled for the DAC (see Table 672).
	DAC_CTRL_RESERVED_Pos                     = 0x4        // Position of RESERVED field.
	DAC_CTRL_RESERVED_Msk                     = 0xfffffff0 // Bit mask of RESERVED field.

	// CNTVAL: DAC Counter Value register. This register contains the reload value for the DAC DMA/Interrupt timer.
	DAC_CNTVAL_VALUE_Pos    = 0x0        // Position of VALUE field.
	DAC_CNTVAL_VALUE_Msk    = 0xffff     // Bit mask of VALUE field.
	DAC_CNTVAL_RESERVED_Pos = 0x10       // Position of RESERVED field.
	DAC_CNTVAL_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.
)

// Bitfields for I2S: I2S interface
const (
	// DAO: I2S Digital Audio Output Register. Contains control bits for the I2S transmit channel.
	I2S_DAO_WORDWIDTH_Pos         = 0x0        // Position of WORDWIDTH field.
	I2S_DAO_WORDWIDTH_Msk         = 0x3        // Bit mask of WORDWIDTH field.
	I2S_DAO_WORDWIDTH_8_BIT_DATA  = 0x0        // 8-bit data
	I2S_DAO_WORDWIDTH_16_BIT_DATA = 0x1        // 16-bit data
	I2S_DAO_WORDWIDTH_32_BIT_DATA = 0x3        // 32-bit data
	I2S_DAO_MONO_Pos              = 0x2        // Position of MONO field.
	I2S_DAO_MONO_Msk              = 0x4        // Bit mask of MONO field.
	I2S_DAO_MONO                  = 0x4        // Bit MONO.
	I2S_DAO_STOP_Pos              = 0x3        // Position of STOP field.
	I2S_DAO_STOP_Msk              = 0x8        // Bit mask of STOP field.
	I2S_DAO_STOP                  = 0x8        // Bit STOP.
	I2S_DAO_RESET_Pos             = 0x4        // Position of RESET field.
	I2S_DAO_RESET_Msk             = 0x10       // Bit mask of RESET field.
	I2S_DAO_RESET                 = 0x10       // Bit RESET.
	I2S_DAO_WS_SEL_Pos            = 0x5        // Position of WS_SEL field.
	I2S_DAO_WS_SEL_Msk            = 0x20       // Bit mask of WS_SEL field.
	I2S_DAO_WS_SEL                = 0x20       // Bit WS_SEL.
	I2S_DAO_WS_HALFPERIOD_Pos     = 0x6        // Position of WS_HALFPERIOD field.
	I2S_DAO_WS_HALFPERIOD_Msk     = 0x7fc0     // Bit mask of WS_HALFPERIOD field.
	I2S_DAO_MUTE_Pos              = 0xf        // Position of MUTE field.
	I2S_DAO_MUTE_Msk              = 0x8000     // Bit mask of MUTE field.
	I2S_DAO_MUTE                  = 0x8000     // Bit MUTE.
	I2S_DAO_RESERVED_Pos          = 0x10       // Position of RESERVED field.
	I2S_DAO_RESERVED_Msk          = 0xffff0000 // Bit mask of RESERVED field.

	// DAI: I2S Digital Audio Input Register. Contains control bits for the I2S receive channel.
	I2S_DAI_WORDWIDTH_Pos         = 0x0        // Position of WORDWIDTH field.
	I2S_DAI_WORDWIDTH_Msk         = 0x3        // Bit mask of WORDWIDTH field.
	I2S_DAI_WORDWIDTH_8_BIT_DATA  = 0x0        // 8-bit data
	I2S_DAI_WORDWIDTH_16_BIT_DATA = 0x1        // 16-bit data
	I2S_DAI_WORDWIDTH_32_BIT_DATA = 0x3        // 32-bit data
	I2S_DAI_MONO_Pos              = 0x2        // Position of MONO field.
	I2S_DAI_MONO_Msk              = 0x4        // Bit mask of MONO field.
	I2S_DAI_MONO                  = 0x4        // Bit MONO.
	I2S_DAI_STOP_Pos              = 0x3        // Position of STOP field.
	I2S_DAI_STOP_Msk              = 0x8        // Bit mask of STOP field.
	I2S_DAI_STOP                  = 0x8        // Bit STOP.
	I2S_DAI_RESET_Pos             = 0x4        // Position of RESET field.
	I2S_DAI_RESET_Msk             = 0x10       // Bit mask of RESET field.
	I2S_DAI_RESET                 = 0x10       // Bit RESET.
	I2S_DAI_WS_SEL_Pos            = 0x5        // Position of WS_SEL field.
	I2S_DAI_WS_SEL_Msk            = 0x20       // Bit mask of WS_SEL field.
	I2S_DAI_WS_SEL                = 0x20       // Bit WS_SEL.
	I2S_DAI_WS_HALFPERIOD_Pos     = 0x6        // Position of WS_HALFPERIOD field.
	I2S_DAI_WS_HALFPERIOD_Msk     = 0x7fc0     // Bit mask of WS_HALFPERIOD field.
	I2S_DAI_RESERVED_Pos          = 0xf        // Position of RESERVED field.
	I2S_DAI_RESERVED_Msk          = 0xffff8000 // Bit mask of RESERVED field.

	// TXFIFO: I2S Transmit FIFO. Access register for the 8 x 32-bit transmitter FIFO.
	I2S_TXFIFO_I2STXFIFO_Pos = 0x0        // Position of I2STXFIFO field.
	I2S_TXFIFO_I2STXFIFO_Msk = 0xffffffff // Bit mask of I2STXFIFO field.

	// RXFIFO: I2S Receive FIFO. Access register for the 8 x 32-bit receiver FIFO.
	I2S_RXFIFO_I2SRXFIFO_Pos = 0x0        // Position of I2SRXFIFO field.
	I2S_RXFIFO_I2SRXFIFO_Msk = 0xffffffff // Bit mask of I2SRXFIFO field.

	// STATE: I2S Status Feedback Register. Contains status information about the I2S interface.
	I2S_STATE_IRQ_Pos      = 0x0        // Position of IRQ field.
	I2S_STATE_IRQ_Msk      = 0x1        // Bit mask of IRQ field.
	I2S_STATE_IRQ          = 0x1        // Bit IRQ.
	I2S_STATE_DMAREQ1_Pos  = 0x1        // Position of DMAREQ1 field.
	I2S_STATE_DMAREQ1_Msk  = 0x2        // Bit mask of DMAREQ1 field.
	I2S_STATE_DMAREQ1      = 0x2        // Bit DMAREQ1.
	I2S_STATE_DMAREQ2_Pos  = 0x2        // Position of DMAREQ2 field.
	I2S_STATE_DMAREQ2_Msk  = 0x4        // Bit mask of DMAREQ2 field.
	I2S_STATE_DMAREQ2      = 0x4        // Bit DMAREQ2.
	I2S_STATE_RESERVED_Pos = 0x3        // Position of RESERVED field.
	I2S_STATE_RESERVED_Msk = 0xf8       // Bit mask of RESERVED field.
	I2S_STATE_RX_LEVEL_Pos = 0x8        // Position of RX_LEVEL field.
	I2S_STATE_RX_LEVEL_Msk = 0xf00      // Bit mask of RX_LEVEL field.
	I2S_STATE_RESERVED_Pos = 0xc        // Position of RESERVED field.
	I2S_STATE_RESERVED_Msk = 0xf000     // Bit mask of RESERVED field.
	I2S_STATE_TX_LEVEL_Pos = 0x10       // Position of TX_LEVEL field.
	I2S_STATE_TX_LEVEL_Msk = 0xf0000    // Bit mask of TX_LEVEL field.
	I2S_STATE_RESERVED_Pos = 0x14       // Position of RESERVED field.
	I2S_STATE_RESERVED_Msk = 0xfff00000 // Bit mask of RESERVED field.

	// DMA1: I2S DMA Configuration Register 1. Contains control information for DMA request 1.
	I2S_DMA1_RX_DMA1_ENABLE_Pos = 0x0        // Position of RX_DMA1_ENABLE field.
	I2S_DMA1_RX_DMA1_ENABLE_Msk = 0x1        // Bit mask of RX_DMA1_ENABLE field.
	I2S_DMA1_RX_DMA1_ENABLE     = 0x1        // Bit RX_DMA1_ENABLE.
	I2S_DMA1_TX_DMA1_ENABLE_Pos = 0x1        // Position of TX_DMA1_ENABLE field.
	I2S_DMA1_TX_DMA1_ENABLE_Msk = 0x2        // Bit mask of TX_DMA1_ENABLE field.
	I2S_DMA1_TX_DMA1_ENABLE     = 0x2        // Bit TX_DMA1_ENABLE.
	I2S_DMA1_RESERVED_Pos       = 0x2        // Position of RESERVED field.
	I2S_DMA1_RESERVED_Msk       = 0xfc       // Bit mask of RESERVED field.
	I2S_DMA1_RX_DEPTH_DMA1_Pos  = 0x8        // Position of RX_DEPTH_DMA1 field.
	I2S_DMA1_RX_DEPTH_DMA1_Msk  = 0xf00      // Bit mask of RX_DEPTH_DMA1 field.
	I2S_DMA1_RESERVED_Pos       = 0xc        // Position of RESERVED field.
	I2S_DMA1_RESERVED_Msk       = 0xf000     // Bit mask of RESERVED field.
	I2S_DMA1_TX_DEPTH_DMA1_Pos  = 0x10       // Position of TX_DEPTH_DMA1 field.
	I2S_DMA1_TX_DEPTH_DMA1_Msk  = 0xf0000    // Bit mask of TX_DEPTH_DMA1 field.
	I2S_DMA1_RESERVED_Pos       = 0x14       // Position of RESERVED field.
	I2S_DMA1_RESERVED_Msk       = 0xfff00000 // Bit mask of RESERVED field.

	// DMA2: I2S DMA Configuration Register 2. Contains control information for DMA request 2.
	I2S_DMA2_RX_DMA2_ENABLE_Pos = 0x0        // Position of RX_DMA2_ENABLE field.
	I2S_DMA2_RX_DMA2_ENABLE_Msk = 0x1        // Bit mask of RX_DMA2_ENABLE field.
	I2S_DMA2_RX_DMA2_ENABLE     = 0x1        // Bit RX_DMA2_ENABLE.
	I2S_DMA2_TX_DMA2_ENABLE_Pos = 0x1        // Position of TX_DMA2_ENABLE field.
	I2S_DMA2_TX_DMA2_ENABLE_Msk = 0x2        // Bit mask of TX_DMA2_ENABLE field.
	I2S_DMA2_TX_DMA2_ENABLE     = 0x2        // Bit TX_DMA2_ENABLE.
	I2S_DMA2_RESERVED_Pos       = 0x2        // Position of RESERVED field.
	I2S_DMA2_RESERVED_Msk       = 0xfc       // Bit mask of RESERVED field.
	I2S_DMA2_RX_DEPTH_DMA2_Pos  = 0x8        // Position of RX_DEPTH_DMA2 field.
	I2S_DMA2_RX_DEPTH_DMA2_Msk  = 0xf00      // Bit mask of RX_DEPTH_DMA2 field.
	I2S_DMA2_RESERVED_Pos       = 0xc        // Position of RESERVED field.
	I2S_DMA2_RESERVED_Msk       = 0xf000     // Bit mask of RESERVED field.
	I2S_DMA2_TX_DEPTH_DMA2_Pos  = 0x10       // Position of TX_DEPTH_DMA2 field.
	I2S_DMA2_TX_DEPTH_DMA2_Msk  = 0xf0000    // Bit mask of TX_DEPTH_DMA2 field.
	I2S_DMA2_RESERVED_Pos       = 0x14       // Position of RESERVED field.
	I2S_DMA2_RESERVED_Msk       = 0xfff00000 // Bit mask of RESERVED field.

	// IRQ: I2S Interrupt Request Control Register. Contains bits that control how the I2S interrupt request is generated.
	I2S_IRQ_RX_IRQ_ENABLE_Pos = 0x0        // Position of RX_IRQ_ENABLE field.
	I2S_IRQ_RX_IRQ_ENABLE_Msk = 0x1        // Bit mask of RX_IRQ_ENABLE field.
	I2S_IRQ_RX_IRQ_ENABLE     = 0x1        // Bit RX_IRQ_ENABLE.
	I2S_IRQ_TX_IRQ_ENABLE_Pos = 0x1        // Position of TX_IRQ_ENABLE field.
	I2S_IRQ_TX_IRQ_ENABLE_Msk = 0x2        // Bit mask of TX_IRQ_ENABLE field.
	I2S_IRQ_TX_IRQ_ENABLE     = 0x2        // Bit TX_IRQ_ENABLE.
	I2S_IRQ_RESERVED_Pos      = 0x2        // Position of RESERVED field.
	I2S_IRQ_RESERVED_Msk      = 0xfc       // Bit mask of RESERVED field.
	I2S_IRQ_RX_DEPTH_IRQ_Pos  = 0x8        // Position of RX_DEPTH_IRQ field.
	I2S_IRQ_RX_DEPTH_IRQ_Msk  = 0xf00      // Bit mask of RX_DEPTH_IRQ field.
	I2S_IRQ_RESERVED_Pos      = 0xc        // Position of RESERVED field.
	I2S_IRQ_RESERVED_Msk      = 0xf000     // Bit mask of RESERVED field.
	I2S_IRQ_TX_DEPTH_IRQ_Pos  = 0x10       // Position of TX_DEPTH_IRQ field.
	I2S_IRQ_TX_DEPTH_IRQ_Msk  = 0xf0000    // Bit mask of TX_DEPTH_IRQ field.
	I2S_IRQ_RESERVED_Pos      = 0x14       // Position of RESERVED field.
	I2S_IRQ_RESERVED_Msk      = 0xfff00000 // Bit mask of RESERVED field.

	// TXRATE: I2S Transmit MCLK divider. This register determines the I2S TX MCLK rate by specifying the value to divide PCLK by in order to produce MCLK.
	I2S_TXRATE_Y_DIVIDER_Pos = 0x0        // Position of Y_DIVIDER field.
	I2S_TXRATE_Y_DIVIDER_Msk = 0xff       // Bit mask of Y_DIVIDER field.
	I2S_TXRATE_X_DIVIDER_Pos = 0x8        // Position of X_DIVIDER field.
	I2S_TXRATE_X_DIVIDER_Msk = 0xff00     // Bit mask of X_DIVIDER field.
	I2S_TXRATE_RESERVED_Pos  = 0x10       // Position of RESERVED field.
	I2S_TXRATE_RESERVED_Msk  = 0xffff0000 // Bit mask of RESERVED field.

	// RXRATE: I2S Receive MCLK divider. This register determines the I2S RX MCLK rate by specifying the value to divide PCLK by in order to produce MCLK.
	I2S_RXRATE_Y_DIVIDER_Pos = 0x0        // Position of Y_DIVIDER field.
	I2S_RXRATE_Y_DIVIDER_Msk = 0xff       // Bit mask of Y_DIVIDER field.
	I2S_RXRATE_X_DIVIDER_Pos = 0x8        // Position of X_DIVIDER field.
	I2S_RXRATE_X_DIVIDER_Msk = 0xff00     // Bit mask of X_DIVIDER field.
	I2S_RXRATE_RESERVED_Pos  = 0x10       // Position of RESERVED field.
	I2S_RXRATE_RESERVED_Msk  = 0xffff0000 // Bit mask of RESERVED field.

	// TXBITRATE: I2S Transmit bit rate divider. This register determines the I2S transmit bit rate by specifying the value to divide TX_MCLK by in order to produce the transmit bit clock.
	I2S_TXBITRATE_TX_BITRATE_Pos = 0x0        // Position of TX_BITRATE field.
	I2S_TXBITRATE_TX_BITRATE_Msk = 0x3f       // Bit mask of TX_BITRATE field.
	I2S_TXBITRATE_RESERVED_Pos   = 0x6        // Position of RESERVED field.
	I2S_TXBITRATE_RESERVED_Msk   = 0xffffffc0 // Bit mask of RESERVED field.

	// RXBITRATE: I2S Receive bit rate divider. This register determines the I2S receive bit rate by specifying the value to divide RX_MCLK by in order to produce the receive bit clock.
	I2S_RXBITRATE_RX_BITRATE_Pos = 0x0        // Position of RX_BITRATE field.
	I2S_RXBITRATE_RX_BITRATE_Msk = 0x3f       // Bit mask of RX_BITRATE field.
	I2S_RXBITRATE_RESERVED_Pos   = 0x6        // Position of RESERVED field.
	I2S_RXBITRATE_RESERVED_Msk   = 0xffffffc0 // Bit mask of RESERVED field.

	// TXMODE: I2S Transmit mode control.
	I2S_TXMODE_TXCLKSEL_Pos                  = 0x0        // Position of TXCLKSEL field.
	I2S_TXMODE_TXCLKSEL_Msk                  = 0x3        // Bit mask of TXCLKSEL field.
	I2S_TXMODE_TXCLKSEL_SELECT_THE_TX_FRACTI = 0x0        // Select the TX fractional rate divider clock output as the source
	I2S_TXMODE_TXCLKSEL_SELECT_THE_RX_MCLK_S = 0x2        // Select the RX_MCLK signal as the TX_MCLK clock source
	I2S_TXMODE_TX4PIN_Pos                    = 0x2        // Position of TX4PIN field.
	I2S_TXMODE_TX4PIN_Msk                    = 0x4        // Bit mask of TX4PIN field.
	I2S_TXMODE_TX4PIN                        = 0x4        // Bit TX4PIN.
	I2S_TXMODE_TXMCENA_Pos                   = 0x3        // Position of TXMCENA field.
	I2S_TXMODE_TXMCENA_Msk                   = 0x8        // Bit mask of TXMCENA field.
	I2S_TXMODE_TXMCENA                       = 0x8        // Bit TXMCENA.
	I2S_TXMODE_RESERVED_Pos                  = 0x4        // Position of RESERVED field.
	I2S_TXMODE_RESERVED_Msk                  = 0xfffffff0 // Bit mask of RESERVED field.

	// RXMODE: I2S Receive mode control.
	I2S_RXMODE_RXCLKSEL_Pos                  = 0x0        // Position of RXCLKSEL field.
	I2S_RXMODE_RXCLKSEL_Msk                  = 0x3        // Bit mask of RXCLKSEL field.
	I2S_RXMODE_RXCLKSEL_SELECT_THE_RX_FRACTI = 0x0        // Select the RX fractional rate divider clock output as the source
	I2S_RXMODE_RXCLKSEL_SELECT_THE_TX_MCLK_S = 0x2        // Select the TX_MCLK signal as the RX_MCLK clock source
	I2S_RXMODE_RX4PIN_Pos                    = 0x2        // Position of RX4PIN field.
	I2S_RXMODE_RX4PIN_Msk                    = 0x4        // Bit mask of RX4PIN field.
	I2S_RXMODE_RX4PIN                        = 0x4        // Bit RX4PIN.
	I2S_RXMODE_RXMCENA_Pos                   = 0x3        // Position of RXMCENA field.
	I2S_RXMODE_RXMCENA_Msk                   = 0x8        // Bit mask of RXMCENA field.
	I2S_RXMODE_RXMCENA                       = 0x8        // Bit RXMCENA.
	I2S_RXMODE_RESERVED_Pos                  = 0x4        // Position of RESERVED field.
	I2S_RXMODE_RESERVED_Msk                  = 0xfffffff0 // Bit mask of RESERVED field.
)

// Bitfields for RITIMER: Repetitive Interrupt Timer (RIT)
const (
	// COMPVAL: Compare register
	RIT_COMPVAL_RICOMP_Pos = 0x0        // Position of RICOMP field.
	RIT_COMPVAL_RICOMP_Msk = 0xffffffff // Bit mask of RICOMP field.

	// MASK: Mask register. This register holds the 32-bit mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
	RIT_MASK_RIMASK_Pos = 0x0        // Position of RIMASK field.
	RIT_MASK_RIMASK_Msk = 0xffffffff // Bit mask of RIMASK field.

	// CTRL: Control register.
	RIT_CTRL_RITINT_Pos                    = 0x0        // Position of RITINT field.
	RIT_CTRL_RITINT_Msk                    = 0x1        // Bit mask of RITINT field.
	RIT_CTRL_RITINT                        = 0x1        // Bit RITINT.
	RIT_CTRL_RITINT_THIS_BIT_IS_SET_TO_1   = 0x1        // This bit is set to 1 by hardware whenever the counter value equals the masked compare value specified by the contents of RICOMPVAL and RIMASK registers. Writing a 1 to this bit will clear it to 0. Writing a 0 has no effect.
	RIT_CTRL_RITINT_THE_COUNTER_VALUE_DO   = 0x0        // The counter value does not equal the masked compare value.
	RIT_CTRL_RITENCLR_Pos                  = 0x1        // Position of RITENCLR field.
	RIT_CTRL_RITENCLR_Msk                  = 0x2        // Bit mask of RITENCLR field.
	RIT_CTRL_RITENCLR                      = 0x2        // Bit RITENCLR.
	RIT_CTRL_RITENCLR_THE_TIMER_WILL_BE_CL = 0x1        // The timer will be cleared to 0 whenever the counter value equals the masked compare value specified by the contents of RICOMPVAL and RIMASK registers. This will occur on the same clock that sets the interrupt flag.
	RIT_CTRL_RITENCLR_THE_TIMER_WILL_NOT_B = 0x0        // The timer will not be cleared to 0.
	RIT_CTRL_RITENBR_Pos                   = 0x2        // Position of RITENBR field.
	RIT_CTRL_RITENBR_Msk                   = 0x4        // Bit mask of RITENBR field.
	RIT_CTRL_RITENBR                       = 0x4        // Bit RITENBR.
	RIT_CTRL_RITENBR_THE_TIMER_IS_HALTED_  = 0x1        // The timer is halted when the processor is halted for debugging.
	RIT_CTRL_RITENBR_DEBUG_HAS_NO_EFFECT_  = 0x0        // Debug has no effect on the timer operation.
	RIT_CTRL_RITEN_Pos                     = 0x3        // Position of RITEN field.
	RIT_CTRL_RITEN_Msk                     = 0x8        // Bit mask of RITEN field.
	RIT_CTRL_RITEN                         = 0x8        // Bit RITEN.
	RIT_CTRL_RITEN_TIMER_ENABLED_THIS_     = 0x1        // Timer enabled. This can be overruled by a debug halt if enabled in bit 2.
	RIT_CTRL_RITEN_TIMER_DISABLED_         = 0x0        // Timer disabled.
	RIT_CTRL_RESERVED_Pos                  = 0x4        // Position of RESERVED field.
	RIT_CTRL_RESERVED_Msk                  = 0xfffffff0 // Bit mask of RESERVED field.

	// COUNTER: 32-bit counter
	RIT_COUNTER_RICOUNTER_Pos = 0x0        // Position of RICOUNTER field.
	RIT_COUNTER_RICOUNTER_Msk = 0xffffffff // Bit mask of RICOUNTER field.
)

// Bitfields for MCPWM: Motor Control PWM
const (
	// CON: PWM Control read address
	MCPWM_CON_RUN0_Pos                   = 0x0        // Position of RUN0 field.
	MCPWM_CON_RUN0_Msk                   = 0x1        // Bit mask of RUN0 field.
	MCPWM_CON_RUN0                       = 0x1        // Bit RUN0.
	MCPWM_CON_RUN0_STOP_                 = 0x0        // Stop.
	MCPWM_CON_RUN0_RUN_                  = 0x1        // Run.
	MCPWM_CON_CENTER0_Pos                = 0x1        // Position of CENTER0 field.
	MCPWM_CON_CENTER0_Msk                = 0x2        // Bit mask of CENTER0 field.
	MCPWM_CON_CENTER0                    = 0x2        // Bit CENTER0.
	MCPWM_CON_CENTER0_EDGE_ALIGNED_      = 0x0        // Edge-aligned.
	MCPWM_CON_CENTER0_CENTER_ALIGNED_    = 0x1        // Center-aligned.
	MCPWM_CON_POLA0_Pos                  = 0x2        // Position of POLA0 field.
	MCPWM_CON_POLA0_Msk                  = 0x4        // Bit mask of POLA0 field.
	MCPWM_CON_POLA0                      = 0x4        // Bit POLA0.
	MCPWM_CON_POLA0_PASSIVE_STATE_IS_LOW = 0x0        // Passive state is LOW, active state is HIGH.
	MCPWM_CON_POLA0_PASSIVE_STATE_IS_HIG = 0x1        // Passive state is HIGH, active state is LOW.
	MCPWM_CON_DTE0_Pos                   = 0x3        // Position of DTE0 field.
	MCPWM_CON_DTE0_Msk                   = 0x8        // Bit mask of DTE0 field.
	MCPWM_CON_DTE0                       = 0x8        // Bit DTE0.
	MCPWM_CON_DTE0_DEAD_TIME_DISABLED_   = 0x0        // Dead-time disabled.
	MCPWM_CON_DTE0_DEAD_TIME_ENABLED_    = 0x1        // Dead-time enabled.
	MCPWM_CON_DISUP0_Pos                 = 0x4        // Position of DISUP0 field.
	MCPWM_CON_DISUP0_Msk                 = 0x10       // Bit mask of DISUP0 field.
	MCPWM_CON_DISUP0                     = 0x10       // Bit DISUP0.
	MCPWM_CON_DISUP0_UPDATE              = 0x0        // Functional registers are updated from the write registers at the end of each PWM cycle.
	MCPWM_CON_DISUP0_NOUPDATE            = 0x1        // Functional registers remain the same as long as the timer is running.
	MCPWM_CON_RESERVED_Pos               = 0x5        // Position of RESERVED field.
	MCPWM_CON_RESERVED_Msk               = 0xe0       // Bit mask of RESERVED field.
	MCPWM_CON_RUN1_Pos                   = 0x8        // Position of RUN1 field.
	MCPWM_CON_RUN1_Msk                   = 0x100      // Bit mask of RUN1 field.
	MCPWM_CON_RUN1                       = 0x100      // Bit RUN1.
	MCPWM_CON_RUN1_STOP_                 = 0x0        // Stop.
	MCPWM_CON_RUN1_RUN_                  = 0x1        // Run.
	MCPWM_CON_CENTER1_Pos                = 0x9        // Position of CENTER1 field.
	MCPWM_CON_CENTER1_Msk                = 0x200      // Bit mask of CENTER1 field.
	MCPWM_CON_CENTER1                    = 0x200      // Bit CENTER1.
	MCPWM_CON_CENTER1_EDGE_ALIGNED_      = 0x0        // Edge-aligned.
	MCPWM_CON_CENTER1_CENTER_ALIGNED_    = 0x1        // Center-aligned.
	MCPWM_CON_POLA1_Pos                  = 0xa        // Position of POLA1 field.
	MCPWM_CON_POLA1_Msk                  = 0x400      // Bit mask of POLA1 field.
	MCPWM_CON_POLA1                      = 0x400      // Bit POLA1.
	MCPWM_CON_POLA1_PASSIVE_STATE_IS_LOW = 0x0        // Passive state is LOW, active state is HIGH.
	MCPWM_CON_POLA1_PASSIVE_STATE_IS_HIG = 0x1        // Passive state is HIGH, active state is LOW.
	MCPWM_CON_DTE1_Pos                   = 0xb        // Position of DTE1 field.
	MCPWM_CON_DTE1_Msk                   = 0x800      // Bit mask of DTE1 field.
	MCPWM_CON_DTE1                       = 0x800      // Bit DTE1.
	MCPWM_CON_DTE1_DEAD_TIME_DISABLED_   = 0x0        // Dead-time disabled.
	MCPWM_CON_DTE1_DEAD_TIME_ENABLED_    = 0x1        // Dead-time enabled.
	MCPWM_CON_DISUP1_Pos                 = 0xc        // Position of DISUP1 field.
	MCPWM_CON_DISUP1_Msk                 = 0x1000     // Bit mask of DISUP1 field.
	MCPWM_CON_DISUP1                     = 0x1000     // Bit DISUP1.
	MCPWM_CON_DISUP1_UPDATE              = 0x0        // Functional registers are updated from the write registers at the end of each PWM cycle.
	MCPWM_CON_DISUP1_NOUPDATE            = 0x1        // Functional registers remain the same as long as the timer is running.
	MCPWM_CON_RESERVED_Pos               = 0xd        // Position of RESERVED field.
	MCPWM_CON_RESERVED_Msk               = 0xe000     // Bit mask of RESERVED field.
	MCPWM_CON_RUN2_Pos                   = 0x10       // Position of RUN2 field.
	MCPWM_CON_RUN2_Msk                   = 0x10000    // Bit mask of RUN2 field.
	MCPWM_CON_RUN2                       = 0x10000    // Bit RUN2.
	MCPWM_CON_RUN2_STOP_                 = 0x0        // Stop.
	MCPWM_CON_RUN2_RUN_                  = 0x1        // Run.
	MCPWM_CON_CENTER2_Pos                = 0x11       // Position of CENTER2 field.
	MCPWM_CON_CENTER2_Msk                = 0x20000    // Bit mask of CENTER2 field.
	MCPWM_CON_CENTER2                    = 0x20000    // Bit CENTER2.
	MCPWM_CON_CENTER2_EDGE_ALIGNED_      = 0x0        // Edge-aligned.
	MCPWM_CON_CENTER2_CENTER_ALIGNED_    = 0x1        // Center-aligned.
	MCPWM_CON_POLA2_Pos                  = 0x12       // Position of POLA2 field.
	MCPWM_CON_POLA2_Msk                  = 0x40000    // Bit mask of POLA2 field.
	MCPWM_CON_POLA2                      = 0x40000    // Bit POLA2.
	MCPWM_CON_POLA2_PASSIVE_STATE_IS_LOW = 0x0        // Passive state is LOW, active state is HIGH.
	MCPWM_CON_POLA2_PASSIVE_STATE_IS_HIG = 0x1        // Passive state is HIGH, active state is LOW.
	MCPWM_CON_DTE2_Pos                   = 0x13       // Position of DTE2 field.
	MCPWM_CON_DTE2_Msk                   = 0x80000    // Bit mask of DTE2 field.
	MCPWM_CON_DTE2                       = 0x80000    // Bit DTE2.
	MCPWM_CON_DTE2_DEAD_TIME_DISABLED_   = 0x0        // Dead-time disabled.
	MCPWM_CON_DTE2_DEAD_TIME_ENABLED_    = 0x1        // Dead-time enabled.
	MCPWM_CON_DISUP2_Pos                 = 0x14       // Position of DISUP2 field.
	MCPWM_CON_DISUP2_Msk                 = 0x100000   // Bit mask of DISUP2 field.
	MCPWM_CON_DISUP2                     = 0x100000   // Bit DISUP2.
	MCPWM_CON_DISUP2_UPDATE              = 0x0        // Functional registers are updated from the write registers at the end of each PWM cycle.
	MCPWM_CON_DISUP2_NOUPDATE            = 0x1        // Functional registers remain the same as long as the timer is running.
	MCPWM_CON_RESERVED_Pos               = 0x15       // Position of RESERVED field.
	MCPWM_CON_RESERVED_Msk               = 0x1fe00000 // Bit mask of RESERVED field.
	MCPWM_CON_INVBDC_Pos                 = 0x1d       // Position of INVBDC field.
	MCPWM_CON_INVBDC_Msk                 = 0x20000000 // Bit mask of INVBDC field.
	MCPWM_CON_INVBDC                     = 0x20000000 // Bit INVBDC.
	MCPWM_CON_INVBDC_OPPOSITE            = 0x0        // The MCOB outputs have opposite polarity from the MCOA outputs (aside from dead time).
	MCPWM_CON_INVBDC_SAME                = 0x1        // The MCOB outputs have the same basic polarity as the MCOA outputs. (see Section 24.8.6)
	MCPWM_CON_ACMODE_Pos                 = 0x1e       // Position of ACMODE field.
	MCPWM_CON_ACMODE_Msk                 = 0x40000000 // Bit mask of ACMODE field.
	MCPWM_CON_ACMODE                     = 0x40000000 // Bit ACMODE.
	MCPWM_CON_ACMODE_3_PHASE_AC_MODE_OFF = 0x0        // 3-phase AC-mode off: Each PWM channel uses its own timer-counter and period register.
	MCPWM_CON_ACMODE_3_PHASE_AC_MODE_ON_ = 0x1        // 3-phase AC-mode on: All PWM channels use the timer-counter and period register of channel 0.
	MCPWM_CON_DCMODE_Pos                 = 0x1f       // Position of DCMODE field.
	MCPWM_CON_DCMODE_Msk                 = 0x80000000 // Bit mask of DCMODE field.
	MCPWM_CON_DCMODE                     = 0x80000000 // Bit DCMODE.
	MCPWM_CON_DCMODE_3_PHASE_DC_MODE_OFF = 0x0        // 3-phase DC mode off: PWM channels are independent (unless bit ACMODE = 1)
	MCPWM_CON_DCMODE_3_PHASE_DC_MODE_ON_ = 0x1        // 3-phase DC mode on: The internal MCOA0 output is routed through the CP register (i.e. a mask) register to all six PWM outputs.

	// CON_SET: PWM Control set address
	MCPWM_CON_SET_RUN0_SET_Pos    = 0x0        // Position of RUN0_SET field.
	MCPWM_CON_SET_RUN0_SET_Msk    = 0x1        // Bit mask of RUN0_SET field.
	MCPWM_CON_SET_RUN0_SET        = 0x1        // Bit RUN0_SET.
	MCPWM_CON_SET_CENTER0_SET_Pos = 0x1        // Position of CENTER0_SET field.
	MCPWM_CON_SET_CENTER0_SET_Msk = 0x2        // Bit mask of CENTER0_SET field.
	MCPWM_CON_SET_CENTER0_SET     = 0x2        // Bit CENTER0_SET.
	MCPWM_CON_SET_POLA0_SET_Pos   = 0x2        // Position of POLA0_SET field.
	MCPWM_CON_SET_POLA0_SET_Msk   = 0x4        // Bit mask of POLA0_SET field.
	MCPWM_CON_SET_POLA0_SET       = 0x4        // Bit POLA0_SET.
	MCPWM_CON_SET_DTE0_SET_Pos    = 0x3        // Position of DTE0_SET field.
	MCPWM_CON_SET_DTE0_SET_Msk    = 0x8        // Bit mask of DTE0_SET field.
	MCPWM_CON_SET_DTE0_SET        = 0x8        // Bit DTE0_SET.
	MCPWM_CON_SET_DISUP0_SET_Pos  = 0x4        // Position of DISUP0_SET field.
	MCPWM_CON_SET_DISUP0_SET_Msk  = 0x10       // Bit mask of DISUP0_SET field.
	MCPWM_CON_SET_DISUP0_SET      = 0x10       // Bit DISUP0_SET.
	MCPWM_CON_SET_RESERVED_Pos    = 0x5        // Position of RESERVED field.
	MCPWM_CON_SET_RESERVED_Msk    = 0xe0       // Bit mask of RESERVED field.
	MCPWM_CON_SET_RUN1_SET_Pos    = 0x8        // Position of RUN1_SET field.
	MCPWM_CON_SET_RUN1_SET_Msk    = 0x100      // Bit mask of RUN1_SET field.
	MCPWM_CON_SET_RUN1_SET        = 0x100      // Bit RUN1_SET.
	MCPWM_CON_SET_CENTER1_SET_Pos = 0x9        // Position of CENTER1_SET field.
	MCPWM_CON_SET_CENTER1_SET_Msk = 0x200      // Bit mask of CENTER1_SET field.
	MCPWM_CON_SET_CENTER1_SET     = 0x200      // Bit CENTER1_SET.
	MCPWM_CON_SET_POLA1_SET_Pos   = 0xa        // Position of POLA1_SET field.
	MCPWM_CON_SET_POLA1_SET_Msk   = 0x400      // Bit mask of POLA1_SET field.
	MCPWM_CON_SET_POLA1_SET       = 0x400      // Bit POLA1_SET.
	MCPWM_CON_SET_DTE1_SET_Pos    = 0xb        // Position of DTE1_SET field.
	MCPWM_CON_SET_DTE1_SET_Msk    = 0x800      // Bit mask of DTE1_SET field.
	MCPWM_CON_SET_DTE1_SET        = 0x800      // Bit DTE1_SET.
	MCPWM_CON_SET_DISUP1_SET_Pos  = 0xc        // Position of DISUP1_SET field.
	MCPWM_CON_SET_DISUP1_SET_Msk  = 0x1000     // Bit mask of DISUP1_SET field.
	MCPWM_CON_SET_DISUP1_SET      = 0x1000     // Bit DISUP1_SET.
	MCPWM_CON_SET_RESERVED_Pos    = 0xd        // Position of RESERVED field.
	MCPWM_CON_SET_RESERVED_Msk    = 0xe000     // Bit mask of RESERVED field.
	MCPWM_CON_SET_RUN2_SET_Pos    = 0x10       // Position of RUN2_SET field.
	MCPWM_CON_SET_RUN2_SET_Msk    = 0x10000    // Bit mask of RUN2_SET field.
	MCPWM_CON_SET_RUN2_SET        = 0x10000    // Bit RUN2_SET.
	MCPWM_CON_SET_CENTER2_SET_Pos = 0x11       // Position of CENTER2_SET field.
	MCPWM_CON_SET_CENTER2_SET_Msk = 0x20000    // Bit mask of CENTER2_SET field.
	MCPWM_CON_SET_CENTER2_SET     = 0x20000    // Bit CENTER2_SET.
	MCPWM_CON_SET_POLA2_SET_Pos   = 0x12       // Position of POLA2_SET field.
	MCPWM_CON_SET_POLA2_SET_Msk   = 0x40000    // Bit mask of POLA2_SET field.
	MCPWM_CON_SET_POLA2_SET       = 0x40000    // Bit POLA2_SET.
	MCPWM_CON_SET_DTE2_SET_Pos    = 0x13       // Position of DTE2_SET field.
	MCPWM_CON_SET_DTE2_SET_Msk    = 0x80000    // Bit mask of DTE2_SET field.
	MCPWM_CON_SET_DTE2_SET        = 0x80000    // Bit DTE2_SET.
	MCPWM_CON_SET_DISUP2_SET_Pos  = 0x14       // Position of DISUP2_SET field.
	MCPWM_CON_SET_DISUP2_SET_Msk  = 0x100000   // Bit mask of DISUP2_SET field.
	MCPWM_CON_SET_DISUP2_SET      = 0x100000   // Bit DISUP2_SET.
	MCPWM_CON_SET_RESERVED_Pos    = 0x15       // Position of RESERVED field.
	MCPWM_CON_SET_RESERVED_Msk    = 0x1fe00000 // Bit mask of RESERVED field.
	MCPWM_CON_SET_INVBDC_SET_Pos  = 0x1d       // Position of INVBDC_SET field.
	MCPWM_CON_SET_INVBDC_SET_Msk  = 0x20000000 // Bit mask of INVBDC_SET field.
	MCPWM_CON_SET_INVBDC_SET      = 0x20000000 // Bit INVBDC_SET.
	MCPWM_CON_SET_ACMODE_SET_Pos  = 0x1e       // Position of ACMODE_SET field.
	MCPWM_CON_SET_ACMODE_SET_Msk  = 0x40000000 // Bit mask of ACMODE_SET field.
	MCPWM_CON_SET_ACMODE_SET      = 0x40000000 // Bit ACMODE_SET.
	MCPWM_CON_SET_DCMODE_SET_Pos  = 0x1f       // Position of DCMODE_SET field.
	MCPWM_CON_SET_DCMODE_SET_Msk  = 0x80000000 // Bit mask of DCMODE_SET field.
	MCPWM_CON_SET_DCMODE_SET      = 0x80000000 // Bit DCMODE_SET.

	// CON_CLR: PWM Control clear address
	MCPWM_CON_CLR_RUN0_CLR_Pos    = 0x0        // Position of RUN0_CLR field.
	MCPWM_CON_CLR_RUN0_CLR_Msk    = 0x1        // Bit mask of RUN0_CLR field.
	MCPWM_CON_CLR_RUN0_CLR        = 0x1        // Bit RUN0_CLR.
	MCPWM_CON_CLR_CENTER0_CLR_Pos = 0x1        // Position of CENTER0_CLR field.
	MCPWM_CON_CLR_CENTER0_CLR_Msk = 0x2        // Bit mask of CENTER0_CLR field.
	MCPWM_CON_CLR_CENTER0_CLR     = 0x2        // Bit CENTER0_CLR.
	MCPWM_CON_CLR_POLA0_CLR_Pos   = 0x2        // Position of POLA0_CLR field.
	MCPWM_CON_CLR_POLA0_CLR_Msk   = 0x4        // Bit mask of POLA0_CLR field.
	MCPWM_CON_CLR_POLA0_CLR       = 0x4        // Bit POLA0_CLR.
	MCPWM_CON_CLR_DTE0_CLR_Pos    = 0x3        // Position of DTE0_CLR field.
	MCPWM_CON_CLR_DTE0_CLR_Msk    = 0x8        // Bit mask of DTE0_CLR field.
	MCPWM_CON_CLR_DTE0_CLR        = 0x8        // Bit DTE0_CLR.
	MCPWM_CON_CLR_DISUP0_CLR_Pos  = 0x4        // Position of DISUP0_CLR field.
	MCPWM_CON_CLR_DISUP0_CLR_Msk  = 0x10       // Bit mask of DISUP0_CLR field.
	MCPWM_CON_CLR_DISUP0_CLR      = 0x10       // Bit DISUP0_CLR.
	MCPWM_CON_CLR_RESERVED_Pos    = 0x5        // Position of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Msk    = 0xe0       // Bit mask of RESERVED field.
	MCPWM_CON_CLR_RUN1_CLR_Pos    = 0x8        // Position of RUN1_CLR field.
	MCPWM_CON_CLR_RUN1_CLR_Msk    = 0x100      // Bit mask of RUN1_CLR field.
	MCPWM_CON_CLR_RUN1_CLR        = 0x100      // Bit RUN1_CLR.
	MCPWM_CON_CLR_CENTER1_CLR_Pos = 0x9        // Position of CENTER1_CLR field.
	MCPWM_CON_CLR_CENTER1_CLR_Msk = 0x200      // Bit mask of CENTER1_CLR field.
	MCPWM_CON_CLR_CENTER1_CLR     = 0x200      // Bit CENTER1_CLR.
	MCPWM_CON_CLR_POLA1_CLR_Pos   = 0xa        // Position of POLA1_CLR field.
	MCPWM_CON_CLR_POLA1_CLR_Msk   = 0x400      // Bit mask of POLA1_CLR field.
	MCPWM_CON_CLR_POLA1_CLR       = 0x400      // Bit POLA1_CLR.
	MCPWM_CON_CLR_DTE1_CLR_Pos    = 0xb        // Position of DTE1_CLR field.
	MCPWM_CON_CLR_DTE1_CLR_Msk    = 0x800      // Bit mask of DTE1_CLR field.
	MCPWM_CON_CLR_DTE1_CLR        = 0x800      // Bit DTE1_CLR.
	MCPWM_CON_CLR_DISUP1_CLR_Pos  = 0xc        // Position of DISUP1_CLR field.
	MCPWM_CON_CLR_DISUP1_CLR_Msk  = 0x1000     // Bit mask of DISUP1_CLR field.
	MCPWM_CON_CLR_DISUP1_CLR      = 0x1000     // Bit DISUP1_CLR.
	MCPWM_CON_CLR_RESERVED_Pos    = 0xd        // Position of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Msk    = 0xe000     // Bit mask of RESERVED field.
	MCPWM_CON_CLR_RUN2_CLR_Pos    = 0x10       // Position of RUN2_CLR field.
	MCPWM_CON_CLR_RUN2_CLR_Msk    = 0x10000    // Bit mask of RUN2_CLR field.
	MCPWM_CON_CLR_RUN2_CLR        = 0x10000    // Bit RUN2_CLR.
	MCPWM_CON_CLR_CENTER2_CLR_Pos = 0x11       // Position of CENTER2_CLR field.
	MCPWM_CON_CLR_CENTER2_CLR_Msk = 0x20000    // Bit mask of CENTER2_CLR field.
	MCPWM_CON_CLR_CENTER2_CLR     = 0x20000    // Bit CENTER2_CLR.
	MCPWM_CON_CLR_POLA2_CLR_Pos   = 0x12       // Position of POLA2_CLR field.
	MCPWM_CON_CLR_POLA2_CLR_Msk   = 0x40000    // Bit mask of POLA2_CLR field.
	MCPWM_CON_CLR_POLA2_CLR       = 0x40000    // Bit POLA2_CLR.
	MCPWM_CON_CLR_DTE2_CLR_Pos    = 0x13       // Position of DTE2_CLR field.
	MCPWM_CON_CLR_DTE2_CLR_Msk    = 0x80000    // Bit mask of DTE2_CLR field.
	MCPWM_CON_CLR_DTE2_CLR        = 0x80000    // Bit DTE2_CLR.
	MCPWM_CON_CLR_DISUP2_CLR_Pos  = 0x14       // Position of DISUP2_CLR field.
	MCPWM_CON_CLR_DISUP2_CLR_Msk  = 0x100000   // Bit mask of DISUP2_CLR field.
	MCPWM_CON_CLR_DISUP2_CLR      = 0x100000   // Bit DISUP2_CLR.
	MCPWM_CON_CLR_RESERVED_Pos    = 0x15       // Position of RESERVED field.
	MCPWM_CON_CLR_RESERVED_Msk    = 0x1fe00000 // Bit mask of RESERVED field.
	MCPWM_CON_CLR_INVBDC_CLR_Pos  = 0x1d       // Position of INVBDC_CLR field.
	MCPWM_CON_CLR_INVBDC_CLR_Msk  = 0x20000000 // Bit mask of INVBDC_CLR field.
	MCPWM_CON_CLR_INVBDC_CLR      = 0x20000000 // Bit INVBDC_CLR.
	MCPWM_CON_CLR_ACMOD_CLR_Pos   = 0x1e       // Position of ACMOD_CLR field.
	MCPWM_CON_CLR_ACMOD_CLR_Msk   = 0x40000000 // Bit mask of ACMOD_CLR field.
	MCPWM_CON_CLR_ACMOD_CLR       = 0x40000000 // Bit ACMOD_CLR.
	MCPWM_CON_CLR_DCMODE_CLR_Pos  = 0x1f       // Position of DCMODE_CLR field.
	MCPWM_CON_CLR_DCMODE_CLR_Msk  = 0x80000000 // Bit mask of DCMODE_CLR field.
	MCPWM_CON_CLR_DCMODE_CLR      = 0x80000000 // Bit DCMODE_CLR.

	// CAPCON: Capture Control read address
	MCPWM_CAPCON_CAP0MCI0_RE_Pos = 0x0        // Position of CAP0MCI0_RE field.
	MCPWM_CAPCON_CAP0MCI0_RE_Msk = 0x1        // Bit mask of CAP0MCI0_RE field.
	MCPWM_CAPCON_CAP0MCI0_RE     = 0x1        // Bit CAP0MCI0_RE.
	MCPWM_CAPCON_CAP0MCI0_FE_Pos = 0x1        // Position of CAP0MCI0_FE field.
	MCPWM_CAPCON_CAP0MCI0_FE_Msk = 0x2        // Bit mask of CAP0MCI0_FE field.
	MCPWM_CAPCON_CAP0MCI0_FE     = 0x2        // Bit CAP0MCI0_FE.
	MCPWM_CAPCON_CAP0MCI1_RE_Pos = 0x2        // Position of CAP0MCI1_RE field.
	MCPWM_CAPCON_CAP0MCI1_RE_Msk = 0x4        // Bit mask of CAP0MCI1_RE field.
	MCPWM_CAPCON_CAP0MCI1_RE     = 0x4        // Bit CAP0MCI1_RE.
	MCPWM_CAPCON_CAP0MCI1_FE_Pos = 0x3        // Position of CAP0MCI1_FE field.
	MCPWM_CAPCON_CAP0MCI1_FE_Msk = 0x8        // Bit mask of CAP0MCI1_FE field.
	MCPWM_CAPCON_CAP0MCI1_FE     = 0x8        // Bit CAP0MCI1_FE.
	MCPWM_CAPCON_CAP0MCI2_RE_Pos = 0x4        // Position of CAP0MCI2_RE field.
	MCPWM_CAPCON_CAP0MCI2_RE_Msk = 0x10       // Bit mask of CAP0MCI2_RE field.
	MCPWM_CAPCON_CAP0MCI2_RE     = 0x10       // Bit CAP0MCI2_RE.
	MCPWM_CAPCON_CAP0MCI2_FE_Pos = 0x5        // Position of CAP0MCI2_FE field.
	MCPWM_CAPCON_CAP0MCI2_FE_Msk = 0x20       // Bit mask of CAP0MCI2_FE field.
	MCPWM_CAPCON_CAP0MCI2_FE     = 0x20       // Bit CAP0MCI2_FE.
	MCPWM_CAPCON_CAP1MCI0_RE_Pos = 0x6        // Position of CAP1MCI0_RE field.
	MCPWM_CAPCON_CAP1MCI0_RE_Msk = 0x40       // Bit mask of CAP1MCI0_RE field.
	MCPWM_CAPCON_CAP1MCI0_RE     = 0x40       // Bit CAP1MCI0_RE.
	MCPWM_CAPCON_CAP1MCI0_FE_Pos = 0x7        // Position of CAP1MCI0_FE field.
	MCPWM_CAPCON_CAP1MCI0_FE_Msk = 0x80       // Bit mask of CAP1MCI0_FE field.
	MCPWM_CAPCON_CAP1MCI0_FE     = 0x80       // Bit CAP1MCI0_FE.
	MCPWM_CAPCON_CAP1MCI1_RE_Pos = 0x8        // Position of CAP1MCI1_RE field.
	MCPWM_CAPCON_CAP1MCI1_RE_Msk = 0x100      // Bit mask of CAP1MCI1_RE field.
	MCPWM_CAPCON_CAP1MCI1_RE     = 0x100      // Bit CAP1MCI1_RE.
	MCPWM_CAPCON_CAP1MCI1_FE_Pos = 0x9        // Position of CAP1MCI1_FE field.
	MCPWM_CAPCON_CAP1MCI1_FE_Msk = 0x200      // Bit mask of CAP1MCI1_FE field.
	MCPWM_CAPCON_CAP1MCI1_FE     = 0x200      // Bit CAP1MCI1_FE.
	MCPWM_CAPCON_CAP1MCI2_RE_Pos = 0xa        // Position of CAP1MCI2_RE field.
	MCPWM_CAPCON_CAP1MCI2_RE_Msk = 0x400      // Bit mask of CAP1MCI2_RE field.
	MCPWM_CAPCON_CAP1MCI2_RE     = 0x400      // Bit CAP1MCI2_RE.
	MCPWM_CAPCON_CAP1MCI2_FE_Pos = 0xb        // Position of CAP1MCI2_FE field.
	MCPWM_CAPCON_CAP1MCI2_FE_Msk = 0x800      // Bit mask of CAP1MCI2_FE field.
	MCPWM_CAPCON_CAP1MCI2_FE     = 0x800      // Bit CAP1MCI2_FE.
	MCPWM_CAPCON_CAP2MCI0_RE_Pos = 0xc        // Position of CAP2MCI0_RE field.
	MCPWM_CAPCON_CAP2MCI0_RE_Msk = 0x1000     // Bit mask of CAP2MCI0_RE field.
	MCPWM_CAPCON_CAP2MCI0_RE     = 0x1000     // Bit CAP2MCI0_RE.
	MCPWM_CAPCON_CAP2MCI0_FE_Pos = 0xd        // Position of CAP2MCI0_FE field.
	MCPWM_CAPCON_CAP2MCI0_FE_Msk = 0x2000     // Bit mask of CAP2MCI0_FE field.
	MCPWM_CAPCON_CAP2MCI0_FE     = 0x2000     // Bit CAP2MCI0_FE.
	MCPWM_CAPCON_CAP2MCI1_RE_Pos = 0xe        // Position of CAP2MCI1_RE field.
	MCPWM_CAPCON_CAP2MCI1_RE_Msk = 0x4000     // Bit mask of CAP2MCI1_RE field.
	MCPWM_CAPCON_CAP2MCI1_RE     = 0x4000     // Bit CAP2MCI1_RE.
	MCPWM_CAPCON_CAP2MCI1_FE_Pos = 0xf        // Position of CAP2MCI1_FE field.
	MCPWM_CAPCON_CAP2MCI1_FE_Msk = 0x8000     // Bit mask of CAP2MCI1_FE field.
	MCPWM_CAPCON_CAP2MCI1_FE     = 0x8000     // Bit CAP2MCI1_FE.
	MCPWM_CAPCON_CAP2MCI2_RE_Pos = 0x10       // Position of CAP2MCI2_RE field.
	MCPWM_CAPCON_CAP2MCI2_RE_Msk = 0x10000    // Bit mask of CAP2MCI2_RE field.
	MCPWM_CAPCON_CAP2MCI2_RE     = 0x10000    // Bit CAP2MCI2_RE.
	MCPWM_CAPCON_CAP2MCI2_FE_Pos = 0x11       // Position of CAP2MCI2_FE field.
	MCPWM_CAPCON_CAP2MCI2_FE_Msk = 0x20000    // Bit mask of CAP2MCI2_FE field.
	MCPWM_CAPCON_CAP2MCI2_FE     = 0x20000    // Bit CAP2MCI2_FE.
	MCPWM_CAPCON_RT0_Pos         = 0x12       // Position of RT0 field.
	MCPWM_CAPCON_RT0_Msk         = 0x40000    // Bit mask of RT0 field.
	MCPWM_CAPCON_RT0             = 0x40000    // Bit RT0.
	MCPWM_CAPCON_RT1_Pos         = 0x13       // Position of RT1 field.
	MCPWM_CAPCON_RT1_Msk         = 0x80000    // Bit mask of RT1 field.
	MCPWM_CAPCON_RT1             = 0x80000    // Bit RT1.
	MCPWM_CAPCON_RT2_Pos         = 0x14       // Position of RT2 field.
	MCPWM_CAPCON_RT2_Msk         = 0x100000   // Bit mask of RT2 field.
	MCPWM_CAPCON_RT2             = 0x100000   // Bit RT2.
	MCPWM_CAPCON_RESERVED_Pos    = 0x15       // Position of RESERVED field.
	MCPWM_CAPCON_RESERVED_Msk    = 0xffe00000 // Bit mask of RESERVED field.

	// CAPCON_SET: Capture Control set address
	MCPWM_CAPCON_SET_CAP0MCI0_RE_SET_Pos = 0x0        // Position of CAP0MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_RE_SET_Msk = 0x1        // Bit mask of CAP0MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_RE_SET     = 0x1        // Bit CAP0MCI0_RE_SET.
	MCPWM_CAPCON_SET_CAP0MCI0_FE_SET_Pos = 0x1        // Position of CAP0MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_FE_SET_Msk = 0x2        // Bit mask of CAP0MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI0_FE_SET     = 0x2        // Bit CAP0MCI0_FE_SET.
	MCPWM_CAPCON_SET_CAP0MCI1_RE_SET_Pos = 0x2        // Position of CAP0MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_RE_SET_Msk = 0x4        // Bit mask of CAP0MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_RE_SET     = 0x4        // Bit CAP0MCI1_RE_SET.
	MCPWM_CAPCON_SET_CAP0MCI1_FE_SET_Pos = 0x3        // Position of CAP0MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_FE_SET_Msk = 0x8        // Bit mask of CAP0MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI1_FE_SET     = 0x8        // Bit CAP0MCI1_FE_SET.
	MCPWM_CAPCON_SET_CAP0MCI2_RE_SET_Pos = 0x4        // Position of CAP0MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_RE_SET_Msk = 0x10       // Bit mask of CAP0MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_RE_SET     = 0x10       // Bit CAP0MCI2_RE_SET.
	MCPWM_CAPCON_SET_CAP0MCI2_FE_SET_Pos = 0x5        // Position of CAP0MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_FE_SET_Msk = 0x20       // Bit mask of CAP0MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP0MCI2_FE_SET     = 0x20       // Bit CAP0MCI2_FE_SET.
	MCPWM_CAPCON_SET_CAP1MCI0_RE_SET_Pos = 0x6        // Position of CAP1MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_RE_SET_Msk = 0x40       // Bit mask of CAP1MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_RE_SET     = 0x40       // Bit CAP1MCI0_RE_SET.
	MCPWM_CAPCON_SET_CAP1MCI0_FE_SET_Pos = 0x7        // Position of CAP1MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_FE_SET_Msk = 0x80       // Bit mask of CAP1MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI0_FE_SET     = 0x80       // Bit CAP1MCI0_FE_SET.
	MCPWM_CAPCON_SET_CAP1MCI1_RE_SET_Pos = 0x8        // Position of CAP1MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_RE_SET_Msk = 0x100      // Bit mask of CAP1MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_RE_SET     = 0x100      // Bit CAP1MCI1_RE_SET.
	MCPWM_CAPCON_SET_CAP1MCI1_FE_SET_Pos = 0x9        // Position of CAP1MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_FE_SET_Msk = 0x200      // Bit mask of CAP1MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI1_FE_SET     = 0x200      // Bit CAP1MCI1_FE_SET.
	MCPWM_CAPCON_SET_CAP1MCI2_RE_SET_Pos = 0xa        // Position of CAP1MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_RE_SET_Msk = 0x400      // Bit mask of CAP1MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_RE_SET     = 0x400      // Bit CAP1MCI2_RE_SET.
	MCPWM_CAPCON_SET_CAP1MCI2_FE_SET_Pos = 0xb        // Position of CAP1MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_FE_SET_Msk = 0x800      // Bit mask of CAP1MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP1MCI2_FE_SET     = 0x800      // Bit CAP1MCI2_FE_SET.
	MCPWM_CAPCON_SET_CAP2MCI0_RE_SET_Pos = 0xc        // Position of CAP2MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_RE_SET_Msk = 0x1000     // Bit mask of CAP2MCI0_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_RE_SET     = 0x1000     // Bit CAP2MCI0_RE_SET.
	MCPWM_CAPCON_SET_CAP2MCI0_FE_SET_Pos = 0xd        // Position of CAP2MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_FE_SET_Msk = 0x2000     // Bit mask of CAP2MCI0_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI0_FE_SET     = 0x2000     // Bit CAP2MCI0_FE_SET.
	MCPWM_CAPCON_SET_CAP2MCI1_RE_SET_Pos = 0xe        // Position of CAP2MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_RE_SET_Msk = 0x4000     // Bit mask of CAP2MCI1_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_RE_SET     = 0x4000     // Bit CAP2MCI1_RE_SET.
	MCPWM_CAPCON_SET_CAP2MCI1_FE_SET_Pos = 0xf        // Position of CAP2MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_FE_SET_Msk = 0x8000     // Bit mask of CAP2MCI1_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI1_FE_SET     = 0x8000     // Bit CAP2MCI1_FE_SET.
	MCPWM_CAPCON_SET_CAP2MCI2_RE_SET_Pos = 0x10       // Position of CAP2MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_RE_SET_Msk = 0x10000    // Bit mask of CAP2MCI2_RE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_RE_SET     = 0x10000    // Bit CAP2MCI2_RE_SET.
	MCPWM_CAPCON_SET_CAP2MCI2_FE_SET_Pos = 0x11       // Position of CAP2MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_FE_SET_Msk = 0x20000    // Bit mask of CAP2MCI2_FE_SET field.
	MCPWM_CAPCON_SET_CAP2MCI2_FE_SET     = 0x20000    // Bit CAP2MCI2_FE_SET.
	MCPWM_CAPCON_SET_RT0_SET_Pos         = 0x12       // Position of RT0_SET field.
	MCPWM_CAPCON_SET_RT0_SET_Msk         = 0x40000    // Bit mask of RT0_SET field.
	MCPWM_CAPCON_SET_RT0_SET             = 0x40000    // Bit RT0_SET.
	MCPWM_CAPCON_SET_RT1_SET_Pos         = 0x13       // Position of RT1_SET field.
	MCPWM_CAPCON_SET_RT1_SET_Msk         = 0x80000    // Bit mask of RT1_SET field.
	MCPWM_CAPCON_SET_RT1_SET             = 0x80000    // Bit RT1_SET.
	MCPWM_CAPCON_SET_RT2_SET_Pos         = 0x14       // Position of RT2_SET field.
	MCPWM_CAPCON_SET_RT2_SET_Msk         = 0x100000   // Bit mask of RT2_SET field.
	MCPWM_CAPCON_SET_RT2_SET             = 0x100000   // Bit RT2_SET.
	MCPWM_CAPCON_SET_RESERVED_Pos        = 0x15       // Position of RESERVED field.
	MCPWM_CAPCON_SET_RESERVED_Msk        = 0xffe00000 // Bit mask of RESERVED field.

	// CAPCON_CLR: Event Control clear address
	MCPWM_CAPCON_CLR_CAP0MCI0_RE_CLR_Pos = 0x0        // Position of CAP0MCI0_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI0_RE_CLR_Msk = 0x1        // Bit mask of CAP0MCI0_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI0_RE_CLR     = 0x1        // Bit CAP0MCI0_RE_CLR.
	MCPWM_CAPCON_CLR_CAP0MCI0_FE_CLR_Pos = 0x1        // Position of CAP0MCI0_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI0_FE_CLR_Msk = 0x2        // Bit mask of CAP0MCI0_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI0_FE_CLR     = 0x2        // Bit CAP0MCI0_FE_CLR.
	MCPWM_CAPCON_CLR_CAP0MCI1_RE_CLR_Pos = 0x2        // Position of CAP0MCI1_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI1_RE_CLR_Msk = 0x4        // Bit mask of CAP0MCI1_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI1_RE_CLR     = 0x4        // Bit CAP0MCI1_RE_CLR.
	MCPWM_CAPCON_CLR_CAP0MCI1_FE_CLR_Pos = 0x3        // Position of CAP0MCI1_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI1_FE_CLR_Msk = 0x8        // Bit mask of CAP0MCI1_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI1_FE_CLR     = 0x8        // Bit CAP0MCI1_FE_CLR.
	MCPWM_CAPCON_CLR_CAP0MCI2_RE_CLR_Pos = 0x4        // Position of CAP0MCI2_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI2_RE_CLR_Msk = 0x10       // Bit mask of CAP0MCI2_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI2_RE_CLR     = 0x10       // Bit CAP0MCI2_RE_CLR.
	MCPWM_CAPCON_CLR_CAP0MCI2_FE_CLR_Pos = 0x5        // Position of CAP0MCI2_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI2_FE_CLR_Msk = 0x20       // Bit mask of CAP0MCI2_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP0MCI2_FE_CLR     = 0x20       // Bit CAP0MCI2_FE_CLR.
	MCPWM_CAPCON_CLR_CAP1MCI0_RE_CLR_Pos = 0x6        // Position of CAP1MCI0_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI0_RE_CLR_Msk = 0x40       // Bit mask of CAP1MCI0_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI0_RE_CLR     = 0x40       // Bit CAP1MCI0_RE_CLR.
	MCPWM_CAPCON_CLR_CAP1MCI0_FE_CLR_Pos = 0x7        // Position of CAP1MCI0_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI0_FE_CLR_Msk = 0x80       // Bit mask of CAP1MCI0_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI0_FE_CLR     = 0x80       // Bit CAP1MCI0_FE_CLR.
	MCPWM_CAPCON_CLR_CAP1MCI1_RE_CLR_Pos = 0x8        // Position of CAP1MCI1_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI1_RE_CLR_Msk = 0x100      // Bit mask of CAP1MCI1_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI1_RE_CLR     = 0x100      // Bit CAP1MCI1_RE_CLR.
	MCPWM_CAPCON_CLR_CAP1MCI1_FE_CLR_Pos = 0x9        // Position of CAP1MCI1_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI1_FE_CLR_Msk = 0x200      // Bit mask of CAP1MCI1_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI1_FE_CLR     = 0x200      // Bit CAP1MCI1_FE_CLR.
	MCPWM_CAPCON_CLR_CAP1MCI2_RE_CLR_Pos = 0xa        // Position of CAP1MCI2_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI2_RE_CLR_Msk = 0x400      // Bit mask of CAP1MCI2_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI2_RE_CLR     = 0x400      // Bit CAP1MCI2_RE_CLR.
	MCPWM_CAPCON_CLR_CAP1MCI2_FE_CLR_Pos = 0xb        // Position of CAP1MCI2_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI2_FE_CLR_Msk = 0x800      // Bit mask of CAP1MCI2_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP1MCI2_FE_CLR     = 0x800      // Bit CAP1MCI2_FE_CLR.
	MCPWM_CAPCON_CLR_CAP2MCI0_RE_CLR_Pos = 0xc        // Position of CAP2MCI0_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI0_RE_CLR_Msk = 0x1000     // Bit mask of CAP2MCI0_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI0_RE_CLR     = 0x1000     // Bit CAP2MCI0_RE_CLR.
	MCPWM_CAPCON_CLR_CAP2MCI0_FE_CLR_Pos = 0xd        // Position of CAP2MCI0_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI0_FE_CLR_Msk = 0x2000     // Bit mask of CAP2MCI0_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI0_FE_CLR     = 0x2000     // Bit CAP2MCI0_FE_CLR.
	MCPWM_CAPCON_CLR_CAP2MCI1_RE_CLR_Pos = 0xe        // Position of CAP2MCI1_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI1_RE_CLR_Msk = 0x4000     // Bit mask of CAP2MCI1_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI1_RE_CLR     = 0x4000     // Bit CAP2MCI1_RE_CLR.
	MCPWM_CAPCON_CLR_CAP2MCI1_FE_CLR_Pos = 0xf        // Position of CAP2MCI1_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI1_FE_CLR_Msk = 0x8000     // Bit mask of CAP2MCI1_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI1_FE_CLR     = 0x8000     // Bit CAP2MCI1_FE_CLR.
	MCPWM_CAPCON_CLR_CAP2MCI2_RE_CLR_Pos = 0x10       // Position of CAP2MCI2_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI2_RE_CLR_Msk = 0x10000    // Bit mask of CAP2MCI2_RE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI2_RE_CLR     = 0x10000    // Bit CAP2MCI2_RE_CLR.
	MCPWM_CAPCON_CLR_CAP2MCI2_FE_CLR_Pos = 0x11       // Position of CAP2MCI2_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI2_FE_CLR_Msk = 0x20000    // Bit mask of CAP2MCI2_FE_CLR field.
	MCPWM_CAPCON_CLR_CAP2MCI2_FE_CLR     = 0x20000    // Bit CAP2MCI2_FE_CLR.
	MCPWM_CAPCON_CLR_RT0_CLR_Pos         = 0x12       // Position of RT0_CLR field.
	MCPWM_CAPCON_CLR_RT0_CLR_Msk         = 0x40000    // Bit mask of RT0_CLR field.
	MCPWM_CAPCON_CLR_RT0_CLR             = 0x40000    // Bit RT0_CLR.
	MCPWM_CAPCON_CLR_RT1_CLR_Pos         = 0x13       // Position of RT1_CLR field.
	MCPWM_CAPCON_CLR_RT1_CLR_Msk         = 0x80000    // Bit mask of RT1_CLR field.
	MCPWM_CAPCON_CLR_RT1_CLR             = 0x80000    // Bit RT1_CLR.
	MCPWM_CAPCON_CLR_RT2_CLR_Pos         = 0x14       // Position of RT2_CLR field.
	MCPWM_CAPCON_CLR_RT2_CLR_Msk         = 0x100000   // Bit mask of RT2_CLR field.
	MCPWM_CAPCON_CLR_RT2_CLR             = 0x100000   // Bit RT2_CLR.
	MCPWM_CAPCON_CLR_RESERVED_Pos        = 0x15       // Position of RESERVED field.
	MCPWM_CAPCON_CLR_RESERVED_Msk        = 0xffe00000 // Bit mask of RESERVED field.

	// TC: Timer Counter register
	MCPWM_TC_MCTC_Pos = 0x0        // Position of MCTC field.
	MCPWM_TC_MCTC_Msk = 0xffffffff // Bit mask of MCTC field.

	// LIM: Limit register
	MCPWM_LIM_MCLIM_Pos = 0x0        // Position of MCLIM field.
	MCPWM_LIM_MCLIM_Msk = 0xffffffff // Bit mask of MCLIM field.

	// MAT: Match register
	MCPWM_MAT_MCMAT_Pos = 0x0        // Position of MCMAT field.
	MCPWM_MAT_MCMAT_Msk = 0xffffffff // Bit mask of MCMAT field.

	// DT: Dead time register
	MCPWM_DT_DT0_Pos      = 0x0        // Position of DT0 field.
	MCPWM_DT_DT0_Msk      = 0x3ff      // Bit mask of DT0 field.
	MCPWM_DT_DT1_Pos      = 0xa        // Position of DT1 field.
	MCPWM_DT_DT1_Msk      = 0xffc00    // Bit mask of DT1 field.
	MCPWM_DT_DT2_Pos      = 0x14       // Position of DT2 field.
	MCPWM_DT_DT2_Msk      = 0x3ff00000 // Bit mask of DT2 field.
	MCPWM_DT_RESERVED_Pos = 0x1e       // Position of RESERVED field.
	MCPWM_DT_RESERVED_Msk = 0xc0000000 // Bit mask of RESERVED field.

	// CP: Communication Pattern register
	MCPWM_CP_CCPA0_Pos                  = 0x0        // Position of CCPA0 field.
	MCPWM_CP_CCPA0_Msk                  = 0x1        // Bit mask of CCPA0 field.
	MCPWM_CP_CCPA0                      = 0x1        // Bit CCPA0.
	MCPWM_CP_CCPA0_MCOA0_PASSIVE_       = 0x0        // MCOA0 passive.
	MCPWM_CP_CCPA0_INTERNAL_MCOA0_      = 0x1        // internal MCOA0.
	MCPWM_CP_CCPB0_Pos                  = 0x1        // Position of CCPB0 field.
	MCPWM_CP_CCPB0_Msk                  = 0x2        // Bit mask of CCPB0 field.
	MCPWM_CP_CCPB0                      = 0x2        // Bit CCPB0.
	MCPWM_CP_CCPB0_MCOB0_PASSIVE_       = 0x0        // MCOB0 passive.
	MCPWM_CP_CCPB0_MCOB0_TRACKS_INTERNA = 0x1        // MCOB0 tracks internal MCOA0.
	MCPWM_CP_CCPA1_Pos                  = 0x2        // Position of CCPA1 field.
	MCPWM_CP_CCPA1_Msk                  = 0x4        // Bit mask of CCPA1 field.
	MCPWM_CP_CCPA1                      = 0x4        // Bit CCPA1.
	MCPWM_CP_CCPA1_MCOA1_PASSIVE_       = 0x0        // MCOA1 passive.
	MCPWM_CP_CCPA1_MCOA1_TRACKS_INTERNA = 0x1        // MCOA1 tracks internal MCOA0.
	MCPWM_CP_CCPB1_Pos                  = 0x3        // Position of CCPB1 field.
	MCPWM_CP_CCPB1_Msk                  = 0x8        // Bit mask of CCPB1 field.
	MCPWM_CP_CCPB1                      = 0x8        // Bit CCPB1.
	MCPWM_CP_CCPB1_MCOB1_PASSIVE_       = 0x0        // MCOB1 passive.
	MCPWM_CP_CCPB1_MCOB1_TRACKS_INTERNA = 0x1        // MCOB1 tracks internal MCOA0.
	MCPWM_CP_CCPA2_Pos                  = 0x4        // Position of CCPA2 field.
	MCPWM_CP_CCPA2_Msk                  = 0x10       // Bit mask of CCPA2 field.
	MCPWM_CP_CCPA2                      = 0x10       // Bit CCPA2.
	MCPWM_CP_CCPA2_MCOA2_PASSIVE_       = 0x0        // MCOA2 passive.
	MCPWM_CP_CCPA2_MCOA2_TRACKS_INTERNA = 0x1        // MCOA2 tracks internal MCOA0.
	MCPWM_CP_CCPB2_Pos                  = 0x5        // Position of CCPB2 field.
	MCPWM_CP_CCPB2_Msk                  = 0x20       // Bit mask of CCPB2 field.
	MCPWM_CP_CCPB2                      = 0x20       // Bit CCPB2.
	MCPWM_CP_CCPB2_MCOB2_PASSIVE_       = 0x0        // MCOB2 passive.
	MCPWM_CP_CCPB2_MCOB2_TRACKS_INTERNA = 0x1        // MCOB2 tracks internal MCOA0.
	MCPWM_CP_RESERVED_Pos               = 0x6        // Position of RESERVED field.
	MCPWM_CP_RESERVED_Msk               = 0xffffffc0 // Bit mask of RESERVED field.

	// CAP: Capture register
	MCPWM_CAP_CAP_Pos = 0x0        // Position of CAP field.
	MCPWM_CAP_CAP_Msk = 0xffffffff // Bit mask of CAP field.

	// INTEN: Interrupt Enable read address
	MCPWM_INTEN_ILIM0_Pos                 = 0x0        // Position of ILIM0 field.
	MCPWM_INTEN_ILIM0_Msk                 = 0x1        // Bit mask of ILIM0 field.
	MCPWM_INTEN_ILIM0                     = 0x1        // Bit ILIM0.
	MCPWM_INTEN_ILIM0_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ILIM0_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_IMAT0_Pos                 = 0x1        // Position of IMAT0 field.
	MCPWM_INTEN_IMAT0_Msk                 = 0x2        // Bit mask of IMAT0 field.
	MCPWM_INTEN_IMAT0                     = 0x2        // Bit IMAT0.
	MCPWM_INTEN_IMAT0_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_IMAT0_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_ICAP0_Pos                 = 0x2        // Position of ICAP0 field.
	MCPWM_INTEN_ICAP0_Msk                 = 0x4        // Bit mask of ICAP0 field.
	MCPWM_INTEN_ICAP0                     = 0x4        // Bit ICAP0.
	MCPWM_INTEN_ICAP0_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ICAP0_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_RESERVED_Pos              = 0x3        // Position of RESERVED field.
	MCPWM_INTEN_RESERVED_Msk              = 0x8        // Bit mask of RESERVED field.
	MCPWM_INTEN_RESERVED                  = 0x8        // Bit RESERVED.
	MCPWM_INTEN_ILIM1_Pos                 = 0x4        // Position of ILIM1 field.
	MCPWM_INTEN_ILIM1_Msk                 = 0x10       // Bit mask of ILIM1 field.
	MCPWM_INTEN_ILIM1                     = 0x10       // Bit ILIM1.
	MCPWM_INTEN_ILIM1_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ILIM1_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_IMAT1_Pos                 = 0x5        // Position of IMAT1 field.
	MCPWM_INTEN_IMAT1_Msk                 = 0x20       // Bit mask of IMAT1 field.
	MCPWM_INTEN_IMAT1                     = 0x20       // Bit IMAT1.
	MCPWM_INTEN_IMAT1_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_IMAT1_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_ICAP1_Pos                 = 0x6        // Position of ICAP1 field.
	MCPWM_INTEN_ICAP1_Msk                 = 0x40       // Bit mask of ICAP1 field.
	MCPWM_INTEN_ICAP1                     = 0x40       // Bit ICAP1.
	MCPWM_INTEN_ICAP1_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ICAP1_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_RESERVED_Pos              = 0x7        // Position of RESERVED field.
	MCPWM_INTEN_RESERVED_Msk              = 0x80       // Bit mask of RESERVED field.
	MCPWM_INTEN_RESERVED                  = 0x80       // Bit RESERVED.
	MCPWM_INTEN_ILIM2_Pos                 = 0x8        // Position of ILIM2 field.
	MCPWM_INTEN_ILIM2_Msk                 = 0x100      // Bit mask of ILIM2 field.
	MCPWM_INTEN_ILIM2                     = 0x100      // Bit ILIM2.
	MCPWM_INTEN_ILIM2_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ILIM2_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_IMAT2_Pos                 = 0x9        // Position of IMAT2 field.
	MCPWM_INTEN_IMAT2_Msk                 = 0x200      // Bit mask of IMAT2 field.
	MCPWM_INTEN_IMAT2                     = 0x200      // Bit IMAT2.
	MCPWM_INTEN_IMAT2_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_IMAT2_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_ICAP2_Pos                 = 0xa        // Position of ICAP2 field.
	MCPWM_INTEN_ICAP2_Msk                 = 0x400      // Bit mask of ICAP2 field.
	MCPWM_INTEN_ICAP2                     = 0x400      // Bit ICAP2.
	MCPWM_INTEN_ICAP2_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ICAP2_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_RESERVED_Pos              = 0xb        // Position of RESERVED field.
	MCPWM_INTEN_RESERVED_Msk              = 0x7800     // Bit mask of RESERVED field.
	MCPWM_INTEN_ABORT_Pos                 = 0xf        // Position of ABORT field.
	MCPWM_INTEN_ABORT_Msk                 = 0x8000     // Bit mask of ABORT field.
	MCPWM_INTEN_ABORT                     = 0x8000     // Bit ABORT.
	MCPWM_INTEN_ABORT_INTERRUPT_DISABLED_ = 0x0        // Interrupt disabled.
	MCPWM_INTEN_ABORT_INTERRUPT_ENABLED_  = 0x1        // Interrupt enabled.
	MCPWM_INTEN_RESERVED_Pos              = 0x10       // Position of RESERVED field.
	MCPWM_INTEN_RESERVED_Msk              = 0xffff0000 // Bit mask of RESERVED field.

	// INTEN_SET: Interrupt Enable set address
	MCPWM_INTEN_SET_ILIM0_SET_Pos = 0x0        // Position of ILIM0_SET field.
	MCPWM_INTEN_SET_ILIM0_SET_Msk = 0x1        // Bit mask of ILIM0_SET field.
	MCPWM_INTEN_SET_ILIM0_SET     = 0x1        // Bit ILIM0_SET.
	MCPWM_INTEN_SET_IMAT0_SET_Pos = 0x1        // Position of IMAT0_SET field.
	MCPWM_INTEN_SET_IMAT0_SET_Msk = 0x2        // Bit mask of IMAT0_SET field.
	MCPWM_INTEN_SET_IMAT0_SET     = 0x2        // Bit IMAT0_SET.
	MCPWM_INTEN_SET_ICAP0_SET_Pos = 0x2        // Position of ICAP0_SET field.
	MCPWM_INTEN_SET_ICAP0_SET_Msk = 0x4        // Bit mask of ICAP0_SET field.
	MCPWM_INTEN_SET_ICAP0_SET     = 0x4        // Bit ICAP0_SET.
	MCPWM_INTEN_SET_RESERVED_Pos  = 0x3        // Position of RESERVED field.
	MCPWM_INTEN_SET_RESERVED_Msk  = 0x8        // Bit mask of RESERVED field.
	MCPWM_INTEN_SET_RESERVED      = 0x8        // Bit RESERVED.
	MCPWM_INTEN_SET_ILIM1_SET_Pos = 0x4        // Position of ILIM1_SET field.
	MCPWM_INTEN_SET_ILIM1_SET_Msk = 0x10       // Bit mask of ILIM1_SET field.
	MCPWM_INTEN_SET_ILIM1_SET     = 0x10       // Bit ILIM1_SET.
	MCPWM_INTEN_SET_IMAT1_SET_Pos = 0x5        // Position of IMAT1_SET field.
	MCPWM_INTEN_SET_IMAT1_SET_Msk = 0x20       // Bit mask of IMAT1_SET field.
	MCPWM_INTEN_SET_IMAT1_SET     = 0x20       // Bit IMAT1_SET.
	MCPWM_INTEN_SET_ICAP1_SET_Pos = 0x6        // Position of ICAP1_SET field.
	MCPWM_INTEN_SET_ICAP1_SET_Msk = 0x40       // Bit mask of ICAP1_SET field.
	MCPWM_INTEN_SET_ICAP1_SET     = 0x40       // Bit ICAP1_SET.
	MCPWM_INTEN_SET_RESERVED_Pos  = 0x7        // Position of RESERVED field.
	MCPWM_INTEN_SET_RESERVED_Msk  = 0x80       // Bit mask of RESERVED field.
	MCPWM_INTEN_SET_RESERVED      = 0x80       // Bit RESERVED.
	MCPWM_INTEN_SET_ILIM2_SET_Pos = 0x9        // Position of ILIM2_SET field.
	MCPWM_INTEN_SET_ILIM2_SET_Msk = 0x200      // Bit mask of ILIM2_SET field.
	MCPWM_INTEN_SET_ILIM2_SET     = 0x200      // Bit ILIM2_SET.
	MCPWM_INTEN_SET_IMAT2_SET_Pos = 0xa        // Position of IMAT2_SET field.
	MCPWM_INTEN_SET_IMAT2_SET_Msk = 0x400      // Bit mask of IMAT2_SET field.
	MCPWM_INTEN_SET_IMAT2_SET     = 0x400      // Bit IMAT2_SET.
	MCPWM_INTEN_SET_ICAP2_SET_Pos = 0xb        // Position of ICAP2_SET field.
	MCPWM_INTEN_SET_ICAP2_SET_Msk = 0x800      // Bit mask of ICAP2_SET field.
	MCPWM_INTEN_SET_ICAP2_SET     = 0x800      // Bit ICAP2_SET.
	MCPWM_INTEN_SET_RESERVED_Pos  = 0xc        // Position of RESERVED field.
	MCPWM_INTEN_SET_RESERVED_Msk  = 0x7000     // Bit mask of RESERVED field.
	MCPWM_INTEN_SET_ABORT_SET_Pos = 0xf        // Position of ABORT_SET field.
	MCPWM_INTEN_SET_ABORT_SET_Msk = 0x8000     // Bit mask of ABORT_SET field.
	MCPWM_INTEN_SET_ABORT_SET     = 0x8000     // Bit ABORT_SET.
	MCPWM_INTEN_SET_RESERVED_Pos  = 0x10       // Position of RESERVED field.
	MCPWM_INTEN_SET_RESERVED_Msk  = 0xffff0000 // Bit mask of RESERVED field.

	// INTEN_CLR: Interrupt Enable clear address
	MCPWM_INTEN_CLR_ILIM0_CLR_Pos = 0x0        // Position of ILIM0_CLR field.
	MCPWM_INTEN_CLR_ILIM0_CLR_Msk = 0x1        // Bit mask of ILIM0_CLR field.
	MCPWM_INTEN_CLR_ILIM0_CLR     = 0x1        // Bit ILIM0_CLR.
	MCPWM_INTEN_CLR_IMAT0_CLR_Pos = 0x1        // Position of IMAT0_CLR field.
	MCPWM_INTEN_CLR_IMAT0_CLR_Msk = 0x2        // Bit mask of IMAT0_CLR field.
	MCPWM_INTEN_CLR_IMAT0_CLR     = 0x2        // Bit IMAT0_CLR.
	MCPWM_INTEN_CLR_ICAP0_CLR_Pos = 0x2        // Position of ICAP0_CLR field.
	MCPWM_INTEN_CLR_ICAP0_CLR_Msk = 0x4        // Bit mask of ICAP0_CLR field.
	MCPWM_INTEN_CLR_ICAP0_CLR     = 0x4        // Bit ICAP0_CLR.
	MCPWM_INTEN_CLR_RESERVED_Pos  = 0x3        // Position of RESERVED field.
	MCPWM_INTEN_CLR_RESERVED_Msk  = 0x8        // Bit mask of RESERVED field.
	MCPWM_INTEN_CLR_RESERVED      = 0x8        // Bit RESERVED.
	MCPWM_INTEN_CLR_ILIM1_CLR_Pos = 0x4        // Position of ILIM1_CLR field.
	MCPWM_INTEN_CLR_ILIM1_CLR_Msk = 0x10       // Bit mask of ILIM1_CLR field.
	MCPWM_INTEN_CLR_ILIM1_CLR     = 0x10       // Bit ILIM1_CLR.
	MCPWM_INTEN_CLR_IMAT1_CLR_Pos = 0x5        // Position of IMAT1_CLR field.
	MCPWM_INTEN_CLR_IMAT1_CLR_Msk = 0x20       // Bit mask of IMAT1_CLR field.
	MCPWM_INTEN_CLR_IMAT1_CLR     = 0x20       // Bit IMAT1_CLR.
	MCPWM_INTEN_CLR_ICAP1_CLR_Pos = 0x6        // Position of ICAP1_CLR field.
	MCPWM_INTEN_CLR_ICAP1_CLR_Msk = 0x40       // Bit mask of ICAP1_CLR field.
	MCPWM_INTEN_CLR_ICAP1_CLR     = 0x40       // Bit ICAP1_CLR.
	MCPWM_INTEN_CLR_RESERVED_Pos  = 0x7        // Position of RESERVED field.
	MCPWM_INTEN_CLR_RESERVED_Msk  = 0x80       // Bit mask of RESERVED field.
	MCPWM_INTEN_CLR_RESERVED      = 0x80       // Bit RESERVED.
	MCPWM_INTEN_CLR_ILIM2_CLR_Pos = 0x8        // Position of ILIM2_CLR field.
	MCPWM_INTEN_CLR_ILIM2_CLR_Msk = 0x100      // Bit mask of ILIM2_CLR field.
	MCPWM_INTEN_CLR_ILIM2_CLR     = 0x100      // Bit ILIM2_CLR.
	MCPWM_INTEN_CLR_IMAT2_CLR_Pos = 0x9        // Position of IMAT2_CLR field.
	MCPWM_INTEN_CLR_IMAT2_CLR_Msk = 0x200      // Bit mask of IMAT2_CLR field.
	MCPWM_INTEN_CLR_IMAT2_CLR     = 0x200      // Bit IMAT2_CLR.
	MCPWM_INTEN_CLR_ICAP2_CLR_Pos = 0xa        // Position of ICAP2_CLR field.
	MCPWM_INTEN_CLR_ICAP2_CLR_Msk = 0x400      // Bit mask of ICAP2_CLR field.
	MCPWM_INTEN_CLR_ICAP2_CLR     = 0x400      // Bit ICAP2_CLR.
	MCPWM_INTEN_CLR_RESERVED_Pos  = 0xb        // Position of RESERVED field.
	MCPWM_INTEN_CLR_RESERVED_Msk  = 0x7800     // Bit mask of RESERVED field.
	MCPWM_INTEN_CLR_ABORT_CLR_Pos = 0xf        // Position of ABORT_CLR field.
	MCPWM_INTEN_CLR_ABORT_CLR_Msk = 0x8000     // Bit mask of ABORT_CLR field.
	MCPWM_INTEN_CLR_ABORT_CLR     = 0x8000     // Bit ABORT_CLR.
	MCPWM_INTEN_CLR_RESERVED_Pos  = 0x10       // Position of RESERVED field.
	MCPWM_INTEN_CLR_RESERVED_Msk  = 0xffff0000 // Bit mask of RESERVED field.

	// CNTCON: Count Control read address
	MCPWM_CNTCON_TC0MCI0_RE_Pos                  = 0x0        // Position of TC0MCI0_RE field.
	MCPWM_CNTCON_TC0MCI0_RE_Msk                  = 0x1        // Bit mask of TC0MCI0_RE field.
	MCPWM_CNTCON_TC0MCI0_RE                      = 0x1        // Bit TC0MCI0_RE.
	MCPWM_CNTCON_TC0MCI0_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI0 does not affect counter 0.
	MCPWM_CNTCON_TC0MCI0_RE_RISING               = 0x1        // If MODE0 is 1, counter 0 advances on a rising edge on MCI0.
	MCPWM_CNTCON_TC0MCI0_FE_Pos                  = 0x1        // Position of TC0MCI0_FE field.
	MCPWM_CNTCON_TC0MCI0_FE_Msk                  = 0x2        // Bit mask of TC0MCI0_FE field.
	MCPWM_CNTCON_TC0MCI0_FE                      = 0x2        // Bit TC0MCI0_FE.
	MCPWM_CNTCON_TC0MCI0_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI0 does not affect counter 0.
	MCPWM_CNTCON_TC0MCI0_FE_FALLING              = 0x1        // If MODE0 is 1, counter 0 advances on a falling edge on MCI0.
	MCPWM_CNTCON_TC0MCI1_RE_Pos                  = 0x2        // Position of TC0MCI1_RE field.
	MCPWM_CNTCON_TC0MCI1_RE_Msk                  = 0x4        // Bit mask of TC0MCI1_RE field.
	MCPWM_CNTCON_TC0MCI1_RE                      = 0x4        // Bit TC0MCI1_RE.
	MCPWM_CNTCON_TC0MCI1_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI1 does not affect counter 0.
	MCPWM_CNTCON_TC0MCI1_RE_RISING               = 0x1        // If MODE0 is 1, counter 0 advances on a rising edge on MCI1.
	MCPWM_CNTCON_TC0MCI1_FE_Pos                  = 0x3        // Position of TC0MCI1_FE field.
	MCPWM_CNTCON_TC0MCI1_FE_Msk                  = 0x8        // Bit mask of TC0MCI1_FE field.
	MCPWM_CNTCON_TC0MCI1_FE                      = 0x8        // Bit TC0MCI1_FE.
	MCPWM_CNTCON_TC0MCI1_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI1 does not affect counter 0.
	MCPWM_CNTCON_TC0MCI1_FE_FALLING              = 0x1        // If MODE0 is 1, counter 0 advances on a falling edge on MCI1.
	MCPWM_CNTCON_TC0MCI2_RE_Pos                  = 0x4        // Position of TC0MCI2_RE field.
	MCPWM_CNTCON_TC0MCI2_RE_Msk                  = 0x10       // Bit mask of TC0MCI2_RE field.
	MCPWM_CNTCON_TC0MCI2_RE                      = 0x10       // Bit TC0MCI2_RE.
	MCPWM_CNTCON_TC0MCI2_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI0 does not affect counter 0.
	MCPWM_CNTCON_TC0MCI2_RE_RISING               = 0x1        // If MODE0 is 1, counter 0 advances on a rising edge on MCI2.
	MCPWM_CNTCON_TC0MCI2_FE_Pos                  = 0x5        // Position of TC0MCI2_FE field.
	MCPWM_CNTCON_TC0MCI2_FE_Msk                  = 0x20       // Bit mask of TC0MCI2_FE field.
	MCPWM_CNTCON_TC0MCI2_FE                      = 0x20       // Bit TC0MCI2_FE.
	MCPWM_CNTCON_TC0MCI2_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI0 does not affect counter 0.
	MCPWM_CNTCON_TC0MCI2_FE_FALLLING             = 0x1        // If MODE0 is 1, counter 0 advances on a falling edge on MCI2.
	MCPWM_CNTCON_TC1MCI0_RE_Pos                  = 0x6        // Position of TC1MCI0_RE field.
	MCPWM_CNTCON_TC1MCI0_RE_Msk                  = 0x40       // Bit mask of TC1MCI0_RE field.
	MCPWM_CNTCON_TC1MCI0_RE                      = 0x40       // Bit TC1MCI0_RE.
	MCPWM_CNTCON_TC1MCI0_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI0 does not affect counter 1.
	MCPWM_CNTCON_TC1MCI0_RE_RISING               = 0x1        // If MODE1 is 1, counter 1 advances on a rising edge on MCI0.
	MCPWM_CNTCON_TC1MCI0_FE_Pos                  = 0x7        // Position of TC1MCI0_FE field.
	MCPWM_CNTCON_TC1MCI0_FE_Msk                  = 0x80       // Bit mask of TC1MCI0_FE field.
	MCPWM_CNTCON_TC1MCI0_FE                      = 0x80       // Bit TC1MCI0_FE.
	MCPWM_CNTCON_TC1MCI0_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI0 does not affect counter 1.
	MCPWM_CNTCON_TC1MCI0_FE_FALLING              = 0x1        // If MODE1 is 1, counter 1 advances on a falling edge on MCI0.
	MCPWM_CNTCON_TC1MCI1_RE_Pos                  = 0x8        // Position of TC1MCI1_RE field.
	MCPWM_CNTCON_TC1MCI1_RE_Msk                  = 0x100      // Bit mask of TC1MCI1_RE field.
	MCPWM_CNTCON_TC1MCI1_RE                      = 0x100      // Bit TC1MCI1_RE.
	MCPWM_CNTCON_TC1MCI1_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI1 does not affect counter 1.
	MCPWM_CNTCON_TC1MCI1_RE_RISING               = 0x1        // If MODE1 is 1, counter 1 advances on a rising edge on MCI1.
	MCPWM_CNTCON_TC1MCI1_FE_Pos                  = 0x9        // Position of TC1MCI1_FE field.
	MCPWM_CNTCON_TC1MCI1_FE_Msk                  = 0x200      // Bit mask of TC1MCI1_FE field.
	MCPWM_CNTCON_TC1MCI1_FE                      = 0x200      // Bit TC1MCI1_FE.
	MCPWM_CNTCON_TC1MCI1_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI0 does not affect counter 1.
	MCPWM_CNTCON_TC1MCI1_FE_FALLING              = 0x1        // If MODE1 is 1, counter 1 advances on a falling edge on MCI1.
	MCPWM_CNTCON_TC1MCI2_RE_Pos                  = 0xa        // Position of TC1MCI2_RE field.
	MCPWM_CNTCON_TC1MCI2_RE_Msk                  = 0x400      // Bit mask of TC1MCI2_RE field.
	MCPWM_CNTCON_TC1MCI2_RE                      = 0x400      // Bit TC1MCI2_RE.
	MCPWM_CNTCON_TC1MCI2_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI2 does not affect counter 1.
	MCPWM_CNTCON_TC1MCI2_RE_RISING               = 0x1        // If MODE1 is 1, counter 1 advances on a rising edge on MCI2.
	MCPWM_CNTCON_TC1MCI2_FE_Pos                  = 0xb        // Position of TC1MCI2_FE field.
	MCPWM_CNTCON_TC1MCI2_FE_Msk                  = 0x800      // Bit mask of TC1MCI2_FE field.
	MCPWM_CNTCON_TC1MCI2_FE                      = 0x800      // Bit TC1MCI2_FE.
	MCPWM_CNTCON_TC1MCI2_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI2 does not affect counter 1.
	MCPWM_CNTCON_TC1MCI2_FE_FALLING              = 0x1        // If MODE1 is 1, counter 1 advances on a falling edge on MCI2.
	MCPWM_CNTCON_TC2MCI0_RE_Pos                  = 0xc        // Position of TC2MCI0_RE field.
	MCPWM_CNTCON_TC2MCI0_RE_Msk                  = 0x1000     // Bit mask of TC2MCI0_RE field.
	MCPWM_CNTCON_TC2MCI0_RE                      = 0x1000     // Bit TC2MCI0_RE.
	MCPWM_CNTCON_TC2MCI0_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI0 does not affect counter 2.
	MCPWM_CNTCON_TC2MCI0_RE_RISING               = 0x1        // If MODE2 is 1, counter 2 advances on a rising edge on MCI0.
	MCPWM_CNTCON_TC2MCI0_FE_Pos                  = 0xd        // Position of TC2MCI0_FE field.
	MCPWM_CNTCON_TC2MCI0_FE_Msk                  = 0x2000     // Bit mask of TC2MCI0_FE field.
	MCPWM_CNTCON_TC2MCI0_FE                      = 0x2000     // Bit TC2MCI0_FE.
	MCPWM_CNTCON_TC2MCI0_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI0 does not affect counter 2.
	MCPWM_CNTCON_TC2MCI0_FE_FALLING              = 0x1        // If MODE2 is 1, counter 2 advances on a falling edge on MCI0.
	MCPWM_CNTCON_TC2MCI1_RE_Pos                  = 0xe        // Position of TC2MCI1_RE field.
	MCPWM_CNTCON_TC2MCI1_RE_Msk                  = 0x4000     // Bit mask of TC2MCI1_RE field.
	MCPWM_CNTCON_TC2MCI1_RE                      = 0x4000     // Bit TC2MCI1_RE.
	MCPWM_CNTCON_TC2MCI1_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI1 does not affect counter 2.
	MCPWM_CNTCON_TC2MCI1_RE_RISING               = 0x1        // If MODE2 is 1, counter 2 advances on a rising edge on MCI1.
	MCPWM_CNTCON_TC2MCI1_FE_Pos                  = 0xf        // Position of TC2MCI1_FE field.
	MCPWM_CNTCON_TC2MCI1_FE_Msk                  = 0x8000     // Bit mask of TC2MCI1_FE field.
	MCPWM_CNTCON_TC2MCI1_FE                      = 0x8000     // Bit TC2MCI1_FE.
	MCPWM_CNTCON_TC2MCI1_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI1 does not affect counter 2.
	MCPWM_CNTCON_TC2MCI1_FE_FALLING              = 0x1        // If MODE2 is 1, counter 2 advances on a falling edge on MCI1.
	MCPWM_CNTCON_TC2MCI2_RE_Pos                  = 0x10       // Position of TC2MCI2_RE field.
	MCPWM_CNTCON_TC2MCI2_RE_Msk                  = 0x10000    // Bit mask of TC2MCI2_RE field.
	MCPWM_CNTCON_TC2MCI2_RE                      = 0x10000    // Bit TC2MCI2_RE.
	MCPWM_CNTCON_TC2MCI2_RE_A_RISING_EDGE_ON_MCI = 0x0        // A rising edge on MCI2 does not affect counter 2.
	MCPWM_CNTCON_TC2MCI2_RE_RISIING              = 0x1        // If MODE2 is 1, counter 2 advances on a rising edge on MCI2.
	MCPWM_CNTCON_TC2MCI2_FE_Pos                  = 0x11       // Position of TC2MCI2_FE field.
	MCPWM_CNTCON_TC2MCI2_FE_Msk                  = 0x20000    // Bit mask of TC2MCI2_FE field.
	MCPWM_CNTCON_TC2MCI2_FE                      = 0x20000    // Bit TC2MCI2_FE.
	MCPWM_CNTCON_TC2MCI2_FE_A_FALLING_EDGE_ON_MC = 0x0        // A falling edge on MCI2 does not affect counter 2.
	MCPWM_CNTCON_TC2MCI2_FE_FALLING              = 0x1        // If MODE2 is 1, counter 2 advances on a falling edge on MCI2.
	MCPWM_CNTCON_RESERVED_Pos                    = 0x12       // Position of RESERVED field.
	MCPWM_CNTCON_RESERVED_Msk                    = 0x1ffc0000 // Bit mask of RESERVED field.
	MCPWM_CNTCON_CNTR0_Pos                       = 0x1d       // Position of CNTR0 field.
	MCPWM_CNTCON_CNTR0_Msk                       = 0x20000000 // Bit mask of CNTR0 field.
	MCPWM_CNTCON_CNTR0                           = 0x20000000 // Bit CNTR0.
	MCPWM_CNTCON_CNTR0_CHANNEL_0_IS_IN_TIME      = 0x0        // Channel 0 is in timer mode.
	MCPWM_CNTCON_CNTR0_CHANNEL_0_IS_IN_COUN      = 0x1        // Channel 0 is in counter mode.
	MCPWM_CNTCON_CNTR1_Pos                       = 0x1e       // Position of CNTR1 field.
	MCPWM_CNTCON_CNTR1_Msk                       = 0x40000000 // Bit mask of CNTR1 field.
	MCPWM_CNTCON_CNTR1                           = 0x40000000 // Bit CNTR1.
	MCPWM_CNTCON_CNTR1_CHANNEL_1_IS_IN_TIME      = 0x0        // Channel 1 is in timer mode.
	MCPWM_CNTCON_CNTR1_CHANNEL_1_IS_IN_COUN      = 0x1        // Channel 1 is in counter mode.
	MCPWM_CNTCON_CNTR2_Pos                       = 0x1f       // Position of CNTR2 field.
	MCPWM_CNTCON_CNTR2_Msk                       = 0x80000000 // Bit mask of CNTR2 field.
	MCPWM_CNTCON_CNTR2                           = 0x80000000 // Bit CNTR2.
	MCPWM_CNTCON_CNTR2_CHANNEL_2_IS_IN_TIME      = 0x0        // Channel 2 is in timer mode.
	MCPWM_CNTCON_CNTR2_CHANNEL_2_IS_IN_COUN      = 0x1        // Channel 2 is in counter mode.

	// CNTCON_SET: Count Control set address
	MCPWM_CNTCON_SET_TC0MCI0_RE_SET_Pos = 0x0        // Position of TC0MCI0_RE_SET field.
	MCPWM_CNTCON_SET_TC0MCI0_RE_SET_Msk = 0x1        // Bit mask of TC0MCI0_RE_SET field.
	MCPWM_CNTCON_SET_TC0MCI0_RE_SET     = 0x1        // Bit TC0MCI0_RE_SET.
	MCPWM_CNTCON_SET_TC0MCI0_FE_SET_Pos = 0x1        // Position of TC0MCI0_FE_SET field.
	MCPWM_CNTCON_SET_TC0MCI0_FE_SET_Msk = 0x2        // Bit mask of TC0MCI0_FE_SET field.
	MCPWM_CNTCON_SET_TC0MCI0_FE_SET     = 0x2        // Bit TC0MCI0_FE_SET.
	MCPWM_CNTCON_SET_TC0MCI1_RE_SET_Pos = 0x2        // Position of TC0MCI1_RE_SET field.
	MCPWM_CNTCON_SET_TC0MCI1_RE_SET_Msk = 0x4        // Bit mask of TC0MCI1_RE_SET field.
	MCPWM_CNTCON_SET_TC0MCI1_RE_SET     = 0x4        // Bit TC0MCI1_RE_SET.
	MCPWM_CNTCON_SET_TC0MCI1_FE_SET_Pos = 0x3        // Position of TC0MCI1_FE_SET field.
	MCPWM_CNTCON_SET_TC0MCI1_FE_SET_Msk = 0x8        // Bit mask of TC0MCI1_FE_SET field.
	MCPWM_CNTCON_SET_TC0MCI1_FE_SET     = 0x8        // Bit TC0MCI1_FE_SET.
	MCPWM_CNTCON_SET_TC0MCI2_RE_SET_Pos = 0x4        // Position of TC0MCI2_RE_SET field.
	MCPWM_CNTCON_SET_TC0MCI2_RE_SET_Msk = 0x10       // Bit mask of TC0MCI2_RE_SET field.
	MCPWM_CNTCON_SET_TC0MCI2_RE_SET     = 0x10       // Bit TC0MCI2_RE_SET.
	MCPWM_CNTCON_SET_TC0MCI2_FE_SET_Pos = 0x5        // Position of TC0MCI2_FE_SET field.
	MCPWM_CNTCON_SET_TC0MCI2_FE_SET_Msk = 0x20       // Bit mask of TC0MCI2_FE_SET field.
	MCPWM_CNTCON_SET_TC0MCI2_FE_SET     = 0x20       // Bit TC0MCI2_FE_SET.
	MCPWM_CNTCON_SET_TC1MCI0_RE_SET_Pos = 0x6        // Position of TC1MCI0_RE_SET field.
	MCPWM_CNTCON_SET_TC1MCI0_RE_SET_Msk = 0x40       // Bit mask of TC1MCI0_RE_SET field.
	MCPWM_CNTCON_SET_TC1MCI0_RE_SET     = 0x40       // Bit TC1MCI0_RE_SET.
	MCPWM_CNTCON_SET_TC1MCI0_FE_SET_Pos = 0x7        // Position of TC1MCI0_FE_SET field.
	MCPWM_CNTCON_SET_TC1MCI0_FE_SET_Msk = 0x80       // Bit mask of TC1MCI0_FE_SET field.
	MCPWM_CNTCON_SET_TC1MCI0_FE_SET     = 0x80       // Bit TC1MCI0_FE_SET.
	MCPWM_CNTCON_SET_TC1MCI1_RE_SET_Pos = 0x8        // Position of TC1MCI1_RE_SET field.
	MCPWM_CNTCON_SET_TC1MCI1_RE_SET_Msk = 0x100      // Bit mask of TC1MCI1_RE_SET field.
	MCPWM_CNTCON_SET_TC1MCI1_RE_SET     = 0x100      // Bit TC1MCI1_RE_SET.
	MCPWM_CNTCON_SET_TC1MCI1_FE_SET_Pos = 0x9        // Position of TC1MCI1_FE_SET field.
	MCPWM_CNTCON_SET_TC1MCI1_FE_SET_Msk = 0x200      // Bit mask of TC1MCI1_FE_SET field.
	MCPWM_CNTCON_SET_TC1MCI1_FE_SET     = 0x200      // Bit TC1MCI1_FE_SET.
	MCPWM_CNTCON_SET_TC1MCI2_RE_SET_Pos = 0xa        // Position of TC1MCI2_RE_SET field.
	MCPWM_CNTCON_SET_TC1MCI2_RE_SET_Msk = 0x400      // Bit mask of TC1MCI2_RE_SET field.
	MCPWM_CNTCON_SET_TC1MCI2_RE_SET     = 0x400      // Bit TC1MCI2_RE_SET.
	MCPWM_CNTCON_SET_TC1MCI2_FE_SET_Pos = 0xb        // Position of TC1MCI2_FE_SET field.
	MCPWM_CNTCON_SET_TC1MCI2_FE_SET_Msk = 0x800      // Bit mask of TC1MCI2_FE_SET field.
	MCPWM_CNTCON_SET_TC1MCI2_FE_SET     = 0x800      // Bit TC1MCI2_FE_SET.
	MCPWM_CNTCON_SET_TC2MCI0_RE_SET_Pos = 0xc        // Position of TC2MCI0_RE_SET field.
	MCPWM_CNTCON_SET_TC2MCI0_RE_SET_Msk = 0x1000     // Bit mask of TC2MCI0_RE_SET field.
	MCPWM_CNTCON_SET_TC2MCI0_RE_SET     = 0x1000     // Bit TC2MCI0_RE_SET.
	MCPWM_CNTCON_SET_TC2MCI0_FE_SET_Pos = 0xd        // Position of TC2MCI0_FE_SET field.
	MCPWM_CNTCON_SET_TC2MCI0_FE_SET_Msk = 0x2000     // Bit mask of TC2MCI0_FE_SET field.
	MCPWM_CNTCON_SET_TC2MCI0_FE_SET     = 0x2000     // Bit TC2MCI0_FE_SET.
	MCPWM_CNTCON_SET_TC2MCI1_RE_SET_Pos = 0xe        // Position of TC2MCI1_RE_SET field.
	MCPWM_CNTCON_SET_TC2MCI1_RE_SET_Msk = 0x4000     // Bit mask of TC2MCI1_RE_SET field.
	MCPWM_CNTCON_SET_TC2MCI1_RE_SET     = 0x4000     // Bit TC2MCI1_RE_SET.
	MCPWM_CNTCON_SET_TC2MCI1_FE_SET_Pos = 0xf        // Position of TC2MCI1_FE_SET field.
	MCPWM_CNTCON_SET_TC2MCI1_FE_SET_Msk = 0x8000     // Bit mask of TC2MCI1_FE_SET field.
	MCPWM_CNTCON_SET_TC2MCI1_FE_SET     = 0x8000     // Bit TC2MCI1_FE_SET.
	MCPWM_CNTCON_SET_TC2MCI2_RE_SET_Pos = 0x10       // Position of TC2MCI2_RE_SET field.
	MCPWM_CNTCON_SET_TC2MCI2_RE_SET_Msk = 0x10000    // Bit mask of TC2MCI2_RE_SET field.
	MCPWM_CNTCON_SET_TC2MCI2_RE_SET     = 0x10000    // Bit TC2MCI2_RE_SET.
	MCPWM_CNTCON_SET_TC2MCI2_FE_SET_Pos = 0x11       // Position of TC2MCI2_FE_SET field.
	MCPWM_CNTCON_SET_TC2MCI2_FE_SET_Msk = 0x20000    // Bit mask of TC2MCI2_FE_SET field.
	MCPWM_CNTCON_SET_TC2MCI2_FE_SET     = 0x20000    // Bit TC2MCI2_FE_SET.
	MCPWM_CNTCON_SET_RESERVED_Pos       = 0x12       // Position of RESERVED field.
	MCPWM_CNTCON_SET_RESERVED_Msk       = 0x1ffc0000 // Bit mask of RESERVED field.
	MCPWM_CNTCON_SET_CNTR0_SET_Pos      = 0x1d       // Position of CNTR0_SET field.
	MCPWM_CNTCON_SET_CNTR0_SET_Msk      = 0x20000000 // Bit mask of CNTR0_SET field.
	MCPWM_CNTCON_SET_CNTR0_SET          = 0x20000000 // Bit CNTR0_SET.
	MCPWM_CNTCON_SET_CNTR1_SET_Pos      = 0x1e       // Position of CNTR1_SET field.
	MCPWM_CNTCON_SET_CNTR1_SET_Msk      = 0x40000000 // Bit mask of CNTR1_SET field.
	MCPWM_CNTCON_SET_CNTR1_SET          = 0x40000000 // Bit CNTR1_SET.
	MCPWM_CNTCON_SET_CNTR2_SET_Pos      = 0x1f       // Position of CNTR2_SET field.
	MCPWM_CNTCON_SET_CNTR2_SET_Msk      = 0x80000000 // Bit mask of CNTR2_SET field.
	MCPWM_CNTCON_SET_CNTR2_SET          = 0x80000000 // Bit CNTR2_SET.

	// CNTCON_CLR: Count Control clear address
	MCPWM_CNTCON_CLR_TC0MCI0_RE_CLR_Pos = 0x0        // Position of TC0MCI0_RE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI0_RE_CLR_Msk = 0x1        // Bit mask of TC0MCI0_RE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI0_RE_CLR     = 0x1        // Bit TC0MCI0_RE_CLR.
	MCPWM_CNTCON_CLR_TC0MCI0_FE_CLR_Pos = 0x1        // Position of TC0MCI0_FE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI0_FE_CLR_Msk = 0x2        // Bit mask of TC0MCI0_FE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI0_FE_CLR     = 0x2        // Bit TC0MCI0_FE_CLR.
	MCPWM_CNTCON_CLR_TC0MCI1_RE_CLR_Pos = 0x2        // Position of TC0MCI1_RE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI1_RE_CLR_Msk = 0x4        // Bit mask of TC0MCI1_RE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI1_RE_CLR     = 0x4        // Bit TC0MCI1_RE_CLR.
	MCPWM_CNTCON_CLR_TC0MCI1_FE_CLR_Pos = 0x3        // Position of TC0MCI1_FE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI1_FE_CLR_Msk = 0x8        // Bit mask of TC0MCI1_FE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI1_FE_CLR     = 0x8        // Bit TC0MCI1_FE_CLR.
	MCPWM_CNTCON_CLR_TC0MCI2_RE_Pos     = 0x4        // Position of TC0MCI2_RE field.
	MCPWM_CNTCON_CLR_TC0MCI2_RE_Msk     = 0x10       // Bit mask of TC0MCI2_RE field.
	MCPWM_CNTCON_CLR_TC0MCI2_RE         = 0x10       // Bit TC0MCI2_RE.
	MCPWM_CNTCON_CLR_TC0MCI2_FE_CLR_Pos = 0x5        // Position of TC0MCI2_FE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI2_FE_CLR_Msk = 0x20       // Bit mask of TC0MCI2_FE_CLR field.
	MCPWM_CNTCON_CLR_TC0MCI2_FE_CLR     = 0x20       // Bit TC0MCI2_FE_CLR.
	MCPWM_CNTCON_CLR_TC1MCI0_RE_CLR_Pos = 0x6        // Position of TC1MCI0_RE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI0_RE_CLR_Msk = 0x40       // Bit mask of TC1MCI0_RE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI0_RE_CLR     = 0x40       // Bit TC1MCI0_RE_CLR.
	MCPWM_CNTCON_CLR_TC1MCI0_FE_CLR_Pos = 0x7        // Position of TC1MCI0_FE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI0_FE_CLR_Msk = 0x80       // Bit mask of TC1MCI0_FE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI0_FE_CLR     = 0x80       // Bit TC1MCI0_FE_CLR.
	MCPWM_CNTCON_CLR_TC1MCI1_RE_CLR_Pos = 0x8        // Position of TC1MCI1_RE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI1_RE_CLR_Msk = 0x100      // Bit mask of TC1MCI1_RE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI1_RE_CLR     = 0x100      // Bit TC1MCI1_RE_CLR.
	MCPWM_CNTCON_CLR_TC1MCI1_FE_CLR_Pos = 0x9        // Position of TC1MCI1_FE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI1_FE_CLR_Msk = 0x200      // Bit mask of TC1MCI1_FE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI1_FE_CLR     = 0x200      // Bit TC1MCI1_FE_CLR.
	MCPWM_CNTCON_CLR_TC1MCI2_RE_CLR_Pos = 0xa        // Position of TC1MCI2_RE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI2_RE_CLR_Msk = 0x400      // Bit mask of TC1MCI2_RE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI2_RE_CLR     = 0x400      // Bit TC1MCI2_RE_CLR.
	MCPWM_CNTCON_CLR_TC1MCI2_FE_CLR_Pos = 0xb        // Position of TC1MCI2_FE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI2_FE_CLR_Msk = 0x800      // Bit mask of TC1MCI2_FE_CLR field.
	MCPWM_CNTCON_CLR_TC1MCI2_FE_CLR     = 0x800      // Bit TC1MCI2_FE_CLR.
	MCPWM_CNTCON_CLR_TC2MCI0_RE_CLR_Pos = 0xc        // Position of TC2MCI0_RE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI0_RE_CLR_Msk = 0x1000     // Bit mask of TC2MCI0_RE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI0_RE_CLR     = 0x1000     // Bit TC2MCI0_RE_CLR.
	MCPWM_CNTCON_CLR_TC2MCI0_FE_CLR_Pos = 0xd        // Position of TC2MCI0_FE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI0_FE_CLR_Msk = 0x2000     // Bit mask of TC2MCI0_FE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI0_FE_CLR     = 0x2000     // Bit TC2MCI0_FE_CLR.
	MCPWM_CNTCON_CLR_TC2MCI1_RE_CLR_Pos = 0xe        // Position of TC2MCI1_RE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI1_RE_CLR_Msk = 0x4000     // Bit mask of TC2MCI1_RE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI1_RE_CLR     = 0x4000     // Bit TC2MCI1_RE_CLR.
	MCPWM_CNTCON_CLR_TC2MCI1_FE_CLR_Pos = 0xf        // Position of TC2MCI1_FE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI1_FE_CLR_Msk = 0x8000     // Bit mask of TC2MCI1_FE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI1_FE_CLR     = 0x8000     // Bit TC2MCI1_FE_CLR.
	MCPWM_CNTCON_CLR_TC2MCI2_RE_CLR_Pos = 0x10       // Position of TC2MCI2_RE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI2_RE_CLR_Msk = 0x10000    // Bit mask of TC2MCI2_RE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI2_RE_CLR     = 0x10000    // Bit TC2MCI2_RE_CLR.
	MCPWM_CNTCON_CLR_TC2MCI2_FE_CLR_Pos = 0x11       // Position of TC2MCI2_FE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI2_FE_CLR_Msk = 0x20000    // Bit mask of TC2MCI2_FE_CLR field.
	MCPWM_CNTCON_CLR_TC2MCI2_FE_CLR     = 0x20000    // Bit TC2MCI2_FE_CLR.
	MCPWM_CNTCON_CLR_RESERVED_Pos       = 0x12       // Position of RESERVED field.
	MCPWM_CNTCON_CLR_RESERVED_Msk       = 0x1ffc0000 // Bit mask of RESERVED field.
	MCPWM_CNTCON_CLR_CNTR0_CLR_Pos      = 0x1d       // Position of CNTR0_CLR field.
	MCPWM_CNTCON_CLR_CNTR0_CLR_Msk      = 0x20000000 // Bit mask of CNTR0_CLR field.
	MCPWM_CNTCON_CLR_CNTR0_CLR          = 0x20000000 // Bit CNTR0_CLR.
	MCPWM_CNTCON_CLR_CNTR1_CLR_Pos      = 0x1e       // Position of CNTR1_CLR field.
	MCPWM_CNTCON_CLR_CNTR1_CLR_Msk      = 0x40000000 // Bit mask of CNTR1_CLR field.
	MCPWM_CNTCON_CLR_CNTR1_CLR          = 0x40000000 // Bit CNTR1_CLR.
	MCPWM_CNTCON_CLR_CNTR2_CLR_Pos      = 0x1f       // Position of CNTR2_CLR field.
	MCPWM_CNTCON_CLR_CNTR2_CLR_Msk      = 0x80000000 // Bit mask of CNTR2_CLR field.
	MCPWM_CNTCON_CLR_CNTR2_CLR          = 0x80000000 // Bit CNTR2_CLR.

	// INTF: Interrupt flags read address
	MCPWM_INTF_ILIM0_F_Pos                  = 0x0        // Position of ILIM0_F field.
	MCPWM_INTF_ILIM0_F_Msk                  = 0x1        // Bit mask of ILIM0_F field.
	MCPWM_INTF_ILIM0_F                      = 0x1        // Bit ILIM0_F.
	MCPWM_INTF_ILIM0_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ILIM0_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_IMAT0_F_Pos                  = 0x1        // Position of IMAT0_F field.
	MCPWM_INTF_IMAT0_F_Msk                  = 0x2        // Bit mask of IMAT0_F field.
	MCPWM_INTF_IMAT0_F                      = 0x2        // Bit IMAT0_F.
	MCPWM_INTF_IMAT0_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_IMAT0_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_ICAP0_F_Pos                  = 0x2        // Position of ICAP0_F field.
	MCPWM_INTF_ICAP0_F_Msk                  = 0x4        // Bit mask of ICAP0_F field.
	MCPWM_INTF_ICAP0_F                      = 0x4        // Bit ICAP0_F.
	MCPWM_INTF_ICAP0_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ICAP0_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_RESERVED_Pos                 = 0x3        // Position of RESERVED field.
	MCPWM_INTF_RESERVED_Msk                 = 0x8        // Bit mask of RESERVED field.
	MCPWM_INTF_RESERVED                     = 0x8        // Bit RESERVED.
	MCPWM_INTF_ILIM1_F_Pos                  = 0x4        // Position of ILIM1_F field.
	MCPWM_INTF_ILIM1_F_Msk                  = 0x10       // Bit mask of ILIM1_F field.
	MCPWM_INTF_ILIM1_F                      = 0x10       // Bit ILIM1_F.
	MCPWM_INTF_ILIM1_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ILIM1_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_IMAT1_F_Pos                  = 0x5        // Position of IMAT1_F field.
	MCPWM_INTF_IMAT1_F_Msk                  = 0x20       // Bit mask of IMAT1_F field.
	MCPWM_INTF_IMAT1_F                      = 0x20       // Bit IMAT1_F.
	MCPWM_INTF_IMAT1_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_IMAT1_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_ICAP1_F_Pos                  = 0x6        // Position of ICAP1_F field.
	MCPWM_INTF_ICAP1_F_Msk                  = 0x40       // Bit mask of ICAP1_F field.
	MCPWM_INTF_ICAP1_F                      = 0x40       // Bit ICAP1_F.
	MCPWM_INTF_ICAP1_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ICAP1_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_RESERVED_Pos                 = 0x7        // Position of RESERVED field.
	MCPWM_INTF_RESERVED_Msk                 = 0x80       // Bit mask of RESERVED field.
	MCPWM_INTF_RESERVED                     = 0x80       // Bit RESERVED.
	MCPWM_INTF_ILIM2_F_Pos                  = 0x8        // Position of ILIM2_F field.
	MCPWM_INTF_ILIM2_F_Msk                  = 0x100      // Bit mask of ILIM2_F field.
	MCPWM_INTF_ILIM2_F                      = 0x100      // Bit ILIM2_F.
	MCPWM_INTF_ILIM2_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ILIM2_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_IMAT2_F_Pos                  = 0x9        // Position of IMAT2_F field.
	MCPWM_INTF_IMAT2_F_Msk                  = 0x200      // Bit mask of IMAT2_F field.
	MCPWM_INTF_IMAT2_F                      = 0x200      // Bit IMAT2_F.
	MCPWM_INTF_IMAT2_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_IMAT2_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_ICAP2_F_Pos                  = 0xa        // Position of ICAP2_F field.
	MCPWM_INTF_ICAP2_F_Msk                  = 0x400      // Bit mask of ICAP2_F field.
	MCPWM_INTF_ICAP2_F                      = 0x400      // Bit ICAP2_F.
	MCPWM_INTF_ICAP2_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ICAP2_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_RESERVED_Pos                 = 0xb        // Position of RESERVED field.
	MCPWM_INTF_RESERVED_Msk                 = 0x7800     // Bit mask of RESERVED field.
	MCPWM_INTF_ABORT_F_Pos                  = 0xf        // Position of ABORT_F field.
	MCPWM_INTF_ABORT_F_Msk                  = 0x8000     // Bit mask of ABORT_F field.
	MCPWM_INTF_ABORT_F                      = 0x8000     // Bit ABORT_F.
	MCPWM_INTF_ABORT_F_THIS_INTERRUPT_SOURC = 0x0        // This interrupt source is not contributing to the MCPWM interrupt request.
	MCPWM_INTF_ABORT_F_IF_THE_CORRESPONDING = 0x1        // If the corresponding bit in INTEN is 1, the MCPWM module is asserting its interrupt request to the Interrupt Controller.
	MCPWM_INTF_RESERVED_Pos                 = 0x10       // Position of RESERVED field.
	MCPWM_INTF_RESERVED_Msk                 = 0xffff0000 // Bit mask of RESERVED field.

	// INTF_SET: Interrupt flags set address
	MCPWM_INTF_SET_ILIM0_F_SET_Pos = 0x0        // Position of ILIM0_F_SET field.
	MCPWM_INTF_SET_ILIM0_F_SET_Msk = 0x1        // Bit mask of ILIM0_F_SET field.
	MCPWM_INTF_SET_ILIM0_F_SET     = 0x1        // Bit ILIM0_F_SET.
	MCPWM_INTF_SET_IMAT0_F_SET_Pos = 0x1        // Position of IMAT0_F_SET field.
	MCPWM_INTF_SET_IMAT0_F_SET_Msk = 0x2        // Bit mask of IMAT0_F_SET field.
	MCPWM_INTF_SET_IMAT0_F_SET     = 0x2        // Bit IMAT0_F_SET.
	MCPWM_INTF_SET_ICAP0_F_SET_Pos = 0x2        // Position of ICAP0_F_SET field.
	MCPWM_INTF_SET_ICAP0_F_SET_Msk = 0x4        // Bit mask of ICAP0_F_SET field.
	MCPWM_INTF_SET_ICAP0_F_SET     = 0x4        // Bit ICAP0_F_SET.
	MCPWM_INTF_SET_RESERVED_Pos    = 0x3        // Position of RESERVED field.
	MCPWM_INTF_SET_RESERVED_Msk    = 0x8        // Bit mask of RESERVED field.
	MCPWM_INTF_SET_RESERVED        = 0x8        // Bit RESERVED.
	MCPWM_INTF_SET_ILIM1_F_SET_Pos = 0x4        // Position of ILIM1_F_SET field.
	MCPWM_INTF_SET_ILIM1_F_SET_Msk = 0x10       // Bit mask of ILIM1_F_SET field.
	MCPWM_INTF_SET_ILIM1_F_SET     = 0x10       // Bit ILIM1_F_SET.
	MCPWM_INTF_SET_IMAT1_F_SET_Pos = 0x5        // Position of IMAT1_F_SET field.
	MCPWM_INTF_SET_IMAT1_F_SET_Msk = 0x20       // Bit mask of IMAT1_F_SET field.
	MCPWM_INTF_SET_IMAT1_F_SET     = 0x20       // Bit IMAT1_F_SET.
	MCPWM_INTF_SET_ICAP1_F_SET_Pos = 0x6        // Position of ICAP1_F_SET field.
	MCPWM_INTF_SET_ICAP1_F_SET_Msk = 0x40       // Bit mask of ICAP1_F_SET field.
	MCPWM_INTF_SET_ICAP1_F_SET     = 0x40       // Bit ICAP1_F_SET.
	MCPWM_INTF_SET_RESERVED_Pos    = 0x7        // Position of RESERVED field.
	MCPWM_INTF_SET_RESERVED_Msk    = 0x80       // Bit mask of RESERVED field.
	MCPWM_INTF_SET_RESERVED        = 0x80       // Bit RESERVED.
	MCPWM_INTF_SET_ILIM2_F_SET_Pos = 0x8        // Position of ILIM2_F_SET field.
	MCPWM_INTF_SET_ILIM2_F_SET_Msk = 0x100      // Bit mask of ILIM2_F_SET field.
	MCPWM_INTF_SET_ILIM2_F_SET     = 0x100      // Bit ILIM2_F_SET.
	MCPWM_INTF_SET_IMAT2_F_SET_Pos = 0x9        // Position of IMAT2_F_SET field.
	MCPWM_INTF_SET_IMAT2_F_SET_Msk = 0x200      // Bit mask of IMAT2_F_SET field.
	MCPWM_INTF_SET_IMAT2_F_SET     = 0x200      // Bit IMAT2_F_SET.
	MCPWM_INTF_SET_ICAP2_F_SET_Pos = 0xa        // Position of ICAP2_F_SET field.
	MCPWM_INTF_SET_ICAP2_F_SET_Msk = 0x400      // Bit mask of ICAP2_F_SET field.
	MCPWM_INTF_SET_ICAP2_F_SET     = 0x400      // Bit ICAP2_F_SET.
	MCPWM_INTF_SET_RESERVED_Pos    = 0xb        // Position of RESERVED field.
	MCPWM_INTF_SET_RESERVED_Msk    = 0x7800     // Bit mask of RESERVED field.
	MCPWM_INTF_SET_ABORT_F_SET_Pos = 0xf        // Position of ABORT_F_SET field.
	MCPWM_INTF_SET_ABORT_F_SET_Msk = 0x8000     // Bit mask of ABORT_F_SET field.
	MCPWM_INTF_SET_ABORT_F_SET     = 0x8000     // Bit ABORT_F_SET.
	MCPWM_INTF_SET_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	MCPWM_INTF_SET_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// INTF_CLR: Interrupt flags clear address
	MCPWM_INTF_CLR_ILIM0_F_CLR_Pos = 0x0        // Position of ILIM0_F_CLR field.
	MCPWM_INTF_CLR_ILIM0_F_CLR_Msk = 0x1        // Bit mask of ILIM0_F_CLR field.
	MCPWM_INTF_CLR_ILIM0_F_CLR     = 0x1        // Bit ILIM0_F_CLR.
	MCPWM_INTF_CLR_IMAT0_F_CLR_Pos = 0x1        // Position of IMAT0_F_CLR field.
	MCPWM_INTF_CLR_IMAT0_F_CLR_Msk = 0x2        // Bit mask of IMAT0_F_CLR field.
	MCPWM_INTF_CLR_IMAT0_F_CLR     = 0x2        // Bit IMAT0_F_CLR.
	MCPWM_INTF_CLR_ICAP0_F_CLR_Pos = 0x2        // Position of ICAP0_F_CLR field.
	MCPWM_INTF_CLR_ICAP0_F_CLR_Msk = 0x4        // Bit mask of ICAP0_F_CLR field.
	MCPWM_INTF_CLR_ICAP0_F_CLR     = 0x4        // Bit ICAP0_F_CLR.
	MCPWM_INTF_CLR_RESERVED_Pos    = 0x3        // Position of RESERVED field.
	MCPWM_INTF_CLR_RESERVED_Msk    = 0x8        // Bit mask of RESERVED field.
	MCPWM_INTF_CLR_RESERVED        = 0x8        // Bit RESERVED.
	MCPWM_INTF_CLR_ILIM1_F_CLR_Pos = 0x4        // Position of ILIM1_F_CLR field.
	MCPWM_INTF_CLR_ILIM1_F_CLR_Msk = 0x10       // Bit mask of ILIM1_F_CLR field.
	MCPWM_INTF_CLR_ILIM1_F_CLR     = 0x10       // Bit ILIM1_F_CLR.
	MCPWM_INTF_CLR_IMAT1_F_CLR_Pos = 0x5        // Position of IMAT1_F_CLR field.
	MCPWM_INTF_CLR_IMAT1_F_CLR_Msk = 0x20       // Bit mask of IMAT1_F_CLR field.
	MCPWM_INTF_CLR_IMAT1_F_CLR     = 0x20       // Bit IMAT1_F_CLR.
	MCPWM_INTF_CLR_ICAP1_F_CLR_Pos = 0x6        // Position of ICAP1_F_CLR field.
	MCPWM_INTF_CLR_ICAP1_F_CLR_Msk = 0x40       // Bit mask of ICAP1_F_CLR field.
	MCPWM_INTF_CLR_ICAP1_F_CLR     = 0x40       // Bit ICAP1_F_CLR.
	MCPWM_INTF_CLR_RESERVED_Pos    = 0x7        // Position of RESERVED field.
	MCPWM_INTF_CLR_RESERVED_Msk    = 0x80       // Bit mask of RESERVED field.
	MCPWM_INTF_CLR_RESERVED        = 0x80       // Bit RESERVED.
	MCPWM_INTF_CLR_ILIM2_F_CLR_Pos = 0x8        // Position of ILIM2_F_CLR field.
	MCPWM_INTF_CLR_ILIM2_F_CLR_Msk = 0x100      // Bit mask of ILIM2_F_CLR field.
	MCPWM_INTF_CLR_ILIM2_F_CLR     = 0x100      // Bit ILIM2_F_CLR.
	MCPWM_INTF_CLR_IMAT2_F_CLR_Pos = 0x9        // Position of IMAT2_F_CLR field.
	MCPWM_INTF_CLR_IMAT2_F_CLR_Msk = 0x200      // Bit mask of IMAT2_F_CLR field.
	MCPWM_INTF_CLR_IMAT2_F_CLR     = 0x200      // Bit IMAT2_F_CLR.
	MCPWM_INTF_CLR_ICAP2_F_CLR_Pos = 0xa        // Position of ICAP2_F_CLR field.
	MCPWM_INTF_CLR_ICAP2_F_CLR_Msk = 0x400      // Bit mask of ICAP2_F_CLR field.
	MCPWM_INTF_CLR_ICAP2_F_CLR     = 0x400      // Bit ICAP2_F_CLR.
	MCPWM_INTF_CLR_RESERVED_Pos    = 0xb        // Position of RESERVED field.
	MCPWM_INTF_CLR_RESERVED_Msk    = 0x7800     // Bit mask of RESERVED field.
	MCPWM_INTF_CLR_ABORT_F_CLR_Pos = 0xf        // Position of ABORT_F_CLR field.
	MCPWM_INTF_CLR_ABORT_F_CLR_Msk = 0x8000     // Bit mask of ABORT_F_CLR field.
	MCPWM_INTF_CLR_ABORT_F_CLR     = 0x8000     // Bit ABORT_F_CLR.
	MCPWM_INTF_CLR_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	MCPWM_INTF_CLR_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// CAP_CLR: Capture clear address
	MCPWM_CAP_CLR_CAP_CLR0_Pos = 0x0        // Position of CAP_CLR0 field.
	MCPWM_CAP_CLR_CAP_CLR0_Msk = 0x1        // Bit mask of CAP_CLR0 field.
	MCPWM_CAP_CLR_CAP_CLR0     = 0x1        // Bit CAP_CLR0.
	MCPWM_CAP_CLR_CAP_CLR1_Pos = 0x1        // Position of CAP_CLR1 field.
	MCPWM_CAP_CLR_CAP_CLR1_Msk = 0x2        // Bit mask of CAP_CLR1 field.
	MCPWM_CAP_CLR_CAP_CLR1     = 0x2        // Bit CAP_CLR1.
	MCPWM_CAP_CLR_CAP_CLR2_Pos = 0x2        // Position of CAP_CLR2 field.
	MCPWM_CAP_CLR_CAP_CLR2_Msk = 0x4        // Bit mask of CAP_CLR2 field.
	MCPWM_CAP_CLR_CAP_CLR2     = 0x4        // Bit CAP_CLR2.
	MCPWM_CAP_CLR_RESERVED_Pos = 0x3        // Position of RESERVED field.
	MCPWM_CAP_CLR_RESERVED_Msk = 0xfffffff8 // Bit mask of RESERVED field.
)

// Bitfields for QEI: Quadrature Encoder Interface (QEI)
const (
	// CON: Control register
	QEI_CON_RESP_Pos     = 0x0        // Position of RESP field.
	QEI_CON_RESP_Msk     = 0x1        // Bit mask of RESP field.
	QEI_CON_RESP         = 0x1        // Bit RESP.
	QEI_CON_RESPI_Pos    = 0x1        // Position of RESPI field.
	QEI_CON_RESPI_Msk    = 0x2        // Bit mask of RESPI field.
	QEI_CON_RESPI        = 0x2        // Bit RESPI.
	QEI_CON_RESV_Pos     = 0x2        // Position of RESV field.
	QEI_CON_RESV_Msk     = 0x4        // Bit mask of RESV field.
	QEI_CON_RESV         = 0x4        // Bit RESV.
	QEI_CON_RESI_Pos     = 0x3        // Position of RESI field.
	QEI_CON_RESI_Msk     = 0x8        // Bit mask of RESI field.
	QEI_CON_RESI         = 0x8        // Bit RESI.
	QEI_CON_RESERVED_Pos = 0x4        // Position of RESERVED field.
	QEI_CON_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// STAT: Status register
	QEI_STAT_DIR_Pos      = 0x0        // Position of DIR field.
	QEI_STAT_DIR_Msk      = 0x1        // Bit mask of DIR field.
	QEI_STAT_DIR          = 0x1        // Bit DIR.
	QEI_STAT_RESERVED_Pos = 0x1        // Position of RESERVED field.
	QEI_STAT_RESERVED_Msk = 0xfffffffe // Bit mask of RESERVED field.

	// CONF: Configuration register
	QEI_CONF_DIRINV_Pos   = 0x0        // Position of DIRINV field.
	QEI_CONF_DIRINV_Msk   = 0x1        // Bit mask of DIRINV field.
	QEI_CONF_DIRINV       = 0x1        // Bit DIRINV.
	QEI_CONF_SIGMODE_Pos  = 0x1        // Position of SIGMODE field.
	QEI_CONF_SIGMODE_Msk  = 0x2        // Bit mask of SIGMODE field.
	QEI_CONF_SIGMODE      = 0x2        // Bit SIGMODE.
	QEI_CONF_CAPMODE_Pos  = 0x2        // Position of CAPMODE field.
	QEI_CONF_CAPMODE_Msk  = 0x4        // Bit mask of CAPMODE field.
	QEI_CONF_CAPMODE      = 0x4        // Bit CAPMODE.
	QEI_CONF_INVINX_Pos   = 0x3        // Position of INVINX field.
	QEI_CONF_INVINX_Msk   = 0x8        // Bit mask of INVINX field.
	QEI_CONF_INVINX       = 0x8        // Bit INVINX.
	QEI_CONF_CRESPI_Pos   = 0x4        // Position of CRESPI field.
	QEI_CONF_CRESPI_Msk   = 0x10       // Bit mask of CRESPI field.
	QEI_CONF_CRESPI       = 0x10       // Bit CRESPI.
	QEI_CONF_RESERVED_Pos = 0x5        // Position of RESERVED field.
	QEI_CONF_RESERVED_Msk = 0xffe0     // Bit mask of RESERVED field.
	QEI_CONF_INXGATE_Pos  = 0x10       // Position of INXGATE field.
	QEI_CONF_INXGATE_Msk  = 0xf0000    // Bit mask of INXGATE field.
	QEI_CONF_RESERVED_Pos = 0x14       // Position of RESERVED field.
	QEI_CONF_RESERVED_Msk = 0xfff00000 // Bit mask of RESERVED field.

	// POS: Position register
	QEI_POS_POS_Pos = 0x0        // Position of POS field.
	QEI_POS_POS_Msk = 0xffffffff // Bit mask of POS field.

	// MAXPOS: Maximum position register
	QEI_MAXPOS_MAXPOS_Pos = 0x0        // Position of MAXPOS field.
	QEI_MAXPOS_MAXPOS_Msk = 0xffffffff // Bit mask of MAXPOS field.

	// CMPOS0: Position compare register 0
	QEI_CMPOS0_PCMP0_Pos = 0x0        // Position of PCMP0 field.
	QEI_CMPOS0_PCMP0_Msk = 0xffffffff // Bit mask of PCMP0 field.

	// CMPOS1: Position compare register 1
	QEI_CMPOS1_PCMP1_Pos = 0x0        // Position of PCMP1 field.
	QEI_CMPOS1_PCMP1_Msk = 0xffffffff // Bit mask of PCMP1 field.

	// CMPOS2: Position compare register 2
	QEI_CMPOS2_PCMP2_Pos = 0x0        // Position of PCMP2 field.
	QEI_CMPOS2_PCMP2_Msk = 0xffffffff // Bit mask of PCMP2 field.

	// INXCNT: Index count register 0
	QEI_INXCNT_ENCPOS_Pos = 0x0        // Position of ENCPOS field.
	QEI_INXCNT_ENCPOS_Msk = 0xffffffff // Bit mask of ENCPOS field.

	// INXCMP0: Index compare register 0
	QEI_INXCMP0_ICMP0_Pos = 0x0        // Position of ICMP0 field.
	QEI_INXCMP0_ICMP0_Msk = 0xffffffff // Bit mask of ICMP0 field.

	// LOAD: Velocity timer reload register
	QEI_LOAD_VELLOAD_Pos = 0x0        // Position of VELLOAD field.
	QEI_LOAD_VELLOAD_Msk = 0xffffffff // Bit mask of VELLOAD field.

	// TIME: Velocity timer register
	QEI_TIME_VELVAL_Pos = 0x0        // Position of VELVAL field.
	QEI_TIME_VELVAL_Msk = 0xffffffff // Bit mask of VELVAL field.

	// VEL: Velocity counter register
	QEI_VEL_VELPC_Pos = 0x0        // Position of VELPC field.
	QEI_VEL_VELPC_Msk = 0xffffffff // Bit mask of VELPC field.

	// CAP: Velocity capture register
	QEI_CAP_VELCAP_Pos = 0x0        // Position of VELCAP field.
	QEI_CAP_VELCAP_Msk = 0xffffffff // Bit mask of VELCAP field.

	// VELCOMP: Velocity compare register
	QEI_VELCOMP_VELPC_Pos = 0x0        // Position of VELPC field.
	QEI_VELCOMP_VELPC_Msk = 0xffffffff // Bit mask of VELPC field.

	// FILTER: Digital filter register
	QEI_FILTER_FILTA_Pos = 0x0        // Position of FILTA field.
	QEI_FILTER_FILTA_Msk = 0xffffffff // Bit mask of FILTA field.

	// IEC: Interrupt enable clear register
	QEI_IEC_INX_INT_Pos     = 0x0        // Position of INX_INT field.
	QEI_IEC_INX_INT_Msk     = 0x1        // Bit mask of INX_INT field.
	QEI_IEC_INX_INT         = 0x1        // Bit INX_INT.
	QEI_IEC_TIM_INT_Pos     = 0x1        // Position of TIM_INT field.
	QEI_IEC_TIM_INT_Msk     = 0x2        // Bit mask of TIM_INT field.
	QEI_IEC_TIM_INT         = 0x2        // Bit TIM_INT.
	QEI_IEC_VELC_INT_Pos    = 0x2        // Position of VELC_INT field.
	QEI_IEC_VELC_INT_Msk    = 0x4        // Bit mask of VELC_INT field.
	QEI_IEC_VELC_INT        = 0x4        // Bit VELC_INT.
	QEI_IEC_DIR_INT_Pos     = 0x3        // Position of DIR_INT field.
	QEI_IEC_DIR_INT_Msk     = 0x8        // Bit mask of DIR_INT field.
	QEI_IEC_DIR_INT         = 0x8        // Bit DIR_INT.
	QEI_IEC_ERR_INT_Pos     = 0x4        // Position of ERR_INT field.
	QEI_IEC_ERR_INT_Msk     = 0x10       // Bit mask of ERR_INT field.
	QEI_IEC_ERR_INT         = 0x10       // Bit ERR_INT.
	QEI_IEC_ENCLK_INT_Pos   = 0x5        // Position of ENCLK_INT field.
	QEI_IEC_ENCLK_INT_Msk   = 0x20       // Bit mask of ENCLK_INT field.
	QEI_IEC_ENCLK_INT       = 0x20       // Bit ENCLK_INT.
	QEI_IEC_POS0_INT_Pos    = 0x6        // Position of POS0_INT field.
	QEI_IEC_POS0_INT_Msk    = 0x40       // Bit mask of POS0_INT field.
	QEI_IEC_POS0_INT        = 0x40       // Bit POS0_INT.
	QEI_IEC_POS1_INT_Pos    = 0x7        // Position of POS1_INT field.
	QEI_IEC_POS1_INT_Msk    = 0x80       // Bit mask of POS1_INT field.
	QEI_IEC_POS1_INT        = 0x80       // Bit POS1_INT.
	QEI_IEC_POS2_INT_Pos    = 0x8        // Position of POS2_INT field.
	QEI_IEC_POS2_INT_Msk    = 0x100      // Bit mask of POS2_INT field.
	QEI_IEC_POS2_INT        = 0x100      // Bit POS2_INT.
	QEI_IEC_REV0_INT_Pos    = 0x9        // Position of REV0_INT field.
	QEI_IEC_REV0_INT_Msk    = 0x200      // Bit mask of REV0_INT field.
	QEI_IEC_REV0_INT        = 0x200      // Bit REV0_INT.
	QEI_IEC_POS0REV_INT_Pos = 0xa        // Position of POS0REV_INT field.
	QEI_IEC_POS0REV_INT_Msk = 0x400      // Bit mask of POS0REV_INT field.
	QEI_IEC_POS0REV_INT     = 0x400      // Bit POS0REV_INT.
	QEI_IEC_POS1REV_INT_Pos = 0xb        // Position of POS1REV_INT field.
	QEI_IEC_POS1REV_INT_Msk = 0x800      // Bit mask of POS1REV_INT field.
	QEI_IEC_POS1REV_INT     = 0x800      // Bit POS1REV_INT.
	QEI_IEC_POS2REV_INT_Pos = 0xc        // Position of POS2REV_INT field.
	QEI_IEC_POS2REV_INT_Msk = 0x1000     // Bit mask of POS2REV_INT field.
	QEI_IEC_POS2REV_INT     = 0x1000     // Bit POS2REV_INT.
	QEI_IEC_REV1_INT_Pos    = 0xd        // Position of REV1_INT field.
	QEI_IEC_REV1_INT_Msk    = 0x2000     // Bit mask of REV1_INT field.
	QEI_IEC_REV1_INT        = 0x2000     // Bit REV1_INT.
	QEI_IEC_REV2_INT_Pos    = 0xe        // Position of REV2_INT field.
	QEI_IEC_REV2_INT_Msk    = 0x4000     // Bit mask of REV2_INT field.
	QEI_IEC_REV2_INT        = 0x4000     // Bit REV2_INT.
	QEI_IEC_MAXPOS_INT_Pos  = 0xf        // Position of MAXPOS_INT field.
	QEI_IEC_MAXPOS_INT_Msk  = 0x8000     // Bit mask of MAXPOS_INT field.
	QEI_IEC_MAXPOS_INT      = 0x8000     // Bit MAXPOS_INT.
	QEI_IEC_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	QEI_IEC_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// IES: Interrupt enable set register
	QEI_IES_INX_INT_Pos     = 0x0        // Position of INX_INT field.
	QEI_IES_INX_INT_Msk     = 0x1        // Bit mask of INX_INT field.
	QEI_IES_INX_INT         = 0x1        // Bit INX_INT.
	QEI_IES_TIM_INT_Pos     = 0x1        // Position of TIM_INT field.
	QEI_IES_TIM_INT_Msk     = 0x2        // Bit mask of TIM_INT field.
	QEI_IES_TIM_INT         = 0x2        // Bit TIM_INT.
	QEI_IES_VELC_INT_Pos    = 0x2        // Position of VELC_INT field.
	QEI_IES_VELC_INT_Msk    = 0x4        // Bit mask of VELC_INT field.
	QEI_IES_VELC_INT        = 0x4        // Bit VELC_INT.
	QEI_IES_DIR_INT_Pos     = 0x3        // Position of DIR_INT field.
	QEI_IES_DIR_INT_Msk     = 0x8        // Bit mask of DIR_INT field.
	QEI_IES_DIR_INT         = 0x8        // Bit DIR_INT.
	QEI_IES_ERR_INT_Pos     = 0x4        // Position of ERR_INT field.
	QEI_IES_ERR_INT_Msk     = 0x10       // Bit mask of ERR_INT field.
	QEI_IES_ERR_INT         = 0x10       // Bit ERR_INT.
	QEI_IES_ENCLK_INT_Pos   = 0x5        // Position of ENCLK_INT field.
	QEI_IES_ENCLK_INT_Msk   = 0x20       // Bit mask of ENCLK_INT field.
	QEI_IES_ENCLK_INT       = 0x20       // Bit ENCLK_INT.
	QEI_IES_POS0_INT_Pos    = 0x6        // Position of POS0_INT field.
	QEI_IES_POS0_INT_Msk    = 0x40       // Bit mask of POS0_INT field.
	QEI_IES_POS0_INT        = 0x40       // Bit POS0_INT.
	QEI_IES_POS1_INT_Pos    = 0x7        // Position of POS1_INT field.
	QEI_IES_POS1_INT_Msk    = 0x80       // Bit mask of POS1_INT field.
	QEI_IES_POS1_INT        = 0x80       // Bit POS1_INT.
	QEI_IES_POS2_INT_Pos    = 0x8        // Position of POS2_INT field.
	QEI_IES_POS2_INT_Msk    = 0x100      // Bit mask of POS2_INT field.
	QEI_IES_POS2_INT        = 0x100      // Bit POS2_INT.
	QEI_IES_REV0_INT_Pos    = 0x9        // Position of REV0_INT field.
	QEI_IES_REV0_INT_Msk    = 0x200      // Bit mask of REV0_INT field.
	QEI_IES_REV0_INT        = 0x200      // Bit REV0_INT.
	QEI_IES_POS0REV_INT_Pos = 0xa        // Position of POS0REV_INT field.
	QEI_IES_POS0REV_INT_Msk = 0x400      // Bit mask of POS0REV_INT field.
	QEI_IES_POS0REV_INT     = 0x400      // Bit POS0REV_INT.
	QEI_IES_POS1REV_INT_Pos = 0xb        // Position of POS1REV_INT field.
	QEI_IES_POS1REV_INT_Msk = 0x800      // Bit mask of POS1REV_INT field.
	QEI_IES_POS1REV_INT     = 0x800      // Bit POS1REV_INT.
	QEI_IES_POS2REV_INT_Pos = 0xc        // Position of POS2REV_INT field.
	QEI_IES_POS2REV_INT_Msk = 0x1000     // Bit mask of POS2REV_INT field.
	QEI_IES_POS2REV_INT     = 0x1000     // Bit POS2REV_INT.
	QEI_IES_REV1_INT_Pos    = 0xd        // Position of REV1_INT field.
	QEI_IES_REV1_INT_Msk    = 0x2000     // Bit mask of REV1_INT field.
	QEI_IES_REV1_INT        = 0x2000     // Bit REV1_INT.
	QEI_IES_REV2_INT_Pos    = 0xe        // Position of REV2_INT field.
	QEI_IES_REV2_INT_Msk    = 0x4000     // Bit mask of REV2_INT field.
	QEI_IES_REV2_INT        = 0x4000     // Bit REV2_INT.
	QEI_IES_MAXPOS_INT_Pos  = 0xf        // Position of MAXPOS_INT field.
	QEI_IES_MAXPOS_INT_Msk  = 0x8000     // Bit mask of MAXPOS_INT field.
	QEI_IES_MAXPOS_INT      = 0x8000     // Bit MAXPOS_INT.
	QEI_IES_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	QEI_IES_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// INTSTAT: Interrupt status register
	QEI_INTSTAT_INX_INT_Pos     = 0x0        // Position of INX_INT field.
	QEI_INTSTAT_INX_INT_Msk     = 0x1        // Bit mask of INX_INT field.
	QEI_INTSTAT_INX_INT         = 0x1        // Bit INX_INT.
	QEI_INTSTAT_TIM_INT_Pos     = 0x1        // Position of TIM_INT field.
	QEI_INTSTAT_TIM_INT_Msk     = 0x2        // Bit mask of TIM_INT field.
	QEI_INTSTAT_TIM_INT         = 0x2        // Bit TIM_INT.
	QEI_INTSTAT_VELC_INT_Pos    = 0x2        // Position of VELC_INT field.
	QEI_INTSTAT_VELC_INT_Msk    = 0x4        // Bit mask of VELC_INT field.
	QEI_INTSTAT_VELC_INT        = 0x4        // Bit VELC_INT.
	QEI_INTSTAT_DIR_INT_Pos     = 0x3        // Position of DIR_INT field.
	QEI_INTSTAT_DIR_INT_Msk     = 0x8        // Bit mask of DIR_INT field.
	QEI_INTSTAT_DIR_INT         = 0x8        // Bit DIR_INT.
	QEI_INTSTAT_ERR_INT_Pos     = 0x4        // Position of ERR_INT field.
	QEI_INTSTAT_ERR_INT_Msk     = 0x10       // Bit mask of ERR_INT field.
	QEI_INTSTAT_ERR_INT         = 0x10       // Bit ERR_INT.
	QEI_INTSTAT_ENCLK_INT_Pos   = 0x5        // Position of ENCLK_INT field.
	QEI_INTSTAT_ENCLK_INT_Msk   = 0x20       // Bit mask of ENCLK_INT field.
	QEI_INTSTAT_ENCLK_INT       = 0x20       // Bit ENCLK_INT.
	QEI_INTSTAT_POS0_INT_Pos    = 0x6        // Position of POS0_INT field.
	QEI_INTSTAT_POS0_INT_Msk    = 0x40       // Bit mask of POS0_INT field.
	QEI_INTSTAT_POS0_INT        = 0x40       // Bit POS0_INT.
	QEI_INTSTAT_POS1_INT_Pos    = 0x7        // Position of POS1_INT field.
	QEI_INTSTAT_POS1_INT_Msk    = 0x80       // Bit mask of POS1_INT field.
	QEI_INTSTAT_POS1_INT        = 0x80       // Bit POS1_INT.
	QEI_INTSTAT_POS2_INT_Pos    = 0x8        // Position of POS2_INT field.
	QEI_INTSTAT_POS2_INT_Msk    = 0x100      // Bit mask of POS2_INT field.
	QEI_INTSTAT_POS2_INT        = 0x100      // Bit POS2_INT.
	QEI_INTSTAT_REV0_INT_Pos    = 0x9        // Position of REV0_INT field.
	QEI_INTSTAT_REV0_INT_Msk    = 0x200      // Bit mask of REV0_INT field.
	QEI_INTSTAT_REV0_INT        = 0x200      // Bit REV0_INT.
	QEI_INTSTAT_POS0REV_INT_Pos = 0xa        // Position of POS0REV_INT field.
	QEI_INTSTAT_POS0REV_INT_Msk = 0x400      // Bit mask of POS0REV_INT field.
	QEI_INTSTAT_POS0REV_INT     = 0x400      // Bit POS0REV_INT.
	QEI_INTSTAT_POS1REV_INT_Pos = 0xb        // Position of POS1REV_INT field.
	QEI_INTSTAT_POS1REV_INT_Msk = 0x800      // Bit mask of POS1REV_INT field.
	QEI_INTSTAT_POS1REV_INT     = 0x800      // Bit POS1REV_INT.
	QEI_INTSTAT_POS2REV_INT_Pos = 0xc        // Position of POS2REV_INT field.
	QEI_INTSTAT_POS2REV_INT_Msk = 0x1000     // Bit mask of POS2REV_INT field.
	QEI_INTSTAT_POS2REV_INT     = 0x1000     // Bit POS2REV_INT.
	QEI_INTSTAT_REV1_INT_Pos    = 0xd        // Position of REV1_INT field.
	QEI_INTSTAT_REV1_INT_Msk    = 0x2000     // Bit mask of REV1_INT field.
	QEI_INTSTAT_REV1_INT        = 0x2000     // Bit REV1_INT.
	QEI_INTSTAT_REV2_INT_Pos    = 0xe        // Position of REV2_INT field.
	QEI_INTSTAT_REV2_INT_Msk    = 0x4000     // Bit mask of REV2_INT field.
	QEI_INTSTAT_REV2_INT        = 0x4000     // Bit REV2_INT.
	QEI_INTSTAT_MAXPOS_INT_Pos  = 0xf        // Position of MAXPOS_INT field.
	QEI_INTSTAT_MAXPOS_INT_Msk  = 0x8000     // Bit mask of MAXPOS_INT field.
	QEI_INTSTAT_MAXPOS_INT      = 0x8000     // Bit MAXPOS_INT.
	QEI_INTSTAT_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	QEI_INTSTAT_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// IE: Interrupt enable register
	QEI_IE_INX_INT_Pos     = 0x0        // Position of INX_INT field.
	QEI_IE_INX_INT_Msk     = 0x1        // Bit mask of INX_INT field.
	QEI_IE_INX_INT         = 0x1        // Bit INX_INT.
	QEI_IE_TIM_INT_Pos     = 0x1        // Position of TIM_INT field.
	QEI_IE_TIM_INT_Msk     = 0x2        // Bit mask of TIM_INT field.
	QEI_IE_TIM_INT         = 0x2        // Bit TIM_INT.
	QEI_IE_VELC_INT_Pos    = 0x2        // Position of VELC_INT field.
	QEI_IE_VELC_INT_Msk    = 0x4        // Bit mask of VELC_INT field.
	QEI_IE_VELC_INT        = 0x4        // Bit VELC_INT.
	QEI_IE_DIR_INT_Pos     = 0x3        // Position of DIR_INT field.
	QEI_IE_DIR_INT_Msk     = 0x8        // Bit mask of DIR_INT field.
	QEI_IE_DIR_INT         = 0x8        // Bit DIR_INT.
	QEI_IE_ERR_INT_Pos     = 0x4        // Position of ERR_INT field.
	QEI_IE_ERR_INT_Msk     = 0x10       // Bit mask of ERR_INT field.
	QEI_IE_ERR_INT         = 0x10       // Bit ERR_INT.
	QEI_IE_ENCLK_INT_Pos   = 0x5        // Position of ENCLK_INT field.
	QEI_IE_ENCLK_INT_Msk   = 0x20       // Bit mask of ENCLK_INT field.
	QEI_IE_ENCLK_INT       = 0x20       // Bit ENCLK_INT.
	QEI_IE_POS0_INT_Pos    = 0x6        // Position of POS0_INT field.
	QEI_IE_POS0_INT_Msk    = 0x40       // Bit mask of POS0_INT field.
	QEI_IE_POS0_INT        = 0x40       // Bit POS0_INT.
	QEI_IE_POS1_INT_Pos    = 0x7        // Position of POS1_INT field.
	QEI_IE_POS1_INT_Msk    = 0x80       // Bit mask of POS1_INT field.
	QEI_IE_POS1_INT        = 0x80       // Bit POS1_INT.
	QEI_IE_POS2_INT_Pos    = 0x8        // Position of POS2_INT field.
	QEI_IE_POS2_INT_Msk    = 0x100      // Bit mask of POS2_INT field.
	QEI_IE_POS2_INT        = 0x100      // Bit POS2_INT.
	QEI_IE_REV0_INT_Pos    = 0x9        // Position of REV0_INT field.
	QEI_IE_REV0_INT_Msk    = 0x200      // Bit mask of REV0_INT field.
	QEI_IE_REV0_INT        = 0x200      // Bit REV0_INT.
	QEI_IE_POS0REV_INT_Pos = 0xa        // Position of POS0REV_INT field.
	QEI_IE_POS0REV_INT_Msk = 0x400      // Bit mask of POS0REV_INT field.
	QEI_IE_POS0REV_INT     = 0x400      // Bit POS0REV_INT.
	QEI_IE_POS1REV_INT_Pos = 0xb        // Position of POS1REV_INT field.
	QEI_IE_POS1REV_INT_Msk = 0x800      // Bit mask of POS1REV_INT field.
	QEI_IE_POS1REV_INT     = 0x800      // Bit POS1REV_INT.
	QEI_IE_POS2REV_INT_Pos = 0xc        // Position of POS2REV_INT field.
	QEI_IE_POS2REV_INT_Msk = 0x1000     // Bit mask of POS2REV_INT field.
	QEI_IE_POS2REV_INT     = 0x1000     // Bit POS2REV_INT.
	QEI_IE_REV1_INT_Pos    = 0xd        // Position of REV1_INT field.
	QEI_IE_REV1_INT_Msk    = 0x2000     // Bit mask of REV1_INT field.
	QEI_IE_REV1_INT        = 0x2000     // Bit REV1_INT.
	QEI_IE_REV2_INT_Pos    = 0xe        // Position of REV2_INT field.
	QEI_IE_REV2_INT_Msk    = 0x4000     // Bit mask of REV2_INT field.
	QEI_IE_REV2_INT        = 0x4000     // Bit REV2_INT.
	QEI_IE_MAXPOS_INT_Pos  = 0xf        // Position of MAXPOS_INT field.
	QEI_IE_MAXPOS_INT_Msk  = 0x8000     // Bit mask of MAXPOS_INT field.
	QEI_IE_MAXPOS_INT      = 0x8000     // Bit MAXPOS_INT.
	QEI_IE_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	QEI_IE_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// CLR: Interrupt status clear register
	QEI_CLR_INX_INT_Pos     = 0x0        // Position of INX_INT field.
	QEI_CLR_INX_INT_Msk     = 0x1        // Bit mask of INX_INT field.
	QEI_CLR_INX_INT         = 0x1        // Bit INX_INT.
	QEI_CLR_TIM_INT_Pos     = 0x1        // Position of TIM_INT field.
	QEI_CLR_TIM_INT_Msk     = 0x2        // Bit mask of TIM_INT field.
	QEI_CLR_TIM_INT         = 0x2        // Bit TIM_INT.
	QEI_CLR_VELC_INT_Pos    = 0x2        // Position of VELC_INT field.
	QEI_CLR_VELC_INT_Msk    = 0x4        // Bit mask of VELC_INT field.
	QEI_CLR_VELC_INT        = 0x4        // Bit VELC_INT.
	QEI_CLR_DIR_INT_Pos     = 0x3        // Position of DIR_INT field.
	QEI_CLR_DIR_INT_Msk     = 0x8        // Bit mask of DIR_INT field.
	QEI_CLR_DIR_INT         = 0x8        // Bit DIR_INT.
	QEI_CLR_ERR_INT_Pos     = 0x4        // Position of ERR_INT field.
	QEI_CLR_ERR_INT_Msk     = 0x10       // Bit mask of ERR_INT field.
	QEI_CLR_ERR_INT         = 0x10       // Bit ERR_INT.
	QEI_CLR_ENCLK_INT_Pos   = 0x5        // Position of ENCLK_INT field.
	QEI_CLR_ENCLK_INT_Msk   = 0x20       // Bit mask of ENCLK_INT field.
	QEI_CLR_ENCLK_INT       = 0x20       // Bit ENCLK_INT.
	QEI_CLR_POS0_INT_Pos    = 0x6        // Position of POS0_INT field.
	QEI_CLR_POS0_INT_Msk    = 0x40       // Bit mask of POS0_INT field.
	QEI_CLR_POS0_INT        = 0x40       // Bit POS0_INT.
	QEI_CLR_POS1_INT_Pos    = 0x7        // Position of POS1_INT field.
	QEI_CLR_POS1_INT_Msk    = 0x80       // Bit mask of POS1_INT field.
	QEI_CLR_POS1_INT        = 0x80       // Bit POS1_INT.
	QEI_CLR_POS2_INT_Pos    = 0x8        // Position of POS2_INT field.
	QEI_CLR_POS2_INT_Msk    = 0x100      // Bit mask of POS2_INT field.
	QEI_CLR_POS2_INT        = 0x100      // Bit POS2_INT.
	QEI_CLR_REV0_INT_Pos    = 0x9        // Position of REV0_INT field.
	QEI_CLR_REV0_INT_Msk    = 0x200      // Bit mask of REV0_INT field.
	QEI_CLR_REV0_INT        = 0x200      // Bit REV0_INT.
	QEI_CLR_POS0REV_INT_Pos = 0xa        // Position of POS0REV_INT field.
	QEI_CLR_POS0REV_INT_Msk = 0x400      // Bit mask of POS0REV_INT field.
	QEI_CLR_POS0REV_INT     = 0x400      // Bit POS0REV_INT.
	QEI_CLR_POS1REV_INT_Pos = 0xb        // Position of POS1REV_INT field.
	QEI_CLR_POS1REV_INT_Msk = 0x800      // Bit mask of POS1REV_INT field.
	QEI_CLR_POS1REV_INT     = 0x800      // Bit POS1REV_INT.
	QEI_CLR_POS2REV_INT_Pos = 0xc        // Position of POS2REV_INT field.
	QEI_CLR_POS2REV_INT_Msk = 0x1000     // Bit mask of POS2REV_INT field.
	QEI_CLR_POS2REV_INT     = 0x1000     // Bit POS2REV_INT.
	QEI_CLR_REV1_INT_Pos    = 0xd        // Position of REV1_INT field.
	QEI_CLR_REV1_INT_Msk    = 0x2000     // Bit mask of REV1_INT field.
	QEI_CLR_REV1_INT        = 0x2000     // Bit REV1_INT.
	QEI_CLR_REV2_INT_Pos    = 0xe        // Position of REV2_INT field.
	QEI_CLR_REV2_INT_Msk    = 0x4000     // Bit mask of REV2_INT field.
	QEI_CLR_REV2_INT        = 0x4000     // Bit REV2_INT.
	QEI_CLR_MAXPOS_INT_Pos  = 0xf        // Position of MAXPOS_INT field.
	QEI_CLR_MAXPOS_INT_Msk  = 0x8000     // Bit mask of MAXPOS_INT field.
	QEI_CLR_MAXPOS_INT      = 0x8000     // Bit MAXPOS_INT.
	QEI_CLR_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	QEI_CLR_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// SET: Interrupt status set register
	QEI_SET_INX_INT_Pos     = 0x0        // Position of INX_INT field.
	QEI_SET_INX_INT_Msk     = 0x1        // Bit mask of INX_INT field.
	QEI_SET_INX_INT         = 0x1        // Bit INX_INT.
	QEI_SET_TIM_INT_Pos     = 0x1        // Position of TIM_INT field.
	QEI_SET_TIM_INT_Msk     = 0x2        // Bit mask of TIM_INT field.
	QEI_SET_TIM_INT         = 0x2        // Bit TIM_INT.
	QEI_SET_VELC_INT_Pos    = 0x2        // Position of VELC_INT field.
	QEI_SET_VELC_INT_Msk    = 0x4        // Bit mask of VELC_INT field.
	QEI_SET_VELC_INT        = 0x4        // Bit VELC_INT.
	QEI_SET_DIR_INT_Pos     = 0x3        // Position of DIR_INT field.
	QEI_SET_DIR_INT_Msk     = 0x8        // Bit mask of DIR_INT field.
	QEI_SET_DIR_INT         = 0x8        // Bit DIR_INT.
	QEI_SET_ERR_INT_Pos     = 0x4        // Position of ERR_INT field.
	QEI_SET_ERR_INT_Msk     = 0x10       // Bit mask of ERR_INT field.
	QEI_SET_ERR_INT         = 0x10       // Bit ERR_INT.
	QEI_SET_ENCLK_INT_Pos   = 0x5        // Position of ENCLK_INT field.
	QEI_SET_ENCLK_INT_Msk   = 0x20       // Bit mask of ENCLK_INT field.
	QEI_SET_ENCLK_INT       = 0x20       // Bit ENCLK_INT.
	QEI_SET_POS0_INT_Pos    = 0x6        // Position of POS0_INT field.
	QEI_SET_POS0_INT_Msk    = 0x40       // Bit mask of POS0_INT field.
	QEI_SET_POS0_INT        = 0x40       // Bit POS0_INT.
	QEI_SET_POS1_INT_Pos    = 0x7        // Position of POS1_INT field.
	QEI_SET_POS1_INT_Msk    = 0x80       // Bit mask of POS1_INT field.
	QEI_SET_POS1_INT        = 0x80       // Bit POS1_INT.
	QEI_SET_POS2_INT_Pos    = 0x8        // Position of POS2_INT field.
	QEI_SET_POS2_INT_Msk    = 0x100      // Bit mask of POS2_INT field.
	QEI_SET_POS2_INT        = 0x100      // Bit POS2_INT.
	QEI_SET_REV0_INT_Pos    = 0x9        // Position of REV0_INT field.
	QEI_SET_REV0_INT_Msk    = 0x200      // Bit mask of REV0_INT field.
	QEI_SET_REV0_INT        = 0x200      // Bit REV0_INT.
	QEI_SET_POS0REV_INT_Pos = 0xa        // Position of POS0REV_INT field.
	QEI_SET_POS0REV_INT_Msk = 0x400      // Bit mask of POS0REV_INT field.
	QEI_SET_POS0REV_INT     = 0x400      // Bit POS0REV_INT.
	QEI_SET_POS1REV_INT_Pos = 0xb        // Position of POS1REV_INT field.
	QEI_SET_POS1REV_INT_Msk = 0x800      // Bit mask of POS1REV_INT field.
	QEI_SET_POS1REV_INT     = 0x800      // Bit POS1REV_INT.
	QEI_SET_POS2REV_INT_Pos = 0xc        // Position of POS2REV_INT field.
	QEI_SET_POS2REV_INT_Msk = 0x1000     // Bit mask of POS2REV_INT field.
	QEI_SET_POS2REV_INT     = 0x1000     // Bit POS2REV_INT.
	QEI_SET_REV1_INT_Pos    = 0xd        // Position of REV1_INT field.
	QEI_SET_REV1_INT_Msk    = 0x2000     // Bit mask of REV1_INT field.
	QEI_SET_REV1_INT        = 0x2000     // Bit REV1_INT.
	QEI_SET_REV2_INT_Pos    = 0xe        // Position of REV2_INT field.
	QEI_SET_REV2_INT_Msk    = 0x4000     // Bit mask of REV2_INT field.
	QEI_SET_REV2_INT        = 0x4000     // Bit REV2_INT.
	QEI_SET_MAXPOS_INT_Pos  = 0xf        // Position of MAXPOS_INT field.
	QEI_SET_MAXPOS_INT_Msk  = 0x8000     // Bit mask of MAXPOS_INT field.
	QEI_SET_MAXPOS_INT      = 0x8000     // Bit MAXPOS_INT.
	QEI_SET_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	QEI_SET_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.
)

// Bitfields for SYSCON: System and clock control
const (
	// FLASHCFG: Flash Accelerator Configuration Register. Controls flash access timing.
	SYSCON_FLASHCFG_RESERVED_Pos  = 0x0        // Position of RESERVED field.
	SYSCON_FLASHCFG_RESERVED_Msk  = 0xfff      // Bit mask of RESERVED field.
	SYSCON_FLASHCFG_FLASHTIM_Pos  = 0xc        // Position of FLASHTIM field.
	SYSCON_FLASHCFG_FLASHTIM_Msk  = 0xf000     // Bit mask of FLASHTIM field.
	SYSCON_FLASHCFG_FLASHTIM_1CLK = 0x0        // Flash accesses use 1 CPU clock. Use for up to 20 MHz CPU clock.
	SYSCON_FLASHCFG_FLASHTIM_2CLK = 0x1        // Flash accesses use 2 CPU clocks. Use for up to 40 MHz CPU clock.
	SYSCON_FLASHCFG_FLASHTIM_3CLK = 0x2        // Flash accesses use 3 CPU clocks. Use for up to 60 MHz CPU clock.
	SYSCON_FLASHCFG_FLASHTIM_4CLK = 0x3        // Flash accesses use 4 CPU clocks. Use for up to 80 MHz CPU clock.
	SYSCON_FLASHCFG_FLASHTIM_5CLK = 0x4        // Flash accesses use 5 CPU clocks. Use for up to 100 MHz CPU clock. Use for up to 120 Mhz for LPC1759 and LPC1769 only.
	SYSCON_FLASHCFG_FLASHTIM_6CLK = 0x5        // Flash accesses use 6 CPU clocks. This safe setting will work under any conditions.
	SYSCON_FLASHCFG_RESERVED_Pos  = 0x10       // Position of RESERVED field.
	SYSCON_FLASHCFG_RESERVED_Msk  = 0xffff0000 // Bit mask of RESERVED field.

	// PLL0CON: PLL0 Control Register
	SYSCON_PLL0CON_PLLE0_Pos    = 0x0        // Position of PLLE0 field.
	SYSCON_PLL0CON_PLLE0_Msk    = 0x1        // Bit mask of PLLE0 field.
	SYSCON_PLL0CON_PLLE0        = 0x1        // Bit PLLE0.
	SYSCON_PLL0CON_PLLC0_Pos    = 0x1        // Position of PLLC0 field.
	SYSCON_PLL0CON_PLLC0_Msk    = 0x2        // Bit mask of PLLC0 field.
	SYSCON_PLL0CON_PLLC0        = 0x2        // Bit PLLC0.
	SYSCON_PLL0CON_RESERVED_Pos = 0x2        // Position of RESERVED field.
	SYSCON_PLL0CON_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// PLL0CFG: PLL0 Configuration Register
	SYSCON_PLL0CFG_MSEL0_Pos    = 0x0        // Position of MSEL0 field.
	SYSCON_PLL0CFG_MSEL0_Msk    = 0x7fff     // Bit mask of MSEL0 field.
	SYSCON_PLL0CFG_RESERVED_Pos = 0xf        // Position of RESERVED field.
	SYSCON_PLL0CFG_RESERVED_Msk = 0x8000     // Bit mask of RESERVED field.
	SYSCON_PLL0CFG_RESERVED     = 0x8000     // Bit RESERVED.
	SYSCON_PLL0CFG_NSEL0_Pos    = 0x10       // Position of NSEL0 field.
	SYSCON_PLL0CFG_NSEL0_Msk    = 0xff0000   // Bit mask of NSEL0 field.
	SYSCON_PLL0CFG_RESERVED_Pos = 0x18       // Position of RESERVED field.
	SYSCON_PLL0CFG_RESERVED_Msk = 0xff000000 // Bit mask of RESERVED field.

	// PLL0STAT: PLL0 Status Register
	SYSCON_PLL0STAT_MSEL0_Pos      = 0x0        // Position of MSEL0 field.
	SYSCON_PLL0STAT_MSEL0_Msk      = 0x7fff     // Bit mask of MSEL0 field.
	SYSCON_PLL0STAT_RESERVED_Pos   = 0xf        // Position of RESERVED field.
	SYSCON_PLL0STAT_RESERVED_Msk   = 0x8000     // Bit mask of RESERVED field.
	SYSCON_PLL0STAT_RESERVED       = 0x8000     // Bit RESERVED.
	SYSCON_PLL0STAT_NSEL0_Pos      = 0x10       // Position of NSEL0 field.
	SYSCON_PLL0STAT_NSEL0_Msk      = 0xff0000   // Bit mask of NSEL0 field.
	SYSCON_PLL0STAT_PLLE0_STAT_Pos = 0x18       // Position of PLLE0_STAT field.
	SYSCON_PLL0STAT_PLLE0_STAT_Msk = 0x1000000  // Bit mask of PLLE0_STAT field.
	SYSCON_PLL0STAT_PLLE0_STAT     = 0x1000000  // Bit PLLE0_STAT.
	SYSCON_PLL0STAT_PLLC0_STAT_Pos = 0x19       // Position of PLLC0_STAT field.
	SYSCON_PLL0STAT_PLLC0_STAT_Msk = 0x2000000  // Bit mask of PLLC0_STAT field.
	SYSCON_PLL0STAT_PLLC0_STAT     = 0x2000000  // Bit PLLC0_STAT.
	SYSCON_PLL0STAT_PLOCK0_Pos     = 0x1a       // Position of PLOCK0 field.
	SYSCON_PLL0STAT_PLOCK0_Msk     = 0x4000000  // Bit mask of PLOCK0 field.
	SYSCON_PLL0STAT_PLOCK0         = 0x4000000  // Bit PLOCK0.
	SYSCON_PLL0STAT_RESERVED_Pos   = 0x1b       // Position of RESERVED field.
	SYSCON_PLL0STAT_RESERVED_Msk   = 0xf8000000 // Bit mask of RESERVED field.

	// PLL0FEED: PLL0 Feed Register
	SYSCON_PLL0FEED_PLL0FEED_Pos = 0x0        // Position of PLL0FEED field.
	SYSCON_PLL0FEED_PLL0FEED_Msk = 0xff       // Bit mask of PLL0FEED field.
	SYSCON_PLL0FEED_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SYSCON_PLL0FEED_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// PLL1CON: PLL1 Control Register
	SYSCON_PLL1CON_PLLE1_Pos    = 0x0        // Position of PLLE1 field.
	SYSCON_PLL1CON_PLLE1_Msk    = 0x1        // Bit mask of PLLE1 field.
	SYSCON_PLL1CON_PLLE1        = 0x1        // Bit PLLE1.
	SYSCON_PLL1CON_PLLC1_Pos    = 0x1        // Position of PLLC1 field.
	SYSCON_PLL1CON_PLLC1_Msk    = 0x2        // Bit mask of PLLC1 field.
	SYSCON_PLL1CON_PLLC1        = 0x2        // Bit PLLC1.
	SYSCON_PLL1CON_RESERVED_Pos = 0x2        // Position of RESERVED field.
	SYSCON_PLL1CON_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// PLL1CFG: PLL1 Configuration Register
	SYSCON_PLL1CFG_MSEL1_Pos    = 0x0        // Position of MSEL1 field.
	SYSCON_PLL1CFG_MSEL1_Msk    = 0x1f       // Bit mask of MSEL1 field.
	SYSCON_PLL1CFG_PSEL1_Pos    = 0x5        // Position of PSEL1 field.
	SYSCON_PLL1CFG_PSEL1_Msk    = 0x60       // Bit mask of PSEL1 field.
	SYSCON_PLL1CFG_RESERVED_Pos = 0x7        // Position of RESERVED field.
	SYSCON_PLL1CFG_RESERVED_Msk = 0xffffff80 // Bit mask of RESERVED field.

	// PLL1STAT: PLL1 Status Register
	SYSCON_PLL1STAT_MSEL1_Pos      = 0x0        // Position of MSEL1 field.
	SYSCON_PLL1STAT_MSEL1_Msk      = 0x1f       // Bit mask of MSEL1 field.
	SYSCON_PLL1STAT_PSEL1_Pos      = 0x5        // Position of PSEL1 field.
	SYSCON_PLL1STAT_PSEL1_Msk      = 0x60       // Bit mask of PSEL1 field.
	SYSCON_PLL1STAT_RESERVED_Pos   = 0x7        // Position of RESERVED field.
	SYSCON_PLL1STAT_RESERVED_Msk   = 0x80       // Bit mask of RESERVED field.
	SYSCON_PLL1STAT_RESERVED       = 0x80       // Bit RESERVED.
	SYSCON_PLL1STAT_PLLE1_STAT_Pos = 0x8        // Position of PLLE1_STAT field.
	SYSCON_PLL1STAT_PLLE1_STAT_Msk = 0x100      // Bit mask of PLLE1_STAT field.
	SYSCON_PLL1STAT_PLLE1_STAT     = 0x100      // Bit PLLE1_STAT.
	SYSCON_PLL1STAT_PLLC1_STAT_Pos = 0x9        // Position of PLLC1_STAT field.
	SYSCON_PLL1STAT_PLLC1_STAT_Msk = 0x200      // Bit mask of PLLC1_STAT field.
	SYSCON_PLL1STAT_PLLC1_STAT     = 0x200      // Bit PLLC1_STAT.
	SYSCON_PLL1STAT_PLOCK1_Pos     = 0xa        // Position of PLOCK1 field.
	SYSCON_PLL1STAT_PLOCK1_Msk     = 0x400      // Bit mask of PLOCK1 field.
	SYSCON_PLL1STAT_PLOCK1         = 0x400      // Bit PLOCK1.
	SYSCON_PLL1STAT_RESERVED_Pos   = 0xb        // Position of RESERVED field.
	SYSCON_PLL1STAT_RESERVED_Msk   = 0xfffff800 // Bit mask of RESERVED field.

	// PLL1FEED: PLL1 Feed Register
	SYSCON_PLL1FEED_PLL1FEED_Pos = 0x0        // Position of PLL1FEED field.
	SYSCON_PLL1FEED_PLL1FEED_Msk = 0xff       // Bit mask of PLL1FEED field.
	SYSCON_PLL1FEED_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SYSCON_PLL1FEED_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// PCON: Power Control Register
	SYSCON_PCON_PM0_Pos      = 0x0        // Position of PM0 field.
	SYSCON_PCON_PM0_Msk      = 0x1        // Bit mask of PM0 field.
	SYSCON_PCON_PM0          = 0x1        // Bit PM0.
	SYSCON_PCON_PM1_Pos      = 0x1        // Position of PM1 field.
	SYSCON_PCON_PM1_Msk      = 0x2        // Bit mask of PM1 field.
	SYSCON_PCON_PM1          = 0x2        // Bit PM1.
	SYSCON_PCON_BODRPM_Pos   = 0x2        // Position of BODRPM field.
	SYSCON_PCON_BODRPM_Msk   = 0x4        // Bit mask of BODRPM field.
	SYSCON_PCON_BODRPM       = 0x4        // Bit BODRPM.
	SYSCON_PCON_BOGD_Pos     = 0x3        // Position of BOGD field.
	SYSCON_PCON_BOGD_Msk     = 0x8        // Bit mask of BOGD field.
	SYSCON_PCON_BOGD         = 0x8        // Bit BOGD.
	SYSCON_PCON_BORD_Pos     = 0x4        // Position of BORD field.
	SYSCON_PCON_BORD_Msk     = 0x10       // Bit mask of BORD field.
	SYSCON_PCON_BORD         = 0x10       // Bit BORD.
	SYSCON_PCON_RESERVED_Pos = 0x3        // Position of RESERVED field.
	SYSCON_PCON_RESERVED_Msk = 0xf8       // Bit mask of RESERVED field.
	SYSCON_PCON_SMFLAG_Pos   = 0x8        // Position of SMFLAG field.
	SYSCON_PCON_SMFLAG_Msk   = 0x100      // Bit mask of SMFLAG field.
	SYSCON_PCON_SMFLAG       = 0x100      // Bit SMFLAG.
	SYSCON_PCON_DSFLAG_Pos   = 0x9        // Position of DSFLAG field.
	SYSCON_PCON_DSFLAG_Msk   = 0x200      // Bit mask of DSFLAG field.
	SYSCON_PCON_DSFLAG       = 0x200      // Bit DSFLAG.
	SYSCON_PCON_PDFLAG_Pos   = 0xa        // Position of PDFLAG field.
	SYSCON_PCON_PDFLAG_Msk   = 0x400      // Bit mask of PDFLAG field.
	SYSCON_PCON_PDFLAG       = 0x400      // Bit PDFLAG.
	SYSCON_PCON_DPDFLAG_Pos  = 0xb        // Position of DPDFLAG field.
	SYSCON_PCON_DPDFLAG_Msk  = 0x800      // Bit mask of DPDFLAG field.
	SYSCON_PCON_DPDFLAG      = 0x800      // Bit DPDFLAG.
	SYSCON_PCON_RESERVED_Pos = 0xc        // Position of RESERVED field.
	SYSCON_PCON_RESERVED_Msk = 0xfffff000 // Bit mask of RESERVED field.

	// PCONP: Power Control for Peripherals Register
	SYSCON_PCONP_RESERVED_Pos = 0x0        // Position of RESERVED field.
	SYSCON_PCONP_RESERVED_Msk = 0x1        // Bit mask of RESERVED field.
	SYSCON_PCONP_RESERVED     = 0x1        // Bit RESERVED.
	SYSCON_PCONP_PCTIM0_Pos   = 0x1        // Position of PCTIM0 field.
	SYSCON_PCONP_PCTIM0_Msk   = 0x2        // Bit mask of PCTIM0 field.
	SYSCON_PCONP_PCTIM0       = 0x2        // Bit PCTIM0.
	SYSCON_PCONP_PCTIM1_Pos   = 0x2        // Position of PCTIM1 field.
	SYSCON_PCONP_PCTIM1_Msk   = 0x4        // Bit mask of PCTIM1 field.
	SYSCON_PCONP_PCTIM1       = 0x4        // Bit PCTIM1.
	SYSCON_PCONP_PCUART0_Pos  = 0x3        // Position of PCUART0 field.
	SYSCON_PCONP_PCUART0_Msk  = 0x8        // Bit mask of PCUART0 field.
	SYSCON_PCONP_PCUART0      = 0x8        // Bit PCUART0.
	SYSCON_PCONP_PCUART1_Pos  = 0x4        // Position of PCUART1 field.
	SYSCON_PCONP_PCUART1_Msk  = 0x10       // Bit mask of PCUART1 field.
	SYSCON_PCONP_PCUART1      = 0x10       // Bit PCUART1.
	SYSCON_PCONP_RESERVED_Pos = 0x5        // Position of RESERVED field.
	SYSCON_PCONP_RESERVED_Msk = 0x20       // Bit mask of RESERVED field.
	SYSCON_PCONP_RESERVED     = 0x20       // Bit RESERVED.
	SYSCON_PCONP_PCPWM1_Pos   = 0x6        // Position of PCPWM1 field.
	SYSCON_PCONP_PCPWM1_Msk   = 0x40       // Bit mask of PCPWM1 field.
	SYSCON_PCONP_PCPWM1       = 0x40       // Bit PCPWM1.
	SYSCON_PCONP_PCI2C0_Pos   = 0x7        // Position of PCI2C0 field.
	SYSCON_PCONP_PCI2C0_Msk   = 0x80       // Bit mask of PCI2C0 field.
	SYSCON_PCONP_PCI2C0       = 0x80       // Bit PCI2C0.
	SYSCON_PCONP_PCSPI_Pos    = 0x8        // Position of PCSPI field.
	SYSCON_PCONP_PCSPI_Msk    = 0x100      // Bit mask of PCSPI field.
	SYSCON_PCONP_PCSPI        = 0x100      // Bit PCSPI.
	SYSCON_PCONP_PCRTC_Pos    = 0x9        // Position of PCRTC field.
	SYSCON_PCONP_PCRTC_Msk    = 0x200      // Bit mask of PCRTC field.
	SYSCON_PCONP_PCRTC        = 0x200      // Bit PCRTC.
	SYSCON_PCONP_PCSSP1_Pos   = 0xa        // Position of PCSSP1 field.
	SYSCON_PCONP_PCSSP1_Msk   = 0x400      // Bit mask of PCSSP1 field.
	SYSCON_PCONP_PCSSP1       = 0x400      // Bit PCSSP1.
	SYSCON_PCONP_RESERVED_Pos = 0xb        // Position of RESERVED field.
	SYSCON_PCONP_RESERVED_Msk = 0x800      // Bit mask of RESERVED field.
	SYSCON_PCONP_RESERVED     = 0x800      // Bit RESERVED.
	SYSCON_PCONP_PCADC_Pos    = 0xc        // Position of PCADC field.
	SYSCON_PCONP_PCADC_Msk    = 0x1000     // Bit mask of PCADC field.
	SYSCON_PCONP_PCADC        = 0x1000     // Bit PCADC.
	SYSCON_PCONP_PCCAN1_Pos   = 0xd        // Position of PCCAN1 field.
	SYSCON_PCONP_PCCAN1_Msk   = 0x2000     // Bit mask of PCCAN1 field.
	SYSCON_PCONP_PCCAN1       = 0x2000     // Bit PCCAN1.
	SYSCON_PCONP_PCCAN2_Pos   = 0xe        // Position of PCCAN2 field.
	SYSCON_PCONP_PCCAN2_Msk   = 0x4000     // Bit mask of PCCAN2 field.
	SYSCON_PCONP_PCCAN2       = 0x4000     // Bit PCCAN2.
	SYSCON_PCONP_PCGPIO_Pos   = 0xf        // Position of PCGPIO field.
	SYSCON_PCONP_PCGPIO_Msk   = 0x8000     // Bit mask of PCGPIO field.
	SYSCON_PCONP_PCGPIO       = 0x8000     // Bit PCGPIO.
	SYSCON_PCONP_PCRIT_Pos    = 0x10       // Position of PCRIT field.
	SYSCON_PCONP_PCRIT_Msk    = 0x10000    // Bit mask of PCRIT field.
	SYSCON_PCONP_PCRIT        = 0x10000    // Bit PCRIT.
	SYSCON_PCONP_PCMCPWM_Pos  = 0x11       // Position of PCMCPWM field.
	SYSCON_PCONP_PCMCPWM_Msk  = 0x20000    // Bit mask of PCMCPWM field.
	SYSCON_PCONP_PCMCPWM      = 0x20000    // Bit PCMCPWM.
	SYSCON_PCONP_PCQEI_Pos    = 0x12       // Position of PCQEI field.
	SYSCON_PCONP_PCQEI_Msk    = 0x40000    // Bit mask of PCQEI field.
	SYSCON_PCONP_PCQEI        = 0x40000    // Bit PCQEI.
	SYSCON_PCONP_PCI2C1_Pos   = 0x13       // Position of PCI2C1 field.
	SYSCON_PCONP_PCI2C1_Msk   = 0x80000    // Bit mask of PCI2C1 field.
	SYSCON_PCONP_PCI2C1       = 0x80000    // Bit PCI2C1.
	SYSCON_PCONP_RESERVED_Pos = 0x14       // Position of RESERVED field.
	SYSCON_PCONP_RESERVED_Msk = 0x100000   // Bit mask of RESERVED field.
	SYSCON_PCONP_RESERVED     = 0x100000   // Bit RESERVED.
	SYSCON_PCONP_PCSSP0_Pos   = 0x15       // Position of PCSSP0 field.
	SYSCON_PCONP_PCSSP0_Msk   = 0x200000   // Bit mask of PCSSP0 field.
	SYSCON_PCONP_PCSSP0       = 0x200000   // Bit PCSSP0.
	SYSCON_PCONP_PCTIM2_Pos   = 0x16       // Position of PCTIM2 field.
	SYSCON_PCONP_PCTIM2_Msk   = 0x400000   // Bit mask of PCTIM2 field.
	SYSCON_PCONP_PCTIM2       = 0x400000   // Bit PCTIM2.
	SYSCON_PCONP_PCTIM3_Pos   = 0x17       // Position of PCTIM3 field.
	SYSCON_PCONP_PCTIM3_Msk   = 0x800000   // Bit mask of PCTIM3 field.
	SYSCON_PCONP_PCTIM3       = 0x800000   // Bit PCTIM3.
	SYSCON_PCONP_PCUART2_Pos  = 0x18       // Position of PCUART2 field.
	SYSCON_PCONP_PCUART2_Msk  = 0x1000000  // Bit mask of PCUART2 field.
	SYSCON_PCONP_PCUART2      = 0x1000000  // Bit PCUART2.
	SYSCON_PCONP_PCUART3_Pos  = 0x19       // Position of PCUART3 field.
	SYSCON_PCONP_PCUART3_Msk  = 0x2000000  // Bit mask of PCUART3 field.
	SYSCON_PCONP_PCUART3      = 0x2000000  // Bit PCUART3.
	SYSCON_PCONP_PCI2C2_Pos   = 0x1a       // Position of PCI2C2 field.
	SYSCON_PCONP_PCI2C2_Msk   = 0x4000000  // Bit mask of PCI2C2 field.
	SYSCON_PCONP_PCI2C2       = 0x4000000  // Bit PCI2C2.
	SYSCON_PCONP_PCI2S_Pos    = 0x1b       // Position of PCI2S field.
	SYSCON_PCONP_PCI2S_Msk    = 0x8000000  // Bit mask of PCI2S field.
	SYSCON_PCONP_PCI2S        = 0x8000000  // Bit PCI2S.
	SYSCON_PCONP_RESERVED_Pos = 0x1c       // Position of RESERVED field.
	SYSCON_PCONP_RESERVED_Msk = 0x10000000 // Bit mask of RESERVED field.
	SYSCON_PCONP_RESERVED     = 0x10000000 // Bit RESERVED.
	SYSCON_PCONP_PCGPDMA_Pos  = 0x1d       // Position of PCGPDMA field.
	SYSCON_PCONP_PCGPDMA_Msk  = 0x20000000 // Bit mask of PCGPDMA field.
	SYSCON_PCONP_PCGPDMA      = 0x20000000 // Bit PCGPDMA.
	SYSCON_PCONP_PCENET_Pos   = 0x1e       // Position of PCENET field.
	SYSCON_PCONP_PCENET_Msk   = 0x40000000 // Bit mask of PCENET field.
	SYSCON_PCONP_PCENET       = 0x40000000 // Bit PCENET.
	SYSCON_PCONP_PCUSB_Pos    = 0x1f       // Position of PCUSB field.
	SYSCON_PCONP_PCUSB_Msk    = 0x80000000 // Bit mask of PCUSB field.
	SYSCON_PCONP_PCUSB        = 0x80000000 // Bit PCUSB.

	// CCLKCFG: CPU Clock Configuration Register
	SYSCON_CCLKCFG_CCLKSEL_Pos  = 0x0        // Position of CCLKSEL field.
	SYSCON_CCLKCFG_CCLKSEL_Msk  = 0xff       // Bit mask of CCLKSEL field.
	SYSCON_CCLKCFG_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SYSCON_CCLKCFG_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// USBCLKCFG: USB Clock Configuration Register
	SYSCON_USBCLKCFG_USBSEL_Pos   = 0x0        // Position of USBSEL field.
	SYSCON_USBCLKCFG_USBSEL_Msk   = 0xf        // Bit mask of USBSEL field.
	SYSCON_USBCLKCFG_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SYSCON_USBCLKCFG_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// CLKSRCSEL: Clock Source Select Register
	SYSCON_CLKSRCSEL_CLKSRC_Pos                  = 0x0        // Position of CLKSRC field.
	SYSCON_CLKSRCSEL_CLKSRC_Msk                  = 0x3        // Bit mask of CLKSRC field.
	SYSCON_CLKSRCSEL_CLKSRC_SELECTS_THE_INTERNAL = 0x0        // Selects the Internal RC oscillator as the PLL0 clock source (default).
	SYSCON_CLKSRCSEL_CLKSRC_SELECTS_THE_MAIN_OSC = 0x1        // Selects the main oscillator as the PLL0 clock source.  Select the main oscillator as PLL0 clock source if the PLL0 clock output is used for USB or for CAN with baudrates > 100 kBit/s.
	SYSCON_CLKSRCSEL_CLKSRC_SELECTS_THE_RTC_OSCI = 0x2        // Selects the RTC oscillator as the PLL0 clock source.
	SYSCON_CLKSRCSEL_RESERVED_Pos                = 0x2        // Position of RESERVED field.
	SYSCON_CLKSRCSEL_RESERVED_Msk                = 0xfffffffc // Bit mask of RESERVED field.

	// CANSLEEPCLR: Allows clearing the current CAN channel sleep state as well as reading that state.
	SYSCON_CANSLEEPCLR_RESERVED_Pos  = 0x0        // Position of RESERVED field.
	SYSCON_CANSLEEPCLR_RESERVED_Msk  = 0x1        // Bit mask of RESERVED field.
	SYSCON_CANSLEEPCLR_RESERVED      = 0x1        // Bit RESERVED.
	SYSCON_CANSLEEPCLR_CAN1SLEEP_Pos = 0x1        // Position of CAN1SLEEP field.
	SYSCON_CANSLEEPCLR_CAN1SLEEP_Msk = 0x2        // Bit mask of CAN1SLEEP field.
	SYSCON_CANSLEEPCLR_CAN1SLEEP     = 0x2        // Bit CAN1SLEEP.
	SYSCON_CANSLEEPCLR_CAN2SLEEP_Pos = 0x2        // Position of CAN2SLEEP field.
	SYSCON_CANSLEEPCLR_CAN2SLEEP_Msk = 0x4        // Bit mask of CAN2SLEEP field.
	SYSCON_CANSLEEPCLR_CAN2SLEEP     = 0x4        // Bit CAN2SLEEP.
	SYSCON_CANSLEEPCLR_RESERVED_Pos  = 0x3        // Position of RESERVED field.
	SYSCON_CANSLEEPCLR_RESERVED_Msk  = 0xfffffff8 // Bit mask of RESERVED field.

	// CANWAKEFLAGS: Allows reading the wake-up state of the CAN channels.
	SYSCON_CANWAKEFLAGS_RESERVED_Pos = 0x0        // Position of RESERVED field.
	SYSCON_CANWAKEFLAGS_RESERVED_Msk = 0x1        // Bit mask of RESERVED field.
	SYSCON_CANWAKEFLAGS_RESERVED     = 0x1        // Bit RESERVED.
	SYSCON_CANWAKEFLAGS_CAN1WAKE_Pos = 0x1        // Position of CAN1WAKE field.
	SYSCON_CANWAKEFLAGS_CAN1WAKE_Msk = 0x2        // Bit mask of CAN1WAKE field.
	SYSCON_CANWAKEFLAGS_CAN1WAKE     = 0x2        // Bit CAN1WAKE.
	SYSCON_CANWAKEFLAGS_CAN2WAKE_Pos = 0x2        // Position of CAN2WAKE field.
	SYSCON_CANWAKEFLAGS_CAN2WAKE_Msk = 0x4        // Bit mask of CAN2WAKE field.
	SYSCON_CANWAKEFLAGS_CAN2WAKE     = 0x4        // Bit CAN2WAKE.
	SYSCON_CANWAKEFLAGS_RESERVED_Pos = 0x3        // Position of RESERVED field.
	SYSCON_CANWAKEFLAGS_RESERVED_Msk = 0xfffffff8 // Bit mask of RESERVED field.

	// EXTINT: External Interrupt Flag Register
	SYSCON_EXTINT_EINT0_Pos    = 0x0        // Position of EINT0 field.
	SYSCON_EXTINT_EINT0_Msk    = 0x1        // Bit mask of EINT0 field.
	SYSCON_EXTINT_EINT0        = 0x1        // Bit EINT0.
	SYSCON_EXTINT_EINT1_Pos    = 0x1        // Position of EINT1 field.
	SYSCON_EXTINT_EINT1_Msk    = 0x2        // Bit mask of EINT1 field.
	SYSCON_EXTINT_EINT1        = 0x2        // Bit EINT1.
	SYSCON_EXTINT_EINT2_Pos    = 0x2        // Position of EINT2 field.
	SYSCON_EXTINT_EINT2_Msk    = 0x4        // Bit mask of EINT2 field.
	SYSCON_EXTINT_EINT2        = 0x4        // Bit EINT2.
	SYSCON_EXTINT_EINT3_Pos    = 0x3        // Position of EINT3 field.
	SYSCON_EXTINT_EINT3_Msk    = 0x8        // Bit mask of EINT3 field.
	SYSCON_EXTINT_EINT3        = 0x8        // Bit EINT3.
	SYSCON_EXTINT_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SYSCON_EXTINT_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// EXTMODE: External Interrupt Mode register
	SYSCON_EXTMODE_EXTMODE0_Pos             = 0x0        // Position of EXTMODE0 field.
	SYSCON_EXTMODE_EXTMODE0_Msk             = 0x1        // Bit mask of EXTMODE0 field.
	SYSCON_EXTMODE_EXTMODE0                 = 0x1        // Bit EXTMODE0.
	SYSCON_EXTMODE_EXTMODE0_LEVEL_SENSITIVE = 0x0        // Level-sensitive. Level-sensitivity is selected for EINT0.
	SYSCON_EXTMODE_EXTMODE0_EDGE_SENSITIVE  = 0x1        // Edge-sensitive. EINT0 is edge sensitive.
	SYSCON_EXTMODE_EXTMODE1_Pos             = 0x1        // Position of EXTMODE1 field.
	SYSCON_EXTMODE_EXTMODE1_Msk             = 0x2        // Bit mask of EXTMODE1 field.
	SYSCON_EXTMODE_EXTMODE1                 = 0x2        // Bit EXTMODE1.
	SYSCON_EXTMODE_EXTMODE1_LEVEL_SENSITIVE = 0x0        // Level-sensitive. Level-sensitivity is selected for EINT1.
	SYSCON_EXTMODE_EXTMODE1_EDGE_SENSITIVE  = 0x1        // Edge-sensitive. EINT1 is edge sensitive.
	SYSCON_EXTMODE_EXTMODE2_Pos             = 0x2        // Position of EXTMODE2 field.
	SYSCON_EXTMODE_EXTMODE2_Msk             = 0x4        // Bit mask of EXTMODE2 field.
	SYSCON_EXTMODE_EXTMODE2                 = 0x4        // Bit EXTMODE2.
	SYSCON_EXTMODE_EXTMODE2_LEVEL_SENSITIVE = 0x0        // Level-sensitive. Level-sensitivity is selected for EINT2.
	SYSCON_EXTMODE_EXTMODE2_EDGE_SENSITIVE  = 0x1        // Edge-sensitive. EINT2 is edge sensitive.
	SYSCON_EXTMODE_EXTMODE3_Pos             = 0x3        // Position of EXTMODE3 field.
	SYSCON_EXTMODE_EXTMODE3_Msk             = 0x8        // Bit mask of EXTMODE3 field.
	SYSCON_EXTMODE_EXTMODE3                 = 0x8        // Bit EXTMODE3.
	SYSCON_EXTMODE_EXTMODE3_LEVEL_SENSITIVE = 0x0        // Level-sensitive. Level-sensitivity is selected for EINT3.
	SYSCON_EXTMODE_EXTMODE3_EDGE_SENSITIVE  = 0x1        // Edge-sensitive. EINT3 is edge sensitive.
	SYSCON_EXTMODE_RESERVED_Pos             = 0x4        // Position of RESERVED field.
	SYSCON_EXTMODE_RESERVED_Msk             = 0xfffffff0 // Bit mask of RESERVED field.

	// EXTPOLAR: External Interrupt Polarity Register
	SYSCON_EXTPOLAR_EXTPOLAR0_Pos          = 0x0        // Position of EXTPOLAR0 field.
	SYSCON_EXTPOLAR_EXTPOLAR0_Msk          = 0x1        // Bit mask of EXTPOLAR0 field.
	SYSCON_EXTPOLAR_EXTPOLAR0              = 0x1        // Bit EXTPOLAR0.
	SYSCON_EXTPOLAR_EXTPOLAR0_FALLING_EDGE = 0x0        // Falling edge. EINT0 is low-active or falling-edge sensitive (depending on EXTMODE0).
	SYSCON_EXTPOLAR_EXTPOLAR0_RISING_EDGE  = 0x1        // Rising edge. EINT0 is high-active or rising-edge sensitive (depending on EXTMODE0).
	SYSCON_EXTPOLAR_EXTPOLAR1_Pos          = 0x1        // Position of EXTPOLAR1 field.
	SYSCON_EXTPOLAR_EXTPOLAR1_Msk          = 0x2        // Bit mask of EXTPOLAR1 field.
	SYSCON_EXTPOLAR_EXTPOLAR1              = 0x2        // Bit EXTPOLAR1.
	SYSCON_EXTPOLAR_EXTPOLAR1_FALLING_EDGE = 0x0        // Falling edge. EINT1 is low-active or falling-edge sensitive (depending on EXTMODE1).
	SYSCON_EXTPOLAR_EXTPOLAR1_RISING_EDGE  = 0x1        // Rising edge. EINT1 is high-active or rising-edge sensitive (depending on EXTMODE1).
	SYSCON_EXTPOLAR_EXTPOLAR2_Pos          = 0x2        // Position of EXTPOLAR2 field.
	SYSCON_EXTPOLAR_EXTPOLAR2_Msk          = 0x4        // Bit mask of EXTPOLAR2 field.
	SYSCON_EXTPOLAR_EXTPOLAR2              = 0x4        // Bit EXTPOLAR2.
	SYSCON_EXTPOLAR_EXTPOLAR2_FALLING_EDGE = 0x0        // Falling edge. EINT2 is low-active or falling-edge sensitive (depending on EXTMODE2).
	SYSCON_EXTPOLAR_EXTPOLAR2_RISING_EDGE  = 0x1        // Rising edge. EINT2 is high-active or rising-edge sensitive (depending on EXTMODE2).
	SYSCON_EXTPOLAR_EXTPOLAR3_Pos          = 0x3        // Position of EXTPOLAR3 field.
	SYSCON_EXTPOLAR_EXTPOLAR3_Msk          = 0x8        // Bit mask of EXTPOLAR3 field.
	SYSCON_EXTPOLAR_EXTPOLAR3              = 0x8        // Bit EXTPOLAR3.
	SYSCON_EXTPOLAR_EXTPOLAR3_FALLING_EDGE = 0x0        // Falling edge. EINT3 is low-active or falling-edge sensitive (depending on EXTMODE3).
	SYSCON_EXTPOLAR_EXTPOLAR3_RISING_EDGE  = 0x1        // Rising edge. EINT3 is high-active or rising-edge sensitive (depending on EXTMODE3).
	SYSCON_EXTPOLAR_RESERVED_Pos           = 0x4        // Position of RESERVED field.
	SYSCON_EXTPOLAR_RESERVED_Msk           = 0xfffffff0 // Bit mask of RESERVED field.

	// RSID: Reset Source Identification Register
	SYSCON_RSID_POR_Pos      = 0x0        // Position of POR field.
	SYSCON_RSID_POR_Msk      = 0x1        // Bit mask of POR field.
	SYSCON_RSID_POR          = 0x1        // Bit POR.
	SYSCON_RSID_EXTR_Pos     = 0x1        // Position of EXTR field.
	SYSCON_RSID_EXTR_Msk     = 0x2        // Bit mask of EXTR field.
	SYSCON_RSID_EXTR         = 0x2        // Bit EXTR.
	SYSCON_RSID_WDTR_Pos     = 0x2        // Position of WDTR field.
	SYSCON_RSID_WDTR_Msk     = 0x4        // Bit mask of WDTR field.
	SYSCON_RSID_WDTR         = 0x4        // Bit WDTR.
	SYSCON_RSID_BODR_Pos     = 0x3        // Position of BODR field.
	SYSCON_RSID_BODR_Msk     = 0x8        // Bit mask of BODR field.
	SYSCON_RSID_BODR         = 0x8        // Bit BODR.
	SYSCON_RSID_RESERVED_Pos = 0x4        // Position of RESERVED field.
	SYSCON_RSID_RESERVED_Msk = 0xfffffff0 // Bit mask of RESERVED field.

	// SCS: System control and status
	SYSCON_SCS_RESERVED_Pos      = 0x0        // Position of RESERVED field.
	SYSCON_SCS_RESERVED_Msk      = 0xf        // Bit mask of RESERVED field.
	SYSCON_SCS_OSCRANGE_Pos      = 0x4        // Position of OSCRANGE field.
	SYSCON_SCS_OSCRANGE_Msk      = 0x10       // Bit mask of OSCRANGE field.
	SYSCON_SCS_OSCRANGE          = 0x10       // Bit OSCRANGE.
	SYSCON_SCS_OSCRANGE_LOW      = 0x0        // Low. The frequency range of the main oscillator is 1 MHz to 20 MHz.
	SYSCON_SCS_OSCRANGE_HIGH     = 0x1        // High. The frequency range of the main oscillator is 15 MHz to 25 MHz.
	SYSCON_SCS_OSCEN_Pos         = 0x5        // Position of OSCEN field.
	SYSCON_SCS_OSCEN_Msk         = 0x20       // Bit mask of OSCEN field.
	SYSCON_SCS_OSCEN             = 0x20       // Bit OSCEN.
	SYSCON_SCS_OSCEN_DISABLED    = 0x0        // Disabled. The main oscillator is disabled.
	SYSCON_SCS_OSCEN_ENABLED     = 0x1        // Enabled.The main oscillator is enabled, and will start up if the correct external circuitry is connected to the XTAL1 and XTAL2 pins.
	SYSCON_SCS_OSCSTAT_Pos       = 0x6        // Position of OSCSTAT field.
	SYSCON_SCS_OSCSTAT_Msk       = 0x40       // Bit mask of OSCSTAT field.
	SYSCON_SCS_OSCSTAT           = 0x40       // Bit OSCSTAT.
	SYSCON_SCS_OSCSTAT_NOT_READY = 0x0        // Not ready. The main oscillator is not ready to be used as a clock source.
	SYSCON_SCS_OSCSTAT_READY     = 0x1        // Ready. The main oscillator is ready to be used as a clock source. The main oscillator must be enabled via the OSCEN bit.
	SYSCON_SCS_RESERVED_Pos      = 0x7        // Position of RESERVED field.
	SYSCON_SCS_RESERVED_Msk      = 0xffffff80 // Bit mask of RESERVED field.

	// PCLKSEL0: Peripheral Clock Selection register 0.
	SYSCON_PCLKSEL0_PCLK_WDT_Pos           = 0x0        // Position of PCLK_WDT field.
	SYSCON_PCLKSEL0_PCLK_WDT_Msk           = 0x3        // Bit mask of PCLK_WDT field.
	SYSCON_PCLKSEL0_PCLK_WDT_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_WDT_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_WDT_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_WDT_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_TIMER0_Pos        = 0x2        // Position of PCLK_TIMER0 field.
	SYSCON_PCLKSEL0_PCLK_TIMER0_Msk        = 0xc        // Bit mask of PCLK_TIMER0 field.
	SYSCON_PCLKSEL0_PCLK_TIMER0_CCLK_DIV_4 = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_TIMER0_CCLK       = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_TIMER0_CCLK_DIV_2 = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_TIMER0_CCLK_DIV_8 = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_TIMER1_Pos        = 0x4        // Position of PCLK_TIMER1 field.
	SYSCON_PCLKSEL0_PCLK_TIMER1_Msk        = 0x30       // Bit mask of PCLK_TIMER1 field.
	SYSCON_PCLKSEL0_PCLK_TIMER1_CCLK_DIV_4 = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_TIMER1_CCLK       = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_TIMER1_CCLK_DIV_2 = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_TIMER1_CCLK_DIV_8 = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_UART0_Pos         = 0x6        // Position of PCLK_UART0 field.
	SYSCON_PCLKSEL0_PCLK_UART0_Msk         = 0xc0       // Bit mask of PCLK_UART0 field.
	SYSCON_PCLKSEL0_PCLK_UART0_CCLK_DIV_4  = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_UART0_CCLK        = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_UART0_CCLK_DIV_2  = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_UART0_CCLK_DIV_8  = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_UART1_Pos         = 0x8        // Position of PCLK_UART1 field.
	SYSCON_PCLKSEL0_PCLK_UART1_Msk         = 0x300      // Bit mask of PCLK_UART1 field.
	SYSCON_PCLKSEL0_PCLK_UART1_CCLK_DIV_4  = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_UART1_CCLK        = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_UART1_CCLK_DIV_2  = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_UART1_CCLK_DIV_8  = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_RESERVED_Pos           = 0xa        // Position of RESERVED field.
	SYSCON_PCLKSEL0_RESERVED_Msk           = 0xc00      // Bit mask of RESERVED field.
	SYSCON_PCLKSEL0_PCLK_PWM1_Pos          = 0xc        // Position of PCLK_PWM1 field.
	SYSCON_PCLKSEL0_PCLK_PWM1_Msk          = 0x3000     // Bit mask of PCLK_PWM1 field.
	SYSCON_PCLKSEL0_PCLK_PWM1_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_PWM1_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_PWM1_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_PWM1_CCLK_DIV_8   = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_I2C0_Pos          = 0xe        // Position of PCLK_I2C0 field.
	SYSCON_PCLKSEL0_PCLK_I2C0_Msk          = 0xc000     // Bit mask of PCLK_I2C0 field.
	SYSCON_PCLKSEL0_PCLK_I2C0_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_I2C0_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_I2C0_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_I2C0_CCLK_DIV_8   = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_SPI_Pos           = 0x10       // Position of PCLK_SPI field.
	SYSCON_PCLKSEL0_PCLK_SPI_Msk           = 0x30000    // Bit mask of PCLK_SPI field.
	SYSCON_PCLKSEL0_PCLK_SPI_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_SPI_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_SPI_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_SPI_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_RESERVED_Pos           = 0x12       // Position of RESERVED field.
	SYSCON_PCLKSEL0_RESERVED_Msk           = 0xc0000    // Bit mask of RESERVED field.
	SYSCON_PCLKSEL0_PCLK_SSP1_Pos          = 0x14       // Position of PCLK_SSP1 field.
	SYSCON_PCLKSEL0_PCLK_SSP1_Msk          = 0x300000   // Bit mask of PCLK_SSP1 field.
	SYSCON_PCLKSEL0_PCLK_SSP1_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_SSP1_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_SSP1_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_SSP1_CCLK_DIV_8   = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_DAC_Pos           = 0x16       // Position of PCLK_DAC field.
	SYSCON_PCLKSEL0_PCLK_DAC_Msk           = 0xc00000   // Bit mask of PCLK_DAC field.
	SYSCON_PCLKSEL0_PCLK_DAC_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_DAC_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_DAC_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_DAC_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_ADC_Pos           = 0x18       // Position of PCLK_ADC field.
	SYSCON_PCLKSEL0_PCLK_ADC_Msk           = 0x3000000  // Bit mask of PCLK_ADC field.
	SYSCON_PCLKSEL0_PCLK_ADC_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_ADC_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_ADC_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_ADC_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL0_PCLK_CAN1_Pos          = 0x1a       // Position of PCLK_CAN1 field.
	SYSCON_PCLKSEL0_PCLK_CAN1_Msk          = 0xc000000  // Bit mask of PCLK_CAN1 field.
	SYSCON_PCLKSEL0_PCLK_CAN1_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_CAN1_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_CAN1_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_CAN1_CCLK_DIV_6   = 0x3        // CCLK div 6. PCLK_peripheral = CCLK/6.
	SYSCON_PCLKSEL0_PCLK_CAN2_Pos          = 0x1c       // Position of PCLK_CAN2 field.
	SYSCON_PCLKSEL0_PCLK_CAN2_Msk          = 0x30000000 // Bit mask of PCLK_CAN2 field.
	SYSCON_PCLKSEL0_PCLK_CAN2_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_CAN2_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_CAN2_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_CAN2_CCLK_DIV_6   = 0x3        // CCLK div 6. PCLK_peripheral = CCLK/6,
	SYSCON_PCLKSEL0_PCLK_ACF_Pos           = 0x1e       // Position of PCLK_ACF field.
	SYSCON_PCLKSEL0_PCLK_ACF_Msk           = 0xc0000000 // Bit mask of PCLK_ACF field.
	SYSCON_PCLKSEL0_PCLK_ACF_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL0_PCLK_ACF_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL0_PCLK_ACF_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL0_PCLK_ACF_CCLK_DIV_6    = 0x3        // CCLK div 6. PCLK_peripheral = CCLK/6

	// PCLKSEL1: Peripheral Clock Selection register 1.
	SYSCON_PCLKSEL1_PCLK_QEI_Pos            = 0x0        // Position of PCLK_QEI field.
	SYSCON_PCLKSEL1_PCLK_QEI_Msk            = 0x3        // Bit mask of PCLK_QEI field.
	SYSCON_PCLKSEL1_PCLK_QEI_CCLK_DIV_4     = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_QEI_CCLK           = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_QEI_CCLK_DIV_2     = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_QEI_CCLK_DIV_8     = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_GPIOINT_Pos        = 0x2        // Position of PCLK_GPIOINT field.
	SYSCON_PCLKSEL1_PCLK_GPIOINT_Msk        = 0xc        // Bit mask of PCLK_GPIOINT field.
	SYSCON_PCLKSEL1_PCLK_GPIOINT_CCLK_DIV_4 = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_GPIOINT_CCLK       = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_GPIOINT_CCLK_DIV_2 = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_GPIOINT_CCLK_DIV_8 = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_PCB_Pos            = 0x4        // Position of PCLK_PCB field.
	SYSCON_PCLKSEL1_PCLK_PCB_Msk            = 0x30       // Bit mask of PCLK_PCB field.
	SYSCON_PCLKSEL1_PCLK_PCB_CCLK_DIV_4     = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_PCB_CCLK           = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_PCB_CCLK_DIV_2     = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_PCB_CCLK_DIV_8     = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_I2C1_Pos           = 0x6        // Position of PCLK_I2C1 field.
	SYSCON_PCLKSEL1_PCLK_I2C1_Msk           = 0xc0       // Bit mask of PCLK_I2C1 field.
	SYSCON_PCLKSEL1_PCLK_I2C1_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_I2C1_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_I2C1_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_I2C1_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_RESERVED_Pos            = 0x8        // Position of RESERVED field.
	SYSCON_PCLKSEL1_RESERVED_Msk            = 0x300      // Bit mask of RESERVED field.
	SYSCON_PCLKSEL1_PCLK_SSP0_Pos           = 0xa        // Position of PCLK_SSP0 field.
	SYSCON_PCLKSEL1_PCLK_SSP0_Msk           = 0xc00      // Bit mask of PCLK_SSP0 field.
	SYSCON_PCLKSEL1_PCLK_SSP0_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_SSP0_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_SSP0_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_SSP0_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_TIMER2_Pos         = 0xc        // Position of PCLK_TIMER2 field.
	SYSCON_PCLKSEL1_PCLK_TIMER2_Msk         = 0x3000     // Bit mask of PCLK_TIMER2 field.
	SYSCON_PCLKSEL1_PCLK_TIMER2_CCLK_DIV_4  = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_TIMER2_CCLK        = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_TIMER2_CCLK_DIV_2  = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_TIMER2_CCLK_DIV_8  = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_TIMER3_Pos         = 0xe        // Position of PCLK_TIMER3 field.
	SYSCON_PCLKSEL1_PCLK_TIMER3_Msk         = 0xc000     // Bit mask of PCLK_TIMER3 field.
	SYSCON_PCLKSEL1_PCLK_TIMER3_CCLK_DIV_4  = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_TIMER3_CCLK        = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_TIMER3_CCLK_DIV_2  = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_TIMER3_CCLK_DIV_8  = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_UART2_Pos          = 0x10       // Position of PCLK_UART2 field.
	SYSCON_PCLKSEL1_PCLK_UART2_Msk          = 0x30000    // Bit mask of PCLK_UART2 field.
	SYSCON_PCLKSEL1_PCLK_UART2_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_UART2_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_UART2_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_UART2_CCLK_DIV_8   = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_UART3_Pos          = 0x12       // Position of PCLK_UART3 field.
	SYSCON_PCLKSEL1_PCLK_UART3_Msk          = 0xc0000    // Bit mask of PCLK_UART3 field.
	SYSCON_PCLKSEL1_PCLK_UART3_CCLK_DIV_4   = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_UART3_CCLK         = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_UART3_CCLK_DIV_2   = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_UART3_CCLK_DIV_8   = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_I2C2_Pos           = 0x14       // Position of PCLK_I2C2 field.
	SYSCON_PCLKSEL1_PCLK_I2C2_Msk           = 0x300000   // Bit mask of PCLK_I2C2 field.
	SYSCON_PCLKSEL1_PCLK_I2C2_CCLK_DIV_4    = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_I2C2_CCLK          = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_I2C2_CCLK_DIV_2    = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_I2C2_CCLK_DIV_8    = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_I2S_Pos            = 0x16       // Position of PCLK_I2S field.
	SYSCON_PCLKSEL1_PCLK_I2S_Msk            = 0xc00000   // Bit mask of PCLK_I2S field.
	SYSCON_PCLKSEL1_PCLK_I2S_CCLK_DIV_4     = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_I2S_CCLK           = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_I2S_CCLK_DIV_2     = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_I2S_CCLK_DIV_8     = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_RESERVED_Pos            = 0x18       // Position of RESERVED field.
	SYSCON_PCLKSEL1_RESERVED_Msk            = 0x3000000  // Bit mask of RESERVED field.
	SYSCON_PCLKSEL1_PCLK_RIT_Pos            = 0x1a       // Position of PCLK_RIT field.
	SYSCON_PCLKSEL1_PCLK_RIT_Msk            = 0xc000000  // Bit mask of PCLK_RIT field.
	SYSCON_PCLKSEL1_PCLK_RIT_CCLK_DIV_4     = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_RIT_CCLK           = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_RIT_CCLK_DIV_2     = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_RIT_CCLK_DIV_8     = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_SYSCON_Pos         = 0x1c       // Position of PCLK_SYSCON field.
	SYSCON_PCLKSEL1_PCLK_SYSCON_Msk         = 0x30000000 // Bit mask of PCLK_SYSCON field.
	SYSCON_PCLKSEL1_PCLK_SYSCON_CCLK_DIV_4  = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_SYSCON_CCLK        = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_SYSCON_CCLK_DIV_2  = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_SYSCON_CCLK_DIV_8  = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8
	SYSCON_PCLKSEL1_PCLK_MC_Pos             = 0x1e       // Position of PCLK_MC field.
	SYSCON_PCLKSEL1_PCLK_MC_Msk             = 0xc0000000 // Bit mask of PCLK_MC field.
	SYSCON_PCLKSEL1_PCLK_MC_CCLK_DIV_4      = 0x0        // CCLK div 4. PCLK_peripheral = CCLK/4
	SYSCON_PCLKSEL1_PCLK_MC_CCLK            = 0x1        // CCLK. PCLK_peripheral = CCLK
	SYSCON_PCLKSEL1_PCLK_MC_CCLK_DIV_2      = 0x2        // CCLK div 2. PCLK_peripheral = CCLK/2
	SYSCON_PCLKSEL1_PCLK_MC_CCLK_DIV_8      = 0x3        // CCLK div 8. PCLK_peripheral = CCLK/8

	// USBINTST: USB Interrupt Status
	SYSCON_USBINTST_USB_INT_REQ_LP_Pos  = 0x0        // Position of USB_INT_REQ_LP field.
	SYSCON_USBINTST_USB_INT_REQ_LP_Msk  = 0x1        // Bit mask of USB_INT_REQ_LP field.
	SYSCON_USBINTST_USB_INT_REQ_LP      = 0x1        // Bit USB_INT_REQ_LP.
	SYSCON_USBINTST_USB_INT_REQ_HP_Pos  = 0x1        // Position of USB_INT_REQ_HP field.
	SYSCON_USBINTST_USB_INT_REQ_HP_Msk  = 0x2        // Bit mask of USB_INT_REQ_HP field.
	SYSCON_USBINTST_USB_INT_REQ_HP      = 0x2        // Bit USB_INT_REQ_HP.
	SYSCON_USBINTST_USB_INT_REQ_DMA_Pos = 0x2        // Position of USB_INT_REQ_DMA field.
	SYSCON_USBINTST_USB_INT_REQ_DMA_Msk = 0x4        // Bit mask of USB_INT_REQ_DMA field.
	SYSCON_USBINTST_USB_INT_REQ_DMA     = 0x4        // Bit USB_INT_REQ_DMA.
	SYSCON_USBINTST_USB_HOST_INT_Pos    = 0x3        // Position of USB_HOST_INT field.
	SYSCON_USBINTST_USB_HOST_INT_Msk    = 0x8        // Bit mask of USB_HOST_INT field.
	SYSCON_USBINTST_USB_HOST_INT        = 0x8        // Bit USB_HOST_INT.
	SYSCON_USBINTST_USB_ATX_INT_Pos     = 0x4        // Position of USB_ATX_INT field.
	SYSCON_USBINTST_USB_ATX_INT_Msk     = 0x10       // Bit mask of USB_ATX_INT field.
	SYSCON_USBINTST_USB_ATX_INT         = 0x10       // Bit USB_ATX_INT.
	SYSCON_USBINTST_USB_OTG_INT_Pos     = 0x5        // Position of USB_OTG_INT field.
	SYSCON_USBINTST_USB_OTG_INT_Msk     = 0x20       // Bit mask of USB_OTG_INT field.
	SYSCON_USBINTST_USB_OTG_INT         = 0x20       // Bit USB_OTG_INT.
	SYSCON_USBINTST_USB_I2C_INT_Pos     = 0x6        // Position of USB_I2C_INT field.
	SYSCON_USBINTST_USB_I2C_INT_Msk     = 0x40       // Bit mask of USB_I2C_INT field.
	SYSCON_USBINTST_USB_I2C_INT         = 0x40       // Bit USB_I2C_INT.
	SYSCON_USBINTST_RESERVED_Pos        = 0x7        // Position of RESERVED field.
	SYSCON_USBINTST_RESERVED_Msk        = 0x80       // Bit mask of RESERVED field.
	SYSCON_USBINTST_RESERVED            = 0x80       // Bit RESERVED.
	SYSCON_USBINTST_USB_NEED_CLK_Pos    = 0x8        // Position of USB_NEED_CLK field.
	SYSCON_USBINTST_USB_NEED_CLK_Msk    = 0x100      // Bit mask of USB_NEED_CLK field.
	SYSCON_USBINTST_USB_NEED_CLK        = 0x100      // Bit USB_NEED_CLK.
	SYSCON_USBINTST_RESERVED_Pos        = 0x9        // Position of RESERVED field.
	SYSCON_USBINTST_RESERVED_Msk        = 0x7ffffe00 // Bit mask of RESERVED field.
	SYSCON_USBINTST_EN_USB_INTS_Pos     = 0x1f       // Position of EN_USB_INTS field.
	SYSCON_USBINTST_EN_USB_INTS_Msk     = 0x80000000 // Bit mask of EN_USB_INTS field.
	SYSCON_USBINTST_EN_USB_INTS         = 0x80000000 // Bit EN_USB_INTS.

	// DMACREQSEL: Selects between alternative requests on DMA channels 0 through 7 and 10 through 15
	SYSCON_DMACREQSEL_DMASEL08_Pos = 0x0        // Position of DMASEL08 field.
	SYSCON_DMACREQSEL_DMASEL08_Msk = 0x1        // Bit mask of DMASEL08 field.
	SYSCON_DMACREQSEL_DMASEL08     = 0x1        // Bit DMASEL08.
	SYSCON_DMACREQSEL_DMASEL09_Pos = 0x1        // Position of DMASEL09 field.
	SYSCON_DMACREQSEL_DMASEL09_Msk = 0x2        // Bit mask of DMASEL09 field.
	SYSCON_DMACREQSEL_DMASEL09     = 0x2        // Bit DMASEL09.
	SYSCON_DMACREQSEL_DMASEL10_Pos = 0x2        // Position of DMASEL10 field.
	SYSCON_DMACREQSEL_DMASEL10_Msk = 0x4        // Bit mask of DMASEL10 field.
	SYSCON_DMACREQSEL_DMASEL10     = 0x4        // Bit DMASEL10.
	SYSCON_DMACREQSEL_DMASEL11_Pos = 0x3        // Position of DMASEL11 field.
	SYSCON_DMACREQSEL_DMASEL11_Msk = 0x8        // Bit mask of DMASEL11 field.
	SYSCON_DMACREQSEL_DMASEL11     = 0x8        // Bit DMASEL11.
	SYSCON_DMACREQSEL_DMASEL12_Pos = 0x4        // Position of DMASEL12 field.
	SYSCON_DMACREQSEL_DMASEL12_Msk = 0x10       // Bit mask of DMASEL12 field.
	SYSCON_DMACREQSEL_DMASEL12     = 0x10       // Bit DMASEL12.
	SYSCON_DMACREQSEL_DMASEL13_Pos = 0x5        // Position of DMASEL13 field.
	SYSCON_DMACREQSEL_DMASEL13_Msk = 0x20       // Bit mask of DMASEL13 field.
	SYSCON_DMACREQSEL_DMASEL13     = 0x20       // Bit DMASEL13.
	SYSCON_DMACREQSEL_DMASEL14_Pos = 0x6        // Position of DMASEL14 field.
	SYSCON_DMACREQSEL_DMASEL14_Msk = 0x40       // Bit mask of DMASEL14 field.
	SYSCON_DMACREQSEL_DMASEL14     = 0x40       // Bit DMASEL14.
	SYSCON_DMACREQSEL_DMASEL15_Pos = 0x7        // Position of DMASEL15 field.
	SYSCON_DMACREQSEL_DMASEL15_Msk = 0x80       // Bit mask of DMASEL15 field.
	SYSCON_DMACREQSEL_DMASEL15     = 0x80       // Bit DMASEL15.
	SYSCON_DMACREQSEL_RESERVED_Pos = 0x8        // Position of RESERVED field.
	SYSCON_DMACREQSEL_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// CLKOUTCFG: Clock Output Configuration Register
	SYSCON_CLKOUTCFG_CLKOUTSEL_Pos                  = 0x0        // Position of CLKOUTSEL field.
	SYSCON_CLKOUTCFG_CLKOUTSEL_Msk                  = 0xf        // Bit mask of CLKOUTSEL field.
	SYSCON_CLKOUTCFG_CLKOUTSEL_SELECTS_THE_CPU_CLOC = 0x0        // Selects the CPU clock as the CLKOUT source.
	SYSCON_CLKOUTCFG_CLKOUTSEL_SELECTS_THE_MAIN_OSC = 0x1        // Selects the main oscillator as the CLKOUT source.
	SYSCON_CLKOUTCFG_CLKOUTSEL_SELECTS_THE_INTERNAL = 0x2        // Selects the Internal RC oscillator as the CLKOUT source.
	SYSCON_CLKOUTCFG_CLKOUTSEL_SELECTS_THE_USB_CLOC = 0x3        // Selects the USB clock as the CLKOUT source.
	SYSCON_CLKOUTCFG_CLKOUTSEL_SELECTS_THE_RTC_OSCI = 0x4        // Selects the RTC oscillator as the CLKOUT source.
	SYSCON_CLKOUTCFG_CLKOUTDIV_Pos                  = 0x4        // Position of CLKOUTDIV field.
	SYSCON_CLKOUTCFG_CLKOUTDIV_Msk                  = 0xf0       // Bit mask of CLKOUTDIV field.
	SYSCON_CLKOUTCFG_CLKOUT_EN_Pos                  = 0x8        // Position of CLKOUT_EN field.
	SYSCON_CLKOUTCFG_CLKOUT_EN_Msk                  = 0x100      // Bit mask of CLKOUT_EN field.
	SYSCON_CLKOUTCFG_CLKOUT_EN                      = 0x100      // Bit CLKOUT_EN.
	SYSCON_CLKOUTCFG_CLKOUT_ACT_Pos                 = 0x9        // Position of CLKOUT_ACT field.
	SYSCON_CLKOUTCFG_CLKOUT_ACT_Msk                 = 0x200      // Bit mask of CLKOUT_ACT field.
	SYSCON_CLKOUTCFG_CLKOUT_ACT                     = 0x200      // Bit CLKOUT_ACT.
	SYSCON_CLKOUTCFG_RESERVED_Pos                   = 0xa        // Position of RESERVED field.
	SYSCON_CLKOUTCFG_RESERVED_Msk                   = 0xfffffc00 // Bit mask of RESERVED field.
)

// Bitfields for EMAC: Ethernet
const (
	// MAC1: MAC configuration register 1.
	ETHERNET_MAC1_RXENABLE_Pos   = 0x0        // Position of RXENABLE field.
	ETHERNET_MAC1_RXENABLE_Msk   = 0x1        // Bit mask of RXENABLE field.
	ETHERNET_MAC1_RXENABLE       = 0x1        // Bit RXENABLE.
	ETHERNET_MAC1_PARF_Pos       = 0x1        // Position of PARF field.
	ETHERNET_MAC1_PARF_Msk       = 0x2        // Bit mask of PARF field.
	ETHERNET_MAC1_PARF           = 0x2        // Bit PARF.
	ETHERNET_MAC1_RXFLOWCTRL_Pos = 0x2        // Position of RXFLOWCTRL field.
	ETHERNET_MAC1_RXFLOWCTRL_Msk = 0x4        // Bit mask of RXFLOWCTRL field.
	ETHERNET_MAC1_RXFLOWCTRL     = 0x4        // Bit RXFLOWCTRL.
	ETHERNET_MAC1_TXFLOWCTRL_Pos = 0x3        // Position of TXFLOWCTRL field.
	ETHERNET_MAC1_TXFLOWCTRL_Msk = 0x8        // Bit mask of TXFLOWCTRL field.
	ETHERNET_MAC1_TXFLOWCTRL     = 0x8        // Bit TXFLOWCTRL.
	ETHERNET_MAC1_LOOPBACK_Pos   = 0x4        // Position of LOOPBACK field.
	ETHERNET_MAC1_LOOPBACK_Msk   = 0x10       // Bit mask of LOOPBACK field.
	ETHERNET_MAC1_LOOPBACK       = 0x10       // Bit LOOPBACK.
	ETHERNET_MAC1_RESERVED_Pos   = 0x5        // Position of RESERVED field.
	ETHERNET_MAC1_RESERVED_Msk   = 0xe0       // Bit mask of RESERVED field.
	ETHERNET_MAC1_RESETTX_Pos    = 0x8        // Position of RESETTX field.
	ETHERNET_MAC1_RESETTX_Msk    = 0x100      // Bit mask of RESETTX field.
	ETHERNET_MAC1_RESETTX        = 0x100      // Bit RESETTX.
	ETHERNET_MAC1_RESETMCSTX_Pos = 0x9        // Position of RESETMCSTX field.
	ETHERNET_MAC1_RESETMCSTX_Msk = 0x200      // Bit mask of RESETMCSTX field.
	ETHERNET_MAC1_RESETMCSTX     = 0x200      // Bit RESETMCSTX.
	ETHERNET_MAC1_RESETRX_Pos    = 0xa        // Position of RESETRX field.
	ETHERNET_MAC1_RESETRX_Msk    = 0x400      // Bit mask of RESETRX field.
	ETHERNET_MAC1_RESETRX        = 0x400      // Bit RESETRX.
	ETHERNET_MAC1_RESETMCSRX_Pos = 0xb        // Position of RESETMCSRX field.
	ETHERNET_MAC1_RESETMCSRX_Msk = 0x800      // Bit mask of RESETMCSRX field.
	ETHERNET_MAC1_RESETMCSRX     = 0x800      // Bit RESETMCSRX.
	ETHERNET_MAC1_RESERVED_Pos   = 0xc        // Position of RESERVED field.
	ETHERNET_MAC1_RESERVED_Msk   = 0x3000     // Bit mask of RESERVED field.
	ETHERNET_MAC1_SIMRESET_Pos   = 0xe        // Position of SIMRESET field.
	ETHERNET_MAC1_SIMRESET_Msk   = 0x4000     // Bit mask of SIMRESET field.
	ETHERNET_MAC1_SIMRESET       = 0x4000     // Bit SIMRESET.
	ETHERNET_MAC1_SOFTRESET_Pos  = 0xf        // Position of SOFTRESET field.
	ETHERNET_MAC1_SOFTRESET_Msk  = 0x8000     // Bit mask of SOFTRESET field.
	ETHERNET_MAC1_SOFTRESET      = 0x8000     // Bit SOFTRESET.
	ETHERNET_MAC1_RESERVED_Pos   = 0x10       // Position of RESERVED field.
	ETHERNET_MAC1_RESERVED_Msk   = 0xffff0000 // Bit mask of RESERVED field.

	// MAC2: MAC configuration register 2.
	ETHERNET_MAC2_FULLDUPLEX_Pos   = 0x0        // Position of FULLDUPLEX field.
	ETHERNET_MAC2_FULLDUPLEX_Msk   = 0x1        // Bit mask of FULLDUPLEX field.
	ETHERNET_MAC2_FULLDUPLEX       = 0x1        // Bit FULLDUPLEX.
	ETHERNET_MAC2_FLC_Pos          = 0x1        // Position of FLC field.
	ETHERNET_MAC2_FLC_Msk          = 0x2        // Bit mask of FLC field.
	ETHERNET_MAC2_FLC              = 0x2        // Bit FLC.
	ETHERNET_MAC2_HFEN_Pos         = 0x2        // Position of HFEN field.
	ETHERNET_MAC2_HFEN_Msk         = 0x4        // Bit mask of HFEN field.
	ETHERNET_MAC2_HFEN             = 0x4        // Bit HFEN.
	ETHERNET_MAC2_DELAYEDCRC_Pos   = 0x3        // Position of DELAYEDCRC field.
	ETHERNET_MAC2_DELAYEDCRC_Msk   = 0x8        // Bit mask of DELAYEDCRC field.
	ETHERNET_MAC2_DELAYEDCRC       = 0x8        // Bit DELAYEDCRC.
	ETHERNET_MAC2_CRCEN_Pos        = 0x4        // Position of CRCEN field.
	ETHERNET_MAC2_CRCEN_Msk        = 0x10       // Bit mask of CRCEN field.
	ETHERNET_MAC2_CRCEN            = 0x10       // Bit CRCEN.
	ETHERNET_MAC2_PADCRCEN_Pos     = 0x5        // Position of PADCRCEN field.
	ETHERNET_MAC2_PADCRCEN_Msk     = 0x20       // Bit mask of PADCRCEN field.
	ETHERNET_MAC2_PADCRCEN         = 0x20       // Bit PADCRCEN.
	ETHERNET_MAC2_VLANPADEN_Pos    = 0x6        // Position of VLANPADEN field.
	ETHERNET_MAC2_VLANPADEN_Msk    = 0x40       // Bit mask of VLANPADEN field.
	ETHERNET_MAC2_VLANPADEN        = 0x40       // Bit VLANPADEN.
	ETHERNET_MAC2_AUTODETPADEN_Pos = 0x7        // Position of AUTODETPADEN field.
	ETHERNET_MAC2_AUTODETPADEN_Msk = 0x80       // Bit mask of AUTODETPADEN field.
	ETHERNET_MAC2_AUTODETPADEN     = 0x80       // Bit AUTODETPADEN.
	ETHERNET_MAC2_PPENF_Pos        = 0x8        // Position of PPENF field.
	ETHERNET_MAC2_PPENF_Msk        = 0x100      // Bit mask of PPENF field.
	ETHERNET_MAC2_PPENF            = 0x100      // Bit PPENF.
	ETHERNET_MAC2_LPENF_Pos        = 0x9        // Position of LPENF field.
	ETHERNET_MAC2_LPENF_Msk        = 0x200      // Bit mask of LPENF field.
	ETHERNET_MAC2_LPENF            = 0x200      // Bit LPENF.
	ETHERNET_MAC2_RESERVED_Pos     = 0xa        // Position of RESERVED field.
	ETHERNET_MAC2_RESERVED_Msk     = 0xc00      // Bit mask of RESERVED field.
	ETHERNET_MAC2_NOBACKOFF_Pos    = 0xc        // Position of NOBACKOFF field.
	ETHERNET_MAC2_NOBACKOFF_Msk    = 0x1000     // Bit mask of NOBACKOFF field.
	ETHERNET_MAC2_NOBACKOFF        = 0x1000     // Bit NOBACKOFF.
	ETHERNET_MAC2_BP_NOBACKOFF_Pos = 0xd        // Position of BP_NOBACKOFF field.
	ETHERNET_MAC2_BP_NOBACKOFF_Msk = 0x2000     // Bit mask of BP_NOBACKOFF field.
	ETHERNET_MAC2_BP_NOBACKOFF     = 0x2000     // Bit BP_NOBACKOFF.
	ETHERNET_MAC2_EXCESSDEFER_Pos  = 0xe        // Position of EXCESSDEFER field.
	ETHERNET_MAC2_EXCESSDEFER_Msk  = 0x4000     // Bit mask of EXCESSDEFER field.
	ETHERNET_MAC2_EXCESSDEFER      = 0x4000     // Bit EXCESSDEFER.
	ETHERNET_MAC2_RESERVED_Pos     = 0xf        // Position of RESERVED field.
	ETHERNET_MAC2_RESERVED_Msk     = 0xffff8000 // Bit mask of RESERVED field.

	// IPGT: Back-to-Back Inter-Packet-Gap register.
	ETHERNET_IPGT_BTOBINTEGAP_Pos = 0x0        // Position of BTOBINTEGAP field.
	ETHERNET_IPGT_BTOBINTEGAP_Msk = 0x7f       // Bit mask of BTOBINTEGAP field.
	ETHERNET_IPGT_RESERVED_Pos    = 0x7        // Position of RESERVED field.
	ETHERNET_IPGT_RESERVED_Msk    = 0xffffff80 // Bit mask of RESERVED field.

	// IPGR: Non Back-to-Back Inter-Packet-Gap register.
	ETHERNET_IPGR_NBTOBINTEGAP2_Pos = 0x0        // Position of NBTOBINTEGAP2 field.
	ETHERNET_IPGR_NBTOBINTEGAP2_Msk = 0x7f       // Bit mask of NBTOBINTEGAP2 field.
	ETHERNET_IPGR_RESERVED_Pos      = 0x7        // Position of RESERVED field.
	ETHERNET_IPGR_RESERVED_Msk      = 0x80       // Bit mask of RESERVED field.
	ETHERNET_IPGR_RESERVED          = 0x80       // Bit RESERVED.
	ETHERNET_IPGR_NBTOBINTEGAP1_Pos = 0x8        // Position of NBTOBINTEGAP1 field.
	ETHERNET_IPGR_NBTOBINTEGAP1_Msk = 0x7f00     // Bit mask of NBTOBINTEGAP1 field.
	ETHERNET_IPGR_RESERVED_Pos      = 0xf        // Position of RESERVED field.
	ETHERNET_IPGR_RESERVED_Msk      = 0xffff8000 // Bit mask of RESERVED field.

	// CLRT: Collision window / Retry register.
	ETHERNET_CLRT_RETRANSMAX_Pos = 0x0        // Position of RETRANSMAX field.
	ETHERNET_CLRT_RETRANSMAX_Msk = 0xf        // Bit mask of RETRANSMAX field.
	ETHERNET_CLRT_RESERVED_Pos   = 0x4        // Position of RESERVED field.
	ETHERNET_CLRT_RESERVED_Msk   = 0xf0       // Bit mask of RESERVED field.
	ETHERNET_CLRT_COLLWIN_Pos    = 0x8        // Position of COLLWIN field.
	ETHERNET_CLRT_COLLWIN_Msk    = 0x3f00     // Bit mask of COLLWIN field.
	ETHERNET_CLRT_RESERVED_Pos   = 0xe        // Position of RESERVED field.
	ETHERNET_CLRT_RESERVED_Msk   = 0xffffc000 // Bit mask of RESERVED field.

	// MAXF: Maximum Frame register.
	ETHERNET_MAXF_MAXFLEN_Pos  = 0x0        // Position of MAXFLEN field.
	ETHERNET_MAXF_MAXFLEN_Msk  = 0xffff     // Bit mask of MAXFLEN field.
	ETHERNET_MAXF_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_MAXF_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// SUPP: PHY Support register.
	ETHERNET_SUPP_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ETHERNET_SUPP_RESERVED_Msk = 0xff       // Bit mask of RESERVED field.
	ETHERNET_SUPP_SPEED_Pos    = 0x8        // Position of SPEED field.
	ETHERNET_SUPP_SPEED_Msk    = 0x100      // Bit mask of SPEED field.
	ETHERNET_SUPP_SPEED        = 0x100      // Bit SPEED.
	ETHERNET_SUPP_RESERVED_Pos = 0x9        // Position of RESERVED field.
	ETHERNET_SUPP_RESERVED_Msk = 0xfffffe00 // Bit mask of RESERVED field.

	// TEST: Test register.
	ETHERNET_TEST_SCPQ_Pos      = 0x0        // Position of SCPQ field.
	ETHERNET_TEST_SCPQ_Msk      = 0x1        // Bit mask of SCPQ field.
	ETHERNET_TEST_SCPQ          = 0x1        // Bit SCPQ.
	ETHERNET_TEST_TESTPAUSE_Pos = 0x1        // Position of TESTPAUSE field.
	ETHERNET_TEST_TESTPAUSE_Msk = 0x2        // Bit mask of TESTPAUSE field.
	ETHERNET_TEST_TESTPAUSE     = 0x2        // Bit TESTPAUSE.
	ETHERNET_TEST_TESTBP_Pos    = 0x2        // Position of TESTBP field.
	ETHERNET_TEST_TESTBP_Msk    = 0x4        // Bit mask of TESTBP field.
	ETHERNET_TEST_TESTBP        = 0x4        // Bit TESTBP.
	ETHERNET_TEST_RESERVED_Pos  = 0x3        // Position of RESERVED field.
	ETHERNET_TEST_RESERVED_Msk  = 0xfffffff8 // Bit mask of RESERVED field.

	// MCFG: MII Mgmt Configuration register.
	ETHERNET_MCFG_SCANINC_Pos      = 0x0        // Position of SCANINC field.
	ETHERNET_MCFG_SCANINC_Msk      = 0x1        // Bit mask of SCANINC field.
	ETHERNET_MCFG_SCANINC          = 0x1        // Bit SCANINC.
	ETHERNET_MCFG_SUPPPREAMBLE_Pos = 0x1        // Position of SUPPPREAMBLE field.
	ETHERNET_MCFG_SUPPPREAMBLE_Msk = 0x2        // Bit mask of SUPPPREAMBLE field.
	ETHERNET_MCFG_SUPPPREAMBLE     = 0x2        // Bit SUPPPREAMBLE.
	ETHERNET_MCFG_CLOCKSEL_Pos     = 0x2        // Position of CLOCKSEL field.
	ETHERNET_MCFG_CLOCKSEL_Msk     = 0x3c       // Bit mask of CLOCKSEL field.
	ETHERNET_MCFG_RESERVED_Pos     = 0x6        // Position of RESERVED field.
	ETHERNET_MCFG_RESERVED_Msk     = 0x7fc0     // Bit mask of RESERVED field.
	ETHERNET_MCFG_RESETMIIMGMT_Pos = 0xf        // Position of RESETMIIMGMT field.
	ETHERNET_MCFG_RESETMIIMGMT_Msk = 0x8000     // Bit mask of RESETMIIMGMT field.
	ETHERNET_MCFG_RESETMIIMGMT     = 0x8000     // Bit RESETMIIMGMT.
	ETHERNET_MCFG_RESERVED_Pos     = 0x10       // Position of RESERVED field.
	ETHERNET_MCFG_RESERVED_Msk     = 0xffff0000 // Bit mask of RESERVED field.

	// MCMD: MII Mgmt Command register.
	ETHERNET_MCMD_READ_Pos     = 0x0        // Position of READ field.
	ETHERNET_MCMD_READ_Msk     = 0x1        // Bit mask of READ field.
	ETHERNET_MCMD_READ         = 0x1        // Bit READ.
	ETHERNET_MCMD_SCAN_Pos     = 0x1        // Position of SCAN field.
	ETHERNET_MCMD_SCAN_Msk     = 0x2        // Bit mask of SCAN field.
	ETHERNET_MCMD_SCAN         = 0x2        // Bit SCAN.
	ETHERNET_MCMD_RESERVED_Pos = 0x2        // Position of RESERVED field.
	ETHERNET_MCMD_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// MADR: MII Mgmt Address register.
	ETHERNET_MADR_REGADDR_Pos  = 0x0        // Position of REGADDR field.
	ETHERNET_MADR_REGADDR_Msk  = 0x1f       // Bit mask of REGADDR field.
	ETHERNET_MADR_RESERVED_Pos = 0x5        // Position of RESERVED field.
	ETHERNET_MADR_RESERVED_Msk = 0xe0       // Bit mask of RESERVED field.
	ETHERNET_MADR_PHYADDR_Pos  = 0x8        // Position of PHYADDR field.
	ETHERNET_MADR_PHYADDR_Msk  = 0x1f00     // Bit mask of PHYADDR field.
	ETHERNET_MADR_RESERVED_Pos = 0xd        // Position of RESERVED field.
	ETHERNET_MADR_RESERVED_Msk = 0xffffe000 // Bit mask of RESERVED field.

	// MWTD: MII Mgmt Write Data register.
	ETHERNET_MWTD_WRITEDATA_Pos = 0x0        // Position of WRITEDATA field.
	ETHERNET_MWTD_WRITEDATA_Msk = 0xffff     // Bit mask of WRITEDATA field.
	ETHERNET_MWTD_RESERVED_Pos  = 0x10       // Position of RESERVED field.
	ETHERNET_MWTD_RESERVED_Msk  = 0xffff0000 // Bit mask of RESERVED field.

	// MRDD: MII Mgmt Read Data register.
	ETHERNET_MRDD_READDATA_Pos = 0x0        // Position of READDATA field.
	ETHERNET_MRDD_READDATA_Msk = 0xffff     // Bit mask of READDATA field.
	ETHERNET_MRDD_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_MRDD_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// MIND: MII Mgmt Indicators register.
	ETHERNET_MIND_BUSY_Pos        = 0x0        // Position of BUSY field.
	ETHERNET_MIND_BUSY_Msk        = 0x1        // Bit mask of BUSY field.
	ETHERNET_MIND_BUSY            = 0x1        // Bit BUSY.
	ETHERNET_MIND_SCANNING_Pos    = 0x1        // Position of SCANNING field.
	ETHERNET_MIND_SCANNING_Msk    = 0x2        // Bit mask of SCANNING field.
	ETHERNET_MIND_SCANNING        = 0x2        // Bit SCANNING.
	ETHERNET_MIND_NOTVALID_Pos    = 0x2        // Position of NOTVALID field.
	ETHERNET_MIND_NOTVALID_Msk    = 0x4        // Bit mask of NOTVALID field.
	ETHERNET_MIND_NOTVALID        = 0x4        // Bit NOTVALID.
	ETHERNET_MIND_MIILINKFAIL_Pos = 0x3        // Position of MIILINKFAIL field.
	ETHERNET_MIND_MIILINKFAIL_Msk = 0x8        // Bit mask of MIILINKFAIL field.
	ETHERNET_MIND_MIILINKFAIL     = 0x8        // Bit MIILINKFAIL.
	ETHERNET_MIND_RESERVED_Pos    = 0x4        // Position of RESERVED field.
	ETHERNET_MIND_RESERVED_Msk    = 0xfffffff0 // Bit mask of RESERVED field.

	// SA0: Station Address 0 register.
	ETHERNET_SA0_SADDR2_Pos   = 0x0        // Position of SADDR2 field.
	ETHERNET_SA0_SADDR2_Msk   = 0xff       // Bit mask of SADDR2 field.
	ETHERNET_SA0_SADDR1_Pos   = 0x8        // Position of SADDR1 field.
	ETHERNET_SA0_SADDR1_Msk   = 0xff00     // Bit mask of SADDR1 field.
	ETHERNET_SA0_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_SA0_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// SA1: Station Address 1 register.
	ETHERNET_SA1_SADDR4_Pos   = 0x0        // Position of SADDR4 field.
	ETHERNET_SA1_SADDR4_Msk   = 0xff       // Bit mask of SADDR4 field.
	ETHERNET_SA1_SADDR3_Pos   = 0x8        // Position of SADDR3 field.
	ETHERNET_SA1_SADDR3_Msk   = 0xff00     // Bit mask of SADDR3 field.
	ETHERNET_SA1_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_SA1_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// SA2: Station Address 2 register.
	ETHERNET_SA2_SADDR6_Pos   = 0x0        // Position of SADDR6 field.
	ETHERNET_SA2_SADDR6_Msk   = 0xff       // Bit mask of SADDR6 field.
	ETHERNET_SA2_SADDR5_Pos   = 0x8        // Position of SADDR5 field.
	ETHERNET_SA2_SADDR5_Msk   = 0xff00     // Bit mask of SADDR5 field.
	ETHERNET_SA2_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_SA2_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// COMMAND: Command register.
	ETHERNET_COMMAND_RXENABLE_Pos      = 0x0        // Position of RXENABLE field.
	ETHERNET_COMMAND_RXENABLE_Msk      = 0x1        // Bit mask of RXENABLE field.
	ETHERNET_COMMAND_RXENABLE          = 0x1        // Bit RXENABLE.
	ETHERNET_COMMAND_TXENABLE_Pos      = 0x1        // Position of TXENABLE field.
	ETHERNET_COMMAND_TXENABLE_Msk      = 0x2        // Bit mask of TXENABLE field.
	ETHERNET_COMMAND_TXENABLE          = 0x2        // Bit TXENABLE.
	ETHERNET_COMMAND_RESERVED_Pos      = 0x2        // Position of RESERVED field.
	ETHERNET_COMMAND_RESERVED_Msk      = 0x4        // Bit mask of RESERVED field.
	ETHERNET_COMMAND_RESERVED          = 0x4        // Bit RESERVED.
	ETHERNET_COMMAND_REGRESET_Pos      = 0x3        // Position of REGRESET field.
	ETHERNET_COMMAND_REGRESET_Msk      = 0x8        // Bit mask of REGRESET field.
	ETHERNET_COMMAND_REGRESET          = 0x8        // Bit REGRESET.
	ETHERNET_COMMAND_TXRESET_Pos       = 0x4        // Position of TXRESET field.
	ETHERNET_COMMAND_TXRESET_Msk       = 0x10       // Bit mask of TXRESET field.
	ETHERNET_COMMAND_TXRESET           = 0x10       // Bit TXRESET.
	ETHERNET_COMMAND_RXRESET_Pos       = 0x5        // Position of RXRESET field.
	ETHERNET_COMMAND_RXRESET_Msk       = 0x20       // Bit mask of RXRESET field.
	ETHERNET_COMMAND_RXRESET           = 0x20       // Bit RXRESET.
	ETHERNET_COMMAND_PASSRUNTFRAME_Pos = 0x6        // Position of PASSRUNTFRAME field.
	ETHERNET_COMMAND_PASSRUNTFRAME_Msk = 0x40       // Bit mask of PASSRUNTFRAME field.
	ETHERNET_COMMAND_PASSRUNTFRAME     = 0x40       // Bit PASSRUNTFRAME.
	ETHERNET_COMMAND_PASSRXFILTER_Pos  = 0x7        // Position of PASSRXFILTER field.
	ETHERNET_COMMAND_PASSRXFILTER_Msk  = 0x80       // Bit mask of PASSRXFILTER field.
	ETHERNET_COMMAND_PASSRXFILTER      = 0x80       // Bit PASSRXFILTER.
	ETHERNET_COMMAND_TXFLOWCONTROL_Pos = 0x8        // Position of TXFLOWCONTROL field.
	ETHERNET_COMMAND_TXFLOWCONTROL_Msk = 0x100      // Bit mask of TXFLOWCONTROL field.
	ETHERNET_COMMAND_TXFLOWCONTROL     = 0x100      // Bit TXFLOWCONTROL.
	ETHERNET_COMMAND_RMII_Pos          = 0x9        // Position of RMII field.
	ETHERNET_COMMAND_RMII_Msk          = 0x200      // Bit mask of RMII field.
	ETHERNET_COMMAND_RMII              = 0x200      // Bit RMII.
	ETHERNET_COMMAND_FULLDUPLEX_Pos    = 0xa        // Position of FULLDUPLEX field.
	ETHERNET_COMMAND_FULLDUPLEX_Msk    = 0x400      // Bit mask of FULLDUPLEX field.
	ETHERNET_COMMAND_FULLDUPLEX        = 0x400      // Bit FULLDUPLEX.
	ETHERNET_COMMAND_RESERVED_Pos      = 0xb        // Position of RESERVED field.
	ETHERNET_COMMAND_RESERVED_Msk      = 0xfffff800 // Bit mask of RESERVED field.

	// STATUS: Status register.
	ETHERNET_STATUS_RXSTATUS_Pos = 0x0        // Position of RXSTATUS field.
	ETHERNET_STATUS_RXSTATUS_Msk = 0x1        // Bit mask of RXSTATUS field.
	ETHERNET_STATUS_RXSTATUS     = 0x1        // Bit RXSTATUS.
	ETHERNET_STATUS_TXSTATUS_Pos = 0x1        // Position of TXSTATUS field.
	ETHERNET_STATUS_TXSTATUS_Msk = 0x2        // Bit mask of TXSTATUS field.
	ETHERNET_STATUS_TXSTATUS     = 0x2        // Bit TXSTATUS.
	ETHERNET_STATUS_RESERVED_Pos = 0x2        // Position of RESERVED field.
	ETHERNET_STATUS_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// RXDESCRIPTOR: Receive descriptor base address register.
	ETHERNET_RXDESCRIPTOR_RESERVED_Pos     = 0x0        // Position of RESERVED field.
	ETHERNET_RXDESCRIPTOR_RESERVED_Msk     = 0x3        // Bit mask of RESERVED field.
	ETHERNET_RXDESCRIPTOR_RXDESCRIPTOR_Pos = 0x2        // Position of RXDESCRIPTOR field.
	ETHERNET_RXDESCRIPTOR_RXDESCRIPTOR_Msk = 0xfffffffc // Bit mask of RXDESCRIPTOR field.

	// RXSTATUS: Receive status base address register.
	ETHERNET_RXSTATUS_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ETHERNET_RXSTATUS_RESERVED_Msk = 0x7        // Bit mask of RESERVED field.
	ETHERNET_RXSTATUS_RXSTATUS_Pos = 0x3        // Position of RXSTATUS field.
	ETHERNET_RXSTATUS_RXSTATUS_Msk = 0xfffffff8 // Bit mask of RXSTATUS field.

	// RXDESCRIPTORNUMBER: Receive number of descriptors register.
	ETHERNET_RXDESCRIPTORNUMBER_RXDESCRIPTORN_Pos = 0x0        // Position of RXDESCRIPTORN field.
	ETHERNET_RXDESCRIPTORNUMBER_RXDESCRIPTORN_Msk = 0xffff     // Bit mask of RXDESCRIPTORN field.
	ETHERNET_RXDESCRIPTORNUMBER_RESERVED_Pos      = 0x10       // Position of RESERVED field.
	ETHERNET_RXDESCRIPTORNUMBER_RESERVED_Msk      = 0xffff0000 // Bit mask of RESERVED field.

	// RXPRODUCEINDEX: Receive produce index register.
	ETHERNET_RXPRODUCEINDEX_RXPRODUCEIX_Pos = 0x0        // Position of RXPRODUCEIX field.
	ETHERNET_RXPRODUCEINDEX_RXPRODUCEIX_Msk = 0xffff     // Bit mask of RXPRODUCEIX field.
	ETHERNET_RXPRODUCEINDEX_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	ETHERNET_RXPRODUCEINDEX_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// RXCONSUMEINDEX: Receive consume index register.
	ETHERNET_RXCONSUMEINDEX_RXCONSUMEIX_Pos = 0x0        // Position of RXCONSUMEIX field.
	ETHERNET_RXCONSUMEINDEX_RXCONSUMEIX_Msk = 0xffff     // Bit mask of RXCONSUMEIX field.
	ETHERNET_RXCONSUMEINDEX_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	ETHERNET_RXCONSUMEINDEX_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// TXDESCRIPTOR: Transmit descriptor base address register.
	ETHERNET_TXDESCRIPTOR_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ETHERNET_TXDESCRIPTOR_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	ETHERNET_TXDESCRIPTOR_TXD_Pos      = 0x2        // Position of TXD field.
	ETHERNET_TXDESCRIPTOR_TXD_Msk      = 0xfffffffc // Bit mask of TXD field.

	// TXSTATUS: Transmit status base address register.
	ETHERNET_TXSTATUS_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ETHERNET_TXSTATUS_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	ETHERNET_TXSTATUS_TXSTAT_Pos   = 0x2        // Position of TXSTAT field.
	ETHERNET_TXSTATUS_TXSTAT_Msk   = 0xfffffffc // Bit mask of TXSTAT field.

	// TXDESCRIPTORNUMBER: Transmit number of descriptors register.
	ETHERNET_TXDESCRIPTORNUMBER_TXDN_Pos     = 0x0        // Position of TXDN field.
	ETHERNET_TXDESCRIPTORNUMBER_TXDN_Msk     = 0xffff     // Bit mask of TXDN field.
	ETHERNET_TXDESCRIPTORNUMBER_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_TXDESCRIPTORNUMBER_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// TXPRODUCEINDEX: Transmit produce index register.
	ETHERNET_TXPRODUCEINDEX_TXPI_Pos     = 0x0        // Position of TXPI field.
	ETHERNET_TXPRODUCEINDEX_TXPI_Msk     = 0xffff     // Bit mask of TXPI field.
	ETHERNET_TXPRODUCEINDEX_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_TXPRODUCEINDEX_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// TXCONSUMEINDEX: Transmit consume index register.
	ETHERNET_TXCONSUMEINDEX_TXCI_Pos     = 0x0        // Position of TXCI field.
	ETHERNET_TXCONSUMEINDEX_TXCI_Msk     = 0xffff     // Bit mask of TXCI field.
	ETHERNET_TXCONSUMEINDEX_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_TXCONSUMEINDEX_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// TSV0: Transmit status vector 0 register.
	ETHERNET_TSV0_CRCERR_Pos       = 0x0        // Position of CRCERR field.
	ETHERNET_TSV0_CRCERR_Msk       = 0x1        // Bit mask of CRCERR field.
	ETHERNET_TSV0_CRCERR           = 0x1        // Bit CRCERR.
	ETHERNET_TSV0_LCE_Pos          = 0x1        // Position of LCE field.
	ETHERNET_TSV0_LCE_Msk          = 0x2        // Bit mask of LCE field.
	ETHERNET_TSV0_LCE              = 0x2        // Bit LCE.
	ETHERNET_TSV0_LOR_Pos          = 0x2        // Position of LOR field.
	ETHERNET_TSV0_LOR_Msk          = 0x4        // Bit mask of LOR field.
	ETHERNET_TSV0_LOR              = 0x4        // Bit LOR.
	ETHERNET_TSV0_DONE_Pos         = 0x3        // Position of DONE field.
	ETHERNET_TSV0_DONE_Msk         = 0x8        // Bit mask of DONE field.
	ETHERNET_TSV0_DONE             = 0x8        // Bit DONE.
	ETHERNET_TSV0_MULTICAST_Pos    = 0x4        // Position of MULTICAST field.
	ETHERNET_TSV0_MULTICAST_Msk    = 0x10       // Bit mask of MULTICAST field.
	ETHERNET_TSV0_MULTICAST        = 0x10       // Bit MULTICAST.
	ETHERNET_TSV0_BROADCAST_Pos    = 0x5        // Position of BROADCAST field.
	ETHERNET_TSV0_BROADCAST_Msk    = 0x20       // Bit mask of BROADCAST field.
	ETHERNET_TSV0_BROADCAST        = 0x20       // Bit BROADCAST.
	ETHERNET_TSV0_PACKETDEFER_Pos  = 0x6        // Position of PACKETDEFER field.
	ETHERNET_TSV0_PACKETDEFER_Msk  = 0x40       // Bit mask of PACKETDEFER field.
	ETHERNET_TSV0_PACKETDEFER      = 0x40       // Bit PACKETDEFER.
	ETHERNET_TSV0_EXDF_Pos         = 0x7        // Position of EXDF field.
	ETHERNET_TSV0_EXDF_Msk         = 0x80       // Bit mask of EXDF field.
	ETHERNET_TSV0_EXDF             = 0x80       // Bit EXDF.
	ETHERNET_TSV0_EXCOL_Pos        = 0x8        // Position of EXCOL field.
	ETHERNET_TSV0_EXCOL_Msk        = 0x100      // Bit mask of EXCOL field.
	ETHERNET_TSV0_EXCOL            = 0x100      // Bit EXCOL.
	ETHERNET_TSV0_LCOL_Pos         = 0x9        // Position of LCOL field.
	ETHERNET_TSV0_LCOL_Msk         = 0x200      // Bit mask of LCOL field.
	ETHERNET_TSV0_LCOL             = 0x200      // Bit LCOL.
	ETHERNET_TSV0_GIANT_Pos        = 0xa        // Position of GIANT field.
	ETHERNET_TSV0_GIANT_Msk        = 0x400      // Bit mask of GIANT field.
	ETHERNET_TSV0_GIANT            = 0x400      // Bit GIANT.
	ETHERNET_TSV0_UNDERRUN_Pos     = 0xb        // Position of UNDERRUN field.
	ETHERNET_TSV0_UNDERRUN_Msk     = 0x800      // Bit mask of UNDERRUN field.
	ETHERNET_TSV0_UNDERRUN         = 0x800      // Bit UNDERRUN.
	ETHERNET_TSV0_TOTALBYTES_Pos   = 0xc        // Position of TOTALBYTES field.
	ETHERNET_TSV0_TOTALBYTES_Msk   = 0xffff000  // Bit mask of TOTALBYTES field.
	ETHERNET_TSV0_CONTROLFRAME_Pos = 0x1c       // Position of CONTROLFRAME field.
	ETHERNET_TSV0_CONTROLFRAME_Msk = 0x10000000 // Bit mask of CONTROLFRAME field.
	ETHERNET_TSV0_CONTROLFRAME     = 0x10000000 // Bit CONTROLFRAME.
	ETHERNET_TSV0_PAUSE_Pos        = 0x1d       // Position of PAUSE field.
	ETHERNET_TSV0_PAUSE_Msk        = 0x20000000 // Bit mask of PAUSE field.
	ETHERNET_TSV0_PAUSE            = 0x20000000 // Bit PAUSE.
	ETHERNET_TSV0_BACKPRESSURE_Pos = 0x1e       // Position of BACKPRESSURE field.
	ETHERNET_TSV0_BACKPRESSURE_Msk = 0x40000000 // Bit mask of BACKPRESSURE field.
	ETHERNET_TSV0_BACKPRESSURE     = 0x40000000 // Bit BACKPRESSURE.
	ETHERNET_TSV0_VLAN_Pos         = 0x1f       // Position of VLAN field.
	ETHERNET_TSV0_VLAN_Msk         = 0x80000000 // Bit mask of VLAN field.
	ETHERNET_TSV0_VLAN             = 0x80000000 // Bit VLAN.

	// TSV1: Transmit status vector 1 register.
	ETHERNET_TSV1_TBC_Pos      = 0x0        // Position of TBC field.
	ETHERNET_TSV1_TBC_Msk      = 0xffff     // Bit mask of TBC field.
	ETHERNET_TSV1_TCC_Pos      = 0x10       // Position of TCC field.
	ETHERNET_TSV1_TCC_Msk      = 0xf0000    // Bit mask of TCC field.
	ETHERNET_TSV1_RESERVED_Pos = 0x14       // Position of RESERVED field.
	ETHERNET_TSV1_RESERVED_Msk = 0xfff00000 // Bit mask of RESERVED field.

	// RSV: Receive status vector register.
	ETHERNET_RSV_RBC_Pos           = 0x0        // Position of RBC field.
	ETHERNET_RSV_RBC_Msk           = 0xffff     // Bit mask of RBC field.
	ETHERNET_RSV_PPI_Pos           = 0x10       // Position of PPI field.
	ETHERNET_RSV_PPI_Msk           = 0x10000    // Bit mask of PPI field.
	ETHERNET_RSV_PPI               = 0x10000    // Bit PPI.
	ETHERNET_RSV_RXDVSEEN_Pos      = 0x11       // Position of RXDVSEEN field.
	ETHERNET_RSV_RXDVSEEN_Msk      = 0x20000    // Bit mask of RXDVSEEN field.
	ETHERNET_RSV_RXDVSEEN          = 0x20000    // Bit RXDVSEEN.
	ETHERNET_RSV_CESEEN_Pos        = 0x12       // Position of CESEEN field.
	ETHERNET_RSV_CESEEN_Msk        = 0x40000    // Bit mask of CESEEN field.
	ETHERNET_RSV_CESEEN            = 0x40000    // Bit CESEEN.
	ETHERNET_RSV_RCV_Pos           = 0x13       // Position of RCV field.
	ETHERNET_RSV_RCV_Msk           = 0x80000    // Bit mask of RCV field.
	ETHERNET_RSV_RCV               = 0x80000    // Bit RCV.
	ETHERNET_RSV_CRCERR_Pos        = 0x14       // Position of CRCERR field.
	ETHERNET_RSV_CRCERR_Msk        = 0x100000   // Bit mask of CRCERR field.
	ETHERNET_RSV_CRCERR            = 0x100000   // Bit CRCERR.
	ETHERNET_RSV_LCERR_Pos         = 0x15       // Position of LCERR field.
	ETHERNET_RSV_LCERR_Msk         = 0x200000   // Bit mask of LCERR field.
	ETHERNET_RSV_LCERR             = 0x200000   // Bit LCERR.
	ETHERNET_RSV_LOR_Pos           = 0x16       // Position of LOR field.
	ETHERNET_RSV_LOR_Msk           = 0x400000   // Bit mask of LOR field.
	ETHERNET_RSV_LOR               = 0x400000   // Bit LOR.
	ETHERNET_RSV_ROK_Pos           = 0x17       // Position of ROK field.
	ETHERNET_RSV_ROK_Msk           = 0x800000   // Bit mask of ROK field.
	ETHERNET_RSV_ROK               = 0x800000   // Bit ROK.
	ETHERNET_RSV_MULTICAST_Pos     = 0x18       // Position of MULTICAST field.
	ETHERNET_RSV_MULTICAST_Msk     = 0x1000000  // Bit mask of MULTICAST field.
	ETHERNET_RSV_MULTICAST         = 0x1000000  // Bit MULTICAST.
	ETHERNET_RSV_BROADCAST_Pos     = 0x19       // Position of BROADCAST field.
	ETHERNET_RSV_BROADCAST_Msk     = 0x2000000  // Bit mask of BROADCAST field.
	ETHERNET_RSV_BROADCAST         = 0x2000000  // Bit BROADCAST.
	ETHERNET_RSV_DRIBBLENIBBLE_Pos = 0x1a       // Position of DRIBBLENIBBLE field.
	ETHERNET_RSV_DRIBBLENIBBLE_Msk = 0x4000000  // Bit mask of DRIBBLENIBBLE field.
	ETHERNET_RSV_DRIBBLENIBBLE     = 0x4000000  // Bit DRIBBLENIBBLE.
	ETHERNET_RSV_CONTROLFRAME_Pos  = 0x1b       // Position of CONTROLFRAME field.
	ETHERNET_RSV_CONTROLFRAME_Msk  = 0x8000000  // Bit mask of CONTROLFRAME field.
	ETHERNET_RSV_CONTROLFRAME      = 0x8000000  // Bit CONTROLFRAME.
	ETHERNET_RSV_PAUSE_Pos         = 0x1c       // Position of PAUSE field.
	ETHERNET_RSV_PAUSE_Msk         = 0x10000000 // Bit mask of PAUSE field.
	ETHERNET_RSV_PAUSE             = 0x10000000 // Bit PAUSE.
	ETHERNET_RSV_UO_Pos            = 0x1d       // Position of UO field.
	ETHERNET_RSV_UO_Msk            = 0x20000000 // Bit mask of UO field.
	ETHERNET_RSV_UO                = 0x20000000 // Bit UO.
	ETHERNET_RSV_VLAN_Pos          = 0x1e       // Position of VLAN field.
	ETHERNET_RSV_VLAN_Msk          = 0x40000000 // Bit mask of VLAN field.
	ETHERNET_RSV_VLAN              = 0x40000000 // Bit VLAN.
	ETHERNET_RSV_RESERVED_Pos      = 0x1f       // Position of RESERVED field.
	ETHERNET_RSV_RESERVED_Msk      = 0x80000000 // Bit mask of RESERVED field.
	ETHERNET_RSV_RESERVED          = 0x80000000 // Bit RESERVED.

	// FLOWCONTROLCOUNTER: Flow control counter register.
	ETHERNET_FLOWCONTROLCOUNTER_MC_Pos = 0x0        // Position of MC field.
	ETHERNET_FLOWCONTROLCOUNTER_MC_Msk = 0xffff     // Bit mask of MC field.
	ETHERNET_FLOWCONTROLCOUNTER_PT_Pos = 0x10       // Position of PT field.
	ETHERNET_FLOWCONTROLCOUNTER_PT_Msk = 0xffff0000 // Bit mask of PT field.

	// FLOWCONTROLSTATUS: Flow control status register.
	ETHERNET_FLOWCONTROLSTATUS_MCC_Pos      = 0x0        // Position of MCC field.
	ETHERNET_FLOWCONTROLSTATUS_MCC_Msk      = 0xffff     // Bit mask of MCC field.
	ETHERNET_FLOWCONTROLSTATUS_RESERVED_Pos = 0x10       // Position of RESERVED field.
	ETHERNET_FLOWCONTROLSTATUS_RESERVED_Msk = 0xffff0000 // Bit mask of RESERVED field.

	// RXFILTERCTRL: Receive filter control register.
	ETHERNET_RXFILTERCTRL_AUE_Pos      = 0x0        // Position of AUE field.
	ETHERNET_RXFILTERCTRL_AUE_Msk      = 0x1        // Bit mask of AUE field.
	ETHERNET_RXFILTERCTRL_AUE          = 0x1        // Bit AUE.
	ETHERNET_RXFILTERCTRL_ABE_Pos      = 0x1        // Position of ABE field.
	ETHERNET_RXFILTERCTRL_ABE_Msk      = 0x2        // Bit mask of ABE field.
	ETHERNET_RXFILTERCTRL_ABE          = 0x2        // Bit ABE.
	ETHERNET_RXFILTERCTRL_AME_Pos      = 0x2        // Position of AME field.
	ETHERNET_RXFILTERCTRL_AME_Msk      = 0x4        // Bit mask of AME field.
	ETHERNET_RXFILTERCTRL_AME          = 0x4        // Bit AME.
	ETHERNET_RXFILTERCTRL_AUHE_Pos     = 0x3        // Position of AUHE field.
	ETHERNET_RXFILTERCTRL_AUHE_Msk     = 0x8        // Bit mask of AUHE field.
	ETHERNET_RXFILTERCTRL_AUHE         = 0x8        // Bit AUHE.
	ETHERNET_RXFILTERCTRL_AMHE_Pos     = 0x4        // Position of AMHE field.
	ETHERNET_RXFILTERCTRL_AMHE_Msk     = 0x10       // Bit mask of AMHE field.
	ETHERNET_RXFILTERCTRL_AMHE         = 0x10       // Bit AMHE.
	ETHERNET_RXFILTERCTRL_APE_Pos      = 0x5        // Position of APE field.
	ETHERNET_RXFILTERCTRL_APE_Msk      = 0x20       // Bit mask of APE field.
	ETHERNET_RXFILTERCTRL_APE          = 0x20       // Bit APE.
	ETHERNET_RXFILTERCTRL_RESERVED_Pos = 0x6        // Position of RESERVED field.
	ETHERNET_RXFILTERCTRL_RESERVED_Msk = 0xfc0      // Bit mask of RESERVED field.
	ETHERNET_RXFILTERCTRL_MPEW_Pos     = 0xc        // Position of MPEW field.
	ETHERNET_RXFILTERCTRL_MPEW_Msk     = 0x1000     // Bit mask of MPEW field.
	ETHERNET_RXFILTERCTRL_MPEW         = 0x1000     // Bit MPEW.
	ETHERNET_RXFILTERCTRL_RFEW_Pos     = 0xd        // Position of RFEW field.
	ETHERNET_RXFILTERCTRL_RFEW_Msk     = 0x2000     // Bit mask of RFEW field.
	ETHERNET_RXFILTERCTRL_RFEW         = 0x2000     // Bit RFEW.
	ETHERNET_RXFILTERCTRL_RESERVED_Pos = 0xe        // Position of RESERVED field.
	ETHERNET_RXFILTERCTRL_RESERVED_Msk = 0xffffc000 // Bit mask of RESERVED field.

	// RXFILTERWOLSTATUS: Receive filter WoL status register.
	ETHERNET_RXFILTERWOLSTATUS_AUW_Pos      = 0x0        // Position of AUW field.
	ETHERNET_RXFILTERWOLSTATUS_AUW_Msk      = 0x1        // Bit mask of AUW field.
	ETHERNET_RXFILTERWOLSTATUS_AUW          = 0x1        // Bit AUW.
	ETHERNET_RXFILTERWOLSTATUS_ABW_Pos      = 0x1        // Position of ABW field.
	ETHERNET_RXFILTERWOLSTATUS_ABW_Msk      = 0x2        // Bit mask of ABW field.
	ETHERNET_RXFILTERWOLSTATUS_ABW          = 0x2        // Bit ABW.
	ETHERNET_RXFILTERWOLSTATUS_AMW_Pos      = 0x2        // Position of AMW field.
	ETHERNET_RXFILTERWOLSTATUS_AMW_Msk      = 0x4        // Bit mask of AMW field.
	ETHERNET_RXFILTERWOLSTATUS_AMW          = 0x4        // Bit AMW.
	ETHERNET_RXFILTERWOLSTATUS_AUHW_Pos     = 0x3        // Position of AUHW field.
	ETHERNET_RXFILTERWOLSTATUS_AUHW_Msk     = 0x8        // Bit mask of AUHW field.
	ETHERNET_RXFILTERWOLSTATUS_AUHW         = 0x8        // Bit AUHW.
	ETHERNET_RXFILTERWOLSTATUS_AMHW_Pos     = 0x4        // Position of AMHW field.
	ETHERNET_RXFILTERWOLSTATUS_AMHW_Msk     = 0x10       // Bit mask of AMHW field.
	ETHERNET_RXFILTERWOLSTATUS_AMHW         = 0x10       // Bit AMHW.
	ETHERNET_RXFILTERWOLSTATUS_APW_Pos      = 0x5        // Position of APW field.
	ETHERNET_RXFILTERWOLSTATUS_APW_Msk      = 0x20       // Bit mask of APW field.
	ETHERNET_RXFILTERWOLSTATUS_APW          = 0x20       // Bit APW.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Pos = 0x6        // Position of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Msk = 0x40       // Bit mask of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED     = 0x40       // Bit RESERVED.
	ETHERNET_RXFILTERWOLSTATUS_RFW_Pos      = 0x7        // Position of RFW field.
	ETHERNET_RXFILTERWOLSTATUS_RFW_Msk      = 0x80       // Bit mask of RFW field.
	ETHERNET_RXFILTERWOLSTATUS_RFW          = 0x80       // Bit RFW.
	ETHERNET_RXFILTERWOLSTATUS_MPW_Pos      = 0x8        // Position of MPW field.
	ETHERNET_RXFILTERWOLSTATUS_MPW_Msk      = 0x100      // Bit mask of MPW field.
	ETHERNET_RXFILTERWOLSTATUS_MPW          = 0x100      // Bit MPW.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Pos = 0x9        // Position of RESERVED field.
	ETHERNET_RXFILTERWOLSTATUS_RESERVED_Msk = 0xfffffe00 // Bit mask of RESERVED field.

	// RXFILTERWOLCLEAR: Receive filter WoL clear register.
	ETHERNET_RXFILTERWOLCLEAR_AUWCLR_Pos   = 0x0        // Position of AUWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUWCLR_Msk   = 0x1        // Bit mask of AUWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUWCLR       = 0x1        // Bit AUWCLR.
	ETHERNET_RXFILTERWOLCLEAR_ABWCLR_Pos   = 0x1        // Position of ABWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_ABWCLR_Msk   = 0x2        // Bit mask of ABWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_ABWCLR       = 0x2        // Bit ABWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AMWCLR_Pos   = 0x2        // Position of AMWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMWCLR_Msk   = 0x4        // Bit mask of AMWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMWCLR       = 0x4        // Bit AMWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AUHWCLR_Pos  = 0x3        // Position of AUHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUHWCLR_Msk  = 0x8        // Bit mask of AUHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AUHWCLR      = 0x8        // Bit AUHWCLR.
	ETHERNET_RXFILTERWOLCLEAR_AMHWCLR_Pos  = 0x4        // Position of AMHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMHWCLR_Msk  = 0x10       // Bit mask of AMHWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_AMHWCLR      = 0x10       // Bit AMHWCLR.
	ETHERNET_RXFILTERWOLCLEAR_APWCLR_Pos   = 0x5        // Position of APWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_APWCLR_Msk   = 0x20       // Bit mask of APWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_APWCLR       = 0x20       // Bit APWCLR.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Pos = 0x6        // Position of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Msk = 0x40       // Bit mask of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED     = 0x40       // Bit RESERVED.
	ETHERNET_RXFILTERWOLCLEAR_RFWCLR_Pos   = 0x7        // Position of RFWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_RFWCLR_Msk   = 0x80       // Bit mask of RFWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_RFWCLR       = 0x80       // Bit RFWCLR.
	ETHERNET_RXFILTERWOLCLEAR_MPWCLR_Pos   = 0x8        // Position of MPWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_MPWCLR_Msk   = 0x100      // Bit mask of MPWCLR field.
	ETHERNET_RXFILTERWOLCLEAR_MPWCLR       = 0x100      // Bit MPWCLR.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Pos = 0x9        // Position of RESERVED field.
	ETHERNET_RXFILTERWOLCLEAR_RESERVED_Msk = 0xfffffe00 // Bit mask of RESERVED field.

	// HASHFILTERL: Hash filter table LSBs register.
	ETHERNET_HASHFILTERL_HFL_Pos = 0x0        // Position of HFL field.
	ETHERNET_HASHFILTERL_HFL_Msk = 0xffffffff // Bit mask of HFL field.

	// HASHFILTERH: Hash filter table MSBs register.
	ETHERNET_HASHFILTERH_HFH_Pos = 0x0        // Position of HFH field.
	ETHERNET_HASHFILTERH_HFH_Msk = 0xffffffff // Bit mask of HFH field.

	// INTSTATUS: Interrupt status register.
	ETHERNET_INTSTATUS_RXOVERRUNINT_Pos  = 0x0        // Position of RXOVERRUNINT field.
	ETHERNET_INTSTATUS_RXOVERRUNINT_Msk  = 0x1        // Bit mask of RXOVERRUNINT field.
	ETHERNET_INTSTATUS_RXOVERRUNINT      = 0x1        // Bit RXOVERRUNINT.
	ETHERNET_INTSTATUS_RXERRORINT_Pos    = 0x1        // Position of RXERRORINT field.
	ETHERNET_INTSTATUS_RXERRORINT_Msk    = 0x2        // Bit mask of RXERRORINT field.
	ETHERNET_INTSTATUS_RXERRORINT        = 0x2        // Bit RXERRORINT.
	ETHERNET_INTSTATUS_RXFINISHEDINT_Pos = 0x2        // Position of RXFINISHEDINT field.
	ETHERNET_INTSTATUS_RXFINISHEDINT_Msk = 0x4        // Bit mask of RXFINISHEDINT field.
	ETHERNET_INTSTATUS_RXFINISHEDINT     = 0x4        // Bit RXFINISHEDINT.
	ETHERNET_INTSTATUS_RXDONEINT_Pos     = 0x3        // Position of RXDONEINT field.
	ETHERNET_INTSTATUS_RXDONEINT_Msk     = 0x8        // Bit mask of RXDONEINT field.
	ETHERNET_INTSTATUS_RXDONEINT         = 0x8        // Bit RXDONEINT.
	ETHERNET_INTSTATUS_TXUNDERRUNINT_Pos = 0x4        // Position of TXUNDERRUNINT field.
	ETHERNET_INTSTATUS_TXUNDERRUNINT_Msk = 0x10       // Bit mask of TXUNDERRUNINT field.
	ETHERNET_INTSTATUS_TXUNDERRUNINT     = 0x10       // Bit TXUNDERRUNINT.
	ETHERNET_INTSTATUS_TXERRORINT_Pos    = 0x5        // Position of TXERRORINT field.
	ETHERNET_INTSTATUS_TXERRORINT_Msk    = 0x20       // Bit mask of TXERRORINT field.
	ETHERNET_INTSTATUS_TXERRORINT        = 0x20       // Bit TXERRORINT.
	ETHERNET_INTSTATUS_TXFINISHEDINT_Pos = 0x6        // Position of TXFINISHEDINT field.
	ETHERNET_INTSTATUS_TXFINISHEDINT_Msk = 0x40       // Bit mask of TXFINISHEDINT field.
	ETHERNET_INTSTATUS_TXFINISHEDINT     = 0x40       // Bit TXFINISHEDINT.
	ETHERNET_INTSTATUS_TXDONEINT_Pos     = 0x7        // Position of TXDONEINT field.
	ETHERNET_INTSTATUS_TXDONEINT_Msk     = 0x80       // Bit mask of TXDONEINT field.
	ETHERNET_INTSTATUS_TXDONEINT         = 0x80       // Bit TXDONEINT.
	ETHERNET_INTSTATUS_RESERVED_Pos      = 0x8        // Position of RESERVED field.
	ETHERNET_INTSTATUS_RESERVED_Msk      = 0xf00      // Bit mask of RESERVED field.
	ETHERNET_INTSTATUS_SOFTINT_Pos       = 0xc        // Position of SOFTINT field.
	ETHERNET_INTSTATUS_SOFTINT_Msk       = 0x1000     // Bit mask of SOFTINT field.
	ETHERNET_INTSTATUS_SOFTINT           = 0x1000     // Bit SOFTINT.
	ETHERNET_INTSTATUS_WAKEUPINT_Pos     = 0xd        // Position of WAKEUPINT field.
	ETHERNET_INTSTATUS_WAKEUPINT_Msk     = 0x2000     // Bit mask of WAKEUPINT field.
	ETHERNET_INTSTATUS_WAKEUPINT         = 0x2000     // Bit WAKEUPINT.
	ETHERNET_INTSTATUS_RESERVED_Pos      = 0xe        // Position of RESERVED field.
	ETHERNET_INTSTATUS_RESERVED_Msk      = 0xffffc000 // Bit mask of RESERVED field.

	// INTENABLE: Interrupt enable register.
	ETHERNET_INTENABLE_RXOVERRUNINTEN_Pos  = 0x0        // Position of RXOVERRUNINTEN field.
	ETHERNET_INTENABLE_RXOVERRUNINTEN_Msk  = 0x1        // Bit mask of RXOVERRUNINTEN field.
	ETHERNET_INTENABLE_RXOVERRUNINTEN      = 0x1        // Bit RXOVERRUNINTEN.
	ETHERNET_INTENABLE_RXERRORINTEN_Pos    = 0x1        // Position of RXERRORINTEN field.
	ETHERNET_INTENABLE_RXERRORINTEN_Msk    = 0x2        // Bit mask of RXERRORINTEN field.
	ETHERNET_INTENABLE_RXERRORINTEN        = 0x2        // Bit RXERRORINTEN.
	ETHERNET_INTENABLE_RXFINISHEDINTEN_Pos = 0x2        // Position of RXFINISHEDINTEN field.
	ETHERNET_INTENABLE_RXFINISHEDINTEN_Msk = 0x4        // Bit mask of RXFINISHEDINTEN field.
	ETHERNET_INTENABLE_RXFINISHEDINTEN     = 0x4        // Bit RXFINISHEDINTEN.
	ETHERNET_INTENABLE_RXDONEINTEN_Pos     = 0x3        // Position of RXDONEINTEN field.
	ETHERNET_INTENABLE_RXDONEINTEN_Msk     = 0x8        // Bit mask of RXDONEINTEN field.
	ETHERNET_INTENABLE_RXDONEINTEN         = 0x8        // Bit RXDONEINTEN.
	ETHERNET_INTENABLE_TXUNDERRUNINTEN_Pos = 0x4        // Position of TXUNDERRUNINTEN field.
	ETHERNET_INTENABLE_TXUNDERRUNINTEN_Msk = 0x10       // Bit mask of TXUNDERRUNINTEN field.
	ETHERNET_INTENABLE_TXUNDERRUNINTEN     = 0x10       // Bit TXUNDERRUNINTEN.
	ETHERNET_INTENABLE_TXERRORINTEN_Pos    = 0x5        // Position of TXERRORINTEN field.
	ETHERNET_INTENABLE_TXERRORINTEN_Msk    = 0x20       // Bit mask of TXERRORINTEN field.
	ETHERNET_INTENABLE_TXERRORINTEN        = 0x20       // Bit TXERRORINTEN.
	ETHERNET_INTENABLE_TXFINISHEDINTEN_Pos = 0x6        // Position of TXFINISHEDINTEN field.
	ETHERNET_INTENABLE_TXFINISHEDINTEN_Msk = 0x40       // Bit mask of TXFINISHEDINTEN field.
	ETHERNET_INTENABLE_TXFINISHEDINTEN     = 0x40       // Bit TXFINISHEDINTEN.
	ETHERNET_INTENABLE_TXDONEINTEN_Pos     = 0x7        // Position of TXDONEINTEN field.
	ETHERNET_INTENABLE_TXDONEINTEN_Msk     = 0x80       // Bit mask of TXDONEINTEN field.
	ETHERNET_INTENABLE_TXDONEINTEN         = 0x80       // Bit TXDONEINTEN.
	ETHERNET_INTENABLE_RESERVED_Pos        = 0x8        // Position of RESERVED field.
	ETHERNET_INTENABLE_RESERVED_Msk        = 0xf00      // Bit mask of RESERVED field.
	ETHERNET_INTENABLE_SOFTINTEN_Pos       = 0xc        // Position of SOFTINTEN field.
	ETHERNET_INTENABLE_SOFTINTEN_Msk       = 0x1000     // Bit mask of SOFTINTEN field.
	ETHERNET_INTENABLE_SOFTINTEN           = 0x1000     // Bit SOFTINTEN.
	ETHERNET_INTENABLE_WAKEUPINTEN_Pos     = 0xd        // Position of WAKEUPINTEN field.
	ETHERNET_INTENABLE_WAKEUPINTEN_Msk     = 0x2000     // Bit mask of WAKEUPINTEN field.
	ETHERNET_INTENABLE_WAKEUPINTEN         = 0x2000     // Bit WAKEUPINTEN.
	ETHERNET_INTENABLE_RESERVED_Pos        = 0xe        // Position of RESERVED field.
	ETHERNET_INTENABLE_RESERVED_Msk        = 0xffffc000 // Bit mask of RESERVED field.

	// INTCLEAR: Interrupt clear register.
	ETHERNET_INTCLEAR_RXOVERRUNINTCLR_Pos  = 0x0        // Position of RXOVERRUNINTCLR field.
	ETHERNET_INTCLEAR_RXOVERRUNINTCLR_Msk  = 0x1        // Bit mask of RXOVERRUNINTCLR field.
	ETHERNET_INTCLEAR_RXOVERRUNINTCLR      = 0x1        // Bit RXOVERRUNINTCLR.
	ETHERNET_INTCLEAR_RXERRORINTCLR_Pos    = 0x1        // Position of RXERRORINTCLR field.
	ETHERNET_INTCLEAR_RXERRORINTCLR_Msk    = 0x2        // Bit mask of RXERRORINTCLR field.
	ETHERNET_INTCLEAR_RXERRORINTCLR        = 0x2        // Bit RXERRORINTCLR.
	ETHERNET_INTCLEAR_RXFINISHEDINTCLR_Pos = 0x2        // Position of RXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_RXFINISHEDINTCLR_Msk = 0x4        // Bit mask of RXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_RXFINISHEDINTCLR     = 0x4        // Bit RXFINISHEDINTCLR.
	ETHERNET_INTCLEAR_RXDONEINTCLR_Pos     = 0x3        // Position of RXDONEINTCLR field.
	ETHERNET_INTCLEAR_RXDONEINTCLR_Msk     = 0x8        // Bit mask of RXDONEINTCLR field.
	ETHERNET_INTCLEAR_RXDONEINTCLR         = 0x8        // Bit RXDONEINTCLR.
	ETHERNET_INTCLEAR_TXUNDERRUNINTCLR_Pos = 0x4        // Position of TXUNDERRUNINTCLR field.
	ETHERNET_INTCLEAR_TXUNDERRUNINTCLR_Msk = 0x10       // Bit mask of TXUNDERRUNINTCLR field.
	ETHERNET_INTCLEAR_TXUNDERRUNINTCLR     = 0x10       // Bit TXUNDERRUNINTCLR.
	ETHERNET_INTCLEAR_TXERRORINTCLR_Pos    = 0x5        // Position of TXERRORINTCLR field.
	ETHERNET_INTCLEAR_TXERRORINTCLR_Msk    = 0x20       // Bit mask of TXERRORINTCLR field.
	ETHERNET_INTCLEAR_TXERRORINTCLR        = 0x20       // Bit TXERRORINTCLR.
	ETHERNET_INTCLEAR_TXFINISHEDINTCLR_Pos = 0x6        // Position of TXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_TXFINISHEDINTCLR_Msk = 0x40       // Bit mask of TXFINISHEDINTCLR field.
	ETHERNET_INTCLEAR_TXFINISHEDINTCLR     = 0x40       // Bit TXFINISHEDINTCLR.
	ETHERNET_INTCLEAR_TXDONEINTCLR_Pos     = 0x7        // Position of TXDONEINTCLR field.
	ETHERNET_INTCLEAR_TXDONEINTCLR_Msk     = 0x80       // Bit mask of TXDONEINTCLR field.
	ETHERNET_INTCLEAR_TXDONEINTCLR         = 0x80       // Bit TXDONEINTCLR.
	ETHERNET_INTCLEAR_RESERVED_Pos         = 0x8        // Position of RESERVED field.
	ETHERNET_INTCLEAR_RESERVED_Msk         = 0xf00      // Bit mask of RESERVED field.
	ETHERNET_INTCLEAR_SOFTINTCLR_Pos       = 0xc        // Position of SOFTINTCLR field.
	ETHERNET_INTCLEAR_SOFTINTCLR_Msk       = 0x1000     // Bit mask of SOFTINTCLR field.
	ETHERNET_INTCLEAR_SOFTINTCLR           = 0x1000     // Bit SOFTINTCLR.
	ETHERNET_INTCLEAR_WAKEUPINTCLR_Pos     = 0xd        // Position of WAKEUPINTCLR field.
	ETHERNET_INTCLEAR_WAKEUPINTCLR_Msk     = 0x2000     // Bit mask of WAKEUPINTCLR field.
	ETHERNET_INTCLEAR_WAKEUPINTCLR         = 0x2000     // Bit WAKEUPINTCLR.
	ETHERNET_INTCLEAR_RESERVED_Pos         = 0xe        // Position of RESERVED field.
	ETHERNET_INTCLEAR_RESERVED_Msk         = 0xffffc000 // Bit mask of RESERVED field.

	// INTSET: Interrupt set register.
	ETHERNET_INTSET_RXOVERRUNINTSET_Pos  = 0x0        // Position of RXOVERRUNINTSET field.
	ETHERNET_INTSET_RXOVERRUNINTSET_Msk  = 0x1        // Bit mask of RXOVERRUNINTSET field.
	ETHERNET_INTSET_RXOVERRUNINTSET      = 0x1        // Bit RXOVERRUNINTSET.
	ETHERNET_INTSET_RXERRORINTSET_Pos    = 0x1        // Position of RXERRORINTSET field.
	ETHERNET_INTSET_RXERRORINTSET_Msk    = 0x2        // Bit mask of RXERRORINTSET field.
	ETHERNET_INTSET_RXERRORINTSET        = 0x2        // Bit RXERRORINTSET.
	ETHERNET_INTSET_RXFINISHEDINTSET_Pos = 0x2        // Position of RXFINISHEDINTSET field.
	ETHERNET_INTSET_RXFINISHEDINTSET_Msk = 0x4        // Bit mask of RXFINISHEDINTSET field.
	ETHERNET_INTSET_RXFINISHEDINTSET     = 0x4        // Bit RXFINISHEDINTSET.
	ETHERNET_INTSET_RXDONEINTSET_Pos     = 0x3        // Position of RXDONEINTSET field.
	ETHERNET_INTSET_RXDONEINTSET_Msk     = 0x8        // Bit mask of RXDONEINTSET field.
	ETHERNET_INTSET_RXDONEINTSET         = 0x8        // Bit RXDONEINTSET.
	ETHERNET_INTSET_TXUNDERRUNINTSET_Pos = 0x4        // Position of TXUNDERRUNINTSET field.
	ETHERNET_INTSET_TXUNDERRUNINTSET_Msk = 0x10       // Bit mask of TXUNDERRUNINTSET field.
	ETHERNET_INTSET_TXUNDERRUNINTSET     = 0x10       // Bit TXUNDERRUNINTSET.
	ETHERNET_INTSET_TXERRORINTSET_Pos    = 0x5        // Position of TXERRORINTSET field.
	ETHERNET_INTSET_TXERRORINTSET_Msk    = 0x20       // Bit mask of TXERRORINTSET field.
	ETHERNET_INTSET_TXERRORINTSET        = 0x20       // Bit TXERRORINTSET.
	ETHERNET_INTSET_TXFINISHEDINTSET_Pos = 0x6        // Position of TXFINISHEDINTSET field.
	ETHERNET_INTSET_TXFINISHEDINTSET_Msk = 0x40       // Bit mask of TXFINISHEDINTSET field.
	ETHERNET_INTSET_TXFINISHEDINTSET     = 0x40       // Bit TXFINISHEDINTSET.
	ETHERNET_INTSET_TXDONEINTSET_Pos     = 0x7        // Position of TXDONEINTSET field.
	ETHERNET_INTSET_TXDONEINTSET_Msk     = 0x80       // Bit mask of TXDONEINTSET field.
	ETHERNET_INTSET_TXDONEINTSET         = 0x80       // Bit TXDONEINTSET.
	ETHERNET_INTSET_RESERVED_Pos         = 0x8        // Position of RESERVED field.
	ETHERNET_INTSET_RESERVED_Msk         = 0xf00      // Bit mask of RESERVED field.
	ETHERNET_INTSET_SOFTINTSET_Pos       = 0xc        // Position of SOFTINTSET field.
	ETHERNET_INTSET_SOFTINTSET_Msk       = 0x1000     // Bit mask of SOFTINTSET field.
	ETHERNET_INTSET_SOFTINTSET           = 0x1000     // Bit SOFTINTSET.
	ETHERNET_INTSET_WAKEUPINTSET_Pos     = 0xd        // Position of WAKEUPINTSET field.
	ETHERNET_INTSET_WAKEUPINTSET_Msk     = 0x2000     // Bit mask of WAKEUPINTSET field.
	ETHERNET_INTSET_WAKEUPINTSET         = 0x2000     // Bit WAKEUPINTSET.
	ETHERNET_INTSET_RESERVED_Pos         = 0xe        // Position of RESERVED field.
	ETHERNET_INTSET_RESERVED_Msk         = 0xffffc000 // Bit mask of RESERVED field.

	// POWERDOWN: Power-down register.
	ETHERNET_POWERDOWN_RESERVED_Pos = 0x0        // Position of RESERVED field.
	ETHERNET_POWERDOWN_RESERVED_Msk = 0x7fffffff // Bit mask of RESERVED field.
	ETHERNET_POWERDOWN_PD_Pos       = 0x1f       // Position of PD field.
	ETHERNET_POWERDOWN_PD_Msk       = 0x80000000 // Bit mask of PD field.
	ETHERNET_POWERDOWN_PD           = 0x80000000 // Bit PD.
)

// Bitfields for GPDMA: General purpose DMA controller
const (
	// INTSTAT: DMA Interrupt Status Register
	GPDMA_INTSTAT_INTSTAT0_Pos = 0x0        // Position of INTSTAT0 field.
	GPDMA_INTSTAT_INTSTAT0_Msk = 0x1        // Bit mask of INTSTAT0 field.
	GPDMA_INTSTAT_INTSTAT0     = 0x1        // Bit INTSTAT0.
	GPDMA_INTSTAT_INTSTAT1_Pos = 0x1        // Position of INTSTAT1 field.
	GPDMA_INTSTAT_INTSTAT1_Msk = 0x2        // Bit mask of INTSTAT1 field.
	GPDMA_INTSTAT_INTSTAT1     = 0x2        // Bit INTSTAT1.
	GPDMA_INTSTAT_INTSTAT2_Pos = 0x2        // Position of INTSTAT2 field.
	GPDMA_INTSTAT_INTSTAT2_Msk = 0x4        // Bit mask of INTSTAT2 field.
	GPDMA_INTSTAT_INTSTAT2     = 0x4        // Bit INTSTAT2.
	GPDMA_INTSTAT_INTSTAT3_Pos = 0x3        // Position of INTSTAT3 field.
	GPDMA_INTSTAT_INTSTAT3_Msk = 0x8        // Bit mask of INTSTAT3 field.
	GPDMA_INTSTAT_INTSTAT3     = 0x8        // Bit INTSTAT3.
	GPDMA_INTSTAT_INTSTAT4_Pos = 0x4        // Position of INTSTAT4 field.
	GPDMA_INTSTAT_INTSTAT4_Msk = 0x10       // Bit mask of INTSTAT4 field.
	GPDMA_INTSTAT_INTSTAT4     = 0x10       // Bit INTSTAT4.
	GPDMA_INTSTAT_INTSTAT5_Pos = 0x5        // Position of INTSTAT5 field.
	GPDMA_INTSTAT_INTSTAT5_Msk = 0x20       // Bit mask of INTSTAT5 field.
	GPDMA_INTSTAT_INTSTAT5     = 0x20       // Bit INTSTAT5.
	GPDMA_INTSTAT_INTSTAT6_Pos = 0x6        // Position of INTSTAT6 field.
	GPDMA_INTSTAT_INTSTAT6_Msk = 0x40       // Bit mask of INTSTAT6 field.
	GPDMA_INTSTAT_INTSTAT6     = 0x40       // Bit INTSTAT6.
	GPDMA_INTSTAT_INTSTAT7_Pos = 0x7        // Position of INTSTAT7 field.
	GPDMA_INTSTAT_INTSTAT7_Msk = 0x80       // Bit mask of INTSTAT7 field.
	GPDMA_INTSTAT_INTSTAT7     = 0x80       // Bit INTSTAT7.
	GPDMA_INTSTAT_RESERVED_Pos = 0x8        // Position of RESERVED field.
	GPDMA_INTSTAT_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// INTTCSTAT: DMA Interrupt Terminal Count Request Status Register
	GPDMA_INTTCSTAT_INTTCSTAT0_Pos = 0x0        // Position of INTTCSTAT0 field.
	GPDMA_INTTCSTAT_INTTCSTAT0_Msk = 0x1        // Bit mask of INTTCSTAT0 field.
	GPDMA_INTTCSTAT_INTTCSTAT0     = 0x1        // Bit INTTCSTAT0.
	GPDMA_INTTCSTAT_INTTCSTAT1_Pos = 0x1        // Position of INTTCSTAT1 field.
	GPDMA_INTTCSTAT_INTTCSTAT1_Msk = 0x2        // Bit mask of INTTCSTAT1 field.
	GPDMA_INTTCSTAT_INTTCSTAT1     = 0x2        // Bit INTTCSTAT1.
	GPDMA_INTTCSTAT_INTTCSTAT2_Pos = 0x2        // Position of INTTCSTAT2 field.
	GPDMA_INTTCSTAT_INTTCSTAT2_Msk = 0x4        // Bit mask of INTTCSTAT2 field.
	GPDMA_INTTCSTAT_INTTCSTAT2     = 0x4        // Bit INTTCSTAT2.
	GPDMA_INTTCSTAT_INTTCSTAT3_Pos = 0x3        // Position of INTTCSTAT3 field.
	GPDMA_INTTCSTAT_INTTCSTAT3_Msk = 0x8        // Bit mask of INTTCSTAT3 field.
	GPDMA_INTTCSTAT_INTTCSTAT3     = 0x8        // Bit INTTCSTAT3.
	GPDMA_INTTCSTAT_INTTCSTAT4_Pos = 0x4        // Position of INTTCSTAT4 field.
	GPDMA_INTTCSTAT_INTTCSTAT4_Msk = 0x10       // Bit mask of INTTCSTAT4 field.
	GPDMA_INTTCSTAT_INTTCSTAT4     = 0x10       // Bit INTTCSTAT4.
	GPDMA_INTTCSTAT_INTTCSTAT5_Pos = 0x5        // Position of INTTCSTAT5 field.
	GPDMA_INTTCSTAT_INTTCSTAT5_Msk = 0x20       // Bit mask of INTTCSTAT5 field.
	GPDMA_INTTCSTAT_INTTCSTAT5     = 0x20       // Bit INTTCSTAT5.
	GPDMA_INTTCSTAT_INTTCSTAT6_Pos = 0x6        // Position of INTTCSTAT6 field.
	GPDMA_INTTCSTAT_INTTCSTAT6_Msk = 0x40       // Bit mask of INTTCSTAT6 field.
	GPDMA_INTTCSTAT_INTTCSTAT6     = 0x40       // Bit INTTCSTAT6.
	GPDMA_INTTCSTAT_INTTCSTAT7_Pos = 0x7        // Position of INTTCSTAT7 field.
	GPDMA_INTTCSTAT_INTTCSTAT7_Msk = 0x80       // Bit mask of INTTCSTAT7 field.
	GPDMA_INTTCSTAT_INTTCSTAT7     = 0x80       // Bit INTTCSTAT7.
	GPDMA_INTTCSTAT_RESERVED_Pos   = 0x8        // Position of RESERVED field.
	GPDMA_INTTCSTAT_RESERVED_Msk   = 0xffffff00 // Bit mask of RESERVED field.

	// INTTCCLEAR: DMA Interrupt Terminal Count Request Clear Register
	GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos = 0x0        // Position of INTTCCLEAR0 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR0_Msk = 0x1        // Bit mask of INTTCCLEAR0 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR0     = 0x1        // Bit INTTCCLEAR0.
	GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos = 0x1        // Position of INTTCCLEAR1 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR1_Msk = 0x2        // Bit mask of INTTCCLEAR1 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR1     = 0x2        // Bit INTTCCLEAR1.
	GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos = 0x2        // Position of INTTCCLEAR2 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR2_Msk = 0x4        // Bit mask of INTTCCLEAR2 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR2     = 0x4        // Bit INTTCCLEAR2.
	GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos = 0x3        // Position of INTTCCLEAR3 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR3_Msk = 0x8        // Bit mask of INTTCCLEAR3 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR3     = 0x8        // Bit INTTCCLEAR3.
	GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos = 0x4        // Position of INTTCCLEAR4 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR4_Msk = 0x10       // Bit mask of INTTCCLEAR4 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR4     = 0x10       // Bit INTTCCLEAR4.
	GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos = 0x5        // Position of INTTCCLEAR5 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR5_Msk = 0x20       // Bit mask of INTTCCLEAR5 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR5     = 0x20       // Bit INTTCCLEAR5.
	GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos = 0x6        // Position of INTTCCLEAR6 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR6_Msk = 0x40       // Bit mask of INTTCCLEAR6 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR6     = 0x40       // Bit INTTCCLEAR6.
	GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos = 0x7        // Position of INTTCCLEAR7 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR7_Msk = 0x80       // Bit mask of INTTCCLEAR7 field.
	GPDMA_INTTCCLEAR_INTTCCLEAR7     = 0x80       // Bit INTTCCLEAR7.
	GPDMA_INTTCCLEAR_RESERVED_Pos    = 0x8        // Position of RESERVED field.
	GPDMA_INTTCCLEAR_RESERVED_Msk    = 0xffffff00 // Bit mask of RESERVED field.

	// INTERRSTAT: DMA Interrupt Error Status Register
	GPDMA_INTERRSTAT_INTERRSTAT0_Pos = 0x0        // Position of INTERRSTAT0 field.
	GPDMA_INTERRSTAT_INTERRSTAT0_Msk = 0x1        // Bit mask of INTERRSTAT0 field.
	GPDMA_INTERRSTAT_INTERRSTAT0     = 0x1        // Bit INTERRSTAT0.
	GPDMA_INTERRSTAT_INTERRSTAT1_Pos = 0x1        // Position of INTERRSTAT1 field.
	GPDMA_INTERRSTAT_INTERRSTAT1_Msk = 0x2        // Bit mask of INTERRSTAT1 field.
	GPDMA_INTERRSTAT_INTERRSTAT1     = 0x2        // Bit INTERRSTAT1.
	GPDMA_INTERRSTAT_INTERRSTAT2_Pos = 0x2        // Position of INTERRSTAT2 field.
	GPDMA_INTERRSTAT_INTERRSTAT2_Msk = 0x4        // Bit mask of INTERRSTAT2 field.
	GPDMA_INTERRSTAT_INTERRSTAT2     = 0x4        // Bit INTERRSTAT2.
	GPDMA_INTERRSTAT_INTERRSTAT3_Pos = 0x3        // Position of INTERRSTAT3 field.
	GPDMA_INTERRSTAT_INTERRSTAT3_Msk = 0x8        // Bit mask of INTERRSTAT3 field.
	GPDMA_INTERRSTAT_INTERRSTAT3     = 0x8        // Bit INTERRSTAT3.
	GPDMA_INTERRSTAT_INTERRSTAT4_Pos = 0x4        // Position of INTERRSTAT4 field.
	GPDMA_INTERRSTAT_INTERRSTAT4_Msk = 0x10       // Bit mask of INTERRSTAT4 field.
	GPDMA_INTERRSTAT_INTERRSTAT4     = 0x10       // Bit INTERRSTAT4.
	GPDMA_INTERRSTAT_INTERRSTAT5_Pos = 0x5        // Position of INTERRSTAT5 field.
	GPDMA_INTERRSTAT_INTERRSTAT5_Msk = 0x20       // Bit mask of INTERRSTAT5 field.
	GPDMA_INTERRSTAT_INTERRSTAT5     = 0x20       // Bit INTERRSTAT5.
	GPDMA_INTERRSTAT_INTERRSTAT6_Pos = 0x6        // Position of INTERRSTAT6 field.
	GPDMA_INTERRSTAT_INTERRSTAT6_Msk = 0x40       // Bit mask of INTERRSTAT6 field.
	GPDMA_INTERRSTAT_INTERRSTAT6     = 0x40       // Bit INTERRSTAT6.
	GPDMA_INTERRSTAT_INTERRSTAT7_Pos = 0x7        // Position of INTERRSTAT7 field.
	GPDMA_INTERRSTAT_INTERRSTAT7_Msk = 0x80       // Bit mask of INTERRSTAT7 field.
	GPDMA_INTERRSTAT_INTERRSTAT7     = 0x80       // Bit INTERRSTAT7.
	GPDMA_INTERRSTAT_RESERVED_Pos    = 0x8        // Position of RESERVED field.
	GPDMA_INTERRSTAT_RESERVED_Msk    = 0xffffff00 // Bit mask of RESERVED field.

	// INTERRCLR: DMA Interrupt Error Clear Register
	GPDMA_INTERRCLR_INTERRCLR0_Pos = 0x0        // Position of INTERRCLR0 field.
	GPDMA_INTERRCLR_INTERRCLR0_Msk = 0x1        // Bit mask of INTERRCLR0 field.
	GPDMA_INTERRCLR_INTERRCLR0     = 0x1        // Bit INTERRCLR0.
	GPDMA_INTERRCLR_INTERRCLR1_Pos = 0x1        // Position of INTERRCLR1 field.
	GPDMA_INTERRCLR_INTERRCLR1_Msk = 0x2        // Bit mask of INTERRCLR1 field.
	GPDMA_INTERRCLR_INTERRCLR1     = 0x2        // Bit INTERRCLR1.
	GPDMA_INTERRCLR_INTERRCLR2_Pos = 0x2        // Position of INTERRCLR2 field.
	GPDMA_INTERRCLR_INTERRCLR2_Msk = 0x4        // Bit mask of INTERRCLR2 field.
	GPDMA_INTERRCLR_INTERRCLR2     = 0x4        // Bit INTERRCLR2.
	GPDMA_INTERRCLR_INTERRCLR3_Pos = 0x3        // Position of INTERRCLR3 field.
	GPDMA_INTERRCLR_INTERRCLR3_Msk = 0x8        // Bit mask of INTERRCLR3 field.
	GPDMA_INTERRCLR_INTERRCLR3     = 0x8        // Bit INTERRCLR3.
	GPDMA_INTERRCLR_INTERRCLR4_Pos = 0x4        // Position of INTERRCLR4 field.
	GPDMA_INTERRCLR_INTERRCLR4_Msk = 0x10       // Bit mask of INTERRCLR4 field.
	GPDMA_INTERRCLR_INTERRCLR4     = 0x10       // Bit INTERRCLR4.
	GPDMA_INTERRCLR_INTERRCLR5_Pos = 0x5        // Position of INTERRCLR5 field.
	GPDMA_INTERRCLR_INTERRCLR5_Msk = 0x20       // Bit mask of INTERRCLR5 field.
	GPDMA_INTERRCLR_INTERRCLR5     = 0x20       // Bit INTERRCLR5.
	GPDMA_INTERRCLR_INTERRCLR6_Pos = 0x6        // Position of INTERRCLR6 field.
	GPDMA_INTERRCLR_INTERRCLR6_Msk = 0x40       // Bit mask of INTERRCLR6 field.
	GPDMA_INTERRCLR_INTERRCLR6     = 0x40       // Bit INTERRCLR6.
	GPDMA_INTERRCLR_INTERRCLR7_Pos = 0x7        // Position of INTERRCLR7 field.
	GPDMA_INTERRCLR_INTERRCLR7_Msk = 0x80       // Bit mask of INTERRCLR7 field.
	GPDMA_INTERRCLR_INTERRCLR7     = 0x80       // Bit INTERRCLR7.
	GPDMA_INTERRCLR_RESERVED_Pos   = 0x8        // Position of RESERVED field.
	GPDMA_INTERRCLR_RESERVED_Msk   = 0xffffff00 // Bit mask of RESERVED field.

	// RAWINTTCSTAT: DMA Raw Interrupt Terminal Count Status Register
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos = 0x0        // Position of RAWINTTCSTAT0 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Msk = 0x1        // Bit mask of RAWINTTCSTAT0 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0     = 0x1        // Bit RAWINTTCSTAT0.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos = 0x1        // Position of RAWINTTCSTAT1 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Msk = 0x2        // Bit mask of RAWINTTCSTAT1 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1     = 0x2        // Bit RAWINTTCSTAT1.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos = 0x2        // Position of RAWINTTCSTAT2 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Msk = 0x4        // Bit mask of RAWINTTCSTAT2 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2     = 0x4        // Bit RAWINTTCSTAT2.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos = 0x3        // Position of RAWINTTCSTAT3 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Msk = 0x8        // Bit mask of RAWINTTCSTAT3 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3     = 0x8        // Bit RAWINTTCSTAT3.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos = 0x4        // Position of RAWINTTCSTAT4 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Msk = 0x10       // Bit mask of RAWINTTCSTAT4 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4     = 0x10       // Bit RAWINTTCSTAT4.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos = 0x5        // Position of RAWINTTCSTAT5 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Msk = 0x20       // Bit mask of RAWINTTCSTAT5 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5     = 0x20       // Bit RAWINTTCSTAT5.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos = 0x6        // Position of RAWINTTCSTAT6 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Msk = 0x40       // Bit mask of RAWINTTCSTAT6 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6     = 0x40       // Bit RAWINTTCSTAT6.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos = 0x7        // Position of RAWINTTCSTAT7 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Msk = 0x80       // Bit mask of RAWINTTCSTAT7 field.
	GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7     = 0x80       // Bit RAWINTTCSTAT7.
	GPDMA_RAWINTTCSTAT_RESERVED_Pos      = 0x8        // Position of RESERVED field.
	GPDMA_RAWINTTCSTAT_RESERVED_Msk      = 0xffffff00 // Bit mask of RESERVED field.

	// RAWINTERRSTAT: DMA Raw Error Interrupt Status Register
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos = 0x0        // Position of RAWINTERRSTAT0 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Msk = 0x1        // Bit mask of RAWINTERRSTAT0 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0     = 0x1        // Bit RAWINTERRSTAT0.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos = 0x1        // Position of RAWINTERRSTAT1 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Msk = 0x2        // Bit mask of RAWINTERRSTAT1 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1     = 0x2        // Bit RAWINTERRSTAT1.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos = 0x2        // Position of RAWINTERRSTAT2 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Msk = 0x4        // Bit mask of RAWINTERRSTAT2 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2     = 0x4        // Bit RAWINTERRSTAT2.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos = 0x3        // Position of RAWINTERRSTAT3 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Msk = 0x8        // Bit mask of RAWINTERRSTAT3 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3     = 0x8        // Bit RAWINTERRSTAT3.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos = 0x4        // Position of RAWINTERRSTAT4 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Msk = 0x10       // Bit mask of RAWINTERRSTAT4 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4     = 0x10       // Bit RAWINTERRSTAT4.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos = 0x5        // Position of RAWINTERRSTAT5 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Msk = 0x20       // Bit mask of RAWINTERRSTAT5 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5     = 0x20       // Bit RAWINTERRSTAT5.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos = 0x6        // Position of RAWINTERRSTAT6 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Msk = 0x40       // Bit mask of RAWINTERRSTAT6 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6     = 0x40       // Bit RAWINTERRSTAT6.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos = 0x7        // Position of RAWINTERRSTAT7 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Msk = 0x80       // Bit mask of RAWINTERRSTAT7 field.
	GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7     = 0x80       // Bit RAWINTERRSTAT7.
	GPDMA_RAWINTERRSTAT_RESERVED_Pos       = 0x8        // Position of RESERVED field.
	GPDMA_RAWINTERRSTAT_RESERVED_Msk       = 0xffffff00 // Bit mask of RESERVED field.

	// ENBLDCHNS: DMA Enabled Channel Register
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos = 0x0        // Position of ENABLEDCHANNELS0 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Msk = 0x1        // Bit mask of ENABLEDCHANNELS0 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS0     = 0x1        // Bit ENABLEDCHANNELS0.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos = 0x1        // Position of ENABLEDCHANNELS1 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Msk = 0x2        // Bit mask of ENABLEDCHANNELS1 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS1     = 0x2        // Bit ENABLEDCHANNELS1.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos = 0x2        // Position of ENABLEDCHANNELS2 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Msk = 0x4        // Bit mask of ENABLEDCHANNELS2 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS2     = 0x4        // Bit ENABLEDCHANNELS2.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos = 0x3        // Position of ENABLEDCHANNELS3 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Msk = 0x8        // Bit mask of ENABLEDCHANNELS3 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS3     = 0x8        // Bit ENABLEDCHANNELS3.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos = 0x4        // Position of ENABLEDCHANNELS4 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Msk = 0x10       // Bit mask of ENABLEDCHANNELS4 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS4     = 0x10       // Bit ENABLEDCHANNELS4.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos = 0x5        // Position of ENABLEDCHANNELS5 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Msk = 0x20       // Bit mask of ENABLEDCHANNELS5 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS5     = 0x20       // Bit ENABLEDCHANNELS5.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos = 0x6        // Position of ENABLEDCHANNELS6 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Msk = 0x40       // Bit mask of ENABLEDCHANNELS6 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS6     = 0x40       // Bit ENABLEDCHANNELS6.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos = 0x7        // Position of ENABLEDCHANNELS7 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Msk = 0x80       // Bit mask of ENABLEDCHANNELS7 field.
	GPDMA_ENBLDCHNS_ENABLEDCHANNELS7     = 0x80       // Bit ENABLEDCHANNELS7.
	GPDMA_ENBLDCHNS_RESERVED_Pos         = 0x8        // Position of RESERVED field.
	GPDMA_ENBLDCHNS_RESERVED_Msk         = 0xffffff00 // Bit mask of RESERVED field.

	// SOFTBREQ: DMA Software Burst Request Register
	GPDMA_SOFTBREQ_SOFTBREQ0_Pos  = 0x0        // Position of SOFTBREQ0 field.
	GPDMA_SOFTBREQ_SOFTBREQ0_Msk  = 0x1        // Bit mask of SOFTBREQ0 field.
	GPDMA_SOFTBREQ_SOFTBREQ0      = 0x1        // Bit SOFTBREQ0.
	GPDMA_SOFTBREQ_SOFTBREQ1_Pos  = 0x1        // Position of SOFTBREQ1 field.
	GPDMA_SOFTBREQ_SOFTBREQ1_Msk  = 0x2        // Bit mask of SOFTBREQ1 field.
	GPDMA_SOFTBREQ_SOFTBREQ1      = 0x2        // Bit SOFTBREQ1.
	GPDMA_SOFTBREQ_SOFTBREQ2_Pos  = 0x2        // Position of SOFTBREQ2 field.
	GPDMA_SOFTBREQ_SOFTBREQ2_Msk  = 0x4        // Bit mask of SOFTBREQ2 field.
	GPDMA_SOFTBREQ_SOFTBREQ2      = 0x4        // Bit SOFTBREQ2.
	GPDMA_SOFTBREQ_SOFTBREQ3_Pos  = 0x3        // Position of SOFTBREQ3 field.
	GPDMA_SOFTBREQ_SOFTBREQ3_Msk  = 0x8        // Bit mask of SOFTBREQ3 field.
	GPDMA_SOFTBREQ_SOFTBREQ3      = 0x8        // Bit SOFTBREQ3.
	GPDMA_SOFTBREQ_SOFTBREQ4_Pos  = 0x4        // Position of SOFTBREQ4 field.
	GPDMA_SOFTBREQ_SOFTBREQ4_Msk  = 0x10       // Bit mask of SOFTBREQ4 field.
	GPDMA_SOFTBREQ_SOFTBREQ4      = 0x10       // Bit SOFTBREQ4.
	GPDMA_SOFTBREQ_SOFTBREQ5_Pos  = 0x5        // Position of SOFTBREQ5 field.
	GPDMA_SOFTBREQ_SOFTBREQ5_Msk  = 0x20       // Bit mask of SOFTBREQ5 field.
	GPDMA_SOFTBREQ_SOFTBREQ5      = 0x20       // Bit SOFTBREQ5.
	GPDMA_SOFTBREQ_SOFTBREQ6_Pos  = 0x6        // Position of SOFTBREQ6 field.
	GPDMA_SOFTBREQ_SOFTBREQ6_Msk  = 0x40       // Bit mask of SOFTBREQ6 field.
	GPDMA_SOFTBREQ_SOFTBREQ6      = 0x40       // Bit SOFTBREQ6.
	GPDMA_SOFTBREQ_SOFTBREQ7_Pos  = 0x7        // Position of SOFTBREQ7 field.
	GPDMA_SOFTBREQ_SOFTBREQ7_Msk  = 0x80       // Bit mask of SOFTBREQ7 field.
	GPDMA_SOFTBREQ_SOFTBREQ7      = 0x80       // Bit SOFTBREQ7.
	GPDMA_SOFTBREQ_SOFTBREQ8_Pos  = 0x8        // Position of SOFTBREQ8 field.
	GPDMA_SOFTBREQ_SOFTBREQ8_Msk  = 0x100      // Bit mask of SOFTBREQ8 field.
	GPDMA_SOFTBREQ_SOFTBREQ8      = 0x100      // Bit SOFTBREQ8.
	GPDMA_SOFTBREQ_SOFTBREQ9_Pos  = 0x9        // Position of SOFTBREQ9 field.
	GPDMA_SOFTBREQ_SOFTBREQ9_Msk  = 0x200      // Bit mask of SOFTBREQ9 field.
	GPDMA_SOFTBREQ_SOFTBREQ9      = 0x200      // Bit SOFTBREQ9.
	GPDMA_SOFTBREQ_SOFTBREQ10_Pos = 0xa        // Position of SOFTBREQ10 field.
	GPDMA_SOFTBREQ_SOFTBREQ10_Msk = 0x400      // Bit mask of SOFTBREQ10 field.
	GPDMA_SOFTBREQ_SOFTBREQ10     = 0x400      // Bit SOFTBREQ10.
	GPDMA_SOFTBREQ_SOFTBREQ11_Pos = 0xb        // Position of SOFTBREQ11 field.
	GPDMA_SOFTBREQ_SOFTBREQ11_Msk = 0x800      // Bit mask of SOFTBREQ11 field.
	GPDMA_SOFTBREQ_SOFTBREQ11     = 0x800      // Bit SOFTBREQ11.
	GPDMA_SOFTBREQ_SOFTBREQ12_Pos = 0xc        // Position of SOFTBREQ12 field.
	GPDMA_SOFTBREQ_SOFTBREQ12_Msk = 0x1000     // Bit mask of SOFTBREQ12 field.
	GPDMA_SOFTBREQ_SOFTBREQ12     = 0x1000     // Bit SOFTBREQ12.
	GPDMA_SOFTBREQ_SOFTBREQ13_Pos = 0xd        // Position of SOFTBREQ13 field.
	GPDMA_SOFTBREQ_SOFTBREQ13_Msk = 0x2000     // Bit mask of SOFTBREQ13 field.
	GPDMA_SOFTBREQ_SOFTBREQ13     = 0x2000     // Bit SOFTBREQ13.
	GPDMA_SOFTBREQ_SOFTBREQ14_Pos = 0xe        // Position of SOFTBREQ14 field.
	GPDMA_SOFTBREQ_SOFTBREQ14_Msk = 0x4000     // Bit mask of SOFTBREQ14 field.
	GPDMA_SOFTBREQ_SOFTBREQ14     = 0x4000     // Bit SOFTBREQ14.
	GPDMA_SOFTBREQ_SOFTBREQ15_Pos = 0xf        // Position of SOFTBREQ15 field.
	GPDMA_SOFTBREQ_SOFTBREQ15_Msk = 0x8000     // Bit mask of SOFTBREQ15 field.
	GPDMA_SOFTBREQ_SOFTBREQ15     = 0x8000     // Bit SOFTBREQ15.
	GPDMA_SOFTBREQ_RESERVED_Pos   = 0x10       // Position of RESERVED field.
	GPDMA_SOFTBREQ_RESERVED_Msk   = 0xffff0000 // Bit mask of RESERVED field.

	// SOFTSREQ: DMA Software Single Request Register
	GPDMA_SOFTSREQ_SOFTSREQ0_Pos  = 0x0        // Position of SOFTSREQ0 field.
	GPDMA_SOFTSREQ_SOFTSREQ0_Msk  = 0x1        // Bit mask of SOFTSREQ0 field.
	GPDMA_SOFTSREQ_SOFTSREQ0      = 0x1        // Bit SOFTSREQ0.
	GPDMA_SOFTSREQ_SOFTSREQ1_Pos  = 0x1        // Position of SOFTSREQ1 field.
	GPDMA_SOFTSREQ_SOFTSREQ1_Msk  = 0x2        // Bit mask of SOFTSREQ1 field.
	GPDMA_SOFTSREQ_SOFTSREQ1      = 0x2        // Bit SOFTSREQ1.
	GPDMA_SOFTSREQ_SOFTSREQ2_Pos  = 0x2        // Position of SOFTSREQ2 field.
	GPDMA_SOFTSREQ_SOFTSREQ2_Msk  = 0x4        // Bit mask of SOFTSREQ2 field.
	GPDMA_SOFTSREQ_SOFTSREQ2      = 0x4        // Bit SOFTSREQ2.
	GPDMA_SOFTSREQ_SOFTSREQ3_Pos  = 0x3        // Position of SOFTSREQ3 field.
	GPDMA_SOFTSREQ_SOFTSREQ3_Msk  = 0x8        // Bit mask of SOFTSREQ3 field.
	GPDMA_SOFTSREQ_SOFTSREQ3      = 0x8        // Bit SOFTSREQ3.
	GPDMA_SOFTSREQ_SOFTSREQ4_Pos  = 0x4        // Position of SOFTSREQ4 field.
	GPDMA_SOFTSREQ_SOFTSREQ4_Msk  = 0x10       // Bit mask of SOFTSREQ4 field.
	GPDMA_SOFTSREQ_SOFTSREQ4      = 0x10       // Bit SOFTSREQ4.
	GPDMA_SOFTSREQ_SOFTSREQ5_Pos  = 0x5        // Position of SOFTSREQ5 field.
	GPDMA_SOFTSREQ_SOFTSREQ5_Msk  = 0x20       // Bit mask of SOFTSREQ5 field.
	GPDMA_SOFTSREQ_SOFTSREQ5      = 0x20       // Bit SOFTSREQ5.
	GPDMA_SOFTSREQ_SOFTSREQ6_Pos  = 0x6        // Position of SOFTSREQ6 field.
	GPDMA_SOFTSREQ_SOFTSREQ6_Msk  = 0x40       // Bit mask of SOFTSREQ6 field.
	GPDMA_SOFTSREQ_SOFTSREQ6      = 0x40       // Bit SOFTSREQ6.
	GPDMA_SOFTSREQ_SOFTSREQ7_Pos  = 0x7        // Position of SOFTSREQ7 field.
	GPDMA_SOFTSREQ_SOFTSREQ7_Msk  = 0x80       // Bit mask of SOFTSREQ7 field.
	GPDMA_SOFTSREQ_SOFTSREQ7      = 0x80       // Bit SOFTSREQ7.
	GPDMA_SOFTSREQ_SOFTSREQ8_Pos  = 0x8        // Position of SOFTSREQ8 field.
	GPDMA_SOFTSREQ_SOFTSREQ8_Msk  = 0x100      // Bit mask of SOFTSREQ8 field.
	GPDMA_SOFTSREQ_SOFTSREQ8      = 0x100      // Bit SOFTSREQ8.
	GPDMA_SOFTSREQ_SOFTSREQ9_Pos  = 0x9        // Position of SOFTSREQ9 field.
	GPDMA_SOFTSREQ_SOFTSREQ9_Msk  = 0x200      // Bit mask of SOFTSREQ9 field.
	GPDMA_SOFTSREQ_SOFTSREQ9      = 0x200      // Bit SOFTSREQ9.
	GPDMA_SOFTSREQ_SOFTSREQ10_Pos = 0xa        // Position of SOFTSREQ10 field.
	GPDMA_SOFTSREQ_SOFTSREQ10_Msk = 0x400      // Bit mask of SOFTSREQ10 field.
	GPDMA_SOFTSREQ_SOFTSREQ10     = 0x400      // Bit SOFTSREQ10.
	GPDMA_SOFTSREQ_SOFTSREQ11_Pos = 0xb        // Position of SOFTSREQ11 field.
	GPDMA_SOFTSREQ_SOFTSREQ11_Msk = 0x800      // Bit mask of SOFTSREQ11 field.
	GPDMA_SOFTSREQ_SOFTSREQ11     = 0x800      // Bit SOFTSREQ11.
	GPDMA_SOFTSREQ_SOFTSREQ12_Pos = 0xc        // Position of SOFTSREQ12 field.
	GPDMA_SOFTSREQ_SOFTSREQ12_Msk = 0x1000     // Bit mask of SOFTSREQ12 field.
	GPDMA_SOFTSREQ_SOFTSREQ12     = 0x1000     // Bit SOFTSREQ12.
	GPDMA_SOFTSREQ_SOFTSREQ13_Pos = 0xd        // Position of SOFTSREQ13 field.
	GPDMA_SOFTSREQ_SOFTSREQ13_Msk = 0x2000     // Bit mask of SOFTSREQ13 field.
	GPDMA_SOFTSREQ_SOFTSREQ13     = 0x2000     // Bit SOFTSREQ13.
	GPDMA_SOFTSREQ_SOFTSREQ14_Pos = 0xe        // Position of SOFTSREQ14 field.
	GPDMA_SOFTSREQ_SOFTSREQ14_Msk = 0x4000     // Bit mask of SOFTSREQ14 field.
	GPDMA_SOFTSREQ_SOFTSREQ14     = 0x4000     // Bit SOFTSREQ14.
	GPDMA_SOFTSREQ_SOFTSREQ15_Pos = 0xf        // Position of SOFTSREQ15 field.
	GPDMA_SOFTSREQ_SOFTSREQ15_Msk = 0x8000     // Bit mask of SOFTSREQ15 field.
	GPDMA_SOFTSREQ_SOFTSREQ15     = 0x8000     // Bit SOFTSREQ15.
	GPDMA_SOFTSREQ_RESERVED_Pos   = 0x10       // Position of RESERVED field.
	GPDMA_SOFTSREQ_RESERVED_Msk   = 0xffff0000 // Bit mask of RESERVED field.

	// SOFTLBREQ: DMA Software Last Burst Request Register
	GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos  = 0x0        // Position of SOFTLBREQ0 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ0_Msk  = 0x1        // Bit mask of SOFTLBREQ0 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ0      = 0x1        // Bit SOFTLBREQ0.
	GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos  = 0x1        // Position of SOFTLBREQ1 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ1_Msk  = 0x2        // Bit mask of SOFTLBREQ1 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ1      = 0x2        // Bit SOFTLBREQ1.
	GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos  = 0x2        // Position of SOFTLBREQ2 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ2_Msk  = 0x4        // Bit mask of SOFTLBREQ2 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ2      = 0x4        // Bit SOFTLBREQ2.
	GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos  = 0x3        // Position of SOFTLBREQ3 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ3_Msk  = 0x8        // Bit mask of SOFTLBREQ3 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ3      = 0x8        // Bit SOFTLBREQ3.
	GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos  = 0x4        // Position of SOFTLBREQ4 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ4_Msk  = 0x10       // Bit mask of SOFTLBREQ4 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ4      = 0x10       // Bit SOFTLBREQ4.
	GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos  = 0x5        // Position of SOFTLBREQ5 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ5_Msk  = 0x20       // Bit mask of SOFTLBREQ5 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ5      = 0x20       // Bit SOFTLBREQ5.
	GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos  = 0x6        // Position of SOFTLBREQ6 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ6_Msk  = 0x40       // Bit mask of SOFTLBREQ6 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ6      = 0x40       // Bit SOFTLBREQ6.
	GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos  = 0x7        // Position of SOFTLBREQ7 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ7_Msk  = 0x80       // Bit mask of SOFTLBREQ7 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ7      = 0x80       // Bit SOFTLBREQ7.
	GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos  = 0x8        // Position of SOFTLBREQ8 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ8_Msk  = 0x100      // Bit mask of SOFTLBREQ8 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ8      = 0x100      // Bit SOFTLBREQ8.
	GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos  = 0x9        // Position of SOFTLBREQ9 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ9_Msk  = 0x200      // Bit mask of SOFTLBREQ9 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ9      = 0x200      // Bit SOFTLBREQ9.
	GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos = 0xa        // Position of SOFTLBREQ10 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ10_Msk = 0x400      // Bit mask of SOFTLBREQ10 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ10     = 0x400      // Bit SOFTLBREQ10.
	GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos = 0xb        // Position of SOFTLBREQ11 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ11_Msk = 0x800      // Bit mask of SOFTLBREQ11 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ11     = 0x800      // Bit SOFTLBREQ11.
	GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos = 0xc        // Position of SOFTLBREQ12 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ12_Msk = 0x1000     // Bit mask of SOFTLBREQ12 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ12     = 0x1000     // Bit SOFTLBREQ12.
	GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos = 0xd        // Position of SOFTLBREQ13 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ13_Msk = 0x2000     // Bit mask of SOFTLBREQ13 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ13     = 0x2000     // Bit SOFTLBREQ13.
	GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos = 0xe        // Position of SOFTLBREQ14 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ14_Msk = 0x4000     // Bit mask of SOFTLBREQ14 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ14     = 0x4000     // Bit SOFTLBREQ14.
	GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos = 0xf        // Position of SOFTLBREQ15 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ15_Msk = 0x8000     // Bit mask of SOFTLBREQ15 field.
	GPDMA_SOFTLBREQ_SOFTLBREQ15     = 0x8000     // Bit SOFTLBREQ15.
	GPDMA_SOFTLBREQ_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	GPDMA_SOFTLBREQ_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// SOFTLSREQ: DMA Software Last Single Request Register
	GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos  = 0x0        // Position of SOFTLSREQ0 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ0_Msk  = 0x1        // Bit mask of SOFTLSREQ0 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ0      = 0x1        // Bit SOFTLSREQ0.
	GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos  = 0x1        // Position of SOFTLSREQ1 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ1_Msk  = 0x2        // Bit mask of SOFTLSREQ1 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ1      = 0x2        // Bit SOFTLSREQ1.
	GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos  = 0x2        // Position of SOFTLSREQ2 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ2_Msk  = 0x4        // Bit mask of SOFTLSREQ2 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ2      = 0x4        // Bit SOFTLSREQ2.
	GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos  = 0x3        // Position of SOFTLSREQ3 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ3_Msk  = 0x8        // Bit mask of SOFTLSREQ3 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ3      = 0x8        // Bit SOFTLSREQ3.
	GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos  = 0x4        // Position of SOFTLSREQ4 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ4_Msk  = 0x10       // Bit mask of SOFTLSREQ4 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ4      = 0x10       // Bit SOFTLSREQ4.
	GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos  = 0x5        // Position of SOFTLSREQ5 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ5_Msk  = 0x20       // Bit mask of SOFTLSREQ5 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ5      = 0x20       // Bit SOFTLSREQ5.
	GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos  = 0x6        // Position of SOFTLSREQ6 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ6_Msk  = 0x40       // Bit mask of SOFTLSREQ6 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ6      = 0x40       // Bit SOFTLSREQ6.
	GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos  = 0x7        // Position of SOFTLSREQ7 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ7_Msk  = 0x80       // Bit mask of SOFTLSREQ7 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ7      = 0x80       // Bit SOFTLSREQ7.
	GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos  = 0x8        // Position of SOFTLSREQ8 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ8_Msk  = 0x100      // Bit mask of SOFTLSREQ8 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ8      = 0x100      // Bit SOFTLSREQ8.
	GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos  = 0x9        // Position of SOFTLSREQ9 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ9_Msk  = 0x200      // Bit mask of SOFTLSREQ9 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ9      = 0x200      // Bit SOFTLSREQ9.
	GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos = 0xa        // Position of SOFTLSREQ10 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ10_Msk = 0x400      // Bit mask of SOFTLSREQ10 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ10     = 0x400      // Bit SOFTLSREQ10.
	GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos = 0xb        // Position of SOFTLSREQ11 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ11_Msk = 0x800      // Bit mask of SOFTLSREQ11 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ11     = 0x800      // Bit SOFTLSREQ11.
	GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos = 0xc        // Position of SOFTLSREQ12 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ12_Msk = 0x1000     // Bit mask of SOFTLSREQ12 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ12     = 0x1000     // Bit SOFTLSREQ12.
	GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos = 0xd        // Position of SOFTLSREQ13 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ13_Msk = 0x2000     // Bit mask of SOFTLSREQ13 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ13     = 0x2000     // Bit SOFTLSREQ13.
	GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos = 0xe        // Position of SOFTLSREQ14 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ14_Msk = 0x4000     // Bit mask of SOFTLSREQ14 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ14     = 0x4000     // Bit SOFTLSREQ14.
	GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos = 0xf        // Position of SOFTLSREQ15 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ15_Msk = 0x8000     // Bit mask of SOFTLSREQ15 field.
	GPDMA_SOFTLSREQ_SOFTLSREQ15     = 0x8000     // Bit SOFTLSREQ15.
	GPDMA_SOFTLSREQ_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	GPDMA_SOFTLSREQ_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// CONFIG: DMA Configuration Register
	GPDMA_CONFIG_E_Pos        = 0x0        // Position of E field.
	GPDMA_CONFIG_E_Msk        = 0x1        // Bit mask of E field.
	GPDMA_CONFIG_E            = 0x1        // Bit E.
	GPDMA_CONFIG_M_Pos        = 0x1        // Position of M field.
	GPDMA_CONFIG_M_Msk        = 0x2        // Bit mask of M field.
	GPDMA_CONFIG_M            = 0x2        // Bit M.
	GPDMA_CONFIG_RESERVED_Pos = 0x2        // Position of RESERVED field.
	GPDMA_CONFIG_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// SYNC: DMA Synchronization Register
	GPDMA_SYNC_DMACSYNC0_Pos  = 0x0        // Position of DMACSYNC0 field.
	GPDMA_SYNC_DMACSYNC0_Msk  = 0x1        // Bit mask of DMACSYNC0 field.
	GPDMA_SYNC_DMACSYNC0      = 0x1        // Bit DMACSYNC0.
	GPDMA_SYNC_DMACSYNC1_Pos  = 0x1        // Position of DMACSYNC1 field.
	GPDMA_SYNC_DMACSYNC1_Msk  = 0x2        // Bit mask of DMACSYNC1 field.
	GPDMA_SYNC_DMACSYNC1      = 0x2        // Bit DMACSYNC1.
	GPDMA_SYNC_DMACSYNC2_Pos  = 0x2        // Position of DMACSYNC2 field.
	GPDMA_SYNC_DMACSYNC2_Msk  = 0x4        // Bit mask of DMACSYNC2 field.
	GPDMA_SYNC_DMACSYNC2      = 0x4        // Bit DMACSYNC2.
	GPDMA_SYNC_DMACSYNC3_Pos  = 0x3        // Position of DMACSYNC3 field.
	GPDMA_SYNC_DMACSYNC3_Msk  = 0x8        // Bit mask of DMACSYNC3 field.
	GPDMA_SYNC_DMACSYNC3      = 0x8        // Bit DMACSYNC3.
	GPDMA_SYNC_DMACSYNC4_Pos  = 0x4        // Position of DMACSYNC4 field.
	GPDMA_SYNC_DMACSYNC4_Msk  = 0x10       // Bit mask of DMACSYNC4 field.
	GPDMA_SYNC_DMACSYNC4      = 0x10       // Bit DMACSYNC4.
	GPDMA_SYNC_DMACSYNC5_Pos  = 0x5        // Position of DMACSYNC5 field.
	GPDMA_SYNC_DMACSYNC5_Msk  = 0x20       // Bit mask of DMACSYNC5 field.
	GPDMA_SYNC_DMACSYNC5      = 0x20       // Bit DMACSYNC5.
	GPDMA_SYNC_DMACSYNC6_Pos  = 0x6        // Position of DMACSYNC6 field.
	GPDMA_SYNC_DMACSYNC6_Msk  = 0x40       // Bit mask of DMACSYNC6 field.
	GPDMA_SYNC_DMACSYNC6      = 0x40       // Bit DMACSYNC6.
	GPDMA_SYNC_DMACSYNC7_Pos  = 0x7        // Position of DMACSYNC7 field.
	GPDMA_SYNC_DMACSYNC7_Msk  = 0x80       // Bit mask of DMACSYNC7 field.
	GPDMA_SYNC_DMACSYNC7      = 0x80       // Bit DMACSYNC7.
	GPDMA_SYNC_DMACSYNC8_Pos  = 0x8        // Position of DMACSYNC8 field.
	GPDMA_SYNC_DMACSYNC8_Msk  = 0x100      // Bit mask of DMACSYNC8 field.
	GPDMA_SYNC_DMACSYNC8      = 0x100      // Bit DMACSYNC8.
	GPDMA_SYNC_DMACSYNC9_Pos  = 0x9        // Position of DMACSYNC9 field.
	GPDMA_SYNC_DMACSYNC9_Msk  = 0x200      // Bit mask of DMACSYNC9 field.
	GPDMA_SYNC_DMACSYNC9      = 0x200      // Bit DMACSYNC9.
	GPDMA_SYNC_DMACSYNC10_Pos = 0xa        // Position of DMACSYNC10 field.
	GPDMA_SYNC_DMACSYNC10_Msk = 0x400      // Bit mask of DMACSYNC10 field.
	GPDMA_SYNC_DMACSYNC10     = 0x400      // Bit DMACSYNC10.
	GPDMA_SYNC_DMACSYNC11_Pos = 0xb        // Position of DMACSYNC11 field.
	GPDMA_SYNC_DMACSYNC11_Msk = 0x800      // Bit mask of DMACSYNC11 field.
	GPDMA_SYNC_DMACSYNC11     = 0x800      // Bit DMACSYNC11.
	GPDMA_SYNC_DMACSYNC12_Pos = 0xc        // Position of DMACSYNC12 field.
	GPDMA_SYNC_DMACSYNC12_Msk = 0x1000     // Bit mask of DMACSYNC12 field.
	GPDMA_SYNC_DMACSYNC12     = 0x1000     // Bit DMACSYNC12.
	GPDMA_SYNC_DMACSYNC13_Pos = 0xd        // Position of DMACSYNC13 field.
	GPDMA_SYNC_DMACSYNC13_Msk = 0x2000     // Bit mask of DMACSYNC13 field.
	GPDMA_SYNC_DMACSYNC13     = 0x2000     // Bit DMACSYNC13.
	GPDMA_SYNC_DMACSYNC14_Pos = 0xe        // Position of DMACSYNC14 field.
	GPDMA_SYNC_DMACSYNC14_Msk = 0x4000     // Bit mask of DMACSYNC14 field.
	GPDMA_SYNC_DMACSYNC14     = 0x4000     // Bit DMACSYNC14.
	GPDMA_SYNC_DMACSYNC15_Pos = 0xf        // Position of DMACSYNC15 field.
	GPDMA_SYNC_DMACSYNC15_Msk = 0x8000     // Bit mask of DMACSYNC15 field.
	GPDMA_SYNC_DMACSYNC15     = 0x8000     // Bit DMACSYNC15.
	GPDMA_SYNC_RESERVED_Pos   = 0x10       // Position of RESERVED field.
	GPDMA_SYNC_RESERVED_Msk   = 0xffff0000 // Bit mask of RESERVED field.

	// SRCADDR0: DMA Channel 0 Source Address Register
	GPDMA_SRCADDR_SRCADDR_Pos = 0x0        // Position of SRCADDR field.
	GPDMA_SRCADDR_SRCADDR_Msk = 0xffffffff // Bit mask of SRCADDR field.

	// DESTADDR0: DMA Channel 0 Destination Address Register
	GPDMA_DESTADDR_DESTADDR_Pos = 0x0        // Position of DESTADDR field.
	GPDMA_DESTADDR_DESTADDR_Msk = 0xffffffff // Bit mask of DESTADDR field.

	// LLI0: DMA Channel 0 Linked List Item Register
	GPDMA_LLI_RESERVED_Pos = 0x0        // Position of RESERVED field.
	GPDMA_LLI_RESERVED_Msk = 0x3        // Bit mask of RESERVED field.
	GPDMA_LLI_LLI_Pos      = 0x2        // Position of LLI field.
	GPDMA_LLI_LLI_Msk      = 0xfffffffc // Bit mask of LLI field.

	// CONTROL0: DMA Channel 0 Control Register
	GPDMA_CONTROL_TRANSFERSIZE_Pos = 0x0        // Position of TRANSFERSIZE field.
	GPDMA_CONTROL_TRANSFERSIZE_Msk = 0xfff      // Bit mask of TRANSFERSIZE field.
	GPDMA_CONTROL_SBSIZE_Pos       = 0xc        // Position of SBSIZE field.
	GPDMA_CONTROL_SBSIZE_Msk       = 0x7000     // Bit mask of SBSIZE field.
	GPDMA_CONTROL_DBSIZE_Pos       = 0xf        // Position of DBSIZE field.
	GPDMA_CONTROL_DBSIZE_Msk       = 0x38000    // Bit mask of DBSIZE field.
	GPDMA_CONTROL_SWIDTH_Pos       = 0x12       // Position of SWIDTH field.
	GPDMA_CONTROL_SWIDTH_Msk       = 0x1c0000   // Bit mask of SWIDTH field.
	GPDMA_CONTROL_DWIDTH_Pos       = 0x15       // Position of DWIDTH field.
	GPDMA_CONTROL_DWIDTH_Msk       = 0xe00000   // Bit mask of DWIDTH field.
	GPDMA_CONTROL_RESERVED_Pos     = 0x18       // Position of RESERVED field.
	GPDMA_CONTROL_RESERVED_Msk     = 0x3000000  // Bit mask of RESERVED field.
	GPDMA_CONTROL_SI_Pos           = 0x1a       // Position of SI field.
	GPDMA_CONTROL_SI_Msk           = 0x4000000  // Bit mask of SI field.
	GPDMA_CONTROL_SI               = 0x4000000  // Bit SI.
	GPDMA_CONTROL_DI_Pos           = 0x1b       // Position of DI field.
	GPDMA_CONTROL_DI_Msk           = 0x8000000  // Bit mask of DI field.
	GPDMA_CONTROL_DI               = 0x8000000  // Bit DI.
	GPDMA_CONTROL_PROT1_Pos        = 0x1c       // Position of PROT1 field.
	GPDMA_CONTROL_PROT1_Msk        = 0x10000000 // Bit mask of PROT1 field.
	GPDMA_CONTROL_PROT1            = 0x10000000 // Bit PROT1.
	GPDMA_CONTROL_PROT2_Pos        = 0x1d       // Position of PROT2 field.
	GPDMA_CONTROL_PROT2_Msk        = 0x20000000 // Bit mask of PROT2 field.
	GPDMA_CONTROL_PROT2            = 0x20000000 // Bit PROT2.
	GPDMA_CONTROL_PROT3_Pos        = 0x1e       // Position of PROT3 field.
	GPDMA_CONTROL_PROT3_Msk        = 0x40000000 // Bit mask of PROT3 field.
	GPDMA_CONTROL_PROT3            = 0x40000000 // Bit PROT3.
	GPDMA_CONTROL_I_Pos            = 0x1f       // Position of I field.
	GPDMA_CONTROL_I_Msk            = 0x80000000 // Bit mask of I field.
	GPDMA_CONTROL_I                = 0x80000000 // Bit I.

	// CONFIG0: DMA Channel 0 Configuration Register[1]
	GPDMA_CONFIG_E_Pos              = 0x0        // Position of E field.
	GPDMA_CONFIG_E_Msk              = 0x1        // Bit mask of E field.
	GPDMA_CONFIG_E                  = 0x1        // Bit E.
	GPDMA_CONFIG_SRCPERIPHERAL_Pos  = 0x1        // Position of SRCPERIPHERAL field.
	GPDMA_CONFIG_SRCPERIPHERAL_Msk  = 0x3e       // Bit mask of SRCPERIPHERAL field.
	GPDMA_CONFIG_DESTPERIPHERAL_Pos = 0x6        // Position of DESTPERIPHERAL field.
	GPDMA_CONFIG_DESTPERIPHERAL_Msk = 0x7c0      // Bit mask of DESTPERIPHERAL field.
	GPDMA_CONFIG_TRANSFERTYPE_Pos   = 0xb        // Position of TRANSFERTYPE field.
	GPDMA_CONFIG_TRANSFERTYPE_Msk   = 0x3800     // Bit mask of TRANSFERTYPE field.
	GPDMA_CONFIG_IE_Pos             = 0xe        // Position of IE field.
	GPDMA_CONFIG_IE_Msk             = 0x4000     // Bit mask of IE field.
	GPDMA_CONFIG_IE                 = 0x4000     // Bit IE.
	GPDMA_CONFIG_ITC_Pos            = 0xf        // Position of ITC field.
	GPDMA_CONFIG_ITC_Msk            = 0x8000     // Bit mask of ITC field.
	GPDMA_CONFIG_ITC                = 0x8000     // Bit ITC.
	GPDMA_CONFIG_L_Pos              = 0x10       // Position of L field.
	GPDMA_CONFIG_L_Msk              = 0x10000    // Bit mask of L field.
	GPDMA_CONFIG_L                  = 0x10000    // Bit L.
	GPDMA_CONFIG_A_Pos              = 0x11       // Position of A field.
	GPDMA_CONFIG_A_Msk              = 0x20000    // Bit mask of A field.
	GPDMA_CONFIG_A                  = 0x20000    // Bit A.
	GPDMA_CONFIG_H_Pos              = 0x12       // Position of H field.
	GPDMA_CONFIG_H_Msk              = 0x40000    // Bit mask of H field.
	GPDMA_CONFIG_H                  = 0x40000    // Bit H.
	GPDMA_CONFIG_RESERVED_Pos       = 0x13       // Position of RESERVED field.
	GPDMA_CONFIG_RESERVED_Msk       = 0xfff80000 // Bit mask of RESERVED field.
)

// Bitfields for USB: USB device/host/OTG controller
const (
	// RXPLEN: USB Receive Packet Length
	USB_RXPLEN_PKT_LNGTH_Pos       = 0x0        // Position of PKT_LNGTH field.
	USB_RXPLEN_PKT_LNGTH_Msk       = 0x3ff      // Bit mask of PKT_LNGTH field.
	USB_RXPLEN_DV_Pos              = 0xa        // Position of DV field.
	USB_RXPLEN_DV_Msk              = 0x400      // Bit mask of DV field.
	USB_RXPLEN_DV                  = 0x400      // Bit DV.
	USB_RXPLEN_DV_DATA_IS_INVALID_ = 0x0        // Data is invalid.
	USB_RXPLEN_DV_DATA_IS_VALID_   = 0x1        // Data is valid.
	USB_RXPLEN_PKT_RDY_Pos         = 0xb        // Position of PKT_RDY field.
	USB_RXPLEN_PKT_RDY_Msk         = 0x800      // Bit mask of PKT_RDY field.
	USB_RXPLEN_PKT_RDY             = 0x800      // Bit PKT_RDY.
	USB_RXPLEN_RESERVED_Pos        = 0xc        // Position of RESERVED field.
	USB_RXPLEN_RESERVED_Msk        = 0xfffff000 // Bit mask of RESERVED field.

	// INTST: OTG Interrupt Status
	USB_INTST_TMR_Pos         = 0x0        // Position of TMR field.
	USB_INTST_TMR_Msk         = 0x1        // Bit mask of TMR field.
	USB_INTST_TMR             = 0x1        // Bit TMR.
	USB_INTST_REMOVE_PU_Pos   = 0x1        // Position of REMOVE_PU field.
	USB_INTST_REMOVE_PU_Msk   = 0x2        // Bit mask of REMOVE_PU field.
	USB_INTST_REMOVE_PU       = 0x2        // Bit REMOVE_PU.
	USB_INTST_HNP_FAILURE_Pos = 0x2        // Position of HNP_FAILURE field.
	USB_INTST_HNP_FAILURE_Msk = 0x4        // Bit mask of HNP_FAILURE field.
	USB_INTST_HNP_FAILURE     = 0x4        // Bit HNP_FAILURE.
	USB_INTST_HNP_SUCCESS_Pos = 0x3        // Position of HNP_SUCCESS field.
	USB_INTST_HNP_SUCCESS_Msk = 0x8        // Bit mask of HNP_SUCCESS field.
	USB_INTST_HNP_SUCCESS     = 0x8        // Bit HNP_SUCCESS.
	USB_INTST_RESERVED_Pos    = 0x4        // Position of RESERVED field.
	USB_INTST_RESERVED_Msk    = 0xfffffff0 // Bit mask of RESERVED field.

	// INTEN: OTG Interrupt Enable
	USB_INTEN_TMR_EN_Pos         = 0x0        // Position of TMR_EN field.
	USB_INTEN_TMR_EN_Msk         = 0x1        // Bit mask of TMR_EN field.
	USB_INTEN_TMR_EN             = 0x1        // Bit TMR_EN.
	USB_INTEN_REMOVE_PU_EN_Pos   = 0x1        // Position of REMOVE_PU_EN field.
	USB_INTEN_REMOVE_PU_EN_Msk   = 0x2        // Bit mask of REMOVE_PU_EN field.
	USB_INTEN_REMOVE_PU_EN       = 0x2        // Bit REMOVE_PU_EN.
	USB_INTEN_HNP_FAILURE_EN_Pos = 0x2        // Position of HNP_FAILURE_EN field.
	USB_INTEN_HNP_FAILURE_EN_Msk = 0x4        // Bit mask of HNP_FAILURE_EN field.
	USB_INTEN_HNP_FAILURE_EN     = 0x4        // Bit HNP_FAILURE_EN.
	USB_INTEN_HNP_SUCCES_EN_Pos  = 0x3        // Position of HNP_SUCCES_EN field.
	USB_INTEN_HNP_SUCCES_EN_Msk  = 0x8        // Bit mask of HNP_SUCCES_EN field.
	USB_INTEN_HNP_SUCCES_EN      = 0x8        // Bit HNP_SUCCES_EN.
	USB_INTEN_RESERVED_Pos       = 0x4        // Position of RESERVED field.
	USB_INTEN_RESERVED_Msk       = 0xfffffff0 // Bit mask of RESERVED field.

	// INTSET: OTG Interrupt Set
	USB_INTSET_TMR_SET_Pos         = 0x0        // Position of TMR_SET field.
	USB_INTSET_TMR_SET_Msk         = 0x1        // Bit mask of TMR_SET field.
	USB_INTSET_TMR_SET             = 0x1        // Bit TMR_SET.
	USB_INTSET_REMOVE_PU_SET_Pos   = 0x1        // Position of REMOVE_PU_SET field.
	USB_INTSET_REMOVE_PU_SET_Msk   = 0x2        // Bit mask of REMOVE_PU_SET field.
	USB_INTSET_REMOVE_PU_SET       = 0x2        // Bit REMOVE_PU_SET.
	USB_INTSET_HNP_FAILURE_SET_Pos = 0x2        // Position of HNP_FAILURE_SET field.
	USB_INTSET_HNP_FAILURE_SET_Msk = 0x4        // Bit mask of HNP_FAILURE_SET field.
	USB_INTSET_HNP_FAILURE_SET     = 0x4        // Bit HNP_FAILURE_SET.
	USB_INTSET_HNP_SUCCES_SET_Pos  = 0x3        // Position of HNP_SUCCES_SET field.
	USB_INTSET_HNP_SUCCES_SET_Msk  = 0x8        // Bit mask of HNP_SUCCES_SET field.
	USB_INTSET_HNP_SUCCES_SET      = 0x8        // Bit HNP_SUCCES_SET.
	USB_INTSET_RESERVED_Pos        = 0x4        // Position of RESERVED field.
	USB_INTSET_RESERVED_Msk        = 0xfffffff0 // Bit mask of RESERVED field.

	// INTCLR: OTG Interrupt Clear
	USB_INTCLR_TMR_CLR_Pos         = 0x0        // Position of TMR_CLR field.
	USB_INTCLR_TMR_CLR_Msk         = 0x1        // Bit mask of TMR_CLR field.
	USB_INTCLR_TMR_CLR             = 0x1        // Bit TMR_CLR.
	USB_INTCLR_REMOVE_PU_CLR_Pos   = 0x1        // Position of REMOVE_PU_CLR field.
	USB_INTCLR_REMOVE_PU_CLR_Msk   = 0x2        // Bit mask of REMOVE_PU_CLR field.
	USB_INTCLR_REMOVE_PU_CLR       = 0x2        // Bit REMOVE_PU_CLR.
	USB_INTCLR_HNP_FAILURE_CLR_Pos = 0x2        // Position of HNP_FAILURE_CLR field.
	USB_INTCLR_HNP_FAILURE_CLR_Msk = 0x4        // Bit mask of HNP_FAILURE_CLR field.
	USB_INTCLR_HNP_FAILURE_CLR     = 0x4        // Bit HNP_FAILURE_CLR.
	USB_INTCLR_HNP_SUCCES_CLR_Pos  = 0x3        // Position of HNP_SUCCES_CLR field.
	USB_INTCLR_HNP_SUCCES_CLR_Msk  = 0x8        // Bit mask of HNP_SUCCES_CLR field.
	USB_INTCLR_HNP_SUCCES_CLR      = 0x8        // Bit HNP_SUCCES_CLR.
	USB_INTCLR_RESERVED_Pos        = 0x4        // Position of RESERVED field.
	USB_INTCLR_RESERVED_Msk        = 0xfffffff0 // Bit mask of RESERVED field.

	// STCTRL: OTG Status and Control and USB port select
	USB_STCTRL_PORT_FUNC_Pos   = 0x0        // Position of PORT_FUNC field.
	USB_STCTRL_PORT_FUNC_Msk   = 0x3        // Bit mask of PORT_FUNC field.
	USB_STCTRL_TMR_SCALE_Pos   = 0x2        // Position of TMR_SCALE field.
	USB_STCTRL_TMR_SCALE_Msk   = 0xc        // Bit mask of TMR_SCALE field.
	USB_STCTRL_TMR_MODE_Pos    = 0x4        // Position of TMR_MODE field.
	USB_STCTRL_TMR_MODE_Msk    = 0x10       // Bit mask of TMR_MODE field.
	USB_STCTRL_TMR_MODE        = 0x10       // Bit TMR_MODE.
	USB_STCTRL_TMR_EN_Pos      = 0x5        // Position of TMR_EN field.
	USB_STCTRL_TMR_EN_Msk      = 0x20       // Bit mask of TMR_EN field.
	USB_STCTRL_TMR_EN          = 0x20       // Bit TMR_EN.
	USB_STCTRL_TMR_RST_Pos     = 0x6        // Position of TMR_RST field.
	USB_STCTRL_TMR_RST_Msk     = 0x40       // Bit mask of TMR_RST field.
	USB_STCTRL_TMR_RST         = 0x40       // Bit TMR_RST.
	USB_STCTRL_RESERVED_Pos    = 0x7        // Position of RESERVED field.
	USB_STCTRL_RESERVED_Msk    = 0x80       // Bit mask of RESERVED field.
	USB_STCTRL_RESERVED        = 0x80       // Bit RESERVED.
	USB_STCTRL_B_HNP_TRACK_Pos = 0x8        // Position of B_HNP_TRACK field.
	USB_STCTRL_B_HNP_TRACK_Msk = 0x100      // Bit mask of B_HNP_TRACK field.
	USB_STCTRL_B_HNP_TRACK     = 0x100      // Bit B_HNP_TRACK.
	USB_STCTRL_A_HNP_TRACK_Pos = 0x9        // Position of A_HNP_TRACK field.
	USB_STCTRL_A_HNP_TRACK_Msk = 0x200      // Bit mask of A_HNP_TRACK field.
	USB_STCTRL_A_HNP_TRACK     = 0x200      // Bit A_HNP_TRACK.
	USB_STCTRL_PU_REMOVED_Pos  = 0xa        // Position of PU_REMOVED field.
	USB_STCTRL_PU_REMOVED_Msk  = 0x400      // Bit mask of PU_REMOVED field.
	USB_STCTRL_PU_REMOVED      = 0x400      // Bit PU_REMOVED.
	USB_STCTRL_RESERVED_Pos    = 0xb        // Position of RESERVED field.
	USB_STCTRL_RESERVED_Msk    = 0xf800     // Bit mask of RESERVED field.
	USB_STCTRL_TMR_CNT_Pos     = 0x10       // Position of TMR_CNT field.
	USB_STCTRL_TMR_CNT_Msk     = 0xffff0000 // Bit mask of TMR_CNT field.

	// TMR: OTG Timer
	USB_TMR_TIMEOUT_CNT_Pos = 0x0        // Position of TIMEOUT_CNT field.
	USB_TMR_TIMEOUT_CNT_Msk = 0xffff     // Bit mask of TIMEOUT_CNT field.
	USB_TMR_RESERVED_Pos    = 0x10       // Position of RESERVED field.
	USB_TMR_RESERVED_Msk    = 0xffff0000 // Bit mask of RESERVED field.

	// DEVINTST: USB Device Interrupt Status
	USB_DEVINTST_FRAME_Pos    = 0x0        // Position of FRAME field.
	USB_DEVINTST_FRAME_Msk    = 0x1        // Bit mask of FRAME field.
	USB_DEVINTST_FRAME        = 0x1        // Bit FRAME.
	USB_DEVINTST_EP_FAST_Pos  = 0x1        // Position of EP_FAST field.
	USB_DEVINTST_EP_FAST_Msk  = 0x2        // Bit mask of EP_FAST field.
	USB_DEVINTST_EP_FAST      = 0x2        // Bit EP_FAST.
	USB_DEVINTST_EP_SLOW_Pos  = 0x2        // Position of EP_SLOW field.
	USB_DEVINTST_EP_SLOW_Msk  = 0x4        // Bit mask of EP_SLOW field.
	USB_DEVINTST_EP_SLOW      = 0x4        // Bit EP_SLOW.
	USB_DEVINTST_DEV_STAT_Pos = 0x3        // Position of DEV_STAT field.
	USB_DEVINTST_DEV_STAT_Msk = 0x8        // Bit mask of DEV_STAT field.
	USB_DEVINTST_DEV_STAT     = 0x8        // Bit DEV_STAT.
	USB_DEVINTST_CCEMPTY_Pos  = 0x4        // Position of CCEMPTY field.
	USB_DEVINTST_CCEMPTY_Msk  = 0x10       // Bit mask of CCEMPTY field.
	USB_DEVINTST_CCEMPTY      = 0x10       // Bit CCEMPTY.
	USB_DEVINTST_CDFULL_Pos   = 0x5        // Position of CDFULL field.
	USB_DEVINTST_CDFULL_Msk   = 0x20       // Bit mask of CDFULL field.
	USB_DEVINTST_CDFULL       = 0x20       // Bit CDFULL.
	USB_DEVINTST_RxENDPKT_Pos = 0x6        // Position of RxENDPKT field.
	USB_DEVINTST_RxENDPKT_Msk = 0x40       // Bit mask of RxENDPKT field.
	USB_DEVINTST_RxENDPKT     = 0x40       // Bit RxENDPKT.
	USB_DEVINTST_TxENDPKT_Pos = 0x7        // Position of TxENDPKT field.
	USB_DEVINTST_TxENDPKT_Msk = 0x80       // Bit mask of TxENDPKT field.
	USB_DEVINTST_TxENDPKT     = 0x80       // Bit TxENDPKT.
	USB_DEVINTST_EP_RLZED_Pos = 0x8        // Position of EP_RLZED field.
	USB_DEVINTST_EP_RLZED_Msk = 0x100      // Bit mask of EP_RLZED field.
	USB_DEVINTST_EP_RLZED     = 0x100      // Bit EP_RLZED.
	USB_DEVINTST_ERR_INT_Pos  = 0x9        // Position of ERR_INT field.
	USB_DEVINTST_ERR_INT_Msk  = 0x200      // Bit mask of ERR_INT field.
	USB_DEVINTST_ERR_INT      = 0x200      // Bit ERR_INT.
	USB_DEVINTST_RESERVED_Pos = 0xa        // Position of RESERVED field.
	USB_DEVINTST_RESERVED_Msk = 0xfffffc00 // Bit mask of RESERVED field.

	// DEVINTEN: USB Device Interrupt Enable
	USB_DEVINTEN_FRAMEEN_Pos    = 0x0        // Position of FRAMEEN field.
	USB_DEVINTEN_FRAMEEN_Msk    = 0x1        // Bit mask of FRAMEEN field.
	USB_DEVINTEN_FRAMEEN        = 0x1        // Bit FRAMEEN.
	USB_DEVINTEN_EP_FASTEN_Pos  = 0x1        // Position of EP_FASTEN field.
	USB_DEVINTEN_EP_FASTEN_Msk  = 0x2        // Bit mask of EP_FASTEN field.
	USB_DEVINTEN_EP_FASTEN      = 0x2        // Bit EP_FASTEN.
	USB_DEVINTEN_EP_SLOWEN_Pos  = 0x2        // Position of EP_SLOWEN field.
	USB_DEVINTEN_EP_SLOWEN_Msk  = 0x4        // Bit mask of EP_SLOWEN field.
	USB_DEVINTEN_EP_SLOWEN      = 0x4        // Bit EP_SLOWEN.
	USB_DEVINTEN_DEV_STATEN_Pos = 0x3        // Position of DEV_STATEN field.
	USB_DEVINTEN_DEV_STATEN_Msk = 0x8        // Bit mask of DEV_STATEN field.
	USB_DEVINTEN_DEV_STATEN     = 0x8        // Bit DEV_STATEN.
	USB_DEVINTEN_CCEMPTYEN_Pos  = 0x4        // Position of CCEMPTYEN field.
	USB_DEVINTEN_CCEMPTYEN_Msk  = 0x10       // Bit mask of CCEMPTYEN field.
	USB_DEVINTEN_CCEMPTYEN      = 0x10       // Bit CCEMPTYEN.
	USB_DEVINTEN_CDFULLEN_Pos   = 0x5        // Position of CDFULLEN field.
	USB_DEVINTEN_CDFULLEN_Msk   = 0x20       // Bit mask of CDFULLEN field.
	USB_DEVINTEN_CDFULLEN       = 0x20       // Bit CDFULLEN.
	USB_DEVINTEN_RxENDPKTEN_Pos = 0x6        // Position of RxENDPKTEN field.
	USB_DEVINTEN_RxENDPKTEN_Msk = 0x40       // Bit mask of RxENDPKTEN field.
	USB_DEVINTEN_RxENDPKTEN     = 0x40       // Bit RxENDPKTEN.
	USB_DEVINTEN_TxENDPKTEN_Pos = 0x7        // Position of TxENDPKTEN field.
	USB_DEVINTEN_TxENDPKTEN_Msk = 0x80       // Bit mask of TxENDPKTEN field.
	USB_DEVINTEN_TxENDPKTEN     = 0x80       // Bit TxENDPKTEN.
	USB_DEVINTEN_EP_RLZEDEN_Pos = 0x8        // Position of EP_RLZEDEN field.
	USB_DEVINTEN_EP_RLZEDEN_Msk = 0x100      // Bit mask of EP_RLZEDEN field.
	USB_DEVINTEN_EP_RLZEDEN     = 0x100      // Bit EP_RLZEDEN.
	USB_DEVINTEN_ERR_INTEN_Pos  = 0x9        // Position of ERR_INTEN field.
	USB_DEVINTEN_ERR_INTEN_Msk  = 0x200      // Bit mask of ERR_INTEN field.
	USB_DEVINTEN_ERR_INTEN      = 0x200      // Bit ERR_INTEN.
	USB_DEVINTEN_RESERVED_Pos   = 0xa        // Position of RESERVED field.
	USB_DEVINTEN_RESERVED_Msk   = 0xfffffc00 // Bit mask of RESERVED field.

	// DEVINTCLR: USB Device Interrupt Clear
	USB_DEVINTCLR_FRAMECLR_Pos    = 0x0        // Position of FRAMECLR field.
	USB_DEVINTCLR_FRAMECLR_Msk    = 0x1        // Bit mask of FRAMECLR field.
	USB_DEVINTCLR_FRAMECLR        = 0x1        // Bit FRAMECLR.
	USB_DEVINTCLR_EP_FASTCLR_Pos  = 0x1        // Position of EP_FASTCLR field.
	USB_DEVINTCLR_EP_FASTCLR_Msk  = 0x2        // Bit mask of EP_FASTCLR field.
	USB_DEVINTCLR_EP_FASTCLR      = 0x2        // Bit EP_FASTCLR.
	USB_DEVINTCLR_EP_SLOWCLR_Pos  = 0x2        // Position of EP_SLOWCLR field.
	USB_DEVINTCLR_EP_SLOWCLR_Msk  = 0x4        // Bit mask of EP_SLOWCLR field.
	USB_DEVINTCLR_EP_SLOWCLR      = 0x4        // Bit EP_SLOWCLR.
	USB_DEVINTCLR_DEV_STATCLR_Pos = 0x3        // Position of DEV_STATCLR field.
	USB_DEVINTCLR_DEV_STATCLR_Msk = 0x8        // Bit mask of DEV_STATCLR field.
	USB_DEVINTCLR_DEV_STATCLR     = 0x8        // Bit DEV_STATCLR.
	USB_DEVINTCLR_CCEMPTYCLR_Pos  = 0x4        // Position of CCEMPTYCLR field.
	USB_DEVINTCLR_CCEMPTYCLR_Msk  = 0x10       // Bit mask of CCEMPTYCLR field.
	USB_DEVINTCLR_CCEMPTYCLR      = 0x10       // Bit CCEMPTYCLR.
	USB_DEVINTCLR_CDFULLCLR_Pos   = 0x5        // Position of CDFULLCLR field.
	USB_DEVINTCLR_CDFULLCLR_Msk   = 0x20       // Bit mask of CDFULLCLR field.
	USB_DEVINTCLR_CDFULLCLR       = 0x20       // Bit CDFULLCLR.
	USB_DEVINTCLR_RxENDPKTCLR_Pos = 0x6        // Position of RxENDPKTCLR field.
	USB_DEVINTCLR_RxENDPKTCLR_Msk = 0x40       // Bit mask of RxENDPKTCLR field.
	USB_DEVINTCLR_RxENDPKTCLR     = 0x40       // Bit RxENDPKTCLR.
	USB_DEVINTCLR_TxENDPKTCLR_Pos = 0x7        // Position of TxENDPKTCLR field.
	USB_DEVINTCLR_TxENDPKTCLR_Msk = 0x80       // Bit mask of TxENDPKTCLR field.
	USB_DEVINTCLR_TxENDPKTCLR     = 0x80       // Bit TxENDPKTCLR.
	USB_DEVINTCLR_EP_RLZEDCLR_Pos = 0x8        // Position of EP_RLZEDCLR field.
	USB_DEVINTCLR_EP_RLZEDCLR_Msk = 0x100      // Bit mask of EP_RLZEDCLR field.
	USB_DEVINTCLR_EP_RLZEDCLR     = 0x100      // Bit EP_RLZEDCLR.
	USB_DEVINTCLR_ERR_INTCLR_Pos  = 0x9        // Position of ERR_INTCLR field.
	USB_DEVINTCLR_ERR_INTCLR_Msk  = 0x200      // Bit mask of ERR_INTCLR field.
	USB_DEVINTCLR_ERR_INTCLR      = 0x200      // Bit ERR_INTCLR.
	USB_DEVINTCLR_RESERVED_Pos    = 0xa        // Position of RESERVED field.
	USB_DEVINTCLR_RESERVED_Msk    = 0xfffffc00 // Bit mask of RESERVED field.

	// DEVINTSET: USB Device Interrupt Set
	USB_DEVINTSET_FRAMESET_Pos    = 0x0        // Position of FRAMESET field.
	USB_DEVINTSET_FRAMESET_Msk    = 0x1        // Bit mask of FRAMESET field.
	USB_DEVINTSET_FRAMESET        = 0x1        // Bit FRAMESET.
	USB_DEVINTSET_EP_FASTSET_Pos  = 0x1        // Position of EP_FASTSET field.
	USB_DEVINTSET_EP_FASTSET_Msk  = 0x2        // Bit mask of EP_FASTSET field.
	USB_DEVINTSET_EP_FASTSET      = 0x2        // Bit EP_FASTSET.
	USB_DEVINTSET_EP_SLOWSET_Pos  = 0x2        // Position of EP_SLOWSET field.
	USB_DEVINTSET_EP_SLOWSET_Msk  = 0x4        // Bit mask of EP_SLOWSET field.
	USB_DEVINTSET_EP_SLOWSET      = 0x4        // Bit EP_SLOWSET.
	USB_DEVINTSET_DEV_STATSET_Pos = 0x3        // Position of DEV_STATSET field.
	USB_DEVINTSET_DEV_STATSET_Msk = 0x8        // Bit mask of DEV_STATSET field.
	USB_DEVINTSET_DEV_STATSET     = 0x8        // Bit DEV_STATSET.
	USB_DEVINTSET_CCEMPTYSET_Pos  = 0x4        // Position of CCEMPTYSET field.
	USB_DEVINTSET_CCEMPTYSET_Msk  = 0x10       // Bit mask of CCEMPTYSET field.
	USB_DEVINTSET_CCEMPTYSET      = 0x10       // Bit CCEMPTYSET.
	USB_DEVINTSET_CDFULLSET_Pos   = 0x5        // Position of CDFULLSET field.
	USB_DEVINTSET_CDFULLSET_Msk   = 0x20       // Bit mask of CDFULLSET field.
	USB_DEVINTSET_CDFULLSET       = 0x20       // Bit CDFULLSET.
	USB_DEVINTSET_RxENDPKTSET_Pos = 0x6        // Position of RxENDPKTSET field.
	USB_DEVINTSET_RxENDPKTSET_Msk = 0x40       // Bit mask of RxENDPKTSET field.
	USB_DEVINTSET_RxENDPKTSET     = 0x40       // Bit RxENDPKTSET.
	USB_DEVINTSET_TxENDPKTSET_Pos = 0x7        // Position of TxENDPKTSET field.
	USB_DEVINTSET_TxENDPKTSET_Msk = 0x80       // Bit mask of TxENDPKTSET field.
	USB_DEVINTSET_TxENDPKTSET     = 0x80       // Bit TxENDPKTSET.
	USB_DEVINTSET_EP_RLZEDSET_Pos = 0x8        // Position of EP_RLZEDSET field.
	USB_DEVINTSET_EP_RLZEDSET_Msk = 0x100      // Bit mask of EP_RLZEDSET field.
	USB_DEVINTSET_EP_RLZEDSET     = 0x100      // Bit EP_RLZEDSET.
	USB_DEVINTSET_ERR_INTSET_Pos  = 0x9        // Position of ERR_INTSET field.
	USB_DEVINTSET_ERR_INTSET_Msk  = 0x200      // Bit mask of ERR_INTSET field.
	USB_DEVINTSET_ERR_INTSET      = 0x200      // Bit ERR_INTSET.
	USB_DEVINTSET_RESERVED_Pos    = 0xa        // Position of RESERVED field.
	USB_DEVINTSET_RESERVED_Msk    = 0xfffffc00 // Bit mask of RESERVED field.

	// CMDCODE: USB Command Code
	USB_CMDCODE_RESERVED_Pos       = 0x0        // Position of RESERVED field.
	USB_CMDCODE_RESERVED_Msk       = 0xff       // Bit mask of RESERVED field.
	USB_CMDCODE_CMD_PHASE_Pos      = 0x8        // Position of CMD_PHASE field.
	USB_CMDCODE_CMD_PHASE_Msk      = 0xff00     // Bit mask of CMD_PHASE field.
	USB_CMDCODE_CMD_PHASE_READ     = 0x2        // Read
	USB_CMDCODE_CMD_PHASE_WRITE    = 0x1        // Write
	USB_CMDCODE_CMD_PHASE_COMMAND  = 0x5        // Command
	USB_CMDCODE_CMD_CODE_WDATA_Pos = 0x10       // Position of CMD_CODE_WDATA field.
	USB_CMDCODE_CMD_CODE_WDATA_Msk = 0xff0000   // Bit mask of CMD_CODE_WDATA field.
	USB_CMDCODE_RESERVED_Pos       = 0x18       // Position of RESERVED field.
	USB_CMDCODE_RESERVED_Msk       = 0xff000000 // Bit mask of RESERVED field.

	// CMDDATA: USB Command Data
	USB_CMDDATA_CMD_RDATA_Pos = 0x0        // Position of CMD_RDATA field.
	USB_CMDDATA_CMD_RDATA_Msk = 0xff       // Bit mask of CMD_RDATA field.
	USB_CMDDATA_RESERVED_Pos  = 0x8        // Position of RESERVED field.
	USB_CMDDATA_RESERVED_Msk  = 0xffffff00 // Bit mask of RESERVED field.

	// RXDATA: USB Receive Data
	USB_RXDATA_RX_DATA_Pos = 0x0        // Position of RX_DATA field.
	USB_RXDATA_RX_DATA_Msk = 0xffffffff // Bit mask of RX_DATA field.

	// TXDATA: USB Transmit Data
	USB_TXDATA_TX_DATA_Pos = 0x0        // Position of TX_DATA field.
	USB_TXDATA_TX_DATA_Msk = 0xffffffff // Bit mask of TX_DATA field.

	// TXPLEN: USB Transmit Packet Length
	USB_TXPLEN_PKT_LNGTH_Pos = 0x0        // Position of PKT_LNGTH field.
	USB_TXPLEN_PKT_LNGTH_Msk = 0x3ff      // Bit mask of PKT_LNGTH field.
	USB_TXPLEN_RESERVED_Pos  = 0xa        // Position of RESERVED field.
	USB_TXPLEN_RESERVED_Msk  = 0xfffffc00 // Bit mask of RESERVED field.

	// CTRL: USB Control
	USB_CTRL_RD_EN_Pos        = 0x0        // Position of RD_EN field.
	USB_CTRL_RD_EN_Msk        = 0x1        // Bit mask of RD_EN field.
	USB_CTRL_RD_EN            = 0x1        // Bit RD_EN.
	USB_CTRL_RD_EN_DISABLED_  = 0x0        // Disabled.
	USB_CTRL_RD_EN_ENABLED_   = 0x1        // Enabled.
	USB_CTRL_WR_EN_Pos        = 0x1        // Position of WR_EN field.
	USB_CTRL_WR_EN_Msk        = 0x2        // Bit mask of WR_EN field.
	USB_CTRL_WR_EN            = 0x2        // Bit WR_EN.
	USB_CTRL_WR_EN_DISABLED_  = 0x0        // Disabled.
	USB_CTRL_WR_EN_ENABLED_   = 0x1        // Enabled.
	USB_CTRL_LOG_ENDPOINT_Pos = 0x2        // Position of LOG_ENDPOINT field.
	USB_CTRL_LOG_ENDPOINT_Msk = 0x3c       // Bit mask of LOG_ENDPOINT field.
	USB_CTRL_RESERVED_Pos     = 0x6        // Position of RESERVED field.
	USB_CTRL_RESERVED_Msk     = 0xffffffc0 // Bit mask of RESERVED field.

	// DEVINTPRI: USB Device Interrupt Priority
	USB_DEVINTPRI_FRAME_Pos    = 0x0        // Position of FRAME field.
	USB_DEVINTPRI_FRAME_Msk    = 0x1        // Bit mask of FRAME field.
	USB_DEVINTPRI_FRAME        = 0x1        // Bit FRAME.
	USB_DEVINTPRI_FRAME_LP     = 0x0        // FRAME interrupt is routed to USB_INT_REQ_LP.
	USB_DEVINTPRI_FRAME_HP     = 0x1        // FRAME interrupt is routed to USB_INT_REQ_HP.
	USB_DEVINTPRI_EP_FAST_Pos  = 0x1        // Position of EP_FAST field.
	USB_DEVINTPRI_EP_FAST_Msk  = 0x2        // Bit mask of EP_FAST field.
	USB_DEVINTPRI_EP_FAST      = 0x2        // Bit EP_FAST.
	USB_DEVINTPRI_EP_FAST_LP   = 0x0        // EP_FAST interrupt is routed to USB_INT_REQ_LP.
	USB_DEVINTPRI_EP_FAST_HP   = 0x1        // EP_FAST interrupt is routed to USB_INT_REQ_HP.
	USB_DEVINTPRI_RESERVED_Pos = 0x2        // Position of RESERVED field.
	USB_DEVINTPRI_RESERVED_Msk = 0xfffffffc // Bit mask of RESERVED field.

	// EPINTST: USB Endpoint Interrupt Status
	USB_EPINTST_EPST0_Pos  = 0x0        // Position of EPST0 field.
	USB_EPINTST_EPST0_Msk  = 0x1        // Bit mask of EPST0 field.
	USB_EPINTST_EPST0      = 0x1        // Bit EPST0.
	USB_EPINTST_EPST1_Pos  = 0x1        // Position of EPST1 field.
	USB_EPINTST_EPST1_Msk  = 0x2        // Bit mask of EPST1 field.
	USB_EPINTST_EPST1      = 0x2        // Bit EPST1.
	USB_EPINTST_EPST2_Pos  = 0x2        // Position of EPST2 field.
	USB_EPINTST_EPST2_Msk  = 0x4        // Bit mask of EPST2 field.
	USB_EPINTST_EPST2      = 0x4        // Bit EPST2.
	USB_EPINTST_EPST3_Pos  = 0x3        // Position of EPST3 field.
	USB_EPINTST_EPST3_Msk  = 0x8        // Bit mask of EPST3 field.
	USB_EPINTST_EPST3      = 0x8        // Bit EPST3.
	USB_EPINTST_EPST4_Pos  = 0x4        // Position of EPST4 field.
	USB_EPINTST_EPST4_Msk  = 0x10       // Bit mask of EPST4 field.
	USB_EPINTST_EPST4      = 0x10       // Bit EPST4.
	USB_EPINTST_EPST5_Pos  = 0x5        // Position of EPST5 field.
	USB_EPINTST_EPST5_Msk  = 0x20       // Bit mask of EPST5 field.
	USB_EPINTST_EPST5      = 0x20       // Bit EPST5.
	USB_EPINTST_EPST6_Pos  = 0x6        // Position of EPST6 field.
	USB_EPINTST_EPST6_Msk  = 0x40       // Bit mask of EPST6 field.
	USB_EPINTST_EPST6      = 0x40       // Bit EPST6.
	USB_EPINTST_EPST7_Pos  = 0x7        // Position of EPST7 field.
	USB_EPINTST_EPST7_Msk  = 0x80       // Bit mask of EPST7 field.
	USB_EPINTST_EPST7      = 0x80       // Bit EPST7.
	USB_EPINTST_EPST8_Pos  = 0x8        // Position of EPST8 field.
	USB_EPINTST_EPST8_Msk  = 0x100      // Bit mask of EPST8 field.
	USB_EPINTST_EPST8      = 0x100      // Bit EPST8.
	USB_EPINTST_EPST9_Pos  = 0x9        // Position of EPST9 field.
	USB_EPINTST_EPST9_Msk  = 0x200      // Bit mask of EPST9 field.
	USB_EPINTST_EPST9      = 0x200      // Bit EPST9.
	USB_EPINTST_EPST10_Pos = 0xa        // Position of EPST10 field.
	USB_EPINTST_EPST10_Msk = 0x400      // Bit mask of EPST10 field.
	USB_EPINTST_EPST10     = 0x400      // Bit EPST10.
	USB_EPINTST_EPST11_Pos = 0xb        // Position of EPST11 field.
	USB_EPINTST_EPST11_Msk = 0x800      // Bit mask of EPST11 field.
	USB_EPINTST_EPST11     = 0x800      // Bit EPST11.
	USB_EPINTST_EPST12_Pos = 0xc        // Position of EPST12 field.
	USB_EPINTST_EPST12_Msk = 0x1000     // Bit mask of EPST12 field.
	USB_EPINTST_EPST12     = 0x1000     // Bit EPST12.
	USB_EPINTST_EPST13_Pos = 0xd        // Position of EPST13 field.
	USB_EPINTST_EPST13_Msk = 0x2000     // Bit mask of EPST13 field.
	USB_EPINTST_EPST13     = 0x2000     // Bit EPST13.
	USB_EPINTST_EPST14_Pos = 0xe        // Position of EPST14 field.
	USB_EPINTST_EPST14_Msk = 0x4000     // Bit mask of EPST14 field.
	USB_EPINTST_EPST14     = 0x4000     // Bit EPST14.
	USB_EPINTST_EPST15_Pos = 0xf        // Position of EPST15 field.
	USB_EPINTST_EPST15_Msk = 0x8000     // Bit mask of EPST15 field.
	USB_EPINTST_EPST15     = 0x8000     // Bit EPST15.
	USB_EPINTST_EPST16_Pos = 0x10       // Position of EPST16 field.
	USB_EPINTST_EPST16_Msk = 0x10000    // Bit mask of EPST16 field.
	USB_EPINTST_EPST16     = 0x10000    // Bit EPST16.
	USB_EPINTST_EPST17_Pos = 0x11       // Position of EPST17 field.
	USB_EPINTST_EPST17_Msk = 0x20000    // Bit mask of EPST17 field.
	USB_EPINTST_EPST17     = 0x20000    // Bit EPST17.
	USB_EPINTST_EPST18_Pos = 0x12       // Position of EPST18 field.
	USB_EPINTST_EPST18_Msk = 0x40000    // Bit mask of EPST18 field.
	USB_EPINTST_EPST18     = 0x40000    // Bit EPST18.
	USB_EPINTST_EPST19_Pos = 0x13       // Position of EPST19 field.
	USB_EPINTST_EPST19_Msk = 0x80000    // Bit mask of EPST19 field.
	USB_EPINTST_EPST19     = 0x80000    // Bit EPST19.
	USB_EPINTST_EPST20_Pos = 0x14       // Position of EPST20 field.
	USB_EPINTST_EPST20_Msk = 0x100000   // Bit mask of EPST20 field.
	USB_EPINTST_EPST20     = 0x100000   // Bit EPST20.
	USB_EPINTST_EPST21_Pos = 0x15       // Position of EPST21 field.
	USB_EPINTST_EPST21_Msk = 0x200000   // Bit mask of EPST21 field.
	USB_EPINTST_EPST21     = 0x200000   // Bit EPST21.
	USB_EPINTST_EPST22_Pos = 0x16       // Position of EPST22 field.
	USB_EPINTST_EPST22_Msk = 0x400000   // Bit mask of EPST22 field.
	USB_EPINTST_EPST22     = 0x400000   // Bit EPST22.
	USB_EPINTST_EPST23_Pos = 0x17       // Position of EPST23 field.
	USB_EPINTST_EPST23_Msk = 0x800000   // Bit mask of EPST23 field.
	USB_EPINTST_EPST23     = 0x800000   // Bit EPST23.
	USB_EPINTST_EPST24_Pos = 0x18       // Position of EPST24 field.
	USB_EPINTST_EPST24_Msk = 0x1000000  // Bit mask of EPST24 field.
	USB_EPINTST_EPST24     = 0x1000000  // Bit EPST24.
	USB_EPINTST_EPST25_Pos = 0x19       // Position of EPST25 field.
	USB_EPINTST_EPST25_Msk = 0x2000000  // Bit mask of EPST25 field.
	USB_EPINTST_EPST25     = 0x2000000  // Bit EPST25.
	USB_EPINTST_EPST26_Pos = 0x1a       // Position of EPST26 field.
	USB_EPINTST_EPST26_Msk = 0x4000000  // Bit mask of EPST26 field.
	USB_EPINTST_EPST26     = 0x4000000  // Bit EPST26.
	USB_EPINTST_EPST27_Pos = 0x1b       // Position of EPST27 field.
	USB_EPINTST_EPST27_Msk = 0x8000000  // Bit mask of EPST27 field.
	USB_EPINTST_EPST27     = 0x8000000  // Bit EPST27.
	USB_EPINTST_EPST28_Pos = 0x1c       // Position of EPST28 field.
	USB_EPINTST_EPST28_Msk = 0x10000000 // Bit mask of EPST28 field.
	USB_EPINTST_EPST28     = 0x10000000 // Bit EPST28.
	USB_EPINTST_EPST29_Pos = 0x1d       // Position of EPST29 field.
	USB_EPINTST_EPST29_Msk = 0x20000000 // Bit mask of EPST29 field.
	USB_EPINTST_EPST29     = 0x20000000 // Bit EPST29.
	USB_EPINTST_EPST30_Pos = 0x1e       // Position of EPST30 field.
	USB_EPINTST_EPST30_Msk = 0x40000000 // Bit mask of EPST30 field.
	USB_EPINTST_EPST30     = 0x40000000 // Bit EPST30.
	USB_EPINTST_EPST31_Pos = 0x1f       // Position of EPST31 field.
	USB_EPINTST_EPST31_Msk = 0x80000000 // Bit mask of EPST31 field.
	USB_EPINTST_EPST31     = 0x80000000 // Bit EPST31.

	// EPINTEN: USB Endpoint Interrupt Enable
	USB_EPINTEN_EPEN0_Pos  = 0x0        // Position of EPEN0 field.
	USB_EPINTEN_EPEN0_Msk  = 0x1        // Bit mask of EPEN0 field.
	USB_EPINTEN_EPEN0      = 0x1        // Bit EPEN0.
	USB_EPINTEN_EPEN1_Pos  = 0x1        // Position of EPEN1 field.
	USB_EPINTEN_EPEN1_Msk  = 0x2        // Bit mask of EPEN1 field.
	USB_EPINTEN_EPEN1      = 0x2        // Bit EPEN1.
	USB_EPINTEN_EPEN2_Pos  = 0x2        // Position of EPEN2 field.
	USB_EPINTEN_EPEN2_Msk  = 0x4        // Bit mask of EPEN2 field.
	USB_EPINTEN_EPEN2      = 0x4        // Bit EPEN2.
	USB_EPINTEN_EPEN3_Pos  = 0x3        // Position of EPEN3 field.
	USB_EPINTEN_EPEN3_Msk  = 0x8        // Bit mask of EPEN3 field.
	USB_EPINTEN_EPEN3      = 0x8        // Bit EPEN3.
	USB_EPINTEN_EPEN4_Pos  = 0x4        // Position of EPEN4 field.
	USB_EPINTEN_EPEN4_Msk  = 0x10       // Bit mask of EPEN4 field.
	USB_EPINTEN_EPEN4      = 0x10       // Bit EPEN4.
	USB_EPINTEN_EPEN5_Pos  = 0x5        // Position of EPEN5 field.
	USB_EPINTEN_EPEN5_Msk  = 0x20       // Bit mask of EPEN5 field.
	USB_EPINTEN_EPEN5      = 0x20       // Bit EPEN5.
	USB_EPINTEN_EPEN6_Pos  = 0x6        // Position of EPEN6 field.
	USB_EPINTEN_EPEN6_Msk  = 0x40       // Bit mask of EPEN6 field.
	USB_EPINTEN_EPEN6      = 0x40       // Bit EPEN6.
	USB_EPINTEN_EPEN7_Pos  = 0x7        // Position of EPEN7 field.
	USB_EPINTEN_EPEN7_Msk  = 0x80       // Bit mask of EPEN7 field.
	USB_EPINTEN_EPEN7      = 0x80       // Bit EPEN7.
	USB_EPINTEN_EPEN8_Pos  = 0x8        // Position of EPEN8 field.
	USB_EPINTEN_EPEN8_Msk  = 0x100      // Bit mask of EPEN8 field.
	USB_EPINTEN_EPEN8      = 0x100      // Bit EPEN8.
	USB_EPINTEN_EPEN9_Pos  = 0x9        // Position of EPEN9 field.
	USB_EPINTEN_EPEN9_Msk  = 0x200      // Bit mask of EPEN9 field.
	USB_EPINTEN_EPEN9      = 0x200      // Bit EPEN9.
	USB_EPINTEN_EPEN10_Pos = 0xa        // Position of EPEN10 field.
	USB_EPINTEN_EPEN10_Msk = 0x400      // Bit mask of EPEN10 field.
	USB_EPINTEN_EPEN10     = 0x400      // Bit EPEN10.
	USB_EPINTEN_EPEN11_Pos = 0xb        // Position of EPEN11 field.
	USB_EPINTEN_EPEN11_Msk = 0x800      // Bit mask of EPEN11 field.
	USB_EPINTEN_EPEN11     = 0x800      // Bit EPEN11.
	USB_EPINTEN_EPEN12_Pos = 0xc        // Position of EPEN12 field.
	USB_EPINTEN_EPEN12_Msk = 0x1000     // Bit mask of EPEN12 field.
	USB_EPINTEN_EPEN12     = 0x1000     // Bit EPEN12.
	USB_EPINTEN_EPEN13_Pos = 0xd        // Position of EPEN13 field.
	USB_EPINTEN_EPEN13_Msk = 0x2000     // Bit mask of EPEN13 field.
	USB_EPINTEN_EPEN13     = 0x2000     // Bit EPEN13.
	USB_EPINTEN_EPEN14_Pos = 0xe        // Position of EPEN14 field.
	USB_EPINTEN_EPEN14_Msk = 0x4000     // Bit mask of EPEN14 field.
	USB_EPINTEN_EPEN14     = 0x4000     // Bit EPEN14.
	USB_EPINTEN_EPEN15_Pos = 0xf        // Position of EPEN15 field.
	USB_EPINTEN_EPEN15_Msk = 0x8000     // Bit mask of EPEN15 field.
	USB_EPINTEN_EPEN15     = 0x8000     // Bit EPEN15.
	USB_EPINTEN_EPEN16_Pos = 0x10       // Position of EPEN16 field.
	USB_EPINTEN_EPEN16_Msk = 0x10000    // Bit mask of EPEN16 field.
	USB_EPINTEN_EPEN16     = 0x10000    // Bit EPEN16.
	USB_EPINTEN_EPEN17_Pos = 0x11       // Position of EPEN17 field.
	USB_EPINTEN_EPEN17_Msk = 0x20000    // Bit mask of EPEN17 field.
	USB_EPINTEN_EPEN17     = 0x20000    // Bit EPEN17.
	USB_EPINTEN_EPEN18_Pos = 0x12       // Position of EPEN18 field.
	USB_EPINTEN_EPEN18_Msk = 0x40000    // Bit mask of EPEN18 field.
	USB_EPINTEN_EPEN18     = 0x40000    // Bit EPEN18.
	USB_EPINTEN_EPEN19_Pos = 0x13       // Position of EPEN19 field.
	USB_EPINTEN_EPEN19_Msk = 0x80000    // Bit mask of EPEN19 field.
	USB_EPINTEN_EPEN19     = 0x80000    // Bit EPEN19.
	USB_EPINTEN_EPEN20_Pos = 0x14       // Position of EPEN20 field.
	USB_EPINTEN_EPEN20_Msk = 0x100000   // Bit mask of EPEN20 field.
	USB_EPINTEN_EPEN20     = 0x100000   // Bit EPEN20.
	USB_EPINTEN_EPEN21_Pos = 0x15       // Position of EPEN21 field.
	USB_EPINTEN_EPEN21_Msk = 0x200000   // Bit mask of EPEN21 field.
	USB_EPINTEN_EPEN21     = 0x200000   // Bit EPEN21.
	USB_EPINTEN_EPEN22_Pos = 0x16       // Position of EPEN22 field.
	USB_EPINTEN_EPEN22_Msk = 0x400000   // Bit mask of EPEN22 field.
	USB_EPINTEN_EPEN22     = 0x400000   // Bit EPEN22.
	USB_EPINTEN_EPEN23_Pos = 0x17       // Position of EPEN23 field.
	USB_EPINTEN_EPEN23_Msk = 0x800000   // Bit mask of EPEN23 field.
	USB_EPINTEN_EPEN23     = 0x800000   // Bit EPEN23.
	USB_EPINTEN_EPEN24_Pos = 0x18       // Position of EPEN24 field.
	USB_EPINTEN_EPEN24_Msk = 0x1000000  // Bit mask of EPEN24 field.
	USB_EPINTEN_EPEN24     = 0x1000000  // Bit EPEN24.
	USB_EPINTEN_EPEN25_Pos = 0x19       // Position of EPEN25 field.
	USB_EPINTEN_EPEN25_Msk = 0x2000000  // Bit mask of EPEN25 field.
	USB_EPINTEN_EPEN25     = 0x2000000  // Bit EPEN25.
	USB_EPINTEN_EPEN26_Pos = 0x1a       // Position of EPEN26 field.
	USB_EPINTEN_EPEN26_Msk = 0x4000000  // Bit mask of EPEN26 field.
	USB_EPINTEN_EPEN26     = 0x4000000  // Bit EPEN26.
	USB_EPINTEN_EPEN27_Pos = 0x1b       // Position of EPEN27 field.
	USB_EPINTEN_EPEN27_Msk = 0x8000000  // Bit mask of EPEN27 field.
	USB_EPINTEN_EPEN27     = 0x8000000  // Bit EPEN27.
	USB_EPINTEN_EPEN28_Pos = 0x1c       // Position of EPEN28 field.
	USB_EPINTEN_EPEN28_Msk = 0x10000000 // Bit mask of EPEN28 field.
	USB_EPINTEN_EPEN28     = 0x10000000 // Bit EPEN28.
	USB_EPINTEN_EPEN29_Pos = 0x1d       // Position of EPEN29 field.
	USB_EPINTEN_EPEN29_Msk = 0x20000000 // Bit mask of EPEN29 field.
	USB_EPINTEN_EPEN29     = 0x20000000 // Bit EPEN29.
	USB_EPINTEN_EPEN30_Pos = 0x1e       // Position of EPEN30 field.
	USB_EPINTEN_EPEN30_Msk = 0x40000000 // Bit mask of EPEN30 field.
	USB_EPINTEN_EPEN30     = 0x40000000 // Bit EPEN30.
	USB_EPINTEN_EPEN31_Pos = 0x1f       // Position of EPEN31 field.
	USB_EPINTEN_EPEN31_Msk = 0x80000000 // Bit mask of EPEN31 field.
	USB_EPINTEN_EPEN31     = 0x80000000 // Bit EPEN31.

	// EPINTCLR: USB Endpoint Interrupt Clear
	USB_EPINTCLR_EPCLR0_Pos  = 0x0        // Position of EPCLR0 field.
	USB_EPINTCLR_EPCLR0_Msk  = 0x1        // Bit mask of EPCLR0 field.
	USB_EPINTCLR_EPCLR0      = 0x1        // Bit EPCLR0.
	USB_EPINTCLR_EPCLR1_Pos  = 0x1        // Position of EPCLR1 field.
	USB_EPINTCLR_EPCLR1_Msk  = 0x2        // Bit mask of EPCLR1 field.
	USB_EPINTCLR_EPCLR1      = 0x2        // Bit EPCLR1.
	USB_EPINTCLR_EPCLR2_Pos  = 0x2        // Position of EPCLR2 field.
	USB_EPINTCLR_EPCLR2_Msk  = 0x4        // Bit mask of EPCLR2 field.
	USB_EPINTCLR_EPCLR2      = 0x4        // Bit EPCLR2.
	USB_EPINTCLR_EPCLR3_Pos  = 0x3        // Position of EPCLR3 field.
	USB_EPINTCLR_EPCLR3_Msk  = 0x8        // Bit mask of EPCLR3 field.
	USB_EPINTCLR_EPCLR3      = 0x8        // Bit EPCLR3.
	USB_EPINTCLR_EPCLR4_Pos  = 0x4        // Position of EPCLR4 field.
	USB_EPINTCLR_EPCLR4_Msk  = 0x10       // Bit mask of EPCLR4 field.
	USB_EPINTCLR_EPCLR4      = 0x10       // Bit EPCLR4.
	USB_EPINTCLR_EPCLR5_Pos  = 0x5        // Position of EPCLR5 field.
	USB_EPINTCLR_EPCLR5_Msk  = 0x20       // Bit mask of EPCLR5 field.
	USB_EPINTCLR_EPCLR5      = 0x20       // Bit EPCLR5.
	USB_EPINTCLR_EPCLR6_Pos  = 0x6        // Position of EPCLR6 field.
	USB_EPINTCLR_EPCLR6_Msk  = 0x40       // Bit mask of EPCLR6 field.
	USB_EPINTCLR_EPCLR6      = 0x40       // Bit EPCLR6.
	USB_EPINTCLR_EPCLR7_Pos  = 0x7        // Position of EPCLR7 field.
	USB_EPINTCLR_EPCLR7_Msk  = 0x80       // Bit mask of EPCLR7 field.
	USB_EPINTCLR_EPCLR7      = 0x80       // Bit EPCLR7.
	USB_EPINTCLR_EPCLR8_Pos  = 0x8        // Position of EPCLR8 field.
	USB_EPINTCLR_EPCLR8_Msk  = 0x100      // Bit mask of EPCLR8 field.
	USB_EPINTCLR_EPCLR8      = 0x100      // Bit EPCLR8.
	USB_EPINTCLR_EPCLR9_Pos  = 0x9        // Position of EPCLR9 field.
	USB_EPINTCLR_EPCLR9_Msk  = 0x200      // Bit mask of EPCLR9 field.
	USB_EPINTCLR_EPCLR9      = 0x200      // Bit EPCLR9.
	USB_EPINTCLR_EPCLR10_Pos = 0xa        // Position of EPCLR10 field.
	USB_EPINTCLR_EPCLR10_Msk = 0x400      // Bit mask of EPCLR10 field.
	USB_EPINTCLR_EPCLR10     = 0x400      // Bit EPCLR10.
	USB_EPINTCLR_EPCLR11_Pos = 0xb        // Position of EPCLR11 field.
	USB_EPINTCLR_EPCLR11_Msk = 0x800      // Bit mask of EPCLR11 field.
	USB_EPINTCLR_EPCLR11     = 0x800      // Bit EPCLR11.
	USB_EPINTCLR_EPCLR12_Pos = 0xc        // Position of EPCLR12 field.
	USB_EPINTCLR_EPCLR12_Msk = 0x1000     // Bit mask of EPCLR12 field.
	USB_EPINTCLR_EPCLR12     = 0x1000     // Bit EPCLR12.
	USB_EPINTCLR_EPCLR13_Pos = 0xd        // Position of EPCLR13 field.
	USB_EPINTCLR_EPCLR13_Msk = 0x2000     // Bit mask of EPCLR13 field.
	USB_EPINTCLR_EPCLR13     = 0x2000     // Bit EPCLR13.
	USB_EPINTCLR_EPCLR14_Pos = 0xe        // Position of EPCLR14 field.
	USB_EPINTCLR_EPCLR14_Msk = 0x4000     // Bit mask of EPCLR14 field.
	USB_EPINTCLR_EPCLR14     = 0x4000     // Bit EPCLR14.
	USB_EPINTCLR_EPCLR15_Pos = 0xf        // Position of EPCLR15 field.
	USB_EPINTCLR_EPCLR15_Msk = 0x8000     // Bit mask of EPCLR15 field.
	USB_EPINTCLR_EPCLR15     = 0x8000     // Bit EPCLR15.
	USB_EPINTCLR_EPCLR16_Pos = 0x10       // Position of EPCLR16 field.
	USB_EPINTCLR_EPCLR16_Msk = 0x10000    // Bit mask of EPCLR16 field.
	USB_EPINTCLR_EPCLR16     = 0x10000    // Bit EPCLR16.
	USB_EPINTCLR_EPCLR17_Pos = 0x11       // Position of EPCLR17 field.
	USB_EPINTCLR_EPCLR17_Msk = 0x20000    // Bit mask of EPCLR17 field.
	USB_EPINTCLR_EPCLR17     = 0x20000    // Bit EPCLR17.
	USB_EPINTCLR_EPCLR18_Pos = 0x12       // Position of EPCLR18 field.
	USB_EPINTCLR_EPCLR18_Msk = 0x40000    // Bit mask of EPCLR18 field.
	USB_EPINTCLR_EPCLR18     = 0x40000    // Bit EPCLR18.
	USB_EPINTCLR_EPCLR19_Pos = 0x13       // Position of EPCLR19 field.
	USB_EPINTCLR_EPCLR19_Msk = 0x80000    // Bit mask of EPCLR19 field.
	USB_EPINTCLR_EPCLR19     = 0x80000    // Bit EPCLR19.
	USB_EPINTCLR_EPCLR20_Pos = 0x14       // Position of EPCLR20 field.
	USB_EPINTCLR_EPCLR20_Msk = 0x100000   // Bit mask of EPCLR20 field.
	USB_EPINTCLR_EPCLR20     = 0x100000   // Bit EPCLR20.
	USB_EPINTCLR_EPCLR21_Pos = 0x15       // Position of EPCLR21 field.
	USB_EPINTCLR_EPCLR21_Msk = 0x200000   // Bit mask of EPCLR21 field.
	USB_EPINTCLR_EPCLR21     = 0x200000   // Bit EPCLR21.
	USB_EPINTCLR_EPCLR22_Pos = 0x16       // Position of EPCLR22 field.
	USB_EPINTCLR_EPCLR22_Msk = 0x400000   // Bit mask of EPCLR22 field.
	USB_EPINTCLR_EPCLR22     = 0x400000   // Bit EPCLR22.
	USB_EPINTCLR_EPCLR23_Pos = 0x17       // Position of EPCLR23 field.
	USB_EPINTCLR_EPCLR23_Msk = 0x800000   // Bit mask of EPCLR23 field.
	USB_EPINTCLR_EPCLR23     = 0x800000   // Bit EPCLR23.
	USB_EPINTCLR_EPCLR24_Pos = 0x18       // Position of EPCLR24 field.
	USB_EPINTCLR_EPCLR24_Msk = 0x1000000  // Bit mask of EPCLR24 field.
	USB_EPINTCLR_EPCLR24     = 0x1000000  // Bit EPCLR24.
	USB_EPINTCLR_EPCLR25_Pos = 0x19       // Position of EPCLR25 field.
	USB_EPINTCLR_EPCLR25_Msk = 0x2000000  // Bit mask of EPCLR25 field.
	USB_EPINTCLR_EPCLR25     = 0x2000000  // Bit EPCLR25.
	USB_EPINTCLR_EPCLR26_Pos = 0x1a       // Position of EPCLR26 field.
	USB_EPINTCLR_EPCLR26_Msk = 0x4000000  // Bit mask of EPCLR26 field.
	USB_EPINTCLR_EPCLR26     = 0x4000000  // Bit EPCLR26.
	USB_EPINTCLR_EPCLR27_Pos = 0x1b       // Position of EPCLR27 field.
	USB_EPINTCLR_EPCLR27_Msk = 0x8000000  // Bit mask of EPCLR27 field.
	USB_EPINTCLR_EPCLR27     = 0x8000000  // Bit EPCLR27.
	USB_EPINTCLR_EPCLR28_Pos = 0x1c       // Position of EPCLR28 field.
	USB_EPINTCLR_EPCLR28_Msk = 0x10000000 // Bit mask of EPCLR28 field.
	USB_EPINTCLR_EPCLR28     = 0x10000000 // Bit EPCLR28.
	USB_EPINTCLR_EPCLR29_Pos = 0x1d       // Position of EPCLR29 field.
	USB_EPINTCLR_EPCLR29_Msk = 0x20000000 // Bit mask of EPCLR29 field.
	USB_EPINTCLR_EPCLR29     = 0x20000000 // Bit EPCLR29.
	USB_EPINTCLR_EPCLR30_Pos = 0x1e       // Position of EPCLR30 field.
	USB_EPINTCLR_EPCLR30_Msk = 0x40000000 // Bit mask of EPCLR30 field.
	USB_EPINTCLR_EPCLR30     = 0x40000000 // Bit EPCLR30.
	USB_EPINTCLR_EPCLR31_Pos = 0x1f       // Position of EPCLR31 field.
	USB_EPINTCLR_EPCLR31_Msk = 0x80000000 // Bit mask of EPCLR31 field.
	USB_EPINTCLR_EPCLR31     = 0x80000000 // Bit EPCLR31.

	// EPINTSET: USB Endpoint Interrupt Set
	USB_EPINTSET_EPSET0_Pos  = 0x0        // Position of EPSET0 field.
	USB_EPINTSET_EPSET0_Msk  = 0x1        // Bit mask of EPSET0 field.
	USB_EPINTSET_EPSET0      = 0x1        // Bit EPSET0.
	USB_EPINTSET_EPSET1_Pos  = 0x1        // Position of EPSET1 field.
	USB_EPINTSET_EPSET1_Msk  = 0x2        // Bit mask of EPSET1 field.
	USB_EPINTSET_EPSET1      = 0x2        // Bit EPSET1.
	USB_EPINTSET_EPSET2_Pos  = 0x2        // Position of EPSET2 field.
	USB_EPINTSET_EPSET2_Msk  = 0x4        // Bit mask of EPSET2 field.
	USB_EPINTSET_EPSET2      = 0x4        // Bit EPSET2.
	USB_EPINTSET_EPSET3_Pos  = 0x3        // Position of EPSET3 field.
	USB_EPINTSET_EPSET3_Msk  = 0x8        // Bit mask of EPSET3 field.
	USB_EPINTSET_EPSET3      = 0x8        // Bit EPSET3.
	USB_EPINTSET_EPSET4_Pos  = 0x4        // Position of EPSET4 field.
	USB_EPINTSET_EPSET4_Msk  = 0x10       // Bit mask of EPSET4 field.
	USB_EPINTSET_EPSET4      = 0x10       // Bit EPSET4.
	USB_EPINTSET_EPSET5_Pos  = 0x5        // Position of EPSET5 field.
	USB_EPINTSET_EPSET5_Msk  = 0x20       // Bit mask of EPSET5 field.
	USB_EPINTSET_EPSET5      = 0x20       // Bit EPSET5.
	USB_EPINTSET_EPSET6_Pos  = 0x6        // Position of EPSET6 field.
	USB_EPINTSET_EPSET6_Msk  = 0x40       // Bit mask of EPSET6 field.
	USB_EPINTSET_EPSET6      = 0x40       // Bit EPSET6.
	USB_EPINTSET_EPSET7_Pos  = 0x7        // Position of EPSET7 field.
	USB_EPINTSET_EPSET7_Msk  = 0x80       // Bit mask of EPSET7 field.
	USB_EPINTSET_EPSET7      = 0x80       // Bit EPSET7.
	USB_EPINTSET_EPSET8_Pos  = 0x8        // Position of EPSET8 field.
	USB_EPINTSET_EPSET8_Msk  = 0x100      // Bit mask of EPSET8 field.
	USB_EPINTSET_EPSET8      = 0x100      // Bit EPSET8.
	USB_EPINTSET_EPSET9_Pos  = 0x9        // Position of EPSET9 field.
	USB_EPINTSET_EPSET9_Msk  = 0x200      // Bit mask of EPSET9 field.
	USB_EPINTSET_EPSET9      = 0x200      // Bit EPSET9.
	USB_EPINTSET_EPSET10_Pos = 0xa        // Position of EPSET10 field.
	USB_EPINTSET_EPSET10_Msk = 0x400      // Bit mask of EPSET10 field.
	USB_EPINTSET_EPSET10     = 0x400      // Bit EPSET10.
	USB_EPINTSET_EPSET11_Pos = 0xb        // Position of EPSET11 field.
	USB_EPINTSET_EPSET11_Msk = 0x800      // Bit mask of EPSET11 field.
	USB_EPINTSET_EPSET11     = 0x800      // Bit EPSET11.
	USB_EPINTSET_EPSET12_Pos = 0xc        // Position of EPSET12 field.
	USB_EPINTSET_EPSET12_Msk = 0x1000     // Bit mask of EPSET12 field.
	USB_EPINTSET_EPSET12     = 0x1000     // Bit EPSET12.
	USB_EPINTSET_EPSET13_Pos = 0xd        // Position of EPSET13 field.
	USB_EPINTSET_EPSET13_Msk = 0x2000     // Bit mask of EPSET13 field.
	USB_EPINTSET_EPSET13     = 0x2000     // Bit EPSET13.
	USB_EPINTSET_EPSET14_Pos = 0xe        // Position of EPSET14 field.
	USB_EPINTSET_EPSET14_Msk = 0x4000     // Bit mask of EPSET14 field.
	USB_EPINTSET_EPSET14     = 0x4000     // Bit EPSET14.
	USB_EPINTSET_EPSET15_Pos = 0xf        // Position of EPSET15 field.
	USB_EPINTSET_EPSET15_Msk = 0x8000     // Bit mask of EPSET15 field.
	USB_EPINTSET_EPSET15     = 0x8000     // Bit EPSET15.
	USB_EPINTSET_EPSET16_Pos = 0x10       // Position of EPSET16 field.
	USB_EPINTSET_EPSET16_Msk = 0x10000    // Bit mask of EPSET16 field.
	USB_EPINTSET_EPSET16     = 0x10000    // Bit EPSET16.
	USB_EPINTSET_EPSET17_Pos = 0x11       // Position of EPSET17 field.
	USB_EPINTSET_EPSET17_Msk = 0x20000    // Bit mask of EPSET17 field.
	USB_EPINTSET_EPSET17     = 0x20000    // Bit EPSET17.
	USB_EPINTSET_EPSET18_Pos = 0x12       // Position of EPSET18 field.
	USB_EPINTSET_EPSET18_Msk = 0x40000    // Bit mask of EPSET18 field.
	USB_EPINTSET_EPSET18     = 0x40000    // Bit EPSET18.
	USB_EPINTSET_EPSET19_Pos = 0x13       // Position of EPSET19 field.
	USB_EPINTSET_EPSET19_Msk = 0x80000    // Bit mask of EPSET19 field.
	USB_EPINTSET_EPSET19     = 0x80000    // Bit EPSET19.
	USB_EPINTSET_EPSET20_Pos = 0x14       // Position of EPSET20 field.
	USB_EPINTSET_EPSET20_Msk = 0x100000   // Bit mask of EPSET20 field.
	USB_EPINTSET_EPSET20     = 0x100000   // Bit EPSET20.
	USB_EPINTSET_EPSET21_Pos = 0x15       // Position of EPSET21 field.
	USB_EPINTSET_EPSET21_Msk = 0x200000   // Bit mask of EPSET21 field.
	USB_EPINTSET_EPSET21     = 0x200000   // Bit EPSET21.
	USB_EPINTSET_EPSET22_Pos = 0x16       // Position of EPSET22 field.
	USB_EPINTSET_EPSET22_Msk = 0x400000   // Bit mask of EPSET22 field.
	USB_EPINTSET_EPSET22     = 0x400000   // Bit EPSET22.
	USB_EPINTSET_EPSET23_Pos = 0x17       // Position of EPSET23 field.
	USB_EPINTSET_EPSET23_Msk = 0x800000   // Bit mask of EPSET23 field.
	USB_EPINTSET_EPSET23     = 0x800000   // Bit EPSET23.
	USB_EPINTSET_EPSET24_Pos = 0x18       // Position of EPSET24 field.
	USB_EPINTSET_EPSET24_Msk = 0x1000000  // Bit mask of EPSET24 field.
	USB_EPINTSET_EPSET24     = 0x1000000  // Bit EPSET24.
	USB_EPINTSET_EPSET25_Pos = 0x19       // Position of EPSET25 field.
	USB_EPINTSET_EPSET25_Msk = 0x2000000  // Bit mask of EPSET25 field.
	USB_EPINTSET_EPSET25     = 0x2000000  // Bit EPSET25.
	USB_EPINTSET_EPSET26_Pos = 0x1a       // Position of EPSET26 field.
	USB_EPINTSET_EPSET26_Msk = 0x4000000  // Bit mask of EPSET26 field.
	USB_EPINTSET_EPSET26     = 0x4000000  // Bit EPSET26.
	USB_EPINTSET_EPSET27_Pos = 0x1b       // Position of EPSET27 field.
	USB_EPINTSET_EPSET27_Msk = 0x8000000  // Bit mask of EPSET27 field.
	USB_EPINTSET_EPSET27     = 0x8000000  // Bit EPSET27.
	USB_EPINTSET_EPSET28_Pos = 0x1c       // Position of EPSET28 field.
	USB_EPINTSET_EPSET28_Msk = 0x10000000 // Bit mask of EPSET28 field.
	USB_EPINTSET_EPSET28     = 0x10000000 // Bit EPSET28.
	USB_EPINTSET_EPSET29_Pos = 0x1d       // Position of EPSET29 field.
	USB_EPINTSET_EPSET29_Msk = 0x20000000 // Bit mask of EPSET29 field.
	USB_EPINTSET_EPSET29     = 0x20000000 // Bit EPSET29.
	USB_EPINTSET_EPSET30_Pos = 0x1e       // Position of EPSET30 field.
	USB_EPINTSET_EPSET30_Msk = 0x40000000 // Bit mask of EPSET30 field.
	USB_EPINTSET_EPSET30     = 0x40000000 // Bit EPSET30.
	USB_EPINTSET_EPSET31_Pos = 0x1f       // Position of EPSET31 field.
	USB_EPINTSET_EPSET31_Msk = 0x80000000 // Bit mask of EPSET31 field.
	USB_EPINTSET_EPSET31     = 0x80000000 // Bit EPSET31.

	// EPINTPRI: USB Endpoint Priority
	USB_EPINTPRI_EPPRI0_Pos  = 0x0        // Position of EPPRI0 field.
	USB_EPINTPRI_EPPRI0_Msk  = 0x1        // Bit mask of EPPRI0 field.
	USB_EPINTPRI_EPPRI0      = 0x1        // Bit EPPRI0.
	USB_EPINTPRI_EPPRI1_Pos  = 0x1        // Position of EPPRI1 field.
	USB_EPINTPRI_EPPRI1_Msk  = 0x2        // Bit mask of EPPRI1 field.
	USB_EPINTPRI_EPPRI1      = 0x2        // Bit EPPRI1.
	USB_EPINTPRI_EPPRI2_Pos  = 0x2        // Position of EPPRI2 field.
	USB_EPINTPRI_EPPRI2_Msk  = 0x4        // Bit mask of EPPRI2 field.
	USB_EPINTPRI_EPPRI2      = 0x4        // Bit EPPRI2.
	USB_EPINTPRI_EPPRI3_Pos  = 0x3        // Position of EPPRI3 field.
	USB_EPINTPRI_EPPRI3_Msk  = 0x8        // Bit mask of EPPRI3 field.
	USB_EPINTPRI_EPPRI3      = 0x8        // Bit EPPRI3.
	USB_EPINTPRI_EPPRI4_Pos  = 0x4        // Position of EPPRI4 field.
	USB_EPINTPRI_EPPRI4_Msk  = 0x10       // Bit mask of EPPRI4 field.
	USB_EPINTPRI_EPPRI4      = 0x10       // Bit EPPRI4.
	USB_EPINTPRI_EPPRI5_Pos  = 0x5        // Position of EPPRI5 field.
	USB_EPINTPRI_EPPRI5_Msk  = 0x20       // Bit mask of EPPRI5 field.
	USB_EPINTPRI_EPPRI5      = 0x20       // Bit EPPRI5.
	USB_EPINTPRI_EPPRI6_Pos  = 0x6        // Position of EPPRI6 field.
	USB_EPINTPRI_EPPRI6_Msk  = 0x40       // Bit mask of EPPRI6 field.
	USB_EPINTPRI_EPPRI6      = 0x40       // Bit EPPRI6.
	USB_EPINTPRI_EPPRI7_Pos  = 0x7        // Position of EPPRI7 field.
	USB_EPINTPRI_EPPRI7_Msk  = 0x80       // Bit mask of EPPRI7 field.
	USB_EPINTPRI_EPPRI7      = 0x80       // Bit EPPRI7.
	USB_EPINTPRI_EPPRI8_Pos  = 0x8        // Position of EPPRI8 field.
	USB_EPINTPRI_EPPRI8_Msk  = 0x100      // Bit mask of EPPRI8 field.
	USB_EPINTPRI_EPPRI8      = 0x100      // Bit EPPRI8.
	USB_EPINTPRI_EPPRI9_Pos  = 0x9        // Position of EPPRI9 field.
	USB_EPINTPRI_EPPRI9_Msk  = 0x200      // Bit mask of EPPRI9 field.
	USB_EPINTPRI_EPPRI9      = 0x200      // Bit EPPRI9.
	USB_EPINTPRI_EPPRI10_Pos = 0xa        // Position of EPPRI10 field.
	USB_EPINTPRI_EPPRI10_Msk = 0x400      // Bit mask of EPPRI10 field.
	USB_EPINTPRI_EPPRI10     = 0x400      // Bit EPPRI10.
	USB_EPINTPRI_EPPRI11_Pos = 0xb        // Position of EPPRI11 field.
	USB_EPINTPRI_EPPRI11_Msk = 0x800      // Bit mask of EPPRI11 field.
	USB_EPINTPRI_EPPRI11     = 0x800      // Bit EPPRI11.
	USB_EPINTPRI_EPPRI12_Pos = 0xc        // Position of EPPRI12 field.
	USB_EPINTPRI_EPPRI12_Msk = 0x1000     // Bit mask of EPPRI12 field.
	USB_EPINTPRI_EPPRI12     = 0x1000     // Bit EPPRI12.
	USB_EPINTPRI_EPPRI13_Pos = 0xd        // Position of EPPRI13 field.
	USB_EPINTPRI_EPPRI13_Msk = 0x2000     // Bit mask of EPPRI13 field.
	USB_EPINTPRI_EPPRI13     = 0x2000     // Bit EPPRI13.
	USB_EPINTPRI_EPPRI14_Pos = 0xe        // Position of EPPRI14 field.
	USB_EPINTPRI_EPPRI14_Msk = 0x4000     // Bit mask of EPPRI14 field.
	USB_EPINTPRI_EPPRI14     = 0x4000     // Bit EPPRI14.
	USB_EPINTPRI_EPPRI15_Pos = 0xf        // Position of EPPRI15 field.
	USB_EPINTPRI_EPPRI15_Msk = 0x8000     // Bit mask of EPPRI15 field.
	USB_EPINTPRI_EPPRI15     = 0x8000     // Bit EPPRI15.
	USB_EPINTPRI_EPPRI16_Pos = 0x10       // Position of EPPRI16 field.
	USB_EPINTPRI_EPPRI16_Msk = 0x10000    // Bit mask of EPPRI16 field.
	USB_EPINTPRI_EPPRI16     = 0x10000    // Bit EPPRI16.
	USB_EPINTPRI_EPPRI17_Pos = 0x11       // Position of EPPRI17 field.
	USB_EPINTPRI_EPPRI17_Msk = 0x20000    // Bit mask of EPPRI17 field.
	USB_EPINTPRI_EPPRI17     = 0x20000    // Bit EPPRI17.
	USB_EPINTPRI_EPPRI18_Pos = 0x12       // Position of EPPRI18 field.
	USB_EPINTPRI_EPPRI18_Msk = 0x40000    // Bit mask of EPPRI18 field.
	USB_EPINTPRI_EPPRI18     = 0x40000    // Bit EPPRI18.
	USB_EPINTPRI_EPPRI19_Pos = 0x13       // Position of EPPRI19 field.
	USB_EPINTPRI_EPPRI19_Msk = 0x80000    // Bit mask of EPPRI19 field.
	USB_EPINTPRI_EPPRI19     = 0x80000    // Bit EPPRI19.
	USB_EPINTPRI_EPPRI20_Pos = 0x14       // Position of EPPRI20 field.
	USB_EPINTPRI_EPPRI20_Msk = 0x100000   // Bit mask of EPPRI20 field.
	USB_EPINTPRI_EPPRI20     = 0x100000   // Bit EPPRI20.
	USB_EPINTPRI_EPPRI21_Pos = 0x15       // Position of EPPRI21 field.
	USB_EPINTPRI_EPPRI21_Msk = 0x200000   // Bit mask of EPPRI21 field.
	USB_EPINTPRI_EPPRI21     = 0x200000   // Bit EPPRI21.
	USB_EPINTPRI_EPPRI22_Pos = 0x16       // Position of EPPRI22 field.
	USB_EPINTPRI_EPPRI22_Msk = 0x400000   // Bit mask of EPPRI22 field.
	USB_EPINTPRI_EPPRI22     = 0x400000   // Bit EPPRI22.
	USB_EPINTPRI_EPPRI23_Pos = 0x17       // Position of EPPRI23 field.
	USB_EPINTPRI_EPPRI23_Msk = 0x800000   // Bit mask of EPPRI23 field.
	USB_EPINTPRI_EPPRI23     = 0x800000   // Bit EPPRI23.
	USB_EPINTPRI_EPPRI24_Pos = 0x18       // Position of EPPRI24 field.
	USB_EPINTPRI_EPPRI24_Msk = 0x1000000  // Bit mask of EPPRI24 field.
	USB_EPINTPRI_EPPRI24     = 0x1000000  // Bit EPPRI24.
	USB_EPINTPRI_EPPRI25_Pos = 0x19       // Position of EPPRI25 field.
	USB_EPINTPRI_EPPRI25_Msk = 0x2000000  // Bit mask of EPPRI25 field.
	USB_EPINTPRI_EPPRI25     = 0x2000000  // Bit EPPRI25.
	USB_EPINTPRI_EPPRI26_Pos = 0x1a       // Position of EPPRI26 field.
	USB_EPINTPRI_EPPRI26_Msk = 0x4000000  // Bit mask of EPPRI26 field.
	USB_EPINTPRI_EPPRI26     = 0x4000000  // Bit EPPRI26.
	USB_EPINTPRI_EPPRI27_Pos = 0x1b       // Position of EPPRI27 field.
	USB_EPINTPRI_EPPRI27_Msk = 0x8000000  // Bit mask of EPPRI27 field.
	USB_EPINTPRI_EPPRI27     = 0x8000000  // Bit EPPRI27.
	USB_EPINTPRI_EPPRI28_Pos = 0x1c       // Position of EPPRI28 field.
	USB_EPINTPRI_EPPRI28_Msk = 0x10000000 // Bit mask of EPPRI28 field.
	USB_EPINTPRI_EPPRI28     = 0x10000000 // Bit EPPRI28.
	USB_EPINTPRI_EPPRI29_Pos = 0x1d       // Position of EPPRI29 field.
	USB_EPINTPRI_EPPRI29_Msk = 0x20000000 // Bit mask of EPPRI29 field.
	USB_EPINTPRI_EPPRI29     = 0x20000000 // Bit EPPRI29.
	USB_EPINTPRI_EPPRI30_Pos = 0x1e       // Position of EPPRI30 field.
	USB_EPINTPRI_EPPRI30_Msk = 0x40000000 // Bit mask of EPPRI30 field.
	USB_EPINTPRI_EPPRI30     = 0x40000000 // Bit EPPRI30.
	USB_EPINTPRI_EPPRI31_Pos = 0x1f       // Position of EPPRI31 field.
	USB_EPINTPRI_EPPRI31_Msk = 0x80000000 // Bit mask of EPPRI31 field.
	USB_EPINTPRI_EPPRI31     = 0x80000000 // Bit EPPRI31.

	// REEP: USB Realize Endpoint
	USB_REEP_EPR0_Pos  = 0x0        // Position of EPR0 field.
	USB_REEP_EPR0_Msk  = 0x1        // Bit mask of EPR0 field.
	USB_REEP_EPR0      = 0x1        // Bit EPR0.
	USB_REEP_EPR1_Pos  = 0x1        // Position of EPR1 field.
	USB_REEP_EPR1_Msk  = 0x2        // Bit mask of EPR1 field.
	USB_REEP_EPR1      = 0x2        // Bit EPR1.
	USB_REEP_EPR2_Pos  = 0x2        // Position of EPR2 field.
	USB_REEP_EPR2_Msk  = 0x4        // Bit mask of EPR2 field.
	USB_REEP_EPR2      = 0x4        // Bit EPR2.
	USB_REEP_EPR3_Pos  = 0x3        // Position of EPR3 field.
	USB_REEP_EPR3_Msk  = 0x8        // Bit mask of EPR3 field.
	USB_REEP_EPR3      = 0x8        // Bit EPR3.
	USB_REEP_EPR4_Pos  = 0x4        // Position of EPR4 field.
	USB_REEP_EPR4_Msk  = 0x10       // Bit mask of EPR4 field.
	USB_REEP_EPR4      = 0x10       // Bit EPR4.
	USB_REEP_EPR5_Pos  = 0x5        // Position of EPR5 field.
	USB_REEP_EPR5_Msk  = 0x20       // Bit mask of EPR5 field.
	USB_REEP_EPR5      = 0x20       // Bit EPR5.
	USB_REEP_EPR6_Pos  = 0x6        // Position of EPR6 field.
	USB_REEP_EPR6_Msk  = 0x40       // Bit mask of EPR6 field.
	USB_REEP_EPR6      = 0x40       // Bit EPR6.
	USB_REEP_EPR7_Pos  = 0x7        // Position of EPR7 field.
	USB_REEP_EPR7_Msk  = 0x80       // Bit mask of EPR7 field.
	USB_REEP_EPR7      = 0x80       // Bit EPR7.
	USB_REEP_EPR8_Pos  = 0x8        // Position of EPR8 field.
	USB_REEP_EPR8_Msk  = 0x100      // Bit mask of EPR8 field.
	USB_REEP_EPR8      = 0x100      // Bit EPR8.
	USB_REEP_EPR9_Pos  = 0x9        // Position of EPR9 field.
	USB_REEP_EPR9_Msk  = 0x200      // Bit mask of EPR9 field.
	USB_REEP_EPR9      = 0x200      // Bit EPR9.
	USB_REEP_EPR10_Pos = 0xa        // Position of EPR10 field.
	USB_REEP_EPR10_Msk = 0x400      // Bit mask of EPR10 field.
	USB_REEP_EPR10     = 0x400      // Bit EPR10.
	USB_REEP_EPR11_Pos = 0xb        // Position of EPR11 field.
	USB_REEP_EPR11_Msk = 0x800      // Bit mask of EPR11 field.
	USB_REEP_EPR11     = 0x800      // Bit EPR11.
	USB_REEP_EPR12_Pos = 0xc        // Position of EPR12 field.
	USB_REEP_EPR12_Msk = 0x1000     // Bit mask of EPR12 field.
	USB_REEP_EPR12     = 0x1000     // Bit EPR12.
	USB_REEP_EPR13_Pos = 0xd        // Position of EPR13 field.
	USB_REEP_EPR13_Msk = 0x2000     // Bit mask of EPR13 field.
	USB_REEP_EPR13     = 0x2000     // Bit EPR13.
	USB_REEP_EPR14_Pos = 0xe        // Position of EPR14 field.
	USB_REEP_EPR14_Msk = 0x4000     // Bit mask of EPR14 field.
	USB_REEP_EPR14     = 0x4000     // Bit EPR14.
	USB_REEP_EPR15_Pos = 0xf        // Position of EPR15 field.
	USB_REEP_EPR15_Msk = 0x8000     // Bit mask of EPR15 field.
	USB_REEP_EPR15     = 0x8000     // Bit EPR15.
	USB_REEP_EPR16_Pos = 0x10       // Position of EPR16 field.
	USB_REEP_EPR16_Msk = 0x10000    // Bit mask of EPR16 field.
	USB_REEP_EPR16     = 0x10000    // Bit EPR16.
	USB_REEP_EPR17_Pos = 0x11       // Position of EPR17 field.
	USB_REEP_EPR17_Msk = 0x20000    // Bit mask of EPR17 field.
	USB_REEP_EPR17     = 0x20000    // Bit EPR17.
	USB_REEP_EPR18_Pos = 0x12       // Position of EPR18 field.
	USB_REEP_EPR18_Msk = 0x40000    // Bit mask of EPR18 field.
	USB_REEP_EPR18     = 0x40000    // Bit EPR18.
	USB_REEP_EPR19_Pos = 0x13       // Position of EPR19 field.
	USB_REEP_EPR19_Msk = 0x80000    // Bit mask of EPR19 field.
	USB_REEP_EPR19     = 0x80000    // Bit EPR19.
	USB_REEP_EPR20_Pos = 0x14       // Position of EPR20 field.
	USB_REEP_EPR20_Msk = 0x100000   // Bit mask of EPR20 field.
	USB_REEP_EPR20     = 0x100000   // Bit EPR20.
	USB_REEP_EPR21_Pos = 0x15       // Position of EPR21 field.
	USB_REEP_EPR21_Msk = 0x200000   // Bit mask of EPR21 field.
	USB_REEP_EPR21     = 0x200000   // Bit EPR21.
	USB_REEP_EPR22_Pos = 0x16       // Position of EPR22 field.
	USB_REEP_EPR22_Msk = 0x400000   // Bit mask of EPR22 field.
	USB_REEP_EPR22     = 0x400000   // Bit EPR22.
	USB_REEP_EPR23_Pos = 0x17       // Position of EPR23 field.
	USB_REEP_EPR23_Msk = 0x800000   // Bit mask of EPR23 field.
	USB_REEP_EPR23     = 0x800000   // Bit EPR23.
	USB_REEP_EPR24_Pos = 0x18       // Position of EPR24 field.
	USB_REEP_EPR24_Msk = 0x1000000  // Bit mask of EPR24 field.
	USB_REEP_EPR24     = 0x1000000  // Bit EPR24.
	USB_REEP_EPR25_Pos = 0x19       // Position of EPR25 field.
	USB_REEP_EPR25_Msk = 0x2000000  // Bit mask of EPR25 field.
	USB_REEP_EPR25     = 0x2000000  // Bit EPR25.
	USB_REEP_EPR26_Pos = 0x1a       // Position of EPR26 field.
	USB_REEP_EPR26_Msk = 0x4000000  // Bit mask of EPR26 field.
	USB_REEP_EPR26     = 0x4000000  // Bit EPR26.
	USB_REEP_EPR27_Pos = 0x1b       // Position of EPR27 field.
	USB_REEP_EPR27_Msk = 0x8000000  // Bit mask of EPR27 field.
	USB_REEP_EPR27     = 0x8000000  // Bit EPR27.
	USB_REEP_EPR28_Pos = 0x1c       // Position of EPR28 field.
	USB_REEP_EPR28_Msk = 0x10000000 // Bit mask of EPR28 field.
	USB_REEP_EPR28     = 0x10000000 // Bit EPR28.
	USB_REEP_EPR29_Pos = 0x1d       // Position of EPR29 field.
	USB_REEP_EPR29_Msk = 0x20000000 // Bit mask of EPR29 field.
	USB_REEP_EPR29     = 0x20000000 // Bit EPR29.
	USB_REEP_EPR30_Pos = 0x1e       // Position of EPR30 field.
	USB_REEP_EPR30_Msk = 0x40000000 // Bit mask of EPR30 field.
	USB_REEP_EPR30     = 0x40000000 // Bit EPR30.
	USB_REEP_EPR31_Pos = 0x1f       // Position of EPR31 field.
	USB_REEP_EPR31_Msk = 0x80000000 // Bit mask of EPR31 field.
	USB_REEP_EPR31     = 0x80000000 // Bit EPR31.

	// EPIND: USB Endpoint Index
	USB_EPIND_PHY_EP_Pos   = 0x0        // Position of PHY_EP field.
	USB_EPIND_PHY_EP_Msk   = 0x1f       // Bit mask of PHY_EP field.
	USB_EPIND_RESERVED_Pos = 0x5        // Position of RESERVED field.
	USB_EPIND_RESERVED_Msk = 0xffffffe0 // Bit mask of RESERVED field.

	// MAXPSIZE: USB MaxPacketSize
	USB_MAXPSIZE_MPS_Pos      = 0x0        // Position of MPS field.
	USB_MAXPSIZE_MPS_Msk      = 0x3ff      // Bit mask of MPS field.
	USB_MAXPSIZE_RESERVED_Pos = 0xa        // Position of RESERVED field.
	USB_MAXPSIZE_RESERVED_Msk = 0xfffffc00 // Bit mask of RESERVED field.

	// DMARST: USB DMA Request Status
	USB_DMARST_EPRST0_Pos  = 0x0        // Position of EPRST0 field.
	USB_DMARST_EPRST0_Msk  = 0x1        // Bit mask of EPRST0 field.
	USB_DMARST_EPRST0      = 0x1        // Bit EPRST0.
	USB_DMARST_EPRST1_Pos  = 0x1        // Position of EPRST1 field.
	USB_DMARST_EPRST1_Msk  = 0x2        // Bit mask of EPRST1 field.
	USB_DMARST_EPRST1      = 0x2        // Bit EPRST1.
	USB_DMARST_EPRST2_Pos  = 0x2        // Position of EPRST2 field.
	USB_DMARST_EPRST2_Msk  = 0x4        // Bit mask of EPRST2 field.
	USB_DMARST_EPRST2      = 0x4        // Bit EPRST2.
	USB_DMARST_EPRST3_Pos  = 0x3        // Position of EPRST3 field.
	USB_DMARST_EPRST3_Msk  = 0x8        // Bit mask of EPRST3 field.
	USB_DMARST_EPRST3      = 0x8        // Bit EPRST3.
	USB_DMARST_EPRST4_Pos  = 0x4        // Position of EPRST4 field.
	USB_DMARST_EPRST4_Msk  = 0x10       // Bit mask of EPRST4 field.
	USB_DMARST_EPRST4      = 0x10       // Bit EPRST4.
	USB_DMARST_EPRST5_Pos  = 0x5        // Position of EPRST5 field.
	USB_DMARST_EPRST5_Msk  = 0x20       // Bit mask of EPRST5 field.
	USB_DMARST_EPRST5      = 0x20       // Bit EPRST5.
	USB_DMARST_EPRST6_Pos  = 0x6        // Position of EPRST6 field.
	USB_DMARST_EPRST6_Msk  = 0x40       // Bit mask of EPRST6 field.
	USB_DMARST_EPRST6      = 0x40       // Bit EPRST6.
	USB_DMARST_EPRST7_Pos  = 0x7        // Position of EPRST7 field.
	USB_DMARST_EPRST7_Msk  = 0x80       // Bit mask of EPRST7 field.
	USB_DMARST_EPRST7      = 0x80       // Bit EPRST7.
	USB_DMARST_EPRST8_Pos  = 0x8        // Position of EPRST8 field.
	USB_DMARST_EPRST8_Msk  = 0x100      // Bit mask of EPRST8 field.
	USB_DMARST_EPRST8      = 0x100      // Bit EPRST8.
	USB_DMARST_EPRST9_Pos  = 0x9        // Position of EPRST9 field.
	USB_DMARST_EPRST9_Msk  = 0x200      // Bit mask of EPRST9 field.
	USB_DMARST_EPRST9      = 0x200      // Bit EPRST9.
	USB_DMARST_EPRST10_Pos = 0xa        // Position of EPRST10 field.
	USB_DMARST_EPRST10_Msk = 0x400      // Bit mask of EPRST10 field.
	USB_DMARST_EPRST10     = 0x400      // Bit EPRST10.
	USB_DMARST_EPRST11_Pos = 0xb        // Position of EPRST11 field.
	USB_DMARST_EPRST11_Msk = 0x800      // Bit mask of EPRST11 field.
	USB_DMARST_EPRST11     = 0x800      // Bit EPRST11.
	USB_DMARST_EPRST12_Pos = 0xc        // Position of EPRST12 field.
	USB_DMARST_EPRST12_Msk = 0x1000     // Bit mask of EPRST12 field.
	USB_DMARST_EPRST12     = 0x1000     // Bit EPRST12.
	USB_DMARST_EPRST13_Pos = 0xd        // Position of EPRST13 field.
	USB_DMARST_EPRST13_Msk = 0x2000     // Bit mask of EPRST13 field.
	USB_DMARST_EPRST13     = 0x2000     // Bit EPRST13.
	USB_DMARST_EPRST14_Pos = 0xe        // Position of EPRST14 field.
	USB_DMARST_EPRST14_Msk = 0x4000     // Bit mask of EPRST14 field.
	USB_DMARST_EPRST14     = 0x4000     // Bit EPRST14.
	USB_DMARST_EPRST15_Pos = 0xf        // Position of EPRST15 field.
	USB_DMARST_EPRST15_Msk = 0x8000     // Bit mask of EPRST15 field.
	USB_DMARST_EPRST15     = 0x8000     // Bit EPRST15.
	USB_DMARST_EPRST16_Pos = 0x10       // Position of EPRST16 field.
	USB_DMARST_EPRST16_Msk = 0x10000    // Bit mask of EPRST16 field.
	USB_DMARST_EPRST16     = 0x10000    // Bit EPRST16.
	USB_DMARST_EPRST17_Pos = 0x11       // Position of EPRST17 field.
	USB_DMARST_EPRST17_Msk = 0x20000    // Bit mask of EPRST17 field.
	USB_DMARST_EPRST17     = 0x20000    // Bit EPRST17.
	USB_DMARST_EPRST18_Pos = 0x12       // Position of EPRST18 field.
	USB_DMARST_EPRST18_Msk = 0x40000    // Bit mask of EPRST18 field.
	USB_DMARST_EPRST18     = 0x40000    // Bit EPRST18.
	USB_DMARST_EPRST19_Pos = 0x13       // Position of EPRST19 field.
	USB_DMARST_EPRST19_Msk = 0x80000    // Bit mask of EPRST19 field.
	USB_DMARST_EPRST19     = 0x80000    // Bit EPRST19.
	USB_DMARST_EPRST20_Pos = 0x14       // Position of EPRST20 field.
	USB_DMARST_EPRST20_Msk = 0x100000   // Bit mask of EPRST20 field.
	USB_DMARST_EPRST20     = 0x100000   // Bit EPRST20.
	USB_DMARST_EPRST21_Pos = 0x15       // Position of EPRST21 field.
	USB_DMARST_EPRST21_Msk = 0x200000   // Bit mask of EPRST21 field.
	USB_DMARST_EPRST21     = 0x200000   // Bit EPRST21.
	USB_DMARST_EPRST22_Pos = 0x16       // Position of EPRST22 field.
	USB_DMARST_EPRST22_Msk = 0x400000   // Bit mask of EPRST22 field.
	USB_DMARST_EPRST22     = 0x400000   // Bit EPRST22.
	USB_DMARST_EPRST23_Pos = 0x17       // Position of EPRST23 field.
	USB_DMARST_EPRST23_Msk = 0x800000   // Bit mask of EPRST23 field.
	USB_DMARST_EPRST23     = 0x800000   // Bit EPRST23.
	USB_DMARST_EPRST24_Pos = 0x18       // Position of EPRST24 field.
	USB_DMARST_EPRST24_Msk = 0x1000000  // Bit mask of EPRST24 field.
	USB_DMARST_EPRST24     = 0x1000000  // Bit EPRST24.
	USB_DMARST_EPRST25_Pos = 0x19       // Position of EPRST25 field.
	USB_DMARST_EPRST25_Msk = 0x2000000  // Bit mask of EPRST25 field.
	USB_DMARST_EPRST25     = 0x2000000  // Bit EPRST25.
	USB_DMARST_EPRST26_Pos = 0x1a       // Position of EPRST26 field.
	USB_DMARST_EPRST26_Msk = 0x4000000  // Bit mask of EPRST26 field.
	USB_DMARST_EPRST26     = 0x4000000  // Bit EPRST26.
	USB_DMARST_EPRST27_Pos = 0x1b       // Position of EPRST27 field.
	USB_DMARST_EPRST27_Msk = 0x8000000  // Bit mask of EPRST27 field.
	USB_DMARST_EPRST27     = 0x8000000  // Bit EPRST27.
	USB_DMARST_EPRST28_Pos = 0x1c       // Position of EPRST28 field.
	USB_DMARST_EPRST28_Msk = 0x10000000 // Bit mask of EPRST28 field.
	USB_DMARST_EPRST28     = 0x10000000 // Bit EPRST28.
	USB_DMARST_EPRST29_Pos = 0x1d       // Position of EPRST29 field.
	USB_DMARST_EPRST29_Msk = 0x20000000 // Bit mask of EPRST29 field.
	USB_DMARST_EPRST29     = 0x20000000 // Bit EPRST29.
	USB_DMARST_EPRST30_Pos = 0x1e       // Position of EPRST30 field.
	USB_DMARST_EPRST30_Msk = 0x40000000 // Bit mask of EPRST30 field.
	USB_DMARST_EPRST30     = 0x40000000 // Bit EPRST30.
	USB_DMARST_EPRST31_Pos = 0x1f       // Position of EPRST31 field.
	USB_DMARST_EPRST31_Msk = 0x80000000 // Bit mask of EPRST31 field.
	USB_DMARST_EPRST31     = 0x80000000 // Bit EPRST31.

	// DMARCLR: USB DMA Request Clear
	USB_DMARCLR_EPRCLR0_Pos  = 0x0        // Position of EPRCLR0 field.
	USB_DMARCLR_EPRCLR0_Msk  = 0x1        // Bit mask of EPRCLR0 field.
	USB_DMARCLR_EPRCLR0      = 0x1        // Bit EPRCLR0.
	USB_DMARCLR_EPRCLR1_Pos  = 0x1        // Position of EPRCLR1 field.
	USB_DMARCLR_EPRCLR1_Msk  = 0x2        // Bit mask of EPRCLR1 field.
	USB_DMARCLR_EPRCLR1      = 0x2        // Bit EPRCLR1.
	USB_DMARCLR_EPRCLR2_Pos  = 0x2        // Position of EPRCLR2 field.
	USB_DMARCLR_EPRCLR2_Msk  = 0x4        // Bit mask of EPRCLR2 field.
	USB_DMARCLR_EPRCLR2      = 0x4        // Bit EPRCLR2.
	USB_DMARCLR_EPRCLR3_Pos  = 0x3        // Position of EPRCLR3 field.
	USB_DMARCLR_EPRCLR3_Msk  = 0x8        // Bit mask of EPRCLR3 field.
	USB_DMARCLR_EPRCLR3      = 0x8        // Bit EPRCLR3.
	USB_DMARCLR_EPRCLR4_Pos  = 0x4        // Position of EPRCLR4 field.
	USB_DMARCLR_EPRCLR4_Msk  = 0x10       // Bit mask of EPRCLR4 field.
	USB_DMARCLR_EPRCLR4      = 0x10       // Bit EPRCLR4.
	USB_DMARCLR_EPRCLR5_Pos  = 0x5        // Position of EPRCLR5 field.
	USB_DMARCLR_EPRCLR5_Msk  = 0x20       // Bit mask of EPRCLR5 field.
	USB_DMARCLR_EPRCLR5      = 0x20       // Bit EPRCLR5.
	USB_DMARCLR_EPRCLR6_Pos  = 0x6        // Position of EPRCLR6 field.
	USB_DMARCLR_EPRCLR6_Msk  = 0x40       // Bit mask of EPRCLR6 field.
	USB_DMARCLR_EPRCLR6      = 0x40       // Bit EPRCLR6.
	USB_DMARCLR_EPRCLR7_Pos  = 0x7        // Position of EPRCLR7 field.
	USB_DMARCLR_EPRCLR7_Msk  = 0x80       // Bit mask of EPRCLR7 field.
	USB_DMARCLR_EPRCLR7      = 0x80       // Bit EPRCLR7.
	USB_DMARCLR_EPRCLR8_Pos  = 0x8        // Position of EPRCLR8 field.
	USB_DMARCLR_EPRCLR8_Msk  = 0x100      // Bit mask of EPRCLR8 field.
	USB_DMARCLR_EPRCLR8      = 0x100      // Bit EPRCLR8.
	USB_DMARCLR_EPRCLR9_Pos  = 0x9        // Position of EPRCLR9 field.
	USB_DMARCLR_EPRCLR9_Msk  = 0x200      // Bit mask of EPRCLR9 field.
	USB_DMARCLR_EPRCLR9      = 0x200      // Bit EPRCLR9.
	USB_DMARCLR_EPRCLR10_Pos = 0xa        // Position of EPRCLR10 field.
	USB_DMARCLR_EPRCLR10_Msk = 0x400      // Bit mask of EPRCLR10 field.
	USB_DMARCLR_EPRCLR10     = 0x400      // Bit EPRCLR10.
	USB_DMARCLR_EPRCLR11_Pos = 0xb        // Position of EPRCLR11 field.
	USB_DMARCLR_EPRCLR11_Msk = 0x800      // Bit mask of EPRCLR11 field.
	USB_DMARCLR_EPRCLR11     = 0x800      // Bit EPRCLR11.
	USB_DMARCLR_EPRCLR12_Pos = 0xc        // Position of EPRCLR12 field.
	USB_DMARCLR_EPRCLR12_Msk = 0x1000     // Bit mask of EPRCLR12 field.
	USB_DMARCLR_EPRCLR12     = 0x1000     // Bit EPRCLR12.
	USB_DMARCLR_EPRCLR13_Pos = 0xd        // Position of EPRCLR13 field.
	USB_DMARCLR_EPRCLR13_Msk = 0x2000     // Bit mask of EPRCLR13 field.
	USB_DMARCLR_EPRCLR13     = 0x2000     // Bit EPRCLR13.
	USB_DMARCLR_EPRCLR14_Pos = 0xe        // Position of EPRCLR14 field.
	USB_DMARCLR_EPRCLR14_Msk = 0x4000     // Bit mask of EPRCLR14 field.
	USB_DMARCLR_EPRCLR14     = 0x4000     // Bit EPRCLR14.
	USB_DMARCLR_EPRCLR15_Pos = 0xf        // Position of EPRCLR15 field.
	USB_DMARCLR_EPRCLR15_Msk = 0x8000     // Bit mask of EPRCLR15 field.
	USB_DMARCLR_EPRCLR15     = 0x8000     // Bit EPRCLR15.
	USB_DMARCLR_EPRCLR16_Pos = 0x10       // Position of EPRCLR16 field.
	USB_DMARCLR_EPRCLR16_Msk = 0x10000    // Bit mask of EPRCLR16 field.
	USB_DMARCLR_EPRCLR16     = 0x10000    // Bit EPRCLR16.
	USB_DMARCLR_EPRCLR17_Pos = 0x11       // Position of EPRCLR17 field.
	USB_DMARCLR_EPRCLR17_Msk = 0x20000    // Bit mask of EPRCLR17 field.
	USB_DMARCLR_EPRCLR17     = 0x20000    // Bit EPRCLR17.
	USB_DMARCLR_EPRCLR18_Pos = 0x12       // Position of EPRCLR18 field.
	USB_DMARCLR_EPRCLR18_Msk = 0x40000    // Bit mask of EPRCLR18 field.
	USB_DMARCLR_EPRCLR18     = 0x40000    // Bit EPRCLR18.
	USB_DMARCLR_EPRCLR19_Pos = 0x13       // Position of EPRCLR19 field.
	USB_DMARCLR_EPRCLR19_Msk = 0x80000    // Bit mask of EPRCLR19 field.
	USB_DMARCLR_EPRCLR19     = 0x80000    // Bit EPRCLR19.
	USB_DMARCLR_EPRCLR20_Pos = 0x14       // Position of EPRCLR20 field.
	USB_DMARCLR_EPRCLR20_Msk = 0x100000   // Bit mask of EPRCLR20 field.
	USB_DMARCLR_EPRCLR20     = 0x100000   // Bit EPRCLR20.
	USB_DMARCLR_EPRCLR21_Pos = 0x15       // Position of EPRCLR21 field.
	USB_DMARCLR_EPRCLR21_Msk = 0x200000   // Bit mask of EPRCLR21 field.
	USB_DMARCLR_EPRCLR21     = 0x200000   // Bit EPRCLR21.
	USB_DMARCLR_EPRCLR22_Pos = 0x16       // Position of EPRCLR22 field.
	USB_DMARCLR_EPRCLR22_Msk = 0x400000   // Bit mask of EPRCLR22 field.
	USB_DMARCLR_EPRCLR22     = 0x400000   // Bit EPRCLR22.
	USB_DMARCLR_EPRCLR23_Pos = 0x17       // Position of EPRCLR23 field.
	USB_DMARCLR_EPRCLR23_Msk = 0x800000   // Bit mask of EPRCLR23 field.
	USB_DMARCLR_EPRCLR23     = 0x800000   // Bit EPRCLR23.
	USB_DMARCLR_EPRCLR24_Pos = 0x18       // Position of EPRCLR24 field.
	USB_DMARCLR_EPRCLR24_Msk = 0x1000000  // Bit mask of EPRCLR24 field.
	USB_DMARCLR_EPRCLR24     = 0x1000000  // Bit EPRCLR24.
	USB_DMARCLR_EPRCLR25_Pos = 0x19       // Position of EPRCLR25 field.
	USB_DMARCLR_EPRCLR25_Msk = 0x2000000  // Bit mask of EPRCLR25 field.
	USB_DMARCLR_EPRCLR25     = 0x2000000  // Bit EPRCLR25.
	USB_DMARCLR_EPRCLR26_Pos = 0x1a       // Position of EPRCLR26 field.
	USB_DMARCLR_EPRCLR26_Msk = 0x4000000  // Bit mask of EPRCLR26 field.
	USB_DMARCLR_EPRCLR26     = 0x4000000  // Bit EPRCLR26.
	USB_DMARCLR_EPRCLR27_Pos = 0x1b       // Position of EPRCLR27 field.
	USB_DMARCLR_EPRCLR27_Msk = 0x8000000  // Bit mask of EPRCLR27 field.
	USB_DMARCLR_EPRCLR27     = 0x8000000  // Bit EPRCLR27.
	USB_DMARCLR_EPRCLR28_Pos = 0x1c       // Position of EPRCLR28 field.
	USB_DMARCLR_EPRCLR28_Msk = 0x10000000 // Bit mask of EPRCLR28 field.
	USB_DMARCLR_EPRCLR28     = 0x10000000 // Bit EPRCLR28.
	USB_DMARCLR_EPRCLR29_Pos = 0x1d       // Position of EPRCLR29 field.
	USB_DMARCLR_EPRCLR29_Msk = 0x20000000 // Bit mask of EPRCLR29 field.
	USB_DMARCLR_EPRCLR29     = 0x20000000 // Bit EPRCLR29.
	USB_DMARCLR_EPRCLR30_Pos = 0x1e       // Position of EPRCLR30 field.
	USB_DMARCLR_EPRCLR30_Msk = 0x40000000 // Bit mask of EPRCLR30 field.
	USB_DMARCLR_EPRCLR30     = 0x40000000 // Bit EPRCLR30.
	USB_DMARCLR_EPRCLR31_Pos = 0x1f       // Position of EPRCLR31 field.
	USB_DMARCLR_EPRCLR31_Msk = 0x80000000 // Bit mask of EPRCLR31 field.
	USB_DMARCLR_EPRCLR31     = 0x80000000 // Bit EPRCLR31.

	// DMARSET: USB DMA Request Set
	USB_DMARSET_EPRSET0_Pos  = 0x0        // Position of EPRSET0 field.
	USB_DMARSET_EPRSET0_Msk  = 0x1        // Bit mask of EPRSET0 field.
	USB_DMARSET_EPRSET0      = 0x1        // Bit EPRSET0.
	USB_DMARSET_EPRSET1_Pos  = 0x1        // Position of EPRSET1 field.
	USB_DMARSET_EPRSET1_Msk  = 0x2        // Bit mask of EPRSET1 field.
	USB_DMARSET_EPRSET1      = 0x2        // Bit EPRSET1.
	USB_DMARSET_EPRSET2_Pos  = 0x2        // Position of EPRSET2 field.
	USB_DMARSET_EPRSET2_Msk  = 0x4        // Bit mask of EPRSET2 field.
	USB_DMARSET_EPRSET2      = 0x4        // Bit EPRSET2.
	USB_DMARSET_EPRSET3_Pos  = 0x3        // Position of EPRSET3 field.
	USB_DMARSET_EPRSET3_Msk  = 0x8        // Bit mask of EPRSET3 field.
	USB_DMARSET_EPRSET3      = 0x8        // Bit EPRSET3.
	USB_DMARSET_EPRSET4_Pos  = 0x4        // Position of EPRSET4 field.
	USB_DMARSET_EPRSET4_Msk  = 0x10       // Bit mask of EPRSET4 field.
	USB_DMARSET_EPRSET4      = 0x10       // Bit EPRSET4.
	USB_DMARSET_EPRSET5_Pos  = 0x5        // Position of EPRSET5 field.
	USB_DMARSET_EPRSET5_Msk  = 0x20       // Bit mask of EPRSET5 field.
	USB_DMARSET_EPRSET5      = 0x20       // Bit EPRSET5.
	USB_DMARSET_EPRSET6_Pos  = 0x6        // Position of EPRSET6 field.
	USB_DMARSET_EPRSET6_Msk  = 0x40       // Bit mask of EPRSET6 field.
	USB_DMARSET_EPRSET6      = 0x40       // Bit EPRSET6.
	USB_DMARSET_EPRSET7_Pos  = 0x7        // Position of EPRSET7 field.
	USB_DMARSET_EPRSET7_Msk  = 0x80       // Bit mask of EPRSET7 field.
	USB_DMARSET_EPRSET7      = 0x80       // Bit EPRSET7.
	USB_DMARSET_EPRSET8_Pos  = 0x8        // Position of EPRSET8 field.
	USB_DMARSET_EPRSET8_Msk  = 0x100      // Bit mask of EPRSET8 field.
	USB_DMARSET_EPRSET8      = 0x100      // Bit EPRSET8.
	USB_DMARSET_EPRSET9_Pos  = 0x9        // Position of EPRSET9 field.
	USB_DMARSET_EPRSET9_Msk  = 0x200      // Bit mask of EPRSET9 field.
	USB_DMARSET_EPRSET9      = 0x200      // Bit EPRSET9.
	USB_DMARSET_EPRSET10_Pos = 0xa        // Position of EPRSET10 field.
	USB_DMARSET_EPRSET10_Msk = 0x400      // Bit mask of EPRSET10 field.
	USB_DMARSET_EPRSET10     = 0x400      // Bit EPRSET10.
	USB_DMARSET_EPRSET11_Pos = 0xb        // Position of EPRSET11 field.
	USB_DMARSET_EPRSET11_Msk = 0x800      // Bit mask of EPRSET11 field.
	USB_DMARSET_EPRSET11     = 0x800      // Bit EPRSET11.
	USB_DMARSET_EPRSET12_Pos = 0xc        // Position of EPRSET12 field.
	USB_DMARSET_EPRSET12_Msk = 0x1000     // Bit mask of EPRSET12 field.
	USB_DMARSET_EPRSET12     = 0x1000     // Bit EPRSET12.
	USB_DMARSET_EPRSET13_Pos = 0xd        // Position of EPRSET13 field.
	USB_DMARSET_EPRSET13_Msk = 0x2000     // Bit mask of EPRSET13 field.
	USB_DMARSET_EPRSET13     = 0x2000     // Bit EPRSET13.
	USB_DMARSET_EPRSET14_Pos = 0xe        // Position of EPRSET14 field.
	USB_DMARSET_EPRSET14_Msk = 0x4000     // Bit mask of EPRSET14 field.
	USB_DMARSET_EPRSET14     = 0x4000     // Bit EPRSET14.
	USB_DMARSET_EPRSET15_Pos = 0xf        // Position of EPRSET15 field.
	USB_DMARSET_EPRSET15_Msk = 0x8000     // Bit mask of EPRSET15 field.
	USB_DMARSET_EPRSET15     = 0x8000     // Bit EPRSET15.
	USB_DMARSET_EPRSET16_Pos = 0x10       // Position of EPRSET16 field.
	USB_DMARSET_EPRSET16_Msk = 0x10000    // Bit mask of EPRSET16 field.
	USB_DMARSET_EPRSET16     = 0x10000    // Bit EPRSET16.
	USB_DMARSET_EPRSET17_Pos = 0x11       // Position of EPRSET17 field.
	USB_DMARSET_EPRSET17_Msk = 0x20000    // Bit mask of EPRSET17 field.
	USB_DMARSET_EPRSET17     = 0x20000    // Bit EPRSET17.
	USB_DMARSET_EPRSET18_Pos = 0x12       // Position of EPRSET18 field.
	USB_DMARSET_EPRSET18_Msk = 0x40000    // Bit mask of EPRSET18 field.
	USB_DMARSET_EPRSET18     = 0x40000    // Bit EPRSET18.
	USB_DMARSET_EPRSET19_Pos = 0x13       // Position of EPRSET19 field.
	USB_DMARSET_EPRSET19_Msk = 0x80000    // Bit mask of EPRSET19 field.
	USB_DMARSET_EPRSET19     = 0x80000    // Bit EPRSET19.
	USB_DMARSET_EPRSET20_Pos = 0x14       // Position of EPRSET20 field.
	USB_DMARSET_EPRSET20_Msk = 0x100000   // Bit mask of EPRSET20 field.
	USB_DMARSET_EPRSET20     = 0x100000   // Bit EPRSET20.
	USB_DMARSET_EPRSET21_Pos = 0x15       // Position of EPRSET21 field.
	USB_DMARSET_EPRSET21_Msk = 0x200000   // Bit mask of EPRSET21 field.
	USB_DMARSET_EPRSET21     = 0x200000   // Bit EPRSET21.
	USB_DMARSET_EPRSET22_Pos = 0x16       // Position of EPRSET22 field.
	USB_DMARSET_EPRSET22_Msk = 0x400000   // Bit mask of EPRSET22 field.
	USB_DMARSET_EPRSET22     = 0x400000   // Bit EPRSET22.
	USB_DMARSET_EPRSET23_Pos = 0x17       // Position of EPRSET23 field.
	USB_DMARSET_EPRSET23_Msk = 0x800000   // Bit mask of EPRSET23 field.
	USB_DMARSET_EPRSET23     = 0x800000   // Bit EPRSET23.
	USB_DMARSET_EPRSET24_Pos = 0x18       // Position of EPRSET24 field.
	USB_DMARSET_EPRSET24_Msk = 0x1000000  // Bit mask of EPRSET24 field.
	USB_DMARSET_EPRSET24     = 0x1000000  // Bit EPRSET24.
	USB_DMARSET_EPRSET25_Pos = 0x19       // Position of EPRSET25 field.
	USB_DMARSET_EPRSET25_Msk = 0x2000000  // Bit mask of EPRSET25 field.
	USB_DMARSET_EPRSET25     = 0x2000000  // Bit EPRSET25.
	USB_DMARSET_EPRSET26_Pos = 0x1a       // Position of EPRSET26 field.
	USB_DMARSET_EPRSET26_Msk = 0x4000000  // Bit mask of EPRSET26 field.
	USB_DMARSET_EPRSET26     = 0x4000000  // Bit EPRSET26.
	USB_DMARSET_EPRSET27_Pos = 0x1b       // Position of EPRSET27 field.
	USB_DMARSET_EPRSET27_Msk = 0x8000000  // Bit mask of EPRSET27 field.
	USB_DMARSET_EPRSET27     = 0x8000000  // Bit EPRSET27.
	USB_DMARSET_EPRSET28_Pos = 0x1c       // Position of EPRSET28 field.
	USB_DMARSET_EPRSET28_Msk = 0x10000000 // Bit mask of EPRSET28 field.
	USB_DMARSET_EPRSET28     = 0x10000000 // Bit EPRSET28.
	USB_DMARSET_EPRSET29_Pos = 0x1d       // Position of EPRSET29 field.
	USB_DMARSET_EPRSET29_Msk = 0x20000000 // Bit mask of EPRSET29 field.
	USB_DMARSET_EPRSET29     = 0x20000000 // Bit EPRSET29.
	USB_DMARSET_EPRSET30_Pos = 0x1e       // Position of EPRSET30 field.
	USB_DMARSET_EPRSET30_Msk = 0x40000000 // Bit mask of EPRSET30 field.
	USB_DMARSET_EPRSET30     = 0x40000000 // Bit EPRSET30.
	USB_DMARSET_EPRSET31_Pos = 0x1f       // Position of EPRSET31 field.
	USB_DMARSET_EPRSET31_Msk = 0x80000000 // Bit mask of EPRSET31 field.
	USB_DMARSET_EPRSET31     = 0x80000000 // Bit EPRSET31.

	// UDCAH: USB UDCA Head
	USB_UDCAH_RESERVED_Pos  = 0x0        // Position of RESERVED field.
	USB_UDCAH_RESERVED_Msk  = 0x7f       // Bit mask of RESERVED field.
	USB_UDCAH_UDCA_ADDR_Pos = 0x7        // Position of UDCA_ADDR field.
	USB_UDCAH_UDCA_ADDR_Msk = 0xffffff80 // Bit mask of UDCA_ADDR field.

	// EPDMAST: USB Endpoint DMA Status
	USB_EPDMAST_EP_DMA_ST0_Pos  = 0x0        // Position of EP_DMA_ST0 field.
	USB_EPDMAST_EP_DMA_ST0_Msk  = 0x1        // Bit mask of EP_DMA_ST0 field.
	USB_EPDMAST_EP_DMA_ST0      = 0x1        // Bit EP_DMA_ST0.
	USB_EPDMAST_EP_DMA_ST1_Pos  = 0x1        // Position of EP_DMA_ST1 field.
	USB_EPDMAST_EP_DMA_ST1_Msk  = 0x2        // Bit mask of EP_DMA_ST1 field.
	USB_EPDMAST_EP_DMA_ST1      = 0x2        // Bit EP_DMA_ST1.
	USB_EPDMAST_EP_DMA_ST2_Pos  = 0x2        // Position of EP_DMA_ST2 field.
	USB_EPDMAST_EP_DMA_ST2_Msk  = 0x4        // Bit mask of EP_DMA_ST2 field.
	USB_EPDMAST_EP_DMA_ST2      = 0x4        // Bit EP_DMA_ST2.
	USB_EPDMAST_EP_DMA_ST3_Pos  = 0x3        // Position of EP_DMA_ST3 field.
	USB_EPDMAST_EP_DMA_ST3_Msk  = 0x8        // Bit mask of EP_DMA_ST3 field.
	USB_EPDMAST_EP_DMA_ST3      = 0x8        // Bit EP_DMA_ST3.
	USB_EPDMAST_EP_DMA_ST4_Pos  = 0x4        // Position of EP_DMA_ST4 field.
	USB_EPDMAST_EP_DMA_ST4_Msk  = 0x10       // Bit mask of EP_DMA_ST4 field.
	USB_EPDMAST_EP_DMA_ST4      = 0x10       // Bit EP_DMA_ST4.
	USB_EPDMAST_EP_DMA_ST5_Pos  = 0x5        // Position of EP_DMA_ST5 field.
	USB_EPDMAST_EP_DMA_ST5_Msk  = 0x20       // Bit mask of EP_DMA_ST5 field.
	USB_EPDMAST_EP_DMA_ST5      = 0x20       // Bit EP_DMA_ST5.
	USB_EPDMAST_EP_DMA_ST6_Pos  = 0x6        // Position of EP_DMA_ST6 field.
	USB_EPDMAST_EP_DMA_ST6_Msk  = 0x40       // Bit mask of EP_DMA_ST6 field.
	USB_EPDMAST_EP_DMA_ST6      = 0x40       // Bit EP_DMA_ST6.
	USB_EPDMAST_EP_DMA_ST7_Pos  = 0x7        // Position of EP_DMA_ST7 field.
	USB_EPDMAST_EP_DMA_ST7_Msk  = 0x80       // Bit mask of EP_DMA_ST7 field.
	USB_EPDMAST_EP_DMA_ST7      = 0x80       // Bit EP_DMA_ST7.
	USB_EPDMAST_EP_DMA_ST8_Pos  = 0x8        // Position of EP_DMA_ST8 field.
	USB_EPDMAST_EP_DMA_ST8_Msk  = 0x100      // Bit mask of EP_DMA_ST8 field.
	USB_EPDMAST_EP_DMA_ST8      = 0x100      // Bit EP_DMA_ST8.
	USB_EPDMAST_EP_DMA_ST9_Pos  = 0x9        // Position of EP_DMA_ST9 field.
	USB_EPDMAST_EP_DMA_ST9_Msk  = 0x200      // Bit mask of EP_DMA_ST9 field.
	USB_EPDMAST_EP_DMA_ST9      = 0x200      // Bit EP_DMA_ST9.
	USB_EPDMAST_EP_DMA_ST10_Pos = 0xa        // Position of EP_DMA_ST10 field.
	USB_EPDMAST_EP_DMA_ST10_Msk = 0x400      // Bit mask of EP_DMA_ST10 field.
	USB_EPDMAST_EP_DMA_ST10     = 0x400      // Bit EP_DMA_ST10.
	USB_EPDMAST_EP_DMA_ST11_Pos = 0xb        // Position of EP_DMA_ST11 field.
	USB_EPDMAST_EP_DMA_ST11_Msk = 0x800      // Bit mask of EP_DMA_ST11 field.
	USB_EPDMAST_EP_DMA_ST11     = 0x800      // Bit EP_DMA_ST11.
	USB_EPDMAST_EP_DMA_ST12_Pos = 0xc        // Position of EP_DMA_ST12 field.
	USB_EPDMAST_EP_DMA_ST12_Msk = 0x1000     // Bit mask of EP_DMA_ST12 field.
	USB_EPDMAST_EP_DMA_ST12     = 0x1000     // Bit EP_DMA_ST12.
	USB_EPDMAST_EP_DMA_ST13_Pos = 0xd        // Position of EP_DMA_ST13 field.
	USB_EPDMAST_EP_DMA_ST13_Msk = 0x2000     // Bit mask of EP_DMA_ST13 field.
	USB_EPDMAST_EP_DMA_ST13     = 0x2000     // Bit EP_DMA_ST13.
	USB_EPDMAST_EP_DMA_ST14_Pos = 0xe        // Position of EP_DMA_ST14 field.
	USB_EPDMAST_EP_DMA_ST14_Msk = 0x4000     // Bit mask of EP_DMA_ST14 field.
	USB_EPDMAST_EP_DMA_ST14     = 0x4000     // Bit EP_DMA_ST14.
	USB_EPDMAST_EP_DMA_ST15_Pos = 0xf        // Position of EP_DMA_ST15 field.
	USB_EPDMAST_EP_DMA_ST15_Msk = 0x8000     // Bit mask of EP_DMA_ST15 field.
	USB_EPDMAST_EP_DMA_ST15     = 0x8000     // Bit EP_DMA_ST15.
	USB_EPDMAST_EP_DMA_ST16_Pos = 0x10       // Position of EP_DMA_ST16 field.
	USB_EPDMAST_EP_DMA_ST16_Msk = 0x10000    // Bit mask of EP_DMA_ST16 field.
	USB_EPDMAST_EP_DMA_ST16     = 0x10000    // Bit EP_DMA_ST16.
	USB_EPDMAST_EP_DMA_ST17_Pos = 0x11       // Position of EP_DMA_ST17 field.
	USB_EPDMAST_EP_DMA_ST17_Msk = 0x20000    // Bit mask of EP_DMA_ST17 field.
	USB_EPDMAST_EP_DMA_ST17     = 0x20000    // Bit EP_DMA_ST17.
	USB_EPDMAST_EP_DMA_ST18_Pos = 0x12       // Position of EP_DMA_ST18 field.
	USB_EPDMAST_EP_DMA_ST18_Msk = 0x40000    // Bit mask of EP_DMA_ST18 field.
	USB_EPDMAST_EP_DMA_ST18     = 0x40000    // Bit EP_DMA_ST18.
	USB_EPDMAST_EP_DMA_ST19_Pos = 0x13       // Position of EP_DMA_ST19 field.
	USB_EPDMAST_EP_DMA_ST19_Msk = 0x80000    // Bit mask of EP_DMA_ST19 field.
	USB_EPDMAST_EP_DMA_ST19     = 0x80000    // Bit EP_DMA_ST19.
	USB_EPDMAST_EP_DMA_ST20_Pos = 0x14       // Position of EP_DMA_ST20 field.
	USB_EPDMAST_EP_DMA_ST20_Msk = 0x100000   // Bit mask of EP_DMA_ST20 field.
	USB_EPDMAST_EP_DMA_ST20     = 0x100000   // Bit EP_DMA_ST20.
	USB_EPDMAST_EP_DMA_ST21_Pos = 0x15       // Position of EP_DMA_ST21 field.
	USB_EPDMAST_EP_DMA_ST21_Msk = 0x200000   // Bit mask of EP_DMA_ST21 field.
	USB_EPDMAST_EP_DMA_ST21     = 0x200000   // Bit EP_DMA_ST21.
	USB_EPDMAST_EP_DMA_ST22_Pos = 0x16       // Position of EP_DMA_ST22 field.
	USB_EPDMAST_EP_DMA_ST22_Msk = 0x400000   // Bit mask of EP_DMA_ST22 field.
	USB_EPDMAST_EP_DMA_ST22     = 0x400000   // Bit EP_DMA_ST22.
	USB_EPDMAST_EP_DMA_ST23_Pos = 0x17       // Position of EP_DMA_ST23 field.
	USB_EPDMAST_EP_DMA_ST23_Msk = 0x800000   // Bit mask of EP_DMA_ST23 field.
	USB_EPDMAST_EP_DMA_ST23     = 0x800000   // Bit EP_DMA_ST23.
	USB_EPDMAST_EP_DMA_ST24_Pos = 0x18       // Position of EP_DMA_ST24 field.
	USB_EPDMAST_EP_DMA_ST24_Msk = 0x1000000  // Bit mask of EP_DMA_ST24 field.
	USB_EPDMAST_EP_DMA_ST24     = 0x1000000  // Bit EP_DMA_ST24.
	USB_EPDMAST_EP_DMA_ST25_Pos = 0x19       // Position of EP_DMA_ST25 field.
	USB_EPDMAST_EP_DMA_ST25_Msk = 0x2000000  // Bit mask of EP_DMA_ST25 field.
	USB_EPDMAST_EP_DMA_ST25     = 0x2000000  // Bit EP_DMA_ST25.
	USB_EPDMAST_EP_DMA_ST26_Pos = 0x1a       // Position of EP_DMA_ST26 field.
	USB_EPDMAST_EP_DMA_ST26_Msk = 0x4000000  // Bit mask of EP_DMA_ST26 field.
	USB_EPDMAST_EP_DMA_ST26     = 0x4000000  // Bit EP_DMA_ST26.
	USB_EPDMAST_EP_DMA_ST27_Pos = 0x1b       // Position of EP_DMA_ST27 field.
	USB_EPDMAST_EP_DMA_ST27_Msk = 0x8000000  // Bit mask of EP_DMA_ST27 field.
	USB_EPDMAST_EP_DMA_ST27     = 0x8000000  // Bit EP_DMA_ST27.
	USB_EPDMAST_EP_DMA_ST28_Pos = 0x1c       // Position of EP_DMA_ST28 field.
	USB_EPDMAST_EP_DMA_ST28_Msk = 0x10000000 // Bit mask of EP_DMA_ST28 field.
	USB_EPDMAST_EP_DMA_ST28     = 0x10000000 // Bit EP_DMA_ST28.
	USB_EPDMAST_EP_DMA_ST29_Pos = 0x1d       // Position of EP_DMA_ST29 field.
	USB_EPDMAST_EP_DMA_ST29_Msk = 0x20000000 // Bit mask of EP_DMA_ST29 field.
	USB_EPDMAST_EP_DMA_ST29     = 0x20000000 // Bit EP_DMA_ST29.
	USB_EPDMAST_EP_DMA_ST30_Pos = 0x1e       // Position of EP_DMA_ST30 field.
	USB_EPDMAST_EP_DMA_ST30_Msk = 0x40000000 // Bit mask of EP_DMA_ST30 field.
	USB_EPDMAST_EP_DMA_ST30     = 0x40000000 // Bit EP_DMA_ST30.
	USB_EPDMAST_EP_DMA_ST31_Pos = 0x1f       // Position of EP_DMA_ST31 field.
	USB_EPDMAST_EP_DMA_ST31_Msk = 0x80000000 // Bit mask of EP_DMA_ST31 field.
	USB_EPDMAST_EP_DMA_ST31     = 0x80000000 // Bit EP_DMA_ST31.

	// EPDMAEN: USB Endpoint DMA Enable
	USB_EPDMAEN_EP_DMA_EN0_Pos = 0x0        // Position of EP_DMA_EN0 field.
	USB_EPDMAEN_EP_DMA_EN0_Msk = 0x1        // Bit mask of EP_DMA_EN0 field.
	USB_EPDMAEN_EP_DMA_EN0     = 0x1        // Bit EP_DMA_EN0.
	USB_EPDMAEN_EP_DMA_EN1_Pos = 0x1        // Position of EP_DMA_EN1 field.
	USB_EPDMAEN_EP_DMA_EN1_Msk = 0x2        // Bit mask of EP_DMA_EN1 field.
	USB_EPDMAEN_EP_DMA_EN1     = 0x2        // Bit EP_DMA_EN1.
	USB_EPDMAEN_EP_DMA_EN_Pos  = 0x2        // Position of EP_DMA_EN field.
	USB_EPDMAEN_EP_DMA_EN_Msk  = 0xfffffffc // Bit mask of EP_DMA_EN field.

	// EPDMADIS: USB Endpoint DMA Disable
	USB_EPDMADIS_EP_DMA_DIS0_Pos  = 0x0        // Position of EP_DMA_DIS0 field.
	USB_EPDMADIS_EP_DMA_DIS0_Msk  = 0x1        // Bit mask of EP_DMA_DIS0 field.
	USB_EPDMADIS_EP_DMA_DIS0      = 0x1        // Bit EP_DMA_DIS0.
	USB_EPDMADIS_EP_DMA_DIS1_Pos  = 0x1        // Position of EP_DMA_DIS1 field.
	USB_EPDMADIS_EP_DMA_DIS1_Msk  = 0x2        // Bit mask of EP_DMA_DIS1 field.
	USB_EPDMADIS_EP_DMA_DIS1      = 0x2        // Bit EP_DMA_DIS1.
	USB_EPDMADIS_EP_DMA_DIS2_Pos  = 0x2        // Position of EP_DMA_DIS2 field.
	USB_EPDMADIS_EP_DMA_DIS2_Msk  = 0x4        // Bit mask of EP_DMA_DIS2 field.
	USB_EPDMADIS_EP_DMA_DIS2      = 0x4        // Bit EP_DMA_DIS2.
	USB_EPDMADIS_EP_DMA_DIS3_Pos  = 0x3        // Position of EP_DMA_DIS3 field.
	USB_EPDMADIS_EP_DMA_DIS3_Msk  = 0x8        // Bit mask of EP_DMA_DIS3 field.
	USB_EPDMADIS_EP_DMA_DIS3      = 0x8        // Bit EP_DMA_DIS3.
	USB_EPDMADIS_EP_DMA_DIS4_Pos  = 0x4        // Position of EP_DMA_DIS4 field.
	USB_EPDMADIS_EP_DMA_DIS4_Msk  = 0x10       // Bit mask of EP_DMA_DIS4 field.
	USB_EPDMADIS_EP_DMA_DIS4      = 0x10       // Bit EP_DMA_DIS4.
	USB_EPDMADIS_EP_DMA_DIS5_Pos  = 0x5        // Position of EP_DMA_DIS5 field.
	USB_EPDMADIS_EP_DMA_DIS5_Msk  = 0x20       // Bit mask of EP_DMA_DIS5 field.
	USB_EPDMADIS_EP_DMA_DIS5      = 0x20       // Bit EP_DMA_DIS5.
	USB_EPDMADIS_EP_DMA_DIS6_Pos  = 0x6        // Position of EP_DMA_DIS6 field.
	USB_EPDMADIS_EP_DMA_DIS6_Msk  = 0x40       // Bit mask of EP_DMA_DIS6 field.
	USB_EPDMADIS_EP_DMA_DIS6      = 0x40       // Bit EP_DMA_DIS6.
	USB_EPDMADIS_EP_DMA_DIS7_Pos  = 0x7        // Position of EP_DMA_DIS7 field.
	USB_EPDMADIS_EP_DMA_DIS7_Msk  = 0x80       // Bit mask of EP_DMA_DIS7 field.
	USB_EPDMADIS_EP_DMA_DIS7      = 0x80       // Bit EP_DMA_DIS7.
	USB_EPDMADIS_EP_DMA_DIS8_Pos  = 0x8        // Position of EP_DMA_DIS8 field.
	USB_EPDMADIS_EP_DMA_DIS8_Msk  = 0x100      // Bit mask of EP_DMA_DIS8 field.
	USB_EPDMADIS_EP_DMA_DIS8      = 0x100      // Bit EP_DMA_DIS8.
	USB_EPDMADIS_EP_DMA_DIS9_Pos  = 0x9        // Position of EP_DMA_DIS9 field.
	USB_EPDMADIS_EP_DMA_DIS9_Msk  = 0x200      // Bit mask of EP_DMA_DIS9 field.
	USB_EPDMADIS_EP_DMA_DIS9      = 0x200      // Bit EP_DMA_DIS9.
	USB_EPDMADIS_EP_DMA_DIS10_Pos = 0xa        // Position of EP_DMA_DIS10 field.
	USB_EPDMADIS_EP_DMA_DIS10_Msk = 0x400      // Bit mask of EP_DMA_DIS10 field.
	USB_EPDMADIS_EP_DMA_DIS10     = 0x400      // Bit EP_DMA_DIS10.
	USB_EPDMADIS_EP_DMA_DIS11_Pos = 0xb        // Position of EP_DMA_DIS11 field.
	USB_EPDMADIS_EP_DMA_DIS11_Msk = 0x800      // Bit mask of EP_DMA_DIS11 field.
	USB_EPDMADIS_EP_DMA_DIS11     = 0x800      // Bit EP_DMA_DIS11.
	USB_EPDMADIS_EP_DMA_DIS12_Pos = 0xc        // Position of EP_DMA_DIS12 field.
	USB_EPDMADIS_EP_DMA_DIS12_Msk = 0x1000     // Bit mask of EP_DMA_DIS12 field.
	USB_EPDMADIS_EP_DMA_DIS12     = 0x1000     // Bit EP_DMA_DIS12.
	USB_EPDMADIS_EP_DMA_DIS13_Pos = 0xd        // Position of EP_DMA_DIS13 field.
	USB_EPDMADIS_EP_DMA_DIS13_Msk = 0x2000     // Bit mask of EP_DMA_DIS13 field.
	USB_EPDMADIS_EP_DMA_DIS13     = 0x2000     // Bit EP_DMA_DIS13.
	USB_EPDMADIS_EP_DMA_DIS14_Pos = 0xe        // Position of EP_DMA_DIS14 field.
	USB_EPDMADIS_EP_DMA_DIS14_Msk = 0x4000     // Bit mask of EP_DMA_DIS14 field.
	USB_EPDMADIS_EP_DMA_DIS14     = 0x4000     // Bit EP_DMA_DIS14.
	USB_EPDMADIS_EP_DMA_DIS15_Pos = 0xf        // Position of EP_DMA_DIS15 field.
	USB_EPDMADIS_EP_DMA_DIS15_Msk = 0x8000     // Bit mask of EP_DMA_DIS15 field.
	USB_EPDMADIS_EP_DMA_DIS15     = 0x8000     // Bit EP_DMA_DIS15.
	USB_EPDMADIS_EP_DMA_DIS16_Pos = 0x10       // Position of EP_DMA_DIS16 field.
	USB_EPDMADIS_EP_DMA_DIS16_Msk = 0x10000    // Bit mask of EP_DMA_DIS16 field.
	USB_EPDMADIS_EP_DMA_DIS16     = 0x10000    // Bit EP_DMA_DIS16.
	USB_EPDMADIS_EP_DMA_DIS17_Pos = 0x11       // Position of EP_DMA_DIS17 field.
	USB_EPDMADIS_EP_DMA_DIS17_Msk = 0x20000    // Bit mask of EP_DMA_DIS17 field.
	USB_EPDMADIS_EP_DMA_DIS17     = 0x20000    // Bit EP_DMA_DIS17.
	USB_EPDMADIS_EP_DMA_DIS18_Pos = 0x12       // Position of EP_DMA_DIS18 field.
	USB_EPDMADIS_EP_DMA_DIS18_Msk = 0x40000    // Bit mask of EP_DMA_DIS18 field.
	USB_EPDMADIS_EP_DMA_DIS18     = 0x40000    // Bit EP_DMA_DIS18.
	USB_EPDMADIS_EP_DMA_DIS19_Pos = 0x13       // Position of EP_DMA_DIS19 field.
	USB_EPDMADIS_EP_DMA_DIS19_Msk = 0x80000    // Bit mask of EP_DMA_DIS19 field.
	USB_EPDMADIS_EP_DMA_DIS19     = 0x80000    // Bit EP_DMA_DIS19.
	USB_EPDMADIS_EP_DMA_DIS20_Pos = 0x14       // Position of EP_DMA_DIS20 field.
	USB_EPDMADIS_EP_DMA_DIS20_Msk = 0x100000   // Bit mask of EP_DMA_DIS20 field.
	USB_EPDMADIS_EP_DMA_DIS20     = 0x100000   // Bit EP_DMA_DIS20.
	USB_EPDMADIS_EP_DMA_DIS21_Pos = 0x15       // Position of EP_DMA_DIS21 field.
	USB_EPDMADIS_EP_DMA_DIS21_Msk = 0x200000   // Bit mask of EP_DMA_DIS21 field.
	USB_EPDMADIS_EP_DMA_DIS21     = 0x200000   // Bit EP_DMA_DIS21.
	USB_EPDMADIS_EP_DMA_DIS22_Pos = 0x16       // Position of EP_DMA_DIS22 field.
	USB_EPDMADIS_EP_DMA_DIS22_Msk = 0x400000   // Bit mask of EP_DMA_DIS22 field.
	USB_EPDMADIS_EP_DMA_DIS22     = 0x400000   // Bit EP_DMA_DIS22.
	USB_EPDMADIS_EP_DMA_DIS23_Pos = 0x17       // Position of EP_DMA_DIS23 field.
	USB_EPDMADIS_EP_DMA_DIS23_Msk = 0x800000   // Bit mask of EP_DMA_DIS23 field.
	USB_EPDMADIS_EP_DMA_DIS23     = 0x800000   // Bit EP_DMA_DIS23.
	USB_EPDMADIS_EP_DMA_DIS24_Pos = 0x18       // Position of EP_DMA_DIS24 field.
	USB_EPDMADIS_EP_DMA_DIS24_Msk = 0x1000000  // Bit mask of EP_DMA_DIS24 field.
	USB_EPDMADIS_EP_DMA_DIS24     = 0x1000000  // Bit EP_DMA_DIS24.
	USB_EPDMADIS_EP_DMA_DIS25_Pos = 0x19       // Position of EP_DMA_DIS25 field.
	USB_EPDMADIS_EP_DMA_DIS25_Msk = 0x2000000  // Bit mask of EP_DMA_DIS25 field.
	USB_EPDMADIS_EP_DMA_DIS25     = 0x2000000  // Bit EP_DMA_DIS25.
	USB_EPDMADIS_EP_DMA_DIS26_Pos = 0x1a       // Position of EP_DMA_DIS26 field.
	USB_EPDMADIS_EP_DMA_DIS26_Msk = 0x4000000  // Bit mask of EP_DMA_DIS26 field.
	USB_EPDMADIS_EP_DMA_DIS26     = 0x4000000  // Bit EP_DMA_DIS26.
	USB_EPDMADIS_EP_DMA_DIS27_Pos = 0x1b       // Position of EP_DMA_DIS27 field.
	USB_EPDMADIS_EP_DMA_DIS27_Msk = 0x8000000  // Bit mask of EP_DMA_DIS27 field.
	USB_EPDMADIS_EP_DMA_DIS27     = 0x8000000  // Bit EP_DMA_DIS27.
	USB_EPDMADIS_EP_DMA_DIS28_Pos = 0x1c       // Position of EP_DMA_DIS28 field.
	USB_EPDMADIS_EP_DMA_DIS28_Msk = 0x10000000 // Bit mask of EP_DMA_DIS28 field.
	USB_EPDMADIS_EP_DMA_DIS28     = 0x10000000 // Bit EP_DMA_DIS28.
	USB_EPDMADIS_EP_DMA_DIS29_Pos = 0x1d       // Position of EP_DMA_DIS29 field.
	USB_EPDMADIS_EP_DMA_DIS29_Msk = 0x20000000 // Bit mask of EP_DMA_DIS29 field.
	USB_EPDMADIS_EP_DMA_DIS29     = 0x20000000 // Bit EP_DMA_DIS29.
	USB_EPDMADIS_EP_DMA_DIS30_Pos = 0x1e       // Position of EP_DMA_DIS30 field.
	USB_EPDMADIS_EP_DMA_DIS30_Msk = 0x40000000 // Bit mask of EP_DMA_DIS30 field.
	USB_EPDMADIS_EP_DMA_DIS30     = 0x40000000 // Bit EP_DMA_DIS30.
	USB_EPDMADIS_EP_DMA_DIS31_Pos = 0x1f       // Position of EP_DMA_DIS31 field.
	USB_EPDMADIS_EP_DMA_DIS31_Msk = 0x80000000 // Bit mask of EP_DMA_DIS31 field.
	USB_EPDMADIS_EP_DMA_DIS31     = 0x80000000 // Bit EP_DMA_DIS31.

	// DMAINTST: USB DMA Interrupt Status
	USB_DMAINTST_EOT_Pos                   = 0x0        // Position of EOT field.
	USB_DMAINTST_EOT_Msk                   = 0x1        // Bit mask of EOT field.
	USB_DMAINTST_EOT                       = 0x1        // Bit EOT.
	USB_DMAINTST_EOT_ALL_BITS_IN_THE_USBE  = 0x0        // All bits in the USBEoTIntSt register are 0.
	USB_DMAINTST_EOT_AT_LEAST_ONE_BIT_IN_  = 0x1        // At least one bit in the USBEoTIntSt is set.
	USB_DMAINTST_NDDR_Pos                  = 0x1        // Position of NDDR field.
	USB_DMAINTST_NDDR_Msk                  = 0x2        // Bit mask of NDDR field.
	USB_DMAINTST_NDDR                      = 0x2        // Bit NDDR.
	USB_DMAINTST_NDDR_ALL_BITS_IN_THE_USBN = 0x0        // All bits in the USBNDDRIntSt register are 0.
	USB_DMAINTST_NDDR_AT_LEAST_ONE_BIT_IN_ = 0x1        // At least one bit in the USBNDDRIntSt is set.
	USB_DMAINTST_ERR_Pos                   = 0x2        // Position of ERR field.
	USB_DMAINTST_ERR_Msk                   = 0x4        // Bit mask of ERR field.
	USB_DMAINTST_ERR                       = 0x4        // Bit ERR.
	USB_DMAINTST_ERR_ALL_BITS_IN_THE_USBS  = 0x0        // All bits in the USBSysErrIntSt register are 0.
	USB_DMAINTST_ERR_AT_LEAST_ONE_BIT_IN_  = 0x1        // At least one bit in the USBSysErrIntSt is set.
	USB_DMAINTST_RESERVED_Pos              = 0x3        // Position of RESERVED field.
	USB_DMAINTST_RESERVED_Msk              = 0xfffffff8 // Bit mask of RESERVED field.

	// DMAINTEN: USB DMA Interrupt Enable
	USB_DMAINTEN_EOT_Pos        = 0x0        // Position of EOT field.
	USB_DMAINTEN_EOT_Msk        = 0x1        // Bit mask of EOT field.
	USB_DMAINTEN_EOT            = 0x1        // Bit EOT.
	USB_DMAINTEN_EOT_DISABLED_  = 0x0        // Disabled.
	USB_DMAINTEN_EOT_ENABLED_   = 0x1        // Enabled.
	USB_DMAINTEN_NDDR_Pos       = 0x1        // Position of NDDR field.
	USB_DMAINTEN_NDDR_Msk       = 0x2        // Bit mask of NDDR field.
	USB_DMAINTEN_NDDR           = 0x2        // Bit NDDR.
	USB_DMAINTEN_NDDR_DISABLED_ = 0x0        // Disabled.
	USB_DMAINTEN_NDDR_ENABLED_  = 0x1        // Enabled.
	USB_DMAINTEN_ERR_Pos        = 0x2        // Position of ERR field.
	USB_DMAINTEN_ERR_Msk        = 0x4        // Bit mask of ERR field.
	USB_DMAINTEN_ERR            = 0x4        // Bit ERR.
	USB_DMAINTEN_ERR_DISABLED_  = 0x0        // Disabled.
	USB_DMAINTEN_ERR_ENABLED_   = 0x1        // Enabled.
	USB_DMAINTEN_RESERVED_Pos   = 0x3        // Position of RESERVED field.
	USB_DMAINTEN_RESERVED_Msk   = 0xfffffff8 // Bit mask of RESERVED field.

	// EOTINTST: USB End of Transfer Interrupt Status
	USB_EOTINTST_EPTXINTST0_Pos  = 0x0        // Position of EPTXINTST0 field.
	USB_EOTINTST_EPTXINTST0_Msk  = 0x1        // Bit mask of EPTXINTST0 field.
	USB_EOTINTST_EPTXINTST0      = 0x1        // Bit EPTXINTST0.
	USB_EOTINTST_EPTXINTST1_Pos  = 0x1        // Position of EPTXINTST1 field.
	USB_EOTINTST_EPTXINTST1_Msk  = 0x2        // Bit mask of EPTXINTST1 field.
	USB_EOTINTST_EPTXINTST1      = 0x2        // Bit EPTXINTST1.
	USB_EOTINTST_EPTXINTST2_Pos  = 0x2        // Position of EPTXINTST2 field.
	USB_EOTINTST_EPTXINTST2_Msk  = 0x4        // Bit mask of EPTXINTST2 field.
	USB_EOTINTST_EPTXINTST2      = 0x4        // Bit EPTXINTST2.
	USB_EOTINTST_EPTXINTST3_Pos  = 0x3        // Position of EPTXINTST3 field.
	USB_EOTINTST_EPTXINTST3_Msk  = 0x8        // Bit mask of EPTXINTST3 field.
	USB_EOTINTST_EPTXINTST3      = 0x8        // Bit EPTXINTST3.
	USB_EOTINTST_EPTXINTST4_Pos  = 0x4        // Position of EPTXINTST4 field.
	USB_EOTINTST_EPTXINTST4_Msk  = 0x10       // Bit mask of EPTXINTST4 field.
	USB_EOTINTST_EPTXINTST4      = 0x10       // Bit EPTXINTST4.
	USB_EOTINTST_EPTXINTST5_Pos  = 0x5        // Position of EPTXINTST5 field.
	USB_EOTINTST_EPTXINTST5_Msk  = 0x20       // Bit mask of EPTXINTST5 field.
	USB_EOTINTST_EPTXINTST5      = 0x20       // Bit EPTXINTST5.
	USB_EOTINTST_EPTXINTST6_Pos  = 0x6        // Position of EPTXINTST6 field.
	USB_EOTINTST_EPTXINTST6_Msk  = 0x40       // Bit mask of EPTXINTST6 field.
	USB_EOTINTST_EPTXINTST6      = 0x40       // Bit EPTXINTST6.
	USB_EOTINTST_EPTXINTST7_Pos  = 0x7        // Position of EPTXINTST7 field.
	USB_EOTINTST_EPTXINTST7_Msk  = 0x80       // Bit mask of EPTXINTST7 field.
	USB_EOTINTST_EPTXINTST7      = 0x80       // Bit EPTXINTST7.
	USB_EOTINTST_EPTXINTST8_Pos  = 0x8        // Position of EPTXINTST8 field.
	USB_EOTINTST_EPTXINTST8_Msk  = 0x100      // Bit mask of EPTXINTST8 field.
	USB_EOTINTST_EPTXINTST8      = 0x100      // Bit EPTXINTST8.
	USB_EOTINTST_EPTXINTST9_Pos  = 0x9        // Position of EPTXINTST9 field.
	USB_EOTINTST_EPTXINTST9_Msk  = 0x200      // Bit mask of EPTXINTST9 field.
	USB_EOTINTST_EPTXINTST9      = 0x200      // Bit EPTXINTST9.
	USB_EOTINTST_EPTXINTST10_Pos = 0xa        // Position of EPTXINTST10 field.
	USB_EOTINTST_EPTXINTST10_Msk = 0x400      // Bit mask of EPTXINTST10 field.
	USB_EOTINTST_EPTXINTST10     = 0x400      // Bit EPTXINTST10.
	USB_EOTINTST_EPTXINTST11_Pos = 0xb        // Position of EPTXINTST11 field.
	USB_EOTINTST_EPTXINTST11_Msk = 0x800      // Bit mask of EPTXINTST11 field.
	USB_EOTINTST_EPTXINTST11     = 0x800      // Bit EPTXINTST11.
	USB_EOTINTST_EPTXINTST12_Pos = 0xc        // Position of EPTXINTST12 field.
	USB_EOTINTST_EPTXINTST12_Msk = 0x1000     // Bit mask of EPTXINTST12 field.
	USB_EOTINTST_EPTXINTST12     = 0x1000     // Bit EPTXINTST12.
	USB_EOTINTST_EPTXINTST13_Pos = 0xd        // Position of EPTXINTST13 field.
	USB_EOTINTST_EPTXINTST13_Msk = 0x2000     // Bit mask of EPTXINTST13 field.
	USB_EOTINTST_EPTXINTST13     = 0x2000     // Bit EPTXINTST13.
	USB_EOTINTST_EPTXINTST14_Pos = 0xe        // Position of EPTXINTST14 field.
	USB_EOTINTST_EPTXINTST14_Msk = 0x4000     // Bit mask of EPTXINTST14 field.
	USB_EOTINTST_EPTXINTST14     = 0x4000     // Bit EPTXINTST14.
	USB_EOTINTST_EPTXINTST15_Pos = 0xf        // Position of EPTXINTST15 field.
	USB_EOTINTST_EPTXINTST15_Msk = 0x8000     // Bit mask of EPTXINTST15 field.
	USB_EOTINTST_EPTXINTST15     = 0x8000     // Bit EPTXINTST15.
	USB_EOTINTST_EPTXINTST16_Pos = 0x10       // Position of EPTXINTST16 field.
	USB_EOTINTST_EPTXINTST16_Msk = 0x10000    // Bit mask of EPTXINTST16 field.
	USB_EOTINTST_EPTXINTST16     = 0x10000    // Bit EPTXINTST16.
	USB_EOTINTST_EPTXINTST17_Pos = 0x11       // Position of EPTXINTST17 field.
	USB_EOTINTST_EPTXINTST17_Msk = 0x20000    // Bit mask of EPTXINTST17 field.
	USB_EOTINTST_EPTXINTST17     = 0x20000    // Bit EPTXINTST17.
	USB_EOTINTST_EPTXINTST18_Pos = 0x12       // Position of EPTXINTST18 field.
	USB_EOTINTST_EPTXINTST18_Msk = 0x40000    // Bit mask of EPTXINTST18 field.
	USB_EOTINTST_EPTXINTST18     = 0x40000    // Bit EPTXINTST18.
	USB_EOTINTST_EPTXINTST19_Pos = 0x13       // Position of EPTXINTST19 field.
	USB_EOTINTST_EPTXINTST19_Msk = 0x80000    // Bit mask of EPTXINTST19 field.
	USB_EOTINTST_EPTXINTST19     = 0x80000    // Bit EPTXINTST19.
	USB_EOTINTST_EPTXINTST20_Pos = 0x14       // Position of EPTXINTST20 field.
	USB_EOTINTST_EPTXINTST20_Msk = 0x100000   // Bit mask of EPTXINTST20 field.
	USB_EOTINTST_EPTXINTST20     = 0x100000   // Bit EPTXINTST20.
	USB_EOTINTST_EPTXINTST21_Pos = 0x15       // Position of EPTXINTST21 field.
	USB_EOTINTST_EPTXINTST21_Msk = 0x200000   // Bit mask of EPTXINTST21 field.
	USB_EOTINTST_EPTXINTST21     = 0x200000   // Bit EPTXINTST21.
	USB_EOTINTST_EPTXINTST22_Pos = 0x16       // Position of EPTXINTST22 field.
	USB_EOTINTST_EPTXINTST22_Msk = 0x400000   // Bit mask of EPTXINTST22 field.
	USB_EOTINTST_EPTXINTST22     = 0x400000   // Bit EPTXINTST22.
	USB_EOTINTST_EPTXINTST23_Pos = 0x17       // Position of EPTXINTST23 field.
	USB_EOTINTST_EPTXINTST23_Msk = 0x800000   // Bit mask of EPTXINTST23 field.
	USB_EOTINTST_EPTXINTST23     = 0x800000   // Bit EPTXINTST23.
	USB_EOTINTST_EPTXINTST24_Pos = 0x18       // Position of EPTXINTST24 field.
	USB_EOTINTST_EPTXINTST24_Msk = 0x1000000  // Bit mask of EPTXINTST24 field.
	USB_EOTINTST_EPTXINTST24     = 0x1000000  // Bit EPTXINTST24.
	USB_EOTINTST_EPTXINTST25_Pos = 0x19       // Position of EPTXINTST25 field.
	USB_EOTINTST_EPTXINTST25_Msk = 0x2000000  // Bit mask of EPTXINTST25 field.
	USB_EOTINTST_EPTXINTST25     = 0x2000000  // Bit EPTXINTST25.
	USB_EOTINTST_EPTXINTST26_Pos = 0x1a       // Position of EPTXINTST26 field.
	USB_EOTINTST_EPTXINTST26_Msk = 0x4000000  // Bit mask of EPTXINTST26 field.
	USB_EOTINTST_EPTXINTST26     = 0x4000000  // Bit EPTXINTST26.
	USB_EOTINTST_EPTXINTST27_Pos = 0x1b       // Position of EPTXINTST27 field.
	USB_EOTINTST_EPTXINTST27_Msk = 0x8000000  // Bit mask of EPTXINTST27 field.
	USB_EOTINTST_EPTXINTST27     = 0x8000000  // Bit EPTXINTST27.
	USB_EOTINTST_EPTXINTST28_Pos = 0x1c       // Position of EPTXINTST28 field.
	USB_EOTINTST_EPTXINTST28_Msk = 0x10000000 // Bit mask of EPTXINTST28 field.
	USB_EOTINTST_EPTXINTST28     = 0x10000000 // Bit EPTXINTST28.
	USB_EOTINTST_EPTXINTST29_Pos = 0x1d       // Position of EPTXINTST29 field.
	USB_EOTINTST_EPTXINTST29_Msk = 0x20000000 // Bit mask of EPTXINTST29 field.
	USB_EOTINTST_EPTXINTST29     = 0x20000000 // Bit EPTXINTST29.
	USB_EOTINTST_EPTXINTST30_Pos = 0x1e       // Position of EPTXINTST30 field.
	USB_EOTINTST_EPTXINTST30_Msk = 0x40000000 // Bit mask of EPTXINTST30 field.
	USB_EOTINTST_EPTXINTST30     = 0x40000000 // Bit EPTXINTST30.
	USB_EOTINTST_EPTXINTST31_Pos = 0x1f       // Position of EPTXINTST31 field.
	USB_EOTINTST_EPTXINTST31_Msk = 0x80000000 // Bit mask of EPTXINTST31 field.
	USB_EOTINTST_EPTXINTST31     = 0x80000000 // Bit EPTXINTST31.

	// EOTINTCLR: USB End of Transfer Interrupt Clear
	USB_EOTINTCLR_EPTXINTCLR0_Pos  = 0x0        // Position of EPTXINTCLR0 field.
	USB_EOTINTCLR_EPTXINTCLR0_Msk  = 0x1        // Bit mask of EPTXINTCLR0 field.
	USB_EOTINTCLR_EPTXINTCLR0      = 0x1        // Bit EPTXINTCLR0.
	USB_EOTINTCLR_EPTXINTCLR1_Pos  = 0x1        // Position of EPTXINTCLR1 field.
	USB_EOTINTCLR_EPTXINTCLR1_Msk  = 0x2        // Bit mask of EPTXINTCLR1 field.
	USB_EOTINTCLR_EPTXINTCLR1      = 0x2        // Bit EPTXINTCLR1.
	USB_EOTINTCLR_EPTXINTCLR2_Pos  = 0x2        // Position of EPTXINTCLR2 field.
	USB_EOTINTCLR_EPTXINTCLR2_Msk  = 0x4        // Bit mask of EPTXINTCLR2 field.
	USB_EOTINTCLR_EPTXINTCLR2      = 0x4        // Bit EPTXINTCLR2.
	USB_EOTINTCLR_EPTXINTCLR3_Pos  = 0x3        // Position of EPTXINTCLR3 field.
	USB_EOTINTCLR_EPTXINTCLR3_Msk  = 0x8        // Bit mask of EPTXINTCLR3 field.
	USB_EOTINTCLR_EPTXINTCLR3      = 0x8        // Bit EPTXINTCLR3.
	USB_EOTINTCLR_EPTXINTCLR4_Pos  = 0x4        // Position of EPTXINTCLR4 field.
	USB_EOTINTCLR_EPTXINTCLR4_Msk  = 0x10       // Bit mask of EPTXINTCLR4 field.
	USB_EOTINTCLR_EPTXINTCLR4      = 0x10       // Bit EPTXINTCLR4.
	USB_EOTINTCLR_EPTXINTCLR5_Pos  = 0x5        // Position of EPTXINTCLR5 field.
	USB_EOTINTCLR_EPTXINTCLR5_Msk  = 0x20       // Bit mask of EPTXINTCLR5 field.
	USB_EOTINTCLR_EPTXINTCLR5      = 0x20       // Bit EPTXINTCLR5.
	USB_EOTINTCLR_EPTXINTCLR6_Pos  = 0x6        // Position of EPTXINTCLR6 field.
	USB_EOTINTCLR_EPTXINTCLR6_Msk  = 0x40       // Bit mask of EPTXINTCLR6 field.
	USB_EOTINTCLR_EPTXINTCLR6      = 0x40       // Bit EPTXINTCLR6.
	USB_EOTINTCLR_EPTXINTCLR7_Pos  = 0x7        // Position of EPTXINTCLR7 field.
	USB_EOTINTCLR_EPTXINTCLR7_Msk  = 0x80       // Bit mask of EPTXINTCLR7 field.
	USB_EOTINTCLR_EPTXINTCLR7      = 0x80       // Bit EPTXINTCLR7.
	USB_EOTINTCLR_EPTXINTCLR8_Pos  = 0x8        // Position of EPTXINTCLR8 field.
	USB_EOTINTCLR_EPTXINTCLR8_Msk  = 0x100      // Bit mask of EPTXINTCLR8 field.
	USB_EOTINTCLR_EPTXINTCLR8      = 0x100      // Bit EPTXINTCLR8.
	USB_EOTINTCLR_EPTXINTCLR9_Pos  = 0x9        // Position of EPTXINTCLR9 field.
	USB_EOTINTCLR_EPTXINTCLR9_Msk  = 0x200      // Bit mask of EPTXINTCLR9 field.
	USB_EOTINTCLR_EPTXINTCLR9      = 0x200      // Bit EPTXINTCLR9.
	USB_EOTINTCLR_EPTXINTCLR10_Pos = 0xa        // Position of EPTXINTCLR10 field.
	USB_EOTINTCLR_EPTXINTCLR10_Msk = 0x400      // Bit mask of EPTXINTCLR10 field.
	USB_EOTINTCLR_EPTXINTCLR10     = 0x400      // Bit EPTXINTCLR10.
	USB_EOTINTCLR_EPTXINTCLR11_Pos = 0xb        // Position of EPTXINTCLR11 field.
	USB_EOTINTCLR_EPTXINTCLR11_Msk = 0x800      // Bit mask of EPTXINTCLR11 field.
	USB_EOTINTCLR_EPTXINTCLR11     = 0x800      // Bit EPTXINTCLR11.
	USB_EOTINTCLR_EPTXINTCLR12_Pos = 0xc        // Position of EPTXINTCLR12 field.
	USB_EOTINTCLR_EPTXINTCLR12_Msk = 0x1000     // Bit mask of EPTXINTCLR12 field.
	USB_EOTINTCLR_EPTXINTCLR12     = 0x1000     // Bit EPTXINTCLR12.
	USB_EOTINTCLR_EPTXINTCLR13_Pos = 0xd        // Position of EPTXINTCLR13 field.
	USB_EOTINTCLR_EPTXINTCLR13_Msk = 0x2000     // Bit mask of EPTXINTCLR13 field.
	USB_EOTINTCLR_EPTXINTCLR13     = 0x2000     // Bit EPTXINTCLR13.
	USB_EOTINTCLR_EPTXINTCLR14_Pos = 0xe        // Position of EPTXINTCLR14 field.
	USB_EOTINTCLR_EPTXINTCLR14_Msk = 0x4000     // Bit mask of EPTXINTCLR14 field.
	USB_EOTINTCLR_EPTXINTCLR14     = 0x4000     // Bit EPTXINTCLR14.
	USB_EOTINTCLR_EPTXINTCLR15_Pos = 0xf        // Position of EPTXINTCLR15 field.
	USB_EOTINTCLR_EPTXINTCLR15_Msk = 0x8000     // Bit mask of EPTXINTCLR15 field.
	USB_EOTINTCLR_EPTXINTCLR15     = 0x8000     // Bit EPTXINTCLR15.
	USB_EOTINTCLR_EPTXINTCLR16_Pos = 0x10       // Position of EPTXINTCLR16 field.
	USB_EOTINTCLR_EPTXINTCLR16_Msk = 0x10000    // Bit mask of EPTXINTCLR16 field.
	USB_EOTINTCLR_EPTXINTCLR16     = 0x10000    // Bit EPTXINTCLR16.
	USB_EOTINTCLR_EPTXINTCLR17_Pos = 0x11       // Position of EPTXINTCLR17 field.
	USB_EOTINTCLR_EPTXINTCLR17_Msk = 0x20000    // Bit mask of EPTXINTCLR17 field.
	USB_EOTINTCLR_EPTXINTCLR17     = 0x20000    // Bit EPTXINTCLR17.
	USB_EOTINTCLR_EPTXINTCLR18_Pos = 0x12       // Position of EPTXINTCLR18 field.
	USB_EOTINTCLR_EPTXINTCLR18_Msk = 0x40000    // Bit mask of EPTXINTCLR18 field.
	USB_EOTINTCLR_EPTXINTCLR18     = 0x40000    // Bit EPTXINTCLR18.
	USB_EOTINTCLR_EPTXINTCLR19_Pos = 0x13       // Position of EPTXINTCLR19 field.
	USB_EOTINTCLR_EPTXINTCLR19_Msk = 0x80000    // Bit mask of EPTXINTCLR19 field.
	USB_EOTINTCLR_EPTXINTCLR19     = 0x80000    // Bit EPTXINTCLR19.
	USB_EOTINTCLR_EPTXINTCLR20_Pos = 0x14       // Position of EPTXINTCLR20 field.
	USB_EOTINTCLR_EPTXINTCLR20_Msk = 0x100000   // Bit mask of EPTXINTCLR20 field.
	USB_EOTINTCLR_EPTXINTCLR20     = 0x100000   // Bit EPTXINTCLR20.
	USB_EOTINTCLR_EPTXINTCLR21_Pos = 0x15       // Position of EPTXINTCLR21 field.
	USB_EOTINTCLR_EPTXINTCLR21_Msk = 0x200000   // Bit mask of EPTXINTCLR21 field.
	USB_EOTINTCLR_EPTXINTCLR21     = 0x200000   // Bit EPTXINTCLR21.
	USB_EOTINTCLR_EPTXINTCLR22_Pos = 0x16       // Position of EPTXINTCLR22 field.
	USB_EOTINTCLR_EPTXINTCLR22_Msk = 0x400000   // Bit mask of EPTXINTCLR22 field.
	USB_EOTINTCLR_EPTXINTCLR22     = 0x400000   // Bit EPTXINTCLR22.
	USB_EOTINTCLR_EPTXINTCLR23_Pos = 0x17       // Position of EPTXINTCLR23 field.
	USB_EOTINTCLR_EPTXINTCLR23_Msk = 0x800000   // Bit mask of EPTXINTCLR23 field.
	USB_EOTINTCLR_EPTXINTCLR23     = 0x800000   // Bit EPTXINTCLR23.
	USB_EOTINTCLR_EPTXINTCLR24_Pos = 0x18       // Position of EPTXINTCLR24 field.
	USB_EOTINTCLR_EPTXINTCLR24_Msk = 0x1000000  // Bit mask of EPTXINTCLR24 field.
	USB_EOTINTCLR_EPTXINTCLR24     = 0x1000000  // Bit EPTXINTCLR24.
	USB_EOTINTCLR_EPTXINTCLR25_Pos = 0x19       // Position of EPTXINTCLR25 field.
	USB_EOTINTCLR_EPTXINTCLR25_Msk = 0x2000000  // Bit mask of EPTXINTCLR25 field.
	USB_EOTINTCLR_EPTXINTCLR25     = 0x2000000  // Bit EPTXINTCLR25.
	USB_EOTINTCLR_EPTXINTCLR26_Pos = 0x1a       // Position of EPTXINTCLR26 field.
	USB_EOTINTCLR_EPTXINTCLR26_Msk = 0x4000000  // Bit mask of EPTXINTCLR26 field.
	USB_EOTINTCLR_EPTXINTCLR26     = 0x4000000  // Bit EPTXINTCLR26.
	USB_EOTINTCLR_EPTXINTCLR27_Pos = 0x1b       // Position of EPTXINTCLR27 field.
	USB_EOTINTCLR_EPTXINTCLR27_Msk = 0x8000000  // Bit mask of EPTXINTCLR27 field.
	USB_EOTINTCLR_EPTXINTCLR27     = 0x8000000  // Bit EPTXINTCLR27.
	USB_EOTINTCLR_EPTXINTCLR28_Pos = 0x1c       // Position of EPTXINTCLR28 field.
	USB_EOTINTCLR_EPTXINTCLR28_Msk = 0x10000000 // Bit mask of EPTXINTCLR28 field.
	USB_EOTINTCLR_EPTXINTCLR28     = 0x10000000 // Bit EPTXINTCLR28.
	USB_EOTINTCLR_EPTXINTCLR29_Pos = 0x1d       // Position of EPTXINTCLR29 field.
	USB_EOTINTCLR_EPTXINTCLR29_Msk = 0x20000000 // Bit mask of EPTXINTCLR29 field.
	USB_EOTINTCLR_EPTXINTCLR29     = 0x20000000 // Bit EPTXINTCLR29.
	USB_EOTINTCLR_EPTXINTCLR30_Pos = 0x1e       // Position of EPTXINTCLR30 field.
	USB_EOTINTCLR_EPTXINTCLR30_Msk = 0x40000000 // Bit mask of EPTXINTCLR30 field.
	USB_EOTINTCLR_EPTXINTCLR30     = 0x40000000 // Bit EPTXINTCLR30.
	USB_EOTINTCLR_EPTXINTCLR31_Pos = 0x1f       // Position of EPTXINTCLR31 field.
	USB_EOTINTCLR_EPTXINTCLR31_Msk = 0x80000000 // Bit mask of EPTXINTCLR31 field.
	USB_EOTINTCLR_EPTXINTCLR31     = 0x80000000 // Bit EPTXINTCLR31.

	// EOTINTSET: USB End of Transfer Interrupt Set
	USB_EOTINTSET_EPTXINTSET0_Pos  = 0x0        // Position of EPTXINTSET0 field.
	USB_EOTINTSET_EPTXINTSET0_Msk  = 0x1        // Bit mask of EPTXINTSET0 field.
	USB_EOTINTSET_EPTXINTSET0      = 0x1        // Bit EPTXINTSET0.
	USB_EOTINTSET_EPTXINTSET1_Pos  = 0x1        // Position of EPTXINTSET1 field.
	USB_EOTINTSET_EPTXINTSET1_Msk  = 0x2        // Bit mask of EPTXINTSET1 field.
	USB_EOTINTSET_EPTXINTSET1      = 0x2        // Bit EPTXINTSET1.
	USB_EOTINTSET_EPTXINTSET2_Pos  = 0x2        // Position of EPTXINTSET2 field.
	USB_EOTINTSET_EPTXINTSET2_Msk  = 0x4        // Bit mask of EPTXINTSET2 field.
	USB_EOTINTSET_EPTXINTSET2      = 0x4        // Bit EPTXINTSET2.
	USB_EOTINTSET_EPTXINTSET3_Pos  = 0x3        // Position of EPTXINTSET3 field.
	USB_EOTINTSET_EPTXINTSET3_Msk  = 0x8        // Bit mask of EPTXINTSET3 field.
	USB_EOTINTSET_EPTXINTSET3      = 0x8        // Bit EPTXINTSET3.
	USB_EOTINTSET_EPTXINTSET4_Pos  = 0x4        // Position of EPTXINTSET4 field.
	USB_EOTINTSET_EPTXINTSET4_Msk  = 0x10       // Bit mask of EPTXINTSET4 field.
	USB_EOTINTSET_EPTXINTSET4      = 0x10       // Bit EPTXINTSET4.
	USB_EOTINTSET_EPTXINTSET5_Pos  = 0x5        // Position of EPTXINTSET5 field.
	USB_EOTINTSET_EPTXINTSET5_Msk  = 0x20       // Bit mask of EPTXINTSET5 field.
	USB_EOTINTSET_EPTXINTSET5      = 0x20       // Bit EPTXINTSET5.
	USB_EOTINTSET_EPTXINTSET6_Pos  = 0x6        // Position of EPTXINTSET6 field.
	USB_EOTINTSET_EPTXINTSET6_Msk  = 0x40       // Bit mask of EPTXINTSET6 field.
	USB_EOTINTSET_EPTXINTSET6      = 0x40       // Bit EPTXINTSET6.
	USB_EOTINTSET_EPTXINTSET7_Pos  = 0x7        // Position of EPTXINTSET7 field.
	USB_EOTINTSET_EPTXINTSET7_Msk  = 0x80       // Bit mask of EPTXINTSET7 field.
	USB_EOTINTSET_EPTXINTSET7      = 0x80       // Bit EPTXINTSET7.
	USB_EOTINTSET_EPTXINTSET8_Pos  = 0x8        // Position of EPTXINTSET8 field.
	USB_EOTINTSET_EPTXINTSET8_Msk  = 0x100      // Bit mask of EPTXINTSET8 field.
	USB_EOTINTSET_EPTXINTSET8      = 0x100      // Bit EPTXINTSET8.
	USB_EOTINTSET_EPTXINTSET9_Pos  = 0x9        // Position of EPTXINTSET9 field.
	USB_EOTINTSET_EPTXINTSET9_Msk  = 0x200      // Bit mask of EPTXINTSET9 field.
	USB_EOTINTSET_EPTXINTSET9      = 0x200      // Bit EPTXINTSET9.
	USB_EOTINTSET_EPTXINTSET10_Pos = 0xa        // Position of EPTXINTSET10 field.
	USB_EOTINTSET_EPTXINTSET10_Msk = 0x400      // Bit mask of EPTXINTSET10 field.
	USB_EOTINTSET_EPTXINTSET10     = 0x400      // Bit EPTXINTSET10.
	USB_EOTINTSET_EPTXINTSET11_Pos = 0xb        // Position of EPTXINTSET11 field.
	USB_EOTINTSET_EPTXINTSET11_Msk = 0x800      // Bit mask of EPTXINTSET11 field.
	USB_EOTINTSET_EPTXINTSET11     = 0x800      // Bit EPTXINTSET11.
	USB_EOTINTSET_EPTXINTSET12_Pos = 0xc        // Position of EPTXINTSET12 field.
	USB_EOTINTSET_EPTXINTSET12_Msk = 0x1000     // Bit mask of EPTXINTSET12 field.
	USB_EOTINTSET_EPTXINTSET12     = 0x1000     // Bit EPTXINTSET12.
	USB_EOTINTSET_EPTXINTSET13_Pos = 0xd        // Position of EPTXINTSET13 field.
	USB_EOTINTSET_EPTXINTSET13_Msk = 0x2000     // Bit mask of EPTXINTSET13 field.
	USB_EOTINTSET_EPTXINTSET13     = 0x2000     // Bit EPTXINTSET13.
	USB_EOTINTSET_EPTXINTSET14_Pos = 0xe        // Position of EPTXINTSET14 field.
	USB_EOTINTSET_EPTXINTSET14_Msk = 0x4000     // Bit mask of EPTXINTSET14 field.
	USB_EOTINTSET_EPTXINTSET14     = 0x4000     // Bit EPTXINTSET14.
	USB_EOTINTSET_EPTXINTSET15_Pos = 0xf        // Position of EPTXINTSET15 field.
	USB_EOTINTSET_EPTXINTSET15_Msk = 0x8000     // Bit mask of EPTXINTSET15 field.
	USB_EOTINTSET_EPTXINTSET15     = 0x8000     // Bit EPTXINTSET15.
	USB_EOTINTSET_EPTXINTSET16_Pos = 0x10       // Position of EPTXINTSET16 field.
	USB_EOTINTSET_EPTXINTSET16_Msk = 0x10000    // Bit mask of EPTXINTSET16 field.
	USB_EOTINTSET_EPTXINTSET16     = 0x10000    // Bit EPTXINTSET16.
	USB_EOTINTSET_EPTXINTSET17_Pos = 0x11       // Position of EPTXINTSET17 field.
	USB_EOTINTSET_EPTXINTSET17_Msk = 0x20000    // Bit mask of EPTXINTSET17 field.
	USB_EOTINTSET_EPTXINTSET17     = 0x20000    // Bit EPTXINTSET17.
	USB_EOTINTSET_EPTXINTSET18_Pos = 0x12       // Position of EPTXINTSET18 field.
	USB_EOTINTSET_EPTXINTSET18_Msk = 0x40000    // Bit mask of EPTXINTSET18 field.
	USB_EOTINTSET_EPTXINTSET18     = 0x40000    // Bit EPTXINTSET18.
	USB_EOTINTSET_EPTXINTSET19_Pos = 0x13       // Position of EPTXINTSET19 field.
	USB_EOTINTSET_EPTXINTSET19_Msk = 0x80000    // Bit mask of EPTXINTSET19 field.
	USB_EOTINTSET_EPTXINTSET19     = 0x80000    // Bit EPTXINTSET19.
	USB_EOTINTSET_EPTXINTSET20_Pos = 0x14       // Position of EPTXINTSET20 field.
	USB_EOTINTSET_EPTXINTSET20_Msk = 0x100000   // Bit mask of EPTXINTSET20 field.
	USB_EOTINTSET_EPTXINTSET20     = 0x100000   // Bit EPTXINTSET20.
	USB_EOTINTSET_EPTXINTSET21_Pos = 0x15       // Position of EPTXINTSET21 field.
	USB_EOTINTSET_EPTXINTSET21_Msk = 0x200000   // Bit mask of EPTXINTSET21 field.
	USB_EOTINTSET_EPTXINTSET21     = 0x200000   // Bit EPTXINTSET21.
	USB_EOTINTSET_EPTXINTSET22_Pos = 0x16       // Position of EPTXINTSET22 field.
	USB_EOTINTSET_EPTXINTSET22_Msk = 0x400000   // Bit mask of EPTXINTSET22 field.
	USB_EOTINTSET_EPTXINTSET22     = 0x400000   // Bit EPTXINTSET22.
	USB_EOTINTSET_EPTXINTSET23_Pos = 0x17       // Position of EPTXINTSET23 field.
	USB_EOTINTSET_EPTXINTSET23_Msk = 0x800000   // Bit mask of EPTXINTSET23 field.
	USB_EOTINTSET_EPTXINTSET23     = 0x800000   // Bit EPTXINTSET23.
	USB_EOTINTSET_EPTXINTSET24_Pos = 0x18       // Position of EPTXINTSET24 field.
	USB_EOTINTSET_EPTXINTSET24_Msk = 0x1000000  // Bit mask of EPTXINTSET24 field.
	USB_EOTINTSET_EPTXINTSET24     = 0x1000000  // Bit EPTXINTSET24.
	USB_EOTINTSET_EPTXINTSET25_Pos = 0x19       // Position of EPTXINTSET25 field.
	USB_EOTINTSET_EPTXINTSET25_Msk = 0x2000000  // Bit mask of EPTXINTSET25 field.
	USB_EOTINTSET_EPTXINTSET25     = 0x2000000  // Bit EPTXINTSET25.
	USB_EOTINTSET_EPTXINTSET26_Pos = 0x1a       // Position of EPTXINTSET26 field.
	USB_EOTINTSET_EPTXINTSET26_Msk = 0x4000000  // Bit mask of EPTXINTSET26 field.
	USB_EOTINTSET_EPTXINTSET26     = 0x4000000  // Bit EPTXINTSET26.
	USB_EOTINTSET_EPTXINTSET27_Pos = 0x1b       // Position of EPTXINTSET27 field.
	USB_EOTINTSET_EPTXINTSET27_Msk = 0x8000000  // Bit mask of EPTXINTSET27 field.
	USB_EOTINTSET_EPTXINTSET27     = 0x8000000  // Bit EPTXINTSET27.
	USB_EOTINTSET_EPTXINTSET28_Pos = 0x1c       // Position of EPTXINTSET28 field.
	USB_EOTINTSET_EPTXINTSET28_Msk = 0x10000000 // Bit mask of EPTXINTSET28 field.
	USB_EOTINTSET_EPTXINTSET28     = 0x10000000 // Bit EPTXINTSET28.
	USB_EOTINTSET_EPTXINTSET29_Pos = 0x1d       // Position of EPTXINTSET29 field.
	USB_EOTINTSET_EPTXINTSET29_Msk = 0x20000000 // Bit mask of EPTXINTSET29 field.
	USB_EOTINTSET_EPTXINTSET29     = 0x20000000 // Bit EPTXINTSET29.
	USB_EOTINTSET_EPTXINTSET30_Pos = 0x1e       // Position of EPTXINTSET30 field.
	USB_EOTINTSET_EPTXINTSET30_Msk = 0x40000000 // Bit mask of EPTXINTSET30 field.
	USB_EOTINTSET_EPTXINTSET30     = 0x40000000 // Bit EPTXINTSET30.
	USB_EOTINTSET_EPTXINTSET31_Pos = 0x1f       // Position of EPTXINTSET31 field.
	USB_EOTINTSET_EPTXINTSET31_Msk = 0x80000000 // Bit mask of EPTXINTSET31 field.
	USB_EOTINTSET_EPTXINTSET31     = 0x80000000 // Bit EPTXINTSET31.

	// NDDRINTST: USB New DD Request Interrupt Status
	USB_NDDRINTST_EPNDDINTST0_Pos  = 0x0        // Position of EPNDDINTST0 field.
	USB_NDDRINTST_EPNDDINTST0_Msk  = 0x1        // Bit mask of EPNDDINTST0 field.
	USB_NDDRINTST_EPNDDINTST0      = 0x1        // Bit EPNDDINTST0.
	USB_NDDRINTST_EPNDDINTST1_Pos  = 0x1        // Position of EPNDDINTST1 field.
	USB_NDDRINTST_EPNDDINTST1_Msk  = 0x2        // Bit mask of EPNDDINTST1 field.
	USB_NDDRINTST_EPNDDINTST1      = 0x2        // Bit EPNDDINTST1.
	USB_NDDRINTST_EPNDDINTST2_Pos  = 0x2        // Position of EPNDDINTST2 field.
	USB_NDDRINTST_EPNDDINTST2_Msk  = 0x4        // Bit mask of EPNDDINTST2 field.
	USB_NDDRINTST_EPNDDINTST2      = 0x4        // Bit EPNDDINTST2.
	USB_NDDRINTST_EPNDDINTST3_Pos  = 0x3        // Position of EPNDDINTST3 field.
	USB_NDDRINTST_EPNDDINTST3_Msk  = 0x8        // Bit mask of EPNDDINTST3 field.
	USB_NDDRINTST_EPNDDINTST3      = 0x8        // Bit EPNDDINTST3.
	USB_NDDRINTST_EPNDDINTST4_Pos  = 0x4        // Position of EPNDDINTST4 field.
	USB_NDDRINTST_EPNDDINTST4_Msk  = 0x10       // Bit mask of EPNDDINTST4 field.
	USB_NDDRINTST_EPNDDINTST4      = 0x10       // Bit EPNDDINTST4.
	USB_NDDRINTST_EPNDDINTST5_Pos  = 0x5        // Position of EPNDDINTST5 field.
	USB_NDDRINTST_EPNDDINTST5_Msk  = 0x20       // Bit mask of EPNDDINTST5 field.
	USB_NDDRINTST_EPNDDINTST5      = 0x20       // Bit EPNDDINTST5.
	USB_NDDRINTST_EPNDDINTST6_Pos  = 0x6        // Position of EPNDDINTST6 field.
	USB_NDDRINTST_EPNDDINTST6_Msk  = 0x40       // Bit mask of EPNDDINTST6 field.
	USB_NDDRINTST_EPNDDINTST6      = 0x40       // Bit EPNDDINTST6.
	USB_NDDRINTST_EPNDDINTST7_Pos  = 0x7        // Position of EPNDDINTST7 field.
	USB_NDDRINTST_EPNDDINTST7_Msk  = 0x80       // Bit mask of EPNDDINTST7 field.
	USB_NDDRINTST_EPNDDINTST7      = 0x80       // Bit EPNDDINTST7.
	USB_NDDRINTST_EPNDDINTST8_Pos  = 0x8        // Position of EPNDDINTST8 field.
	USB_NDDRINTST_EPNDDINTST8_Msk  = 0x100      // Bit mask of EPNDDINTST8 field.
	USB_NDDRINTST_EPNDDINTST8      = 0x100      // Bit EPNDDINTST8.
	USB_NDDRINTST_EPNDDINTST9_Pos  = 0x9        // Position of EPNDDINTST9 field.
	USB_NDDRINTST_EPNDDINTST9_Msk  = 0x200      // Bit mask of EPNDDINTST9 field.
	USB_NDDRINTST_EPNDDINTST9      = 0x200      // Bit EPNDDINTST9.
	USB_NDDRINTST_EPNDDINTST10_Pos = 0xa        // Position of EPNDDINTST10 field.
	USB_NDDRINTST_EPNDDINTST10_Msk = 0x400      // Bit mask of EPNDDINTST10 field.
	USB_NDDRINTST_EPNDDINTST10     = 0x400      // Bit EPNDDINTST10.
	USB_NDDRINTST_EPNDDINTST11_Pos = 0xb        // Position of EPNDDINTST11 field.
	USB_NDDRINTST_EPNDDINTST11_Msk = 0x800      // Bit mask of EPNDDINTST11 field.
	USB_NDDRINTST_EPNDDINTST11     = 0x800      // Bit EPNDDINTST11.
	USB_NDDRINTST_EPNDDINTST12_Pos = 0xc        // Position of EPNDDINTST12 field.
	USB_NDDRINTST_EPNDDINTST12_Msk = 0x1000     // Bit mask of EPNDDINTST12 field.
	USB_NDDRINTST_EPNDDINTST12     = 0x1000     // Bit EPNDDINTST12.
	USB_NDDRINTST_EPNDDINTST13_Pos = 0xd        // Position of EPNDDINTST13 field.
	USB_NDDRINTST_EPNDDINTST13_Msk = 0x2000     // Bit mask of EPNDDINTST13 field.
	USB_NDDRINTST_EPNDDINTST13     = 0x2000     // Bit EPNDDINTST13.
	USB_NDDRINTST_EPNDDINTST14_Pos = 0xe        // Position of EPNDDINTST14 field.
	USB_NDDRINTST_EPNDDINTST14_Msk = 0x4000     // Bit mask of EPNDDINTST14 field.
	USB_NDDRINTST_EPNDDINTST14     = 0x4000     // Bit EPNDDINTST14.
	USB_NDDRINTST_EPNDDINTST15_Pos = 0xf        // Position of EPNDDINTST15 field.
	USB_NDDRINTST_EPNDDINTST15_Msk = 0x8000     // Bit mask of EPNDDINTST15 field.
	USB_NDDRINTST_EPNDDINTST15     = 0x8000     // Bit EPNDDINTST15.
	USB_NDDRINTST_EPNDDINTST16_Pos = 0x10       // Position of EPNDDINTST16 field.
	USB_NDDRINTST_EPNDDINTST16_Msk = 0x10000    // Bit mask of EPNDDINTST16 field.
	USB_NDDRINTST_EPNDDINTST16     = 0x10000    // Bit EPNDDINTST16.
	USB_NDDRINTST_EPNDDINTST17_Pos = 0x11       // Position of EPNDDINTST17 field.
	USB_NDDRINTST_EPNDDINTST17_Msk = 0x20000    // Bit mask of EPNDDINTST17 field.
	USB_NDDRINTST_EPNDDINTST17     = 0x20000    // Bit EPNDDINTST17.
	USB_NDDRINTST_EPNDDINTST18_Pos = 0x12       // Position of EPNDDINTST18 field.
	USB_NDDRINTST_EPNDDINTST18_Msk = 0x40000    // Bit mask of EPNDDINTST18 field.
	USB_NDDRINTST_EPNDDINTST18     = 0x40000    // Bit EPNDDINTST18.
	USB_NDDRINTST_EPNDDINTST19_Pos = 0x13       // Position of EPNDDINTST19 field.
	USB_NDDRINTST_EPNDDINTST19_Msk = 0x80000    // Bit mask of EPNDDINTST19 field.
	USB_NDDRINTST_EPNDDINTST19     = 0x80000    // Bit EPNDDINTST19.
	USB_NDDRINTST_EPNDDINTST20_Pos = 0x14       // Position of EPNDDINTST20 field.
	USB_NDDRINTST_EPNDDINTST20_Msk = 0x100000   // Bit mask of EPNDDINTST20 field.
	USB_NDDRINTST_EPNDDINTST20     = 0x100000   // Bit EPNDDINTST20.
	USB_NDDRINTST_EPNDDINTST21_Pos = 0x15       // Position of EPNDDINTST21 field.
	USB_NDDRINTST_EPNDDINTST21_Msk = 0x200000   // Bit mask of EPNDDINTST21 field.
	USB_NDDRINTST_EPNDDINTST21     = 0x200000   // Bit EPNDDINTST21.
	USB_NDDRINTST_EPNDDINTST22_Pos = 0x16       // Position of EPNDDINTST22 field.
	USB_NDDRINTST_EPNDDINTST22_Msk = 0x400000   // Bit mask of EPNDDINTST22 field.
	USB_NDDRINTST_EPNDDINTST22     = 0x400000   // Bit EPNDDINTST22.
	USB_NDDRINTST_EPNDDINTST23_Pos = 0x17       // Position of EPNDDINTST23 field.
	USB_NDDRINTST_EPNDDINTST23_Msk = 0x800000   // Bit mask of EPNDDINTST23 field.
	USB_NDDRINTST_EPNDDINTST23     = 0x800000   // Bit EPNDDINTST23.
	USB_NDDRINTST_EPNDDINTST24_Pos = 0x18       // Position of EPNDDINTST24 field.
	USB_NDDRINTST_EPNDDINTST24_Msk = 0x1000000  // Bit mask of EPNDDINTST24 field.
	USB_NDDRINTST_EPNDDINTST24     = 0x1000000  // Bit EPNDDINTST24.
	USB_NDDRINTST_EPNDDINTST25_Pos = 0x19       // Position of EPNDDINTST25 field.
	USB_NDDRINTST_EPNDDINTST25_Msk = 0x2000000  // Bit mask of EPNDDINTST25 field.
	USB_NDDRINTST_EPNDDINTST25     = 0x2000000  // Bit EPNDDINTST25.
	USB_NDDRINTST_EPNDDINTST26_Pos = 0x1a       // Position of EPNDDINTST26 field.
	USB_NDDRINTST_EPNDDINTST26_Msk = 0x4000000  // Bit mask of EPNDDINTST26 field.
	USB_NDDRINTST_EPNDDINTST26     = 0x4000000  // Bit EPNDDINTST26.
	USB_NDDRINTST_EPNDDINTST27_Pos = 0x1b       // Position of EPNDDINTST27 field.
	USB_NDDRINTST_EPNDDINTST27_Msk = 0x8000000  // Bit mask of EPNDDINTST27 field.
	USB_NDDRINTST_EPNDDINTST27     = 0x8000000  // Bit EPNDDINTST27.
	USB_NDDRINTST_EPNDDINTST28_Pos = 0x1c       // Position of EPNDDINTST28 field.
	USB_NDDRINTST_EPNDDINTST28_Msk = 0x10000000 // Bit mask of EPNDDINTST28 field.
	USB_NDDRINTST_EPNDDINTST28     = 0x10000000 // Bit EPNDDINTST28.
	USB_NDDRINTST_EPNDDINTST29_Pos = 0x1d       // Position of EPNDDINTST29 field.
	USB_NDDRINTST_EPNDDINTST29_Msk = 0x20000000 // Bit mask of EPNDDINTST29 field.
	USB_NDDRINTST_EPNDDINTST29     = 0x20000000 // Bit EPNDDINTST29.
	USB_NDDRINTST_EPNDDINTST30_Pos = 0x1e       // Position of EPNDDINTST30 field.
	USB_NDDRINTST_EPNDDINTST30_Msk = 0x40000000 // Bit mask of EPNDDINTST30 field.
	USB_NDDRINTST_EPNDDINTST30     = 0x40000000 // Bit EPNDDINTST30.
	USB_NDDRINTST_EPNDDINTST31_Pos = 0x1f       // Position of EPNDDINTST31 field.
	USB_NDDRINTST_EPNDDINTST31_Msk = 0x80000000 // Bit mask of EPNDDINTST31 field.
	USB_NDDRINTST_EPNDDINTST31     = 0x80000000 // Bit EPNDDINTST31.

	// NDDRINTCLR: USB New DD Request Interrupt Clear
	USB_NDDRINTCLR_EPNDDINTCLR0_Pos  = 0x0        // Position of EPNDDINTCLR0 field.
	USB_NDDRINTCLR_EPNDDINTCLR0_Msk  = 0x1        // Bit mask of EPNDDINTCLR0 field.
	USB_NDDRINTCLR_EPNDDINTCLR0      = 0x1        // Bit EPNDDINTCLR0.
	USB_NDDRINTCLR_EPNDDINTCLR1_Pos  = 0x1        // Position of EPNDDINTCLR1 field.
	USB_NDDRINTCLR_EPNDDINTCLR1_Msk  = 0x2        // Bit mask of EPNDDINTCLR1 field.
	USB_NDDRINTCLR_EPNDDINTCLR1      = 0x2        // Bit EPNDDINTCLR1.
	USB_NDDRINTCLR_EPNDDINTCLR2_Pos  = 0x2        // Position of EPNDDINTCLR2 field.
	USB_NDDRINTCLR_EPNDDINTCLR2_Msk  = 0x4        // Bit mask of EPNDDINTCLR2 field.
	USB_NDDRINTCLR_EPNDDINTCLR2      = 0x4        // Bit EPNDDINTCLR2.
	USB_NDDRINTCLR_EPNDDINTCLR3_Pos  = 0x3        // Position of EPNDDINTCLR3 field.
	USB_NDDRINTCLR_EPNDDINTCLR3_Msk  = 0x8        // Bit mask of EPNDDINTCLR3 field.
	USB_NDDRINTCLR_EPNDDINTCLR3      = 0x8        // Bit EPNDDINTCLR3.
	USB_NDDRINTCLR_EPNDDINTCLR4_Pos  = 0x4        // Position of EPNDDINTCLR4 field.
	USB_NDDRINTCLR_EPNDDINTCLR4_Msk  = 0x10       // Bit mask of EPNDDINTCLR4 field.
	USB_NDDRINTCLR_EPNDDINTCLR4      = 0x10       // Bit EPNDDINTCLR4.
	USB_NDDRINTCLR_EPNDDINTCLR5_Pos  = 0x5        // Position of EPNDDINTCLR5 field.
	USB_NDDRINTCLR_EPNDDINTCLR5_Msk  = 0x20       // Bit mask of EPNDDINTCLR5 field.
	USB_NDDRINTCLR_EPNDDINTCLR5      = 0x20       // Bit EPNDDINTCLR5.
	USB_NDDRINTCLR_EPNDDINTCLR6_Pos  = 0x6        // Position of EPNDDINTCLR6 field.
	USB_NDDRINTCLR_EPNDDINTCLR6_Msk  = 0x40       // Bit mask of EPNDDINTCLR6 field.
	USB_NDDRINTCLR_EPNDDINTCLR6      = 0x40       // Bit EPNDDINTCLR6.
	USB_NDDRINTCLR_EPNDDINTCLR7_Pos  = 0x7        // Position of EPNDDINTCLR7 field.
	USB_NDDRINTCLR_EPNDDINTCLR7_Msk  = 0x80       // Bit mask of EPNDDINTCLR7 field.
	USB_NDDRINTCLR_EPNDDINTCLR7      = 0x80       // Bit EPNDDINTCLR7.
	USB_NDDRINTCLR_EPNDDINTCLR8_Pos  = 0x8        // Position of EPNDDINTCLR8 field.
	USB_NDDRINTCLR_EPNDDINTCLR8_Msk  = 0x100      // Bit mask of EPNDDINTCLR8 field.
	USB_NDDRINTCLR_EPNDDINTCLR8      = 0x100      // Bit EPNDDINTCLR8.
	USB_NDDRINTCLR_EPNDDINTCLR9_Pos  = 0x9        // Position of EPNDDINTCLR9 field.
	USB_NDDRINTCLR_EPNDDINTCLR9_Msk  = 0x200      // Bit mask of EPNDDINTCLR9 field.
	USB_NDDRINTCLR_EPNDDINTCLR9      = 0x200      // Bit EPNDDINTCLR9.
	USB_NDDRINTCLR_EPNDDINTCLR10_Pos = 0xa        // Position of EPNDDINTCLR10 field.
	USB_NDDRINTCLR_EPNDDINTCLR10_Msk = 0x400      // Bit mask of EPNDDINTCLR10 field.
	USB_NDDRINTCLR_EPNDDINTCLR10     = 0x400      // Bit EPNDDINTCLR10.
	USB_NDDRINTCLR_EPNDDINTCLR11_Pos = 0xb        // Position of EPNDDINTCLR11 field.
	USB_NDDRINTCLR_EPNDDINTCLR11_Msk = 0x800      // Bit mask of EPNDDINTCLR11 field.
	USB_NDDRINTCLR_EPNDDINTCLR11     = 0x800      // Bit EPNDDINTCLR11.
	USB_NDDRINTCLR_EPNDDINTCLR12_Pos = 0xc        // Position of EPNDDINTCLR12 field.
	USB_NDDRINTCLR_EPNDDINTCLR12_Msk = 0x1000     // Bit mask of EPNDDINTCLR12 field.
	USB_NDDRINTCLR_EPNDDINTCLR12     = 0x1000     // Bit EPNDDINTCLR12.
	USB_NDDRINTCLR_EPNDDINTCLR13_Pos = 0xd        // Position of EPNDDINTCLR13 field.
	USB_NDDRINTCLR_EPNDDINTCLR13_Msk = 0x2000     // Bit mask of EPNDDINTCLR13 field.
	USB_NDDRINTCLR_EPNDDINTCLR13     = 0x2000     // Bit EPNDDINTCLR13.
	USB_NDDRINTCLR_EPNDDINTCLR14_Pos = 0xe        // Position of EPNDDINTCLR14 field.
	USB_NDDRINTCLR_EPNDDINTCLR14_Msk = 0x4000     // Bit mask of EPNDDINTCLR14 field.
	USB_NDDRINTCLR_EPNDDINTCLR14     = 0x4000     // Bit EPNDDINTCLR14.
	USB_NDDRINTCLR_EPNDDINTCLR15_Pos = 0xf        // Position of EPNDDINTCLR15 field.
	USB_NDDRINTCLR_EPNDDINTCLR15_Msk = 0x8000     // Bit mask of EPNDDINTCLR15 field.
	USB_NDDRINTCLR_EPNDDINTCLR15     = 0x8000     // Bit EPNDDINTCLR15.
	USB_NDDRINTCLR_EPNDDINTCLR16_Pos = 0x10       // Position of EPNDDINTCLR16 field.
	USB_NDDRINTCLR_EPNDDINTCLR16_Msk = 0x10000    // Bit mask of EPNDDINTCLR16 field.
	USB_NDDRINTCLR_EPNDDINTCLR16     = 0x10000    // Bit EPNDDINTCLR16.
	USB_NDDRINTCLR_EPNDDINTCLR17_Pos = 0x11       // Position of EPNDDINTCLR17 field.
	USB_NDDRINTCLR_EPNDDINTCLR17_Msk = 0x20000    // Bit mask of EPNDDINTCLR17 field.
	USB_NDDRINTCLR_EPNDDINTCLR17     = 0x20000    // Bit EPNDDINTCLR17.
	USB_NDDRINTCLR_EPNDDINTCLR18_Pos = 0x12       // Position of EPNDDINTCLR18 field.
	USB_NDDRINTCLR_EPNDDINTCLR18_Msk = 0x40000    // Bit mask of EPNDDINTCLR18 field.
	USB_NDDRINTCLR_EPNDDINTCLR18     = 0x40000    // Bit EPNDDINTCLR18.
	USB_NDDRINTCLR_EPNDDINTCLR19_Pos = 0x13       // Position of EPNDDINTCLR19 field.
	USB_NDDRINTCLR_EPNDDINTCLR19_Msk = 0x80000    // Bit mask of EPNDDINTCLR19 field.
	USB_NDDRINTCLR_EPNDDINTCLR19     = 0x80000    // Bit EPNDDINTCLR19.
	USB_NDDRINTCLR_EPNDDINTCLR20_Pos = 0x14       // Position of EPNDDINTCLR20 field.
	USB_NDDRINTCLR_EPNDDINTCLR20_Msk = 0x100000   // Bit mask of EPNDDINTCLR20 field.
	USB_NDDRINTCLR_EPNDDINTCLR20     = 0x100000   // Bit EPNDDINTCLR20.
	USB_NDDRINTCLR_EPNDDINTCLR21_Pos = 0x15       // Position of EPNDDINTCLR21 field.
	USB_NDDRINTCLR_EPNDDINTCLR21_Msk = 0x200000   // Bit mask of EPNDDINTCLR21 field.
	USB_NDDRINTCLR_EPNDDINTCLR21     = 0x200000   // Bit EPNDDINTCLR21.
	USB_NDDRINTCLR_EPNDDINTCLR22_Pos = 0x16       // Position of EPNDDINTCLR22 field.
	USB_NDDRINTCLR_EPNDDINTCLR22_Msk = 0x400000   // Bit mask of EPNDDINTCLR22 field.
	USB_NDDRINTCLR_EPNDDINTCLR22     = 0x400000   // Bit EPNDDINTCLR22.
	USB_NDDRINTCLR_EPNDDINTCLR23_Pos = 0x17       // Position of EPNDDINTCLR23 field.
	USB_NDDRINTCLR_EPNDDINTCLR23_Msk = 0x800000   // Bit mask of EPNDDINTCLR23 field.
	USB_NDDRINTCLR_EPNDDINTCLR23     = 0x800000   // Bit EPNDDINTCLR23.
	USB_NDDRINTCLR_EPNDDINTCLR24_Pos = 0x18       // Position of EPNDDINTCLR24 field.
	USB_NDDRINTCLR_EPNDDINTCLR24_Msk = 0x1000000  // Bit mask of EPNDDINTCLR24 field.
	USB_NDDRINTCLR_EPNDDINTCLR24     = 0x1000000  // Bit EPNDDINTCLR24.
	USB_NDDRINTCLR_EPNDDINTCLR25_Pos = 0x19       // Position of EPNDDINTCLR25 field.
	USB_NDDRINTCLR_EPNDDINTCLR25_Msk = 0x2000000  // Bit mask of EPNDDINTCLR25 field.
	USB_NDDRINTCLR_EPNDDINTCLR25     = 0x2000000  // Bit EPNDDINTCLR25.
	USB_NDDRINTCLR_EPNDDINTCLR26_Pos = 0x1a       // Position of EPNDDINTCLR26 field.
	USB_NDDRINTCLR_EPNDDINTCLR26_Msk = 0x4000000  // Bit mask of EPNDDINTCLR26 field.
	USB_NDDRINTCLR_EPNDDINTCLR26     = 0x4000000  // Bit EPNDDINTCLR26.
	USB_NDDRINTCLR_EPNDDINTCLR27_Pos = 0x1b       // Position of EPNDDINTCLR27 field.
	USB_NDDRINTCLR_EPNDDINTCLR27_Msk = 0x8000000  // Bit mask of EPNDDINTCLR27 field.
	USB_NDDRINTCLR_EPNDDINTCLR27     = 0x8000000  // Bit EPNDDINTCLR27.
	USB_NDDRINTCLR_EPNDDINTCLR28_Pos = 0x1c       // Position of EPNDDINTCLR28 field.
	USB_NDDRINTCLR_EPNDDINTCLR28_Msk = 0x10000000 // Bit mask of EPNDDINTCLR28 field.
	USB_NDDRINTCLR_EPNDDINTCLR28     = 0x10000000 // Bit EPNDDINTCLR28.
	USB_NDDRINTCLR_EPNDDINTCLR29_Pos = 0x1d       // Position of EPNDDINTCLR29 field.
	USB_NDDRINTCLR_EPNDDINTCLR29_Msk = 0x20000000 // Bit mask of EPNDDINTCLR29 field.
	USB_NDDRINTCLR_EPNDDINTCLR29     = 0x20000000 // Bit EPNDDINTCLR29.
	USB_NDDRINTCLR_EPNDDINTCLR30_Pos = 0x1e       // Position of EPNDDINTCLR30 field.
	USB_NDDRINTCLR_EPNDDINTCLR30_Msk = 0x40000000 // Bit mask of EPNDDINTCLR30 field.
	USB_NDDRINTCLR_EPNDDINTCLR30     = 0x40000000 // Bit EPNDDINTCLR30.
	USB_NDDRINTCLR_EPNDDINTCLR31_Pos = 0x1f       // Position of EPNDDINTCLR31 field.
	USB_NDDRINTCLR_EPNDDINTCLR31_Msk = 0x80000000 // Bit mask of EPNDDINTCLR31 field.
	USB_NDDRINTCLR_EPNDDINTCLR31     = 0x80000000 // Bit EPNDDINTCLR31.

	// NDDRINTSET: USB New DD Request Interrupt Set
	USB_NDDRINTSET_EPNDDINTSET0_Pos  = 0x0        // Position of EPNDDINTSET0 field.
	USB_NDDRINTSET_EPNDDINTSET0_Msk  = 0x1        // Bit mask of EPNDDINTSET0 field.
	USB_NDDRINTSET_EPNDDINTSET0      = 0x1        // Bit EPNDDINTSET0.
	USB_NDDRINTSET_EPNDDINTSET1_Pos  = 0x1        // Position of EPNDDINTSET1 field.
	USB_NDDRINTSET_EPNDDINTSET1_Msk  = 0x2        // Bit mask of EPNDDINTSET1 field.
	USB_NDDRINTSET_EPNDDINTSET1      = 0x2        // Bit EPNDDINTSET1.
	USB_NDDRINTSET_EPNDDINTSET2_Pos  = 0x2        // Position of EPNDDINTSET2 field.
	USB_NDDRINTSET_EPNDDINTSET2_Msk  = 0x4        // Bit mask of EPNDDINTSET2 field.
	USB_NDDRINTSET_EPNDDINTSET2      = 0x4        // Bit EPNDDINTSET2.
	USB_NDDRINTSET_EPNDDINTSET3_Pos  = 0x3        // Position of EPNDDINTSET3 field.
	USB_NDDRINTSET_EPNDDINTSET3_Msk  = 0x8        // Bit mask of EPNDDINTSET3 field.
	USB_NDDRINTSET_EPNDDINTSET3      = 0x8        // Bit EPNDDINTSET3.
	USB_NDDRINTSET_EPNDDINTSET4_Pos  = 0x4        // Position of EPNDDINTSET4 field.
	USB_NDDRINTSET_EPNDDINTSET4_Msk  = 0x10       // Bit mask of EPNDDINTSET4 field.
	USB_NDDRINTSET_EPNDDINTSET4      = 0x10       // Bit EPNDDINTSET4.
	USB_NDDRINTSET_EPNDDINTSET5_Pos  = 0x5        // Position of EPNDDINTSET5 field.
	USB_NDDRINTSET_EPNDDINTSET5_Msk  = 0x20       // Bit mask of EPNDDINTSET5 field.
	USB_NDDRINTSET_EPNDDINTSET5      = 0x20       // Bit EPNDDINTSET5.
	USB_NDDRINTSET_EPNDDINTSET6_Pos  = 0x6        // Position of EPNDDINTSET6 field.
	USB_NDDRINTSET_EPNDDINTSET6_Msk  = 0x40       // Bit mask of EPNDDINTSET6 field.
	USB_NDDRINTSET_EPNDDINTSET6      = 0x40       // Bit EPNDDINTSET6.
	USB_NDDRINTSET_EPNDDINTSET7_Pos  = 0x7        // Position of EPNDDINTSET7 field.
	USB_NDDRINTSET_EPNDDINTSET7_Msk  = 0x80       // Bit mask of EPNDDINTSET7 field.
	USB_NDDRINTSET_EPNDDINTSET7      = 0x80       // Bit EPNDDINTSET7.
	USB_NDDRINTSET_EPNDDINTSET8_Pos  = 0x8        // Position of EPNDDINTSET8 field.
	USB_NDDRINTSET_EPNDDINTSET8_Msk  = 0x100      // Bit mask of EPNDDINTSET8 field.
	USB_NDDRINTSET_EPNDDINTSET8      = 0x100      // Bit EPNDDINTSET8.
	USB_NDDRINTSET_EPNDDINTSET9_Pos  = 0x9        // Position of EPNDDINTSET9 field.
	USB_NDDRINTSET_EPNDDINTSET9_Msk  = 0x200      // Bit mask of EPNDDINTSET9 field.
	USB_NDDRINTSET_EPNDDINTSET9      = 0x200      // Bit EPNDDINTSET9.
	USB_NDDRINTSET_EPNDDINTSET10_Pos = 0xa        // Position of EPNDDINTSET10 field.
	USB_NDDRINTSET_EPNDDINTSET10_Msk = 0x400      // Bit mask of EPNDDINTSET10 field.
	USB_NDDRINTSET_EPNDDINTSET10     = 0x400      // Bit EPNDDINTSET10.
	USB_NDDRINTSET_EPNDDINTSET11_Pos = 0xb        // Position of EPNDDINTSET11 field.
	USB_NDDRINTSET_EPNDDINTSET11_Msk = 0x800      // Bit mask of EPNDDINTSET11 field.
	USB_NDDRINTSET_EPNDDINTSET11     = 0x800      // Bit EPNDDINTSET11.
	USB_NDDRINTSET_EPNDDINTSET12_Pos = 0xc        // Position of EPNDDINTSET12 field.
	USB_NDDRINTSET_EPNDDINTSET12_Msk = 0x1000     // Bit mask of EPNDDINTSET12 field.
	USB_NDDRINTSET_EPNDDINTSET12     = 0x1000     // Bit EPNDDINTSET12.
	USB_NDDRINTSET_EPNDDINTSET13_Pos = 0xd        // Position of EPNDDINTSET13 field.
	USB_NDDRINTSET_EPNDDINTSET13_Msk = 0x2000     // Bit mask of EPNDDINTSET13 field.
	USB_NDDRINTSET_EPNDDINTSET13     = 0x2000     // Bit EPNDDINTSET13.
	USB_NDDRINTSET_EPNDDINTSET14_Pos = 0xe        // Position of EPNDDINTSET14 field.
	USB_NDDRINTSET_EPNDDINTSET14_Msk = 0x4000     // Bit mask of EPNDDINTSET14 field.
	USB_NDDRINTSET_EPNDDINTSET14     = 0x4000     // Bit EPNDDINTSET14.
	USB_NDDRINTSET_EPNDDINTSET15_Pos = 0xf        // Position of EPNDDINTSET15 field.
	USB_NDDRINTSET_EPNDDINTSET15_Msk = 0x8000     // Bit mask of EPNDDINTSET15 field.
	USB_NDDRINTSET_EPNDDINTSET15     = 0x8000     // Bit EPNDDINTSET15.
	USB_NDDRINTSET_EPNDDINTSET16_Pos = 0x10       // Position of EPNDDINTSET16 field.
	USB_NDDRINTSET_EPNDDINTSET16_Msk = 0x10000    // Bit mask of EPNDDINTSET16 field.
	USB_NDDRINTSET_EPNDDINTSET16     = 0x10000    // Bit EPNDDINTSET16.
	USB_NDDRINTSET_EPNDDINTSET17_Pos = 0x11       // Position of EPNDDINTSET17 field.
	USB_NDDRINTSET_EPNDDINTSET17_Msk = 0x20000    // Bit mask of EPNDDINTSET17 field.
	USB_NDDRINTSET_EPNDDINTSET17     = 0x20000    // Bit EPNDDINTSET17.
	USB_NDDRINTSET_EPNDDINTSET18_Pos = 0x12       // Position of EPNDDINTSET18 field.
	USB_NDDRINTSET_EPNDDINTSET18_Msk = 0x40000    // Bit mask of EPNDDINTSET18 field.
	USB_NDDRINTSET_EPNDDINTSET18     = 0x40000    // Bit EPNDDINTSET18.
	USB_NDDRINTSET_EPNDDINTSET19_Pos = 0x13       // Position of EPNDDINTSET19 field.
	USB_NDDRINTSET_EPNDDINTSET19_Msk = 0x80000    // Bit mask of EPNDDINTSET19 field.
	USB_NDDRINTSET_EPNDDINTSET19     = 0x80000    // Bit EPNDDINTSET19.
	USB_NDDRINTSET_EPNDDINTSET20_Pos = 0x14       // Position of EPNDDINTSET20 field.
	USB_NDDRINTSET_EPNDDINTSET20_Msk = 0x100000   // Bit mask of EPNDDINTSET20 field.
	USB_NDDRINTSET_EPNDDINTSET20     = 0x100000   // Bit EPNDDINTSET20.
	USB_NDDRINTSET_EPNDDINTSET21_Pos = 0x15       // Position of EPNDDINTSET21 field.
	USB_NDDRINTSET_EPNDDINTSET21_Msk = 0x200000   // Bit mask of EPNDDINTSET21 field.
	USB_NDDRINTSET_EPNDDINTSET21     = 0x200000   // Bit EPNDDINTSET21.
	USB_NDDRINTSET_EPNDDINTSET22_Pos = 0x16       // Position of EPNDDINTSET22 field.
	USB_NDDRINTSET_EPNDDINTSET22_Msk = 0x400000   // Bit mask of EPNDDINTSET22 field.
	USB_NDDRINTSET_EPNDDINTSET22     = 0x400000   // Bit EPNDDINTSET22.
	USB_NDDRINTSET_EPNDDINTSET23_Pos = 0x17       // Position of EPNDDINTSET23 field.
	USB_NDDRINTSET_EPNDDINTSET23_Msk = 0x800000   // Bit mask of EPNDDINTSET23 field.
	USB_NDDRINTSET_EPNDDINTSET23     = 0x800000   // Bit EPNDDINTSET23.
	USB_NDDRINTSET_EPNDDINTSET24_Pos = 0x18       // Position of EPNDDINTSET24 field.
	USB_NDDRINTSET_EPNDDINTSET24_Msk = 0x1000000  // Bit mask of EPNDDINTSET24 field.
	USB_NDDRINTSET_EPNDDINTSET24     = 0x1000000  // Bit EPNDDINTSET24.
	USB_NDDRINTSET_EPNDDINTSET25_Pos = 0x19       // Position of EPNDDINTSET25 field.
	USB_NDDRINTSET_EPNDDINTSET25_Msk = 0x2000000  // Bit mask of EPNDDINTSET25 field.
	USB_NDDRINTSET_EPNDDINTSET25     = 0x2000000  // Bit EPNDDINTSET25.
	USB_NDDRINTSET_EPNDDINTSET26_Pos = 0x1a       // Position of EPNDDINTSET26 field.
	USB_NDDRINTSET_EPNDDINTSET26_Msk = 0x4000000  // Bit mask of EPNDDINTSET26 field.
	USB_NDDRINTSET_EPNDDINTSET26     = 0x4000000  // Bit EPNDDINTSET26.
	USB_NDDRINTSET_EPNDDINTSET27_Pos = 0x1b       // Position of EPNDDINTSET27 field.
	USB_NDDRINTSET_EPNDDINTSET27_Msk = 0x8000000  // Bit mask of EPNDDINTSET27 field.
	USB_NDDRINTSET_EPNDDINTSET27     = 0x8000000  // Bit EPNDDINTSET27.
	USB_NDDRINTSET_EPNDDINTSET28_Pos = 0x1c       // Position of EPNDDINTSET28 field.
	USB_NDDRINTSET_EPNDDINTSET28_Msk = 0x10000000 // Bit mask of EPNDDINTSET28 field.
	USB_NDDRINTSET_EPNDDINTSET28     = 0x10000000 // Bit EPNDDINTSET28.
	USB_NDDRINTSET_EPNDDINTSET29_Pos = 0x1d       // Position of EPNDDINTSET29 field.
	USB_NDDRINTSET_EPNDDINTSET29_Msk = 0x20000000 // Bit mask of EPNDDINTSET29 field.
	USB_NDDRINTSET_EPNDDINTSET29     = 0x20000000 // Bit EPNDDINTSET29.
	USB_NDDRINTSET_EPNDDINTSET30_Pos = 0x1e       // Position of EPNDDINTSET30 field.
	USB_NDDRINTSET_EPNDDINTSET30_Msk = 0x40000000 // Bit mask of EPNDDINTSET30 field.
	USB_NDDRINTSET_EPNDDINTSET30     = 0x40000000 // Bit EPNDDINTSET30.
	USB_NDDRINTSET_EPNDDINTSET31_Pos = 0x1f       // Position of EPNDDINTSET31 field.
	USB_NDDRINTSET_EPNDDINTSET31_Msk = 0x80000000 // Bit mask of EPNDDINTSET31 field.
	USB_NDDRINTSET_EPNDDINTSET31     = 0x80000000 // Bit EPNDDINTSET31.

	// SYSERRINTST: USB System Error Interrupt Status
	USB_SYSERRINTST_EPERRINTST0_Pos  = 0x0        // Position of EPERRINTST0 field.
	USB_SYSERRINTST_EPERRINTST0_Msk  = 0x1        // Bit mask of EPERRINTST0 field.
	USB_SYSERRINTST_EPERRINTST0      = 0x1        // Bit EPERRINTST0.
	USB_SYSERRINTST_EPERRINTST1_Pos  = 0x1        // Position of EPERRINTST1 field.
	USB_SYSERRINTST_EPERRINTST1_Msk  = 0x2        // Bit mask of EPERRINTST1 field.
	USB_SYSERRINTST_EPERRINTST1      = 0x2        // Bit EPERRINTST1.
	USB_SYSERRINTST_EPERRINTST2_Pos  = 0x2        // Position of EPERRINTST2 field.
	USB_SYSERRINTST_EPERRINTST2_Msk  = 0x4        // Bit mask of EPERRINTST2 field.
	USB_SYSERRINTST_EPERRINTST2      = 0x4        // Bit EPERRINTST2.
	USB_SYSERRINTST_EPERRINTST3_Pos  = 0x3        // Position of EPERRINTST3 field.
	USB_SYSERRINTST_EPERRINTST3_Msk  = 0x8        // Bit mask of EPERRINTST3 field.
	USB_SYSERRINTST_EPERRINTST3      = 0x8        // Bit EPERRINTST3.
	USB_SYSERRINTST_EPERRINTST4_Pos  = 0x4        // Position of EPERRINTST4 field.
	USB_SYSERRINTST_EPERRINTST4_Msk  = 0x10       // Bit mask of EPERRINTST4 field.
	USB_SYSERRINTST_EPERRINTST4      = 0x10       // Bit EPERRINTST4.
	USB_SYSERRINTST_EPERRINTST5_Pos  = 0x5        // Position of EPERRINTST5 field.
	USB_SYSERRINTST_EPERRINTST5_Msk  = 0x20       // Bit mask of EPERRINTST5 field.
	USB_SYSERRINTST_EPERRINTST5      = 0x20       // Bit EPERRINTST5.
	USB_SYSERRINTST_EPERRINTST6_Pos  = 0x6        // Position of EPERRINTST6 field.
	USB_SYSERRINTST_EPERRINTST6_Msk  = 0x40       // Bit mask of EPERRINTST6 field.
	USB_SYSERRINTST_EPERRINTST6      = 0x40       // Bit EPERRINTST6.
	USB_SYSERRINTST_EPERRINTST7_Pos  = 0x7        // Position of EPERRINTST7 field.
	USB_SYSERRINTST_EPERRINTST7_Msk  = 0x80       // Bit mask of EPERRINTST7 field.
	USB_SYSERRINTST_EPERRINTST7      = 0x80       // Bit EPERRINTST7.
	USB_SYSERRINTST_EPERRINTST8_Pos  = 0x8        // Position of EPERRINTST8 field.
	USB_SYSERRINTST_EPERRINTST8_Msk  = 0x100      // Bit mask of EPERRINTST8 field.
	USB_SYSERRINTST_EPERRINTST8      = 0x100      // Bit EPERRINTST8.
	USB_SYSERRINTST_EPERRINTST9_Pos  = 0x9        // Position of EPERRINTST9 field.
	USB_SYSERRINTST_EPERRINTST9_Msk  = 0x200      // Bit mask of EPERRINTST9 field.
	USB_SYSERRINTST_EPERRINTST9      = 0x200      // Bit EPERRINTST9.
	USB_SYSERRINTST_EPERRINTST10_Pos = 0xa        // Position of EPERRINTST10 field.
	USB_SYSERRINTST_EPERRINTST10_Msk = 0x400      // Bit mask of EPERRINTST10 field.
	USB_SYSERRINTST_EPERRINTST10     = 0x400      // Bit EPERRINTST10.
	USB_SYSERRINTST_EPERRINTST11_Pos = 0xb        // Position of EPERRINTST11 field.
	USB_SYSERRINTST_EPERRINTST11_Msk = 0x800      // Bit mask of EPERRINTST11 field.
	USB_SYSERRINTST_EPERRINTST11     = 0x800      // Bit EPERRINTST11.
	USB_SYSERRINTST_EPERRINTST12_Pos = 0xc        // Position of EPERRINTST12 field.
	USB_SYSERRINTST_EPERRINTST12_Msk = 0x1000     // Bit mask of EPERRINTST12 field.
	USB_SYSERRINTST_EPERRINTST12     = 0x1000     // Bit EPERRINTST12.
	USB_SYSERRINTST_EPERRINTST13_Pos = 0xd        // Position of EPERRINTST13 field.
	USB_SYSERRINTST_EPERRINTST13_Msk = 0x2000     // Bit mask of EPERRINTST13 field.
	USB_SYSERRINTST_EPERRINTST13     = 0x2000     // Bit EPERRINTST13.
	USB_SYSERRINTST_EPERRINTST14_Pos = 0xe        // Position of EPERRINTST14 field.
	USB_SYSERRINTST_EPERRINTST14_Msk = 0x4000     // Bit mask of EPERRINTST14 field.
	USB_SYSERRINTST_EPERRINTST14     = 0x4000     // Bit EPERRINTST14.
	USB_SYSERRINTST_EPERRINTST15_Pos = 0xf        // Position of EPERRINTST15 field.
	USB_SYSERRINTST_EPERRINTST15_Msk = 0x8000     // Bit mask of EPERRINTST15 field.
	USB_SYSERRINTST_EPERRINTST15     = 0x8000     // Bit EPERRINTST15.
	USB_SYSERRINTST_EPERRINTST16_Pos = 0x10       // Position of EPERRINTST16 field.
	USB_SYSERRINTST_EPERRINTST16_Msk = 0x10000    // Bit mask of EPERRINTST16 field.
	USB_SYSERRINTST_EPERRINTST16     = 0x10000    // Bit EPERRINTST16.
	USB_SYSERRINTST_EPERRINTST17_Pos = 0x11       // Position of EPERRINTST17 field.
	USB_SYSERRINTST_EPERRINTST17_Msk = 0x20000    // Bit mask of EPERRINTST17 field.
	USB_SYSERRINTST_EPERRINTST17     = 0x20000    // Bit EPERRINTST17.
	USB_SYSERRINTST_EPERRINTST18_Pos = 0x12       // Position of EPERRINTST18 field.
	USB_SYSERRINTST_EPERRINTST18_Msk = 0x40000    // Bit mask of EPERRINTST18 field.
	USB_SYSERRINTST_EPERRINTST18     = 0x40000    // Bit EPERRINTST18.
	USB_SYSERRINTST_EPERRINTST19_Pos = 0x13       // Position of EPERRINTST19 field.
	USB_SYSERRINTST_EPERRINTST19_Msk = 0x80000    // Bit mask of EPERRINTST19 field.
	USB_SYSERRINTST_EPERRINTST19     = 0x80000    // Bit EPERRINTST19.
	USB_SYSERRINTST_EPERRINTST20_Pos = 0x14       // Position of EPERRINTST20 field.
	USB_SYSERRINTST_EPERRINTST20_Msk = 0x100000   // Bit mask of EPERRINTST20 field.
	USB_SYSERRINTST_EPERRINTST20     = 0x100000   // Bit EPERRINTST20.
	USB_SYSERRINTST_EPERRINTST21_Pos = 0x15       // Position of EPERRINTST21 field.
	USB_SYSERRINTST_EPERRINTST21_Msk = 0x200000   // Bit mask of EPERRINTST21 field.
	USB_SYSERRINTST_EPERRINTST21     = 0x200000   // Bit EPERRINTST21.
	USB_SYSERRINTST_EPERRINTST22_Pos = 0x16       // Position of EPERRINTST22 field.
	USB_SYSERRINTST_EPERRINTST22_Msk = 0x400000   // Bit mask of EPERRINTST22 field.
	USB_SYSERRINTST_EPERRINTST22     = 0x400000   // Bit EPERRINTST22.
	USB_SYSERRINTST_EPERRINTST23_Pos = 0x17       // Position of EPERRINTST23 field.
	USB_SYSERRINTST_EPERRINTST23_Msk = 0x800000   // Bit mask of EPERRINTST23 field.
	USB_SYSERRINTST_EPERRINTST23     = 0x800000   // Bit EPERRINTST23.
	USB_SYSERRINTST_EPERRINTST24_Pos = 0x18       // Position of EPERRINTST24 field.
	USB_SYSERRINTST_EPERRINTST24_Msk = 0x1000000  // Bit mask of EPERRINTST24 field.
	USB_SYSERRINTST_EPERRINTST24     = 0x1000000  // Bit EPERRINTST24.
	USB_SYSERRINTST_EPERRINTST25_Pos = 0x19       // Position of EPERRINTST25 field.
	USB_SYSERRINTST_EPERRINTST25_Msk = 0x2000000  // Bit mask of EPERRINTST25 field.
	USB_SYSERRINTST_EPERRINTST25     = 0x2000000  // Bit EPERRINTST25.
	USB_SYSERRINTST_EPERRINTST26_Pos = 0x1a       // Position of EPERRINTST26 field.
	USB_SYSERRINTST_EPERRINTST26_Msk = 0x4000000  // Bit mask of EPERRINTST26 field.
	USB_SYSERRINTST_EPERRINTST26     = 0x4000000  // Bit EPERRINTST26.
	USB_SYSERRINTST_EPERRINTST27_Pos = 0x1b       // Position of EPERRINTST27 field.
	USB_SYSERRINTST_EPERRINTST27_Msk = 0x8000000  // Bit mask of EPERRINTST27 field.
	USB_SYSERRINTST_EPERRINTST27     = 0x8000000  // Bit EPERRINTST27.
	USB_SYSERRINTST_EPERRINTST28_Pos = 0x1c       // Position of EPERRINTST28 field.
	USB_SYSERRINTST_EPERRINTST28_Msk = 0x10000000 // Bit mask of EPERRINTST28 field.
	USB_SYSERRINTST_EPERRINTST28     = 0x10000000 // Bit EPERRINTST28.
	USB_SYSERRINTST_EPERRINTST29_Pos = 0x1d       // Position of EPERRINTST29 field.
	USB_SYSERRINTST_EPERRINTST29_Msk = 0x20000000 // Bit mask of EPERRINTST29 field.
	USB_SYSERRINTST_EPERRINTST29     = 0x20000000 // Bit EPERRINTST29.
	USB_SYSERRINTST_EPERRINTST30_Pos = 0x1e       // Position of EPERRINTST30 field.
	USB_SYSERRINTST_EPERRINTST30_Msk = 0x40000000 // Bit mask of EPERRINTST30 field.
	USB_SYSERRINTST_EPERRINTST30     = 0x40000000 // Bit EPERRINTST30.
	USB_SYSERRINTST_EPERRINTST31_Pos = 0x1f       // Position of EPERRINTST31 field.
	USB_SYSERRINTST_EPERRINTST31_Msk = 0x80000000 // Bit mask of EPERRINTST31 field.
	USB_SYSERRINTST_EPERRINTST31     = 0x80000000 // Bit EPERRINTST31.

	// SYSERRINTCLR: USB System Error Interrupt Clear
	USB_SYSERRINTCLR_EPERRINTCLR0_Pos  = 0x0        // Position of EPERRINTCLR0 field.
	USB_SYSERRINTCLR_EPERRINTCLR0_Msk  = 0x1        // Bit mask of EPERRINTCLR0 field.
	USB_SYSERRINTCLR_EPERRINTCLR0      = 0x1        // Bit EPERRINTCLR0.
	USB_SYSERRINTCLR_EPERRINTCLR1_Pos  = 0x1        // Position of EPERRINTCLR1 field.
	USB_SYSERRINTCLR_EPERRINTCLR1_Msk  = 0x2        // Bit mask of EPERRINTCLR1 field.
	USB_SYSERRINTCLR_EPERRINTCLR1      = 0x2        // Bit EPERRINTCLR1.
	USB_SYSERRINTCLR_EPERRINTCLR2_Pos  = 0x2        // Position of EPERRINTCLR2 field.
	USB_SYSERRINTCLR_EPERRINTCLR2_Msk  = 0x4        // Bit mask of EPERRINTCLR2 field.
	USB_SYSERRINTCLR_EPERRINTCLR2      = 0x4        // Bit EPERRINTCLR2.
	USB_SYSERRINTCLR_EPERRINTCLR3_Pos  = 0x3        // Position of EPERRINTCLR3 field.
	USB_SYSERRINTCLR_EPERRINTCLR3_Msk  = 0x8        // Bit mask of EPERRINTCLR3 field.
	USB_SYSERRINTCLR_EPERRINTCLR3      = 0x8        // Bit EPERRINTCLR3.
	USB_SYSERRINTCLR_EPERRINTCLR4_Pos  = 0x4        // Position of EPERRINTCLR4 field.
	USB_SYSERRINTCLR_EPERRINTCLR4_Msk  = 0x10       // Bit mask of EPERRINTCLR4 field.
	USB_SYSERRINTCLR_EPERRINTCLR4      = 0x10       // Bit EPERRINTCLR4.
	USB_SYSERRINTCLR_EPERRINTCLR5_Pos  = 0x5        // Position of EPERRINTCLR5 field.
	USB_SYSERRINTCLR_EPERRINTCLR5_Msk  = 0x20       // Bit mask of EPERRINTCLR5 field.
	USB_SYSERRINTCLR_EPERRINTCLR5      = 0x20       // Bit EPERRINTCLR5.
	USB_SYSERRINTCLR_EPERRINTCLR6_Pos  = 0x6        // Position of EPERRINTCLR6 field.
	USB_SYSERRINTCLR_EPERRINTCLR6_Msk  = 0x40       // Bit mask of EPERRINTCLR6 field.
	USB_SYSERRINTCLR_EPERRINTCLR6      = 0x40       // Bit EPERRINTCLR6.
	USB_SYSERRINTCLR_EPERRINTCLR7_Pos  = 0x7        // Position of EPERRINTCLR7 field.
	USB_SYSERRINTCLR_EPERRINTCLR7_Msk  = 0x80       // Bit mask of EPERRINTCLR7 field.
	USB_SYSERRINTCLR_EPERRINTCLR7      = 0x80       // Bit EPERRINTCLR7.
	USB_SYSERRINTCLR_EPERRINTCLR8_Pos  = 0x8        // Position of EPERRINTCLR8 field.
	USB_SYSERRINTCLR_EPERRINTCLR8_Msk  = 0x100      // Bit mask of EPERRINTCLR8 field.
	USB_SYSERRINTCLR_EPERRINTCLR8      = 0x100      // Bit EPERRINTCLR8.
	USB_SYSERRINTCLR_EPERRINTCLR9_Pos  = 0x9        // Position of EPERRINTCLR9 field.
	USB_SYSERRINTCLR_EPERRINTCLR9_Msk  = 0x200      // Bit mask of EPERRINTCLR9 field.
	USB_SYSERRINTCLR_EPERRINTCLR9      = 0x200      // Bit EPERRINTCLR9.
	USB_SYSERRINTCLR_EPERRINTCLR10_Pos = 0xa        // Position of EPERRINTCLR10 field.
	USB_SYSERRINTCLR_EPERRINTCLR10_Msk = 0x400      // Bit mask of EPERRINTCLR10 field.
	USB_SYSERRINTCLR_EPERRINTCLR10     = 0x400      // Bit EPERRINTCLR10.
	USB_SYSERRINTCLR_EPERRINTCLR11_Pos = 0xb        // Position of EPERRINTCLR11 field.
	USB_SYSERRINTCLR_EPERRINTCLR11_Msk = 0x800      // Bit mask of EPERRINTCLR11 field.
	USB_SYSERRINTCLR_EPERRINTCLR11     = 0x800      // Bit EPERRINTCLR11.
	USB_SYSERRINTCLR_EPERRINTCLR12_Pos = 0xc        // Position of EPERRINTCLR12 field.
	USB_SYSERRINTCLR_EPERRINTCLR12_Msk = 0x1000     // Bit mask of EPERRINTCLR12 field.
	USB_SYSERRINTCLR_EPERRINTCLR12     = 0x1000     // Bit EPERRINTCLR12.
	USB_SYSERRINTCLR_EPERRINTCLR13_Pos = 0xd        // Position of EPERRINTCLR13 field.
	USB_SYSERRINTCLR_EPERRINTCLR13_Msk = 0x2000     // Bit mask of EPERRINTCLR13 field.
	USB_SYSERRINTCLR_EPERRINTCLR13     = 0x2000     // Bit EPERRINTCLR13.
	USB_SYSERRINTCLR_EPERRINTCLR14_Pos = 0xe        // Position of EPERRINTCLR14 field.
	USB_SYSERRINTCLR_EPERRINTCLR14_Msk = 0x4000     // Bit mask of EPERRINTCLR14 field.
	USB_SYSERRINTCLR_EPERRINTCLR14     = 0x4000     // Bit EPERRINTCLR14.
	USB_SYSERRINTCLR_EPERRINTCLR15_Pos = 0xf        // Position of EPERRINTCLR15 field.
	USB_SYSERRINTCLR_EPERRINTCLR15_Msk = 0x8000     // Bit mask of EPERRINTCLR15 field.
	USB_SYSERRINTCLR_EPERRINTCLR15     = 0x8000     // Bit EPERRINTCLR15.
	USB_SYSERRINTCLR_EPERRINTCLR16_Pos = 0x10       // Position of EPERRINTCLR16 field.
	USB_SYSERRINTCLR_EPERRINTCLR16_Msk = 0x10000    // Bit mask of EPERRINTCLR16 field.
	USB_SYSERRINTCLR_EPERRINTCLR16     = 0x10000    // Bit EPERRINTCLR16.
	USB_SYSERRINTCLR_EPERRINTCLR17_Pos = 0x11       // Position of EPERRINTCLR17 field.
	USB_SYSERRINTCLR_EPERRINTCLR17_Msk = 0x20000    // Bit mask of EPERRINTCLR17 field.
	USB_SYSERRINTCLR_EPERRINTCLR17     = 0x20000    // Bit EPERRINTCLR17.
	USB_SYSERRINTCLR_EPERRINTCLR18_Pos = 0x12       // Position of EPERRINTCLR18 field.
	USB_SYSERRINTCLR_EPERRINTCLR18_Msk = 0x40000    // Bit mask of EPERRINTCLR18 field.
	USB_SYSERRINTCLR_EPERRINTCLR18     = 0x40000    // Bit EPERRINTCLR18.
	USB_SYSERRINTCLR_EPERRINTCLR19_Pos = 0x13       // Position of EPERRINTCLR19 field.
	USB_SYSERRINTCLR_EPERRINTCLR19_Msk = 0x80000    // Bit mask of EPERRINTCLR19 field.
	USB_SYSERRINTCLR_EPERRINTCLR19     = 0x80000    // Bit EPERRINTCLR19.
	USB_SYSERRINTCLR_EPERRINTCLR20_Pos = 0x14       // Position of EPERRINTCLR20 field.
	USB_SYSERRINTCLR_EPERRINTCLR20_Msk = 0x100000   // Bit mask of EPERRINTCLR20 field.
	USB_SYSERRINTCLR_EPERRINTCLR20     = 0x100000   // Bit EPERRINTCLR20.
	USB_SYSERRINTCLR_EPERRINTCLR21_Pos = 0x15       // Position of EPERRINTCLR21 field.
	USB_SYSERRINTCLR_EPERRINTCLR21_Msk = 0x200000   // Bit mask of EPERRINTCLR21 field.
	USB_SYSERRINTCLR_EPERRINTCLR21     = 0x200000   // Bit EPERRINTCLR21.
	USB_SYSERRINTCLR_EPERRINTCLR22_Pos = 0x16       // Position of EPERRINTCLR22 field.
	USB_SYSERRINTCLR_EPERRINTCLR22_Msk = 0x400000   // Bit mask of EPERRINTCLR22 field.
	USB_SYSERRINTCLR_EPERRINTCLR22     = 0x400000   // Bit EPERRINTCLR22.
	USB_SYSERRINTCLR_EPERRINTCLR23_Pos = 0x17       // Position of EPERRINTCLR23 field.
	USB_SYSERRINTCLR_EPERRINTCLR23_Msk = 0x800000   // Bit mask of EPERRINTCLR23 field.
	USB_SYSERRINTCLR_EPERRINTCLR23     = 0x800000   // Bit EPERRINTCLR23.
	USB_SYSERRINTCLR_EPERRINTCLR24_Pos = 0x18       // Position of EPERRINTCLR24 field.
	USB_SYSERRINTCLR_EPERRINTCLR24_Msk = 0x1000000  // Bit mask of EPERRINTCLR24 field.
	USB_SYSERRINTCLR_EPERRINTCLR24     = 0x1000000  // Bit EPERRINTCLR24.
	USB_SYSERRINTCLR_EPERRINTCLR25_Pos = 0x19       // Position of EPERRINTCLR25 field.
	USB_SYSERRINTCLR_EPERRINTCLR25_Msk = 0x2000000  // Bit mask of EPERRINTCLR25 field.
	USB_SYSERRINTCLR_EPERRINTCLR25     = 0x2000000  // Bit EPERRINTCLR25.
	USB_SYSERRINTCLR_EPERRINTCLR26_Pos = 0x1a       // Position of EPERRINTCLR26 field.
	USB_SYSERRINTCLR_EPERRINTCLR26_Msk = 0x4000000  // Bit mask of EPERRINTCLR26 field.
	USB_SYSERRINTCLR_EPERRINTCLR26     = 0x4000000  // Bit EPERRINTCLR26.
	USB_SYSERRINTCLR_EPERRINTCLR27_Pos = 0x1b       // Position of EPERRINTCLR27 field.
	USB_SYSERRINTCLR_EPERRINTCLR27_Msk = 0x8000000  // Bit mask of EPERRINTCLR27 field.
	USB_SYSERRINTCLR_EPERRINTCLR27     = 0x8000000  // Bit EPERRINTCLR27.
	USB_SYSERRINTCLR_EPERRINTCLR28_Pos = 0x1c       // Position of EPERRINTCLR28 field.
	USB_SYSERRINTCLR_EPERRINTCLR28_Msk = 0x10000000 // Bit mask of EPERRINTCLR28 field.
	USB_SYSERRINTCLR_EPERRINTCLR28     = 0x10000000 // Bit EPERRINTCLR28.
	USB_SYSERRINTCLR_EPERRINTCLR29_Pos = 0x1d       // Position of EPERRINTCLR29 field.
	USB_SYSERRINTCLR_EPERRINTCLR29_Msk = 0x20000000 // Bit mask of EPERRINTCLR29 field.
	USB_SYSERRINTCLR_EPERRINTCLR29     = 0x20000000 // Bit EPERRINTCLR29.
	USB_SYSERRINTCLR_EPERRINTCLR30_Pos = 0x1e       // Position of EPERRINTCLR30 field.
	USB_SYSERRINTCLR_EPERRINTCLR30_Msk = 0x40000000 // Bit mask of EPERRINTCLR30 field.
	USB_SYSERRINTCLR_EPERRINTCLR30     = 0x40000000 // Bit EPERRINTCLR30.
	USB_SYSERRINTCLR_EPERRINTCLR31_Pos = 0x1f       // Position of EPERRINTCLR31 field.
	USB_SYSERRINTCLR_EPERRINTCLR31_Msk = 0x80000000 // Bit mask of EPERRINTCLR31 field.
	USB_SYSERRINTCLR_EPERRINTCLR31     = 0x80000000 // Bit EPERRINTCLR31.

	// SYSERRINTSET: USB System Error Interrupt Set
	USB_SYSERRINTSET_EPERRINTSET0_Pos  = 0x0        // Position of EPERRINTSET0 field.
	USB_SYSERRINTSET_EPERRINTSET0_Msk  = 0x1        // Bit mask of EPERRINTSET0 field.
	USB_SYSERRINTSET_EPERRINTSET0      = 0x1        // Bit EPERRINTSET0.
	USB_SYSERRINTSET_EPERRINTSET1_Pos  = 0x1        // Position of EPERRINTSET1 field.
	USB_SYSERRINTSET_EPERRINTSET1_Msk  = 0x2        // Bit mask of EPERRINTSET1 field.
	USB_SYSERRINTSET_EPERRINTSET1      = 0x2        // Bit EPERRINTSET1.
	USB_SYSERRINTSET_EPERRINTSET2_Pos  = 0x2        // Position of EPERRINTSET2 field.
	USB_SYSERRINTSET_EPERRINTSET2_Msk  = 0x4        // Bit mask of EPERRINTSET2 field.
	USB_SYSERRINTSET_EPERRINTSET2      = 0x4        // Bit EPERRINTSET2.
	USB_SYSERRINTSET_EPERRINTSET3_Pos  = 0x3        // Position of EPERRINTSET3 field.
	USB_SYSERRINTSET_EPERRINTSET3_Msk  = 0x8        // Bit mask of EPERRINTSET3 field.
	USB_SYSERRINTSET_EPERRINTSET3      = 0x8        // Bit EPERRINTSET3.
	USB_SYSERRINTSET_EPERRINTSET4_Pos  = 0x4        // Position of EPERRINTSET4 field.
	USB_SYSERRINTSET_EPERRINTSET4_Msk  = 0x10       // Bit mask of EPERRINTSET4 field.
	USB_SYSERRINTSET_EPERRINTSET4      = 0x10       // Bit EPERRINTSET4.
	USB_SYSERRINTSET_EPERRINTSET5_Pos  = 0x5        // Position of EPERRINTSET5 field.
	USB_SYSERRINTSET_EPERRINTSET5_Msk  = 0x20       // Bit mask of EPERRINTSET5 field.
	USB_SYSERRINTSET_EPERRINTSET5      = 0x20       // Bit EPERRINTSET5.
	USB_SYSERRINTSET_EPERRINTSET6_Pos  = 0x6        // Position of EPERRINTSET6 field.
	USB_SYSERRINTSET_EPERRINTSET6_Msk  = 0x40       // Bit mask of EPERRINTSET6 field.
	USB_SYSERRINTSET_EPERRINTSET6      = 0x40       // Bit EPERRINTSET6.
	USB_SYSERRINTSET_EPERRINTSET7_Pos  = 0x7        // Position of EPERRINTSET7 field.
	USB_SYSERRINTSET_EPERRINTSET7_Msk  = 0x80       // Bit mask of EPERRINTSET7 field.
	USB_SYSERRINTSET_EPERRINTSET7      = 0x80       // Bit EPERRINTSET7.
	USB_SYSERRINTSET_EPERRINTSET8_Pos  = 0x8        // Position of EPERRINTSET8 field.
	USB_SYSERRINTSET_EPERRINTSET8_Msk  = 0x100      // Bit mask of EPERRINTSET8 field.
	USB_SYSERRINTSET_EPERRINTSET8      = 0x100      // Bit EPERRINTSET8.
	USB_SYSERRINTSET_EPERRINTSET9_Pos  = 0x9        // Position of EPERRINTSET9 field.
	USB_SYSERRINTSET_EPERRINTSET9_Msk  = 0x200      // Bit mask of EPERRINTSET9 field.
	USB_SYSERRINTSET_EPERRINTSET9      = 0x200      // Bit EPERRINTSET9.
	USB_SYSERRINTSET_EPERRINTSET10_Pos = 0xa        // Position of EPERRINTSET10 field.
	USB_SYSERRINTSET_EPERRINTSET10_Msk = 0x400      // Bit mask of EPERRINTSET10 field.
	USB_SYSERRINTSET_EPERRINTSET10     = 0x400      // Bit EPERRINTSET10.
	USB_SYSERRINTSET_EPERRINTSET11_Pos = 0xb        // Position of EPERRINTSET11 field.
	USB_SYSERRINTSET_EPERRINTSET11_Msk = 0x800      // Bit mask of EPERRINTSET11 field.
	USB_SYSERRINTSET_EPERRINTSET11     = 0x800      // Bit EPERRINTSET11.
	USB_SYSERRINTSET_EPERRINTSET12_Pos = 0xc        // Position of EPERRINTSET12 field.
	USB_SYSERRINTSET_EPERRINTSET12_Msk = 0x1000     // Bit mask of EPERRINTSET12 field.
	USB_SYSERRINTSET_EPERRINTSET12     = 0x1000     // Bit EPERRINTSET12.
	USB_SYSERRINTSET_EPERRINTSET13_Pos = 0xd        // Position of EPERRINTSET13 field.
	USB_SYSERRINTSET_EPERRINTSET13_Msk = 0x2000     // Bit mask of EPERRINTSET13 field.
	USB_SYSERRINTSET_EPERRINTSET13     = 0x2000     // Bit EPERRINTSET13.
	USB_SYSERRINTSET_EPERRINTSET14_Pos = 0xe        // Position of EPERRINTSET14 field.
	USB_SYSERRINTSET_EPERRINTSET14_Msk = 0x4000     // Bit mask of EPERRINTSET14 field.
	USB_SYSERRINTSET_EPERRINTSET14     = 0x4000     // Bit EPERRINTSET14.
	USB_SYSERRINTSET_EPERRINTSET15_Pos = 0xf        // Position of EPERRINTSET15 field.
	USB_SYSERRINTSET_EPERRINTSET15_Msk = 0x8000     // Bit mask of EPERRINTSET15 field.
	USB_SYSERRINTSET_EPERRINTSET15     = 0x8000     // Bit EPERRINTSET15.
	USB_SYSERRINTSET_EPERRINTSET16_Pos = 0x10       // Position of EPERRINTSET16 field.
	USB_SYSERRINTSET_EPERRINTSET16_Msk = 0x10000    // Bit mask of EPERRINTSET16 field.
	USB_SYSERRINTSET_EPERRINTSET16     = 0x10000    // Bit EPERRINTSET16.
	USB_SYSERRINTSET_EPERRINTSET17_Pos = 0x11       // Position of EPERRINTSET17 field.
	USB_SYSERRINTSET_EPERRINTSET17_Msk = 0x20000    // Bit mask of EPERRINTSET17 field.
	USB_SYSERRINTSET_EPERRINTSET17     = 0x20000    // Bit EPERRINTSET17.
	USB_SYSERRINTSET_EPERRINTSET18_Pos = 0x12       // Position of EPERRINTSET18 field.
	USB_SYSERRINTSET_EPERRINTSET18_Msk = 0x40000    // Bit mask of EPERRINTSET18 field.
	USB_SYSERRINTSET_EPERRINTSET18     = 0x40000    // Bit EPERRINTSET18.
	USB_SYSERRINTSET_EPERRINTSET19_Pos = 0x13       // Position of EPERRINTSET19 field.
	USB_SYSERRINTSET_EPERRINTSET19_Msk = 0x80000    // Bit mask of EPERRINTSET19 field.
	USB_SYSERRINTSET_EPERRINTSET19     = 0x80000    // Bit EPERRINTSET19.
	USB_SYSERRINTSET_EPERRINTSET20_Pos = 0x14       // Position of EPERRINTSET20 field.
	USB_SYSERRINTSET_EPERRINTSET20_Msk = 0x100000   // Bit mask of EPERRINTSET20 field.
	USB_SYSERRINTSET_EPERRINTSET20     = 0x100000   // Bit EPERRINTSET20.
	USB_SYSERRINTSET_EPERRINTSET21_Pos = 0x15       // Position of EPERRINTSET21 field.
	USB_SYSERRINTSET_EPERRINTSET21_Msk = 0x200000   // Bit mask of EPERRINTSET21 field.
	USB_SYSERRINTSET_EPERRINTSET21     = 0x200000   // Bit EPERRINTSET21.
	USB_SYSERRINTSET_EPERRINTSET22_Pos = 0x16       // Position of EPERRINTSET22 field.
	USB_SYSERRINTSET_EPERRINTSET22_Msk = 0x400000   // Bit mask of EPERRINTSET22 field.
	USB_SYSERRINTSET_EPERRINTSET22     = 0x400000   // Bit EPERRINTSET22.
	USB_SYSERRINTSET_EPERRINTSET23_Pos = 0x17       // Position of EPERRINTSET23 field.
	USB_SYSERRINTSET_EPERRINTSET23_Msk = 0x800000   // Bit mask of EPERRINTSET23 field.
	USB_SYSERRINTSET_EPERRINTSET23     = 0x800000   // Bit EPERRINTSET23.
	USB_SYSERRINTSET_EPERRINTSET24_Pos = 0x18       // Position of EPERRINTSET24 field.
	USB_SYSERRINTSET_EPERRINTSET24_Msk = 0x1000000  // Bit mask of EPERRINTSET24 field.
	USB_SYSERRINTSET_EPERRINTSET24     = 0x1000000  // Bit EPERRINTSET24.
	USB_SYSERRINTSET_EPERRINTSET25_Pos = 0x19       // Position of EPERRINTSET25 field.
	USB_SYSERRINTSET_EPERRINTSET25_Msk = 0x2000000  // Bit mask of EPERRINTSET25 field.
	USB_SYSERRINTSET_EPERRINTSET25     = 0x2000000  // Bit EPERRINTSET25.
	USB_SYSERRINTSET_EPERRINTSET26_Pos = 0x1a       // Position of EPERRINTSET26 field.
	USB_SYSERRINTSET_EPERRINTSET26_Msk = 0x4000000  // Bit mask of EPERRINTSET26 field.
	USB_SYSERRINTSET_EPERRINTSET26     = 0x4000000  // Bit EPERRINTSET26.
	USB_SYSERRINTSET_EPERRINTSET27_Pos = 0x1b       // Position of EPERRINTSET27 field.
	USB_SYSERRINTSET_EPERRINTSET27_Msk = 0x8000000  // Bit mask of EPERRINTSET27 field.
	USB_SYSERRINTSET_EPERRINTSET27     = 0x8000000  // Bit EPERRINTSET27.
	USB_SYSERRINTSET_EPERRINTSET28_Pos = 0x1c       // Position of EPERRINTSET28 field.
	USB_SYSERRINTSET_EPERRINTSET28_Msk = 0x10000000 // Bit mask of EPERRINTSET28 field.
	USB_SYSERRINTSET_EPERRINTSET28     = 0x10000000 // Bit EPERRINTSET28.
	USB_SYSERRINTSET_EPERRINTSET29_Pos = 0x1d       // Position of EPERRINTSET29 field.
	USB_SYSERRINTSET_EPERRINTSET29_Msk = 0x20000000 // Bit mask of EPERRINTSET29 field.
	USB_SYSERRINTSET_EPERRINTSET29     = 0x20000000 // Bit EPERRINTSET29.
	USB_SYSERRINTSET_EPERRINTSET30_Pos = 0x1e       // Position of EPERRINTSET30 field.
	USB_SYSERRINTSET_EPERRINTSET30_Msk = 0x40000000 // Bit mask of EPERRINTSET30 field.
	USB_SYSERRINTSET_EPERRINTSET30     = 0x40000000 // Bit EPERRINTSET30.
	USB_SYSERRINTSET_EPERRINTSET31_Pos = 0x1f       // Position of EPERRINTSET31 field.
	USB_SYSERRINTSET_EPERRINTSET31_Msk = 0x80000000 // Bit mask of EPERRINTSET31 field.
	USB_SYSERRINTSET_EPERRINTSET31     = 0x80000000 // Bit EPERRINTSET31.

	// I2C_RX: I2C Receive
	USB_I2C_RX_RXDATA_Pos = 0x0  // Position of RXDATA field.
	USB_I2C_RX_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// I2C_WO: I2C Transmit
	USB_I2C_WO_TXDATA_Pos   = 0x0        // Position of TXDATA field.
	USB_I2C_WO_TXDATA_Msk   = 0xff       // Bit mask of TXDATA field.
	USB_I2C_WO_START_Pos    = 0x8        // Position of START field.
	USB_I2C_WO_START_Msk    = 0x100      // Bit mask of START field.
	USB_I2C_WO_START        = 0x100      // Bit START.
	USB_I2C_WO_STOP_Pos     = 0x9        // Position of STOP field.
	USB_I2C_WO_STOP_Msk     = 0x200      // Bit mask of STOP field.
	USB_I2C_WO_STOP         = 0x200      // Bit STOP.
	USB_I2C_WO_RESERVED_Pos = 0xa        // Position of RESERVED field.
	USB_I2C_WO_RESERVED_Msk = 0xfffffc00 // Bit mask of RESERVED field.

	// I2C_STS: I2C Status
	USB_I2C_STS_TDI_Pos                  = 0x0        // Position of TDI field.
	USB_I2C_STS_TDI_Msk                  = 0x1        // Bit mask of TDI field.
	USB_I2C_STS_TDI                      = 0x1        // Bit TDI.
	USB_I2C_STS_TDI_NOT_COMPLETE         = 0x0        // Transaction has not completed.
	USB_I2C_STS_TDI_COMPLETE             = 0x1        // Transaction completed.
	USB_I2C_STS_AFI_Pos                  = 0x1        // Position of AFI field.
	USB_I2C_STS_AFI_Msk                  = 0x2        // Bit mask of AFI field.
	USB_I2C_STS_AFI                      = 0x2        // Bit AFI.
	USB_I2C_STS_AFI_NO_ARBITRATION_FAILU = 0x0        // No arbitration failure on last transmission.
	USB_I2C_STS_AFI_ARBITRATION_FAILURE_ = 0x1        // Arbitration failure occurred on last transmission.
	USB_I2C_STS_NAI_Pos                  = 0x2        // Position of NAI field.
	USB_I2C_STS_NAI_Msk                  = 0x4        // Bit mask of NAI field.
	USB_I2C_STS_NAI                      = 0x4        // Bit NAI.
	USB_I2C_STS_NAI_ACKNOWLEDGE_RCVD     = 0x0        // Last transmission received an acknowledge.
	USB_I2C_STS_NAI_NO_ACKNOWLEDGE_RCVD  = 0x1        // Last transmission did not receive an acknowledge.
	USB_I2C_STS_DRMI_Pos                 = 0x3        // Position of DRMI field.
	USB_I2C_STS_DRMI_Msk                 = 0x8        // Bit mask of DRMI field.
	USB_I2C_STS_DRMI                     = 0x8        // Bit DRMI.
	USB_I2C_STS_DRMI_BUSY                = 0x0        // Master transmitter does not need data.
	USB_I2C_STS_DRMI_NEED_DATA           = 0x1        // Master transmitter needs data.
	USB_I2C_STS_DRSI_Pos                 = 0x4        // Position of DRSI field.
	USB_I2C_STS_DRSI_Msk                 = 0x10       // Bit mask of DRSI field.
	USB_I2C_STS_DRSI                     = 0x10       // Bit DRSI.
	USB_I2C_STS_DRSI_BUSY                = 0x0        // Slave transmitter does not need data.
	USB_I2C_STS_DRSI_NEED_DATA           = 0x1        // Slave transmitter needs data.
	USB_I2C_STS_Active_Pos               = 0x5        // Position of Active field.
	USB_I2C_STS_Active_Msk               = 0x20       // Bit mask of Active field.
	USB_I2C_STS_Active                   = 0x20       // Bit Active.
	USB_I2C_STS_SCL_Pos                  = 0x6        // Position of SCL field.
	USB_I2C_STS_SCL_Msk                  = 0x40       // Bit mask of SCL field.
	USB_I2C_STS_SCL                      = 0x40       // Bit SCL.
	USB_I2C_STS_SDA_Pos                  = 0x7        // Position of SDA field.
	USB_I2C_STS_SDA_Msk                  = 0x80       // Bit mask of SDA field.
	USB_I2C_STS_SDA                      = 0x80       // Bit SDA.
	USB_I2C_STS_RFF_Pos                  = 0x8        // Position of RFF field.
	USB_I2C_STS_RFF_Msk                  = 0x100      // Bit mask of RFF field.
	USB_I2C_STS_RFF                      = 0x100      // Bit RFF.
	USB_I2C_STS_RFF_RX_FIFO_IS_NOT_FULL  = 0x0        // RX FIFO is not full
	USB_I2C_STS_RFF_RX_FIFO_IS_FULL      = 0x1        // RX FIFO is full
	USB_I2C_STS_RFE_Pos                  = 0x9        // Position of RFE field.
	USB_I2C_STS_RFE_Msk                  = 0x200      // Bit mask of RFE field.
	USB_I2C_STS_RFE                      = 0x200      // Bit RFE.
	USB_I2C_STS_RFE_DATA                 = 0x0        // RX FIFO contains data.
	USB_I2C_STS_RFE_EMPTY                = 0x1        // RX FIFO is empty
	USB_I2C_STS_TFF_Pos                  = 0xa        // Position of TFF field.
	USB_I2C_STS_TFF_Msk                  = 0x400      // Bit mask of TFF field.
	USB_I2C_STS_TFF                      = 0x400      // Bit TFF.
	USB_I2C_STS_TFF_TX_FIFO_IS_NOT_FULL_ = 0x0        // TX FIFO is not full.
	USB_I2C_STS_TFF_TX_FIFO_IS_FULL      = 0x1        // TX FIFO is full
	USB_I2C_STS_TFE_Pos                  = 0xb        // Position of TFE field.
	USB_I2C_STS_TFE_Msk                  = 0x800      // Bit mask of TFE field.
	USB_I2C_STS_TFE                      = 0x800      // Bit TFE.
	USB_I2C_STS_TFE_VALID_DATA           = 0x0        // TX FIFO contains valid data.
	USB_I2C_STS_TFE_EMPTY                = 0x1        // TX FIFO is empty
	USB_I2C_STS_RESERVED_Pos             = 0xc        // Position of RESERVED field.
	USB_I2C_STS_RESERVED_Msk             = 0xfffff000 // Bit mask of RESERVED field.

	// I2C_CTL: I2C Control
	USB_I2C_CTL_TDIE_Pos                   = 0x0        // Position of TDIE field.
	USB_I2C_CTL_TDIE_Msk                   = 0x1        // Bit mask of TDIE field.
	USB_I2C_CTL_TDIE                       = 0x1        // Bit TDIE.
	USB_I2C_CTL_TDIE_DISABLE_THE_TDI_INTE  = 0x0        // Disable the TDI interrupt.
	USB_I2C_CTL_TDIE_ENABLE_THE_TDI_INTER  = 0x1        // Enable the TDI interrupt.
	USB_I2C_CTL_AFIE_Pos                   = 0x1        // Position of AFIE field.
	USB_I2C_CTL_AFIE_Msk                   = 0x2        // Bit mask of AFIE field.
	USB_I2C_CTL_AFIE                       = 0x2        // Bit AFIE.
	USB_I2C_CTL_AFIE_DISABLE_THE_AFI_      = 0x0        // Disable the AFI.
	USB_I2C_CTL_AFIE_ENABLE_THE_AFI_       = 0x1        // Enable the AFI.
	USB_I2C_CTL_NAIE_Pos                   = 0x2        // Position of NAIE field.
	USB_I2C_CTL_NAIE_Msk                   = 0x4        // Bit mask of NAIE field.
	USB_I2C_CTL_NAIE                       = 0x4        // Bit NAIE.
	USB_I2C_CTL_NAIE_DISABLE_THE_NAI_      = 0x0        // Disable the NAI.
	USB_I2C_CTL_NAIE_ENABLE_THE_NAI_       = 0x1        // Enable the NAI.
	USB_I2C_CTL_DRMIE_Pos                  = 0x3        // Position of DRMIE field.
	USB_I2C_CTL_DRMIE_Msk                  = 0x8        // Bit mask of DRMIE field.
	USB_I2C_CTL_DRMIE                      = 0x8        // Bit DRMIE.
	USB_I2C_CTL_DRMIE_DISABLE_THE_DRMI_INT = 0x0        // Disable the DRMI interrupt.
	USB_I2C_CTL_DRMIE_ENABLE_THE_DRMI_INTE = 0x1        // Enable the DRMI interrupt.
	USB_I2C_CTL_DRSIE_Pos                  = 0x4        // Position of DRSIE field.
	USB_I2C_CTL_DRSIE_Msk                  = 0x10       // Bit mask of DRSIE field.
	USB_I2C_CTL_DRSIE                      = 0x10       // Bit DRSIE.
	USB_I2C_CTL_DRSIE_DISABLE_THE_DRSI_INT = 0x0        // Disable the DRSI interrupt.
	USB_I2C_CTL_DRSIE_ENABLE_THE_DRSI_INTE = 0x1        // Enable the DRSI interrupt.
	USB_I2C_CTL_REFIE_Pos                  = 0x5        // Position of REFIE field.
	USB_I2C_CTL_REFIE_Msk                  = 0x20       // Bit mask of REFIE field.
	USB_I2C_CTL_REFIE                      = 0x20       // Bit REFIE.
	USB_I2C_CTL_REFIE_DISABLE_THE_RFFI_    = 0x0        // Disable the RFFI.
	USB_I2C_CTL_REFIE_ENABLE_THE_RFFI_     = 0x1        // Enable the RFFI.
	USB_I2C_CTL_RFDAIE_Pos                 = 0x6        // Position of RFDAIE field.
	USB_I2C_CTL_RFDAIE_Msk                 = 0x40       // Bit mask of RFDAIE field.
	USB_I2C_CTL_RFDAIE                     = 0x40       // Bit RFDAIE.
	USB_I2C_CTL_RFDAIE_DISABLE_THE_DAI_    = 0x0        // Disable the DAI.
	USB_I2C_CTL_RFDAIE_ENABLE_THE_DAI_     = 0x1        // Enable the DAI.
	USB_I2C_CTL_TFFIE_Pos                  = 0x7        // Position of TFFIE field.
	USB_I2C_CTL_TFFIE_Msk                  = 0x80       // Bit mask of TFFIE field.
	USB_I2C_CTL_TFFIE                      = 0x80       // Bit TFFIE.
	USB_I2C_CTL_TFFIE_DISABLE_THE_TFFI_    = 0x0        // Disable the TFFI.
	USB_I2C_CTL_TFFIE_ENABLE_THE_TFFI_     = 0x1        // Enable the TFFI.
	USB_I2C_CTL_SRST_Pos                   = 0x8        // Position of SRST field.
	USB_I2C_CTL_SRST_Msk                   = 0x100      // Bit mask of SRST field.
	USB_I2C_CTL_SRST                       = 0x100      // Bit SRST.
	USB_I2C_CTL_SRST_NO_RESET              = 0x0        // No reset.
	USB_I2C_CTL_SRST_RESET                 = 0x1        // Reset the I2C to idle state. Self clearing.
	USB_I2C_CTL_RESERVED_Pos               = 0x9        // Position of RESERVED field.
	USB_I2C_CTL_RESERVED_Msk               = 0xfffffe00 // Bit mask of RESERVED field.

	// I2C_CLKHI: I2C Clock High
	USB_I2C_CLKHI_CDHI_Pos     = 0x0        // Position of CDHI field.
	USB_I2C_CLKHI_CDHI_Msk     = 0xff       // Bit mask of CDHI field.
	USB_I2C_CLKHI_RESERVED_Pos = 0x8        // Position of RESERVED field.
	USB_I2C_CLKHI_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// I2C_CLKLO: I2C Clock Low
	USB_I2C_CLKLO_CDLO_Pos     = 0x0        // Position of CDLO field.
	USB_I2C_CLKLO_CDLO_Msk     = 0xff       // Bit mask of CDLO field.
	USB_I2C_CLKLO_RESERVED_Pos = 0x8        // Position of RESERVED field.
	USB_I2C_CLKLO_RESERVED_Msk = 0xffffff00 // Bit mask of RESERVED field.

	// USBCLKCTRL: USB Clock Control
	USB_USBCLKCTRL_RESERVED_Pos       = 0x0        // Position of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Msk       = 0x1        // Bit mask of RESERVED field.
	USB_USBCLKCTRL_RESERVED           = 0x1        // Bit RESERVED.
	USB_USBCLKCTRL_DEV_CLK_EN_Pos     = 0x1        // Position of DEV_CLK_EN field.
	USB_USBCLKCTRL_DEV_CLK_EN_Msk     = 0x2        // Bit mask of DEV_CLK_EN field.
	USB_USBCLKCTRL_DEV_CLK_EN         = 0x2        // Bit DEV_CLK_EN.
	USB_USBCLKCTRL_RESERVED_Pos       = 0x2        // Position of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Msk       = 0x4        // Bit mask of RESERVED field.
	USB_USBCLKCTRL_RESERVED           = 0x4        // Bit RESERVED.
	USB_USBCLKCTRL_PORTSEL_CLK_EN_Pos = 0x3        // Position of PORTSEL_CLK_EN field.
	USB_USBCLKCTRL_PORTSEL_CLK_EN_Msk = 0x8        // Bit mask of PORTSEL_CLK_EN field.
	USB_USBCLKCTRL_PORTSEL_CLK_EN     = 0x8        // Bit PORTSEL_CLK_EN.
	USB_USBCLKCTRL_AHB_CLK_EN_Pos     = 0x4        // Position of AHB_CLK_EN field.
	USB_USBCLKCTRL_AHB_CLK_EN_Msk     = 0x10       // Bit mask of AHB_CLK_EN field.
	USB_USBCLKCTRL_AHB_CLK_EN         = 0x10       // Bit AHB_CLK_EN.
	USB_USBCLKCTRL_RESERVED_Pos       = 0x5        // Position of RESERVED field.
	USB_USBCLKCTRL_RESERVED_Msk       = 0xffffffe0 // Bit mask of RESERVED field.

	// OTGCLKCTRL: OTG clock controller
	USB_OTGCLKCTRL_HOST_CLK_EN_Pos                  = 0x0        // Position of HOST_CLK_EN field.
	USB_OTGCLKCTRL_HOST_CLK_EN_Msk                  = 0x1        // Bit mask of HOST_CLK_EN field.
	USB_OTGCLKCTRL_HOST_CLK_EN                      = 0x1        // Bit HOST_CLK_EN.
	USB_OTGCLKCTRL_HOST_CLK_EN_DISABLE_THE_HOST_CLO = 0x0        // Disable the Host clock.
	USB_OTGCLKCTRL_HOST_CLK_EN_ENABLE_THE_HOST_CLOC = 0x1        // Enable the Host clock.
	USB_OTGCLKCTRL_DEV_CLK_EN_Pos                   = 0x1        // Position of DEV_CLK_EN field.
	USB_OTGCLKCTRL_DEV_CLK_EN_Msk                   = 0x2        // Bit mask of DEV_CLK_EN field.
	USB_OTGCLKCTRL_DEV_CLK_EN                       = 0x2        // Bit DEV_CLK_EN.
	USB_OTGCLKCTRL_DEV_CLK_EN_DISABLE_THE_DEVICE_C  = 0x0        // Disable the Device clock.
	USB_OTGCLKCTRL_DEV_CLK_EN_ENABLE_THE_DEVICE_CL  = 0x1        // Enable the Device clock.
	USB_OTGCLKCTRL_I2C_CLK_EN_Pos                   = 0x2        // Position of I2C_CLK_EN field.
	USB_OTGCLKCTRL_I2C_CLK_EN_Msk                   = 0x4        // Bit mask of I2C_CLK_EN field.
	USB_OTGCLKCTRL_I2C_CLK_EN                       = 0x4        // Bit I2C_CLK_EN.
	USB_OTGCLKCTRL_I2C_CLK_EN_DISABLE_THE_I2C_CLOC  = 0x0        // Disable the I2C clock.
	USB_OTGCLKCTRL_I2C_CLK_EN_ENABLE_THE_I2C_CLOCK  = 0x1        // Enable the I2C clock.
	USB_OTGCLKCTRL_OTG_CLK_EN_Pos                   = 0x3        // Position of OTG_CLK_EN field.
	USB_OTGCLKCTRL_OTG_CLK_EN_Msk                   = 0x8        // Bit mask of OTG_CLK_EN field.
	USB_OTGCLKCTRL_OTG_CLK_EN                       = 0x8        // Bit OTG_CLK_EN.
	USB_OTGCLKCTRL_OTG_CLK_EN_DISABLE_THE_OTG_CLOC  = 0x0        // Disable the OTG clock.
	USB_OTGCLKCTRL_OTG_CLK_EN_ENABLE_THE_OTG_CLOCK  = 0x1        // Enable the OTG clock.
	USB_OTGCLKCTRL_AHB_CLK_EN_Pos                   = 0x4        // Position of AHB_CLK_EN field.
	USB_OTGCLKCTRL_AHB_CLK_EN_Msk                   = 0x10       // Bit mask of AHB_CLK_EN field.
	USB_OTGCLKCTRL_AHB_CLK_EN                       = 0x10       // Bit AHB_CLK_EN.
	USB_OTGCLKCTRL_AHB_CLK_EN_DISABLE_THE_AHB_CLOC  = 0x0        // Disable the AHB clock.
	USB_OTGCLKCTRL_AHB_CLK_EN_ENABLE_THE_AHB_CLOCK  = 0x1        // Enable the AHB clock.
	USB_OTGCLKCTRL_RESERVED_Pos                     = 0x5        // Position of RESERVED field.
	USB_OTGCLKCTRL_RESERVED_Msk                     = 0xffffffe0 // Bit mask of RESERVED field.

	// USBCLKST: USB Clock Status
	USB_USBCLKST_RESERVED_Pos       = 0x0        // Position of RESERVED field.
	USB_USBCLKST_RESERVED_Msk       = 0x1        // Bit mask of RESERVED field.
	USB_USBCLKST_RESERVED           = 0x1        // Bit RESERVED.
	USB_USBCLKST_DEV_CLK_ON_Pos     = 0x1        // Position of DEV_CLK_ON field.
	USB_USBCLKST_DEV_CLK_ON_Msk     = 0x2        // Bit mask of DEV_CLK_ON field.
	USB_USBCLKST_DEV_CLK_ON         = 0x2        // Bit DEV_CLK_ON.
	USB_USBCLKST_RESERVED_Pos       = 0x2        // Position of RESERVED field.
	USB_USBCLKST_RESERVED_Msk       = 0x4        // Bit mask of RESERVED field.
	USB_USBCLKST_RESERVED           = 0x4        // Bit RESERVED.
	USB_USBCLKST_PORTSEL_CLK_ON_Pos = 0x3        // Position of PORTSEL_CLK_ON field.
	USB_USBCLKST_PORTSEL_CLK_ON_Msk = 0x8        // Bit mask of PORTSEL_CLK_ON field.
	USB_USBCLKST_PORTSEL_CLK_ON     = 0x8        // Bit PORTSEL_CLK_ON.
	USB_USBCLKST_AHB_CLK_ON_Pos     = 0x4        // Position of AHB_CLK_ON field.
	USB_USBCLKST_AHB_CLK_ON_Msk     = 0x10       // Bit mask of AHB_CLK_ON field.
	USB_USBCLKST_AHB_CLK_ON         = 0x10       // Bit AHB_CLK_ON.
	USB_USBCLKST_RESERVED_Pos       = 0x5        // Position of RESERVED field.
	USB_USBCLKST_RESERVED_Msk       = 0xffffffe0 // Bit mask of RESERVED field.

	// OTGCLKST: OTG clock status
	USB_OTGCLKST_HOST_CLK_ON_Pos                  = 0x0        // Position of HOST_CLK_ON field.
	USB_OTGCLKST_HOST_CLK_ON_Msk                  = 0x1        // Bit mask of HOST_CLK_ON field.
	USB_OTGCLKST_HOST_CLK_ON                      = 0x1        // Bit HOST_CLK_ON.
	USB_OTGCLKST_HOST_CLK_ON_HOST_CLOCK_IS_NOT_AV = 0x0        // Host clock is not available.
	USB_OTGCLKST_HOST_CLK_ON_HOST_CLOCK_IS_AVAILA = 0x1        // Host clock is available.
	USB_OTGCLKST_DEV_CLK_ON_Pos                   = 0x1        // Position of DEV_CLK_ON field.
	USB_OTGCLKST_DEV_CLK_ON_Msk                   = 0x2        // Bit mask of DEV_CLK_ON field.
	USB_OTGCLKST_DEV_CLK_ON                       = 0x2        // Bit DEV_CLK_ON.
	USB_OTGCLKST_DEV_CLK_ON_DEVICE_CLOCK_IS_NOT_  = 0x0        // Device clock is not available.
	USB_OTGCLKST_DEV_CLK_ON_DEVICE_CLOCK_IS_AVAI  = 0x1        // Device clock is available.
	USB_OTGCLKST_I2C_CLK_ON_Pos                   = 0x2        // Position of I2C_CLK_ON field.
	USB_OTGCLKST_I2C_CLK_ON_Msk                   = 0x4        // Bit mask of I2C_CLK_ON field.
	USB_OTGCLKST_I2C_CLK_ON                       = 0x4        // Bit I2C_CLK_ON.
	USB_OTGCLKST_I2C_CLK_ON_I2C_CLOCK_IS_NOT_AVA  = 0x0        // I2C clock is not available.
	USB_OTGCLKST_I2C_CLK_ON_I2C_CLOCK_IS_AVAILAB  = 0x1        // I2C clock is available.
	USB_OTGCLKST_OTG_CLK_ON_Pos                   = 0x3        // Position of OTG_CLK_ON field.
	USB_OTGCLKST_OTG_CLK_ON_Msk                   = 0x8        // Bit mask of OTG_CLK_ON field.
	USB_OTGCLKST_OTG_CLK_ON                       = 0x8        // Bit OTG_CLK_ON.
	USB_OTGCLKST_OTG_CLK_ON_OTG_CLOCK_IS_NOT_AVA  = 0x0        // OTG clock is not available.
	USB_OTGCLKST_OTG_CLK_ON_OTG_CLOCK_IS_AVAILAB  = 0x1        // OTG clock is available.
	USB_OTGCLKST_AHB_CLK_ON_Pos                   = 0x4        // Position of AHB_CLK_ON field.
	USB_OTGCLKST_AHB_CLK_ON_Msk                   = 0x10       // Bit mask of AHB_CLK_ON field.
	USB_OTGCLKST_AHB_CLK_ON                       = 0x10       // Bit AHB_CLK_ON.
	USB_OTGCLKST_AHB_CLK_ON_AHB_CLOCK_IS_NOT_AVA  = 0x0        // AHB clock is not available.
	USB_OTGCLKST_AHB_CLK_ON_AHB_CLOCK_IS_AVAILAB  = 0x1        // AHB clock is available.
	USB_OTGCLKST_RESERVED_Pos                     = 0x5        // Position of RESERVED field.
	USB_OTGCLKST_RESERVED_Msk                     = 0xffffffe0 // Bit mask of RESERVED field.
)

// Bitfields for GPIO: General Purpose I/O
const (
	// DIR0: GPIO Port Direction control register.
	GPIO_DIR_PINDIR0_Pos  = 0x0        // Position of PINDIR0 field.
	GPIO_DIR_PINDIR0_Msk  = 0x1        // Bit mask of PINDIR0 field.
	GPIO_DIR_PINDIR0      = 0x1        // Bit PINDIR0.
	GPIO_DIR_PINDIR1_Pos  = 0x1        // Position of PINDIR1 field.
	GPIO_DIR_PINDIR1_Msk  = 0x2        // Bit mask of PINDIR1 field.
	GPIO_DIR_PINDIR1      = 0x2        // Bit PINDIR1.
	GPIO_DIR_PINDIR2_Pos  = 0x2        // Position of PINDIR2 field.
	GPIO_DIR_PINDIR2_Msk  = 0x4        // Bit mask of PINDIR2 field.
	GPIO_DIR_PINDIR2      = 0x4        // Bit PINDIR2.
	GPIO_DIR_PINDIR3_Pos  = 0x3        // Position of PINDIR3 field.
	GPIO_DIR_PINDIR3_Msk  = 0x8        // Bit mask of PINDIR3 field.
	GPIO_DIR_PINDIR3      = 0x8        // Bit PINDIR3.
	GPIO_DIR_PINDIR4_Pos  = 0x4        // Position of PINDIR4 field.
	GPIO_DIR_PINDIR4_Msk  = 0x10       // Bit mask of PINDIR4 field.
	GPIO_DIR_PINDIR4      = 0x10       // Bit PINDIR4.
	GPIO_DIR_PINDIR5_Pos  = 0x5        // Position of PINDIR5 field.
	GPIO_DIR_PINDIR5_Msk  = 0x20       // Bit mask of PINDIR5 field.
	GPIO_DIR_PINDIR5      = 0x20       // Bit PINDIR5.
	GPIO_DIR_PINDIR6_Pos  = 0x6        // Position of PINDIR6 field.
	GPIO_DIR_PINDIR6_Msk  = 0x40       // Bit mask of PINDIR6 field.
	GPIO_DIR_PINDIR6      = 0x40       // Bit PINDIR6.
	GPIO_DIR_PINDIR7_Pos  = 0x7        // Position of PINDIR7 field.
	GPIO_DIR_PINDIR7_Msk  = 0x80       // Bit mask of PINDIR7 field.
	GPIO_DIR_PINDIR7      = 0x80       // Bit PINDIR7.
	GPIO_DIR_PINDIR8_Pos  = 0x8        // Position of PINDIR8 field.
	GPIO_DIR_PINDIR8_Msk  = 0x100      // Bit mask of PINDIR8 field.
	GPIO_DIR_PINDIR8      = 0x100      // Bit PINDIR8.
	GPIO_DIR_PINDIR9_Pos  = 0x9        // Position of PINDIR9 field.
	GPIO_DIR_PINDIR9_Msk  = 0x200      // Bit mask of PINDIR9 field.
	GPIO_DIR_PINDIR9      = 0x200      // Bit PINDIR9.
	GPIO_DIR_PINDIR10_Pos = 0xa        // Position of PINDIR10 field.
	GPIO_DIR_PINDIR10_Msk = 0x400      // Bit mask of PINDIR10 field.
	GPIO_DIR_PINDIR10     = 0x400      // Bit PINDIR10.
	GPIO_DIR_PINDIR11_Pos = 0xb        // Position of PINDIR11 field.
	GPIO_DIR_PINDIR11_Msk = 0x800      // Bit mask of PINDIR11 field.
	GPIO_DIR_PINDIR11     = 0x800      // Bit PINDIR11.
	GPIO_DIR_PINDIR12_Pos = 0xc        // Position of PINDIR12 field.
	GPIO_DIR_PINDIR12_Msk = 0x1000     // Bit mask of PINDIR12 field.
	GPIO_DIR_PINDIR12     = 0x1000     // Bit PINDIR12.
	GPIO_DIR_PINDIR13_Pos = 0xd        // Position of PINDIR13 field.
	GPIO_DIR_PINDIR13_Msk = 0x2000     // Bit mask of PINDIR13 field.
	GPIO_DIR_PINDIR13     = 0x2000     // Bit PINDIR13.
	GPIO_DIR_PINDIR14_Pos = 0xe        // Position of PINDIR14 field.
	GPIO_DIR_PINDIR14_Msk = 0x4000     // Bit mask of PINDIR14 field.
	GPIO_DIR_PINDIR14     = 0x4000     // Bit PINDIR14.
	GPIO_DIR_PINDIR15_Pos = 0xf        // Position of PINDIR15 field.
	GPIO_DIR_PINDIR15_Msk = 0x8000     // Bit mask of PINDIR15 field.
	GPIO_DIR_PINDIR15     = 0x8000     // Bit PINDIR15.
	GPIO_DIR_PINDIR16_Pos = 0x10       // Position of PINDIR16 field.
	GPIO_DIR_PINDIR16_Msk = 0x10000    // Bit mask of PINDIR16 field.
	GPIO_DIR_PINDIR16     = 0x10000    // Bit PINDIR16.
	GPIO_DIR_PINDIR17_Pos = 0x11       // Position of PINDIR17 field.
	GPIO_DIR_PINDIR17_Msk = 0x20000    // Bit mask of PINDIR17 field.
	GPIO_DIR_PINDIR17     = 0x20000    // Bit PINDIR17.
	GPIO_DIR_PINDIR18_Pos = 0x12       // Position of PINDIR18 field.
	GPIO_DIR_PINDIR18_Msk = 0x40000    // Bit mask of PINDIR18 field.
	GPIO_DIR_PINDIR18     = 0x40000    // Bit PINDIR18.
	GPIO_DIR_PINDIR19_Pos = 0x13       // Position of PINDIR19 field.
	GPIO_DIR_PINDIR19_Msk = 0x80000    // Bit mask of PINDIR19 field.
	GPIO_DIR_PINDIR19     = 0x80000    // Bit PINDIR19.
	GPIO_DIR_PINDIR20_Pos = 0x14       // Position of PINDIR20 field.
	GPIO_DIR_PINDIR20_Msk = 0x100000   // Bit mask of PINDIR20 field.
	GPIO_DIR_PINDIR20     = 0x100000   // Bit PINDIR20.
	GPIO_DIR_PINDIR21_Pos = 0x15       // Position of PINDIR21 field.
	GPIO_DIR_PINDIR21_Msk = 0x200000   // Bit mask of PINDIR21 field.
	GPIO_DIR_PINDIR21     = 0x200000   // Bit PINDIR21.
	GPIO_DIR_PINDIR22_Pos = 0x16       // Position of PINDIR22 field.
	GPIO_DIR_PINDIR22_Msk = 0x400000   // Bit mask of PINDIR22 field.
	GPIO_DIR_PINDIR22     = 0x400000   // Bit PINDIR22.
	GPIO_DIR_PINDIR23_Pos = 0x17       // Position of PINDIR23 field.
	GPIO_DIR_PINDIR23_Msk = 0x800000   // Bit mask of PINDIR23 field.
	GPIO_DIR_PINDIR23     = 0x800000   // Bit PINDIR23.
	GPIO_DIR_PINDIR24_Pos = 0x18       // Position of PINDIR24 field.
	GPIO_DIR_PINDIR24_Msk = 0x1000000  // Bit mask of PINDIR24 field.
	GPIO_DIR_PINDIR24     = 0x1000000  // Bit PINDIR24.
	GPIO_DIR_PINDIR25_Pos = 0x19       // Position of PINDIR25 field.
	GPIO_DIR_PINDIR25_Msk = 0x2000000  // Bit mask of PINDIR25 field.
	GPIO_DIR_PINDIR25     = 0x2000000  // Bit PINDIR25.
	GPIO_DIR_PINDIR26_Pos = 0x1a       // Position of PINDIR26 field.
	GPIO_DIR_PINDIR26_Msk = 0x4000000  // Bit mask of PINDIR26 field.
	GPIO_DIR_PINDIR26     = 0x4000000  // Bit PINDIR26.
	GPIO_DIR_PINDIR27_Pos = 0x1b       // Position of PINDIR27 field.
	GPIO_DIR_PINDIR27_Msk = 0x8000000  // Bit mask of PINDIR27 field.
	GPIO_DIR_PINDIR27     = 0x8000000  // Bit PINDIR27.
	GPIO_DIR_PINDIR28_Pos = 0x1c       // Position of PINDIR28 field.
	GPIO_DIR_PINDIR28_Msk = 0x10000000 // Bit mask of PINDIR28 field.
	GPIO_DIR_PINDIR28     = 0x10000000 // Bit PINDIR28.
	GPIO_DIR_PINDIR29_Pos = 0x1d       // Position of PINDIR29 field.
	GPIO_DIR_PINDIR29_Msk = 0x20000000 // Bit mask of PINDIR29 field.
	GPIO_DIR_PINDIR29     = 0x20000000 // Bit PINDIR29.
	GPIO_DIR_PINDIR30_Pos = 0x1e       // Position of PINDIR30 field.
	GPIO_DIR_PINDIR30_Msk = 0x40000000 // Bit mask of PINDIR30 field.
	GPIO_DIR_PINDIR30     = 0x40000000 // Bit PINDIR30.
	GPIO_DIR_PINDIR31_Pos = 0x1f       // Position of PINDIR31 field.
	GPIO_DIR_PINDIR31_Msk = 0x80000000 // Bit mask of PINDIR31 field.
	GPIO_DIR_PINDIR31     = 0x80000000 // Bit PINDIR31.

	// MASK0: Mask register for Port.
	GPIO_MASK_PINMASK0_Pos  = 0x0        // Position of PINMASK0 field.
	GPIO_MASK_PINMASK0_Msk  = 0x1        // Bit mask of PINMASK0 field.
	GPIO_MASK_PINMASK0      = 0x1        // Bit PINMASK0.
	GPIO_MASK_PINMASK1_Pos  = 0x1        // Position of PINMASK1 field.
	GPIO_MASK_PINMASK1_Msk  = 0x2        // Bit mask of PINMASK1 field.
	GPIO_MASK_PINMASK1      = 0x2        // Bit PINMASK1.
	GPIO_MASK_PINMASK2_Pos  = 0x2        // Position of PINMASK2 field.
	GPIO_MASK_PINMASK2_Msk  = 0x4        // Bit mask of PINMASK2 field.
	GPIO_MASK_PINMASK2      = 0x4        // Bit PINMASK2.
	GPIO_MASK_PINMASK3_Pos  = 0x3        // Position of PINMASK3 field.
	GPIO_MASK_PINMASK3_Msk  = 0x8        // Bit mask of PINMASK3 field.
	GPIO_MASK_PINMASK3      = 0x8        // Bit PINMASK3.
	GPIO_MASK_PINMASK4_Pos  = 0x4        // Position of PINMASK4 field.
	GPIO_MASK_PINMASK4_Msk  = 0x10       // Bit mask of PINMASK4 field.
	GPIO_MASK_PINMASK4      = 0x10       // Bit PINMASK4.
	GPIO_MASK_PINMASK5_Pos  = 0x5        // Position of PINMASK5 field.
	GPIO_MASK_PINMASK5_Msk  = 0x20       // Bit mask of PINMASK5 field.
	GPIO_MASK_PINMASK5      = 0x20       // Bit PINMASK5.
	GPIO_MASK_PINMASK6_Pos  = 0x6        // Position of PINMASK6 field.
	GPIO_MASK_PINMASK6_Msk  = 0x40       // Bit mask of PINMASK6 field.
	GPIO_MASK_PINMASK6      = 0x40       // Bit PINMASK6.
	GPIO_MASK_PINMASK7_Pos  = 0x7        // Position of PINMASK7 field.
	GPIO_MASK_PINMASK7_Msk  = 0x80       // Bit mask of PINMASK7 field.
	GPIO_MASK_PINMASK7      = 0x80       // Bit PINMASK7.
	GPIO_MASK_PINMASK8_Pos  = 0x8        // Position of PINMASK8 field.
	GPIO_MASK_PINMASK8_Msk  = 0x100      // Bit mask of PINMASK8 field.
	GPIO_MASK_PINMASK8      = 0x100      // Bit PINMASK8.
	GPIO_MASK_PINMASK9_Pos  = 0x9        // Position of PINMASK9 field.
	GPIO_MASK_PINMASK9_Msk  = 0x200      // Bit mask of PINMASK9 field.
	GPIO_MASK_PINMASK9      = 0x200      // Bit PINMASK9.
	GPIO_MASK_PINMASK10_Pos = 0xa        // Position of PINMASK10 field.
	GPIO_MASK_PINMASK10_Msk = 0x400      // Bit mask of PINMASK10 field.
	GPIO_MASK_PINMASK10     = 0x400      // Bit PINMASK10.
	GPIO_MASK_PINMASK11_Pos = 0xb        // Position of PINMASK11 field.
	GPIO_MASK_PINMASK11_Msk = 0x800      // Bit mask of PINMASK11 field.
	GPIO_MASK_PINMASK11     = 0x800      // Bit PINMASK11.
	GPIO_MASK_PINMASK12_Pos = 0xc        // Position of PINMASK12 field.
	GPIO_MASK_PINMASK12_Msk = 0x1000     // Bit mask of PINMASK12 field.
	GPIO_MASK_PINMASK12     = 0x1000     // Bit PINMASK12.
	GPIO_MASK_PINMASK13_Pos = 0xd        // Position of PINMASK13 field.
	GPIO_MASK_PINMASK13_Msk = 0x2000     // Bit mask of PINMASK13 field.
	GPIO_MASK_PINMASK13     = 0x2000     // Bit PINMASK13.
	GPIO_MASK_PINMASK14_Pos = 0xe        // Position of PINMASK14 field.
	GPIO_MASK_PINMASK14_Msk = 0x4000     // Bit mask of PINMASK14 field.
	GPIO_MASK_PINMASK14     = 0x4000     // Bit PINMASK14.
	GPIO_MASK_PINMASK15_Pos = 0xf        // Position of PINMASK15 field.
	GPIO_MASK_PINMASK15_Msk = 0x8000     // Bit mask of PINMASK15 field.
	GPIO_MASK_PINMASK15     = 0x8000     // Bit PINMASK15.
	GPIO_MASK_PINMASK16_Pos = 0x10       // Position of PINMASK16 field.
	GPIO_MASK_PINMASK16_Msk = 0x10000    // Bit mask of PINMASK16 field.
	GPIO_MASK_PINMASK16     = 0x10000    // Bit PINMASK16.
	GPIO_MASK_PINMASK17_Pos = 0x11       // Position of PINMASK17 field.
	GPIO_MASK_PINMASK17_Msk = 0x20000    // Bit mask of PINMASK17 field.
	GPIO_MASK_PINMASK17     = 0x20000    // Bit PINMASK17.
	GPIO_MASK_PINMASK18_Pos = 0x12       // Position of PINMASK18 field.
	GPIO_MASK_PINMASK18_Msk = 0x40000    // Bit mask of PINMASK18 field.
	GPIO_MASK_PINMASK18     = 0x40000    // Bit PINMASK18.
	GPIO_MASK_PINMASK19_Pos = 0x13       // Position of PINMASK19 field.
	GPIO_MASK_PINMASK19_Msk = 0x80000    // Bit mask of PINMASK19 field.
	GPIO_MASK_PINMASK19     = 0x80000    // Bit PINMASK19.
	GPIO_MASK_PINMASK20_Pos = 0x14       // Position of PINMASK20 field.
	GPIO_MASK_PINMASK20_Msk = 0x100000   // Bit mask of PINMASK20 field.
	GPIO_MASK_PINMASK20     = 0x100000   // Bit PINMASK20.
	GPIO_MASK_PINMASK21_Pos = 0x15       // Position of PINMASK21 field.
	GPIO_MASK_PINMASK21_Msk = 0x200000   // Bit mask of PINMASK21 field.
	GPIO_MASK_PINMASK21     = 0x200000   // Bit PINMASK21.
	GPIO_MASK_PINMASK22_Pos = 0x16       // Position of PINMASK22 field.
	GPIO_MASK_PINMASK22_Msk = 0x400000   // Bit mask of PINMASK22 field.
	GPIO_MASK_PINMASK22     = 0x400000   // Bit PINMASK22.
	GPIO_MASK_PINMASK23_Pos = 0x17       // Position of PINMASK23 field.
	GPIO_MASK_PINMASK23_Msk = 0x800000   // Bit mask of PINMASK23 field.
	GPIO_MASK_PINMASK23     = 0x800000   // Bit PINMASK23.
	GPIO_MASK_PINMASK24_Pos = 0x18       // Position of PINMASK24 field.
	GPIO_MASK_PINMASK24_Msk = 0x1000000  // Bit mask of PINMASK24 field.
	GPIO_MASK_PINMASK24     = 0x1000000  // Bit PINMASK24.
	GPIO_MASK_PINMASK25_Pos = 0x19       // Position of PINMASK25 field.
	GPIO_MASK_PINMASK25_Msk = 0x2000000  // Bit mask of PINMASK25 field.
	GPIO_MASK_PINMASK25     = 0x2000000  // Bit PINMASK25.
	GPIO_MASK_PINMASK26_Pos = 0x1a       // Position of PINMASK26 field.
	GPIO_MASK_PINMASK26_Msk = 0x4000000  // Bit mask of PINMASK26 field.
	GPIO_MASK_PINMASK26     = 0x4000000  // Bit PINMASK26.
	GPIO_MASK_PINMASK27_Pos = 0x1b       // Position of PINMASK27 field.
	GPIO_MASK_PINMASK27_Msk = 0x8000000  // Bit mask of PINMASK27 field.
	GPIO_MASK_PINMASK27     = 0x8000000  // Bit PINMASK27.
	GPIO_MASK_PINMASK28_Pos = 0x1c       // Position of PINMASK28 field.
	GPIO_MASK_PINMASK28_Msk = 0x10000000 // Bit mask of PINMASK28 field.
	GPIO_MASK_PINMASK28     = 0x10000000 // Bit PINMASK28.
	GPIO_MASK_PINMASK29_Pos = 0x1d       // Position of PINMASK29 field.
	GPIO_MASK_PINMASK29_Msk = 0x20000000 // Bit mask of PINMASK29 field.
	GPIO_MASK_PINMASK29     = 0x20000000 // Bit PINMASK29.
	GPIO_MASK_PINMASK30_Pos = 0x1e       // Position of PINMASK30 field.
	GPIO_MASK_PINMASK30_Msk = 0x40000000 // Bit mask of PINMASK30 field.
	GPIO_MASK_PINMASK30     = 0x40000000 // Bit PINMASK30.
	GPIO_MASK_PINMASK31_Pos = 0x1f       // Position of PINMASK31 field.
	GPIO_MASK_PINMASK31_Msk = 0x80000000 // Bit mask of PINMASK31 field.
	GPIO_MASK_PINMASK31     = 0x80000000 // Bit PINMASK31.

	// PIN0: Port Pin value register using FIOMASK.
	GPIO_PIN_PINVAL0_Pos  = 0x0        // Position of PINVAL0 field.
	GPIO_PIN_PINVAL0_Msk  = 0x1        // Bit mask of PINVAL0 field.
	GPIO_PIN_PINVAL0      = 0x1        // Bit PINVAL0.
	GPIO_PIN_PINVAL1_Pos  = 0x1        // Position of PINVAL1 field.
	GPIO_PIN_PINVAL1_Msk  = 0x2        // Bit mask of PINVAL1 field.
	GPIO_PIN_PINVAL1      = 0x2        // Bit PINVAL1.
	GPIO_PIN_PINVAL2_Pos  = 0x2        // Position of PINVAL2 field.
	GPIO_PIN_PINVAL2_Msk  = 0x4        // Bit mask of PINVAL2 field.
	GPIO_PIN_PINVAL2      = 0x4        // Bit PINVAL2.
	GPIO_PIN_PINVAL3_Pos  = 0x3        // Position of PINVAL3 field.
	GPIO_PIN_PINVAL3_Msk  = 0x8        // Bit mask of PINVAL3 field.
	GPIO_PIN_PINVAL3      = 0x8        // Bit PINVAL3.
	GPIO_PIN_PINVAL4_Pos  = 0x4        // Position of PINVAL4 field.
	GPIO_PIN_PINVAL4_Msk  = 0x10       // Bit mask of PINVAL4 field.
	GPIO_PIN_PINVAL4      = 0x10       // Bit PINVAL4.
	GPIO_PIN_PINVAL5_Pos  = 0x5        // Position of PINVAL5 field.
	GPIO_PIN_PINVAL5_Msk  = 0x20       // Bit mask of PINVAL5 field.
	GPIO_PIN_PINVAL5      = 0x20       // Bit PINVAL5.
	GPIO_PIN_PINVAL6_Pos  = 0x6        // Position of PINVAL6 field.
	GPIO_PIN_PINVAL6_Msk  = 0x40       // Bit mask of PINVAL6 field.
	GPIO_PIN_PINVAL6      = 0x40       // Bit PINVAL6.
	GPIO_PIN_PINVAL7_Pos  = 0x7        // Position of PINVAL7 field.
	GPIO_PIN_PINVAL7_Msk  = 0x80       // Bit mask of PINVAL7 field.
	GPIO_PIN_PINVAL7      = 0x80       // Bit PINVAL7.
	GPIO_PIN_PINVAL8_Pos  = 0x8        // Position of PINVAL8 field.
	GPIO_PIN_PINVAL8_Msk  = 0x100      // Bit mask of PINVAL8 field.
	GPIO_PIN_PINVAL8      = 0x100      // Bit PINVAL8.
	GPIO_PIN_PINVAL9_Pos  = 0x9        // Position of PINVAL9 field.
	GPIO_PIN_PINVAL9_Msk  = 0x200      // Bit mask of PINVAL9 field.
	GPIO_PIN_PINVAL9      = 0x200      // Bit PINVAL9.
	GPIO_PIN_PINVAL10_Pos = 0xa        // Position of PINVAL10 field.
	GPIO_PIN_PINVAL10_Msk = 0x400      // Bit mask of PINVAL10 field.
	GPIO_PIN_PINVAL10     = 0x400      // Bit PINVAL10.
	GPIO_PIN_PINVAL11_Pos = 0xb        // Position of PINVAL11 field.
	GPIO_PIN_PINVAL11_Msk = 0x800      // Bit mask of PINVAL11 field.
	GPIO_PIN_PINVAL11     = 0x800      // Bit PINVAL11.
	GPIO_PIN_PINVAL12_Pos = 0xc        // Position of PINVAL12 field.
	GPIO_PIN_PINVAL12_Msk = 0x1000     // Bit mask of PINVAL12 field.
	GPIO_PIN_PINVAL12     = 0x1000     // Bit PINVAL12.
	GPIO_PIN_PINVAL13_Pos = 0xd        // Position of PINVAL13 field.
	GPIO_PIN_PINVAL13_Msk = 0x2000     // Bit mask of PINVAL13 field.
	GPIO_PIN_PINVAL13     = 0x2000     // Bit PINVAL13.
	GPIO_PIN_PINVAL14_Pos = 0xe        // Position of PINVAL14 field.
	GPIO_PIN_PINVAL14_Msk = 0x4000     // Bit mask of PINVAL14 field.
	GPIO_PIN_PINVAL14     = 0x4000     // Bit PINVAL14.
	GPIO_PIN_PINVAL15_Pos = 0xf        // Position of PINVAL15 field.
	GPIO_PIN_PINVAL15_Msk = 0x8000     // Bit mask of PINVAL15 field.
	GPIO_PIN_PINVAL15     = 0x8000     // Bit PINVAL15.
	GPIO_PIN_PINVAL16_Pos = 0x10       // Position of PINVAL16 field.
	GPIO_PIN_PINVAL16_Msk = 0x10000    // Bit mask of PINVAL16 field.
	GPIO_PIN_PINVAL16     = 0x10000    // Bit PINVAL16.
	GPIO_PIN_PINVAL17_Pos = 0x11       // Position of PINVAL17 field.
	GPIO_PIN_PINVAL17_Msk = 0x20000    // Bit mask of PINVAL17 field.
	GPIO_PIN_PINVAL17     = 0x20000    // Bit PINVAL17.
	GPIO_PIN_PINVAL18_Pos = 0x12       // Position of PINVAL18 field.
	GPIO_PIN_PINVAL18_Msk = 0x40000    // Bit mask of PINVAL18 field.
	GPIO_PIN_PINVAL18     = 0x40000    // Bit PINVAL18.
	GPIO_PIN_PINVAL19_Pos = 0x13       // Position of PINVAL19 field.
	GPIO_PIN_PINVAL19_Msk = 0x80000    // Bit mask of PINVAL19 field.
	GPIO_PIN_PINVAL19     = 0x80000    // Bit PINVAL19.
	GPIO_PIN_PINVAL20_Pos = 0x14       // Position of PINVAL20 field.
	GPIO_PIN_PINVAL20_Msk = 0x100000   // Bit mask of PINVAL20 field.
	GPIO_PIN_PINVAL20     = 0x100000   // Bit PINVAL20.
	GPIO_PIN_PINVAL21_Pos = 0x15       // Position of PINVAL21 field.
	GPIO_PIN_PINVAL21_Msk = 0x200000   // Bit mask of PINVAL21 field.
	GPIO_PIN_PINVAL21     = 0x200000   // Bit PINVAL21.
	GPIO_PIN_PINVAL22_Pos = 0x16       // Position of PINVAL22 field.
	GPIO_PIN_PINVAL22_Msk = 0x400000   // Bit mask of PINVAL22 field.
	GPIO_PIN_PINVAL22     = 0x400000   // Bit PINVAL22.
	GPIO_PIN_PINVAL23_Pos = 0x17       // Position of PINVAL23 field.
	GPIO_PIN_PINVAL23_Msk = 0x800000   // Bit mask of PINVAL23 field.
	GPIO_PIN_PINVAL23     = 0x800000   // Bit PINVAL23.
	GPIO_PIN_PINVAL24_Pos = 0x18       // Position of PINVAL24 field.
	GPIO_PIN_PINVAL24_Msk = 0x1000000  // Bit mask of PINVAL24 field.
	GPIO_PIN_PINVAL24     = 0x1000000  // Bit PINVAL24.
	GPIO_PIN_PINVAL25_Pos = 0x19       // Position of PINVAL25 field.
	GPIO_PIN_PINVAL25_Msk = 0x2000000  // Bit mask of PINVAL25 field.
	GPIO_PIN_PINVAL25     = 0x2000000  // Bit PINVAL25.
	GPIO_PIN_PINVAL26_Pos = 0x1a       // Position of PINVAL26 field.
	GPIO_PIN_PINVAL26_Msk = 0x4000000  // Bit mask of PINVAL26 field.
	GPIO_PIN_PINVAL26     = 0x4000000  // Bit PINVAL26.
	GPIO_PIN_PINVAL27_Pos = 0x1b       // Position of PINVAL27 field.
	GPIO_PIN_PINVAL27_Msk = 0x8000000  // Bit mask of PINVAL27 field.
	GPIO_PIN_PINVAL27     = 0x8000000  // Bit PINVAL27.
	GPIO_PIN_PINVAL28_Pos = 0x1c       // Position of PINVAL28 field.
	GPIO_PIN_PINVAL28_Msk = 0x10000000 // Bit mask of PINVAL28 field.
	GPIO_PIN_PINVAL28     = 0x10000000 // Bit PINVAL28.
	GPIO_PIN_PINVAL29_Pos = 0x1d       // Position of PINVAL29 field.
	GPIO_PIN_PINVAL29_Msk = 0x20000000 // Bit mask of PINVAL29 field.
	GPIO_PIN_PINVAL29     = 0x20000000 // Bit PINVAL29.
	GPIO_PIN_PINVAL30_Pos = 0x1e       // Position of PINVAL30 field.
	GPIO_PIN_PINVAL30_Msk = 0x40000000 // Bit mask of PINVAL30 field.
	GPIO_PIN_PINVAL30     = 0x40000000 // Bit PINVAL30.
	GPIO_PIN_PINVAL31_Pos = 0x1f       // Position of PINVAL31 field.
	GPIO_PIN_PINVAL31_Msk = 0x80000000 // Bit mask of PINVAL31 field.
	GPIO_PIN_PINVAL31     = 0x80000000 // Bit PINVAL31.

	// SET0: Port Output Set register using FIOMASK.
	GPIO_SET_PINSET0_Pos  = 0x0        // Position of PINSET0 field.
	GPIO_SET_PINSET0_Msk  = 0x1        // Bit mask of PINSET0 field.
	GPIO_SET_PINSET0      = 0x1        // Bit PINSET0.
	GPIO_SET_PINSET1_Pos  = 0x1        // Position of PINSET1 field.
	GPIO_SET_PINSET1_Msk  = 0x2        // Bit mask of PINSET1 field.
	GPIO_SET_PINSET1      = 0x2        // Bit PINSET1.
	GPIO_SET_PINSET2_Pos  = 0x2        // Position of PINSET2 field.
	GPIO_SET_PINSET2_Msk  = 0x4        // Bit mask of PINSET2 field.
	GPIO_SET_PINSET2      = 0x4        // Bit PINSET2.
	GPIO_SET_PINSET3_Pos  = 0x3        // Position of PINSET3 field.
	GPIO_SET_PINSET3_Msk  = 0x8        // Bit mask of PINSET3 field.
	GPIO_SET_PINSET3      = 0x8        // Bit PINSET3.
	GPIO_SET_PINSET4_Pos  = 0x4        // Position of PINSET4 field.
	GPIO_SET_PINSET4_Msk  = 0x10       // Bit mask of PINSET4 field.
	GPIO_SET_PINSET4      = 0x10       // Bit PINSET4.
	GPIO_SET_PINSET5_Pos  = 0x5        // Position of PINSET5 field.
	GPIO_SET_PINSET5_Msk  = 0x20       // Bit mask of PINSET5 field.
	GPIO_SET_PINSET5      = 0x20       // Bit PINSET5.
	GPIO_SET_PINSET6_Pos  = 0x6        // Position of PINSET6 field.
	GPIO_SET_PINSET6_Msk  = 0x40       // Bit mask of PINSET6 field.
	GPIO_SET_PINSET6      = 0x40       // Bit PINSET6.
	GPIO_SET_PINSET7_Pos  = 0x7        // Position of PINSET7 field.
	GPIO_SET_PINSET7_Msk  = 0x80       // Bit mask of PINSET7 field.
	GPIO_SET_PINSET7      = 0x80       // Bit PINSET7.
	GPIO_SET_PINSET8_Pos  = 0x8        // Position of PINSET8 field.
	GPIO_SET_PINSET8_Msk  = 0x100      // Bit mask of PINSET8 field.
	GPIO_SET_PINSET8      = 0x100      // Bit PINSET8.
	GPIO_SET_PINSET9_Pos  = 0x9        // Position of PINSET9 field.
	GPIO_SET_PINSET9_Msk  = 0x200      // Bit mask of PINSET9 field.
	GPIO_SET_PINSET9      = 0x200      // Bit PINSET9.
	GPIO_SET_PINSET10_Pos = 0xa        // Position of PINSET10 field.
	GPIO_SET_PINSET10_Msk = 0x400      // Bit mask of PINSET10 field.
	GPIO_SET_PINSET10     = 0x400      // Bit PINSET10.
	GPIO_SET_PINSET11_Pos = 0xb        // Position of PINSET11 field.
	GPIO_SET_PINSET11_Msk = 0x800      // Bit mask of PINSET11 field.
	GPIO_SET_PINSET11     = 0x800      // Bit PINSET11.
	GPIO_SET_PINSET12_Pos = 0xc        // Position of PINSET12 field.
	GPIO_SET_PINSET12_Msk = 0x1000     // Bit mask of PINSET12 field.
	GPIO_SET_PINSET12     = 0x1000     // Bit PINSET12.
	GPIO_SET_PINSET13_Pos = 0xd        // Position of PINSET13 field.
	GPIO_SET_PINSET13_Msk = 0x2000     // Bit mask of PINSET13 field.
	GPIO_SET_PINSET13     = 0x2000     // Bit PINSET13.
	GPIO_SET_PINSET14_Pos = 0xe        // Position of PINSET14 field.
	GPIO_SET_PINSET14_Msk = 0x4000     // Bit mask of PINSET14 field.
	GPIO_SET_PINSET14     = 0x4000     // Bit PINSET14.
	GPIO_SET_PINSET15_Pos = 0xf        // Position of PINSET15 field.
	GPIO_SET_PINSET15_Msk = 0x8000     // Bit mask of PINSET15 field.
	GPIO_SET_PINSET15     = 0x8000     // Bit PINSET15.
	GPIO_SET_PINSET16_Pos = 0x10       // Position of PINSET16 field.
	GPIO_SET_PINSET16_Msk = 0x10000    // Bit mask of PINSET16 field.
	GPIO_SET_PINSET16     = 0x10000    // Bit PINSET16.
	GPIO_SET_PINSET17_Pos = 0x11       // Position of PINSET17 field.
	GPIO_SET_PINSET17_Msk = 0x20000    // Bit mask of PINSET17 field.
	GPIO_SET_PINSET17     = 0x20000    // Bit PINSET17.
	GPIO_SET_PINSET18_Pos = 0x12       // Position of PINSET18 field.
	GPIO_SET_PINSET18_Msk = 0x40000    // Bit mask of PINSET18 field.
	GPIO_SET_PINSET18     = 0x40000    // Bit PINSET18.
	GPIO_SET_PINSET19_Pos = 0x13       // Position of PINSET19 field.
	GPIO_SET_PINSET19_Msk = 0x80000    // Bit mask of PINSET19 field.
	GPIO_SET_PINSET19     = 0x80000    // Bit PINSET19.
	GPIO_SET_PINSET20_Pos = 0x14       // Position of PINSET20 field.
	GPIO_SET_PINSET20_Msk = 0x100000   // Bit mask of PINSET20 field.
	GPIO_SET_PINSET20     = 0x100000   // Bit PINSET20.
	GPIO_SET_PINSET21_Pos = 0x15       // Position of PINSET21 field.
	GPIO_SET_PINSET21_Msk = 0x200000   // Bit mask of PINSET21 field.
	GPIO_SET_PINSET21     = 0x200000   // Bit PINSET21.
	GPIO_SET_PINSET22_Pos = 0x16       // Position of PINSET22 field.
	GPIO_SET_PINSET22_Msk = 0x400000   // Bit mask of PINSET22 field.
	GPIO_SET_PINSET22     = 0x400000   // Bit PINSET22.
	GPIO_SET_PINSET23_Pos = 0x17       // Position of PINSET23 field.
	GPIO_SET_PINSET23_Msk = 0x800000   // Bit mask of PINSET23 field.
	GPIO_SET_PINSET23     = 0x800000   // Bit PINSET23.
	GPIO_SET_PINSET24_Pos = 0x18       // Position of PINSET24 field.
	GPIO_SET_PINSET24_Msk = 0x1000000  // Bit mask of PINSET24 field.
	GPIO_SET_PINSET24     = 0x1000000  // Bit PINSET24.
	GPIO_SET_PINSET25_Pos = 0x19       // Position of PINSET25 field.
	GPIO_SET_PINSET25_Msk = 0x2000000  // Bit mask of PINSET25 field.
	GPIO_SET_PINSET25     = 0x2000000  // Bit PINSET25.
	GPIO_SET_PINSET26_Pos = 0x1a       // Position of PINSET26 field.
	GPIO_SET_PINSET26_Msk = 0x4000000  // Bit mask of PINSET26 field.
	GPIO_SET_PINSET26     = 0x4000000  // Bit PINSET26.
	GPIO_SET_PINSET27_Pos = 0x1b       // Position of PINSET27 field.
	GPIO_SET_PINSET27_Msk = 0x8000000  // Bit mask of PINSET27 field.
	GPIO_SET_PINSET27     = 0x8000000  // Bit PINSET27.
	GPIO_SET_PINSET28_Pos = 0x1c       // Position of PINSET28 field.
	GPIO_SET_PINSET28_Msk = 0x10000000 // Bit mask of PINSET28 field.
	GPIO_SET_PINSET28     = 0x10000000 // Bit PINSET28.
	GPIO_SET_PINSET29_Pos = 0x1d       // Position of PINSET29 field.
	GPIO_SET_PINSET29_Msk = 0x20000000 // Bit mask of PINSET29 field.
	GPIO_SET_PINSET29     = 0x20000000 // Bit PINSET29.
	GPIO_SET_PINSET30_Pos = 0x1e       // Position of PINSET30 field.
	GPIO_SET_PINSET30_Msk = 0x40000000 // Bit mask of PINSET30 field.
	GPIO_SET_PINSET30     = 0x40000000 // Bit PINSET30.
	GPIO_SET_PINSET31_Pos = 0x1f       // Position of PINSET31 field.
	GPIO_SET_PINSET31_Msk = 0x80000000 // Bit mask of PINSET31 field.
	GPIO_SET_PINSET31     = 0x80000000 // Bit PINSET31.

	// CLR0: Port Output Clear register using FIOMASK.
	GPIO_CLR_PINCLR0_Pos  = 0x0        // Position of PINCLR0 field.
	GPIO_CLR_PINCLR0_Msk  = 0x1        // Bit mask of PINCLR0 field.
	GPIO_CLR_PINCLR0      = 0x1        // Bit PINCLR0.
	GPIO_CLR_PINCLR1_Pos  = 0x1        // Position of PINCLR1 field.
	GPIO_CLR_PINCLR1_Msk  = 0x2        // Bit mask of PINCLR1 field.
	GPIO_CLR_PINCLR1      = 0x2        // Bit PINCLR1.
	GPIO_CLR_PINCLR2_Pos  = 0x2        // Position of PINCLR2 field.
	GPIO_CLR_PINCLR2_Msk  = 0x4        // Bit mask of PINCLR2 field.
	GPIO_CLR_PINCLR2      = 0x4        // Bit PINCLR2.
	GPIO_CLR_PINCLR3_Pos  = 0x3        // Position of PINCLR3 field.
	GPIO_CLR_PINCLR3_Msk  = 0x8        // Bit mask of PINCLR3 field.
	GPIO_CLR_PINCLR3      = 0x8        // Bit PINCLR3.
	GPIO_CLR_PINCLR4_Pos  = 0x4        // Position of PINCLR4 field.
	GPIO_CLR_PINCLR4_Msk  = 0x10       // Bit mask of PINCLR4 field.
	GPIO_CLR_PINCLR4      = 0x10       // Bit PINCLR4.
	GPIO_CLR_PINCLR5_Pos  = 0x5        // Position of PINCLR5 field.
	GPIO_CLR_PINCLR5_Msk  = 0x20       // Bit mask of PINCLR5 field.
	GPIO_CLR_PINCLR5      = 0x20       // Bit PINCLR5.
	GPIO_CLR_PINCLR6_Pos  = 0x6        // Position of PINCLR6 field.
	GPIO_CLR_PINCLR6_Msk  = 0x40       // Bit mask of PINCLR6 field.
	GPIO_CLR_PINCLR6      = 0x40       // Bit PINCLR6.
	GPIO_CLR_PINCLR7_Pos  = 0x7        // Position of PINCLR7 field.
	GPIO_CLR_PINCLR7_Msk  = 0x80       // Bit mask of PINCLR7 field.
	GPIO_CLR_PINCLR7      = 0x80       // Bit PINCLR7.
	GPIO_CLR_PINCLR8_Pos  = 0x8        // Position of PINCLR8 field.
	GPIO_CLR_PINCLR8_Msk  = 0x100      // Bit mask of PINCLR8 field.
	GPIO_CLR_PINCLR8      = 0x100      // Bit PINCLR8.
	GPIO_CLR_PINCLR9_Pos  = 0x9        // Position of PINCLR9 field.
	GPIO_CLR_PINCLR9_Msk  = 0x200      // Bit mask of PINCLR9 field.
	GPIO_CLR_PINCLR9      = 0x200      // Bit PINCLR9.
	GPIO_CLR_PINCLR10_Pos = 0xa        // Position of PINCLR10 field.
	GPIO_CLR_PINCLR10_Msk = 0x400      // Bit mask of PINCLR10 field.
	GPIO_CLR_PINCLR10     = 0x400      // Bit PINCLR10.
	GPIO_CLR_PINCLR11_Pos = 0xb        // Position of PINCLR11 field.
	GPIO_CLR_PINCLR11_Msk = 0x800      // Bit mask of PINCLR11 field.
	GPIO_CLR_PINCLR11     = 0x800      // Bit PINCLR11.
	GPIO_CLR_PINCLR12_Pos = 0xc        // Position of PINCLR12 field.
	GPIO_CLR_PINCLR12_Msk = 0x1000     // Bit mask of PINCLR12 field.
	GPIO_CLR_PINCLR12     = 0x1000     // Bit PINCLR12.
	GPIO_CLR_PINCLR13_Pos = 0xd        // Position of PINCLR13 field.
	GPIO_CLR_PINCLR13_Msk = 0x2000     // Bit mask of PINCLR13 field.
	GPIO_CLR_PINCLR13     = 0x2000     // Bit PINCLR13.
	GPIO_CLR_PINCLR14_Pos = 0xe        // Position of PINCLR14 field.
	GPIO_CLR_PINCLR14_Msk = 0x4000     // Bit mask of PINCLR14 field.
	GPIO_CLR_PINCLR14     = 0x4000     // Bit PINCLR14.
	GPIO_CLR_PINCLR15_Pos = 0xf        // Position of PINCLR15 field.
	GPIO_CLR_PINCLR15_Msk = 0x8000     // Bit mask of PINCLR15 field.
	GPIO_CLR_PINCLR15     = 0x8000     // Bit PINCLR15.
	GPIO_CLR_PINCLR16_Pos = 0x10       // Position of PINCLR16 field.
	GPIO_CLR_PINCLR16_Msk = 0x10000    // Bit mask of PINCLR16 field.
	GPIO_CLR_PINCLR16     = 0x10000    // Bit PINCLR16.
	GPIO_CLR_PINCLR17_Pos = 0x11       // Position of PINCLR17 field.
	GPIO_CLR_PINCLR17_Msk = 0x20000    // Bit mask of PINCLR17 field.
	GPIO_CLR_PINCLR17     = 0x20000    // Bit PINCLR17.
	GPIO_CLR_PINCLR18_Pos = 0x12       // Position of PINCLR18 field.
	GPIO_CLR_PINCLR18_Msk = 0x40000    // Bit mask of PINCLR18 field.
	GPIO_CLR_PINCLR18     = 0x40000    // Bit PINCLR18.
	GPIO_CLR_PINCLR19_Pos = 0x13       // Position of PINCLR19 field.
	GPIO_CLR_PINCLR19_Msk = 0x80000    // Bit mask of PINCLR19 field.
	GPIO_CLR_PINCLR19     = 0x80000    // Bit PINCLR19.
	GPIO_CLR_PINCLR20_Pos = 0x14       // Position of PINCLR20 field.
	GPIO_CLR_PINCLR20_Msk = 0x100000   // Bit mask of PINCLR20 field.
	GPIO_CLR_PINCLR20     = 0x100000   // Bit PINCLR20.
	GPIO_CLR_PINCLR21_Pos = 0x15       // Position of PINCLR21 field.
	GPIO_CLR_PINCLR21_Msk = 0x200000   // Bit mask of PINCLR21 field.
	GPIO_CLR_PINCLR21     = 0x200000   // Bit PINCLR21.
	GPIO_CLR_PINCLR22_Pos = 0x16       // Position of PINCLR22 field.
	GPIO_CLR_PINCLR22_Msk = 0x400000   // Bit mask of PINCLR22 field.
	GPIO_CLR_PINCLR22     = 0x400000   // Bit PINCLR22.
	GPIO_CLR_PINCLR23_Pos = 0x17       // Position of PINCLR23 field.
	GPIO_CLR_PINCLR23_Msk = 0x800000   // Bit mask of PINCLR23 field.
	GPIO_CLR_PINCLR23     = 0x800000   // Bit PINCLR23.
	GPIO_CLR_PINCLR24_Pos = 0x18       // Position of PINCLR24 field.
	GPIO_CLR_PINCLR24_Msk = 0x1000000  // Bit mask of PINCLR24 field.
	GPIO_CLR_PINCLR24     = 0x1000000  // Bit PINCLR24.
	GPIO_CLR_PINCLR25_Pos = 0x19       // Position of PINCLR25 field.
	GPIO_CLR_PINCLR25_Msk = 0x2000000  // Bit mask of PINCLR25 field.
	GPIO_CLR_PINCLR25     = 0x2000000  // Bit PINCLR25.
	GPIO_CLR_PINCLR26_Pos = 0x1a       // Position of PINCLR26 field.
	GPIO_CLR_PINCLR26_Msk = 0x4000000  // Bit mask of PINCLR26 field.
	GPIO_CLR_PINCLR26     = 0x4000000  // Bit PINCLR26.
	GPIO_CLR_PINCLR27_Pos = 0x1b       // Position of PINCLR27 field.
	GPIO_CLR_PINCLR27_Msk = 0x8000000  // Bit mask of PINCLR27 field.
	GPIO_CLR_PINCLR27     = 0x8000000  // Bit PINCLR27.
	GPIO_CLR_PINCLR28_Pos = 0x1c       // Position of PINCLR28 field.
	GPIO_CLR_PINCLR28_Msk = 0x10000000 // Bit mask of PINCLR28 field.
	GPIO_CLR_PINCLR28     = 0x10000000 // Bit PINCLR28.
	GPIO_CLR_PINCLR29_Pos = 0x1d       // Position of PINCLR29 field.
	GPIO_CLR_PINCLR29_Msk = 0x20000000 // Bit mask of PINCLR29 field.
	GPIO_CLR_PINCLR29     = 0x20000000 // Bit PINCLR29.
	GPIO_CLR_PINCLR30_Pos = 0x1e       // Position of PINCLR30 field.
	GPIO_CLR_PINCLR30_Msk = 0x40000000 // Bit mask of PINCLR30 field.
	GPIO_CLR_PINCLR30     = 0x40000000 // Bit PINCLR30.
	GPIO_CLR_PINCLR31_Pos = 0x1f       // Position of PINCLR31 field.
	GPIO_CLR_PINCLR31_Msk = 0x80000000 // Bit mask of PINCLR31 field.
	GPIO_CLR_PINCLR31     = 0x80000000 // Bit PINCLR31.
)
