// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32L4R7.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32l4r7

// STM32L4R7
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32L4R7"
)

// Interrupt numbers.
const (
	IRQ_WWDG               = 0  // System window watchdog
	IRQ_PVD_PVM            = 1  // External interrupt/event controller
	IRQ_TAMP_STAMP         = 2  // Real-time clock
	IRQ_RTC_WKUP           = 3  // Real-time clock
	IRQ_FLASH              = 4  // Flash
	IRQ_RCC                = 5  // Reset and clock control
	IRQ_EXTI0              = 6  // External interrupt/event controller
	IRQ_EXTI1              = 7  // External interrupt/event controller
	IRQ_EXTI2              = 8  // External interrupt/event controller
	IRQ_EXTI3              = 9  // External interrupt/event controller
	IRQ_EXTI4              = 10 // External interrupt/event controller
	IRQ_DMA1_CH1           = 11 // Direct memory access controller
	IRQ_DMA1_CH2           = 12 // Direct memory access controller
	IRQ_DMA1_CH3           = 13 // Direct memory access controller
	IRQ_DMA1_CH4           = 14 // Direct memory access controller
	IRQ_DMA1_CH5           = 15 // Direct memory access controller
	IRQ_DMA1_CH6           = 16 // Direct memory access controller
	IRQ_DMA1_CH7           = 17 // Direct memory access controller
	IRQ_ADC1               = 18 // Analog-to-Digital Converter
	IRQ_CAN1_TX            = 19 // Controller area network
	IRQ_CAN1_RX0           = 20 // Controller area network
	IRQ_CAN1_RX1           = 21 // Controller area network
	IRQ_CAN1_SCE           = 22 // Controller area network
	IRQ_EXTI9_5            = 23 // External interrupt/event controller
	IRQ_TIM1_BRK_TIM15     = 24 // Advanced-timers
	IRQ_TIM1_UP_TIM16      = 25 // Advanced-timers
	IRQ_TIM1_TRG_COM_TIM17 = 26 // Advanced-timers
	IRQ_TIM1_CC            = 27 // Advanced-timers
	IRQ_TIM2               = 28 // General-purpose-timers
	IRQ_TIM3               = 29 //
	IRQ_TIM4               = 30 //
	IRQ_I2C1_EV            = 31 // Inter-integrated circuit
	IRQ_I2C1_ER            = 32 // Inter-integrated circuit
	IRQ_I2C2_EV            = 33 //
	IRQ_I2C2_ER            = 34 //
	IRQ_SPI1               = 35 // Serial peripheral interface/Inter-IC sound
	IRQ_SPI2               = 36 //
	IRQ_USART1             = 37 // Universal synchronous asynchronous receiver transmitter
	IRQ_USART2             = 38 //
	IRQ_USART3             = 39 //
	IRQ_EXTI15_10          = 40 // External interrupt/event controller
	IRQ_RTC_ALARM          = 41 // Real-time clock
	IRQ_DFSDM1_FLT3        = 42 // Digital filter for sigma delta modulators
	IRQ_TIM8_BRK           = 43 // Advanced-timers
	IRQ_TIM8_UP            = 44 // Advanced-timers
	IRQ_TIM8_TRG_COM       = 45 // Advanced-timers
	IRQ_TIM8_CC            = 46 // Advanced-timers
	IRQ_ADC3               = 47 // Analog-to-Digital Converter
	IRQ_FMC                = 48 // Flexible memory controller
	IRQ_SDMMC1             = 49 // Secure digital input/output interface
	IRQ_TIM5               = 50 //
	IRQ_SPI3               = 51 //
	IRQ_UART4              = 52 //
	IRQ_UART5              = 53 //
	IRQ_TIM6_DACUNDER      = 54 // Basic-timers
	IRQ_TIM7               = 55 //
	IRQ_DMA2_CH1           = 56 //
	IRQ_DMA2_CH2           = 57 //
	IRQ_DMA2_CH3           = 58 //
	IRQ_DMA2_CH4           = 59 //
	IRQ_DMA2_CH5           = 60 //
	IRQ_DFSDM1_FLT0        = 61 // Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT1        = 62 // Digital filter for sigma delta modulators
	IRQ_DFSDM1_FLT2        = 63 // Digital filter for sigma delta modulators
	IRQ_COMP               = 64 // Comparator
	IRQ_LPTIM1             = 65 // Low power timer
	IRQ_LPTIM2             = 66 //
	IRQ_OTG_FS             = 67 // USB on the go full speed
	IRQ_DMA2_CH6           = 68 //
	IRQ_DMA2_CH7           = 69 //
	IRQ_LPUART1            = 70 // Universal synchronous asynchronous receiver transmitter
	IRQ_OCTOSPI1           = 71 // OctoSPI
	IRQ_I2C3_EV            = 72 //
	IRQ_I2C3_ER            = 73 //
	IRQ_SAI1               = 74 // Serial audio interface
	IRQ_SAI2               = 75 //
	IRQ_OCTOSPI2           = 76 //
	IRQ_TSC                = 77 // Touch sensing controller
	IRQ_DSIHSOT            = 78 // DSI Host
	IRQ_AES                = 79 // Advanced encryption standard hardware accelerator
	IRQ_RNG_HASH           = 80 // Random number generator
	IRQ_FPU                = 81 // Flexible memory controller // Floting point unit
	IRQ_CRS                = 82 // Clock recovery system
	IRQ_I2C4_ER            = 83 //
	IRQ_I2C4_EV            = 84 //
	IRQ_DCMI               = 85 // Digital camera interface
	IRQ_DMA2D              = 90 // DMA2D controller
	IRQ_LCD_TFT            = 91 // Liquid crystal display controller
	IRQ_LCD_TFT_ER         = 92 // Liquid crystal display controller
	IRQ_GFXMMU             = 93 // Graphic MMU
	IRQ_DMAMUX_OVR         = 94 // Direct memory access controller
	IRQ_max                = 94 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD_PVM, "PVD_PVM_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2, "EXTI2_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH1, "DMA1_CH1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH2, "DMA1_CH2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH3, "DMA1_CH3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH4, "DMA1_CH4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH5, "DMA1_CH5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH6, "DMA1_CH6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH7, "DMA1_CH7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1, "ADC1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_TX, "CAN1_TX_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX0, "CAN1_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_RX1, "CAN1_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN1_SCE, "CAN1_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM15, "TIM1_BRK_TIM15_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM16, "TIM1_UP_TIM16_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM17, "TIM1_TRG_COM_TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV, "I2C1_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV, "I2C2_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1, "USART1_IRQHandler")
	_ = interrupt.Register(IRQ_USART2, "USART2_IRQHandler")
	_ = interrupt.Register(IRQ_USART3, "USART3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_ALARM, "RTC_ALARM_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT3, "DFSDM1_FLT3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_BRK, "TIM8_BRK_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_UP, "TIM8_UP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_TRG_COM, "TIM8_TRG_COM_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_CC, "TIM8_CC_IRQHandler")
	_ = interrupt.Register(IRQ_ADC3, "ADC3_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_SDMMC1, "SDMMC1_IRQHandler")
	_ = interrupt.Register(IRQ_TIM5, "TIM5_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4, "UART4_IRQHandler")
	_ = interrupt.Register(IRQ_UART5, "UART5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DACUNDER, "TIM6_DACUNDER_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH1, "DMA2_CH1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH2, "DMA2_CH2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH3, "DMA2_CH3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH4, "DMA2_CH4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH5, "DMA2_CH5_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT0, "DFSDM1_FLT0_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT1, "DFSDM1_FLT1_IRQHandler")
	_ = interrupt.Register(IRQ_DFSDM1_FLT2, "DFSDM1_FLT2_IRQHandler")
	_ = interrupt.Register(IRQ_COMP, "COMP_IRQHandler")
	_ = interrupt.Register(IRQ_LPTIM1, "LPTIM1_IRQHandler")
	_ = interrupt.Register(IRQ_LPTIM2, "LPTIM2_IRQHandler")
	_ = interrupt.Register(IRQ_OTG_FS, "OTG_FS_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH6, "DMA2_CH6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH7, "DMA2_CH7_IRQHandler")
	_ = interrupt.Register(IRQ_LPUART1, "LPUART1_IRQHandler")
	_ = interrupt.Register(IRQ_OCTOSPI1, "OCTOSPI1_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SAI1, "SAI1_IRQHandler")
	_ = interrupt.Register(IRQ_SAI2, "SAI2_IRQHandler")
	_ = interrupt.Register(IRQ_OCTOSPI2, "OCTOSPI2_IRQHandler")
	_ = interrupt.Register(IRQ_TSC, "TSC_IRQHandler")
	_ = interrupt.Register(IRQ_DSIHSOT, "DSIHSOT_IRQHandler")
	_ = interrupt.Register(IRQ_AES, "AES_IRQHandler")
	_ = interrupt.Register(IRQ_RNG_HASH, "RNG_HASH_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_CRS, "CRS_IRQHandler")
	_ = interrupt.Register(IRQ_I2C4_ER, "I2C4_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C4_EV, "I2C4_EV_IRQHandler")
	_ = interrupt.Register(IRQ_DCMI, "DCMI_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2D, "DMA2D_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT, "LCD_TFT_IRQHandler")
	_ = interrupt.Register(IRQ_LCD_TFT_ER, "LCD_TFT_ER_IRQHandler")
	_ = interrupt.Register(IRQ_GFXMMU, "GFXMMU_IRQHandler")
	_ = interrupt.Register(IRQ_DMAMUX_OVR, "DMAMUX_OVR_IRQHandler")
)

// Peripherals.
var (
	DAC           = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))        // Digital-to-analog converter
	DMA1          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))        // Direct memory access controller
	CRC           = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))        // Cyclic redundancy check calculation unit
	LTCD          = (*LCD_Type)(unsafe.Pointer(uintptr(0x40016800)))        // Liquid crystal display controller
	TSC           = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))        // Touch sensing controller
	IWDG          = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))       // Independent watchdog
	WWDG          = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))       // System window watchdog
	COMP          = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010200)))       // Comparator
	FIREWALL      = (*Firewall_Type)(unsafe.Pointer(uintptr(0x40011c00)))   // Firewall
	I2C1          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))        // Inter-integrated circuit
	FLASH         = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))      // Flash
	DBGMCU        = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))     // Debug support
	OCTOSPI1      = (*OctoSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))    // OctoSPI
	RCC           = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))        // Reset and clock control
	PWR           = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))        // Power control
	SYSCFG        = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))     // System configuration controller
	DFSDM1        = (*DFSDM_Type)(unsafe.Pointer(uintptr(0x40016000)))      // Digital filter for sigma delta modulators
	RNG           = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))        // Random number generator
	AES           = (*AES_Type)(unsafe.Pointer(uintptr(0x50060000)))        // Advanced encryption standard hardware accelerator
	ADC           = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040000)))        // Analog-to-Digital Converter
	ADC_Common    = (*ADC_Type)(unsafe.Pointer(uintptr(0x50040300)))        // Analog-to-Digital Converter
	GPIOA         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))       // General-purpose I/Os
	GPIOB         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))       // General-purpose I/Os
	GPIOC         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))       // General-purpose I/Os
	GPIOI         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48002000)))       // General-purpose I/Os
	SAI1          = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015400)))        // Serial audio interface
	TIM2          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))        // General-purpose-timers
	TIM15         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))        // General purpose timers
	TIM16         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))        // General purpose timers
	TIM1          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))        // Advanced-timers
	TIM8          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40013400)))        // Advanced-timers
	TIM6          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))        // Basic-timers
	LPTIM1        = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40007c00)))      // Low power timer
	USART1        = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))      // Universal synchronous asynchronous receiver transmitter
	LPUART1       = (*USART_Type)(unsafe.Pointer(uintptr(0x40008000)))      // Universal synchronous asynchronous receiver transmitter
	SPI1          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))        // Serial peripheral interface/Inter-IC sound
	SDMMC1        = (*SDIO_Type)(unsafe.Pointer(uintptr(0x50062400)))       // Secure digital input/output interface
	EXTI          = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))       // External interrupt/event controller
	VREFBUF       = (*VREF_Type)(unsafe.Pointer(uintptr(0x40010030)))       // Voltage reference buffer
	CAN1          = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))        // Controller area network
	RTC           = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))        // Real-time clock
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000))) // USB on the go full speed
	OTG_FS_HOST   = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400))) // USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800))) // USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00))) // USB on the go full speed
	SWPMI1        = (*SWPMI_Type)(unsafe.Pointer(uintptr(0x40008800)))      // Single Wire Protocol Master Interface
	OPAMP         = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40007800)))      // Operational amplifiers
	FMC           = (*FMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))        // Flexible memory controller
	NVIC          = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))       // Nested Vectored Interrupt Controller
	CRS           = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006000)))        // Clock recovery system
	DCMI          = (*DCMI_Type)(unsafe.Pointer(uintptr(0x50050000)))       // Digital camera interface
	HASH          = (*HASH_Type)(unsafe.Pointer(uintptr(0x50060400)))       // Hash processor
	DMA2D         = (*DMA2D_Type)(unsafe.Pointer(uintptr(0x4002b000)))      // DMA2D controller
	DSI           = (*DSI_Type)(unsafe.Pointer(uintptr(0x40016c00)))        // DSI Host
	GFXMMU        = (*GFXMMU_Type)(unsafe.Pointer(uintptr(0x4002c000)))     // Graphic MMU
	OCTOSPIM      = (*OCTOSPIM_Type)(unsafe.Pointer(uintptr(0x50061c00)))   // OctoSPI IO Manager
	FPU           = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))        // Floting point unit
	MPU           = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))        // Memory protection unit
	STK           = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))        // SysTick timer
	SCB           = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))        // System control block
	NVIC_STIR     = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))       // Nested vectored interrupt controller
	FPU_CPACR     = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))        // Floating point unit CPACR
	SCB_ACTRL     = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))        // System control block ACTLR
	DMA2          = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))        // Direct memory access controller
	I2C2          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))        // Inter-integrated circuit
	I2C3          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))        // Inter-integrated circuit
	I2C4          = (*I2C_Type)(unsafe.Pointer(uintptr(0x40008400)))        // Inter-integrated circuit
	OCTOSPI2      = (*OctoSPI_Type)(unsafe.Pointer(uintptr(0xa0001400)))    // OctoSPI
	GPIOD         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))       // General-purpose I/Os
	GPIOE         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))       // General-purpose I/Os
	GPIOF         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))       // General-purpose I/Os
	GPIOG         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001800)))       // General-purpose I/Os
	GPIOH         = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))       // General-purpose I/Os
	SAI2          = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))        // Serial audio interface
	TIM3          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))        // General-purpose-timers
	TIM4          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))        // General-purpose-timers
	TIM5          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))        // General-purpose-timers
	TIM17         = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))        // General purpose timers
	TIM7          = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))        // Basic-timers
	LPTIM2        = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40009400)))      // Low power timer
	USART2        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))      // Universal synchronous asynchronous receiver transmitter
	USART3        = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))      // Universal synchronous asynchronous receiver transmitter
	UART4         = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))      // Universal synchronous asynchronous receiver transmitter
	UART5         = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))      // Universal synchronous asynchronous receiver transmitter
	SPI2          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))        // Serial peripheral interface/Inter-IC sound
	SPI3          = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))        // Serial peripheral interface/Inter-IC sound
)

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
	CCR     volatile.Register32 // 0x38
	MCR     volatile.Register32 // 0x3C
	SHSR1   volatile.Register32 // 0x40
	SHSR2   volatile.Register32 // 0x44
	SHHR    volatile.Register32 // 0x48
	SHRR    volatile.Register32 // 0x4C
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
	_      [24]byte
	CSELR  volatile.Register32 // 0xA8
}

// Cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// Liquid crystal display controller
type LCD_Type struct {
	_        [8]byte
	SSCR     volatile.Register32 // 0x8
	BPCR     volatile.Register32 // 0xC
	AWCR     volatile.Register32 // 0x10
	TWCR     volatile.Register32 // 0x14
	GCR      volatile.Register32 // 0x18
	_        [8]byte
	SRCR     volatile.Register32 // 0x24
	_        [4]byte
	BCCR     volatile.Register32 // 0x2C
	_        [4]byte
	IER      volatile.Register32 // 0x34
	ISR      volatile.Register32 // 0x38
	ICR      volatile.Register32 // 0x3C
	LIPCR    volatile.Register32 // 0x40
	CPSR     volatile.Register32 // 0x44
	CDSR     volatile.Register32 // 0x48
	_        [56]byte
	L1CR     volatile.Register32 // 0x84
	L1WHPCR  volatile.Register32 // 0x88
	L1WVPCR  volatile.Register32 // 0x8C
	L1CKCR   volatile.Register32 // 0x90
	L1PFCR   volatile.Register32 // 0x94
	L1CACR   volatile.Register32 // 0x98
	L1DCCR   volatile.Register32 // 0x9C
	L1BFCR   volatile.Register32 // 0xA0
	_        [8]byte
	L1CFBAR  volatile.Register32 // 0xAC
	L1CFBLR  volatile.Register32 // 0xB0
	L1CFBLNR volatile.Register32 // 0xB4
	_        [12]byte
	L1CLUTWR volatile.Register32 // 0xC4
	_        [60]byte
	L2CR     volatile.Register32 // 0x104
	L2WHPCR  volatile.Register32 // 0x108
	L2WVPCR  volatile.Register32 // 0x10C
	L2CKCR   volatile.Register32 // 0x110
	L2PFCR   volatile.Register32 // 0x114
	L2CACR   volatile.Register32 // 0x118
	L2DCCR   volatile.Register32 // 0x11C
	_        [4]byte
	L2BFCR   volatile.Register32 // 0x124
	_        [4]byte
	L2CFBAR  volatile.Register32 // 0x12C
	L2CFBLR  volatile.Register32 // 0x130
	L2CFBLNR volatile.Register32 // 0x134
	_        [12]byte
	L2CLUTWR volatile.Register32 // 0x144
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// System window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Comparator
type COMP_Type struct {
	COMP1_CSR volatile.Register32 // 0x0
	COMP2_CSR volatile.Register32 // 0x4
}

// Firewall
type Firewall_Type struct {
	CSSA   volatile.Register32 // 0x0
	CSL    volatile.Register32 // 0x4
	NVDSSA volatile.Register32 // 0x8
	NVDSL  volatile.Register32 // 0xC
	VDSSA  volatile.Register32 // 0x10
	VDSL   volatile.Register32 // 0x14
	_      [8]byte
	CR     volatile.Register32 // 0x20
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Flash
type Flash_Type struct {
	ACR      volatile.Register32 // 0x0
	PDKEYR   volatile.Register32 // 0x4
	KEYR     volatile.Register32 // 0x8
	OPTKEYR  volatile.Register32 // 0xC
	SR       volatile.Register32 // 0x10
	CR       volatile.Register32 // 0x14
	ECCR     volatile.Register32 // 0x18
	_        [4]byte
	OPTR     volatile.Register32 // 0x20
	PCROP1SR volatile.Register32 // 0x24
	PCROP1ER volatile.Register32 // 0x28
	WRP1AR   volatile.Register32 // 0x2C
	WRP1BR   volatile.Register32 // 0x30
	_        [16]byte
	PCROP2SR volatile.Register32 // 0x44
	PCROP2ER volatile.Register32 // 0x48
	WRP2AR   volatile.Register32 // 0x4C
	WRP2BR   volatile.Register32 // 0x50
}

// Debug support
type DBGMCU_Type struct {
	IDCODE    volatile.Register32 // 0x0
	CR        volatile.Register32 // 0x4
	APB1_FZR1 volatile.Register32 // 0x8
	APB1_FZR2 volatile.Register32 // 0xC
	APB2_FZR  volatile.Register32 // 0x10
}

// OctoSPI
type OctoSPI_Type struct {
	CR     volatile.Register32 // 0x0
	_      [4]byte
	DCR1   volatile.Register32 // 0x8
	DCR2   volatile.Register32 // 0xC
	DCR3   volatile.Register32 // 0x10
	_      [12]byte
	SR     volatile.Register32 // 0x20
	FCR    volatile.Register32 // 0x24
	_      [24]byte
	DLR    volatile.Register32 // 0x40
	_      [4]byte
	AR     volatile.Register32 // 0x48
	_      [4]byte
	DR     volatile.Register32 // 0x50
	_      [44]byte
	PSMKR  volatile.Register32 // 0x80
	_      [4]byte
	PSMAR  volatile.Register32 // 0x88
	_      [4]byte
	PIR    volatile.Register32 // 0x90
	_      [108]byte
	CCR    volatile.Register32 // 0x100
	_      [4]byte
	TCR    volatile.Register32 // 0x108
	_      [4]byte
	IR     volatile.Register32 // 0x110
	_      [12]byte
	ABR    volatile.Register32 // 0x120
	_      [12]byte
	LPTR   volatile.Register32 // 0x130
	_      [76]byte
	WCCR   volatile.Register32 // 0x180
	_      [4]byte
	WTCR   volatile.Register32 // 0x188
	_      [4]byte
	WIR    volatile.Register32 // 0x190
	_      [12]byte
	WABR   volatile.Register32 // 0x1A0
	_      [92]byte
	HLCR   volatile.Register32 // 0x200
	_      [492]byte
	HWCFGR volatile.Register32 // 0x3F0
	VER    volatile.Register32 // 0x3F4
	ID     volatile.Register32 // 0x3F8
	MID    volatile.Register32 // 0x3FC
}

// Reset and clock control
type RCC_Type struct {
	CR          volatile.Register32 // 0x0
	ICSCR       volatile.Register32 // 0x4
	CFGR        volatile.Register32 // 0x8
	PLLCFGR     volatile.Register32 // 0xC
	PLLSAI1CFGR volatile.Register32 // 0x10
	PLLSAI2CFGR volatile.Register32 // 0x14
	CIER        volatile.Register32 // 0x18
	CIFR        volatile.Register32 // 0x1C
	CICR        volatile.Register32 // 0x20
	_           [4]byte
	AHB1RSTR    volatile.Register32 // 0x28
	AHB2RSTR    volatile.Register32 // 0x2C
	AHB3RSTR    volatile.Register32 // 0x30
	_           [4]byte
	APB1RSTR1   volatile.Register32 // 0x38
	APB1RSTR2   volatile.Register32 // 0x3C
	APB2RSTR    volatile.Register32 // 0x40
	_           [4]byte
	AHB1ENR     volatile.Register32 // 0x48
	AHB2ENR     volatile.Register32 // 0x4C
	AHB3ENR     volatile.Register32 // 0x50
	_           [4]byte
	APB1ENR1    volatile.Register32 // 0x58
	APB1ENR2    volatile.Register32 // 0x5C
	APB2ENR     volatile.Register32 // 0x60
	_           [4]byte
	AHB1SMENR   volatile.Register32 // 0x68
	AHB2SMENR   volatile.Register32 // 0x6C
	AHB3SMENR   volatile.Register32 // 0x70
	_           [4]byte
	APB1SMENR1  volatile.Register32 // 0x78
	APB1SMENR2  volatile.Register32 // 0x7C
	APB2SMENR   volatile.Register32 // 0x80
	_           [4]byte
	CCIPR       volatile.Register32 // 0x88
	_           [4]byte
	BDCR        volatile.Register32 // 0x90
	CSR         volatile.Register32 // 0x94
	CRRCR       volatile.Register32 // 0x98
	CCIPR2      volatile.Register32 // 0x9C
}

// Power control
type PWR_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	CR3   volatile.Register32 // 0x8
	CR4   volatile.Register32 // 0xC
	SR1   volatile.Register32 // 0x10
	SR2   volatile.Register32 // 0x14
	SCR   volatile.Register32 // 0x18
	_     [4]byte
	PUCRA volatile.Register32 // 0x20
	PDCRA volatile.Register32 // 0x24
	PUCRB volatile.Register32 // 0x28
	PDCRB volatile.Register32 // 0x2C
	PUCRC volatile.Register32 // 0x30
	PDCRC volatile.Register32 // 0x34
	PUCRD volatile.Register32 // 0x38
	PDCRD volatile.Register32 // 0x3C
	PUCRE volatile.Register32 // 0x40
	PDCRE volatile.Register32 // 0x44
	PUCRF volatile.Register32 // 0x48
	PDCRF volatile.Register32 // 0x4C
	PUCRG volatile.Register32 // 0x50
	PDCRG volatile.Register32 // 0x54
	PUCRH volatile.Register32 // 0x58
	PDCRH volatile.Register32 // 0x5C
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	CFGR1   volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	SCSR    volatile.Register32 // 0x18
	CFGR2   volatile.Register32 // 0x1C
	SWPR    volatile.Register32 // 0x20
	SKR     volatile.Register32 // 0x24
}

// Digital filter for sigma delta modulators
type DFSDM_Type struct {
	CHCFG0R1       volatile.Register32 // 0x0
	CHCFG0R2       volatile.Register32 // 0x4
	AWSCD0R        volatile.Register32 // 0x8
	CHWDAT0R       volatile.Register32 // 0xC
	CHDATIN0R      volatile.Register32 // 0x10
	_              [12]byte
	CHCFG1R1       volatile.Register32 // 0x20
	CHCFG1R2       volatile.Register32 // 0x24
	AWSCD1R        volatile.Register32 // 0x28
	CHWDAT1R       volatile.Register32 // 0x2C
	CHDATIN1R      volatile.Register32 // 0x30
	_              [12]byte
	CHCFG2R1       volatile.Register32 // 0x40
	CHCFG2R2       volatile.Register32 // 0x44
	AWSCD2R        volatile.Register32 // 0x48
	CHWDAT2R       volatile.Register32 // 0x4C
	CHDATIN2R      volatile.Register32 // 0x50
	_              [12]byte
	CHCFG3R1       volatile.Register32 // 0x60
	CHCFG3R2       volatile.Register32 // 0x64
	AWSCD3R        volatile.Register32 // 0x68
	CHWDAT3R       volatile.Register32 // 0x6C
	CHDATIN3R      volatile.Register32 // 0x70
	_              [12]byte
	CHCFG4R1       volatile.Register32 // 0x80
	CHCFG4R2       volatile.Register32 // 0x84
	AWSCD4R        volatile.Register32 // 0x88
	CHWDAT4R       volatile.Register32 // 0x8C
	CHDATIN4R      volatile.Register32 // 0x90
	_              [12]byte
	CHCFG5R1       volatile.Register32 // 0xA0
	CHCFG5R2       volatile.Register32 // 0xA4
	AWSCD5R        volatile.Register32 // 0xA8
	CHWDAT5R       volatile.Register32 // 0xAC
	CHDATIN5R      volatile.Register32 // 0xB0
	_              [12]byte
	CHCFG6R1       volatile.Register32 // 0xC0
	CHCFG6R2       volatile.Register32 // 0xC4
	AWSCD6R        volatile.Register32 // 0xC8
	CHWDAT6R       volatile.Register32 // 0xCC
	CHDATIN6R      volatile.Register32 // 0xD0
	_              [12]byte
	CHCFG7R1       volatile.Register32 // 0xE0
	CHCFG7R2       volatile.Register32 // 0xE4
	AWSCD7R        volatile.Register32 // 0xE8
	CHWDAT7R       volatile.Register32 // 0xEC
	CHDATIN7R      volatile.Register32 // 0xF0
	_              [12]byte
	DFSDM0_CR1     volatile.Register32 // 0x100
	DFSDM0_CR2     volatile.Register32 // 0x104
	DFSDM0_ISR     volatile.Register32 // 0x108
	DFSDM0_ICR     volatile.Register32 // 0x10C
	DFSDM0_JCHGR   volatile.Register32 // 0x110
	DFSDM0_FCR     volatile.Register32 // 0x114
	DFSDM0_JDATAR  volatile.Register32 // 0x118
	DFSDM0_RDATAR  volatile.Register32 // 0x11C
	DFSDM0_AWHTR   volatile.Register32 // 0x120
	DFSDM0_AWLTR   volatile.Register32 // 0x124
	DFSDM0_AWSR    volatile.Register32 // 0x128
	DFSDM0_AWCFR   volatile.Register32 // 0x12C
	DFSDM0_EXMAX   volatile.Register32 // 0x130
	DFSDM0_EXMIN   volatile.Register32 // 0x134
	DFSDM0_CNVTIMR volatile.Register32 // 0x138
	_              [196]byte
	DFSDM1_CR1     volatile.Register32 // 0x200
	DFSDM1_CR2     volatile.Register32 // 0x204
	DFSDM1_ISR     volatile.Register32 // 0x208
	DFSDM1_ICR     volatile.Register32 // 0x20C
	DFSDM1_JCHGR   volatile.Register32 // 0x210
	DFSDM1_FCR     volatile.Register32 // 0x214
	DFSDM1_JDATAR  volatile.Register32 // 0x218
	DFSDM1_RDATAR  volatile.Register32 // 0x21C
	DFSDM1_AWHTR   volatile.Register32 // 0x220
	DFSDM1_AWLTR   volatile.Register32 // 0x224
	DFSDM1_AWSR    volatile.Register32 // 0x228
	DFSDM1_AWCFR   volatile.Register32 // 0x22C
	DFSDM1_EXMAX   volatile.Register32 // 0x230
	DFSDM1_EXMIN   volatile.Register32 // 0x234
	DFSDM1_CNVTIMR volatile.Register32 // 0x238
	_              [196]byte
	DFSDM2_CR1     volatile.Register32 // 0x300
	DFSDM2_CR2     volatile.Register32 // 0x304
	DFSDM2_ISR     volatile.Register32 // 0x308
	DFSDM2_ICR     volatile.Register32 // 0x30C
	DFSDM2_JCHGR   volatile.Register32 // 0x310
	DFSDM2_FCR     volatile.Register32 // 0x314
	DFSDM2_JDATAR  volatile.Register32 // 0x318
	DFSDM2_RDATAR  volatile.Register32 // 0x31C
	DFSDM2_AWHTR   volatile.Register32 // 0x320
	DFSDM2_AWLTR   volatile.Register32 // 0x324
	DFSDM2_AWSR    volatile.Register32 // 0x328
	DFSDM2_AWCFR   volatile.Register32 // 0x32C
	DFSDM2_EXMAX   volatile.Register32 // 0x330
	DFSDM2_EXMIN   volatile.Register32 // 0x334
	DFSDM2_CNVTIMR volatile.Register32 // 0x338
	_              [196]byte
	DFSDM3_CR1     volatile.Register32 // 0x400
	DFSDM3_CR2     volatile.Register32 // 0x404
	DFSDM3_ISR     volatile.Register32 // 0x408
	DFSDM3_ICR     volatile.Register32 // 0x40C
	DFSDM3_JCHGR   volatile.Register32 // 0x410
	DFSDM3_FCR     volatile.Register32 // 0x414
	DFSDM3_JDATAR  volatile.Register32 // 0x418
	DFSDM3_RDATAR  volatile.Register32 // 0x41C
	DFSDM3_AWHTR   volatile.Register32 // 0x420
	DFSDM3_AWLTR   volatile.Register32 // 0x424
	DFSDM3_AWSR    volatile.Register32 // 0x428
	DFSDM3_AWCFR   volatile.Register32 // 0x42C
	DFSDM3_EXMAX   volatile.Register32 // 0x430
	DFSDM3_EXMIN   volatile.Register32 // 0x434
	DFSDM3_CNVTIMR volatile.Register32 // 0x438
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// Advanced encryption standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// Analog-to-Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	CFGR2   volatile.Register32 // 0x10
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
	ASCR    volatile.Register32 // 0x2C
}

// Serial audio interface
type SAI_Type struct {
	_      [4]byte
	ACR1   volatile.Register32 // 0x4
	ACR2   volatile.Register32 // 0x8
	AFRCR  volatile.Register32 // 0xC
	ASLOTR volatile.Register32 // 0x10
	AIM    volatile.Register32 // 0x14
	ASR    volatile.Register32 // 0x18
	ACLRFR volatile.Register32 // 0x1C
	ADR    volatile.Register32 // 0x20
	BCR1   volatile.Register32 // 0x24
	BCR2   volatile.Register32 // 0x28
	BFRCR  volatile.Register32 // 0x2C
	BSLOTR volatile.Register32 // 0x30
	BIM    volatile.Register32 // 0x34
	BSR    volatile.Register32 // 0x38
	BCLRFR volatile.Register32 // 0x3C
	BDR    volatile.Register32 // 0x40
}

// General-purpose-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	OR           volatile.Register32 // 0x50
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1    volatile.Register32 // 0x0
	CR2    volatile.Register32 // 0x4
	SR     volatile.Register32 // 0x8
	DR     volatile.Register32 // 0xC
	CRCPR  volatile.Register32 // 0x10
	RXCRCR volatile.Register32 // 0x14
	TXCRCR volatile.Register32 // 0x18
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	_      [8]byte
	IMR2   volatile.Register32 // 0x20
	EMR2   volatile.Register32 // 0x24
	RTSR2  volatile.Register32 // 0x28
	FTSR2  volatile.Register32 // 0x2C
	SWIER2 volatile.Register32 // 0x30
	PR2    volatile.Register32 // 0x34
}

// Voltage reference buffer
type VREF_Type struct {
	CSR volatile.Register32 // 0x0
	CCR volatile.Register32 // 0x4
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TI0R  volatile.Register32 // 0x180
	TDT0R volatile.Register32 // 0x184
	TDL0R volatile.Register32 // 0x188
	TDH0R volatile.Register32 // 0x18C
	TI1R  volatile.Register32 // 0x190
	TDT1R volatile.Register32 // 0x194
	TDL1R volatile.Register32 // 0x198
	TDH1R volatile.Register32 // 0x19C
	TI2R  volatile.Register32 // 0x1A0
	TDT2R volatile.Register32 // 0x1A4
	TDL2R volatile.Register32 // 0x1A8
	TDH2R volatile.Register32 // 0x1AC
	RI0R  volatile.Register32 // 0x1B0
	RDT0R volatile.Register32 // 0x1B4
	RDL0R volatile.Register32 // 0x1B8
	RDH0R volatile.Register32 // 0x1BC
	RI1R  volatile.Register32 // 0x1C0
	RDT1R volatile.Register32 // 0x1C4
	RDL1R volatile.Register32 // 0x1C8
	RDH1R volatile.Register32 // 0x1CC
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	F0R1  volatile.Register32 // 0x240
	F0R2  volatile.Register32 // 0x244
	F1R1  volatile.Register32 // 0x248
	F1R2  volatile.Register32 // 0x24C
	F2R1  volatile.Register32 // 0x250
	F2R2  volatile.Register32 // 0x254
	F3R1  volatile.Register32 // 0x258
	F3R2  volatile.Register32 // 0x25C
	F4R1  volatile.Register32 // 0x260
	F4R2  volatile.Register32 // 0x264
	F5R1  volatile.Register32 // 0x268
	F5R2  volatile.Register32 // 0x26C
	F6R1  volatile.Register32 // 0x270
	F6R2  volatile.Register32 // 0x274
	F7R1  volatile.Register32 // 0x278
	F7R2  volatile.Register32 // 0x27C
	F8R1  volatile.Register32 // 0x280
	F8R2  volatile.Register32 // 0x284
	F9R1  volatile.Register32 // 0x288
	F9R2  volatile.Register32 // 0x28C
	F10R1 volatile.Register32 // 0x290
	F10R2 volatile.Register32 // 0x294
	F11R1 volatile.Register32 // 0x298
	F11R2 volatile.Register32 // 0x29C
	F12R1 volatile.Register32 // 0x2A0
	F12R2 volatile.Register32 // 0x2A4
	F13R1 volatile.Register32 // 0x2A8
	F13R2 volatile.Register32 // 0x2AC
	F14R1 volatile.Register32 // 0x2B0
	F14R2 volatile.Register32 // 0x2B4
	F15R1 volatile.Register32 // 0x2B8
	F15R2 volatile.Register32 // 0x2BC
	F16R1 volatile.Register32 // 0x2C0
	F16R2 volatile.Register32 // 0x2C4
	F17R1 volatile.Register32 // 0x2C8
	F17R2 volatile.Register32 // 0x2CC
	F18R1 volatile.Register32 // 0x2D0
	F18R2 volatile.Register32 // 0x2D4
	F19R1 volatile.Register32 // 0x2D8
	F19R2 volatile.Register32 // 0x2DC
	F20R1 volatile.Register32 // 0x2E0
	F20R2 volatile.Register32 // 0x2E4
	F21R1 volatile.Register32 // 0x2E8
	F21R2 volatile.Register32 // 0x2EC
	F22R1 volatile.Register32 // 0x2F0
	F22R2 volatile.Register32 // 0x2F4
	F23R1 volatile.Register32 // 0x2F8
	F23R2 volatile.Register32 // 0x2FC
	F24R1 volatile.Register32 // 0x300
	F24R2 volatile.Register32 // 0x304
	F25R1 volatile.Register32 // 0x308
	F25R2 volatile.Register32 // 0x30C
	F26R1 volatile.Register32 // 0x310
	F26R2 volatile.Register32 // 0x314
	F27R1 volatile.Register32 // 0x318
	F27R2 volatile.Register32 // 0x31C
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	FS_GOTGCTL          volatile.Register32 // 0x0
	FS_GOTGINT          volatile.Register32 // 0x4
	FS_GAHBCFG          volatile.Register32 // 0x8
	FS_GUSBCFG          volatile.Register32 // 0xC
	FS_GRSTCTL          volatile.Register32 // 0x10
	FS_GINTSTS          volatile.Register32 // 0x14
	FS_GINTMSK          volatile.Register32 // 0x18
	FS_GRXSTSR_Device   volatile.Register32 // 0x1C
	_                   [4]byte
	FS_GRXFSIZ          volatile.Register32 // 0x24
	FS_GNPTXFSIZ_Device volatile.Register32 // 0x28
	FS_GNPTXSTS         volatile.Register32 // 0x2C
	_                   [8]byte
	FS_GCCFG            volatile.Register32 // 0x38
	FS_CID              volatile.Register32 // 0x3C
	_                   [192]byte
	FS_HPTXFSIZ         volatile.Register32 // 0x100
	FS_DIEPTXF1         volatile.Register32 // 0x104
	FS_DIEPTXF2         volatile.Register32 // 0x108
	FS_DIEPTXF3         volatile.Register32 // 0x10C
}

// Single Wire Protocol Master Interface
type SWPMI_Type struct {
	CR  volatile.Register32 // 0x0
	BRR volatile.Register32 // 0x4
	_   [4]byte
	ISR volatile.Register32 // 0xC
	ICR volatile.Register32 // 0x10
	IER volatile.Register32 // 0x14
	RFL volatile.Register32 // 0x18
	TDR volatile.Register32 // 0x1C
	RDR volatile.Register32 // 0x20
}

// Operational amplifiers
type OPAMP_Type struct {
	OPAMP1_CSR   volatile.Register32 // 0x0
	OPAMP1_OTR   volatile.Register32 // 0x4
	OPAMP1_LPOTR volatile.Register32 // 0x8
	_            [4]byte
	OPAMP2_CSR   volatile.Register32 // 0x10
	OPAMP2_OTR   volatile.Register32 // 0x14
	OPAMP2_LPOTR volatile.Register32 // 0x18
}

// Flexible memory controller
type FMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// Digital camera interface
type DCMI_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	RIS    volatile.Register32 // 0x8
	IER    volatile.Register32 // 0xC
	MIS    volatile.Register32 // 0x10
	ICR    volatile.Register32 // 0x14
	ESCR   volatile.Register32 // 0x18
	ESUR   volatile.Register32 // 0x1C
	CWSTRT volatile.Register32 // 0x20
	CWSIZE volatile.Register32 // 0x24
	DR     volatile.Register32 // 0x28
}

// Hash processor
type HASH_Type struct {
	CR       volatile.Register32 // 0x0
	DIN      volatile.Register32 // 0x4
	STR      volatile.Register32 // 0x8
	HR0      volatile.Register32 // 0xC
	_        [16]byte
	IMR      volatile.Register32 // 0x20
	SR       volatile.Register32 // 0x24
	_        [208]byte
	CSR0     volatile.Register32 // 0xF8
	CSR1     volatile.Register32 // 0xFC
	CSR2     volatile.Register32 // 0x100
	CSR3     volatile.Register32 // 0x104
	CSR4     volatile.Register32 // 0x108
	CSR5     volatile.Register32 // 0x10C
	CSR6     volatile.Register32 // 0x110
	CSR7     volatile.Register32 // 0x114
	CSR8     volatile.Register32 // 0x118
	CSR9     volatile.Register32 // 0x11C
	CSR10    volatile.Register32 // 0x120
	CSR11    volatile.Register32 // 0x124
	CSR12    volatile.Register32 // 0x128
	CSR13    volatile.Register32 // 0x12C
	CSR14    volatile.Register32 // 0x130
	CSR15    volatile.Register32 // 0x134
	CSR16    volatile.Register32 // 0x138
	CSR17    volatile.Register32 // 0x13C
	CSR18    volatile.Register32 // 0x140
	CSR19    volatile.Register32 // 0x144
	CSR20    volatile.Register32 // 0x148
	CSR21    volatile.Register32 // 0x14C
	CSR22    volatile.Register32 // 0x150
	CSR23    volatile.Register32 // 0x154
	CSR24    volatile.Register32 // 0x158
	CSR25    volatile.Register32 // 0x15C
	CSR26    volatile.Register32 // 0x160
	CSR27    volatile.Register32 // 0x164
	CSR28    volatile.Register32 // 0x168
	CSR29    volatile.Register32 // 0x16C
	CSR30    volatile.Register32 // 0x170
	CSR31    volatile.Register32 // 0x174
	CSR32    volatile.Register32 // 0x178
	CSR33    volatile.Register32 // 0x17C
	CSR34    volatile.Register32 // 0x180
	CSR35    volatile.Register32 // 0x184
	CSR36    volatile.Register32 // 0x188
	CSR37    volatile.Register32 // 0x18C
	CSR38    volatile.Register32 // 0x190
	CSR39    volatile.Register32 // 0x194
	CSR40    volatile.Register32 // 0x198
	CSR41    volatile.Register32 // 0x19C
	CSR42    volatile.Register32 // 0x1A0
	CSR43    volatile.Register32 // 0x1A4
	CSR44    volatile.Register32 // 0x1A8
	CSR45    volatile.Register32 // 0x1AC
	CSR46    volatile.Register32 // 0x1B0
	CSR47    volatile.Register32 // 0x1B4
	CSR48    volatile.Register32 // 0x1B8
	CSR49    volatile.Register32 // 0x1BC
	CSR50    volatile.Register32 // 0x1C0
	CSR51    volatile.Register32 // 0x1C4
	CSR52    volatile.Register32 // 0x1C8
	CSR53    volatile.Register32 // 0x1CC
	_        [320]byte
	HASH_HR0 volatile.Register32 // 0x310
	HASH_HR1 volatile.Register32 // 0x314
	HASH_HR2 volatile.Register32 // 0x318
	HASH_HR3 volatile.Register32 // 0x31C
	HASH_HR4 volatile.Register32 // 0x320
	HASH_HR5 volatile.Register32 // 0x324
	HASH_HR6 volatile.Register32 // 0x328
	HASH_HR7 volatile.Register32 // 0x32C
}

// DMA2D controller
type DMA2D_Type struct {
	CR      volatile.Register32 // 0x0
	ISR     volatile.Register32 // 0x4
	IFCR    volatile.Register32 // 0x8
	FGMAR   volatile.Register32 // 0xC
	FGOR    volatile.Register32 // 0x10
	BGMAR   volatile.Register32 // 0x14
	BGOR    volatile.Register32 // 0x18
	FGPFCCR volatile.Register32 // 0x1C
	FGCOLR  volatile.Register32 // 0x20
	BGPFCCR volatile.Register32 // 0x24
	BGCOLR  volatile.Register32 // 0x28
	FGCMAR  volatile.Register32 // 0x2C
	BGCMAR  volatile.Register32 // 0x30
	OPFCCR  volatile.Register32 // 0x34
	OCOLR   volatile.Register32 // 0x38
	OMAR    volatile.Register32 // 0x3C
	OOR     volatile.Register32 // 0x40
	NLR     volatile.Register32 // 0x44
	LWR     volatile.Register32 // 0x48
	AMTCR   volatile.Register32 // 0x4C
	_       [944]byte
	FGCLUT  volatile.Register32 // 0x400
	_       [1020]byte
	BGCLUT  volatile.Register32 // 0x800
}

// DSI Host
type DSI_Type struct {
	DSI_VR      volatile.Register32 // 0x0
	DSI_CR      volatile.Register32 // 0x4
	DSI_CCR     volatile.Register32 // 0x8
	DSI_LVCIDR  volatile.Register32 // 0xC
	DSI_LCOLCR  volatile.Register32 // 0x10
	DSI_LPCR    volatile.Register32 // 0x14
	DSI_LPMCR   volatile.Register32 // 0x18
	DSI_PCR     volatile.Register32 // 0x1C
	DSI_GVCIDR  volatile.Register32 // 0x20
	DSI_MCR     volatile.Register32 // 0x24
	DSI_VMCR    volatile.Register32 // 0x28
	DSI_VPCR    volatile.Register32 // 0x2C
	DSI_VCCR    volatile.Register32 // 0x30
	DSI_VNPCR   volatile.Register32 // 0x34
	DSI_VHSACR  volatile.Register32 // 0x38
	DSI_VHBPCR  volatile.Register32 // 0x3C
	DSI_VLCR    volatile.Register32 // 0x40
	DSI_VVSACR  volatile.Register32 // 0x44
	DSI_VVBPCR  volatile.Register32 // 0x48
	DSI_VVFPCR  volatile.Register32 // 0x4C
	DSI_VVACR   volatile.Register32 // 0x50
	DSI_LCCR    volatile.Register32 // 0x54
	DSI_CMCR    volatile.Register32 // 0x58
	DSI_GHCR    volatile.Register32 // 0x5C
	DSI_GPDR    volatile.Register32 // 0x60
	DSI_GPSR    volatile.Register32 // 0x64
	DSI_TCCR0   volatile.Register32 // 0x68
	DSI_TCCR1   volatile.Register32 // 0x6C
	DSI_TCCR2   volatile.Register32 // 0x70
	DSI_TCCR3   volatile.Register32 // 0x74
	DSI_TCCR4   volatile.Register32 // 0x78
	DSI_TCCR5   volatile.Register32 // 0x7C
	DSI_CLCR    volatile.Register32 // 0x80
	DSI_CLTCR   volatile.Register32 // 0x84
	DSI_DLTRC   volatile.Register32 // 0x88
	DSI_PCTLR   volatile.Register32 // 0x8C
	DSI_PCONFR  volatile.Register32 // 0x90
	DSI_PUCR    volatile.Register32 // 0x94
	DSI_PTTCR   volatile.Register32 // 0x98
	DSI_PSR     volatile.Register32 // 0x9C
	DSI_ISR0    volatile.Register32 // 0xA0
	DSI_ISR1    volatile.Register32 // 0xA4
	DSI_IER0    volatile.Register32 // 0xA8
	DSI_IER1    volatile.Register32 // 0xAC
	DSI_FIR0    volatile.Register32 // 0xB0
	DSI_FIR1    volatile.Register32 // 0xB4
	DSI_VSCR    volatile.Register32 // 0xB8
	DSI_LCVCIDR volatile.Register32 // 0xBC
	DSI_LCCCR   volatile.Register32 // 0xC0
	DSI_LPMCCR  volatile.Register32 // 0xC4
	DSI_VMCCR   volatile.Register32 // 0xC8
	DSI_VPCCR   volatile.Register32 // 0xCC
	DSI_VCCCR   volatile.Register32 // 0xD0
	DSI_VNPCCR  volatile.Register32 // 0xD4
	DSI_VHSACCR volatile.Register32 // 0xD8
	DSI_VHBPCCR volatile.Register32 // 0xDC
	DSI_VLCCR   volatile.Register32 // 0xE0
	DSI_VVSACCR volatile.Register32 // 0xE4
	DSI_VVBPCCR volatile.Register32 // 0xE8
	DSI_VVFPCCR volatile.Register32 // 0xEC
	DSI_VVACCR  volatile.Register32 // 0xF0
	_           [780]byte
	DSI_WCFGR   volatile.Register32 // 0x400
	DSI_WCR     volatile.Register32 // 0x404
	DSI_WIER    volatile.Register32 // 0x408
	DSI_WISR    volatile.Register32 // 0x40C
	DSI_WIFCR   volatile.Register32 // 0x410
	_           [4]byte
	DSI_WPCR1   volatile.Register32 // 0x418
	DSI_WPCR2   volatile.Register32 // 0x41C
	DSI_WPCR3   volatile.Register32 // 0x420
	DSI_WPCR4   volatile.Register32 // 0x424
	DSI_WPCR5   volatile.Register32 // 0x428
	_           [4]byte
	DSI_WRPCR   volatile.Register32 // 0x430
}

// Graphic MMU
type GFXMMU_Type struct {
	CR       volatile.Register32 // 0x0
	SR       volatile.Register32 // 0x4
	FCR      volatile.Register32 // 0x8
	_        [4]byte
	DVR      volatile.Register32 // 0x10
	_        [12]byte
	B0CR     volatile.Register32 // 0x20
	B1CR     volatile.Register32 // 0x24
	B2CR     volatile.Register32 // 0x28
	B3CR     volatile.Register32 // 0x2C
	_        [4036]byte
	VERR     volatile.Register32 // 0xFF4
	IPIDR    volatile.Register32 // 0xFF8
	SIDR     volatile.Register32 // 0xFFC
	LUT0L    volatile.Register32 // 0x1000
	LUT0H    volatile.Register32 // 0x1004
	LUT1L    volatile.Register32 // 0x1008
	LUT1H    volatile.Register32 // 0x100C
	LUT2L    volatile.Register32 // 0x1010
	LUT2H    volatile.Register32 // 0x1014
	LUT3L    volatile.Register32 // 0x1018
	LUT3H    volatile.Register32 // 0x101C
	LUT4L    volatile.Register32 // 0x1020
	LUT4H    volatile.Register32 // 0x1024
	LUT5L    volatile.Register32 // 0x1028
	LUT5H    volatile.Register32 // 0x102C
	LUT6L    volatile.Register32 // 0x1030
	LUT6H    volatile.Register32 // 0x1034
	LUT7L    volatile.Register32 // 0x1038
	LUT7H    volatile.Register32 // 0x103C
	LUT8L    volatile.Register32 // 0x1040
	LUT8H    volatile.Register32 // 0x1044
	LUT9L    volatile.Register32 // 0x1048
	LUT9H    volatile.Register32 // 0x104C
	LUT10L   volatile.Register32 // 0x1050
	LUT10H   volatile.Register32 // 0x1054
	LUT11L   volatile.Register32 // 0x1058
	LUT11H   volatile.Register32 // 0x105C
	LUT12L   volatile.Register32 // 0x1060
	LUT12H   volatile.Register32 // 0x1064
	LUT13L   volatile.Register32 // 0x1068
	LUT13H   volatile.Register32 // 0x106C
	LUT14L   volatile.Register32 // 0x1070
	LUT14H   volatile.Register32 // 0x1074
	LUT15L   volatile.Register32 // 0x1078
	LUT15H   volatile.Register32 // 0x107C
	LUT16L   volatile.Register32 // 0x1080
	LUT16H   volatile.Register32 // 0x1084
	LUT17L   volatile.Register32 // 0x1088
	LUT17H   volatile.Register32 // 0x108C
	LUT18L   volatile.Register32 // 0x1090
	LUT18H   volatile.Register32 // 0x1094
	LUT19L   volatile.Register32 // 0x1098
	LUT19H   volatile.Register32 // 0x109C
	LUT20L   volatile.Register32 // 0x10A0
	LUT20H   volatile.Register32 // 0x10A4
	LUT21L   volatile.Register32 // 0x10A8
	LUT21H   volatile.Register32 // 0x10AC
	LUT22L   volatile.Register32 // 0x10B0
	LUT22H   volatile.Register32 // 0x10B4
	LUT23L   volatile.Register32 // 0x10B8
	LUT23H   volatile.Register32 // 0x10BC
	LUT24L   volatile.Register32 // 0x10C0
	LUT24H   volatile.Register32 // 0x10C4
	LUT25L   volatile.Register32 // 0x10C8
	LUT25H   volatile.Register32 // 0x10CC
	LUT26L   volatile.Register32 // 0x10D0
	LUT26H   volatile.Register32 // 0x10D4
	LUT27L   volatile.Register32 // 0x10D8
	LUT27H   volatile.Register32 // 0x10DC
	LUT28L   volatile.Register32 // 0x10E0
	LUT28H   volatile.Register32 // 0x10E4
	LUT29L   volatile.Register32 // 0x10E8
	LUT29H   volatile.Register32 // 0x10EC
	LUT30L   volatile.Register32 // 0x10F0
	LUT30H   volatile.Register32 // 0x10F4
	LUT31L   volatile.Register32 // 0x10F8
	LUT31H   volatile.Register32 // 0x10FC
	LUT32L   volatile.Register32 // 0x1100
	LUT32H   volatile.Register32 // 0x1104
	LUT33L   volatile.Register32 // 0x1108
	LUT33H   volatile.Register32 // 0x110C
	LUT34L   volatile.Register32 // 0x1110
	LUT34H   volatile.Register32 // 0x1114
	LUT35L   volatile.Register32 // 0x1118
	LUT35H   volatile.Register32 // 0x111C
	LUT36L   volatile.Register32 // 0x1120
	LUT36H   volatile.Register32 // 0x1124
	LUT37L   volatile.Register32 // 0x1128
	LUT37H   volatile.Register32 // 0x112C
	LUT38L   volatile.Register32 // 0x1130
	LUT38H   volatile.Register32 // 0x1134
	LUT39L   volatile.Register32 // 0x1138
	LUT39H   volatile.Register32 // 0x113C
	LUT40L   volatile.Register32 // 0x1140
	LUT40H   volatile.Register32 // 0x1144
	LUT41L   volatile.Register32 // 0x1148
	LUT41H   volatile.Register32 // 0x114C
	LUT42L   volatile.Register32 // 0x1150
	LUT42H   volatile.Register32 // 0x1154
	LUT43L   volatile.Register32 // 0x1158
	LUT43H   volatile.Register32 // 0x115C
	LUT44L   volatile.Register32 // 0x1160
	LUT44H   volatile.Register32 // 0x1164
	LUT45L   volatile.Register32 // 0x1168
	LUT45H   volatile.Register32 // 0x116C
	LUT46L   volatile.Register32 // 0x1170
	LUT46H   volatile.Register32 // 0x1174
	LUT47L   volatile.Register32 // 0x1178
	LUT47H   volatile.Register32 // 0x117C
	LUT48L   volatile.Register32 // 0x1180
	LUT48H   volatile.Register32 // 0x1184
	LUT49L   volatile.Register32 // 0x1188
	LUT49H   volatile.Register32 // 0x118C
	LUT50L   volatile.Register32 // 0x1190
	LUT50H   volatile.Register32 // 0x1194
	LUT51L   volatile.Register32 // 0x1198
	LUT51H   volatile.Register32 // 0x119C
	LUT52L   volatile.Register32 // 0x11A0
	LUT52H   volatile.Register32 // 0x11A4
	LUT53L   volatile.Register32 // 0x11A8
	LUT53H   volatile.Register32 // 0x11AC
	LUT54L   volatile.Register32 // 0x11B0
	LUT54H   volatile.Register32 // 0x11B4
	LUT55L   volatile.Register32 // 0x11B8
	LUT55H   volatile.Register32 // 0x11BC
	LUT56L   volatile.Register32 // 0x11C0
	LUT56H   volatile.Register32 // 0x11C4
	LUT57L   volatile.Register32 // 0x11C8
	LUT57H   volatile.Register32 // 0x11CC
	LUT58L   volatile.Register32 // 0x11D0
	LUT58H   volatile.Register32 // 0x11D4
	LUT59L   volatile.Register32 // 0x11D8
	LUT59H   volatile.Register32 // 0x11DC
	LUT60L   volatile.Register32 // 0x11E0
	LUT60H   volatile.Register32 // 0x11E4
	LUT61L   volatile.Register32 // 0x11E8
	LUT61H   volatile.Register32 // 0x11EC
	LUT62L   volatile.Register32 // 0x11F0
	LUT62H   volatile.Register32 // 0x11F4
	LUT63L   volatile.Register32 // 0x11F8
	LUT63H   volatile.Register32 // 0x11FC
	LUT64L   volatile.Register32 // 0x1200
	LUT64H   volatile.Register32 // 0x1204
	LUT65L   volatile.Register32 // 0x1208
	LUT65H   volatile.Register32 // 0x120C
	LUT66L   volatile.Register32 // 0x1210
	LUT66H   volatile.Register32 // 0x1214
	LUT67L   volatile.Register32 // 0x1218
	LUT67H   volatile.Register32 // 0x121C
	LUT68L   volatile.Register32 // 0x1220
	LUT68H   volatile.Register32 // 0x1224
	LUT69L   volatile.Register32 // 0x1228
	LUT69H   volatile.Register32 // 0x122C
	LUT70L   volatile.Register32 // 0x1230
	LUT70H   volatile.Register32 // 0x1234
	LUT71L   volatile.Register32 // 0x1238
	LUT71H   volatile.Register32 // 0x123C
	LUT72L   volatile.Register32 // 0x1240
	LUT72H   volatile.Register32 // 0x1244
	LUT73L   volatile.Register32 // 0x1248
	LUT73H   volatile.Register32 // 0x124C
	LUT74L   volatile.Register32 // 0x1250
	LUT74H   volatile.Register32 // 0x1254
	LUT75L   volatile.Register32 // 0x1258
	LUT75H   volatile.Register32 // 0x125C
	LUT76L   volatile.Register32 // 0x1260
	LUT76H   volatile.Register32 // 0x1264
	LUT77L   volatile.Register32 // 0x1268
	LUT77H   volatile.Register32 // 0x126C
	LUT78L   volatile.Register32 // 0x1270
	LUT78H   volatile.Register32 // 0x1274
	LUT79L   volatile.Register32 // 0x1278
	LUT79H   volatile.Register32 // 0x127C
	LUT80L   volatile.Register32 // 0x1280
	LUT80H   volatile.Register32 // 0x1284
	LUT81L   volatile.Register32 // 0x1288
	LUT81H   volatile.Register32 // 0x128C
	LUT82L   volatile.Register32 // 0x1290
	LUT82H   volatile.Register32 // 0x1294
	LUT83L   volatile.Register32 // 0x1298
	LUT83H   volatile.Register32 // 0x129C
	LUT84L   volatile.Register32 // 0x12A0
	LUT84H   volatile.Register32 // 0x12A4
	LUT85L   volatile.Register32 // 0x12A8
	LUT85H   volatile.Register32 // 0x12AC
	LUT86L   volatile.Register32 // 0x12B0
	LUT86H   volatile.Register32 // 0x12B4
	LUT87L   volatile.Register32 // 0x12B8
	LUT87H   volatile.Register32 // 0x12BC
	LUT88L   volatile.Register32 // 0x12C0
	LUT88H   volatile.Register32 // 0x12C4
	LUT89L   volatile.Register32 // 0x12C8
	LUT89H   volatile.Register32 // 0x12CC
	LUT90L   volatile.Register32 // 0x12D0
	LUT90H   volatile.Register32 // 0x12D4
	LUT91L   volatile.Register32 // 0x12D8
	LUT91H   volatile.Register32 // 0x12DC
	LUT92L   volatile.Register32 // 0x12E0
	LUT92H   volatile.Register32 // 0x12E4
	LUT93L   volatile.Register32 // 0x12E8
	LUT93H   volatile.Register32 // 0x12EC
	LUT94L   volatile.Register32 // 0x12F0
	LUT94H   volatile.Register32 // 0x12F4
	LUT95L   volatile.Register32 // 0x12F8
	LUT95H   volatile.Register32 // 0x12FC
	LUT96L   volatile.Register32 // 0x1300
	LUT96H   volatile.Register32 // 0x1304
	LUT97L   volatile.Register32 // 0x1308
	LUT97H   volatile.Register32 // 0x130C
	LUT98L   volatile.Register32 // 0x1310
	LUT98H   volatile.Register32 // 0x1314
	LUT99L   volatile.Register32 // 0x1318
	LUT99H   volatile.Register32 // 0x131C
	LUT100L  volatile.Register32 // 0x1320
	LUT100H  volatile.Register32 // 0x1324
	LUT101L  volatile.Register32 // 0x1328
	LUT101H  volatile.Register32 // 0x132C
	LUT102L  volatile.Register32 // 0x1330
	LUT102H  volatile.Register32 // 0x1334
	LUT103L  volatile.Register32 // 0x1338
	LUT103H  volatile.Register32 // 0x133C
	LUT104L  volatile.Register32 // 0x1340
	LUT104H  volatile.Register32 // 0x1344
	LUT105L  volatile.Register32 // 0x1348
	LUT105H  volatile.Register32 // 0x134C
	LUT106L  volatile.Register32 // 0x1350
	LUT106H  volatile.Register32 // 0x1354
	LUT107L  volatile.Register32 // 0x1358
	LUT107H  volatile.Register32 // 0x135C
	LUT108L  volatile.Register32 // 0x1360
	LUT108H  volatile.Register32 // 0x1364
	LUT109L  volatile.Register32 // 0x1368
	LUT109H  volatile.Register32 // 0x136C
	LUT110L  volatile.Register32 // 0x1370
	LUT110H  volatile.Register32 // 0x1374
	LUT111L  volatile.Register32 // 0x1378
	LUT111H  volatile.Register32 // 0x137C
	LUT112L  volatile.Register32 // 0x1380
	LUT112H  volatile.Register32 // 0x1384
	LUT113L  volatile.Register32 // 0x1388
	LUT113H  volatile.Register32 // 0x138C
	LUT114L  volatile.Register32 // 0x1390
	LUT114H  volatile.Register32 // 0x1394
	LUT115L  volatile.Register32 // 0x1398
	LUT115H  volatile.Register32 // 0x139C
	LUT116L  volatile.Register32 // 0x13A0
	LUT116H  volatile.Register32 // 0x13A4
	LUT117L  volatile.Register32 // 0x13A8
	LUT117H  volatile.Register32 // 0x13AC
	LUT118L  volatile.Register32 // 0x13B0
	LUT118H  volatile.Register32 // 0x13B4
	LUT119L  volatile.Register32 // 0x13B8
	LUT119H  volatile.Register32 // 0x13BC
	LUT120L  volatile.Register32 // 0x13C0
	LUT120H  volatile.Register32 // 0x13C4
	LUT121L  volatile.Register32 // 0x13C8
	LUT121H  volatile.Register32 // 0x13CC
	LUT122L  volatile.Register32 // 0x13D0
	LUT122H  volatile.Register32 // 0x13D4
	LUT123L  volatile.Register32 // 0x13D8
	LUT123H  volatile.Register32 // 0x13DC
	LUT124L  volatile.Register32 // 0x13E0
	LUT124H  volatile.Register32 // 0x13E4
	LUT125L  volatile.Register32 // 0x13E8
	LUT125H  volatile.Register32 // 0x13EC
	LUT126L  volatile.Register32 // 0x13F0
	LUT126H  volatile.Register32 // 0x13F4
	LUT127L  volatile.Register32 // 0x13F8
	LUT127H  volatile.Register32 // 0x13FC
	LUT128L  volatile.Register32 // 0x1400
	LUT128H  volatile.Register32 // 0x1404
	LUT129L  volatile.Register32 // 0x1408
	LUT129H  volatile.Register32 // 0x140C
	LUT130L  volatile.Register32 // 0x1410
	LUT130H  volatile.Register32 // 0x1414
	LUT131L  volatile.Register32 // 0x1418
	LUT131H  volatile.Register32 // 0x141C
	LUT132L  volatile.Register32 // 0x1420
	LUT132H  volatile.Register32 // 0x1424
	LUT133L  volatile.Register32 // 0x1428
	LUT133H  volatile.Register32 // 0x142C
	LUT134L  volatile.Register32 // 0x1430
	LUT134H  volatile.Register32 // 0x1434
	LUT135L  volatile.Register32 // 0x1438
	LUT135H  volatile.Register32 // 0x143C
	LUT136L  volatile.Register32 // 0x1440
	LUT136H  volatile.Register32 // 0x1444
	LUT137L  volatile.Register32 // 0x1448
	LUT137H  volatile.Register32 // 0x144C
	LUT138L  volatile.Register32 // 0x1450
	LUT138H  volatile.Register32 // 0x1454
	LUT139L  volatile.Register32 // 0x1458
	LUT139H  volatile.Register32 // 0x145C
	LUT140L  volatile.Register32 // 0x1460
	LUT140H  volatile.Register32 // 0x1464
	LUT141L  volatile.Register32 // 0x1468
	LUT141H  volatile.Register32 // 0x146C
	LUT142L  volatile.Register32 // 0x1470
	LUT142H  volatile.Register32 // 0x1474
	LUT143L  volatile.Register32 // 0x1478
	LUT143H  volatile.Register32 // 0x147C
	LUT144L  volatile.Register32 // 0x1480
	LUT144H  volatile.Register32 // 0x1484
	LUT145L  volatile.Register32 // 0x1488
	LUT145H  volatile.Register32 // 0x148C
	LUT146L  volatile.Register32 // 0x1490
	LUT146H  volatile.Register32 // 0x1494
	LUT147L  volatile.Register32 // 0x1498
	LUT147H  volatile.Register32 // 0x149C
	LUT148L  volatile.Register32 // 0x14A0
	LUT148H  volatile.Register32 // 0x14A4
	LUT149L  volatile.Register32 // 0x14A8
	LUT149H  volatile.Register32 // 0x14AC
	LUT150L  volatile.Register32 // 0x14B0
	LUT150H  volatile.Register32 // 0x14B4
	LUT151L  volatile.Register32 // 0x14B8
	LUT151H  volatile.Register32 // 0x14BC
	LUT152L  volatile.Register32 // 0x14C0
	LUT152H  volatile.Register32 // 0x14C4
	LUT153L  volatile.Register32 // 0x14C8
	LUT153H  volatile.Register32 // 0x14CC
	LUT154L  volatile.Register32 // 0x14D0
	LUT154H  volatile.Register32 // 0x14D4
	LUT155L  volatile.Register32 // 0x14D8
	LUT155H  volatile.Register32 // 0x14DC
	LUT156L  volatile.Register32 // 0x14E0
	LUT156H  volatile.Register32 // 0x14E4
	LUT157L  volatile.Register32 // 0x14E8
	LUT157H  volatile.Register32 // 0x14EC
	LUT158L  volatile.Register32 // 0x14F0
	LUT158H  volatile.Register32 // 0x14F4
	LUT159L  volatile.Register32 // 0x14F8
	LUT159H  volatile.Register32 // 0x14FC
	LUT160L  volatile.Register32 // 0x1500
	LUT160H  volatile.Register32 // 0x1504
	LUT161L  volatile.Register32 // 0x1508
	LUT161H  volatile.Register32 // 0x150C
	LUT162L  volatile.Register32 // 0x1510
	LUT162H  volatile.Register32 // 0x1514
	LUT163L  volatile.Register32 // 0x1518
	LUT163H  volatile.Register32 // 0x151C
	LUT164L  volatile.Register32 // 0x1520
	LUT164H  volatile.Register32 // 0x1524
	LUT165L  volatile.Register32 // 0x1528
	LUT165H  volatile.Register32 // 0x152C
	LUT166L  volatile.Register32 // 0x1530
	LUT166H  volatile.Register32 // 0x1534
	LUT167L  volatile.Register32 // 0x1538
	LUT167H  volatile.Register32 // 0x153C
	LUT168L  volatile.Register32 // 0x1540
	LUT168H  volatile.Register32 // 0x1544
	LUT169L  volatile.Register32 // 0x1548
	LUT169H  volatile.Register32 // 0x154C
	LUT170L  volatile.Register32 // 0x1550
	LUT170H  volatile.Register32 // 0x1554
	LUT171L  volatile.Register32 // 0x1558
	LUT171H  volatile.Register32 // 0x155C
	LUT172L  volatile.Register32 // 0x1560
	LUT172H  volatile.Register32 // 0x1564
	LUT173L  volatile.Register32 // 0x1568
	LUT173H  volatile.Register32 // 0x156C
	LUT174L  volatile.Register32 // 0x1570
	LUT174H  volatile.Register32 // 0x1574
	LUT175L  volatile.Register32 // 0x1578
	LUT175H  volatile.Register32 // 0x157C
	LUT176L  volatile.Register32 // 0x1580
	LUT176H  volatile.Register32 // 0x1584
	LUT177L  volatile.Register32 // 0x1588
	LUT177H  volatile.Register32 // 0x158C
	LUT178L  volatile.Register32 // 0x1590
	LUT178H  volatile.Register32 // 0x1594
	LUT179L  volatile.Register32 // 0x1598
	LUT179H  volatile.Register32 // 0x159C
	LUT180L  volatile.Register32 // 0x15A0
	LUT180H  volatile.Register32 // 0x15A4
	LUT181L  volatile.Register32 // 0x15A8
	LUT181H  volatile.Register32 // 0x15AC
	LUT182L  volatile.Register32 // 0x15B0
	LUT182H  volatile.Register32 // 0x15B4
	LUT183L  volatile.Register32 // 0x15B8
	LUT183H  volatile.Register32 // 0x15BC
	LUT184L  volatile.Register32 // 0x15C0
	LUT184H  volatile.Register32 // 0x15C4
	LUT185L  volatile.Register32 // 0x15C8
	LUT185H  volatile.Register32 // 0x15CC
	LUT186L  volatile.Register32 // 0x15D0
	LUT186H  volatile.Register32 // 0x15D4
	LUT187L  volatile.Register32 // 0x15D8
	LUT187H  volatile.Register32 // 0x15DC
	LUT188L  volatile.Register32 // 0x15E0
	LUT188H  volatile.Register32 // 0x15E4
	LUT189L  volatile.Register32 // 0x15E8
	LUT189H  volatile.Register32 // 0x15EC
	LUT190L  volatile.Register32 // 0x15F0
	LUT190H  volatile.Register32 // 0x15F4
	LUT191L  volatile.Register32 // 0x15F8
	LUT191H  volatile.Register32 // 0x15FC
	LUT192L  volatile.Register32 // 0x1600
	LUT192H  volatile.Register32 // 0x1604
	LUT193L  volatile.Register32 // 0x1608
	LUT193H  volatile.Register32 // 0x160C
	LUT194L  volatile.Register32 // 0x1610
	LUT194H  volatile.Register32 // 0x1614
	LUT195L  volatile.Register32 // 0x1618
	LUT195H  volatile.Register32 // 0x161C
	LUT196L  volatile.Register32 // 0x1620
	LUT196H  volatile.Register32 // 0x1624
	LUT197L  volatile.Register32 // 0x1628
	LUT197H  volatile.Register32 // 0x162C
	LUT198L  volatile.Register32 // 0x1630
	LUT198H  volatile.Register32 // 0x1634
	LUT199L  volatile.Register32 // 0x1638
	LUT199H  volatile.Register32 // 0x163C
	LUT200L  volatile.Register32 // 0x1640
	LUT200H  volatile.Register32 // 0x1644
	LUT201L  volatile.Register32 // 0x1648
	LUT201H  volatile.Register32 // 0x164C
	LUT202L  volatile.Register32 // 0x1650
	LUT202H  volatile.Register32 // 0x1654
	LUT203L  volatile.Register32 // 0x1658
	LUT203H  volatile.Register32 // 0x165C
	LUT204L  volatile.Register32 // 0x1660
	LUT204H  volatile.Register32 // 0x1664
	LUT205L  volatile.Register32 // 0x1668
	LUT205H  volatile.Register32 // 0x166C
	LUT206L  volatile.Register32 // 0x1670
	LUT206H  volatile.Register32 // 0x1674
	LUT207L  volatile.Register32 // 0x1678
	LUT207H  volatile.Register32 // 0x167C
	LUT208L  volatile.Register32 // 0x1680
	LUT208H  volatile.Register32 // 0x1684
	LUT209L  volatile.Register32 // 0x1688
	LUT209H  volatile.Register32 // 0x168C
	LUT210L  volatile.Register32 // 0x1690
	LUT210H  volatile.Register32 // 0x1694
	LUT211L  volatile.Register32 // 0x1698
	LUT211H  volatile.Register32 // 0x169C
	LUT212L  volatile.Register32 // 0x16A0
	LUT212H  volatile.Register32 // 0x16A4
	LUT213L  volatile.Register32 // 0x16A8
	LUT213H  volatile.Register32 // 0x16AC
	LUT214L  volatile.Register32 // 0x16B0
	LUT214H  volatile.Register32 // 0x16B4
	LUT215L  volatile.Register32 // 0x16B8
	LUT215H  volatile.Register32 // 0x16BC
	LUT216L  volatile.Register32 // 0x16C0
	LUT216H  volatile.Register32 // 0x16C4
	LUT217L  volatile.Register32 // 0x16C8
	LUT217H  volatile.Register32 // 0x16CC
	LUT218L  volatile.Register32 // 0x16D0
	LUT218H  volatile.Register32 // 0x16D4
	LUT219L  volatile.Register32 // 0x16D8
	LUT219H  volatile.Register32 // 0x16DC
	LUT220L  volatile.Register32 // 0x16E0
	LUT220H  volatile.Register32 // 0x16E4
	LUT221L  volatile.Register32 // 0x16E8
	LUT221H  volatile.Register32 // 0x16EC
	LUT222L  volatile.Register32 // 0x16F0
	LUT222H  volatile.Register32 // 0x16F4
	LUT223L  volatile.Register32 // 0x16F8
	LUT223H  volatile.Register32 // 0x16FC
	LUT224L  volatile.Register32 // 0x1700
	LUT224H  volatile.Register32 // 0x1704
	LUT225L  volatile.Register32 // 0x1708
	LUT225H  volatile.Register32 // 0x170C
	LUT226L  volatile.Register32 // 0x1710
	LUT226H  volatile.Register32 // 0x1714
	LUT227L  volatile.Register32 // 0x1718
	LUT227H  volatile.Register32 // 0x171C
	LUT228L  volatile.Register32 // 0x1720
	LUT228H  volatile.Register32 // 0x1724
	LUT229L  volatile.Register32 // 0x1728
	LUT229H  volatile.Register32 // 0x172C
	LUT230L  volatile.Register32 // 0x1730
	LUT230H  volatile.Register32 // 0x1734
	LUT231L  volatile.Register32 // 0x1738
	LUT231H  volatile.Register32 // 0x173C
	LUT232L  volatile.Register32 // 0x1740
	LUT232H  volatile.Register32 // 0x1744
	LUT233L  volatile.Register32 // 0x1748
	LUT233H  volatile.Register32 // 0x174C
	LUT234L  volatile.Register32 // 0x1750
	LUT234H  volatile.Register32 // 0x1754
	LUT235L  volatile.Register32 // 0x1758
	LUT235H  volatile.Register32 // 0x175C
	LUT236L  volatile.Register32 // 0x1760
	LUT236H  volatile.Register32 // 0x1764
	LUT237L  volatile.Register32 // 0x1768
	LUT237H  volatile.Register32 // 0x176C
	LUT238L  volatile.Register32 // 0x1770
	LUT238H  volatile.Register32 // 0x1774
	LUT239L  volatile.Register32 // 0x1778
	LUT239H  volatile.Register32 // 0x177C
	LUT240L  volatile.Register32 // 0x1780
	LUT240H  volatile.Register32 // 0x1784
	LUT241L  volatile.Register32 // 0x1788
	LUT241H  volatile.Register32 // 0x178C
	LUT242L  volatile.Register32 // 0x1790
	LUT242H  volatile.Register32 // 0x1794
	LUT243L  volatile.Register32 // 0x1798
	LUT243H  volatile.Register32 // 0x179C
	LUT244L  volatile.Register32 // 0x17A0
	LUT244H  volatile.Register32 // 0x17A4
	LUT245L  volatile.Register32 // 0x17A8
	LUT245H  volatile.Register32 // 0x17AC
	LUT246L  volatile.Register32 // 0x17B0
	LUT246H  volatile.Register32 // 0x17B4
	LUT247L  volatile.Register32 // 0x17B8
	LUT247H  volatile.Register32 // 0x17BC
	LUT248L  volatile.Register32 // 0x17C0
	LUT248H  volatile.Register32 // 0x17C4
	LUT249L  volatile.Register32 // 0x17C8
	LUT249H  volatile.Register32 // 0x17CC
	LUT250L  volatile.Register32 // 0x17D0
	LUT250H  volatile.Register32 // 0x17D4
	LUT251L  volatile.Register32 // 0x17D8
	LUT251H  volatile.Register32 // 0x17DC
	LUT252L  volatile.Register32 // 0x17E0
	LUT252H  volatile.Register32 // 0x17E4
	LUT253L  volatile.Register32 // 0x17E8
	LUT253H  volatile.Register32 // 0x17EC
	LUT254L  volatile.Register32 // 0x17F0
	LUT254H  volatile.Register32 // 0x17F4
	LUT255L  volatile.Register32 // 0x17F8
	LUT255H  volatile.Register32 // 0x17FC
	LUT256L  volatile.Register32 // 0x1800
	LUT256H  volatile.Register32 // 0x1804
	LUT257L  volatile.Register32 // 0x1808
	LUT257H  volatile.Register32 // 0x180C
	LUT258L  volatile.Register32 // 0x1810
	LUT258H  volatile.Register32 // 0x1814
	LUT259L  volatile.Register32 // 0x1818
	LUT259H  volatile.Register32 // 0x181C
	LUT260L  volatile.Register32 // 0x1820
	LUT260H  volatile.Register32 // 0x1824
	LUT261L  volatile.Register32 // 0x1828
	LUT261H  volatile.Register32 // 0x182C
	LUT262L  volatile.Register32 // 0x1830
	LUT262H  volatile.Register32 // 0x1834
	LUT263L  volatile.Register32 // 0x1838
	LUT263H  volatile.Register32 // 0x183C
	LUT264L  volatile.Register32 // 0x1840
	LUT264H  volatile.Register32 // 0x1844
	LUT265L  volatile.Register32 // 0x1848
	LUT265H  volatile.Register32 // 0x184C
	LUT266L  volatile.Register32 // 0x1850
	LUT266H  volatile.Register32 // 0x1854
	LUT267L  volatile.Register32 // 0x1858
	LUT267H  volatile.Register32 // 0x185C
	LUT268L  volatile.Register32 // 0x1860
	LUT268H  volatile.Register32 // 0x1864
	LUT269L  volatile.Register32 // 0x1868
	LUT269H  volatile.Register32 // 0x186C
	LUT270L  volatile.Register32 // 0x1870
	LUT270H  volatile.Register32 // 0x1874
	LUT271L  volatile.Register32 // 0x1878
	LUT271H  volatile.Register32 // 0x187C
	LUT272L  volatile.Register32 // 0x1880
	LUT272H  volatile.Register32 // 0x1884
	LUT273L  volatile.Register32 // 0x1888
	LUT273H  volatile.Register32 // 0x188C
	LUT274L  volatile.Register32 // 0x1890
	LUT274H  volatile.Register32 // 0x1894
	LUT275L  volatile.Register32 // 0x1898
	LUT275H  volatile.Register32 // 0x189C
	LUT276L  volatile.Register32 // 0x18A0
	LUT276H  volatile.Register32 // 0x18A4
	LUT277L  volatile.Register32 // 0x18A8
	LUT277H  volatile.Register32 // 0x18AC
	LUT278L  volatile.Register32 // 0x18B0
	LUT278H  volatile.Register32 // 0x18B4
	LUT279L  volatile.Register32 // 0x18B8
	LUT279H  volatile.Register32 // 0x18BC
	LUT280L  volatile.Register32 // 0x18C0
	LUT280H  volatile.Register32 // 0x18C4
	LUT281L  volatile.Register32 // 0x18C8
	LUT281H  volatile.Register32 // 0x18CC
	LUT282L  volatile.Register32 // 0x18D0
	LUT282H  volatile.Register32 // 0x18D4
	LUT283L  volatile.Register32 // 0x18D8
	LUT283H  volatile.Register32 // 0x18DC
	LUT284L  volatile.Register32 // 0x18E0
	LUT284H  volatile.Register32 // 0x18E4
	LUT285L  volatile.Register32 // 0x18E8
	LUT285H  volatile.Register32 // 0x18EC
	LUT286L  volatile.Register32 // 0x18F0
	LUT286H  volatile.Register32 // 0x18F4
	LUT287L  volatile.Register32 // 0x18F8
	LUT287H  volatile.Register32 // 0x18FC
	LUT288L  volatile.Register32 // 0x1900
	LUT288H  volatile.Register32 // 0x1904
	LUT289L  volatile.Register32 // 0x1908
	LUT289H  volatile.Register32 // 0x190C
	LUT290L  volatile.Register32 // 0x1910
	LUT290H  volatile.Register32 // 0x1914
	LUT291L  volatile.Register32 // 0x1918
	LUT291H  volatile.Register32 // 0x191C
	LUT292L  volatile.Register32 // 0x1920
	LUT292H  volatile.Register32 // 0x1924
	LUT293L  volatile.Register32 // 0x1928
	LUT293H  volatile.Register32 // 0x192C
	LUT294L  volatile.Register32 // 0x1930
	LUT294H  volatile.Register32 // 0x1934
	LUT295L  volatile.Register32 // 0x1938
	LUT295H  volatile.Register32 // 0x193C
	LUT296L  volatile.Register32 // 0x1940
	LUT296H  volatile.Register32 // 0x1944
	LUT297L  volatile.Register32 // 0x1948
	LUT297H  volatile.Register32 // 0x194C
	LUT298L  volatile.Register32 // 0x1950
	LUT298H  volatile.Register32 // 0x1954
	LUT299L  volatile.Register32 // 0x1958
	LUT299H  volatile.Register32 // 0x195C
	LUT300L  volatile.Register32 // 0x1960
	LUT300H  volatile.Register32 // 0x1964
	LUT301L  volatile.Register32 // 0x1968
	LUT301H  volatile.Register32 // 0x196C
	LUT302L  volatile.Register32 // 0x1970
	LUT302H  volatile.Register32 // 0x1974
	LUT303L  volatile.Register32 // 0x1978
	LUT303H  volatile.Register32 // 0x197C
	LUT304L  volatile.Register32 // 0x1980
	LUT304H  volatile.Register32 // 0x1984
	LUT305L  volatile.Register32 // 0x1988
	LUT305H  volatile.Register32 // 0x198C
	LUT306L  volatile.Register32 // 0x1990
	LUT306H  volatile.Register32 // 0x1994
	LUT307L  volatile.Register32 // 0x1998
	LUT307H  volatile.Register32 // 0x199C
	LUT308L  volatile.Register32 // 0x19A0
	LUT308H  volatile.Register32 // 0x19A4
	LUT309L  volatile.Register32 // 0x19A8
	LUT309H  volatile.Register32 // 0x19AC
	LUT310L  volatile.Register32 // 0x19B0
	LUT310H  volatile.Register32 // 0x19B4
	LUT311L  volatile.Register32 // 0x19B8
	LUT311H  volatile.Register32 // 0x19BC
	LUT312L  volatile.Register32 // 0x19C0
	LUT312H  volatile.Register32 // 0x19C4
	LUT313L  volatile.Register32 // 0x19C8
	LUT313H  volatile.Register32 // 0x19CC
	LUT314L  volatile.Register32 // 0x19D0
	LUT314H  volatile.Register32 // 0x19D4
	LUT315L  volatile.Register32 // 0x19D8
	LUT315H  volatile.Register32 // 0x19DC
	LUT316L  volatile.Register32 // 0x19E0
	LUT316H  volatile.Register32 // 0x19E4
	LUT317L  volatile.Register32 // 0x19E8
	LUT317H  volatile.Register32 // 0x19EC
	LUT318L  volatile.Register32 // 0x19F0
	LUT318H  volatile.Register32 // 0x19F4
	LUT319L  volatile.Register32 // 0x19F8
	LUT319H  volatile.Register32 // 0x19FC
	LUT320L  volatile.Register32 // 0x1A00
	LUT320H  volatile.Register32 // 0x1A04
	LUT321L  volatile.Register32 // 0x1A08
	LUT321H  volatile.Register32 // 0x1A0C
	LUT322L  volatile.Register32 // 0x1A10
	LUT322H  volatile.Register32 // 0x1A14
	LUT323L  volatile.Register32 // 0x1A18
	LUT323H  volatile.Register32 // 0x1A1C
	LUT324L  volatile.Register32 // 0x1A20
	LUT324H  volatile.Register32 // 0x1A24
	LUT325L  volatile.Register32 // 0x1A28
	LUT325H  volatile.Register32 // 0x1A2C
	LUT326L  volatile.Register32 // 0x1A30
	LUT326H  volatile.Register32 // 0x1A34
	LUT327L  volatile.Register32 // 0x1A38
	LUT327H  volatile.Register32 // 0x1A3C
	LUT328L  volatile.Register32 // 0x1A40
	LUT328H  volatile.Register32 // 0x1A44
	LUT329L  volatile.Register32 // 0x1A48
	LUT329H  volatile.Register32 // 0x1A4C
	LUT330L  volatile.Register32 // 0x1A50
	LUT330H  volatile.Register32 // 0x1A54
	LUT331L  volatile.Register32 // 0x1A58
	LUT331H  volatile.Register32 // 0x1A5C
	LUT332L  volatile.Register32 // 0x1A60
	LUT332H  volatile.Register32 // 0x1A64
	LUT333L  volatile.Register32 // 0x1A68
	LUT333H  volatile.Register32 // 0x1A6C
	LUT334L  volatile.Register32 // 0x1A70
	LUT334H  volatile.Register32 // 0x1A74
	LUT335L  volatile.Register32 // 0x1A78
	LUT335H  volatile.Register32 // 0x1A7C
	LUT336L  volatile.Register32 // 0x1A80
	LUT336H  volatile.Register32 // 0x1A84
	LUT337L  volatile.Register32 // 0x1A88
	LUT337H  volatile.Register32 // 0x1A8C
	LUT338L  volatile.Register32 // 0x1A90
	LUT338H  volatile.Register32 // 0x1A94
	LUT339L  volatile.Register32 // 0x1A98
	LUT339H  volatile.Register32 // 0x1A9C
	LUT340L  volatile.Register32 // 0x1AA0
	LUT340H  volatile.Register32 // 0x1AA4
	LUT341L  volatile.Register32 // 0x1AA8
	LUT341H  volatile.Register32 // 0x1AAC
	LUT342L  volatile.Register32 // 0x1AB0
	LUT342H  volatile.Register32 // 0x1AB4
	LUT343L  volatile.Register32 // 0x1AB8
	LUT343H  volatile.Register32 // 0x1ABC
	LUT344L  volatile.Register32 // 0x1AC0
	LUT344H  volatile.Register32 // 0x1AC4
	LUT345L  volatile.Register32 // 0x1AC8
	LUT345H  volatile.Register32 // 0x1ACC
	LUT346L  volatile.Register32 // 0x1AD0
	LUT346H  volatile.Register32 // 0x1AD4
	LUT347L  volatile.Register32 // 0x1AD8
	LUT347H  volatile.Register32 // 0x1ADC
	LUT348L  volatile.Register32 // 0x1AE0
	LUT348H  volatile.Register32 // 0x1AE4
	LUT349L  volatile.Register32 // 0x1AE8
	LUT349H  volatile.Register32 // 0x1AEC
	LUT350L  volatile.Register32 // 0x1AF0
	LUT350H  volatile.Register32 // 0x1AF4
	LUT351L  volatile.Register32 // 0x1AF8
	LUT351H  volatile.Register32 // 0x1AFC
	LUT352L  volatile.Register32 // 0x1B00
	LUT352H  volatile.Register32 // 0x1B04
	LUT353L  volatile.Register32 // 0x1B08
	LUT353H  volatile.Register32 // 0x1B0C
	LUT354L  volatile.Register32 // 0x1B10
	LUT354H  volatile.Register32 // 0x1B14
	LUT355L  volatile.Register32 // 0x1B18
	LUT355H  volatile.Register32 // 0x1B1C
	LUT356L  volatile.Register32 // 0x1B20
	LUT356H  volatile.Register32 // 0x1B24
	LUT357L  volatile.Register32 // 0x1B28
	LUT357H  volatile.Register32 // 0x1B2C
	LUT358L  volatile.Register32 // 0x1B30
	LUT358H  volatile.Register32 // 0x1B34
	LUT359L  volatile.Register32 // 0x1B38
	LUT359H  volatile.Register32 // 0x1B3C
	LUT360L  volatile.Register32 // 0x1B40
	LUT360H  volatile.Register32 // 0x1B44
	LUT361L  volatile.Register32 // 0x1B48
	LUT361H  volatile.Register32 // 0x1B4C
	LUT362L  volatile.Register32 // 0x1B50
	LUT362H  volatile.Register32 // 0x1B54
	LUT363L  volatile.Register32 // 0x1B58
	LUT363H  volatile.Register32 // 0x1B5C
	LUT364L  volatile.Register32 // 0x1B60
	LUT364H  volatile.Register32 // 0x1B64
	LUT365L  volatile.Register32 // 0x1B68
	LUT365H  volatile.Register32 // 0x1B6C
	LUT366L  volatile.Register32 // 0x1B70
	LUT366H  volatile.Register32 // 0x1B74
	LUT367L  volatile.Register32 // 0x1B78
	LUT367H  volatile.Register32 // 0x1B7C
	LUT368L  volatile.Register32 // 0x1B80
	LUT368H  volatile.Register32 // 0x1B84
	LUT369L  volatile.Register32 // 0x1B88
	LUT369H  volatile.Register32 // 0x1B8C
	LUT370L  volatile.Register32 // 0x1B90
	LUT370H  volatile.Register32 // 0x1B94
	LUT371L  volatile.Register32 // 0x1B98
	LUT371H  volatile.Register32 // 0x1B9C
	LUT372L  volatile.Register32 // 0x1BA0
	LUT372H  volatile.Register32 // 0x1BA4
	LUT373L  volatile.Register32 // 0x1BA8
	LUT373H  volatile.Register32 // 0x1BAC
	LUT374L  volatile.Register32 // 0x1BB0
	LUT374H  volatile.Register32 // 0x1BB4
	LUT375L  volatile.Register32 // 0x1BB8
	LUT375H  volatile.Register32 // 0x1BBC
	LUT376L  volatile.Register32 // 0x1BC0
	LUT376H  volatile.Register32 // 0x1BC4
	LUT377L  volatile.Register32 // 0x1BC8
	LUT377H  volatile.Register32 // 0x1BCC
	LUT378L  volatile.Register32 // 0x1BD0
	LUT378H  volatile.Register32 // 0x1BD4
	LUT379L  volatile.Register32 // 0x1BD8
	LUT379H  volatile.Register32 // 0x1BDC
	LUT380L  volatile.Register32 // 0x1BE0
	LUT380H  volatile.Register32 // 0x1BE4
	LUT381L  volatile.Register32 // 0x1BE8
	LUT381H  volatile.Register32 // 0x1BEC
	LUT382L  volatile.Register32 // 0x1BF0
	LUT382H  volatile.Register32 // 0x1BF4
	LUT383L  volatile.Register32 // 0x1BF8
	LUT383H  volatile.Register32 // 0x1BFC
	LUT384L  volatile.Register32 // 0x1C00
	LUT384H  volatile.Register32 // 0x1C04
	LUT385L  volatile.Register32 // 0x1C08
	LUT385H  volatile.Register32 // 0x1C0C
	LUT386L  volatile.Register32 // 0x1C10
	LUT386H  volatile.Register32 // 0x1C14
	LUT387L  volatile.Register32 // 0x1C18
	LUT387H  volatile.Register32 // 0x1C1C
	LUT388L  volatile.Register32 // 0x1C20
	LUT388H  volatile.Register32 // 0x1C24
	LUT389L  volatile.Register32 // 0x1C28
	LUT389H  volatile.Register32 // 0x1C2C
	LUT390L  volatile.Register32 // 0x1C30
	LUT390H  volatile.Register32 // 0x1C34
	LUT391L  volatile.Register32 // 0x1C38
	LUT391H  volatile.Register32 // 0x1C3C
	LUT392L  volatile.Register32 // 0x1C40
	LUT392H  volatile.Register32 // 0x1C44
	LUT393L  volatile.Register32 // 0x1C48
	LUT393H  volatile.Register32 // 0x1C4C
	LUT394L  volatile.Register32 // 0x1C50
	LUT394H  volatile.Register32 // 0x1C54
	LUT395L  volatile.Register32 // 0x1C58
	LUT395H  volatile.Register32 // 0x1C5C
	LUT396L  volatile.Register32 // 0x1C60
	LUT396H  volatile.Register32 // 0x1C64
	LUT397L  volatile.Register32 // 0x1C68
	LUT397H  volatile.Register32 // 0x1C6C
	LUT398L  volatile.Register32 // 0x1C70
	LUT398H  volatile.Register32 // 0x1C74
	LUT399L  volatile.Register32 // 0x1C78
	LUT399H  volatile.Register32 // 0x1C7C
	LUT400L  volatile.Register32 // 0x1C80
	LUT400H  volatile.Register32 // 0x1C84
	LUT401L  volatile.Register32 // 0x1C88
	LUT401H  volatile.Register32 // 0x1C8C
	LUT402L  volatile.Register32 // 0x1C90
	LUT402H  volatile.Register32 // 0x1C94
	LUT403L  volatile.Register32 // 0x1C98
	LUT403H  volatile.Register32 // 0x1C9C
	LUT404L  volatile.Register32 // 0x1CA0
	LUT404H  volatile.Register32 // 0x1CA4
	LUT405L  volatile.Register32 // 0x1CA8
	LUT405H  volatile.Register32 // 0x1CAC
	LUT406L  volatile.Register32 // 0x1CB0
	LUT406H  volatile.Register32 // 0x1CB4
	LUT407L  volatile.Register32 // 0x1CB8
	LUT407H  volatile.Register32 // 0x1CBC
	LUT408L  volatile.Register32 // 0x1CC0
	LUT408H  volatile.Register32 // 0x1CC4
	LUT409L  volatile.Register32 // 0x1CC8
	LUT409H  volatile.Register32 // 0x1CCC
	LUT410L  volatile.Register32 // 0x1CD0
	LUT410H  volatile.Register32 // 0x1CD4
	LUT411L  volatile.Register32 // 0x1CD8
	LUT411H  volatile.Register32 // 0x1CDC
	LUT412L  volatile.Register32 // 0x1CE0
	LUT412H  volatile.Register32 // 0x1CE4
	LUT413L  volatile.Register32 // 0x1CE8
	LUT413H  volatile.Register32 // 0x1CEC
	LUT414L  volatile.Register32 // 0x1CF0
	LUT414H  volatile.Register32 // 0x1CF4
	LUT415L  volatile.Register32 // 0x1CF8
	LUT415H  volatile.Register32 // 0x1CFC
	LUT416L  volatile.Register32 // 0x1D00
	LUT416H  volatile.Register32 // 0x1D04
	LUT417L  volatile.Register32 // 0x1D08
	LUT417H  volatile.Register32 // 0x1D0C
	LUT418L  volatile.Register32 // 0x1D10
	LUT418H  volatile.Register32 // 0x1D14
	LUT419L  volatile.Register32 // 0x1D18
	LUT419H  volatile.Register32 // 0x1D1C
	LUT420L  volatile.Register32 // 0x1D20
	LUT420H  volatile.Register32 // 0x1D24
	LUT421L  volatile.Register32 // 0x1D28
	LUT421H  volatile.Register32 // 0x1D2C
	LUT422L  volatile.Register32 // 0x1D30
	LUT422H  volatile.Register32 // 0x1D34
	LUT423L  volatile.Register32 // 0x1D38
	LUT423H  volatile.Register32 // 0x1D3C
	LUT424L  volatile.Register32 // 0x1D40
	LUT424H  volatile.Register32 // 0x1D44
	LUT425L  volatile.Register32 // 0x1D48
	LUT425H  volatile.Register32 // 0x1D4C
	LUT426L  volatile.Register32 // 0x1D50
	LUT426H  volatile.Register32 // 0x1D54
	LUT427L  volatile.Register32 // 0x1D58
	LUT427H  volatile.Register32 // 0x1D5C
	LUT428L  volatile.Register32 // 0x1D60
	LUT428H  volatile.Register32 // 0x1D64
	LUT429L  volatile.Register32 // 0x1D68
	LUT429H  volatile.Register32 // 0x1D6C
	LUT430L  volatile.Register32 // 0x1D70
	LUT430H  volatile.Register32 // 0x1D74
	LUT431L  volatile.Register32 // 0x1D78
	LUT431H  volatile.Register32 // 0x1D7C
	LUT432L  volatile.Register32 // 0x1D80
	LUT432H  volatile.Register32 // 0x1D84
	LUT433L  volatile.Register32 // 0x1D88
	LUT433H  volatile.Register32 // 0x1D8C
	LUT434L  volatile.Register32 // 0x1D90
	LUT434H  volatile.Register32 // 0x1D94
	LUT435L  volatile.Register32 // 0x1D98
	LUT435H  volatile.Register32 // 0x1D9C
	LUT436L  volatile.Register32 // 0x1DA0
	LUT436H  volatile.Register32 // 0x1DA4
	LUT437L  volatile.Register32 // 0x1DA8
	LUT437H  volatile.Register32 // 0x1DAC
	LUT438L  volatile.Register32 // 0x1DB0
	LUT438H  volatile.Register32 // 0x1DB4
	LUT439L  volatile.Register32 // 0x1DB8
	LUT439H  volatile.Register32 // 0x1DBC
	LUT440L  volatile.Register32 // 0x1DC0
	LUT440H  volatile.Register32 // 0x1DC4
	LUT441L  volatile.Register32 // 0x1DC8
	LUT441H  volatile.Register32 // 0x1DCC
	LUT442L  volatile.Register32 // 0x1DD0
	LUT442H  volatile.Register32 // 0x1DD4
	LUT443L  volatile.Register32 // 0x1DD8
	LUT443H  volatile.Register32 // 0x1DDC
	LUT444L  volatile.Register32 // 0x1DE0
	LUT444H  volatile.Register32 // 0x1DE4
	LUT445L  volatile.Register32 // 0x1DE8
	LUT445H  volatile.Register32 // 0x1DEC
	LUT446L  volatile.Register32 // 0x1DF0
	LUT446H  volatile.Register32 // 0x1DF4
	LUT447L  volatile.Register32 // 0x1DF8
	LUT447H  volatile.Register32 // 0x1DFC
	LUT448L  volatile.Register32 // 0x1E00
	LUT448H  volatile.Register32 // 0x1E04
	LUT449L  volatile.Register32 // 0x1E08
	LUT449H  volatile.Register32 // 0x1E0C
	LUT450L  volatile.Register32 // 0x1E10
	LUT450H  volatile.Register32 // 0x1E14
	LUT451L  volatile.Register32 // 0x1E18
	LUT451H  volatile.Register32 // 0x1E1C
	LUT452L  volatile.Register32 // 0x1E20
	LUT452H  volatile.Register32 // 0x1E24
	LUT453L  volatile.Register32 // 0x1E28
	LUT453H  volatile.Register32 // 0x1E2C
	LUT454L  volatile.Register32 // 0x1E30
	LUT454H  volatile.Register32 // 0x1E34
	LUT455L  volatile.Register32 // 0x1E38
	LUT455H  volatile.Register32 // 0x1E3C
	LUT456L  volatile.Register32 // 0x1E40
	LUT456H  volatile.Register32 // 0x1E44
	LUT457L  volatile.Register32 // 0x1E48
	LUT457H  volatile.Register32 // 0x1E4C
	LUT458L  volatile.Register32 // 0x1E50
	LUT458H  volatile.Register32 // 0x1E54
	LUT459L  volatile.Register32 // 0x1E58
	LUT459H  volatile.Register32 // 0x1E5C
	LUT460L  volatile.Register32 // 0x1E60
	LUT460H  volatile.Register32 // 0x1E64
	LUT461L  volatile.Register32 // 0x1E68
	LUT461H  volatile.Register32 // 0x1E6C
	LUT462L  volatile.Register32 // 0x1E70
	LUT462H  volatile.Register32 // 0x1E74
	LUT463L  volatile.Register32 // 0x1E78
	LUT463H  volatile.Register32 // 0x1E7C
	LUT464L  volatile.Register32 // 0x1E80
	LUT464H  volatile.Register32 // 0x1E84
	LUT465L  volatile.Register32 // 0x1E88
	LUT465H  volatile.Register32 // 0x1E8C
	LUT466L  volatile.Register32 // 0x1E90
	LUT466H  volatile.Register32 // 0x1E94
	LUT467L  volatile.Register32 // 0x1E98
	LUT467H  volatile.Register32 // 0x1E9C
	LUT468L  volatile.Register32 // 0x1EA0
	LUT468H  volatile.Register32 // 0x1EA4
	LUT469L  volatile.Register32 // 0x1EA8
	LUT469H  volatile.Register32 // 0x1EAC
	LUT470L  volatile.Register32 // 0x1EB0
	LUT470H  volatile.Register32 // 0x1EB4
	LUT471L  volatile.Register32 // 0x1EB8
	LUT471H  volatile.Register32 // 0x1EBC
	LUT472L  volatile.Register32 // 0x1EC0
	LUT472H  volatile.Register32 // 0x1EC4
	LUT473L  volatile.Register32 // 0x1EC8
	LUT473H  volatile.Register32 // 0x1ECC
	LUT474L  volatile.Register32 // 0x1ED0
	LUT474H  volatile.Register32 // 0x1ED4
	LUT475L  volatile.Register32 // 0x1ED8
	LUT475H  volatile.Register32 // 0x1EDC
	LUT476L  volatile.Register32 // 0x1EE0
	LUT476H  volatile.Register32 // 0x1EE4
	LUT477L  volatile.Register32 // 0x1EE8
	LUT477H  volatile.Register32 // 0x1EEC
	LUT478L  volatile.Register32 // 0x1EF0
	LUT478H  volatile.Register32 // 0x1EF4
	LUT479L  volatile.Register32 // 0x1EF8
	LUT479H  volatile.Register32 // 0x1EFC
	LUT480L  volatile.Register32 // 0x1F00
	LUT480H  volatile.Register32 // 0x1F04
	LUT481L  volatile.Register32 // 0x1F08
	LUT481H  volatile.Register32 // 0x1F0C
	LUT482L  volatile.Register32 // 0x1F10
	LUT482H  volatile.Register32 // 0x1F14
	LUT483L  volatile.Register32 // 0x1F18
	LUT483H  volatile.Register32 // 0x1F1C
	LUT484L  volatile.Register32 // 0x1F20
	LUT484H  volatile.Register32 // 0x1F24
	LUT485L  volatile.Register32 // 0x1F28
	LUT485H  volatile.Register32 // 0x1F2C
	LUT486L  volatile.Register32 // 0x1F30
	LUT486H  volatile.Register32 // 0x1F34
	LUT487L  volatile.Register32 // 0x1F38
	LUT487H  volatile.Register32 // 0x1F3C
	LUT488L  volatile.Register32 // 0x1F40
	LUT488H  volatile.Register32 // 0x1F44
	LUT489L  volatile.Register32 // 0x1F48
	LUT489H  volatile.Register32 // 0x1F4C
	LUT490L  volatile.Register32 // 0x1F50
	LUT490H  volatile.Register32 // 0x1F54
	LUT491L  volatile.Register32 // 0x1F58
	LUT491H  volatile.Register32 // 0x1F5C
	LUT492L  volatile.Register32 // 0x1F60
	LUT492H  volatile.Register32 // 0x1F64
	LUT493L  volatile.Register32 // 0x1F68
	LUT493H  volatile.Register32 // 0x1F6C
	LUT494L  volatile.Register32 // 0x1F70
	LUT494H  volatile.Register32 // 0x1F74
	LUT495L  volatile.Register32 // 0x1F78
	LUT495H  volatile.Register32 // 0x1F7C
	LUT496L  volatile.Register32 // 0x1F80
	LUT496H  volatile.Register32 // 0x1F84
	LUT497L  volatile.Register32 // 0x1F88
	LUT497H  volatile.Register32 // 0x1F8C
	LUT498L  volatile.Register32 // 0x1F90
	LUT498H  volatile.Register32 // 0x1F94
	LUT499L  volatile.Register32 // 0x1F98
	LUT499H  volatile.Register32 // 0x1F9C
	LUT500L  volatile.Register32 // 0x1FA0
	LUT500H  volatile.Register32 // 0x1FA4
	LUT501L  volatile.Register32 // 0x1FA8
	LUT501H  volatile.Register32 // 0x1FAC
	LUT502L  volatile.Register32 // 0x1FB0
	LUT502H  volatile.Register32 // 0x1FB4
	LUT503L  volatile.Register32 // 0x1FB8
	LUT503H  volatile.Register32 // 0x1FBC
	LUT504L  volatile.Register32 // 0x1FC0
	LUT504H  volatile.Register32 // 0x1FC4
	LUT505L  volatile.Register32 // 0x1FC8
	LUT505H  volatile.Register32 // 0x1FCC
	LUT506L  volatile.Register32 // 0x1FD0
	LUT506H  volatile.Register32 // 0x1FD4
	LUT507L  volatile.Register32 // 0x1FD8
	LUT507H  volatile.Register32 // 0x1FDC
	LUT508L  volatile.Register32 // 0x1FE0
	LUT508H  volatile.Register32 // 0x1FE4
	LUT509L  volatile.Register32 // 0x1FE8
	LUT509H  volatile.Register32 // 0x1FEC
	LUT510L  volatile.Register32 // 0x1FF0
	LUT510H  volatile.Register32 // 0x1FF4
	LUT511L  volatile.Register32 // 0x1FF8
	LUT511H  volatile.Register32 // 0x1FFC
	LUT512L  volatile.Register32 // 0x2000
	LUT512H  volatile.Register32 // 0x2004
	LUT513L  volatile.Register32 // 0x2008
	LUT513H  volatile.Register32 // 0x200C
	LUT514L  volatile.Register32 // 0x2010
	LUT514H  volatile.Register32 // 0x2014
	LUT515L  volatile.Register32 // 0x2018
	LUT515H  volatile.Register32 // 0x201C
	LUT516L  volatile.Register32 // 0x2020
	LUT516H  volatile.Register32 // 0x2024
	LUT517L  volatile.Register32 // 0x2028
	LUT517H  volatile.Register32 // 0x202C
	LUT518L  volatile.Register32 // 0x2030
	LUT518H  volatile.Register32 // 0x2034
	LUT519L  volatile.Register32 // 0x2038
	LUT519H  volatile.Register32 // 0x203C
	LUT520L  volatile.Register32 // 0x2040
	LUT520H  volatile.Register32 // 0x2044
	LUT521L  volatile.Register32 // 0x2048
	LUT521H  volatile.Register32 // 0x204C
	LUT522L  volatile.Register32 // 0x2050
	LUT522H  volatile.Register32 // 0x2054
	LUT523L  volatile.Register32 // 0x2058
	LUT523H  volatile.Register32 // 0x205C
	LUT524L  volatile.Register32 // 0x2060
	LUT524H  volatile.Register32 // 0x2064
	LUT525L  volatile.Register32 // 0x2068
	LUT525H  volatile.Register32 // 0x206C
	LUT526L  volatile.Register32 // 0x2070
	LUT526H  volatile.Register32 // 0x2074
	LUT527L  volatile.Register32 // 0x2078
	LUT527H  volatile.Register32 // 0x207C
	LUT528L  volatile.Register32 // 0x2080
	LUT528H  volatile.Register32 // 0x2084
	LUT529L  volatile.Register32 // 0x2088
	LUT529H  volatile.Register32 // 0x208C
	LUT530L  volatile.Register32 // 0x2090
	LUT530H  volatile.Register32 // 0x2094
	LUT531L  volatile.Register32 // 0x2098
	LUT531H  volatile.Register32 // 0x209C
	LUT532L  volatile.Register32 // 0x20A0
	LUT532H  volatile.Register32 // 0x20A4
	LUT533L  volatile.Register32 // 0x20A8
	LUT533H  volatile.Register32 // 0x20AC
	LUT534L  volatile.Register32 // 0x20B0
	LUT534H  volatile.Register32 // 0x20B4
	LUT535L  volatile.Register32 // 0x20B8
	LUT535H  volatile.Register32 // 0x20BC
	LUT536L  volatile.Register32 // 0x20C0
	LUT536H  volatile.Register32 // 0x20C4
	LUT537L  volatile.Register32 // 0x20C8
	LUT537H  volatile.Register32 // 0x20CC
	LUT538L  volatile.Register32 // 0x20D0
	LUT538H  volatile.Register32 // 0x20D4
	LUT539L  volatile.Register32 // 0x20D8
	LUT539H  volatile.Register32 // 0x20DC
	LUT540L  volatile.Register32 // 0x20E0
	LUT540H  volatile.Register32 // 0x20E4
	LUT541L  volatile.Register32 // 0x20E8
	LUT541H  volatile.Register32 // 0x20EC
	LUT542L  volatile.Register32 // 0x20F0
	LUT542H  volatile.Register32 // 0x20F4
	LUT543L  volatile.Register32 // 0x20F8
	LUT543H  volatile.Register32 // 0x20FC
	LUT544L  volatile.Register32 // 0x2100
	LUT544H  volatile.Register32 // 0x2104
	LUT545L  volatile.Register32 // 0x2108
	LUT545H  volatile.Register32 // 0x210C
	LUT546L  volatile.Register32 // 0x2110
	LUT546H  volatile.Register32 // 0x2114
	LUT547L  volatile.Register32 // 0x2118
	LUT547H  volatile.Register32 // 0x211C
	LUT548L  volatile.Register32 // 0x2120
	LUT548H  volatile.Register32 // 0x2124
	LUT549L  volatile.Register32 // 0x2128
	LUT549H  volatile.Register32 // 0x212C
	LUT550L  volatile.Register32 // 0x2130
	LUT550H  volatile.Register32 // 0x2134
	LUT551L  volatile.Register32 // 0x2138
	LUT551H  volatile.Register32 // 0x213C
	LUT552L  volatile.Register32 // 0x2140
	LUT552H  volatile.Register32 // 0x2144
	LUT553L  volatile.Register32 // 0x2148
	LUT553H  volatile.Register32 // 0x214C
	LUT554L  volatile.Register32 // 0x2150
	LUT554H  volatile.Register32 // 0x2154
	LUT555L  volatile.Register32 // 0x2158
	LUT555H  volatile.Register32 // 0x215C
	LUT556L  volatile.Register32 // 0x2160
	LUT556H  volatile.Register32 // 0x2164
	LUT557L  volatile.Register32 // 0x2168
	LUT557H  volatile.Register32 // 0x216C
	LUT558L  volatile.Register32 // 0x2170
	LUT558H  volatile.Register32 // 0x2174
	LUT559L  volatile.Register32 // 0x2178
	LUT559H  volatile.Register32 // 0x217C
	LUT560L  volatile.Register32 // 0x2180
	LUT560H  volatile.Register32 // 0x2184
	LUT561L  volatile.Register32 // 0x2188
	LUT561H  volatile.Register32 // 0x218C
	LUT562L  volatile.Register32 // 0x2190
	LUT562H  volatile.Register32 // 0x2194
	LUT563L  volatile.Register32 // 0x2198
	LUT563H  volatile.Register32 // 0x219C
	LUT564L  volatile.Register32 // 0x21A0
	LUT564H  volatile.Register32 // 0x21A4
	LUT565L  volatile.Register32 // 0x21A8
	LUT565H  volatile.Register32 // 0x21AC
	LUT566L  volatile.Register32 // 0x21B0
	LUT566H  volatile.Register32 // 0x21B4
	LUT567L  volatile.Register32 // 0x21B8
	LUT567H  volatile.Register32 // 0x21BC
	LUT568L  volatile.Register32 // 0x21C0
	LUT568H  volatile.Register32 // 0x21C4
	LUT569L  volatile.Register32 // 0x21C8
	LUT569H  volatile.Register32 // 0x21CC
	LUT570L  volatile.Register32 // 0x21D0
	LUT570H  volatile.Register32 // 0x21D4
	LUT571L  volatile.Register32 // 0x21D8
	LUT571H  volatile.Register32 // 0x21DC
	LUT572L  volatile.Register32 // 0x21E0
	LUT572H  volatile.Register32 // 0x21E4
	LUT573L  volatile.Register32 // 0x21E8
	LUT573H  volatile.Register32 // 0x21EC
	LUT574L  volatile.Register32 // 0x21F0
	LUT574H  volatile.Register32 // 0x21F4
	LUT575L  volatile.Register32 // 0x21F8
	LUT575H  volatile.Register32 // 0x21FC
	LUT576L  volatile.Register32 // 0x2200
	LUT576H  volatile.Register32 // 0x2204
	LUT577L  volatile.Register32 // 0x2208
	LUT577H  volatile.Register32 // 0x220C
	LUT578L  volatile.Register32 // 0x2210
	LUT578H  volatile.Register32 // 0x2214
	LUT579L  volatile.Register32 // 0x2218
	LUT579H  volatile.Register32 // 0x221C
	LUT580L  volatile.Register32 // 0x2220
	LUT580H  volatile.Register32 // 0x2224
	LUT581L  volatile.Register32 // 0x2228
	LUT581H  volatile.Register32 // 0x222C
	LUT582L  volatile.Register32 // 0x2230
	LUT582H  volatile.Register32 // 0x2234
	LUT583L  volatile.Register32 // 0x2238
	LUT583H  volatile.Register32 // 0x223C
	LUT584L  volatile.Register32 // 0x2240
	LUT584H  volatile.Register32 // 0x2244
	LUT585L  volatile.Register32 // 0x2248
	LUT585H  volatile.Register32 // 0x224C
	LUT586L  volatile.Register32 // 0x2250
	LUT586H  volatile.Register32 // 0x2254
	LUT587L  volatile.Register32 // 0x2258
	LUT587H  volatile.Register32 // 0x225C
	LUT588L  volatile.Register32 // 0x2260
	LUT588H  volatile.Register32 // 0x2264
	LUT589L  volatile.Register32 // 0x2268
	LUT589H  volatile.Register32 // 0x226C
	LUT590L  volatile.Register32 // 0x2270
	LUT590H  volatile.Register32 // 0x2274
	LUT591L  volatile.Register32 // 0x2278
	LUT591H  volatile.Register32 // 0x227C
	LUT592L  volatile.Register32 // 0x2280
	LUT592H  volatile.Register32 // 0x2284
	LUT593L  volatile.Register32 // 0x2288
	LUT593H  volatile.Register32 // 0x228C
	LUT594L  volatile.Register32 // 0x2290
	LUT594H  volatile.Register32 // 0x2294
	LUT595L  volatile.Register32 // 0x2298
	LUT595H  volatile.Register32 // 0x229C
	LUT596L  volatile.Register32 // 0x22A0
	LUT596H  volatile.Register32 // 0x22A4
	LUT597L  volatile.Register32 // 0x22A8
	LUT597H  volatile.Register32 // 0x22AC
	LUT598L  volatile.Register32 // 0x22B0
	LUT598H  volatile.Register32 // 0x22B4
	LUT599L  volatile.Register32 // 0x22B8
	LUT599H  volatile.Register32 // 0x22BC
	LUT600L  volatile.Register32 // 0x22C0
	LUT600H  volatile.Register32 // 0x22C4
	LUT601L  volatile.Register32 // 0x22C8
	LUT601H  volatile.Register32 // 0x22CC
	LUT602L  volatile.Register32 // 0x22D0
	LUT602H  volatile.Register32 // 0x22D4
	LUT603L  volatile.Register32 // 0x22D8
	LUT603H  volatile.Register32 // 0x22DC
	LUT604L  volatile.Register32 // 0x22E0
	LUT604H  volatile.Register32 // 0x22E4
	LUT605L  volatile.Register32 // 0x22E8
	LUT605H  volatile.Register32 // 0x22EC
	LUT606L  volatile.Register32 // 0x22F0
	LUT606H  volatile.Register32 // 0x22F4
	LUT607L  volatile.Register32 // 0x22F8
	LUT607H  volatile.Register32 // 0x22FC
	LUT608L  volatile.Register32 // 0x2300
	LUT608H  volatile.Register32 // 0x2304
	LUT609L  volatile.Register32 // 0x2308
	LUT609H  volatile.Register32 // 0x230C
	LUT610L  volatile.Register32 // 0x2310
	LUT610H  volatile.Register32 // 0x2314
	LUT611L  volatile.Register32 // 0x2318
	LUT611H  volatile.Register32 // 0x231C
	LUT612L  volatile.Register32 // 0x2320
	LUT612H  volatile.Register32 // 0x2324
	LUT613L  volatile.Register32 // 0x2328
	LUT613H  volatile.Register32 // 0x232C
	LUT614L  volatile.Register32 // 0x2330
	LUT614H  volatile.Register32 // 0x2334
	LUT615L  volatile.Register32 // 0x2338
	LUT615H  volatile.Register32 // 0x233C
	LUT616L  volatile.Register32 // 0x2340
	LUT616H  volatile.Register32 // 0x2344
	LUT617L  volatile.Register32 // 0x2348
	LUT617H  volatile.Register32 // 0x234C
	LUT618L  volatile.Register32 // 0x2350
	LUT618H  volatile.Register32 // 0x2354
	LUT619L  volatile.Register32 // 0x2358
	LUT619H  volatile.Register32 // 0x235C
	LUT620L  volatile.Register32 // 0x2360
	LUT620H  volatile.Register32 // 0x2364
	LUT621L  volatile.Register32 // 0x2368
	LUT621H  volatile.Register32 // 0x236C
	LUT622L  volatile.Register32 // 0x2370
	LUT622H  volatile.Register32 // 0x2374
	LUT623L  volatile.Register32 // 0x2378
	LUT623H  volatile.Register32 // 0x237C
	LUT624L  volatile.Register32 // 0x2380
	LUT624H  volatile.Register32 // 0x2384
	LUT625L  volatile.Register32 // 0x2388
	LUT625H  volatile.Register32 // 0x238C
	LUT626L  volatile.Register32 // 0x2390
	LUT626H  volatile.Register32 // 0x2394
	LUT627L  volatile.Register32 // 0x2398
	LUT627H  volatile.Register32 // 0x239C
	LUT628L  volatile.Register32 // 0x23A0
	LUT628H  volatile.Register32 // 0x23A4
	LUT629L  volatile.Register32 // 0x23A8
	LUT629H  volatile.Register32 // 0x23AC
	LUT630L  volatile.Register32 // 0x23B0
	LUT630H  volatile.Register32 // 0x23B4
	LUT631L  volatile.Register32 // 0x23B8
	LUT631H  volatile.Register32 // 0x23BC
	LUT632L  volatile.Register32 // 0x23C0
	LUT632H  volatile.Register32 // 0x23C4
	LUT633L  volatile.Register32 // 0x23C8
	LUT633H  volatile.Register32 // 0x23CC
	LUT634L  volatile.Register32 // 0x23D0
	LUT634H  volatile.Register32 // 0x23D4
	LUT635L  volatile.Register32 // 0x23D8
	LUT635H  volatile.Register32 // 0x23DC
	LUT636L  volatile.Register32 // 0x23E0
	LUT636H  volatile.Register32 // 0x23E4
	LUT637L  volatile.Register32 // 0x23E8
	LUT637H  volatile.Register32 // 0x23EC
	LUT638L  volatile.Register32 // 0x23F0
	LUT638H  volatile.Register32 // 0x23F4
	LUT639L  volatile.Register32 // 0x23F8
	LUT639H  volatile.Register32 // 0x23FC
	LUT640L  volatile.Register32 // 0x2400
	LUT640H  volatile.Register32 // 0x2404
	LUT641L  volatile.Register32 // 0x2408
	LUT641H  volatile.Register32 // 0x240C
	LUT642L  volatile.Register32 // 0x2410
	LUT642H  volatile.Register32 // 0x2414
	LUT643L  volatile.Register32 // 0x2418
	LUT643H  volatile.Register32 // 0x241C
	LUT644L  volatile.Register32 // 0x2420
	LUT644H  volatile.Register32 // 0x2424
	LUT645L  volatile.Register32 // 0x2428
	LUT645H  volatile.Register32 // 0x242C
	LUT646L  volatile.Register32 // 0x2430
	LUT646H  volatile.Register32 // 0x2434
	LUT647L  volatile.Register32 // 0x2438
	LUT647H  volatile.Register32 // 0x243C
	LUT648L  volatile.Register32 // 0x2440
	LUT648H  volatile.Register32 // 0x2444
	LUT649L  volatile.Register32 // 0x2448
	LUT649H  volatile.Register32 // 0x244C
	LUT650L  volatile.Register32 // 0x2450
	LUT650H  volatile.Register32 // 0x2454
	LUT651L  volatile.Register32 // 0x2458
	LUT651H  volatile.Register32 // 0x245C
	LUT652L  volatile.Register32 // 0x2460
	LUT652H  volatile.Register32 // 0x2464
	LUT653L  volatile.Register32 // 0x2468
	LUT653H  volatile.Register32 // 0x246C
	LUT654L  volatile.Register32 // 0x2470
	LUT654H  volatile.Register32 // 0x2474
	LUT655L  volatile.Register32 // 0x2478
	LUT655H  volatile.Register32 // 0x247C
	LUT656L  volatile.Register32 // 0x2480
	LUT656H  volatile.Register32 // 0x2484
	LUT657L  volatile.Register32 // 0x2488
	LUT657H  volatile.Register32 // 0x248C
	LUT658L  volatile.Register32 // 0x2490
	LUT658H  volatile.Register32 // 0x2494
	LUT659L  volatile.Register32 // 0x2498
	LUT659H  volatile.Register32 // 0x249C
	LUT660L  volatile.Register32 // 0x24A0
	LUT660H  volatile.Register32 // 0x24A4
	LUT661L  volatile.Register32 // 0x24A8
	LUT661H  volatile.Register32 // 0x24AC
	LUT662L  volatile.Register32 // 0x24B0
	LUT662H  volatile.Register32 // 0x24B4
	LUT663L  volatile.Register32 // 0x24B8
	LUT663H  volatile.Register32 // 0x24BC
	LUT664L  volatile.Register32 // 0x24C0
	LUT664H  volatile.Register32 // 0x24C4
	LUT665L  volatile.Register32 // 0x24C8
	LUT665H  volatile.Register32 // 0x24CC
	LUT666L  volatile.Register32 // 0x24D0
	LUT666H  volatile.Register32 // 0x24D4
	LUT667L  volatile.Register32 // 0x24D8
	LUT667H  volatile.Register32 // 0x24DC
	LUT668L  volatile.Register32 // 0x24E0
	LUT668H  volatile.Register32 // 0x24E4
	LUT669L  volatile.Register32 // 0x24E8
	LUT669H  volatile.Register32 // 0x24EC
	LUT670L  volatile.Register32 // 0x24F0
	LUT670H  volatile.Register32 // 0x24F4
	LUT671L  volatile.Register32 // 0x24F8
	LUT671H  volatile.Register32 // 0x24FC
	LUT672L  volatile.Register32 // 0x2500
	LUT672H  volatile.Register32 // 0x2504
	LUT673L  volatile.Register32 // 0x2508
	LUT673H  volatile.Register32 // 0x250C
	LUT674L  volatile.Register32 // 0x2510
	LUT674H  volatile.Register32 // 0x2514
	LUT675L  volatile.Register32 // 0x2518
	LUT675H  volatile.Register32 // 0x251C
	LUT676L  volatile.Register32 // 0x2520
	LUT676H  volatile.Register32 // 0x2524
	LUT677L  volatile.Register32 // 0x2528
	LUT677H  volatile.Register32 // 0x252C
	LUT678L  volatile.Register32 // 0x2530
	LUT678H  volatile.Register32 // 0x2534
	LUT679L  volatile.Register32 // 0x2538
	LUT679H  volatile.Register32 // 0x253C
	LUT680L  volatile.Register32 // 0x2540
	LUT680H  volatile.Register32 // 0x2544
	LUT681L  volatile.Register32 // 0x2548
	LUT681H  volatile.Register32 // 0x254C
	LUT682L  volatile.Register32 // 0x2550
	LUT682H  volatile.Register32 // 0x2554
	LUT683L  volatile.Register32 // 0x2558
	LUT683H  volatile.Register32 // 0x255C
	LUT684L  volatile.Register32 // 0x2560
	LUT684H  volatile.Register32 // 0x2564
	LUT685L  volatile.Register32 // 0x2568
	LUT685H  volatile.Register32 // 0x256C
	LUT686L  volatile.Register32 // 0x2570
	LUT686H  volatile.Register32 // 0x2574
	LUT687L  volatile.Register32 // 0x2578
	LUT687H  volatile.Register32 // 0x257C
	LUT688L  volatile.Register32 // 0x2580
	LUT688H  volatile.Register32 // 0x2584
	LUT689L  volatile.Register32 // 0x2588
	LUT689H  volatile.Register32 // 0x258C
	LUT690L  volatile.Register32 // 0x2590
	LUT690H  volatile.Register32 // 0x2594
	LUT691L  volatile.Register32 // 0x2598
	LUT691H  volatile.Register32 // 0x259C
	LUT692L  volatile.Register32 // 0x25A0
	LUT692H  volatile.Register32 // 0x25A4
	LUT693L  volatile.Register32 // 0x25A8
	LUT693H  volatile.Register32 // 0x25AC
	LUT694L  volatile.Register32 // 0x25B0
	LUT694H  volatile.Register32 // 0x25B4
	LUT695L  volatile.Register32 // 0x25B8
	LUT695H  volatile.Register32 // 0x25BC
	LUT696L  volatile.Register32 // 0x25C0
	LUT696H  volatile.Register32 // 0x25C4
	LUT697L  volatile.Register32 // 0x25C8
	LUT697H  volatile.Register32 // 0x25CC
	LUT698L  volatile.Register32 // 0x25D0
	LUT698H  volatile.Register32 // 0x25D4
	LUT699L  volatile.Register32 // 0x25D8
	LUT699H  volatile.Register32 // 0x25DC
	LUT700L  volatile.Register32 // 0x25E0
	LUT700H  volatile.Register32 // 0x25E4
	LUT701L  volatile.Register32 // 0x25E8
	LUT701H  volatile.Register32 // 0x25EC
	LUT702L  volatile.Register32 // 0x25F0
	LUT702H  volatile.Register32 // 0x25F4
	LUT703L  volatile.Register32 // 0x25F8
	LUT703H  volatile.Register32 // 0x25FC
	LUT704L  volatile.Register32 // 0x2600
	LUT704H  volatile.Register32 // 0x2604
	LUT705L  volatile.Register32 // 0x2608
	LUT705H  volatile.Register32 // 0x260C
	LUT706L  volatile.Register32 // 0x2610
	LUT706H  volatile.Register32 // 0x2614
	LUT707L  volatile.Register32 // 0x2618
	LUT707H  volatile.Register32 // 0x261C
	LUT708L  volatile.Register32 // 0x2620
	LUT708H  volatile.Register32 // 0x2624
	LUT709L  volatile.Register32 // 0x2628
	LUT709H  volatile.Register32 // 0x262C
	LUT710L  volatile.Register32 // 0x2630
	LUT710H  volatile.Register32 // 0x2634
	LUT711L  volatile.Register32 // 0x2638
	LUT711H  volatile.Register32 // 0x263C
	LUT712L  volatile.Register32 // 0x2640
	LUT712H  volatile.Register32 // 0x2644
	LUT713L  volatile.Register32 // 0x2648
	LUT713H  volatile.Register32 // 0x264C
	LUT714L  volatile.Register32 // 0x2650
	LUT714H  volatile.Register32 // 0x2654
	LUT715L  volatile.Register32 // 0x2658
	LUT715H  volatile.Register32 // 0x265C
	LUT716L  volatile.Register32 // 0x2660
	LUT716H  volatile.Register32 // 0x2664
	LUT717L  volatile.Register32 // 0x2668
	LUT717H  volatile.Register32 // 0x266C
	LUT718L  volatile.Register32 // 0x2670
	LUT718H  volatile.Register32 // 0x2674
	LUT719L  volatile.Register32 // 0x2678
	LUT719H  volatile.Register32 // 0x267C
	LUT720L  volatile.Register32 // 0x2680
	LUT720H  volatile.Register32 // 0x2684
	LUT721L  volatile.Register32 // 0x2688
	LUT721H  volatile.Register32 // 0x268C
	LUT722L  volatile.Register32 // 0x2690
	LUT722H  volatile.Register32 // 0x2694
	LUT723L  volatile.Register32 // 0x2698
	LUT723H  volatile.Register32 // 0x269C
	LUT724L  volatile.Register32 // 0x26A0
	LUT724H  volatile.Register32 // 0x26A4
	LUT725L  volatile.Register32 // 0x26A8
	LUT725H  volatile.Register32 // 0x26AC
	LUT726L  volatile.Register32 // 0x26B0
	LUT726H  volatile.Register32 // 0x26B4
	LUT727L  volatile.Register32 // 0x26B8
	LUT727H  volatile.Register32 // 0x26BC
	LUT728L  volatile.Register32 // 0x26C0
	LUT728H  volatile.Register32 // 0x26C4
	LUT729L  volatile.Register32 // 0x26C8
	LUT729H  volatile.Register32 // 0x26CC
	LUT730L  volatile.Register32 // 0x26D0
	LUT730H  volatile.Register32 // 0x26D4
	LUT731L  volatile.Register32 // 0x26D8
	LUT731H  volatile.Register32 // 0x26DC
	LUT732L  volatile.Register32 // 0x26E0
	LUT732H  volatile.Register32 // 0x26E4
	LUT733L  volatile.Register32 // 0x26E8
	LUT733H  volatile.Register32 // 0x26EC
	LUT734L  volatile.Register32 // 0x26F0
	LUT734H  volatile.Register32 // 0x26F4
	LUT735L  volatile.Register32 // 0x26F8
	LUT735H  volatile.Register32 // 0x26FC
	LUT736L  volatile.Register32 // 0x2700
	LUT736H  volatile.Register32 // 0x2704
	LUT737L  volatile.Register32 // 0x2708
	LUT737H  volatile.Register32 // 0x270C
	LUT738L  volatile.Register32 // 0x2710
	LUT738H  volatile.Register32 // 0x2714
	LUT739L  volatile.Register32 // 0x2718
	LUT739H  volatile.Register32 // 0x271C
	LUT740L  volatile.Register32 // 0x2720
	LUT740H  volatile.Register32 // 0x2724
	LUT741L  volatile.Register32 // 0x2728
	LUT741H  volatile.Register32 // 0x272C
	LUT742L  volatile.Register32 // 0x2730
	LUT742H  volatile.Register32 // 0x2734
	LUT743L  volatile.Register32 // 0x2738
	LUT743H  volatile.Register32 // 0x273C
	LUT744L  volatile.Register32 // 0x2740
	LUT744H  volatile.Register32 // 0x2744
	LUT745L  volatile.Register32 // 0x2748
	LUT745H  volatile.Register32 // 0x274C
	LUT746L  volatile.Register32 // 0x2750
	LUT746H  volatile.Register32 // 0x2754
	LUT747L  volatile.Register32 // 0x2758
	LUT747H  volatile.Register32 // 0x275C
	LUT748L  volatile.Register32 // 0x2760
	LUT748H  volatile.Register32 // 0x2764
	LUT749L  volatile.Register32 // 0x2768
	LUT749H  volatile.Register32 // 0x276C
	LUT750L  volatile.Register32 // 0x2770
	LUT750H  volatile.Register32 // 0x2774
	LUT751L  volatile.Register32 // 0x2778
	LUT751H  volatile.Register32 // 0x277C
	LUT752L  volatile.Register32 // 0x2780
	LUT752H  volatile.Register32 // 0x2784
	LUT753L  volatile.Register32 // 0x2788
	LUT753H  volatile.Register32 // 0x278C
	LUT754L  volatile.Register32 // 0x2790
	LUT754H  volatile.Register32 // 0x2794
	LUT755L  volatile.Register32 // 0x2798
	LUT755H  volatile.Register32 // 0x279C
	LUT756L  volatile.Register32 // 0x27A0
	LUT756H  volatile.Register32 // 0x27A4
	LUT757L  volatile.Register32 // 0x27A8
	LUT757H  volatile.Register32 // 0x27AC
	LUT758L  volatile.Register32 // 0x27B0
	LUT758H  volatile.Register32 // 0x27B4
	LUT759L  volatile.Register32 // 0x27B8
	LUT759H  volatile.Register32 // 0x27BC
	LUT760L  volatile.Register32 // 0x27C0
	LUT760H  volatile.Register32 // 0x27C4
	LUT761L  volatile.Register32 // 0x27C8
	LUT761H  volatile.Register32 // 0x27CC
	LUT762L  volatile.Register32 // 0x27D0
	LUT762H  volatile.Register32 // 0x27D4
	LUT763L  volatile.Register32 // 0x27D8
	LUT763H  volatile.Register32 // 0x27DC
	LUT764L  volatile.Register32 // 0x27E0
	LUT764H  volatile.Register32 // 0x27E4
	LUT765L  volatile.Register32 // 0x27E8
	LUT765H  volatile.Register32 // 0x27EC
	LUT766L  volatile.Register32 // 0x27F0
	LUT766H  volatile.Register32 // 0x27F4
	LUT767L  volatile.Register32 // 0x27F8
	LUT767H  volatile.Register32 // 0x27FC
	LUT768L  volatile.Register32 // 0x2800
	LUT768H  volatile.Register32 // 0x2804
	LUT769L  volatile.Register32 // 0x2808
	LUT769H  volatile.Register32 // 0x280C
	LUT770L  volatile.Register32 // 0x2810
	LUT770H  volatile.Register32 // 0x2814
	LUT771L  volatile.Register32 // 0x2818
	LUT771H  volatile.Register32 // 0x281C
	LUT772L  volatile.Register32 // 0x2820
	LUT772H  volatile.Register32 // 0x2824
	LUT773L  volatile.Register32 // 0x2828
	LUT773H  volatile.Register32 // 0x282C
	LUT774L  volatile.Register32 // 0x2830
	LUT774H  volatile.Register32 // 0x2834
	LUT775L  volatile.Register32 // 0x2838
	LUT775H  volatile.Register32 // 0x283C
	LUT776L  volatile.Register32 // 0x2840
	LUT776H  volatile.Register32 // 0x2844
	LUT777L  volatile.Register32 // 0x2848
	LUT777H  volatile.Register32 // 0x284C
	LUT778L  volatile.Register32 // 0x2850
	LUT778H  volatile.Register32 // 0x2854
	LUT779L  volatile.Register32 // 0x2858
	LUT779H  volatile.Register32 // 0x285C
	LUT780L  volatile.Register32 // 0x2860
	LUT780H  volatile.Register32 // 0x2864
	LUT781L  volatile.Register32 // 0x2868
	LUT781H  volatile.Register32 // 0x286C
	LUT782L  volatile.Register32 // 0x2870
	LUT782H  volatile.Register32 // 0x2874
	LUT783L  volatile.Register32 // 0x2878
	LUT783H  volatile.Register32 // 0x287C
	LUT784L  volatile.Register32 // 0x2880
	LUT784H  volatile.Register32 // 0x2884
	LUT785L  volatile.Register32 // 0x2888
	LUT785H  volatile.Register32 // 0x288C
	LUT786L  volatile.Register32 // 0x2890
	LUT786H  volatile.Register32 // 0x2894
	LUT787L  volatile.Register32 // 0x2898
	LUT787H  volatile.Register32 // 0x289C
	LUT788L  volatile.Register32 // 0x28A0
	LUT788H  volatile.Register32 // 0x28A4
	LUT789L  volatile.Register32 // 0x28A8
	LUT789H  volatile.Register32 // 0x28AC
	LUT790L  volatile.Register32 // 0x28B0
	LUT790H  volatile.Register32 // 0x28B4
	LUT791L  volatile.Register32 // 0x28B8
	LUT791H  volatile.Register32 // 0x28BC
	LUT792L  volatile.Register32 // 0x28C0
	LUT792H  volatile.Register32 // 0x28C4
	LUT793L  volatile.Register32 // 0x28C8
	LUT793H  volatile.Register32 // 0x28CC
	LUT794L  volatile.Register32 // 0x28D0
	LUT794H  volatile.Register32 // 0x28D4
	LUT795L  volatile.Register32 // 0x28D8
	LUT795H  volatile.Register32 // 0x28DC
	LUT796L  volatile.Register32 // 0x28E0
	LUT796H  volatile.Register32 // 0x28E4
	LUT797L  volatile.Register32 // 0x28E8
	LUT797H  volatile.Register32 // 0x28EC
	LUT798L  volatile.Register32 // 0x28F0
	LUT798H  volatile.Register32 // 0x28F4
	LUT799L  volatile.Register32 // 0x28F8
	LUT799H  volatile.Register32 // 0x28FC
	LUT800L  volatile.Register32 // 0x2900
	LUT800H  volatile.Register32 // 0x2904
	LUT801L  volatile.Register32 // 0x2908
	LUT801H  volatile.Register32 // 0x290C
	LUT802L  volatile.Register32 // 0x2910
	LUT802H  volatile.Register32 // 0x2914
	LUT803L  volatile.Register32 // 0x2918
	LUT803H  volatile.Register32 // 0x291C
	LUT804L  volatile.Register32 // 0x2920
	LUT804H  volatile.Register32 // 0x2924
	LUT805L  volatile.Register32 // 0x2928
	LUT805H  volatile.Register32 // 0x292C
	LUT806L  volatile.Register32 // 0x2930
	LUT806H  volatile.Register32 // 0x2934
	LUT807L  volatile.Register32 // 0x2938
	LUT807H  volatile.Register32 // 0x293C
	LUT808L  volatile.Register32 // 0x2940
	LUT808H  volatile.Register32 // 0x2944
	LUT809L  volatile.Register32 // 0x2948
	LUT809H  volatile.Register32 // 0x294C
	LUT810L  volatile.Register32 // 0x2950
	LUT810H  volatile.Register32 // 0x2954
	LUT811L  volatile.Register32 // 0x2958
	LUT811H  volatile.Register32 // 0x295C
	LUT812L  volatile.Register32 // 0x2960
	LUT812H  volatile.Register32 // 0x2964
	LUT813L  volatile.Register32 // 0x2968
	LUT813H  volatile.Register32 // 0x296C
	LUT814L  volatile.Register32 // 0x2970
	LUT814H  volatile.Register32 // 0x2974
	LUT815L  volatile.Register32 // 0x2978
	LUT815H  volatile.Register32 // 0x297C
	LUT816L  volatile.Register32 // 0x2980
	LUT816H  volatile.Register32 // 0x2984
	LUT817L  volatile.Register32 // 0x2988
	LUT817H  volatile.Register32 // 0x298C
	LUT818L  volatile.Register32 // 0x2990
	LUT818H  volatile.Register32 // 0x2994
	LUT819L  volatile.Register32 // 0x2998
	LUT819H  volatile.Register32 // 0x299C
	LUT820L  volatile.Register32 // 0x29A0
	LUT820H  volatile.Register32 // 0x29A4
	LUT821L  volatile.Register32 // 0x29A8
	LUT821H  volatile.Register32 // 0x29AC
	LUT822L  volatile.Register32 // 0x29B0
	LUT822H  volatile.Register32 // 0x29B4
	LUT823L  volatile.Register32 // 0x29B8
	LUT823H  volatile.Register32 // 0x29BC
	LUT824L  volatile.Register32 // 0x29C0
	LUT824H  volatile.Register32 // 0x29C4
	LUT825L  volatile.Register32 // 0x29C8
	LUT825H  volatile.Register32 // 0x29CC
	LUT826L  volatile.Register32 // 0x29D0
	LUT826H  volatile.Register32 // 0x29D4
	LUT827L  volatile.Register32 // 0x29D8
	LUT827H  volatile.Register32 // 0x29DC
	LUT828L  volatile.Register32 // 0x29E0
	LUT828H  volatile.Register32 // 0x29E4
	LUT829L  volatile.Register32 // 0x29E8
	LUT829H  volatile.Register32 // 0x29EC
	LUT830L  volatile.Register32 // 0x29F0
	LUT830H  volatile.Register32 // 0x29F4
	LUT831L  volatile.Register32 // 0x29F8
	LUT831H  volatile.Register32 // 0x29FC
	LUT832L  volatile.Register32 // 0x2A00
	LUT832H  volatile.Register32 // 0x2A04
	LUT833L  volatile.Register32 // 0x2A08
	LUT833H  volatile.Register32 // 0x2A0C
	LUT834L  volatile.Register32 // 0x2A10
	LUT834H  volatile.Register32 // 0x2A14
	LUT835L  volatile.Register32 // 0x2A18
	LUT835H  volatile.Register32 // 0x2A1C
	LUT836L  volatile.Register32 // 0x2A20
	LUT836H  volatile.Register32 // 0x2A24
	LUT837L  volatile.Register32 // 0x2A28
	LUT837H  volatile.Register32 // 0x2A2C
	LUT838L  volatile.Register32 // 0x2A30
	LUT838H  volatile.Register32 // 0x2A34
	LUT839L  volatile.Register32 // 0x2A38
	LUT839H  volatile.Register32 // 0x2A3C
	LUT840L  volatile.Register32 // 0x2A40
	LUT840H  volatile.Register32 // 0x2A44
	LUT841L  volatile.Register32 // 0x2A48
	LUT841H  volatile.Register32 // 0x2A4C
	LUT842L  volatile.Register32 // 0x2A50
	LUT842H  volatile.Register32 // 0x2A54
	LUT843L  volatile.Register32 // 0x2A58
	LUT843H  volatile.Register32 // 0x2A5C
	LUT844L  volatile.Register32 // 0x2A60
	LUT844H  volatile.Register32 // 0x2A64
	LUT845L  volatile.Register32 // 0x2A68
	LUT845H  volatile.Register32 // 0x2A6C
	LUT846L  volatile.Register32 // 0x2A70
	LUT846H  volatile.Register32 // 0x2A74
	LUT847L  volatile.Register32 // 0x2A78
	LUT847H  volatile.Register32 // 0x2A7C
	LUT848L  volatile.Register32 // 0x2A80
	LUT848H  volatile.Register32 // 0x2A84
	LUT849L  volatile.Register32 // 0x2A88
	LUT849H  volatile.Register32 // 0x2A8C
	LUT850L  volatile.Register32 // 0x2A90
	LUT850H  volatile.Register32 // 0x2A94
	LUT851L  volatile.Register32 // 0x2A98
	LUT851H  volatile.Register32 // 0x2A9C
	LUT852L  volatile.Register32 // 0x2AA0
	LUT852H  volatile.Register32 // 0x2AA4
	LUT853L  volatile.Register32 // 0x2AA8
	LUT853H  volatile.Register32 // 0x2AAC
	LUT854L  volatile.Register32 // 0x2AB0
	LUT854H  volatile.Register32 // 0x2AB4
	LUT855L  volatile.Register32 // 0x2AB8
	LUT855H  volatile.Register32 // 0x2ABC
	LUT856L  volatile.Register32 // 0x2AC0
	LUT856H  volatile.Register32 // 0x2AC4
	LUT857L  volatile.Register32 // 0x2AC8
	LUT857H  volatile.Register32 // 0x2ACC
	LUT858L  volatile.Register32 // 0x2AD0
	LUT858H  volatile.Register32 // 0x2AD4
	LUT859L  volatile.Register32 // 0x2AD8
	LUT859H  volatile.Register32 // 0x2ADC
	LUT860L  volatile.Register32 // 0x2AE0
	LUT860H  volatile.Register32 // 0x2AE4
	LUT861L  volatile.Register32 // 0x2AE8
	LUT861H  volatile.Register32 // 0x2AEC
	LUT862L  volatile.Register32 // 0x2AF0
	LUT862H  volatile.Register32 // 0x2AF4
	LUT863L  volatile.Register32 // 0x2AF8
	LUT863H  volatile.Register32 // 0x2AFC
	LUT864L  volatile.Register32 // 0x2B00
	LUT864H  volatile.Register32 // 0x2B04
	LUT865L  volatile.Register32 // 0x2B08
	LUT865H  volatile.Register32 // 0x2B0C
	LUT866L  volatile.Register32 // 0x2B10
	LUT866H  volatile.Register32 // 0x2B14
	LUT867L  volatile.Register32 // 0x2B18
	LUT867H  volatile.Register32 // 0x2B1C
	LUT868L  volatile.Register32 // 0x2B20
	LUT868H  volatile.Register32 // 0x2B24
	LUT869L  volatile.Register32 // 0x2B28
	LUT869H  volatile.Register32 // 0x2B2C
	LUT870L  volatile.Register32 // 0x2B30
	LUT870H  volatile.Register32 // 0x2B34
	LUT871L  volatile.Register32 // 0x2B38
	LUT871H  volatile.Register32 // 0x2B3C
	LUT872L  volatile.Register32 // 0x2B40
	LUT872H  volatile.Register32 // 0x2B44
	LUT873L  volatile.Register32 // 0x2B48
	LUT873H  volatile.Register32 // 0x2B4C
	LUT874L  volatile.Register32 // 0x2B50
	LUT874H  volatile.Register32 // 0x2B54
	LUT875L  volatile.Register32 // 0x2B58
	LUT875H  volatile.Register32 // 0x2B5C
	LUT876L  volatile.Register32 // 0x2B60
	LUT876H  volatile.Register32 // 0x2B64
	LUT877L  volatile.Register32 // 0x2B68
	LUT877H  volatile.Register32 // 0x2B6C
	LUT878L  volatile.Register32 // 0x2B70
	LUT878H  volatile.Register32 // 0x2B74
	LUT879L  volatile.Register32 // 0x2B78
	LUT879H  volatile.Register32 // 0x2B7C
	LUT880L  volatile.Register32 // 0x2B80
	LUT880H  volatile.Register32 // 0x2B84
	LUT881L  volatile.Register32 // 0x2B88
	LUT881H  volatile.Register32 // 0x2B8C
	LUT882L  volatile.Register32 // 0x2B90
	LUT882H  volatile.Register32 // 0x2B94
	LUT883L  volatile.Register32 // 0x2B98
	LUT883H  volatile.Register32 // 0x2B9C
	LUT884L  volatile.Register32 // 0x2BA0
	LUT884H  volatile.Register32 // 0x2BA4
	LUT885L  volatile.Register32 // 0x2BA8
	LUT885H  volatile.Register32 // 0x2BAC
	LUT886L  volatile.Register32 // 0x2BB0
	LUT886H  volatile.Register32 // 0x2BB4
	LUT887L  volatile.Register32 // 0x2BB8
	LUT887H  volatile.Register32 // 0x2BBC
	LUT888L  volatile.Register32 // 0x2BC0
	LUT888H  volatile.Register32 // 0x2BC4
	LUT889L  volatile.Register32 // 0x2BC8
	LUT889H  volatile.Register32 // 0x2BCC
	LUT890L  volatile.Register32 // 0x2BD0
	LUT890H  volatile.Register32 // 0x2BD4
	LUT891L  volatile.Register32 // 0x2BD8
	LUT891H  volatile.Register32 // 0x2BDC
	LUT892L  volatile.Register32 // 0x2BE0
	LUT892H  volatile.Register32 // 0x2BE4
	LUT893L  volatile.Register32 // 0x2BE8
	LUT893H  volatile.Register32 // 0x2BEC
	LUT894L  volatile.Register32 // 0x2BF0
	LUT894H  volatile.Register32 // 0x2BF4
	LUT895L  volatile.Register32 // 0x2BF8
	LUT895H  volatile.Register32 // 0x2BFC
	LUT896L  volatile.Register32 // 0x2C00
	LUT896H  volatile.Register32 // 0x2C04
	LUT897L  volatile.Register32 // 0x2C08
	LUT897H  volatile.Register32 // 0x2C0C
	LUT898L  volatile.Register32 // 0x2C10
	LUT898H  volatile.Register32 // 0x2C14
	LUT899L  volatile.Register32 // 0x2C18
	LUT899H  volatile.Register32 // 0x2C1C
	LUT900L  volatile.Register32 // 0x2C20
	LUT900H  volatile.Register32 // 0x2C24
	LUT901L  volatile.Register32 // 0x2C28
	LUT901H  volatile.Register32 // 0x2C2C
	LUT902L  volatile.Register32 // 0x2C30
	LUT902H  volatile.Register32 // 0x2C34
	LUT903L  volatile.Register32 // 0x2C38
	LUT903H  volatile.Register32 // 0x2C3C
	LUT904L  volatile.Register32 // 0x2C40
	LUT904H  volatile.Register32 // 0x2C44
	LUT905L  volatile.Register32 // 0x2C48
	LUT905H  volatile.Register32 // 0x2C4C
	LUT906L  volatile.Register32 // 0x2C50
	LUT906H  volatile.Register32 // 0x2C54
	LUT907L  volatile.Register32 // 0x2C58
	LUT907H  volatile.Register32 // 0x2C5C
	LUT908L  volatile.Register32 // 0x2C60
	LUT908H  volatile.Register32 // 0x2C64
	LUT909L  volatile.Register32 // 0x2C68
	LUT909H  volatile.Register32 // 0x2C6C
	LUT910L  volatile.Register32 // 0x2C70
	LUT910H  volatile.Register32 // 0x2C74
	LUT911L  volatile.Register32 // 0x2C78
	LUT911H  volatile.Register32 // 0x2C7C
	LUT912L  volatile.Register32 // 0x2C80
	LUT912H  volatile.Register32 // 0x2C84
	LUT913L  volatile.Register32 // 0x2C88
	LUT913H  volatile.Register32 // 0x2C8C
	LUT914L  volatile.Register32 // 0x2C90
	LUT914H  volatile.Register32 // 0x2C94
	LUT915L  volatile.Register32 // 0x2C98
	LUT915H  volatile.Register32 // 0x2C9C
	LUT916L  volatile.Register32 // 0x2CA0
	LUT916H  volatile.Register32 // 0x2CA4
	LUT917L  volatile.Register32 // 0x2CA8
	LUT917H  volatile.Register32 // 0x2CAC
	LUT918L  volatile.Register32 // 0x2CB0
	LUT918H  volatile.Register32 // 0x2CB4
	LUT919L  volatile.Register32 // 0x2CB8
	LUT919H  volatile.Register32 // 0x2CBC
	LUT920L  volatile.Register32 // 0x2CC0
	LUT920H  volatile.Register32 // 0x2CC4
	LUT921L  volatile.Register32 // 0x2CC8
	LUT921H  volatile.Register32 // 0x2CCC
	LUT922L  volatile.Register32 // 0x2CD0
	LUT922H  volatile.Register32 // 0x2CD4
	LUT923L  volatile.Register32 // 0x2CD8
	LUT923H  volatile.Register32 // 0x2CDC
	LUT924L  volatile.Register32 // 0x2CE0
	LUT924H  volatile.Register32 // 0x2CE4
	LUT925L  volatile.Register32 // 0x2CE8
	LUT925H  volatile.Register32 // 0x2CEC
	LUT926L  volatile.Register32 // 0x2CF0
	LUT926H  volatile.Register32 // 0x2CF4
	LUT927L  volatile.Register32 // 0x2CF8
	LUT927H  volatile.Register32 // 0x2CFC
	LUT928L  volatile.Register32 // 0x2D00
	LUT928H  volatile.Register32 // 0x2D04
	LUT929L  volatile.Register32 // 0x2D08
	LUT929H  volatile.Register32 // 0x2D0C
	LUT930L  volatile.Register32 // 0x2D10
	LUT930H  volatile.Register32 // 0x2D14
	LUT931L  volatile.Register32 // 0x2D18
	LUT931H  volatile.Register32 // 0x2D1C
	LUT932L  volatile.Register32 // 0x2D20
	LUT932H  volatile.Register32 // 0x2D24
	LUT933L  volatile.Register32 // 0x2D28
	LUT933H  volatile.Register32 // 0x2D2C
	LUT934L  volatile.Register32 // 0x2D30
	LUT934H  volatile.Register32 // 0x2D34
	LUT935L  volatile.Register32 // 0x2D38
	LUT935H  volatile.Register32 // 0x2D3C
	LUT936L  volatile.Register32 // 0x2D40
	LUT936H  volatile.Register32 // 0x2D44
	LUT937L  volatile.Register32 // 0x2D48
	LUT937H  volatile.Register32 // 0x2D4C
	LUT938L  volatile.Register32 // 0x2D50
	LUT938H  volatile.Register32 // 0x2D54
	LUT939L  volatile.Register32 // 0x2D58
	LUT939H  volatile.Register32 // 0x2D5C
	LUT940L  volatile.Register32 // 0x2D60
	LUT940H  volatile.Register32 // 0x2D64
	LUT941L  volatile.Register32 // 0x2D68
	LUT941H  volatile.Register32 // 0x2D6C
	LUT942L  volatile.Register32 // 0x2D70
	LUT942H  volatile.Register32 // 0x2D74
	LUT943L  volatile.Register32 // 0x2D78
	LUT943H  volatile.Register32 // 0x2D7C
	LUT944L  volatile.Register32 // 0x2D80
	LUT944H  volatile.Register32 // 0x2D84
	LUT945L  volatile.Register32 // 0x2D88
	LUT945H  volatile.Register32 // 0x2D8C
	LUT946L  volatile.Register32 // 0x2D90
	LUT946H  volatile.Register32 // 0x2D94
	LUT947L  volatile.Register32 // 0x2D98
	LUT947H  volatile.Register32 // 0x2D9C
	LUT948L  volatile.Register32 // 0x2DA0
	LUT948H  volatile.Register32 // 0x2DA4
	LUT949L  volatile.Register32 // 0x2DA8
	LUT949H  volatile.Register32 // 0x2DAC
	LUT950L  volatile.Register32 // 0x2DB0
	LUT950H  volatile.Register32 // 0x2DB4
	LUT951L  volatile.Register32 // 0x2DB8
	LUT951H  volatile.Register32 // 0x2DBC
	LUT952L  volatile.Register32 // 0x2DC0
	LUT952H  volatile.Register32 // 0x2DC4
	LUT953L  volatile.Register32 // 0x2DC8
	LUT953H  volatile.Register32 // 0x2DCC
	LUT954L  volatile.Register32 // 0x2DD0
	LUT954H  volatile.Register32 // 0x2DD4
	LUT955L  volatile.Register32 // 0x2DD8
	LUT955H  volatile.Register32 // 0x2DDC
	LUT956L  volatile.Register32 // 0x2DE0
	LUT956H  volatile.Register32 // 0x2DE4
	LUT957L  volatile.Register32 // 0x2DE8
	LUT957H  volatile.Register32 // 0x2DEC
	LUT958L  volatile.Register32 // 0x2DF0
	LUT958H  volatile.Register32 // 0x2DF4
	LUT959L  volatile.Register32 // 0x2DF8
	LUT959H  volatile.Register32 // 0x2DFC
	LUT960L  volatile.Register32 // 0x2E00
	LUT960H  volatile.Register32 // 0x2E04
	LUT961L  volatile.Register32 // 0x2E08
	LUT961H  volatile.Register32 // 0x2E0C
	LUT962L  volatile.Register32 // 0x2E10
	LUT962H  volatile.Register32 // 0x2E14
	LUT963L  volatile.Register32 // 0x2E18
	LUT963H  volatile.Register32 // 0x2E1C
	LUT964L  volatile.Register32 // 0x2E20
	LUT964H  volatile.Register32 // 0x2E24
	LUT965L  volatile.Register32 // 0x2E28
	LUT965H  volatile.Register32 // 0x2E2C
	LUT966L  volatile.Register32 // 0x2E30
	LUT966H  volatile.Register32 // 0x2E34
	LUT967L  volatile.Register32 // 0x2E38
	LUT967H  volatile.Register32 // 0x2E3C
	LUT968L  volatile.Register32 // 0x2E40
	LUT968H  volatile.Register32 // 0x2E44
	LUT969L  volatile.Register32 // 0x2E48
	LUT969H  volatile.Register32 // 0x2E4C
	LUT970L  volatile.Register32 // 0x2E50
	LUT970H  volatile.Register32 // 0x2E54
	LUT971L  volatile.Register32 // 0x2E58
	LUT971H  volatile.Register32 // 0x2E5C
	LUT972L  volatile.Register32 // 0x2E60
	LUT972H  volatile.Register32 // 0x2E64
	LUT973L  volatile.Register32 // 0x2E68
	LUT973H  volatile.Register32 // 0x2E6C
	LUT974L  volatile.Register32 // 0x2E70
	LUT974H  volatile.Register32 // 0x2E74
	LUT975L  volatile.Register32 // 0x2E78
	LUT975H  volatile.Register32 // 0x2E7C
	LUT976L  volatile.Register32 // 0x2E80
	LUT976H  volatile.Register32 // 0x2E84
	LUT977L  volatile.Register32 // 0x2E88
	LUT977H  volatile.Register32 // 0x2E8C
	LUT978L  volatile.Register32 // 0x2E90
	LUT978H  volatile.Register32 // 0x2E94
	LUT979L  volatile.Register32 // 0x2E98
	LUT979H  volatile.Register32 // 0x2E9C
	LUT980L  volatile.Register32 // 0x2EA0
	LUT980H  volatile.Register32 // 0x2EA4
	LUT981L  volatile.Register32 // 0x2EA8
	LUT981H  volatile.Register32 // 0x2EAC
	LUT982L  volatile.Register32 // 0x2EB0
	LUT982H  volatile.Register32 // 0x2EB4
	LUT983L  volatile.Register32 // 0x2EB8
	LUT983H  volatile.Register32 // 0x2EBC
	LUT984L  volatile.Register32 // 0x2EC0
	LUT984H  volatile.Register32 // 0x2EC4
	LUT985L  volatile.Register32 // 0x2EC8
	LUT985H  volatile.Register32 // 0x2ECC
	LUT986L  volatile.Register32 // 0x2ED0
	LUT986H  volatile.Register32 // 0x2ED4
	LUT987L  volatile.Register32 // 0x2ED8
	LUT987H  volatile.Register32 // 0x2EDC
	LUT988L  volatile.Register32 // 0x2EE0
	LUT988H  volatile.Register32 // 0x2EE4
	LUT989L  volatile.Register32 // 0x2EE8
	LUT989H  volatile.Register32 // 0x2EEC
	LUT990L  volatile.Register32 // 0x2EF0
	LUT990H  volatile.Register32 // 0x2EF4
	LUT991L  volatile.Register32 // 0x2EF8
	LUT991H  volatile.Register32 // 0x2EFC
	LUT992L  volatile.Register32 // 0x2F00
	LUT992H  volatile.Register32 // 0x2F04
	LUT993L  volatile.Register32 // 0x2F08
	LUT993H  volatile.Register32 // 0x2F0C
	LUT994L  volatile.Register32 // 0x2F10
	LUT994H  volatile.Register32 // 0x2F14
	LUT995L  volatile.Register32 // 0x2F18
	LUT995H  volatile.Register32 // 0x2F1C
	LUT996L  volatile.Register32 // 0x2F20
	LUT996H  volatile.Register32 // 0x2F24
	LUT997L  volatile.Register32 // 0x2F28
	LUT997H  volatile.Register32 // 0x2F2C
	LUT998L  volatile.Register32 // 0x2F30
	LUT998H  volatile.Register32 // 0x2F34
	LUT999L  volatile.Register32 // 0x2F38
	LUT999H  volatile.Register32 // 0x2F3C
	LUT1000L volatile.Register32 // 0x2F40
	LUT1000H volatile.Register32 // 0x2F44
	LUT1001L volatile.Register32 // 0x2F48
	LUT1001H volatile.Register32 // 0x2F4C
	LUT1002L volatile.Register32 // 0x2F50
	LUT1002H volatile.Register32 // 0x2F54
	LUT1003L volatile.Register32 // 0x2F58
	LUT1003H volatile.Register32 // 0x2F5C
	LUT1004L volatile.Register32 // 0x2F60
	LUT1004H volatile.Register32 // 0x2F64
	LUT1005L volatile.Register32 // 0x2F68
	LUT1005H volatile.Register32 // 0x2F6C
	LUT1006L volatile.Register32 // 0x2F70
	LUT1006H volatile.Register32 // 0x2F74
	LUT1007L volatile.Register32 // 0x2F78
	LUT1007H volatile.Register32 // 0x2F7C
	LUT1008L volatile.Register32 // 0x2F80
	LUT1008H volatile.Register32 // 0x2F84
	LUT1009L volatile.Register32 // 0x2F88
	LUT1009H volatile.Register32 // 0x2F8C
	LUT1010L volatile.Register32 // 0x2F90
	LUT1010H volatile.Register32 // 0x2F94
	LUT1011L volatile.Register32 // 0x2F98
	LUT1011H volatile.Register32 // 0x2F9C
	LUT1012L volatile.Register32 // 0x2FA0
	LUT1012H volatile.Register32 // 0x2FA4
	LUT1013L volatile.Register32 // 0x2FA8
	LUT1013H volatile.Register32 // 0x2FAC
	LUT1014L volatile.Register32 // 0x2FB0
	LUT1014H volatile.Register32 // 0x2FB4
	LUT1015L volatile.Register32 // 0x2FB8
	LUT1015H volatile.Register32 // 0x2FBC
	LUT1016L volatile.Register32 // 0x2FC0
	LUT1016H volatile.Register32 // 0x2FC4
	LUT1017L volatile.Register32 // 0x2FC8
	LUT1017H volatile.Register32 // 0x2FCC
	LUT1018L volatile.Register32 // 0x2FD0
	LUT1018H volatile.Register32 // 0x2FD4
	LUT1019L volatile.Register32 // 0x2FD8
	LUT1019H volatile.Register32 // 0x2FDC
	LUT1020L volatile.Register32 // 0x2FE0
	LUT1020H volatile.Register32 // 0x2FE4
	LUT1021L volatile.Register32 // 0x2FE8
	LUT1021H volatile.Register32 // 0x2FEC
	LUT1022L volatile.Register32 // 0x2FF0
	LUT1022H volatile.Register32 // 0x2FF4
	LUT1023L volatile.Register32 // 0x2FF8
	LUT1023H volatile.Register32 // 0x2FFC
}

// OctoSPI IO Manager
type OCTOSPIM_Type struct {
	_    [4]byte
	P1CR volatile.Register32 // 0x4
	P2CR volatile.Register32 // 0x8
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1        // Bit EN1.
	DAC_CR_TEN1_Pos      = 0x2        // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4        // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4        // Bit TEN1.
	DAC_CR_TSEL1_Pos     = 0x3        // Position of TSEL1 field.
	DAC_CR_TSEL1_Msk     = 0x38       // Bit mask of TSEL1 field.
	DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_CR_CEN1_Pos      = 0xe        // Position of CEN1 field.
	DAC_CR_CEN1_Msk      = 0x4000     // Bit mask of CEN1 field.
	DAC_CR_CEN1          = 0x4000     // Bit CEN1.
	DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_CR_TEN2_Pos      = 0x12       // Position of TEN2 field.
	DAC_CR_TEN2_Msk      = 0x40000    // Bit mask of TEN2 field.
	DAC_CR_TEN2          = 0x40000    // Bit TEN2.
	DAC_CR_TSEL2_Pos     = 0x13       // Position of TSEL2 field.
	DAC_CR_TSEL2_Msk     = 0x380000   // Bit mask of TSEL2 field.
	DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.
	DAC_CR_CEN2_Pos      = 0x1e       // Position of CEN2 field.
	DAC_CR_CEN2_Msk      = 0x40000000 // Bit mask of CEN2 field.
	DAC_CR_CEN2          = 0x40000000 // Bit CEN2.

	// SWTRIGR: software trigger register
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2     = 0x2 // Bit SWTRIG2.

	// DHR12R1: channel1 12-bit right-aligned data holding           register
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: channel1 12-bit left-aligned data holding           register
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: channel1 8-bit right-aligned data holding           register
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DHR12R2: channel2 12-bit right aligned data holding           register
	DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DHR12L2: channel2 12-bit left aligned data holding           register
	DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DHR8R2: channel2 8-bit right-aligned data holding           register
	DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DHR12RD: Dual DAC 12-bit right-aligned data holding           register
	DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.

	// DHR12LD: DUAL DAC 12-bit left aligned data holding           register
	DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.

	// DHR8RD: DUAL DAC 8-bit right aligned data holding           register
	DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.

	// DOR1: channel1 data output register
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DOR2: channel2 data output register
	DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// SR: status register
	DAC_SR_DMAUDR1_Pos   = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk   = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1       = 0x2000     // Bit DMAUDR1.
	DAC_SR_CAL_FLAG1_Pos = 0xe        // Position of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1_Msk = 0x4000     // Bit mask of CAL_FLAG1 field.
	DAC_SR_CAL_FLAG1     = 0x4000     // Bit CAL_FLAG1.
	DAC_SR_BWST1_Pos     = 0xf        // Position of BWST1 field.
	DAC_SR_BWST1_Msk     = 0x8000     // Bit mask of BWST1 field.
	DAC_SR_BWST1         = 0x8000     // Bit BWST1.
	DAC_SR_DMAUDR2_Pos   = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk   = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2       = 0x20000000 // Bit DMAUDR2.
	DAC_SR_CAL_FLAG2_Pos = 0x1e       // Position of CAL_FLAG2 field.
	DAC_SR_CAL_FLAG2_Msk = 0x40000000 // Bit mask of CAL_FLAG2 field.
	DAC_SR_CAL_FLAG2     = 0x40000000 // Bit CAL_FLAG2.
	DAC_SR_BWST2_Pos     = 0x1f       // Position of BWST2 field.
	DAC_SR_BWST2_Msk     = 0x80000000 // Bit mask of BWST2 field.
	DAC_SR_BWST2         = 0x80000000 // Bit BWST2.

	// CCR: calibration control register
	DAC_CCR_OTRIM1_Pos = 0x0      // Position of OTRIM1 field.
	DAC_CCR_OTRIM1_Msk = 0x1f     // Bit mask of OTRIM1 field.
	DAC_CCR_OTRIM2_Pos = 0x10     // Position of OTRIM2 field.
	DAC_CCR_OTRIM2_Msk = 0x1f0000 // Bit mask of OTRIM2 field.

	// MCR: mode control register
	DAC_MCR_MODE1_Pos = 0x0     // Position of MODE1 field.
	DAC_MCR_MODE1_Msk = 0x7     // Bit mask of MODE1 field.
	DAC_MCR_MODE2_Pos = 0x10    // Position of MODE2 field.
	DAC_MCR_MODE2_Msk = 0x70000 // Bit mask of MODE2 field.

	// SHSR1: Sample and Hold sample time register           1
	DAC_SHSR1_TSAMPLE1_Pos = 0x0   // Position of TSAMPLE1 field.
	DAC_SHSR1_TSAMPLE1_Msk = 0x3ff // Bit mask of TSAMPLE1 field.

	// SHSR2: Sample and Hold sample time register           2
	DAC_SHSR2_TSAMPLE2_Pos = 0x0   // Position of TSAMPLE2 field.
	DAC_SHSR2_TSAMPLE2_Msk = 0x3ff // Bit mask of TSAMPLE2 field.

	// SHHR: Sample and Hold hold time           register
	DAC_SHHR_THOLD1_Pos = 0x0       // Position of THOLD1 field.
	DAC_SHHR_THOLD1_Msk = 0x3ff     // Bit mask of THOLD1 field.
	DAC_SHHR_THOLD2_Pos = 0x10      // Position of THOLD2 field.
	DAC_SHHR_THOLD2_Msk = 0x3ff0000 // Bit mask of THOLD2 field.

	// SHRR: Sample and Hold refresh time           register
	DAC_SHRR_TREFRESH1_Pos = 0x0      // Position of TREFRESH1 field.
	DAC_SHRR_TREFRESH1_Msk = 0xff     // Bit mask of TREFRESH1 field.
	DAC_SHRR_TREFRESH2_Pos = 0x10     // Position of TREFRESH2 field.
	DAC_SHRR_TREFRESH2_Msk = 0xff0000 // Bit mask of TREFRESH2 field.
)

// Bitfields for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	DMA_ISR_TEIF7_Pos = 0x1b      // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000 // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7     = 0x8000000 // Bit TEIF7.
	DMA_ISR_HTIF7_Pos = 0x1a      // Position of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000 // Bit mask of HTIF7 field.
	DMA_ISR_HTIF7     = 0x4000000 // Bit HTIF7.
	DMA_ISR_TCIF7_Pos = 0x19      // Position of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000 // Bit mask of TCIF7 field.
	DMA_ISR_TCIF7     = 0x2000000 // Bit TCIF7.
	DMA_ISR_GIF7_Pos  = 0x18      // Position of GIF7 field.
	DMA_ISR_GIF7_Msk  = 0x1000000 // Bit mask of GIF7 field.
	DMA_ISR_GIF7      = 0x1000000 // Bit GIF7.
	DMA_ISR_TEIF6_Pos = 0x17      // Position of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000  // Bit mask of TEIF6 field.
	DMA_ISR_TEIF6     = 0x800000  // Bit TEIF6.
	DMA_ISR_HTIF6_Pos = 0x16      // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000  // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6     = 0x400000  // Bit HTIF6.
	DMA_ISR_TCIF6_Pos = 0x15      // Position of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000  // Bit mask of TCIF6 field.
	DMA_ISR_TCIF6     = 0x200000  // Bit TCIF6.
	DMA_ISR_GIF6_Pos  = 0x14      // Position of GIF6 field.
	DMA_ISR_GIF6_Msk  = 0x100000  // Bit mask of GIF6 field.
	DMA_ISR_GIF6      = 0x100000  // Bit GIF6.
	DMA_ISR_TEIF5_Pos = 0x13      // Position of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000   // Bit mask of TEIF5 field.
	DMA_ISR_TEIF5     = 0x80000   // Bit TEIF5.
	DMA_ISR_HTIF5_Pos = 0x12      // Position of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000   // Bit mask of HTIF5 field.
	DMA_ISR_HTIF5     = 0x40000   // Bit HTIF5.
	DMA_ISR_TCIF5_Pos = 0x11      // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000   // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5     = 0x20000   // Bit TCIF5.
	DMA_ISR_GIF5_Pos  = 0x10      // Position of GIF5 field.
	DMA_ISR_GIF5_Msk  = 0x10000   // Bit mask of GIF5 field.
	DMA_ISR_GIF5      = 0x10000   // Bit GIF5.
	DMA_ISR_TEIF4_Pos = 0xf       // Position of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000    // Bit mask of TEIF4 field.
	DMA_ISR_TEIF4     = 0x8000    // Bit TEIF4.
	DMA_ISR_HTIF4_Pos = 0xe       // Position of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000    // Bit mask of HTIF4 field.
	DMA_ISR_HTIF4     = 0x4000    // Bit HTIF4.
	DMA_ISR_TCIF4_Pos = 0xd       // Position of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000    // Bit mask of TCIF4 field.
	DMA_ISR_TCIF4     = 0x2000    // Bit TCIF4.
	DMA_ISR_GIF4_Pos  = 0xc       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk  = 0x1000    // Bit mask of GIF4 field.
	DMA_ISR_GIF4      = 0x1000    // Bit GIF4.
	DMA_ISR_TEIF3_Pos = 0xb       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800     // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3     = 0x800     // Bit TEIF3.
	DMA_ISR_HTIF3_Pos = 0xa       // Position of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400     // Bit mask of HTIF3 field.
	DMA_ISR_HTIF3     = 0x400     // Bit HTIF3.
	DMA_ISR_TCIF3_Pos = 0x9       // Position of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200     // Bit mask of TCIF3 field.
	DMA_ISR_TCIF3     = 0x200     // Bit TCIF3.
	DMA_ISR_GIF3_Pos  = 0x8       // Position of GIF3 field.
	DMA_ISR_GIF3_Msk  = 0x100     // Bit mask of GIF3 field.
	DMA_ISR_GIF3      = 0x100     // Bit GIF3.
	DMA_ISR_TEIF2_Pos = 0x7       // Position of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80      // Bit mask of TEIF2 field.
	DMA_ISR_TEIF2     = 0x80      // Bit TEIF2.
	DMA_ISR_HTIF2_Pos = 0x6       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40      // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2     = 0x40      // Bit HTIF2.
	DMA_ISR_TCIF2_Pos = 0x5       // Position of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20      // Bit mask of TCIF2 field.
	DMA_ISR_TCIF2     = 0x20      // Bit TCIF2.
	DMA_ISR_GIF2_Pos  = 0x4       // Position of GIF2 field.
	DMA_ISR_GIF2_Msk  = 0x10      // Bit mask of GIF2 field.
	DMA_ISR_GIF2      = 0x10      // Bit GIF2.
	DMA_ISR_TEIF1_Pos = 0x3       // Position of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8       // Bit mask of TEIF1 field.
	DMA_ISR_TEIF1     = 0x8       // Bit TEIF1.
	DMA_ISR_HTIF1_Pos = 0x2       // Position of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4       // Bit mask of HTIF1 field.
	DMA_ISR_HTIF1     = 0x4       // Bit HTIF1.
	DMA_ISR_TCIF1_Pos = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1     = 0x2       // Bit TCIF1.
	DMA_ISR_GIF1_Pos  = 0x0       // Position of GIF1 field.
	DMA_ISR_GIF1_Msk  = 0x1       // Bit mask of GIF1 field.
	DMA_ISR_GIF1      = 0x1       // Bit GIF1.

	// IFCR: interrupt flag clear register
	DMA_IFCR_CTEIF7_Pos = 0x1b      // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000 // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7     = 0x8000000 // Bit CTEIF7.
	DMA_IFCR_CHTIF7_Pos = 0x1a      // Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7     = 0x4000000 // Bit CHTIF7.
	DMA_IFCR_CTCIF7_Pos = 0x19      // Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000 // Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7     = 0x2000000 // Bit CTCIF7.
	DMA_IFCR_CGIF7_Pos  = 0x18      // Position of CGIF7 field.
	DMA_IFCR_CGIF7_Msk  = 0x1000000 // Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7      = 0x1000000 // Bit CGIF7.
	DMA_IFCR_CTEIF6_Pos = 0x17      // Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000  // Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6     = 0x800000  // Bit CTEIF6.
	DMA_IFCR_CHTIF6_Pos = 0x16      // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000  // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6     = 0x400000  // Bit CHTIF6.
	DMA_IFCR_CTCIF6_Pos = 0x15      // Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000  // Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6     = 0x200000  // Bit CTCIF6.
	DMA_IFCR_CGIF6_Pos  = 0x14      // Position of CGIF6 field.
	DMA_IFCR_CGIF6_Msk  = 0x100000  // Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6      = 0x100000  // Bit CGIF6.
	DMA_IFCR_CTEIF5_Pos = 0x13      // Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000   // Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5     = 0x80000   // Bit CTEIF5.
	DMA_IFCR_CHTIF5_Pos = 0x12      // Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000   // Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5     = 0x40000   // Bit CHTIF5.
	DMA_IFCR_CTCIF5_Pos = 0x11      // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000   // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5     = 0x20000   // Bit CTCIF5.
	DMA_IFCR_CGIF5_Pos  = 0x10      // Position of CGIF5 field.
	DMA_IFCR_CGIF5_Msk  = 0x10000   // Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5      = 0x10000   // Bit CGIF5.
	DMA_IFCR_CTEIF4_Pos = 0xf       // Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000    // Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4     = 0x8000    // Bit CTEIF4.
	DMA_IFCR_CHTIF4_Pos = 0xe       // Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000    // Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4     = 0x4000    // Bit CHTIF4.
	DMA_IFCR_CTCIF4_Pos = 0xd       // Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000    // Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4     = 0x2000    // Bit CTCIF4.
	DMA_IFCR_CGIF4_Pos  = 0xc       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk  = 0x1000    // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4      = 0x1000    // Bit CGIF4.
	DMA_IFCR_CTEIF3_Pos = 0xb       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800     // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3     = 0x800     // Bit CTEIF3.
	DMA_IFCR_CHTIF3_Pos = 0xa       // Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400     // Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3     = 0x400     // Bit CHTIF3.
	DMA_IFCR_CTCIF3_Pos = 0x9       // Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200     // Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3     = 0x200     // Bit CTCIF3.
	DMA_IFCR_CGIF3_Pos  = 0x8       // Position of CGIF3 field.
	DMA_IFCR_CGIF3_Msk  = 0x100     // Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3      = 0x100     // Bit CGIF3.
	DMA_IFCR_CTEIF2_Pos = 0x7       // Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80      // Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2     = 0x80      // Bit CTEIF2.
	DMA_IFCR_CHTIF2_Pos = 0x6       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40      // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2     = 0x40      // Bit CHTIF2.
	DMA_IFCR_CTCIF2_Pos = 0x5       // Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20      // Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2     = 0x20      // Bit CTCIF2.
	DMA_IFCR_CGIF2_Pos  = 0x4       // Position of CGIF2 field.
	DMA_IFCR_CGIF2_Msk  = 0x10      // Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2      = 0x10      // Bit CGIF2.
	DMA_IFCR_CTEIF1_Pos = 0x3       // Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8       // Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1     = 0x8       // Bit CTEIF1.
	DMA_IFCR_CHTIF1_Pos = 0x2       // Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4       // Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1     = 0x4       // Bit CHTIF1.
	DMA_IFCR_CTCIF1_Pos = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1     = 0x2       // Bit CTCIF1.
	DMA_IFCR_CGIF1_Pos  = 0x0       // Position of CGIF1 field.
	DMA_IFCR_CGIF1_Msk  = 0x1       // Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1      = 0x1       // Bit CGIF1.

	// CCR1: channel x configuration           register
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.

	// CNDTR1: channel x number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: channel x peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: channel x memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: channel x configuration           register
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.

	// CNDTR2: channel x number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: channel x peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: channel x memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: channel x configuration           register
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.

	// CNDTR3: channel x number of data           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: channel x peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: channel x memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: channel x configuration           register
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.

	// CNDTR4: channel x number of data           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: channel x peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: channel x memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: channel x configuration           register
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.

	// CNDTR5: channel x number of data           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: channel x peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: channel x memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: channel x configuration           register
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.

	// CNDTR6: channel x number of data           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: channel x peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: channel x memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: channel x configuration           register
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.

	// CNDTR7: channel x number of data           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: channel x peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: channel x memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CSELR: channel selection register
	DMA_CSELR_C7S_Pos = 0x18      // Position of C7S field.
	DMA_CSELR_C7S_Msk = 0xf000000 // Bit mask of C7S field.
	DMA_CSELR_C6S_Pos = 0x14      // Position of C6S field.
	DMA_CSELR_C6S_Msk = 0xf00000  // Bit mask of C6S field.
	DMA_CSELR_C5S_Pos = 0x10      // Position of C5S field.
	DMA_CSELR_C5S_Msk = 0xf0000   // Bit mask of C5S field.
	DMA_CSELR_C4S_Pos = 0xc       // Position of C4S field.
	DMA_CSELR_C4S_Msk = 0xf000    // Bit mask of C4S field.
	DMA_CSELR_C3S_Pos = 0x8       // Position of C3S field.
	DMA_CSELR_C3S_Msk = 0xf00     // Bit mask of C3S field.
	DMA_CSELR_C2S_Pos = 0x4       // Position of C2S field.
	DMA_CSELR_C2S_Msk = 0xf0      // Bit mask of C2S field.
	DMA_CSELR_C1S_Pos = 0x0       // Position of C1S field.
	DMA_CSELR_C1S_Msk = 0xf       // Bit mask of C1S field.
)

// Bitfields for CRC: Cyclic redundancy check calculation unit
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_REV_OUT_Pos  = 0x7  // Position of REV_OUT field.
	CRC_CR_REV_OUT_Msk  = 0x80 // Bit mask of REV_OUT field.
	CRC_CR_REV_OUT      = 0x80 // Bit REV_OUT.
	CRC_CR_REV_IN_Pos   = 0x5  // Position of REV_IN field.
	CRC_CR_REV_IN_Msk   = 0x60 // Bit mask of REV_IN field.
	CRC_CR_POLYSIZE_Pos = 0x3  // Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18 // Bit mask of POLYSIZE field.
	CRC_CR_RESET_Pos    = 0x0  // Position of RESET field.
	CRC_CR_RESET_Msk    = 0x1  // Bit mask of RESET field.
	CRC_CR_RESET        = 0x1  // Bit RESET.

	// INIT: Initial CRC value
	CRC_INIT_CRC_INIT_Pos = 0x0        // Position of CRC_INIT field.
	CRC_INIT_CRC_INIT_Msk = 0xffffffff // Bit mask of CRC_INIT field.

	// POL: polynomial
	CRC_POL_Polynomialcoefficients_Pos = 0x0        // Position of Polynomialcoefficients field.
	CRC_POL_Polynomialcoefficients_Msk = 0xffffffff // Bit mask of Polynomialcoefficients field.
)

// Bitfields for LTCD: Liquid crystal display controller
const (
	// SSCR: LTDC Synchronization Size Configuration           Register
	LCD_SSCR_VSH_Pos = 0x0       // Position of VSH field.
	LCD_SSCR_VSH_Msk = 0x7ff     // Bit mask of VSH field.
	LCD_SSCR_HSW_Pos = 0x10      // Position of HSW field.
	LCD_SSCR_HSW_Msk = 0xfff0000 // Bit mask of HSW field.

	// BPCR: LTDC Back Porch Configuration           Register
	LCD_BPCR_AVBP_Pos = 0x0       // Position of AVBP field.
	LCD_BPCR_AVBP_Msk = 0x7ff     // Bit mask of AVBP field.
	LCD_BPCR_AHBP_Pos = 0x10      // Position of AHBP field.
	LCD_BPCR_AHBP_Msk = 0xfff0000 // Bit mask of AHBP field.

	// AWCR: LTDC Active Width Configuration           Register
	LCD_AWCR_AAH_Pos = 0x0       // Position of AAH field.
	LCD_AWCR_AAH_Msk = 0x7ff     // Bit mask of AAH field.
	LCD_AWCR_AAW_Pos = 0x10      // Position of AAW field.
	LCD_AWCR_AAW_Msk = 0xfff0000 // Bit mask of AAW field.

	// TWCR: LTDC Total Width Configuration           Register
	LCD_TWCR_TOTALH_Pos = 0x0       // Position of TOTALH field.
	LCD_TWCR_TOTALH_Msk = 0x7ff     // Bit mask of TOTALH field.
	LCD_TWCR_TOTALW_Pos = 0x10      // Position of TOTALW field.
	LCD_TWCR_TOTALW_Msk = 0xfff0000 // Bit mask of TOTALW field.

	// GCR: LTDC Global Control Register
	LCD_GCR_LTDCEN_Pos = 0x0        // Position of LTDCEN field.
	LCD_GCR_LTDCEN_Msk = 0x1        // Bit mask of LTDCEN field.
	LCD_GCR_LTDCEN     = 0x1        // Bit LTDCEN.
	LCD_GCR_DBW_Pos    = 0x4        // Position of DBW field.
	LCD_GCR_DBW_Msk    = 0x70       // Bit mask of DBW field.
	LCD_GCR_DGW_Pos    = 0x8        // Position of DGW field.
	LCD_GCR_DGW_Msk    = 0x700      // Bit mask of DGW field.
	LCD_GCR_DRW_Pos    = 0xc        // Position of DRW field.
	LCD_GCR_DRW_Msk    = 0x7000     // Bit mask of DRW field.
	LCD_GCR_DEN_Pos    = 0x10       // Position of DEN field.
	LCD_GCR_DEN_Msk    = 0x10000    // Bit mask of DEN field.
	LCD_GCR_DEN        = 0x10000    // Bit DEN.
	LCD_GCR_PCPOL_Pos  = 0x1c       // Position of PCPOL field.
	LCD_GCR_PCPOL_Msk  = 0x10000000 // Bit mask of PCPOL field.
	LCD_GCR_PCPOL      = 0x10000000 // Bit PCPOL.
	LCD_GCR_DEPOL_Pos  = 0x1d       // Position of DEPOL field.
	LCD_GCR_DEPOL_Msk  = 0x20000000 // Bit mask of DEPOL field.
	LCD_GCR_DEPOL      = 0x20000000 // Bit DEPOL.
	LCD_GCR_VSPOL_Pos  = 0x1e       // Position of VSPOL field.
	LCD_GCR_VSPOL_Msk  = 0x40000000 // Bit mask of VSPOL field.
	LCD_GCR_VSPOL      = 0x40000000 // Bit VSPOL.
	LCD_GCR_HSPOL_Pos  = 0x1f       // Position of HSPOL field.
	LCD_GCR_HSPOL_Msk  = 0x80000000 // Bit mask of HSPOL field.
	LCD_GCR_HSPOL      = 0x80000000 // Bit HSPOL.

	// SRCR: LTDC Shadow Reload Configuration           Register
	LCD_SRCR_IMR_Pos = 0x0 // Position of IMR field.
	LCD_SRCR_IMR_Msk = 0x1 // Bit mask of IMR field.
	LCD_SRCR_IMR     = 0x1 // Bit IMR.
	LCD_SRCR_VBR_Pos = 0x1 // Position of VBR field.
	LCD_SRCR_VBR_Msk = 0x2 // Bit mask of VBR field.
	LCD_SRCR_VBR     = 0x2 // Bit VBR.

	// BCCR: LTDC Background Color Configuration           Register
	LCD_BCCR_BCBLUE_Pos  = 0x0      // Position of BCBLUE field.
	LCD_BCCR_BCBLUE_Msk  = 0xff     // Bit mask of BCBLUE field.
	LCD_BCCR_BCGREEN_Pos = 0x8      // Position of BCGREEN field.
	LCD_BCCR_BCGREEN_Msk = 0xff00   // Bit mask of BCGREEN field.
	LCD_BCCR_BCRED_Pos   = 0x10     // Position of BCRED field.
	LCD_BCCR_BCRED_Msk   = 0xff0000 // Bit mask of BCRED field.

	// IER: LTDC Interrupt Enable Register
	LCD_IER_LIE_Pos    = 0x0 // Position of LIE field.
	LCD_IER_LIE_Msk    = 0x1 // Bit mask of LIE field.
	LCD_IER_LIE        = 0x1 // Bit LIE.
	LCD_IER_FUIE_Pos   = 0x1 // Position of FUIE field.
	LCD_IER_FUIE_Msk   = 0x2 // Bit mask of FUIE field.
	LCD_IER_FUIE       = 0x2 // Bit FUIE.
	LCD_IER_TERRIE_Pos = 0x2 // Position of TERRIE field.
	LCD_IER_TERRIE_Msk = 0x4 // Bit mask of TERRIE field.
	LCD_IER_TERRIE     = 0x4 // Bit TERRIE.
	LCD_IER_RRIE_Pos   = 0x3 // Position of RRIE field.
	LCD_IER_RRIE_Msk   = 0x8 // Bit mask of RRIE field.
	LCD_IER_RRIE       = 0x8 // Bit RRIE.

	// ISR: LTDC Interrupt Status Register
	LCD_ISR_LIF_Pos    = 0x0 // Position of LIF field.
	LCD_ISR_LIF_Msk    = 0x1 // Bit mask of LIF field.
	LCD_ISR_LIF        = 0x1 // Bit LIF.
	LCD_ISR_FUIF_Pos   = 0x1 // Position of FUIF field.
	LCD_ISR_FUIF_Msk   = 0x2 // Bit mask of FUIF field.
	LCD_ISR_FUIF       = 0x2 // Bit FUIF.
	LCD_ISR_TERRIF_Pos = 0x2 // Position of TERRIF field.
	LCD_ISR_TERRIF_Msk = 0x4 // Bit mask of TERRIF field.
	LCD_ISR_TERRIF     = 0x4 // Bit TERRIF.
	LCD_ISR_RRIF_Pos   = 0x3 // Position of RRIF field.
	LCD_ISR_RRIF_Msk   = 0x8 // Bit mask of RRIF field.
	LCD_ISR_RRIF       = 0x8 // Bit RRIF.

	// ICR: LTDC Interrupt Clear Register
	LCD_ICR_CLIF_Pos    = 0x0 // Position of CLIF field.
	LCD_ICR_CLIF_Msk    = 0x1 // Bit mask of CLIF field.
	LCD_ICR_CLIF        = 0x1 // Bit CLIF.
	LCD_ICR_CFUIF_Pos   = 0x1 // Position of CFUIF field.
	LCD_ICR_CFUIF_Msk   = 0x2 // Bit mask of CFUIF field.
	LCD_ICR_CFUIF       = 0x2 // Bit CFUIF.
	LCD_ICR_CTERRIF_Pos = 0x2 // Position of CTERRIF field.
	LCD_ICR_CTERRIF_Msk = 0x4 // Bit mask of CTERRIF field.
	LCD_ICR_CTERRIF     = 0x4 // Bit CTERRIF.
	LCD_ICR_CRRIF_Pos   = 0x3 // Position of CRRIF field.
	LCD_ICR_CRRIF_Msk   = 0x8 // Bit mask of CRRIF field.
	LCD_ICR_CRRIF       = 0x8 // Bit CRRIF.

	// LIPCR: LTDC Line Interrupt Position Configuration           Register
	LCD_LIPCR_LIPOS_Pos = 0x0   // Position of LIPOS field.
	LCD_LIPCR_LIPOS_Msk = 0x7ff // Bit mask of LIPOS field.

	// CPSR: LTDC Current Position Status           Register
	LCD_CPSR_CYPOS_Pos = 0x0        // Position of CYPOS field.
	LCD_CPSR_CYPOS_Msk = 0xffff     // Bit mask of CYPOS field.
	LCD_CPSR_CXPOS_Pos = 0x10       // Position of CXPOS field.
	LCD_CPSR_CXPOS_Msk = 0xffff0000 // Bit mask of CXPOS field.

	// CDSR: LTDC Current Display Status           Register
	LCD_CDSR_VDES_Pos   = 0x0 // Position of VDES field.
	LCD_CDSR_VDES_Msk   = 0x1 // Bit mask of VDES field.
	LCD_CDSR_VDES       = 0x1 // Bit VDES.
	LCD_CDSR_HDES_Pos   = 0x1 // Position of HDES field.
	LCD_CDSR_HDES_Msk   = 0x2 // Bit mask of HDES field.
	LCD_CDSR_HDES       = 0x2 // Bit HDES.
	LCD_CDSR_VSYNCS_Pos = 0x2 // Position of VSYNCS field.
	LCD_CDSR_VSYNCS_Msk = 0x4 // Bit mask of VSYNCS field.
	LCD_CDSR_VSYNCS     = 0x4 // Bit VSYNCS.
	LCD_CDSR_HSYNCS_Pos = 0x3 // Position of HSYNCS field.
	LCD_CDSR_HSYNCS_Msk = 0x8 // Bit mask of HSYNCS field.
	LCD_CDSR_HSYNCS     = 0x8 // Bit HSYNCS.

	// L1CR: LTDC Layer Control Register
	LCD_L1CR_LEN_Pos    = 0x0  // Position of LEN field.
	LCD_L1CR_LEN_Msk    = 0x1  // Bit mask of LEN field.
	LCD_L1CR_LEN        = 0x1  // Bit LEN.
	LCD_L1CR_COLKEN_Pos = 0x1  // Position of COLKEN field.
	LCD_L1CR_COLKEN_Msk = 0x2  // Bit mask of COLKEN field.
	LCD_L1CR_COLKEN     = 0x2  // Bit COLKEN.
	LCD_L1CR_CLUTEN_Pos = 0x4  // Position of CLUTEN field.
	LCD_L1CR_CLUTEN_Msk = 0x10 // Bit mask of CLUTEN field.
	LCD_L1CR_CLUTEN     = 0x10 // Bit CLUTEN.

	// L1WHPCR: LTDC Layer Window Horizontal Position           Configuration Register
	LCD_L1WHPCR_WHSTPOS_Pos = 0x0       // Position of WHSTPOS field.
	LCD_L1WHPCR_WHSTPOS_Msk = 0xfff     // Bit mask of WHSTPOS field.
	LCD_L1WHPCR_WHSPPOS_Pos = 0x10      // Position of WHSPPOS field.
	LCD_L1WHPCR_WHSPPOS_Msk = 0xfff0000 // Bit mask of WHSPPOS field.

	// L1WVPCR: LTDC Layer Window Vertical Position           Configuration Register
	LCD_L1WVPCR_WVSTPOS_Pos = 0x0       // Position of WVSTPOS field.
	LCD_L1WVPCR_WVSTPOS_Msk = 0x7ff     // Bit mask of WVSTPOS field.
	LCD_L1WVPCR_WVSPPOS_Pos = 0x10      // Position of WVSPPOS field.
	LCD_L1WVPCR_WVSPPOS_Msk = 0x7ff0000 // Bit mask of WVSPPOS field.

	// L1CKCR: LTDC Layer Color Keying Configuration           Register
	LCD_L1CKCR_CKBLUE_Pos  = 0x0      // Position of CKBLUE field.
	LCD_L1CKCR_CKBLUE_Msk  = 0xff     // Bit mask of CKBLUE field.
	LCD_L1CKCR_CKGREEN_Pos = 0x8      // Position of CKGREEN field.
	LCD_L1CKCR_CKGREEN_Msk = 0xff00   // Bit mask of CKGREEN field.
	LCD_L1CKCR_CKRED_Pos   = 0x10     // Position of CKRED field.
	LCD_L1CKCR_CKRED_Msk   = 0xff0000 // Bit mask of CKRED field.

	// L1PFCR: LTDC Layer Pixel Format Configuration           Register
	LCD_L1PFCR_PF_Pos = 0x0 // Position of PF field.
	LCD_L1PFCR_PF_Msk = 0x7 // Bit mask of PF field.

	// L1CACR: LTDC Layer Constant Alpha Configuration           Register
	LCD_L1CACR_CONSTA_Pos = 0x0  // Position of CONSTA field.
	LCD_L1CACR_CONSTA_Msk = 0xff // Bit mask of CONSTA field.

	// L1DCCR: LTDC Layer Default Color Configuration           Register
	LCD_L1DCCR_DCBLUE_Pos  = 0x0        // Position of DCBLUE field.
	LCD_L1DCCR_DCBLUE_Msk  = 0xff       // Bit mask of DCBLUE field.
	LCD_L1DCCR_DCGREEN_Pos = 0x8        // Position of DCGREEN field.
	LCD_L1DCCR_DCGREEN_Msk = 0xff00     // Bit mask of DCGREEN field.
	LCD_L1DCCR_DCRED_Pos   = 0x10       // Position of DCRED field.
	LCD_L1DCCR_DCRED_Msk   = 0xff0000   // Bit mask of DCRED field.
	LCD_L1DCCR_DCALPHA_Pos = 0x18       // Position of DCALPHA field.
	LCD_L1DCCR_DCALPHA_Msk = 0xff000000 // Bit mask of DCALPHA field.

	// L1BFCR: LTDC Layer Blending Factors Configuration           Register
	LCD_L1BFCR_BF2_Pos = 0x0   // Position of BF2 field.
	LCD_L1BFCR_BF2_Msk = 0x7   // Bit mask of BF2 field.
	LCD_L1BFCR_BF1_Pos = 0x8   // Position of BF1 field.
	LCD_L1BFCR_BF1_Msk = 0x700 // Bit mask of BF1 field.

	// L1CFBAR: LTDC Layer Color Frame Buffer Address           Register
	LCD_L1CFBAR_CFBADD_Pos = 0x0        // Position of CFBADD field.
	LCD_L1CFBAR_CFBADD_Msk = 0xffffffff // Bit mask of CFBADD field.

	// L1CFBLR: LTDC Layer Color Frame Buffer Length           Register
	LCD_L1CFBLR_CFBLL_Pos = 0x0        // Position of CFBLL field.
	LCD_L1CFBLR_CFBLL_Msk = 0x1fff     // Bit mask of CFBLL field.
	LCD_L1CFBLR_CFBP_Pos  = 0x10       // Position of CFBP field.
	LCD_L1CFBLR_CFBP_Msk  = 0x1fff0000 // Bit mask of CFBP field.

	// L1CFBLNR: LTDC Layer ColorFrame Buffer Line Number           Register
	LCD_L1CFBLNR_CFBLNBR_Pos = 0x0   // Position of CFBLNBR field.
	LCD_L1CFBLNR_CFBLNBR_Msk = 0x7ff // Bit mask of CFBLNBR field.

	// L1CLUTWR: LTDC Layerx CLUT Write           Register
	LCD_L1CLUTWR_BLUE_Pos    = 0x0        // Position of BLUE field.
	LCD_L1CLUTWR_BLUE_Msk    = 0xff       // Bit mask of BLUE field.
	LCD_L1CLUTWR_GREEN_Pos   = 0x8        // Position of GREEN field.
	LCD_L1CLUTWR_GREEN_Msk   = 0xff00     // Bit mask of GREEN field.
	LCD_L1CLUTWR_RED_Pos     = 0x10       // Position of RED field.
	LCD_L1CLUTWR_RED_Msk     = 0xff0000   // Bit mask of RED field.
	LCD_L1CLUTWR_CLUTADD_Pos = 0x18       // Position of CLUTADD field.
	LCD_L1CLUTWR_CLUTADD_Msk = 0xff000000 // Bit mask of CLUTADD field.

	// L2CR: LTDC Layer Control Register
	LCD_L2CR_LEN_Pos    = 0x0  // Position of LEN field.
	LCD_L2CR_LEN_Msk    = 0x1  // Bit mask of LEN field.
	LCD_L2CR_LEN        = 0x1  // Bit LEN.
	LCD_L2CR_COLKEN_Pos = 0x1  // Position of COLKEN field.
	LCD_L2CR_COLKEN_Msk = 0x2  // Bit mask of COLKEN field.
	LCD_L2CR_COLKEN     = 0x2  // Bit COLKEN.
	LCD_L2CR_CLUTEN_Pos = 0x4  // Position of CLUTEN field.
	LCD_L2CR_CLUTEN_Msk = 0x10 // Bit mask of CLUTEN field.
	LCD_L2CR_CLUTEN     = 0x10 // Bit CLUTEN.

	// L2WHPCR: LTDC Layerx Window Horizontal Position           Configuration Register
	LCD_L2WHPCR_WHSTPOS_Pos = 0x0       // Position of WHSTPOS field.
	LCD_L2WHPCR_WHSTPOS_Msk = 0xfff     // Bit mask of WHSTPOS field.
	LCD_L2WHPCR_WHSPPOS_Pos = 0x10      // Position of WHSPPOS field.
	LCD_L2WHPCR_WHSPPOS_Msk = 0xfff0000 // Bit mask of WHSPPOS field.

	// L2WVPCR: LTDC Layer Window Vertical Position           Configuration Register
	LCD_L2WVPCR_WVSTPOS_Pos = 0x0       // Position of WVSTPOS field.
	LCD_L2WVPCR_WVSTPOS_Msk = 0x7ff     // Bit mask of WVSTPOS field.
	LCD_L2WVPCR_WVSPPOS_Pos = 0x10      // Position of WVSPPOS field.
	LCD_L2WVPCR_WVSPPOS_Msk = 0x7ff0000 // Bit mask of WVSPPOS field.

	// L2CKCR: LTDC Layer Color Keying Configuration           Register
	LCD_L2CKCR_CKBLUE_Pos  = 0x0      // Position of CKBLUE field.
	LCD_L2CKCR_CKBLUE_Msk  = 0xff     // Bit mask of CKBLUE field.
	LCD_L2CKCR_CKGREEN_Pos = 0x8      // Position of CKGREEN field.
	LCD_L2CKCR_CKGREEN_Msk = 0xff00   // Bit mask of CKGREEN field.
	LCD_L2CKCR_CKRED_Pos   = 0x10     // Position of CKRED field.
	LCD_L2CKCR_CKRED_Msk   = 0xff0000 // Bit mask of CKRED field.

	// L2PFCR: LTDC Layer Pixel Format Configuration           Register
	LCD_L2PFCR_PF_Pos = 0x0 // Position of PF field.
	LCD_L2PFCR_PF_Msk = 0x7 // Bit mask of PF field.

	// L2CACR: LTDC Layer Constant Alpha Configuration           Register
	LCD_L2CACR_CONSTA_Pos = 0x0  // Position of CONSTA field.
	LCD_L2CACR_CONSTA_Msk = 0xff // Bit mask of CONSTA field.

	// L2DCCR: LTDC Layer Default Color Configuration           Register
	LCD_L2DCCR_DCBLUE_Pos  = 0x0        // Position of DCBLUE field.
	LCD_L2DCCR_DCBLUE_Msk  = 0xff       // Bit mask of DCBLUE field.
	LCD_L2DCCR_DCGREEN_Pos = 0x8        // Position of DCGREEN field.
	LCD_L2DCCR_DCGREEN_Msk = 0xff00     // Bit mask of DCGREEN field.
	LCD_L2DCCR_DCRED_Pos   = 0x10       // Position of DCRED field.
	LCD_L2DCCR_DCRED_Msk   = 0xff0000   // Bit mask of DCRED field.
	LCD_L2DCCR_DCALPHA_Pos = 0x18       // Position of DCALPHA field.
	LCD_L2DCCR_DCALPHA_Msk = 0xff000000 // Bit mask of DCALPHA field.

	// L2BFCR: LTDC Layer Blending Factors Configuration           Register
	LCD_L2BFCR_BF2_Pos = 0x0   // Position of BF2 field.
	LCD_L2BFCR_BF2_Msk = 0x7   // Bit mask of BF2 field.
	LCD_L2BFCR_BF1_Pos = 0x8   // Position of BF1 field.
	LCD_L2BFCR_BF1_Msk = 0x700 // Bit mask of BF1 field.

	// L2CFBAR: LTDC Layer Color Frame Buffer Address           Register
	LCD_L2CFBAR_CFBADD_Pos = 0x0        // Position of CFBADD field.
	LCD_L2CFBAR_CFBADD_Msk = 0xffffffff // Bit mask of CFBADD field.

	// L2CFBLR: LTDC Layer Color Frame Buffer Length           Register
	LCD_L2CFBLR_CFBLL_Pos = 0x0        // Position of CFBLL field.
	LCD_L2CFBLR_CFBLL_Msk = 0x1fff     // Bit mask of CFBLL field.
	LCD_L2CFBLR_CFBP_Pos  = 0x10       // Position of CFBP field.
	LCD_L2CFBLR_CFBP_Msk  = 0x1fff0000 // Bit mask of CFBP field.

	// L2CFBLNR: LTDC Layer ColorFrame Buffer Line Number           Register
	LCD_L2CFBLNR_CFBLNBR_Pos = 0x0   // Position of CFBLNBR field.
	LCD_L2CFBLNR_CFBLNBR_Msk = 0x7ff // Bit mask of CFBLNBR field.

	// L2CLUTWR: LTDC Layerx CLUT Write           Register
	LCD_L2CLUTWR_BLUE_Pos    = 0x0        // Position of BLUE field.
	LCD_L2CLUTWR_BLUE_Msk    = 0xff       // Bit mask of BLUE field.
	LCD_L2CLUTWR_GREEN_Pos   = 0x8        // Position of GREEN field.
	LCD_L2CLUTWR_GREEN_Msk   = 0xff00     // Bit mask of GREEN field.
	LCD_L2CLUTWR_RED_Pos     = 0x10       // Position of RED field.
	LCD_L2CLUTWR_RED_Msk     = 0xff0000   // Bit mask of RED field.
	LCD_L2CLUTWR_CLUTADD_Pos = 0x18       // Position of CLUTADD field.
	LCD_L2CLUTWR_CLUTADD_Msk = 0xff000000 // Bit mask of CLUTADD field.
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	TSC_CR_CTPH_Pos    = 0x1c       // Position of CTPH field.
	TSC_CR_CTPH_Msk    = 0xf0000000 // Bit mask of CTPH field.
	TSC_CR_CTPL_Pos    = 0x18       // Position of CTPL field.
	TSC_CR_CTPL_Msk    = 0xf000000  // Bit mask of CTPL field.
	TSC_CR_SSD_Pos     = 0x11       // Position of SSD field.
	TSC_CR_SSD_Msk     = 0xfe0000   // Bit mask of SSD field.
	TSC_CR_SSE_Pos     = 0x10       // Position of SSE field.
	TSC_CR_SSE_Msk     = 0x10000    // Bit mask of SSE field.
	TSC_CR_SSE         = 0x10000    // Bit SSE.
	TSC_CR_SSPSC_Pos   = 0xf        // Position of SSPSC field.
	TSC_CR_SSPSC_Msk   = 0x8000     // Bit mask of SSPSC field.
	TSC_CR_SSPSC       = 0x8000     // Bit SSPSC.
	TSC_CR_PGPSC_Pos   = 0xc        // Position of PGPSC field.
	TSC_CR_PGPSC_Msk   = 0x7000     // Bit mask of PGPSC field.
	TSC_CR_MCV_Pos     = 0x5        // Position of MCV field.
	TSC_CR_MCV_Msk     = 0xe0       // Bit mask of MCV field.
	TSC_CR_IODEF_Pos   = 0x4        // Position of IODEF field.
	TSC_CR_IODEF_Msk   = 0x10       // Bit mask of IODEF field.
	TSC_CR_IODEF       = 0x10       // Bit IODEF.
	TSC_CR_SYNCPOL_Pos = 0x3        // Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8        // Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL     = 0x8        // Bit SYNCPOL.
	TSC_CR_AM_Pos      = 0x2        // Position of AM field.
	TSC_CR_AM_Msk      = 0x4        // Bit mask of AM field.
	TSC_CR_AM          = 0x4        // Bit AM.
	TSC_CR_START_Pos   = 0x1        // Position of START field.
	TSC_CR_START_Msk   = 0x2        // Bit mask of START field.
	TSC_CR_START       = 0x2        // Bit START.
	TSC_CR_TSCE_Pos    = 0x0        // Position of TSCE field.
	TSC_CR_TSCE_Msk    = 0x1        // Bit mask of TSCE field.
	TSC_CR_TSCE        = 0x1        // Bit TSCE.

	// IER: interrupt enable register
	TSC_IER_MCEIE_Pos = 0x1 // Position of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2 // Bit mask of MCEIE field.
	TSC_IER_MCEIE     = 0x2 // Bit MCEIE.
	TSC_IER_EOAIE_Pos = 0x0 // Position of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1 // Bit mask of EOAIE field.
	TSC_IER_EOAIE     = 0x1 // Bit EOAIE.

	// ICR: interrupt clear register
	TSC_ICR_MCEIC_Pos = 0x1 // Position of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2 // Bit mask of MCEIC field.
	TSC_ICR_MCEIC     = 0x2 // Bit MCEIC.
	TSC_ICR_EOAIC_Pos = 0x0 // Position of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1 // Bit mask of EOAIC field.
	TSC_ICR_EOAIC     = 0x1 // Bit EOAIC.

	// ISR: interrupt status register
	TSC_ISR_MCEF_Pos = 0x1 // Position of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2 // Bit mask of MCEF field.
	TSC_ISR_MCEF     = 0x2 // Bit MCEF.
	TSC_ISR_EOAF_Pos = 0x0 // Position of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1 // Bit mask of EOAF field.
	TSC_ISR_EOAF     = 0x1 // Bit EOAF.

	// IOHCR: I/O hysteresis control           register
	TSC_IOHCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOHCR_G8_IO4     = 0x80000000 // Bit G8_IO4.
	TSC_IOHCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOHCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOHCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOHCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOHCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOHCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOHCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOHCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOHCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOHCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOHCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOHCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOHCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOHCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOHCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOHCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOHCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOHCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOHCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOHCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOHCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOHCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOHCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOHCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOHCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOHCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOHCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOHCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOHCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOHCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOHCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOHCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOHCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOHCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1     = 0x1        // Bit G1_IO1.

	// IOASCR: I/O analog switch control           register
	TSC_IOASCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOASCR_G8_IO4     = 0x80000000 // Bit G8_IO4.
	TSC_IOASCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOASCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOASCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOASCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOASCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOASCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOASCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOASCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOASCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOASCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOASCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOASCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOASCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOASCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOASCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOASCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOASCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOASCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOASCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOASCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOASCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOASCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOASCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOASCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOASCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOASCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOASCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOASCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOASCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOASCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOASCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOASCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOASCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOASCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1     = 0x1        // Bit G1_IO1.

	// IOSCR: I/O sampling control register
	TSC_IOSCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOSCR_G8_IO4     = 0x80000000 // Bit G8_IO4.
	TSC_IOSCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOSCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOSCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOSCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOSCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOSCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOSCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOSCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOSCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOSCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOSCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOSCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOSCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOSCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOSCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOSCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOSCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOSCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOSCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOSCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOSCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOSCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOSCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOSCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOSCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOSCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOSCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOSCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOSCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOSCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOSCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOSCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOSCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOSCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1     = 0x1        // Bit G1_IO1.

	// IOCCR: I/O channel control register
	TSC_IOCCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOCCR_G8_IO4     = 0x80000000 // Bit G8_IO4.
	TSC_IOCCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOCCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOCCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOCCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOCCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOCCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOCCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOCCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOCCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOCCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOCCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOCCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOCCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOCCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOCCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOCCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOCCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOCCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOCCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOCCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOCCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOCCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOCCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOCCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOCCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOCCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOCCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOCCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOCCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOCCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOCCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOCCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOCCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOCCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1     = 0x1        // Bit G1_IO1.

	// IOGCSR: I/O group control status           register
	TSC_IOGCSR_G8S_Pos = 0x17     // Position of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000 // Bit mask of G8S field.
	TSC_IOGCSR_G8S     = 0x800000 // Bit G8S.
	TSC_IOGCSR_G7S_Pos = 0x16     // Position of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000 // Bit mask of G7S field.
	TSC_IOGCSR_G7S     = 0x400000 // Bit G7S.
	TSC_IOGCSR_G6S_Pos = 0x15     // Position of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000 // Bit mask of G6S field.
	TSC_IOGCSR_G6S     = 0x200000 // Bit G6S.
	TSC_IOGCSR_G5S_Pos = 0x14     // Position of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000 // Bit mask of G5S field.
	TSC_IOGCSR_G5S     = 0x100000 // Bit G5S.
	TSC_IOGCSR_G4S_Pos = 0x13     // Position of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000  // Bit mask of G4S field.
	TSC_IOGCSR_G4S     = 0x80000  // Bit G4S.
	TSC_IOGCSR_G3S_Pos = 0x12     // Position of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000  // Bit mask of G3S field.
	TSC_IOGCSR_G3S     = 0x40000  // Bit G3S.
	TSC_IOGCSR_G2S_Pos = 0x11     // Position of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000  // Bit mask of G2S field.
	TSC_IOGCSR_G2S     = 0x20000  // Bit G2S.
	TSC_IOGCSR_G1S_Pos = 0x10     // Position of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000  // Bit mask of G1S field.
	TSC_IOGCSR_G1S     = 0x10000  // Bit G1S.
	TSC_IOGCSR_G8E_Pos = 0x7      // Position of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80     // Bit mask of G8E field.
	TSC_IOGCSR_G8E     = 0x80     // Bit G8E.
	TSC_IOGCSR_G7E_Pos = 0x6      // Position of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40     // Bit mask of G7E field.
	TSC_IOGCSR_G7E     = 0x40     // Bit G7E.
	TSC_IOGCSR_G6E_Pos = 0x5      // Position of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20     // Bit mask of G6E field.
	TSC_IOGCSR_G6E     = 0x20     // Bit G6E.
	TSC_IOGCSR_G5E_Pos = 0x4      // Position of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10     // Bit mask of G5E field.
	TSC_IOGCSR_G5E     = 0x10     // Bit G5E.
	TSC_IOGCSR_G4E_Pos = 0x3      // Position of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8      // Bit mask of G4E field.
	TSC_IOGCSR_G4E     = 0x8      // Bit G4E.
	TSC_IOGCSR_G3E_Pos = 0x2      // Position of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4      // Bit mask of G3E field.
	TSC_IOGCSR_G3E     = 0x4      // Bit G3E.
	TSC_IOGCSR_G2E_Pos = 0x1      // Position of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2      // Bit mask of G2E field.
	TSC_IOGCSR_G2E     = 0x2      // Bit G2E.
	TSC_IOGCSR_G1E_Pos = 0x0      // Position of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1      // Bit mask of G1E field.
	TSC_IOGCSR_G1E     = 0x1      // Bit G1E.

	// IOG1CR: I/O group x counter register
	TSC_IOG1CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG1CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG2CR: I/O group x counter register
	TSC_IOG2CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG2CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG3CR: I/O group x counter register
	TSC_IOG3CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG3CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG4CR: I/O group x counter register
	TSC_IOG4CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG4CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG5CR: I/O group x counter register
	TSC_IOG5CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG5CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG6CR: I/O group x counter register
	TSC_IOG6CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG6CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG7CR: I/O group x counter register
	TSC_IOG7CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG7CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG8CR: I/O group x counter register
	TSC_IOG8CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG8CR_CNT_Msk = 0x3fff // Bit mask of CNT field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_WVU_Pos = 0x2 // Position of WVU field.
	IWDG_SR_WVU_Msk = 0x4 // Bit mask of WVU field.
	IWDG_SR_WVU     = 0x4 // Bit WVU.
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.

	// WINR: Window register
	IWDG_WINR_WIN_Pos = 0x0   // Position of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff // Bit mask of WIN field.
)

// Bitfields for WWDG: System window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos   = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk   = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI       = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB_Pos = 0x7   // Position of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180 // Bit mask of WDGTB field.
	WWDG_CFR_W_Pos     = 0x0   // Position of W field.
	WWDG_CFR_W_Msk     = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for COMP: Comparator
const (
	// COMP1_CSR: Comparator 1 control and status           register
	COMP_COMP1_CSR_COMP1_EN_Pos       = 0x0        // Position of COMP1_EN field.
	COMP_COMP1_CSR_COMP1_EN_Msk       = 0x1        // Bit mask of COMP1_EN field.
	COMP_COMP1_CSR_COMP1_EN           = 0x1        // Bit COMP1_EN.
	COMP_COMP1_CSR_COMP1_PWRMODE_Pos  = 0x2        // Position of COMP1_PWRMODE field.
	COMP_COMP1_CSR_COMP1_PWRMODE_Msk  = 0xc        // Bit mask of COMP1_PWRMODE field.
	COMP_COMP1_CSR_COMP1_INMSEL_Pos   = 0x4        // Position of COMP1_INMSEL field.
	COMP_COMP1_CSR_COMP1_INMSEL_Msk   = 0x70       // Bit mask of COMP1_INMSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL_Pos   = 0x7        // Position of COMP1_INPSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL_Msk   = 0x80       // Bit mask of COMP1_INPSEL field.
	COMP_COMP1_CSR_COMP1_INPSEL       = 0x80       // Bit COMP1_INPSEL.
	COMP_COMP1_CSR_COMP1_POLARITY_Pos = 0xf        // Position of COMP1_POLARITY field.
	COMP_COMP1_CSR_COMP1_POLARITY_Msk = 0x8000     // Bit mask of COMP1_POLARITY field.
	COMP_COMP1_CSR_COMP1_POLARITY     = 0x8000     // Bit COMP1_POLARITY.
	COMP_COMP1_CSR_COMP1_HYST_Pos     = 0x10       // Position of COMP1_HYST field.
	COMP_COMP1_CSR_COMP1_HYST_Msk     = 0x30000    // Bit mask of COMP1_HYST field.
	COMP_COMP1_CSR_COMP1_BLANKING_Pos = 0x12       // Position of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BLANKING_Msk = 0x1c0000   // Bit mask of COMP1_BLANKING field.
	COMP_COMP1_CSR_COMP1_BRGEN_Pos    = 0x16       // Position of COMP1_BRGEN field.
	COMP_COMP1_CSR_COMP1_BRGEN_Msk    = 0x400000   // Bit mask of COMP1_BRGEN field.
	COMP_COMP1_CSR_COMP1_BRGEN        = 0x400000   // Bit COMP1_BRGEN.
	COMP_COMP1_CSR_COMP1_SCALEN_Pos   = 0x17       // Position of COMP1_SCALEN field.
	COMP_COMP1_CSR_COMP1_SCALEN_Msk   = 0x800000   // Bit mask of COMP1_SCALEN field.
	COMP_COMP1_CSR_COMP1_SCALEN       = 0x800000   // Bit COMP1_SCALEN.
	COMP_COMP1_CSR_COMP1_VALUE_Pos    = 0x1e       // Position of COMP1_VALUE field.
	COMP_COMP1_CSR_COMP1_VALUE_Msk    = 0x40000000 // Bit mask of COMP1_VALUE field.
	COMP_COMP1_CSR_COMP1_VALUE        = 0x40000000 // Bit COMP1_VALUE.
	COMP_COMP1_CSR_COMP1_LOCK_Pos     = 0x1f       // Position of COMP1_LOCK field.
	COMP_COMP1_CSR_COMP1_LOCK_Msk     = 0x80000000 // Bit mask of COMP1_LOCK field.
	COMP_COMP1_CSR_COMP1_LOCK         = 0x80000000 // Bit COMP1_LOCK.

	// COMP2_CSR: Comparator 2 control and status           register
	COMP_COMP2_CSR_COMP2_EN_Pos       = 0x0        // Position of COMP2_EN field.
	COMP_COMP2_CSR_COMP2_EN_Msk       = 0x1        // Bit mask of COMP2_EN field.
	COMP_COMP2_CSR_COMP2_EN           = 0x1        // Bit COMP2_EN.
	COMP_COMP2_CSR_COMP2_PWRMODE_Pos  = 0x2        // Position of COMP2_PWRMODE field.
	COMP_COMP2_CSR_COMP2_PWRMODE_Msk  = 0xc        // Bit mask of COMP2_PWRMODE field.
	COMP_COMP2_CSR_COMP2_INMSEL_Pos   = 0x4        // Position of COMP2_INMSEL field.
	COMP_COMP2_CSR_COMP2_INMSEL_Msk   = 0x70       // Bit mask of COMP2_INMSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL_Pos   = 0x7        // Position of COMP2_INPSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL_Msk   = 0x80       // Bit mask of COMP2_INPSEL field.
	COMP_COMP2_CSR_COMP2_INPSEL       = 0x80       // Bit COMP2_INPSEL.
	COMP_COMP2_CSR_COMP2_WINMODE_Pos  = 0x9        // Position of COMP2_WINMODE field.
	COMP_COMP2_CSR_COMP2_WINMODE_Msk  = 0x200      // Bit mask of COMP2_WINMODE field.
	COMP_COMP2_CSR_COMP2_WINMODE      = 0x200      // Bit COMP2_WINMODE.
	COMP_COMP2_CSR_COMP2_POLARITY_Pos = 0xf        // Position of COMP2_POLARITY field.
	COMP_COMP2_CSR_COMP2_POLARITY_Msk = 0x8000     // Bit mask of COMP2_POLARITY field.
	COMP_COMP2_CSR_COMP2_POLARITY     = 0x8000     // Bit COMP2_POLARITY.
	COMP_COMP2_CSR_COMP2_HYST_Pos     = 0x10       // Position of COMP2_HYST field.
	COMP_COMP2_CSR_COMP2_HYST_Msk     = 0x30000    // Bit mask of COMP2_HYST field.
	COMP_COMP2_CSR_COMP2_BLANKING_Pos = 0x12       // Position of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BLANKING_Msk = 0x1c0000   // Bit mask of COMP2_BLANKING field.
	COMP_COMP2_CSR_COMP2_BRGEN_Pos    = 0x16       // Position of COMP2_BRGEN field.
	COMP_COMP2_CSR_COMP2_BRGEN_Msk    = 0x400000   // Bit mask of COMP2_BRGEN field.
	COMP_COMP2_CSR_COMP2_BRGEN        = 0x400000   // Bit COMP2_BRGEN.
	COMP_COMP2_CSR_COMP2_SCALEN_Pos   = 0x17       // Position of COMP2_SCALEN field.
	COMP_COMP2_CSR_COMP2_SCALEN_Msk   = 0x800000   // Bit mask of COMP2_SCALEN field.
	COMP_COMP2_CSR_COMP2_SCALEN       = 0x800000   // Bit COMP2_SCALEN.
	COMP_COMP2_CSR_COMP2_VALUE_Pos    = 0x1e       // Position of COMP2_VALUE field.
	COMP_COMP2_CSR_COMP2_VALUE_Msk    = 0x40000000 // Bit mask of COMP2_VALUE field.
	COMP_COMP2_CSR_COMP2_VALUE        = 0x40000000 // Bit COMP2_VALUE.
	COMP_COMP2_CSR_COMP2_LOCK_Pos     = 0x1f       // Position of COMP2_LOCK field.
	COMP_COMP2_CSR_COMP2_LOCK_Msk     = 0x80000000 // Bit mask of COMP2_LOCK field.
	COMP_COMP2_CSR_COMP2_LOCK         = 0x80000000 // Bit COMP2_LOCK.
)

// Bitfields for FIREWALL: Firewall
const (
	// CSSA: Code segment start address
	Firewall_CSSA_ADD_Pos = 0x8      // Position of ADD field.
	Firewall_CSSA_ADD_Msk = 0xffff00 // Bit mask of ADD field.

	// CSL: Code segment length
	Firewall_CSL_LENG_Pos = 0x8      // Position of LENG field.
	Firewall_CSL_LENG_Msk = 0x3fff00 // Bit mask of LENG field.

	// NVDSSA: Non-volatile data segment start           address
	Firewall_NVDSSA_ADD_Pos = 0x8      // Position of ADD field.
	Firewall_NVDSSA_ADD_Msk = 0xffff00 // Bit mask of ADD field.

	// NVDSL: Non-volatile data segment           length
	Firewall_NVDSL_LENG_Pos = 0x8      // Position of LENG field.
	Firewall_NVDSL_LENG_Msk = 0x3fff00 // Bit mask of LENG field.

	// VDSSA: Volatile data segment start           address
	Firewall_VDSSA_ADD_Pos = 0x6    // Position of ADD field.
	Firewall_VDSSA_ADD_Msk = 0xffc0 // Bit mask of ADD field.

	// VDSL: Volatile data segment length
	Firewall_VDSL_LENG_Pos = 0x6    // Position of LENG field.
	Firewall_VDSL_LENG_Msk = 0xffc0 // Bit mask of LENG field.

	// CR: Configuration register
	Firewall_CR_VDE_Pos = 0x2 // Position of VDE field.
	Firewall_CR_VDE_Msk = 0x4 // Bit mask of VDE field.
	Firewall_CR_VDE     = 0x4 // Bit VDE.
	Firewall_CR_VDS_Pos = 0x1 // Position of VDS field.
	Firewall_CR_VDS_Msk = 0x2 // Bit mask of VDS field.
	Firewall_CR_VDS     = 0x2 // Bit VDS.
	Firewall_CR_FPA_Pos = 0x0 // Position of FPA field.
	Firewall_CR_FPA_Msk = 0x1 // Bit mask of FPA field.
	Firewall_CR_FPA     = 0x1 // Bit FPA.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_PE_Pos        = 0x0      // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1      // Bit mask of PE field.
	I2C_CR1_PE            = 0x1      // Bit PE.
	I2C_CR1_TXIE_Pos      = 0x1      // Position of TXIE field.
	I2C_CR1_TXIE_Msk      = 0x2      // Bit mask of TXIE field.
	I2C_CR1_TXIE          = 0x2      // Bit TXIE.
	I2C_CR1_RXIE_Pos      = 0x2      // Position of RXIE field.
	I2C_CR1_RXIE_Msk      = 0x4      // Bit mask of RXIE field.
	I2C_CR1_RXIE          = 0x4      // Bit RXIE.
	I2C_CR1_ADDRIE_Pos    = 0x3      // Position of ADDRIE field.
	I2C_CR1_ADDRIE_Msk    = 0x8      // Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE        = 0x8      // Bit ADDRIE.
	I2C_CR1_NACKIE_Pos    = 0x4      // Position of NACKIE field.
	I2C_CR1_NACKIE_Msk    = 0x10     // Bit mask of NACKIE field.
	I2C_CR1_NACKIE        = 0x10     // Bit NACKIE.
	I2C_CR1_STOPIE_Pos    = 0x5      // Position of STOPIE field.
	I2C_CR1_STOPIE_Msk    = 0x20     // Bit mask of STOPIE field.
	I2C_CR1_STOPIE        = 0x20     // Bit STOPIE.
	I2C_CR1_TCIE_Pos      = 0x6      // Position of TCIE field.
	I2C_CR1_TCIE_Msk      = 0x40     // Bit mask of TCIE field.
	I2C_CR1_TCIE          = 0x40     // Bit TCIE.
	I2C_CR1_ERRIE_Pos     = 0x7      // Position of ERRIE field.
	I2C_CR1_ERRIE_Msk     = 0x80     // Bit mask of ERRIE field.
	I2C_CR1_ERRIE         = 0x80     // Bit ERRIE.
	I2C_CR1_DNF_Pos       = 0x8      // Position of DNF field.
	I2C_CR1_DNF_Msk       = 0xf00    // Bit mask of DNF field.
	I2C_CR1_ANFOFF_Pos    = 0xc      // Position of ANFOFF field.
	I2C_CR1_ANFOFF_Msk    = 0x1000   // Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF        = 0x1000   // Bit ANFOFF.
	I2C_CR1_TXDMAEN_Pos   = 0xe      // Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk   = 0x4000   // Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN       = 0x4000   // Bit TXDMAEN.
	I2C_CR1_RXDMAEN_Pos   = 0xf      // Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk   = 0x8000   // Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN       = 0x8000   // Bit RXDMAEN.
	I2C_CR1_SBC_Pos       = 0x10     // Position of SBC field.
	I2C_CR1_SBC_Msk       = 0x10000  // Bit mask of SBC field.
	I2C_CR1_SBC           = 0x10000  // Bit SBC.
	I2C_CR1_NOSTRETCH_Pos = 0x11     // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000  // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x20000  // Bit NOSTRETCH.
	I2C_CR1_WUPEN_Pos     = 0x12     // Position of WUPEN field.
	I2C_CR1_WUPEN_Msk     = 0x40000  // Bit mask of WUPEN field.
	I2C_CR1_WUPEN         = 0x40000  // Bit WUPEN.
	I2C_CR1_GCEN_Pos      = 0x13     // Position of GCEN field.
	I2C_CR1_GCEN_Msk      = 0x80000  // Bit mask of GCEN field.
	I2C_CR1_GCEN          = 0x80000  // Bit GCEN.
	I2C_CR1_SMBHEN_Pos    = 0x14     // Position of SMBHEN field.
	I2C_CR1_SMBHEN_Msk    = 0x100000 // Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN        = 0x100000 // Bit SMBHEN.
	I2C_CR1_SMBDEN_Pos    = 0x15     // Position of SMBDEN field.
	I2C_CR1_SMBDEN_Msk    = 0x200000 // Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN        = 0x200000 // Bit SMBDEN.
	I2C_CR1_ALERTEN_Pos   = 0x16     // Position of ALERTEN field.
	I2C_CR1_ALERTEN_Msk   = 0x400000 // Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN       = 0x400000 // Bit ALERTEN.
	I2C_CR1_PECEN_Pos     = 0x17     // Position of PECEN field.
	I2C_CR1_PECEN_Msk     = 0x800000 // Bit mask of PECEN field.
	I2C_CR1_PECEN         = 0x800000 // Bit PECEN.

	// CR2: Control register 2
	I2C_CR2_PECBYTE_Pos = 0x1a      // Position of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000 // Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE     = 0x4000000 // Bit PECBYTE.
	I2C_CR2_AUTOEND_Pos = 0x19      // Position of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000 // Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND     = 0x2000000 // Bit AUTOEND.
	I2C_CR2_RELOAD_Pos  = 0x18      // Position of RELOAD field.
	I2C_CR2_RELOAD_Msk  = 0x1000000 // Bit mask of RELOAD field.
	I2C_CR2_RELOAD      = 0x1000000 // Bit RELOAD.
	I2C_CR2_NBYTES_Pos  = 0x10      // Position of NBYTES field.
	I2C_CR2_NBYTES_Msk  = 0xff0000  // Bit mask of NBYTES field.
	I2C_CR2_NACK_Pos    = 0xf       // Position of NACK field.
	I2C_CR2_NACK_Msk    = 0x8000    // Bit mask of NACK field.
	I2C_CR2_NACK        = 0x8000    // Bit NACK.
	I2C_CR2_STOP_Pos    = 0xe       // Position of STOP field.
	I2C_CR2_STOP_Msk    = 0x4000    // Bit mask of STOP field.
	I2C_CR2_STOP        = 0x4000    // Bit STOP.
	I2C_CR2_START_Pos   = 0xd       // Position of START field.
	I2C_CR2_START_Msk   = 0x2000    // Bit mask of START field.
	I2C_CR2_START       = 0x2000    // Bit START.
	I2C_CR2_HEAD10R_Pos = 0xc       // Position of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000    // Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R     = 0x1000    // Bit HEAD10R.
	I2C_CR2_ADD10_Pos   = 0xb       // Position of ADD10 field.
	I2C_CR2_ADD10_Msk   = 0x800     // Bit mask of ADD10 field.
	I2C_CR2_ADD10       = 0x800     // Bit ADD10.
	I2C_CR2_RD_WRN_Pos  = 0xa       // Position of RD_WRN field.
	I2C_CR2_RD_WRN_Msk  = 0x400     // Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN      = 0x400     // Bit RD_WRN.
	I2C_CR2_SADD_Pos    = 0x0       // Position of SADD field.
	I2C_CR2_SADD_Msk    = 0x3ff     // Bit mask of SADD field.

	// OAR1: Own address register 1
	I2C_OAR1_OA1_Pos     = 0x0    // Position of OA1 field.
	I2C_OAR1_OA1_Msk     = 0x3ff  // Bit mask of OA1 field.
	I2C_OAR1_OA1MODE_Pos = 0xa    // Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400  // Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE     = 0x400  // Bit OA1MODE.
	I2C_OAR1_OA1EN_Pos   = 0xf    // Position of OA1EN field.
	I2C_OAR1_OA1EN_Msk   = 0x8000 // Bit mask of OA1EN field.
	I2C_OAR1_OA1EN       = 0x8000 // Bit OA1EN.

	// OAR2: Own address register 2
	I2C_OAR2_OA2_Pos    = 0x1    // Position of OA2 field.
	I2C_OAR2_OA2_Msk    = 0xfe   // Bit mask of OA2 field.
	I2C_OAR2_OA2MSK_Pos = 0x8    // Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700  // Bit mask of OA2MSK field.
	I2C_OAR2_OA2EN_Pos  = 0xf    // Position of OA2EN field.
	I2C_OAR2_OA2EN_Msk  = 0x8000 // Bit mask of OA2EN field.
	I2C_OAR2_OA2EN      = 0x8000 // Bit OA2EN.

	// TIMINGR: Timing register
	I2C_TIMINGR_SCLL_Pos   = 0x0        // Position of SCLL field.
	I2C_TIMINGR_SCLL_Msk   = 0xff       // Bit mask of SCLL field.
	I2C_TIMINGR_SCLH_Pos   = 0x8        // Position of SCLH field.
	I2C_TIMINGR_SCLH_Msk   = 0xff00     // Bit mask of SCLH field.
	I2C_TIMINGR_SDADEL_Pos = 0x10       // Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000    // Bit mask of SDADEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14       // Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000   // Bit mask of SCLDEL field.
	I2C_TIMINGR_PRESC_Pos  = 0x1c       // Position of PRESC field.
	I2C_TIMINGR_PRESC_Msk  = 0xf0000000 // Bit mask of PRESC field.

	// TIMEOUTR: Status register 1
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0        // Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff      // Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIDLE_Pos    = 0xc        // Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk    = 0x1000     // Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE        = 0x1000     // Bit TIDLE.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf        // Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000     // Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN     = 0x8000     // Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10       // Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000  // Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TEXTEN_Pos   = 0x1f       // Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk   = 0x80000000 // Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN       = 0x80000000 // Bit TEXTEN.

	// ISR: Interrupt and Status register
	I2C_ISR_ADDCODE_Pos = 0x11     // Position of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000 // Bit mask of ADDCODE field.
	I2C_ISR_DIR_Pos     = 0x10     // Position of DIR field.
	I2C_ISR_DIR_Msk     = 0x10000  // Bit mask of DIR field.
	I2C_ISR_DIR         = 0x10000  // Bit DIR.
	I2C_ISR_BUSY_Pos    = 0xf      // Position of BUSY field.
	I2C_ISR_BUSY_Msk    = 0x8000   // Bit mask of BUSY field.
	I2C_ISR_BUSY        = 0x8000   // Bit BUSY.
	I2C_ISR_ALERT_Pos   = 0xd      // Position of ALERT field.
	I2C_ISR_ALERT_Msk   = 0x2000   // Bit mask of ALERT field.
	I2C_ISR_ALERT       = 0x2000   // Bit ALERT.
	I2C_ISR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000   // Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT     = 0x1000   // Bit TIMEOUT.
	I2C_ISR_PECERR_Pos  = 0xb      // Position of PECERR field.
	I2C_ISR_PECERR_Msk  = 0x800    // Bit mask of PECERR field.
	I2C_ISR_PECERR      = 0x800    // Bit PECERR.
	I2C_ISR_OVR_Pos     = 0xa      // Position of OVR field.
	I2C_ISR_OVR_Msk     = 0x400    // Bit mask of OVR field.
	I2C_ISR_OVR         = 0x400    // Bit OVR.
	I2C_ISR_ARLO_Pos    = 0x9      // Position of ARLO field.
	I2C_ISR_ARLO_Msk    = 0x200    // Bit mask of ARLO field.
	I2C_ISR_ARLO        = 0x200    // Bit ARLO.
	I2C_ISR_BERR_Pos    = 0x8      // Position of BERR field.
	I2C_ISR_BERR_Msk    = 0x100    // Bit mask of BERR field.
	I2C_ISR_BERR        = 0x100    // Bit BERR.
	I2C_ISR_TCR_Pos     = 0x7      // Position of TCR field.
	I2C_ISR_TCR_Msk     = 0x80     // Bit mask of TCR field.
	I2C_ISR_TCR         = 0x80     // Bit TCR.
	I2C_ISR_TC_Pos      = 0x6      // Position of TC field.
	I2C_ISR_TC_Msk      = 0x40     // Bit mask of TC field.
	I2C_ISR_TC          = 0x40     // Bit TC.
	I2C_ISR_STOPF_Pos   = 0x5      // Position of STOPF field.
	I2C_ISR_STOPF_Msk   = 0x20     // Bit mask of STOPF field.
	I2C_ISR_STOPF       = 0x20     // Bit STOPF.
	I2C_ISR_NACKF_Pos   = 0x4      // Position of NACKF field.
	I2C_ISR_NACKF_Msk   = 0x10     // Bit mask of NACKF field.
	I2C_ISR_NACKF       = 0x10     // Bit NACKF.
	I2C_ISR_ADDR_Pos    = 0x3      // Position of ADDR field.
	I2C_ISR_ADDR_Msk    = 0x8      // Bit mask of ADDR field.
	I2C_ISR_ADDR        = 0x8      // Bit ADDR.
	I2C_ISR_RXNE_Pos    = 0x2      // Position of RXNE field.
	I2C_ISR_RXNE_Msk    = 0x4      // Bit mask of RXNE field.
	I2C_ISR_RXNE        = 0x4      // Bit RXNE.
	I2C_ISR_TXIS_Pos    = 0x1      // Position of TXIS field.
	I2C_ISR_TXIS_Msk    = 0x2      // Bit mask of TXIS field.
	I2C_ISR_TXIS        = 0x2      // Bit TXIS.
	I2C_ISR_TXE_Pos     = 0x0      // Position of TXE field.
	I2C_ISR_TXE_Msk     = 0x1      // Bit mask of TXE field.
	I2C_ISR_TXE         = 0x1      // Bit TXE.

	// ICR: Interrupt clear register
	I2C_ICR_ALERTCF_Pos  = 0xd    // Position of ALERTCF field.
	I2C_ICR_ALERTCF_Msk  = 0x2000 // Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF      = 0x2000 // Bit ALERTCF.
	I2C_ICR_TIMOUTCF_Pos = 0xc    // Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000 // Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF     = 0x1000 // Bit TIMOUTCF.
	I2C_ICR_PECCF_Pos    = 0xb    // Position of PECCF field.
	I2C_ICR_PECCF_Msk    = 0x800  // Bit mask of PECCF field.
	I2C_ICR_PECCF        = 0x800  // Bit PECCF.
	I2C_ICR_OVRCF_Pos    = 0xa    // Position of OVRCF field.
	I2C_ICR_OVRCF_Msk    = 0x400  // Bit mask of OVRCF field.
	I2C_ICR_OVRCF        = 0x400  // Bit OVRCF.
	I2C_ICR_ARLOCF_Pos   = 0x9    // Position of ARLOCF field.
	I2C_ICR_ARLOCF_Msk   = 0x200  // Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF       = 0x200  // Bit ARLOCF.
	I2C_ICR_BERRCF_Pos   = 0x8    // Position of BERRCF field.
	I2C_ICR_BERRCF_Msk   = 0x100  // Bit mask of BERRCF field.
	I2C_ICR_BERRCF       = 0x100  // Bit BERRCF.
	I2C_ICR_STOPCF_Pos   = 0x5    // Position of STOPCF field.
	I2C_ICR_STOPCF_Msk   = 0x20   // Bit mask of STOPCF field.
	I2C_ICR_STOPCF       = 0x20   // Bit STOPCF.
	I2C_ICR_NACKCF_Pos   = 0x4    // Position of NACKCF field.
	I2C_ICR_NACKCF_Msk   = 0x10   // Bit mask of NACKCF field.
	I2C_ICR_NACKCF       = 0x10   // Bit NACKCF.
	I2C_ICR_ADDRCF_Pos   = 0x3    // Position of ADDRCF field.
	I2C_ICR_ADDRCF_Msk   = 0x8    // Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF       = 0x8    // Bit ADDRCF.

	// PECR: PEC register
	I2C_PECR_PEC_Pos = 0x0  // Position of PEC field.
	I2C_PECR_PEC_Msk = 0xff // Bit mask of PEC field.

	// RXDR: Receive data register
	I2C_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// TXDR: Transmit data register
	I2C_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for FLASH: Flash
const (
	// ACR: Access control register
	Flash_ACR_LATENCY_Pos  = 0x0    // Position of LATENCY field.
	Flash_ACR_LATENCY_Msk  = 0x7    // Bit mask of LATENCY field.
	Flash_ACR_PRFTEN_Pos   = 0x8    // Position of PRFTEN field.
	Flash_ACR_PRFTEN_Msk   = 0x100  // Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN       = 0x100  // Bit PRFTEN.
	Flash_ACR_ICEN_Pos     = 0x9    // Position of ICEN field.
	Flash_ACR_ICEN_Msk     = 0x200  // Bit mask of ICEN field.
	Flash_ACR_ICEN         = 0x200  // Bit ICEN.
	Flash_ACR_DCEN_Pos     = 0xa    // Position of DCEN field.
	Flash_ACR_DCEN_Msk     = 0x400  // Bit mask of DCEN field.
	Flash_ACR_DCEN         = 0x400  // Bit DCEN.
	Flash_ACR_ICRST_Pos    = 0xb    // Position of ICRST field.
	Flash_ACR_ICRST_Msk    = 0x800  // Bit mask of ICRST field.
	Flash_ACR_ICRST        = 0x800  // Bit ICRST.
	Flash_ACR_DCRST_Pos    = 0xc    // Position of DCRST field.
	Flash_ACR_DCRST_Msk    = 0x1000 // Bit mask of DCRST field.
	Flash_ACR_DCRST        = 0x1000 // Bit DCRST.
	Flash_ACR_RUN_PD_Pos   = 0xd    // Position of RUN_PD field.
	Flash_ACR_RUN_PD_Msk   = 0x2000 // Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD       = 0x2000 // Bit RUN_PD.
	Flash_ACR_SLEEP_PD_Pos = 0xe    // Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk = 0x4000 // Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD     = 0x4000 // Bit SLEEP_PD.

	// PDKEYR: Power down key register
	Flash_PDKEYR_PDKEYR_Pos = 0x0        // Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff // Bit mask of PDKEYR field.

	// KEYR: Flash key register
	Flash_KEYR_KEYR_Pos = 0x0        // Position of KEYR field.
	Flash_KEYR_KEYR_Msk = 0xffffffff // Bit mask of KEYR field.

	// OPTKEYR: Option byte key register
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// SR: Status register
	Flash_SR_EOP_Pos     = 0x0     // Position of EOP field.
	Flash_SR_EOP_Msk     = 0x1     // Bit mask of EOP field.
	Flash_SR_EOP         = 0x1     // Bit EOP.
	Flash_SR_OPERR_Pos   = 0x1     // Position of OPERR field.
	Flash_SR_OPERR_Msk   = 0x2     // Bit mask of OPERR field.
	Flash_SR_OPERR       = 0x2     // Bit OPERR.
	Flash_SR_PROGERR_Pos = 0x3     // Position of PROGERR field.
	Flash_SR_PROGERR_Msk = 0x8     // Bit mask of PROGERR field.
	Flash_SR_PROGERR     = 0x8     // Bit PROGERR.
	Flash_SR_WRPERR_Pos  = 0x4     // Position of WRPERR field.
	Flash_SR_WRPERR_Msk  = 0x10    // Bit mask of WRPERR field.
	Flash_SR_WRPERR      = 0x10    // Bit WRPERR.
	Flash_SR_PGAERR_Pos  = 0x5     // Position of PGAERR field.
	Flash_SR_PGAERR_Msk  = 0x20    // Bit mask of PGAERR field.
	Flash_SR_PGAERR      = 0x20    // Bit PGAERR.
	Flash_SR_SIZERR_Pos  = 0x6     // Position of SIZERR field.
	Flash_SR_SIZERR_Msk  = 0x40    // Bit mask of SIZERR field.
	Flash_SR_SIZERR      = 0x40    // Bit SIZERR.
	Flash_SR_PGSERR_Pos  = 0x7     // Position of PGSERR field.
	Flash_SR_PGSERR_Msk  = 0x80    // Bit mask of PGSERR field.
	Flash_SR_PGSERR      = 0x80    // Bit PGSERR.
	Flash_SR_MISERR_Pos  = 0x8     // Position of MISERR field.
	Flash_SR_MISERR_Msk  = 0x100   // Bit mask of MISERR field.
	Flash_SR_MISERR      = 0x100   // Bit MISERR.
	Flash_SR_FASTERR_Pos = 0x9     // Position of FASTERR field.
	Flash_SR_FASTERR_Msk = 0x200   // Bit mask of FASTERR field.
	Flash_SR_FASTERR     = 0x200   // Bit FASTERR.
	Flash_SR_RDERR_Pos   = 0xe     // Position of RDERR field.
	Flash_SR_RDERR_Msk   = 0x4000  // Bit mask of RDERR field.
	Flash_SR_RDERR       = 0x4000  // Bit RDERR.
	Flash_SR_OPTVERR_Pos = 0xf     // Position of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x8000  // Bit mask of OPTVERR field.
	Flash_SR_OPTVERR     = 0x8000  // Bit OPTVERR.
	Flash_SR_BSY_Pos     = 0x10    // Position of BSY field.
	Flash_SR_BSY_Msk     = 0x10000 // Bit mask of BSY field.
	Flash_SR_BSY         = 0x10000 // Bit BSY.

	// CR: Flash control register
	Flash_CR_PG_Pos         = 0x0        // Position of PG field.
	Flash_CR_PG_Msk         = 0x1        // Bit mask of PG field.
	Flash_CR_PG             = 0x1        // Bit PG.
	Flash_CR_PER_Pos        = 0x1        // Position of PER field.
	Flash_CR_PER_Msk        = 0x2        // Bit mask of PER field.
	Flash_CR_PER            = 0x2        // Bit PER.
	Flash_CR_MER1_Pos       = 0x2        // Position of MER1 field.
	Flash_CR_MER1_Msk       = 0x4        // Bit mask of MER1 field.
	Flash_CR_MER1           = 0x4        // Bit MER1.
	Flash_CR_PNB_Pos        = 0x3        // Position of PNB field.
	Flash_CR_PNB_Msk        = 0x7f8      // Bit mask of PNB field.
	Flash_CR_BKER_Pos       = 0xb        // Position of BKER field.
	Flash_CR_BKER_Msk       = 0x800      // Bit mask of BKER field.
	Flash_CR_BKER           = 0x800      // Bit BKER.
	Flash_CR_MER2_Pos       = 0xf        // Position of MER2 field.
	Flash_CR_MER2_Msk       = 0x8000     // Bit mask of MER2 field.
	Flash_CR_MER2           = 0x8000     // Bit MER2.
	Flash_CR_START_Pos      = 0x10       // Position of START field.
	Flash_CR_START_Msk      = 0x10000    // Bit mask of START field.
	Flash_CR_START          = 0x10000    // Bit START.
	Flash_CR_OPTSTRT_Pos    = 0x11       // Position of OPTSTRT field.
	Flash_CR_OPTSTRT_Msk    = 0x20000    // Bit mask of OPTSTRT field.
	Flash_CR_OPTSTRT        = 0x20000    // Bit OPTSTRT.
	Flash_CR_FSTPG_Pos      = 0x12       // Position of FSTPG field.
	Flash_CR_FSTPG_Msk      = 0x40000    // Bit mask of FSTPG field.
	Flash_CR_FSTPG          = 0x40000    // Bit FSTPG.
	Flash_CR_EOPIE_Pos      = 0x18       // Position of EOPIE field.
	Flash_CR_EOPIE_Msk      = 0x1000000  // Bit mask of EOPIE field.
	Flash_CR_EOPIE          = 0x1000000  // Bit EOPIE.
	Flash_CR_ERRIE_Pos      = 0x19       // Position of ERRIE field.
	Flash_CR_ERRIE_Msk      = 0x2000000  // Bit mask of ERRIE field.
	Flash_CR_ERRIE          = 0x2000000  // Bit ERRIE.
	Flash_CR_RDERRIE_Pos    = 0x1a       // Position of RDERRIE field.
	Flash_CR_RDERRIE_Msk    = 0x4000000  // Bit mask of RDERRIE field.
	Flash_CR_RDERRIE        = 0x4000000  // Bit RDERRIE.
	Flash_CR_OBL_LAUNCH_Pos = 0x1b       // Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x8000000  // Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH     = 0x8000000  // Bit OBL_LAUNCH.
	Flash_CR_OPTLOCK_Pos    = 0x1e       // Position of OPTLOCK field.
	Flash_CR_OPTLOCK_Msk    = 0x40000000 // Bit mask of OPTLOCK field.
	Flash_CR_OPTLOCK        = 0x40000000 // Bit OPTLOCK.
	Flash_CR_LOCK_Pos       = 0x1f       // Position of LOCK field.
	Flash_CR_LOCK_Msk       = 0x80000000 // Bit mask of LOCK field.
	Flash_CR_LOCK           = 0x80000000 // Bit LOCK.

	// ECCR: Flash ECC register
	Flash_ECCR_ADDR_ECC_Pos = 0x0        // Position of ADDR_ECC field.
	Flash_ECCR_ADDR_ECC_Msk = 0x7ffff    // Bit mask of ADDR_ECC field.
	Flash_ECCR_BK_ECC_Pos   = 0x13       // Position of BK_ECC field.
	Flash_ECCR_BK_ECC_Msk   = 0x80000    // Bit mask of BK_ECC field.
	Flash_ECCR_BK_ECC       = 0x80000    // Bit BK_ECC.
	Flash_ECCR_SYSF_ECC_Pos = 0x14       // Position of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC_Msk = 0x100000   // Bit mask of SYSF_ECC field.
	Flash_ECCR_SYSF_ECC     = 0x100000   // Bit SYSF_ECC.
	Flash_ECCR_ECCIE_Pos    = 0x18       // Position of ECCIE field.
	Flash_ECCR_ECCIE_Msk    = 0x1000000  // Bit mask of ECCIE field.
	Flash_ECCR_ECCIE        = 0x1000000  // Bit ECCIE.
	Flash_ECCR_ECCC_Pos     = 0x1e       // Position of ECCC field.
	Flash_ECCR_ECCC_Msk     = 0x40000000 // Bit mask of ECCC field.
	Flash_ECCR_ECCC         = 0x40000000 // Bit ECCC.
	Flash_ECCR_ECCD_Pos     = 0x1f       // Position of ECCD field.
	Flash_ECCR_ECCD_Msk     = 0x80000000 // Bit mask of ECCD field.
	Flash_ECCR_ECCD         = 0x80000000 // Bit ECCD.

	// OPTR: Flash option register
	Flash_OPTR_RDP_Pos        = 0x0       // Position of RDP field.
	Flash_OPTR_RDP_Msk        = 0xff      // Bit mask of RDP field.
	Flash_OPTR_BOR_LEV_Pos    = 0x8       // Position of BOR_LEV field.
	Flash_OPTR_BOR_LEV_Msk    = 0x700     // Bit mask of BOR_LEV field.
	Flash_OPTR_NRST_STOP_Pos  = 0xc       // Position of NRST_STOP field.
	Flash_OPTR_NRST_STOP_Msk  = 0x1000    // Bit mask of NRST_STOP field.
	Flash_OPTR_NRST_STOP      = 0x1000    // Bit NRST_STOP.
	Flash_OPTR_NRST_STDBY_Pos = 0xd       // Position of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY_Msk = 0x2000    // Bit mask of NRST_STDBY field.
	Flash_OPTR_NRST_STDBY     = 0x2000    // Bit NRST_STDBY.
	Flash_OPTR_IDWG_SW_Pos    = 0x10      // Position of IDWG_SW field.
	Flash_OPTR_IDWG_SW_Msk    = 0x10000   // Bit mask of IDWG_SW field.
	Flash_OPTR_IDWG_SW        = 0x10000   // Bit IDWG_SW.
	Flash_OPTR_IWDG_STOP_Pos  = 0x11      // Position of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP_Msk  = 0x20000   // Bit mask of IWDG_STOP field.
	Flash_OPTR_IWDG_STOP      = 0x20000   // Bit IWDG_STOP.
	Flash_OPTR_IWDG_STDBY_Pos = 0x12      // Position of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY_Msk = 0x40000   // Bit mask of IWDG_STDBY field.
	Flash_OPTR_IWDG_STDBY     = 0x40000   // Bit IWDG_STDBY.
	Flash_OPTR_WWDG_SW_Pos    = 0x13      // Position of WWDG_SW field.
	Flash_OPTR_WWDG_SW_Msk    = 0x80000   // Bit mask of WWDG_SW field.
	Flash_OPTR_WWDG_SW        = 0x80000   // Bit WWDG_SW.
	Flash_OPTR_BFB2_Pos       = 0x14      // Position of BFB2 field.
	Flash_OPTR_BFB2_Msk       = 0x100000  // Bit mask of BFB2 field.
	Flash_OPTR_BFB2           = 0x100000  // Bit BFB2.
	Flash_OPTR_DUALBANK_Pos   = 0x15      // Position of DUALBANK field.
	Flash_OPTR_DUALBANK_Msk   = 0x200000  // Bit mask of DUALBANK field.
	Flash_OPTR_DUALBANK       = 0x200000  // Bit DUALBANK.
	Flash_OPTR_NBOOT1_Pos     = 0x17      // Position of NBOOT1 field.
	Flash_OPTR_NBOOT1_Msk     = 0x800000  // Bit mask of NBOOT1 field.
	Flash_OPTR_NBOOT1         = 0x800000  // Bit NBOOT1.
	Flash_OPTR_SRAM2_PE_Pos   = 0x18      // Position of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE_Msk   = 0x1000000 // Bit mask of SRAM2_PE field.
	Flash_OPTR_SRAM2_PE       = 0x1000000 // Bit SRAM2_PE.
	Flash_OPTR_SRAM2_RST_Pos  = 0x19      // Position of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST_Msk  = 0x2000000 // Bit mask of SRAM2_RST field.
	Flash_OPTR_SRAM2_RST      = 0x2000000 // Bit SRAM2_RST.

	// PCROP1SR: Flash Bank 1 PCROP Start address           register
	Flash_PCROP1SR_PCROP1_STRT_Pos = 0x0    // Position of PCROP1_STRT field.
	Flash_PCROP1SR_PCROP1_STRT_Msk = 0xffff // Bit mask of PCROP1_STRT field.

	// PCROP1ER: Flash Bank 1 PCROP End address           register
	Flash_PCROP1ER_PCROP1_END_Pos = 0x0        // Position of PCROP1_END field.
	Flash_PCROP1ER_PCROP1_END_Msk = 0xffff     // Bit mask of PCROP1_END field.
	Flash_PCROP1ER_PCROP_RDP_Pos  = 0x1f       // Position of PCROP_RDP field.
	Flash_PCROP1ER_PCROP_RDP_Msk  = 0x80000000 // Bit mask of PCROP_RDP field.
	Flash_PCROP1ER_PCROP_RDP      = 0x80000000 // Bit PCROP_RDP.

	// WRP1AR: Flash Bank 1 WRP area A address           register
	Flash_WRP1AR_WRP1A_STRT_Pos = 0x0      // Position of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_STRT_Msk = 0xff     // Bit mask of WRP1A_STRT field.
	Flash_WRP1AR_WRP1A_END_Pos  = 0x10     // Position of WRP1A_END field.
	Flash_WRP1AR_WRP1A_END_Msk  = 0xff0000 // Bit mask of WRP1A_END field.

	// WRP1BR: Flash Bank 1 WRP area B address           register
	Flash_WRP1BR_WRP1B_STRT_Pos = 0x10     // Position of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_STRT_Msk = 0xff0000 // Bit mask of WRP1B_STRT field.
	Flash_WRP1BR_WRP1B_END_Pos  = 0x0      // Position of WRP1B_END field.
	Flash_WRP1BR_WRP1B_END_Msk  = 0xff     // Bit mask of WRP1B_END field.

	// PCROP2SR: Flash Bank 2 PCROP Start address           register
	Flash_PCROP2SR_PCROP2_STRT_Pos = 0x0    // Position of PCROP2_STRT field.
	Flash_PCROP2SR_PCROP2_STRT_Msk = 0xffff // Bit mask of PCROP2_STRT field.

	// PCROP2ER: Flash Bank 2 PCROP End address           register
	Flash_PCROP2ER_PCROP2_END_Pos = 0x0    // Position of PCROP2_END field.
	Flash_PCROP2ER_PCROP2_END_Msk = 0xffff // Bit mask of PCROP2_END field.

	// WRP2AR: Flash Bank 2 WRP area A address           register
	Flash_WRP2AR_WRP2A_STRT_Pos = 0x0      // Position of WRP2A_STRT field.
	Flash_WRP2AR_WRP2A_STRT_Msk = 0xff     // Bit mask of WRP2A_STRT field.
	Flash_WRP2AR_WRP2A_END_Pos  = 0x10     // Position of WRP2A_END field.
	Flash_WRP2AR_WRP2A_END_Msk  = 0xff0000 // Bit mask of WRP2A_END field.

	// WRP2BR: Flash Bank 2 WRP area B address           register
	Flash_WRP2BR_WRP2B_STRT_Pos = 0x0      // Position of WRP2B_STRT field.
	Flash_WRP2BR_WRP2B_STRT_Msk = 0xff     // Bit mask of WRP2B_STRT field.
	Flash_WRP2BR_WRP2B_END_Pos  = 0x10     // Position of WRP2B_END field.
	Flash_WRP2BR_WRP2B_END_Msk  = 0xff0000 // Bit mask of WRP2B_END field.
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xffff     // Bit mask of DEV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// CR: Debug MCU Configuration           Register
	DBGMCU_CR_DBG_SLEEP_Pos   = 0x0  // Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk   = 0x1  // Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP       = 0x1  // Bit DBG_SLEEP.
	DBGMCU_CR_DBG_STOP_Pos    = 0x1  // Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk    = 0x2  // Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP        = 0x2  // Bit DBG_STOP.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2  // Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4  // Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY     = 0x4  // Bit DBG_STANDBY.
	DBGMCU_CR_TRACE_IOEN_Pos  = 0x5  // Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk  = 0x20 // Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN      = 0x20 // Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_MODE_Pos  = 0x6  // Position of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Msk  = 0xc0 // Bit mask of TRACE_MODE field.

	// APB1_FZR1: APB Low Freeze Register 1
	DBGMCU_APB1_FZR1_DBG_TIMER2_STOP_Pos  = 0x0        // Position of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER2_STOP_Msk  = 0x1        // Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER2_STOP      = 0x1        // Bit DBG_TIMER2_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM3_STOP_Pos    = 0x1        // Position of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM3_STOP_Msk    = 0x2        // Bit mask of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM3_STOP        = 0x2        // Bit DBG_TIM3_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM4_STOP_Pos    = 0x2        // Position of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM4_STOP_Msk    = 0x4        // Bit mask of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM4_STOP        = 0x4        // Bit DBG_TIM4_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM5_STOP_Pos    = 0x3        // Position of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM5_STOP_Msk    = 0x8        // Bit mask of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM5_STOP        = 0x8        // Bit DBG_TIM5_STOP.
	DBGMCU_APB1_FZR1_DBG_TIMER6_STOP_Pos  = 0x4        // Position of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER6_STOP_Msk  = 0x10       // Bit mask of DBG_TIMER6_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIMER6_STOP      = 0x10       // Bit DBG_TIMER6_STOP.
	DBGMCU_APB1_FZR1_DBG_TIM7_STOP_Pos    = 0x5        // Position of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM7_STOP_Msk    = 0x20       // Bit mask of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZR1_DBG_TIM7_STOP        = 0x20       // Bit DBG_TIM7_STOP.
	DBGMCU_APB1_FZR1_DBG_RTC_STOP_Pos     = 0xa        // Position of DBG_RTC_STOP field.
	DBGMCU_APB1_FZR1_DBG_RTC_STOP_Msk     = 0x400      // Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1_FZR1_DBG_RTC_STOP         = 0x400      // Bit DBG_RTC_STOP.
	DBGMCU_APB1_FZR1_DBG_WWDG_STOP_Pos    = 0xb        // Position of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_WWDG_STOP_Msk    = 0x800      // Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_WWDG_STOP        = 0x800      // Bit DBG_WWDG_STOP.
	DBGMCU_APB1_FZR1_DBG_IWDG_STOP_Pos    = 0xc        // Position of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_IWDG_STOP_Msk    = 0x1000     // Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZR1_DBG_IWDG_STOP        = 0x1000     // Bit DBG_IWDG_STOP.
	DBGMCU_APB1_FZR1_DBG_I2C1_STOP_Pos    = 0x15       // Position of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C1_STOP_Msk    = 0x200000   // Bit mask of DBG_I2C1_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C1_STOP        = 0x200000   // Bit DBG_I2C1_STOP.
	DBGMCU_APB1_FZR1_DBG_I2C2_STOP_Pos    = 0x16       // Position of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C2_STOP_Msk    = 0x400000   // Bit mask of DBG_I2C2_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C2_STOP        = 0x400000   // Bit DBG_I2C2_STOP.
	DBGMCU_APB1_FZR1_DBG_I2C3_STOP_Pos    = 0x17       // Position of DBG_I2C3_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C3_STOP_Msk    = 0x800000   // Bit mask of DBG_I2C3_STOP field.
	DBGMCU_APB1_FZR1_DBG_I2C3_STOP        = 0x800000   // Bit DBG_I2C3_STOP.
	DBGMCU_APB1_FZR1_DBG_CAN_STOP_Pos     = 0x19       // Position of DBG_CAN_STOP field.
	DBGMCU_APB1_FZR1_DBG_CAN_STOP_Msk     = 0x2000000  // Bit mask of DBG_CAN_STOP field.
	DBGMCU_APB1_FZR1_DBG_CAN_STOP         = 0x2000000  // Bit DBG_CAN_STOP.
	DBGMCU_APB1_FZR1_DBG_LPTIMER_STOP_Pos = 0x1f       // Position of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZR1_DBG_LPTIMER_STOP_Msk = 0x80000000 // Bit mask of DBG_LPTIMER_STOP field.
	DBGMCU_APB1_FZR1_DBG_LPTIMER_STOP     = 0x80000000 // Bit DBG_LPTIMER_STOP.

	// APB1_FZR2: APB Low Freeze Register 2
	DBGMCU_APB1_FZR2_DBG_LPTIM2_STOP_Pos = 0x5  // Position of DBG_LPTIM2_STOP field.
	DBGMCU_APB1_FZR2_DBG_LPTIM2_STOP_Msk = 0x20 // Bit mask of DBG_LPTIM2_STOP field.
	DBGMCU_APB1_FZR2_DBG_LPTIM2_STOP     = 0x20 // Bit DBG_LPTIM2_STOP.

	// APB2_FZR: APB High Freeze Register
	DBGMCU_APB2_FZR_DBG_TIM1_STOP_Pos  = 0xb     // Position of DBG_TIM1_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM1_STOP_Msk  = 0x800   // Bit mask of DBG_TIM1_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM1_STOP      = 0x800   // Bit DBG_TIM1_STOP.
	DBGMCU_APB2_FZR_DBG_TIM8_STOP_Pos  = 0xd     // Position of DBG_TIM8_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM8_STOP_Msk  = 0x2000  // Bit mask of DBG_TIM8_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM8_STOP      = 0x2000  // Bit DBG_TIM8_STOP.
	DBGMCU_APB2_FZR_DBG_TIM15_STOP_Pos = 0x10    // Position of DBG_TIM15_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM15_STOP_Msk = 0x10000 // Bit mask of DBG_TIM15_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM15_STOP     = 0x10000 // Bit DBG_TIM15_STOP.
	DBGMCU_APB2_FZR_DBG_TIM16_STOP_Pos = 0x11    // Position of DBG_TIM16_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM16_STOP_Msk = 0x20000 // Bit mask of DBG_TIM16_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM16_STOP     = 0x20000 // Bit DBG_TIM16_STOP.
	DBGMCU_APB2_FZR_DBG_TIM17_STOP_Pos = 0x12    // Position of DBG_TIM17_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM17_STOP_Msk = 0x40000 // Bit mask of DBG_TIM17_STOP field.
	DBGMCU_APB2_FZR_DBG_TIM17_STOP     = 0x40000 // Bit DBG_TIM17_STOP.
)

// Bitfields for OCTOSPI1: OctoSPI
const (
	// CR: control register
	OctoSPI_CR_FMODE_Pos  = 0x1c       // Position of FMODE field.
	OctoSPI_CR_FMODE_Msk  = 0x30000000 // Bit mask of FMODE field.
	OctoSPI_CR_PMM_Pos    = 0x17       // Position of PMM field.
	OctoSPI_CR_PMM_Msk    = 0x800000   // Bit mask of PMM field.
	OctoSPI_CR_PMM        = 0x800000   // Bit PMM.
	OctoSPI_CR_APMS_Pos   = 0x16       // Position of APMS field.
	OctoSPI_CR_APMS_Msk   = 0x400000   // Bit mask of APMS field.
	OctoSPI_CR_APMS       = 0x400000   // Bit APMS.
	OctoSPI_CR_TOIE_Pos   = 0x14       // Position of TOIE field.
	OctoSPI_CR_TOIE_Msk   = 0x100000   // Bit mask of TOIE field.
	OctoSPI_CR_TOIE       = 0x100000   // Bit TOIE.
	OctoSPI_CR_SMIE_Pos   = 0x13       // Position of SMIE field.
	OctoSPI_CR_SMIE_Msk   = 0x80000    // Bit mask of SMIE field.
	OctoSPI_CR_SMIE       = 0x80000    // Bit SMIE.
	OctoSPI_CR_FTIE_Pos   = 0x12       // Position of FTIE field.
	OctoSPI_CR_FTIE_Msk   = 0x40000    // Bit mask of FTIE field.
	OctoSPI_CR_FTIE       = 0x40000    // Bit FTIE.
	OctoSPI_CR_TCIE_Pos   = 0x11       // Position of TCIE field.
	OctoSPI_CR_TCIE_Msk   = 0x20000    // Bit mask of TCIE field.
	OctoSPI_CR_TCIE       = 0x20000    // Bit TCIE.
	OctoSPI_CR_TEIE_Pos   = 0x10       // Position of TEIE field.
	OctoSPI_CR_TEIE_Msk   = 0x10000    // Bit mask of TEIE field.
	OctoSPI_CR_TEIE       = 0x10000    // Bit TEIE.
	OctoSPI_CR_FTHRES_Pos = 0x8        // Position of FTHRES field.
	OctoSPI_CR_FTHRES_Msk = 0x1f00     // Bit mask of FTHRES field.
	OctoSPI_CR_FSEL_Pos   = 0x7        // Position of FSEL field.
	OctoSPI_CR_FSEL_Msk   = 0x80       // Bit mask of FSEL field.
	OctoSPI_CR_FSEL       = 0x80       // Bit FSEL.
	OctoSPI_CR_DQM_Pos    = 0x6        // Position of DQM field.
	OctoSPI_CR_DQM_Msk    = 0x40       // Bit mask of DQM field.
	OctoSPI_CR_DQM        = 0x40       // Bit DQM.
	OctoSPI_CR_TCEN_Pos   = 0x3        // Position of TCEN field.
	OctoSPI_CR_TCEN_Msk   = 0x8        // Bit mask of TCEN field.
	OctoSPI_CR_TCEN       = 0x8        // Bit TCEN.
	OctoSPI_CR_DMAEN_Pos  = 0x2        // Position of DMAEN field.
	OctoSPI_CR_DMAEN_Msk  = 0x4        // Bit mask of DMAEN field.
	OctoSPI_CR_DMAEN      = 0x4        // Bit DMAEN.
	OctoSPI_CR_ABORT_Pos  = 0x1        // Position of ABORT field.
	OctoSPI_CR_ABORT_Msk  = 0x2        // Bit mask of ABORT field.
	OctoSPI_CR_ABORT      = 0x2        // Bit ABORT.
	OctoSPI_CR_EN_Pos     = 0x0        // Position of EN field.
	OctoSPI_CR_EN_Msk     = 0x1        // Bit mask of EN field.
	OctoSPI_CR_EN         = 0x1        // Bit EN.

	// DCR1: device configuration register
	OctoSPI_DCR1_CKMODE_Pos  = 0x0       // Position of CKMODE field.
	OctoSPI_DCR1_CKMODE_Msk  = 0x1       // Bit mask of CKMODE field.
	OctoSPI_DCR1_CKMODE      = 0x1       // Bit CKMODE.
	OctoSPI_DCR1_FRCK_Pos    = 0x1       // Position of FRCK field.
	OctoSPI_DCR1_FRCK_Msk    = 0x2       // Bit mask of FRCK field.
	OctoSPI_DCR1_FRCK        = 0x2       // Bit FRCK.
	OctoSPI_DCR1_CSHT_Pos    = 0x8       // Position of CSHT field.
	OctoSPI_DCR1_CSHT_Msk    = 0x700     // Bit mask of CSHT field.
	OctoSPI_DCR1_DEVSIZE_Pos = 0x10      // Position of DEVSIZE field.
	OctoSPI_DCR1_DEVSIZE_Msk = 0x1f0000  // Bit mask of DEVSIZE field.
	OctoSPI_DCR1_MTYP_Pos    = 0x18      // Position of MTYP field.
	OctoSPI_DCR1_MTYP_Msk    = 0x3000000 // Bit mask of MTYP field.

	// DCR2: device configuration register           2
	OctoSPI_DCR2_PRESCALER_Pos = 0x0     // Position of PRESCALER field.
	OctoSPI_DCR2_PRESCALER_Msk = 0xff    // Bit mask of PRESCALER field.
	OctoSPI_DCR2_WRAPSIZE_Pos  = 0x10    // Position of WRAPSIZE field.
	OctoSPI_DCR2_WRAPSIZE_Msk  = 0x70000 // Bit mask of WRAPSIZE field.

	// DCR3: device configuration register           3
	OctoSPI_DCR3_CSBOUND_Pos = 0x10     // Position of CSBOUND field.
	OctoSPI_DCR3_CSBOUND_Msk = 0x1f0000 // Bit mask of CSBOUND field.

	// SR: status register
	OctoSPI_SR_TEF_Pos    = 0x0    // Position of TEF field.
	OctoSPI_SR_TEF_Msk    = 0x1    // Bit mask of TEF field.
	OctoSPI_SR_TEF        = 0x1    // Bit TEF.
	OctoSPI_SR_TCF_Pos    = 0x1    // Position of TCF field.
	OctoSPI_SR_TCF_Msk    = 0x2    // Bit mask of TCF field.
	OctoSPI_SR_TCF        = 0x2    // Bit TCF.
	OctoSPI_SR_FTF_Pos    = 0x2    // Position of FTF field.
	OctoSPI_SR_FTF_Msk    = 0x4    // Bit mask of FTF field.
	OctoSPI_SR_FTF        = 0x4    // Bit FTF.
	OctoSPI_SR_SMF_Pos    = 0x3    // Position of SMF field.
	OctoSPI_SR_SMF_Msk    = 0x8    // Bit mask of SMF field.
	OctoSPI_SR_SMF        = 0x8    // Bit SMF.
	OctoSPI_SR_TOF_Pos    = 0x4    // Position of TOF field.
	OctoSPI_SR_TOF_Msk    = 0x10   // Bit mask of TOF field.
	OctoSPI_SR_TOF        = 0x10   // Bit TOF.
	OctoSPI_SR_BUSY_Pos   = 0x5    // Position of BUSY field.
	OctoSPI_SR_BUSY_Msk   = 0x20   // Bit mask of BUSY field.
	OctoSPI_SR_BUSY       = 0x20   // Bit BUSY.
	OctoSPI_SR_FLEVEL_Pos = 0x8    // Position of FLEVEL field.
	OctoSPI_SR_FLEVEL_Msk = 0x3f00 // Bit mask of FLEVEL field.

	// FCR: flag clear register
	OctoSPI_FCR_CTEF_Pos = 0x0  // Position of CTEF field.
	OctoSPI_FCR_CTEF_Msk = 0x1  // Bit mask of CTEF field.
	OctoSPI_FCR_CTEF     = 0x1  // Bit CTEF.
	OctoSPI_FCR_CTCF_Pos = 0x1  // Position of CTCF field.
	OctoSPI_FCR_CTCF_Msk = 0x2  // Bit mask of CTCF field.
	OctoSPI_FCR_CTCF     = 0x2  // Bit CTCF.
	OctoSPI_FCR_CSMF_Pos = 0x3  // Position of CSMF field.
	OctoSPI_FCR_CSMF_Msk = 0x8  // Bit mask of CSMF field.
	OctoSPI_FCR_CSMF     = 0x8  // Bit CSMF.
	OctoSPI_FCR_CTOF_Pos = 0x4  // Position of CTOF field.
	OctoSPI_FCR_CTOF_Msk = 0x10 // Bit mask of CTOF field.
	OctoSPI_FCR_CTOF     = 0x10 // Bit CTOF.

	// DLR: data length register
	OctoSPI_DLR_DL_Pos = 0x0        // Position of DL field.
	OctoSPI_DLR_DL_Msk = 0xffffffff // Bit mask of DL field.

	// AR: address register
	OctoSPI_AR_ADDRESS_Pos = 0x0        // Position of ADDRESS field.
	OctoSPI_AR_ADDRESS_Msk = 0xffffffff // Bit mask of ADDRESS field.

	// DR: data register
	OctoSPI_DR_DATA_Pos = 0x0        // Position of DATA field.
	OctoSPI_DR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// PSMKR: polling status mask register
	OctoSPI_PSMKR_MASK_Pos = 0x0        // Position of MASK field.
	OctoSPI_PSMKR_MASK_Msk = 0xffffffff // Bit mask of MASK field.

	// PSMAR: polling status match register
	OctoSPI_PSMAR_MATCH_Pos = 0x0        // Position of MATCH field.
	OctoSPI_PSMAR_MATCH_Msk = 0xffffffff // Bit mask of MATCH field.

	// PIR: polling interval register
	OctoSPI_PIR_INTERVAL_Pos = 0x0    // Position of INTERVAL field.
	OctoSPI_PIR_INTERVAL_Msk = 0xffff // Bit mask of INTERVAL field.

	// CCR: communication configuration           register
	OctoSPI_CCR_IMODE_Pos  = 0x0        // Position of IMODE field.
	OctoSPI_CCR_IMODE_Msk  = 0x7        // Bit mask of IMODE field.
	OctoSPI_CCR_IDTR_Pos   = 0x3        // Position of IDTR field.
	OctoSPI_CCR_IDTR_Msk   = 0x8        // Bit mask of IDTR field.
	OctoSPI_CCR_IDTR       = 0x8        // Bit IDTR.
	OctoSPI_CCR_ISIZE_Pos  = 0x4        // Position of ISIZE field.
	OctoSPI_CCR_ISIZE_Msk  = 0x30       // Bit mask of ISIZE field.
	OctoSPI_CCR_ADMODE_Pos = 0x8        // Position of ADMODE field.
	OctoSPI_CCR_ADMODE_Msk = 0x700      // Bit mask of ADMODE field.
	OctoSPI_CCR_ADDTR_Pos  = 0xb        // Position of ADDTR field.
	OctoSPI_CCR_ADDTR_Msk  = 0x800      // Bit mask of ADDTR field.
	OctoSPI_CCR_ADDTR      = 0x800      // Bit ADDTR.
	OctoSPI_CCR_ADSIZE_Pos = 0xc        // Position of ADSIZE field.
	OctoSPI_CCR_ADSIZE_Msk = 0x3000     // Bit mask of ADSIZE field.
	OctoSPI_CCR_ABMODE_Pos = 0x10       // Position of ABMODE field.
	OctoSPI_CCR_ABMODE_Msk = 0x70000    // Bit mask of ABMODE field.
	OctoSPI_CCR_ABDTR_Pos  = 0x13       // Position of ABDTR field.
	OctoSPI_CCR_ABDTR_Msk  = 0x80000    // Bit mask of ABDTR field.
	OctoSPI_CCR_ABDTR      = 0x80000    // Bit ABDTR.
	OctoSPI_CCR_ABSIZE_Pos = 0x14       // Position of ABSIZE field.
	OctoSPI_CCR_ABSIZE_Msk = 0x300000   // Bit mask of ABSIZE field.
	OctoSPI_CCR_DMODE_Pos  = 0x18       // Position of DMODE field.
	OctoSPI_CCR_DMODE_Msk  = 0x7000000  // Bit mask of DMODE field.
	OctoSPI_CCR_DDTR_Pos   = 0x1b       // Position of DDTR field.
	OctoSPI_CCR_DDTR_Msk   = 0x8000000  // Bit mask of DDTR field.
	OctoSPI_CCR_DDTR       = 0x8000000  // Bit DDTR.
	OctoSPI_CCR_DQSE_Pos   = 0x1d       // Position of DQSE field.
	OctoSPI_CCR_DQSE_Msk   = 0x20000000 // Bit mask of DQSE field.
	OctoSPI_CCR_DQSE       = 0x20000000 // Bit DQSE.
	OctoSPI_CCR_SIOO_Pos   = 0x1f       // Position of SIOO field.
	OctoSPI_CCR_SIOO_Msk   = 0x80000000 // Bit mask of SIOO field.
	OctoSPI_CCR_SIOO       = 0x80000000 // Bit SIOO.

	// TCR: timing configuration register
	OctoSPI_TCR_DCYC_Pos   = 0x0        // Position of DCYC field.
	OctoSPI_TCR_DCYC_Msk   = 0x1f       // Bit mask of DCYC field.
	OctoSPI_TCR_DHQC_Pos   = 0x1c       // Position of DHQC field.
	OctoSPI_TCR_DHQC_Msk   = 0x10000000 // Bit mask of DHQC field.
	OctoSPI_TCR_DHQC       = 0x10000000 // Bit DHQC.
	OctoSPI_TCR_SSHIFT_Pos = 0x1e       // Position of SSHIFT field.
	OctoSPI_TCR_SSHIFT_Msk = 0x40000000 // Bit mask of SSHIFT field.
	OctoSPI_TCR_SSHIFT     = 0x40000000 // Bit SSHIFT.

	// IR: instruction register
	OctoSPI_IR_INSTRUCTION_Pos = 0x0        // Position of INSTRUCTION field.
	OctoSPI_IR_INSTRUCTION_Msk = 0xffffffff // Bit mask of INSTRUCTION field.

	// ABR: alternate bytes register
	OctoSPI_ABR_ALTERNATE_Pos = 0x0        // Position of ALTERNATE field.
	OctoSPI_ABR_ALTERNATE_Msk = 0xffffffff // Bit mask of ALTERNATE field.

	// LPTR: low-power timeout register
	OctoSPI_LPTR_TIMEOUT_Pos = 0x0    // Position of TIMEOUT field.
	OctoSPI_LPTR_TIMEOUT_Msk = 0xffff // Bit mask of TIMEOUT field.

	// WCCR: write communication configuration           register
	OctoSPI_WCCR_IMODE_Pos  = 0x0        // Position of IMODE field.
	OctoSPI_WCCR_IMODE_Msk  = 0x7        // Bit mask of IMODE field.
	OctoSPI_WCCR_IDTR_Pos   = 0x3        // Position of IDTR field.
	OctoSPI_WCCR_IDTR_Msk   = 0x8        // Bit mask of IDTR field.
	OctoSPI_WCCR_IDTR       = 0x8        // Bit IDTR.
	OctoSPI_WCCR_ISIZE_Pos  = 0x4        // Position of ISIZE field.
	OctoSPI_WCCR_ISIZE_Msk  = 0x30       // Bit mask of ISIZE field.
	OctoSPI_WCCR_ADMODE_Pos = 0x8        // Position of ADMODE field.
	OctoSPI_WCCR_ADMODE_Msk = 0x700      // Bit mask of ADMODE field.
	OctoSPI_WCCR_ADDTR_Pos  = 0xb        // Position of ADDTR field.
	OctoSPI_WCCR_ADDTR_Msk  = 0x800      // Bit mask of ADDTR field.
	OctoSPI_WCCR_ADDTR      = 0x800      // Bit ADDTR.
	OctoSPI_WCCR_ADSIZE_Pos = 0xc        // Position of ADSIZE field.
	OctoSPI_WCCR_ADSIZE_Msk = 0x3000     // Bit mask of ADSIZE field.
	OctoSPI_WCCR_ABMODE_Pos = 0x10       // Position of ABMODE field.
	OctoSPI_WCCR_ABMODE_Msk = 0x70000    // Bit mask of ABMODE field.
	OctoSPI_WCCR_ABDTR_Pos  = 0x13       // Position of ABDTR field.
	OctoSPI_WCCR_ABDTR_Msk  = 0x80000    // Bit mask of ABDTR field.
	OctoSPI_WCCR_ABDTR      = 0x80000    // Bit ABDTR.
	OctoSPI_WCCR_ABSIZE_Pos = 0x14       // Position of ABSIZE field.
	OctoSPI_WCCR_ABSIZE_Msk = 0x300000   // Bit mask of ABSIZE field.
	OctoSPI_WCCR_DMODE_Pos  = 0x18       // Position of DMODE field.
	OctoSPI_WCCR_DMODE_Msk  = 0x7000000  // Bit mask of DMODE field.
	OctoSPI_WCCR_DDTR_Pos   = 0x1b       // Position of DDTR field.
	OctoSPI_WCCR_DDTR_Msk   = 0x8000000  // Bit mask of DDTR field.
	OctoSPI_WCCR_DDTR       = 0x8000000  // Bit DDTR.
	OctoSPI_WCCR_DQSE_Pos   = 0x1d       // Position of DQSE field.
	OctoSPI_WCCR_DQSE_Msk   = 0x20000000 // Bit mask of DQSE field.
	OctoSPI_WCCR_DQSE       = 0x20000000 // Bit DQSE.
	OctoSPI_WCCR_SIOO_Pos   = 0x1f       // Position of SIOO field.
	OctoSPI_WCCR_SIOO_Msk   = 0x80000000 // Bit mask of SIOO field.
	OctoSPI_WCCR_SIOO       = 0x80000000 // Bit SIOO.

	// WTCR: write timing configuration           register
	OctoSPI_WTCR_DCYC_Pos = 0x0  // Position of DCYC field.
	OctoSPI_WTCR_DCYC_Msk = 0x1f // Bit mask of DCYC field.

	// WIR: write instruction register
	OctoSPI_WIR_INSTRUCTION_Pos = 0x0        // Position of INSTRUCTION field.
	OctoSPI_WIR_INSTRUCTION_Msk = 0xffffffff // Bit mask of INSTRUCTION field.

	// WABR: write alternate bytes register
	OctoSPI_WABR_ALTERNATE_Pos = 0x0        // Position of ALTERNATE field.
	OctoSPI_WABR_ALTERNATE_Msk = 0xffffffff // Bit mask of ALTERNATE field.

	// HLCR: HyperBusTM latency configuration           register
	OctoSPI_HLCR_LM_Pos   = 0x0      // Position of LM field.
	OctoSPI_HLCR_LM_Msk   = 0x1      // Bit mask of LM field.
	OctoSPI_HLCR_LM       = 0x1      // Bit LM.
	OctoSPI_HLCR_WZL_Pos  = 0x1      // Position of WZL field.
	OctoSPI_HLCR_WZL_Msk  = 0x2      // Bit mask of WZL field.
	OctoSPI_HLCR_WZL      = 0x2      // Bit WZL.
	OctoSPI_HLCR_TACC_Pos = 0x8      // Position of TACC field.
	OctoSPI_HLCR_TACC_Msk = 0xff00   // Bit mask of TACC field.
	OctoSPI_HLCR_TRWR_Pos = 0x10     // Position of TRWR field.
	OctoSPI_HLCR_TRWR_Msk = 0xff0000 // Bit mask of TRWR field.

	// HWCFGR: HW configuration register
	OctoSPI_HWCFGR_AXI_Pos  = 0x0        // Position of AXI field.
	OctoSPI_HWCFGR_AXI_Msk  = 0xf        // Bit mask of AXI field.
	OctoSPI_HWCFGR_FIFO_Pos = 0x4        // Position of FIFO field.
	OctoSPI_HWCFGR_FIFO_Msk = 0xff0      // Bit mask of FIFO field.
	OctoSPI_HWCFGR_PRES_Pos = 0xc        // Position of PRES field.
	OctoSPI_HWCFGR_PRES_Msk = 0xff000    // Bit mask of PRES field.
	OctoSPI_HWCFGR_IDL_Pos  = 0x14       // Position of IDL field.
	OctoSPI_HWCFGR_IDL_Msk  = 0xf00000   // Bit mask of IDL field.
	OctoSPI_HWCFGR_MMW_Pos  = 0x18       // Position of MMW field.
	OctoSPI_HWCFGR_MMW_Msk  = 0xf000000  // Bit mask of MMW field.
	OctoSPI_HWCFGR_MST_Pos  = 0x1c       // Position of MST field.
	OctoSPI_HWCFGR_MST_Msk  = 0xf0000000 // Bit mask of MST field.

	// VER: version register
	OctoSPI_VER_VER_Pos = 0x0  // Position of VER field.
	OctoSPI_VER_VER_Msk = 0xff // Bit mask of VER field.

	// ID: identification
	OctoSPI_ID_ID_Pos = 0x0        // Position of ID field.
	OctoSPI_ID_ID_Msk = 0xffffffff // Bit mask of ID field.

	// MID: magic ID
	OctoSPI_MID_MID_Pos = 0x0        // Position of MID field.
	OctoSPI_MID_MID_Msk = 0xffffffff // Bit mask of MID field.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_PLLSAI2RDY_Pos = 0x1d       // Position of PLLSAI2RDY field.
	RCC_CR_PLLSAI2RDY_Msk = 0x20000000 // Bit mask of PLLSAI2RDY field.
	RCC_CR_PLLSAI2RDY     = 0x20000000 // Bit PLLSAI2RDY.
	RCC_CR_PLLSAI2ON_Pos  = 0x1c       // Position of PLLSAI2ON field.
	RCC_CR_PLLSAI2ON_Msk  = 0x10000000 // Bit mask of PLLSAI2ON field.
	RCC_CR_PLLSAI2ON      = 0x10000000 // Bit PLLSAI2ON.
	RCC_CR_PLLSAI1RDY_Pos = 0x1b       // Position of PLLSAI1RDY field.
	RCC_CR_PLLSAI1RDY_Msk = 0x8000000  // Bit mask of PLLSAI1RDY field.
	RCC_CR_PLLSAI1RDY     = 0x8000000  // Bit PLLSAI1RDY.
	RCC_CR_PLLSAI1ON_Pos  = 0x1a       // Position of PLLSAI1ON field.
	RCC_CR_PLLSAI1ON_Msk  = 0x4000000  // Bit mask of PLLSAI1ON field.
	RCC_CR_PLLSAI1ON      = 0x4000000  // Bit PLLSAI1ON.
	RCC_CR_PLLRDY_Pos     = 0x19       // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk     = 0x2000000  // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY         = 0x2000000  // Bit PLLRDY.
	RCC_CR_PLLON_Pos      = 0x18       // Position of PLLON field.
	RCC_CR_PLLON_Msk      = 0x1000000  // Bit mask of PLLON field.
	RCC_CR_PLLON          = 0x1000000  // Bit PLLON.
	RCC_CR_CSSON_Pos      = 0x13       // Position of CSSON field.
	RCC_CR_CSSON_Msk      = 0x80000    // Bit mask of CSSON field.
	RCC_CR_CSSON          = 0x80000    // Bit CSSON.
	RCC_CR_HSEBYP_Pos     = 0x12       // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk     = 0x40000    // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP         = 0x40000    // Bit HSEBYP.
	RCC_CR_HSERDY_Pos     = 0x11       // Position of HSERDY field.
	RCC_CR_HSERDY_Msk     = 0x20000    // Bit mask of HSERDY field.
	RCC_CR_HSERDY         = 0x20000    // Bit HSERDY.
	RCC_CR_HSEON_Pos      = 0x10       // Position of HSEON field.
	RCC_CR_HSEON_Msk      = 0x10000    // Bit mask of HSEON field.
	RCC_CR_HSEON          = 0x10000    // Bit HSEON.
	RCC_CR_HSIASFS_Pos    = 0xb        // Position of HSIASFS field.
	RCC_CR_HSIASFS_Msk    = 0x800      // Bit mask of HSIASFS field.
	RCC_CR_HSIASFS        = 0x800      // Bit HSIASFS.
	RCC_CR_HSIRDY_Pos     = 0xa        // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk     = 0x400      // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY         = 0x400      // Bit HSIRDY.
	RCC_CR_HSIKERON_Pos   = 0x9        // Position of HSIKERON field.
	RCC_CR_HSIKERON_Msk   = 0x200      // Bit mask of HSIKERON field.
	RCC_CR_HSIKERON       = 0x200      // Bit HSIKERON.
	RCC_CR_HSION_Pos      = 0x8        // Position of HSION field.
	RCC_CR_HSION_Msk      = 0x100      // Bit mask of HSION field.
	RCC_CR_HSION          = 0x100      // Bit HSION.
	RCC_CR_MSIRANGE_Pos   = 0x4        // Position of MSIRANGE field.
	RCC_CR_MSIRANGE_Msk   = 0xf0       // Bit mask of MSIRANGE field.
	RCC_CR_MSIRGSEL_Pos   = 0x3        // Position of MSIRGSEL field.
	RCC_CR_MSIRGSEL_Msk   = 0x8        // Bit mask of MSIRGSEL field.
	RCC_CR_MSIRGSEL       = 0x8        // Bit MSIRGSEL.
	RCC_CR_MSIPLLEN_Pos   = 0x2        // Position of MSIPLLEN field.
	RCC_CR_MSIPLLEN_Msk   = 0x4        // Bit mask of MSIPLLEN field.
	RCC_CR_MSIPLLEN       = 0x4        // Bit MSIPLLEN.
	RCC_CR_MSIRDY_Pos     = 0x1        // Position of MSIRDY field.
	RCC_CR_MSIRDY_Msk     = 0x2        // Bit mask of MSIRDY field.
	RCC_CR_MSIRDY         = 0x2        // Bit MSIRDY.
	RCC_CR_MSION_Pos      = 0x0        // Position of MSION field.
	RCC_CR_MSION_Msk      = 0x1        // Bit mask of MSION field.
	RCC_CR_MSION          = 0x1        // Bit MSION.

	// ICSCR: Internal clock sources calibration           register
	RCC_ICSCR_HSITRIM_Pos = 0x18       // Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x7f000000 // Bit mask of HSITRIM field.
	RCC_ICSCR_HSICAL_Pos  = 0x10       // Position of HSICAL field.
	RCC_ICSCR_HSICAL_Msk  = 0xff0000   // Bit mask of HSICAL field.
	RCC_ICSCR_MSITRIM_Pos = 0x8        // Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk = 0xff00     // Bit mask of MSITRIM field.
	RCC_ICSCR_MSICAL_Pos  = 0x0        // Position of MSICAL field.
	RCC_ICSCR_MSICAL_Msk  = 0xff       // Bit mask of MSICAL field.

	// CFGR: Clock configuration register
	RCC_CFGR_MCOPRE_Pos   = 0x1c       // Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk   = 0x70000000 // Bit mask of MCOPRE field.
	RCC_CFGR_MCOSEL_Pos   = 0x18       // Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk   = 0x7000000  // Bit mask of MCOSEL field.
	RCC_CFGR_STOPWUCK_Pos = 0xf        // Position of STOPWUCK field.
	RCC_CFGR_STOPWUCK_Msk = 0x8000     // Bit mask of STOPWUCK field.
	RCC_CFGR_STOPWUCK     = 0x8000     // Bit STOPWUCK.
	RCC_CFGR_PPRE2_Pos    = 0xb        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk    = 0x3800     // Bit mask of PPRE2 field.
	RCC_CFGR_PPRE1_Pos    = 0x8        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk    = 0x700      // Bit mask of PPRE1 field.
	RCC_CFGR_HPRE_Pos     = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk     = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_SWS_Pos      = 0x2        // Position of SWS field.
	RCC_CFGR_SWS_Msk      = 0xc        // Bit mask of SWS field.
	RCC_CFGR_SW_Pos       = 0x0        // Position of SW field.
	RCC_CFGR_SW_Msk       = 0x3        // Bit mask of SW field.

	// PLLCFGR: PLL configuration register
	RCC_PLLCFGR_PLLPDIV_Pos = 0x1b       // Position of PLLPDIV field.
	RCC_PLLCFGR_PLLPDIV_Msk = 0xf8000000 // Bit mask of PLLPDIV field.
	RCC_PLLCFGR_PLLR_Pos    = 0x19       // Position of PLLR field.
	RCC_PLLCFGR_PLLR_Msk    = 0x6000000  // Bit mask of PLLR field.
	RCC_PLLCFGR_PLLREN_Pos  = 0x18       // Position of PLLREN field.
	RCC_PLLCFGR_PLLREN_Msk  = 0x1000000  // Bit mask of PLLREN field.
	RCC_PLLCFGR_PLLREN      = 0x1000000  // Bit PLLREN.
	RCC_PLLCFGR_PLLQ_Pos    = 0x15       // Position of PLLQ field.
	RCC_PLLCFGR_PLLQ_Msk    = 0x600000   // Bit mask of PLLQ field.
	RCC_PLLCFGR_PLLQEN_Pos  = 0x14       // Position of PLLQEN field.
	RCC_PLLCFGR_PLLQEN_Msk  = 0x100000   // Bit mask of PLLQEN field.
	RCC_PLLCFGR_PLLQEN      = 0x100000   // Bit PLLQEN.
	RCC_PLLCFGR_PLLP_Pos    = 0x11       // Position of PLLP field.
	RCC_PLLCFGR_PLLP_Msk    = 0x20000    // Bit mask of PLLP field.
	RCC_PLLCFGR_PLLP        = 0x20000    // Bit PLLP.
	RCC_PLLCFGR_PLLPEN_Pos  = 0x10       // Position of PLLPEN field.
	RCC_PLLCFGR_PLLPEN_Msk  = 0x10000    // Bit mask of PLLPEN field.
	RCC_PLLCFGR_PLLPEN      = 0x10000    // Bit PLLPEN.
	RCC_PLLCFGR_PLLN_Pos    = 0x8        // Position of PLLN field.
	RCC_PLLCFGR_PLLN_Msk    = 0x7f00     // Bit mask of PLLN field.
	RCC_PLLCFGR_PLLM_Pos    = 0x4        // Position of PLLM field.
	RCC_PLLCFGR_PLLM_Msk    = 0xf0       // Bit mask of PLLM field.
	RCC_PLLCFGR_PLLSRC_Pos  = 0x0        // Position of PLLSRC field.
	RCC_PLLCFGR_PLLSRC_Msk  = 0x3        // Bit mask of PLLSRC field.

	// PLLSAI1CFGR: PLLSAI1 configuration register
	RCC_PLLSAI1CFGR_PLLSAI1PDIV_Pos = 0x1b       // Position of PLLSAI1PDIV field.
	RCC_PLLSAI1CFGR_PLLSAI1PDIV_Msk = 0xf8000000 // Bit mask of PLLSAI1PDIV field.
	RCC_PLLSAI1CFGR_PLLSAI1R_Pos    = 0x19       // Position of PLLSAI1R field.
	RCC_PLLSAI1CFGR_PLLSAI1R_Msk    = 0x6000000  // Bit mask of PLLSAI1R field.
	RCC_PLLSAI1CFGR_PLLSAI1REN_Pos  = 0x18       // Position of PLLSAI1REN field.
	RCC_PLLSAI1CFGR_PLLSAI1REN_Msk  = 0x1000000  // Bit mask of PLLSAI1REN field.
	RCC_PLLSAI1CFGR_PLLSAI1REN      = 0x1000000  // Bit PLLSAI1REN.
	RCC_PLLSAI1CFGR_PLLSAI1Q_Pos    = 0x15       // Position of PLLSAI1Q field.
	RCC_PLLSAI1CFGR_PLLSAI1Q_Msk    = 0x600000   // Bit mask of PLLSAI1Q field.
	RCC_PLLSAI1CFGR_PLLSAI1QEN_Pos  = 0x14       // Position of PLLSAI1QEN field.
	RCC_PLLSAI1CFGR_PLLSAI1QEN_Msk  = 0x100000   // Bit mask of PLLSAI1QEN field.
	RCC_PLLSAI1CFGR_PLLSAI1QEN      = 0x100000   // Bit PLLSAI1QEN.
	RCC_PLLSAI1CFGR_PLLSAI1P_Pos    = 0x11       // Position of PLLSAI1P field.
	RCC_PLLSAI1CFGR_PLLSAI1P_Msk    = 0x20000    // Bit mask of PLLSAI1P field.
	RCC_PLLSAI1CFGR_PLLSAI1P        = 0x20000    // Bit PLLSAI1P.
	RCC_PLLSAI1CFGR_PLLSAI1PEN_Pos  = 0x10       // Position of PLLSAI1PEN field.
	RCC_PLLSAI1CFGR_PLLSAI1PEN_Msk  = 0x10000    // Bit mask of PLLSAI1PEN field.
	RCC_PLLSAI1CFGR_PLLSAI1PEN      = 0x10000    // Bit PLLSAI1PEN.
	RCC_PLLSAI1CFGR_PLLSAI1N_Pos    = 0x8        // Position of PLLSAI1N field.
	RCC_PLLSAI1CFGR_PLLSAI1N_Msk    = 0x7f00     // Bit mask of PLLSAI1N field.
	RCC_PLLSAI1CFGR_PLLSAI1M_Pos    = 0x4        // Position of PLLSAI1M field.
	RCC_PLLSAI1CFGR_PLLSAI1M_Msk    = 0xf0       // Bit mask of PLLSAI1M field.

	// PLLSAI2CFGR: PLLSAI2 configuration register
	RCC_PLLSAI2CFGR_PLLSAI2PDIV_Pos = 0x1b       // Position of PLLSAI2PDIV field.
	RCC_PLLSAI2CFGR_PLLSAI2PDIV_Msk = 0xf8000000 // Bit mask of PLLSAI2PDIV field.
	RCC_PLLSAI2CFGR_PLLSAI2R_Pos    = 0x19       // Position of PLLSAI2R field.
	RCC_PLLSAI2CFGR_PLLSAI2R_Msk    = 0x6000000  // Bit mask of PLLSAI2R field.
	RCC_PLLSAI2CFGR_PLLSAI2REN_Pos  = 0x18       // Position of PLLSAI2REN field.
	RCC_PLLSAI2CFGR_PLLSAI2REN_Msk  = 0x1000000  // Bit mask of PLLSAI2REN field.
	RCC_PLLSAI2CFGR_PLLSAI2REN      = 0x1000000  // Bit PLLSAI2REN.
	RCC_PLLSAI2CFGR_PLLSAI2Q_Pos    = 0x15       // Position of PLLSAI2Q field.
	RCC_PLLSAI2CFGR_PLLSAI2Q_Msk    = 0x600000   // Bit mask of PLLSAI2Q field.
	RCC_PLLSAI2CFGR_PLLSAI2QEN_Pos  = 0x14       // Position of PLLSAI2QEN field.
	RCC_PLLSAI2CFGR_PLLSAI2QEN_Msk  = 0x100000   // Bit mask of PLLSAI2QEN field.
	RCC_PLLSAI2CFGR_PLLSAI2QEN      = 0x100000   // Bit PLLSAI2QEN.
	RCC_PLLSAI2CFGR_PLLSAI2P_Pos    = 0x11       // Position of PLLSAI2P field.
	RCC_PLLSAI2CFGR_PLLSAI2P_Msk    = 0x20000    // Bit mask of PLLSAI2P field.
	RCC_PLLSAI2CFGR_PLLSAI2P        = 0x20000    // Bit PLLSAI2P.
	RCC_PLLSAI2CFGR_PLLSAI2PEN_Pos  = 0x10       // Position of PLLSAI2PEN field.
	RCC_PLLSAI2CFGR_PLLSAI2PEN_Msk  = 0x10000    // Bit mask of PLLSAI2PEN field.
	RCC_PLLSAI2CFGR_PLLSAI2PEN      = 0x10000    // Bit PLLSAI2PEN.
	RCC_PLLSAI2CFGR_PLLSAI2N_Pos    = 0x8        // Position of PLLSAI2N field.
	RCC_PLLSAI2CFGR_PLLSAI2N_Msk    = 0x7f00     // Bit mask of PLLSAI2N field.
	RCC_PLLSAI2CFGR_PLLSAI2M_Pos    = 0x4        // Position of PLLSAI2M field.
	RCC_PLLSAI2CFGR_PLLSAI2M_Msk    = 0xf0       // Bit mask of PLLSAI2M field.

	// CIER: Clock interrupt enable           register
	RCC_CIER_LSIRDYIE_Pos     = 0x0   // Position of LSIRDYIE field.
	RCC_CIER_LSIRDYIE_Msk     = 0x1   // Bit mask of LSIRDYIE field.
	RCC_CIER_LSIRDYIE         = 0x1   // Bit LSIRDYIE.
	RCC_CIER_LSERDYIE_Pos     = 0x1   // Position of LSERDYIE field.
	RCC_CIER_LSERDYIE_Msk     = 0x2   // Bit mask of LSERDYIE field.
	RCC_CIER_LSERDYIE         = 0x2   // Bit LSERDYIE.
	RCC_CIER_MSIRDYIE_Pos     = 0x2   // Position of MSIRDYIE field.
	RCC_CIER_MSIRDYIE_Msk     = 0x4   // Bit mask of MSIRDYIE field.
	RCC_CIER_MSIRDYIE         = 0x4   // Bit MSIRDYIE.
	RCC_CIER_HSIRDYIE_Pos     = 0x3   // Position of HSIRDYIE field.
	RCC_CIER_HSIRDYIE_Msk     = 0x8   // Bit mask of HSIRDYIE field.
	RCC_CIER_HSIRDYIE         = 0x8   // Bit HSIRDYIE.
	RCC_CIER_HSERDYIE_Pos     = 0x4   // Position of HSERDYIE field.
	RCC_CIER_HSERDYIE_Msk     = 0x10  // Bit mask of HSERDYIE field.
	RCC_CIER_HSERDYIE         = 0x10  // Bit HSERDYIE.
	RCC_CIER_PLLRDYIE_Pos     = 0x5   // Position of PLLRDYIE field.
	RCC_CIER_PLLRDYIE_Msk     = 0x20  // Bit mask of PLLRDYIE field.
	RCC_CIER_PLLRDYIE         = 0x20  // Bit PLLRDYIE.
	RCC_CIER_PLLSAI1RDYIE_Pos = 0x6   // Position of PLLSAI1RDYIE field.
	RCC_CIER_PLLSAI1RDYIE_Msk = 0x40  // Bit mask of PLLSAI1RDYIE field.
	RCC_CIER_PLLSAI1RDYIE     = 0x40  // Bit PLLSAI1RDYIE.
	RCC_CIER_PLLSAI2RDYIE_Pos = 0x7   // Position of PLLSAI2RDYIE field.
	RCC_CIER_PLLSAI2RDYIE_Msk = 0x80  // Bit mask of PLLSAI2RDYIE field.
	RCC_CIER_PLLSAI2RDYIE     = 0x80  // Bit PLLSAI2RDYIE.
	RCC_CIER_LSECSSIE_Pos     = 0x9   // Position of LSECSSIE field.
	RCC_CIER_LSECSSIE_Msk     = 0x200 // Bit mask of LSECSSIE field.
	RCC_CIER_LSECSSIE         = 0x200 // Bit LSECSSIE.
	RCC_CIER_HSI48RDYIE_Pos   = 0xa   // Position of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE_Msk   = 0x400 // Bit mask of HSI48RDYIE field.
	RCC_CIER_HSI48RDYIE       = 0x400 // Bit HSI48RDYIE.

	// CIFR: Clock interrupt flag register
	RCC_CIFR_LSIRDYF_Pos     = 0x0   // Position of LSIRDYF field.
	RCC_CIFR_LSIRDYF_Msk     = 0x1   // Bit mask of LSIRDYF field.
	RCC_CIFR_LSIRDYF         = 0x1   // Bit LSIRDYF.
	RCC_CIFR_LSERDYF_Pos     = 0x1   // Position of LSERDYF field.
	RCC_CIFR_LSERDYF_Msk     = 0x2   // Bit mask of LSERDYF field.
	RCC_CIFR_LSERDYF         = 0x2   // Bit LSERDYF.
	RCC_CIFR_MSIRDYF_Pos     = 0x2   // Position of MSIRDYF field.
	RCC_CIFR_MSIRDYF_Msk     = 0x4   // Bit mask of MSIRDYF field.
	RCC_CIFR_MSIRDYF         = 0x4   // Bit MSIRDYF.
	RCC_CIFR_HSIRDYF_Pos     = 0x3   // Position of HSIRDYF field.
	RCC_CIFR_HSIRDYF_Msk     = 0x8   // Bit mask of HSIRDYF field.
	RCC_CIFR_HSIRDYF         = 0x8   // Bit HSIRDYF.
	RCC_CIFR_HSERDYF_Pos     = 0x4   // Position of HSERDYF field.
	RCC_CIFR_HSERDYF_Msk     = 0x10  // Bit mask of HSERDYF field.
	RCC_CIFR_HSERDYF         = 0x10  // Bit HSERDYF.
	RCC_CIFR_PLLRDYF_Pos     = 0x5   // Position of PLLRDYF field.
	RCC_CIFR_PLLRDYF_Msk     = 0x20  // Bit mask of PLLRDYF field.
	RCC_CIFR_PLLRDYF         = 0x20  // Bit PLLRDYF.
	RCC_CIFR_PLLSAI1RDYF_Pos = 0x6   // Position of PLLSAI1RDYF field.
	RCC_CIFR_PLLSAI1RDYF_Msk = 0x40  // Bit mask of PLLSAI1RDYF field.
	RCC_CIFR_PLLSAI1RDYF     = 0x40  // Bit PLLSAI1RDYF.
	RCC_CIFR_PLLSAI2RDYF_Pos = 0x7   // Position of PLLSAI2RDYF field.
	RCC_CIFR_PLLSAI2RDYF_Msk = 0x80  // Bit mask of PLLSAI2RDYF field.
	RCC_CIFR_PLLSAI2RDYF     = 0x80  // Bit PLLSAI2RDYF.
	RCC_CIFR_CSSF_Pos        = 0x8   // Position of CSSF field.
	RCC_CIFR_CSSF_Msk        = 0x100 // Bit mask of CSSF field.
	RCC_CIFR_CSSF            = 0x100 // Bit CSSF.
	RCC_CIFR_LSECSSF_Pos     = 0x9   // Position of LSECSSF field.
	RCC_CIFR_LSECSSF_Msk     = 0x200 // Bit mask of LSECSSF field.
	RCC_CIFR_LSECSSF         = 0x200 // Bit LSECSSF.
	RCC_CIFR_HSI48RDYF_Pos   = 0xa   // Position of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF_Msk   = 0x400 // Bit mask of HSI48RDYF field.
	RCC_CIFR_HSI48RDYF       = 0x400 // Bit HSI48RDYF.

	// CICR: Clock interrupt clear register
	RCC_CICR_LSIRDYC_Pos     = 0x0   // Position of LSIRDYC field.
	RCC_CICR_LSIRDYC_Msk     = 0x1   // Bit mask of LSIRDYC field.
	RCC_CICR_LSIRDYC         = 0x1   // Bit LSIRDYC.
	RCC_CICR_LSERDYC_Pos     = 0x1   // Position of LSERDYC field.
	RCC_CICR_LSERDYC_Msk     = 0x2   // Bit mask of LSERDYC field.
	RCC_CICR_LSERDYC         = 0x2   // Bit LSERDYC.
	RCC_CICR_MSIRDYC_Pos     = 0x2   // Position of MSIRDYC field.
	RCC_CICR_MSIRDYC_Msk     = 0x4   // Bit mask of MSIRDYC field.
	RCC_CICR_MSIRDYC         = 0x4   // Bit MSIRDYC.
	RCC_CICR_HSIRDYC_Pos     = 0x3   // Position of HSIRDYC field.
	RCC_CICR_HSIRDYC_Msk     = 0x8   // Bit mask of HSIRDYC field.
	RCC_CICR_HSIRDYC         = 0x8   // Bit HSIRDYC.
	RCC_CICR_HSERDYC_Pos     = 0x4   // Position of HSERDYC field.
	RCC_CICR_HSERDYC_Msk     = 0x10  // Bit mask of HSERDYC field.
	RCC_CICR_HSERDYC         = 0x10  // Bit HSERDYC.
	RCC_CICR_PLLRDYC_Pos     = 0x5   // Position of PLLRDYC field.
	RCC_CICR_PLLRDYC_Msk     = 0x20  // Bit mask of PLLRDYC field.
	RCC_CICR_PLLRDYC         = 0x20  // Bit PLLRDYC.
	RCC_CICR_PLLSAI1RDYC_Pos = 0x6   // Position of PLLSAI1RDYC field.
	RCC_CICR_PLLSAI1RDYC_Msk = 0x40  // Bit mask of PLLSAI1RDYC field.
	RCC_CICR_PLLSAI1RDYC     = 0x40  // Bit PLLSAI1RDYC.
	RCC_CICR_PLLSAI2RDYC_Pos = 0x7   // Position of PLLSAI2RDYC field.
	RCC_CICR_PLLSAI2RDYC_Msk = 0x80  // Bit mask of PLLSAI2RDYC field.
	RCC_CICR_PLLSAI2RDYC     = 0x80  // Bit PLLSAI2RDYC.
	RCC_CICR_CSSC_Pos        = 0x8   // Position of CSSC field.
	RCC_CICR_CSSC_Msk        = 0x100 // Bit mask of CSSC field.
	RCC_CICR_CSSC            = 0x100 // Bit CSSC.
	RCC_CICR_LSECSSC_Pos     = 0x9   // Position of LSECSSC field.
	RCC_CICR_LSECSSC_Msk     = 0x200 // Bit mask of LSECSSC field.
	RCC_CICR_LSECSSC         = 0x200 // Bit LSECSSC.
	RCC_CICR_HSI48RDYC_Pos   = 0xa   // Position of HSI48RDYC field.
	RCC_CICR_HSI48RDYC_Msk   = 0x400 // Bit mask of HSI48RDYC field.
	RCC_CICR_HSI48RDYC       = 0x400 // Bit HSI48RDYC.

	// AHB1RSTR: AHB1 peripheral reset register
	RCC_AHB1RSTR_DMA1RST_Pos    = 0x0     // Position of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST_Msk    = 0x1     // Bit mask of DMA1RST field.
	RCC_AHB1RSTR_DMA1RST        = 0x1     // Bit DMA1RST.
	RCC_AHB1RSTR_DMA2RST_Pos    = 0x1     // Position of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST_Msk    = 0x2     // Bit mask of DMA2RST field.
	RCC_AHB1RSTR_DMA2RST        = 0x2     // Bit DMA2RST.
	RCC_AHB1RSTR_DMAMUX1RST_Pos = 0x2     // Position of DMAMUX1RST field.
	RCC_AHB1RSTR_DMAMUX1RST_Msk = 0x4     // Bit mask of DMAMUX1RST field.
	RCC_AHB1RSTR_DMAMUX1RST     = 0x4     // Bit DMAMUX1RST.
	RCC_AHB1RSTR_FLASHRST_Pos   = 0x8     // Position of FLASHRST field.
	RCC_AHB1RSTR_FLASHRST_Msk   = 0x100   // Bit mask of FLASHRST field.
	RCC_AHB1RSTR_FLASHRST       = 0x100   // Bit FLASHRST.
	RCC_AHB1RSTR_CRCRST_Pos     = 0xc     // Position of CRCRST field.
	RCC_AHB1RSTR_CRCRST_Msk     = 0x1000  // Bit mask of CRCRST field.
	RCC_AHB1RSTR_CRCRST         = 0x1000  // Bit CRCRST.
	RCC_AHB1RSTR_TSCRST_Pos     = 0x10    // Position of TSCRST field.
	RCC_AHB1RSTR_TSCRST_Msk     = 0x10000 // Bit mask of TSCRST field.
	RCC_AHB1RSTR_TSCRST         = 0x10000 // Bit TSCRST.
	RCC_AHB1RSTR_DMA2DRST_Pos   = 0x11    // Position of DMA2DRST field.
	RCC_AHB1RSTR_DMA2DRST_Msk   = 0x20000 // Bit mask of DMA2DRST field.
	RCC_AHB1RSTR_DMA2DRST       = 0x20000 // Bit DMA2DRST.
	RCC_AHB1RSTR_GFXMMURST_Pos  = 0x12    // Position of GFXMMURST field.
	RCC_AHB1RSTR_GFXMMURST_Msk  = 0x40000 // Bit mask of GFXMMURST field.
	RCC_AHB1RSTR_GFXMMURST      = 0x40000 // Bit GFXMMURST.

	// AHB2RSTR: AHB2 peripheral reset register
	RCC_AHB2RSTR_GPIOARST_Pos  = 0x0      // Position of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST_Msk  = 0x1      // Bit mask of GPIOARST field.
	RCC_AHB2RSTR_GPIOARST      = 0x1      // Bit GPIOARST.
	RCC_AHB2RSTR_GPIOBRST_Pos  = 0x1      // Position of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST_Msk  = 0x2      // Bit mask of GPIOBRST field.
	RCC_AHB2RSTR_GPIOBRST      = 0x2      // Bit GPIOBRST.
	RCC_AHB2RSTR_GPIOCRST_Pos  = 0x2      // Position of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST_Msk  = 0x4      // Bit mask of GPIOCRST field.
	RCC_AHB2RSTR_GPIOCRST      = 0x4      // Bit GPIOCRST.
	RCC_AHB2RSTR_GPIODRST_Pos  = 0x3      // Position of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST_Msk  = 0x8      // Bit mask of GPIODRST field.
	RCC_AHB2RSTR_GPIODRST      = 0x8      // Bit GPIODRST.
	RCC_AHB2RSTR_GPIOERST_Pos  = 0x4      // Position of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST_Msk  = 0x10     // Bit mask of GPIOERST field.
	RCC_AHB2RSTR_GPIOERST      = 0x10     // Bit GPIOERST.
	RCC_AHB2RSTR_GPIOFRST_Pos  = 0x5      // Position of GPIOFRST field.
	RCC_AHB2RSTR_GPIOFRST_Msk  = 0x20     // Bit mask of GPIOFRST field.
	RCC_AHB2RSTR_GPIOFRST      = 0x20     // Bit GPIOFRST.
	RCC_AHB2RSTR_GPIOGRST_Pos  = 0x6      // Position of GPIOGRST field.
	RCC_AHB2RSTR_GPIOGRST_Msk  = 0x40     // Bit mask of GPIOGRST field.
	RCC_AHB2RSTR_GPIOGRST      = 0x40     // Bit GPIOGRST.
	RCC_AHB2RSTR_GPIOHRST_Pos  = 0x7      // Position of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST_Msk  = 0x80     // Bit mask of GPIOHRST field.
	RCC_AHB2RSTR_GPIOHRST      = 0x80     // Bit GPIOHRST.
	RCC_AHB2RSTR_GPIOIRST_Pos  = 0x8      // Position of GPIOIRST field.
	RCC_AHB2RSTR_GPIOIRST_Msk  = 0x100    // Bit mask of GPIOIRST field.
	RCC_AHB2RSTR_GPIOIRST      = 0x100    // Bit GPIOIRST.
	RCC_AHB2RSTR_OTGFSRST_Pos  = 0xc      // Position of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST_Msk  = 0x1000   // Bit mask of OTGFSRST field.
	RCC_AHB2RSTR_OTGFSRST      = 0x1000   // Bit OTGFSRST.
	RCC_AHB2RSTR_ADCRST_Pos    = 0xd      // Position of ADCRST field.
	RCC_AHB2RSTR_ADCRST_Msk    = 0x2000   // Bit mask of ADCRST field.
	RCC_AHB2RSTR_ADCRST        = 0x2000   // Bit ADCRST.
	RCC_AHB2RSTR_DCMIRST_Pos   = 0xe      // Position of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST_Msk   = 0x4000   // Bit mask of DCMIRST field.
	RCC_AHB2RSTR_DCMIRST       = 0x4000   // Bit DCMIRST.
	RCC_AHB2RSTR_AESRST_Pos    = 0x10     // Position of AESRST field.
	RCC_AHB2RSTR_AESRST_Msk    = 0x10000  // Bit mask of AESRST field.
	RCC_AHB2RSTR_AESRST        = 0x10000  // Bit AESRST.
	RCC_AHB2RSTR_HASHRST_Pos   = 0x11     // Position of HASHRST field.
	RCC_AHB2RSTR_HASHRST_Msk   = 0x20000  // Bit mask of HASHRST field.
	RCC_AHB2RSTR_HASHRST       = 0x20000  // Bit HASHRST.
	RCC_AHB2RSTR_RNGRST_Pos    = 0x12     // Position of RNGRST field.
	RCC_AHB2RSTR_RNGRST_Msk    = 0x40000  // Bit mask of RNGRST field.
	RCC_AHB2RSTR_RNGRST        = 0x40000  // Bit RNGRST.
	RCC_AHB2RSTR_OSPIMRST_Pos  = 0x14     // Position of OSPIMRST field.
	RCC_AHB2RSTR_OSPIMRST_Msk  = 0x100000 // Bit mask of OSPIMRST field.
	RCC_AHB2RSTR_OSPIMRST      = 0x100000 // Bit OSPIMRST.
	RCC_AHB2RSTR_SDMMC1RST_Pos = 0x16     // Position of SDMMC1RST field.
	RCC_AHB2RSTR_SDMMC1RST_Msk = 0x400000 // Bit mask of SDMMC1RST field.
	RCC_AHB2RSTR_SDMMC1RST     = 0x400000 // Bit SDMMC1RST.

	// AHB3RSTR: AHB3 peripheral reset register
	RCC_AHB3RSTR_FMCRST_Pos   = 0x0   // Position of FMCRST field.
	RCC_AHB3RSTR_FMCRST_Msk   = 0x1   // Bit mask of FMCRST field.
	RCC_AHB3RSTR_FMCRST       = 0x1   // Bit FMCRST.
	RCC_AHB3RSTR_OSPI2RST_Pos = 0x9   // Position of OSPI2RST field.
	RCC_AHB3RSTR_OSPI2RST_Msk = 0x200 // Bit mask of OSPI2RST field.
	RCC_AHB3RSTR_OSPI2RST     = 0x200 // Bit OSPI2RST.

	// APB1RSTR1: APB1 peripheral reset register           1
	RCC_APB1RSTR1_LPTIM1RST_Pos = 0x1f       // Position of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST_Msk = 0x80000000 // Bit mask of LPTIM1RST field.
	RCC_APB1RSTR1_LPTIM1RST     = 0x80000000 // Bit LPTIM1RST.
	RCC_APB1RSTR1_OPAMPRST_Pos  = 0x1e       // Position of OPAMPRST field.
	RCC_APB1RSTR1_OPAMPRST_Msk  = 0x40000000 // Bit mask of OPAMPRST field.
	RCC_APB1RSTR1_OPAMPRST      = 0x40000000 // Bit OPAMPRST.
	RCC_APB1RSTR1_DAC1RST_Pos   = 0x1d       // Position of DAC1RST field.
	RCC_APB1RSTR1_DAC1RST_Msk   = 0x20000000 // Bit mask of DAC1RST field.
	RCC_APB1RSTR1_DAC1RST       = 0x20000000 // Bit DAC1RST.
	RCC_APB1RSTR1_PWRRST_Pos    = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR1_PWRRST_Msk    = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR1_PWRRST        = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR1_CAN1RST_Pos   = 0x19       // Position of CAN1RST field.
	RCC_APB1RSTR1_CAN1RST_Msk   = 0x2000000  // Bit mask of CAN1RST field.
	RCC_APB1RSTR1_CAN1RST       = 0x2000000  // Bit CAN1RST.
	RCC_APB1RSTR1_CRSRST_Pos    = 0x18       // Position of CRSRST field.
	RCC_APB1RSTR1_CRSRST_Msk    = 0x1000000  // Bit mask of CRSRST field.
	RCC_APB1RSTR1_CRSRST        = 0x1000000  // Bit CRSRST.
	RCC_APB1RSTR1_I2C3RST_Pos   = 0x17       // Position of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST_Msk   = 0x800000   // Bit mask of I2C3RST field.
	RCC_APB1RSTR1_I2C3RST       = 0x800000   // Bit I2C3RST.
	RCC_APB1RSTR1_I2C2RST_Pos   = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST_Msk   = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR1_I2C2RST       = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR1_I2C1RST_Pos   = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST_Msk   = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR1_I2C1RST       = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR1_UART5RST_Pos  = 0x14       // Position of UART5RST field.
	RCC_APB1RSTR1_UART5RST_Msk  = 0x100000   // Bit mask of UART5RST field.
	RCC_APB1RSTR1_UART5RST      = 0x100000   // Bit UART5RST.
	RCC_APB1RSTR1_UART4RST_Pos  = 0x13       // Position of UART4RST field.
	RCC_APB1RSTR1_UART4RST_Msk  = 0x80000    // Bit mask of UART4RST field.
	RCC_APB1RSTR1_UART4RST      = 0x80000    // Bit UART4RST.
	RCC_APB1RSTR1_USART3RST_Pos = 0x12       // Position of USART3RST field.
	RCC_APB1RSTR1_USART3RST_Msk = 0x40000    // Bit mask of USART3RST field.
	RCC_APB1RSTR1_USART3RST     = 0x40000    // Bit USART3RST.
	RCC_APB1RSTR1_USART2RST_Pos = 0x11       // Position of USART2RST field.
	RCC_APB1RSTR1_USART2RST_Msk = 0x20000    // Bit mask of USART2RST field.
	RCC_APB1RSTR1_USART2RST     = 0x20000    // Bit USART2RST.
	RCC_APB1RSTR1_SPI3RST_Pos   = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR1_SPI3RST_Msk   = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR1_SPI3RST       = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR1_SPI2RST_Pos   = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST_Msk   = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR1_SPI2RST       = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR1_TIM7RST_Pos   = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR1_TIM7RST_Msk   = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR1_TIM7RST       = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR1_TIM6RST_Pos   = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR1_TIM6RST_Msk   = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR1_TIM6RST       = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR1_TIM5RST_Pos   = 0x3        // Position of TIM5RST field.
	RCC_APB1RSTR1_TIM5RST_Msk   = 0x8        // Bit mask of TIM5RST field.
	RCC_APB1RSTR1_TIM5RST       = 0x8        // Bit TIM5RST.
	RCC_APB1RSTR1_TIM4RST_Pos   = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR1_TIM4RST_Msk   = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR1_TIM4RST       = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR1_TIM3RST_Pos   = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR1_TIM3RST_Msk   = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR1_TIM3RST       = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR1_TIM2RST_Pos   = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST_Msk   = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR1_TIM2RST       = 0x1        // Bit TIM2RST.

	// APB1RSTR2: APB1 peripheral reset register           2
	RCC_APB1RSTR2_LPUART1RST_Pos = 0x0  // Position of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST_Msk = 0x1  // Bit mask of LPUART1RST field.
	RCC_APB1RSTR2_LPUART1RST     = 0x1  // Bit LPUART1RST.
	RCC_APB1RSTR2_I2C4RST_Pos    = 0x1  // Position of I2C4RST field.
	RCC_APB1RSTR2_I2C4RST_Msk    = 0x2  // Bit mask of I2C4RST field.
	RCC_APB1RSTR2_I2C4RST        = 0x2  // Bit I2C4RST.
	RCC_APB1RSTR2_LPTIM2RST_Pos  = 0x5  // Position of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST_Msk  = 0x20 // Bit mask of LPTIM2RST field.
	RCC_APB1RSTR2_LPTIM2RST      = 0x20 // Bit LPTIM2RST.

	// APB2RSTR: APB2 peripheral reset register
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0       // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1       // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x1       // Bit SYSCFGRST.
	RCC_APB2RSTR_TIM1RST_Pos   = 0xb       // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x800     // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x800     // Bit TIM1RST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc       // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000    // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000    // Bit SPI1RST.
	RCC_APB2RSTR_TIM8RST_Pos   = 0xd       // Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk   = 0x2000    // Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST       = 0x2000    // Bit TIM8RST.
	RCC_APB2RSTR_USART1RST_Pos = 0xe       // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000    // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x4000    // Bit USART1RST.
	RCC_APB2RSTR_TIM15RST_Pos  = 0x10      // Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk  = 0x10000   // Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST      = 0x10000   // Bit TIM15RST.
	RCC_APB2RSTR_TIM16RST_Pos  = 0x11      // Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk  = 0x20000   // Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST      = 0x20000   // Bit TIM16RST.
	RCC_APB2RSTR_TIM17RST_Pos  = 0x12      // Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk  = 0x40000   // Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST      = 0x40000   // Bit TIM17RST.
	RCC_APB2RSTR_SAI1RST_Pos   = 0x15      // Position of SAI1RST field.
	RCC_APB2RSTR_SAI1RST_Msk   = 0x200000  // Bit mask of SAI1RST field.
	RCC_APB2RSTR_SAI1RST       = 0x200000  // Bit SAI1RST.
	RCC_APB2RSTR_SAI2RST_Pos   = 0x16      // Position of SAI2RST field.
	RCC_APB2RSTR_SAI2RST_Msk   = 0x400000  // Bit mask of SAI2RST field.
	RCC_APB2RSTR_SAI2RST       = 0x400000  // Bit SAI2RST.
	RCC_APB2RSTR_DFSDM1RST_Pos = 0x18      // Position of DFSDM1RST field.
	RCC_APB2RSTR_DFSDM1RST_Msk = 0x1000000 // Bit mask of DFSDM1RST field.
	RCC_APB2RSTR_DFSDM1RST     = 0x1000000 // Bit DFSDM1RST.
	RCC_APB2RSTR_LTDCRST_Pos   = 0x1a      // Position of LTDCRST field.
	RCC_APB2RSTR_LTDCRST_Msk   = 0x4000000 // Bit mask of LTDCRST field.
	RCC_APB2RSTR_LTDCRST       = 0x4000000 // Bit LTDCRST.
	RCC_APB2RSTR_DSIRST_Pos    = 0x1b      // Position of DSIRST field.
	RCC_APB2RSTR_DSIRST_Msk    = 0x8000000 // Bit mask of DSIRST field.
	RCC_APB2RSTR_DSIRST        = 0x8000000 // Bit DSIRST.

	// AHB1ENR: AHB1 peripheral clock enable           register
	RCC_AHB1ENR_DMA1EN_Pos    = 0x0     // Position of DMA1EN field.
	RCC_AHB1ENR_DMA1EN_Msk    = 0x1     // Bit mask of DMA1EN field.
	RCC_AHB1ENR_DMA1EN        = 0x1     // Bit DMA1EN.
	RCC_AHB1ENR_DMA2EN_Pos    = 0x1     // Position of DMA2EN field.
	RCC_AHB1ENR_DMA2EN_Msk    = 0x2     // Bit mask of DMA2EN field.
	RCC_AHB1ENR_DMA2EN        = 0x2     // Bit DMA2EN.
	RCC_AHB1ENR_DMAMUX1EN_Pos = 0x2     // Position of DMAMUX1EN field.
	RCC_AHB1ENR_DMAMUX1EN_Msk = 0x4     // Bit mask of DMAMUX1EN field.
	RCC_AHB1ENR_DMAMUX1EN     = 0x4     // Bit DMAMUX1EN.
	RCC_AHB1ENR_FLASHEN_Pos   = 0x8     // Position of FLASHEN field.
	RCC_AHB1ENR_FLASHEN_Msk   = 0x100   // Bit mask of FLASHEN field.
	RCC_AHB1ENR_FLASHEN       = 0x100   // Bit FLASHEN.
	RCC_AHB1ENR_CRCEN_Pos     = 0xc     // Position of CRCEN field.
	RCC_AHB1ENR_CRCEN_Msk     = 0x1000  // Bit mask of CRCEN field.
	RCC_AHB1ENR_CRCEN         = 0x1000  // Bit CRCEN.
	RCC_AHB1ENR_TSCEN_Pos     = 0x10    // Position of TSCEN field.
	RCC_AHB1ENR_TSCEN_Msk     = 0x10000 // Bit mask of TSCEN field.
	RCC_AHB1ENR_TSCEN         = 0x10000 // Bit TSCEN.
	RCC_AHB1ENR_DMA2DEN_Pos   = 0x11    // Position of DMA2DEN field.
	RCC_AHB1ENR_DMA2DEN_Msk   = 0x20000 // Bit mask of DMA2DEN field.
	RCC_AHB1ENR_DMA2DEN       = 0x20000 // Bit DMA2DEN.
	RCC_AHB1ENR_GFXMMUEN_Pos  = 0x12    // Position of GFXMMUEN field.
	RCC_AHB1ENR_GFXMMUEN_Msk  = 0x40000 // Bit mask of GFXMMUEN field.
	RCC_AHB1ENR_GFXMMUEN      = 0x40000 // Bit GFXMMUEN.

	// AHB2ENR: AHB2 peripheral clock enable           register
	RCC_AHB2ENR_GPIOAEN_Pos  = 0x0      // Position of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN_Msk  = 0x1      // Bit mask of GPIOAEN field.
	RCC_AHB2ENR_GPIOAEN      = 0x1      // Bit GPIOAEN.
	RCC_AHB2ENR_GPIOBEN_Pos  = 0x1      // Position of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN_Msk  = 0x2      // Bit mask of GPIOBEN field.
	RCC_AHB2ENR_GPIOBEN      = 0x2      // Bit GPIOBEN.
	RCC_AHB2ENR_GPIOCEN_Pos  = 0x2      // Position of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN_Msk  = 0x4      // Bit mask of GPIOCEN field.
	RCC_AHB2ENR_GPIOCEN      = 0x4      // Bit GPIOCEN.
	RCC_AHB2ENR_GPIODEN_Pos  = 0x3      // Position of GPIODEN field.
	RCC_AHB2ENR_GPIODEN_Msk  = 0x8      // Bit mask of GPIODEN field.
	RCC_AHB2ENR_GPIODEN      = 0x8      // Bit GPIODEN.
	RCC_AHB2ENR_GPIOEEN_Pos  = 0x4      // Position of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN_Msk  = 0x10     // Bit mask of GPIOEEN field.
	RCC_AHB2ENR_GPIOEEN      = 0x10     // Bit GPIOEEN.
	RCC_AHB2ENR_GPIOFEN_Pos  = 0x5      // Position of GPIOFEN field.
	RCC_AHB2ENR_GPIOFEN_Msk  = 0x20     // Bit mask of GPIOFEN field.
	RCC_AHB2ENR_GPIOFEN      = 0x20     // Bit GPIOFEN.
	RCC_AHB2ENR_GPIOGEN_Pos  = 0x6      // Position of GPIOGEN field.
	RCC_AHB2ENR_GPIOGEN_Msk  = 0x40     // Bit mask of GPIOGEN field.
	RCC_AHB2ENR_GPIOGEN      = 0x40     // Bit GPIOGEN.
	RCC_AHB2ENR_GPIOHEN_Pos  = 0x7      // Position of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN_Msk  = 0x80     // Bit mask of GPIOHEN field.
	RCC_AHB2ENR_GPIOHEN      = 0x80     // Bit GPIOHEN.
	RCC_AHB2ENR_GPIOIEN_Pos  = 0x8      // Position of GPIOIEN field.
	RCC_AHB2ENR_GPIOIEN_Msk  = 0x100    // Bit mask of GPIOIEN field.
	RCC_AHB2ENR_GPIOIEN      = 0x100    // Bit GPIOIEN.
	RCC_AHB2ENR_OTGFSEN_Pos  = 0xc      // Position of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN_Msk  = 0x1000   // Bit mask of OTGFSEN field.
	RCC_AHB2ENR_OTGFSEN      = 0x1000   // Bit OTGFSEN.
	RCC_AHB2ENR_ADCEN_Pos    = 0xd      // Position of ADCEN field.
	RCC_AHB2ENR_ADCEN_Msk    = 0x2000   // Bit mask of ADCEN field.
	RCC_AHB2ENR_ADCEN        = 0x2000   // Bit ADCEN.
	RCC_AHB2ENR_DCMIEN_Pos   = 0xe      // Position of DCMIEN field.
	RCC_AHB2ENR_DCMIEN_Msk   = 0x4000   // Bit mask of DCMIEN field.
	RCC_AHB2ENR_DCMIEN       = 0x4000   // Bit DCMIEN.
	RCC_AHB2ENR_AESEN_Pos    = 0x10     // Position of AESEN field.
	RCC_AHB2ENR_AESEN_Msk    = 0x10000  // Bit mask of AESEN field.
	RCC_AHB2ENR_AESEN        = 0x10000  // Bit AESEN.
	RCC_AHB2ENR_HASHEN_Pos   = 0x11     // Position of HASHEN field.
	RCC_AHB2ENR_HASHEN_Msk   = 0x20000  // Bit mask of HASHEN field.
	RCC_AHB2ENR_HASHEN       = 0x20000  // Bit HASHEN.
	RCC_AHB2ENR_RNGEN_Pos    = 0x12     // Position of RNGEN field.
	RCC_AHB2ENR_RNGEN_Msk    = 0x40000  // Bit mask of RNGEN field.
	RCC_AHB2ENR_RNGEN        = 0x40000  // Bit RNGEN.
	RCC_AHB2ENR_OSPIMEN_Pos  = 0x14     // Position of OSPIMEN field.
	RCC_AHB2ENR_OSPIMEN_Msk  = 0x100000 // Bit mask of OSPIMEN field.
	RCC_AHB2ENR_OSPIMEN      = 0x100000 // Bit OSPIMEN.
	RCC_AHB2ENR_SDMMC1EN_Pos = 0x16     // Position of SDMMC1EN field.
	RCC_AHB2ENR_SDMMC1EN_Msk = 0x400000 // Bit mask of SDMMC1EN field.
	RCC_AHB2ENR_SDMMC1EN     = 0x400000 // Bit SDMMC1EN.

	// AHB3ENR: AHB3 peripheral clock enable           register
	RCC_AHB3ENR_FMCEN_Pos   = 0x0   // Position of FMCEN field.
	RCC_AHB3ENR_FMCEN_Msk   = 0x1   // Bit mask of FMCEN field.
	RCC_AHB3ENR_FMCEN       = 0x1   // Bit FMCEN.
	RCC_AHB3ENR_OSPI2EN_Pos = 0x9   // Position of OSPI2EN field.
	RCC_AHB3ENR_OSPI2EN_Msk = 0x200 // Bit mask of OSPI2EN field.
	RCC_AHB3ENR_OSPI2EN     = 0x200 // Bit OSPI2EN.

	// APB1ENR1: APB1ENR1
	RCC_APB1ENR1_TIM2EN_Pos   = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR1_TIM2EN_Msk   = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR1_TIM2EN       = 0x1        // Bit TIM2EN.
	RCC_APB1ENR1_TIM3EN_Pos   = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR1_TIM3EN_Msk   = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR1_TIM3EN       = 0x2        // Bit TIM3EN.
	RCC_APB1ENR1_TIM4EN_Pos   = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR1_TIM4EN_Msk   = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR1_TIM4EN       = 0x4        // Bit TIM4EN.
	RCC_APB1ENR1_TIM5EN_Pos   = 0x3        // Position of TIM5EN field.
	RCC_APB1ENR1_TIM5EN_Msk   = 0x8        // Bit mask of TIM5EN field.
	RCC_APB1ENR1_TIM5EN       = 0x8        // Bit TIM5EN.
	RCC_APB1ENR1_TIM6EN_Pos   = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR1_TIM6EN_Msk   = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR1_TIM6EN       = 0x10       // Bit TIM6EN.
	RCC_APB1ENR1_TIM7EN_Pos   = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR1_TIM7EN_Msk   = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR1_TIM7EN       = 0x20       // Bit TIM7EN.
	RCC_APB1ENR1_RTCAPBEN_Pos = 0xa        // Position of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN_Msk = 0x400      // Bit mask of RTCAPBEN field.
	RCC_APB1ENR1_RTCAPBEN     = 0x400      // Bit RTCAPBEN.
	RCC_APB1ENR1_WWDGEN_Pos   = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR1_WWDGEN_Msk   = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR1_WWDGEN       = 0x800      // Bit WWDGEN.
	RCC_APB1ENR1_SPI2EN_Pos   = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR1_SPI2EN_Msk   = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR1_SPI2EN       = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR1_SP3EN_Pos    = 0xf        // Position of SP3EN field.
	RCC_APB1ENR1_SP3EN_Msk    = 0x8000     // Bit mask of SP3EN field.
	RCC_APB1ENR1_SP3EN        = 0x8000     // Bit SP3EN.
	RCC_APB1ENR1_USART2EN_Pos = 0x11       // Position of USART2EN field.
	RCC_APB1ENR1_USART2EN_Msk = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR1_USART2EN     = 0x20000    // Bit USART2EN.
	RCC_APB1ENR1_USART3EN_Pos = 0x12       // Position of USART3EN field.
	RCC_APB1ENR1_USART3EN_Msk = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR1_USART3EN     = 0x40000    // Bit USART3EN.
	RCC_APB1ENR1_UART4EN_Pos  = 0x13       // Position of UART4EN field.
	RCC_APB1ENR1_UART4EN_Msk  = 0x80000    // Bit mask of UART4EN field.
	RCC_APB1ENR1_UART4EN      = 0x80000    // Bit UART4EN.
	RCC_APB1ENR1_UART5EN_Pos  = 0x14       // Position of UART5EN field.
	RCC_APB1ENR1_UART5EN_Msk  = 0x100000   // Bit mask of UART5EN field.
	RCC_APB1ENR1_UART5EN      = 0x100000   // Bit UART5EN.
	RCC_APB1ENR1_I2C1EN_Pos   = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR1_I2C1EN_Msk   = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR1_I2C1EN       = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR1_I2C2EN_Pos   = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR1_I2C2EN_Msk   = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR1_I2C2EN       = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR1_I2C3EN_Pos   = 0x17       // Position of I2C3EN field.
	RCC_APB1ENR1_I2C3EN_Msk   = 0x800000   // Bit mask of I2C3EN field.
	RCC_APB1ENR1_I2C3EN       = 0x800000   // Bit I2C3EN.
	RCC_APB1ENR1_CRSEN_Pos    = 0x18       // Position of CRSEN field.
	RCC_APB1ENR1_CRSEN_Msk    = 0x1000000  // Bit mask of CRSEN field.
	RCC_APB1ENR1_CRSEN        = 0x1000000  // Bit CRSEN.
	RCC_APB1ENR1_CAN1EN_Pos   = 0x19       // Position of CAN1EN field.
	RCC_APB1ENR1_CAN1EN_Msk   = 0x2000000  // Bit mask of CAN1EN field.
	RCC_APB1ENR1_CAN1EN       = 0x2000000  // Bit CAN1EN.
	RCC_APB1ENR1_PWREN_Pos    = 0x1c       // Position of PWREN field.
	RCC_APB1ENR1_PWREN_Msk    = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR1_PWREN        = 0x10000000 // Bit PWREN.
	RCC_APB1ENR1_DAC1EN_Pos   = 0x1d       // Position of DAC1EN field.
	RCC_APB1ENR1_DAC1EN_Msk   = 0x20000000 // Bit mask of DAC1EN field.
	RCC_APB1ENR1_DAC1EN       = 0x20000000 // Bit DAC1EN.
	RCC_APB1ENR1_OPAMPEN_Pos  = 0x1e       // Position of OPAMPEN field.
	RCC_APB1ENR1_OPAMPEN_Msk  = 0x40000000 // Bit mask of OPAMPEN field.
	RCC_APB1ENR1_OPAMPEN      = 0x40000000 // Bit OPAMPEN.
	RCC_APB1ENR1_LPTIM1EN_Pos = 0x1f       // Position of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN_Msk = 0x80000000 // Bit mask of LPTIM1EN field.
	RCC_APB1ENR1_LPTIM1EN     = 0x80000000 // Bit LPTIM1EN.

	// APB1ENR2: APB1 peripheral clock enable register           2
	RCC_APB1ENR2_LPUART1EN_Pos = 0x0  // Position of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN_Msk = 0x1  // Bit mask of LPUART1EN field.
	RCC_APB1ENR2_LPUART1EN     = 0x1  // Bit LPUART1EN.
	RCC_APB1ENR2_I2C4EN_Pos    = 0x1  // Position of I2C4EN field.
	RCC_APB1ENR2_I2C4EN_Msk    = 0x2  // Bit mask of I2C4EN field.
	RCC_APB1ENR2_I2C4EN        = 0x2  // Bit I2C4EN.
	RCC_APB1ENR2_LPTIM2EN_Pos  = 0x5  // Position of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN_Msk  = 0x20 // Bit mask of LPTIM2EN field.
	RCC_APB1ENR2_LPTIM2EN      = 0x20 // Bit LPTIM2EN.

	// APB2ENR: APB2ENR
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0       // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1       // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x1       // Bit SYSCFGEN.
	RCC_APB2ENR_FWEN_Pos     = 0x7       // Position of FWEN field.
	RCC_APB2ENR_FWEN_Msk     = 0x80      // Bit mask of FWEN field.
	RCC_APB2ENR_FWEN         = 0x80      // Bit FWEN.
	RCC_APB2ENR_TIM1EN_Pos   = 0xb       // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x800     // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x800     // Bit TIM1EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc       // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000    // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000    // Bit SPI1EN.
	RCC_APB2ENR_TIM8EN_Pos   = 0xd       // Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk   = 0x2000    // Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN       = 0x2000    // Bit TIM8EN.
	RCC_APB2ENR_USART1EN_Pos = 0xe       // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000    // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x4000    // Bit USART1EN.
	RCC_APB2ENR_TIM15EN_Pos  = 0x10      // Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk  = 0x10000   // Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN      = 0x10000   // Bit TIM15EN.
	RCC_APB2ENR_TIM16EN_Pos  = 0x11      // Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk  = 0x20000   // Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN      = 0x20000   // Bit TIM16EN.
	RCC_APB2ENR_TIM17EN_Pos  = 0x12      // Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk  = 0x40000   // Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN      = 0x40000   // Bit TIM17EN.
	RCC_APB2ENR_SAI1EN_Pos   = 0x15      // Position of SAI1EN field.
	RCC_APB2ENR_SAI1EN_Msk   = 0x200000  // Bit mask of SAI1EN field.
	RCC_APB2ENR_SAI1EN       = 0x200000  // Bit SAI1EN.
	RCC_APB2ENR_SAI2EN_Pos   = 0x16      // Position of SAI2EN field.
	RCC_APB2ENR_SAI2EN_Msk   = 0x400000  // Bit mask of SAI2EN field.
	RCC_APB2ENR_SAI2EN       = 0x400000  // Bit SAI2EN.
	RCC_APB2ENR_DFSDM1EN_Pos = 0x18      // Position of DFSDM1EN field.
	RCC_APB2ENR_DFSDM1EN_Msk = 0x1000000 // Bit mask of DFSDM1EN field.
	RCC_APB2ENR_DFSDM1EN     = 0x1000000 // Bit DFSDM1EN.
	RCC_APB2ENR_LTDCEN_Pos   = 0x1a      // Position of LTDCEN field.
	RCC_APB2ENR_LTDCEN_Msk   = 0x4000000 // Bit mask of LTDCEN field.
	RCC_APB2ENR_LTDCEN       = 0x4000000 // Bit LTDCEN.
	RCC_APB2ENR_DSIEN_Pos    = 0x1b      // Position of DSIEN field.
	RCC_APB2ENR_DSIEN_Msk    = 0x8000000 // Bit mask of DSIEN field.
	RCC_APB2ENR_DSIEN        = 0x8000000 // Bit DSIEN.

	// AHB1SMENR: AHB1 peripheral clocks enable in Sleep and           Stop modes register
	RCC_AHB1SMENR_DMA1SMEN_Pos    = 0x0     // Position of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN_Msk    = 0x1     // Bit mask of DMA1SMEN field.
	RCC_AHB1SMENR_DMA1SMEN        = 0x1     // Bit DMA1SMEN.
	RCC_AHB1SMENR_DMA2SMEN_Pos    = 0x1     // Position of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN_Msk    = 0x2     // Bit mask of DMA2SMEN field.
	RCC_AHB1SMENR_DMA2SMEN        = 0x2     // Bit DMA2SMEN.
	RCC_AHB1SMENR_DMAMUX1SMEN_Pos = 0x2     // Position of DMAMUX1SMEN field.
	RCC_AHB1SMENR_DMAMUX1SMEN_Msk = 0x4     // Bit mask of DMAMUX1SMEN field.
	RCC_AHB1SMENR_DMAMUX1SMEN     = 0x4     // Bit DMAMUX1SMEN.
	RCC_AHB1SMENR_FLASHSMEN_Pos   = 0x8     // Position of FLASHSMEN field.
	RCC_AHB1SMENR_FLASHSMEN_Msk   = 0x100   // Bit mask of FLASHSMEN field.
	RCC_AHB1SMENR_FLASHSMEN       = 0x100   // Bit FLASHSMEN.
	RCC_AHB1SMENR_SRAM1SMEN_Pos   = 0x9     // Position of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN_Msk   = 0x200   // Bit mask of SRAM1SMEN field.
	RCC_AHB1SMENR_SRAM1SMEN       = 0x200   // Bit SRAM1SMEN.
	RCC_AHB1SMENR_CRCSMEN_Pos     = 0xc     // Position of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN_Msk     = 0x1000  // Bit mask of CRCSMEN field.
	RCC_AHB1SMENR_CRCSMEN         = 0x1000  // Bit CRCSMEN.
	RCC_AHB1SMENR_TSCSMEN_Pos     = 0x10    // Position of TSCSMEN field.
	RCC_AHB1SMENR_TSCSMEN_Msk     = 0x10000 // Bit mask of TSCSMEN field.
	RCC_AHB1SMENR_TSCSMEN         = 0x10000 // Bit TSCSMEN.
	RCC_AHB1SMENR_DMA2DSMEN_Pos   = 0x11    // Position of DMA2DSMEN field.
	RCC_AHB1SMENR_DMA2DSMEN_Msk   = 0x20000 // Bit mask of DMA2DSMEN field.
	RCC_AHB1SMENR_DMA2DSMEN       = 0x20000 // Bit DMA2DSMEN.
	RCC_AHB1SMENR_GFXMMUSMEN_Pos  = 0x12    // Position of GFXMMUSMEN field.
	RCC_AHB1SMENR_GFXMMUSMEN_Msk  = 0x40000 // Bit mask of GFXMMUSMEN field.
	RCC_AHB1SMENR_GFXMMUSMEN      = 0x40000 // Bit GFXMMUSMEN.

	// AHB2SMENR: AHB2 peripheral clocks enable in Sleep and           Stop modes register
	RCC_AHB2SMENR_GPIOASMEN_Pos  = 0x0      // Position of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN_Msk  = 0x1      // Bit mask of GPIOASMEN field.
	RCC_AHB2SMENR_GPIOASMEN      = 0x1      // Bit GPIOASMEN.
	RCC_AHB2SMENR_GPIOBSMEN_Pos  = 0x1      // Position of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN_Msk  = 0x2      // Bit mask of GPIOBSMEN field.
	RCC_AHB2SMENR_GPIOBSMEN      = 0x2      // Bit GPIOBSMEN.
	RCC_AHB2SMENR_GPIOCSMEN_Pos  = 0x2      // Position of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN_Msk  = 0x4      // Bit mask of GPIOCSMEN field.
	RCC_AHB2SMENR_GPIOCSMEN      = 0x4      // Bit GPIOCSMEN.
	RCC_AHB2SMENR_GPIODSMEN_Pos  = 0x3      // Position of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN_Msk  = 0x8      // Bit mask of GPIODSMEN field.
	RCC_AHB2SMENR_GPIODSMEN      = 0x8      // Bit GPIODSMEN.
	RCC_AHB2SMENR_GPIOESMEN_Pos  = 0x4      // Position of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN_Msk  = 0x10     // Bit mask of GPIOESMEN field.
	RCC_AHB2SMENR_GPIOESMEN      = 0x10     // Bit GPIOESMEN.
	RCC_AHB2SMENR_GPIOFSMEN_Pos  = 0x5      // Position of GPIOFSMEN field.
	RCC_AHB2SMENR_GPIOFSMEN_Msk  = 0x20     // Bit mask of GPIOFSMEN field.
	RCC_AHB2SMENR_GPIOFSMEN      = 0x20     // Bit GPIOFSMEN.
	RCC_AHB2SMENR_GPIOGSMEN_Pos  = 0x6      // Position of GPIOGSMEN field.
	RCC_AHB2SMENR_GPIOGSMEN_Msk  = 0x40     // Bit mask of GPIOGSMEN field.
	RCC_AHB2SMENR_GPIOGSMEN      = 0x40     // Bit GPIOGSMEN.
	RCC_AHB2SMENR_GPIOHSMEN_Pos  = 0x7      // Position of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN_Msk  = 0x80     // Bit mask of GPIOHSMEN field.
	RCC_AHB2SMENR_GPIOHSMEN      = 0x80     // Bit GPIOHSMEN.
	RCC_AHB2SMENR_GPIOISMEN_Pos  = 0x8      // Position of GPIOISMEN field.
	RCC_AHB2SMENR_GPIOISMEN_Msk  = 0x100    // Bit mask of GPIOISMEN field.
	RCC_AHB2SMENR_GPIOISMEN      = 0x100    // Bit GPIOISMEN.
	RCC_AHB2SMENR_SRAM2SMEN_Pos  = 0x9      // Position of SRAM2SMEN field.
	RCC_AHB2SMENR_SRAM2SMEN_Msk  = 0x200    // Bit mask of SRAM2SMEN field.
	RCC_AHB2SMENR_SRAM2SMEN      = 0x200    // Bit SRAM2SMEN.
	RCC_AHB2SMENR_SRAM3SMEN_Pos  = 0xa      // Position of SRAM3SMEN field.
	RCC_AHB2SMENR_SRAM3SMEN_Msk  = 0x400    // Bit mask of SRAM3SMEN field.
	RCC_AHB2SMENR_SRAM3SMEN      = 0x400    // Bit SRAM3SMEN.
	RCC_AHB2SMENR_OTGFSSMEN_Pos  = 0xc      // Position of OTGFSSMEN field.
	RCC_AHB2SMENR_OTGFSSMEN_Msk  = 0x1000   // Bit mask of OTGFSSMEN field.
	RCC_AHB2SMENR_OTGFSSMEN      = 0x1000   // Bit OTGFSSMEN.
	RCC_AHB2SMENR_ADCFSSMEN_Pos  = 0xd      // Position of ADCFSSMEN field.
	RCC_AHB2SMENR_ADCFSSMEN_Msk  = 0x2000   // Bit mask of ADCFSSMEN field.
	RCC_AHB2SMENR_ADCFSSMEN      = 0x2000   // Bit ADCFSSMEN.
	RCC_AHB2SMENR_DCMISMEN_Pos   = 0xe      // Position of DCMISMEN field.
	RCC_AHB2SMENR_DCMISMEN_Msk   = 0x4000   // Bit mask of DCMISMEN field.
	RCC_AHB2SMENR_DCMISMEN       = 0x4000   // Bit DCMISMEN.
	RCC_AHB2SMENR_AESSMEN_Pos    = 0x10     // Position of AESSMEN field.
	RCC_AHB2SMENR_AESSMEN_Msk    = 0x10000  // Bit mask of AESSMEN field.
	RCC_AHB2SMENR_AESSMEN        = 0x10000  // Bit AESSMEN.
	RCC_AHB2SMENR_HASHSMEN_Pos   = 0x11     // Position of HASHSMEN field.
	RCC_AHB2SMENR_HASHSMEN_Msk   = 0x20000  // Bit mask of HASHSMEN field.
	RCC_AHB2SMENR_HASHSMEN       = 0x20000  // Bit HASHSMEN.
	RCC_AHB2SMENR_RNGSMEN_Pos    = 0x12     // Position of RNGSMEN field.
	RCC_AHB2SMENR_RNGSMEN_Msk    = 0x40000  // Bit mask of RNGSMEN field.
	RCC_AHB2SMENR_RNGSMEN        = 0x40000  // Bit RNGSMEN.
	RCC_AHB2SMENR_OSPIMSMEN_Pos  = 0x14     // Position of OSPIMSMEN field.
	RCC_AHB2SMENR_OSPIMSMEN_Msk  = 0x100000 // Bit mask of OSPIMSMEN field.
	RCC_AHB2SMENR_OSPIMSMEN      = 0x100000 // Bit OSPIMSMEN.
	RCC_AHB2SMENR_SDMMC1SMEN_Pos = 0x16     // Position of SDMMC1SMEN field.
	RCC_AHB2SMENR_SDMMC1SMEN_Msk = 0x400000 // Bit mask of SDMMC1SMEN field.
	RCC_AHB2SMENR_SDMMC1SMEN     = 0x400000 // Bit SDMMC1SMEN.

	// AHB3SMENR: AHB3 peripheral clocks enable in Sleep and           Stop modes register
	RCC_AHB3SMENR_FMCSMEN_Pos  = 0x0   // Position of FMCSMEN field.
	RCC_AHB3SMENR_FMCSMEN_Msk  = 0x1   // Bit mask of FMCSMEN field.
	RCC_AHB3SMENR_FMCSMEN      = 0x1   // Bit FMCSMEN.
	RCC_AHB3SMENR_OCTOSPI2_Pos = 0x9   // Position of OCTOSPI2 field.
	RCC_AHB3SMENR_OCTOSPI2_Msk = 0x200 // Bit mask of OCTOSPI2 field.
	RCC_AHB3SMENR_OCTOSPI2     = 0x200 // Bit OCTOSPI2.

	// APB1SMENR1: APB1SMENR1
	RCC_APB1SMENR1_TIM2SMEN_Pos   = 0x0        // Position of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN_Msk   = 0x1        // Bit mask of TIM2SMEN field.
	RCC_APB1SMENR1_TIM2SMEN       = 0x1        // Bit TIM2SMEN.
	RCC_APB1SMENR1_TIM3SMEN_Pos   = 0x1        // Position of TIM3SMEN field.
	RCC_APB1SMENR1_TIM3SMEN_Msk   = 0x2        // Bit mask of TIM3SMEN field.
	RCC_APB1SMENR1_TIM3SMEN       = 0x2        // Bit TIM3SMEN.
	RCC_APB1SMENR1_TIM4SMEN_Pos   = 0x2        // Position of TIM4SMEN field.
	RCC_APB1SMENR1_TIM4SMEN_Msk   = 0x4        // Bit mask of TIM4SMEN field.
	RCC_APB1SMENR1_TIM4SMEN       = 0x4        // Bit TIM4SMEN.
	RCC_APB1SMENR1_TIM5SMEN_Pos   = 0x3        // Position of TIM5SMEN field.
	RCC_APB1SMENR1_TIM5SMEN_Msk   = 0x8        // Bit mask of TIM5SMEN field.
	RCC_APB1SMENR1_TIM5SMEN       = 0x8        // Bit TIM5SMEN.
	RCC_APB1SMENR1_TIM6SMEN_Pos   = 0x4        // Position of TIM6SMEN field.
	RCC_APB1SMENR1_TIM6SMEN_Msk   = 0x10       // Bit mask of TIM6SMEN field.
	RCC_APB1SMENR1_TIM6SMEN       = 0x10       // Bit TIM6SMEN.
	RCC_APB1SMENR1_TIM7SMEN_Pos   = 0x5        // Position of TIM7SMEN field.
	RCC_APB1SMENR1_TIM7SMEN_Msk   = 0x20       // Bit mask of TIM7SMEN field.
	RCC_APB1SMENR1_TIM7SMEN       = 0x20       // Bit TIM7SMEN.
	RCC_APB1SMENR1_RTCAPBSMEN_Pos = 0xa        // Position of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN_Msk = 0x400      // Bit mask of RTCAPBSMEN field.
	RCC_APB1SMENR1_RTCAPBSMEN     = 0x400      // Bit RTCAPBSMEN.
	RCC_APB1SMENR1_WWDGSMEN_Pos   = 0xb        // Position of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN_Msk   = 0x800      // Bit mask of WWDGSMEN field.
	RCC_APB1SMENR1_WWDGSMEN       = 0x800      // Bit WWDGSMEN.
	RCC_APB1SMENR1_SPI2SMEN_Pos   = 0xe        // Position of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN_Msk   = 0x4000     // Bit mask of SPI2SMEN field.
	RCC_APB1SMENR1_SPI2SMEN       = 0x4000     // Bit SPI2SMEN.
	RCC_APB1SMENR1_SP3SMEN_Pos    = 0xf        // Position of SP3SMEN field.
	RCC_APB1SMENR1_SP3SMEN_Msk    = 0x8000     // Bit mask of SP3SMEN field.
	RCC_APB1SMENR1_SP3SMEN        = 0x8000     // Bit SP3SMEN.
	RCC_APB1SMENR1_USART2SMEN_Pos = 0x11       // Position of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN_Msk = 0x20000    // Bit mask of USART2SMEN field.
	RCC_APB1SMENR1_USART2SMEN     = 0x20000    // Bit USART2SMEN.
	RCC_APB1SMENR1_USART3SMEN_Pos = 0x12       // Position of USART3SMEN field.
	RCC_APB1SMENR1_USART3SMEN_Msk = 0x40000    // Bit mask of USART3SMEN field.
	RCC_APB1SMENR1_USART3SMEN     = 0x40000    // Bit USART3SMEN.
	RCC_APB1SMENR1_UART4SMEN_Pos  = 0x13       // Position of UART4SMEN field.
	RCC_APB1SMENR1_UART4SMEN_Msk  = 0x80000    // Bit mask of UART4SMEN field.
	RCC_APB1SMENR1_UART4SMEN      = 0x80000    // Bit UART4SMEN.
	RCC_APB1SMENR1_UART5SMEN_Pos  = 0x14       // Position of UART5SMEN field.
	RCC_APB1SMENR1_UART5SMEN_Msk  = 0x100000   // Bit mask of UART5SMEN field.
	RCC_APB1SMENR1_UART5SMEN      = 0x100000   // Bit UART5SMEN.
	RCC_APB1SMENR1_I2C1SMEN_Pos   = 0x15       // Position of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN_Msk   = 0x200000   // Bit mask of I2C1SMEN field.
	RCC_APB1SMENR1_I2C1SMEN       = 0x200000   // Bit I2C1SMEN.
	RCC_APB1SMENR1_I2C2SMEN_Pos   = 0x16       // Position of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN_Msk   = 0x400000   // Bit mask of I2C2SMEN field.
	RCC_APB1SMENR1_I2C2SMEN       = 0x400000   // Bit I2C2SMEN.
	RCC_APB1SMENR1_I2C3SMEN_Pos   = 0x17       // Position of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN_Msk   = 0x800000   // Bit mask of I2C3SMEN field.
	RCC_APB1SMENR1_I2C3SMEN       = 0x800000   // Bit I2C3SMEN.
	RCC_APB1SMENR1_CRSSMEN_Pos    = 0x18       // Position of CRSSMEN field.
	RCC_APB1SMENR1_CRSSMEN_Msk    = 0x1000000  // Bit mask of CRSSMEN field.
	RCC_APB1SMENR1_CRSSMEN        = 0x1000000  // Bit CRSSMEN.
	RCC_APB1SMENR1_CAN1SMEN_Pos   = 0x19       // Position of CAN1SMEN field.
	RCC_APB1SMENR1_CAN1SMEN_Msk   = 0x2000000  // Bit mask of CAN1SMEN field.
	RCC_APB1SMENR1_CAN1SMEN       = 0x2000000  // Bit CAN1SMEN.
	RCC_APB1SMENR1_PWRSMEN_Pos    = 0x1c       // Position of PWRSMEN field.
	RCC_APB1SMENR1_PWRSMEN_Msk    = 0x10000000 // Bit mask of PWRSMEN field.
	RCC_APB1SMENR1_PWRSMEN        = 0x10000000 // Bit PWRSMEN.
	RCC_APB1SMENR1_DAC1SMEN_Pos   = 0x1d       // Position of DAC1SMEN field.
	RCC_APB1SMENR1_DAC1SMEN_Msk   = 0x20000000 // Bit mask of DAC1SMEN field.
	RCC_APB1SMENR1_DAC1SMEN       = 0x20000000 // Bit DAC1SMEN.
	RCC_APB1SMENR1_OPAMPSMEN_Pos  = 0x1e       // Position of OPAMPSMEN field.
	RCC_APB1SMENR1_OPAMPSMEN_Msk  = 0x40000000 // Bit mask of OPAMPSMEN field.
	RCC_APB1SMENR1_OPAMPSMEN      = 0x40000000 // Bit OPAMPSMEN.
	RCC_APB1SMENR1_LPTIM1SMEN_Pos = 0x1f       // Position of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN_Msk = 0x80000000 // Bit mask of LPTIM1SMEN field.
	RCC_APB1SMENR1_LPTIM1SMEN     = 0x80000000 // Bit LPTIM1SMEN.

	// APB1SMENR2: APB1 peripheral clocks enable in Sleep and           Stop modes register 2
	RCC_APB1SMENR2_LPUART1SMEN_Pos = 0x0  // Position of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN_Msk = 0x1  // Bit mask of LPUART1SMEN field.
	RCC_APB1SMENR2_LPUART1SMEN     = 0x1  // Bit LPUART1SMEN.
	RCC_APB1SMENR2_I2C4SMEN_Pos    = 0x1  // Position of I2C4SMEN field.
	RCC_APB1SMENR2_I2C4SMEN_Msk    = 0x2  // Bit mask of I2C4SMEN field.
	RCC_APB1SMENR2_I2C4SMEN        = 0x2  // Bit I2C4SMEN.
	RCC_APB1SMENR2_LPTIM2SMEN_Pos  = 0x5  // Position of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN_Msk  = 0x20 // Bit mask of LPTIM2SMEN field.
	RCC_APB1SMENR2_LPTIM2SMEN      = 0x20 // Bit LPTIM2SMEN.

	// APB2SMENR: APB2SMENR
	RCC_APB2SMENR_SYSCFGSMEN_Pos = 0x0       // Position of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN_Msk = 0x1       // Bit mask of SYSCFGSMEN field.
	RCC_APB2SMENR_SYSCFGSMEN     = 0x1       // Bit SYSCFGSMEN.
	RCC_APB2SMENR_TIM1SMEN_Pos   = 0xb       // Position of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN_Msk   = 0x800     // Bit mask of TIM1SMEN field.
	RCC_APB2SMENR_TIM1SMEN       = 0x800     // Bit TIM1SMEN.
	RCC_APB2SMENR_SPI1SMEN_Pos   = 0xc       // Position of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN_Msk   = 0x1000    // Bit mask of SPI1SMEN field.
	RCC_APB2SMENR_SPI1SMEN       = 0x1000    // Bit SPI1SMEN.
	RCC_APB2SMENR_TIM8SMEN_Pos   = 0xd       // Position of TIM8SMEN field.
	RCC_APB2SMENR_TIM8SMEN_Msk   = 0x2000    // Bit mask of TIM8SMEN field.
	RCC_APB2SMENR_TIM8SMEN       = 0x2000    // Bit TIM8SMEN.
	RCC_APB2SMENR_USART1SMEN_Pos = 0xe       // Position of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN_Msk = 0x4000    // Bit mask of USART1SMEN field.
	RCC_APB2SMENR_USART1SMEN     = 0x4000    // Bit USART1SMEN.
	RCC_APB2SMENR_TIM15SMEN_Pos  = 0x10      // Position of TIM15SMEN field.
	RCC_APB2SMENR_TIM15SMEN_Msk  = 0x10000   // Bit mask of TIM15SMEN field.
	RCC_APB2SMENR_TIM15SMEN      = 0x10000   // Bit TIM15SMEN.
	RCC_APB2SMENR_TIM16SMEN_Pos  = 0x11      // Position of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN_Msk  = 0x20000   // Bit mask of TIM16SMEN field.
	RCC_APB2SMENR_TIM16SMEN      = 0x20000   // Bit TIM16SMEN.
	RCC_APB2SMENR_TIM17SMEN_Pos  = 0x12      // Position of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN_Msk  = 0x40000   // Bit mask of TIM17SMEN field.
	RCC_APB2SMENR_TIM17SMEN      = 0x40000   // Bit TIM17SMEN.
	RCC_APB2SMENR_SAI1SMEN_Pos   = 0x15      // Position of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN_Msk   = 0x200000  // Bit mask of SAI1SMEN field.
	RCC_APB2SMENR_SAI1SMEN       = 0x200000  // Bit SAI1SMEN.
	RCC_APB2SMENR_SAI2SMEN_Pos   = 0x16      // Position of SAI2SMEN field.
	RCC_APB2SMENR_SAI2SMEN_Msk   = 0x400000  // Bit mask of SAI2SMEN field.
	RCC_APB2SMENR_SAI2SMEN       = 0x400000  // Bit SAI2SMEN.
	RCC_APB2SMENR_DFSDM1SMEN_Pos = 0x18      // Position of DFSDM1SMEN field.
	RCC_APB2SMENR_DFSDM1SMEN_Msk = 0x1000000 // Bit mask of DFSDM1SMEN field.
	RCC_APB2SMENR_DFSDM1SMEN     = 0x1000000 // Bit DFSDM1SMEN.
	RCC_APB2SMENR_LTDCSMEN_Pos   = 0x1a      // Position of LTDCSMEN field.
	RCC_APB2SMENR_LTDCSMEN_Msk   = 0x4000000 // Bit mask of LTDCSMEN field.
	RCC_APB2SMENR_LTDCSMEN       = 0x4000000 // Bit LTDCSMEN.
	RCC_APB2SMENR_DSISMEN_Pos    = 0x1b      // Position of DSISMEN field.
	RCC_APB2SMENR_DSISMEN_Msk    = 0x8000000 // Bit mask of DSISMEN field.
	RCC_APB2SMENR_DSISMEN        = 0x8000000 // Bit DSISMEN.

	// CCIPR: CCIPR
	RCC_CCIPR_ADCSEL_Pos     = 0x1c       // Position of ADCSEL field.
	RCC_CCIPR_ADCSEL_Msk     = 0x30000000 // Bit mask of ADCSEL field.
	RCC_CCIPR_CLK48SEL_Pos   = 0x1a       // Position of CLK48SEL field.
	RCC_CCIPR_CLK48SEL_Msk   = 0xc000000  // Bit mask of CLK48SEL field.
	RCC_CCIPR_SAI2SEL_Pos    = 0x18       // Position of SAI2SEL field.
	RCC_CCIPR_SAI2SEL_Msk    = 0x3000000  // Bit mask of SAI2SEL field.
	RCC_CCIPR_SAI1SEL_Pos    = 0x16       // Position of SAI1SEL field.
	RCC_CCIPR_SAI1SEL_Msk    = 0xc00000   // Bit mask of SAI1SEL field.
	RCC_CCIPR_LPTIM2SEL_Pos  = 0x14       // Position of LPTIM2SEL field.
	RCC_CCIPR_LPTIM2SEL_Msk  = 0x300000   // Bit mask of LPTIM2SEL field.
	RCC_CCIPR_LPTIM1SEL_Pos  = 0x12       // Position of LPTIM1SEL field.
	RCC_CCIPR_LPTIM1SEL_Msk  = 0xc0000    // Bit mask of LPTIM1SEL field.
	RCC_CCIPR_I2C3SEL_Pos    = 0x10       // Position of I2C3SEL field.
	RCC_CCIPR_I2C3SEL_Msk    = 0x30000    // Bit mask of I2C3SEL field.
	RCC_CCIPR_I2C2SEL_Pos    = 0xe        // Position of I2C2SEL field.
	RCC_CCIPR_I2C2SEL_Msk    = 0xc000     // Bit mask of I2C2SEL field.
	RCC_CCIPR_I2C1SEL_Pos    = 0xc        // Position of I2C1SEL field.
	RCC_CCIPR_I2C1SEL_Msk    = 0x3000     // Bit mask of I2C1SEL field.
	RCC_CCIPR_LPUART1SEL_Pos = 0xa        // Position of LPUART1SEL field.
	RCC_CCIPR_LPUART1SEL_Msk = 0xc00      // Bit mask of LPUART1SEL field.
	RCC_CCIPR_UART5SEL_Pos   = 0x8        // Position of UART5SEL field.
	RCC_CCIPR_UART5SEL_Msk   = 0x300      // Bit mask of UART5SEL field.
	RCC_CCIPR_UART4SEL_Pos   = 0x6        // Position of UART4SEL field.
	RCC_CCIPR_UART4SEL_Msk   = 0xc0       // Bit mask of UART4SEL field.
	RCC_CCIPR_USART3SEL_Pos  = 0x4        // Position of USART3SEL field.
	RCC_CCIPR_USART3SEL_Msk  = 0x30       // Bit mask of USART3SEL field.
	RCC_CCIPR_USART2SEL_Pos  = 0x2        // Position of USART2SEL field.
	RCC_CCIPR_USART2SEL_Msk  = 0xc        // Bit mask of USART2SEL field.
	RCC_CCIPR_USART1SEL_Pos  = 0x0        // Position of USART1SEL field.
	RCC_CCIPR_USART1SEL_Msk  = 0x3        // Bit mask of USART1SEL field.

	// BDCR: BDCR
	RCC_BDCR_LSCOSEL_Pos  = 0x19      // Position of LSCOSEL field.
	RCC_BDCR_LSCOSEL_Msk  = 0x2000000 // Bit mask of LSCOSEL field.
	RCC_BDCR_LSCOSEL      = 0x2000000 // Bit LSCOSEL.
	RCC_BDCR_LSCOEN_Pos   = 0x18      // Position of LSCOEN field.
	RCC_BDCR_LSCOEN_Msk   = 0x1000000 // Bit mask of LSCOEN field.
	RCC_BDCR_LSCOEN       = 0x1000000 // Bit LSCOEN.
	RCC_BDCR_BDRST_Pos    = 0x10      // Position of BDRST field.
	RCC_BDCR_BDRST_Msk    = 0x10000   // Bit mask of BDRST field.
	RCC_BDCR_BDRST        = 0x10000   // Bit BDRST.
	RCC_BDCR_RTCEN_Pos    = 0xf       // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk    = 0x8000    // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN        = 0x8000    // Bit RTCEN.
	RCC_BDCR_RTCSEL_Pos   = 0x8       // Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk   = 0x300     // Bit mask of RTCSEL field.
	RCC_BDCR_LSECSSD_Pos  = 0x6       // Position of LSECSSD field.
	RCC_BDCR_LSECSSD_Msk  = 0x40      // Bit mask of LSECSSD field.
	RCC_BDCR_LSECSSD      = 0x40      // Bit LSECSSD.
	RCC_BDCR_LSECSSON_Pos = 0x5       // Position of LSECSSON field.
	RCC_BDCR_LSECSSON_Msk = 0x20      // Bit mask of LSECSSON field.
	RCC_BDCR_LSECSSON     = 0x20      // Bit LSECSSON.
	RCC_BDCR_LSEDRV_Pos   = 0x3       // Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk   = 0x18      // Bit mask of LSEDRV field.
	RCC_BDCR_LSEBYP_Pos   = 0x2       // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk   = 0x4       // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP       = 0x4       // Bit LSEBYP.
	RCC_BDCR_LSERDY_Pos   = 0x1       // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk   = 0x2       // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY       = 0x2       // Bit LSERDY.
	RCC_BDCR_LSEON_Pos    = 0x0       // Position of LSEON field.
	RCC_BDCR_LSEON_Msk    = 0x1       // Bit mask of LSEON field.
	RCC_BDCR_LSEON        = 0x1       // Bit LSEON.

	// CSR: CSR
	RCC_CSR_LPWRSTF_Pos   = 0x1f       // Position of LPWRSTF field.
	RCC_CSR_LPWRSTF_Msk   = 0x80000000 // Bit mask of LPWRSTF field.
	RCC_CSR_LPWRSTF       = 0x80000000 // Bit LPWRSTF.
	RCC_CSR_WWDGRSTF_Pos  = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk  = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF      = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_IWDGRSTF_Pos  = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk  = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF      = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_SFTRSTF_Pos   = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk   = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF       = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_BORRSTF_Pos   = 0x1b       // Position of BORRSTF field.
	RCC_CSR_BORRSTF_Msk   = 0x8000000  // Bit mask of BORRSTF field.
	RCC_CSR_BORRSTF       = 0x8000000  // Bit BORRSTF.
	RCC_CSR_PINRSTF_Pos   = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk   = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF       = 0x4000000  // Bit PINRSTF.
	RCC_CSR_OBLRSTF_Pos   = 0x19       // Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk   = 0x2000000  // Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF       = 0x2000000  // Bit OBLRSTF.
	RCC_CSR_FWRSTF_Pos    = 0x18       // Position of FWRSTF field.
	RCC_CSR_FWRSTF_Msk    = 0x1000000  // Bit mask of FWRSTF field.
	RCC_CSR_FWRSTF        = 0x1000000  // Bit FWRSTF.
	RCC_CSR_RMVF_Pos      = 0x17       // Position of RMVF field.
	RCC_CSR_RMVF_Msk      = 0x800000   // Bit mask of RMVF field.
	RCC_CSR_RMVF          = 0x800000   // Bit RMVF.
	RCC_CSR_MSISRANGE_Pos = 0x8        // Position of MSISRANGE field.
	RCC_CSR_MSISRANGE_Msk = 0xf00      // Bit mask of MSISRANGE field.
	RCC_CSR_LSIRDY_Pos    = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk    = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY        = 0x2        // Bit LSIRDY.
	RCC_CSR_LSION_Pos     = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk     = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION         = 0x1        // Bit LSION.

	// CRRCR: Clock recovery RC register
	RCC_CRRCR_HSI48ON_Pos  = 0x0    // Position of HSI48ON field.
	RCC_CRRCR_HSI48ON_Msk  = 0x1    // Bit mask of HSI48ON field.
	RCC_CRRCR_HSI48ON      = 0x1    // Bit HSI48ON.
	RCC_CRRCR_HSI48RDY_Pos = 0x1    // Position of HSI48RDY field.
	RCC_CRRCR_HSI48RDY_Msk = 0x2    // Bit mask of HSI48RDY field.
	RCC_CRRCR_HSI48RDY     = 0x2    // Bit HSI48RDY.
	RCC_CRRCR_HSI48CAL_Pos = 0x7    // Position of HSI48CAL field.
	RCC_CRRCR_HSI48CAL_Msk = 0xff80 // Bit mask of HSI48CAL field.

	// CCIPR2: Peripherals independent clock configuration           register
	RCC_CCIPR2_I2C4SEL_Pos     = 0x0      // Position of I2C4SEL field.
	RCC_CCIPR2_I2C4SEL_Msk     = 0x3      // Bit mask of I2C4SEL field.
	RCC_CCIPR2_DFSDMSEL_Pos    = 0x2      // Position of DFSDMSEL field.
	RCC_CCIPR2_DFSDMSEL_Msk    = 0x4      // Bit mask of DFSDMSEL field.
	RCC_CCIPR2_DFSDMSEL        = 0x4      // Bit DFSDMSEL.
	RCC_CCIPR2_ADFSDMSEL_Pos   = 0x3      // Position of ADFSDMSEL field.
	RCC_CCIPR2_ADFSDMSEL_Msk   = 0x18     // Bit mask of ADFSDMSEL field.
	RCC_CCIPR2_SAI1SEL_Pos     = 0x5      // Position of SAI1SEL field.
	RCC_CCIPR2_SAI1SEL_Msk     = 0xe0     // Bit mask of SAI1SEL field.
	RCC_CCIPR2_SAI2SEL_Pos     = 0x8      // Position of SAI2SEL field.
	RCC_CCIPR2_SAI2SEL_Msk     = 0x700    // Bit mask of SAI2SEL field.
	RCC_CCIPR2_DSISEL_Pos      = 0xc      // Position of DSISEL field.
	RCC_CCIPR2_DSISEL_Msk      = 0x1000   // Bit mask of DSISEL field.
	RCC_CCIPR2_DSISEL          = 0x1000   // Bit DSISEL.
	RCC_CCIPR2_SDMMCSEL_Pos    = 0xe      // Position of SDMMCSEL field.
	RCC_CCIPR2_SDMMCSEL_Msk    = 0x4000   // Bit mask of SDMMCSEL field.
	RCC_CCIPR2_SDMMCSEL        = 0x4000   // Bit SDMMCSEL.
	RCC_CCIPR2_PLLSAI2DIVR_Pos = 0x10     // Position of PLLSAI2DIVR field.
	RCC_CCIPR2_PLLSAI2DIVR_Msk = 0x30000  // Bit mask of PLLSAI2DIVR field.
	RCC_CCIPR2_OSPISEL_Pos     = 0x14     // Position of OSPISEL field.
	RCC_CCIPR2_OSPISEL_Msk     = 0x300000 // Bit mask of OSPISEL field.
)

// Bitfields for PWR: Power control
const (
	// CR1: Power control register 1
	PWR_CR1_LPR_Pos  = 0xe    // Position of LPR field.
	PWR_CR1_LPR_Msk  = 0x4000 // Bit mask of LPR field.
	PWR_CR1_LPR      = 0x4000 // Bit LPR.
	PWR_CR1_VOS_Pos  = 0x9    // Position of VOS field.
	PWR_CR1_VOS_Msk  = 0x600  // Bit mask of VOS field.
	PWR_CR1_DBP_Pos  = 0x8    // Position of DBP field.
	PWR_CR1_DBP_Msk  = 0x100  // Bit mask of DBP field.
	PWR_CR1_DBP      = 0x100  // Bit DBP.
	PWR_CR1_LPMS_Pos = 0x0    // Position of LPMS field.
	PWR_CR1_LPMS_Msk = 0x7    // Bit mask of LPMS field.

	// CR2: Power control register 2
	PWR_CR2_USV_Pos   = 0xa   // Position of USV field.
	PWR_CR2_USV_Msk   = 0x400 // Bit mask of USV field.
	PWR_CR2_USV       = 0x400 // Bit USV.
	PWR_CR2_IOSV_Pos  = 0x9   // Position of IOSV field.
	PWR_CR2_IOSV_Msk  = 0x200 // Bit mask of IOSV field.
	PWR_CR2_IOSV      = 0x200 // Bit IOSV.
	PWR_CR2_PVME4_Pos = 0x7   // Position of PVME4 field.
	PWR_CR2_PVME4_Msk = 0x80  // Bit mask of PVME4 field.
	PWR_CR2_PVME4     = 0x80  // Bit PVME4.
	PWR_CR2_PVME3_Pos = 0x6   // Position of PVME3 field.
	PWR_CR2_PVME3_Msk = 0x40  // Bit mask of PVME3 field.
	PWR_CR2_PVME3     = 0x40  // Bit PVME3.
	PWR_CR2_PVME2_Pos = 0x5   // Position of PVME2 field.
	PWR_CR2_PVME2_Msk = 0x20  // Bit mask of PVME2 field.
	PWR_CR2_PVME2     = 0x20  // Bit PVME2.
	PWR_CR2_PVME1_Pos = 0x4   // Position of PVME1 field.
	PWR_CR2_PVME1_Msk = 0x10  // Bit mask of PVME1 field.
	PWR_CR2_PVME1     = 0x10  // Bit PVME1.
	PWR_CR2_PLS_Pos   = 0x1   // Position of PLS field.
	PWR_CR2_PLS_Msk   = 0xe   // Bit mask of PLS field.
	PWR_CR2_PVDE_Pos  = 0x0   // Position of PVDE field.
	PWR_CR2_PVDE_Msk  = 0x1   // Bit mask of PVDE field.
	PWR_CR2_PVDE      = 0x1   // Bit PVDE.

	// CR3: Power control register 3
	PWR_CR3_EWF_Pos   = 0xf    // Position of EWF field.
	PWR_CR3_EWF_Msk   = 0x8000 // Bit mask of EWF field.
	PWR_CR3_EWF       = 0x8000 // Bit EWF.
	PWR_CR3_APC_Pos   = 0xa    // Position of APC field.
	PWR_CR3_APC_Msk   = 0x400  // Bit mask of APC field.
	PWR_CR3_APC       = 0x400  // Bit APC.
	PWR_CR3_RRS_Pos   = 0x8    // Position of RRS field.
	PWR_CR3_RRS_Msk   = 0x100  // Bit mask of RRS field.
	PWR_CR3_RRS       = 0x100  // Bit RRS.
	PWR_CR3_EWUP5_Pos = 0x4    // Position of EWUP5 field.
	PWR_CR3_EWUP5_Msk = 0x10   // Bit mask of EWUP5 field.
	PWR_CR3_EWUP5     = 0x10   // Bit EWUP5.
	PWR_CR3_EWUP4_Pos = 0x3    // Position of EWUP4 field.
	PWR_CR3_EWUP4_Msk = 0x8    // Bit mask of EWUP4 field.
	PWR_CR3_EWUP4     = 0x8    // Bit EWUP4.
	PWR_CR3_EWUP3_Pos = 0x2    // Position of EWUP3 field.
	PWR_CR3_EWUP3_Msk = 0x4    // Bit mask of EWUP3 field.
	PWR_CR3_EWUP3     = 0x4    // Bit EWUP3.
	PWR_CR3_EWUP2_Pos = 0x1    // Position of EWUP2 field.
	PWR_CR3_EWUP2_Msk = 0x2    // Bit mask of EWUP2 field.
	PWR_CR3_EWUP2     = 0x2    // Bit EWUP2.
	PWR_CR3_EWUP1_Pos = 0x0    // Position of EWUP1 field.
	PWR_CR3_EWUP1_Msk = 0x1    // Bit mask of EWUP1 field.
	PWR_CR3_EWUP1     = 0x1    // Bit EWUP1.

	// CR4: Power control register 4
	PWR_CR4_VBRS_Pos = 0x9   // Position of VBRS field.
	PWR_CR4_VBRS_Msk = 0x200 // Bit mask of VBRS field.
	PWR_CR4_VBRS     = 0x200 // Bit VBRS.
	PWR_CR4_VBE_Pos  = 0x8   // Position of VBE field.
	PWR_CR4_VBE_Msk  = 0x100 // Bit mask of VBE field.
	PWR_CR4_VBE      = 0x100 // Bit VBE.
	PWR_CR4_WP5_Pos  = 0x4   // Position of WP5 field.
	PWR_CR4_WP5_Msk  = 0x10  // Bit mask of WP5 field.
	PWR_CR4_WP5      = 0x10  // Bit WP5.
	PWR_CR4_WP4_Pos  = 0x3   // Position of WP4 field.
	PWR_CR4_WP4_Msk  = 0x8   // Bit mask of WP4 field.
	PWR_CR4_WP4      = 0x8   // Bit WP4.
	PWR_CR4_WP3_Pos  = 0x2   // Position of WP3 field.
	PWR_CR4_WP3_Msk  = 0x4   // Bit mask of WP3 field.
	PWR_CR4_WP3      = 0x4   // Bit WP3.
	PWR_CR4_WP2_Pos  = 0x1   // Position of WP2 field.
	PWR_CR4_WP2_Msk  = 0x2   // Bit mask of WP2 field.
	PWR_CR4_WP2      = 0x2   // Bit WP2.
	PWR_CR4_WP1_Pos  = 0x0   // Position of WP1 field.
	PWR_CR4_WP1_Msk  = 0x1   // Bit mask of WP1 field.
	PWR_CR4_WP1      = 0x1   // Bit WP1.

	// SR1: Power status register 1
	PWR_SR1_WUFI_Pos  = 0xf    // Position of WUFI field.
	PWR_SR1_WUFI_Msk  = 0x8000 // Bit mask of WUFI field.
	PWR_SR1_WUFI      = 0x8000 // Bit WUFI.
	PWR_SR1_CSBF_Pos  = 0x8    // Position of CSBF field.
	PWR_SR1_CSBF_Msk  = 0x100  // Bit mask of CSBF field.
	PWR_SR1_CSBF      = 0x100  // Bit CSBF.
	PWR_SR1_CWUF5_Pos = 0x4    // Position of CWUF5 field.
	PWR_SR1_CWUF5_Msk = 0x10   // Bit mask of CWUF5 field.
	PWR_SR1_CWUF5     = 0x10   // Bit CWUF5.
	PWR_SR1_CWUF4_Pos = 0x3    // Position of CWUF4 field.
	PWR_SR1_CWUF4_Msk = 0x8    // Bit mask of CWUF4 field.
	PWR_SR1_CWUF4     = 0x8    // Bit CWUF4.
	PWR_SR1_CWUF3_Pos = 0x2    // Position of CWUF3 field.
	PWR_SR1_CWUF3_Msk = 0x4    // Bit mask of CWUF3 field.
	PWR_SR1_CWUF3     = 0x4    // Bit CWUF3.
	PWR_SR1_CWUF2_Pos = 0x1    // Position of CWUF2 field.
	PWR_SR1_CWUF2_Msk = 0x2    // Bit mask of CWUF2 field.
	PWR_SR1_CWUF2     = 0x2    // Bit CWUF2.
	PWR_SR1_CWUF1_Pos = 0x0    // Position of CWUF1 field.
	PWR_SR1_CWUF1_Msk = 0x1    // Bit mask of CWUF1 field.
	PWR_SR1_CWUF1     = 0x1    // Bit CWUF1.

	// SR2: Power status register 2
	PWR_SR2_PVMO4_Pos  = 0xf    // Position of PVMO4 field.
	PWR_SR2_PVMO4_Msk  = 0x8000 // Bit mask of PVMO4 field.
	PWR_SR2_PVMO4      = 0x8000 // Bit PVMO4.
	PWR_SR2_PVMO3_Pos  = 0xe    // Position of PVMO3 field.
	PWR_SR2_PVMO3_Msk  = 0x4000 // Bit mask of PVMO3 field.
	PWR_SR2_PVMO3      = 0x4000 // Bit PVMO3.
	PWR_SR2_PVMO2_Pos  = 0xd    // Position of PVMO2 field.
	PWR_SR2_PVMO2_Msk  = 0x2000 // Bit mask of PVMO2 field.
	PWR_SR2_PVMO2      = 0x2000 // Bit PVMO2.
	PWR_SR2_PVMO1_Pos  = 0xc    // Position of PVMO1 field.
	PWR_SR2_PVMO1_Msk  = 0x1000 // Bit mask of PVMO1 field.
	PWR_SR2_PVMO1      = 0x1000 // Bit PVMO1.
	PWR_SR2_PVDO_Pos   = 0xb    // Position of PVDO field.
	PWR_SR2_PVDO_Msk   = 0x800  // Bit mask of PVDO field.
	PWR_SR2_PVDO       = 0x800  // Bit PVDO.
	PWR_SR2_VOSF_Pos   = 0xa    // Position of VOSF field.
	PWR_SR2_VOSF_Msk   = 0x400  // Bit mask of VOSF field.
	PWR_SR2_VOSF       = 0x400  // Bit VOSF.
	PWR_SR2_REGLPF_Pos = 0x9    // Position of REGLPF field.
	PWR_SR2_REGLPF_Msk = 0x200  // Bit mask of REGLPF field.
	PWR_SR2_REGLPF     = 0x200  // Bit REGLPF.
	PWR_SR2_REGLPS_Pos = 0x8    // Position of REGLPS field.
	PWR_SR2_REGLPS_Msk = 0x100  // Bit mask of REGLPS field.
	PWR_SR2_REGLPS     = 0x100  // Bit REGLPS.

	// SCR: Power status clear register
	PWR_SCR_SBF_Pos  = 0x8   // Position of SBF field.
	PWR_SCR_SBF_Msk  = 0x100 // Bit mask of SBF field.
	PWR_SCR_SBF      = 0x100 // Bit SBF.
	PWR_SCR_WUF5_Pos = 0x4   // Position of WUF5 field.
	PWR_SCR_WUF5_Msk = 0x10  // Bit mask of WUF5 field.
	PWR_SCR_WUF5     = 0x10  // Bit WUF5.
	PWR_SCR_WUF4_Pos = 0x3   // Position of WUF4 field.
	PWR_SCR_WUF4_Msk = 0x8   // Bit mask of WUF4 field.
	PWR_SCR_WUF4     = 0x8   // Bit WUF4.
	PWR_SCR_WUF3_Pos = 0x2   // Position of WUF3 field.
	PWR_SCR_WUF3_Msk = 0x4   // Bit mask of WUF3 field.
	PWR_SCR_WUF3     = 0x4   // Bit WUF3.
	PWR_SCR_WUF2_Pos = 0x1   // Position of WUF2 field.
	PWR_SCR_WUF2_Msk = 0x2   // Bit mask of WUF2 field.
	PWR_SCR_WUF2     = 0x2   // Bit WUF2.
	PWR_SCR_WUF1_Pos = 0x0   // Position of WUF1 field.
	PWR_SCR_WUF1_Msk = 0x1   // Bit mask of WUF1 field.
	PWR_SCR_WUF1     = 0x1   // Bit WUF1.

	// PUCRA: Power Port A pull-up control           register
	PWR_PUCRA_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRA_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRA_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRA_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRA_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRA_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRA_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRA_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRA_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRA_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRA_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRA_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRA_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRA_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRA_PU11     = 0x800  // Bit PU11.
	PWR_PUCRA_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRA_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRA_PU10     = 0x400  // Bit PU10.
	PWR_PUCRA_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRA_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRA_PU9      = 0x200  // Bit PU9.
	PWR_PUCRA_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRA_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRA_PU8      = 0x100  // Bit PU8.
	PWR_PUCRA_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRA_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRA_PU7      = 0x80   // Bit PU7.
	PWR_PUCRA_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRA_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRA_PU6      = 0x40   // Bit PU6.
	PWR_PUCRA_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRA_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRA_PU5      = 0x20   // Bit PU5.
	PWR_PUCRA_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRA_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRA_PU4      = 0x10   // Bit PU4.
	PWR_PUCRA_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRA_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRA_PU3      = 0x8    // Bit PU3.
	PWR_PUCRA_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRA_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRA_PU2      = 0x4    // Bit PU2.
	PWR_PUCRA_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRA_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRA_PU1      = 0x2    // Bit PU1.
	PWR_PUCRA_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRA_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRA_PU0      = 0x1    // Bit PU0.

	// PDCRA: Power Port A pull-down control           register
	PWR_PDCRA_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRA_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRA_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRA_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRA_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRA_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRA_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRA_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRA_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRA_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRA_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRA_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRA_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRA_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRA_PD11     = 0x800  // Bit PD11.
	PWR_PDCRA_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRA_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRA_PD10     = 0x400  // Bit PD10.
	PWR_PDCRA_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRA_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRA_PD9      = 0x200  // Bit PD9.
	PWR_PDCRA_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRA_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRA_PD8      = 0x100  // Bit PD8.
	PWR_PDCRA_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRA_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRA_PD7      = 0x80   // Bit PD7.
	PWR_PDCRA_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRA_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRA_PD6      = 0x40   // Bit PD6.
	PWR_PDCRA_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRA_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRA_PD5      = 0x20   // Bit PD5.
	PWR_PDCRA_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRA_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRA_PD4      = 0x10   // Bit PD4.
	PWR_PDCRA_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRA_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRA_PD3      = 0x8    // Bit PD3.
	PWR_PDCRA_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRA_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRA_PD2      = 0x4    // Bit PD2.
	PWR_PDCRA_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRA_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRA_PD1      = 0x2    // Bit PD1.
	PWR_PDCRA_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRA_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRA_PD0      = 0x1    // Bit PD0.

	// PUCRB: Power Port B pull-up control           register
	PWR_PUCRB_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRB_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRB_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRB_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRB_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRB_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRB_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRB_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRB_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRB_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRB_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRB_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRB_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRB_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRB_PU11     = 0x800  // Bit PU11.
	PWR_PUCRB_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRB_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRB_PU10     = 0x400  // Bit PU10.
	PWR_PUCRB_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRB_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRB_PU9      = 0x200  // Bit PU9.
	PWR_PUCRB_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRB_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRB_PU8      = 0x100  // Bit PU8.
	PWR_PUCRB_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRB_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRB_PU7      = 0x80   // Bit PU7.
	PWR_PUCRB_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRB_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRB_PU6      = 0x40   // Bit PU6.
	PWR_PUCRB_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRB_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRB_PU5      = 0x20   // Bit PU5.
	PWR_PUCRB_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRB_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRB_PU4      = 0x10   // Bit PU4.
	PWR_PUCRB_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRB_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRB_PU3      = 0x8    // Bit PU3.
	PWR_PUCRB_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRB_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRB_PU2      = 0x4    // Bit PU2.
	PWR_PUCRB_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRB_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRB_PU1      = 0x2    // Bit PU1.
	PWR_PUCRB_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRB_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRB_PU0      = 0x1    // Bit PU0.

	// PDCRB: Power Port B pull-down control           register
	PWR_PDCRB_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRB_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRB_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRB_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRB_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRB_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRB_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRB_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRB_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRB_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRB_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRB_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRB_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRB_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRB_PD11     = 0x800  // Bit PD11.
	PWR_PDCRB_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRB_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRB_PD10     = 0x400  // Bit PD10.
	PWR_PDCRB_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRB_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRB_PD9      = 0x200  // Bit PD9.
	PWR_PDCRB_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRB_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRB_PD8      = 0x100  // Bit PD8.
	PWR_PDCRB_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRB_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRB_PD7      = 0x80   // Bit PD7.
	PWR_PDCRB_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRB_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRB_PD6      = 0x40   // Bit PD6.
	PWR_PDCRB_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRB_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRB_PD5      = 0x20   // Bit PD5.
	PWR_PDCRB_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRB_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRB_PD4      = 0x10   // Bit PD4.
	PWR_PDCRB_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRB_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRB_PD3      = 0x8    // Bit PD3.
	PWR_PDCRB_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRB_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRB_PD2      = 0x4    // Bit PD2.
	PWR_PDCRB_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRB_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRB_PD1      = 0x2    // Bit PD1.
	PWR_PDCRB_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRB_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRB_PD0      = 0x1    // Bit PD0.

	// PUCRC: Power Port C pull-up control           register
	PWR_PUCRC_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRC_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRC_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRC_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRC_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRC_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRC_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRC_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRC_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRC_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRC_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRC_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRC_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRC_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRC_PU11     = 0x800  // Bit PU11.
	PWR_PUCRC_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRC_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRC_PU10     = 0x400  // Bit PU10.
	PWR_PUCRC_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRC_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRC_PU9      = 0x200  // Bit PU9.
	PWR_PUCRC_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRC_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRC_PU8      = 0x100  // Bit PU8.
	PWR_PUCRC_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRC_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRC_PU7      = 0x80   // Bit PU7.
	PWR_PUCRC_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRC_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRC_PU6      = 0x40   // Bit PU6.
	PWR_PUCRC_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRC_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRC_PU5      = 0x20   // Bit PU5.
	PWR_PUCRC_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRC_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRC_PU4      = 0x10   // Bit PU4.
	PWR_PUCRC_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRC_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRC_PU3      = 0x8    // Bit PU3.
	PWR_PUCRC_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRC_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRC_PU2      = 0x4    // Bit PU2.
	PWR_PUCRC_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRC_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRC_PU1      = 0x2    // Bit PU1.
	PWR_PUCRC_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRC_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRC_PU0      = 0x1    // Bit PU0.

	// PDCRC: Power Port C pull-down control           register
	PWR_PDCRC_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRC_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRC_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRC_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRC_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRC_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRC_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRC_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRC_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRC_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRC_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRC_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRC_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRC_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRC_PD11     = 0x800  // Bit PD11.
	PWR_PDCRC_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRC_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRC_PD10     = 0x400  // Bit PD10.
	PWR_PDCRC_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRC_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRC_PD9      = 0x200  // Bit PD9.
	PWR_PDCRC_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRC_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRC_PD8      = 0x100  // Bit PD8.
	PWR_PDCRC_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRC_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRC_PD7      = 0x80   // Bit PD7.
	PWR_PDCRC_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRC_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRC_PD6      = 0x40   // Bit PD6.
	PWR_PDCRC_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRC_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRC_PD5      = 0x20   // Bit PD5.
	PWR_PDCRC_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRC_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRC_PD4      = 0x10   // Bit PD4.
	PWR_PDCRC_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRC_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRC_PD3      = 0x8    // Bit PD3.
	PWR_PDCRC_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRC_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRC_PD2      = 0x4    // Bit PD2.
	PWR_PDCRC_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRC_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRC_PD1      = 0x2    // Bit PD1.
	PWR_PDCRC_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRC_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRC_PD0      = 0x1    // Bit PD0.

	// PUCRD: Power Port D pull-up control           register
	PWR_PUCRD_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRD_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRD_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRD_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRD_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRD_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRD_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRD_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRD_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRD_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRD_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRD_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRD_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRD_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRD_PU11     = 0x800  // Bit PU11.
	PWR_PUCRD_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRD_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRD_PU10     = 0x400  // Bit PU10.
	PWR_PUCRD_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRD_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRD_PU9      = 0x200  // Bit PU9.
	PWR_PUCRD_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRD_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRD_PU8      = 0x100  // Bit PU8.
	PWR_PUCRD_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRD_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRD_PU7      = 0x80   // Bit PU7.
	PWR_PUCRD_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRD_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRD_PU6      = 0x40   // Bit PU6.
	PWR_PUCRD_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRD_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRD_PU5      = 0x20   // Bit PU5.
	PWR_PUCRD_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRD_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRD_PU4      = 0x10   // Bit PU4.
	PWR_PUCRD_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRD_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRD_PU3      = 0x8    // Bit PU3.
	PWR_PUCRD_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRD_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRD_PU2      = 0x4    // Bit PU2.
	PWR_PUCRD_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRD_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRD_PU1      = 0x2    // Bit PU1.
	PWR_PUCRD_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRD_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRD_PU0      = 0x1    // Bit PU0.

	// PDCRD: Power Port D pull-down control           register
	PWR_PDCRD_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRD_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRD_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRD_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRD_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRD_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRD_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRD_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRD_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRD_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRD_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRD_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRD_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRD_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRD_PD11     = 0x800  // Bit PD11.
	PWR_PDCRD_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRD_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRD_PD10     = 0x400  // Bit PD10.
	PWR_PDCRD_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRD_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRD_PD9      = 0x200  // Bit PD9.
	PWR_PDCRD_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRD_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRD_PD8      = 0x100  // Bit PD8.
	PWR_PDCRD_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRD_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRD_PD7      = 0x80   // Bit PD7.
	PWR_PDCRD_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRD_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRD_PD6      = 0x40   // Bit PD6.
	PWR_PDCRD_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRD_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRD_PD5      = 0x20   // Bit PD5.
	PWR_PDCRD_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRD_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRD_PD4      = 0x10   // Bit PD4.
	PWR_PDCRD_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRD_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRD_PD3      = 0x8    // Bit PD3.
	PWR_PDCRD_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRD_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRD_PD2      = 0x4    // Bit PD2.
	PWR_PDCRD_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRD_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRD_PD1      = 0x2    // Bit PD1.
	PWR_PDCRD_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRD_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRD_PD0      = 0x1    // Bit PD0.

	// PUCRE: Power Port E pull-up control           register
	PWR_PUCRE_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRE_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRE_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRE_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRE_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRE_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRE_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRE_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRE_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRE_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRE_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRE_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRE_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRE_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRE_PU11     = 0x800  // Bit PU11.
	PWR_PUCRE_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRE_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRE_PU10     = 0x400  // Bit PU10.
	PWR_PUCRE_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRE_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRE_PU9      = 0x200  // Bit PU9.
	PWR_PUCRE_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRE_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRE_PU8      = 0x100  // Bit PU8.
	PWR_PUCRE_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRE_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRE_PU7      = 0x80   // Bit PU7.
	PWR_PUCRE_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRE_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRE_PU6      = 0x40   // Bit PU6.
	PWR_PUCRE_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRE_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRE_PU5      = 0x20   // Bit PU5.
	PWR_PUCRE_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRE_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRE_PU4      = 0x10   // Bit PU4.
	PWR_PUCRE_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRE_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRE_PU3      = 0x8    // Bit PU3.
	PWR_PUCRE_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRE_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRE_PU2      = 0x4    // Bit PU2.
	PWR_PUCRE_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRE_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRE_PU1      = 0x2    // Bit PU1.
	PWR_PUCRE_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRE_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRE_PU0      = 0x1    // Bit PU0.

	// PDCRE: Power Port E pull-down control           register
	PWR_PDCRE_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRE_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRE_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRE_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRE_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRE_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRE_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRE_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRE_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRE_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRE_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRE_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRE_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRE_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRE_PD11     = 0x800  // Bit PD11.
	PWR_PDCRE_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRE_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRE_PD10     = 0x400  // Bit PD10.
	PWR_PDCRE_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRE_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRE_PD9      = 0x200  // Bit PD9.
	PWR_PDCRE_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRE_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRE_PD8      = 0x100  // Bit PD8.
	PWR_PDCRE_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRE_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRE_PD7      = 0x80   // Bit PD7.
	PWR_PDCRE_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRE_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRE_PD6      = 0x40   // Bit PD6.
	PWR_PDCRE_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRE_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRE_PD5      = 0x20   // Bit PD5.
	PWR_PDCRE_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRE_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRE_PD4      = 0x10   // Bit PD4.
	PWR_PDCRE_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRE_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRE_PD3      = 0x8    // Bit PD3.
	PWR_PDCRE_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRE_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRE_PD2      = 0x4    // Bit PD2.
	PWR_PDCRE_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRE_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRE_PD1      = 0x2    // Bit PD1.
	PWR_PDCRE_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRE_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRE_PD0      = 0x1    // Bit PD0.

	// PUCRF: Power Port F pull-up control           register
	PWR_PUCRF_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRF_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRF_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRF_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRF_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRF_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRF_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRF_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRF_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRF_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRF_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRF_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRF_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRF_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRF_PU11     = 0x800  // Bit PU11.
	PWR_PUCRF_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRF_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRF_PU10     = 0x400  // Bit PU10.
	PWR_PUCRF_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRF_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRF_PU9      = 0x200  // Bit PU9.
	PWR_PUCRF_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRF_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRF_PU8      = 0x100  // Bit PU8.
	PWR_PUCRF_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRF_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRF_PU7      = 0x80   // Bit PU7.
	PWR_PUCRF_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRF_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRF_PU6      = 0x40   // Bit PU6.
	PWR_PUCRF_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRF_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRF_PU5      = 0x20   // Bit PU5.
	PWR_PUCRF_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRF_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRF_PU4      = 0x10   // Bit PU4.
	PWR_PUCRF_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRF_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRF_PU3      = 0x8    // Bit PU3.
	PWR_PUCRF_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRF_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRF_PU2      = 0x4    // Bit PU2.
	PWR_PUCRF_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRF_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRF_PU1      = 0x2    // Bit PU1.
	PWR_PUCRF_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRF_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRF_PU0      = 0x1    // Bit PU0.

	// PDCRF: Power Port F pull-down control           register
	PWR_PDCRF_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRF_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRF_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRF_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRF_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRF_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRF_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRF_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRF_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRF_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRF_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRF_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRF_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRF_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRF_PD11     = 0x800  // Bit PD11.
	PWR_PDCRF_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRF_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRF_PD10     = 0x400  // Bit PD10.
	PWR_PDCRF_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRF_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRF_PD9      = 0x200  // Bit PD9.
	PWR_PDCRF_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRF_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRF_PD8      = 0x100  // Bit PD8.
	PWR_PDCRF_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRF_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRF_PD7      = 0x80   // Bit PD7.
	PWR_PDCRF_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRF_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRF_PD6      = 0x40   // Bit PD6.
	PWR_PDCRF_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRF_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRF_PD5      = 0x20   // Bit PD5.
	PWR_PDCRF_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRF_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRF_PD4      = 0x10   // Bit PD4.
	PWR_PDCRF_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRF_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRF_PD3      = 0x8    // Bit PD3.
	PWR_PDCRF_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRF_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRF_PD2      = 0x4    // Bit PD2.
	PWR_PDCRF_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRF_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRF_PD1      = 0x2    // Bit PD1.
	PWR_PDCRF_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRF_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRF_PD0      = 0x1    // Bit PD0.

	// PUCRG: Power Port G pull-up control           register
	PWR_PUCRG_PU15_Pos = 0xf    // Position of PU15 field.
	PWR_PUCRG_PU15_Msk = 0x8000 // Bit mask of PU15 field.
	PWR_PUCRG_PU15     = 0x8000 // Bit PU15.
	PWR_PUCRG_PU14_Pos = 0xe    // Position of PU14 field.
	PWR_PUCRG_PU14_Msk = 0x4000 // Bit mask of PU14 field.
	PWR_PUCRG_PU14     = 0x4000 // Bit PU14.
	PWR_PUCRG_PU13_Pos = 0xd    // Position of PU13 field.
	PWR_PUCRG_PU13_Msk = 0x2000 // Bit mask of PU13 field.
	PWR_PUCRG_PU13     = 0x2000 // Bit PU13.
	PWR_PUCRG_PU12_Pos = 0xc    // Position of PU12 field.
	PWR_PUCRG_PU12_Msk = 0x1000 // Bit mask of PU12 field.
	PWR_PUCRG_PU12     = 0x1000 // Bit PU12.
	PWR_PUCRG_PU11_Pos = 0xb    // Position of PU11 field.
	PWR_PUCRG_PU11_Msk = 0x800  // Bit mask of PU11 field.
	PWR_PUCRG_PU11     = 0x800  // Bit PU11.
	PWR_PUCRG_PU10_Pos = 0xa    // Position of PU10 field.
	PWR_PUCRG_PU10_Msk = 0x400  // Bit mask of PU10 field.
	PWR_PUCRG_PU10     = 0x400  // Bit PU10.
	PWR_PUCRG_PU9_Pos  = 0x9    // Position of PU9 field.
	PWR_PUCRG_PU9_Msk  = 0x200  // Bit mask of PU9 field.
	PWR_PUCRG_PU9      = 0x200  // Bit PU9.
	PWR_PUCRG_PU8_Pos  = 0x8    // Position of PU8 field.
	PWR_PUCRG_PU8_Msk  = 0x100  // Bit mask of PU8 field.
	PWR_PUCRG_PU8      = 0x100  // Bit PU8.
	PWR_PUCRG_PU7_Pos  = 0x7    // Position of PU7 field.
	PWR_PUCRG_PU7_Msk  = 0x80   // Bit mask of PU7 field.
	PWR_PUCRG_PU7      = 0x80   // Bit PU7.
	PWR_PUCRG_PU6_Pos  = 0x6    // Position of PU6 field.
	PWR_PUCRG_PU6_Msk  = 0x40   // Bit mask of PU6 field.
	PWR_PUCRG_PU6      = 0x40   // Bit PU6.
	PWR_PUCRG_PU5_Pos  = 0x5    // Position of PU5 field.
	PWR_PUCRG_PU5_Msk  = 0x20   // Bit mask of PU5 field.
	PWR_PUCRG_PU5      = 0x20   // Bit PU5.
	PWR_PUCRG_PU4_Pos  = 0x4    // Position of PU4 field.
	PWR_PUCRG_PU4_Msk  = 0x10   // Bit mask of PU4 field.
	PWR_PUCRG_PU4      = 0x10   // Bit PU4.
	PWR_PUCRG_PU3_Pos  = 0x3    // Position of PU3 field.
	PWR_PUCRG_PU3_Msk  = 0x8    // Bit mask of PU3 field.
	PWR_PUCRG_PU3      = 0x8    // Bit PU3.
	PWR_PUCRG_PU2_Pos  = 0x2    // Position of PU2 field.
	PWR_PUCRG_PU2_Msk  = 0x4    // Bit mask of PU2 field.
	PWR_PUCRG_PU2      = 0x4    // Bit PU2.
	PWR_PUCRG_PU1_Pos  = 0x1    // Position of PU1 field.
	PWR_PUCRG_PU1_Msk  = 0x2    // Bit mask of PU1 field.
	PWR_PUCRG_PU1      = 0x2    // Bit PU1.
	PWR_PUCRG_PU0_Pos  = 0x0    // Position of PU0 field.
	PWR_PUCRG_PU0_Msk  = 0x1    // Bit mask of PU0 field.
	PWR_PUCRG_PU0      = 0x1    // Bit PU0.

	// PDCRG: Power Port G pull-down control           register
	PWR_PDCRG_PD15_Pos = 0xf    // Position of PD15 field.
	PWR_PDCRG_PD15_Msk = 0x8000 // Bit mask of PD15 field.
	PWR_PDCRG_PD15     = 0x8000 // Bit PD15.
	PWR_PDCRG_PD14_Pos = 0xe    // Position of PD14 field.
	PWR_PDCRG_PD14_Msk = 0x4000 // Bit mask of PD14 field.
	PWR_PDCRG_PD14     = 0x4000 // Bit PD14.
	PWR_PDCRG_PD13_Pos = 0xd    // Position of PD13 field.
	PWR_PDCRG_PD13_Msk = 0x2000 // Bit mask of PD13 field.
	PWR_PDCRG_PD13     = 0x2000 // Bit PD13.
	PWR_PDCRG_PD12_Pos = 0xc    // Position of PD12 field.
	PWR_PDCRG_PD12_Msk = 0x1000 // Bit mask of PD12 field.
	PWR_PDCRG_PD12     = 0x1000 // Bit PD12.
	PWR_PDCRG_PD11_Pos = 0xb    // Position of PD11 field.
	PWR_PDCRG_PD11_Msk = 0x800  // Bit mask of PD11 field.
	PWR_PDCRG_PD11     = 0x800  // Bit PD11.
	PWR_PDCRG_PD10_Pos = 0xa    // Position of PD10 field.
	PWR_PDCRG_PD10_Msk = 0x400  // Bit mask of PD10 field.
	PWR_PDCRG_PD10     = 0x400  // Bit PD10.
	PWR_PDCRG_PD9_Pos  = 0x9    // Position of PD9 field.
	PWR_PDCRG_PD9_Msk  = 0x200  // Bit mask of PD9 field.
	PWR_PDCRG_PD9      = 0x200  // Bit PD9.
	PWR_PDCRG_PD8_Pos  = 0x8    // Position of PD8 field.
	PWR_PDCRG_PD8_Msk  = 0x100  // Bit mask of PD8 field.
	PWR_PDCRG_PD8      = 0x100  // Bit PD8.
	PWR_PDCRG_PD7_Pos  = 0x7    // Position of PD7 field.
	PWR_PDCRG_PD7_Msk  = 0x80   // Bit mask of PD7 field.
	PWR_PDCRG_PD7      = 0x80   // Bit PD7.
	PWR_PDCRG_PD6_Pos  = 0x6    // Position of PD6 field.
	PWR_PDCRG_PD6_Msk  = 0x40   // Bit mask of PD6 field.
	PWR_PDCRG_PD6      = 0x40   // Bit PD6.
	PWR_PDCRG_PD5_Pos  = 0x5    // Position of PD5 field.
	PWR_PDCRG_PD5_Msk  = 0x20   // Bit mask of PD5 field.
	PWR_PDCRG_PD5      = 0x20   // Bit PD5.
	PWR_PDCRG_PD4_Pos  = 0x4    // Position of PD4 field.
	PWR_PDCRG_PD4_Msk  = 0x10   // Bit mask of PD4 field.
	PWR_PDCRG_PD4      = 0x10   // Bit PD4.
	PWR_PDCRG_PD3_Pos  = 0x3    // Position of PD3 field.
	PWR_PDCRG_PD3_Msk  = 0x8    // Bit mask of PD3 field.
	PWR_PDCRG_PD3      = 0x8    // Bit PD3.
	PWR_PDCRG_PD2_Pos  = 0x2    // Position of PD2 field.
	PWR_PDCRG_PD2_Msk  = 0x4    // Bit mask of PD2 field.
	PWR_PDCRG_PD2      = 0x4    // Bit PD2.
	PWR_PDCRG_PD1_Pos  = 0x1    // Position of PD1 field.
	PWR_PDCRG_PD1_Msk  = 0x2    // Bit mask of PD1 field.
	PWR_PDCRG_PD1      = 0x2    // Bit PD1.
	PWR_PDCRG_PD0_Pos  = 0x0    // Position of PD0 field.
	PWR_PDCRG_PD0_Msk  = 0x1    // Bit mask of PD0 field.
	PWR_PDCRG_PD0      = 0x1    // Bit PD0.

	// PUCRH: Power Port H pull-up control           register
	PWR_PUCRH_PU1_Pos = 0x1 // Position of PU1 field.
	PWR_PUCRH_PU1_Msk = 0x2 // Bit mask of PU1 field.
	PWR_PUCRH_PU1     = 0x2 // Bit PU1.
	PWR_PUCRH_PU0_Pos = 0x0 // Position of PU0 field.
	PWR_PUCRH_PU0_Msk = 0x1 // Bit mask of PU0 field.
	PWR_PUCRH_PU0     = 0x1 // Bit PU0.

	// PDCRH: Power Port H pull-down control           register
	PWR_PDCRH_PD1_Pos = 0x1 // Position of PD1 field.
	PWR_PDCRH_PD1_Msk = 0x2 // Bit mask of PD1 field.
	PWR_PDCRH_PD1     = 0x2 // Bit PD1.
	PWR_PDCRH_PD0_Pos = 0x0 // Position of PD0 field.
	PWR_PDCRH_PD0_Msk = 0x1 // Bit mask of PD0 field.
	PWR_PDCRH_PD0     = 0x1 // Bit PD0.
)

// Bitfields for SYSCFG: System configuration controller
const (
	// MEMRMP: memory remap register
	SYSCFG_MEMRMP_FB_MODE_Pos  = 0x8   // Position of FB_MODE field.
	SYSCFG_MEMRMP_FB_MODE_Msk  = 0x100 // Bit mask of FB_MODE field.
	SYSCFG_MEMRMP_FB_MODE      = 0x100 // Bit FB_MODE.
	SYSCFG_MEMRMP_QFS_Pos      = 0x3   // Position of QFS field.
	SYSCFG_MEMRMP_QFS_Msk      = 0x8   // Bit mask of QFS field.
	SYSCFG_MEMRMP_QFS          = 0x8   // Bit QFS.
	SYSCFG_MEMRMP_MEM_MODE_Pos = 0x0   // Position of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Msk = 0x7   // Bit mask of MEM_MODE field.

	// CFGR1: configuration register 1
	SYSCFG_CFGR1_FPU_IE_Pos      = 0x1a       // Position of FPU_IE field.
	SYSCFG_CFGR1_FPU_IE_Msk      = 0xfc000000 // Bit mask of FPU_IE field.
	SYSCFG_CFGR1_I2C3_FMP_Pos    = 0x16       // Position of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP_Msk    = 0x400000   // Bit mask of I2C3_FMP field.
	SYSCFG_CFGR1_I2C3_FMP        = 0x400000   // Bit I2C3_FMP.
	SYSCFG_CFGR1_I2C2_FMP_Pos    = 0x15       // Position of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP_Msk    = 0x200000   // Bit mask of I2C2_FMP field.
	SYSCFG_CFGR1_I2C2_FMP        = 0x200000   // Bit I2C2_FMP.
	SYSCFG_CFGR1_I2C1_FMP_Pos    = 0x14       // Position of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP_Msk    = 0x100000   // Bit mask of I2C1_FMP field.
	SYSCFG_CFGR1_I2C1_FMP        = 0x100000   // Bit I2C1_FMP.
	SYSCFG_CFGR1_I2C_PB9_FMP_Pos = 0x13       // Position of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP_Msk = 0x80000    // Bit mask of I2C_PB9_FMP field.
	SYSCFG_CFGR1_I2C_PB9_FMP     = 0x80000    // Bit I2C_PB9_FMP.
	SYSCFG_CFGR1_I2C_PB8_FMP_Pos = 0x12       // Position of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP_Msk = 0x40000    // Bit mask of I2C_PB8_FMP field.
	SYSCFG_CFGR1_I2C_PB8_FMP     = 0x40000    // Bit I2C_PB8_FMP.
	SYSCFG_CFGR1_I2C_PB7_FMP_Pos = 0x11       // Position of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP_Msk = 0x20000    // Bit mask of I2C_PB7_FMP field.
	SYSCFG_CFGR1_I2C_PB7_FMP     = 0x20000    // Bit I2C_PB7_FMP.
	SYSCFG_CFGR1_I2C_PB6_FMP_Pos = 0x10       // Position of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP_Msk = 0x10000    // Bit mask of I2C_PB6_FMP field.
	SYSCFG_CFGR1_I2C_PB6_FMP     = 0x10000    // Bit I2C_PB6_FMP.
	SYSCFG_CFGR1_BOOSTEN_Pos     = 0x8        // Position of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN_Msk     = 0x100      // Bit mask of BOOSTEN field.
	SYSCFG_CFGR1_BOOSTEN         = 0x100      // Bit BOOSTEN.
	SYSCFG_CFGR1_FWDIS_Pos       = 0x0        // Position of FWDIS field.
	SYSCFG_CFGR1_FWDIS_Msk       = 0x1        // Bit mask of FWDIS field.
	SYSCFG_CFGR1_FWDIS           = 0x1        // Bit FWDIS.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0x7000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0x700  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0x70   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0x7    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0x7000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0x700  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0x70   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0x7    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0x7000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0x700  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0x70   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0x7    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0x7000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0x700  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0x70   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0x7    // Bit mask of EXTI12 field.

	// SCSR: SCSR
	SYSCFG_SCSR_SRAM2BSY_Pos = 0x1 // Position of SRAM2BSY field.
	SYSCFG_SCSR_SRAM2BSY_Msk = 0x2 // Bit mask of SRAM2BSY field.
	SYSCFG_SCSR_SRAM2BSY     = 0x2 // Bit SRAM2BSY.
	SYSCFG_SCSR_SRAM2ER_Pos  = 0x0 // Position of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER_Msk  = 0x1 // Bit mask of SRAM2ER field.
	SYSCFG_SCSR_SRAM2ER      = 0x1 // Bit SRAM2ER.

	// CFGR2: CFGR2
	SYSCFG_CFGR2_SPF_Pos  = 0x8   // Position of SPF field.
	SYSCFG_CFGR2_SPF_Msk  = 0x100 // Bit mask of SPF field.
	SYSCFG_CFGR2_SPF      = 0x100 // Bit SPF.
	SYSCFG_CFGR2_ECCL_Pos = 0x3   // Position of ECCL field.
	SYSCFG_CFGR2_ECCL_Msk = 0x8   // Bit mask of ECCL field.
	SYSCFG_CFGR2_ECCL     = 0x8   // Bit ECCL.
	SYSCFG_CFGR2_PVDL_Pos = 0x2   // Position of PVDL field.
	SYSCFG_CFGR2_PVDL_Msk = 0x4   // Bit mask of PVDL field.
	SYSCFG_CFGR2_PVDL     = 0x4   // Bit PVDL.
	SYSCFG_CFGR2_SPL_Pos  = 0x1   // Position of SPL field.
	SYSCFG_CFGR2_SPL_Msk  = 0x2   // Bit mask of SPL field.
	SYSCFG_CFGR2_SPL      = 0x2   // Bit SPL.
	SYSCFG_CFGR2_CLL_Pos  = 0x0   // Position of CLL field.
	SYSCFG_CFGR2_CLL_Msk  = 0x1   // Bit mask of CLL field.
	SYSCFG_CFGR2_CLL      = 0x1   // Bit CLL.

	// SWPR: SWPR
	SYSCFG_SWPR_P31WP_Pos = 0x1f       // Position of P31WP field.
	SYSCFG_SWPR_P31WP_Msk = 0x80000000 // Bit mask of P31WP field.
	SYSCFG_SWPR_P31WP     = 0x80000000 // Bit P31WP.
	SYSCFG_SWPR_P30WP_Pos = 0x1e       // Position of P30WP field.
	SYSCFG_SWPR_P30WP_Msk = 0x40000000 // Bit mask of P30WP field.
	SYSCFG_SWPR_P30WP     = 0x40000000 // Bit P30WP.
	SYSCFG_SWPR_P29WP_Pos = 0x1d       // Position of P29WP field.
	SYSCFG_SWPR_P29WP_Msk = 0x20000000 // Bit mask of P29WP field.
	SYSCFG_SWPR_P29WP     = 0x20000000 // Bit P29WP.
	SYSCFG_SWPR_P28WP_Pos = 0x1c       // Position of P28WP field.
	SYSCFG_SWPR_P28WP_Msk = 0x10000000 // Bit mask of P28WP field.
	SYSCFG_SWPR_P28WP     = 0x10000000 // Bit P28WP.
	SYSCFG_SWPR_P27WP_Pos = 0x1b       // Position of P27WP field.
	SYSCFG_SWPR_P27WP_Msk = 0x8000000  // Bit mask of P27WP field.
	SYSCFG_SWPR_P27WP     = 0x8000000  // Bit P27WP.
	SYSCFG_SWPR_P26WP_Pos = 0x1a       // Position of P26WP field.
	SYSCFG_SWPR_P26WP_Msk = 0x4000000  // Bit mask of P26WP field.
	SYSCFG_SWPR_P26WP     = 0x4000000  // Bit P26WP.
	SYSCFG_SWPR_P25WP_Pos = 0x19       // Position of P25WP field.
	SYSCFG_SWPR_P25WP_Msk = 0x2000000  // Bit mask of P25WP field.
	SYSCFG_SWPR_P25WP     = 0x2000000  // Bit P25WP.
	SYSCFG_SWPR_P24WP_Pos = 0x18       // Position of P24WP field.
	SYSCFG_SWPR_P24WP_Msk = 0x1000000  // Bit mask of P24WP field.
	SYSCFG_SWPR_P24WP     = 0x1000000  // Bit P24WP.
	SYSCFG_SWPR_P23WP_Pos = 0x17       // Position of P23WP field.
	SYSCFG_SWPR_P23WP_Msk = 0x800000   // Bit mask of P23WP field.
	SYSCFG_SWPR_P23WP     = 0x800000   // Bit P23WP.
	SYSCFG_SWPR_P22WP_Pos = 0x16       // Position of P22WP field.
	SYSCFG_SWPR_P22WP_Msk = 0x400000   // Bit mask of P22WP field.
	SYSCFG_SWPR_P22WP     = 0x400000   // Bit P22WP.
	SYSCFG_SWPR_P21WP_Pos = 0x15       // Position of P21WP field.
	SYSCFG_SWPR_P21WP_Msk = 0x200000   // Bit mask of P21WP field.
	SYSCFG_SWPR_P21WP     = 0x200000   // Bit P21WP.
	SYSCFG_SWPR_P20WP_Pos = 0x14       // Position of P20WP field.
	SYSCFG_SWPR_P20WP_Msk = 0x100000   // Bit mask of P20WP field.
	SYSCFG_SWPR_P20WP     = 0x100000   // Bit P20WP.
	SYSCFG_SWPR_P19WP_Pos = 0x13       // Position of P19WP field.
	SYSCFG_SWPR_P19WP_Msk = 0x80000    // Bit mask of P19WP field.
	SYSCFG_SWPR_P19WP     = 0x80000    // Bit P19WP.
	SYSCFG_SWPR_P18WP_Pos = 0x12       // Position of P18WP field.
	SYSCFG_SWPR_P18WP_Msk = 0x40000    // Bit mask of P18WP field.
	SYSCFG_SWPR_P18WP     = 0x40000    // Bit P18WP.
	SYSCFG_SWPR_P17WP_Pos = 0x11       // Position of P17WP field.
	SYSCFG_SWPR_P17WP_Msk = 0x20000    // Bit mask of P17WP field.
	SYSCFG_SWPR_P17WP     = 0x20000    // Bit P17WP.
	SYSCFG_SWPR_P16WP_Pos = 0x10       // Position of P16WP field.
	SYSCFG_SWPR_P16WP_Msk = 0x10000    // Bit mask of P16WP field.
	SYSCFG_SWPR_P16WP     = 0x10000    // Bit P16WP.
	SYSCFG_SWPR_P15WP_Pos = 0xf        // Position of P15WP field.
	SYSCFG_SWPR_P15WP_Msk = 0x8000     // Bit mask of P15WP field.
	SYSCFG_SWPR_P15WP     = 0x8000     // Bit P15WP.
	SYSCFG_SWPR_P14WP_Pos = 0xe        // Position of P14WP field.
	SYSCFG_SWPR_P14WP_Msk = 0x4000     // Bit mask of P14WP field.
	SYSCFG_SWPR_P14WP     = 0x4000     // Bit P14WP.
	SYSCFG_SWPR_P13WP_Pos = 0xd        // Position of P13WP field.
	SYSCFG_SWPR_P13WP_Msk = 0x2000     // Bit mask of P13WP field.
	SYSCFG_SWPR_P13WP     = 0x2000     // Bit P13WP.
	SYSCFG_SWPR_P12WP_Pos = 0xc        // Position of P12WP field.
	SYSCFG_SWPR_P12WP_Msk = 0x1000     // Bit mask of P12WP field.
	SYSCFG_SWPR_P12WP     = 0x1000     // Bit P12WP.
	SYSCFG_SWPR_P11WP_Pos = 0xb        // Position of P11WP field.
	SYSCFG_SWPR_P11WP_Msk = 0x800      // Bit mask of P11WP field.
	SYSCFG_SWPR_P11WP     = 0x800      // Bit P11WP.
	SYSCFG_SWPR_P10WP_Pos = 0xa        // Position of P10WP field.
	SYSCFG_SWPR_P10WP_Msk = 0x400      // Bit mask of P10WP field.
	SYSCFG_SWPR_P10WP     = 0x400      // Bit P10WP.
	SYSCFG_SWPR_P9WP_Pos  = 0x9        // Position of P9WP field.
	SYSCFG_SWPR_P9WP_Msk  = 0x200      // Bit mask of P9WP field.
	SYSCFG_SWPR_P9WP      = 0x200      // Bit P9WP.
	SYSCFG_SWPR_P8WP_Pos  = 0x8        // Position of P8WP field.
	SYSCFG_SWPR_P8WP_Msk  = 0x100      // Bit mask of P8WP field.
	SYSCFG_SWPR_P8WP      = 0x100      // Bit P8WP.
	SYSCFG_SWPR_P7WP_Pos  = 0x7        // Position of P7WP field.
	SYSCFG_SWPR_P7WP_Msk  = 0x80       // Bit mask of P7WP field.
	SYSCFG_SWPR_P7WP      = 0x80       // Bit P7WP.
	SYSCFG_SWPR_P6WP_Pos  = 0x6        // Position of P6WP field.
	SYSCFG_SWPR_P6WP_Msk  = 0x40       // Bit mask of P6WP field.
	SYSCFG_SWPR_P6WP      = 0x40       // Bit P6WP.
	SYSCFG_SWPR_P5WP_Pos  = 0x5        // Position of P5WP field.
	SYSCFG_SWPR_P5WP_Msk  = 0x20       // Bit mask of P5WP field.
	SYSCFG_SWPR_P5WP      = 0x20       // Bit P5WP.
	SYSCFG_SWPR_P4WP_Pos  = 0x4        // Position of P4WP field.
	SYSCFG_SWPR_P4WP_Msk  = 0x10       // Bit mask of P4WP field.
	SYSCFG_SWPR_P4WP      = 0x10       // Bit P4WP.
	SYSCFG_SWPR_P3WP_Pos  = 0x3        // Position of P3WP field.
	SYSCFG_SWPR_P3WP_Msk  = 0x8        // Bit mask of P3WP field.
	SYSCFG_SWPR_P3WP      = 0x8        // Bit P3WP.
	SYSCFG_SWPR_P2WP_Pos  = 0x2        // Position of P2WP field.
	SYSCFG_SWPR_P2WP_Msk  = 0x4        // Bit mask of P2WP field.
	SYSCFG_SWPR_P2WP      = 0x4        // Bit P2WP.
	SYSCFG_SWPR_P1WP_Pos  = 0x1        // Position of P1WP field.
	SYSCFG_SWPR_P1WP_Msk  = 0x2        // Bit mask of P1WP field.
	SYSCFG_SWPR_P1WP      = 0x2        // Bit P1WP.
	SYSCFG_SWPR_P0WP_Pos  = 0x0        // Position of P0WP field.
	SYSCFG_SWPR_P0WP_Msk  = 0x1        // Bit mask of P0WP field.
	SYSCFG_SWPR_P0WP      = 0x1        // Bit P0WP.

	// SKR: SKR
	SYSCFG_SKR_KEY_Pos = 0x0  // Position of KEY field.
	SYSCFG_SKR_KEY_Msk = 0xff // Bit mask of KEY field.
)

// Bitfields for DFSDM1: Digital filter for sigma delta modulators
const (
	// CHCFG0R1: channel configuration y           register
	DFSDM_CHCFG0R1_DFSDMEN_Pos  = 0x1f       // Position of DFSDMEN field.
	DFSDM_CHCFG0R1_DFSDMEN_Msk  = 0x80000000 // Bit mask of DFSDMEN field.
	DFSDM_CHCFG0R1_DFSDMEN      = 0x80000000 // Bit DFSDMEN.
	DFSDM_CHCFG0R1_CKOUTSRC_Pos = 0x1e       // Position of CKOUTSRC field.
	DFSDM_CHCFG0R1_CKOUTSRC_Msk = 0x40000000 // Bit mask of CKOUTSRC field.
	DFSDM_CHCFG0R1_CKOUTSRC     = 0x40000000 // Bit CKOUTSRC.
	DFSDM_CHCFG0R1_CKOUTDIV_Pos = 0x10       // Position of CKOUTDIV field.
	DFSDM_CHCFG0R1_CKOUTDIV_Msk = 0xff0000   // Bit mask of CKOUTDIV field.
	DFSDM_CHCFG0R1_DATPACK_Pos  = 0xe        // Position of DATPACK field.
	DFSDM_CHCFG0R1_DATPACK_Msk  = 0xc000     // Bit mask of DATPACK field.
	DFSDM_CHCFG0R1_DATMPX_Pos   = 0xc        // Position of DATMPX field.
	DFSDM_CHCFG0R1_DATMPX_Msk   = 0x3000     // Bit mask of DATMPX field.
	DFSDM_CHCFG0R1_CHINSEL_Pos  = 0x8        // Position of CHINSEL field.
	DFSDM_CHCFG0R1_CHINSEL_Msk  = 0x100      // Bit mask of CHINSEL field.
	DFSDM_CHCFG0R1_CHINSEL      = 0x100      // Bit CHINSEL.
	DFSDM_CHCFG0R1_CHEN_Pos     = 0x7        // Position of CHEN field.
	DFSDM_CHCFG0R1_CHEN_Msk     = 0x80       // Bit mask of CHEN field.
	DFSDM_CHCFG0R1_CHEN         = 0x80       // Bit CHEN.
	DFSDM_CHCFG0R1_CKABEN_Pos   = 0x6        // Position of CKABEN field.
	DFSDM_CHCFG0R1_CKABEN_Msk   = 0x40       // Bit mask of CKABEN field.
	DFSDM_CHCFG0R1_CKABEN       = 0x40       // Bit CKABEN.
	DFSDM_CHCFG0R1_SCDEN_Pos    = 0x5        // Position of SCDEN field.
	DFSDM_CHCFG0R1_SCDEN_Msk    = 0x20       // Bit mask of SCDEN field.
	DFSDM_CHCFG0R1_SCDEN        = 0x20       // Bit SCDEN.
	DFSDM_CHCFG0R1_SPICKSEL_Pos = 0x2        // Position of SPICKSEL field.
	DFSDM_CHCFG0R1_SPICKSEL_Msk = 0xc        // Bit mask of SPICKSEL field.
	DFSDM_CHCFG0R1_SITP_Pos     = 0x0        // Position of SITP field.
	DFSDM_CHCFG0R1_SITP_Msk     = 0x3        // Bit mask of SITP field.

	// CHCFG0R2: channel configuration y           register
	DFSDM_CHCFG0R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG0R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG0R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG0R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD0R: analog watchdog and short-circuit detector           register
	DFSDM_AWSCD0R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD0R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD0R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD0R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD0R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD0R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD0R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD0R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT0R: channel watchdog filter data           register
	DFSDM_CHWDAT0R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT0R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN0R: channel data input register
	DFSDM_CHDATIN0R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN0R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN0R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN0R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG1R1: CHCFG1R1
	DFSDM_CHCFG1R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG1R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG1R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG1R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG1R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG1R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG1R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG1R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG1R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG1R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG1R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG1R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG1R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG1R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG1R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG1R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG1R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG1R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG1R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG1R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG1R2: CHCFG1R2
	DFSDM_CHCFG1R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG1R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG1R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG1R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD1R: AWSCD1R
	DFSDM_AWSCD1R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD1R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD1R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD1R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD1R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD1R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD1R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD1R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT1R: CHWDAT1R
	DFSDM_CHWDAT1R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT1R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN1R: CHDATIN1R
	DFSDM_CHDATIN1R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN1R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN1R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN1R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG2R1: CHCFG2R1
	DFSDM_CHCFG2R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG2R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG2R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG2R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG2R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG2R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG2R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG2R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG2R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG2R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG2R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG2R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG2R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG2R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG2R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG2R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG2R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG2R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG2R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG2R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG2R2: CHCFG2R2
	DFSDM_CHCFG2R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG2R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG2R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG2R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD2R: AWSCD2R
	DFSDM_AWSCD2R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD2R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD2R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD2R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD2R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD2R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD2R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD2R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT2R: CHWDAT2R
	DFSDM_CHWDAT2R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT2R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN2R: CHDATIN2R
	DFSDM_CHDATIN2R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN2R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN2R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN2R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG3R1: CHCFG3R1
	DFSDM_CHCFG3R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG3R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG3R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG3R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG3R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG3R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG3R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG3R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG3R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG3R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG3R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG3R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG3R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG3R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG3R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG3R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG3R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG3R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG3R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG3R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG3R2: CHCFG3R2
	DFSDM_CHCFG3R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG3R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG3R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG3R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD3R: AWSCD3R
	DFSDM_AWSCD3R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD3R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD3R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD3R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD3R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD3R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD3R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD3R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT3R: CHWDAT3R
	DFSDM_CHWDAT3R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT3R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN3R: CHDATIN3R
	DFSDM_CHDATIN3R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN3R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN3R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN3R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG4R1: CHCFG4R1
	DFSDM_CHCFG4R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG4R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG4R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG4R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG4R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG4R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG4R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG4R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG4R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG4R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG4R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG4R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG4R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG4R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG4R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG4R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG4R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG4R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG4R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG4R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG4R2: CHCFG4R2
	DFSDM_CHCFG4R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG4R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG4R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG4R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD4R: AWSCD4R
	DFSDM_AWSCD4R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD4R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD4R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD4R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD4R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD4R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD4R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD4R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT4R: CHWDAT4R
	DFSDM_CHWDAT4R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT4R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN4R: CHDATIN4R
	DFSDM_CHDATIN4R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN4R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN4R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN4R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG5R1: CHCFG5R1
	DFSDM_CHCFG5R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG5R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG5R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG5R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG5R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG5R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG5R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG5R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG5R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG5R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG5R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG5R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG5R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG5R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG5R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG5R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG5R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG5R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG5R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG5R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG5R2: CHCFG5R2
	DFSDM_CHCFG5R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG5R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG5R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG5R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD5R: AWSCD5R
	DFSDM_AWSCD5R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD5R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD5R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD5R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD5R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD5R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD5R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD5R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT5R: CHWDAT5R
	DFSDM_CHWDAT5R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT5R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN5R: CHDATIN5R
	DFSDM_CHDATIN5R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN5R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN5R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN5R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG6R1: CHCFG6R1
	DFSDM_CHCFG6R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG6R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG6R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG6R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG6R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG6R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG6R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG6R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG6R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG6R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG6R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG6R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG6R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG6R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG6R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG6R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG6R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG6R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG6R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG6R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG6R2: CHCFG6R2
	DFSDM_CHCFG6R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG6R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG6R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG6R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD6R: AWSCD6R
	DFSDM_AWSCD6R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD6R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD6R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD6R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD6R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD6R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD6R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD6R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT6R: CHWDAT6R
	DFSDM_CHWDAT6R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT6R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN6R: CHDATIN6R
	DFSDM_CHDATIN6R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN6R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN6R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN6R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// CHCFG7R1: CHCFG7R1
	DFSDM_CHCFG7R1_DATPACK_Pos  = 0xe    // Position of DATPACK field.
	DFSDM_CHCFG7R1_DATPACK_Msk  = 0xc000 // Bit mask of DATPACK field.
	DFSDM_CHCFG7R1_DATMPX_Pos   = 0xc    // Position of DATMPX field.
	DFSDM_CHCFG7R1_DATMPX_Msk   = 0x3000 // Bit mask of DATMPX field.
	DFSDM_CHCFG7R1_CHINSEL_Pos  = 0x8    // Position of CHINSEL field.
	DFSDM_CHCFG7R1_CHINSEL_Msk  = 0x100  // Bit mask of CHINSEL field.
	DFSDM_CHCFG7R1_CHINSEL      = 0x100  // Bit CHINSEL.
	DFSDM_CHCFG7R1_CHEN_Pos     = 0x7    // Position of CHEN field.
	DFSDM_CHCFG7R1_CHEN_Msk     = 0x80   // Bit mask of CHEN field.
	DFSDM_CHCFG7R1_CHEN         = 0x80   // Bit CHEN.
	DFSDM_CHCFG7R1_CKABEN_Pos   = 0x6    // Position of CKABEN field.
	DFSDM_CHCFG7R1_CKABEN_Msk   = 0x40   // Bit mask of CKABEN field.
	DFSDM_CHCFG7R1_CKABEN       = 0x40   // Bit CKABEN.
	DFSDM_CHCFG7R1_SCDEN_Pos    = 0x5    // Position of SCDEN field.
	DFSDM_CHCFG7R1_SCDEN_Msk    = 0x20   // Bit mask of SCDEN field.
	DFSDM_CHCFG7R1_SCDEN        = 0x20   // Bit SCDEN.
	DFSDM_CHCFG7R1_SPICKSEL_Pos = 0x2    // Position of SPICKSEL field.
	DFSDM_CHCFG7R1_SPICKSEL_Msk = 0xc    // Bit mask of SPICKSEL field.
	DFSDM_CHCFG7R1_SITP_Pos     = 0x0    // Position of SITP field.
	DFSDM_CHCFG7R1_SITP_Msk     = 0x3    // Bit mask of SITP field.

	// CHCFG7R2: CHCFG7R2
	DFSDM_CHCFG7R2_OFFSET_Pos = 0x8        // Position of OFFSET field.
	DFSDM_CHCFG7R2_OFFSET_Msk = 0xffffff00 // Bit mask of OFFSET field.
	DFSDM_CHCFG7R2_DTRBS_Pos  = 0x3        // Position of DTRBS field.
	DFSDM_CHCFG7R2_DTRBS_Msk  = 0xf8       // Bit mask of DTRBS field.

	// AWSCD7R: AWSCD7R
	DFSDM_AWSCD7R_AWFORD_Pos = 0x16     // Position of AWFORD field.
	DFSDM_AWSCD7R_AWFORD_Msk = 0xc00000 // Bit mask of AWFORD field.
	DFSDM_AWSCD7R_AWFOSR_Pos = 0x10     // Position of AWFOSR field.
	DFSDM_AWSCD7R_AWFOSR_Msk = 0x1f0000 // Bit mask of AWFOSR field.
	DFSDM_AWSCD7R_BKSCD_Pos  = 0xc      // Position of BKSCD field.
	DFSDM_AWSCD7R_BKSCD_Msk  = 0xf000   // Bit mask of BKSCD field.
	DFSDM_AWSCD7R_SCDT_Pos   = 0x0      // Position of SCDT field.
	DFSDM_AWSCD7R_SCDT_Msk   = 0xff     // Bit mask of SCDT field.

	// CHWDAT7R: CHWDAT7R
	DFSDM_CHWDAT7R_WDATA_Pos = 0x0    // Position of WDATA field.
	DFSDM_CHWDAT7R_WDATA_Msk = 0xffff // Bit mask of WDATA field.

	// CHDATIN7R: CHDATIN7R
	DFSDM_CHDATIN7R_INDAT1_Pos = 0x10       // Position of INDAT1 field.
	DFSDM_CHDATIN7R_INDAT1_Msk = 0xffff0000 // Bit mask of INDAT1 field.
	DFSDM_CHDATIN7R_INDAT0_Pos = 0x0        // Position of INDAT0 field.
	DFSDM_CHDATIN7R_INDAT0_Msk = 0xffff     // Bit mask of INDAT0 field.

	// DFSDM0_CR1: control register 1
	DFSDM_DFSDM0_CR1_AWFSEL_Pos   = 0x1e       // Position of AWFSEL field.
	DFSDM_DFSDM0_CR1_AWFSEL_Msk   = 0x40000000 // Bit mask of AWFSEL field.
	DFSDM_DFSDM0_CR1_AWFSEL       = 0x40000000 // Bit AWFSEL.
	DFSDM_DFSDM0_CR1_FAST_Pos     = 0x1d       // Position of FAST field.
	DFSDM_DFSDM0_CR1_FAST_Msk     = 0x20000000 // Bit mask of FAST field.
	DFSDM_DFSDM0_CR1_FAST         = 0x20000000 // Bit FAST.
	DFSDM_DFSDM0_CR1_RCH_Pos      = 0x18       // Position of RCH field.
	DFSDM_DFSDM0_CR1_RCH_Msk      = 0x7000000  // Bit mask of RCH field.
	DFSDM_DFSDM0_CR1_RDMAEN_Pos   = 0x15       // Position of RDMAEN field.
	DFSDM_DFSDM0_CR1_RDMAEN_Msk   = 0x200000   // Bit mask of RDMAEN field.
	DFSDM_DFSDM0_CR1_RDMAEN       = 0x200000   // Bit RDMAEN.
	DFSDM_DFSDM0_CR1_RSYNC_Pos    = 0x13       // Position of RSYNC field.
	DFSDM_DFSDM0_CR1_RSYNC_Msk    = 0x80000    // Bit mask of RSYNC field.
	DFSDM_DFSDM0_CR1_RSYNC        = 0x80000    // Bit RSYNC.
	DFSDM_DFSDM0_CR1_RCONT_Pos    = 0x12       // Position of RCONT field.
	DFSDM_DFSDM0_CR1_RCONT_Msk    = 0x40000    // Bit mask of RCONT field.
	DFSDM_DFSDM0_CR1_RCONT        = 0x40000    // Bit RCONT.
	DFSDM_DFSDM0_CR1_RSWSTART_Pos = 0x11       // Position of RSWSTART field.
	DFSDM_DFSDM0_CR1_RSWSTART_Msk = 0x20000    // Bit mask of RSWSTART field.
	DFSDM_DFSDM0_CR1_RSWSTART     = 0x20000    // Bit RSWSTART.
	DFSDM_DFSDM0_CR1_JEXTEN_Pos   = 0xd        // Position of JEXTEN field.
	DFSDM_DFSDM0_CR1_JEXTEN_Msk   = 0x6000     // Bit mask of JEXTEN field.
	DFSDM_DFSDM0_CR1_JEXTSEL_Pos  = 0x8        // Position of JEXTSEL field.
	DFSDM_DFSDM0_CR1_JEXTSEL_Msk  = 0x700      // Bit mask of JEXTSEL field.
	DFSDM_DFSDM0_CR1_JDMAEN_Pos   = 0x5        // Position of JDMAEN field.
	DFSDM_DFSDM0_CR1_JDMAEN_Msk   = 0x20       // Bit mask of JDMAEN field.
	DFSDM_DFSDM0_CR1_JDMAEN       = 0x20       // Bit JDMAEN.
	DFSDM_DFSDM0_CR1_JSCAN_Pos    = 0x4        // Position of JSCAN field.
	DFSDM_DFSDM0_CR1_JSCAN_Msk    = 0x10       // Bit mask of JSCAN field.
	DFSDM_DFSDM0_CR1_JSCAN        = 0x10       // Bit JSCAN.
	DFSDM_DFSDM0_CR1_JSYNC_Pos    = 0x3        // Position of JSYNC field.
	DFSDM_DFSDM0_CR1_JSYNC_Msk    = 0x8        // Bit mask of JSYNC field.
	DFSDM_DFSDM0_CR1_JSYNC        = 0x8        // Bit JSYNC.
	DFSDM_DFSDM0_CR1_JSWSTART_Pos = 0x1        // Position of JSWSTART field.
	DFSDM_DFSDM0_CR1_JSWSTART_Msk = 0x2        // Bit mask of JSWSTART field.
	DFSDM_DFSDM0_CR1_JSWSTART     = 0x2        // Bit JSWSTART.
	DFSDM_DFSDM0_CR1_DFEN_Pos     = 0x0        // Position of DFEN field.
	DFSDM_DFSDM0_CR1_DFEN_Msk     = 0x1        // Bit mask of DFEN field.
	DFSDM_DFSDM0_CR1_DFEN         = 0x1        // Bit DFEN.

	// DFSDM0_CR2: control register 2
	DFSDM_DFSDM0_CR2_AWDCH_Pos  = 0x10     // Position of AWDCH field.
	DFSDM_DFSDM0_CR2_AWDCH_Msk  = 0xff0000 // Bit mask of AWDCH field.
	DFSDM_DFSDM0_CR2_EXCH_Pos   = 0x8      // Position of EXCH field.
	DFSDM_DFSDM0_CR2_EXCH_Msk   = 0xff00   // Bit mask of EXCH field.
	DFSDM_DFSDM0_CR2_CKABIE_Pos = 0x6      // Position of CKABIE field.
	DFSDM_DFSDM0_CR2_CKABIE_Msk = 0x40     // Bit mask of CKABIE field.
	DFSDM_DFSDM0_CR2_CKABIE     = 0x40     // Bit CKABIE.
	DFSDM_DFSDM0_CR2_SCDIE_Pos  = 0x5      // Position of SCDIE field.
	DFSDM_DFSDM0_CR2_SCDIE_Msk  = 0x20     // Bit mask of SCDIE field.
	DFSDM_DFSDM0_CR2_SCDIE      = 0x20     // Bit SCDIE.
	DFSDM_DFSDM0_CR2_AWDIE_Pos  = 0x4      // Position of AWDIE field.
	DFSDM_DFSDM0_CR2_AWDIE_Msk  = 0x10     // Bit mask of AWDIE field.
	DFSDM_DFSDM0_CR2_AWDIE      = 0x10     // Bit AWDIE.
	DFSDM_DFSDM0_CR2_ROVRIE_Pos = 0x3      // Position of ROVRIE field.
	DFSDM_DFSDM0_CR2_ROVRIE_Msk = 0x8      // Bit mask of ROVRIE field.
	DFSDM_DFSDM0_CR2_ROVRIE     = 0x8      // Bit ROVRIE.
	DFSDM_DFSDM0_CR2_JOVRIE_Pos = 0x2      // Position of JOVRIE field.
	DFSDM_DFSDM0_CR2_JOVRIE_Msk = 0x4      // Bit mask of JOVRIE field.
	DFSDM_DFSDM0_CR2_JOVRIE     = 0x4      // Bit JOVRIE.
	DFSDM_DFSDM0_CR2_REOCIE_Pos = 0x1      // Position of REOCIE field.
	DFSDM_DFSDM0_CR2_REOCIE_Msk = 0x2      // Bit mask of REOCIE field.
	DFSDM_DFSDM0_CR2_REOCIE     = 0x2      // Bit REOCIE.
	DFSDM_DFSDM0_CR2_JEOCIE_Pos = 0x0      // Position of JEOCIE field.
	DFSDM_DFSDM0_CR2_JEOCIE_Msk = 0x1      // Bit mask of JEOCIE field.
	DFSDM_DFSDM0_CR2_JEOCIE     = 0x1      // Bit JEOCIE.

	// DFSDM0_ISR: interrupt and status register
	DFSDM_DFSDM0_ISR_SCDF_Pos  = 0x18       // Position of SCDF field.
	DFSDM_DFSDM0_ISR_SCDF_Msk  = 0xff000000 // Bit mask of SCDF field.
	DFSDM_DFSDM0_ISR_CKABF_Pos = 0x10       // Position of CKABF field.
	DFSDM_DFSDM0_ISR_CKABF_Msk = 0xff0000   // Bit mask of CKABF field.
	DFSDM_DFSDM0_ISR_RCIP_Pos  = 0xe        // Position of RCIP field.
	DFSDM_DFSDM0_ISR_RCIP_Msk  = 0x4000     // Bit mask of RCIP field.
	DFSDM_DFSDM0_ISR_RCIP      = 0x4000     // Bit RCIP.
	DFSDM_DFSDM0_ISR_JCIP_Pos  = 0xd        // Position of JCIP field.
	DFSDM_DFSDM0_ISR_JCIP_Msk  = 0x2000     // Bit mask of JCIP field.
	DFSDM_DFSDM0_ISR_JCIP      = 0x2000     // Bit JCIP.
	DFSDM_DFSDM0_ISR_AWDF_Pos  = 0x4        // Position of AWDF field.
	DFSDM_DFSDM0_ISR_AWDF_Msk  = 0x10       // Bit mask of AWDF field.
	DFSDM_DFSDM0_ISR_AWDF      = 0x10       // Bit AWDF.
	DFSDM_DFSDM0_ISR_ROVRF_Pos = 0x3        // Position of ROVRF field.
	DFSDM_DFSDM0_ISR_ROVRF_Msk = 0x8        // Bit mask of ROVRF field.
	DFSDM_DFSDM0_ISR_ROVRF     = 0x8        // Bit ROVRF.
	DFSDM_DFSDM0_ISR_JOVRF_Pos = 0x2        // Position of JOVRF field.
	DFSDM_DFSDM0_ISR_JOVRF_Msk = 0x4        // Bit mask of JOVRF field.
	DFSDM_DFSDM0_ISR_JOVRF     = 0x4        // Bit JOVRF.
	DFSDM_DFSDM0_ISR_REOCF_Pos = 0x1        // Position of REOCF field.
	DFSDM_DFSDM0_ISR_REOCF_Msk = 0x2        // Bit mask of REOCF field.
	DFSDM_DFSDM0_ISR_REOCF     = 0x2        // Bit REOCF.
	DFSDM_DFSDM0_ISR_JEOCF_Pos = 0x0        // Position of JEOCF field.
	DFSDM_DFSDM0_ISR_JEOCF_Msk = 0x1        // Bit mask of JEOCF field.
	DFSDM_DFSDM0_ISR_JEOCF     = 0x1        // Bit JEOCF.

	// DFSDM0_ICR: interrupt flag clear register
	DFSDM_DFSDM0_ICR_CLRSCDF_Pos  = 0x18       // Position of CLRSCDF field.
	DFSDM_DFSDM0_ICR_CLRSCDF_Msk  = 0xff000000 // Bit mask of CLRSCDF field.
	DFSDM_DFSDM0_ICR_CLRCKABF_Pos = 0x10       // Position of CLRCKABF field.
	DFSDM_DFSDM0_ICR_CLRCKABF_Msk = 0xff0000   // Bit mask of CLRCKABF field.
	DFSDM_DFSDM0_ICR_CLRROVRF_Pos = 0x3        // Position of CLRROVRF field.
	DFSDM_DFSDM0_ICR_CLRROVRF_Msk = 0x8        // Bit mask of CLRROVRF field.
	DFSDM_DFSDM0_ICR_CLRROVRF     = 0x8        // Bit CLRROVRF.
	DFSDM_DFSDM0_ICR_CLRJOVRF_Pos = 0x2        // Position of CLRJOVRF field.
	DFSDM_DFSDM0_ICR_CLRJOVRF_Msk = 0x4        // Bit mask of CLRJOVRF field.
	DFSDM_DFSDM0_ICR_CLRJOVRF     = 0x4        // Bit CLRJOVRF.

	// DFSDM0_JCHGR: injected channel group selection           register
	DFSDM_DFSDM0_JCHGR_JCHG_Pos = 0x0  // Position of JCHG field.
	DFSDM_DFSDM0_JCHGR_JCHG_Msk = 0xff // Bit mask of JCHG field.

	// DFSDM0_FCR: filter control register
	DFSDM_DFSDM0_FCR_FORD_Pos = 0x1d       // Position of FORD field.
	DFSDM_DFSDM0_FCR_FORD_Msk = 0xe0000000 // Bit mask of FORD field.
	DFSDM_DFSDM0_FCR_FOSR_Pos = 0x10       // Position of FOSR field.
	DFSDM_DFSDM0_FCR_FOSR_Msk = 0x3ff0000  // Bit mask of FOSR field.
	DFSDM_DFSDM0_FCR_IOSR_Pos = 0x0        // Position of IOSR field.
	DFSDM_DFSDM0_FCR_IOSR_Msk = 0xff       // Bit mask of IOSR field.

	// DFSDM0_JDATAR: data register for injected           group
	DFSDM_DFSDM0_JDATAR_JDATA_Pos   = 0x8        // Position of JDATA field.
	DFSDM_DFSDM0_JDATAR_JDATA_Msk   = 0xffffff00 // Bit mask of JDATA field.
	DFSDM_DFSDM0_JDATAR_JDATACH_Pos = 0x0        // Position of JDATACH field.
	DFSDM_DFSDM0_JDATAR_JDATACH_Msk = 0x7        // Bit mask of JDATACH field.

	// DFSDM0_RDATAR: data register for the regular           channel
	DFSDM_DFSDM0_RDATAR_RDATA_Pos   = 0x8        // Position of RDATA field.
	DFSDM_DFSDM0_RDATAR_RDATA_Msk   = 0xffffff00 // Bit mask of RDATA field.
	DFSDM_DFSDM0_RDATAR_RPEND_Pos   = 0x4        // Position of RPEND field.
	DFSDM_DFSDM0_RDATAR_RPEND_Msk   = 0x10       // Bit mask of RPEND field.
	DFSDM_DFSDM0_RDATAR_RPEND       = 0x10       // Bit RPEND.
	DFSDM_DFSDM0_RDATAR_RDATACH_Pos = 0x0        // Position of RDATACH field.
	DFSDM_DFSDM0_RDATAR_RDATACH_Msk = 0x7        // Bit mask of RDATACH field.

	// DFSDM0_AWHTR: analog watchdog high threshold           register
	DFSDM_DFSDM0_AWHTR_AWHT_Pos  = 0x8        // Position of AWHT field.
	DFSDM_DFSDM0_AWHTR_AWHT_Msk  = 0xffffff00 // Bit mask of AWHT field.
	DFSDM_DFSDM0_AWHTR_BKAWH_Pos = 0x0        // Position of BKAWH field.
	DFSDM_DFSDM0_AWHTR_BKAWH_Msk = 0xf        // Bit mask of BKAWH field.

	// DFSDM0_AWLTR: analog watchdog low threshold           register
	DFSDM_DFSDM0_AWLTR_AWLT_Pos  = 0x8        // Position of AWLT field.
	DFSDM_DFSDM0_AWLTR_AWLT_Msk  = 0xffffff00 // Bit mask of AWLT field.
	DFSDM_DFSDM0_AWLTR_BKAWL_Pos = 0x0        // Position of BKAWL field.
	DFSDM_DFSDM0_AWLTR_BKAWL_Msk = 0xf        // Bit mask of BKAWL field.

	// DFSDM0_AWSR: analog watchdog status           register
	DFSDM_DFSDM0_AWSR_AWHTF_Pos = 0x8    // Position of AWHTF field.
	DFSDM_DFSDM0_AWSR_AWHTF_Msk = 0xff00 // Bit mask of AWHTF field.
	DFSDM_DFSDM0_AWSR_AWLTF_Pos = 0x0    // Position of AWLTF field.
	DFSDM_DFSDM0_AWSR_AWLTF_Msk = 0xff   // Bit mask of AWLTF field.

	// DFSDM0_AWCFR: analog watchdog clear flag           register
	DFSDM_DFSDM0_AWCFR_CLRAWHTF_Pos = 0x8    // Position of CLRAWHTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWHTF_Msk = 0xff00 // Bit mask of CLRAWHTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWLTF_Pos = 0x0    // Position of CLRAWLTF field.
	DFSDM_DFSDM0_AWCFR_CLRAWLTF_Msk = 0xff   // Bit mask of CLRAWLTF field.

	// DFSDM0_EXMAX: Extremes detector maximum           register
	DFSDM_DFSDM0_EXMAX_EXMAX_Pos   = 0x8        // Position of EXMAX field.
	DFSDM_DFSDM0_EXMAX_EXMAX_Msk   = 0xffffff00 // Bit mask of EXMAX field.
	DFSDM_DFSDM0_EXMAX_EXMAXCH_Pos = 0x0        // Position of EXMAXCH field.
	DFSDM_DFSDM0_EXMAX_EXMAXCH_Msk = 0x7        // Bit mask of EXMAXCH field.

	// DFSDM0_EXMIN: Extremes detector minimum           register
	DFSDM_DFSDM0_EXMIN_EXMIN_Pos   = 0x8        // Position of EXMIN field.
	DFSDM_DFSDM0_EXMIN_EXMIN_Msk   = 0xffffff00 // Bit mask of EXMIN field.
	DFSDM_DFSDM0_EXMIN_EXMINCH_Pos = 0x0        // Position of EXMINCH field.
	DFSDM_DFSDM0_EXMIN_EXMINCH_Msk = 0x7        // Bit mask of EXMINCH field.

	// DFSDM0_CNVTIMR: conversion timer register
	DFSDM_DFSDM0_CNVTIMR_CNVCNT_Pos = 0x4        // Position of CNVCNT field.
	DFSDM_DFSDM0_CNVTIMR_CNVCNT_Msk = 0xfffffff0 // Bit mask of CNVCNT field.

	// DFSDM1_CR1: control register 1
	DFSDM_DFSDM1_CR1_AWFSEL_Pos   = 0x1e       // Position of AWFSEL field.
	DFSDM_DFSDM1_CR1_AWFSEL_Msk   = 0x40000000 // Bit mask of AWFSEL field.
	DFSDM_DFSDM1_CR1_AWFSEL       = 0x40000000 // Bit AWFSEL.
	DFSDM_DFSDM1_CR1_FAST_Pos     = 0x1d       // Position of FAST field.
	DFSDM_DFSDM1_CR1_FAST_Msk     = 0x20000000 // Bit mask of FAST field.
	DFSDM_DFSDM1_CR1_FAST         = 0x20000000 // Bit FAST.
	DFSDM_DFSDM1_CR1_RCH_Pos      = 0x18       // Position of RCH field.
	DFSDM_DFSDM1_CR1_RCH_Msk      = 0x7000000  // Bit mask of RCH field.
	DFSDM_DFSDM1_CR1_RDMAEN_Pos   = 0x15       // Position of RDMAEN field.
	DFSDM_DFSDM1_CR1_RDMAEN_Msk   = 0x200000   // Bit mask of RDMAEN field.
	DFSDM_DFSDM1_CR1_RDMAEN       = 0x200000   // Bit RDMAEN.
	DFSDM_DFSDM1_CR1_RSYNC_Pos    = 0x13       // Position of RSYNC field.
	DFSDM_DFSDM1_CR1_RSYNC_Msk    = 0x80000    // Bit mask of RSYNC field.
	DFSDM_DFSDM1_CR1_RSYNC        = 0x80000    // Bit RSYNC.
	DFSDM_DFSDM1_CR1_RCONT_Pos    = 0x12       // Position of RCONT field.
	DFSDM_DFSDM1_CR1_RCONT_Msk    = 0x40000    // Bit mask of RCONT field.
	DFSDM_DFSDM1_CR1_RCONT        = 0x40000    // Bit RCONT.
	DFSDM_DFSDM1_CR1_RSWSTART_Pos = 0x11       // Position of RSWSTART field.
	DFSDM_DFSDM1_CR1_RSWSTART_Msk = 0x20000    // Bit mask of RSWSTART field.
	DFSDM_DFSDM1_CR1_RSWSTART     = 0x20000    // Bit RSWSTART.
	DFSDM_DFSDM1_CR1_JEXTEN_Pos   = 0xd        // Position of JEXTEN field.
	DFSDM_DFSDM1_CR1_JEXTEN_Msk   = 0x6000     // Bit mask of JEXTEN field.
	DFSDM_DFSDM1_CR1_JEXTSEL_Pos  = 0x8        // Position of JEXTSEL field.
	DFSDM_DFSDM1_CR1_JEXTSEL_Msk  = 0x700      // Bit mask of JEXTSEL field.
	DFSDM_DFSDM1_CR1_JDMAEN_Pos   = 0x5        // Position of JDMAEN field.
	DFSDM_DFSDM1_CR1_JDMAEN_Msk   = 0x20       // Bit mask of JDMAEN field.
	DFSDM_DFSDM1_CR1_JDMAEN       = 0x20       // Bit JDMAEN.
	DFSDM_DFSDM1_CR1_JSCAN_Pos    = 0x4        // Position of JSCAN field.
	DFSDM_DFSDM1_CR1_JSCAN_Msk    = 0x10       // Bit mask of JSCAN field.
	DFSDM_DFSDM1_CR1_JSCAN        = 0x10       // Bit JSCAN.
	DFSDM_DFSDM1_CR1_JSYNC_Pos    = 0x3        // Position of JSYNC field.
	DFSDM_DFSDM1_CR1_JSYNC_Msk    = 0x8        // Bit mask of JSYNC field.
	DFSDM_DFSDM1_CR1_JSYNC        = 0x8        // Bit JSYNC.
	DFSDM_DFSDM1_CR1_JSWSTART_Pos = 0x1        // Position of JSWSTART field.
	DFSDM_DFSDM1_CR1_JSWSTART_Msk = 0x2        // Bit mask of JSWSTART field.
	DFSDM_DFSDM1_CR1_JSWSTART     = 0x2        // Bit JSWSTART.
	DFSDM_DFSDM1_CR1_DFEN_Pos     = 0x0        // Position of DFEN field.
	DFSDM_DFSDM1_CR1_DFEN_Msk     = 0x1        // Bit mask of DFEN field.
	DFSDM_DFSDM1_CR1_DFEN         = 0x1        // Bit DFEN.

	// DFSDM1_CR2: control register 2
	DFSDM_DFSDM1_CR2_AWDCH_Pos  = 0x10     // Position of AWDCH field.
	DFSDM_DFSDM1_CR2_AWDCH_Msk  = 0xff0000 // Bit mask of AWDCH field.
	DFSDM_DFSDM1_CR2_EXCH_Pos   = 0x8      // Position of EXCH field.
	DFSDM_DFSDM1_CR2_EXCH_Msk   = 0xff00   // Bit mask of EXCH field.
	DFSDM_DFSDM1_CR2_CKABIE_Pos = 0x6      // Position of CKABIE field.
	DFSDM_DFSDM1_CR2_CKABIE_Msk = 0x40     // Bit mask of CKABIE field.
	DFSDM_DFSDM1_CR2_CKABIE     = 0x40     // Bit CKABIE.
	DFSDM_DFSDM1_CR2_SCDIE_Pos  = 0x5      // Position of SCDIE field.
	DFSDM_DFSDM1_CR2_SCDIE_Msk  = 0x20     // Bit mask of SCDIE field.
	DFSDM_DFSDM1_CR2_SCDIE      = 0x20     // Bit SCDIE.
	DFSDM_DFSDM1_CR2_AWDIE_Pos  = 0x4      // Position of AWDIE field.
	DFSDM_DFSDM1_CR2_AWDIE_Msk  = 0x10     // Bit mask of AWDIE field.
	DFSDM_DFSDM1_CR2_AWDIE      = 0x10     // Bit AWDIE.
	DFSDM_DFSDM1_CR2_ROVRIE_Pos = 0x3      // Position of ROVRIE field.
	DFSDM_DFSDM1_CR2_ROVRIE_Msk = 0x8      // Bit mask of ROVRIE field.
	DFSDM_DFSDM1_CR2_ROVRIE     = 0x8      // Bit ROVRIE.
	DFSDM_DFSDM1_CR2_JOVRIE_Pos = 0x2      // Position of JOVRIE field.
	DFSDM_DFSDM1_CR2_JOVRIE_Msk = 0x4      // Bit mask of JOVRIE field.
	DFSDM_DFSDM1_CR2_JOVRIE     = 0x4      // Bit JOVRIE.
	DFSDM_DFSDM1_CR2_REOCIE_Pos = 0x1      // Position of REOCIE field.
	DFSDM_DFSDM1_CR2_REOCIE_Msk = 0x2      // Bit mask of REOCIE field.
	DFSDM_DFSDM1_CR2_REOCIE     = 0x2      // Bit REOCIE.
	DFSDM_DFSDM1_CR2_JEOCIE_Pos = 0x0      // Position of JEOCIE field.
	DFSDM_DFSDM1_CR2_JEOCIE_Msk = 0x1      // Bit mask of JEOCIE field.
	DFSDM_DFSDM1_CR2_JEOCIE     = 0x1      // Bit JEOCIE.

	// DFSDM1_ISR: interrupt and status register
	DFSDM_DFSDM1_ISR_SCDF_Pos  = 0x18       // Position of SCDF field.
	DFSDM_DFSDM1_ISR_SCDF_Msk  = 0xff000000 // Bit mask of SCDF field.
	DFSDM_DFSDM1_ISR_CKABF_Pos = 0x10       // Position of CKABF field.
	DFSDM_DFSDM1_ISR_CKABF_Msk = 0xff0000   // Bit mask of CKABF field.
	DFSDM_DFSDM1_ISR_RCIP_Pos  = 0xe        // Position of RCIP field.
	DFSDM_DFSDM1_ISR_RCIP_Msk  = 0x4000     // Bit mask of RCIP field.
	DFSDM_DFSDM1_ISR_RCIP      = 0x4000     // Bit RCIP.
	DFSDM_DFSDM1_ISR_JCIP_Pos  = 0xd        // Position of JCIP field.
	DFSDM_DFSDM1_ISR_JCIP_Msk  = 0x2000     // Bit mask of JCIP field.
	DFSDM_DFSDM1_ISR_JCIP      = 0x2000     // Bit JCIP.
	DFSDM_DFSDM1_ISR_AWDF_Pos  = 0x4        // Position of AWDF field.
	DFSDM_DFSDM1_ISR_AWDF_Msk  = 0x10       // Bit mask of AWDF field.
	DFSDM_DFSDM1_ISR_AWDF      = 0x10       // Bit AWDF.
	DFSDM_DFSDM1_ISR_ROVRF_Pos = 0x3        // Position of ROVRF field.
	DFSDM_DFSDM1_ISR_ROVRF_Msk = 0x8        // Bit mask of ROVRF field.
	DFSDM_DFSDM1_ISR_ROVRF     = 0x8        // Bit ROVRF.
	DFSDM_DFSDM1_ISR_JOVRF_Pos = 0x2        // Position of JOVRF field.
	DFSDM_DFSDM1_ISR_JOVRF_Msk = 0x4        // Bit mask of JOVRF field.
	DFSDM_DFSDM1_ISR_JOVRF     = 0x4        // Bit JOVRF.
	DFSDM_DFSDM1_ISR_REOCF_Pos = 0x1        // Position of REOCF field.
	DFSDM_DFSDM1_ISR_REOCF_Msk = 0x2        // Bit mask of REOCF field.
	DFSDM_DFSDM1_ISR_REOCF     = 0x2        // Bit REOCF.
	DFSDM_DFSDM1_ISR_JEOCF_Pos = 0x0        // Position of JEOCF field.
	DFSDM_DFSDM1_ISR_JEOCF_Msk = 0x1        // Bit mask of JEOCF field.
	DFSDM_DFSDM1_ISR_JEOCF     = 0x1        // Bit JEOCF.

	// DFSDM1_ICR: interrupt flag clear register
	DFSDM_DFSDM1_ICR_CLRSCDF_Pos  = 0x18       // Position of CLRSCDF field.
	DFSDM_DFSDM1_ICR_CLRSCDF_Msk  = 0xff000000 // Bit mask of CLRSCDF field.
	DFSDM_DFSDM1_ICR_CLRCKABF_Pos = 0x10       // Position of CLRCKABF field.
	DFSDM_DFSDM1_ICR_CLRCKABF_Msk = 0xff0000   // Bit mask of CLRCKABF field.
	DFSDM_DFSDM1_ICR_CLRROVRF_Pos = 0x3        // Position of CLRROVRF field.
	DFSDM_DFSDM1_ICR_CLRROVRF_Msk = 0x8        // Bit mask of CLRROVRF field.
	DFSDM_DFSDM1_ICR_CLRROVRF     = 0x8        // Bit CLRROVRF.
	DFSDM_DFSDM1_ICR_CLRJOVRF_Pos = 0x2        // Position of CLRJOVRF field.
	DFSDM_DFSDM1_ICR_CLRJOVRF_Msk = 0x4        // Bit mask of CLRJOVRF field.
	DFSDM_DFSDM1_ICR_CLRJOVRF     = 0x4        // Bit CLRJOVRF.

	// DFSDM1_JCHGR: injected channel group selection           register
	DFSDM_DFSDM1_JCHGR_JCHG_Pos = 0x0  // Position of JCHG field.
	DFSDM_DFSDM1_JCHGR_JCHG_Msk = 0xff // Bit mask of JCHG field.

	// DFSDM1_FCR: filter control register
	DFSDM_DFSDM1_FCR_FORD_Pos = 0x1d       // Position of FORD field.
	DFSDM_DFSDM1_FCR_FORD_Msk = 0xe0000000 // Bit mask of FORD field.
	DFSDM_DFSDM1_FCR_FOSR_Pos = 0x10       // Position of FOSR field.
	DFSDM_DFSDM1_FCR_FOSR_Msk = 0x3ff0000  // Bit mask of FOSR field.
	DFSDM_DFSDM1_FCR_IOSR_Pos = 0x0        // Position of IOSR field.
	DFSDM_DFSDM1_FCR_IOSR_Msk = 0xff       // Bit mask of IOSR field.

	// DFSDM1_JDATAR: data register for injected           group
	DFSDM_DFSDM1_JDATAR_JDATA_Pos   = 0x8        // Position of JDATA field.
	DFSDM_DFSDM1_JDATAR_JDATA_Msk   = 0xffffff00 // Bit mask of JDATA field.
	DFSDM_DFSDM1_JDATAR_JDATACH_Pos = 0x0        // Position of JDATACH field.
	DFSDM_DFSDM1_JDATAR_JDATACH_Msk = 0x7        // Bit mask of JDATACH field.

	// DFSDM1_RDATAR: data register for the regular           channel
	DFSDM_DFSDM1_RDATAR_RDATA_Pos   = 0x8        // Position of RDATA field.
	DFSDM_DFSDM1_RDATAR_RDATA_Msk   = 0xffffff00 // Bit mask of RDATA field.
	DFSDM_DFSDM1_RDATAR_RPEND_Pos   = 0x4        // Position of RPEND field.
	DFSDM_DFSDM1_RDATAR_RPEND_Msk   = 0x10       // Bit mask of RPEND field.
	DFSDM_DFSDM1_RDATAR_RPEND       = 0x10       // Bit RPEND.
	DFSDM_DFSDM1_RDATAR_RDATACH_Pos = 0x0        // Position of RDATACH field.
	DFSDM_DFSDM1_RDATAR_RDATACH_Msk = 0x7        // Bit mask of RDATACH field.

	// DFSDM1_AWHTR: analog watchdog high threshold           register
	DFSDM_DFSDM1_AWHTR_AWHT_Pos  = 0x8        // Position of AWHT field.
	DFSDM_DFSDM1_AWHTR_AWHT_Msk  = 0xffffff00 // Bit mask of AWHT field.
	DFSDM_DFSDM1_AWHTR_BKAWH_Pos = 0x0        // Position of BKAWH field.
	DFSDM_DFSDM1_AWHTR_BKAWH_Msk = 0xf        // Bit mask of BKAWH field.

	// DFSDM1_AWLTR: analog watchdog low threshold           register
	DFSDM_DFSDM1_AWLTR_AWLT_Pos  = 0x8        // Position of AWLT field.
	DFSDM_DFSDM1_AWLTR_AWLT_Msk  = 0xffffff00 // Bit mask of AWLT field.
	DFSDM_DFSDM1_AWLTR_BKAWL_Pos = 0x0        // Position of BKAWL field.
	DFSDM_DFSDM1_AWLTR_BKAWL_Msk = 0xf        // Bit mask of BKAWL field.

	// DFSDM1_AWSR: analog watchdog status           register
	DFSDM_DFSDM1_AWSR_AWHTF_Pos = 0x8    // Position of AWHTF field.
	DFSDM_DFSDM1_AWSR_AWHTF_Msk = 0xff00 // Bit mask of AWHTF field.
	DFSDM_DFSDM1_AWSR_AWLTF_Pos = 0x0    // Position of AWLTF field.
	DFSDM_DFSDM1_AWSR_AWLTF_Msk = 0xff   // Bit mask of AWLTF field.

	// DFSDM1_AWCFR: analog watchdog clear flag           register
	DFSDM_DFSDM1_AWCFR_CLRAWHTF_Pos = 0x8    // Position of CLRAWHTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWHTF_Msk = 0xff00 // Bit mask of CLRAWHTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWLTF_Pos = 0x0    // Position of CLRAWLTF field.
	DFSDM_DFSDM1_AWCFR_CLRAWLTF_Msk = 0xff   // Bit mask of CLRAWLTF field.

	// DFSDM1_EXMAX: Extremes detector maximum           register
	DFSDM_DFSDM1_EXMAX_EXMAX_Pos   = 0x8        // Position of EXMAX field.
	DFSDM_DFSDM1_EXMAX_EXMAX_Msk   = 0xffffff00 // Bit mask of EXMAX field.
	DFSDM_DFSDM1_EXMAX_EXMAXCH_Pos = 0x0        // Position of EXMAXCH field.
	DFSDM_DFSDM1_EXMAX_EXMAXCH_Msk = 0x7        // Bit mask of EXMAXCH field.

	// DFSDM1_EXMIN: Extremes detector minimum           register
	DFSDM_DFSDM1_EXMIN_EXMIN_Pos   = 0x8        // Position of EXMIN field.
	DFSDM_DFSDM1_EXMIN_EXMIN_Msk   = 0xffffff00 // Bit mask of EXMIN field.
	DFSDM_DFSDM1_EXMIN_EXMINCH_Pos = 0x0        // Position of EXMINCH field.
	DFSDM_DFSDM1_EXMIN_EXMINCH_Msk = 0x7        // Bit mask of EXMINCH field.

	// DFSDM1_CNVTIMR: conversion timer register
	DFSDM_DFSDM1_CNVTIMR_CNVCNT_Pos = 0x4        // Position of CNVCNT field.
	DFSDM_DFSDM1_CNVTIMR_CNVCNT_Msk = 0xfffffff0 // Bit mask of CNVCNT field.

	// DFSDM2_CR1: control register 1
	DFSDM_DFSDM2_CR1_AWFSEL_Pos   = 0x1e       // Position of AWFSEL field.
	DFSDM_DFSDM2_CR1_AWFSEL_Msk   = 0x40000000 // Bit mask of AWFSEL field.
	DFSDM_DFSDM2_CR1_AWFSEL       = 0x40000000 // Bit AWFSEL.
	DFSDM_DFSDM2_CR1_FAST_Pos     = 0x1d       // Position of FAST field.
	DFSDM_DFSDM2_CR1_FAST_Msk     = 0x20000000 // Bit mask of FAST field.
	DFSDM_DFSDM2_CR1_FAST         = 0x20000000 // Bit FAST.
	DFSDM_DFSDM2_CR1_RCH_Pos      = 0x18       // Position of RCH field.
	DFSDM_DFSDM2_CR1_RCH_Msk      = 0x7000000  // Bit mask of RCH field.
	DFSDM_DFSDM2_CR1_RDMAEN_Pos   = 0x15       // Position of RDMAEN field.
	DFSDM_DFSDM2_CR1_RDMAEN_Msk   = 0x200000   // Bit mask of RDMAEN field.
	DFSDM_DFSDM2_CR1_RDMAEN       = 0x200000   // Bit RDMAEN.
	DFSDM_DFSDM2_CR1_RSYNC_Pos    = 0x13       // Position of RSYNC field.
	DFSDM_DFSDM2_CR1_RSYNC_Msk    = 0x80000    // Bit mask of RSYNC field.
	DFSDM_DFSDM2_CR1_RSYNC        = 0x80000    // Bit RSYNC.
	DFSDM_DFSDM2_CR1_RCONT_Pos    = 0x12       // Position of RCONT field.
	DFSDM_DFSDM2_CR1_RCONT_Msk    = 0x40000    // Bit mask of RCONT field.
	DFSDM_DFSDM2_CR1_RCONT        = 0x40000    // Bit RCONT.
	DFSDM_DFSDM2_CR1_RSWSTART_Pos = 0x11       // Position of RSWSTART field.
	DFSDM_DFSDM2_CR1_RSWSTART_Msk = 0x20000    // Bit mask of RSWSTART field.
	DFSDM_DFSDM2_CR1_RSWSTART     = 0x20000    // Bit RSWSTART.
	DFSDM_DFSDM2_CR1_JEXTEN_Pos   = 0xd        // Position of JEXTEN field.
	DFSDM_DFSDM2_CR1_JEXTEN_Msk   = 0x6000     // Bit mask of JEXTEN field.
	DFSDM_DFSDM2_CR1_JEXTSEL_Pos  = 0x8        // Position of JEXTSEL field.
	DFSDM_DFSDM2_CR1_JEXTSEL_Msk  = 0x700      // Bit mask of JEXTSEL field.
	DFSDM_DFSDM2_CR1_JDMAEN_Pos   = 0x5        // Position of JDMAEN field.
	DFSDM_DFSDM2_CR1_JDMAEN_Msk   = 0x20       // Bit mask of JDMAEN field.
	DFSDM_DFSDM2_CR1_JDMAEN       = 0x20       // Bit JDMAEN.
	DFSDM_DFSDM2_CR1_JSCAN_Pos    = 0x4        // Position of JSCAN field.
	DFSDM_DFSDM2_CR1_JSCAN_Msk    = 0x10       // Bit mask of JSCAN field.
	DFSDM_DFSDM2_CR1_JSCAN        = 0x10       // Bit JSCAN.
	DFSDM_DFSDM2_CR1_JSYNC_Pos    = 0x3        // Position of JSYNC field.
	DFSDM_DFSDM2_CR1_JSYNC_Msk    = 0x8        // Bit mask of JSYNC field.
	DFSDM_DFSDM2_CR1_JSYNC        = 0x8        // Bit JSYNC.
	DFSDM_DFSDM2_CR1_JSWSTART_Pos = 0x1        // Position of JSWSTART field.
	DFSDM_DFSDM2_CR1_JSWSTART_Msk = 0x2        // Bit mask of JSWSTART field.
	DFSDM_DFSDM2_CR1_JSWSTART     = 0x2        // Bit JSWSTART.
	DFSDM_DFSDM2_CR1_DFEN_Pos     = 0x0        // Position of DFEN field.
	DFSDM_DFSDM2_CR1_DFEN_Msk     = 0x1        // Bit mask of DFEN field.
	DFSDM_DFSDM2_CR1_DFEN         = 0x1        // Bit DFEN.

	// DFSDM2_CR2: control register 2
	DFSDM_DFSDM2_CR2_AWDCH_Pos  = 0x10     // Position of AWDCH field.
	DFSDM_DFSDM2_CR2_AWDCH_Msk  = 0xff0000 // Bit mask of AWDCH field.
	DFSDM_DFSDM2_CR2_EXCH_Pos   = 0x8      // Position of EXCH field.
	DFSDM_DFSDM2_CR2_EXCH_Msk   = 0xff00   // Bit mask of EXCH field.
	DFSDM_DFSDM2_CR2_CKABIE_Pos = 0x6      // Position of CKABIE field.
	DFSDM_DFSDM2_CR2_CKABIE_Msk = 0x40     // Bit mask of CKABIE field.
	DFSDM_DFSDM2_CR2_CKABIE     = 0x40     // Bit CKABIE.
	DFSDM_DFSDM2_CR2_SCDIE_Pos  = 0x5      // Position of SCDIE field.
	DFSDM_DFSDM2_CR2_SCDIE_Msk  = 0x20     // Bit mask of SCDIE field.
	DFSDM_DFSDM2_CR2_SCDIE      = 0x20     // Bit SCDIE.
	DFSDM_DFSDM2_CR2_AWDIE_Pos  = 0x4      // Position of AWDIE field.
	DFSDM_DFSDM2_CR2_AWDIE_Msk  = 0x10     // Bit mask of AWDIE field.
	DFSDM_DFSDM2_CR2_AWDIE      = 0x10     // Bit AWDIE.
	DFSDM_DFSDM2_CR2_ROVRIE_Pos = 0x3      // Position of ROVRIE field.
	DFSDM_DFSDM2_CR2_ROVRIE_Msk = 0x8      // Bit mask of ROVRIE field.
	DFSDM_DFSDM2_CR2_ROVRIE     = 0x8      // Bit ROVRIE.
	DFSDM_DFSDM2_CR2_JOVRIE_Pos = 0x2      // Position of JOVRIE field.
	DFSDM_DFSDM2_CR2_JOVRIE_Msk = 0x4      // Bit mask of JOVRIE field.
	DFSDM_DFSDM2_CR2_JOVRIE     = 0x4      // Bit JOVRIE.
	DFSDM_DFSDM2_CR2_REOCIE_Pos = 0x1      // Position of REOCIE field.
	DFSDM_DFSDM2_CR2_REOCIE_Msk = 0x2      // Bit mask of REOCIE field.
	DFSDM_DFSDM2_CR2_REOCIE     = 0x2      // Bit REOCIE.
	DFSDM_DFSDM2_CR2_JEOCIE_Pos = 0x0      // Position of JEOCIE field.
	DFSDM_DFSDM2_CR2_JEOCIE_Msk = 0x1      // Bit mask of JEOCIE field.
	DFSDM_DFSDM2_CR2_JEOCIE     = 0x1      // Bit JEOCIE.

	// DFSDM2_ISR: interrupt and status register
	DFSDM_DFSDM2_ISR_SCDF_Pos  = 0x18       // Position of SCDF field.
	DFSDM_DFSDM2_ISR_SCDF_Msk  = 0xff000000 // Bit mask of SCDF field.
	DFSDM_DFSDM2_ISR_CKABF_Pos = 0x10       // Position of CKABF field.
	DFSDM_DFSDM2_ISR_CKABF_Msk = 0xff0000   // Bit mask of CKABF field.
	DFSDM_DFSDM2_ISR_RCIP_Pos  = 0xe        // Position of RCIP field.
	DFSDM_DFSDM2_ISR_RCIP_Msk  = 0x4000     // Bit mask of RCIP field.
	DFSDM_DFSDM2_ISR_RCIP      = 0x4000     // Bit RCIP.
	DFSDM_DFSDM2_ISR_JCIP_Pos  = 0xd        // Position of JCIP field.
	DFSDM_DFSDM2_ISR_JCIP_Msk  = 0x2000     // Bit mask of JCIP field.
	DFSDM_DFSDM2_ISR_JCIP      = 0x2000     // Bit JCIP.
	DFSDM_DFSDM2_ISR_AWDF_Pos  = 0x4        // Position of AWDF field.
	DFSDM_DFSDM2_ISR_AWDF_Msk  = 0x10       // Bit mask of AWDF field.
	DFSDM_DFSDM2_ISR_AWDF      = 0x10       // Bit AWDF.
	DFSDM_DFSDM2_ISR_ROVRF_Pos = 0x3        // Position of ROVRF field.
	DFSDM_DFSDM2_ISR_ROVRF_Msk = 0x8        // Bit mask of ROVRF field.
	DFSDM_DFSDM2_ISR_ROVRF     = 0x8        // Bit ROVRF.
	DFSDM_DFSDM2_ISR_JOVRF_Pos = 0x2        // Position of JOVRF field.
	DFSDM_DFSDM2_ISR_JOVRF_Msk = 0x4        // Bit mask of JOVRF field.
	DFSDM_DFSDM2_ISR_JOVRF     = 0x4        // Bit JOVRF.
	DFSDM_DFSDM2_ISR_REOCF_Pos = 0x1        // Position of REOCF field.
	DFSDM_DFSDM2_ISR_REOCF_Msk = 0x2        // Bit mask of REOCF field.
	DFSDM_DFSDM2_ISR_REOCF     = 0x2        // Bit REOCF.
	DFSDM_DFSDM2_ISR_JEOCF_Pos = 0x0        // Position of JEOCF field.
	DFSDM_DFSDM2_ISR_JEOCF_Msk = 0x1        // Bit mask of JEOCF field.
	DFSDM_DFSDM2_ISR_JEOCF     = 0x1        // Bit JEOCF.

	// DFSDM2_ICR: interrupt flag clear register
	DFSDM_DFSDM2_ICR_CLRSCDF_Pos  = 0x18       // Position of CLRSCDF field.
	DFSDM_DFSDM2_ICR_CLRSCDF_Msk  = 0xff000000 // Bit mask of CLRSCDF field.
	DFSDM_DFSDM2_ICR_CLRCKABF_Pos = 0x10       // Position of CLRCKABF field.
	DFSDM_DFSDM2_ICR_CLRCKABF_Msk = 0xff0000   // Bit mask of CLRCKABF field.
	DFSDM_DFSDM2_ICR_CLRROVRF_Pos = 0x3        // Position of CLRROVRF field.
	DFSDM_DFSDM2_ICR_CLRROVRF_Msk = 0x8        // Bit mask of CLRROVRF field.
	DFSDM_DFSDM2_ICR_CLRROVRF     = 0x8        // Bit CLRROVRF.
	DFSDM_DFSDM2_ICR_CLRJOVRF_Pos = 0x2        // Position of CLRJOVRF field.
	DFSDM_DFSDM2_ICR_CLRJOVRF_Msk = 0x4        // Bit mask of CLRJOVRF field.
	DFSDM_DFSDM2_ICR_CLRJOVRF     = 0x4        // Bit CLRJOVRF.

	// DFSDM2_JCHGR: injected channel group selection           register
	DFSDM_DFSDM2_JCHGR_JCHG_Pos = 0x0  // Position of JCHG field.
	DFSDM_DFSDM2_JCHGR_JCHG_Msk = 0xff // Bit mask of JCHG field.

	// DFSDM2_FCR: filter control register
	DFSDM_DFSDM2_FCR_FORD_Pos = 0x1d       // Position of FORD field.
	DFSDM_DFSDM2_FCR_FORD_Msk = 0xe0000000 // Bit mask of FORD field.
	DFSDM_DFSDM2_FCR_FOSR_Pos = 0x10       // Position of FOSR field.
	DFSDM_DFSDM2_FCR_FOSR_Msk = 0x3ff0000  // Bit mask of FOSR field.
	DFSDM_DFSDM2_FCR_IOSR_Pos = 0x0        // Position of IOSR field.
	DFSDM_DFSDM2_FCR_IOSR_Msk = 0xff       // Bit mask of IOSR field.

	// DFSDM2_JDATAR: data register for injected           group
	DFSDM_DFSDM2_JDATAR_JDATA_Pos   = 0x8        // Position of JDATA field.
	DFSDM_DFSDM2_JDATAR_JDATA_Msk   = 0xffffff00 // Bit mask of JDATA field.
	DFSDM_DFSDM2_JDATAR_JDATACH_Pos = 0x0        // Position of JDATACH field.
	DFSDM_DFSDM2_JDATAR_JDATACH_Msk = 0x7        // Bit mask of JDATACH field.

	// DFSDM2_RDATAR: data register for the regular           channel
	DFSDM_DFSDM2_RDATAR_RDATA_Pos   = 0x8        // Position of RDATA field.
	DFSDM_DFSDM2_RDATAR_RDATA_Msk   = 0xffffff00 // Bit mask of RDATA field.
	DFSDM_DFSDM2_RDATAR_RPEND_Pos   = 0x4        // Position of RPEND field.
	DFSDM_DFSDM2_RDATAR_RPEND_Msk   = 0x10       // Bit mask of RPEND field.
	DFSDM_DFSDM2_RDATAR_RPEND       = 0x10       // Bit RPEND.
	DFSDM_DFSDM2_RDATAR_RDATACH_Pos = 0x0        // Position of RDATACH field.
	DFSDM_DFSDM2_RDATAR_RDATACH_Msk = 0x7        // Bit mask of RDATACH field.

	// DFSDM2_AWHTR: analog watchdog high threshold           register
	DFSDM_DFSDM2_AWHTR_AWHT_Pos  = 0x8        // Position of AWHT field.
	DFSDM_DFSDM2_AWHTR_AWHT_Msk  = 0xffffff00 // Bit mask of AWHT field.
	DFSDM_DFSDM2_AWHTR_BKAWH_Pos = 0x0        // Position of BKAWH field.
	DFSDM_DFSDM2_AWHTR_BKAWH_Msk = 0xf        // Bit mask of BKAWH field.

	// DFSDM2_AWLTR: analog watchdog low threshold           register
	DFSDM_DFSDM2_AWLTR_AWLT_Pos  = 0x8        // Position of AWLT field.
	DFSDM_DFSDM2_AWLTR_AWLT_Msk  = 0xffffff00 // Bit mask of AWLT field.
	DFSDM_DFSDM2_AWLTR_BKAWL_Pos = 0x0        // Position of BKAWL field.
	DFSDM_DFSDM2_AWLTR_BKAWL_Msk = 0xf        // Bit mask of BKAWL field.

	// DFSDM2_AWSR: analog watchdog status           register
	DFSDM_DFSDM2_AWSR_AWHTF_Pos = 0x8    // Position of AWHTF field.
	DFSDM_DFSDM2_AWSR_AWHTF_Msk = 0xff00 // Bit mask of AWHTF field.
	DFSDM_DFSDM2_AWSR_AWLTF_Pos = 0x0    // Position of AWLTF field.
	DFSDM_DFSDM2_AWSR_AWLTF_Msk = 0xff   // Bit mask of AWLTF field.

	// DFSDM2_AWCFR: analog watchdog clear flag           register
	DFSDM_DFSDM2_AWCFR_CLRAWHTF_Pos = 0x8    // Position of CLRAWHTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWHTF_Msk = 0xff00 // Bit mask of CLRAWHTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWLTF_Pos = 0x0    // Position of CLRAWLTF field.
	DFSDM_DFSDM2_AWCFR_CLRAWLTF_Msk = 0xff   // Bit mask of CLRAWLTF field.

	// DFSDM2_EXMAX: Extremes detector maximum           register
	DFSDM_DFSDM2_EXMAX_EXMAX_Pos   = 0x8        // Position of EXMAX field.
	DFSDM_DFSDM2_EXMAX_EXMAX_Msk   = 0xffffff00 // Bit mask of EXMAX field.
	DFSDM_DFSDM2_EXMAX_EXMAXCH_Pos = 0x0        // Position of EXMAXCH field.
	DFSDM_DFSDM2_EXMAX_EXMAXCH_Msk = 0x7        // Bit mask of EXMAXCH field.

	// DFSDM2_EXMIN: Extremes detector minimum           register
	DFSDM_DFSDM2_EXMIN_EXMIN_Pos   = 0x8        // Position of EXMIN field.
	DFSDM_DFSDM2_EXMIN_EXMIN_Msk   = 0xffffff00 // Bit mask of EXMIN field.
	DFSDM_DFSDM2_EXMIN_EXMINCH_Pos = 0x0        // Position of EXMINCH field.
	DFSDM_DFSDM2_EXMIN_EXMINCH_Msk = 0x7        // Bit mask of EXMINCH field.

	// DFSDM2_CNVTIMR: conversion timer register
	DFSDM_DFSDM2_CNVTIMR_CNVCNT_Pos = 0x4        // Position of CNVCNT field.
	DFSDM_DFSDM2_CNVTIMR_CNVCNT_Msk = 0xfffffff0 // Bit mask of CNVCNT field.

	// DFSDM3_CR1: control register 1
	DFSDM_DFSDM3_CR1_AWFSEL_Pos   = 0x1e       // Position of AWFSEL field.
	DFSDM_DFSDM3_CR1_AWFSEL_Msk   = 0x40000000 // Bit mask of AWFSEL field.
	DFSDM_DFSDM3_CR1_AWFSEL       = 0x40000000 // Bit AWFSEL.
	DFSDM_DFSDM3_CR1_FAST_Pos     = 0x1d       // Position of FAST field.
	DFSDM_DFSDM3_CR1_FAST_Msk     = 0x20000000 // Bit mask of FAST field.
	DFSDM_DFSDM3_CR1_FAST         = 0x20000000 // Bit FAST.
	DFSDM_DFSDM3_CR1_RCH_Pos      = 0x18       // Position of RCH field.
	DFSDM_DFSDM3_CR1_RCH_Msk      = 0x7000000  // Bit mask of RCH field.
	DFSDM_DFSDM3_CR1_RDMAEN_Pos   = 0x15       // Position of RDMAEN field.
	DFSDM_DFSDM3_CR1_RDMAEN_Msk   = 0x200000   // Bit mask of RDMAEN field.
	DFSDM_DFSDM3_CR1_RDMAEN       = 0x200000   // Bit RDMAEN.
	DFSDM_DFSDM3_CR1_RSYNC_Pos    = 0x13       // Position of RSYNC field.
	DFSDM_DFSDM3_CR1_RSYNC_Msk    = 0x80000    // Bit mask of RSYNC field.
	DFSDM_DFSDM3_CR1_RSYNC        = 0x80000    // Bit RSYNC.
	DFSDM_DFSDM3_CR1_RCONT_Pos    = 0x12       // Position of RCONT field.
	DFSDM_DFSDM3_CR1_RCONT_Msk    = 0x40000    // Bit mask of RCONT field.
	DFSDM_DFSDM3_CR1_RCONT        = 0x40000    // Bit RCONT.
	DFSDM_DFSDM3_CR1_RSWSTART_Pos = 0x11       // Position of RSWSTART field.
	DFSDM_DFSDM3_CR1_RSWSTART_Msk = 0x20000    // Bit mask of RSWSTART field.
	DFSDM_DFSDM3_CR1_RSWSTART     = 0x20000    // Bit RSWSTART.
	DFSDM_DFSDM3_CR1_JEXTEN_Pos   = 0xd        // Position of JEXTEN field.
	DFSDM_DFSDM3_CR1_JEXTEN_Msk   = 0x6000     // Bit mask of JEXTEN field.
	DFSDM_DFSDM3_CR1_JEXTSEL_Pos  = 0x8        // Position of JEXTSEL field.
	DFSDM_DFSDM3_CR1_JEXTSEL_Msk  = 0x700      // Bit mask of JEXTSEL field.
	DFSDM_DFSDM3_CR1_JDMAEN_Pos   = 0x5        // Position of JDMAEN field.
	DFSDM_DFSDM3_CR1_JDMAEN_Msk   = 0x20       // Bit mask of JDMAEN field.
	DFSDM_DFSDM3_CR1_JDMAEN       = 0x20       // Bit JDMAEN.
	DFSDM_DFSDM3_CR1_JSCAN_Pos    = 0x4        // Position of JSCAN field.
	DFSDM_DFSDM3_CR1_JSCAN_Msk    = 0x10       // Bit mask of JSCAN field.
	DFSDM_DFSDM3_CR1_JSCAN        = 0x10       // Bit JSCAN.
	DFSDM_DFSDM3_CR1_JSYNC_Pos    = 0x3        // Position of JSYNC field.
	DFSDM_DFSDM3_CR1_JSYNC_Msk    = 0x8        // Bit mask of JSYNC field.
	DFSDM_DFSDM3_CR1_JSYNC        = 0x8        // Bit JSYNC.
	DFSDM_DFSDM3_CR1_JSWSTART_Pos = 0x1        // Position of JSWSTART field.
	DFSDM_DFSDM3_CR1_JSWSTART_Msk = 0x2        // Bit mask of JSWSTART field.
	DFSDM_DFSDM3_CR1_JSWSTART     = 0x2        // Bit JSWSTART.
	DFSDM_DFSDM3_CR1_DFEN_Pos     = 0x0        // Position of DFEN field.
	DFSDM_DFSDM3_CR1_DFEN_Msk     = 0x1        // Bit mask of DFEN field.
	DFSDM_DFSDM3_CR1_DFEN         = 0x1        // Bit DFEN.

	// DFSDM3_CR2: control register 2
	DFSDM_DFSDM3_CR2_AWDCH_Pos  = 0x10     // Position of AWDCH field.
	DFSDM_DFSDM3_CR2_AWDCH_Msk  = 0xff0000 // Bit mask of AWDCH field.
	DFSDM_DFSDM3_CR2_EXCH_Pos   = 0x8      // Position of EXCH field.
	DFSDM_DFSDM3_CR2_EXCH_Msk   = 0xff00   // Bit mask of EXCH field.
	DFSDM_DFSDM3_CR2_CKABIE_Pos = 0x6      // Position of CKABIE field.
	DFSDM_DFSDM3_CR2_CKABIE_Msk = 0x40     // Bit mask of CKABIE field.
	DFSDM_DFSDM3_CR2_CKABIE     = 0x40     // Bit CKABIE.
	DFSDM_DFSDM3_CR2_SCDIE_Pos  = 0x5      // Position of SCDIE field.
	DFSDM_DFSDM3_CR2_SCDIE_Msk  = 0x20     // Bit mask of SCDIE field.
	DFSDM_DFSDM3_CR2_SCDIE      = 0x20     // Bit SCDIE.
	DFSDM_DFSDM3_CR2_AWDIE_Pos  = 0x4      // Position of AWDIE field.
	DFSDM_DFSDM3_CR2_AWDIE_Msk  = 0x10     // Bit mask of AWDIE field.
	DFSDM_DFSDM3_CR2_AWDIE      = 0x10     // Bit AWDIE.
	DFSDM_DFSDM3_CR2_ROVRIE_Pos = 0x3      // Position of ROVRIE field.
	DFSDM_DFSDM3_CR2_ROVRIE_Msk = 0x8      // Bit mask of ROVRIE field.
	DFSDM_DFSDM3_CR2_ROVRIE     = 0x8      // Bit ROVRIE.
	DFSDM_DFSDM3_CR2_JOVRIE_Pos = 0x2      // Position of JOVRIE field.
	DFSDM_DFSDM3_CR2_JOVRIE_Msk = 0x4      // Bit mask of JOVRIE field.
	DFSDM_DFSDM3_CR2_JOVRIE     = 0x4      // Bit JOVRIE.
	DFSDM_DFSDM3_CR2_REOCIE_Pos = 0x1      // Position of REOCIE field.
	DFSDM_DFSDM3_CR2_REOCIE_Msk = 0x2      // Bit mask of REOCIE field.
	DFSDM_DFSDM3_CR2_REOCIE     = 0x2      // Bit REOCIE.
	DFSDM_DFSDM3_CR2_JEOCIE_Pos = 0x0      // Position of JEOCIE field.
	DFSDM_DFSDM3_CR2_JEOCIE_Msk = 0x1      // Bit mask of JEOCIE field.
	DFSDM_DFSDM3_CR2_JEOCIE     = 0x1      // Bit JEOCIE.

	// DFSDM3_ISR: interrupt and status register
	DFSDM_DFSDM3_ISR_SCDF_Pos  = 0x18       // Position of SCDF field.
	DFSDM_DFSDM3_ISR_SCDF_Msk  = 0xff000000 // Bit mask of SCDF field.
	DFSDM_DFSDM3_ISR_CKABF_Pos = 0x10       // Position of CKABF field.
	DFSDM_DFSDM3_ISR_CKABF_Msk = 0xff0000   // Bit mask of CKABF field.
	DFSDM_DFSDM3_ISR_RCIP_Pos  = 0xe        // Position of RCIP field.
	DFSDM_DFSDM3_ISR_RCIP_Msk  = 0x4000     // Bit mask of RCIP field.
	DFSDM_DFSDM3_ISR_RCIP      = 0x4000     // Bit RCIP.
	DFSDM_DFSDM3_ISR_JCIP_Pos  = 0xd        // Position of JCIP field.
	DFSDM_DFSDM3_ISR_JCIP_Msk  = 0x2000     // Bit mask of JCIP field.
	DFSDM_DFSDM3_ISR_JCIP      = 0x2000     // Bit JCIP.
	DFSDM_DFSDM3_ISR_AWDF_Pos  = 0x4        // Position of AWDF field.
	DFSDM_DFSDM3_ISR_AWDF_Msk  = 0x10       // Bit mask of AWDF field.
	DFSDM_DFSDM3_ISR_AWDF      = 0x10       // Bit AWDF.
	DFSDM_DFSDM3_ISR_ROVRF_Pos = 0x3        // Position of ROVRF field.
	DFSDM_DFSDM3_ISR_ROVRF_Msk = 0x8        // Bit mask of ROVRF field.
	DFSDM_DFSDM3_ISR_ROVRF     = 0x8        // Bit ROVRF.
	DFSDM_DFSDM3_ISR_JOVRF_Pos = 0x2        // Position of JOVRF field.
	DFSDM_DFSDM3_ISR_JOVRF_Msk = 0x4        // Bit mask of JOVRF field.
	DFSDM_DFSDM3_ISR_JOVRF     = 0x4        // Bit JOVRF.
	DFSDM_DFSDM3_ISR_REOCF_Pos = 0x1        // Position of REOCF field.
	DFSDM_DFSDM3_ISR_REOCF_Msk = 0x2        // Bit mask of REOCF field.
	DFSDM_DFSDM3_ISR_REOCF     = 0x2        // Bit REOCF.
	DFSDM_DFSDM3_ISR_JEOCF_Pos = 0x0        // Position of JEOCF field.
	DFSDM_DFSDM3_ISR_JEOCF_Msk = 0x1        // Bit mask of JEOCF field.
	DFSDM_DFSDM3_ISR_JEOCF     = 0x1        // Bit JEOCF.

	// DFSDM3_ICR: interrupt flag clear register
	DFSDM_DFSDM3_ICR_CLRSCDF_Pos  = 0x18       // Position of CLRSCDF field.
	DFSDM_DFSDM3_ICR_CLRSCDF_Msk  = 0xff000000 // Bit mask of CLRSCDF field.
	DFSDM_DFSDM3_ICR_CLRCKABF_Pos = 0x10       // Position of CLRCKABF field.
	DFSDM_DFSDM3_ICR_CLRCKABF_Msk = 0xff0000   // Bit mask of CLRCKABF field.
	DFSDM_DFSDM3_ICR_CLRROVRF_Pos = 0x3        // Position of CLRROVRF field.
	DFSDM_DFSDM3_ICR_CLRROVRF_Msk = 0x8        // Bit mask of CLRROVRF field.
	DFSDM_DFSDM3_ICR_CLRROVRF     = 0x8        // Bit CLRROVRF.
	DFSDM_DFSDM3_ICR_CLRJOVRF_Pos = 0x2        // Position of CLRJOVRF field.
	DFSDM_DFSDM3_ICR_CLRJOVRF_Msk = 0x4        // Bit mask of CLRJOVRF field.
	DFSDM_DFSDM3_ICR_CLRJOVRF     = 0x4        // Bit CLRJOVRF.

	// DFSDM3_JCHGR: injected channel group selection           register
	DFSDM_DFSDM3_JCHGR_JCHG_Pos = 0x0  // Position of JCHG field.
	DFSDM_DFSDM3_JCHGR_JCHG_Msk = 0xff // Bit mask of JCHG field.

	// DFSDM3_FCR: filter control register
	DFSDM_DFSDM3_FCR_FORD_Pos = 0x1d       // Position of FORD field.
	DFSDM_DFSDM3_FCR_FORD_Msk = 0xe0000000 // Bit mask of FORD field.
	DFSDM_DFSDM3_FCR_FOSR_Pos = 0x10       // Position of FOSR field.
	DFSDM_DFSDM3_FCR_FOSR_Msk = 0x3ff0000  // Bit mask of FOSR field.
	DFSDM_DFSDM3_FCR_IOSR_Pos = 0x0        // Position of IOSR field.
	DFSDM_DFSDM3_FCR_IOSR_Msk = 0xff       // Bit mask of IOSR field.

	// DFSDM3_JDATAR: data register for injected           group
	DFSDM_DFSDM3_JDATAR_JDATA_Pos   = 0x8        // Position of JDATA field.
	DFSDM_DFSDM3_JDATAR_JDATA_Msk   = 0xffffff00 // Bit mask of JDATA field.
	DFSDM_DFSDM3_JDATAR_JDATACH_Pos = 0x0        // Position of JDATACH field.
	DFSDM_DFSDM3_JDATAR_JDATACH_Msk = 0x7        // Bit mask of JDATACH field.

	// DFSDM3_RDATAR: data register for the regular           channel
	DFSDM_DFSDM3_RDATAR_RDATA_Pos   = 0x8        // Position of RDATA field.
	DFSDM_DFSDM3_RDATAR_RDATA_Msk   = 0xffffff00 // Bit mask of RDATA field.
	DFSDM_DFSDM3_RDATAR_RPEND_Pos   = 0x4        // Position of RPEND field.
	DFSDM_DFSDM3_RDATAR_RPEND_Msk   = 0x10       // Bit mask of RPEND field.
	DFSDM_DFSDM3_RDATAR_RPEND       = 0x10       // Bit RPEND.
	DFSDM_DFSDM3_RDATAR_RDATACH_Pos = 0x0        // Position of RDATACH field.
	DFSDM_DFSDM3_RDATAR_RDATACH_Msk = 0x7        // Bit mask of RDATACH field.

	// DFSDM3_AWHTR: analog watchdog high threshold           register
	DFSDM_DFSDM3_AWHTR_AWHT_Pos  = 0x8        // Position of AWHT field.
	DFSDM_DFSDM3_AWHTR_AWHT_Msk  = 0xffffff00 // Bit mask of AWHT field.
	DFSDM_DFSDM3_AWHTR_BKAWH_Pos = 0x0        // Position of BKAWH field.
	DFSDM_DFSDM3_AWHTR_BKAWH_Msk = 0xf        // Bit mask of BKAWH field.

	// DFSDM3_AWLTR: analog watchdog low threshold           register
	DFSDM_DFSDM3_AWLTR_AWLT_Pos  = 0x8        // Position of AWLT field.
	DFSDM_DFSDM3_AWLTR_AWLT_Msk  = 0xffffff00 // Bit mask of AWLT field.
	DFSDM_DFSDM3_AWLTR_BKAWL_Pos = 0x0        // Position of BKAWL field.
	DFSDM_DFSDM3_AWLTR_BKAWL_Msk = 0xf        // Bit mask of BKAWL field.

	// DFSDM3_AWSR: analog watchdog status           register
	DFSDM_DFSDM3_AWSR_AWHTF_Pos = 0x8    // Position of AWHTF field.
	DFSDM_DFSDM3_AWSR_AWHTF_Msk = 0xff00 // Bit mask of AWHTF field.
	DFSDM_DFSDM3_AWSR_AWLTF_Pos = 0x0    // Position of AWLTF field.
	DFSDM_DFSDM3_AWSR_AWLTF_Msk = 0xff   // Bit mask of AWLTF field.

	// DFSDM3_AWCFR: analog watchdog clear flag           register
	DFSDM_DFSDM3_AWCFR_CLRAWHTF_Pos = 0x8    // Position of CLRAWHTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWHTF_Msk = 0xff00 // Bit mask of CLRAWHTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWLTF_Pos = 0x0    // Position of CLRAWLTF field.
	DFSDM_DFSDM3_AWCFR_CLRAWLTF_Msk = 0xff   // Bit mask of CLRAWLTF field.

	// DFSDM3_EXMAX: Extremes detector maximum           register
	DFSDM_DFSDM3_EXMAX_EXMAX_Pos   = 0x8        // Position of EXMAX field.
	DFSDM_DFSDM3_EXMAX_EXMAX_Msk   = 0xffffff00 // Bit mask of EXMAX field.
	DFSDM_DFSDM3_EXMAX_EXMAXCH_Pos = 0x0        // Position of EXMAXCH field.
	DFSDM_DFSDM3_EXMAX_EXMAXCH_Msk = 0x7        // Bit mask of EXMAXCH field.

	// DFSDM3_EXMIN: Extremes detector minimum           register
	DFSDM_DFSDM3_EXMIN_EXMIN_Pos   = 0x8        // Position of EXMIN field.
	DFSDM_DFSDM3_EXMIN_EXMIN_Msk   = 0xffffff00 // Bit mask of EXMIN field.
	DFSDM_DFSDM3_EXMIN_EXMINCH_Pos = 0x0        // Position of EXMINCH field.
	DFSDM_DFSDM3_EXMIN_EXMINCH_Msk = 0x7        // Bit mask of EXMINCH field.

	// DFSDM3_CNVTIMR: conversion timer register
	DFSDM_DFSDM3_CNVTIMR_CNVCNT_Pos = 0x4        // Position of CNVCNT field.
	DFSDM_DFSDM3_CNVTIMR_CNVCNT_Msk = 0xfffffff0 // Bit mask of CNVCNT field.
)

// Bitfields for RNG: Random number generator
const (
	// CR: control register
	RNG_CR_IE_Pos    = 0x3 // Position of IE field.
	RNG_CR_IE_Msk    = 0x8 // Bit mask of IE field.
	RNG_CR_IE        = 0x8 // Bit IE.
	RNG_CR_RNGEN_Pos = 0x2 // Position of RNGEN field.
	RNG_CR_RNGEN_Msk = 0x4 // Bit mask of RNGEN field.
	RNG_CR_RNGEN     = 0x4 // Bit RNGEN.

	// SR: status register
	RNG_SR_SEIS_Pos = 0x6  // Position of SEIS field.
	RNG_SR_SEIS_Msk = 0x40 // Bit mask of SEIS field.
	RNG_SR_SEIS     = 0x40 // Bit SEIS.
	RNG_SR_CEIS_Pos = 0x5  // Position of CEIS field.
	RNG_SR_CEIS_Msk = 0x20 // Bit mask of CEIS field.
	RNG_SR_CEIS     = 0x20 // Bit CEIS.
	RNG_SR_SECS_Pos = 0x2  // Position of SECS field.
	RNG_SR_SECS_Msk = 0x4  // Bit mask of SECS field.
	RNG_SR_SECS     = 0x4  // Bit SECS.
	RNG_SR_CECS_Pos = 0x1  // Position of CECS field.
	RNG_SR_CECS_Msk = 0x2  // Bit mask of CECS field.
	RNG_SR_CECS     = 0x2  // Bit CECS.
	RNG_SR_DRDY_Pos = 0x0  // Position of DRDY field.
	RNG_SR_DRDY_Msk = 0x1  // Bit mask of DRDY field.
	RNG_SR_DRDY     = 0x1  // Bit DRDY.

	// DR: data register
	RNG_DR_RNDATA_Pos = 0x0        // Position of RNDATA field.
	RNG_DR_RNDATA_Msk = 0xffffffff // Bit mask of RNDATA field.
)

// Bitfields for AES: Advanced encryption standard hardware accelerator
const (
	// CR: control register
	AES_CR_DMAOUTEN_Pos = 0xc    // Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000 // Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN     = 0x1000 // Bit DMAOUTEN.
	AES_CR_DMAINEN_Pos  = 0xb    // Position of DMAINEN field.
	AES_CR_DMAINEN_Msk  = 0x800  // Bit mask of DMAINEN field.
	AES_CR_DMAINEN      = 0x800  // Bit DMAINEN.
	AES_CR_ERRIE_Pos    = 0xa    // Position of ERRIE field.
	AES_CR_ERRIE_Msk    = 0x400  // Bit mask of ERRIE field.
	AES_CR_ERRIE        = 0x400  // Bit ERRIE.
	AES_CR_CCFIE_Pos    = 0x9    // Position of CCFIE field.
	AES_CR_CCFIE_Msk    = 0x200  // Bit mask of CCFIE field.
	AES_CR_CCFIE        = 0x200  // Bit CCFIE.
	AES_CR_ERRC_Pos     = 0x8    // Position of ERRC field.
	AES_CR_ERRC_Msk     = 0x100  // Bit mask of ERRC field.
	AES_CR_ERRC         = 0x100  // Bit ERRC.
	AES_CR_CCFC_Pos     = 0x7    // Position of CCFC field.
	AES_CR_CCFC_Msk     = 0x80   // Bit mask of CCFC field.
	AES_CR_CCFC         = 0x80   // Bit CCFC.
	AES_CR_CHMOD_Pos    = 0x5    // Position of CHMOD field.
	AES_CR_CHMOD_Msk    = 0x60   // Bit mask of CHMOD field.
	AES_CR_MODE_Pos     = 0x3    // Position of MODE field.
	AES_CR_MODE_Msk     = 0x18   // Bit mask of MODE field.
	AES_CR_DATATYPE_Pos = 0x1    // Position of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6    // Bit mask of DATATYPE field.
	AES_CR_EN_Pos       = 0x0    // Position of EN field.
	AES_CR_EN_Msk       = 0x1    // Bit mask of EN field.
	AES_CR_EN           = 0x1    // Bit EN.

	// SR: status register
	AES_SR_WRERR_Pos = 0x2 // Position of WRERR field.
	AES_SR_WRERR_Msk = 0x4 // Bit mask of WRERR field.
	AES_SR_WRERR     = 0x4 // Bit WRERR.
	AES_SR_RDERR_Pos = 0x1 // Position of RDERR field.
	AES_SR_RDERR_Msk = 0x2 // Bit mask of RDERR field.
	AES_SR_RDERR     = 0x2 // Bit RDERR.
	AES_SR_CCF_Pos   = 0x0 // Position of CCF field.
	AES_SR_CCF_Msk   = 0x1 // Bit mask of CCF field.
	AES_SR_CCF       = 0x1 // Bit CCF.

	// DINR: data input register
	AES_DINR_AES_DINR_Pos = 0x0        // Position of AES_DINR field.
	AES_DINR_AES_DINR_Msk = 0xffffffff // Bit mask of AES_DINR field.

	// DOUTR: data output register
	AES_DOUTR_AES_DOUTR_Pos = 0x0        // Position of AES_DOUTR field.
	AES_DOUTR_AES_DOUTR_Msk = 0xffffffff // Bit mask of AES_DOUTR field.

	// KEYR0: key register 0
	AES_KEYR0_AES_KEYR0_Pos = 0x0        // Position of AES_KEYR0 field.
	AES_KEYR0_AES_KEYR0_Msk = 0xffffffff // Bit mask of AES_KEYR0 field.

	// KEYR1: key register 1
	AES_KEYR1_AES_KEYR1_Pos = 0x0        // Position of AES_KEYR1 field.
	AES_KEYR1_AES_KEYR1_Msk = 0xffffffff // Bit mask of AES_KEYR1 field.

	// KEYR2: key register 2
	AES_KEYR2_AES_KEYR2_Pos = 0x0        // Position of AES_KEYR2 field.
	AES_KEYR2_AES_KEYR2_Msk = 0xffffffff // Bit mask of AES_KEYR2 field.

	// KEYR3: key register 3
	AES_KEYR3_AES_KEYR3_Pos = 0x0        // Position of AES_KEYR3 field.
	AES_KEYR3_AES_KEYR3_Msk = 0xffffffff // Bit mask of AES_KEYR3 field.

	// IVR0: initialization vector register           0
	AES_IVR0_AES_IVR0_Pos = 0x0        // Position of AES_IVR0 field.
	AES_IVR0_AES_IVR0_Msk = 0xffffffff // Bit mask of AES_IVR0 field.

	// IVR1: initialization vector register           1
	AES_IVR1_AES_IVR1_Pos = 0x0        // Position of AES_IVR1 field.
	AES_IVR1_AES_IVR1_Msk = 0xffffffff // Bit mask of AES_IVR1 field.

	// IVR2: initialization vector register           2
	AES_IVR2_AES_IVR2_Pos = 0x0        // Position of AES_IVR2 field.
	AES_IVR2_AES_IVR2_Msk = 0xffffffff // Bit mask of AES_IVR2 field.

	// IVR3: initialization vector register           3
	AES_IVR3_AES_IVR3_Pos = 0x0        // Position of AES_IVR3 field.
	AES_IVR3_AES_IVR3_Msk = 0xffffffff // Bit mask of AES_IVR3 field.
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ISR: interrupt and status register
	ADC_ISR_JQOVF_Pos = 0xa   // Position of JQOVF field.
	ADC_ISR_JQOVF_Msk = 0x400 // Bit mask of JQOVF field.
	ADC_ISR_JQOVF     = 0x400 // Bit JQOVF.
	ADC_ISR_AWD3_Pos  = 0x9   // Position of AWD3 field.
	ADC_ISR_AWD3_Msk  = 0x200 // Bit mask of AWD3 field.
	ADC_ISR_AWD3      = 0x200 // Bit AWD3.
	ADC_ISR_AWD2_Pos  = 0x8   // Position of AWD2 field.
	ADC_ISR_AWD2_Msk  = 0x100 // Bit mask of AWD2 field.
	ADC_ISR_AWD2      = 0x100 // Bit AWD2.
	ADC_ISR_AWD1_Pos  = 0x7   // Position of AWD1 field.
	ADC_ISR_AWD1_Msk  = 0x80  // Bit mask of AWD1 field.
	ADC_ISR_AWD1      = 0x80  // Bit AWD1.
	ADC_ISR_JEOS_Pos  = 0x6   // Position of JEOS field.
	ADC_ISR_JEOS_Msk  = 0x40  // Bit mask of JEOS field.
	ADC_ISR_JEOS      = 0x40  // Bit JEOS.
	ADC_ISR_JEOC_Pos  = 0x5   // Position of JEOC field.
	ADC_ISR_JEOC_Msk  = 0x20  // Bit mask of JEOC field.
	ADC_ISR_JEOC      = 0x20  // Bit JEOC.
	ADC_ISR_OVR_Pos   = 0x4   // Position of OVR field.
	ADC_ISR_OVR_Msk   = 0x10  // Bit mask of OVR field.
	ADC_ISR_OVR       = 0x10  // Bit OVR.
	ADC_ISR_EOS_Pos   = 0x3   // Position of EOS field.
	ADC_ISR_EOS_Msk   = 0x8   // Bit mask of EOS field.
	ADC_ISR_EOS       = 0x8   // Bit EOS.
	ADC_ISR_EOC_Pos   = 0x2   // Position of EOC field.
	ADC_ISR_EOC_Msk   = 0x4   // Bit mask of EOC field.
	ADC_ISR_EOC       = 0x4   // Bit EOC.
	ADC_ISR_EOSMP_Pos = 0x1   // Position of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2   // Bit mask of EOSMP field.
	ADC_ISR_EOSMP     = 0x2   // Bit EOSMP.
	ADC_ISR_ADRDY_Pos = 0x0   // Position of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1   // Bit mask of ADRDY field.
	ADC_ISR_ADRDY     = 0x1   // Bit ADRDY.

	// IER: interrupt enable register
	ADC_IER_JQOVFIE_Pos = 0xa   // Position of JQOVFIE field.
	ADC_IER_JQOVFIE_Msk = 0x400 // Bit mask of JQOVFIE field.
	ADC_IER_JQOVFIE     = 0x400 // Bit JQOVFIE.
	ADC_IER_AWD3IE_Pos  = 0x9   // Position of AWD3IE field.
	ADC_IER_AWD3IE_Msk  = 0x200 // Bit mask of AWD3IE field.
	ADC_IER_AWD3IE      = 0x200 // Bit AWD3IE.
	ADC_IER_AWD2IE_Pos  = 0x8   // Position of AWD2IE field.
	ADC_IER_AWD2IE_Msk  = 0x100 // Bit mask of AWD2IE field.
	ADC_IER_AWD2IE      = 0x100 // Bit AWD2IE.
	ADC_IER_AWD1IE_Pos  = 0x7   // Position of AWD1IE field.
	ADC_IER_AWD1IE_Msk  = 0x80  // Bit mask of AWD1IE field.
	ADC_IER_AWD1IE      = 0x80  // Bit AWD1IE.
	ADC_IER_JEOSIE_Pos  = 0x6   // Position of JEOSIE field.
	ADC_IER_JEOSIE_Msk  = 0x40  // Bit mask of JEOSIE field.
	ADC_IER_JEOSIE      = 0x40  // Bit JEOSIE.
	ADC_IER_JEOCIE_Pos  = 0x5   // Position of JEOCIE field.
	ADC_IER_JEOCIE_Msk  = 0x20  // Bit mask of JEOCIE field.
	ADC_IER_JEOCIE      = 0x20  // Bit JEOCIE.
	ADC_IER_OVRIE_Pos   = 0x4   // Position of OVRIE field.
	ADC_IER_OVRIE_Msk   = 0x10  // Bit mask of OVRIE field.
	ADC_IER_OVRIE       = 0x10  // Bit OVRIE.
	ADC_IER_EOSIE_Pos   = 0x3   // Position of EOSIE field.
	ADC_IER_EOSIE_Msk   = 0x8   // Bit mask of EOSIE field.
	ADC_IER_EOSIE       = 0x8   // Bit EOSIE.
	ADC_IER_EOCIE_Pos   = 0x2   // Position of EOCIE field.
	ADC_IER_EOCIE_Msk   = 0x4   // Bit mask of EOCIE field.
	ADC_IER_EOCIE       = 0x4   // Bit EOCIE.
	ADC_IER_EOSMPIE_Pos = 0x1   // Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2   // Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE     = 0x2   // Bit EOSMPIE.
	ADC_IER_ADRDYIE_Pos = 0x0   // Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1   // Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE     = 0x1   // Bit ADRDYIE.

	// CR: control register
	ADC_CR_ADCAL_Pos    = 0x1f       // Position of ADCAL field.
	ADC_CR_ADCAL_Msk    = 0x80000000 // Bit mask of ADCAL field.
	ADC_CR_ADCAL        = 0x80000000 // Bit ADCAL.
	ADC_CR_ADCALDIF_Pos = 0x1e       // Position of ADCALDIF field.
	ADC_CR_ADCALDIF_Msk = 0x40000000 // Bit mask of ADCALDIF field.
	ADC_CR_ADCALDIF     = 0x40000000 // Bit ADCALDIF.
	ADC_CR_DEEPPWD_Pos  = 0x1d       // Position of DEEPPWD field.
	ADC_CR_DEEPPWD_Msk  = 0x20000000 // Bit mask of DEEPPWD field.
	ADC_CR_DEEPPWD      = 0x20000000 // Bit DEEPPWD.
	ADC_CR_ADVREGEN_Pos = 0x1c       // Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000 // Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN     = 0x10000000 // Bit ADVREGEN.
	ADC_CR_JADSTP_Pos   = 0x5        // Position of JADSTP field.
	ADC_CR_JADSTP_Msk   = 0x20       // Bit mask of JADSTP field.
	ADC_CR_JADSTP       = 0x20       // Bit JADSTP.
	ADC_CR_ADSTP_Pos    = 0x4        // Position of ADSTP field.
	ADC_CR_ADSTP_Msk    = 0x10       // Bit mask of ADSTP field.
	ADC_CR_ADSTP        = 0x10       // Bit ADSTP.
	ADC_CR_JADSTART_Pos = 0x3        // Position of JADSTART field.
	ADC_CR_JADSTART_Msk = 0x8        // Bit mask of JADSTART field.
	ADC_CR_JADSTART     = 0x8        // Bit JADSTART.
	ADC_CR_ADSTART_Pos  = 0x2        // Position of ADSTART field.
	ADC_CR_ADSTART_Msk  = 0x4        // Bit mask of ADSTART field.
	ADC_CR_ADSTART      = 0x4        // Bit ADSTART.
	ADC_CR_ADDIS_Pos    = 0x1        // Position of ADDIS field.
	ADC_CR_ADDIS_Msk    = 0x2        // Bit mask of ADDIS field.
	ADC_CR_ADDIS        = 0x2        // Bit ADDIS.
	ADC_CR_ADEN_Pos     = 0x0        // Position of ADEN field.
	ADC_CR_ADEN_Msk     = 0x1        // Bit mask of ADEN field.
	ADC_CR_ADEN         = 0x1        // Bit ADEN.

	// CFGR: configuration register
	ADC_CFGR_AWDCH1CH_Pos = 0x1a       // Position of AWDCH1CH field.
	ADC_CFGR_AWDCH1CH_Msk = 0x7c000000 // Bit mask of AWDCH1CH field.
	ADC_CFGR_JAUTO_Pos    = 0x19       // Position of JAUTO field.
	ADC_CFGR_JAUTO_Msk    = 0x2000000  // Bit mask of JAUTO field.
	ADC_CFGR_JAUTO        = 0x2000000  // Bit JAUTO.
	ADC_CFGR_JAWD1EN_Pos  = 0x18       // Position of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Msk  = 0x1000000  // Bit mask of JAWD1EN field.
	ADC_CFGR_JAWD1EN      = 0x1000000  // Bit JAWD1EN.
	ADC_CFGR_AWD1EN_Pos   = 0x17       // Position of AWD1EN field.
	ADC_CFGR_AWD1EN_Msk   = 0x800000   // Bit mask of AWD1EN field.
	ADC_CFGR_AWD1EN       = 0x800000   // Bit AWD1EN.
	ADC_CFGR_AWD1SGL_Pos  = 0x16       // Position of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Msk  = 0x400000   // Bit mask of AWD1SGL field.
	ADC_CFGR_AWD1SGL      = 0x400000   // Bit AWD1SGL.
	ADC_CFGR_JQM_Pos      = 0x15       // Position of JQM field.
	ADC_CFGR_JQM_Msk      = 0x200000   // Bit mask of JQM field.
	ADC_CFGR_JQM          = 0x200000   // Bit JQM.
	ADC_CFGR_JDISCEN_Pos  = 0x14       // Position of JDISCEN field.
	ADC_CFGR_JDISCEN_Msk  = 0x100000   // Bit mask of JDISCEN field.
	ADC_CFGR_JDISCEN      = 0x100000   // Bit JDISCEN.
	ADC_CFGR_DISCNUM_Pos  = 0x11       // Position of DISCNUM field.
	ADC_CFGR_DISCNUM_Msk  = 0xe0000    // Bit mask of DISCNUM field.
	ADC_CFGR_DISCEN_Pos   = 0x10       // Position of DISCEN field.
	ADC_CFGR_DISCEN_Msk   = 0x10000    // Bit mask of DISCEN field.
	ADC_CFGR_DISCEN       = 0x10000    // Bit DISCEN.
	ADC_CFGR_AUTDLY_Pos   = 0xe        // Position of AUTDLY field.
	ADC_CFGR_AUTDLY_Msk   = 0x4000     // Bit mask of AUTDLY field.
	ADC_CFGR_AUTDLY       = 0x4000     // Bit AUTDLY.
	ADC_CFGR_CONT_Pos     = 0xd        // Position of CONT field.
	ADC_CFGR_CONT_Msk     = 0x2000     // Bit mask of CONT field.
	ADC_CFGR_CONT         = 0x2000     // Bit CONT.
	ADC_CFGR_OVRMOD_Pos   = 0xc        // Position of OVRMOD field.
	ADC_CFGR_OVRMOD_Msk   = 0x1000     // Bit mask of OVRMOD field.
	ADC_CFGR_OVRMOD       = 0x1000     // Bit OVRMOD.
	ADC_CFGR_EXTEN_Pos    = 0xa        // Position of EXTEN field.
	ADC_CFGR_EXTEN_Msk    = 0xc00      // Bit mask of EXTEN field.
	ADC_CFGR_EXTSEL_Pos   = 0x6        // Position of EXTSEL field.
	ADC_CFGR_EXTSEL_Msk   = 0x3c0      // Bit mask of EXTSEL field.
	ADC_CFGR_ALIGN_Pos    = 0x5        // Position of ALIGN field.
	ADC_CFGR_ALIGN_Msk    = 0x20       // Bit mask of ALIGN field.
	ADC_CFGR_ALIGN        = 0x20       // Bit ALIGN.
	ADC_CFGR_RES_Pos      = 0x3        // Position of RES field.
	ADC_CFGR_RES_Msk      = 0x18       // Bit mask of RES field.
	ADC_CFGR_DMACFG_Pos   = 0x1        // Position of DMACFG field.
	ADC_CFGR_DMACFG_Msk   = 0x2        // Bit mask of DMACFG field.
	ADC_CFGR_DMACFG       = 0x2        // Bit DMACFG.
	ADC_CFGR_DMAEN_Pos    = 0x0        // Position of DMAEN field.
	ADC_CFGR_DMAEN_Msk    = 0x1        // Bit mask of DMAEN field.
	ADC_CFGR_DMAEN        = 0x1        // Bit DMAEN.
	ADC_CFGR_JQDIS_Pos    = 0x1f       // Position of JQDIS field.
	ADC_CFGR_JQDIS_Msk    = 0x80000000 // Bit mask of JQDIS field.
	ADC_CFGR_JQDIS        = 0x80000000 // Bit JQDIS.

	// CFGR2: configuration register
	ADC_CFGR2_ROVSM_Pos = 0xa   // Position of ROVSM field.
	ADC_CFGR2_ROVSM_Msk = 0x400 // Bit mask of ROVSM field.
	ADC_CFGR2_ROVSM     = 0x400 // Bit ROVSM.
	ADC_CFGR2_TROVS_Pos = 0x9   // Position of TROVS field.
	ADC_CFGR2_TROVS_Msk = 0x200 // Bit mask of TROVS field.
	ADC_CFGR2_TROVS     = 0x200 // Bit TROVS.
	ADC_CFGR2_OVSS_Pos  = 0x5   // Position of OVSS field.
	ADC_CFGR2_OVSS_Msk  = 0x1e0 // Bit mask of OVSS field.
	ADC_CFGR2_OVSR_Pos  = 0x2   // Position of OVSR field.
	ADC_CFGR2_OVSR_Msk  = 0x1c  // Bit mask of OVSR field.
	ADC_CFGR2_JOVSE_Pos = 0x1   // Position of JOVSE field.
	ADC_CFGR2_JOVSE_Msk = 0x2   // Bit mask of JOVSE field.
	ADC_CFGR2_JOVSE     = 0x2   // Bit JOVSE.
	ADC_CFGR2_ROVSE_Pos = 0x0   // Position of ROVSE field.
	ADC_CFGR2_ROVSE_Msk = 0x1   // Bit mask of ROVSE field.
	ADC_CFGR2_ROVSE     = 0x1   // Bit ROVSE.

	// SMPR1: sample time register 1
	ADC_SMPR1_SMP9_Pos    = 0x1b       // Position of SMP9 field.
	ADC_SMPR1_SMP9_Msk    = 0x38000000 // Bit mask of SMP9 field.
	ADC_SMPR1_SMP8_Pos    = 0x18       // Position of SMP8 field.
	ADC_SMPR1_SMP8_Msk    = 0x7000000  // Bit mask of SMP8 field.
	ADC_SMPR1_SMP7_Pos    = 0x15       // Position of SMP7 field.
	ADC_SMPR1_SMP7_Msk    = 0xe00000   // Bit mask of SMP7 field.
	ADC_SMPR1_SMP6_Pos    = 0x12       // Position of SMP6 field.
	ADC_SMPR1_SMP6_Msk    = 0x1c0000   // Bit mask of SMP6 field.
	ADC_SMPR1_SMP5_Pos    = 0xf        // Position of SMP5 field.
	ADC_SMPR1_SMP5_Msk    = 0x38000    // Bit mask of SMP5 field.
	ADC_SMPR1_SMP4_Pos    = 0xc        // Position of SMP4 field.
	ADC_SMPR1_SMP4_Msk    = 0x7000     // Bit mask of SMP4 field.
	ADC_SMPR1_SMP3_Pos    = 0x9        // Position of SMP3 field.
	ADC_SMPR1_SMP3_Msk    = 0xe00      // Bit mask of SMP3 field.
	ADC_SMPR1_SMP2_Pos    = 0x6        // Position of SMP2 field.
	ADC_SMPR1_SMP2_Msk    = 0x1c0      // Bit mask of SMP2 field.
	ADC_SMPR1_SMP1_Pos    = 0x3        // Position of SMP1 field.
	ADC_SMPR1_SMP1_Msk    = 0x38       // Bit mask of SMP1 field.
	ADC_SMPR1_SMPPLUS_Pos = 0x1f       // Position of SMPPLUS field.
	ADC_SMPR1_SMPPLUS_Msk = 0x80000000 // Bit mask of SMPPLUS field.
	ADC_SMPR1_SMPPLUS     = 0x80000000 // Bit SMPPLUS.
	ADC_SMPR1_SMP0_Pos    = 0x0        // Position of SMP0 field.
	ADC_SMPR1_SMP0_Msk    = 0x7        // Bit mask of SMP0 field.

	// SMPR2: sample time register 2
	ADC_SMPR2_SMP18_Pos = 0x18      // Position of SMP18 field.
	ADC_SMPR2_SMP18_Msk = 0x7000000 // Bit mask of SMP18 field.
	ADC_SMPR2_SMP17_Pos = 0x15      // Position of SMP17 field.
	ADC_SMPR2_SMP17_Msk = 0xe00000  // Bit mask of SMP17 field.
	ADC_SMPR2_SMP16_Pos = 0x12      // Position of SMP16 field.
	ADC_SMPR2_SMP16_Msk = 0x1c0000  // Bit mask of SMP16 field.
	ADC_SMPR2_SMP15_Pos = 0xf       // Position of SMP15 field.
	ADC_SMPR2_SMP15_Msk = 0x38000   // Bit mask of SMP15 field.
	ADC_SMPR2_SMP14_Pos = 0xc       // Position of SMP14 field.
	ADC_SMPR2_SMP14_Msk = 0x7000    // Bit mask of SMP14 field.
	ADC_SMPR2_SMP13_Pos = 0x9       // Position of SMP13 field.
	ADC_SMPR2_SMP13_Msk = 0xe00     // Bit mask of SMP13 field.
	ADC_SMPR2_SMP12_Pos = 0x6       // Position of SMP12 field.
	ADC_SMPR2_SMP12_Msk = 0x1c0     // Bit mask of SMP12 field.
	ADC_SMPR2_SMP11_Pos = 0x3       // Position of SMP11 field.
	ADC_SMPR2_SMP11_Msk = 0x38      // Bit mask of SMP11 field.
	ADC_SMPR2_SMP10_Pos = 0x0       // Position of SMP10 field.
	ADC_SMPR2_SMP10_Msk = 0x7       // Bit mask of SMP10 field.

	// TR1: watchdog threshold register 1
	ADC_TR1_HT1_Pos = 0x10      // Position of HT1 field.
	ADC_TR1_HT1_Msk = 0xfff0000 // Bit mask of HT1 field.
	ADC_TR1_LT1_Pos = 0x0       // Position of LT1 field.
	ADC_TR1_LT1_Msk = 0xfff     // Bit mask of LT1 field.

	// TR2: watchdog threshold register
	ADC_TR2_HT2_Pos = 0x10     // Position of HT2 field.
	ADC_TR2_HT2_Msk = 0xff0000 // Bit mask of HT2 field.
	ADC_TR2_LT2_Pos = 0x0      // Position of LT2 field.
	ADC_TR2_LT2_Msk = 0xff     // Bit mask of LT2 field.

	// TR3: watchdog threshold register 3
	ADC_TR3_HT3_Pos = 0x10     // Position of HT3 field.
	ADC_TR3_HT3_Msk = 0xff0000 // Bit mask of HT3 field.
	ADC_TR3_LT3_Pos = 0x0      // Position of LT3 field.
	ADC_TR3_LT3_Msk = 0xff     // Bit mask of LT3 field.

	// SQR1: regular sequence register 1
	ADC_SQR1_SQ4_Pos = 0x18       // Position of SQ4 field.
	ADC_SQR1_SQ4_Msk = 0x1f000000 // Bit mask of SQ4 field.
	ADC_SQR1_SQ3_Pos = 0x12       // Position of SQ3 field.
	ADC_SQR1_SQ3_Msk = 0x7c0000   // Bit mask of SQ3 field.
	ADC_SQR1_SQ2_Pos = 0xc        // Position of SQ2 field.
	ADC_SQR1_SQ2_Msk = 0x1f000    // Bit mask of SQ2 field.
	ADC_SQR1_SQ1_Pos = 0x6        // Position of SQ1 field.
	ADC_SQR1_SQ1_Msk = 0x7c0      // Bit mask of SQ1 field.
	ADC_SQR1_L_Pos   = 0x0        // Position of L field.
	ADC_SQR1_L_Msk   = 0xf        // Bit mask of L field.

	// SQR2: regular sequence register 2
	ADC_SQR2_SQ9_Pos = 0x18       // Position of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x1f000000 // Bit mask of SQ9 field.
	ADC_SQR2_SQ8_Pos = 0x12       // Position of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x7c0000   // Bit mask of SQ8 field.
	ADC_SQR2_SQ7_Pos = 0xc        // Position of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f000    // Bit mask of SQ7 field.
	ADC_SQR2_SQ6_Pos = 0x6        // Position of SQ6 field.
	ADC_SQR2_SQ6_Msk = 0x7c0      // Bit mask of SQ6 field.
	ADC_SQR2_SQ5_Pos = 0x0        // Position of SQ5 field.
	ADC_SQR2_SQ5_Msk = 0x1f       // Bit mask of SQ5 field.

	// SQR3: regular sequence register 3
	ADC_SQR3_SQ14_Pos = 0x18       // Position of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x1f000000 // Bit mask of SQ14 field.
	ADC_SQR3_SQ13_Pos = 0x12       // Position of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x7c0000   // Bit mask of SQ13 field.
	ADC_SQR3_SQ12_Pos = 0xc        // Position of SQ12 field.
	ADC_SQR3_SQ12_Msk = 0x1f000    // Bit mask of SQ12 field.
	ADC_SQR3_SQ11_Pos = 0x6        // Position of SQ11 field.
	ADC_SQR3_SQ11_Msk = 0x7c0      // Bit mask of SQ11 field.
	ADC_SQR3_SQ10_Pos = 0x0        // Position of SQ10 field.
	ADC_SQR3_SQ10_Msk = 0x1f       // Bit mask of SQ10 field.

	// SQR4: regular sequence register 4
	ADC_SQR4_SQ16_Pos = 0x6   // Position of SQ16 field.
	ADC_SQR4_SQ16_Msk = 0x7c0 // Bit mask of SQ16 field.
	ADC_SQR4_SQ15_Pos = 0x0   // Position of SQ15 field.
	ADC_SQR4_SQ15_Msk = 0x1f  // Bit mask of SQ15 field.

	// DR: regular Data Register
	ADC_DR_RDATA_Pos = 0x0    // Position of RDATA field.
	ADC_DR_RDATA_Msk = 0xffff // Bit mask of RDATA field.

	// JSQR: injected sequence register
	ADC_JSQR_JSQ4_Pos    = 0x1a       // Position of JSQ4 field.
	ADC_JSQR_JSQ4_Msk    = 0x7c000000 // Bit mask of JSQ4 field.
	ADC_JSQR_JSQ3_Pos    = 0x14       // Position of JSQ3 field.
	ADC_JSQR_JSQ3_Msk    = 0x1f00000  // Bit mask of JSQ3 field.
	ADC_JSQR_JSQ2_Pos    = 0xe        // Position of JSQ2 field.
	ADC_JSQR_JSQ2_Msk    = 0x7c000    // Bit mask of JSQ2 field.
	ADC_JSQR_JSQ1_Pos    = 0x8        // Position of JSQ1 field.
	ADC_JSQR_JSQ1_Msk    = 0x1f00     // Bit mask of JSQ1 field.
	ADC_JSQR_JEXTEN_Pos  = 0x6        // Position of JEXTEN field.
	ADC_JSQR_JEXTEN_Msk  = 0xc0       // Bit mask of JEXTEN field.
	ADC_JSQR_JEXTSEL_Pos = 0x2        // Position of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Msk = 0x3c       // Bit mask of JEXTSEL field.
	ADC_JSQR_JL_Pos      = 0x0        // Position of JL field.
	ADC_JSQR_JL_Msk      = 0x3        // Bit mask of JL field.

	// OFR1: offset register 1
	ADC_OFR1_OFFSET1_EN_Pos = 0x1f       // Position of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Msk = 0x80000000 // Bit mask of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN     = 0x80000000 // Bit OFFSET1_EN.
	ADC_OFR1_OFFSET1_CH_Pos = 0x1a       // Position of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Msk = 0x7c000000 // Bit mask of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_Pos    = 0x0        // Position of OFFSET1 field.
	ADC_OFR1_OFFSET1_Msk    = 0xfff      // Bit mask of OFFSET1 field.

	// OFR2: offset register 2
	ADC_OFR2_OFFSET2_EN_Pos = 0x1f       // Position of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Msk = 0x80000000 // Bit mask of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN     = 0x80000000 // Bit OFFSET2_EN.
	ADC_OFR2_OFFSET2_CH_Pos = 0x1a       // Position of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Msk = 0x7c000000 // Bit mask of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_Pos    = 0x0        // Position of OFFSET2 field.
	ADC_OFR2_OFFSET2_Msk    = 0xfff      // Bit mask of OFFSET2 field.

	// OFR3: offset register 3
	ADC_OFR3_OFFSET3_EN_Pos = 0x1f       // Position of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Msk = 0x80000000 // Bit mask of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN     = 0x80000000 // Bit OFFSET3_EN.
	ADC_OFR3_OFFSET3_CH_Pos = 0x1a       // Position of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Msk = 0x7c000000 // Bit mask of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_Pos    = 0x0        // Position of OFFSET3 field.
	ADC_OFR3_OFFSET3_Msk    = 0xfff      // Bit mask of OFFSET3 field.

	// OFR4: offset register 4
	ADC_OFR4_OFFSET4_EN_Pos = 0x1f       // Position of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Msk = 0x80000000 // Bit mask of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN     = 0x80000000 // Bit OFFSET4_EN.
	ADC_OFR4_OFFSET4_CH_Pos = 0x1a       // Position of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Msk = 0x7c000000 // Bit mask of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_Pos    = 0x0        // Position of OFFSET4 field.
	ADC_OFR4_OFFSET4_Msk    = 0xfff      // Bit mask of OFFSET4 field.

	// JDR1: injected data register 1
	ADC_JDR1_JDATA1_Pos = 0x0    // Position of JDATA1 field.
	ADC_JDR1_JDATA1_Msk = 0xffff // Bit mask of JDATA1 field.

	// JDR2: injected data register 2
	ADC_JDR2_JDATA2_Pos = 0x0    // Position of JDATA2 field.
	ADC_JDR2_JDATA2_Msk = 0xffff // Bit mask of JDATA2 field.

	// JDR3: injected data register 3
	ADC_JDR3_JDATA3_Pos = 0x0    // Position of JDATA3 field.
	ADC_JDR3_JDATA3_Msk = 0xffff // Bit mask of JDATA3 field.

	// JDR4: injected data register 4
	ADC_JDR4_JDATA4_Pos = 0x0    // Position of JDATA4 field.
	ADC_JDR4_JDATA4_Msk = 0xffff // Bit mask of JDATA4 field.

	// AWD2CR: Analog Watchdog 2 Configuration           Register
	ADC_AWD2CR_AWD2CH_Pos = 0x0     // Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x3ffff // Bit mask of AWD2CH field.

	// AWD3CR: Analog Watchdog 3 Configuration           Register
	ADC_AWD3CR_AWD3CH_Pos = 0x0     // Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x3ffff // Bit mask of AWD3CH field.

	// DIFSEL: Differential Mode Selection Register           2
	ADC_DIFSEL_DIFSEL_1_15_Pos  = 0x1     // Position of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_1_15_Msk  = 0xfffe  // Bit mask of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_16_18_Pos = 0x10    // Position of DIFSEL_16_18 field.
	ADC_DIFSEL_DIFSEL_16_18_Msk = 0x70000 // Bit mask of DIFSEL_16_18 field.

	// CALFACT: Calibration Factors
	ADC_CALFACT_CALFACT_D_Pos = 0x10     // Position of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Msk = 0x7f0000 // Bit mask of CALFACT_D field.
	ADC_CALFACT_CALFACT_S_Pos = 0x0      // Position of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Msk = 0x7f     // Bit mask of CALFACT_S field.
)

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.

	// BRR: GPIO port bit reset register
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.

	// ASCR: GPIO port analog switch control           register
	GPIO_ASCR_ASC0_Pos  = 0x0    // Position of ASC0 field.
	GPIO_ASCR_ASC0_Msk  = 0x1    // Bit mask of ASC0 field.
	GPIO_ASCR_ASC0      = 0x1    // Bit ASC0.
	GPIO_ASCR_ASC1_Pos  = 0x1    // Position of ASC1 field.
	GPIO_ASCR_ASC1_Msk  = 0x2    // Bit mask of ASC1 field.
	GPIO_ASCR_ASC1      = 0x2    // Bit ASC1.
	GPIO_ASCR_ASC2_Pos  = 0x2    // Position of ASC2 field.
	GPIO_ASCR_ASC2_Msk  = 0x4    // Bit mask of ASC2 field.
	GPIO_ASCR_ASC2      = 0x4    // Bit ASC2.
	GPIO_ASCR_ASC3_Pos  = 0x3    // Position of ASC3 field.
	GPIO_ASCR_ASC3_Msk  = 0x8    // Bit mask of ASC3 field.
	GPIO_ASCR_ASC3      = 0x8    // Bit ASC3.
	GPIO_ASCR_ASC4_Pos  = 0x4    // Position of ASC4 field.
	GPIO_ASCR_ASC4_Msk  = 0x10   // Bit mask of ASC4 field.
	GPIO_ASCR_ASC4      = 0x10   // Bit ASC4.
	GPIO_ASCR_ASC5_Pos  = 0x5    // Position of ASC5 field.
	GPIO_ASCR_ASC5_Msk  = 0x20   // Bit mask of ASC5 field.
	GPIO_ASCR_ASC5      = 0x20   // Bit ASC5.
	GPIO_ASCR_ASC6_Pos  = 0x6    // Position of ASC6 field.
	GPIO_ASCR_ASC6_Msk  = 0x40   // Bit mask of ASC6 field.
	GPIO_ASCR_ASC6      = 0x40   // Bit ASC6.
	GPIO_ASCR_ASC7_Pos  = 0x7    // Position of ASC7 field.
	GPIO_ASCR_ASC7_Msk  = 0x80   // Bit mask of ASC7 field.
	GPIO_ASCR_ASC7      = 0x80   // Bit ASC7.
	GPIO_ASCR_ASC8_Pos  = 0x8    // Position of ASC8 field.
	GPIO_ASCR_ASC8_Msk  = 0x100  // Bit mask of ASC8 field.
	GPIO_ASCR_ASC8      = 0x100  // Bit ASC8.
	GPIO_ASCR_ASC9_Pos  = 0x9    // Position of ASC9 field.
	GPIO_ASCR_ASC9_Msk  = 0x200  // Bit mask of ASC9 field.
	GPIO_ASCR_ASC9      = 0x200  // Bit ASC9.
	GPIO_ASCR_ASC10_Pos = 0xa    // Position of ASC10 field.
	GPIO_ASCR_ASC10_Msk = 0x400  // Bit mask of ASC10 field.
	GPIO_ASCR_ASC10     = 0x400  // Bit ASC10.
	GPIO_ASCR_ASC11_Pos = 0xb    // Position of ASC11 field.
	GPIO_ASCR_ASC11_Msk = 0x800  // Bit mask of ASC11 field.
	GPIO_ASCR_ASC11     = 0x800  // Bit ASC11.
	GPIO_ASCR_ASC12_Pos = 0xc    // Position of ASC12 field.
	GPIO_ASCR_ASC12_Msk = 0x1000 // Bit mask of ASC12 field.
	GPIO_ASCR_ASC12     = 0x1000 // Bit ASC12.
	GPIO_ASCR_ASC13_Pos = 0xd    // Position of ASC13 field.
	GPIO_ASCR_ASC13_Msk = 0x2000 // Bit mask of ASC13 field.
	GPIO_ASCR_ASC13     = 0x2000 // Bit ASC13.
	GPIO_ASCR_ASC14_Pos = 0xe    // Position of ASC14 field.
	GPIO_ASCR_ASC14_Msk = 0x4000 // Bit mask of ASC14 field.
	GPIO_ASCR_ASC14     = 0x4000 // Bit ASC14.
	GPIO_ASCR_ASC15_Pos = 0xf    // Position of ASC15 field.
	GPIO_ASCR_ASC15_Msk = 0x8000 // Bit mask of ASC15 field.
	GPIO_ASCR_ASC15     = 0x8000 // Bit ASC15.
)

// Bitfields for SAI1: Serial audio interface
const (
	// ACR1: AConfiguration register 1
	SAI_ACR1_MCJDIV_Pos   = 0x14     // Position of MCJDIV field.
	SAI_ACR1_MCJDIV_Msk   = 0xf00000 // Bit mask of MCJDIV field.
	SAI_ACR1_NODIV_Pos    = 0x13     // Position of NODIV field.
	SAI_ACR1_NODIV_Msk    = 0x80000  // Bit mask of NODIV field.
	SAI_ACR1_NODIV        = 0x80000  // Bit NODIV.
	SAI_ACR1_DMAEN_Pos    = 0x11     // Position of DMAEN field.
	SAI_ACR1_DMAEN_Msk    = 0x20000  // Bit mask of DMAEN field.
	SAI_ACR1_DMAEN        = 0x20000  // Bit DMAEN.
	SAI_ACR1_SAIAEN_Pos   = 0x10     // Position of SAIAEN field.
	SAI_ACR1_SAIAEN_Msk   = 0x10000  // Bit mask of SAIAEN field.
	SAI_ACR1_SAIAEN       = 0x10000  // Bit SAIAEN.
	SAI_ACR1_OutDri_Pos   = 0xd      // Position of OutDri field.
	SAI_ACR1_OutDri_Msk   = 0x2000   // Bit mask of OutDri field.
	SAI_ACR1_OutDri       = 0x2000   // Bit OutDri.
	SAI_ACR1_MONO_Pos     = 0xc      // Position of MONO field.
	SAI_ACR1_MONO_Msk     = 0x1000   // Bit mask of MONO field.
	SAI_ACR1_MONO         = 0x1000   // Bit MONO.
	SAI_ACR1_SYNCEN_Pos   = 0xa      // Position of SYNCEN field.
	SAI_ACR1_SYNCEN_Msk   = 0xc00    // Bit mask of SYNCEN field.
	SAI_ACR1_CKSTR_Pos    = 0x9      // Position of CKSTR field.
	SAI_ACR1_CKSTR_Msk    = 0x200    // Bit mask of CKSTR field.
	SAI_ACR1_CKSTR        = 0x200    // Bit CKSTR.
	SAI_ACR1_LSBFIRST_Pos = 0x8      // Position of LSBFIRST field.
	SAI_ACR1_LSBFIRST_Msk = 0x100    // Bit mask of LSBFIRST field.
	SAI_ACR1_LSBFIRST     = 0x100    // Bit LSBFIRST.
	SAI_ACR1_DS_Pos       = 0x5      // Position of DS field.
	SAI_ACR1_DS_Msk       = 0xe0     // Bit mask of DS field.
	SAI_ACR1_PRTCFG_Pos   = 0x2      // Position of PRTCFG field.
	SAI_ACR1_PRTCFG_Msk   = 0xc      // Bit mask of PRTCFG field.
	SAI_ACR1_MODE_Pos     = 0x0      // Position of MODE field.
	SAI_ACR1_MODE_Msk     = 0x3      // Bit mask of MODE field.

	// ACR2: AConfiguration register 2
	SAI_ACR2_COMP_Pos    = 0xe    // Position of COMP field.
	SAI_ACR2_COMP_Msk    = 0xc000 // Bit mask of COMP field.
	SAI_ACR2_CPL_Pos     = 0xd    // Position of CPL field.
	SAI_ACR2_CPL_Msk     = 0x2000 // Bit mask of CPL field.
	SAI_ACR2_CPL         = 0x2000 // Bit CPL.
	SAI_ACR2_MUTECN_Pos  = 0x7    // Position of MUTECN field.
	SAI_ACR2_MUTECN_Msk  = 0x1f80 // Bit mask of MUTECN field.
	SAI_ACR2_MUTEVAL_Pos = 0x6    // Position of MUTEVAL field.
	SAI_ACR2_MUTEVAL_Msk = 0x40   // Bit mask of MUTEVAL field.
	SAI_ACR2_MUTEVAL     = 0x40   // Bit MUTEVAL.
	SAI_ACR2_MUTE_Pos    = 0x5    // Position of MUTE field.
	SAI_ACR2_MUTE_Msk    = 0x20   // Bit mask of MUTE field.
	SAI_ACR2_MUTE        = 0x20   // Bit MUTE.
	SAI_ACR2_TRIS_Pos    = 0x4    // Position of TRIS field.
	SAI_ACR2_TRIS_Msk    = 0x10   // Bit mask of TRIS field.
	SAI_ACR2_TRIS        = 0x10   // Bit TRIS.
	SAI_ACR2_FFLUS_Pos   = 0x3    // Position of FFLUS field.
	SAI_ACR2_FFLUS_Msk   = 0x8    // Bit mask of FFLUS field.
	SAI_ACR2_FFLUS       = 0x8    // Bit FFLUS.
	SAI_ACR2_FTH_Pos     = 0x0    // Position of FTH field.
	SAI_ACR2_FTH_Msk     = 0x7    // Bit mask of FTH field.

	// AFRCR: AFRCR
	SAI_AFRCR_FSOFF_Pos = 0x12    // Position of FSOFF field.
	SAI_AFRCR_FSOFF_Msk = 0x40000 // Bit mask of FSOFF field.
	SAI_AFRCR_FSOFF     = 0x40000 // Bit FSOFF.
	SAI_AFRCR_FSPOL_Pos = 0x11    // Position of FSPOL field.
	SAI_AFRCR_FSPOL_Msk = 0x20000 // Bit mask of FSPOL field.
	SAI_AFRCR_FSPOL     = 0x20000 // Bit FSPOL.
	SAI_AFRCR_FSDEF_Pos = 0x10    // Position of FSDEF field.
	SAI_AFRCR_FSDEF_Msk = 0x10000 // Bit mask of FSDEF field.
	SAI_AFRCR_FSDEF     = 0x10000 // Bit FSDEF.
	SAI_AFRCR_FSALL_Pos = 0x8     // Position of FSALL field.
	SAI_AFRCR_FSALL_Msk = 0x7f00  // Bit mask of FSALL field.
	SAI_AFRCR_FRL_Pos   = 0x0     // Position of FRL field.
	SAI_AFRCR_FRL_Msk   = 0xff    // Bit mask of FRL field.

	// ASLOTR: ASlot register
	SAI_ASLOTR_SLOTEN_Pos = 0x10       // Position of SLOTEN field.
	SAI_ASLOTR_SLOTEN_Msk = 0xffff0000 // Bit mask of SLOTEN field.
	SAI_ASLOTR_NBSLOT_Pos = 0x8        // Position of NBSLOT field.
	SAI_ASLOTR_NBSLOT_Msk = 0xf00      // Bit mask of NBSLOT field.
	SAI_ASLOTR_SLOTSZ_Pos = 0x6        // Position of SLOTSZ field.
	SAI_ASLOTR_SLOTSZ_Msk = 0xc0       // Bit mask of SLOTSZ field.
	SAI_ASLOTR_FBOFF_Pos  = 0x0        // Position of FBOFF field.
	SAI_ASLOTR_FBOFF_Msk  = 0x1f       // Bit mask of FBOFF field.

	// AIM: AInterrupt mask register2
	SAI_AIM_LFSDET_Pos   = 0x6  // Position of LFSDET field.
	SAI_AIM_LFSDET_Msk   = 0x40 // Bit mask of LFSDET field.
	SAI_AIM_LFSDET       = 0x40 // Bit LFSDET.
	SAI_AIM_AFSDETIE_Pos = 0x5  // Position of AFSDETIE field.
	SAI_AIM_AFSDETIE_Msk = 0x20 // Bit mask of AFSDETIE field.
	SAI_AIM_AFSDETIE     = 0x20 // Bit AFSDETIE.
	SAI_AIM_CNRDYIE_Pos  = 0x4  // Position of CNRDYIE field.
	SAI_AIM_CNRDYIE_Msk  = 0x10 // Bit mask of CNRDYIE field.
	SAI_AIM_CNRDYIE      = 0x10 // Bit CNRDYIE.
	SAI_AIM_FREQIE_Pos   = 0x3  // Position of FREQIE field.
	SAI_AIM_FREQIE_Msk   = 0x8  // Bit mask of FREQIE field.
	SAI_AIM_FREQIE       = 0x8  // Bit FREQIE.
	SAI_AIM_WCKCFG_Pos   = 0x2  // Position of WCKCFG field.
	SAI_AIM_WCKCFG_Msk   = 0x4  // Bit mask of WCKCFG field.
	SAI_AIM_WCKCFG       = 0x4  // Bit WCKCFG.
	SAI_AIM_MUTEDET_Pos  = 0x1  // Position of MUTEDET field.
	SAI_AIM_MUTEDET_Msk  = 0x2  // Bit mask of MUTEDET field.
	SAI_AIM_MUTEDET      = 0x2  // Bit MUTEDET.
	SAI_AIM_OVRUDRIE_Pos = 0x0  // Position of OVRUDRIE field.
	SAI_AIM_OVRUDRIE_Msk = 0x1  // Bit mask of OVRUDRIE field.
	SAI_AIM_OVRUDRIE     = 0x1  // Bit OVRUDRIE.

	// ASR: AStatus register
	SAI_ASR_FLVL_Pos    = 0x10    // Position of FLVL field.
	SAI_ASR_FLVL_Msk    = 0x70000 // Bit mask of FLVL field.
	SAI_ASR_LFSDET_Pos  = 0x6     // Position of LFSDET field.
	SAI_ASR_LFSDET_Msk  = 0x40    // Bit mask of LFSDET field.
	SAI_ASR_LFSDET      = 0x40    // Bit LFSDET.
	SAI_ASR_AFSDET_Pos  = 0x5     // Position of AFSDET field.
	SAI_ASR_AFSDET_Msk  = 0x20    // Bit mask of AFSDET field.
	SAI_ASR_AFSDET      = 0x20    // Bit AFSDET.
	SAI_ASR_CNRDY_Pos   = 0x4     // Position of CNRDY field.
	SAI_ASR_CNRDY_Msk   = 0x10    // Bit mask of CNRDY field.
	SAI_ASR_CNRDY       = 0x10    // Bit CNRDY.
	SAI_ASR_FREQ_Pos    = 0x3     // Position of FREQ field.
	SAI_ASR_FREQ_Msk    = 0x8     // Bit mask of FREQ field.
	SAI_ASR_FREQ        = 0x8     // Bit FREQ.
	SAI_ASR_WCKCFG_Pos  = 0x2     // Position of WCKCFG field.
	SAI_ASR_WCKCFG_Msk  = 0x4     // Bit mask of WCKCFG field.
	SAI_ASR_WCKCFG      = 0x4     // Bit WCKCFG.
	SAI_ASR_MUTEDET_Pos = 0x1     // Position of MUTEDET field.
	SAI_ASR_MUTEDET_Msk = 0x2     // Bit mask of MUTEDET field.
	SAI_ASR_MUTEDET     = 0x2     // Bit MUTEDET.
	SAI_ASR_OVRUDR_Pos  = 0x0     // Position of OVRUDR field.
	SAI_ASR_OVRUDR_Msk  = 0x1     // Bit mask of OVRUDR field.
	SAI_ASR_OVRUDR      = 0x1     // Bit OVRUDR.

	// ACLRFR: AClear flag register
	SAI_ACLRFR_LFSDET_Pos  = 0x6  // Position of LFSDET field.
	SAI_ACLRFR_LFSDET_Msk  = 0x40 // Bit mask of LFSDET field.
	SAI_ACLRFR_LFSDET      = 0x40 // Bit LFSDET.
	SAI_ACLRFR_CAFSDET_Pos = 0x5  // Position of CAFSDET field.
	SAI_ACLRFR_CAFSDET_Msk = 0x20 // Bit mask of CAFSDET field.
	SAI_ACLRFR_CAFSDET     = 0x20 // Bit CAFSDET.
	SAI_ACLRFR_CNRDY_Pos   = 0x4  // Position of CNRDY field.
	SAI_ACLRFR_CNRDY_Msk   = 0x10 // Bit mask of CNRDY field.
	SAI_ACLRFR_CNRDY       = 0x10 // Bit CNRDY.
	SAI_ACLRFR_WCKCFG_Pos  = 0x2  // Position of WCKCFG field.
	SAI_ACLRFR_WCKCFG_Msk  = 0x4  // Bit mask of WCKCFG field.
	SAI_ACLRFR_WCKCFG      = 0x4  // Bit WCKCFG.
	SAI_ACLRFR_MUTEDET_Pos = 0x1  // Position of MUTEDET field.
	SAI_ACLRFR_MUTEDET_Msk = 0x2  // Bit mask of MUTEDET field.
	SAI_ACLRFR_MUTEDET     = 0x2  // Bit MUTEDET.
	SAI_ACLRFR_OVRUDR_Pos  = 0x0  // Position of OVRUDR field.
	SAI_ACLRFR_OVRUDR_Msk  = 0x1  // Bit mask of OVRUDR field.
	SAI_ACLRFR_OVRUDR      = 0x1  // Bit OVRUDR.

	// ADR: AData register
	SAI_ADR_DATA_Pos = 0x0        // Position of DATA field.
	SAI_ADR_DATA_Msk = 0xffffffff // Bit mask of DATA field.

	// BCR1: BConfiguration register 1
	SAI_BCR1_MCJDIV_Pos   = 0x14     // Position of MCJDIV field.
	SAI_BCR1_MCJDIV_Msk   = 0xf00000 // Bit mask of MCJDIV field.
	SAI_BCR1_NODIV_Pos    = 0x13     // Position of NODIV field.
	SAI_BCR1_NODIV_Msk    = 0x80000  // Bit mask of NODIV field.
	SAI_BCR1_NODIV        = 0x80000  // Bit NODIV.
	SAI_BCR1_DMAEN_Pos    = 0x11     // Position of DMAEN field.
	SAI_BCR1_DMAEN_Msk    = 0x20000  // Bit mask of DMAEN field.
	SAI_BCR1_DMAEN        = 0x20000  // Bit DMAEN.
	SAI_BCR1_SAIBEN_Pos   = 0x10     // Position of SAIBEN field.
	SAI_BCR1_SAIBEN_Msk   = 0x10000  // Bit mask of SAIBEN field.
	SAI_BCR1_SAIBEN       = 0x10000  // Bit SAIBEN.
	SAI_BCR1_OutDri_Pos   = 0xd      // Position of OutDri field.
	SAI_BCR1_OutDri_Msk   = 0x2000   // Bit mask of OutDri field.
	SAI_BCR1_OutDri       = 0x2000   // Bit OutDri.
	SAI_BCR1_MONO_Pos     = 0xc      // Position of MONO field.
	SAI_BCR1_MONO_Msk     = 0x1000   // Bit mask of MONO field.
	SAI_BCR1_MONO         = 0x1000   // Bit MONO.
	SAI_BCR1_SYNCEN_Pos   = 0xa      // Position of SYNCEN field.
	SAI_BCR1_SYNCEN_Msk   = 0xc00    // Bit mask of SYNCEN field.
	SAI_BCR1_CKSTR_Pos    = 0x9      // Position of CKSTR field.
	SAI_BCR1_CKSTR_Msk    = 0x200    // Bit mask of CKSTR field.
	SAI_BCR1_CKSTR        = 0x200    // Bit CKSTR.
	SAI_BCR1_LSBFIRST_Pos = 0x8      // Position of LSBFIRST field.
	SAI_BCR1_LSBFIRST_Msk = 0x100    // Bit mask of LSBFIRST field.
	SAI_BCR1_LSBFIRST     = 0x100    // Bit LSBFIRST.
	SAI_BCR1_DS_Pos       = 0x5      // Position of DS field.
	SAI_BCR1_DS_Msk       = 0xe0     // Bit mask of DS field.
	SAI_BCR1_PRTCFG_Pos   = 0x2      // Position of PRTCFG field.
	SAI_BCR1_PRTCFG_Msk   = 0xc      // Bit mask of PRTCFG field.
	SAI_BCR1_MODE_Pos     = 0x0      // Position of MODE field.
	SAI_BCR1_MODE_Msk     = 0x3      // Bit mask of MODE field.

	// BCR2: BConfiguration register 2
	SAI_BCR2_COMP_Pos    = 0xe    // Position of COMP field.
	SAI_BCR2_COMP_Msk    = 0xc000 // Bit mask of COMP field.
	SAI_BCR2_CPL_Pos     = 0xd    // Position of CPL field.
	SAI_BCR2_CPL_Msk     = 0x2000 // Bit mask of CPL field.
	SAI_BCR2_CPL         = 0x2000 // Bit CPL.
	SAI_BCR2_MUTECN_Pos  = 0x7    // Position of MUTECN field.
	SAI_BCR2_MUTECN_Msk  = 0x1f80 // Bit mask of MUTECN field.
	SAI_BCR2_MUTEVAL_Pos = 0x6    // Position of MUTEVAL field.
	SAI_BCR2_MUTEVAL_Msk = 0x40   // Bit mask of MUTEVAL field.
	SAI_BCR2_MUTEVAL     = 0x40   // Bit MUTEVAL.
	SAI_BCR2_MUTE_Pos    = 0x5    // Position of MUTE field.
	SAI_BCR2_MUTE_Msk    = 0x20   // Bit mask of MUTE field.
	SAI_BCR2_MUTE        = 0x20   // Bit MUTE.
	SAI_BCR2_TRIS_Pos    = 0x4    // Position of TRIS field.
	SAI_BCR2_TRIS_Msk    = 0x10   // Bit mask of TRIS field.
	SAI_BCR2_TRIS        = 0x10   // Bit TRIS.
	SAI_BCR2_FFLUS_Pos   = 0x3    // Position of FFLUS field.
	SAI_BCR2_FFLUS_Msk   = 0x8    // Bit mask of FFLUS field.
	SAI_BCR2_FFLUS       = 0x8    // Bit FFLUS.
	SAI_BCR2_FTH_Pos     = 0x0    // Position of FTH field.
	SAI_BCR2_FTH_Msk     = 0x7    // Bit mask of FTH field.

	// BFRCR: BFRCR
	SAI_BFRCR_FSOFF_Pos = 0x12    // Position of FSOFF field.
	SAI_BFRCR_FSOFF_Msk = 0x40000 // Bit mask of FSOFF field.
	SAI_BFRCR_FSOFF     = 0x40000 // Bit FSOFF.
	SAI_BFRCR_FSPOL_Pos = 0x11    // Position of FSPOL field.
	SAI_BFRCR_FSPOL_Msk = 0x20000 // Bit mask of FSPOL field.
	SAI_BFRCR_FSPOL     = 0x20000 // Bit FSPOL.
	SAI_BFRCR_FSDEF_Pos = 0x10    // Position of FSDEF field.
	SAI_BFRCR_FSDEF_Msk = 0x10000 // Bit mask of FSDEF field.
	SAI_BFRCR_FSDEF     = 0x10000 // Bit FSDEF.
	SAI_BFRCR_FSALL_Pos = 0x8     // Position of FSALL field.
	SAI_BFRCR_FSALL_Msk = 0x7f00  // Bit mask of FSALL field.
	SAI_BFRCR_FRL_Pos   = 0x0     // Position of FRL field.
	SAI_BFRCR_FRL_Msk   = 0xff    // Bit mask of FRL field.

	// BSLOTR: BSlot register
	SAI_BSLOTR_SLOTEN_Pos = 0x10       // Position of SLOTEN field.
	SAI_BSLOTR_SLOTEN_Msk = 0xffff0000 // Bit mask of SLOTEN field.
	SAI_BSLOTR_NBSLOT_Pos = 0x8        // Position of NBSLOT field.
	SAI_BSLOTR_NBSLOT_Msk = 0xf00      // Bit mask of NBSLOT field.
	SAI_BSLOTR_SLOTSZ_Pos = 0x6        // Position of SLOTSZ field.
	SAI_BSLOTR_SLOTSZ_Msk = 0xc0       // Bit mask of SLOTSZ field.
	SAI_BSLOTR_FBOFF_Pos  = 0x0        // Position of FBOFF field.
	SAI_BSLOTR_FBOFF_Msk  = 0x1f       // Bit mask of FBOFF field.

	// BIM: BInterrupt mask register2
	SAI_BIM_LFSDETIE_Pos = 0x6  // Position of LFSDETIE field.
	SAI_BIM_LFSDETIE_Msk = 0x40 // Bit mask of LFSDETIE field.
	SAI_BIM_LFSDETIE     = 0x40 // Bit LFSDETIE.
	SAI_BIM_AFSDETIE_Pos = 0x5  // Position of AFSDETIE field.
	SAI_BIM_AFSDETIE_Msk = 0x20 // Bit mask of AFSDETIE field.
	SAI_BIM_AFSDETIE     = 0x20 // Bit AFSDETIE.
	SAI_BIM_CNRDYIE_Pos  = 0x4  // Position of CNRDYIE field.
	SAI_BIM_CNRDYIE_Msk  = 0x10 // Bit mask of CNRDYIE field.
	SAI_BIM_CNRDYIE      = 0x10 // Bit CNRDYIE.
	SAI_BIM_FREQIE_Pos   = 0x3  // Position of FREQIE field.
	SAI_BIM_FREQIE_Msk   = 0x8  // Bit mask of FREQIE field.
	SAI_BIM_FREQIE       = 0x8  // Bit FREQIE.
	SAI_BIM_WCKCFG_Pos   = 0x2  // Position of WCKCFG field.
	SAI_BIM_WCKCFG_Msk   = 0x4  // Bit mask of WCKCFG field.
	SAI_BIM_WCKCFG       = 0x4  // Bit WCKCFG.
	SAI_BIM_MUTEDET_Pos  = 0x1  // Position of MUTEDET field.
	SAI_BIM_MUTEDET_Msk  = 0x2  // Bit mask of MUTEDET field.
	SAI_BIM_MUTEDET      = 0x2  // Bit MUTEDET.
	SAI_BIM_OVRUDRIE_Pos = 0x0  // Position of OVRUDRIE field.
	SAI_BIM_OVRUDRIE_Msk = 0x1  // Bit mask of OVRUDRIE field.
	SAI_BIM_OVRUDRIE     = 0x1  // Bit OVRUDRIE.

	// BSR: BStatus register
	SAI_BSR_FLVL_Pos    = 0x10    // Position of FLVL field.
	SAI_BSR_FLVL_Msk    = 0x70000 // Bit mask of FLVL field.
	SAI_BSR_LFSDET_Pos  = 0x6     // Position of LFSDET field.
	SAI_BSR_LFSDET_Msk  = 0x40    // Bit mask of LFSDET field.
	SAI_BSR_LFSDET      = 0x40    // Bit LFSDET.
	SAI_BSR_AFSDET_Pos  = 0x5     // Position of AFSDET field.
	SAI_BSR_AFSDET_Msk  = 0x20    // Bit mask of AFSDET field.
	SAI_BSR_AFSDET      = 0x20    // Bit AFSDET.
	SAI_BSR_CNRDY_Pos   = 0x4     // Position of CNRDY field.
	SAI_BSR_CNRDY_Msk   = 0x10    // Bit mask of CNRDY field.
	SAI_BSR_CNRDY       = 0x10    // Bit CNRDY.
	SAI_BSR_FREQ_Pos    = 0x3     // Position of FREQ field.
	SAI_BSR_FREQ_Msk    = 0x8     // Bit mask of FREQ field.
	SAI_BSR_FREQ        = 0x8     // Bit FREQ.
	SAI_BSR_WCKCFG_Pos  = 0x2     // Position of WCKCFG field.
	SAI_BSR_WCKCFG_Msk  = 0x4     // Bit mask of WCKCFG field.
	SAI_BSR_WCKCFG      = 0x4     // Bit WCKCFG.
	SAI_BSR_MUTEDET_Pos = 0x1     // Position of MUTEDET field.
	SAI_BSR_MUTEDET_Msk = 0x2     // Bit mask of MUTEDET field.
	SAI_BSR_MUTEDET     = 0x2     // Bit MUTEDET.
	SAI_BSR_OVRUDR_Pos  = 0x0     // Position of OVRUDR field.
	SAI_BSR_OVRUDR_Msk  = 0x1     // Bit mask of OVRUDR field.
	SAI_BSR_OVRUDR      = 0x1     // Bit OVRUDR.

	// BCLRFR: BClear flag register
	SAI_BCLRFR_LFSDET_Pos  = 0x6  // Position of LFSDET field.
	SAI_BCLRFR_LFSDET_Msk  = 0x40 // Bit mask of LFSDET field.
	SAI_BCLRFR_LFSDET      = 0x40 // Bit LFSDET.
	SAI_BCLRFR_CAFSDET_Pos = 0x5  // Position of CAFSDET field.
	SAI_BCLRFR_CAFSDET_Msk = 0x20 // Bit mask of CAFSDET field.
	SAI_BCLRFR_CAFSDET     = 0x20 // Bit CAFSDET.
	SAI_BCLRFR_CNRDY_Pos   = 0x4  // Position of CNRDY field.
	SAI_BCLRFR_CNRDY_Msk   = 0x10 // Bit mask of CNRDY field.
	SAI_BCLRFR_CNRDY       = 0x10 // Bit CNRDY.
	SAI_BCLRFR_WCKCFG_Pos  = 0x2  // Position of WCKCFG field.
	SAI_BCLRFR_WCKCFG_Msk  = 0x4  // Bit mask of WCKCFG field.
	SAI_BCLRFR_WCKCFG      = 0x4  // Bit WCKCFG.
	SAI_BCLRFR_MUTEDET_Pos = 0x1  // Position of MUTEDET field.
	SAI_BCLRFR_MUTEDET_Msk = 0x2  // Bit mask of MUTEDET field.
	SAI_BCLRFR_MUTEDET     = 0x2  // Bit MUTEDET.
	SAI_BCLRFR_OVRUDR_Pos  = 0x0  // Position of OVRUDR field.
	SAI_BCLRFR_OVRUDR_Msk  = 0x1  // Bit mask of OVRUDR field.
	SAI_BCLRFR_OVRUDR      = 0x1  // Bit OVRUDR.

	// BDR: BData register
	SAI_BDR_DATA_Pos = 0x0        // Position of DATA field.
	SAI_BDR_DATA_Msk = 0xffffffff // Bit mask of DATA field.
)

// Bitfields for TIM2: General-purpose-timers
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_TI1S_Pos = 0x7  // Position of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80 // Bit mask of TI1S field.
	TIM_CR2_TI1S     = 0x80 // Bit TI1S.
	TIM_CR2_MMS_Pos  = 0x4  // Position of MMS field.
	TIM_CR2_MMS_Msk  = 0x70 // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos = 0x3  // Position of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8  // Bit mask of CCDS field.
	TIM_CR2_CCDS     = 0x8  // Bit CCDS.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa    // Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00  // Bit mask of IC2PSC field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2    // Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc    // Bit mask of IC1PSC field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4NP_Pos = 0xf    // Position of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000 // Bit mask of CC4NP field.
	TIM_CCER_CC4NP     = 0x8000 // Bit CC4NP.
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_H_Pos = 0x10       // Position of CNT_H field.
	TIM_CNT_CNT_H_Msk = 0xffff0000 // Bit mask of CNT_H field.
	TIM_CNT_CNT_L_Pos = 0x0        // Position of CNT_L field.
	TIM_CNT_CNT_L_Msk = 0xffff     // Bit mask of CNT_L field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_H_Pos = 0x10       // Position of ARR_H field.
	TIM_ARR_ARR_H_Msk = 0xffff0000 // Bit mask of ARR_H field.
	TIM_ARR_ARR_L_Pos = 0x0        // Position of ARR_L field.
	TIM_ARR_ARR_L_Msk = 0xffff     // Bit mask of ARR_L field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_H_Pos = 0x10       // Position of CCR1_H field.
	TIM_CCR1_CCR1_H_Msk = 0xffff0000 // Bit mask of CCR1_H field.
	TIM_CCR1_CCR1_L_Pos = 0x0        // Position of CCR1_L field.
	TIM_CCR1_CCR1_L_Msk = 0xffff     // Bit mask of CCR1_L field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_H_Pos = 0x10       // Position of CCR2_H field.
	TIM_CCR2_CCR2_H_Msk = 0xffff0000 // Bit mask of CCR2_H field.
	TIM_CCR2_CCR2_L_Pos = 0x0        // Position of CCR2_L field.
	TIM_CCR2_CCR2_L_Msk = 0xffff     // Bit mask of CCR2_L field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_H_Pos = 0x10       // Position of CCR3_H field.
	TIM_CCR3_CCR3_H_Msk = 0xffff0000 // Bit mask of CCR3_H field.
	TIM_CCR3_CCR3_L_Pos = 0x0        // Position of CCR3_L field.
	TIM_CCR3_CCR3_L_Msk = 0xffff     // Bit mask of CCR3_L field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_H_Pos = 0x10       // Position of CCR4_H field.
	TIM_CCR4_CCR4_H_Msk = 0xffff0000 // Bit mask of CCR4_H field.
	TIM_CCR4_CCR4_L_Pos = 0x0        // Position of CCR4_L field.
	TIM_CCR4_CCR4_L_Msk = 0xffff     // Bit mask of CCR4_L field.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.

	// OR: TIM2 option register
	TIM_OR_ETR_RMP_Pos = 0x0  // Position of ETR_RMP field.
	TIM_OR_ETR_RMP_Msk = 0x7  // Bit mask of ETR_RMP field.
	TIM_OR_TI4_RMP_Pos = 0x3  // Position of TI4_RMP field.
	TIM_OR_TI4_RMP_Msk = 0x18 // Bit mask of TI4_RMP field.
)

// Bitfields for LPTIM1: Low power timer
const (
	// ISR: Interrupt and Status Register
	LPTIM_ISR_DOWN_Pos    = 0x6  // Position of DOWN field.
	LPTIM_ISR_DOWN_Msk    = 0x40 // Bit mask of DOWN field.
	LPTIM_ISR_DOWN        = 0x40 // Bit DOWN.
	LPTIM_ISR_UP_Pos      = 0x5  // Position of UP field.
	LPTIM_ISR_UP_Msk      = 0x20 // Bit mask of UP field.
	LPTIM_ISR_UP          = 0x20 // Bit UP.
	LPTIM_ISR_ARROK_Pos   = 0x4  // Position of ARROK field.
	LPTIM_ISR_ARROK_Msk   = 0x10 // Bit mask of ARROK field.
	LPTIM_ISR_ARROK       = 0x10 // Bit ARROK.
	LPTIM_ISR_CMPOK_Pos   = 0x3  // Position of CMPOK field.
	LPTIM_ISR_CMPOK_Msk   = 0x8  // Bit mask of CMPOK field.
	LPTIM_ISR_CMPOK       = 0x8  // Bit CMPOK.
	LPTIM_ISR_EXTTRIG_Pos = 0x2  // Position of EXTTRIG field.
	LPTIM_ISR_EXTTRIG_Msk = 0x4  // Bit mask of EXTTRIG field.
	LPTIM_ISR_EXTTRIG     = 0x4  // Bit EXTTRIG.
	LPTIM_ISR_ARRM_Pos    = 0x1  // Position of ARRM field.
	LPTIM_ISR_ARRM_Msk    = 0x2  // Bit mask of ARRM field.
	LPTIM_ISR_ARRM        = 0x2  // Bit ARRM.
	LPTIM_ISR_CMPM_Pos    = 0x0  // Position of CMPM field.
	LPTIM_ISR_CMPM_Msk    = 0x1  // Bit mask of CMPM field.
	LPTIM_ISR_CMPM        = 0x1  // Bit CMPM.

	// ICR: Interrupt Clear Register
	LPTIM_ICR_DOWNCF_Pos    = 0x6  // Position of DOWNCF field.
	LPTIM_ICR_DOWNCF_Msk    = 0x40 // Bit mask of DOWNCF field.
	LPTIM_ICR_DOWNCF        = 0x40 // Bit DOWNCF.
	LPTIM_ICR_UPCF_Pos      = 0x5  // Position of UPCF field.
	LPTIM_ICR_UPCF_Msk      = 0x20 // Bit mask of UPCF field.
	LPTIM_ICR_UPCF          = 0x20 // Bit UPCF.
	LPTIM_ICR_ARROKCF_Pos   = 0x4  // Position of ARROKCF field.
	LPTIM_ICR_ARROKCF_Msk   = 0x10 // Bit mask of ARROKCF field.
	LPTIM_ICR_ARROKCF       = 0x10 // Bit ARROKCF.
	LPTIM_ICR_CMPOKCF_Pos   = 0x3  // Position of CMPOKCF field.
	LPTIM_ICR_CMPOKCF_Msk   = 0x8  // Bit mask of CMPOKCF field.
	LPTIM_ICR_CMPOKCF       = 0x8  // Bit CMPOKCF.
	LPTIM_ICR_EXTTRIGCF_Pos = 0x2  // Position of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF_Msk = 0x4  // Bit mask of EXTTRIGCF field.
	LPTIM_ICR_EXTTRIGCF     = 0x4  // Bit EXTTRIGCF.
	LPTIM_ICR_ARRMCF_Pos    = 0x1  // Position of ARRMCF field.
	LPTIM_ICR_ARRMCF_Msk    = 0x2  // Bit mask of ARRMCF field.
	LPTIM_ICR_ARRMCF        = 0x2  // Bit ARRMCF.
	LPTIM_ICR_CMPMCF_Pos    = 0x0  // Position of CMPMCF field.
	LPTIM_ICR_CMPMCF_Msk    = 0x1  // Bit mask of CMPMCF field.
	LPTIM_ICR_CMPMCF        = 0x1  // Bit CMPMCF.

	// IER: Interrupt Enable Register
	LPTIM_IER_DOWNIE_Pos    = 0x6  // Position of DOWNIE field.
	LPTIM_IER_DOWNIE_Msk    = 0x40 // Bit mask of DOWNIE field.
	LPTIM_IER_DOWNIE        = 0x40 // Bit DOWNIE.
	LPTIM_IER_UPIE_Pos      = 0x5  // Position of UPIE field.
	LPTIM_IER_UPIE_Msk      = 0x20 // Bit mask of UPIE field.
	LPTIM_IER_UPIE          = 0x20 // Bit UPIE.
	LPTIM_IER_ARROKIE_Pos   = 0x4  // Position of ARROKIE field.
	LPTIM_IER_ARROKIE_Msk   = 0x10 // Bit mask of ARROKIE field.
	LPTIM_IER_ARROKIE       = 0x10 // Bit ARROKIE.
	LPTIM_IER_CMPOKIE_Pos   = 0x3  // Position of CMPOKIE field.
	LPTIM_IER_CMPOKIE_Msk   = 0x8  // Bit mask of CMPOKIE field.
	LPTIM_IER_CMPOKIE       = 0x8  // Bit CMPOKIE.
	LPTIM_IER_EXTTRIGIE_Pos = 0x2  // Position of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE_Msk = 0x4  // Bit mask of EXTTRIGIE field.
	LPTIM_IER_EXTTRIGIE     = 0x4  // Bit EXTTRIGIE.
	LPTIM_IER_ARRMIE_Pos    = 0x1  // Position of ARRMIE field.
	LPTIM_IER_ARRMIE_Msk    = 0x2  // Bit mask of ARRMIE field.
	LPTIM_IER_ARRMIE        = 0x2  // Bit ARRMIE.
	LPTIM_IER_CMPMIE_Pos    = 0x0  // Position of CMPMIE field.
	LPTIM_IER_CMPMIE_Msk    = 0x1  // Bit mask of CMPMIE field.
	LPTIM_IER_CMPMIE        = 0x1  // Bit CMPMIE.

	// CFGR: Configuration Register
	LPTIM_CFGR_ENC_Pos       = 0x18      // Position of ENC field.
	LPTIM_CFGR_ENC_Msk       = 0x1000000 // Bit mask of ENC field.
	LPTIM_CFGR_ENC           = 0x1000000 // Bit ENC.
	LPTIM_CFGR_COUNTMODE_Pos = 0x17      // Position of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE_Msk = 0x800000  // Bit mask of COUNTMODE field.
	LPTIM_CFGR_COUNTMODE     = 0x800000  // Bit COUNTMODE.
	LPTIM_CFGR_PRELOAD_Pos   = 0x16      // Position of PRELOAD field.
	LPTIM_CFGR_PRELOAD_Msk   = 0x400000  // Bit mask of PRELOAD field.
	LPTIM_CFGR_PRELOAD       = 0x400000  // Bit PRELOAD.
	LPTIM_CFGR_WAVPOL_Pos    = 0x15      // Position of WAVPOL field.
	LPTIM_CFGR_WAVPOL_Msk    = 0x200000  // Bit mask of WAVPOL field.
	LPTIM_CFGR_WAVPOL        = 0x200000  // Bit WAVPOL.
	LPTIM_CFGR_WAVE_Pos      = 0x14      // Position of WAVE field.
	LPTIM_CFGR_WAVE_Msk      = 0x100000  // Bit mask of WAVE field.
	LPTIM_CFGR_WAVE          = 0x100000  // Bit WAVE.
	LPTIM_CFGR_TIMOUT_Pos    = 0x13      // Position of TIMOUT field.
	LPTIM_CFGR_TIMOUT_Msk    = 0x80000   // Bit mask of TIMOUT field.
	LPTIM_CFGR_TIMOUT        = 0x80000   // Bit TIMOUT.
	LPTIM_CFGR_TRIGEN_Pos    = 0x11      // Position of TRIGEN field.
	LPTIM_CFGR_TRIGEN_Msk    = 0x60000   // Bit mask of TRIGEN field.
	LPTIM_CFGR_TRIGSEL_Pos   = 0xd       // Position of TRIGSEL field.
	LPTIM_CFGR_TRIGSEL_Msk   = 0xe000    // Bit mask of TRIGSEL field.
	LPTIM_CFGR_PRESC_Pos     = 0x9       // Position of PRESC field.
	LPTIM_CFGR_PRESC_Msk     = 0xe00     // Bit mask of PRESC field.
	LPTIM_CFGR_TRGFLT_Pos    = 0x6       // Position of TRGFLT field.
	LPTIM_CFGR_TRGFLT_Msk    = 0xc0      // Bit mask of TRGFLT field.
	LPTIM_CFGR_CKFLT_Pos     = 0x3       // Position of CKFLT field.
	LPTIM_CFGR_CKFLT_Msk     = 0x18      // Bit mask of CKFLT field.
	LPTIM_CFGR_CKPOL_Pos     = 0x1       // Position of CKPOL field.
	LPTIM_CFGR_CKPOL_Msk     = 0x6       // Bit mask of CKPOL field.
	LPTIM_CFGR_CKSEL_Pos     = 0x0       // Position of CKSEL field.
	LPTIM_CFGR_CKSEL_Msk     = 0x1       // Bit mask of CKSEL field.
	LPTIM_CFGR_CKSEL         = 0x1       // Bit CKSEL.

	// CR: Control Register
	LPTIM_CR_CNTSTRT_Pos = 0x2 // Position of CNTSTRT field.
	LPTIM_CR_CNTSTRT_Msk = 0x4 // Bit mask of CNTSTRT field.
	LPTIM_CR_CNTSTRT     = 0x4 // Bit CNTSTRT.
	LPTIM_CR_SNGSTRT_Pos = 0x1 // Position of SNGSTRT field.
	LPTIM_CR_SNGSTRT_Msk = 0x2 // Bit mask of SNGSTRT field.
	LPTIM_CR_SNGSTRT     = 0x2 // Bit SNGSTRT.
	LPTIM_CR_ENABLE_Pos  = 0x0 // Position of ENABLE field.
	LPTIM_CR_ENABLE_Msk  = 0x1 // Bit mask of ENABLE field.
	LPTIM_CR_ENABLE      = 0x1 // Bit ENABLE.

	// CMP: Compare Register
	LPTIM_CMP_CMP_Pos = 0x0    // Position of CMP field.
	LPTIM_CMP_CMP_Msk = 0xffff // Bit mask of CMP field.

	// ARR: Autoreload Register
	LPTIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	LPTIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// CNT: Counter Register
	LPTIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	LPTIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	USART_CR1_M1_Pos     = 0x1c       // Position of M1 field.
	USART_CR1_M1_Msk     = 0x10000000 // Bit mask of M1 field.
	USART_CR1_M1         = 0x10000000 // Bit M1.
	USART_CR1_EOBIE_Pos  = 0x1b       // Position of EOBIE field.
	USART_CR1_EOBIE_Msk  = 0x8000000  // Bit mask of EOBIE field.
	USART_CR1_EOBIE      = 0x8000000  // Bit EOBIE.
	USART_CR1_RTOIE_Pos  = 0x1a       // Position of RTOIE field.
	USART_CR1_RTOIE_Msk  = 0x4000000  // Bit mask of RTOIE field.
	USART_CR1_RTOIE      = 0x4000000  // Bit RTOIE.
	USART_CR1_DEAT4_Pos  = 0x19       // Position of DEAT4 field.
	USART_CR1_DEAT4_Msk  = 0x2000000  // Bit mask of DEAT4 field.
	USART_CR1_DEAT4      = 0x2000000  // Bit DEAT4.
	USART_CR1_DEAT3_Pos  = 0x18       // Position of DEAT3 field.
	USART_CR1_DEAT3_Msk  = 0x1000000  // Bit mask of DEAT3 field.
	USART_CR1_DEAT3      = 0x1000000  // Bit DEAT3.
	USART_CR1_DEAT2_Pos  = 0x17       // Position of DEAT2 field.
	USART_CR1_DEAT2_Msk  = 0x800000   // Bit mask of DEAT2 field.
	USART_CR1_DEAT2      = 0x800000   // Bit DEAT2.
	USART_CR1_DEAT1_Pos  = 0x16       // Position of DEAT1 field.
	USART_CR1_DEAT1_Msk  = 0x400000   // Bit mask of DEAT1 field.
	USART_CR1_DEAT1      = 0x400000   // Bit DEAT1.
	USART_CR1_DEAT0_Pos  = 0x15       // Position of DEAT0 field.
	USART_CR1_DEAT0_Msk  = 0x200000   // Bit mask of DEAT0 field.
	USART_CR1_DEAT0      = 0x200000   // Bit DEAT0.
	USART_CR1_DEDT4_Pos  = 0x14       // Position of DEDT4 field.
	USART_CR1_DEDT4_Msk  = 0x100000   // Bit mask of DEDT4 field.
	USART_CR1_DEDT4      = 0x100000   // Bit DEDT4.
	USART_CR1_DEDT3_Pos  = 0x13       // Position of DEDT3 field.
	USART_CR1_DEDT3_Msk  = 0x80000    // Bit mask of DEDT3 field.
	USART_CR1_DEDT3      = 0x80000    // Bit DEDT3.
	USART_CR1_DEDT2_Pos  = 0x12       // Position of DEDT2 field.
	USART_CR1_DEDT2_Msk  = 0x40000    // Bit mask of DEDT2 field.
	USART_CR1_DEDT2      = 0x40000    // Bit DEDT2.
	USART_CR1_DEDT1_Pos  = 0x11       // Position of DEDT1 field.
	USART_CR1_DEDT1_Msk  = 0x20000    // Bit mask of DEDT1 field.
	USART_CR1_DEDT1      = 0x20000    // Bit DEDT1.
	USART_CR1_DEDT0_Pos  = 0x10       // Position of DEDT0 field.
	USART_CR1_DEDT0_Msk  = 0x10000    // Bit mask of DEDT0 field.
	USART_CR1_DEDT0      = 0x10000    // Bit DEDT0.
	USART_CR1_OVER8_Pos  = 0xf        // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000     // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000     // Bit OVER8.
	USART_CR1_CMIE_Pos   = 0xe        // Position of CMIE field.
	USART_CR1_CMIE_Msk   = 0x4000     // Bit mask of CMIE field.
	USART_CR1_CMIE       = 0x4000     // Bit CMIE.
	USART_CR1_MME_Pos    = 0xd        // Position of MME field.
	USART_CR1_MME_Msk    = 0x2000     // Bit mask of MME field.
	USART_CR1_MME        = 0x2000     // Bit MME.
	USART_CR1_M0_Pos     = 0xc        // Position of M0 field.
	USART_CR1_M0_Msk     = 0x1000     // Bit mask of M0 field.
	USART_CR1_M0         = 0x1000     // Bit M0.
	USART_CR1_WAKE_Pos   = 0xb        // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800      // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800      // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa        // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400      // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400      // Bit PCE.
	USART_CR1_PS_Pos     = 0x9        // Position of PS field.
	USART_CR1_PS_Msk     = 0x200      // Bit mask of PS field.
	USART_CR1_PS         = 0x200      // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8        // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100      // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100      // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7        // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80       // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80       // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6        // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40       // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40       // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5        // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20       // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20       // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4        // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10       // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10       // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3        // Position of TE field.
	USART_CR1_TE_Msk     = 0x8        // Bit mask of TE field.
	USART_CR1_TE         = 0x8        // Bit TE.
	USART_CR1_RE_Pos     = 0x2        // Position of RE field.
	USART_CR1_RE_Msk     = 0x4        // Bit mask of RE field.
	USART_CR1_RE         = 0x4        // Bit RE.
	USART_CR1_UESM_Pos   = 0x1        // Position of UESM field.
	USART_CR1_UESM_Msk   = 0x2        // Bit mask of UESM field.
	USART_CR1_UESM       = 0x2        // Bit UESM.
	USART_CR1_UE_Pos     = 0x0        // Position of UE field.
	USART_CR1_UE_Msk     = 0x1        // Bit mask of UE field.
	USART_CR1_UE         = 0x1        // Bit UE.

	// CR2: Control register 2
	USART_CR2_ADD4_7_Pos   = 0x1c       // Position of ADD4_7 field.
	USART_CR2_ADD4_7_Msk   = 0xf0000000 // Bit mask of ADD4_7 field.
	USART_CR2_ADD0_3_Pos   = 0x18       // Position of ADD0_3 field.
	USART_CR2_ADD0_3_Msk   = 0xf000000  // Bit mask of ADD0_3 field.
	USART_CR2_RTOEN_Pos    = 0x17       // Position of RTOEN field.
	USART_CR2_RTOEN_Msk    = 0x800000   // Bit mask of RTOEN field.
	USART_CR2_RTOEN        = 0x800000   // Bit RTOEN.
	USART_CR2_ABRMOD1_Pos  = 0x16       // Position of ABRMOD1 field.
	USART_CR2_ABRMOD1_Msk  = 0x400000   // Bit mask of ABRMOD1 field.
	USART_CR2_ABRMOD1      = 0x400000   // Bit ABRMOD1.
	USART_CR2_ABRMOD0_Pos  = 0x15       // Position of ABRMOD0 field.
	USART_CR2_ABRMOD0_Msk  = 0x200000   // Bit mask of ABRMOD0 field.
	USART_CR2_ABRMOD0      = 0x200000   // Bit ABRMOD0.
	USART_CR2_ABREN_Pos    = 0x14       // Position of ABREN field.
	USART_CR2_ABREN_Msk    = 0x100000   // Bit mask of ABREN field.
	USART_CR2_ABREN        = 0x100000   // Bit ABREN.
	USART_CR2_MSBFIRST_Pos = 0x13       // Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000    // Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST     = 0x80000    // Bit MSBFIRST.
	USART_CR2_TAINV_Pos    = 0x12       // Position of TAINV field.
	USART_CR2_TAINV_Msk    = 0x40000    // Bit mask of TAINV field.
	USART_CR2_TAINV        = 0x40000    // Bit TAINV.
	USART_CR2_TXINV_Pos    = 0x11       // Position of TXINV field.
	USART_CR2_TXINV_Msk    = 0x20000    // Bit mask of TXINV field.
	USART_CR2_TXINV        = 0x20000    // Bit TXINV.
	USART_CR2_RXINV_Pos    = 0x10       // Position of RXINV field.
	USART_CR2_RXINV_Msk    = 0x10000    // Bit mask of RXINV field.
	USART_CR2_RXINV        = 0x10000    // Bit RXINV.
	USART_CR2_SWAP_Pos     = 0xf        // Position of SWAP field.
	USART_CR2_SWAP_Msk     = 0x8000     // Bit mask of SWAP field.
	USART_CR2_SWAP         = 0x8000     // Bit SWAP.
	USART_CR2_LINEN_Pos    = 0xe        // Position of LINEN field.
	USART_CR2_LINEN_Msk    = 0x4000     // Bit mask of LINEN field.
	USART_CR2_LINEN        = 0x4000     // Bit LINEN.
	USART_CR2_STOP_Pos     = 0xc        // Position of STOP field.
	USART_CR2_STOP_Msk     = 0x3000     // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos    = 0xb        // Position of CLKEN field.
	USART_CR2_CLKEN_Msk    = 0x800      // Bit mask of CLKEN field.
	USART_CR2_CLKEN        = 0x800      // Bit CLKEN.
	USART_CR2_CPOL_Pos     = 0xa        // Position of CPOL field.
	USART_CR2_CPOL_Msk     = 0x400      // Bit mask of CPOL field.
	USART_CR2_CPOL         = 0x400      // Bit CPOL.
	USART_CR2_CPHA_Pos     = 0x9        // Position of CPHA field.
	USART_CR2_CPHA_Msk     = 0x200      // Bit mask of CPHA field.
	USART_CR2_CPHA         = 0x200      // Bit CPHA.
	USART_CR2_LBCL_Pos     = 0x8        // Position of LBCL field.
	USART_CR2_LBCL_Msk     = 0x100      // Bit mask of LBCL field.
	USART_CR2_LBCL         = 0x100      // Bit LBCL.
	USART_CR2_LBDIE_Pos    = 0x6        // Position of LBDIE field.
	USART_CR2_LBDIE_Msk    = 0x40       // Bit mask of LBDIE field.
	USART_CR2_LBDIE        = 0x40       // Bit LBDIE.
	USART_CR2_LBDL_Pos     = 0x5        // Position of LBDL field.
	USART_CR2_LBDL_Msk     = 0x20       // Bit mask of LBDL field.
	USART_CR2_LBDL         = 0x20       // Bit LBDL.
	USART_CR2_ADDM7_Pos    = 0x4        // Position of ADDM7 field.
	USART_CR2_ADDM7_Msk    = 0x10       // Bit mask of ADDM7 field.
	USART_CR2_ADDM7        = 0x10       // Bit ADDM7.

	// CR3: Control register 3
	USART_CR3_WUFIE_Pos   = 0x16     // Position of WUFIE field.
	USART_CR3_WUFIE_Msk   = 0x400000 // Bit mask of WUFIE field.
	USART_CR3_WUFIE       = 0x400000 // Bit WUFIE.
	USART_CR3_WUS_Pos     = 0x14     // Position of WUS field.
	USART_CR3_WUS_Msk     = 0x300000 // Bit mask of WUS field.
	USART_CR3_SCARCNT_Pos = 0x11     // Position of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000  // Bit mask of SCARCNT field.
	USART_CR3_DEP_Pos     = 0xf      // Position of DEP field.
	USART_CR3_DEP_Msk     = 0x8000   // Bit mask of DEP field.
	USART_CR3_DEP         = 0x8000   // Bit DEP.
	USART_CR3_DEM_Pos     = 0xe      // Position of DEM field.
	USART_CR3_DEM_Msk     = 0x4000   // Bit mask of DEM field.
	USART_CR3_DEM         = 0x4000   // Bit DEM.
	USART_CR3_DDRE_Pos    = 0xd      // Position of DDRE field.
	USART_CR3_DDRE_Msk    = 0x2000   // Bit mask of DDRE field.
	USART_CR3_DDRE        = 0x2000   // Bit DDRE.
	USART_CR3_OVRDIS_Pos  = 0xc      // Position of OVRDIS field.
	USART_CR3_OVRDIS_Msk  = 0x1000   // Bit mask of OVRDIS field.
	USART_CR3_OVRDIS      = 0x1000   // Bit OVRDIS.
	USART_CR3_ONEBIT_Pos  = 0xb      // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk  = 0x800    // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT      = 0x800    // Bit ONEBIT.
	USART_CR3_CTSIE_Pos   = 0xa      // Position of CTSIE field.
	USART_CR3_CTSIE_Msk   = 0x400    // Bit mask of CTSIE field.
	USART_CR3_CTSIE       = 0x400    // Bit CTSIE.
	USART_CR3_CTSE_Pos    = 0x9      // Position of CTSE field.
	USART_CR3_CTSE_Msk    = 0x200    // Bit mask of CTSE field.
	USART_CR3_CTSE        = 0x200    // Bit CTSE.
	USART_CR3_RTSE_Pos    = 0x8      // Position of RTSE field.
	USART_CR3_RTSE_Msk    = 0x100    // Bit mask of RTSE field.
	USART_CR3_RTSE        = 0x100    // Bit RTSE.
	USART_CR3_DMAT_Pos    = 0x7      // Position of DMAT field.
	USART_CR3_DMAT_Msk    = 0x80     // Bit mask of DMAT field.
	USART_CR3_DMAT        = 0x80     // Bit DMAT.
	USART_CR3_DMAR_Pos    = 0x6      // Position of DMAR field.
	USART_CR3_DMAR_Msk    = 0x40     // Bit mask of DMAR field.
	USART_CR3_DMAR        = 0x40     // Bit DMAR.
	USART_CR3_SCEN_Pos    = 0x5      // Position of SCEN field.
	USART_CR3_SCEN_Msk    = 0x20     // Bit mask of SCEN field.
	USART_CR3_SCEN        = 0x20     // Bit SCEN.
	USART_CR3_NACK_Pos    = 0x4      // Position of NACK field.
	USART_CR3_NACK_Msk    = 0x10     // Bit mask of NACK field.
	USART_CR3_NACK        = 0x10     // Bit NACK.
	USART_CR3_HDSEL_Pos   = 0x3      // Position of HDSEL field.
	USART_CR3_HDSEL_Msk   = 0x8      // Bit mask of HDSEL field.
	USART_CR3_HDSEL       = 0x8      // Bit HDSEL.
	USART_CR3_IRLP_Pos    = 0x2      // Position of IRLP field.
	USART_CR3_IRLP_Msk    = 0x4      // Bit mask of IRLP field.
	USART_CR3_IRLP        = 0x4      // Bit IRLP.
	USART_CR3_IREN_Pos    = 0x1      // Position of IREN field.
	USART_CR3_IREN_Msk    = 0x2      // Bit mask of IREN field.
	USART_CR3_IREN        = 0x2      // Bit IREN.
	USART_CR3_EIE_Pos     = 0x0      // Position of EIE field.
	USART_CR3_EIE_Msk     = 0x1      // Bit mask of EIE field.
	USART_CR3_EIE         = 0x1      // Bit EIE.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.

	// RTOR: Receiver timeout register
	USART_RTOR_BLEN_Pos = 0x18       // Position of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000 // Bit mask of BLEN field.
	USART_RTOR_RTO_Pos  = 0x0        // Position of RTO field.
	USART_RTOR_RTO_Msk  = 0xffffff   // Bit mask of RTO field.

	// RQR: Request register
	USART_RQR_TXFRQ_Pos = 0x4  // Position of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10 // Bit mask of TXFRQ field.
	USART_RQR_TXFRQ     = 0x10 // Bit TXFRQ.
	USART_RQR_RXFRQ_Pos = 0x3  // Position of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8  // Bit mask of RXFRQ field.
	USART_RQR_RXFRQ     = 0x8  // Bit RXFRQ.
	USART_RQR_MMRQ_Pos  = 0x2  // Position of MMRQ field.
	USART_RQR_MMRQ_Msk  = 0x4  // Bit mask of MMRQ field.
	USART_RQR_MMRQ      = 0x4  // Bit MMRQ.
	USART_RQR_SBKRQ_Pos = 0x1  // Position of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2  // Bit mask of SBKRQ field.
	USART_RQR_SBKRQ     = 0x2  // Bit SBKRQ.
	USART_RQR_ABRRQ_Pos = 0x0  // Position of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1  // Bit mask of ABRRQ field.
	USART_RQR_ABRRQ     = 0x1  // Bit ABRRQ.

	// ISR: Interrupt & status           register
	USART_ISR_REACK_Pos = 0x16     // Position of REACK field.
	USART_ISR_REACK_Msk = 0x400000 // Bit mask of REACK field.
	USART_ISR_REACK     = 0x400000 // Bit REACK.
	USART_ISR_TEACK_Pos = 0x15     // Position of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000 // Bit mask of TEACK field.
	USART_ISR_TEACK     = 0x200000 // Bit TEACK.
	USART_ISR_WUF_Pos   = 0x14     // Position of WUF field.
	USART_ISR_WUF_Msk   = 0x100000 // Bit mask of WUF field.
	USART_ISR_WUF       = 0x100000 // Bit WUF.
	USART_ISR_RWU_Pos   = 0x13     // Position of RWU field.
	USART_ISR_RWU_Msk   = 0x80000  // Bit mask of RWU field.
	USART_ISR_RWU       = 0x80000  // Bit RWU.
	USART_ISR_SBKF_Pos  = 0x12     // Position of SBKF field.
	USART_ISR_SBKF_Msk  = 0x40000  // Bit mask of SBKF field.
	USART_ISR_SBKF      = 0x40000  // Bit SBKF.
	USART_ISR_CMF_Pos   = 0x11     // Position of CMF field.
	USART_ISR_CMF_Msk   = 0x20000  // Bit mask of CMF field.
	USART_ISR_CMF       = 0x20000  // Bit CMF.
	USART_ISR_BUSY_Pos  = 0x10     // Position of BUSY field.
	USART_ISR_BUSY_Msk  = 0x10000  // Bit mask of BUSY field.
	USART_ISR_BUSY      = 0x10000  // Bit BUSY.
	USART_ISR_ABRF_Pos  = 0xf      // Position of ABRF field.
	USART_ISR_ABRF_Msk  = 0x8000   // Bit mask of ABRF field.
	USART_ISR_ABRF      = 0x8000   // Bit ABRF.
	USART_ISR_ABRE_Pos  = 0xe      // Position of ABRE field.
	USART_ISR_ABRE_Msk  = 0x4000   // Bit mask of ABRE field.
	USART_ISR_ABRE      = 0x4000   // Bit ABRE.
	USART_ISR_EOBF_Pos  = 0xc      // Position of EOBF field.
	USART_ISR_EOBF_Msk  = 0x1000   // Bit mask of EOBF field.
	USART_ISR_EOBF      = 0x1000   // Bit EOBF.
	USART_ISR_RTOF_Pos  = 0xb      // Position of RTOF field.
	USART_ISR_RTOF_Msk  = 0x800    // Bit mask of RTOF field.
	USART_ISR_RTOF      = 0x800    // Bit RTOF.
	USART_ISR_CTS_Pos   = 0xa      // Position of CTS field.
	USART_ISR_CTS_Msk   = 0x400    // Bit mask of CTS field.
	USART_ISR_CTS       = 0x400    // Bit CTS.
	USART_ISR_CTSIF_Pos = 0x9      // Position of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200    // Bit mask of CTSIF field.
	USART_ISR_CTSIF     = 0x200    // Bit CTSIF.
	USART_ISR_LBDF_Pos  = 0x8      // Position of LBDF field.
	USART_ISR_LBDF_Msk  = 0x100    // Bit mask of LBDF field.
	USART_ISR_LBDF      = 0x100    // Bit LBDF.
	USART_ISR_TXE_Pos   = 0x7      // Position of TXE field.
	USART_ISR_TXE_Msk   = 0x80     // Bit mask of TXE field.
	USART_ISR_TXE       = 0x80     // Bit TXE.
	USART_ISR_TC_Pos    = 0x6      // Position of TC field.
	USART_ISR_TC_Msk    = 0x40     // Bit mask of TC field.
	USART_ISR_TC        = 0x40     // Bit TC.
	USART_ISR_RXNE_Pos  = 0x5      // Position of RXNE field.
	USART_ISR_RXNE_Msk  = 0x20     // Bit mask of RXNE field.
	USART_ISR_RXNE      = 0x20     // Bit RXNE.
	USART_ISR_IDLE_Pos  = 0x4      // Position of IDLE field.
	USART_ISR_IDLE_Msk  = 0x10     // Bit mask of IDLE field.
	USART_ISR_IDLE      = 0x10     // Bit IDLE.
	USART_ISR_ORE_Pos   = 0x3      // Position of ORE field.
	USART_ISR_ORE_Msk   = 0x8      // Bit mask of ORE field.
	USART_ISR_ORE       = 0x8      // Bit ORE.
	USART_ISR_NF_Pos    = 0x2      // Position of NF field.
	USART_ISR_NF_Msk    = 0x4      // Bit mask of NF field.
	USART_ISR_NF        = 0x4      // Bit NF.
	USART_ISR_FE_Pos    = 0x1      // Position of FE field.
	USART_ISR_FE_Msk    = 0x2      // Bit mask of FE field.
	USART_ISR_FE        = 0x2      // Bit FE.
	USART_ISR_PE_Pos    = 0x0      // Position of PE field.
	USART_ISR_PE_Msk    = 0x1      // Bit mask of PE field.
	USART_ISR_PE        = 0x1      // Bit PE.

	// ICR: Interrupt flag clear register
	USART_ICR_WUCF_Pos   = 0x14     // Position of WUCF field.
	USART_ICR_WUCF_Msk   = 0x100000 // Bit mask of WUCF field.
	USART_ICR_WUCF       = 0x100000 // Bit WUCF.
	USART_ICR_CMCF_Pos   = 0x11     // Position of CMCF field.
	USART_ICR_CMCF_Msk   = 0x20000  // Bit mask of CMCF field.
	USART_ICR_CMCF       = 0x20000  // Bit CMCF.
	USART_ICR_EOBCF_Pos  = 0xc      // Position of EOBCF field.
	USART_ICR_EOBCF_Msk  = 0x1000   // Bit mask of EOBCF field.
	USART_ICR_EOBCF      = 0x1000   // Bit EOBCF.
	USART_ICR_RTOCF_Pos  = 0xb      // Position of RTOCF field.
	USART_ICR_RTOCF_Msk  = 0x800    // Bit mask of RTOCF field.
	USART_ICR_RTOCF      = 0x800    // Bit RTOCF.
	USART_ICR_CTSCF_Pos  = 0x9      // Position of CTSCF field.
	USART_ICR_CTSCF_Msk  = 0x200    // Bit mask of CTSCF field.
	USART_ICR_CTSCF      = 0x200    // Bit CTSCF.
	USART_ICR_LBDCF_Pos  = 0x8      // Position of LBDCF field.
	USART_ICR_LBDCF_Msk  = 0x100    // Bit mask of LBDCF field.
	USART_ICR_LBDCF      = 0x100    // Bit LBDCF.
	USART_ICR_TCCF_Pos   = 0x6      // Position of TCCF field.
	USART_ICR_TCCF_Msk   = 0x40     // Bit mask of TCCF field.
	USART_ICR_TCCF       = 0x40     // Bit TCCF.
	USART_ICR_IDLECF_Pos = 0x4      // Position of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10     // Bit mask of IDLECF field.
	USART_ICR_IDLECF     = 0x10     // Bit IDLECF.
	USART_ICR_ORECF_Pos  = 0x3      // Position of ORECF field.
	USART_ICR_ORECF_Msk  = 0x8      // Bit mask of ORECF field.
	USART_ICR_ORECF      = 0x8      // Bit ORECF.
	USART_ICR_NCF_Pos    = 0x2      // Position of NCF field.
	USART_ICR_NCF_Msk    = 0x4      // Bit mask of NCF field.
	USART_ICR_NCF        = 0x4      // Bit NCF.
	USART_ICR_FECF_Pos   = 0x1      // Position of FECF field.
	USART_ICR_FECF_Msk   = 0x2      // Bit mask of FECF field.
	USART_ICR_FECF       = 0x2      // Bit FECF.
	USART_ICR_PECF_Pos   = 0x0      // Position of PECF field.
	USART_ICR_PECF_Msk   = 0x1      // Bit mask of PECF field.
	USART_ICR_PECF       = 0x1      // Bit PECF.

	// RDR: Receive data register
	USART_RDR_RDR_Pos = 0x0   // Position of RDR field.
	USART_RDR_RDR_Msk = 0x1ff // Bit mask of RDR field.

	// TDR: Transmit data register
	USART_TDR_TDR_Pos = 0x0   // Position of TDR field.
	USART_TDR_TDR_Msk = 0x1ff // Bit mask of TDR field.
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_RXDMAEN_Pos = 0x0    // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1    // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1    // Bit RXDMAEN.
	SPI_CR2_TXDMAEN_Pos = 0x1    // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2    // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2    // Bit TXDMAEN.
	SPI_CR2_SSOE_Pos    = 0x2    // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4    // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4    // Bit SSOE.
	SPI_CR2_NSSP_Pos    = 0x3    // Position of NSSP field.
	SPI_CR2_NSSP_Msk    = 0x8    // Bit mask of NSSP field.
	SPI_CR2_NSSP        = 0x8    // Bit NSSP.
	SPI_CR2_FRF_Pos     = 0x4    // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10   // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10   // Bit FRF.
	SPI_CR2_ERRIE_Pos   = 0x5    // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20   // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20   // Bit ERRIE.
	SPI_CR2_RXNEIE_Pos  = 0x6    // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40   // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40   // Bit RXNEIE.
	SPI_CR2_TXEIE_Pos   = 0x7    // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80   // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80   // Bit TXEIE.
	SPI_CR2_DS_Pos      = 0x8    // Position of DS field.
	SPI_CR2_DS_Msk      = 0xf00  // Bit mask of DS field.
	SPI_CR2_FRXTH_Pos   = 0xc    // Position of FRXTH field.
	SPI_CR2_FRXTH_Msk   = 0x1000 // Bit mask of FRXTH field.
	SPI_CR2_FRXTH       = 0x1000 // Bit FRXTH.
	SPI_CR2_LDMA_RX_Pos = 0xd    // Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000 // Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX     = 0x2000 // Bit LDMA_RX.
	SPI_CR2_LDMA_TX_Pos = 0xe    // Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000 // Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX     = 0x4000 // Bit LDMA_TX.

	// SR: status register
	SPI_SR_RXNE_Pos   = 0x0    // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1    // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1    // Bit RXNE.
	SPI_SR_TXE_Pos    = 0x1    // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2    // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2    // Bit TXE.
	SPI_SR_CRCERR_Pos = 0x4    // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10   // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10   // Bit CRCERR.
	SPI_SR_MODF_Pos   = 0x5    // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20   // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20   // Bit MODF.
	SPI_SR_OVR_Pos    = 0x6    // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40   // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40   // Bit OVR.
	SPI_SR_BSY_Pos    = 0x7    // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80   // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80   // Bit BSY.
	SPI_SR_TIFRFE_Pos = 0x8    // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100  // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100  // Bit TIFRFE.
	SPI_SR_FRLVL_Pos  = 0x9    // Position of FRLVL field.
	SPI_SR_FRLVL_Msk  = 0x600  // Bit mask of FRLVL field.
	SPI_SR_FTLVL_Pos  = 0xb    // Position of FTLVL field.
	SPI_SR_FTLVL_Msk  = 0x1800 // Bit mask of FTLVL field.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.
)

// Bitfields for SDMMC1: Secure digital input/output interface
const (
	// POWER: power control register
	SDIO_POWER_PWRCTRL_Pos = 0x0 // Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3 // Bit mask of PWRCTRL field.

	// CLKCR: SDI clock control register
	SDIO_CLKCR_HWFC_EN_Pos = 0xe    // Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000 // Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN     = 0x4000 // Bit HWFC_EN.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd    // Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000 // Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE     = 0x2000 // Bit NEGEDGE.
	SDIO_CLKCR_WIDBUS_Pos  = 0xb    // Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk  = 0x1800 // Bit mask of WIDBUS field.
	SDIO_CLKCR_BYPASS_Pos  = 0xa    // Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk  = 0x400  // Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS      = 0x400  // Bit BYPASS.
	SDIO_CLKCR_PWRSAV_Pos  = 0x9    // Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk  = 0x200  // Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV      = 0x200  // Bit PWRSAV.
	SDIO_CLKCR_CLKEN_Pos   = 0x8    // Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk   = 0x100  // Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN       = 0x100  // Bit CLKEN.
	SDIO_CLKCR_CLKDIV_Pos  = 0x0    // Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk  = 0xff   // Bit mask of CLKDIV field.

	// ARG: argument register
	SDIO_ARG_CMDARG_Pos = 0x0        // Position of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff // Bit mask of CMDARG field.

	// CMD: command register
	SDIO_CMD_CE_ATACMD_Pos   = 0xe    // Position of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Msk   = 0x4000 // Bit mask of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD       = 0x4000 // Bit CE_ATACMD.
	SDIO_CMD_NIEN_Pos        = 0xd    // Position of NIEN field.
	SDIO_CMD_NIEN_Msk        = 0x2000 // Bit mask of NIEN field.
	SDIO_CMD_NIEN            = 0x2000 // Bit NIEN.
	SDIO_CMD_ENCMDcompl_Pos  = 0xc    // Position of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Msk  = 0x1000 // Bit mask of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl      = 0x1000 // Bit ENCMDcompl.
	SDIO_CMD_SDIOSuspend_Pos = 0xb    // Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800  // Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend     = 0x800  // Bit SDIOSuspend.
	SDIO_CMD_CPSMEN_Pos      = 0xa    // Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk      = 0x400  // Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN          = 0x400  // Bit CPSMEN.
	SDIO_CMD_WAITPEND_Pos    = 0x9    // Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk    = 0x200  // Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND        = 0x200  // Bit WAITPEND.
	SDIO_CMD_WAITINT_Pos     = 0x8    // Position of WAITINT field.
	SDIO_CMD_WAITINT_Msk     = 0x100  // Bit mask of WAITINT field.
	SDIO_CMD_WAITINT         = 0x100  // Bit WAITINT.
	SDIO_CMD_WAITRESP_Pos    = 0x6    // Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk    = 0xc0   // Bit mask of WAITRESP field.
	SDIO_CMD_CMDINDEX_Pos    = 0x0    // Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk    = 0x3f   // Bit mask of CMDINDEX field.

	// RESPCMD: command response register
	SDIO_RESPCMD_RESPCMD_Pos = 0x0  // Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f // Bit mask of RESPCMD field.

	// RESP1: response 1..4 register
	SDIO_RESP1_CARDSTATUS1_Pos = 0x0        // Position of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Msk = 0xffffffff // Bit mask of CARDSTATUS1 field.

	// RESP2: response 1..4 register
	SDIO_RESP2_CARDSTATUS2_Pos = 0x0        // Position of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Msk = 0xffffffff // Bit mask of CARDSTATUS2 field.

	// RESP3: response 1..4 register
	SDIO_RESP3_CARDSTATUS3_Pos = 0x0        // Position of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Msk = 0xffffffff // Bit mask of CARDSTATUS3 field.

	// RESP4: response 1..4 register
	SDIO_RESP4_CARDSTATUS4_Pos = 0x0        // Position of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Msk = 0xffffffff // Bit mask of CARDSTATUS4 field.

	// DTIMER: data timer register
	SDIO_DTIMER_DATATIME_Pos = 0x0        // Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff // Bit mask of DATATIME field.

	// DLEN: data length register
	SDIO_DLEN_DATALENGTH_Pos = 0x0       // Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff // Bit mask of DATALENGTH field.

	// DCTRL: data control register
	SDIO_DCTRL_SDIOEN_Pos     = 0xb   // Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk     = 0x800 // Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN         = 0x800 // Bit SDIOEN.
	SDIO_DCTRL_RWMOD_Pos      = 0xa   // Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk      = 0x400 // Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD          = 0x400 // Bit RWMOD.
	SDIO_DCTRL_RWSTOP_Pos     = 0x9   // Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk     = 0x200 // Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP         = 0x200 // Bit RWSTOP.
	SDIO_DCTRL_RWSTART_Pos    = 0x8   // Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk    = 0x100 // Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART        = 0x100 // Bit RWSTART.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4   // Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0  // Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DMAEN_Pos      = 0x3   // Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk      = 0x8   // Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN          = 0x8   // Bit DMAEN.
	SDIO_DCTRL_DTMODE_Pos     = 0x2   // Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk     = 0x4   // Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE         = 0x4   // Bit DTMODE.
	SDIO_DCTRL_DTDIR_Pos      = 0x1   // Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk      = 0x2   // Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR          = 0x2   // Bit DTDIR.
	SDIO_DCTRL_DTEN_Pos       = 0x0   // Position of DTEN field.
	SDIO_DCTRL_DTEN_Msk       = 0x1   // Bit mask of DTEN field.
	SDIO_DCTRL_DTEN           = 0x1   // Bit DTEN.

	// DCOUNT: data counter register
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0       // Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff // Bit mask of DATACOUNT field.

	// STA: status register
	SDIO_STA_CEATAEND_Pos = 0x17     // Position of CEATAEND field.
	SDIO_STA_CEATAEND_Msk = 0x800000 // Bit mask of CEATAEND field.
	SDIO_STA_CEATAEND     = 0x800000 // Bit CEATAEND.
	SDIO_STA_SDIOIT_Pos   = 0x16     // Position of SDIOIT field.
	SDIO_STA_SDIOIT_Msk   = 0x400000 // Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT       = 0x400000 // Bit SDIOIT.
	SDIO_STA_RXDAVL_Pos   = 0x15     // Position of RXDAVL field.
	SDIO_STA_RXDAVL_Msk   = 0x200000 // Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL       = 0x200000 // Bit RXDAVL.
	SDIO_STA_TXDAVL_Pos   = 0x14     // Position of TXDAVL field.
	SDIO_STA_TXDAVL_Msk   = 0x100000 // Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL       = 0x100000 // Bit TXDAVL.
	SDIO_STA_RXFIFOE_Pos  = 0x13     // Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk  = 0x80000  // Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE      = 0x80000  // Bit RXFIFOE.
	SDIO_STA_TXFIFOE_Pos  = 0x12     // Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk  = 0x40000  // Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE      = 0x40000  // Bit TXFIFOE.
	SDIO_STA_RXFIFOF_Pos  = 0x11     // Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk  = 0x20000  // Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF      = 0x20000  // Bit RXFIFOF.
	SDIO_STA_TXFIFOF_Pos  = 0x10     // Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk  = 0x10000  // Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF      = 0x10000  // Bit TXFIFOF.
	SDIO_STA_RXFIFOHF_Pos = 0xf      // Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000   // Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF     = 0x8000   // Bit RXFIFOHF.
	SDIO_STA_TXFIFOHE_Pos = 0xe      // Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000   // Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE     = 0x4000   // Bit TXFIFOHE.
	SDIO_STA_RXACT_Pos    = 0xd      // Position of RXACT field.
	SDIO_STA_RXACT_Msk    = 0x2000   // Bit mask of RXACT field.
	SDIO_STA_RXACT        = 0x2000   // Bit RXACT.
	SDIO_STA_TXACT_Pos    = 0xc      // Position of TXACT field.
	SDIO_STA_TXACT_Msk    = 0x1000   // Bit mask of TXACT field.
	SDIO_STA_TXACT        = 0x1000   // Bit TXACT.
	SDIO_STA_CMDACT_Pos   = 0xb      // Position of CMDACT field.
	SDIO_STA_CMDACT_Msk   = 0x800    // Bit mask of CMDACT field.
	SDIO_STA_CMDACT       = 0x800    // Bit CMDACT.
	SDIO_STA_DBCKEND_Pos  = 0xa      // Position of DBCKEND field.
	SDIO_STA_DBCKEND_Msk  = 0x400    // Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND      = 0x400    // Bit DBCKEND.
	SDIO_STA_STBITERR_Pos = 0x9      // Position of STBITERR field.
	SDIO_STA_STBITERR_Msk = 0x200    // Bit mask of STBITERR field.
	SDIO_STA_STBITERR     = 0x200    // Bit STBITERR.
	SDIO_STA_DATAEND_Pos  = 0x8      // Position of DATAEND field.
	SDIO_STA_DATAEND_Msk  = 0x100    // Bit mask of DATAEND field.
	SDIO_STA_DATAEND      = 0x100    // Bit DATAEND.
	SDIO_STA_CMDSENT_Pos  = 0x7      // Position of CMDSENT field.
	SDIO_STA_CMDSENT_Msk  = 0x80     // Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT      = 0x80     // Bit CMDSENT.
	SDIO_STA_CMDREND_Pos  = 0x6      // Position of CMDREND field.
	SDIO_STA_CMDREND_Msk  = 0x40     // Bit mask of CMDREND field.
	SDIO_STA_CMDREND      = 0x40     // Bit CMDREND.
	SDIO_STA_RXOVERR_Pos  = 0x5      // Position of RXOVERR field.
	SDIO_STA_RXOVERR_Msk  = 0x20     // Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR      = 0x20     // Bit RXOVERR.
	SDIO_STA_TXUNDERR_Pos = 0x4      // Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10     // Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR     = 0x10     // Bit TXUNDERR.
	SDIO_STA_DTIMEOUT_Pos = 0x3      // Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8      // Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT     = 0x8      // Bit DTIMEOUT.
	SDIO_STA_CTIMEOUT_Pos = 0x2      // Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4      // Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT     = 0x4      // Bit CTIMEOUT.
	SDIO_STA_DCRCFAIL_Pos = 0x1      // Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2      // Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL     = 0x2      // Bit DCRCFAIL.
	SDIO_STA_CCRCFAIL_Pos = 0x0      // Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1      // Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL     = 0x1      // Bit CCRCFAIL.

	// ICR: interrupt clear register
	SDIO_ICR_CEATAENDC_Pos = 0x17     // Position of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Msk = 0x800000 // Bit mask of CEATAENDC field.
	SDIO_ICR_CEATAENDC     = 0x800000 // Bit CEATAENDC.
	SDIO_ICR_SDIOITC_Pos   = 0x16     // Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk   = 0x400000 // Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC       = 0x400000 // Bit SDIOITC.
	SDIO_ICR_DBCKENDC_Pos  = 0xa      // Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk  = 0x400    // Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC      = 0x400    // Bit DBCKENDC.
	SDIO_ICR_STBITERRC_Pos = 0x9      // Position of STBITERRC field.
	SDIO_ICR_STBITERRC_Msk = 0x200    // Bit mask of STBITERRC field.
	SDIO_ICR_STBITERRC     = 0x200    // Bit STBITERRC.
	SDIO_ICR_DATAENDC_Pos  = 0x8      // Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk  = 0x100    // Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC      = 0x100    // Bit DATAENDC.
	SDIO_ICR_CMDSENTC_Pos  = 0x7      // Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk  = 0x80     // Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC      = 0x80     // Bit CMDSENTC.
	SDIO_ICR_CMDRENDC_Pos  = 0x6      // Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk  = 0x40     // Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC      = 0x40     // Bit CMDRENDC.
	SDIO_ICR_RXOVERRC_Pos  = 0x5      // Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk  = 0x20     // Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC      = 0x20     // Bit RXOVERRC.
	SDIO_ICR_TXUNDERRC_Pos = 0x4      // Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10     // Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC     = 0x10     // Bit TXUNDERRC.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3      // Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8      // Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC     = 0x8      // Bit DTIMEOUTC.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2      // Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4      // Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC     = 0x4      // Bit CTIMEOUTC.
	SDIO_ICR_DCRCFAILC_Pos = 0x1      // Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2      // Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC     = 0x2      // Bit DCRCFAILC.
	SDIO_ICR_CCRCFAILC_Pos = 0x0      // Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1      // Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC     = 0x1      // Bit CCRCFAILC.

	// MASK: mask register
	SDIO_MASK_CEATAENDIE_Pos = 0x17     // Position of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Msk = 0x800000 // Bit mask of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE     = 0x800000 // Bit CEATAENDIE.
	SDIO_MASK_SDIOITIE_Pos   = 0x16     // Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk   = 0x400000 // Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE       = 0x400000 // Bit SDIOITIE.
	SDIO_MASK_RXDAVLIE_Pos   = 0x15     // Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk   = 0x200000 // Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE       = 0x200000 // Bit RXDAVLIE.
	SDIO_MASK_TXDAVLIE_Pos   = 0x14     // Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk   = 0x100000 // Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE       = 0x100000 // Bit TXDAVLIE.
	SDIO_MASK_RXFIFOEIE_Pos  = 0x13     // Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk  = 0x80000  // Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE      = 0x80000  // Bit RXFIFOEIE.
	SDIO_MASK_TXFIFOEIE_Pos  = 0x12     // Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk  = 0x40000  // Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE      = 0x40000  // Bit TXFIFOEIE.
	SDIO_MASK_RXFIFOFIE_Pos  = 0x11     // Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk  = 0x20000  // Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE      = 0x20000  // Bit RXFIFOFIE.
	SDIO_MASK_TXFIFOFIE_Pos  = 0x10     // Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk  = 0x10000  // Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE      = 0x10000  // Bit TXFIFOFIE.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf      // Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000   // Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE     = 0x8000   // Bit RXFIFOHFIE.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe      // Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000   // Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE     = 0x4000   // Bit TXFIFOHEIE.
	SDIO_MASK_RXACTIE_Pos    = 0xd      // Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk    = 0x2000   // Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE        = 0x2000   // Bit RXACTIE.
	SDIO_MASK_TXACTIE_Pos    = 0xc      // Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk    = 0x1000   // Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE        = 0x1000   // Bit TXACTIE.
	SDIO_MASK_CMDACTIE_Pos   = 0xb      // Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk   = 0x800    // Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE       = 0x800    // Bit CMDACTIE.
	SDIO_MASK_DBCKENDIE_Pos  = 0xa      // Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk  = 0x400    // Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE      = 0x400    // Bit DBCKENDIE.
	SDIO_MASK_STBITERRIE_Pos = 0x9      // Position of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Msk = 0x200    // Bit mask of STBITERRIE field.
	SDIO_MASK_STBITERRIE     = 0x200    // Bit STBITERRIE.
	SDIO_MASK_DATAENDIE_Pos  = 0x8      // Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk  = 0x100    // Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE      = 0x100    // Bit DATAENDIE.
	SDIO_MASK_CMDSENTIE_Pos  = 0x7      // Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk  = 0x80     // Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE      = 0x80     // Bit CMDSENTIE.
	SDIO_MASK_CMDRENDIE_Pos  = 0x6      // Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk  = 0x40     // Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE      = 0x40     // Bit CMDRENDIE.
	SDIO_MASK_RXOVERRIE_Pos  = 0x5      // Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk  = 0x20     // Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE      = 0x20     // Bit RXOVERRIE.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4      // Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10     // Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE     = 0x10     // Bit TXUNDERRIE.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3      // Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8      // Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE     = 0x8      // Bit DTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2      // Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4      // Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE     = 0x4      // Bit CTIMEOUTIE.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1      // Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2      // Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE     = 0x2      // Bit DCRCFAILIE.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0      // Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1      // Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE     = 0x1      // Bit CCRCFAILIE.

	// FIFOCNT: FIFO counter register
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0      // Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff // Bit mask of FIFOCOUNT field.

	// FIFO: data FIFO register
	SDIO_FIFO_FIFOData_Pos = 0x0        // Position of FIFOData field.
	SDIO_FIFO_FIFOData_Msk = 0xffffffff // Bit mask of FIFOData field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR1: Interrupt mask register
	EXTI_IMR1_MR0_Pos  = 0x0        // Position of MR0 field.
	EXTI_IMR1_MR0_Msk  = 0x1        // Bit mask of MR0 field.
	EXTI_IMR1_MR0      = 0x1        // Bit MR0.
	EXTI_IMR1_MR1_Pos  = 0x1        // Position of MR1 field.
	EXTI_IMR1_MR1_Msk  = 0x2        // Bit mask of MR1 field.
	EXTI_IMR1_MR1      = 0x2        // Bit MR1.
	EXTI_IMR1_MR2_Pos  = 0x2        // Position of MR2 field.
	EXTI_IMR1_MR2_Msk  = 0x4        // Bit mask of MR2 field.
	EXTI_IMR1_MR2      = 0x4        // Bit MR2.
	EXTI_IMR1_MR3_Pos  = 0x3        // Position of MR3 field.
	EXTI_IMR1_MR3_Msk  = 0x8        // Bit mask of MR3 field.
	EXTI_IMR1_MR3      = 0x8        // Bit MR3.
	EXTI_IMR1_MR4_Pos  = 0x4        // Position of MR4 field.
	EXTI_IMR1_MR4_Msk  = 0x10       // Bit mask of MR4 field.
	EXTI_IMR1_MR4      = 0x10       // Bit MR4.
	EXTI_IMR1_MR5_Pos  = 0x5        // Position of MR5 field.
	EXTI_IMR1_MR5_Msk  = 0x20       // Bit mask of MR5 field.
	EXTI_IMR1_MR5      = 0x20       // Bit MR5.
	EXTI_IMR1_MR6_Pos  = 0x6        // Position of MR6 field.
	EXTI_IMR1_MR6_Msk  = 0x40       // Bit mask of MR6 field.
	EXTI_IMR1_MR6      = 0x40       // Bit MR6.
	EXTI_IMR1_MR7_Pos  = 0x7        // Position of MR7 field.
	EXTI_IMR1_MR7_Msk  = 0x80       // Bit mask of MR7 field.
	EXTI_IMR1_MR7      = 0x80       // Bit MR7.
	EXTI_IMR1_MR8_Pos  = 0x8        // Position of MR8 field.
	EXTI_IMR1_MR8_Msk  = 0x100      // Bit mask of MR8 field.
	EXTI_IMR1_MR8      = 0x100      // Bit MR8.
	EXTI_IMR1_MR9_Pos  = 0x9        // Position of MR9 field.
	EXTI_IMR1_MR9_Msk  = 0x200      // Bit mask of MR9 field.
	EXTI_IMR1_MR9      = 0x200      // Bit MR9.
	EXTI_IMR1_MR10_Pos = 0xa        // Position of MR10 field.
	EXTI_IMR1_MR10_Msk = 0x400      // Bit mask of MR10 field.
	EXTI_IMR1_MR10     = 0x400      // Bit MR10.
	EXTI_IMR1_MR11_Pos = 0xb        // Position of MR11 field.
	EXTI_IMR1_MR11_Msk = 0x800      // Bit mask of MR11 field.
	EXTI_IMR1_MR11     = 0x800      // Bit MR11.
	EXTI_IMR1_MR12_Pos = 0xc        // Position of MR12 field.
	EXTI_IMR1_MR12_Msk = 0x1000     // Bit mask of MR12 field.
	EXTI_IMR1_MR12     = 0x1000     // Bit MR12.
	EXTI_IMR1_MR13_Pos = 0xd        // Position of MR13 field.
	EXTI_IMR1_MR13_Msk = 0x2000     // Bit mask of MR13 field.
	EXTI_IMR1_MR13     = 0x2000     // Bit MR13.
	EXTI_IMR1_MR14_Pos = 0xe        // Position of MR14 field.
	EXTI_IMR1_MR14_Msk = 0x4000     // Bit mask of MR14 field.
	EXTI_IMR1_MR14     = 0x4000     // Bit MR14.
	EXTI_IMR1_MR15_Pos = 0xf        // Position of MR15 field.
	EXTI_IMR1_MR15_Msk = 0x8000     // Bit mask of MR15 field.
	EXTI_IMR1_MR15     = 0x8000     // Bit MR15.
	EXTI_IMR1_MR16_Pos = 0x10       // Position of MR16 field.
	EXTI_IMR1_MR16_Msk = 0x10000    // Bit mask of MR16 field.
	EXTI_IMR1_MR16     = 0x10000    // Bit MR16.
	EXTI_IMR1_MR17_Pos = 0x11       // Position of MR17 field.
	EXTI_IMR1_MR17_Msk = 0x20000    // Bit mask of MR17 field.
	EXTI_IMR1_MR17     = 0x20000    // Bit MR17.
	EXTI_IMR1_MR18_Pos = 0x12       // Position of MR18 field.
	EXTI_IMR1_MR18_Msk = 0x40000    // Bit mask of MR18 field.
	EXTI_IMR1_MR18     = 0x40000    // Bit MR18.
	EXTI_IMR1_MR19_Pos = 0x13       // Position of MR19 field.
	EXTI_IMR1_MR19_Msk = 0x80000    // Bit mask of MR19 field.
	EXTI_IMR1_MR19     = 0x80000    // Bit MR19.
	EXTI_IMR1_MR20_Pos = 0x14       // Position of MR20 field.
	EXTI_IMR1_MR20_Msk = 0x100000   // Bit mask of MR20 field.
	EXTI_IMR1_MR20     = 0x100000   // Bit MR20.
	EXTI_IMR1_MR21_Pos = 0x15       // Position of MR21 field.
	EXTI_IMR1_MR21_Msk = 0x200000   // Bit mask of MR21 field.
	EXTI_IMR1_MR21     = 0x200000   // Bit MR21.
	EXTI_IMR1_MR22_Pos = 0x16       // Position of MR22 field.
	EXTI_IMR1_MR22_Msk = 0x400000   // Bit mask of MR22 field.
	EXTI_IMR1_MR22     = 0x400000   // Bit MR22.
	EXTI_IMR1_MR23_Pos = 0x17       // Position of MR23 field.
	EXTI_IMR1_MR23_Msk = 0x800000   // Bit mask of MR23 field.
	EXTI_IMR1_MR23     = 0x800000   // Bit MR23.
	EXTI_IMR1_MR24_Pos = 0x18       // Position of MR24 field.
	EXTI_IMR1_MR24_Msk = 0x1000000  // Bit mask of MR24 field.
	EXTI_IMR1_MR24     = 0x1000000  // Bit MR24.
	EXTI_IMR1_MR25_Pos = 0x19       // Position of MR25 field.
	EXTI_IMR1_MR25_Msk = 0x2000000  // Bit mask of MR25 field.
	EXTI_IMR1_MR25     = 0x2000000  // Bit MR25.
	EXTI_IMR1_MR26_Pos = 0x1a       // Position of MR26 field.
	EXTI_IMR1_MR26_Msk = 0x4000000  // Bit mask of MR26 field.
	EXTI_IMR1_MR26     = 0x4000000  // Bit MR26.
	EXTI_IMR1_MR27_Pos = 0x1b       // Position of MR27 field.
	EXTI_IMR1_MR27_Msk = 0x8000000  // Bit mask of MR27 field.
	EXTI_IMR1_MR27     = 0x8000000  // Bit MR27.
	EXTI_IMR1_MR28_Pos = 0x1c       // Position of MR28 field.
	EXTI_IMR1_MR28_Msk = 0x10000000 // Bit mask of MR28 field.
	EXTI_IMR1_MR28     = 0x10000000 // Bit MR28.
	EXTI_IMR1_MR29_Pos = 0x1d       // Position of MR29 field.
	EXTI_IMR1_MR29_Msk = 0x20000000 // Bit mask of MR29 field.
	EXTI_IMR1_MR29     = 0x20000000 // Bit MR29.
	EXTI_IMR1_MR30_Pos = 0x1e       // Position of MR30 field.
	EXTI_IMR1_MR30_Msk = 0x40000000 // Bit mask of MR30 field.
	EXTI_IMR1_MR30     = 0x40000000 // Bit MR30.
	EXTI_IMR1_MR31_Pos = 0x1f       // Position of MR31 field.
	EXTI_IMR1_MR31_Msk = 0x80000000 // Bit mask of MR31 field.
	EXTI_IMR1_MR31     = 0x80000000 // Bit MR31.

	// EMR1: Event mask register
	EXTI_EMR1_MR0_Pos  = 0x0        // Position of MR0 field.
	EXTI_EMR1_MR0_Msk  = 0x1        // Bit mask of MR0 field.
	EXTI_EMR1_MR0      = 0x1        // Bit MR0.
	EXTI_EMR1_MR1_Pos  = 0x1        // Position of MR1 field.
	EXTI_EMR1_MR1_Msk  = 0x2        // Bit mask of MR1 field.
	EXTI_EMR1_MR1      = 0x2        // Bit MR1.
	EXTI_EMR1_MR2_Pos  = 0x2        // Position of MR2 field.
	EXTI_EMR1_MR2_Msk  = 0x4        // Bit mask of MR2 field.
	EXTI_EMR1_MR2      = 0x4        // Bit MR2.
	EXTI_EMR1_MR3_Pos  = 0x3        // Position of MR3 field.
	EXTI_EMR1_MR3_Msk  = 0x8        // Bit mask of MR3 field.
	EXTI_EMR1_MR3      = 0x8        // Bit MR3.
	EXTI_EMR1_MR4_Pos  = 0x4        // Position of MR4 field.
	EXTI_EMR1_MR4_Msk  = 0x10       // Bit mask of MR4 field.
	EXTI_EMR1_MR4      = 0x10       // Bit MR4.
	EXTI_EMR1_MR5_Pos  = 0x5        // Position of MR5 field.
	EXTI_EMR1_MR5_Msk  = 0x20       // Bit mask of MR5 field.
	EXTI_EMR1_MR5      = 0x20       // Bit MR5.
	EXTI_EMR1_MR6_Pos  = 0x6        // Position of MR6 field.
	EXTI_EMR1_MR6_Msk  = 0x40       // Bit mask of MR6 field.
	EXTI_EMR1_MR6      = 0x40       // Bit MR6.
	EXTI_EMR1_MR7_Pos  = 0x7        // Position of MR7 field.
	EXTI_EMR1_MR7_Msk  = 0x80       // Bit mask of MR7 field.
	EXTI_EMR1_MR7      = 0x80       // Bit MR7.
	EXTI_EMR1_MR8_Pos  = 0x8        // Position of MR8 field.
	EXTI_EMR1_MR8_Msk  = 0x100      // Bit mask of MR8 field.
	EXTI_EMR1_MR8      = 0x100      // Bit MR8.
	EXTI_EMR1_MR9_Pos  = 0x9        // Position of MR9 field.
	EXTI_EMR1_MR9_Msk  = 0x200      // Bit mask of MR9 field.
	EXTI_EMR1_MR9      = 0x200      // Bit MR9.
	EXTI_EMR1_MR10_Pos = 0xa        // Position of MR10 field.
	EXTI_EMR1_MR10_Msk = 0x400      // Bit mask of MR10 field.
	EXTI_EMR1_MR10     = 0x400      // Bit MR10.
	EXTI_EMR1_MR11_Pos = 0xb        // Position of MR11 field.
	EXTI_EMR1_MR11_Msk = 0x800      // Bit mask of MR11 field.
	EXTI_EMR1_MR11     = 0x800      // Bit MR11.
	EXTI_EMR1_MR12_Pos = 0xc        // Position of MR12 field.
	EXTI_EMR1_MR12_Msk = 0x1000     // Bit mask of MR12 field.
	EXTI_EMR1_MR12     = 0x1000     // Bit MR12.
	EXTI_EMR1_MR13_Pos = 0xd        // Position of MR13 field.
	EXTI_EMR1_MR13_Msk = 0x2000     // Bit mask of MR13 field.
	EXTI_EMR1_MR13     = 0x2000     // Bit MR13.
	EXTI_EMR1_MR14_Pos = 0xe        // Position of MR14 field.
	EXTI_EMR1_MR14_Msk = 0x4000     // Bit mask of MR14 field.
	EXTI_EMR1_MR14     = 0x4000     // Bit MR14.
	EXTI_EMR1_MR15_Pos = 0xf        // Position of MR15 field.
	EXTI_EMR1_MR15_Msk = 0x8000     // Bit mask of MR15 field.
	EXTI_EMR1_MR15     = 0x8000     // Bit MR15.
	EXTI_EMR1_MR16_Pos = 0x10       // Position of MR16 field.
	EXTI_EMR1_MR16_Msk = 0x10000    // Bit mask of MR16 field.
	EXTI_EMR1_MR16     = 0x10000    // Bit MR16.
	EXTI_EMR1_MR17_Pos = 0x11       // Position of MR17 field.
	EXTI_EMR1_MR17_Msk = 0x20000    // Bit mask of MR17 field.
	EXTI_EMR1_MR17     = 0x20000    // Bit MR17.
	EXTI_EMR1_MR18_Pos = 0x12       // Position of MR18 field.
	EXTI_EMR1_MR18_Msk = 0x40000    // Bit mask of MR18 field.
	EXTI_EMR1_MR18     = 0x40000    // Bit MR18.
	EXTI_EMR1_MR19_Pos = 0x13       // Position of MR19 field.
	EXTI_EMR1_MR19_Msk = 0x80000    // Bit mask of MR19 field.
	EXTI_EMR1_MR19     = 0x80000    // Bit MR19.
	EXTI_EMR1_MR20_Pos = 0x14       // Position of MR20 field.
	EXTI_EMR1_MR20_Msk = 0x100000   // Bit mask of MR20 field.
	EXTI_EMR1_MR20     = 0x100000   // Bit MR20.
	EXTI_EMR1_MR21_Pos = 0x15       // Position of MR21 field.
	EXTI_EMR1_MR21_Msk = 0x200000   // Bit mask of MR21 field.
	EXTI_EMR1_MR21     = 0x200000   // Bit MR21.
	EXTI_EMR1_MR22_Pos = 0x16       // Position of MR22 field.
	EXTI_EMR1_MR22_Msk = 0x400000   // Bit mask of MR22 field.
	EXTI_EMR1_MR22     = 0x400000   // Bit MR22.
	EXTI_EMR1_MR23_Pos = 0x17       // Position of MR23 field.
	EXTI_EMR1_MR23_Msk = 0x800000   // Bit mask of MR23 field.
	EXTI_EMR1_MR23     = 0x800000   // Bit MR23.
	EXTI_EMR1_MR24_Pos = 0x18       // Position of MR24 field.
	EXTI_EMR1_MR24_Msk = 0x1000000  // Bit mask of MR24 field.
	EXTI_EMR1_MR24     = 0x1000000  // Bit MR24.
	EXTI_EMR1_MR25_Pos = 0x19       // Position of MR25 field.
	EXTI_EMR1_MR25_Msk = 0x2000000  // Bit mask of MR25 field.
	EXTI_EMR1_MR25     = 0x2000000  // Bit MR25.
	EXTI_EMR1_MR26_Pos = 0x1a       // Position of MR26 field.
	EXTI_EMR1_MR26_Msk = 0x4000000  // Bit mask of MR26 field.
	EXTI_EMR1_MR26     = 0x4000000  // Bit MR26.
	EXTI_EMR1_MR27_Pos = 0x1b       // Position of MR27 field.
	EXTI_EMR1_MR27_Msk = 0x8000000  // Bit mask of MR27 field.
	EXTI_EMR1_MR27     = 0x8000000  // Bit MR27.
	EXTI_EMR1_MR28_Pos = 0x1c       // Position of MR28 field.
	EXTI_EMR1_MR28_Msk = 0x10000000 // Bit mask of MR28 field.
	EXTI_EMR1_MR28     = 0x10000000 // Bit MR28.
	EXTI_EMR1_MR29_Pos = 0x1d       // Position of MR29 field.
	EXTI_EMR1_MR29_Msk = 0x20000000 // Bit mask of MR29 field.
	EXTI_EMR1_MR29     = 0x20000000 // Bit MR29.
	EXTI_EMR1_MR30_Pos = 0x1e       // Position of MR30 field.
	EXTI_EMR1_MR30_Msk = 0x40000000 // Bit mask of MR30 field.
	EXTI_EMR1_MR30     = 0x40000000 // Bit MR30.
	EXTI_EMR1_MR31_Pos = 0x1f       // Position of MR31 field.
	EXTI_EMR1_MR31_Msk = 0x80000000 // Bit mask of MR31 field.
	EXTI_EMR1_MR31     = 0x80000000 // Bit MR31.

	// RTSR1: Rising Trigger selection           register
	EXTI_RTSR1_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_RTSR1_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_RTSR1_TR0      = 0x1      // Bit TR0.
	EXTI_RTSR1_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_RTSR1_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_RTSR1_TR1      = 0x2      // Bit TR1.
	EXTI_RTSR1_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_RTSR1_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_RTSR1_TR2      = 0x4      // Bit TR2.
	EXTI_RTSR1_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_RTSR1_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_RTSR1_TR3      = 0x8      // Bit TR3.
	EXTI_RTSR1_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_RTSR1_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_RTSR1_TR4      = 0x10     // Bit TR4.
	EXTI_RTSR1_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_RTSR1_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_RTSR1_TR5      = 0x20     // Bit TR5.
	EXTI_RTSR1_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_RTSR1_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_RTSR1_TR6      = 0x40     // Bit TR6.
	EXTI_RTSR1_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_RTSR1_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_RTSR1_TR7      = 0x80     // Bit TR7.
	EXTI_RTSR1_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_RTSR1_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_RTSR1_TR8      = 0x100    // Bit TR8.
	EXTI_RTSR1_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_RTSR1_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_RTSR1_TR9      = 0x200    // Bit TR9.
	EXTI_RTSR1_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_RTSR1_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_RTSR1_TR10     = 0x400    // Bit TR10.
	EXTI_RTSR1_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_RTSR1_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_RTSR1_TR11     = 0x800    // Bit TR11.
	EXTI_RTSR1_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_RTSR1_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_RTSR1_TR12     = 0x1000   // Bit TR12.
	EXTI_RTSR1_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_RTSR1_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_RTSR1_TR13     = 0x2000   // Bit TR13.
	EXTI_RTSR1_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_RTSR1_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_RTSR1_TR14     = 0x4000   // Bit TR14.
	EXTI_RTSR1_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_RTSR1_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_RTSR1_TR15     = 0x8000   // Bit TR15.
	EXTI_RTSR1_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_RTSR1_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_RTSR1_TR16     = 0x10000  // Bit TR16.
	EXTI_RTSR1_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_RTSR1_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_RTSR1_TR18     = 0x40000  // Bit TR18.
	EXTI_RTSR1_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_RTSR1_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_RTSR1_TR19     = 0x80000  // Bit TR19.
	EXTI_RTSR1_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_RTSR1_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_RTSR1_TR20     = 0x100000 // Bit TR20.
	EXTI_RTSR1_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_RTSR1_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_RTSR1_TR21     = 0x200000 // Bit TR21.
	EXTI_RTSR1_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_RTSR1_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_RTSR1_TR22     = 0x400000 // Bit TR22.

	// FTSR1: Falling Trigger selection           register
	EXTI_FTSR1_TR0_Pos  = 0x0      // Position of TR0 field.
	EXTI_FTSR1_TR0_Msk  = 0x1      // Bit mask of TR0 field.
	EXTI_FTSR1_TR0      = 0x1      // Bit TR0.
	EXTI_FTSR1_TR1_Pos  = 0x1      // Position of TR1 field.
	EXTI_FTSR1_TR1_Msk  = 0x2      // Bit mask of TR1 field.
	EXTI_FTSR1_TR1      = 0x2      // Bit TR1.
	EXTI_FTSR1_TR2_Pos  = 0x2      // Position of TR2 field.
	EXTI_FTSR1_TR2_Msk  = 0x4      // Bit mask of TR2 field.
	EXTI_FTSR1_TR2      = 0x4      // Bit TR2.
	EXTI_FTSR1_TR3_Pos  = 0x3      // Position of TR3 field.
	EXTI_FTSR1_TR3_Msk  = 0x8      // Bit mask of TR3 field.
	EXTI_FTSR1_TR3      = 0x8      // Bit TR3.
	EXTI_FTSR1_TR4_Pos  = 0x4      // Position of TR4 field.
	EXTI_FTSR1_TR4_Msk  = 0x10     // Bit mask of TR4 field.
	EXTI_FTSR1_TR4      = 0x10     // Bit TR4.
	EXTI_FTSR1_TR5_Pos  = 0x5      // Position of TR5 field.
	EXTI_FTSR1_TR5_Msk  = 0x20     // Bit mask of TR5 field.
	EXTI_FTSR1_TR5      = 0x20     // Bit TR5.
	EXTI_FTSR1_TR6_Pos  = 0x6      // Position of TR6 field.
	EXTI_FTSR1_TR6_Msk  = 0x40     // Bit mask of TR6 field.
	EXTI_FTSR1_TR6      = 0x40     // Bit TR6.
	EXTI_FTSR1_TR7_Pos  = 0x7      // Position of TR7 field.
	EXTI_FTSR1_TR7_Msk  = 0x80     // Bit mask of TR7 field.
	EXTI_FTSR1_TR7      = 0x80     // Bit TR7.
	EXTI_FTSR1_TR8_Pos  = 0x8      // Position of TR8 field.
	EXTI_FTSR1_TR8_Msk  = 0x100    // Bit mask of TR8 field.
	EXTI_FTSR1_TR8      = 0x100    // Bit TR8.
	EXTI_FTSR1_TR9_Pos  = 0x9      // Position of TR9 field.
	EXTI_FTSR1_TR9_Msk  = 0x200    // Bit mask of TR9 field.
	EXTI_FTSR1_TR9      = 0x200    // Bit TR9.
	EXTI_FTSR1_TR10_Pos = 0xa      // Position of TR10 field.
	EXTI_FTSR1_TR10_Msk = 0x400    // Bit mask of TR10 field.
	EXTI_FTSR1_TR10     = 0x400    // Bit TR10.
	EXTI_FTSR1_TR11_Pos = 0xb      // Position of TR11 field.
	EXTI_FTSR1_TR11_Msk = 0x800    // Bit mask of TR11 field.
	EXTI_FTSR1_TR11     = 0x800    // Bit TR11.
	EXTI_FTSR1_TR12_Pos = 0xc      // Position of TR12 field.
	EXTI_FTSR1_TR12_Msk = 0x1000   // Bit mask of TR12 field.
	EXTI_FTSR1_TR12     = 0x1000   // Bit TR12.
	EXTI_FTSR1_TR13_Pos = 0xd      // Position of TR13 field.
	EXTI_FTSR1_TR13_Msk = 0x2000   // Bit mask of TR13 field.
	EXTI_FTSR1_TR13     = 0x2000   // Bit TR13.
	EXTI_FTSR1_TR14_Pos = 0xe      // Position of TR14 field.
	EXTI_FTSR1_TR14_Msk = 0x4000   // Bit mask of TR14 field.
	EXTI_FTSR1_TR14     = 0x4000   // Bit TR14.
	EXTI_FTSR1_TR15_Pos = 0xf      // Position of TR15 field.
	EXTI_FTSR1_TR15_Msk = 0x8000   // Bit mask of TR15 field.
	EXTI_FTSR1_TR15     = 0x8000   // Bit TR15.
	EXTI_FTSR1_TR16_Pos = 0x10     // Position of TR16 field.
	EXTI_FTSR1_TR16_Msk = 0x10000  // Bit mask of TR16 field.
	EXTI_FTSR1_TR16     = 0x10000  // Bit TR16.
	EXTI_FTSR1_TR18_Pos = 0x12     // Position of TR18 field.
	EXTI_FTSR1_TR18_Msk = 0x40000  // Bit mask of TR18 field.
	EXTI_FTSR1_TR18     = 0x40000  // Bit TR18.
	EXTI_FTSR1_TR19_Pos = 0x13     // Position of TR19 field.
	EXTI_FTSR1_TR19_Msk = 0x80000  // Bit mask of TR19 field.
	EXTI_FTSR1_TR19     = 0x80000  // Bit TR19.
	EXTI_FTSR1_TR20_Pos = 0x14     // Position of TR20 field.
	EXTI_FTSR1_TR20_Msk = 0x100000 // Bit mask of TR20 field.
	EXTI_FTSR1_TR20     = 0x100000 // Bit TR20.
	EXTI_FTSR1_TR21_Pos = 0x15     // Position of TR21 field.
	EXTI_FTSR1_TR21_Msk = 0x200000 // Bit mask of TR21 field.
	EXTI_FTSR1_TR21     = 0x200000 // Bit TR21.
	EXTI_FTSR1_TR22_Pos = 0x16     // Position of TR22 field.
	EXTI_FTSR1_TR22_Msk = 0x400000 // Bit mask of TR22 field.
	EXTI_FTSR1_TR22     = 0x400000 // Bit TR22.

	// SWIER1: Software interrupt event           register
	EXTI_SWIER1_SWIER0_Pos  = 0x0      // Position of SWIER0 field.
	EXTI_SWIER1_SWIER0_Msk  = 0x1      // Bit mask of SWIER0 field.
	EXTI_SWIER1_SWIER0      = 0x1      // Bit SWIER0.
	EXTI_SWIER1_SWIER1_Pos  = 0x1      // Position of SWIER1 field.
	EXTI_SWIER1_SWIER1_Msk  = 0x2      // Bit mask of SWIER1 field.
	EXTI_SWIER1_SWIER1      = 0x2      // Bit SWIER1.
	EXTI_SWIER1_SWIER2_Pos  = 0x2      // Position of SWIER2 field.
	EXTI_SWIER1_SWIER2_Msk  = 0x4      // Bit mask of SWIER2 field.
	EXTI_SWIER1_SWIER2      = 0x4      // Bit SWIER2.
	EXTI_SWIER1_SWIER3_Pos  = 0x3      // Position of SWIER3 field.
	EXTI_SWIER1_SWIER3_Msk  = 0x8      // Bit mask of SWIER3 field.
	EXTI_SWIER1_SWIER3      = 0x8      // Bit SWIER3.
	EXTI_SWIER1_SWIER4_Pos  = 0x4      // Position of SWIER4 field.
	EXTI_SWIER1_SWIER4_Msk  = 0x10     // Bit mask of SWIER4 field.
	EXTI_SWIER1_SWIER4      = 0x10     // Bit SWIER4.
	EXTI_SWIER1_SWIER5_Pos  = 0x5      // Position of SWIER5 field.
	EXTI_SWIER1_SWIER5_Msk  = 0x20     // Bit mask of SWIER5 field.
	EXTI_SWIER1_SWIER5      = 0x20     // Bit SWIER5.
	EXTI_SWIER1_SWIER6_Pos  = 0x6      // Position of SWIER6 field.
	EXTI_SWIER1_SWIER6_Msk  = 0x40     // Bit mask of SWIER6 field.
	EXTI_SWIER1_SWIER6      = 0x40     // Bit SWIER6.
	EXTI_SWIER1_SWIER7_Pos  = 0x7      // Position of SWIER7 field.
	EXTI_SWIER1_SWIER7_Msk  = 0x80     // Bit mask of SWIER7 field.
	EXTI_SWIER1_SWIER7      = 0x80     // Bit SWIER7.
	EXTI_SWIER1_SWIER8_Pos  = 0x8      // Position of SWIER8 field.
	EXTI_SWIER1_SWIER8_Msk  = 0x100    // Bit mask of SWIER8 field.
	EXTI_SWIER1_SWIER8      = 0x100    // Bit SWIER8.
	EXTI_SWIER1_SWIER9_Pos  = 0x9      // Position of SWIER9 field.
	EXTI_SWIER1_SWIER9_Msk  = 0x200    // Bit mask of SWIER9 field.
	EXTI_SWIER1_SWIER9      = 0x200    // Bit SWIER9.
	EXTI_SWIER1_SWIER10_Pos = 0xa      // Position of SWIER10 field.
	EXTI_SWIER1_SWIER10_Msk = 0x400    // Bit mask of SWIER10 field.
	EXTI_SWIER1_SWIER10     = 0x400    // Bit SWIER10.
	EXTI_SWIER1_SWIER11_Pos = 0xb      // Position of SWIER11 field.
	EXTI_SWIER1_SWIER11_Msk = 0x800    // Bit mask of SWIER11 field.
	EXTI_SWIER1_SWIER11     = 0x800    // Bit SWIER11.
	EXTI_SWIER1_SWIER12_Pos = 0xc      // Position of SWIER12 field.
	EXTI_SWIER1_SWIER12_Msk = 0x1000   // Bit mask of SWIER12 field.
	EXTI_SWIER1_SWIER12     = 0x1000   // Bit SWIER12.
	EXTI_SWIER1_SWIER13_Pos = 0xd      // Position of SWIER13 field.
	EXTI_SWIER1_SWIER13_Msk = 0x2000   // Bit mask of SWIER13 field.
	EXTI_SWIER1_SWIER13     = 0x2000   // Bit SWIER13.
	EXTI_SWIER1_SWIER14_Pos = 0xe      // Position of SWIER14 field.
	EXTI_SWIER1_SWIER14_Msk = 0x4000   // Bit mask of SWIER14 field.
	EXTI_SWIER1_SWIER14     = 0x4000   // Bit SWIER14.
	EXTI_SWIER1_SWIER15_Pos = 0xf      // Position of SWIER15 field.
	EXTI_SWIER1_SWIER15_Msk = 0x8000   // Bit mask of SWIER15 field.
	EXTI_SWIER1_SWIER15     = 0x8000   // Bit SWIER15.
	EXTI_SWIER1_SWIER16_Pos = 0x10     // Position of SWIER16 field.
	EXTI_SWIER1_SWIER16_Msk = 0x10000  // Bit mask of SWIER16 field.
	EXTI_SWIER1_SWIER16     = 0x10000  // Bit SWIER16.
	EXTI_SWIER1_SWIER18_Pos = 0x12     // Position of SWIER18 field.
	EXTI_SWIER1_SWIER18_Msk = 0x40000  // Bit mask of SWIER18 field.
	EXTI_SWIER1_SWIER18     = 0x40000  // Bit SWIER18.
	EXTI_SWIER1_SWIER19_Pos = 0x13     // Position of SWIER19 field.
	EXTI_SWIER1_SWIER19_Msk = 0x80000  // Bit mask of SWIER19 field.
	EXTI_SWIER1_SWIER19     = 0x80000  // Bit SWIER19.
	EXTI_SWIER1_SWIER20_Pos = 0x14     // Position of SWIER20 field.
	EXTI_SWIER1_SWIER20_Msk = 0x100000 // Bit mask of SWIER20 field.
	EXTI_SWIER1_SWIER20     = 0x100000 // Bit SWIER20.
	EXTI_SWIER1_SWIER21_Pos = 0x15     // Position of SWIER21 field.
	EXTI_SWIER1_SWIER21_Msk = 0x200000 // Bit mask of SWIER21 field.
	EXTI_SWIER1_SWIER21     = 0x200000 // Bit SWIER21.
	EXTI_SWIER1_SWIER22_Pos = 0x16     // Position of SWIER22 field.
	EXTI_SWIER1_SWIER22_Msk = 0x400000 // Bit mask of SWIER22 field.
	EXTI_SWIER1_SWIER22     = 0x400000 // Bit SWIER22.

	// PR1: Pending register
	EXTI_PR1_PR0_Pos  = 0x0      // Position of PR0 field.
	EXTI_PR1_PR0_Msk  = 0x1      // Bit mask of PR0 field.
	EXTI_PR1_PR0      = 0x1      // Bit PR0.
	EXTI_PR1_PR1_Pos  = 0x1      // Position of PR1 field.
	EXTI_PR1_PR1_Msk  = 0x2      // Bit mask of PR1 field.
	EXTI_PR1_PR1      = 0x2      // Bit PR1.
	EXTI_PR1_PR2_Pos  = 0x2      // Position of PR2 field.
	EXTI_PR1_PR2_Msk  = 0x4      // Bit mask of PR2 field.
	EXTI_PR1_PR2      = 0x4      // Bit PR2.
	EXTI_PR1_PR3_Pos  = 0x3      // Position of PR3 field.
	EXTI_PR1_PR3_Msk  = 0x8      // Bit mask of PR3 field.
	EXTI_PR1_PR3      = 0x8      // Bit PR3.
	EXTI_PR1_PR4_Pos  = 0x4      // Position of PR4 field.
	EXTI_PR1_PR4_Msk  = 0x10     // Bit mask of PR4 field.
	EXTI_PR1_PR4      = 0x10     // Bit PR4.
	EXTI_PR1_PR5_Pos  = 0x5      // Position of PR5 field.
	EXTI_PR1_PR5_Msk  = 0x20     // Bit mask of PR5 field.
	EXTI_PR1_PR5      = 0x20     // Bit PR5.
	EXTI_PR1_PR6_Pos  = 0x6      // Position of PR6 field.
	EXTI_PR1_PR6_Msk  = 0x40     // Bit mask of PR6 field.
	EXTI_PR1_PR6      = 0x40     // Bit PR6.
	EXTI_PR1_PR7_Pos  = 0x7      // Position of PR7 field.
	EXTI_PR1_PR7_Msk  = 0x80     // Bit mask of PR7 field.
	EXTI_PR1_PR7      = 0x80     // Bit PR7.
	EXTI_PR1_PR8_Pos  = 0x8      // Position of PR8 field.
	EXTI_PR1_PR8_Msk  = 0x100    // Bit mask of PR8 field.
	EXTI_PR1_PR8      = 0x100    // Bit PR8.
	EXTI_PR1_PR9_Pos  = 0x9      // Position of PR9 field.
	EXTI_PR1_PR9_Msk  = 0x200    // Bit mask of PR9 field.
	EXTI_PR1_PR9      = 0x200    // Bit PR9.
	EXTI_PR1_PR10_Pos = 0xa      // Position of PR10 field.
	EXTI_PR1_PR10_Msk = 0x400    // Bit mask of PR10 field.
	EXTI_PR1_PR10     = 0x400    // Bit PR10.
	EXTI_PR1_PR11_Pos = 0xb      // Position of PR11 field.
	EXTI_PR1_PR11_Msk = 0x800    // Bit mask of PR11 field.
	EXTI_PR1_PR11     = 0x800    // Bit PR11.
	EXTI_PR1_PR12_Pos = 0xc      // Position of PR12 field.
	EXTI_PR1_PR12_Msk = 0x1000   // Bit mask of PR12 field.
	EXTI_PR1_PR12     = 0x1000   // Bit PR12.
	EXTI_PR1_PR13_Pos = 0xd      // Position of PR13 field.
	EXTI_PR1_PR13_Msk = 0x2000   // Bit mask of PR13 field.
	EXTI_PR1_PR13     = 0x2000   // Bit PR13.
	EXTI_PR1_PR14_Pos = 0xe      // Position of PR14 field.
	EXTI_PR1_PR14_Msk = 0x4000   // Bit mask of PR14 field.
	EXTI_PR1_PR14     = 0x4000   // Bit PR14.
	EXTI_PR1_PR15_Pos = 0xf      // Position of PR15 field.
	EXTI_PR1_PR15_Msk = 0x8000   // Bit mask of PR15 field.
	EXTI_PR1_PR15     = 0x8000   // Bit PR15.
	EXTI_PR1_PR16_Pos = 0x10     // Position of PR16 field.
	EXTI_PR1_PR16_Msk = 0x10000  // Bit mask of PR16 field.
	EXTI_PR1_PR16     = 0x10000  // Bit PR16.
	EXTI_PR1_PR18_Pos = 0x12     // Position of PR18 field.
	EXTI_PR1_PR18_Msk = 0x40000  // Bit mask of PR18 field.
	EXTI_PR1_PR18     = 0x40000  // Bit PR18.
	EXTI_PR1_PR19_Pos = 0x13     // Position of PR19 field.
	EXTI_PR1_PR19_Msk = 0x80000  // Bit mask of PR19 field.
	EXTI_PR1_PR19     = 0x80000  // Bit PR19.
	EXTI_PR1_PR20_Pos = 0x14     // Position of PR20 field.
	EXTI_PR1_PR20_Msk = 0x100000 // Bit mask of PR20 field.
	EXTI_PR1_PR20     = 0x100000 // Bit PR20.
	EXTI_PR1_PR21_Pos = 0x15     // Position of PR21 field.
	EXTI_PR1_PR21_Msk = 0x200000 // Bit mask of PR21 field.
	EXTI_PR1_PR21     = 0x200000 // Bit PR21.
	EXTI_PR1_PR22_Pos = 0x16     // Position of PR22 field.
	EXTI_PR1_PR22_Msk = 0x400000 // Bit mask of PR22 field.
	EXTI_PR1_PR22     = 0x400000 // Bit PR22.

	// IMR2: Interrupt mask register
	EXTI_IMR2_MR32_Pos = 0x0  // Position of MR32 field.
	EXTI_IMR2_MR32_Msk = 0x1  // Bit mask of MR32 field.
	EXTI_IMR2_MR32     = 0x1  // Bit MR32.
	EXTI_IMR2_MR33_Pos = 0x1  // Position of MR33 field.
	EXTI_IMR2_MR33_Msk = 0x2  // Bit mask of MR33 field.
	EXTI_IMR2_MR33     = 0x2  // Bit MR33.
	EXTI_IMR2_MR34_Pos = 0x2  // Position of MR34 field.
	EXTI_IMR2_MR34_Msk = 0x4  // Bit mask of MR34 field.
	EXTI_IMR2_MR34     = 0x4  // Bit MR34.
	EXTI_IMR2_MR35_Pos = 0x3  // Position of MR35 field.
	EXTI_IMR2_MR35_Msk = 0x8  // Bit mask of MR35 field.
	EXTI_IMR2_MR35     = 0x8  // Bit MR35.
	EXTI_IMR2_MR36_Pos = 0x4  // Position of MR36 field.
	EXTI_IMR2_MR36_Msk = 0x10 // Bit mask of MR36 field.
	EXTI_IMR2_MR36     = 0x10 // Bit MR36.
	EXTI_IMR2_MR37_Pos = 0x5  // Position of MR37 field.
	EXTI_IMR2_MR37_Msk = 0x20 // Bit mask of MR37 field.
	EXTI_IMR2_MR37     = 0x20 // Bit MR37.
	EXTI_IMR2_MR38_Pos = 0x6  // Position of MR38 field.
	EXTI_IMR2_MR38_Msk = 0x40 // Bit mask of MR38 field.
	EXTI_IMR2_MR38     = 0x40 // Bit MR38.
	EXTI_IMR2_MR39_Pos = 0x7  // Position of MR39 field.
	EXTI_IMR2_MR39_Msk = 0x80 // Bit mask of MR39 field.
	EXTI_IMR2_MR39     = 0x80 // Bit MR39.

	// EMR2: Event mask register
	EXTI_EMR2_MR32_Pos = 0x0  // Position of MR32 field.
	EXTI_EMR2_MR32_Msk = 0x1  // Bit mask of MR32 field.
	EXTI_EMR2_MR32     = 0x1  // Bit MR32.
	EXTI_EMR2_MR33_Pos = 0x1  // Position of MR33 field.
	EXTI_EMR2_MR33_Msk = 0x2  // Bit mask of MR33 field.
	EXTI_EMR2_MR33     = 0x2  // Bit MR33.
	EXTI_EMR2_MR34_Pos = 0x2  // Position of MR34 field.
	EXTI_EMR2_MR34_Msk = 0x4  // Bit mask of MR34 field.
	EXTI_EMR2_MR34     = 0x4  // Bit MR34.
	EXTI_EMR2_MR35_Pos = 0x3  // Position of MR35 field.
	EXTI_EMR2_MR35_Msk = 0x8  // Bit mask of MR35 field.
	EXTI_EMR2_MR35     = 0x8  // Bit MR35.
	EXTI_EMR2_MR36_Pos = 0x4  // Position of MR36 field.
	EXTI_EMR2_MR36_Msk = 0x10 // Bit mask of MR36 field.
	EXTI_EMR2_MR36     = 0x10 // Bit MR36.
	EXTI_EMR2_MR37_Pos = 0x5  // Position of MR37 field.
	EXTI_EMR2_MR37_Msk = 0x20 // Bit mask of MR37 field.
	EXTI_EMR2_MR37     = 0x20 // Bit MR37.
	EXTI_EMR2_MR38_Pos = 0x6  // Position of MR38 field.
	EXTI_EMR2_MR38_Msk = 0x40 // Bit mask of MR38 field.
	EXTI_EMR2_MR38     = 0x40 // Bit MR38.
	EXTI_EMR2_MR39_Pos = 0x7  // Position of MR39 field.
	EXTI_EMR2_MR39_Msk = 0x80 // Bit mask of MR39 field.
	EXTI_EMR2_MR39     = 0x80 // Bit MR39.

	// RTSR2: Rising Trigger selection           register
	EXTI_RTSR2_RT35_Pos = 0x3  // Position of RT35 field.
	EXTI_RTSR2_RT35_Msk = 0x8  // Bit mask of RT35 field.
	EXTI_RTSR2_RT35     = 0x8  // Bit RT35.
	EXTI_RTSR2_RT36_Pos = 0x4  // Position of RT36 field.
	EXTI_RTSR2_RT36_Msk = 0x10 // Bit mask of RT36 field.
	EXTI_RTSR2_RT36     = 0x10 // Bit RT36.
	EXTI_RTSR2_RT37_Pos = 0x5  // Position of RT37 field.
	EXTI_RTSR2_RT37_Msk = 0x20 // Bit mask of RT37 field.
	EXTI_RTSR2_RT37     = 0x20 // Bit RT37.
	EXTI_RTSR2_RT38_Pos = 0x6  // Position of RT38 field.
	EXTI_RTSR2_RT38_Msk = 0x40 // Bit mask of RT38 field.
	EXTI_RTSR2_RT38     = 0x40 // Bit RT38.

	// FTSR2: Falling Trigger selection           register
	EXTI_FTSR2_FT35_Pos = 0x3  // Position of FT35 field.
	EXTI_FTSR2_FT35_Msk = 0x8  // Bit mask of FT35 field.
	EXTI_FTSR2_FT35     = 0x8  // Bit FT35.
	EXTI_FTSR2_FT36_Pos = 0x4  // Position of FT36 field.
	EXTI_FTSR2_FT36_Msk = 0x10 // Bit mask of FT36 field.
	EXTI_FTSR2_FT36     = 0x10 // Bit FT36.
	EXTI_FTSR2_FT37_Pos = 0x5  // Position of FT37 field.
	EXTI_FTSR2_FT37_Msk = 0x20 // Bit mask of FT37 field.
	EXTI_FTSR2_FT37     = 0x20 // Bit FT37.
	EXTI_FTSR2_FT38_Pos = 0x6  // Position of FT38 field.
	EXTI_FTSR2_FT38_Msk = 0x40 // Bit mask of FT38 field.
	EXTI_FTSR2_FT38     = 0x40 // Bit FT38.

	// SWIER2: Software interrupt event           register
	EXTI_SWIER2_SWI35_Pos = 0x3  // Position of SWI35 field.
	EXTI_SWIER2_SWI35_Msk = 0x8  // Bit mask of SWI35 field.
	EXTI_SWIER2_SWI35     = 0x8  // Bit SWI35.
	EXTI_SWIER2_SWI36_Pos = 0x4  // Position of SWI36 field.
	EXTI_SWIER2_SWI36_Msk = 0x10 // Bit mask of SWI36 field.
	EXTI_SWIER2_SWI36     = 0x10 // Bit SWI36.
	EXTI_SWIER2_SWI37_Pos = 0x5  // Position of SWI37 field.
	EXTI_SWIER2_SWI37_Msk = 0x20 // Bit mask of SWI37 field.
	EXTI_SWIER2_SWI37     = 0x20 // Bit SWI37.
	EXTI_SWIER2_SWI38_Pos = 0x6  // Position of SWI38 field.
	EXTI_SWIER2_SWI38_Msk = 0x40 // Bit mask of SWI38 field.
	EXTI_SWIER2_SWI38     = 0x40 // Bit SWI38.

	// PR2: Pending register
	EXTI_PR2_PIF35_Pos = 0x3  // Position of PIF35 field.
	EXTI_PR2_PIF35_Msk = 0x8  // Bit mask of PIF35 field.
	EXTI_PR2_PIF35     = 0x8  // Bit PIF35.
	EXTI_PR2_PIF36_Pos = 0x4  // Position of PIF36 field.
	EXTI_PR2_PIF36_Msk = 0x10 // Bit mask of PIF36 field.
	EXTI_PR2_PIF36     = 0x10 // Bit PIF36.
	EXTI_PR2_PIF37_Pos = 0x5  // Position of PIF37 field.
	EXTI_PR2_PIF37_Msk = 0x20 // Bit mask of PIF37 field.
	EXTI_PR2_PIF37     = 0x20 // Bit PIF37.
	EXTI_PR2_PIF38_Pos = 0x6  // Position of PIF38 field.
	EXTI_PR2_PIF38_Msk = 0x40 // Bit mask of PIF38 field.
	EXTI_PR2_PIF38     = 0x40 // Bit PIF38.
)

// Bitfields for VREFBUF: Voltage reference buffer
const (
	// CSR: VREF control and status           register
	VREF_CSR_ENVR_Pos = 0x0 // Position of ENVR field.
	VREF_CSR_ENVR_Msk = 0x1 // Bit mask of ENVR field.
	VREF_CSR_ENVR     = 0x1 // Bit ENVR.
	VREF_CSR_HIZ_Pos  = 0x1 // Position of HIZ field.
	VREF_CSR_HIZ_Msk  = 0x2 // Bit mask of HIZ field.
	VREF_CSR_HIZ      = 0x2 // Bit HIZ.
	VREF_CSR_VRS_Pos  = 0x2 // Position of VRS field.
	VREF_CSR_VRS_Msk  = 0x4 // Bit mask of VRS field.
	VREF_CSR_VRS      = 0x4 // Bit VRS.
	VREF_CSR_VRR_Pos  = 0x3 // Position of VRR field.
	VREF_CSR_VRR_Msk  = 0x8 // Bit mask of VRR field.
	VREF_CSR_VRR      = 0x8 // Bit VRR.

	// CCR: calibration control register
	VREF_CCR_TRIM_Pos = 0x0  // Position of TRIM field.
	VREF_CCR_TRIM_Msk = 0x3f // Bit mask of TRIM field.
)

// Bitfields for CAN1: Controller area network
const (
	// MCR: master control register
	CAN_MCR_DBF_Pos   = 0x10    // Position of DBF field.
	CAN_MCR_DBF_Msk   = 0x10000 // Bit mask of DBF field.
	CAN_MCR_DBF       = 0x10000 // Bit DBF.
	CAN_MCR_RESET_Pos = 0xf     // Position of RESET field.
	CAN_MCR_RESET_Msk = 0x8000  // Bit mask of RESET field.
	CAN_MCR_RESET     = 0x8000  // Bit RESET.
	CAN_MCR_TTCM_Pos  = 0x7     // Position of TTCM field.
	CAN_MCR_TTCM_Msk  = 0x80    // Bit mask of TTCM field.
	CAN_MCR_TTCM      = 0x80    // Bit TTCM.
	CAN_MCR_ABOM_Pos  = 0x6     // Position of ABOM field.
	CAN_MCR_ABOM_Msk  = 0x40    // Bit mask of ABOM field.
	CAN_MCR_ABOM      = 0x40    // Bit ABOM.
	CAN_MCR_AWUM_Pos  = 0x5     // Position of AWUM field.
	CAN_MCR_AWUM_Msk  = 0x20    // Bit mask of AWUM field.
	CAN_MCR_AWUM      = 0x20    // Bit AWUM.
	CAN_MCR_NART_Pos  = 0x4     // Position of NART field.
	CAN_MCR_NART_Msk  = 0x10    // Bit mask of NART field.
	CAN_MCR_NART      = 0x10    // Bit NART.
	CAN_MCR_RFLM_Pos  = 0x3     // Position of RFLM field.
	CAN_MCR_RFLM_Msk  = 0x8     // Bit mask of RFLM field.
	CAN_MCR_RFLM      = 0x8     // Bit RFLM.
	CAN_MCR_TXFP_Pos  = 0x2     // Position of TXFP field.
	CAN_MCR_TXFP_Msk  = 0x4     // Bit mask of TXFP field.
	CAN_MCR_TXFP      = 0x4     // Bit TXFP.
	CAN_MCR_SLEEP_Pos = 0x1     // Position of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2     // Bit mask of SLEEP field.
	CAN_MCR_SLEEP     = 0x2     // Bit SLEEP.
	CAN_MCR_INRQ_Pos  = 0x0     // Position of INRQ field.
	CAN_MCR_INRQ_Msk  = 0x1     // Bit mask of INRQ field.
	CAN_MCR_INRQ      = 0x1     // Bit INRQ.

	// MSR: master status register
	CAN_MSR_RX_Pos    = 0xb   // Position of RX field.
	CAN_MSR_RX_Msk    = 0x800 // Bit mask of RX field.
	CAN_MSR_RX        = 0x800 // Bit RX.
	CAN_MSR_SAMP_Pos  = 0xa   // Position of SAMP field.
	CAN_MSR_SAMP_Msk  = 0x400 // Bit mask of SAMP field.
	CAN_MSR_SAMP      = 0x400 // Bit SAMP.
	CAN_MSR_RXM_Pos   = 0x9   // Position of RXM field.
	CAN_MSR_RXM_Msk   = 0x200 // Bit mask of RXM field.
	CAN_MSR_RXM       = 0x200 // Bit RXM.
	CAN_MSR_TXM_Pos   = 0x8   // Position of TXM field.
	CAN_MSR_TXM_Msk   = 0x100 // Bit mask of TXM field.
	CAN_MSR_TXM       = 0x100 // Bit TXM.
	CAN_MSR_SLAKI_Pos = 0x4   // Position of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10  // Bit mask of SLAKI field.
	CAN_MSR_SLAKI     = 0x10  // Bit SLAKI.
	CAN_MSR_WKUI_Pos  = 0x3   // Position of WKUI field.
	CAN_MSR_WKUI_Msk  = 0x8   // Bit mask of WKUI field.
	CAN_MSR_WKUI      = 0x8   // Bit WKUI.
	CAN_MSR_ERRI_Pos  = 0x2   // Position of ERRI field.
	CAN_MSR_ERRI_Msk  = 0x4   // Bit mask of ERRI field.
	CAN_MSR_ERRI      = 0x4   // Bit ERRI.
	CAN_MSR_SLAK_Pos  = 0x1   // Position of SLAK field.
	CAN_MSR_SLAK_Msk  = 0x2   // Bit mask of SLAK field.
	CAN_MSR_SLAK      = 0x2   // Bit SLAK.
	CAN_MSR_INAK_Pos  = 0x0   // Position of INAK field.
	CAN_MSR_INAK_Msk  = 0x1   // Bit mask of INAK field.
	CAN_MSR_INAK      = 0x1   // Bit INAK.

	// TSR: transmit status register
	CAN_TSR_LOW2_Pos  = 0x1f       // Position of LOW2 field.
	CAN_TSR_LOW2_Msk  = 0x80000000 // Bit mask of LOW2 field.
	CAN_TSR_LOW2      = 0x80000000 // Bit LOW2.
	CAN_TSR_LOW1_Pos  = 0x1e       // Position of LOW1 field.
	CAN_TSR_LOW1_Msk  = 0x40000000 // Bit mask of LOW1 field.
	CAN_TSR_LOW1      = 0x40000000 // Bit LOW1.
	CAN_TSR_LOW0_Pos  = 0x1d       // Position of LOW0 field.
	CAN_TSR_LOW0_Msk  = 0x20000000 // Bit mask of LOW0 field.
	CAN_TSR_LOW0      = 0x20000000 // Bit LOW0.
	CAN_TSR_TME2_Pos  = 0x1c       // Position of TME2 field.
	CAN_TSR_TME2_Msk  = 0x10000000 // Bit mask of TME2 field.
	CAN_TSR_TME2      = 0x10000000 // Bit TME2.
	CAN_TSR_TME1_Pos  = 0x1b       // Position of TME1 field.
	CAN_TSR_TME1_Msk  = 0x8000000  // Bit mask of TME1 field.
	CAN_TSR_TME1      = 0x8000000  // Bit TME1.
	CAN_TSR_TME0_Pos  = 0x1a       // Position of TME0 field.
	CAN_TSR_TME0_Msk  = 0x4000000  // Bit mask of TME0 field.
	CAN_TSR_TME0      = 0x4000000  // Bit TME0.
	CAN_TSR_CODE_Pos  = 0x18       // Position of CODE field.
	CAN_TSR_CODE_Msk  = 0x3000000  // Bit mask of CODE field.
	CAN_TSR_ABRQ2_Pos = 0x17       // Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000   // Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2     = 0x800000   // Bit ABRQ2.
	CAN_TSR_TERR2_Pos = 0x13       // Position of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000    // Bit mask of TERR2 field.
	CAN_TSR_TERR2     = 0x80000    // Bit TERR2.
	CAN_TSR_ALST2_Pos = 0x12       // Position of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000    // Bit mask of ALST2 field.
	CAN_TSR_ALST2     = 0x40000    // Bit ALST2.
	CAN_TSR_TXOK2_Pos = 0x11       // Position of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000    // Bit mask of TXOK2 field.
	CAN_TSR_TXOK2     = 0x20000    // Bit TXOK2.
	CAN_TSR_RQCP2_Pos = 0x10       // Position of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000    // Bit mask of RQCP2 field.
	CAN_TSR_RQCP2     = 0x10000    // Bit RQCP2.
	CAN_TSR_ABRQ1_Pos = 0xf        // Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000     // Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1     = 0x8000     // Bit ABRQ1.
	CAN_TSR_TERR1_Pos = 0xb        // Position of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800      // Bit mask of TERR1 field.
	CAN_TSR_TERR1     = 0x800      // Bit TERR1.
	CAN_TSR_ALST1_Pos = 0xa        // Position of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400      // Bit mask of ALST1 field.
	CAN_TSR_ALST1     = 0x400      // Bit ALST1.
	CAN_TSR_TXOK1_Pos = 0x9        // Position of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200      // Bit mask of TXOK1 field.
	CAN_TSR_TXOK1     = 0x200      // Bit TXOK1.
	CAN_TSR_RQCP1_Pos = 0x8        // Position of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100      // Bit mask of RQCP1 field.
	CAN_TSR_RQCP1     = 0x100      // Bit RQCP1.
	CAN_TSR_ABRQ0_Pos = 0x7        // Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80       // Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0     = 0x80       // Bit ABRQ0.
	CAN_TSR_TERR0_Pos = 0x3        // Position of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8        // Bit mask of TERR0 field.
	CAN_TSR_TERR0     = 0x8        // Bit TERR0.
	CAN_TSR_ALST0_Pos = 0x2        // Position of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4        // Bit mask of ALST0 field.
	CAN_TSR_ALST0     = 0x4        // Bit ALST0.
	CAN_TSR_TXOK0_Pos = 0x1        // Position of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2        // Bit mask of TXOK0 field.
	CAN_TSR_TXOK0     = 0x2        // Bit TXOK0.
	CAN_TSR_RQCP0_Pos = 0x0        // Position of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1        // Bit mask of RQCP0 field.
	CAN_TSR_RQCP0     = 0x1        // Bit RQCP0.

	// RF0R: receive FIFO 0 register
	CAN_RF0R_RFOM0_Pos = 0x5  // Position of RFOM0 field.
	CAN_RF0R_RFOM0_Msk = 0x20 // Bit mask of RFOM0 field.
	CAN_RF0R_RFOM0     = 0x20 // Bit RFOM0.
	CAN_RF0R_FOVR0_Pos = 0x4  // Position of FOVR0 field.
	CAN_RF0R_FOVR0_Msk = 0x10 // Bit mask of FOVR0 field.
	CAN_RF0R_FOVR0     = 0x10 // Bit FOVR0.
	CAN_RF0R_FULL0_Pos = 0x3  // Position of FULL0 field.
	CAN_RF0R_FULL0_Msk = 0x8  // Bit mask of FULL0 field.
	CAN_RF0R_FULL0     = 0x8  // Bit FULL0.
	CAN_RF0R_FMP0_Pos  = 0x0  // Position of FMP0 field.
	CAN_RF0R_FMP0_Msk  = 0x3  // Bit mask of FMP0 field.

	// RF1R: receive FIFO 1 register
	CAN_RF1R_RFOM1_Pos = 0x5  // Position of RFOM1 field.
	CAN_RF1R_RFOM1_Msk = 0x20 // Bit mask of RFOM1 field.
	CAN_RF1R_RFOM1     = 0x20 // Bit RFOM1.
	CAN_RF1R_FOVR1_Pos = 0x4  // Position of FOVR1 field.
	CAN_RF1R_FOVR1_Msk = 0x10 // Bit mask of FOVR1 field.
	CAN_RF1R_FOVR1     = 0x10 // Bit FOVR1.
	CAN_RF1R_FULL1_Pos = 0x3  // Position of FULL1 field.
	CAN_RF1R_FULL1_Msk = 0x8  // Bit mask of FULL1 field.
	CAN_RF1R_FULL1     = 0x8  // Bit FULL1.
	CAN_RF1R_FMP1_Pos  = 0x0  // Position of FMP1 field.
	CAN_RF1R_FMP1_Msk  = 0x3  // Bit mask of FMP1 field.

	// IER: interrupt enable register
	CAN_IER_SLKIE_Pos  = 0x11    // Position of SLKIE field.
	CAN_IER_SLKIE_Msk  = 0x20000 // Bit mask of SLKIE field.
	CAN_IER_SLKIE      = 0x20000 // Bit SLKIE.
	CAN_IER_WKUIE_Pos  = 0x10    // Position of WKUIE field.
	CAN_IER_WKUIE_Msk  = 0x10000 // Bit mask of WKUIE field.
	CAN_IER_WKUIE      = 0x10000 // Bit WKUIE.
	CAN_IER_ERRIE_Pos  = 0xf     // Position of ERRIE field.
	CAN_IER_ERRIE_Msk  = 0x8000  // Bit mask of ERRIE field.
	CAN_IER_ERRIE      = 0x8000  // Bit ERRIE.
	CAN_IER_LECIE_Pos  = 0xb     // Position of LECIE field.
	CAN_IER_LECIE_Msk  = 0x800   // Bit mask of LECIE field.
	CAN_IER_LECIE      = 0x800   // Bit LECIE.
	CAN_IER_BOFIE_Pos  = 0xa     // Position of BOFIE field.
	CAN_IER_BOFIE_Msk  = 0x400   // Bit mask of BOFIE field.
	CAN_IER_BOFIE      = 0x400   // Bit BOFIE.
	CAN_IER_EPVIE_Pos  = 0x9     // Position of EPVIE field.
	CAN_IER_EPVIE_Msk  = 0x200   // Bit mask of EPVIE field.
	CAN_IER_EPVIE      = 0x200   // Bit EPVIE.
	CAN_IER_EWGIE_Pos  = 0x8     // Position of EWGIE field.
	CAN_IER_EWGIE_Msk  = 0x100   // Bit mask of EWGIE field.
	CAN_IER_EWGIE      = 0x100   // Bit EWGIE.
	CAN_IER_FOVIE1_Pos = 0x6     // Position of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40    // Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1     = 0x40    // Bit FOVIE1.
	CAN_IER_FFIE1_Pos  = 0x5     // Position of FFIE1 field.
	CAN_IER_FFIE1_Msk  = 0x20    // Bit mask of FFIE1 field.
	CAN_IER_FFIE1      = 0x20    // Bit FFIE1.
	CAN_IER_FMPIE1_Pos = 0x4     // Position of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10    // Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1     = 0x10    // Bit FMPIE1.
	CAN_IER_FOVIE0_Pos = 0x3     // Position of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8     // Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0     = 0x8     // Bit FOVIE0.
	CAN_IER_FFIE0_Pos  = 0x2     // Position of FFIE0 field.
	CAN_IER_FFIE0_Msk  = 0x4     // Bit mask of FFIE0 field.
	CAN_IER_FFIE0      = 0x4     // Bit FFIE0.
	CAN_IER_FMPIE0_Pos = 0x1     // Position of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2     // Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0     = 0x2     // Bit FMPIE0.
	CAN_IER_TMEIE_Pos  = 0x0     // Position of TMEIE field.
	CAN_IER_TMEIE_Msk  = 0x1     // Bit mask of TMEIE field.
	CAN_IER_TMEIE      = 0x1     // Bit TMEIE.

	// ESR: interrupt enable register
	CAN_ESR_REC_Pos  = 0x18       // Position of REC field.
	CAN_ESR_REC_Msk  = 0xff000000 // Bit mask of REC field.
	CAN_ESR_TEC_Pos  = 0x10       // Position of TEC field.
	CAN_ESR_TEC_Msk  = 0xff0000   // Bit mask of TEC field.
	CAN_ESR_LEC_Pos  = 0x4        // Position of LEC field.
	CAN_ESR_LEC_Msk  = 0x70       // Bit mask of LEC field.
	CAN_ESR_BOFF_Pos = 0x2        // Position of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4        // Bit mask of BOFF field.
	CAN_ESR_BOFF     = 0x4        // Bit BOFF.
	CAN_ESR_EPVF_Pos = 0x1        // Position of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2        // Bit mask of EPVF field.
	CAN_ESR_EPVF     = 0x2        // Bit EPVF.
	CAN_ESR_EWGF_Pos = 0x0        // Position of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1        // Bit mask of EWGF field.
	CAN_ESR_EWGF     = 0x1        // Bit EWGF.

	// BTR: bit timing register
	CAN_BTR_SILM_Pos = 0x1f       // Position of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000 // Bit mask of SILM field.
	CAN_BTR_SILM     = 0x80000000 // Bit SILM.
	CAN_BTR_LBKM_Pos = 0x1e       // Position of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000 // Bit mask of LBKM field.
	CAN_BTR_LBKM     = 0x40000000 // Bit LBKM.
	CAN_BTR_SJW_Pos  = 0x18       // Position of SJW field.
	CAN_BTR_SJW_Msk  = 0x3000000  // Bit mask of SJW field.
	CAN_BTR_TS2_Pos  = 0x14       // Position of TS2 field.
	CAN_BTR_TS2_Msk  = 0x700000   // Bit mask of TS2 field.
	CAN_BTR_TS1_Pos  = 0x10       // Position of TS1 field.
	CAN_BTR_TS1_Msk  = 0xf0000    // Bit mask of TS1 field.
	CAN_BTR_BRP_Pos  = 0x0        // Position of BRP field.
	CAN_BTR_BRP_Msk  = 0x3ff      // Bit mask of BRP field.

	// TI0R: TX mailbox identifier register
	CAN_TI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI0R_IDE      = 0x4        // Bit IDE.
	CAN_TI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI0R_RTR      = 0x2        // Bit RTR.
	CAN_TI0R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI0R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI0R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT0R: mailbox data length control and time stamp           register
	CAN_TDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT0R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT0R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT0R_TGT      = 0x100      // Bit TGT.
	CAN_TDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL0R: mailbox data low register
	CAN_TDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH0R: mailbox data high register
	CAN_TDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI1R: mailbox identifier register
	CAN_TI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI1R_IDE      = 0x4        // Bit IDE.
	CAN_TI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI1R_RTR      = 0x2        // Bit RTR.
	CAN_TI1R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI1R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI1R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT1R: mailbox data length control and time stamp           register
	CAN_TDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT1R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT1R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT1R_TGT      = 0x100      // Bit TGT.
	CAN_TDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL1R: mailbox data low register
	CAN_TDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH1R: mailbox data high register
	CAN_TDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI2R: mailbox identifier register
	CAN_TI2R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI2R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI2R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI2R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI2R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI2R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI2R_IDE      = 0x4        // Bit IDE.
	CAN_TI2R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI2R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI2R_RTR      = 0x2        // Bit RTR.
	CAN_TI2R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI2R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI2R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT2R: mailbox data length control and time stamp           register
	CAN_TDT2R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT2R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT2R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT2R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT2R_TGT      = 0x100      // Bit TGT.
	CAN_TDT2R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT2R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL2R: mailbox data low register
	CAN_TDL2R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL2R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL2R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL2R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL2R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL2R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL2R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL2R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH2R: mailbox data high register
	CAN_TDH2R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH2R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH2R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH2R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH2R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH2R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH2R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH2R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI0R: receive FIFO mailbox identifier           register
	CAN_RI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI0R_IDE      = 0x4        // Bit IDE.
	CAN_RI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI0R_RTR      = 0x2        // Bit RTR.

	// RDT0R: mailbox data high register
	CAN_RDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT0R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT0R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL0R: mailbox data high register
	CAN_RDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH0R: receive FIFO mailbox data high           register
	CAN_RDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI1R: mailbox data high register
	CAN_RI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI1R_IDE      = 0x4        // Bit IDE.
	CAN_RI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI1R_RTR      = 0x2        // Bit RTR.

	// RDT1R: mailbox data high register
	CAN_RDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT1R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT1R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL1R: mailbox data high register
	CAN_RDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH1R: mailbox data high register
	CAN_RDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// FMR: filter master register
	CAN_FMR_FINIT_Pos = 0x0    // Position of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1    // Bit mask of FINIT field.
	CAN_FMR_FINIT     = 0x1    // Bit FINIT.
	CAN_FMR_CANSB_Pos = 0x8    // Position of CANSB field.
	CAN_FMR_CANSB_Msk = 0x3f00 // Bit mask of CANSB field.

	// FM1R: filter mode register
	CAN_FM1R_FBM0_Pos  = 0x0       // Position of FBM0 field.
	CAN_FM1R_FBM0_Msk  = 0x1       // Bit mask of FBM0 field.
	CAN_FM1R_FBM0      = 0x1       // Bit FBM0.
	CAN_FM1R_FBM1_Pos  = 0x1       // Position of FBM1 field.
	CAN_FM1R_FBM1_Msk  = 0x2       // Bit mask of FBM1 field.
	CAN_FM1R_FBM1      = 0x2       // Bit FBM1.
	CAN_FM1R_FBM2_Pos  = 0x2       // Position of FBM2 field.
	CAN_FM1R_FBM2_Msk  = 0x4       // Bit mask of FBM2 field.
	CAN_FM1R_FBM2      = 0x4       // Bit FBM2.
	CAN_FM1R_FBM3_Pos  = 0x3       // Position of FBM3 field.
	CAN_FM1R_FBM3_Msk  = 0x8       // Bit mask of FBM3 field.
	CAN_FM1R_FBM3      = 0x8       // Bit FBM3.
	CAN_FM1R_FBM4_Pos  = 0x4       // Position of FBM4 field.
	CAN_FM1R_FBM4_Msk  = 0x10      // Bit mask of FBM4 field.
	CAN_FM1R_FBM4      = 0x10      // Bit FBM4.
	CAN_FM1R_FBM5_Pos  = 0x5       // Position of FBM5 field.
	CAN_FM1R_FBM5_Msk  = 0x20      // Bit mask of FBM5 field.
	CAN_FM1R_FBM5      = 0x20      // Bit FBM5.
	CAN_FM1R_FBM6_Pos  = 0x6       // Position of FBM6 field.
	CAN_FM1R_FBM6_Msk  = 0x40      // Bit mask of FBM6 field.
	CAN_FM1R_FBM6      = 0x40      // Bit FBM6.
	CAN_FM1R_FBM7_Pos  = 0x7       // Position of FBM7 field.
	CAN_FM1R_FBM7_Msk  = 0x80      // Bit mask of FBM7 field.
	CAN_FM1R_FBM7      = 0x80      // Bit FBM7.
	CAN_FM1R_FBM8_Pos  = 0x8       // Position of FBM8 field.
	CAN_FM1R_FBM8_Msk  = 0x100     // Bit mask of FBM8 field.
	CAN_FM1R_FBM8      = 0x100     // Bit FBM8.
	CAN_FM1R_FBM9_Pos  = 0x9       // Position of FBM9 field.
	CAN_FM1R_FBM9_Msk  = 0x200     // Bit mask of FBM9 field.
	CAN_FM1R_FBM9      = 0x200     // Bit FBM9.
	CAN_FM1R_FBM10_Pos = 0xa       // Position of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400     // Bit mask of FBM10 field.
	CAN_FM1R_FBM10     = 0x400     // Bit FBM10.
	CAN_FM1R_FBM11_Pos = 0xb       // Position of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800     // Bit mask of FBM11 field.
	CAN_FM1R_FBM11     = 0x800     // Bit FBM11.
	CAN_FM1R_FBM12_Pos = 0xc       // Position of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000    // Bit mask of FBM12 field.
	CAN_FM1R_FBM12     = 0x1000    // Bit FBM12.
	CAN_FM1R_FBM13_Pos = 0xd       // Position of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000    // Bit mask of FBM13 field.
	CAN_FM1R_FBM13     = 0x2000    // Bit FBM13.
	CAN_FM1R_FBM14_Pos = 0xe       // Position of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000    // Bit mask of FBM14 field.
	CAN_FM1R_FBM14     = 0x4000    // Bit FBM14.
	CAN_FM1R_FBM15_Pos = 0xf       // Position of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000    // Bit mask of FBM15 field.
	CAN_FM1R_FBM15     = 0x8000    // Bit FBM15.
	CAN_FM1R_FBM16_Pos = 0x10      // Position of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000   // Bit mask of FBM16 field.
	CAN_FM1R_FBM16     = 0x10000   // Bit FBM16.
	CAN_FM1R_FBM17_Pos = 0x11      // Position of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000   // Bit mask of FBM17 field.
	CAN_FM1R_FBM17     = 0x20000   // Bit FBM17.
	CAN_FM1R_FBM18_Pos = 0x12      // Position of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000   // Bit mask of FBM18 field.
	CAN_FM1R_FBM18     = 0x40000   // Bit FBM18.
	CAN_FM1R_FBM19_Pos = 0x13      // Position of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000   // Bit mask of FBM19 field.
	CAN_FM1R_FBM19     = 0x80000   // Bit FBM19.
	CAN_FM1R_FBM20_Pos = 0x14      // Position of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000  // Bit mask of FBM20 field.
	CAN_FM1R_FBM20     = 0x100000  // Bit FBM20.
	CAN_FM1R_FBM21_Pos = 0x15      // Position of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000  // Bit mask of FBM21 field.
	CAN_FM1R_FBM21     = 0x200000  // Bit FBM21.
	CAN_FM1R_FBM22_Pos = 0x16      // Position of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000  // Bit mask of FBM22 field.
	CAN_FM1R_FBM22     = 0x400000  // Bit FBM22.
	CAN_FM1R_FBM23_Pos = 0x17      // Position of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000  // Bit mask of FBM23 field.
	CAN_FM1R_FBM23     = 0x800000  // Bit FBM23.
	CAN_FM1R_FBM24_Pos = 0x18      // Position of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000 // Bit mask of FBM24 field.
	CAN_FM1R_FBM24     = 0x1000000 // Bit FBM24.
	CAN_FM1R_FBM25_Pos = 0x19      // Position of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000 // Bit mask of FBM25 field.
	CAN_FM1R_FBM25     = 0x2000000 // Bit FBM25.
	CAN_FM1R_FBM26_Pos = 0x1a      // Position of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000 // Bit mask of FBM26 field.
	CAN_FM1R_FBM26     = 0x4000000 // Bit FBM26.
	CAN_FM1R_FBM27_Pos = 0x1b      // Position of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000 // Bit mask of FBM27 field.
	CAN_FM1R_FBM27     = 0x8000000 // Bit FBM27.

	// FS1R: filter scale register
	CAN_FS1R_FSC0_Pos  = 0x0       // Position of FSC0 field.
	CAN_FS1R_FSC0_Msk  = 0x1       // Bit mask of FSC0 field.
	CAN_FS1R_FSC0      = 0x1       // Bit FSC0.
	CAN_FS1R_FSC1_Pos  = 0x1       // Position of FSC1 field.
	CAN_FS1R_FSC1_Msk  = 0x2       // Bit mask of FSC1 field.
	CAN_FS1R_FSC1      = 0x2       // Bit FSC1.
	CAN_FS1R_FSC2_Pos  = 0x2       // Position of FSC2 field.
	CAN_FS1R_FSC2_Msk  = 0x4       // Bit mask of FSC2 field.
	CAN_FS1R_FSC2      = 0x4       // Bit FSC2.
	CAN_FS1R_FSC3_Pos  = 0x3       // Position of FSC3 field.
	CAN_FS1R_FSC3_Msk  = 0x8       // Bit mask of FSC3 field.
	CAN_FS1R_FSC3      = 0x8       // Bit FSC3.
	CAN_FS1R_FSC4_Pos  = 0x4       // Position of FSC4 field.
	CAN_FS1R_FSC4_Msk  = 0x10      // Bit mask of FSC4 field.
	CAN_FS1R_FSC4      = 0x10      // Bit FSC4.
	CAN_FS1R_FSC5_Pos  = 0x5       // Position of FSC5 field.
	CAN_FS1R_FSC5_Msk  = 0x20      // Bit mask of FSC5 field.
	CAN_FS1R_FSC5      = 0x20      // Bit FSC5.
	CAN_FS1R_FSC6_Pos  = 0x6       // Position of FSC6 field.
	CAN_FS1R_FSC6_Msk  = 0x40      // Bit mask of FSC6 field.
	CAN_FS1R_FSC6      = 0x40      // Bit FSC6.
	CAN_FS1R_FSC7_Pos  = 0x7       // Position of FSC7 field.
	CAN_FS1R_FSC7_Msk  = 0x80      // Bit mask of FSC7 field.
	CAN_FS1R_FSC7      = 0x80      // Bit FSC7.
	CAN_FS1R_FSC8_Pos  = 0x8       // Position of FSC8 field.
	CAN_FS1R_FSC8_Msk  = 0x100     // Bit mask of FSC8 field.
	CAN_FS1R_FSC8      = 0x100     // Bit FSC8.
	CAN_FS1R_FSC9_Pos  = 0x9       // Position of FSC9 field.
	CAN_FS1R_FSC9_Msk  = 0x200     // Bit mask of FSC9 field.
	CAN_FS1R_FSC9      = 0x200     // Bit FSC9.
	CAN_FS1R_FSC10_Pos = 0xa       // Position of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400     // Bit mask of FSC10 field.
	CAN_FS1R_FSC10     = 0x400     // Bit FSC10.
	CAN_FS1R_FSC11_Pos = 0xb       // Position of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800     // Bit mask of FSC11 field.
	CAN_FS1R_FSC11     = 0x800     // Bit FSC11.
	CAN_FS1R_FSC12_Pos = 0xc       // Position of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000    // Bit mask of FSC12 field.
	CAN_FS1R_FSC12     = 0x1000    // Bit FSC12.
	CAN_FS1R_FSC13_Pos = 0xd       // Position of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000    // Bit mask of FSC13 field.
	CAN_FS1R_FSC13     = 0x2000    // Bit FSC13.
	CAN_FS1R_FSC14_Pos = 0xe       // Position of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000    // Bit mask of FSC14 field.
	CAN_FS1R_FSC14     = 0x4000    // Bit FSC14.
	CAN_FS1R_FSC15_Pos = 0xf       // Position of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000    // Bit mask of FSC15 field.
	CAN_FS1R_FSC15     = 0x8000    // Bit FSC15.
	CAN_FS1R_FSC16_Pos = 0x10      // Position of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000   // Bit mask of FSC16 field.
	CAN_FS1R_FSC16     = 0x10000   // Bit FSC16.
	CAN_FS1R_FSC17_Pos = 0x11      // Position of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000   // Bit mask of FSC17 field.
	CAN_FS1R_FSC17     = 0x20000   // Bit FSC17.
	CAN_FS1R_FSC18_Pos = 0x12      // Position of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000   // Bit mask of FSC18 field.
	CAN_FS1R_FSC18     = 0x40000   // Bit FSC18.
	CAN_FS1R_FSC19_Pos = 0x13      // Position of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000   // Bit mask of FSC19 field.
	CAN_FS1R_FSC19     = 0x80000   // Bit FSC19.
	CAN_FS1R_FSC20_Pos = 0x14      // Position of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000  // Bit mask of FSC20 field.
	CAN_FS1R_FSC20     = 0x100000  // Bit FSC20.
	CAN_FS1R_FSC21_Pos = 0x15      // Position of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000  // Bit mask of FSC21 field.
	CAN_FS1R_FSC21     = 0x200000  // Bit FSC21.
	CAN_FS1R_FSC22_Pos = 0x16      // Position of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000  // Bit mask of FSC22 field.
	CAN_FS1R_FSC22     = 0x400000  // Bit FSC22.
	CAN_FS1R_FSC23_Pos = 0x17      // Position of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000  // Bit mask of FSC23 field.
	CAN_FS1R_FSC23     = 0x800000  // Bit FSC23.
	CAN_FS1R_FSC24_Pos = 0x18      // Position of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000 // Bit mask of FSC24 field.
	CAN_FS1R_FSC24     = 0x1000000 // Bit FSC24.
	CAN_FS1R_FSC25_Pos = 0x19      // Position of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000 // Bit mask of FSC25 field.
	CAN_FS1R_FSC25     = 0x2000000 // Bit FSC25.
	CAN_FS1R_FSC26_Pos = 0x1a      // Position of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000 // Bit mask of FSC26 field.
	CAN_FS1R_FSC26     = 0x4000000 // Bit FSC26.
	CAN_FS1R_FSC27_Pos = 0x1b      // Position of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000 // Bit mask of FSC27 field.
	CAN_FS1R_FSC27     = 0x8000000 // Bit FSC27.

	// FFA1R: filter FIFO assignment           register
	CAN_FFA1R_FFA0_Pos  = 0x0       // Position of FFA0 field.
	CAN_FFA1R_FFA0_Msk  = 0x1       // Bit mask of FFA0 field.
	CAN_FFA1R_FFA0      = 0x1       // Bit FFA0.
	CAN_FFA1R_FFA1_Pos  = 0x1       // Position of FFA1 field.
	CAN_FFA1R_FFA1_Msk  = 0x2       // Bit mask of FFA1 field.
	CAN_FFA1R_FFA1      = 0x2       // Bit FFA1.
	CAN_FFA1R_FFA2_Pos  = 0x2       // Position of FFA2 field.
	CAN_FFA1R_FFA2_Msk  = 0x4       // Bit mask of FFA2 field.
	CAN_FFA1R_FFA2      = 0x4       // Bit FFA2.
	CAN_FFA1R_FFA3_Pos  = 0x3       // Position of FFA3 field.
	CAN_FFA1R_FFA3_Msk  = 0x8       // Bit mask of FFA3 field.
	CAN_FFA1R_FFA3      = 0x8       // Bit FFA3.
	CAN_FFA1R_FFA4_Pos  = 0x4       // Position of FFA4 field.
	CAN_FFA1R_FFA4_Msk  = 0x10      // Bit mask of FFA4 field.
	CAN_FFA1R_FFA4      = 0x10      // Bit FFA4.
	CAN_FFA1R_FFA5_Pos  = 0x5       // Position of FFA5 field.
	CAN_FFA1R_FFA5_Msk  = 0x20      // Bit mask of FFA5 field.
	CAN_FFA1R_FFA5      = 0x20      // Bit FFA5.
	CAN_FFA1R_FFA6_Pos  = 0x6       // Position of FFA6 field.
	CAN_FFA1R_FFA6_Msk  = 0x40      // Bit mask of FFA6 field.
	CAN_FFA1R_FFA6      = 0x40      // Bit FFA6.
	CAN_FFA1R_FFA7_Pos  = 0x7       // Position of FFA7 field.
	CAN_FFA1R_FFA7_Msk  = 0x80      // Bit mask of FFA7 field.
	CAN_FFA1R_FFA7      = 0x80      // Bit FFA7.
	CAN_FFA1R_FFA8_Pos  = 0x8       // Position of FFA8 field.
	CAN_FFA1R_FFA8_Msk  = 0x100     // Bit mask of FFA8 field.
	CAN_FFA1R_FFA8      = 0x100     // Bit FFA8.
	CAN_FFA1R_FFA9_Pos  = 0x9       // Position of FFA9 field.
	CAN_FFA1R_FFA9_Msk  = 0x200     // Bit mask of FFA9 field.
	CAN_FFA1R_FFA9      = 0x200     // Bit FFA9.
	CAN_FFA1R_FFA10_Pos = 0xa       // Position of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400     // Bit mask of FFA10 field.
	CAN_FFA1R_FFA10     = 0x400     // Bit FFA10.
	CAN_FFA1R_FFA11_Pos = 0xb       // Position of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800     // Bit mask of FFA11 field.
	CAN_FFA1R_FFA11     = 0x800     // Bit FFA11.
	CAN_FFA1R_FFA12_Pos = 0xc       // Position of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000    // Bit mask of FFA12 field.
	CAN_FFA1R_FFA12     = 0x1000    // Bit FFA12.
	CAN_FFA1R_FFA13_Pos = 0xd       // Position of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000    // Bit mask of FFA13 field.
	CAN_FFA1R_FFA13     = 0x2000    // Bit FFA13.
	CAN_FFA1R_FFA14_Pos = 0xe       // Position of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000    // Bit mask of FFA14 field.
	CAN_FFA1R_FFA14     = 0x4000    // Bit FFA14.
	CAN_FFA1R_FFA15_Pos = 0xf       // Position of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000    // Bit mask of FFA15 field.
	CAN_FFA1R_FFA15     = 0x8000    // Bit FFA15.
	CAN_FFA1R_FFA16_Pos = 0x10      // Position of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000   // Bit mask of FFA16 field.
	CAN_FFA1R_FFA16     = 0x10000   // Bit FFA16.
	CAN_FFA1R_FFA17_Pos = 0x11      // Position of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000   // Bit mask of FFA17 field.
	CAN_FFA1R_FFA17     = 0x20000   // Bit FFA17.
	CAN_FFA1R_FFA18_Pos = 0x12      // Position of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000   // Bit mask of FFA18 field.
	CAN_FFA1R_FFA18     = 0x40000   // Bit FFA18.
	CAN_FFA1R_FFA19_Pos = 0x13      // Position of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000   // Bit mask of FFA19 field.
	CAN_FFA1R_FFA19     = 0x80000   // Bit FFA19.
	CAN_FFA1R_FFA20_Pos = 0x14      // Position of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000  // Bit mask of FFA20 field.
	CAN_FFA1R_FFA20     = 0x100000  // Bit FFA20.
	CAN_FFA1R_FFA21_Pos = 0x15      // Position of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000  // Bit mask of FFA21 field.
	CAN_FFA1R_FFA21     = 0x200000  // Bit FFA21.
	CAN_FFA1R_FFA22_Pos = 0x16      // Position of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000  // Bit mask of FFA22 field.
	CAN_FFA1R_FFA22     = 0x400000  // Bit FFA22.
	CAN_FFA1R_FFA23_Pos = 0x17      // Position of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000  // Bit mask of FFA23 field.
	CAN_FFA1R_FFA23     = 0x800000  // Bit FFA23.
	CAN_FFA1R_FFA24_Pos = 0x18      // Position of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000 // Bit mask of FFA24 field.
	CAN_FFA1R_FFA24     = 0x1000000 // Bit FFA24.
	CAN_FFA1R_FFA25_Pos = 0x19      // Position of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000 // Bit mask of FFA25 field.
	CAN_FFA1R_FFA25     = 0x2000000 // Bit FFA25.
	CAN_FFA1R_FFA26_Pos = 0x1a      // Position of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000 // Bit mask of FFA26 field.
	CAN_FFA1R_FFA26     = 0x4000000 // Bit FFA26.
	CAN_FFA1R_FFA27_Pos = 0x1b      // Position of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000 // Bit mask of FFA27 field.
	CAN_FFA1R_FFA27     = 0x8000000 // Bit FFA27.

	// FA1R: filter activation register
	CAN_FA1R_FACT0_Pos  = 0x0       // Position of FACT0 field.
	CAN_FA1R_FACT0_Msk  = 0x1       // Bit mask of FACT0 field.
	CAN_FA1R_FACT0      = 0x1       // Bit FACT0.
	CAN_FA1R_FACT1_Pos  = 0x1       // Position of FACT1 field.
	CAN_FA1R_FACT1_Msk  = 0x2       // Bit mask of FACT1 field.
	CAN_FA1R_FACT1      = 0x2       // Bit FACT1.
	CAN_FA1R_FACT2_Pos  = 0x2       // Position of FACT2 field.
	CAN_FA1R_FACT2_Msk  = 0x4       // Bit mask of FACT2 field.
	CAN_FA1R_FACT2      = 0x4       // Bit FACT2.
	CAN_FA1R_FACT3_Pos  = 0x3       // Position of FACT3 field.
	CAN_FA1R_FACT3_Msk  = 0x8       // Bit mask of FACT3 field.
	CAN_FA1R_FACT3      = 0x8       // Bit FACT3.
	CAN_FA1R_FACT4_Pos  = 0x4       // Position of FACT4 field.
	CAN_FA1R_FACT4_Msk  = 0x10      // Bit mask of FACT4 field.
	CAN_FA1R_FACT4      = 0x10      // Bit FACT4.
	CAN_FA1R_FACT5_Pos  = 0x5       // Position of FACT5 field.
	CAN_FA1R_FACT5_Msk  = 0x20      // Bit mask of FACT5 field.
	CAN_FA1R_FACT5      = 0x20      // Bit FACT5.
	CAN_FA1R_FACT6_Pos  = 0x6       // Position of FACT6 field.
	CAN_FA1R_FACT6_Msk  = 0x40      // Bit mask of FACT6 field.
	CAN_FA1R_FACT6      = 0x40      // Bit FACT6.
	CAN_FA1R_FACT7_Pos  = 0x7       // Position of FACT7 field.
	CAN_FA1R_FACT7_Msk  = 0x80      // Bit mask of FACT7 field.
	CAN_FA1R_FACT7      = 0x80      // Bit FACT7.
	CAN_FA1R_FACT8_Pos  = 0x8       // Position of FACT8 field.
	CAN_FA1R_FACT8_Msk  = 0x100     // Bit mask of FACT8 field.
	CAN_FA1R_FACT8      = 0x100     // Bit FACT8.
	CAN_FA1R_FACT9_Pos  = 0x9       // Position of FACT9 field.
	CAN_FA1R_FACT9_Msk  = 0x200     // Bit mask of FACT9 field.
	CAN_FA1R_FACT9      = 0x200     // Bit FACT9.
	CAN_FA1R_FACT10_Pos = 0xa       // Position of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400     // Bit mask of FACT10 field.
	CAN_FA1R_FACT10     = 0x400     // Bit FACT10.
	CAN_FA1R_FACT11_Pos = 0xb       // Position of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800     // Bit mask of FACT11 field.
	CAN_FA1R_FACT11     = 0x800     // Bit FACT11.
	CAN_FA1R_FACT12_Pos = 0xc       // Position of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000    // Bit mask of FACT12 field.
	CAN_FA1R_FACT12     = 0x1000    // Bit FACT12.
	CAN_FA1R_FACT13_Pos = 0xd       // Position of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000    // Bit mask of FACT13 field.
	CAN_FA1R_FACT13     = 0x2000    // Bit FACT13.
	CAN_FA1R_FACT14_Pos = 0xe       // Position of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000    // Bit mask of FACT14 field.
	CAN_FA1R_FACT14     = 0x4000    // Bit FACT14.
	CAN_FA1R_FACT15_Pos = 0xf       // Position of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000    // Bit mask of FACT15 field.
	CAN_FA1R_FACT15     = 0x8000    // Bit FACT15.
	CAN_FA1R_FACT16_Pos = 0x10      // Position of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000   // Bit mask of FACT16 field.
	CAN_FA1R_FACT16     = 0x10000   // Bit FACT16.
	CAN_FA1R_FACT17_Pos = 0x11      // Position of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000   // Bit mask of FACT17 field.
	CAN_FA1R_FACT17     = 0x20000   // Bit FACT17.
	CAN_FA1R_FACT18_Pos = 0x12      // Position of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000   // Bit mask of FACT18 field.
	CAN_FA1R_FACT18     = 0x40000   // Bit FACT18.
	CAN_FA1R_FACT19_Pos = 0x13      // Position of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000   // Bit mask of FACT19 field.
	CAN_FA1R_FACT19     = 0x80000   // Bit FACT19.
	CAN_FA1R_FACT20_Pos = 0x14      // Position of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000  // Bit mask of FACT20 field.
	CAN_FA1R_FACT20     = 0x100000  // Bit FACT20.
	CAN_FA1R_FACT21_Pos = 0x15      // Position of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000  // Bit mask of FACT21 field.
	CAN_FA1R_FACT21     = 0x200000  // Bit FACT21.
	CAN_FA1R_FACT22_Pos = 0x16      // Position of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000  // Bit mask of FACT22 field.
	CAN_FA1R_FACT22     = 0x400000  // Bit FACT22.
	CAN_FA1R_FACT23_Pos = 0x17      // Position of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000  // Bit mask of FACT23 field.
	CAN_FA1R_FACT23     = 0x800000  // Bit FACT23.
	CAN_FA1R_FACT24_Pos = 0x18      // Position of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000 // Bit mask of FACT24 field.
	CAN_FA1R_FACT24     = 0x1000000 // Bit FACT24.
	CAN_FA1R_FACT25_Pos = 0x19      // Position of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000 // Bit mask of FACT25 field.
	CAN_FA1R_FACT25     = 0x2000000 // Bit FACT25.
	CAN_FA1R_FACT26_Pos = 0x1a      // Position of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000 // Bit mask of FACT26 field.
	CAN_FA1R_FACT26     = 0x4000000 // Bit FACT26.
	CAN_FA1R_FACT27_Pos = 0x1b      // Position of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000 // Bit mask of FACT27 field.
	CAN_FA1R_FACT27     = 0x8000000 // Bit FACT27.

	// F0R1: Filter bank 0 register 1
	CAN_F0R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R1_FB0      = 0x1        // Bit FB0.
	CAN_F0R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R1_FB1      = 0x2        // Bit FB1.
	CAN_F0R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R1_FB2      = 0x4        // Bit FB2.
	CAN_F0R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R1_FB3      = 0x8        // Bit FB3.
	CAN_F0R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R1_FB4      = 0x10       // Bit FB4.
	CAN_F0R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R1_FB5      = 0x20       // Bit FB5.
	CAN_F0R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R1_FB6      = 0x40       // Bit FB6.
	CAN_F0R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R1_FB7      = 0x80       // Bit FB7.
	CAN_F0R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R1_FB8      = 0x100      // Bit FB8.
	CAN_F0R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R1_FB9      = 0x200      // Bit FB9.
	CAN_F0R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R1_FB10     = 0x400      // Bit FB10.
	CAN_F0R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R1_FB11     = 0x800      // Bit FB11.
	CAN_F0R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R1_FB12     = 0x1000     // Bit FB12.
	CAN_F0R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R1_FB13     = 0x2000     // Bit FB13.
	CAN_F0R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R1_FB14     = 0x4000     // Bit FB14.
	CAN_F0R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R1_FB15     = 0x8000     // Bit FB15.
	CAN_F0R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R1_FB16     = 0x10000    // Bit FB16.
	CAN_F0R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R1_FB17     = 0x20000    // Bit FB17.
	CAN_F0R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R1_FB18     = 0x40000    // Bit FB18.
	CAN_F0R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R1_FB19     = 0x80000    // Bit FB19.
	CAN_F0R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R1_FB20     = 0x100000   // Bit FB20.
	CAN_F0R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R1_FB21     = 0x200000   // Bit FB21.
	CAN_F0R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R1_FB22     = 0x400000   // Bit FB22.
	CAN_F0R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R1_FB23     = 0x800000   // Bit FB23.
	CAN_F0R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R1_FB31     = 0x80000000 // Bit FB31.

	// F0R2: Filter bank 0 register 2
	CAN_F0R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R2_FB0      = 0x1        // Bit FB0.
	CAN_F0R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R2_FB1      = 0x2        // Bit FB1.
	CAN_F0R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R2_FB2      = 0x4        // Bit FB2.
	CAN_F0R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R2_FB3      = 0x8        // Bit FB3.
	CAN_F0R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R2_FB4      = 0x10       // Bit FB4.
	CAN_F0R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R2_FB5      = 0x20       // Bit FB5.
	CAN_F0R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R2_FB6      = 0x40       // Bit FB6.
	CAN_F0R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R2_FB7      = 0x80       // Bit FB7.
	CAN_F0R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R2_FB8      = 0x100      // Bit FB8.
	CAN_F0R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R2_FB9      = 0x200      // Bit FB9.
	CAN_F0R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R2_FB10     = 0x400      // Bit FB10.
	CAN_F0R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R2_FB11     = 0x800      // Bit FB11.
	CAN_F0R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R2_FB12     = 0x1000     // Bit FB12.
	CAN_F0R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R2_FB13     = 0x2000     // Bit FB13.
	CAN_F0R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R2_FB14     = 0x4000     // Bit FB14.
	CAN_F0R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R2_FB15     = 0x8000     // Bit FB15.
	CAN_F0R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R2_FB16     = 0x10000    // Bit FB16.
	CAN_F0R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R2_FB17     = 0x20000    // Bit FB17.
	CAN_F0R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R2_FB18     = 0x40000    // Bit FB18.
	CAN_F0R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R2_FB19     = 0x80000    // Bit FB19.
	CAN_F0R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R2_FB20     = 0x100000   // Bit FB20.
	CAN_F0R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R2_FB21     = 0x200000   // Bit FB21.
	CAN_F0R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R2_FB22     = 0x400000   // Bit FB22.
	CAN_F0R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R2_FB23     = 0x800000   // Bit FB23.
	CAN_F0R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R2_FB31     = 0x80000000 // Bit FB31.

	// F1R1: Filter bank 1 register 1
	CAN_F1R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R1_FB0      = 0x1        // Bit FB0.
	CAN_F1R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R1_FB1      = 0x2        // Bit FB1.
	CAN_F1R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R1_FB2      = 0x4        // Bit FB2.
	CAN_F1R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R1_FB3      = 0x8        // Bit FB3.
	CAN_F1R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R1_FB4      = 0x10       // Bit FB4.
	CAN_F1R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R1_FB5      = 0x20       // Bit FB5.
	CAN_F1R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R1_FB6      = 0x40       // Bit FB6.
	CAN_F1R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R1_FB7      = 0x80       // Bit FB7.
	CAN_F1R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R1_FB8      = 0x100      // Bit FB8.
	CAN_F1R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R1_FB9      = 0x200      // Bit FB9.
	CAN_F1R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R1_FB10     = 0x400      // Bit FB10.
	CAN_F1R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R1_FB11     = 0x800      // Bit FB11.
	CAN_F1R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R1_FB12     = 0x1000     // Bit FB12.
	CAN_F1R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R1_FB13     = 0x2000     // Bit FB13.
	CAN_F1R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R1_FB14     = 0x4000     // Bit FB14.
	CAN_F1R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R1_FB15     = 0x8000     // Bit FB15.
	CAN_F1R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R1_FB16     = 0x10000    // Bit FB16.
	CAN_F1R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R1_FB17     = 0x20000    // Bit FB17.
	CAN_F1R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R1_FB18     = 0x40000    // Bit FB18.
	CAN_F1R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R1_FB19     = 0x80000    // Bit FB19.
	CAN_F1R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R1_FB20     = 0x100000   // Bit FB20.
	CAN_F1R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R1_FB21     = 0x200000   // Bit FB21.
	CAN_F1R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R1_FB22     = 0x400000   // Bit FB22.
	CAN_F1R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R1_FB23     = 0x800000   // Bit FB23.
	CAN_F1R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R1_FB31     = 0x80000000 // Bit FB31.

	// F1R2: Filter bank 1 register 2
	CAN_F1R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R2_FB0      = 0x1        // Bit FB0.
	CAN_F1R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R2_FB1      = 0x2        // Bit FB1.
	CAN_F1R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R2_FB2      = 0x4        // Bit FB2.
	CAN_F1R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R2_FB3      = 0x8        // Bit FB3.
	CAN_F1R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R2_FB4      = 0x10       // Bit FB4.
	CAN_F1R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R2_FB5      = 0x20       // Bit FB5.
	CAN_F1R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R2_FB6      = 0x40       // Bit FB6.
	CAN_F1R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R2_FB7      = 0x80       // Bit FB7.
	CAN_F1R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R2_FB8      = 0x100      // Bit FB8.
	CAN_F1R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R2_FB9      = 0x200      // Bit FB9.
	CAN_F1R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R2_FB10     = 0x400      // Bit FB10.
	CAN_F1R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R2_FB11     = 0x800      // Bit FB11.
	CAN_F1R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R2_FB12     = 0x1000     // Bit FB12.
	CAN_F1R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R2_FB13     = 0x2000     // Bit FB13.
	CAN_F1R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R2_FB14     = 0x4000     // Bit FB14.
	CAN_F1R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R2_FB15     = 0x8000     // Bit FB15.
	CAN_F1R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R2_FB16     = 0x10000    // Bit FB16.
	CAN_F1R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R2_FB17     = 0x20000    // Bit FB17.
	CAN_F1R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R2_FB18     = 0x40000    // Bit FB18.
	CAN_F1R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R2_FB19     = 0x80000    // Bit FB19.
	CAN_F1R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R2_FB20     = 0x100000   // Bit FB20.
	CAN_F1R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R2_FB21     = 0x200000   // Bit FB21.
	CAN_F1R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R2_FB22     = 0x400000   // Bit FB22.
	CAN_F1R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R2_FB23     = 0x800000   // Bit FB23.
	CAN_F1R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R2_FB31     = 0x80000000 // Bit FB31.

	// F2R1: Filter bank 2 register 1
	CAN_F2R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R1_FB0      = 0x1        // Bit FB0.
	CAN_F2R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R1_FB1      = 0x2        // Bit FB1.
	CAN_F2R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R1_FB2      = 0x4        // Bit FB2.
	CAN_F2R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R1_FB3      = 0x8        // Bit FB3.
	CAN_F2R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R1_FB4      = 0x10       // Bit FB4.
	CAN_F2R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R1_FB5      = 0x20       // Bit FB5.
	CAN_F2R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R1_FB6      = 0x40       // Bit FB6.
	CAN_F2R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R1_FB7      = 0x80       // Bit FB7.
	CAN_F2R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R1_FB8      = 0x100      // Bit FB8.
	CAN_F2R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R1_FB9      = 0x200      // Bit FB9.
	CAN_F2R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R1_FB10     = 0x400      // Bit FB10.
	CAN_F2R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R1_FB11     = 0x800      // Bit FB11.
	CAN_F2R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R1_FB12     = 0x1000     // Bit FB12.
	CAN_F2R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R1_FB13     = 0x2000     // Bit FB13.
	CAN_F2R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R1_FB14     = 0x4000     // Bit FB14.
	CAN_F2R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R1_FB15     = 0x8000     // Bit FB15.
	CAN_F2R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R1_FB16     = 0x10000    // Bit FB16.
	CAN_F2R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R1_FB17     = 0x20000    // Bit FB17.
	CAN_F2R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R1_FB18     = 0x40000    // Bit FB18.
	CAN_F2R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R1_FB19     = 0x80000    // Bit FB19.
	CAN_F2R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R1_FB20     = 0x100000   // Bit FB20.
	CAN_F2R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R1_FB21     = 0x200000   // Bit FB21.
	CAN_F2R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R1_FB22     = 0x400000   // Bit FB22.
	CAN_F2R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R1_FB23     = 0x800000   // Bit FB23.
	CAN_F2R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R1_FB31     = 0x80000000 // Bit FB31.

	// F2R2: Filter bank 2 register 2
	CAN_F2R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R2_FB0      = 0x1        // Bit FB0.
	CAN_F2R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R2_FB1      = 0x2        // Bit FB1.
	CAN_F2R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R2_FB2      = 0x4        // Bit FB2.
	CAN_F2R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R2_FB3      = 0x8        // Bit FB3.
	CAN_F2R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R2_FB4      = 0x10       // Bit FB4.
	CAN_F2R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R2_FB5      = 0x20       // Bit FB5.
	CAN_F2R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R2_FB6      = 0x40       // Bit FB6.
	CAN_F2R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R2_FB7      = 0x80       // Bit FB7.
	CAN_F2R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R2_FB8      = 0x100      // Bit FB8.
	CAN_F2R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R2_FB9      = 0x200      // Bit FB9.
	CAN_F2R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R2_FB10     = 0x400      // Bit FB10.
	CAN_F2R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R2_FB11     = 0x800      // Bit FB11.
	CAN_F2R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R2_FB12     = 0x1000     // Bit FB12.
	CAN_F2R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R2_FB13     = 0x2000     // Bit FB13.
	CAN_F2R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R2_FB14     = 0x4000     // Bit FB14.
	CAN_F2R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R2_FB15     = 0x8000     // Bit FB15.
	CAN_F2R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R2_FB16     = 0x10000    // Bit FB16.
	CAN_F2R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R2_FB17     = 0x20000    // Bit FB17.
	CAN_F2R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R2_FB18     = 0x40000    // Bit FB18.
	CAN_F2R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R2_FB19     = 0x80000    // Bit FB19.
	CAN_F2R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R2_FB20     = 0x100000   // Bit FB20.
	CAN_F2R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R2_FB21     = 0x200000   // Bit FB21.
	CAN_F2R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R2_FB22     = 0x400000   // Bit FB22.
	CAN_F2R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R2_FB23     = 0x800000   // Bit FB23.
	CAN_F2R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R2_FB31     = 0x80000000 // Bit FB31.

	// F3R1: Filter bank 3 register 1
	CAN_F3R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R1_FB0      = 0x1        // Bit FB0.
	CAN_F3R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R1_FB1      = 0x2        // Bit FB1.
	CAN_F3R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R1_FB2      = 0x4        // Bit FB2.
	CAN_F3R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R1_FB3      = 0x8        // Bit FB3.
	CAN_F3R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R1_FB4      = 0x10       // Bit FB4.
	CAN_F3R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R1_FB5      = 0x20       // Bit FB5.
	CAN_F3R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R1_FB6      = 0x40       // Bit FB6.
	CAN_F3R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R1_FB7      = 0x80       // Bit FB7.
	CAN_F3R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R1_FB8      = 0x100      // Bit FB8.
	CAN_F3R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R1_FB9      = 0x200      // Bit FB9.
	CAN_F3R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R1_FB10     = 0x400      // Bit FB10.
	CAN_F3R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R1_FB11     = 0x800      // Bit FB11.
	CAN_F3R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R1_FB12     = 0x1000     // Bit FB12.
	CAN_F3R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R1_FB13     = 0x2000     // Bit FB13.
	CAN_F3R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R1_FB14     = 0x4000     // Bit FB14.
	CAN_F3R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R1_FB15     = 0x8000     // Bit FB15.
	CAN_F3R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R1_FB16     = 0x10000    // Bit FB16.
	CAN_F3R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R1_FB17     = 0x20000    // Bit FB17.
	CAN_F3R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R1_FB18     = 0x40000    // Bit FB18.
	CAN_F3R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R1_FB19     = 0x80000    // Bit FB19.
	CAN_F3R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R1_FB20     = 0x100000   // Bit FB20.
	CAN_F3R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R1_FB21     = 0x200000   // Bit FB21.
	CAN_F3R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R1_FB22     = 0x400000   // Bit FB22.
	CAN_F3R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R1_FB23     = 0x800000   // Bit FB23.
	CAN_F3R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R1_FB31     = 0x80000000 // Bit FB31.

	// F3R2: Filter bank 3 register 2
	CAN_F3R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R2_FB0      = 0x1        // Bit FB0.
	CAN_F3R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R2_FB1      = 0x2        // Bit FB1.
	CAN_F3R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R2_FB2      = 0x4        // Bit FB2.
	CAN_F3R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R2_FB3      = 0x8        // Bit FB3.
	CAN_F3R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R2_FB4      = 0x10       // Bit FB4.
	CAN_F3R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R2_FB5      = 0x20       // Bit FB5.
	CAN_F3R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R2_FB6      = 0x40       // Bit FB6.
	CAN_F3R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R2_FB7      = 0x80       // Bit FB7.
	CAN_F3R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R2_FB8      = 0x100      // Bit FB8.
	CAN_F3R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R2_FB9      = 0x200      // Bit FB9.
	CAN_F3R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R2_FB10     = 0x400      // Bit FB10.
	CAN_F3R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R2_FB11     = 0x800      // Bit FB11.
	CAN_F3R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R2_FB12     = 0x1000     // Bit FB12.
	CAN_F3R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R2_FB13     = 0x2000     // Bit FB13.
	CAN_F3R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R2_FB14     = 0x4000     // Bit FB14.
	CAN_F3R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R2_FB15     = 0x8000     // Bit FB15.
	CAN_F3R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R2_FB16     = 0x10000    // Bit FB16.
	CAN_F3R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R2_FB17     = 0x20000    // Bit FB17.
	CAN_F3R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R2_FB18     = 0x40000    // Bit FB18.
	CAN_F3R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R2_FB19     = 0x80000    // Bit FB19.
	CAN_F3R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R2_FB20     = 0x100000   // Bit FB20.
	CAN_F3R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R2_FB21     = 0x200000   // Bit FB21.
	CAN_F3R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R2_FB22     = 0x400000   // Bit FB22.
	CAN_F3R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R2_FB23     = 0x800000   // Bit FB23.
	CAN_F3R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R2_FB31     = 0x80000000 // Bit FB31.

	// F4R1: Filter bank 4 register 1
	CAN_F4R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R1_FB0      = 0x1        // Bit FB0.
	CAN_F4R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R1_FB1      = 0x2        // Bit FB1.
	CAN_F4R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R1_FB2      = 0x4        // Bit FB2.
	CAN_F4R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R1_FB3      = 0x8        // Bit FB3.
	CAN_F4R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R1_FB4      = 0x10       // Bit FB4.
	CAN_F4R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R1_FB5      = 0x20       // Bit FB5.
	CAN_F4R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R1_FB6      = 0x40       // Bit FB6.
	CAN_F4R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R1_FB7      = 0x80       // Bit FB7.
	CAN_F4R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R1_FB8      = 0x100      // Bit FB8.
	CAN_F4R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R1_FB9      = 0x200      // Bit FB9.
	CAN_F4R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R1_FB10     = 0x400      // Bit FB10.
	CAN_F4R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R1_FB11     = 0x800      // Bit FB11.
	CAN_F4R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R1_FB12     = 0x1000     // Bit FB12.
	CAN_F4R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R1_FB13     = 0x2000     // Bit FB13.
	CAN_F4R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R1_FB14     = 0x4000     // Bit FB14.
	CAN_F4R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R1_FB15     = 0x8000     // Bit FB15.
	CAN_F4R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R1_FB16     = 0x10000    // Bit FB16.
	CAN_F4R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R1_FB17     = 0x20000    // Bit FB17.
	CAN_F4R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R1_FB18     = 0x40000    // Bit FB18.
	CAN_F4R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R1_FB19     = 0x80000    // Bit FB19.
	CAN_F4R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R1_FB20     = 0x100000   // Bit FB20.
	CAN_F4R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R1_FB21     = 0x200000   // Bit FB21.
	CAN_F4R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R1_FB22     = 0x400000   // Bit FB22.
	CAN_F4R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R1_FB23     = 0x800000   // Bit FB23.
	CAN_F4R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R1_FB31     = 0x80000000 // Bit FB31.

	// F4R2: Filter bank 4 register 2
	CAN_F4R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R2_FB0      = 0x1        // Bit FB0.
	CAN_F4R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R2_FB1      = 0x2        // Bit FB1.
	CAN_F4R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R2_FB2      = 0x4        // Bit FB2.
	CAN_F4R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R2_FB3      = 0x8        // Bit FB3.
	CAN_F4R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R2_FB4      = 0x10       // Bit FB4.
	CAN_F4R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R2_FB5      = 0x20       // Bit FB5.
	CAN_F4R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R2_FB6      = 0x40       // Bit FB6.
	CAN_F4R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R2_FB7      = 0x80       // Bit FB7.
	CAN_F4R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R2_FB8      = 0x100      // Bit FB8.
	CAN_F4R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R2_FB9      = 0x200      // Bit FB9.
	CAN_F4R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R2_FB10     = 0x400      // Bit FB10.
	CAN_F4R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R2_FB11     = 0x800      // Bit FB11.
	CAN_F4R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R2_FB12     = 0x1000     // Bit FB12.
	CAN_F4R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R2_FB13     = 0x2000     // Bit FB13.
	CAN_F4R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R2_FB14     = 0x4000     // Bit FB14.
	CAN_F4R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R2_FB15     = 0x8000     // Bit FB15.
	CAN_F4R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R2_FB16     = 0x10000    // Bit FB16.
	CAN_F4R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R2_FB17     = 0x20000    // Bit FB17.
	CAN_F4R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R2_FB18     = 0x40000    // Bit FB18.
	CAN_F4R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R2_FB19     = 0x80000    // Bit FB19.
	CAN_F4R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R2_FB20     = 0x100000   // Bit FB20.
	CAN_F4R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R2_FB21     = 0x200000   // Bit FB21.
	CAN_F4R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R2_FB22     = 0x400000   // Bit FB22.
	CAN_F4R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R2_FB23     = 0x800000   // Bit FB23.
	CAN_F4R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R2_FB31     = 0x80000000 // Bit FB31.

	// F5R1: Filter bank 5 register 1
	CAN_F5R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R1_FB0      = 0x1        // Bit FB0.
	CAN_F5R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R1_FB1      = 0x2        // Bit FB1.
	CAN_F5R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R1_FB2      = 0x4        // Bit FB2.
	CAN_F5R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R1_FB3      = 0x8        // Bit FB3.
	CAN_F5R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R1_FB4      = 0x10       // Bit FB4.
	CAN_F5R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R1_FB5      = 0x20       // Bit FB5.
	CAN_F5R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R1_FB6      = 0x40       // Bit FB6.
	CAN_F5R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R1_FB7      = 0x80       // Bit FB7.
	CAN_F5R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R1_FB8      = 0x100      // Bit FB8.
	CAN_F5R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R1_FB9      = 0x200      // Bit FB9.
	CAN_F5R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R1_FB10     = 0x400      // Bit FB10.
	CAN_F5R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R1_FB11     = 0x800      // Bit FB11.
	CAN_F5R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R1_FB12     = 0x1000     // Bit FB12.
	CAN_F5R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R1_FB13     = 0x2000     // Bit FB13.
	CAN_F5R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R1_FB14     = 0x4000     // Bit FB14.
	CAN_F5R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R1_FB15     = 0x8000     // Bit FB15.
	CAN_F5R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R1_FB16     = 0x10000    // Bit FB16.
	CAN_F5R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R1_FB17     = 0x20000    // Bit FB17.
	CAN_F5R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R1_FB18     = 0x40000    // Bit FB18.
	CAN_F5R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R1_FB19     = 0x80000    // Bit FB19.
	CAN_F5R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R1_FB20     = 0x100000   // Bit FB20.
	CAN_F5R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R1_FB21     = 0x200000   // Bit FB21.
	CAN_F5R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R1_FB22     = 0x400000   // Bit FB22.
	CAN_F5R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R1_FB23     = 0x800000   // Bit FB23.
	CAN_F5R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R1_FB31     = 0x80000000 // Bit FB31.

	// F5R2: Filter bank 5 register 2
	CAN_F5R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R2_FB0      = 0x1        // Bit FB0.
	CAN_F5R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R2_FB1      = 0x2        // Bit FB1.
	CAN_F5R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R2_FB2      = 0x4        // Bit FB2.
	CAN_F5R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R2_FB3      = 0x8        // Bit FB3.
	CAN_F5R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R2_FB4      = 0x10       // Bit FB4.
	CAN_F5R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R2_FB5      = 0x20       // Bit FB5.
	CAN_F5R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R2_FB6      = 0x40       // Bit FB6.
	CAN_F5R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R2_FB7      = 0x80       // Bit FB7.
	CAN_F5R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R2_FB8      = 0x100      // Bit FB8.
	CAN_F5R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R2_FB9      = 0x200      // Bit FB9.
	CAN_F5R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R2_FB10     = 0x400      // Bit FB10.
	CAN_F5R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R2_FB11     = 0x800      // Bit FB11.
	CAN_F5R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R2_FB12     = 0x1000     // Bit FB12.
	CAN_F5R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R2_FB13     = 0x2000     // Bit FB13.
	CAN_F5R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R2_FB14     = 0x4000     // Bit FB14.
	CAN_F5R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R2_FB15     = 0x8000     // Bit FB15.
	CAN_F5R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R2_FB16     = 0x10000    // Bit FB16.
	CAN_F5R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R2_FB17     = 0x20000    // Bit FB17.
	CAN_F5R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R2_FB18     = 0x40000    // Bit FB18.
	CAN_F5R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R2_FB19     = 0x80000    // Bit FB19.
	CAN_F5R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R2_FB20     = 0x100000   // Bit FB20.
	CAN_F5R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R2_FB21     = 0x200000   // Bit FB21.
	CAN_F5R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R2_FB22     = 0x400000   // Bit FB22.
	CAN_F5R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R2_FB23     = 0x800000   // Bit FB23.
	CAN_F5R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R2_FB31     = 0x80000000 // Bit FB31.

	// F6R1: Filter bank 6 register 1
	CAN_F6R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R1_FB0      = 0x1        // Bit FB0.
	CAN_F6R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R1_FB1      = 0x2        // Bit FB1.
	CAN_F6R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R1_FB2      = 0x4        // Bit FB2.
	CAN_F6R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R1_FB3      = 0x8        // Bit FB3.
	CAN_F6R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R1_FB4      = 0x10       // Bit FB4.
	CAN_F6R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R1_FB5      = 0x20       // Bit FB5.
	CAN_F6R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R1_FB6      = 0x40       // Bit FB6.
	CAN_F6R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R1_FB7      = 0x80       // Bit FB7.
	CAN_F6R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R1_FB8      = 0x100      // Bit FB8.
	CAN_F6R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R1_FB9      = 0x200      // Bit FB9.
	CAN_F6R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R1_FB10     = 0x400      // Bit FB10.
	CAN_F6R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R1_FB11     = 0x800      // Bit FB11.
	CAN_F6R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R1_FB12     = 0x1000     // Bit FB12.
	CAN_F6R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R1_FB13     = 0x2000     // Bit FB13.
	CAN_F6R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R1_FB14     = 0x4000     // Bit FB14.
	CAN_F6R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R1_FB15     = 0x8000     // Bit FB15.
	CAN_F6R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R1_FB16     = 0x10000    // Bit FB16.
	CAN_F6R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R1_FB17     = 0x20000    // Bit FB17.
	CAN_F6R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R1_FB18     = 0x40000    // Bit FB18.
	CAN_F6R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R1_FB19     = 0x80000    // Bit FB19.
	CAN_F6R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R1_FB20     = 0x100000   // Bit FB20.
	CAN_F6R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R1_FB21     = 0x200000   // Bit FB21.
	CAN_F6R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R1_FB22     = 0x400000   // Bit FB22.
	CAN_F6R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R1_FB23     = 0x800000   // Bit FB23.
	CAN_F6R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R1_FB31     = 0x80000000 // Bit FB31.

	// F6R2: Filter bank 6 register 2
	CAN_F6R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R2_FB0      = 0x1        // Bit FB0.
	CAN_F6R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R2_FB1      = 0x2        // Bit FB1.
	CAN_F6R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R2_FB2      = 0x4        // Bit FB2.
	CAN_F6R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R2_FB3      = 0x8        // Bit FB3.
	CAN_F6R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R2_FB4      = 0x10       // Bit FB4.
	CAN_F6R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R2_FB5      = 0x20       // Bit FB5.
	CAN_F6R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R2_FB6      = 0x40       // Bit FB6.
	CAN_F6R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R2_FB7      = 0x80       // Bit FB7.
	CAN_F6R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R2_FB8      = 0x100      // Bit FB8.
	CAN_F6R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R2_FB9      = 0x200      // Bit FB9.
	CAN_F6R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R2_FB10     = 0x400      // Bit FB10.
	CAN_F6R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R2_FB11     = 0x800      // Bit FB11.
	CAN_F6R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R2_FB12     = 0x1000     // Bit FB12.
	CAN_F6R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R2_FB13     = 0x2000     // Bit FB13.
	CAN_F6R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R2_FB14     = 0x4000     // Bit FB14.
	CAN_F6R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R2_FB15     = 0x8000     // Bit FB15.
	CAN_F6R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R2_FB16     = 0x10000    // Bit FB16.
	CAN_F6R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R2_FB17     = 0x20000    // Bit FB17.
	CAN_F6R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R2_FB18     = 0x40000    // Bit FB18.
	CAN_F6R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R2_FB19     = 0x80000    // Bit FB19.
	CAN_F6R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R2_FB20     = 0x100000   // Bit FB20.
	CAN_F6R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R2_FB21     = 0x200000   // Bit FB21.
	CAN_F6R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R2_FB22     = 0x400000   // Bit FB22.
	CAN_F6R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R2_FB23     = 0x800000   // Bit FB23.
	CAN_F6R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R2_FB31     = 0x80000000 // Bit FB31.

	// F7R1: Filter bank 7 register 1
	CAN_F7R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R1_FB0      = 0x1        // Bit FB0.
	CAN_F7R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R1_FB1      = 0x2        // Bit FB1.
	CAN_F7R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R1_FB2      = 0x4        // Bit FB2.
	CAN_F7R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R1_FB3      = 0x8        // Bit FB3.
	CAN_F7R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R1_FB4      = 0x10       // Bit FB4.
	CAN_F7R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R1_FB5      = 0x20       // Bit FB5.
	CAN_F7R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R1_FB6      = 0x40       // Bit FB6.
	CAN_F7R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R1_FB7      = 0x80       // Bit FB7.
	CAN_F7R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R1_FB8      = 0x100      // Bit FB8.
	CAN_F7R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R1_FB9      = 0x200      // Bit FB9.
	CAN_F7R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R1_FB10     = 0x400      // Bit FB10.
	CAN_F7R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R1_FB11     = 0x800      // Bit FB11.
	CAN_F7R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R1_FB12     = 0x1000     // Bit FB12.
	CAN_F7R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R1_FB13     = 0x2000     // Bit FB13.
	CAN_F7R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R1_FB14     = 0x4000     // Bit FB14.
	CAN_F7R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R1_FB15     = 0x8000     // Bit FB15.
	CAN_F7R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R1_FB16     = 0x10000    // Bit FB16.
	CAN_F7R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R1_FB17     = 0x20000    // Bit FB17.
	CAN_F7R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R1_FB18     = 0x40000    // Bit FB18.
	CAN_F7R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R1_FB19     = 0x80000    // Bit FB19.
	CAN_F7R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R1_FB20     = 0x100000   // Bit FB20.
	CAN_F7R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R1_FB21     = 0x200000   // Bit FB21.
	CAN_F7R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R1_FB22     = 0x400000   // Bit FB22.
	CAN_F7R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R1_FB23     = 0x800000   // Bit FB23.
	CAN_F7R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R1_FB31     = 0x80000000 // Bit FB31.

	// F7R2: Filter bank 7 register 2
	CAN_F7R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R2_FB0      = 0x1        // Bit FB0.
	CAN_F7R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R2_FB1      = 0x2        // Bit FB1.
	CAN_F7R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R2_FB2      = 0x4        // Bit FB2.
	CAN_F7R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R2_FB3      = 0x8        // Bit FB3.
	CAN_F7R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R2_FB4      = 0x10       // Bit FB4.
	CAN_F7R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R2_FB5      = 0x20       // Bit FB5.
	CAN_F7R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R2_FB6      = 0x40       // Bit FB6.
	CAN_F7R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R2_FB7      = 0x80       // Bit FB7.
	CAN_F7R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R2_FB8      = 0x100      // Bit FB8.
	CAN_F7R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R2_FB9      = 0x200      // Bit FB9.
	CAN_F7R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R2_FB10     = 0x400      // Bit FB10.
	CAN_F7R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R2_FB11     = 0x800      // Bit FB11.
	CAN_F7R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R2_FB12     = 0x1000     // Bit FB12.
	CAN_F7R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R2_FB13     = 0x2000     // Bit FB13.
	CAN_F7R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R2_FB14     = 0x4000     // Bit FB14.
	CAN_F7R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R2_FB15     = 0x8000     // Bit FB15.
	CAN_F7R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R2_FB16     = 0x10000    // Bit FB16.
	CAN_F7R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R2_FB17     = 0x20000    // Bit FB17.
	CAN_F7R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R2_FB18     = 0x40000    // Bit FB18.
	CAN_F7R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R2_FB19     = 0x80000    // Bit FB19.
	CAN_F7R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R2_FB20     = 0x100000   // Bit FB20.
	CAN_F7R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R2_FB21     = 0x200000   // Bit FB21.
	CAN_F7R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R2_FB22     = 0x400000   // Bit FB22.
	CAN_F7R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R2_FB23     = 0x800000   // Bit FB23.
	CAN_F7R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R2_FB31     = 0x80000000 // Bit FB31.

	// F8R1: Filter bank 8 register 1
	CAN_F8R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R1_FB0      = 0x1        // Bit FB0.
	CAN_F8R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R1_FB1      = 0x2        // Bit FB1.
	CAN_F8R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R1_FB2      = 0x4        // Bit FB2.
	CAN_F8R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R1_FB3      = 0x8        // Bit FB3.
	CAN_F8R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R1_FB4      = 0x10       // Bit FB4.
	CAN_F8R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R1_FB5      = 0x20       // Bit FB5.
	CAN_F8R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R1_FB6      = 0x40       // Bit FB6.
	CAN_F8R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R1_FB7      = 0x80       // Bit FB7.
	CAN_F8R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R1_FB8      = 0x100      // Bit FB8.
	CAN_F8R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R1_FB9      = 0x200      // Bit FB9.
	CAN_F8R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R1_FB10     = 0x400      // Bit FB10.
	CAN_F8R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R1_FB11     = 0x800      // Bit FB11.
	CAN_F8R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R1_FB12     = 0x1000     // Bit FB12.
	CAN_F8R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R1_FB13     = 0x2000     // Bit FB13.
	CAN_F8R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R1_FB14     = 0x4000     // Bit FB14.
	CAN_F8R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R1_FB15     = 0x8000     // Bit FB15.
	CAN_F8R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R1_FB16     = 0x10000    // Bit FB16.
	CAN_F8R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R1_FB17     = 0x20000    // Bit FB17.
	CAN_F8R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R1_FB18     = 0x40000    // Bit FB18.
	CAN_F8R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R1_FB19     = 0x80000    // Bit FB19.
	CAN_F8R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R1_FB20     = 0x100000   // Bit FB20.
	CAN_F8R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R1_FB21     = 0x200000   // Bit FB21.
	CAN_F8R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R1_FB22     = 0x400000   // Bit FB22.
	CAN_F8R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R1_FB23     = 0x800000   // Bit FB23.
	CAN_F8R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R1_FB31     = 0x80000000 // Bit FB31.

	// F8R2: Filter bank 8 register 2
	CAN_F8R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R2_FB0      = 0x1        // Bit FB0.
	CAN_F8R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R2_FB1      = 0x2        // Bit FB1.
	CAN_F8R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R2_FB2      = 0x4        // Bit FB2.
	CAN_F8R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R2_FB3      = 0x8        // Bit FB3.
	CAN_F8R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R2_FB4      = 0x10       // Bit FB4.
	CAN_F8R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R2_FB5      = 0x20       // Bit FB5.
	CAN_F8R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R2_FB6      = 0x40       // Bit FB6.
	CAN_F8R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R2_FB7      = 0x80       // Bit FB7.
	CAN_F8R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R2_FB8      = 0x100      // Bit FB8.
	CAN_F8R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R2_FB9      = 0x200      // Bit FB9.
	CAN_F8R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R2_FB10     = 0x400      // Bit FB10.
	CAN_F8R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R2_FB11     = 0x800      // Bit FB11.
	CAN_F8R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R2_FB12     = 0x1000     // Bit FB12.
	CAN_F8R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R2_FB13     = 0x2000     // Bit FB13.
	CAN_F8R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R2_FB14     = 0x4000     // Bit FB14.
	CAN_F8R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R2_FB15     = 0x8000     // Bit FB15.
	CAN_F8R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R2_FB16     = 0x10000    // Bit FB16.
	CAN_F8R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R2_FB17     = 0x20000    // Bit FB17.
	CAN_F8R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R2_FB18     = 0x40000    // Bit FB18.
	CAN_F8R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R2_FB19     = 0x80000    // Bit FB19.
	CAN_F8R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R2_FB20     = 0x100000   // Bit FB20.
	CAN_F8R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R2_FB21     = 0x200000   // Bit FB21.
	CAN_F8R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R2_FB22     = 0x400000   // Bit FB22.
	CAN_F8R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R2_FB23     = 0x800000   // Bit FB23.
	CAN_F8R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R2_FB31     = 0x80000000 // Bit FB31.

	// F9R1: Filter bank 9 register 1
	CAN_F9R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R1_FB0      = 0x1        // Bit FB0.
	CAN_F9R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R1_FB1      = 0x2        // Bit FB1.
	CAN_F9R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R1_FB2      = 0x4        // Bit FB2.
	CAN_F9R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R1_FB3      = 0x8        // Bit FB3.
	CAN_F9R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R1_FB4      = 0x10       // Bit FB4.
	CAN_F9R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R1_FB5      = 0x20       // Bit FB5.
	CAN_F9R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R1_FB6      = 0x40       // Bit FB6.
	CAN_F9R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R1_FB7      = 0x80       // Bit FB7.
	CAN_F9R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R1_FB8      = 0x100      // Bit FB8.
	CAN_F9R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R1_FB9      = 0x200      // Bit FB9.
	CAN_F9R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R1_FB10     = 0x400      // Bit FB10.
	CAN_F9R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R1_FB11     = 0x800      // Bit FB11.
	CAN_F9R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R1_FB12     = 0x1000     // Bit FB12.
	CAN_F9R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R1_FB13     = 0x2000     // Bit FB13.
	CAN_F9R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R1_FB14     = 0x4000     // Bit FB14.
	CAN_F9R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R1_FB15     = 0x8000     // Bit FB15.
	CAN_F9R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R1_FB16     = 0x10000    // Bit FB16.
	CAN_F9R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R1_FB17     = 0x20000    // Bit FB17.
	CAN_F9R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R1_FB18     = 0x40000    // Bit FB18.
	CAN_F9R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R1_FB19     = 0x80000    // Bit FB19.
	CAN_F9R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R1_FB20     = 0x100000   // Bit FB20.
	CAN_F9R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R1_FB21     = 0x200000   // Bit FB21.
	CAN_F9R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R1_FB22     = 0x400000   // Bit FB22.
	CAN_F9R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R1_FB23     = 0x800000   // Bit FB23.
	CAN_F9R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R1_FB31     = 0x80000000 // Bit FB31.

	// F9R2: Filter bank 9 register 2
	CAN_F9R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R2_FB0      = 0x1        // Bit FB0.
	CAN_F9R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R2_FB1      = 0x2        // Bit FB1.
	CAN_F9R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R2_FB2      = 0x4        // Bit FB2.
	CAN_F9R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R2_FB3      = 0x8        // Bit FB3.
	CAN_F9R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R2_FB4      = 0x10       // Bit FB4.
	CAN_F9R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R2_FB5      = 0x20       // Bit FB5.
	CAN_F9R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R2_FB6      = 0x40       // Bit FB6.
	CAN_F9R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R2_FB7      = 0x80       // Bit FB7.
	CAN_F9R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R2_FB8      = 0x100      // Bit FB8.
	CAN_F9R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R2_FB9      = 0x200      // Bit FB9.
	CAN_F9R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R2_FB10     = 0x400      // Bit FB10.
	CAN_F9R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R2_FB11     = 0x800      // Bit FB11.
	CAN_F9R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R2_FB12     = 0x1000     // Bit FB12.
	CAN_F9R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R2_FB13     = 0x2000     // Bit FB13.
	CAN_F9R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R2_FB14     = 0x4000     // Bit FB14.
	CAN_F9R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R2_FB15     = 0x8000     // Bit FB15.
	CAN_F9R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R2_FB16     = 0x10000    // Bit FB16.
	CAN_F9R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R2_FB17     = 0x20000    // Bit FB17.
	CAN_F9R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R2_FB18     = 0x40000    // Bit FB18.
	CAN_F9R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R2_FB19     = 0x80000    // Bit FB19.
	CAN_F9R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R2_FB20     = 0x100000   // Bit FB20.
	CAN_F9R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R2_FB21     = 0x200000   // Bit FB21.
	CAN_F9R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R2_FB22     = 0x400000   // Bit FB22.
	CAN_F9R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R2_FB23     = 0x800000   // Bit FB23.
	CAN_F9R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R2_FB31     = 0x80000000 // Bit FB31.

	// F10R1: Filter bank 10 register 1
	CAN_F10R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R1_FB0      = 0x1        // Bit FB0.
	CAN_F10R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R1_FB1      = 0x2        // Bit FB1.
	CAN_F10R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R1_FB2      = 0x4        // Bit FB2.
	CAN_F10R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R1_FB3      = 0x8        // Bit FB3.
	CAN_F10R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R1_FB4      = 0x10       // Bit FB4.
	CAN_F10R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R1_FB5      = 0x20       // Bit FB5.
	CAN_F10R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R1_FB6      = 0x40       // Bit FB6.
	CAN_F10R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R1_FB7      = 0x80       // Bit FB7.
	CAN_F10R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R1_FB8      = 0x100      // Bit FB8.
	CAN_F10R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R1_FB9      = 0x200      // Bit FB9.
	CAN_F10R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R1_FB10     = 0x400      // Bit FB10.
	CAN_F10R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R1_FB11     = 0x800      // Bit FB11.
	CAN_F10R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R1_FB12     = 0x1000     // Bit FB12.
	CAN_F10R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R1_FB13     = 0x2000     // Bit FB13.
	CAN_F10R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R1_FB14     = 0x4000     // Bit FB14.
	CAN_F10R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R1_FB15     = 0x8000     // Bit FB15.
	CAN_F10R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R1_FB16     = 0x10000    // Bit FB16.
	CAN_F10R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R1_FB17     = 0x20000    // Bit FB17.
	CAN_F10R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R1_FB18     = 0x40000    // Bit FB18.
	CAN_F10R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R1_FB19     = 0x80000    // Bit FB19.
	CAN_F10R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R1_FB20     = 0x100000   // Bit FB20.
	CAN_F10R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R1_FB21     = 0x200000   // Bit FB21.
	CAN_F10R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R1_FB22     = 0x400000   // Bit FB22.
	CAN_F10R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R1_FB23     = 0x800000   // Bit FB23.
	CAN_F10R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R1_FB31     = 0x80000000 // Bit FB31.

	// F10R2: Filter bank 10 register 2
	CAN_F10R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R2_FB0      = 0x1        // Bit FB0.
	CAN_F10R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R2_FB1      = 0x2        // Bit FB1.
	CAN_F10R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R2_FB2      = 0x4        // Bit FB2.
	CAN_F10R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R2_FB3      = 0x8        // Bit FB3.
	CAN_F10R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R2_FB4      = 0x10       // Bit FB4.
	CAN_F10R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R2_FB5      = 0x20       // Bit FB5.
	CAN_F10R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R2_FB6      = 0x40       // Bit FB6.
	CAN_F10R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R2_FB7      = 0x80       // Bit FB7.
	CAN_F10R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R2_FB8      = 0x100      // Bit FB8.
	CAN_F10R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R2_FB9      = 0x200      // Bit FB9.
	CAN_F10R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R2_FB10     = 0x400      // Bit FB10.
	CAN_F10R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R2_FB11     = 0x800      // Bit FB11.
	CAN_F10R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R2_FB12     = 0x1000     // Bit FB12.
	CAN_F10R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R2_FB13     = 0x2000     // Bit FB13.
	CAN_F10R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R2_FB14     = 0x4000     // Bit FB14.
	CAN_F10R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R2_FB15     = 0x8000     // Bit FB15.
	CAN_F10R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R2_FB16     = 0x10000    // Bit FB16.
	CAN_F10R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R2_FB17     = 0x20000    // Bit FB17.
	CAN_F10R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R2_FB18     = 0x40000    // Bit FB18.
	CAN_F10R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R2_FB19     = 0x80000    // Bit FB19.
	CAN_F10R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R2_FB20     = 0x100000   // Bit FB20.
	CAN_F10R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R2_FB21     = 0x200000   // Bit FB21.
	CAN_F10R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R2_FB22     = 0x400000   // Bit FB22.
	CAN_F10R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R2_FB23     = 0x800000   // Bit FB23.
	CAN_F10R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R2_FB31     = 0x80000000 // Bit FB31.

	// F11R1: Filter bank 11 register 1
	CAN_F11R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R1_FB0      = 0x1        // Bit FB0.
	CAN_F11R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R1_FB1      = 0x2        // Bit FB1.
	CAN_F11R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R1_FB2      = 0x4        // Bit FB2.
	CAN_F11R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R1_FB3      = 0x8        // Bit FB3.
	CAN_F11R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R1_FB4      = 0x10       // Bit FB4.
	CAN_F11R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R1_FB5      = 0x20       // Bit FB5.
	CAN_F11R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R1_FB6      = 0x40       // Bit FB6.
	CAN_F11R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R1_FB7      = 0x80       // Bit FB7.
	CAN_F11R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R1_FB8      = 0x100      // Bit FB8.
	CAN_F11R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R1_FB9      = 0x200      // Bit FB9.
	CAN_F11R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R1_FB10     = 0x400      // Bit FB10.
	CAN_F11R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R1_FB11     = 0x800      // Bit FB11.
	CAN_F11R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R1_FB12     = 0x1000     // Bit FB12.
	CAN_F11R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R1_FB13     = 0x2000     // Bit FB13.
	CAN_F11R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R1_FB14     = 0x4000     // Bit FB14.
	CAN_F11R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R1_FB15     = 0x8000     // Bit FB15.
	CAN_F11R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R1_FB16     = 0x10000    // Bit FB16.
	CAN_F11R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R1_FB17     = 0x20000    // Bit FB17.
	CAN_F11R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R1_FB18     = 0x40000    // Bit FB18.
	CAN_F11R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R1_FB19     = 0x80000    // Bit FB19.
	CAN_F11R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R1_FB20     = 0x100000   // Bit FB20.
	CAN_F11R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R1_FB21     = 0x200000   // Bit FB21.
	CAN_F11R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R1_FB22     = 0x400000   // Bit FB22.
	CAN_F11R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R1_FB23     = 0x800000   // Bit FB23.
	CAN_F11R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R1_FB31     = 0x80000000 // Bit FB31.

	// F11R2: Filter bank 11 register 2
	CAN_F11R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R2_FB0      = 0x1        // Bit FB0.
	CAN_F11R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R2_FB1      = 0x2        // Bit FB1.
	CAN_F11R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R2_FB2      = 0x4        // Bit FB2.
	CAN_F11R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R2_FB3      = 0x8        // Bit FB3.
	CAN_F11R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R2_FB4      = 0x10       // Bit FB4.
	CAN_F11R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R2_FB5      = 0x20       // Bit FB5.
	CAN_F11R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R2_FB6      = 0x40       // Bit FB6.
	CAN_F11R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R2_FB7      = 0x80       // Bit FB7.
	CAN_F11R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R2_FB8      = 0x100      // Bit FB8.
	CAN_F11R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R2_FB9      = 0x200      // Bit FB9.
	CAN_F11R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R2_FB10     = 0x400      // Bit FB10.
	CAN_F11R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R2_FB11     = 0x800      // Bit FB11.
	CAN_F11R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R2_FB12     = 0x1000     // Bit FB12.
	CAN_F11R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R2_FB13     = 0x2000     // Bit FB13.
	CAN_F11R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R2_FB14     = 0x4000     // Bit FB14.
	CAN_F11R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R2_FB15     = 0x8000     // Bit FB15.
	CAN_F11R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R2_FB16     = 0x10000    // Bit FB16.
	CAN_F11R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R2_FB17     = 0x20000    // Bit FB17.
	CAN_F11R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R2_FB18     = 0x40000    // Bit FB18.
	CAN_F11R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R2_FB19     = 0x80000    // Bit FB19.
	CAN_F11R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R2_FB20     = 0x100000   // Bit FB20.
	CAN_F11R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R2_FB21     = 0x200000   // Bit FB21.
	CAN_F11R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R2_FB22     = 0x400000   // Bit FB22.
	CAN_F11R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R2_FB23     = 0x800000   // Bit FB23.
	CAN_F11R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R2_FB31     = 0x80000000 // Bit FB31.

	// F12R1: Filter bank 4 register 1
	CAN_F12R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R1_FB0      = 0x1        // Bit FB0.
	CAN_F12R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R1_FB1      = 0x2        // Bit FB1.
	CAN_F12R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R1_FB2      = 0x4        // Bit FB2.
	CAN_F12R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R1_FB3      = 0x8        // Bit FB3.
	CAN_F12R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R1_FB4      = 0x10       // Bit FB4.
	CAN_F12R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R1_FB5      = 0x20       // Bit FB5.
	CAN_F12R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R1_FB6      = 0x40       // Bit FB6.
	CAN_F12R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R1_FB7      = 0x80       // Bit FB7.
	CAN_F12R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R1_FB8      = 0x100      // Bit FB8.
	CAN_F12R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R1_FB9      = 0x200      // Bit FB9.
	CAN_F12R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R1_FB10     = 0x400      // Bit FB10.
	CAN_F12R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R1_FB11     = 0x800      // Bit FB11.
	CAN_F12R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R1_FB12     = 0x1000     // Bit FB12.
	CAN_F12R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R1_FB13     = 0x2000     // Bit FB13.
	CAN_F12R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R1_FB14     = 0x4000     // Bit FB14.
	CAN_F12R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R1_FB15     = 0x8000     // Bit FB15.
	CAN_F12R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R1_FB16     = 0x10000    // Bit FB16.
	CAN_F12R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R1_FB17     = 0x20000    // Bit FB17.
	CAN_F12R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R1_FB18     = 0x40000    // Bit FB18.
	CAN_F12R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R1_FB19     = 0x80000    // Bit FB19.
	CAN_F12R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R1_FB20     = 0x100000   // Bit FB20.
	CAN_F12R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R1_FB21     = 0x200000   // Bit FB21.
	CAN_F12R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R1_FB22     = 0x400000   // Bit FB22.
	CAN_F12R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R1_FB23     = 0x800000   // Bit FB23.
	CAN_F12R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R1_FB31     = 0x80000000 // Bit FB31.

	// F12R2: Filter bank 12 register 2
	CAN_F12R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R2_FB0      = 0x1        // Bit FB0.
	CAN_F12R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R2_FB1      = 0x2        // Bit FB1.
	CAN_F12R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R2_FB2      = 0x4        // Bit FB2.
	CAN_F12R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R2_FB3      = 0x8        // Bit FB3.
	CAN_F12R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R2_FB4      = 0x10       // Bit FB4.
	CAN_F12R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R2_FB5      = 0x20       // Bit FB5.
	CAN_F12R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R2_FB6      = 0x40       // Bit FB6.
	CAN_F12R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R2_FB7      = 0x80       // Bit FB7.
	CAN_F12R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R2_FB8      = 0x100      // Bit FB8.
	CAN_F12R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R2_FB9      = 0x200      // Bit FB9.
	CAN_F12R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R2_FB10     = 0x400      // Bit FB10.
	CAN_F12R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R2_FB11     = 0x800      // Bit FB11.
	CAN_F12R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R2_FB12     = 0x1000     // Bit FB12.
	CAN_F12R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R2_FB13     = 0x2000     // Bit FB13.
	CAN_F12R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R2_FB14     = 0x4000     // Bit FB14.
	CAN_F12R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R2_FB15     = 0x8000     // Bit FB15.
	CAN_F12R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R2_FB16     = 0x10000    // Bit FB16.
	CAN_F12R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R2_FB17     = 0x20000    // Bit FB17.
	CAN_F12R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R2_FB18     = 0x40000    // Bit FB18.
	CAN_F12R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R2_FB19     = 0x80000    // Bit FB19.
	CAN_F12R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R2_FB20     = 0x100000   // Bit FB20.
	CAN_F12R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R2_FB21     = 0x200000   // Bit FB21.
	CAN_F12R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R2_FB22     = 0x400000   // Bit FB22.
	CAN_F12R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R2_FB23     = 0x800000   // Bit FB23.
	CAN_F12R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R2_FB31     = 0x80000000 // Bit FB31.

	// F13R1: Filter bank 13 register 1
	CAN_F13R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R1_FB0      = 0x1        // Bit FB0.
	CAN_F13R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R1_FB1      = 0x2        // Bit FB1.
	CAN_F13R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R1_FB2      = 0x4        // Bit FB2.
	CAN_F13R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R1_FB3      = 0x8        // Bit FB3.
	CAN_F13R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R1_FB4      = 0x10       // Bit FB4.
	CAN_F13R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R1_FB5      = 0x20       // Bit FB5.
	CAN_F13R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R1_FB6      = 0x40       // Bit FB6.
	CAN_F13R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R1_FB7      = 0x80       // Bit FB7.
	CAN_F13R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R1_FB8      = 0x100      // Bit FB8.
	CAN_F13R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R1_FB9      = 0x200      // Bit FB9.
	CAN_F13R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R1_FB10     = 0x400      // Bit FB10.
	CAN_F13R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R1_FB11     = 0x800      // Bit FB11.
	CAN_F13R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R1_FB12     = 0x1000     // Bit FB12.
	CAN_F13R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R1_FB13     = 0x2000     // Bit FB13.
	CAN_F13R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R1_FB14     = 0x4000     // Bit FB14.
	CAN_F13R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R1_FB15     = 0x8000     // Bit FB15.
	CAN_F13R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R1_FB16     = 0x10000    // Bit FB16.
	CAN_F13R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R1_FB17     = 0x20000    // Bit FB17.
	CAN_F13R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R1_FB18     = 0x40000    // Bit FB18.
	CAN_F13R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R1_FB19     = 0x80000    // Bit FB19.
	CAN_F13R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R1_FB20     = 0x100000   // Bit FB20.
	CAN_F13R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R1_FB21     = 0x200000   // Bit FB21.
	CAN_F13R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R1_FB22     = 0x400000   // Bit FB22.
	CAN_F13R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R1_FB23     = 0x800000   // Bit FB23.
	CAN_F13R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R1_FB31     = 0x80000000 // Bit FB31.

	// F13R2: Filter bank 13 register 2
	CAN_F13R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R2_FB0      = 0x1        // Bit FB0.
	CAN_F13R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R2_FB1      = 0x2        // Bit FB1.
	CAN_F13R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R2_FB2      = 0x4        // Bit FB2.
	CAN_F13R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R2_FB3      = 0x8        // Bit FB3.
	CAN_F13R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R2_FB4      = 0x10       // Bit FB4.
	CAN_F13R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R2_FB5      = 0x20       // Bit FB5.
	CAN_F13R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R2_FB6      = 0x40       // Bit FB6.
	CAN_F13R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R2_FB7      = 0x80       // Bit FB7.
	CAN_F13R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R2_FB8      = 0x100      // Bit FB8.
	CAN_F13R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R2_FB9      = 0x200      // Bit FB9.
	CAN_F13R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R2_FB10     = 0x400      // Bit FB10.
	CAN_F13R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R2_FB11     = 0x800      // Bit FB11.
	CAN_F13R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R2_FB12     = 0x1000     // Bit FB12.
	CAN_F13R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R2_FB13     = 0x2000     // Bit FB13.
	CAN_F13R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R2_FB14     = 0x4000     // Bit FB14.
	CAN_F13R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R2_FB15     = 0x8000     // Bit FB15.
	CAN_F13R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R2_FB16     = 0x10000    // Bit FB16.
	CAN_F13R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R2_FB17     = 0x20000    // Bit FB17.
	CAN_F13R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R2_FB18     = 0x40000    // Bit FB18.
	CAN_F13R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R2_FB19     = 0x80000    // Bit FB19.
	CAN_F13R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R2_FB20     = 0x100000   // Bit FB20.
	CAN_F13R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R2_FB21     = 0x200000   // Bit FB21.
	CAN_F13R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R2_FB22     = 0x400000   // Bit FB22.
	CAN_F13R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R2_FB23     = 0x800000   // Bit FB23.
	CAN_F13R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R2_FB31     = 0x80000000 // Bit FB31.

	// F14R1: Filter bank 14 register 1
	CAN_F14R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R1_FB0      = 0x1        // Bit FB0.
	CAN_F14R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R1_FB1      = 0x2        // Bit FB1.
	CAN_F14R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R1_FB2      = 0x4        // Bit FB2.
	CAN_F14R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R1_FB3      = 0x8        // Bit FB3.
	CAN_F14R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R1_FB4      = 0x10       // Bit FB4.
	CAN_F14R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R1_FB5      = 0x20       // Bit FB5.
	CAN_F14R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R1_FB6      = 0x40       // Bit FB6.
	CAN_F14R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R1_FB7      = 0x80       // Bit FB7.
	CAN_F14R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R1_FB8      = 0x100      // Bit FB8.
	CAN_F14R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R1_FB9      = 0x200      // Bit FB9.
	CAN_F14R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R1_FB10     = 0x400      // Bit FB10.
	CAN_F14R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R1_FB11     = 0x800      // Bit FB11.
	CAN_F14R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R1_FB12     = 0x1000     // Bit FB12.
	CAN_F14R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R1_FB13     = 0x2000     // Bit FB13.
	CAN_F14R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R1_FB14     = 0x4000     // Bit FB14.
	CAN_F14R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R1_FB15     = 0x8000     // Bit FB15.
	CAN_F14R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R1_FB16     = 0x10000    // Bit FB16.
	CAN_F14R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R1_FB17     = 0x20000    // Bit FB17.
	CAN_F14R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R1_FB18     = 0x40000    // Bit FB18.
	CAN_F14R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R1_FB19     = 0x80000    // Bit FB19.
	CAN_F14R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R1_FB20     = 0x100000   // Bit FB20.
	CAN_F14R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R1_FB21     = 0x200000   // Bit FB21.
	CAN_F14R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R1_FB22     = 0x400000   // Bit FB22.
	CAN_F14R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R1_FB23     = 0x800000   // Bit FB23.
	CAN_F14R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R1_FB31     = 0x80000000 // Bit FB31.

	// F14R2: Filter bank 14 register 2
	CAN_F14R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R2_FB0      = 0x1        // Bit FB0.
	CAN_F14R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R2_FB1      = 0x2        // Bit FB1.
	CAN_F14R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R2_FB2      = 0x4        // Bit FB2.
	CAN_F14R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R2_FB3      = 0x8        // Bit FB3.
	CAN_F14R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R2_FB4      = 0x10       // Bit FB4.
	CAN_F14R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R2_FB5      = 0x20       // Bit FB5.
	CAN_F14R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R2_FB6      = 0x40       // Bit FB6.
	CAN_F14R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R2_FB7      = 0x80       // Bit FB7.
	CAN_F14R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R2_FB8      = 0x100      // Bit FB8.
	CAN_F14R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R2_FB9      = 0x200      // Bit FB9.
	CAN_F14R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R2_FB10     = 0x400      // Bit FB10.
	CAN_F14R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R2_FB11     = 0x800      // Bit FB11.
	CAN_F14R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R2_FB12     = 0x1000     // Bit FB12.
	CAN_F14R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R2_FB13     = 0x2000     // Bit FB13.
	CAN_F14R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R2_FB14     = 0x4000     // Bit FB14.
	CAN_F14R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R2_FB15     = 0x8000     // Bit FB15.
	CAN_F14R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R2_FB16     = 0x10000    // Bit FB16.
	CAN_F14R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R2_FB17     = 0x20000    // Bit FB17.
	CAN_F14R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R2_FB18     = 0x40000    // Bit FB18.
	CAN_F14R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R2_FB19     = 0x80000    // Bit FB19.
	CAN_F14R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R2_FB20     = 0x100000   // Bit FB20.
	CAN_F14R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R2_FB21     = 0x200000   // Bit FB21.
	CAN_F14R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R2_FB22     = 0x400000   // Bit FB22.
	CAN_F14R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R2_FB23     = 0x800000   // Bit FB23.
	CAN_F14R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R2_FB31     = 0x80000000 // Bit FB31.

	// F15R1: Filter bank 15 register 1
	CAN_F15R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R1_FB0      = 0x1        // Bit FB0.
	CAN_F15R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R1_FB1      = 0x2        // Bit FB1.
	CAN_F15R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R1_FB2      = 0x4        // Bit FB2.
	CAN_F15R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R1_FB3      = 0x8        // Bit FB3.
	CAN_F15R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R1_FB4      = 0x10       // Bit FB4.
	CAN_F15R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R1_FB5      = 0x20       // Bit FB5.
	CAN_F15R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R1_FB6      = 0x40       // Bit FB6.
	CAN_F15R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R1_FB7      = 0x80       // Bit FB7.
	CAN_F15R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R1_FB8      = 0x100      // Bit FB8.
	CAN_F15R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R1_FB9      = 0x200      // Bit FB9.
	CAN_F15R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R1_FB10     = 0x400      // Bit FB10.
	CAN_F15R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R1_FB11     = 0x800      // Bit FB11.
	CAN_F15R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R1_FB12     = 0x1000     // Bit FB12.
	CAN_F15R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R1_FB13     = 0x2000     // Bit FB13.
	CAN_F15R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R1_FB14     = 0x4000     // Bit FB14.
	CAN_F15R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R1_FB15     = 0x8000     // Bit FB15.
	CAN_F15R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R1_FB16     = 0x10000    // Bit FB16.
	CAN_F15R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R1_FB17     = 0x20000    // Bit FB17.
	CAN_F15R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R1_FB18     = 0x40000    // Bit FB18.
	CAN_F15R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R1_FB19     = 0x80000    // Bit FB19.
	CAN_F15R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R1_FB20     = 0x100000   // Bit FB20.
	CAN_F15R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R1_FB21     = 0x200000   // Bit FB21.
	CAN_F15R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R1_FB22     = 0x400000   // Bit FB22.
	CAN_F15R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R1_FB23     = 0x800000   // Bit FB23.
	CAN_F15R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R1_FB31     = 0x80000000 // Bit FB31.

	// F15R2: Filter bank 15 register 2
	CAN_F15R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R2_FB0      = 0x1        // Bit FB0.
	CAN_F15R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R2_FB1      = 0x2        // Bit FB1.
	CAN_F15R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R2_FB2      = 0x4        // Bit FB2.
	CAN_F15R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R2_FB3      = 0x8        // Bit FB3.
	CAN_F15R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R2_FB4      = 0x10       // Bit FB4.
	CAN_F15R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R2_FB5      = 0x20       // Bit FB5.
	CAN_F15R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R2_FB6      = 0x40       // Bit FB6.
	CAN_F15R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R2_FB7      = 0x80       // Bit FB7.
	CAN_F15R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R2_FB8      = 0x100      // Bit FB8.
	CAN_F15R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R2_FB9      = 0x200      // Bit FB9.
	CAN_F15R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R2_FB10     = 0x400      // Bit FB10.
	CAN_F15R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R2_FB11     = 0x800      // Bit FB11.
	CAN_F15R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R2_FB12     = 0x1000     // Bit FB12.
	CAN_F15R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R2_FB13     = 0x2000     // Bit FB13.
	CAN_F15R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R2_FB14     = 0x4000     // Bit FB14.
	CAN_F15R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R2_FB15     = 0x8000     // Bit FB15.
	CAN_F15R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R2_FB16     = 0x10000    // Bit FB16.
	CAN_F15R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R2_FB17     = 0x20000    // Bit FB17.
	CAN_F15R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R2_FB18     = 0x40000    // Bit FB18.
	CAN_F15R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R2_FB19     = 0x80000    // Bit FB19.
	CAN_F15R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R2_FB20     = 0x100000   // Bit FB20.
	CAN_F15R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R2_FB21     = 0x200000   // Bit FB21.
	CAN_F15R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R2_FB22     = 0x400000   // Bit FB22.
	CAN_F15R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R2_FB23     = 0x800000   // Bit FB23.
	CAN_F15R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R2_FB31     = 0x80000000 // Bit FB31.

	// F16R1: Filter bank 16 register 1
	CAN_F16R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R1_FB0      = 0x1        // Bit FB0.
	CAN_F16R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R1_FB1      = 0x2        // Bit FB1.
	CAN_F16R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R1_FB2      = 0x4        // Bit FB2.
	CAN_F16R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R1_FB3      = 0x8        // Bit FB3.
	CAN_F16R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R1_FB4      = 0x10       // Bit FB4.
	CAN_F16R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R1_FB5      = 0x20       // Bit FB5.
	CAN_F16R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R1_FB6      = 0x40       // Bit FB6.
	CAN_F16R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R1_FB7      = 0x80       // Bit FB7.
	CAN_F16R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R1_FB8      = 0x100      // Bit FB8.
	CAN_F16R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R1_FB9      = 0x200      // Bit FB9.
	CAN_F16R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R1_FB10     = 0x400      // Bit FB10.
	CAN_F16R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R1_FB11     = 0x800      // Bit FB11.
	CAN_F16R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R1_FB12     = 0x1000     // Bit FB12.
	CAN_F16R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R1_FB13     = 0x2000     // Bit FB13.
	CAN_F16R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R1_FB14     = 0x4000     // Bit FB14.
	CAN_F16R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R1_FB15     = 0x8000     // Bit FB15.
	CAN_F16R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R1_FB16     = 0x10000    // Bit FB16.
	CAN_F16R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R1_FB17     = 0x20000    // Bit FB17.
	CAN_F16R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R1_FB18     = 0x40000    // Bit FB18.
	CAN_F16R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R1_FB19     = 0x80000    // Bit FB19.
	CAN_F16R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R1_FB20     = 0x100000   // Bit FB20.
	CAN_F16R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R1_FB21     = 0x200000   // Bit FB21.
	CAN_F16R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R1_FB22     = 0x400000   // Bit FB22.
	CAN_F16R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R1_FB23     = 0x800000   // Bit FB23.
	CAN_F16R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R1_FB31     = 0x80000000 // Bit FB31.

	// F16R2: Filter bank 16 register 2
	CAN_F16R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R2_FB0      = 0x1        // Bit FB0.
	CAN_F16R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R2_FB1      = 0x2        // Bit FB1.
	CAN_F16R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R2_FB2      = 0x4        // Bit FB2.
	CAN_F16R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R2_FB3      = 0x8        // Bit FB3.
	CAN_F16R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R2_FB4      = 0x10       // Bit FB4.
	CAN_F16R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R2_FB5      = 0x20       // Bit FB5.
	CAN_F16R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R2_FB6      = 0x40       // Bit FB6.
	CAN_F16R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R2_FB7      = 0x80       // Bit FB7.
	CAN_F16R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R2_FB8      = 0x100      // Bit FB8.
	CAN_F16R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R2_FB9      = 0x200      // Bit FB9.
	CAN_F16R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R2_FB10     = 0x400      // Bit FB10.
	CAN_F16R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R2_FB11     = 0x800      // Bit FB11.
	CAN_F16R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R2_FB12     = 0x1000     // Bit FB12.
	CAN_F16R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R2_FB13     = 0x2000     // Bit FB13.
	CAN_F16R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R2_FB14     = 0x4000     // Bit FB14.
	CAN_F16R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R2_FB15     = 0x8000     // Bit FB15.
	CAN_F16R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R2_FB16     = 0x10000    // Bit FB16.
	CAN_F16R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R2_FB17     = 0x20000    // Bit FB17.
	CAN_F16R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R2_FB18     = 0x40000    // Bit FB18.
	CAN_F16R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R2_FB19     = 0x80000    // Bit FB19.
	CAN_F16R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R2_FB20     = 0x100000   // Bit FB20.
	CAN_F16R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R2_FB21     = 0x200000   // Bit FB21.
	CAN_F16R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R2_FB22     = 0x400000   // Bit FB22.
	CAN_F16R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R2_FB23     = 0x800000   // Bit FB23.
	CAN_F16R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R2_FB31     = 0x80000000 // Bit FB31.

	// F17R1: Filter bank 17 register 1
	CAN_F17R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R1_FB0      = 0x1        // Bit FB0.
	CAN_F17R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R1_FB1      = 0x2        // Bit FB1.
	CAN_F17R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R1_FB2      = 0x4        // Bit FB2.
	CAN_F17R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R1_FB3      = 0x8        // Bit FB3.
	CAN_F17R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R1_FB4      = 0x10       // Bit FB4.
	CAN_F17R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R1_FB5      = 0x20       // Bit FB5.
	CAN_F17R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R1_FB6      = 0x40       // Bit FB6.
	CAN_F17R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R1_FB7      = 0x80       // Bit FB7.
	CAN_F17R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R1_FB8      = 0x100      // Bit FB8.
	CAN_F17R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R1_FB9      = 0x200      // Bit FB9.
	CAN_F17R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R1_FB10     = 0x400      // Bit FB10.
	CAN_F17R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R1_FB11     = 0x800      // Bit FB11.
	CAN_F17R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R1_FB12     = 0x1000     // Bit FB12.
	CAN_F17R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R1_FB13     = 0x2000     // Bit FB13.
	CAN_F17R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R1_FB14     = 0x4000     // Bit FB14.
	CAN_F17R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R1_FB15     = 0x8000     // Bit FB15.
	CAN_F17R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R1_FB16     = 0x10000    // Bit FB16.
	CAN_F17R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R1_FB17     = 0x20000    // Bit FB17.
	CAN_F17R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R1_FB18     = 0x40000    // Bit FB18.
	CAN_F17R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R1_FB19     = 0x80000    // Bit FB19.
	CAN_F17R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R1_FB20     = 0x100000   // Bit FB20.
	CAN_F17R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R1_FB21     = 0x200000   // Bit FB21.
	CAN_F17R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R1_FB22     = 0x400000   // Bit FB22.
	CAN_F17R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R1_FB23     = 0x800000   // Bit FB23.
	CAN_F17R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R1_FB31     = 0x80000000 // Bit FB31.

	// F17R2: Filter bank 17 register 2
	CAN_F17R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R2_FB0      = 0x1        // Bit FB0.
	CAN_F17R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R2_FB1      = 0x2        // Bit FB1.
	CAN_F17R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R2_FB2      = 0x4        // Bit FB2.
	CAN_F17R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R2_FB3      = 0x8        // Bit FB3.
	CAN_F17R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R2_FB4      = 0x10       // Bit FB4.
	CAN_F17R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R2_FB5      = 0x20       // Bit FB5.
	CAN_F17R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R2_FB6      = 0x40       // Bit FB6.
	CAN_F17R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R2_FB7      = 0x80       // Bit FB7.
	CAN_F17R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R2_FB8      = 0x100      // Bit FB8.
	CAN_F17R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R2_FB9      = 0x200      // Bit FB9.
	CAN_F17R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R2_FB10     = 0x400      // Bit FB10.
	CAN_F17R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R2_FB11     = 0x800      // Bit FB11.
	CAN_F17R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R2_FB12     = 0x1000     // Bit FB12.
	CAN_F17R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R2_FB13     = 0x2000     // Bit FB13.
	CAN_F17R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R2_FB14     = 0x4000     // Bit FB14.
	CAN_F17R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R2_FB15     = 0x8000     // Bit FB15.
	CAN_F17R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R2_FB16     = 0x10000    // Bit FB16.
	CAN_F17R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R2_FB17     = 0x20000    // Bit FB17.
	CAN_F17R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R2_FB18     = 0x40000    // Bit FB18.
	CAN_F17R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R2_FB19     = 0x80000    // Bit FB19.
	CAN_F17R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R2_FB20     = 0x100000   // Bit FB20.
	CAN_F17R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R2_FB21     = 0x200000   // Bit FB21.
	CAN_F17R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R2_FB22     = 0x400000   // Bit FB22.
	CAN_F17R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R2_FB23     = 0x800000   // Bit FB23.
	CAN_F17R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R2_FB31     = 0x80000000 // Bit FB31.

	// F18R1: Filter bank 18 register 1
	CAN_F18R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R1_FB0      = 0x1        // Bit FB0.
	CAN_F18R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R1_FB1      = 0x2        // Bit FB1.
	CAN_F18R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R1_FB2      = 0x4        // Bit FB2.
	CAN_F18R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R1_FB3      = 0x8        // Bit FB3.
	CAN_F18R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R1_FB4      = 0x10       // Bit FB4.
	CAN_F18R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R1_FB5      = 0x20       // Bit FB5.
	CAN_F18R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R1_FB6      = 0x40       // Bit FB6.
	CAN_F18R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R1_FB7      = 0x80       // Bit FB7.
	CAN_F18R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R1_FB8      = 0x100      // Bit FB8.
	CAN_F18R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R1_FB9      = 0x200      // Bit FB9.
	CAN_F18R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R1_FB10     = 0x400      // Bit FB10.
	CAN_F18R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R1_FB11     = 0x800      // Bit FB11.
	CAN_F18R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R1_FB12     = 0x1000     // Bit FB12.
	CAN_F18R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R1_FB13     = 0x2000     // Bit FB13.
	CAN_F18R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R1_FB14     = 0x4000     // Bit FB14.
	CAN_F18R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R1_FB15     = 0x8000     // Bit FB15.
	CAN_F18R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R1_FB16     = 0x10000    // Bit FB16.
	CAN_F18R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R1_FB17     = 0x20000    // Bit FB17.
	CAN_F18R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R1_FB18     = 0x40000    // Bit FB18.
	CAN_F18R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R1_FB19     = 0x80000    // Bit FB19.
	CAN_F18R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R1_FB20     = 0x100000   // Bit FB20.
	CAN_F18R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R1_FB21     = 0x200000   // Bit FB21.
	CAN_F18R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R1_FB22     = 0x400000   // Bit FB22.
	CAN_F18R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R1_FB23     = 0x800000   // Bit FB23.
	CAN_F18R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R1_FB31     = 0x80000000 // Bit FB31.

	// F18R2: Filter bank 18 register 2
	CAN_F18R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R2_FB0      = 0x1        // Bit FB0.
	CAN_F18R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R2_FB1      = 0x2        // Bit FB1.
	CAN_F18R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R2_FB2      = 0x4        // Bit FB2.
	CAN_F18R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R2_FB3      = 0x8        // Bit FB3.
	CAN_F18R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R2_FB4      = 0x10       // Bit FB4.
	CAN_F18R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R2_FB5      = 0x20       // Bit FB5.
	CAN_F18R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R2_FB6      = 0x40       // Bit FB6.
	CAN_F18R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R2_FB7      = 0x80       // Bit FB7.
	CAN_F18R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R2_FB8      = 0x100      // Bit FB8.
	CAN_F18R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R2_FB9      = 0x200      // Bit FB9.
	CAN_F18R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R2_FB10     = 0x400      // Bit FB10.
	CAN_F18R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R2_FB11     = 0x800      // Bit FB11.
	CAN_F18R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R2_FB12     = 0x1000     // Bit FB12.
	CAN_F18R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R2_FB13     = 0x2000     // Bit FB13.
	CAN_F18R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R2_FB14     = 0x4000     // Bit FB14.
	CAN_F18R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R2_FB15     = 0x8000     // Bit FB15.
	CAN_F18R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R2_FB16     = 0x10000    // Bit FB16.
	CAN_F18R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R2_FB17     = 0x20000    // Bit FB17.
	CAN_F18R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R2_FB18     = 0x40000    // Bit FB18.
	CAN_F18R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R2_FB19     = 0x80000    // Bit FB19.
	CAN_F18R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R2_FB20     = 0x100000   // Bit FB20.
	CAN_F18R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R2_FB21     = 0x200000   // Bit FB21.
	CAN_F18R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R2_FB22     = 0x400000   // Bit FB22.
	CAN_F18R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R2_FB23     = 0x800000   // Bit FB23.
	CAN_F18R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R2_FB31     = 0x80000000 // Bit FB31.

	// F19R1: Filter bank 19 register 1
	CAN_F19R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R1_FB0      = 0x1        // Bit FB0.
	CAN_F19R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R1_FB1      = 0x2        // Bit FB1.
	CAN_F19R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R1_FB2      = 0x4        // Bit FB2.
	CAN_F19R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R1_FB3      = 0x8        // Bit FB3.
	CAN_F19R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R1_FB4      = 0x10       // Bit FB4.
	CAN_F19R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R1_FB5      = 0x20       // Bit FB5.
	CAN_F19R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R1_FB6      = 0x40       // Bit FB6.
	CAN_F19R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R1_FB7      = 0x80       // Bit FB7.
	CAN_F19R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R1_FB8      = 0x100      // Bit FB8.
	CAN_F19R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R1_FB9      = 0x200      // Bit FB9.
	CAN_F19R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R1_FB10     = 0x400      // Bit FB10.
	CAN_F19R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R1_FB11     = 0x800      // Bit FB11.
	CAN_F19R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R1_FB12     = 0x1000     // Bit FB12.
	CAN_F19R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R1_FB13     = 0x2000     // Bit FB13.
	CAN_F19R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R1_FB14     = 0x4000     // Bit FB14.
	CAN_F19R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R1_FB15     = 0x8000     // Bit FB15.
	CAN_F19R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R1_FB16     = 0x10000    // Bit FB16.
	CAN_F19R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R1_FB17     = 0x20000    // Bit FB17.
	CAN_F19R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R1_FB18     = 0x40000    // Bit FB18.
	CAN_F19R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R1_FB19     = 0x80000    // Bit FB19.
	CAN_F19R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R1_FB20     = 0x100000   // Bit FB20.
	CAN_F19R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R1_FB21     = 0x200000   // Bit FB21.
	CAN_F19R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R1_FB22     = 0x400000   // Bit FB22.
	CAN_F19R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R1_FB23     = 0x800000   // Bit FB23.
	CAN_F19R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R1_FB31     = 0x80000000 // Bit FB31.

	// F19R2: Filter bank 19 register 2
	CAN_F19R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R2_FB0      = 0x1        // Bit FB0.
	CAN_F19R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R2_FB1      = 0x2        // Bit FB1.
	CAN_F19R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R2_FB2      = 0x4        // Bit FB2.
	CAN_F19R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R2_FB3      = 0x8        // Bit FB3.
	CAN_F19R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R2_FB4      = 0x10       // Bit FB4.
	CAN_F19R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R2_FB5      = 0x20       // Bit FB5.
	CAN_F19R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R2_FB6      = 0x40       // Bit FB6.
	CAN_F19R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R2_FB7      = 0x80       // Bit FB7.
	CAN_F19R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R2_FB8      = 0x100      // Bit FB8.
	CAN_F19R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R2_FB9      = 0x200      // Bit FB9.
	CAN_F19R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R2_FB10     = 0x400      // Bit FB10.
	CAN_F19R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R2_FB11     = 0x800      // Bit FB11.
	CAN_F19R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R2_FB12     = 0x1000     // Bit FB12.
	CAN_F19R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R2_FB13     = 0x2000     // Bit FB13.
	CAN_F19R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R2_FB14     = 0x4000     // Bit FB14.
	CAN_F19R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R2_FB15     = 0x8000     // Bit FB15.
	CAN_F19R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R2_FB16     = 0x10000    // Bit FB16.
	CAN_F19R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R2_FB17     = 0x20000    // Bit FB17.
	CAN_F19R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R2_FB18     = 0x40000    // Bit FB18.
	CAN_F19R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R2_FB19     = 0x80000    // Bit FB19.
	CAN_F19R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R2_FB20     = 0x100000   // Bit FB20.
	CAN_F19R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R2_FB21     = 0x200000   // Bit FB21.
	CAN_F19R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R2_FB22     = 0x400000   // Bit FB22.
	CAN_F19R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R2_FB23     = 0x800000   // Bit FB23.
	CAN_F19R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R2_FB31     = 0x80000000 // Bit FB31.

	// F20R1: Filter bank 20 register 1
	CAN_F20R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R1_FB0      = 0x1        // Bit FB0.
	CAN_F20R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R1_FB1      = 0x2        // Bit FB1.
	CAN_F20R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R1_FB2      = 0x4        // Bit FB2.
	CAN_F20R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R1_FB3      = 0x8        // Bit FB3.
	CAN_F20R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R1_FB4      = 0x10       // Bit FB4.
	CAN_F20R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R1_FB5      = 0x20       // Bit FB5.
	CAN_F20R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R1_FB6      = 0x40       // Bit FB6.
	CAN_F20R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R1_FB7      = 0x80       // Bit FB7.
	CAN_F20R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R1_FB8      = 0x100      // Bit FB8.
	CAN_F20R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R1_FB9      = 0x200      // Bit FB9.
	CAN_F20R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R1_FB10     = 0x400      // Bit FB10.
	CAN_F20R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R1_FB11     = 0x800      // Bit FB11.
	CAN_F20R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R1_FB12     = 0x1000     // Bit FB12.
	CAN_F20R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R1_FB13     = 0x2000     // Bit FB13.
	CAN_F20R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R1_FB14     = 0x4000     // Bit FB14.
	CAN_F20R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R1_FB15     = 0x8000     // Bit FB15.
	CAN_F20R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R1_FB16     = 0x10000    // Bit FB16.
	CAN_F20R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R1_FB17     = 0x20000    // Bit FB17.
	CAN_F20R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R1_FB18     = 0x40000    // Bit FB18.
	CAN_F20R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R1_FB19     = 0x80000    // Bit FB19.
	CAN_F20R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R1_FB20     = 0x100000   // Bit FB20.
	CAN_F20R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R1_FB21     = 0x200000   // Bit FB21.
	CAN_F20R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R1_FB22     = 0x400000   // Bit FB22.
	CAN_F20R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R1_FB23     = 0x800000   // Bit FB23.
	CAN_F20R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R1_FB31     = 0x80000000 // Bit FB31.

	// F20R2: Filter bank 20 register 2
	CAN_F20R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R2_FB0      = 0x1        // Bit FB0.
	CAN_F20R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R2_FB1      = 0x2        // Bit FB1.
	CAN_F20R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R2_FB2      = 0x4        // Bit FB2.
	CAN_F20R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R2_FB3      = 0x8        // Bit FB3.
	CAN_F20R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R2_FB4      = 0x10       // Bit FB4.
	CAN_F20R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R2_FB5      = 0x20       // Bit FB5.
	CAN_F20R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R2_FB6      = 0x40       // Bit FB6.
	CAN_F20R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R2_FB7      = 0x80       // Bit FB7.
	CAN_F20R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R2_FB8      = 0x100      // Bit FB8.
	CAN_F20R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R2_FB9      = 0x200      // Bit FB9.
	CAN_F20R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R2_FB10     = 0x400      // Bit FB10.
	CAN_F20R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R2_FB11     = 0x800      // Bit FB11.
	CAN_F20R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R2_FB12     = 0x1000     // Bit FB12.
	CAN_F20R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R2_FB13     = 0x2000     // Bit FB13.
	CAN_F20R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R2_FB14     = 0x4000     // Bit FB14.
	CAN_F20R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R2_FB15     = 0x8000     // Bit FB15.
	CAN_F20R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R2_FB16     = 0x10000    // Bit FB16.
	CAN_F20R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R2_FB17     = 0x20000    // Bit FB17.
	CAN_F20R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R2_FB18     = 0x40000    // Bit FB18.
	CAN_F20R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R2_FB19     = 0x80000    // Bit FB19.
	CAN_F20R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R2_FB20     = 0x100000   // Bit FB20.
	CAN_F20R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R2_FB21     = 0x200000   // Bit FB21.
	CAN_F20R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R2_FB22     = 0x400000   // Bit FB22.
	CAN_F20R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R2_FB23     = 0x800000   // Bit FB23.
	CAN_F20R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R2_FB31     = 0x80000000 // Bit FB31.

	// F21R1: Filter bank 21 register 1
	CAN_F21R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R1_FB0      = 0x1        // Bit FB0.
	CAN_F21R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R1_FB1      = 0x2        // Bit FB1.
	CAN_F21R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R1_FB2      = 0x4        // Bit FB2.
	CAN_F21R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R1_FB3      = 0x8        // Bit FB3.
	CAN_F21R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R1_FB4      = 0x10       // Bit FB4.
	CAN_F21R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R1_FB5      = 0x20       // Bit FB5.
	CAN_F21R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R1_FB6      = 0x40       // Bit FB6.
	CAN_F21R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R1_FB7      = 0x80       // Bit FB7.
	CAN_F21R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R1_FB8      = 0x100      // Bit FB8.
	CAN_F21R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R1_FB9      = 0x200      // Bit FB9.
	CAN_F21R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R1_FB10     = 0x400      // Bit FB10.
	CAN_F21R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R1_FB11     = 0x800      // Bit FB11.
	CAN_F21R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R1_FB12     = 0x1000     // Bit FB12.
	CAN_F21R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R1_FB13     = 0x2000     // Bit FB13.
	CAN_F21R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R1_FB14     = 0x4000     // Bit FB14.
	CAN_F21R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R1_FB15     = 0x8000     // Bit FB15.
	CAN_F21R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R1_FB16     = 0x10000    // Bit FB16.
	CAN_F21R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R1_FB17     = 0x20000    // Bit FB17.
	CAN_F21R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R1_FB18     = 0x40000    // Bit FB18.
	CAN_F21R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R1_FB19     = 0x80000    // Bit FB19.
	CAN_F21R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R1_FB20     = 0x100000   // Bit FB20.
	CAN_F21R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R1_FB21     = 0x200000   // Bit FB21.
	CAN_F21R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R1_FB22     = 0x400000   // Bit FB22.
	CAN_F21R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R1_FB23     = 0x800000   // Bit FB23.
	CAN_F21R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R1_FB31     = 0x80000000 // Bit FB31.

	// F21R2: Filter bank 21 register 2
	CAN_F21R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R2_FB0      = 0x1        // Bit FB0.
	CAN_F21R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R2_FB1      = 0x2        // Bit FB1.
	CAN_F21R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R2_FB2      = 0x4        // Bit FB2.
	CAN_F21R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R2_FB3      = 0x8        // Bit FB3.
	CAN_F21R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R2_FB4      = 0x10       // Bit FB4.
	CAN_F21R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R2_FB5      = 0x20       // Bit FB5.
	CAN_F21R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R2_FB6      = 0x40       // Bit FB6.
	CAN_F21R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R2_FB7      = 0x80       // Bit FB7.
	CAN_F21R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R2_FB8      = 0x100      // Bit FB8.
	CAN_F21R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R2_FB9      = 0x200      // Bit FB9.
	CAN_F21R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R2_FB10     = 0x400      // Bit FB10.
	CAN_F21R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R2_FB11     = 0x800      // Bit FB11.
	CAN_F21R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R2_FB12     = 0x1000     // Bit FB12.
	CAN_F21R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R2_FB13     = 0x2000     // Bit FB13.
	CAN_F21R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R2_FB14     = 0x4000     // Bit FB14.
	CAN_F21R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R2_FB15     = 0x8000     // Bit FB15.
	CAN_F21R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R2_FB16     = 0x10000    // Bit FB16.
	CAN_F21R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R2_FB17     = 0x20000    // Bit FB17.
	CAN_F21R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R2_FB18     = 0x40000    // Bit FB18.
	CAN_F21R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R2_FB19     = 0x80000    // Bit FB19.
	CAN_F21R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R2_FB20     = 0x100000   // Bit FB20.
	CAN_F21R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R2_FB21     = 0x200000   // Bit FB21.
	CAN_F21R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R2_FB22     = 0x400000   // Bit FB22.
	CAN_F21R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R2_FB23     = 0x800000   // Bit FB23.
	CAN_F21R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R2_FB31     = 0x80000000 // Bit FB31.

	// F22R1: Filter bank 22 register 1
	CAN_F22R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R1_FB0      = 0x1        // Bit FB0.
	CAN_F22R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R1_FB1      = 0x2        // Bit FB1.
	CAN_F22R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R1_FB2      = 0x4        // Bit FB2.
	CAN_F22R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R1_FB3      = 0x8        // Bit FB3.
	CAN_F22R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R1_FB4      = 0x10       // Bit FB4.
	CAN_F22R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R1_FB5      = 0x20       // Bit FB5.
	CAN_F22R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R1_FB6      = 0x40       // Bit FB6.
	CAN_F22R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R1_FB7      = 0x80       // Bit FB7.
	CAN_F22R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R1_FB8      = 0x100      // Bit FB8.
	CAN_F22R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R1_FB9      = 0x200      // Bit FB9.
	CAN_F22R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R1_FB10     = 0x400      // Bit FB10.
	CAN_F22R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R1_FB11     = 0x800      // Bit FB11.
	CAN_F22R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R1_FB12     = 0x1000     // Bit FB12.
	CAN_F22R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R1_FB13     = 0x2000     // Bit FB13.
	CAN_F22R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R1_FB14     = 0x4000     // Bit FB14.
	CAN_F22R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R1_FB15     = 0x8000     // Bit FB15.
	CAN_F22R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R1_FB16     = 0x10000    // Bit FB16.
	CAN_F22R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R1_FB17     = 0x20000    // Bit FB17.
	CAN_F22R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R1_FB18     = 0x40000    // Bit FB18.
	CAN_F22R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R1_FB19     = 0x80000    // Bit FB19.
	CAN_F22R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R1_FB20     = 0x100000   // Bit FB20.
	CAN_F22R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R1_FB21     = 0x200000   // Bit FB21.
	CAN_F22R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R1_FB22     = 0x400000   // Bit FB22.
	CAN_F22R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R1_FB23     = 0x800000   // Bit FB23.
	CAN_F22R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R1_FB31     = 0x80000000 // Bit FB31.

	// F22R2: Filter bank 22 register 2
	CAN_F22R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R2_FB0      = 0x1        // Bit FB0.
	CAN_F22R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R2_FB1      = 0x2        // Bit FB1.
	CAN_F22R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R2_FB2      = 0x4        // Bit FB2.
	CAN_F22R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R2_FB3      = 0x8        // Bit FB3.
	CAN_F22R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R2_FB4      = 0x10       // Bit FB4.
	CAN_F22R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R2_FB5      = 0x20       // Bit FB5.
	CAN_F22R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R2_FB6      = 0x40       // Bit FB6.
	CAN_F22R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R2_FB7      = 0x80       // Bit FB7.
	CAN_F22R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R2_FB8      = 0x100      // Bit FB8.
	CAN_F22R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R2_FB9      = 0x200      // Bit FB9.
	CAN_F22R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R2_FB10     = 0x400      // Bit FB10.
	CAN_F22R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R2_FB11     = 0x800      // Bit FB11.
	CAN_F22R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R2_FB12     = 0x1000     // Bit FB12.
	CAN_F22R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R2_FB13     = 0x2000     // Bit FB13.
	CAN_F22R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R2_FB14     = 0x4000     // Bit FB14.
	CAN_F22R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R2_FB15     = 0x8000     // Bit FB15.
	CAN_F22R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R2_FB16     = 0x10000    // Bit FB16.
	CAN_F22R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R2_FB17     = 0x20000    // Bit FB17.
	CAN_F22R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R2_FB18     = 0x40000    // Bit FB18.
	CAN_F22R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R2_FB19     = 0x80000    // Bit FB19.
	CAN_F22R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R2_FB20     = 0x100000   // Bit FB20.
	CAN_F22R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R2_FB21     = 0x200000   // Bit FB21.
	CAN_F22R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R2_FB22     = 0x400000   // Bit FB22.
	CAN_F22R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R2_FB23     = 0x800000   // Bit FB23.
	CAN_F22R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R2_FB31     = 0x80000000 // Bit FB31.

	// F23R1: Filter bank 23 register 1
	CAN_F23R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R1_FB0      = 0x1        // Bit FB0.
	CAN_F23R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R1_FB1      = 0x2        // Bit FB1.
	CAN_F23R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R1_FB2      = 0x4        // Bit FB2.
	CAN_F23R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R1_FB3      = 0x8        // Bit FB3.
	CAN_F23R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R1_FB4      = 0x10       // Bit FB4.
	CAN_F23R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R1_FB5      = 0x20       // Bit FB5.
	CAN_F23R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R1_FB6      = 0x40       // Bit FB6.
	CAN_F23R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R1_FB7      = 0x80       // Bit FB7.
	CAN_F23R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R1_FB8      = 0x100      // Bit FB8.
	CAN_F23R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R1_FB9      = 0x200      // Bit FB9.
	CAN_F23R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R1_FB10     = 0x400      // Bit FB10.
	CAN_F23R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R1_FB11     = 0x800      // Bit FB11.
	CAN_F23R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R1_FB12     = 0x1000     // Bit FB12.
	CAN_F23R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R1_FB13     = 0x2000     // Bit FB13.
	CAN_F23R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R1_FB14     = 0x4000     // Bit FB14.
	CAN_F23R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R1_FB15     = 0x8000     // Bit FB15.
	CAN_F23R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R1_FB16     = 0x10000    // Bit FB16.
	CAN_F23R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R1_FB17     = 0x20000    // Bit FB17.
	CAN_F23R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R1_FB18     = 0x40000    // Bit FB18.
	CAN_F23R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R1_FB19     = 0x80000    // Bit FB19.
	CAN_F23R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R1_FB20     = 0x100000   // Bit FB20.
	CAN_F23R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R1_FB21     = 0x200000   // Bit FB21.
	CAN_F23R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R1_FB22     = 0x400000   // Bit FB22.
	CAN_F23R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R1_FB23     = 0x800000   // Bit FB23.
	CAN_F23R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R1_FB31     = 0x80000000 // Bit FB31.

	// F23R2: Filter bank 23 register 2
	CAN_F23R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R2_FB0      = 0x1        // Bit FB0.
	CAN_F23R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R2_FB1      = 0x2        // Bit FB1.
	CAN_F23R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R2_FB2      = 0x4        // Bit FB2.
	CAN_F23R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R2_FB3      = 0x8        // Bit FB3.
	CAN_F23R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R2_FB4      = 0x10       // Bit FB4.
	CAN_F23R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R2_FB5      = 0x20       // Bit FB5.
	CAN_F23R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R2_FB6      = 0x40       // Bit FB6.
	CAN_F23R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R2_FB7      = 0x80       // Bit FB7.
	CAN_F23R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R2_FB8      = 0x100      // Bit FB8.
	CAN_F23R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R2_FB9      = 0x200      // Bit FB9.
	CAN_F23R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R2_FB10     = 0x400      // Bit FB10.
	CAN_F23R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R2_FB11     = 0x800      // Bit FB11.
	CAN_F23R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R2_FB12     = 0x1000     // Bit FB12.
	CAN_F23R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R2_FB13     = 0x2000     // Bit FB13.
	CAN_F23R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R2_FB14     = 0x4000     // Bit FB14.
	CAN_F23R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R2_FB15     = 0x8000     // Bit FB15.
	CAN_F23R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R2_FB16     = 0x10000    // Bit FB16.
	CAN_F23R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R2_FB17     = 0x20000    // Bit FB17.
	CAN_F23R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R2_FB18     = 0x40000    // Bit FB18.
	CAN_F23R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R2_FB19     = 0x80000    // Bit FB19.
	CAN_F23R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R2_FB20     = 0x100000   // Bit FB20.
	CAN_F23R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R2_FB21     = 0x200000   // Bit FB21.
	CAN_F23R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R2_FB22     = 0x400000   // Bit FB22.
	CAN_F23R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R2_FB23     = 0x800000   // Bit FB23.
	CAN_F23R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R2_FB31     = 0x80000000 // Bit FB31.

	// F24R1: Filter bank 24 register 1
	CAN_F24R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R1_FB0      = 0x1        // Bit FB0.
	CAN_F24R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R1_FB1      = 0x2        // Bit FB1.
	CAN_F24R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R1_FB2      = 0x4        // Bit FB2.
	CAN_F24R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R1_FB3      = 0x8        // Bit FB3.
	CAN_F24R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R1_FB4      = 0x10       // Bit FB4.
	CAN_F24R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R1_FB5      = 0x20       // Bit FB5.
	CAN_F24R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R1_FB6      = 0x40       // Bit FB6.
	CAN_F24R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R1_FB7      = 0x80       // Bit FB7.
	CAN_F24R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R1_FB8      = 0x100      // Bit FB8.
	CAN_F24R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R1_FB9      = 0x200      // Bit FB9.
	CAN_F24R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R1_FB10     = 0x400      // Bit FB10.
	CAN_F24R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R1_FB11     = 0x800      // Bit FB11.
	CAN_F24R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R1_FB12     = 0x1000     // Bit FB12.
	CAN_F24R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R1_FB13     = 0x2000     // Bit FB13.
	CAN_F24R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R1_FB14     = 0x4000     // Bit FB14.
	CAN_F24R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R1_FB15     = 0x8000     // Bit FB15.
	CAN_F24R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R1_FB16     = 0x10000    // Bit FB16.
	CAN_F24R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R1_FB17     = 0x20000    // Bit FB17.
	CAN_F24R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R1_FB18     = 0x40000    // Bit FB18.
	CAN_F24R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R1_FB19     = 0x80000    // Bit FB19.
	CAN_F24R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R1_FB20     = 0x100000   // Bit FB20.
	CAN_F24R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R1_FB21     = 0x200000   // Bit FB21.
	CAN_F24R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R1_FB22     = 0x400000   // Bit FB22.
	CAN_F24R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R1_FB23     = 0x800000   // Bit FB23.
	CAN_F24R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R1_FB31     = 0x80000000 // Bit FB31.

	// F24R2: Filter bank 24 register 2
	CAN_F24R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R2_FB0      = 0x1        // Bit FB0.
	CAN_F24R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R2_FB1      = 0x2        // Bit FB1.
	CAN_F24R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R2_FB2      = 0x4        // Bit FB2.
	CAN_F24R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R2_FB3      = 0x8        // Bit FB3.
	CAN_F24R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R2_FB4      = 0x10       // Bit FB4.
	CAN_F24R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R2_FB5      = 0x20       // Bit FB5.
	CAN_F24R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R2_FB6      = 0x40       // Bit FB6.
	CAN_F24R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R2_FB7      = 0x80       // Bit FB7.
	CAN_F24R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R2_FB8      = 0x100      // Bit FB8.
	CAN_F24R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R2_FB9      = 0x200      // Bit FB9.
	CAN_F24R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R2_FB10     = 0x400      // Bit FB10.
	CAN_F24R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R2_FB11     = 0x800      // Bit FB11.
	CAN_F24R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R2_FB12     = 0x1000     // Bit FB12.
	CAN_F24R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R2_FB13     = 0x2000     // Bit FB13.
	CAN_F24R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R2_FB14     = 0x4000     // Bit FB14.
	CAN_F24R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R2_FB15     = 0x8000     // Bit FB15.
	CAN_F24R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R2_FB16     = 0x10000    // Bit FB16.
	CAN_F24R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R2_FB17     = 0x20000    // Bit FB17.
	CAN_F24R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R2_FB18     = 0x40000    // Bit FB18.
	CAN_F24R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R2_FB19     = 0x80000    // Bit FB19.
	CAN_F24R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R2_FB20     = 0x100000   // Bit FB20.
	CAN_F24R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R2_FB21     = 0x200000   // Bit FB21.
	CAN_F24R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R2_FB22     = 0x400000   // Bit FB22.
	CAN_F24R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R2_FB23     = 0x800000   // Bit FB23.
	CAN_F24R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R2_FB31     = 0x80000000 // Bit FB31.

	// F25R1: Filter bank 25 register 1
	CAN_F25R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R1_FB0      = 0x1        // Bit FB0.
	CAN_F25R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R1_FB1      = 0x2        // Bit FB1.
	CAN_F25R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R1_FB2      = 0x4        // Bit FB2.
	CAN_F25R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R1_FB3      = 0x8        // Bit FB3.
	CAN_F25R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R1_FB4      = 0x10       // Bit FB4.
	CAN_F25R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R1_FB5      = 0x20       // Bit FB5.
	CAN_F25R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R1_FB6      = 0x40       // Bit FB6.
	CAN_F25R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R1_FB7      = 0x80       // Bit FB7.
	CAN_F25R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R1_FB8      = 0x100      // Bit FB8.
	CAN_F25R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R1_FB9      = 0x200      // Bit FB9.
	CAN_F25R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R1_FB10     = 0x400      // Bit FB10.
	CAN_F25R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R1_FB11     = 0x800      // Bit FB11.
	CAN_F25R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R1_FB12     = 0x1000     // Bit FB12.
	CAN_F25R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R1_FB13     = 0x2000     // Bit FB13.
	CAN_F25R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R1_FB14     = 0x4000     // Bit FB14.
	CAN_F25R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R1_FB15     = 0x8000     // Bit FB15.
	CAN_F25R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R1_FB16     = 0x10000    // Bit FB16.
	CAN_F25R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R1_FB17     = 0x20000    // Bit FB17.
	CAN_F25R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R1_FB18     = 0x40000    // Bit FB18.
	CAN_F25R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R1_FB19     = 0x80000    // Bit FB19.
	CAN_F25R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R1_FB20     = 0x100000   // Bit FB20.
	CAN_F25R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R1_FB21     = 0x200000   // Bit FB21.
	CAN_F25R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R1_FB22     = 0x400000   // Bit FB22.
	CAN_F25R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R1_FB23     = 0x800000   // Bit FB23.
	CAN_F25R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R1_FB31     = 0x80000000 // Bit FB31.

	// F25R2: Filter bank 25 register 2
	CAN_F25R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R2_FB0      = 0x1        // Bit FB0.
	CAN_F25R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R2_FB1      = 0x2        // Bit FB1.
	CAN_F25R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R2_FB2      = 0x4        // Bit FB2.
	CAN_F25R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R2_FB3      = 0x8        // Bit FB3.
	CAN_F25R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R2_FB4      = 0x10       // Bit FB4.
	CAN_F25R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R2_FB5      = 0x20       // Bit FB5.
	CAN_F25R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R2_FB6      = 0x40       // Bit FB6.
	CAN_F25R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R2_FB7      = 0x80       // Bit FB7.
	CAN_F25R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R2_FB8      = 0x100      // Bit FB8.
	CAN_F25R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R2_FB9      = 0x200      // Bit FB9.
	CAN_F25R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R2_FB10     = 0x400      // Bit FB10.
	CAN_F25R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R2_FB11     = 0x800      // Bit FB11.
	CAN_F25R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R2_FB12     = 0x1000     // Bit FB12.
	CAN_F25R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R2_FB13     = 0x2000     // Bit FB13.
	CAN_F25R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R2_FB14     = 0x4000     // Bit FB14.
	CAN_F25R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R2_FB15     = 0x8000     // Bit FB15.
	CAN_F25R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R2_FB16     = 0x10000    // Bit FB16.
	CAN_F25R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R2_FB17     = 0x20000    // Bit FB17.
	CAN_F25R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R2_FB18     = 0x40000    // Bit FB18.
	CAN_F25R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R2_FB19     = 0x80000    // Bit FB19.
	CAN_F25R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R2_FB20     = 0x100000   // Bit FB20.
	CAN_F25R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R2_FB21     = 0x200000   // Bit FB21.
	CAN_F25R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R2_FB22     = 0x400000   // Bit FB22.
	CAN_F25R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R2_FB23     = 0x800000   // Bit FB23.
	CAN_F25R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R2_FB31     = 0x80000000 // Bit FB31.

	// F26R1: Filter bank 26 register 1
	CAN_F26R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R1_FB0      = 0x1        // Bit FB0.
	CAN_F26R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R1_FB1      = 0x2        // Bit FB1.
	CAN_F26R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R1_FB2      = 0x4        // Bit FB2.
	CAN_F26R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R1_FB3      = 0x8        // Bit FB3.
	CAN_F26R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R1_FB4      = 0x10       // Bit FB4.
	CAN_F26R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R1_FB5      = 0x20       // Bit FB5.
	CAN_F26R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R1_FB6      = 0x40       // Bit FB6.
	CAN_F26R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R1_FB7      = 0x80       // Bit FB7.
	CAN_F26R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R1_FB8      = 0x100      // Bit FB8.
	CAN_F26R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R1_FB9      = 0x200      // Bit FB9.
	CAN_F26R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R1_FB10     = 0x400      // Bit FB10.
	CAN_F26R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R1_FB11     = 0x800      // Bit FB11.
	CAN_F26R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R1_FB12     = 0x1000     // Bit FB12.
	CAN_F26R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R1_FB13     = 0x2000     // Bit FB13.
	CAN_F26R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R1_FB14     = 0x4000     // Bit FB14.
	CAN_F26R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R1_FB15     = 0x8000     // Bit FB15.
	CAN_F26R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R1_FB16     = 0x10000    // Bit FB16.
	CAN_F26R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R1_FB17     = 0x20000    // Bit FB17.
	CAN_F26R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R1_FB18     = 0x40000    // Bit FB18.
	CAN_F26R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R1_FB19     = 0x80000    // Bit FB19.
	CAN_F26R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R1_FB20     = 0x100000   // Bit FB20.
	CAN_F26R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R1_FB21     = 0x200000   // Bit FB21.
	CAN_F26R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R1_FB22     = 0x400000   // Bit FB22.
	CAN_F26R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R1_FB23     = 0x800000   // Bit FB23.
	CAN_F26R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R1_FB31     = 0x80000000 // Bit FB31.

	// F26R2: Filter bank 26 register 2
	CAN_F26R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R2_FB0      = 0x1        // Bit FB0.
	CAN_F26R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R2_FB1      = 0x2        // Bit FB1.
	CAN_F26R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R2_FB2      = 0x4        // Bit FB2.
	CAN_F26R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R2_FB3      = 0x8        // Bit FB3.
	CAN_F26R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R2_FB4      = 0x10       // Bit FB4.
	CAN_F26R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R2_FB5      = 0x20       // Bit FB5.
	CAN_F26R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R2_FB6      = 0x40       // Bit FB6.
	CAN_F26R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R2_FB7      = 0x80       // Bit FB7.
	CAN_F26R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R2_FB8      = 0x100      // Bit FB8.
	CAN_F26R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R2_FB9      = 0x200      // Bit FB9.
	CAN_F26R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R2_FB10     = 0x400      // Bit FB10.
	CAN_F26R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R2_FB11     = 0x800      // Bit FB11.
	CAN_F26R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R2_FB12     = 0x1000     // Bit FB12.
	CAN_F26R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R2_FB13     = 0x2000     // Bit FB13.
	CAN_F26R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R2_FB14     = 0x4000     // Bit FB14.
	CAN_F26R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R2_FB15     = 0x8000     // Bit FB15.
	CAN_F26R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R2_FB16     = 0x10000    // Bit FB16.
	CAN_F26R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R2_FB17     = 0x20000    // Bit FB17.
	CAN_F26R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R2_FB18     = 0x40000    // Bit FB18.
	CAN_F26R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R2_FB19     = 0x80000    // Bit FB19.
	CAN_F26R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R2_FB20     = 0x100000   // Bit FB20.
	CAN_F26R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R2_FB21     = 0x200000   // Bit FB21.
	CAN_F26R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R2_FB22     = 0x400000   // Bit FB22.
	CAN_F26R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R2_FB23     = 0x800000   // Bit FB23.
	CAN_F26R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R2_FB31     = 0x80000000 // Bit FB31.

	// F27R1: Filter bank 27 register 1
	CAN_F27R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R1_FB0      = 0x1        // Bit FB0.
	CAN_F27R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R1_FB1      = 0x2        // Bit FB1.
	CAN_F27R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R1_FB2      = 0x4        // Bit FB2.
	CAN_F27R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R1_FB3      = 0x8        // Bit FB3.
	CAN_F27R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R1_FB4      = 0x10       // Bit FB4.
	CAN_F27R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R1_FB5      = 0x20       // Bit FB5.
	CAN_F27R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R1_FB6      = 0x40       // Bit FB6.
	CAN_F27R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R1_FB7      = 0x80       // Bit FB7.
	CAN_F27R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R1_FB8      = 0x100      // Bit FB8.
	CAN_F27R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R1_FB9      = 0x200      // Bit FB9.
	CAN_F27R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R1_FB10     = 0x400      // Bit FB10.
	CAN_F27R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R1_FB11     = 0x800      // Bit FB11.
	CAN_F27R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R1_FB12     = 0x1000     // Bit FB12.
	CAN_F27R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R1_FB13     = 0x2000     // Bit FB13.
	CAN_F27R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R1_FB14     = 0x4000     // Bit FB14.
	CAN_F27R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R1_FB15     = 0x8000     // Bit FB15.
	CAN_F27R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R1_FB16     = 0x10000    // Bit FB16.
	CAN_F27R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R1_FB17     = 0x20000    // Bit FB17.
	CAN_F27R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R1_FB18     = 0x40000    // Bit FB18.
	CAN_F27R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R1_FB19     = 0x80000    // Bit FB19.
	CAN_F27R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R1_FB20     = 0x100000   // Bit FB20.
	CAN_F27R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R1_FB21     = 0x200000   // Bit FB21.
	CAN_F27R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R1_FB22     = 0x400000   // Bit FB22.
	CAN_F27R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R1_FB23     = 0x800000   // Bit FB23.
	CAN_F27R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R1_FB31     = 0x80000000 // Bit FB31.

	// F27R2: Filter bank 27 register 2
	CAN_F27R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R2_FB0      = 0x1        // Bit FB0.
	CAN_F27R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R2_FB1      = 0x2        // Bit FB1.
	CAN_F27R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R2_FB2      = 0x4        // Bit FB2.
	CAN_F27R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R2_FB3      = 0x8        // Bit FB3.
	CAN_F27R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R2_FB4      = 0x10       // Bit FB4.
	CAN_F27R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R2_FB5      = 0x20       // Bit FB5.
	CAN_F27R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R2_FB6      = 0x40       // Bit FB6.
	CAN_F27R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R2_FB7      = 0x80       // Bit FB7.
	CAN_F27R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R2_FB8      = 0x100      // Bit FB8.
	CAN_F27R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R2_FB9      = 0x200      // Bit FB9.
	CAN_F27R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R2_FB10     = 0x400      // Bit FB10.
	CAN_F27R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R2_FB11     = 0x800      // Bit FB11.
	CAN_F27R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R2_FB12     = 0x1000     // Bit FB12.
	CAN_F27R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R2_FB13     = 0x2000     // Bit FB13.
	CAN_F27R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R2_FB14     = 0x4000     // Bit FB14.
	CAN_F27R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R2_FB15     = 0x8000     // Bit FB15.
	CAN_F27R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R2_FB16     = 0x10000    // Bit FB16.
	CAN_F27R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R2_FB17     = 0x20000    // Bit FB17.
	CAN_F27R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R2_FB18     = 0x40000    // Bit FB18.
	CAN_F27R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R2_FB19     = 0x80000    // Bit FB19.
	CAN_F27R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R2_FB20     = 0x100000   // Bit FB20.
	CAN_F27R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R2_FB21     = 0x200000   // Bit FB21.
	CAN_F27R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R2_FB22     = 0x400000   // Bit FB22.
	CAN_F27R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R2_FB23     = 0x800000   // Bit FB23.
	CAN_F27R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R2_FB31     = 0x80000000 // Bit FB31.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_WCKSEL_Pos  = 0x0       // Position of WCKSEL field.
	RTC_CR_WCKSEL_Msk  = 0x7       // Bit mask of WCKSEL field.
	RTC_CR_TSEDGE_Pos  = 0x3       // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8       // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8       // Bit TSEDGE.
	RTC_CR_REFCKON_Pos = 0x4       // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10      // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10      // Bit REFCKON.
	RTC_CR_BYPSHAD_Pos = 0x5       // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20      // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20      // Bit BYPSHAD.
	RTC_CR_FMT_Pos     = 0x6       // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40      // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40      // Bit FMT.
	RTC_CR_ALRAE_Pos   = 0x8       // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100     // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100     // Bit ALRAE.
	RTC_CR_ALRBE_Pos   = 0x9       // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200     // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200     // Bit ALRBE.
	RTC_CR_WUTE_Pos    = 0xa       // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400     // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400     // Bit WUTE.
	RTC_CR_TSE_Pos     = 0xb       // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800     // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800     // Bit TSE.
	RTC_CR_ALRAIE_Pos  = 0xc       // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000    // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000    // Bit ALRAIE.
	RTC_CR_ALRBIE_Pos  = 0xd       // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000    // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000    // Bit ALRBIE.
	RTC_CR_WUTIE_Pos   = 0xe       // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000    // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000    // Bit WUTIE.
	RTC_CR_TSIE_Pos    = 0xf       // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000    // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000    // Bit TSIE.
	RTC_CR_ADD1H_Pos   = 0x10      // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000   // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000   // Bit ADD1H.
	RTC_CR_SUB1H_Pos   = 0x11      // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000   // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000   // Bit SUB1H.
	RTC_CR_BKP_Pos     = 0x12      // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000   // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000   // Bit BKP.
	RTC_CR_COSEL_Pos   = 0x13      // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000   // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000   // Bit COSEL.
	RTC_CR_POL_Pos     = 0x14      // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000  // Bit mask of POL field.
	RTC_CR_POL         = 0x100000  // Bit POL.
	RTC_CR_OSEL_Pos    = 0x15      // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000  // Bit mask of OSEL field.
	RTC_CR_COE_Pos     = 0x17      // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000  // Bit mask of COE field.
	RTC_CR_COE         = 0x800000  // Bit COE.
	RTC_CR_ITSE_Pos    = 0x18      // Position of ITSE field.
	RTC_CR_ITSE_Msk    = 0x1000000 // Bit mask of ITSE field.
	RTC_CR_ITSE        = 0x1000000 // Bit ITSE.

	// ISR: initialization and status           register
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ISR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ISR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ISR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_ALRBF_Pos   = 0x9     // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk   = 0x200   // Bit mask of ALRBF field.
	RTC_ISR_ALRBF       = 0x200   // Bit ALRBF.
	RTC_ISR_WUTF_Pos    = 0xa     // Position of WUTF field.
	RTC_ISR_WUTF_Msk    = 0x400   // Bit mask of WUTF field.
	RTC_ISR_WUTF        = 0x400   // Bit WUTF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_TAMP3F_Pos  = 0xf     // Position of TAMP3F field.
	RTC_ISR_TAMP3F_Msk  = 0x8000  // Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F      = 0x8000  // Bit TAMP3F.
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: time stamp time register
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAMPCR: tamper configuration register
	RTC_TAMPCR_TAMP1E_Pos       = 0x0       // Position of TAMP1E field.
	RTC_TAMPCR_TAMP1E_Msk       = 0x1       // Bit mask of TAMP1E field.
	RTC_TAMPCR_TAMP1E           = 0x1       // Bit TAMP1E.
	RTC_TAMPCR_TAMP1TRG_Pos     = 0x1       // Position of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG_Msk     = 0x2       // Bit mask of TAMP1TRG field.
	RTC_TAMPCR_TAMP1TRG         = 0x2       // Bit TAMP1TRG.
	RTC_TAMPCR_TAMPIE_Pos       = 0x2       // Position of TAMPIE field.
	RTC_TAMPCR_TAMPIE_Msk       = 0x4       // Bit mask of TAMPIE field.
	RTC_TAMPCR_TAMPIE           = 0x4       // Bit TAMPIE.
	RTC_TAMPCR_TAMP2E_Pos       = 0x3       // Position of TAMP2E field.
	RTC_TAMPCR_TAMP2E_Msk       = 0x8       // Bit mask of TAMP2E field.
	RTC_TAMPCR_TAMP2E           = 0x8       // Bit TAMP2E.
	RTC_TAMPCR_TAMP2TRG_Pos     = 0x4       // Position of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG_Msk     = 0x10      // Bit mask of TAMP2TRG field.
	RTC_TAMPCR_TAMP2TRG         = 0x10      // Bit TAMP2TRG.
	RTC_TAMPCR_TAMP3E_Pos       = 0x5       // Position of TAMP3E field.
	RTC_TAMPCR_TAMP3E_Msk       = 0x20      // Bit mask of TAMP3E field.
	RTC_TAMPCR_TAMP3E           = 0x20      // Bit TAMP3E.
	RTC_TAMPCR_TAMP3TRG_Pos     = 0x6       // Position of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG_Msk     = 0x40      // Bit mask of TAMP3TRG field.
	RTC_TAMPCR_TAMP3TRG         = 0x40      // Bit TAMP3TRG.
	RTC_TAMPCR_TAMPTS_Pos       = 0x7       // Position of TAMPTS field.
	RTC_TAMPCR_TAMPTS_Msk       = 0x80      // Bit mask of TAMPTS field.
	RTC_TAMPCR_TAMPTS           = 0x80      // Bit TAMPTS.
	RTC_TAMPCR_TAMPFREQ_Pos     = 0x8       // Position of TAMPFREQ field.
	RTC_TAMPCR_TAMPFREQ_Msk     = 0x700     // Bit mask of TAMPFREQ field.
	RTC_TAMPCR_TAMPFLT_Pos      = 0xb       // Position of TAMPFLT field.
	RTC_TAMPCR_TAMPFLT_Msk      = 0x1800    // Bit mask of TAMPFLT field.
	RTC_TAMPCR_TAMPPRCH_Pos     = 0xd       // Position of TAMPPRCH field.
	RTC_TAMPCR_TAMPPRCH_Msk     = 0x6000    // Bit mask of TAMPPRCH field.
	RTC_TAMPCR_TAMPPUDIS_Pos    = 0xf       // Position of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS_Msk    = 0x8000    // Bit mask of TAMPPUDIS field.
	RTC_TAMPCR_TAMPPUDIS        = 0x8000    // Bit TAMPPUDIS.
	RTC_TAMPCR_TAMP1IE_Pos      = 0x10      // Position of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE_Msk      = 0x10000   // Bit mask of TAMP1IE field.
	RTC_TAMPCR_TAMP1IE          = 0x10000   // Bit TAMP1IE.
	RTC_TAMPCR_TAMP1NOERASE_Pos = 0x11      // Position of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE_Msk = 0x20000   // Bit mask of TAMP1NOERASE field.
	RTC_TAMPCR_TAMP1NOERASE     = 0x20000   // Bit TAMP1NOERASE.
	RTC_TAMPCR_TAMP1MF_Pos      = 0x12      // Position of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF_Msk      = 0x40000   // Bit mask of TAMP1MF field.
	RTC_TAMPCR_TAMP1MF          = 0x40000   // Bit TAMP1MF.
	RTC_TAMPCR_TAMP2IE_Pos      = 0x13      // Position of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE_Msk      = 0x80000   // Bit mask of TAMP2IE field.
	RTC_TAMPCR_TAMP2IE          = 0x80000   // Bit TAMP2IE.
	RTC_TAMPCR_TAMP2NOERASE_Pos = 0x14      // Position of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE_Msk = 0x100000  // Bit mask of TAMP2NOERASE field.
	RTC_TAMPCR_TAMP2NOERASE     = 0x100000  // Bit TAMP2NOERASE.
	RTC_TAMPCR_TAMP2MF_Pos      = 0x15      // Position of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF_Msk      = 0x200000  // Bit mask of TAMP2MF field.
	RTC_TAMPCR_TAMP2MF          = 0x200000  // Bit TAMP2MF.
	RTC_TAMPCR_TAMP3IE_Pos      = 0x16      // Position of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE_Msk      = 0x400000  // Bit mask of TAMP3IE field.
	RTC_TAMPCR_TAMP3IE          = 0x400000  // Bit TAMP3IE.
	RTC_TAMPCR_TAMP3NOERASE_Pos = 0x17      // Position of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE_Msk = 0x800000  // Bit mask of TAMP3NOERASE field.
	RTC_TAMPCR_TAMP3NOERASE     = 0x800000  // Bit TAMP3NOERASE.
	RTC_TAMPCR_TAMP3MF_Pos      = 0x18      // Position of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF_Msk      = 0x1000000 // Bit mask of TAMP3MF field.
	RTC_TAMPCR_TAMP3MF          = 0x1000000 // Bit TAMP3MF.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// OR: option register
	RTC_OR_RTC_ALARM_TYPE_Pos = 0x0 // Position of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE_Msk = 0x1 // Bit mask of RTC_ALARM_TYPE field.
	RTC_OR_RTC_ALARM_TYPE     = 0x1 // Bit RTC_ALARM_TYPE.
	RTC_OR_RTC_OUT_RMP_Pos    = 0x1 // Position of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP_Msk    = 0x2 // Bit mask of RTC_OUT_RMP field.
	RTC_OR_RTC_OUT_RMP        = 0x2 // Bit RTC_OUT_RMP.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP5R: backup register
	RTC_BKP5R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP6R: backup register
	RTC_BKP6R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP7R: backup register
	RTC_BKP7R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP8R: backup register
	RTC_BKP8R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP9R: backup register
	RTC_BKP9R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP10R: backup register
	RTC_BKP10R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP11R: backup register
	RTC_BKP11R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP12R: backup register
	RTC_BKP12R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP13R: backup register
	RTC_BKP13R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP14R: backup register
	RTC_BKP14R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP15R: backup register
	RTC_BKP15R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP16R: backup register
	RTC_BKP16R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP17R: backup register
	RTC_BKP17R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP18R: backup register
	RTC_BKP18R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP19R: backup register
	RTC_BKP19R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP20R: backup register
	RTC_BKP20R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP20R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP21R: backup register
	RTC_BKP21R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP21R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP22R: backup register
	RTC_BKP22R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP22R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP23R: backup register
	RTC_BKP23R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP23R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP24R: backup register
	RTC_BKP24R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP24R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP25R: backup register
	RTC_BKP25R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP25R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP26R: backup register
	RTC_BKP26R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP26R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP27R: backup register
	RTC_BKP27R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP27R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP28R: backup register
	RTC_BKP28R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP28R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP29R: backup register
	RTC_BKP29R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP29R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP30R: backup register
	RTC_BKP30R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP30R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP31R: backup register
	RTC_BKP31R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP31R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for OTG_FS_GLOBAL: USB on the go full speed
const (
	// FS_GOTGCTL: OTG_FS control and status register           (OTG_FS_GOTGCTL)
	USB_OTG_FS_FS_GOTGCTL_SRQSCS_Pos  = 0x0     // Position of SRQSCS field.
	USB_OTG_FS_FS_GOTGCTL_SRQSCS_Msk  = 0x1     // Bit mask of SRQSCS field.
	USB_OTG_FS_FS_GOTGCTL_SRQSCS      = 0x1     // Bit SRQSCS.
	USB_OTG_FS_FS_GOTGCTL_SRQ_Pos     = 0x1     // Position of SRQ field.
	USB_OTG_FS_FS_GOTGCTL_SRQ_Msk     = 0x2     // Bit mask of SRQ field.
	USB_OTG_FS_FS_GOTGCTL_SRQ         = 0x2     // Bit SRQ.
	USB_OTG_FS_FS_GOTGCTL_HNGSCS_Pos  = 0x8     // Position of HNGSCS field.
	USB_OTG_FS_FS_GOTGCTL_HNGSCS_Msk  = 0x100   // Bit mask of HNGSCS field.
	USB_OTG_FS_FS_GOTGCTL_HNGSCS      = 0x100   // Bit HNGSCS.
	USB_OTG_FS_FS_GOTGCTL_HNPRQ_Pos   = 0x9     // Position of HNPRQ field.
	USB_OTG_FS_FS_GOTGCTL_HNPRQ_Msk   = 0x200   // Bit mask of HNPRQ field.
	USB_OTG_FS_FS_GOTGCTL_HNPRQ       = 0x200   // Bit HNPRQ.
	USB_OTG_FS_FS_GOTGCTL_HSHNPEN_Pos = 0xa     // Position of HSHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_HSHNPEN_Msk = 0x400   // Bit mask of HSHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_HSHNPEN     = 0x400   // Bit HSHNPEN.
	USB_OTG_FS_FS_GOTGCTL_DHNPEN_Pos  = 0xb     // Position of DHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_DHNPEN_Msk  = 0x800   // Bit mask of DHNPEN field.
	USB_OTG_FS_FS_GOTGCTL_DHNPEN      = 0x800   // Bit DHNPEN.
	USB_OTG_FS_FS_GOTGCTL_CIDSTS_Pos  = 0x10    // Position of CIDSTS field.
	USB_OTG_FS_FS_GOTGCTL_CIDSTS_Msk  = 0x10000 // Bit mask of CIDSTS field.
	USB_OTG_FS_FS_GOTGCTL_CIDSTS      = 0x10000 // Bit CIDSTS.
	USB_OTG_FS_FS_GOTGCTL_DBCT_Pos    = 0x11    // Position of DBCT field.
	USB_OTG_FS_FS_GOTGCTL_DBCT_Msk    = 0x20000 // Bit mask of DBCT field.
	USB_OTG_FS_FS_GOTGCTL_DBCT        = 0x20000 // Bit DBCT.
	USB_OTG_FS_FS_GOTGCTL_ASVLD_Pos   = 0x12    // Position of ASVLD field.
	USB_OTG_FS_FS_GOTGCTL_ASVLD_Msk   = 0x40000 // Bit mask of ASVLD field.
	USB_OTG_FS_FS_GOTGCTL_ASVLD       = 0x40000 // Bit ASVLD.
	USB_OTG_FS_FS_GOTGCTL_BSVLD_Pos   = 0x13    // Position of BSVLD field.
	USB_OTG_FS_FS_GOTGCTL_BSVLD_Msk   = 0x80000 // Bit mask of BSVLD field.
	USB_OTG_FS_FS_GOTGCTL_BSVLD       = 0x80000 // Bit BSVLD.

	// FS_GOTGINT: OTG_FS interrupt register           (OTG_FS_GOTGINT)
	USB_OTG_FS_FS_GOTGINT_SEDET_Pos   = 0x2     // Position of SEDET field.
	USB_OTG_FS_FS_GOTGINT_SEDET_Msk   = 0x4     // Bit mask of SEDET field.
	USB_OTG_FS_FS_GOTGINT_SEDET       = 0x4     // Bit SEDET.
	USB_OTG_FS_FS_GOTGINT_SRSSCHG_Pos = 0x8     // Position of SRSSCHG field.
	USB_OTG_FS_FS_GOTGINT_SRSSCHG_Msk = 0x100   // Bit mask of SRSSCHG field.
	USB_OTG_FS_FS_GOTGINT_SRSSCHG     = 0x100   // Bit SRSSCHG.
	USB_OTG_FS_FS_GOTGINT_HNSSCHG_Pos = 0x9     // Position of HNSSCHG field.
	USB_OTG_FS_FS_GOTGINT_HNSSCHG_Msk = 0x200   // Bit mask of HNSSCHG field.
	USB_OTG_FS_FS_GOTGINT_HNSSCHG     = 0x200   // Bit HNSSCHG.
	USB_OTG_FS_FS_GOTGINT_HNGDET_Pos  = 0x11    // Position of HNGDET field.
	USB_OTG_FS_FS_GOTGINT_HNGDET_Msk  = 0x20000 // Bit mask of HNGDET field.
	USB_OTG_FS_FS_GOTGINT_HNGDET      = 0x20000 // Bit HNGDET.
	USB_OTG_FS_FS_GOTGINT_ADTOCHG_Pos = 0x12    // Position of ADTOCHG field.
	USB_OTG_FS_FS_GOTGINT_ADTOCHG_Msk = 0x40000 // Bit mask of ADTOCHG field.
	USB_OTG_FS_FS_GOTGINT_ADTOCHG     = 0x40000 // Bit ADTOCHG.
	USB_OTG_FS_FS_GOTGINT_DBCDNE_Pos  = 0x13    // Position of DBCDNE field.
	USB_OTG_FS_FS_GOTGINT_DBCDNE_Msk  = 0x80000 // Bit mask of DBCDNE field.
	USB_OTG_FS_FS_GOTGINT_DBCDNE      = 0x80000 // Bit DBCDNE.

	// FS_GAHBCFG: OTG_FS AHB configuration register           (OTG_FS_GAHBCFG)
	USB_OTG_FS_FS_GAHBCFG_GINT_Pos     = 0x0   // Position of GINT field.
	USB_OTG_FS_FS_GAHBCFG_GINT_Msk     = 0x1   // Bit mask of GINT field.
	USB_OTG_FS_FS_GAHBCFG_GINT         = 0x1   // Bit GINT.
	USB_OTG_FS_FS_GAHBCFG_TXFELVL_Pos  = 0x7   // Position of TXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_TXFELVL_Msk  = 0x80  // Bit mask of TXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_TXFELVL      = 0x80  // Bit TXFELVL.
	USB_OTG_FS_FS_GAHBCFG_PTXFELVL_Pos = 0x8   // Position of PTXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_PTXFELVL_Msk = 0x100 // Bit mask of PTXFELVL field.
	USB_OTG_FS_FS_GAHBCFG_PTXFELVL     = 0x100 // Bit PTXFELVL.

	// FS_GUSBCFG: OTG_FS USB configuration register           (OTG_FS_GUSBCFG)
	USB_OTG_FS_FS_GUSBCFG_TOCAL_Pos  = 0x0        // Position of TOCAL field.
	USB_OTG_FS_FS_GUSBCFG_TOCAL_Msk  = 0x7        // Bit mask of TOCAL field.
	USB_OTG_FS_FS_GUSBCFG_PHYSEL_Pos = 0x6        // Position of PHYSEL field.
	USB_OTG_FS_FS_GUSBCFG_PHYSEL_Msk = 0x40       // Bit mask of PHYSEL field.
	USB_OTG_FS_FS_GUSBCFG_PHYSEL     = 0x40       // Bit PHYSEL.
	USB_OTG_FS_FS_GUSBCFG_SRPCAP_Pos = 0x8        // Position of SRPCAP field.
	USB_OTG_FS_FS_GUSBCFG_SRPCAP_Msk = 0x100      // Bit mask of SRPCAP field.
	USB_OTG_FS_FS_GUSBCFG_SRPCAP     = 0x100      // Bit SRPCAP.
	USB_OTG_FS_FS_GUSBCFG_HNPCAP_Pos = 0x9        // Position of HNPCAP field.
	USB_OTG_FS_FS_GUSBCFG_HNPCAP_Msk = 0x200      // Bit mask of HNPCAP field.
	USB_OTG_FS_FS_GUSBCFG_HNPCAP     = 0x200      // Bit HNPCAP.
	USB_OTG_FS_FS_GUSBCFG_TRDT_Pos   = 0xa        // Position of TRDT field.
	USB_OTG_FS_FS_GUSBCFG_TRDT_Msk   = 0x3c00     // Bit mask of TRDT field.
	USB_OTG_FS_FS_GUSBCFG_FHMOD_Pos  = 0x1d       // Position of FHMOD field.
	USB_OTG_FS_FS_GUSBCFG_FHMOD_Msk  = 0x20000000 // Bit mask of FHMOD field.
	USB_OTG_FS_FS_GUSBCFG_FHMOD      = 0x20000000 // Bit FHMOD.
	USB_OTG_FS_FS_GUSBCFG_FDMOD_Pos  = 0x1e       // Position of FDMOD field.
	USB_OTG_FS_FS_GUSBCFG_FDMOD_Msk  = 0x40000000 // Bit mask of FDMOD field.
	USB_OTG_FS_FS_GUSBCFG_FDMOD      = 0x40000000 // Bit FDMOD.
	USB_OTG_FS_FS_GUSBCFG_CTXPKT_Pos = 0x1f       // Position of CTXPKT field.
	USB_OTG_FS_FS_GUSBCFG_CTXPKT_Msk = 0x80000000 // Bit mask of CTXPKT field.
	USB_OTG_FS_FS_GUSBCFG_CTXPKT     = 0x80000000 // Bit CTXPKT.

	// FS_GRSTCTL: OTG_FS reset register           (OTG_FS_GRSTCTL)
	USB_OTG_FS_FS_GRSTCTL_CSRST_Pos   = 0x0        // Position of CSRST field.
	USB_OTG_FS_FS_GRSTCTL_CSRST_Msk   = 0x1        // Bit mask of CSRST field.
	USB_OTG_FS_FS_GRSTCTL_CSRST       = 0x1        // Bit CSRST.
	USB_OTG_FS_FS_GRSTCTL_HSRST_Pos   = 0x1        // Position of HSRST field.
	USB_OTG_FS_FS_GRSTCTL_HSRST_Msk   = 0x2        // Bit mask of HSRST field.
	USB_OTG_FS_FS_GRSTCTL_HSRST       = 0x2        // Bit HSRST.
	USB_OTG_FS_FS_GRSTCTL_FCRST_Pos   = 0x2        // Position of FCRST field.
	USB_OTG_FS_FS_GRSTCTL_FCRST_Msk   = 0x4        // Bit mask of FCRST field.
	USB_OTG_FS_FS_GRSTCTL_FCRST       = 0x4        // Bit FCRST.
	USB_OTG_FS_FS_GRSTCTL_RXFFLSH_Pos = 0x4        // Position of RXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_RXFFLSH_Msk = 0x10       // Bit mask of RXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_RXFFLSH     = 0x10       // Bit RXFFLSH.
	USB_OTG_FS_FS_GRSTCTL_TXFFLSH_Pos = 0x5        // Position of TXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_TXFFLSH_Msk = 0x20       // Bit mask of TXFFLSH field.
	USB_OTG_FS_FS_GRSTCTL_TXFFLSH     = 0x20       // Bit TXFFLSH.
	USB_OTG_FS_FS_GRSTCTL_TXFNUM_Pos  = 0x6        // Position of TXFNUM field.
	USB_OTG_FS_FS_GRSTCTL_TXFNUM_Msk  = 0x7c0      // Bit mask of TXFNUM field.
	USB_OTG_FS_FS_GRSTCTL_AHBIDL_Pos  = 0x1f       // Position of AHBIDL field.
	USB_OTG_FS_FS_GRSTCTL_AHBIDL_Msk  = 0x80000000 // Bit mask of AHBIDL field.
	USB_OTG_FS_FS_GRSTCTL_AHBIDL      = 0x80000000 // Bit AHBIDL.

	// FS_GINTSTS: OTG_FS core interrupt register           (OTG_FS_GINTSTS)
	USB_OTG_FS_FS_GINTSTS_CMOD_Pos               = 0x0        // Position of CMOD field.
	USB_OTG_FS_FS_GINTSTS_CMOD_Msk    