/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.main.Resources;
import freemind.main.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileController;

public class TileImage
implements ImageObserver {
    private Tile[][] mTiles = null;
    private boolean mTilesPresent = false;
    private boolean mImageCreated = false;
    private BufferedImage mImage;
    private int mWaitingForCallbacks = 0;
    private int mDx;
    private int mDy;

    public boolean isLoaded() {
        if (!this.mTilesPresent) {
            return false;
        }
        for (int i = 0; i < this.mTiles.length; ++i) {
            Tile[] tiles = this.mTiles[i];
            for (int j = 0; j < tiles.length; ++j) {
                Tile tile = tiles[j];
                if (tile.isLoaded() || tile.hasError()) continue;
                System.out.println("Tile " + tile + " is not loaded:" + tile.getStatus());
                return false;
            }
        }
        if (!this.mImageCreated) {
            this.createImage();
            this.mImageCreated = true;
        }
        return this.isDrawingDone();
    }

    private void createImage() {
        BufferedImage tileImage00 = this.mTiles[0][0].getImage();
        int height = tileImage00.getHeight();
        int width = tileImage00.getWidth();
        this.mImage = new BufferedImage(height * this.mTiles[0].length, width * this.mTiles.length, 1);
        Graphics2D graphics = (Graphics2D)this.mImage.getGraphics();
        for (int i = 0; i < this.mTiles.length; ++i) {
            Tile[] tiles = this.mTiles[i];
            for (int j = 0; j < tiles.length; ++j) {
                Tile tile = tiles[j];
                boolean done = graphics.drawImage((Image)tile.getImage(), i * height, j * width, this);
                if (done) continue;
                ++this.mWaitingForCallbacks;
            }
        }
        if (this.isDrawingDone()) {
            this.drawCross();
        }
    }

    public boolean isDrawingDone() {
        return this.mWaitingForCallbacks <= 0;
    }

    public void drawCross() {
        Graphics2D graphics = (Graphics2D)this.mImage.getGraphics();
        graphics.setColor(Color.RED);
        graphics.setStroke(new BasicStroke(4.0f));
        int size = 15;
        graphics.drawLine(this.mDx - size, this.mDy, this.mDx + size, this.mDy);
        graphics.drawLine(this.mDx, this.mDy - size, this.mDx, this.mDy + size);
    }

    public void load(String pCodedImage) {
        try {
            this.mImage = ImageIO.read(new ByteArrayInputStream(Tools.fromBase64((String)pCodedImage)));
            this.mTilesPresent = false;
            this.mImageCreated = true;
        }
        catch (IOException e) {
            Resources.getInstance().logException((Throwable)e);
        }
    }

    public void load(File pFileName) {
        try {
            this.mImage = ImageIO.read(new FileInputStream(pFileName));
            this.mTilesPresent = false;
            this.mImageCreated = true;
        }
        catch (IOException e) {
            Resources.getInstance().logException((Throwable)e);
        }
    }

    public String save() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.mImage, "png", stream);
            stream.close();
            return Tools.toBase64((byte[])stream.toByteArray());
        }
        catch (Exception e) {
            Resources.getInstance().logException((Throwable)e);
            return null;
        }
    }

    public RenderedImage getImage() {
        return this.mImage;
    }

    public void setTiles(int pDimension, int pX, int pY, int pZoom, TileController mTileController, Logger pLogger, int pDx, int pDy) {
        this.mDx = pDx;
        this.mDy = pDy;
        this.mTiles = new Tile[pDimension][pDimension];
        for (int i = 0; i < pDimension; ++i) {
            for (int j = 0; j < pDimension; ++j) {
                pLogger.fine("Trying to load tile to x=" + (pX + i) + ", y=" + (pY + j) + ", zoom=" + pZoom);
                this.mTiles[i][j] = mTileController.getTile(pX + i, pY + j, pZoom);
            }
        }
        this.mTilesPresent = true;
    }

    @Override
    public boolean imageUpdate(Image pImg, int pInfoflags, int pX, int pY, int pWidth, int pHeight) {
        --this.mWaitingForCallbacks;
        if (this.isDrawingDone()) {
            this.drawCross();
        }
        return this.isDrawingDone();
    }

    public boolean hasErrors() {
        if (!this.mTilesPresent) {
            return false;
        }
        for (int i = 0; i < this.mTiles.length; ++i) {
            Tile[] tiles = this.mTiles[i];
            for (int j = 0; j < tiles.length; ++j) {
                Tile tile = tiles[j];
                if (!tile.hasError()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImageCreated() {
        return this.mImageCreated;
    }
}

