/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.rosetta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.creole.rosetta.ReaderAbstractWiki;
import net.sourceforge.plantuml.creole.rosetta.ReaderWiki;
import net.sourceforge.plantuml.creole.rosetta.WikiLanguage;

public class ReaderDokuwiki
extends ReaderAbstractWiki
implements ReaderWiki {
    @Override
    protected String singleLineFormat(String wiki) {
        boolean endingSlashSlash = wiki.endsWith("\\\\");
        if (endingSlashSlash) {
            wiki = wiki.substring(0, wiki.length() - 2);
        }
        wiki = this.rawCode(wiki, "''%%", "%%''");
        wiki = this.rawCode(wiki, "%%", "%%");
        wiki = this.rawCode(wiki, "''", "''");
        for (char c : "^|<".toCharArray()) {
            wiki = wiki.replace("\\" + c, "" + WikiLanguage.toF7(c));
        }
        wiki = wiki.replaceAll("^___+$", WikiLanguage.UNICODE.tag("hr"));
        wiki = wiki.replaceAll("^---+$", WikiLanguage.UNICODE.tag("hr"));
        wiki = wiki.replaceAll("^\\*\\*\\*+$", WikiLanguage.UNICODE.tag("hr"));
        wiki = wiki.replaceAll("\\<del\\>([^<>]+?)\\</del\\>", WikiLanguage.UNICODE.tag("strike") + "$1" + WikiLanguage.UNICODE.slashTag("strike"));
        wiki = wiki.replaceAll("\\<strike\\>([^<>]+?)\\</strike\\>", WikiLanguage.UNICODE.tag("strike") + "$1" + WikiLanguage.UNICODE.slashTag("strike"));
        wiki = wiki.replaceAll("~~([^~]+?)~~", WikiLanguage.UNICODE.tag("strike") + "$1" + WikiLanguage.UNICODE.slashTag("strike"));
        wiki = wiki.replace("\\\\ ", WikiLanguage.UNICODE.tag("br"));
        wiki = wiki.replaceAll("//(.+?)//", WikiLanguage.UNICODE.tag("em") + "$1" + WikiLanguage.UNICODE.slashTag("em"));
        wiki = wiki.replaceAll("\\*\\*(.+?)\\*\\*", WikiLanguage.UNICODE.tag("strong") + "$1" + WikiLanguage.UNICODE.slashTag("strong"));
        wiki = wiki.replace(WikiLanguage.UNICODE.tag("strong") + WikiLanguage.UNICODE.tag("em"), WikiLanguage.UNICODE.tag("strongem"));
        wiki = wiki.replace(WikiLanguage.UNICODE.tag("em") + WikiLanguage.UNICODE.tag("strong"), WikiLanguage.UNICODE.tag("strongem"));
        wiki = wiki.replace(WikiLanguage.UNICODE.slashTag("strong") + WikiLanguage.UNICODE.slashTag("em"), WikiLanguage.UNICODE.slashTag("strongem"));
        wiki = wiki.replace(WikiLanguage.UNICODE.slashTag("em") + WikiLanguage.UNICODE.slashTag("strong"), WikiLanguage.UNICODE.slashTag("strongem"));
        wiki = wiki.replaceAll("__(.+?)__", WikiLanguage.UNICODE.tag("u") + "$1" + WikiLanguage.UNICODE.slashTag("u"));
        if (endingSlashSlash) {
            wiki = wiki + WikiLanguage.UNICODE.tag("br");
        }
        return wiki;
    }

    @Override
    public List<String> transform(List<String> raw) {
        ArrayList<String> uhtml = new ArrayList<String>();
        for (int i = 0; i < raw.size(); ++i) {
            String current = raw.get(i);
            if (current.startsWith("FIXME ")) continue;
            current = current.replaceFirst("^\\s+@start", "@start");
            current = current.replaceFirst("^\\s+@end", "@end");
            AutoGroup autoGroup = this.getAutoGroup(raw, i);
            if (autoGroup != null) {
                i += autoGroup.getSkipped() - 1;
                autoGroup.exportHtml(uhtml);
                continue;
            }
            StartEndGroup startEndGroup = this.getStartEndGroup(raw, i);
            if (startEndGroup != null) {
                i += startEndGroup.getSkipped() - 1;
                startEndGroup.exportHtml(uhtml);
                continue;
            }
            if (current.length() == 0) {
                uhtml.add(WikiLanguage.UNICODE.tag("p"));
                continue;
            }
            uhtml.add(this.singleLineFormat(current));
        }
        return Collections.unmodifiableList(uhtml);
    }

    private StartEndGroup getStartEndGroup(List<String> raw, int i) {
        if (raw.get(i).equals("<code>")) {
            return new StartEndGroup(raw, i, "</code>");
        }
        if (raw.get(i).startsWith("<uml")) {
            return new StartEndGroup(raw, i, "</uml>");
        }
        if (raw.get(i).equals("<plantuml>")) {
            return new StartEndGroup(raw, i, "</plantuml>");
        }
        return null;
    }

    private AutoGroup getAutoGroup(List<String> raw, int i) {
        AutoGroup group = this.getAutoGroup(raw, i, "  * ", "    * ");
        if (group != null) {
            return group;
        }
        group = this.getAutoGroup(raw, i, "  - ", "    - ");
        if (group != null) {
            return group;
        }
        group = this.getAutoGroup(raw, i, "\t");
        if (group != null) {
            return group;
        }
        group = this.getAutoGroup(raw, i, "> ");
        if (group != null) {
            return group;
        }
        group = this.getAutoGroup(raw, i, "] ");
        if (group != null) {
            return group;
        }
        group = this.getAutoGroup(raw, i, "    ");
        if (group != null) {
            return group;
        }
        group = this.getAutoGroup(raw, i, "^");
        if (group != null) {
            return group;
        }
        return null;
    }

    private AutoGroup getAutoGroup(List<String> raw, int i, String ... headers) {
        if (!raw.get(i).startsWith(headers[0])) {
            return null;
        }
        AutoGroup result = new AutoGroup(headers);
        while (i < raw.size() && result.isInTheGroup(raw.get(i))) {
            result.addLine(raw.get(i));
            ++i;
        }
        return result;
    }

    class AutoGroup {
        private final List<String> lines = new ArrayList<String>();
        private int skip = 0;
        private final String[] headers;

        private AutoGroup(String[] headers) {
            this.headers = headers;
        }

        private void addLine(String s) {
            if (this.headers[0].equals("> ") && s.equals(">")) {
                this.lines.add("");
            } else if (this.headers[0].equals("] ") && s.equals("]")) {
                this.lines.add("");
            } else if (this.headers[0].equals("^")) {
                this.lines.add(s);
            } else {
                this.lines.add(s.substring(this.headers[0].length()));
            }
            ++this.skip;
        }

        private int getSkipped() {
            return this.skip;
        }

        private void exportHtml(List<String> uhtml) {
            if (this.headers[0].equals("  * ")) {
                this.exportList(uhtml, "ul");
            } else if (this.headers[0].equals("  - ")) {
                this.exportList(uhtml, "ol");
            } else if (this.headers[0].equals("    ")) {
                this.exportCode(uhtml);
            } else if (this.headers[0].equals("\t")) {
                this.exportCode(uhtml);
            } else if (this.headers[0].equals("> ")) {
                this.exportBlockquote(uhtml);
            } else if (this.headers[0].equals("] ")) {
                this.exportFieldset(uhtml);
            } else if (this.headers[0].equals("^")) {
                this.exportTable(uhtml);
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void exportCode(List<String> uhtml) {
            ReaderDokuwiki.this.exportCodeInternal(uhtml, "codepre", this.lines);
        }

        private void exportList(List<String> uhtml, String type) {
            uhtml.add(WikiLanguage.UNICODE.tag(type));
            for (String s : this.lines) {
                int level = 0;
                if (s.startsWith("* ") || s.startsWith("- ")) {
                    ++level;
                    s = s.substring(2);
                }
                uhtml.add(WikiLanguage.UNICODE.tag(type + "li", "level", "" + level) + ReaderDokuwiki.this.singleLineFormat(s) + WikiLanguage.UNICODE.slashTag(type + "li"));
            }
            uhtml.add(WikiLanguage.UNICODE.slashTag(type));
        }

        private void exportFieldset(List<String> uhtml) {
            uhtml.add(WikiLanguage.UNICODE.tag("fieldset"));
            uhtml.addAll(ReaderDokuwiki.this.transform(this.lines));
            uhtml.add(WikiLanguage.UNICODE.slashTag("fieldset"));
        }

        private void exportBlockquote(List<String> uhtml) {
            uhtml.add(WikiLanguage.UNICODE.tag("blockquote"));
            uhtml.addAll(ReaderDokuwiki.this.transform(this.lines));
            uhtml.add(WikiLanguage.UNICODE.slashTag("blockquote"));
        }

        private void exportTable(List<String> uhtml) {
            uhtml.add(WikiLanguage.UNICODE.tag("table"));
            int i = 0;
            int sizeHeader = 0;
            for (String s : this.lines) {
                String sep = i == 0 ? "^" : "|";
                String tagHeader = i == 0 ? "th" : "tr";
                String cellHeader = i == 0 ? "tdh" : "td";
                uhtml.add(WikiLanguage.UNICODE.tag(tagHeader));
                s = ReaderDokuwiki.this.cleanAndHideBackslashSeparator(s, sep, "\uf500");
                String[] cols = s.split("\\" + sep);
                if (i == 0) {
                    sizeHeader = cols.length;
                } else if (cols.length != sizeHeader) {
                    System.err.println("lines=" + this.lines);
                    System.err.println("WARNING!!! " + sizeHeader + " " + cols.length);
                    throw new IllegalStateException("WARNING!!! " + sizeHeader + " " + cols.length);
                }
                for (String cell : cols) {
                    cell = cell.trim();
                    uhtml.add(WikiLanguage.UNICODE.tag(cellHeader));
                    uhtml.add(WikiLanguage.restoreAllCharsF7(cell.replace('\uf500', sep.charAt(0))));
                    uhtml.add(WikiLanguage.UNICODE.slashTag(cellHeader));
                }
                uhtml.add(WikiLanguage.UNICODE.slashTag(tagHeader));
                ++i;
            }
            uhtml.add(WikiLanguage.UNICODE.slashTag("table"));
        }

        public boolean isInTheGroup(String line) {
            if (this.headers[0].equals("^") && line.startsWith("|")) {
                return true;
            }
            if (this.headers[0].equals("> ") && line.startsWith(">")) {
                return true;
            }
            if (this.headers[0].equals("] ") && line.startsWith("]")) {
                return true;
            }
            for (String header : this.headers) {
                if (!line.startsWith(header)) continue;
                return true;
            }
            return false;
        }
    }

    class StartEndGroup {
        private final List<String> lines = new ArrayList<String>();
        private int skip = 0;
        private final String first;

        private StartEndGroup(List<String> raw, int i, String end) {
            this.first = raw.get(i);
            ++this.skip;
            ++i;
            while (i < raw.size() && !raw.get(i).equals(end)) {
                this.lines.add(raw.get(i));
                ++i;
                ++this.skip;
            }
            ++this.skip;
        }

        private void exportHtml(List<String> uhtml) {
            if (this.first.equals("<code>")) {
                ReaderDokuwiki.this.exportCodeInternal(uhtml, "codepre", this.lines);
            } else if (this.first.startsWith("<uml")) {
                ReaderDokuwiki.this.exportCodeInternal(uhtml, "imageuml", this.lines);
            } else if (this.first.equals("<plantuml>")) {
                ReaderDokuwiki.this.exportCodeInternalEnsureStartuml(uhtml, "codeandimg", this.lines);
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private int getSkipped() {
            return this.skip;
        }
    }
}

