/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandCreateState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreateState() {
        super(CommandCreateState.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateState.class.getName(), RegexLeaf.start(), new RegexLeaf("state"), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("DISPLAY1", "[%g]([^%g]+)[%g]")), new RegexConcat(new RegexLeaf("DISPLAY2", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)")), new RegexLeaf("CODE3", "([\\p{L}0-9_.]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandCreateState.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LINECOLOR", "##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("ADDFIELD", "(.*)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram diagram, LineLocation location, RegexResult arg) {
        String urlString;
        String idShort = arg.getLazzy("CODE", 0);
        Ident ident = diagram.buildLeafIdent(idShort);
        Ident code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        String display = arg.getLazzy("DISPLAY", 0);
        if (display == null) {
            display = code.getName();
        }
        String stereotype = arg.get("STEREOTYPE", 0);
        LeafType type = this.getTypeFromStereotype(stereotype);
        if (!diagram.checkConcurrentStateOk(ident, code)) {
            return CommandExecutionResult.error("The state " + code.getName() + " has been created in a concurrent state : it cannot be used here.");
        }
        IEntity ent = diagram.getOrCreateLeaf(diagram.buildLeafIdent(idShort), code, type, null);
        ent.setDisplay(Display.getWithNewlines(display));
        if (stereotype != null) {
            ent.setStereotype(new Stereotype(stereotype));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            ent.addUrl(url);
        }
        Colors colors = CommandCreateState.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        HColor lineColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINECOLOR", 1));
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        if (arg.get("LINECOLOR", 0) != null) {
            colors = colors.addLegacyStroke(arg.get("LINECOLOR", 0));
        }
        ent.setColors(colors);
        String addFields = arg.get("ADDFIELD", 0);
        if (addFields != null) {
            ent.getBodier().addFieldOrMethod(addFields);
        }
        return CommandExecutionResult.ok();
    }

    private LeafType getTypeFromStereotype(String stereotype) {
        if ("<<choice>>".equalsIgnoreCase(stereotype)) {
            return LeafType.STATE_CHOICE;
        }
        if ("<<fork>>".equalsIgnoreCase(stereotype)) {
            return LeafType.STATE_FORK_JOIN;
        }
        if ("<<join>>".equalsIgnoreCase(stereotype)) {
            return LeafType.STATE_FORK_JOIN;
        }
        if ("<<end>>".equalsIgnoreCase(stereotype)) {
            return LeafType.CIRCLE_END;
        }
        return null;
    }
}

