/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.EUC_TW;

public class CharToByteEUC_TW
extends CharToByteConverter {
    private final EUC_TW.Encoder enc = (EUC_TW.Encoder)new EUC_TW().newEncoder();

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        this.reset();
        return 0;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    public boolean canConvert(char ch) {
        return this.enc.canEncode(ch);
    }

    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        byte[] tmpbuf = new byte[4];
        this.byteOff = outOff;
        this.charOff = inOff;
        while (this.charOff < inEnd) {
            int outputSize;
            byte[] outputByte = tmpbuf;
            if (input[this.charOff] < '\u0080') {
                outputSize = 1;
                outputByte[0] = (byte)(input[this.charOff] & 0x7F);
            } else {
                outputSize = this.enc.toEUC(input[this.charOff], outputByte);
            }
            if (outputSize == -1) {
                if (this.subMode) {
                    outputByte = this.subBytes;
                    outputSize = this.subBytes.length;
                } else {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
            }
            if (outEnd - this.byteOff < outputSize) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            ++this.charOff;
        }
        return this.byteOff - outOff;
    }

    public int getMaxBytesPerChar() {
        return 4;
    }

    public String getCharacterEncoding() {
        return "EUC_TW";
    }
}

