/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.Globals;
import org.apache.catalina.ant.BaseRedirectorHelperTask;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;

public class ValidatorTask
extends BaseRedirectorHelperTask {
    protected String path = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.path == null) {
            throw new BuildException("Must specify 'path'");
        }
        File file = new File(this.path, "WEB-INF/web.xml");
        if (!file.exists() || !file.canRead()) {
            throw new BuildException("Cannot find web.xml");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ValidatorTask.class.getClassLoader());
        Digester digester = DigesterFactory.newDigester((boolean)true, (boolean)true, null, (boolean)Globals.IS_SECURITY_ENABLED);
        InputStream inputStream = null;
        try {
            file = file.getCanonicalFile();
            inputStream = new BufferedInputStream(new FileInputStream(file));
            InputSource inputSource = new InputSource(file.toURI().toURL().toExternalForm());
            inputSource.setByteStream(inputStream);
            digester.parse(inputSource);
            this.handleOutput("web.xml validated");
        }
        catch (Exception exception) {
            if (this.isFailOnError()) {
                throw new BuildException("Validation failure", (Throwable)exception);
            }
            this.handleErrorOutput("Validation failure: " + exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            this.closeRedirector();
        }
    }
}

