/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private static final LaunchMechanism launchMechanism = AccessController.doPrivileged(new PrivilegedAction<LaunchMechanism>(){

        @Override
        public LaunchMechanism run() {
            String javahome = System.getProperty("java.home");
            String osArch = System.getProperty("os.arch");
            UNIXProcess.access$002(UNIXProcess.toCString(javahome + "/lib/" + osArch + "/jspawnhelper"));
            String s = System.getProperty("jdk.lang.Process.launchMechanism", "vfork");
            try {
                return LaunchMechanism.valueOf(s.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new Error(s + " is not a supported " + "process launch mechanism on this platform.");
            }
        }
    });
    private static byte[] helperpath;
    private static final Executor processReaperExecutor;

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10) throws IOException;

    UNIXProcess(byte[] prog, byte[] argBlock, int argc, byte[] envBlock, int envc, byte[] dir, final int[] fds, boolean redirectErrorStream) throws IOException {
        this.pid = this.forkAndExec(launchMechanism.value, helperpath, prog, argBlock, argc, envBlock, envc, dir, fds, redirectErrorStream);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    UNIXProcess.this.initStreams(fds);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    static FileDescriptor newFileDescriptor(int fd) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, fd);
        return fileDescriptor;
    }

    void initStreams(int[] fds) throws IOException {
        this.stdin = fds[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(fds[0]);
        this.stdout = fds[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(fds[1]);
        this.stderr = fds[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(fds[2]);
        processReaperExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int exitcode = UNIXProcess.this.waitForProcessExit(UNIXProcess.this.pid);
                UNIXProcess.this.processExited(exitcode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processExited(int exitcode) {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            this.exitcode = exitcode;
            this.hasExited = true;
            this.notifyAll();
        }
        if (this.stdout instanceof ProcessPipeInputStream) {
            ((ProcessPipeInputStream)this.stdout).processExited();
        }
        if (this.stderr instanceof ProcessPipeInputStream) {
            ((ProcessPipeInputStream)this.stderr).processExited();
        }
        if (this.stdin instanceof ProcessPipeOutputStream) {
            ((ProcessPipeOutputStream)this.stdin).processExited();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        UNIXProcess uNIXProcess = this;
        synchronized (uNIXProcess) {
            if (!this.hasExited) {
                UNIXProcess.destroyProcess(this.pid);
            }
        }
        try {
            this.stdin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static native void init();

    static /* synthetic */ byte[] access$002(byte[] x0) {
        helperpath = x0;
        return x0;
    }

    static {
        processReaperExecutor = AccessController.doPrivileged(new PrivilegedAction<Executor>(){

            @Override
            public Executor run() {
                return Executors.newCachedThreadPool(new ProcessReaperThreadFactory());
            }
        });
        UNIXProcess.init();
    }

    static class ProcessPipeOutputStream
    extends BufferedOutputStream {
        ProcessPipeOutputStream(int fd) {
            super(new FileOutputStream(UNIXProcess.newFileDescriptor(fd)));
        }

        synchronized void processExited() {
            OutputStream out = this.out;
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = ProcessBuilder.NullOutputStream.INSTANCE;
            }
        }
    }

    static class ProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();

        ProcessPipeInputStream(int fd) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(fd)));
        }

        private static byte[] drainInputStream(InputStream in) throws IOException {
            int j;
            int n = 0;
            byte[] a = null;
            while ((j = in.available()) > 0) {
                a = a == null ? new byte[j] : Arrays.copyOf(a, n + j);
                n += in.read(a, n, j);
            }
            return a == null || n == a.length ? a : Arrays.copyOf(a, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void processExited() {
            Object object = this.closeLock;
            synchronized (object) {
                try {
                    InputStream in = this.in;
                    if (in != null) {
                        byte[] stragglers = ProcessPipeInputStream.drainInputStream(in);
                        in.close();
                        this.in = stragglers == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(stragglers);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                super.close();
            }
        }
    }

    private static class ProcessReaperThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup group = ProcessReaperThreadFactory.getRootThreadGroup();

        private ProcessReaperThreadFactory() {
        }

        private static ThreadGroup getRootThreadGroup() {
            return AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup root = Thread.currentThread().getThreadGroup();
                    while (root.getParent() != null) {
                        root = root.getParent();
                    }
                    return root;
                }
            });
        }

        @Override
        public Thread newThread(Runnable grimReaper) {
            Thread t = new Thread(group, grimReaper, "process reaper", 32768L);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        }
    }

    private static enum LaunchMechanism {
        FORK(1),
        VFORK(3);

        private int value;

        private LaunchMechanism(int x) {
            this.value = x;
        }
    }
}

