/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zh extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_key_nu = "\u6570\u5b57";
        final String metaValue_type_nu_gong = "\u9a6c\u8428\u62c9\u59c6\u5188\u5fb7\u6570\u5b57";
        final Object[][] data = new Object[][] {
            { "ksh", "\u79d1\u9686\u8bed" },
            { "Ogam", "\u6b27\u7518\u6587" },
            { "mwl", "\u7c73\u5170\u5fb7\u65af\u8bed" },
            { "Zsym", "\u7b26\u53f7" },
            { "cch", "\u963f\u707f\u8bed" },
            { "mwr", "\u9a6c\u5c14\u74e6\u91cc\u8bed" },
            { "type.nu.lanatham", "\u5170\u7eb3\u6587\u6570\u5b57" },
            { "Tagb", "\u5854\u683c\u73ed\u74e6\u6587" },
            { "Zsye", "\u8868\u60c5\u7b26\u53f7" },
            { "%%NJIVA", "Gniva/Njiva \u65b9\u8a00" },
            { "ccp", "\u67e5\u514b\u739b\u8bed" },
            { "egy", "\u53e4\u57c3\u53ca\u8bed" },
            { "raj", "\u62c9\u8d3e\u65af\u5766\u8bed" },
            { "Phag", "\u516b\u601d\u5df4\u6587" },
            { "tem", "\u6cf0\u59c6\u5948\u8bed" },
            { "Medf", "\u6885\u5fb7\u6cd5\u4f0a\u5fb7\u6797\u6587" },
            { "type.nu.sind", "\u5e93\u8fbe\u74e6\u8fea\u6570\u5b57" },
            { "teo", "\u7279\u7d22\u8bed" },
            { "rap", "\u62c9\u5e15\u52aa\u4f0a\u8bed" },
            { "ter", "\u7279\u4f26\u8bfa\u8bed" },
            { "AC", "\u963f\u68ee\u677e\u5c9b" },
            { "rar", "\u62c9\u7f57\u6c64\u52a0\u8bed" },
            { "tet", "\u5fb7\u987f\u8bed" },
            { "%%BARLA", "\u4f5b\u5f97\u89d2\u8bed\u5411\u98ce\u65b9\u8a00\u7ec4" },
            { "type.nu.sinh", "\u50e7\u4f3d\u7f57\u6587\u6570\u5b57" },
            { "AD", "\u5b89\u9053\u5c14" },
            { "AE", "\u963f\u62c9\u4f2f\u8054\u5408\u914b\u957f\u56fd" },
            { "nl_BE", "\u5f17\u62c9\u8292\u8bed" },
            { "AF", "\u963f\u5bcc\u6c57" },
            { "AG", "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe" },
            { "type.nu.mroo", "\u8c2c\u6587\u6570\u5b57" },
            { "type.ca.ethiopic", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u5386" },
            { "AI", "\u5b89\u572d\u62c9" },
            { "key.tz", "\u65f6\u533a" },
            { "AL", "\u963f\u5c14\u5df4\u5c3c\u4e9a" },
            { "AM", "\u4e9a\u7f8e\u5c3c\u4e9a" },
            { "Teng", "\u817e\u683c\u74e6\u6587\u5b57" },
            { "AO", "\u5b89\u54e5\u62c9" },
            { "AQ", "\u5357\u6781\u6d32" },
            { "AR", "\u963f\u6839\u5ef7" },
            { "Prti", "\u5e15\u63d0\u4e9a\u6587\u7891\u94ed\u4f53" },
            { "AS", "\u7f8e\u5c5e\u8428\u6469\u4e9a" },
            { "AT", "\u5965\u5730\u5229" },
            { "AU", "\u6fb3\u5927\u5229\u4e9a" },
            { "AW", "\u963f\u9c81\u5df4" },
            { "en_US", "\u7f8e\u56fd\u82f1\u8bed" },
            { "AX", "\u5965\u5170\u7fa4\u5c9b" },
            { "mye", "\u59c6\u8036\u5185\u8bed" },
            { "AZ", "\u963f\u585e\u62dc\u7586" },
            { "%%AREVELA", "\u4e1c\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "BA", "\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3" },
            { "BB", "\u5df4\u5df4\u591a\u65af" },
            { "ceb", "\u5bbf\u52a1\u8bed" },
            { "BD", "\u5b5f\u52a0\u62c9\u56fd" },
            { "kum", "\u5e93\u6885\u514b\u8bed" },
            { "BE", "\u6bd4\u5229\u65f6" },
            { "gmh", "\u4e2d\u53e4\u9ad8\u5730\u5fb7\u8bed" },
            { "Sogo", "\u53e4\u7c9f\u7279\u6587" },
            { "BF", "\u5e03\u57fa\u7eb3\u6cd5\u7d22" },
            { "BG", "\u4fdd\u52a0\u5229\u4e9a" },
            { "BH", "\u5df4\u6797" },
            { "BI", "\u5e03\u9686\u8fea" },
            { "BJ", "\u8d1d\u5b81" },
            { "BL", "\u5723\u5df4\u6cf0\u52d2\u7c73" },
            { "BM", "\u767e\u6155\u5927" },
            { "kut", "\u5e93\u7279\u5948\u8bed" },
            { "myv", "\u5384\u5c14\u5179\u4e9a\u8bed" },
            { "BN", "\u6587\u83b1" },
            { "BO", "\u73bb\u5229\u7ef4\u4e9a" },
            { "BQ", "\u8377\u5c5e\u52a0\u52d2\u6bd4\u533a" },
            { "BR", "\u5df4\u897f" },
            { "BS", "\u5df4\u54c8\u9a6c" },
            { "xog", "\u7d22\u52a0\u8bed" },
            { "BT", "\u4e0d\u4e39" },
            { "BV", "\u5e03\u97e6\u5c9b" },
            { "BW", "\u535a\u8328\u74e6\u7eb3" },
            { "BY", "\u767d\u4fc4\u7f57\u65af" },
            { "BZ", "\u4f2f\u5229\u5179" },
            { "Visp", "\u53ef\u89c1\u8bed\u8a00" },
            { "type.ca.persian", "\u6ce2\u65af\u5386" },
            { "%%CREISS", "\u514b\u96f7\u6851\u65b9\u8a00" },
            { "type.nu.hebr", "\u5e0c\u4f2f\u6765\u6570\u5b57" },
            { "CA", "\u52a0\u62ff\u5927" },
            { "Kits", "\u5951\u4e39\u5c0f\u5b57" },
            { "CC", "\u79d1\u79d1\u65af\uff08\u57fa\u6797\uff09\u7fa4\u5c9b" },
            { "mzn", "\u9a6c\u8d5e\u5fb7\u5170\u8bed" },
            { "CD", "\u521a\u679c\uff08\u91d1\uff09" },
            { "CF", "\u4e2d\u975e\u5171\u548c\u56fd" },
            { "CG", "\u521a\u679c\uff08\u5e03\uff09" },
            { "CH", "\u745e\u58eb" },
            { "CI", "\u79d1\u7279\u8fea\u74e6" },
            { "CK", "\u5e93\u514b\u7fa4\u5c9b" },
            { "CL", "\u667a\u5229" },
            { "Kthi", "\u51ef\u63d0\u6587" },
            { "CM", "\u5580\u9ea6\u9686" },
            { "CN", "\u4e2d\u56fd" },
            { "CO", "\u54e5\u4f26\u6bd4\u4e9a" },
            { "CP", "\u514b\u5229\u73c0\u987f\u5c9b" },
            { "CR", "\u54e5\u65af\u8fbe\u9ece\u52a0" },
            { "CU", "\u53e4\u5df4" },
            { "CV", "\u4f5b\u5f97\u89d2" },
            { "CW", "\u5e93\u62c9\u7d22" },
            { "CX", "\u5723\u8bde\u5c9b" },
            { "CY", "\u585e\u6d66\u8def\u65af" },
            { "type.nu.bali", "\u5df4\u5398\u6587\u6570\u5b57" },
            { "CZ", "\u6377\u514b" },
            { "eka", "\u827e\u5361\u6731\u514b\u8bed" },
            { "Ahom", "Ahom" },
            { "Pauc", "\u5305\u91d1\u8c6a\u6587" },
            { "%%RIGIK", "\u53e4\u5178\u6c83\u62c9\u666e\u514b\u8bed" },
            { "Sogd", "\u7c9f\u7279\u6587" },
            { "DE", "\u5fb7\u56fd" },
            { "goh", "\u53e4\u9ad8\u5730\u5fb7\u8bed" },
            { "ace", "\u4e9a\u9f50\u8bed" },
            { "cgg", "\u5947\u52a0\u8bed" },
            { "DG", "\u8fea\u6208\u52a0\u897f\u4e9a\u5c9b" },
            { "type.nu.deva", "\u68b5\u6587\u6570\u5b57" },
            { "DJ", "\u5409\u5e03\u63d0" },
            { "DK", "\u4e39\u9ea6" },
            { "ach", "\u963f\u4e54\u5229\u8bed" },
            { "gon", "\u5188\u5fb7\u8bed" },
            { "Brai", "\u5e03\u83b1\u53f6\u76f2\u6587" },
            { "Brah", "\u5a46\u7f57\u7c73\u6587\u5b57" },
            { "DM", "\u591a\u7c73\u5c3c\u514b" },
            { "type.nu.armnlow", "\u4e9a\u7f8e\u5c3c\u4e9a\u5c0f\u5199\u6570\u5b57" },
            { "DO", "\u591a\u7c73\u5c3c\u52a0\u5171\u548c\u56fd" },
            { "gor", "\u54e5\u4f26\u6253\u6d1b\u8bed" },
            { "got", "\u54e5\u7279\u8bed" },
            { "Mtei", "\u66fc\u5c3c\u666e\u5c14\u6587" },
            { "zun", "\u7956\u5c3c\u8bed" },
            { "tig", "\u63d0\u683c\u96f7\u8bed" },
            { "Takr", "\u6cf0\u514b\u91cc\u6587" },
            { "DZ", "\u963f\u5c14\u53ca\u5229\u4e9a" },
            { "pag", "\u90a6\u963f\u897f\u5357\u8bed" },
            { "type.d0.hwidth", "\u534a\u89d2" },
            { "pal", "\u5df4\u62c9\u7ef4\u8bed" },
            { "EA", "\u4f11\u8fbe\u53ca\u6885\u5229\u5229\u4e9a" },
            { "chb", "\u5947\u5e03\u67e5\u8bed" },
            { "pam", "\u90a6\u677f\u7259\u8bed" },
            { "EC", "\u5384\u74dc\u591a\u5c14" },
            { "pap", "\u5e15\u76ae\u963f\u95e8\u6258\u8bed" },
            { "ada", "\u963f\u5f53\u6885\u8bed" },
            { "EE", "\u7231\u6c99\u5c3c\u4e9a" },
            { "tiv", "\u8482\u592b\u8bed" },
            { "EG", "\u57c3\u53ca" },
            { "EH", "\u897f\u6492\u54c8\u62c9" },
            { "chg", "\u5bdf\u5408\u53f0\u8bed" },
            { "pau", "\u5e15\u52b3\u8bed" },
            { "chk", "\u695a\u514b\u8bed" },
            { "chn", "\u5947\u52aa\u514b\u6df7\u5408\u8bed" },
            { "chm", "\u9a6c\u91cc\u8bed" },
            { "chp", "\u5947\u4f69\u7ef4\u5b89\u8bed" },
            { "cho", "\u4e54\u514b\u6258\u8bed" },
            { "type.nu.mathbold", "\u6570\u5b66\u7c97\u4f53\u6570\u5b57" },
            { "chr", "\u5207\u7f57\u57fa\u8bed" },
            { "ER", "\u5384\u7acb\u7279\u91cc\u4e9a" },
            { "ES", "\u897f\u73ed\u7259" },
            { "ET", "\u57c3\u585e\u4fc4\u6bd4\u4e9a" },
            { "EU", "\u6b27\u76df" },
            { "elx", "\u57c3\u5170\u8bed" },
            { "type.ca.gregorian", "\u516c\u5386" },
            { "EZ", "\u6b27\u5143\u533a" },
            { "chy", "\u590f\u5ef6\u8bed" },
            { "type.nu.gujr", "\u53e4\u5409\u62c9\u7279\u6570\u5b57" },
            { "Inds", "\u5370\u5ea6\u6cb3\u6587\u5b57" },
            { "ady", "\u963f\u8fea\u683c\u8bed" },
            { "FI", "\u82ac\u5170" },
            { "FJ", "\u6590\u6d4e" },
            { "FK", "\u798f\u514b\u5170\u7fa4\u5c9b" },
            { "FM", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a" },
            { "key.va", "\u8bed\u8a00\u533a\u57df\u522b\u540d" },
            { "FO", "\u6cd5\u7f57\u7fa4\u5c9b" },
            { "Taml", "\u6cf0\u7c73\u5c14\u6587" },
            { "FR", "\u6cd5\u56fd" },
            { "Kpel", "\u514b\u4f69\u5217\u6587" },
            { "%%SIMPLE", "\u7b80\u5355\u82f1\u8bed" },
            { "tkl", "\u6258\u514b\u52b3\u8bed" },
            { "grb", "\u683c\u5217\u535a\u8bed" },
            { "root", "\u6839\u8bed\u8a00" },
            { "%%DAJNKO", "\u8fbe\u91d1\u79d1\u5b57\u6bcd" },
            { "type.ca.indian", "\u5370\u5ea6\u56fd\u5b9a\u5386" },
            { "grc", "\u53e4\u5e0c\u814a\u8bed" },
            { "GA", "\u52a0\u84ec" },
            { "vot", "\u6c83\u63d0\u514b\u8bed" },
            { "GB", "\u82f1\u56fd" },
            { "pcm", "\u5c3c\u65e5\u5229\u4e9a\u76ae\u94a6\u8bed" },
            { "GD", "\u683c\u6797\u7eb3\u8fbe" },
            { "GE", "\u683c\u9c81\u5409\u4e9a" },
            { "GF", "\u6cd5\u5c5e\u572d\u4e9a\u90a3" },
            { "GG", "\u6839\u897f\u5c9b" },
            { "GH", "\u52a0\u7eb3" },
            { "Tale", "\u6cf0\u4e50\u6587" },
            { "GI", "\u76f4\u5e03\u7f57\u9640" },
            { "afh", "\u963f\u5f17\u91cc\u5e0c\u5229\u8bed" },
            { "GL", "\u683c\u9675\u5170" },
            { "enm", "\u4e2d\u53e4\u82f1\u8bed" },
            { "GM", "\u5188\u6bd4\u4e9a" },
            { "GN", "\u51e0\u5185\u4e9a" },
            { "GP", "\u74dc\u5fb7\u7f57\u666e" },
            { "GQ", "\u8d64\u9053\u51e0\u5185\u4e9a" },
            { "GR", "\u5e0c\u814a" },
            { "GS", "\u5357\u4e54\u6cbb\u4e9a\u548c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b" },
            { "GT", "\u5371\u5730\u9a6c\u62c9" },
            { "GU", "\u5173\u5c9b" },
            { "type.nu.mathmono", "\u6570\u5b66\u7b49\u5bbd\u6570\u5b57" },
            { "GW", "\u51e0\u5185\u4e9a\u6bd4\u7ecd" },
            { "tli", "\u7279\u6797\u5409\u7279\u8bed" },
            { "tlh", "\u514b\u6797\u8d21\u8bed" },
            { "Talu", "\u65b0\u50a3\u6587" },
            { "GY", "\u572d\u4e9a\u90a3" },
            { "ckb", "\u4e2d\u5e93\u5c14\u5fb7\u8bed" },
            { "zxx", "\u65e0\u8bed\u8a00\u5185\u5bb9" },
            { "Jurc", "\u5973\u771f\u6587" },
            { "%%VIVARAUP", "\u7ef4\u74e6\u9c81\u666e\u65b9\u8a00" },
            { "de_AT", "\u5965\u5730\u5229\u5fb7\u8bed" },
            { "HK", "\u4e2d\u56fd\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a" },
            { "Vaii", "\u74e6\u4f9d\u6587" },
            { "HM", "\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b" },
            { "HN", "\u6d2a\u90fd\u62c9\u65af" },
            { "HR", "\u514b\u7f57\u5730\u4e9a" },
            { "agq", "\u4e9a\u7f55\u8bed" },
            { "gsw", "\u745e\u58eb\u5fb7\u8bed" },
            { "type.ca.islamic-umalqura", "\u4f0a\u65af\u5170\u5386\uff08\u4e4c\u59c6\u5e93\u62c9\uff09" },
            { "HT", "\u6d77\u5730" },
            { "HU", "\u5308\u7259\u5229" },
            { "tmh", "\u5854\u9a6c\u5947\u514b\u8bed" },
            { "IC", "\u52a0\u7eb3\u5229\u7fa4\u5c9b" },
            { "nan", "\u95fd\u5357\u8bed" },
            { "ID", "\u5370\u5ea6\u5c3c\u897f\u4e9a" },
            { "peo", "\u53e4\u6ce2\u65af\u8bed" },
            { "Adlm", "\u963f\u5fb7\u62c9\u59c6\u6587" },
            { "type.nu.kali", "\u514b\u8036\u5b57\u6bcd\u6570\u5b57" },
            { "IE", "\u7231\u5c14\u5170" },
            { "nap", "\u90a3\u4e0d\u52d2\u65af\u8bed" },
            { "%%NDYUKA", "Ndyuka \u65b9\u8a00" },
            { "naq", "\u7eb3\u9a6c\u8bed" },
            { "type.nu.sora", "\u7d20\u62c9\u50e7\u5e73\u6570\u5b57" },
            { "zza", "\u624e\u624e\u8bed" },
            { "Tang", "\u5510\u53e4\u7279\u6587" },
            { "IL", "\u4ee5\u8272\u5217" },
            { "Nbat", "\u7eb3\u5df4\u6cf0\u6587" },
            { "IM", "\u9a6c\u6069\u5c9b" },
            { "IN", "\u5370\u5ea6" },
            { "type.co.eor", "\u6b27\u6d32\u6392\u5e8f\u89c4\u5219" },
            { "IO", "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730" },
            { "IQ", "\u4f0a\u62c9\u514b" },
            { "IR", "\u4f0a\u6717" },
            { "IS", "\u51b0\u5c9b" },
            { "IT", "\u610f\u5927\u5229" },
            { "Zmth", "\u6570\u5b66\u7b26\u53f7" },
            { "type.nu.thai", "\u6cf0\u6587\u6570\u5b57" },
            { "%%POSIX", "\u7535\u8111" },
            { "type.nu.beng", "\u5b5f\u52a0\u62c9\u6570\u5b57" },
            { "type.nu.cyrl", "\u65af\u62c9\u592b\u6570\u5b57" },
            { "JE", "\u6cfd\u897f\u5c9b" },
            { "type.ca.islamic", "\u4f0a\u65af\u5170\u5386" },
            { "JM", "\u7259\u4e70\u52a0" },
            { "Beng", "\u5b5f\u52a0\u62c9\u6587" },
            { "%%EKAVSK", "\u585e\u5c14\u7ef4\u4e9a\u8bed\u4f0a\u5361\u7ef4\u4e9a\u53d1\u97f3" },
            { "JO", "\u7ea6\u65e6" },
            { "JP", "\u65e5\u672c" },
            { "%%1606NICT", "1606 \u5e74\u524d\u4e2d\u540e\u671f\u6cd5\u6587" },
            { "ain", "\u963f\u4f0a\u52aa\u8bed" },
            { "%%KOCIEWIE", "\u79d1\u5947\u97e6\u65b9\u8a00" },
            { "Mend", "\u95e8\u8fea\u6587" },
            { "guz", "\u53e4\u897f\u8bed" },
            { "tog", "\u5c3c\u4e9a\u8428\u6c64\u52a0\u8bed" },
            { "type.nu.knda", "\u5361\u7eb3\u8fbe\u6570\u5b57" },
            { "Kali", "\u514b\u8036\u674e\u6587\u5b57" },
            { "Sidd", "\u6089\u6619" },
            { "de_CH", "\u745e\u58eb\u9ad8\u5730\u5fb7\u8bed" },
            { "type.co.phonetic", "\u8bed\u97f3\u6392\u5e8f" },
            { "type.ca.buddhist", "\u4f5b\u5386" },
            { "KE", "\u80af\u5c3c\u4e9a" },
            { "419", "\u62c9\u4e01\u7f8e\u6d32" },
            { "KG", "\u5409\u5c14\u5409\u65af\u65af\u5766" },
            { "KH", "\u67ec\u57d4\u5be8" },
            { "KI", "\u57fa\u91cc\u5df4\u65af" },
            { "KM", "\u79d1\u6469\u7f57" },
            { "KN", "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af" },
            { "Knda", "\u5361\u7eb3\u8fbe\u6587" },
            { "Zinh", "\u9057\u4f20\u5b66\u672f\u8bed" },
            { "fr_CA", "\u52a0\u62ff\u5927\u6cd5\u8bed" },
            { "KP", "\u671d\u9c9c" },
            { "KR", "\u97e9\u56fd" },
            { "Plrd", "\u6ce2\u62c9\u5fb7\u97f3\u6807\u6587\u5b57" },
            { "fr_CH", "\u745e\u58eb\u6cd5\u8bed" },
            { "KW", "\u79d1\u5a01\u7279" },
            { "tpi", "\u6258\u514b\u76ae\u8f9b\u8bed" },
            { "KY", "\u5f00\u66fc\u7fa4\u5c9b" },
            { "KZ", "\u54c8\u8428\u514b\u65af\u5766" },
            { "Cyrl", "\u897f\u91cc\u5c14\u6587" },
            { "LA", "\u8001\u631d" },
            { "LB", "\u9ece\u5df4\u5ae9" },
            { "LC", "\u5723\u5362\u897f\u4e9a" },
            { "phn", "\u8153\u5c3c\u57fa\u8bed" },
            { "Cyrs", "\u897f\u91cc\u5c14\u6587\u5b57\uff08\u53e4\u6559\u4f1a\u65af\u62c9\u592b\u6587\u7684\u53d8\u4f53\uff09" },
            { "gwi", "\u54e5\u5a01\u8fc5\u8bed" },
            { "%%LUNA1918", "\u4fc4\u6587\u62fc\u5b57\uff081918\u5e74\u8d77\uff09" },
            { "nds", "\u4f4e\u5730\u5fb7\u8bed" },
            { "LI", "\u5217\u652f\u6566\u58eb\u767b" },
            { "LK", "\u65af\u91cc\u5170\u5361" },
            { "akk", "\u963f\u5361\u5fb7\u8bed" },
            { "cop", "\u79d1\u666e\u7279\u8bed" },
            { "Hmnp", "\u5c3c\u4e9a\u80af\u84b2\u4e18\u82d7\u6587" },
            { "LR", "\u5229\u6bd4\u91cc\u4e9a" },
            { "LS", "\u83b1\u7d22\u6258" },
            { "Phlv", "\u5df4\u5217\u7ef4\u6587\uff08\u4e66\u4f53\uff09" },
            { "LT", "\u7acb\u9676\u5b9b" },
            { "LU", "\u5362\u68ee\u5821" },
            { "LV", "\u62c9\u8131\u7ef4\u4e9a" },
            { "Kana", "\u7247\u5047\u540d" },
            { "Sora", "\u7d22\u6717\u6851\u670b\u6587" },
            { "LY", "\u5229\u6bd4\u4e9a" },
            { "lad", "\u62c9\u8fea\u8bfa\u8bed" },
            { "vun", "\u6e29\u65e7\u8bed" },
            { "%%LAUKIKA", "\u4f20\u7edf\u68b5\u6587" },
            { "lah", "\u5370\u5ea6-\u96c5\u5229\u5b89\u8bed" },
            { "Mahj", "\u9ed8\u54c8\u91d1\u6587" },
            { "lag", "\u6717\u5409\u8bed" },
            { "Thaa", "\u5854\u5b89\u90a3\u6587" },
            { "MA", "\u6469\u6d1b\u54e5" },
            { "MC", "\u6469\u7eb3\u54e5" },
            { "MD", "\u6469\u5c14\u591a\u74e6" },
            { "Nshu", "\u5973\u4e66" },
            { "ME", "\u9ed1\u5c71" },
            { "MF", "\u6cd5\u5c5e\u5723\u9a6c\u4e01" },
            { "lam", "\u5170\u5df4\u8bed" },
            { "MG", "\u9a6c\u8fbe\u52a0\u65af\u52a0" },
            { "MH", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b" },
            { "ale", "\u963f\u7559\u7533\u8bed" },
            { "Thai", "\u6cf0\u6587" },
            { "type.nu.vaii", "\u74e6\u4f0a\u6587\u6570\u5b57" },
            { "MK", "\u5317\u9a6c\u5176\u987f" },
            { "type.nu.mathdbl", "\u6570\u5b66\u7a7a\u5fc3\u6570\u5b57" },
            { "ML", "\u9a6c\u91cc" },
            { "MM", "\u7f05\u7538" },
            { "MN", "\u8499\u53e4" },
            { "new", "\u5c3c\u74e6\u5c14\u8bed" },
            { "MO", "\u4e2d\u56fd\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a" },
            { "MP", "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b" },
            { "MQ", "\u9a6c\u63d0\u5c3c\u514b" },
            { "MR", "\u6bdb\u91cc\u5854\u5c3c\u4e9a" },
            { "MS", "\u8499\u7279\u585e\u62c9\u7279" },
            { "Chrs", "\u82b1\u62c9\u5b50\u6a21\u6587" },
            { "MT", "\u9a6c\u8033\u4ed6" },
            { "type.m0.ungegn", "\u8054\u5408\u56fd\u5730\u540d\u4e13\u5bb6\u7ec4 (UNGEGN)" },
            { "MU", "\u6bdb\u91cc\u6c42\u65af" },
            { "alt", "\u5357\u963f\u5c14\u6cf0\u8bed" },
            { "MV", "\u9a6c\u5c14\u4ee3\u592b" },
            { "MW", "\u9a6c\u62c9\u7ef4" },
            { "MX", "\u58a8\u897f\u54e5" },
            { "type.ca.japanese", "\u548c\u5386" },
            { "MY", "\u9a6c\u6765\u897f\u4e9a" },
            { "MZ", "\u83ab\u6851\u6bd4\u514b" },
            { "Phli", "\u5df4\u5217\u7ef4\u6587\u7891\u94ed\u4f53" },
            { "NA", "\u7eb3\u7c73\u6bd4\u4e9a" },
            { "%%ARANES", "\u963f\u5170\u65b9\u8a00" },
            { "202", "\u6492\u54c8\u62c9\u4ee5\u5357\u975e\u6d32" },
            { "type.ca.hebrew", "\u5e0c\u4f2f\u6765\u5386" },
            { "type.co.dictionary", "\u5b57\u5178\u6392\u5e8f" },
            { "NC", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a" },
            { "%%WADEGILE", "WG \u5a01\u6c0f\u62fc\u97f3\u6cd5" },
            { "%%UCRCOR", "\u7edf\u4e00\u548c\u4fee\u8ba2\u7684\u62fc\u5b57" },
            { "NE", "\u5c3c\u65e5\u5c14" },
            { "NF", "\u8bfa\u798f\u514b\u5c9b" },
            { "NG", "\u5c3c\u65e5\u5229\u4e9a" },
            { "trv", "\u8d5b\u5fb7\u514b\u8bed" },
            { "Phlp", "\u5df4\u5217\u7ef4\u6587\uff08\u5723\u8bd7\u4f53\uff09" },
            { "NI", "\u5c3c\u52a0\u62c9\u74dc" },
            { "Hmng", "\u6768\u677e\u5f55\u82d7\u6587" },
            { "NL", "\u8377\u5170" },
            { "NO", "\u632a\u5a01" },
            { "NP", "\u5c3c\u6cca\u5c14" },
            { "NR", "\u7459\u9c81" },
            { "NU", "\u7ebd\u57c3" },
            { "Phnx", "\u8153\u5c3c\u57fa\u6587" },
            { "rof", "\u5170\u535a\u8bed" },
            { "tsi", "\u94a6\u897f\u5b89\u8bed" },
            { "NZ", "\u65b0\u897f\u5170" },
            { "Merc", "\u9ea6\u7f57\u57c3\u8349\u4e66" },
            { "%%COLB1945", "1945\u5e74\u8461\u8404\u7259-\u5df4\u897f\u6b63\u5199\u6cd5\u534f\u5b9a" },
            { "rom", "\u5409\u666e\u8d5b\u8bed" },
            { "Mero", "\u9ea6\u82e5\u63d0\u514b\u6587" },
            { "crh", "\u514b\u91cc\u7c73\u4e9a\u571f\u8033\u5176\u8bed" },
            { "ang", "\u53e4\u82f1\u8bed" },
            { "%%GRMISTR", "\u683c\u7c73\u65af\u7279\u65b9\u8a00" },
            { "OM", "\u963f\u66fc" },
            { "%%PETR1708", "\u4fc4\u6587\u62fc\u5b57\uff081708\u5e74\uff09" },
            { "anp", "\u6602\u52a0\u8bed" },
            { "crs", "\u585e\u820c\u5c14\u514b\u91cc\u5965\u5c14\u8bed" },
            { "type.nu.hmnp", "\u5c3c\u4e9a\u80af\u84b2\u4e18\u82d7\u6587\u6570\u5b57" },
            { "Xpeo", "\u53e4\u6ce2\u65af\u6587" },
            { "type.nu.hmng", "\u6768\u677e\u5f55\u82d7\u6587\u6570\u5b57" },
            { "PA", "\u5df4\u62ff\u9a6c" },
            { "type.ca.islamic-civil", "\u4f0a\u65af\u5170\u5e0c\u5409\u6765\u65e5\u5386" },
            { "csb", "\u5361\u8212\u6bd4\u8bed" },
            { "en_GB", "\u82f1\u56fd\u82f1\u8bed" },
            { "PE", "\u79d8\u9c81" },
            { "PF", "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a" },
            { "PG", "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a" },
            { "PH", "\u83f2\u5f8b\u5bbe" },
            { "PK", "\u5df4\u57fa\u65af\u5766" },
            { "%%NICARD", "\u5c3c\u65af\u65b9\u8a00" },
            { "PL", "\u6ce2\u5170" },
            { "ewo", "\u65fa\u675c\u8bed" },
            { "PM", "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b" },
            { "PN", "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b" },
            { "PR", "\u6ce2\u591a\u9ece\u5404" },
            { "PS", "\u5df4\u52d2\u65af\u5766\u9886\u571f" },
            { "Bali", "\u5df4\u5398\u6587" },
            { "PT", "\u8461\u8404\u7259" },
            { "PW", "\u5e15\u52b3" },
            { "nia", "\u5c3c\u4e9a\u65af\u8bed" },
            { "type.nu.greklow", "\u5e0c\u814a\u5c0f\u5199\u6570\u5b57" },
            { "PY", "\u5df4\u62c9\u572d" },
            { "tum", "\u901a\u5e03\u5361\u8bed" },
            { "Hebr", "\u5e0c\u4f2f\u6765\u6587" },
            { "QA", "\u5361\u5854\u5c14" },
            { "%%SCOTLAND", "\u82cf\u683c\u5170\u6807\u51c6\u82f1\u6587" },
            { "niu", "\u7ebd\u57c3\u8bed" },
            { "QO", "\u5927\u6d0b\u6d32\u8fb9\u8fdc\u7fa4\u5c9b" },
            { "lez", "\u5217\u5179\u91d1\u8bed" },
            { "type.nu.ahom", "\u963f\u970d\u59c6\u6570\u5b57" },
            { "%%FONUPA", "UPA \u97f3\u6807" },
            { "type.nu.takr", "\u6cf0\u514b\u91cc\u6570\u5b57" },
            { "tvl", "\u56fe\u74e6\u5362\u8bed" },
            { "Tavt", "\u8d8a\u5357\u50a3\u6587" },
            { "%%SOTAV", "\u4f5b\u5f97\u89d2\u8bed\u80cc\u98ce\u65b9\u8a00\u7ec4" },
            { "Maka", "\u671b\u52a0\u9521\u6587" },
            { "001", "\u4e16\u754c" },
            { "002", "\u975e\u6d32" },
            { "003", "\u5317\u7f8e\u6d32" },
            { "RE", "\u7559\u5c3c\u6c6a" },
            { "005", "\u5357\u7f8e\u6d32" },
            { "jbo", "\u903b\u8f91\u8bed" },
            { "Rjng", "\u62c9\u8ba9\u6587" },
            { "009", "\u5927\u6d0b\u6d32" },
            { "Elym", "\u57c3\u5229\u8fc8\u6587" },
            { "%%SURSILV", "\u745e\u58eb\u82cf\u745f\u74e6\u65b9\u8a00" },
            { "RO", "\u7f57\u9a6c\u5c3c\u4e9a" },
            { "RS", "\u585e\u5c14\u7ef4\u4e9a" },
            { "Mroo", "\u8c2c\u6587" },
            { "RU", "\u4fc4\u7f57\u65af" },
            { "RW", "\u5362\u65fa\u8fbe" },
            { "type.nu.talu", "\u65b0\u50a3\u4ec2\u6587\u6570\u5b57" },
            { "%%METELKO", "\u6885\u7279\u5c14\u79d1\u5b57\u6bcd" },
            { "Mani", "\u6469\u5c3c\u6559\u6587" },
            { "Ugar", "\u4e4c\u52a0\u91cc\u7279\u6587" },
            { "Khar", "\u5361\u7f57\u987b\u63d0\u6587" },
            { "SA", "\u6c99\u7279\u963f\u62c9\u4f2f" },
            { "pon", "\u6ce2\u7eb3\u4f69\u8bed" },
            { "Mand", "\u963f\u62c9\u7c73\u6587" },
            { "SB", "\u6240\u7f57\u95e8\u7fa4\u5c9b" },
            { "twq", "\u5317\u6851\u6d77\u8bed" },
            { "011", "\u897f\u975e" },
            { "SC", "\u585e\u820c\u5c14" },
            { "SD", "\u82cf\u4e39" },
            { "013", "\u4e2d\u7f8e\u6d32" },
            { "SE", "\u745e\u5178" },
            { "014", "\u4e1c\u975e" },
            { "arc", "\u963f\u62c9\u7c73\u8bed" },
            { "Loma", "\u6d1b\u9a6c\u6587" },
            { "015", "\u5317\u975e" },
            { "SG", "\u65b0\u52a0\u5761" },
            { "SH", "\u5723\u8d6b\u52d2\u62ff" },
            { "type.lb.strict", "\u4e25\u683c\u6362\u884c\u7b26\u6837\u5f0f" },
            { "017", "\u4e2d\u975e" },
            { "SI", "\u65af\u6d1b\u6587\u5c3c\u4e9a" },
            { "type.nu.mymrtlng", "\u7f05\u7538\u6cf0\u5170\u6570\u5b57" },
            { "018", "\u5357\u90e8\u975e\u6d32" },
            { "SJ", "\u65af\u74e6\u5c14\u5df4\u548c\u626c\u9a6c\u5ef6" },
            { "019", "\u7f8e\u6d32" },
            { "SK", "\u65af\u6d1b\u4f10\u514b" },
            { "Bamu", "\u5df4\u59c6\u7a46\u6587" },
            { "Wole", "\u6c83\u83b1\u827e\u6587" },
            { "SL", "\u585e\u62c9\u5229\u6602" },
            { "SM", "\u5723\u9a6c\u529b\u8bfa" },
            { "SN", "\u585e\u5185\u52a0\u5c14" },
            { "SO", "\u7d22\u9a6c\u91cc" },
            { "arn", "\u9a6c\u666e\u5207\u8bed" },
            { "arp", "\u963f\u62c9\u5e15\u970d\u8bed" },
            { "type.nu.taml", "\u4f20\u7edf\u6cf0\u7c73\u5c14\u6570\u5b57" },
            { "SR", "\u82cf\u91cc\u5357" },
            { "SS", "\u5357\u82cf\u4e39" },
            { "ST", "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4" },
            { "SV", "\u8428\u5c14\u74e6\u591a" },
            { "ars", "\u7eb3\u5409\u8fea\u963f\u62c9\u4f2f\u8bed" },
            { "SX", "\u8377\u5c5e\u5723\u9a6c\u4e01" },
            { "SY", "\u53d9\u5229\u4e9a" },
            { "yao", "\u7476\u65cf\u8bed" },
            { "SZ", "\u65af\u5a01\u58eb\u5170" },
            { "arw", "\u963f\u62c9\u74e6\u514b\u8bed" },
            { "yap", "\u96c5\u6d66\u8bed" },
            { "TA", "\u7279\u91cc\u65af\u5766-\u8fbe\u5e93\u5c3c\u4e9a\u7fa4\u5c9b" },
            { "asa", "\u5e15\u96f7\u8bed" },
            { "type.ms.ussystem", "\u7f8e\u5236" },
            { "021", "\u7f8e\u6d32\u5317\u90e8" },
            { "TC", "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b" },
            { "yav", "\u6d0b\u535e\u8bed" },
            { "TD", "\u4e4d\u5f97" },
            { "Qaag", "Zawgyi" },
            { "TF", "\u6cd5\u5c5e\u5357\u90e8\u9886\u5730" },
            { "TG", "\u591a\u54e5" },
            { "TH", "\u6cf0\u56fd" },
            { "TJ", "\u5854\u5409\u514b\u65af\u5766" },
            { "029", "\u52a0\u52d2\u6bd4\u5730\u533a" },
            { "TK", "\u6258\u514b\u52b3" },
            { "TL", "\u4e1c\u5e1d\u6c76" },
            { "ybb", "\u8036\u59c6\u5df4\u8bed" },
            { "type.co.searchjl", "\u6309\u97e9\u6587\u5b57\u5f00\u9996\u8f85\u97f3\u6765\u641c\u7d22" },
            { "TM", "\u571f\u5e93\u66fc\u65af\u5766" },
            { "%%BOONT", "\u5e03\u6069\u7279\u6797\u65b9\u8a00" },
            { "TN", "\u7a81\u5c3c\u65af" },
            { "TO", "\u6c64\u52a0" },
            { "%%NULIK", "\u73b0\u4ee3\u6c83\u62c9\u666e\u514b\u8bed" },
            { "TR", "\u571f\u8033\u5176" },
            { "TT", "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5" },
            { "TV", "\u56fe\u74e6\u5362" },
            { "TW", "\u53f0\u6e7e" },
            { "ast", "\u963f\u65af\u56fe\u91cc\u4e9a\u65af\u8bed" },
            { "Orkh", "\u9102\u5c14\u6d51\u6587" },
            { "TZ", "\u5766\u6851\u5c3c\u4e9a" },
            { "nmg", "\u5938\u897f\u5965\u8bed" },
            { "Zzzz", "\u672a\u77e5\u6587\u5b57" },
            { "Sind", "\u4fe1\u5fb7\u6587" },
            { "UA", "\u4e4c\u514b\u5170" },
            { "rup", "\u963f\u7f57\u9a6c\u5c3c\u4e9a\u8bed" },
            { "030", "\u4e1c\u4e9a" },
            { "tyv", "\u56fe\u74e6\u8bed" },
            { "sw_CD", "\u521a\u679c\u65af\u74e6\u5e0c\u91cc\u8bed" },
            { "034", "\u5357\u4e9a" },
            { "hai", "\u6d77\u8fbe\u8bed" },
            { "035", "\u4e1c\u5357\u4e9a" },
            { "UG", "\u4e4c\u5e72\u8fbe" },
            { "hak", "\u5ba2\u5bb6\u8bed" },
            { "type.co.pinyin", "\u62fc\u97f3\u6392\u5e8f" },
            { "039", "\u5357\u6b27" },
            { "Sinh", "\u50e7\u4f3d\u7f57\u6587" },
            { "UM", "\u7f8e\u56fd\u672c\u571f\u5916\u5c0f\u5c9b\u5c7f" },
            { "UN", "\u8054\u5408\u56fd" },
            { "US", "\u7f8e\u56fd" },
            { "haw", "\u590f\u5a01\u5937\u8bed" },
            { "%%1959ACAD", "\u5b66\u672f" },
            { "%%IVANCHOV", "\u4f0a\u4e07\u4e54\u592b\u65b9\u8a00" },
            { "type.co.gb2312han", "\u7b80\u4f53\u4e2d\u6587\u6392\u5e8f - GB2312" },
            { "UY", "\u4e4c\u62c9\u572d" },
            { "prg", "\u666e\u9c81\u58eb\u8bed" },
            { "UZ", "\u4e4c\u5179\u522b\u514b\u65af\u5766" },
            { "tzm", "\u5854\u9a6c\u9f50\u683c\u7279\u8bed" },
            { "type.co.stroke", "\u7b14\u753b\u6392\u5e8f" },
            { "nnh", "\u6069\u7518\u6f8e\u8bed" },
            { "VA", "\u68b5\u8482\u5188" },
            { "pro", "\u53e4\u666e\u7f57\u6587\u65af\u8bed" },
            { "VC", "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af" },
            { "%%HSISTEMO", "\u8d6b\u897f\u65af\u7279\u83ab\u65b9\u8a00" },
            { "VE", "\u59d4\u5185\u745e\u62c9" },
            { "VG", "\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b" },
            { "VI", "\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b" },
            { "%%LEMOSIN", "\u5229\u59c6\u8d5e\u65b9\u8a00" },
            { "Soyo", "\u7d22\u6c38\u5e03\u6587" },
            { "VN", "\u8d8a\u5357" },
            { "VU", "\u74e6\u52aa\u963f\u56fe" },
            { "Marc", "\u5927\u739b\u5c14\u6587" },
            { "nog", "\u8bfa\u76d6\u8bed" },
            { "rwk", "\u7f57\u74e6\u8bed" },
            { "non", "\u53e4\u8bfa\u5c14\u65af\u8bed" },
            { "053", "\u6fb3\u5927\u62c9\u897f\u4e9a" },
            { "%%AREVMDA", "\u897f\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "054", "\u7f8e\u62c9\u5c3c\u897f\u4e9a" },
            { "WF", "\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3" },
            { "type.co.traditional", "\u4f20\u7edf\u6392\u5e8f" },
            { "057", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u5730\u533a" },
            { "jgo", "\u6069\u826e\u5df4\u8bed" },
            { "lkt", "\u62c9\u79d1\u5854\u8bed" },
            { "type.nu.finance", "\u91d1\u878d\u6570\u5b57" },
            { "%%HEPBURN", "\u8d6b\u4f2f\u6069\u7f57\u9a6c\u5b57" },
            { "type.co.compat", "\u57fa\u4e8e\u517c\u5bb9\u6027\u6cbf\u7528\u65e2\u5f80\u6392\u5e8f" },
            { "wae", "\u74e6\u5c14\u745f\u8bed" },
            { "WS", "\u8428\u6469\u4e9a" },
            { "Bass", "\u5df4\u8428\u6587" },
            { "type.nu.mtei", "\u66fc\u5c3c\u666e\u5c14\u6570\u5b57" },
            { "wal", "\u74e6\u62c9\u83ab\u8bed" },
            { "was", "\u74e6\u7ecd\u8bed" },
            { "XA", "\u4f2a\u5730\u533a" },
            { "war", "\u74e6\u745e\u8bed" },
            { "XB", "\u4f2a\u53cc\u5411\u8bed\u8a00\u5730\u533a" },
            { "awa", "\u963f\u74e6\u5fb7\u8bed" },
            { "061", "\u73bb\u5229\u5c3c\u897f\u4e9a" },
            { "%%KSCOR", "\u6807\u51c6\u6b63\u5199\u6cd5" },
            { "XK", "\u79d1\u7d22\u6c83" },
            { "type.nu.brah", "\u5a46\u7f57\u7c73\u6570\u5b57" },
            { "Gujr", "\u53e4\u5409\u62c9\u7279\u6587" },
            { "Zxxx", "\u975e\u4e66\u9762\u6587\u5b57" },
            { "Olck", "\u6851\u5854\u5229\u6587" },
            { "wbp", "\u74e6\u5c14\u76ae\u745e\u8bed" },
            { "Batk", "\u5df4\u5854\u514b\u6587" },
            { "Blis", "\u5e03\u5217\u65af\u7b26\u53f7" },
            { "YE", "\u4e5f\u95e8" },
            { "nqo", "\u897f\u975e\u4e66\u9762\u6587\u5b57" },
            { "type.co.standard", "\u6807\u51c6\u6392\u5e8f" },
            { "Zanb", "\u672d\u90a3\u5df4\u672d\u5c14\u65b9\u5757\u6587\u5b57" },
            { "fan", "\u82b3\u683c\u8bed" },
            { "%%BALANKA", "\u963f\u5c3c\u8bedBalanka\u65b9\u8a00" },
            { "%%ROZAJ", "\u96f7\u897f\u4e9a\u6587" },
            { "%%SUTSILV", "\u745e\u58eb\u82cf\u5e0c\u74e6\u65b9\u8a00" },
            { "fat", "\u82b3\u8482\u8bed" },
            { "Sgnw", "\u4e66\u5199\u7b26\u53f7" },
            { "YT", "\u9a6c\u7ea6\u7279" },
            { "type.nu.cham", "\u5360\u6587\u6570\u5b57" },
            { "%%NEWFOUND", "\u7ebd\u82ac\u5170\u65b9\u8a00" },
            { "ZA", "\u5357\u975e" },
            { "type.nu.sund", "\u82cf\u4e39\u6587\u6570\u5b57" },
            { "type.lb.loose", "\u5bbd\u677e\u6362\u884c\u7b26\u6837\u5f0f" },
            { "Deva", "\u5929\u57ce\u6587" },
            { "type.nu.geor", "\u683c\u9c81\u5409\u4e9a\u6570\u5b57" },
            { "type.co.zhuyin", "\u6ce8\u97f3\u6392\u5e8f" },
            { "Hira", "\u5e73\u5047\u540d" },
            { "ZM", "\u8d5e\u6bd4\u4e9a" },
            { "%%PINYIN", "\u62fc\u97f3\u7f57\u9a6c\u5b57" },
            { "ZW", "\u6d25\u5df4\u5e03\u97e6" },
            { "ZZ", "\u672a\u77e5\u5730\u533a" },
            { "Runr", "\u53e4\u4ee3\u5317\u6b27\u6587" },
            { "type.ms.metric", "\u516c\u5236" },
            { "type.ca.iso8601", "\u56fd\u9645\u6807\u51c6\u5386\u6cd5" },
            { "lol", "\u8499\u6208\u8bed" },
            { "nso", "\u5317\u7d22\u6258\u8bed" },
            { "type.nu.telu", "\u6cf0\u5362\u56fa\u6570\u5b57" },
            { "lou", "\u8def\u6613\u65af\u5b89\u90a3\u514b\u91cc\u5965\u5c14\u8bed" },
            { "loz", "\u6d1b\u9f50\u8bed" },
            { "%%FONKIRSH", "\u4e30\u5409\u4ec0\u65b9\u8a00" },
            { "Nkgb", "\u7eb3\u897f\u683c\u5df4\u6587" },
            { "%%ASANTE", "\u963f\u6563\u8482\u65b9\u8a00" },
            { "%%AUVERN", "\u81ea\u52a8\u94bb\u673a" },
            { "jmc", "\u9a6c\u5207\u59c6\u8bed" },
            { "type.nu.hansfin", "\u7b80\u4f53\u4e2d\u6587\u5927\u5199\u6570\u5b57" },
            { "hil", "\u5e0c\u5229\u76d6\u519c\u8bed" },
            { "type.nu.arabext", "\u6269\u5c55\u963f\u62c9\u4f2f-\u5370\u5ea6\u6570\u5b57" },
            { "nus", "\u52aa\u57c3\u5c14\u8bed" },
            { "dak", "\u8fbe\u79d1\u4ed6\u8bed" },
            { "type.nu.fullwide", "\u5168\u89d2\u6570\u5b57" },
            { "hit", "\u8d6b\u68af\u8bed" },
            { "dar", "\u8fbe\u5c14\u683c\u74e6\u8bed" },
            { "dav", "\u53f0\u5854\u8bed" },
            { "Maya", "\u739b\u96c5\u5723\u7b26\u6587" },
            { "lrc", "\u5317\u5362\u5c14\u8bed" },
            { "type.co.emoji", "\u8868\u60c5\u7b26\u53f7\u6392\u5e8f" },
            { "Copt", "\u514b\u666e\u7279\u6587" },
            { "nwc", "\u53e4\u5178\u5c3c\u74e6\u5c14\u8bed" },
            { "udm", "\u4e4c\u5fb7\u7a46\u5c14\u7279\u8bed" },
            { "Khmr", "\u9ad8\u68c9\u6587" },
            { "%%FONNAPA", "\u798f\u7eb3\u5e15\u65b9\u8a00" },
            { "type.ca.islamic-rgsa", "\u6c99\u7279\u963f\u62c9\u4f2f\u4f0a\u65af\u5170\u5386" },
            { "Limb", "\u6797\u5e03\u6587" },
            { "sad", "\u6851\u8fbe\u97e6\u8bed" },
            { "type.nu.roman", "\u7f57\u9a6c\u6570\u5b57" },
            { "sah", "\u8428\u54c8\u8bed" },
            { "type.nu.shrd", "\u590f\u62c9\u8fbe\u6570\u5b57" },
            { "sam", "\u8428\u9a6c\u5229\u4e9a\u963f\u62c9\u59c6\u8bed" },
            { "Aghb", "\u9ad8\u52a0\u7d22\u963f\u5c14\u5df4\u5c3c\u4e9a\u6587" },
            { "%%SCOUSE", "\u5229\u7269\u6d66\u65b9\u8a00" },
            { "saq", "\u6851\u5e03\u9c81\u8bed" },
            { "sas", "\u8428\u8428\u514b\u6587" },
            { "sat", "\u6851\u5854\u5229\u8bed" },
            { "Tfng", "\u63d0\u975e\u7eb3\u6587" },
            { "type.d0.npinyin", metaValue_key_nu },
            { "jpr", "\u72b9\u592a\u6ce2\u65af\u8bed" },
            { "type.nu.native", "\u5f53\u5730\u6570\u5b57" },
            { "sba", "\u7518\u62dc\u8bed" },
            { "Guru", "\u679c\u9c81\u7a46\u5947\u6587" },
            { "%%ALUKU", "\u963f\u9c81\u5e93\u65b9\u8a00" },
            { "type.nu.diak", "\u8fea\u7ef4\u897f\u963f\u5e93\u9c81\u6570\u5b57" },
            { "lua", "\u5362\u5df4-\u5362\u62c9\u8bed" },
            { "%%BISCAYAN", "\u6bd4\u65af\u5f00\u65b9\u8a00" },
            { "type.nu.tirh", "\u8fc8\u8482\u5229\u6570\u5b57" },
            { "type.d0.fwidth", "\u5168\u89d2" },
            { "sbp", "\u6851\u53e4\u8bed" },
            { "lui", "\u5362\u4f0a\u585e\u8bfa\u8bed" },
            { "%%GRITAL", "\u683c\u91cc\u9676\u65b9\u8a00" },
            { "nyn", "\u5c3c\u6602\u79d1\u52d2\u8bed" },
            { "nym", "\u5c3c\u626c\u97e6\u9f50\u8bed" },
            { "lun", "\u9686\u8fbe\u8bed" },
            { "nyo", "\u5c3c\u5965\u7f57\u8bed" },
            { "luo", "\u5362\u5965\u8bed" },
            { "fil", "\u83f2\u5f8b\u5bbe\u8bed" },
            { "hmn", "\u82d7\u8bed" },
            { "del", "\u7279\u62c9\u534e\u8bed" },
            { "lus", "\u7c73\u4f50\u8bed" },
            { "bal", "\u4ffe\u8def\u652f\u8bed" },
            { "den", "\u53f2\u62c9\u7ef4\u8bed" },
            { "ban", "\u5df4\u5398\u8bed" },
            { "uga", "\u4e4c\u52a0\u91cc\u7279\u8bed" },
            { "type.nu.wara", "\u74e6\u90ce\u5947\u8482\u6570\u5b57" },
            { "luy", "\u5362\u96c5\u8bed" },
            { "bas", "\u5df4\u8428\u8bed" },
            { "bax", "\u5df4\u59c6\u7a46\u8bed" },
            { "%%ABL1943", "1943\u5e74\u6b63\u5199\u6cd5\u6784\u60f3" },
            { "jrb", "\u72b9\u592a\u963f\u62c9\u4f2f\u8bed" },
            { "es_ES", "\u6b27\u6d32\u897f\u73ed\u7259\u8bed" },
            { "nzi", "\u6069\u6d4e\u9a6c\u8bed" },
            { "sco", "\u82cf\u683c\u5170\u8bed" },
            { "scn", "\u897f\u897f\u91cc\u8bed" },
            { "aa", "\u963f\u6cd5\u5c14\u8bed" },
            { "ab", "\u963f\u5e03\u54c8\u897f\u4e9a\u8bed" },
            { "Aran", "\u6ce2\u65af\u4f53" },
            { "ae", "\u963f\u7ef4\u65af\u5854\u8bed" },
            { "af", "\u5357\u975e\u8377\u5170\u8bed" },
            { "ak", "\u963f\u80af\u8bed" },
            { "type.nu.cakm", "\u67e5\u514b\u739b\u6570\u5b57" },
            { "bbj", "\u6208\u9a6c\u62c9\u8bed" },
            { "am", "\u963f\u59c6\u54c8\u62c9\u8bed" },
            { "an", "\u963f\u62c9\u8d21\u8bed" },
            { "Arab", "\u963f\u62c9\u4f2f\u6587" },
            { "%%SOLBA", "Stolvizza/Solbica \u65b9\u8a00" },
            { "Jpan", "\u65e5\u6587" },
            { "ar", "\u963f\u62c9\u4f2f\u8bed" },
            { "Hrkt", "\u5047\u540d\u8868" },
            { "as", "\u963f\u8428\u59c6\u8bed" },
            { "Lina", "\u7ebf\u5f62\u6587\u5b57\uff08A\uff09" },
            { "av", "\u963f\u74e6\u5c14\u8bed" },
            { "Linb", "\u7ebf\u5f62\u6587\u5b57\uff08B\uff09" },
            { "sdh", "\u5357\u5e93\u5c14\u5fb7\u8bed" },
            { "ay", "\u827e\u9a6c\u62c9\u8bed" },
            { "az", "\u963f\u585e\u62dc\u7586\u8bed" },
            { "Rohg", "\u54c8\u4e43\u6590\u7f57\u5174\u4e9a\u6587" },
            { "Khoj", "\u514b\u5409\u5947\u6587\u5b57" },
            { "%%CISAUP", "\u897f\u8428\u666e\u65b9\u8a00" },
            { "%%OSOJS", "Oseacco/Osojane \u65b9\u8a00" },
            { "%%UNIFON", "Unifon\u97f3\u4f4d\u5b57\u6bcd" },
            { "ba", "\u5df4\u4ec0\u57fa\u5c14\u8bed" },
            { "type.co.unihan", "\u90e8\u9996\u7b14\u753b\u6392\u5e8f" },
            { "be", "\u767d\u4fc4\u7f57\u65af\u8bed" },
            { "bg", "\u4fdd\u52a0\u5229\u4e9a\u8bed" },
            { "bi", "\u6bd4\u65af\u62c9\u9a6c\u8bed" },
            { "type.nu.java", "\u722a\u54c7\u6587\u6570\u5b57" },
            { "bm", "\u73ed\u5df4\u62c9\u8bed" },
            { "bn", "\u5b5f\u52a0\u62c9\u8bed" },
            { "bo", "\u85cf\u8bed" },
            { "dgr", "\u591a\u683c\u91cc\u5e03\u8bed" },
            { "br", "\u5e03\u5217\u5854\u5c3c\u8bed" },
            { "bs", "\u6ce2\u65af\u5c3c\u4e9a\u8bed" },
            { "Bhks", "\u62dc\u514b\u8212\u514b\u6587" },
            { "see", "\u585e\u5185\u5361\u8bed" },
            { "Mymr", "\u7f05\u7538\u6587" },
            { "type.nu.laoo", "\u8001\u631d\u6570\u5b57" },
            { "seh", "\u585e\u7eb3\u8bed" },
            { "Nkoo", "\u897f\u975e\u4e66\u9762\u6587\u5b57\uff08N\u2019Ko\uff09" },
            { "sel", "\u585e\u5c14\u5e93\u666e\u8bed" },
            { "ca", "\u52a0\u6cf0\u7f57\u5c3c\u4e9a\u8bed" },
            { "ses", "\u4e1c\u6851\u6d77\u8bed" },
            { "ce", "\u8f66\u81e3\u8bed" },
            { "ch", "\u67e5\u83ab\u7f57\u8bed" },
            { "%%REVISED", "\u4fee\u8ba2\u7684\u62fc\u5b57" },
            { "co", "\u79d1\u897f\u5609\u8bed" },
            { "Orya", "\u5965\u91cc\u4e9a\u6587" },
            { "cr", "\u514b\u91cc\u65cf\u8bed" },
            { "cs", "\u6377\u514b\u8bed" },
            { "cu", "\u6559\u4f1a\u65af\u62c9\u592b\u8bed" },
            { "cv", "\u695a\u74e6\u4ec0\u8bed" },
            { "cy", "\u5a01\u5c14\u58eb\u8bed" },
            { "type.nu.ethi", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u6570\u5b57" },
            { "Yiii", "\u5f5d\u6587" },
            { "da", "\u4e39\u9ea6\u8bed" },
            { "pt_PT", "\u6b27\u6d32\u8461\u8404\u7259\u8bed" },
            { "de", "\u5fb7\u8bed" },
            { "type.cf.standard", "\u6807\u51c6\u8d27\u5e01\u683c\u5f0f" },
            { "bej", "\u8d1d\u6c99\u8bed" },
            { "din", "\u4e01\u5361\u8bed" },
            { "Bugi", "\u5e03\u5409\u6587" },
            { "bem", "\u672c\u5df4\u8bed" },
            { "sga", "\u53e4\u7231\u5c14\u5170\u8bed" },
            { "type.nu.mong", "\u8499\u53e4\u6587\u6570\u5b57" },
            { "dv", "\u8fea\u7ef4\u5e0c\u8bed" },
            { "es_419", "\u62c9\u4e01\u7f8e\u6d32\u897f\u73ed\u7259\u8bed" },
            { "dz", "\u5b97\u5361\u8bed" },
            { "bez", "\u8d1d\u7eb3\u8bed" },
            { "type.ca.chinese", "\u519c\u5386" },
            { "Lisu", "\u5088\u50f3\u6587" },
            { "dje", "\u54f2\u5c14\u9a6c\u8bed" },
            { "type.nu.grek", "\u5e0c\u814a\u6570\u5b57" },
            { "ee", "\u57c3\u7ef4\u8bed" },
            { "bfd", "\u5df4\u975e\u7279\u8bed" },
            { "type.lb.normal", "\u6b63\u5e38\u6362\u884c\u7b26\u6837\u5f0f" },
            { "ro_MD", "\u6469\u5c14\u591a\u74e6\u8bed" },
            { "el", "\u5e0c\u814a\u8bed" },
            { "en", "\u82f1\u8bed" },
            { "eo", "\u4e16\u754c\u8bed" },
            { "type.co.big5han", "\u7e41\u4f53\u4e2d\u6587\u6392\u5e8f - Big5" },
            { "es", "\u897f\u73ed\u7259\u8bed" },
            { "et", "\u7231\u6c99\u5c3c\u4e9a\u8bed" },
            { "Hanb", "\u6c49\u8bed\u6ce8\u97f3" },
            { "eu", "\u5df4\u65af\u514b\u8bed" },
            { "Buhd", "\u5e03\u5e0c\u5fb7\u6587" },
            { "Hang", "\u8c1a\u6587" },
            { "Samr", "\u6492\u9a6c\u5229\u4e9a\u6587" },
            { "shi", "\u5e0c\u5c14\u54c8\u8bed" },
            { "hsb", "\u4e0a\u7d22\u5e03\u8bed" },
            { "Hani", "\u6c49\u5b57" },
            { "%%ULSTER", "\u963f\u5c14\u65af\u7279\u65b9\u8a00" },
            { "shn", "\u63b8\u8bed" },
            { "Hano", "\u6c49\u5974\u7f57\u6587" },
            { "fa", "\u6ce2\u65af\u8bed" },
            { "Hans", "\u7b80\u4f53" },
            { "type.nu.latn", "\u897f\u65b9\u6570\u5b57" },
            { "Hant", "\u7e41\u4f53" },
            { "az_Arab", "\u5357\u963f\u585e\u62dc\u7586\u8bed" },
            { "ff", "\u5bcc\u62c9\u8bed" },
            { "shu", "\u4e4d\u5f97\u963f\u62c9\u4f2f\u8bed" },
            { "hsn", "\u6e58\u8bed" },
            { "fi", "\u82ac\u5170\u8bed" },
            { "fj", "\u6590\u6d4e\u8bed" },
            { "fon", "\u4e30\u8bed" },
            { "bgn", "\u897f\u4ffe\u8def\u652f\u8bed" },
            { "yue", "\u7ca4\u8bed" },
            { "fo", "\u6cd5\u7f57\u8bed" },
            { "type.m0.bgn", "\u7f8e\u56fd\u5730\u540d\u59d4\u5458\u4f1a (BGN)" },
            { "umb", "\u7fc1\u672c\u675c\u8bed" },
            { "fr", "\u6cd5\u8bed" },
            { "%%AKUAPEM", "\u963f\u5938\u4f69\u59c6\u65b9\u8a00" },
            { "sid", "\u6089\u8fbe\u6469\u8bed" },
            { "fy", "\u897f\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "ga", "\u7231\u5c14\u5170\u8bed" },
            { "Wcho", "\u4e07\u79cb\u6587" },
            { "gd", "\u82cf\u683c\u5170\u76d6\u5c14\u8bed" },
            { "Gong", "\u8d21\u8d3e\u62c9\u8d21\u5fb7\u6587" },
            { "gl", "\u52a0\u5229\u897f\u4e9a\u8bed" },
            { "Gonm", "\u9a6c\u8428\u62c9\u59c6\u5188\u5fb7\u6587" },
            { "gn", "\u74dc\u62c9\u5c3c\u8bed" },
            { "bho", "\u535a\u6770\u666e\u5c14\u8bed" },
            { "und", "\u672a\u77e5\u8bed\u8a00" },
            { "type.ca.ethiopic-amete-alem", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u963f\u7c73\u7279\u963f\u83b1\u59c6\u65e5\u5386" },
            { "gu", "\u53e4\u5409\u62c9\u7279\u8bed" },
            { "type.ca.islamic-tbla", "\u4f0a\u65af\u5170\u5929\u6587\u5386" },
            { "gv", "\u9a6c\u6069\u8bed" },
            { "type.nu.osma", "\u5965\u65af\u66fc\u6570\u5b57" },
            { "ha", "\u8c6a\u8428\u8bed" },
            { "he", "\u5e0c\u4f2f\u6765\u8bed" },
            { "hi", "\u5370\u5730\u8bed" },
            { "hup", "\u80e1\u5e15\u8bed" },
            { "bik", "\u6bd4\u79d1\u5c14\u8bed" },
            { "bin", "\u6bd4\u5c3c\u8bed" },
            { "ho", "\u5e0c\u91cc\u83ab\u56fe\u8bed" },
            { "hr", "\u514b\u7f57\u5730\u4e9a\u8bed" },
            { "ht", "\u6d77\u5730\u514b\u91cc\u5965\u5c14\u8bed" },
            { "hu", "\u5308\u7259\u5229\u8bed" },
            { "hy", "\u4e9a\u7f8e\u5c3c\u4e9a\u8bed" },
            { "hz", "\u8d6b\u96f7\u7f57\u8bed" },
            { "frc", "\u5361\u771f\u6cd5\u8bed" },
            { "%%FONIPA", "\u56fd\u9645\u97f3\u6807" },
            { "ia", "\u56fd\u9645\u8bed" },
            { "Jamo", "\u97e9\u6587\u5b57\u6bcd" },
            { "id", "\u5370\u5ea6\u5c3c\u897f\u4e9a\u8bed" },
            { "type.nu.tibt", "\u85cf\u6587\u6570\u5b57" },
            { "ie", "\u56fd\u9645\u6587\u5b57\uff08E\uff09" },
            { "%%GASCON", "\u52a0\u65af\u79d1\u65b9\u8a00" },
            { "ig", "\u4f0a\u535a\u8bed" },
            { "ii", "\u56db\u5ddd\u5f5d\u8bed" },
            { "frm", "\u4e2d\u53e4\u6cd5\u8bed" },
            { "%%RUMGR", "\u7f57\u66fc\u4ec0\u6587" },
            { "%%AO1990", "1990\u5e74\u8461\u8404\u7259\u8bed\u6b63\u5199\u6cd5\u534f\u8bae" },
            { "ik", "\u4f0a\u52aa\u76ae\u514b\u8bed" },
            { "fro", "\u53e4\u6cd5\u8bed" },
            { "io", "\u4f0a\u591a\u8bed" },
            { "frs", "\u4e1c\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "frr", "\u5317\u5f17\u91cc\u897f\u4e9a\u8bed" },
            { "is", "\u51b0\u5c9b\u8bed" },
            { "it", "\u610f\u5927\u5229\u8bed" },
            { "iu", "\u56e0\u7ebd\u7279\u8bed" },
            { "%%CORNU", "\u79d1\u5c14\u5c3c\u65b9\u8a00" },
            { "%%HOGNORSK", "\u9ad8\u5730\u632a\u5a01\u6587" },
            { "ja", "\u65e5\u8bed" },
            { "Mlym", "\u9a6c\u62c9\u96c5\u62c9\u59c6\u6587" },
            { "Sarb", "\u53e4\u5357\u963f\u62c9\u4f2f\u6587" },
            { "Sara", "\u6c99\u62c9\u5824\u6587" },
            { "doi", "\u591a\u683c\u62c9\u8bed" },
            { "type.nu.lepc", "\u96f7\u5e03\u67e5\u6587\u6570\u5b57" },
            { "bkm", "\u79d1\u59c6\u8bed" },
            { "sma", "\u5357\u8428\u7c73\u8bed" },
            { "jv", "\u722a\u54c7\u8bed" },
            { "Shaw", "\u8427\u4f2f\u7eb3\u5f0f\u6587" },
            { "%%BAUDDHA", "\u4f5b\u9640\u68b5\u6587" },
            { "mad", "\u9a6c\u90fd\u62c9\u8bed" },
            { "smj", "\u5415\u52d2\u8428\u7c73\u8bed" },
            { "mag", "\u6469\u63ed\u9640\u8bed" },
            { "maf", "\u9a6c\u6cd5\u8bed" },
            { "mai", "\u8fc8\u8482\u5229\u8bed" },
            { "smn", "\u4f0a\u7eb3\u91cc\u8428\u7c73\u8bed" },
            { "ka", "\u683c\u9c81\u5409\u4e9a\u8bed" },
            { "bla", "\u897f\u514b\u897f\u5361\u8bed" },
            { "mak", "\u671b\u52a0\u9521\u8bed" },
            { "wuu", "\u5434\u8bed" },
            { "sms", "\u65af\u79d1\u7279\u8428\u7c73\u8bed" },
            { "man", "\u66fc\u4e01\u54e5\u8bed" },
            { "kg", "\u521a\u679c\u8bed" },
            { "Goth", "\u54e5\u7279\u6587" },
            { "ki", "\u5409\u5e93\u5c24\u8bed" },
            { "mas", "\u9a6c\u8d5b\u8bed" },
            { "kj", "\u5bbd\u4e9a\u739b\u8bed" },
            { "kk", "\u54c8\u8428\u514b\u8bed" },
            { "kl", "\u683c\u9675\u5170\u8bed" },
            { "km", "\u9ad8\u68c9\u8bed" },
            { "kn", "\u5361\u7eb3\u8fbe\u8bed" },
            { "ko", "\u97e9\u8bed" },
            { "kr", "\u5361\u52aa\u91cc\u8bed" },
            { "ks", "\u514b\u4ec0\u7c73\u5c14\u8bed" },
            { "Cirt", "\u8272\u65af\u6587" },
            { "Lepc", "\u96f7\u5e03\u67e5\u6587" },
            { "Avst", "\u963f\u7ef4\u65af\u9640\u6587" },
            { "ku", "\u5e93\u5c14\u5fb7\u8bed" },
            { "kv", "\u79d1\u7c73\u8bed" },
            { "kw", "\u5eb7\u6c83\u5c14\u8bed" },
            { "ky", "\u67ef\u5c14\u514b\u5b5c\u8bed" },
            { "snk", "\u7d22\u5b81\u514b\u8bed" },
            { "Mult", "\u7a46\u5c14\u5766\u6587" },
            { "la", "\u62c9\u4e01\u8bed" },
            { "Hatr", "\u54c8\u7279\u5170\u6587" },
            { "lb", "\u5362\u68ee\u5821\u8bed" },
            { "type.nu.mlym", "\u9a6c\u62c9\u96c5\u62c9\u59c6\u6570\u5b57" },
            { "lg", "\u5362\u5e72\u8fbe\u8bed" },
            { "Roro", "\u6717\u683c\u6717\u683c\u6587" },
            { "li", "\u6797\u5821\u8bed" },
            { "Tibt", "\u85cf\u6587" },
            { "ln", "\u6797\u52a0\u62c9\u8bed" },
            { "fur", "\u5f17\u7559\u5229\u8bed" },
            { "lo", "\u8001\u631d\u8bed" },
            { "type.ms.uksystem", "\u82f1\u5236" },
            { "type.nu.lana", "\u8001\u50a3\u6587\u6570\u5b57" },
            { "lt", "\u7acb\u9676\u5b9b\u8bed" },
            { "lu", "\u9c81\u5df4\u52a0\u4e39\u52a0\u8bed" },
            { "lv", "\u62c9\u8131\u7ef4\u4e9a\u8bed" },
            { "sog", "\u7c9f\u7279\u8bed" },
            { "ListCompositionPattern", "{0}\uff0c{1}" },
            { "mg", "\u9a6c\u62c9\u52a0\u65af\u8bed" },
            { "mh", "\u9a6c\u7ecd\u5c14\u8bed" },
            { "type.co.ducet", "\u9ed8\u8ba4 Unicode \u6392\u5e8f" },
            { "mi", "\u6bdb\u5229\u8bed" },
            { "mk", "\u9a6c\u5176\u987f\u8bed" },
            { "ml", "\u9a6c\u62c9\u96c5\u62c9\u59c6\u8bed" },
            { "mn", "\u8499\u53e4\u8bed" },
            { "mr", "\u9a6c\u62c9\u5730\u8bed" },
            { "ms", "\u9a6c\u6765\u8bed" },
            { "mt", "\u9a6c\u8033\u4ed6\u8bed" },
            { "my", "\u7f05\u7538\u8bed" },
            { "Saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587" },
            { "Armn", "\u4e9a\u7f8e\u5c3c\u4e9a\u6587" },
            { "mdf", "\u83ab\u514b\u6c99\u8bed" },
            { "mde", "\u9a6c\u575d\u8bed" },
            { "dsb", "\u4e0b\u7d22\u5e03\u8bed" },
            { "Armi", "\u7687\u5ba4\u4e9a\u62c9\u59c6\u6587" },
            { "na", "\u7459\u9c81\u8bed" },
            { "type.co.search", "\u5e38\u89c4\u641c\u7d22" },
            { "nb", "\u4e66\u9762\u632a\u5a01\u8bed" },
            { "nd", "\u5317\u6069\u5fb7\u8d1d\u52d2\u8bed" },
            { "ne", "\u5c3c\u6cca\u5c14\u8bed" },
            { "ng", "\u6069\u4e1c\u52a0\u8bed" },
            { "mdr", "\u66fc\u8fbe\u5c14\u8bed" },
            { "nl", "\u8377\u5170\u8bed" },
            { "nn", "\u632a\u5a01\u5c3c\u8bfa\u65af\u514b\u8bed" },
            { "no", "\u632a\u5a01\u8bed" },
            { "%%PROVENC", "\u666e\u7f57\u65fa\u65af\u65b9\u8a00" },
            { "nr", "\u5357\u6069\u5fb7\u8d1d\u52d2\u8bed" },
            { "type.nu.modi", "\u83ab\u8fea\u6570\u5b57" },
            { "Osge", "\u6b27\u585e\u5947\u6587" },
            { "nv", "\u7eb3\u74e6\u970d\u8bed" },
            { "kaa", "\u5361\u62c9\u5361\u5c14\u5e15\u514b\u8bed" },
            { "ny", "\u9f50\u5207\u74e6\u8bed" },
            { "kac", "\u514b\u94a6\u8bed" },
            { "kab", "\u5361\u62dc\u5c14\u8bed" },
            { "%%POLYTON", "\u591a\u97f3\u5b57\u6bcd" },
            { "oc", "\u5965\u514b\u8bed" },
            { "kaj", "\u5361\u6377\u8bed" },
            { "kam", "\u5361\u59c6\u5df4\u8bed" },
            { "men", "\u95e8\u5fb7\u8bed" },
            { "%%EMODENG", "\u8fd1\u4ee3\u82f1\u8bed" },
            { "oj", "\u5965\u5409\u5e03\u74e6\u8bed" },
            { "mer", "\u6885\u9c81\u8bed" },
            { "type.nu.armn", "\u4e9a\u7f8e\u5c3c\u4e9a\u6570\u5b57" },
            { "om", "\u5965\u7f57\u83ab\u8bed" },
            { "kaw", "\u5361\u5a01\u8bed" },
            { "or", "\u5965\u91cc\u4e9a\u8bed" },
            { "Modi", "\u83ab\u8fea\u6587" },
            { "os", "\u5965\u585e\u68af\u8bed" },
            { "%%ALALC97", "1997 \u7248 ALA-LC \u7f57\u9a6c\u5b57" },
            { "kbd", "\u5361\u5df4\u5c14\u5fb7\u8bed" },
            { "mfe", "\u6bdb\u91cc\u6c42\u65af\u514b\u91cc\u5965\u5c14\u8bed" },
            { "srn", "\u82cf\u91cc\u5357\u6c64\u52a0\u8bed" },
            { "pa", "\u65c1\u906e\u666e\u8bed" },
            { "dua", "\u90fd\u963f\u62c9\u8bed" },
            { "srr", "\u585e\u96f7\u5c14\u8bed" },
            { "%%LIPAW", "\u96f7\u897f\u4e9a Lipovaz \u65b9\u8a00" },
            { "kbl", "\u52a0\u6d85\u59c6\u5e03\u8bed" },
            { "pi", "\u5df4\u5229\u8bed" },
            { "pl", "\u6ce2\u5170\u8bed" },
            { "dum", "\u4e2d\u53e4\u8377\u5170\u8bed" },
            { "type.nu.saur", "\u7d22\u62c9\u4ec0\u7279\u62c9\u6587\u6570\u5b57" },
            { "type.ca.dangi", "\u6a80\u7eaa\u5386" },
            { "%%VALLADER", "\u745e\u58eb\u74e6\u52d2\u5fb7\u65b9\u8a00" },
            { "ps", "\u666e\u4ec0\u56fe\u8bed" },
            { "pt", "\u8461\u8404\u7259\u8bed" },
            { "mga", "\u4e2d\u53e4\u7231\u5c14\u5170\u8bed" },
            { "key.co", "\u6392\u5e8f" },
            { "pt_BR", "\u5df4\u897f\u8461\u8404\u7259\u8bed" },
            { "%%BOHORIC", "\u535a\u970d\u91cc\u5947\u5b57\u6bcd" },
            { "kcg", "\u5361\u5854\u5e03\u8bed" },
            { "mgh", "\u9a6c\u5e93\u963f\u8bed" },
            { "key.cf", "\u8d27\u5e01\u683c\u5f0f" },
            { "type.nu.nkoo", "\u66fc\u5fb7\u6570\u5b57" },
            { "bra", "\u5e03\u62c9\u6770\u8bed" },
            { "key.ca", "\u65e5\u5386" },
            { "%%JAUER", "\u7c73\u65bd\u6cf0\u5c14\u65b9\u8a00" },
            { "Laoo", "\u8001\u631d\u6587" },
            { "%%SURMIRAN", "\u745e\u58eb\u82cf\u8fc8\u62c9\u65b9\u8a00" },
            { "mgo", "\u6885\u5854\u8bed" },
            { "type.hc.h23", "24\u5c0f\u65f6\u5236\uff080\u201323\uff09" },
            { "type.hc.h24", "24\u5c0f\u65f6\u5236\uff081\u201324\uff09" },
            { "ssy", "\u8428\u970d\u8bed" },
            { "type.nu.mymr", "\u7f05\u7538\u6570\u5b57" },
            { "qu", "\u514b\u4e18\u4e9a\u8bed" },
            { "zap", "\u8428\u6ce2\u8482\u514b\u8bed" },
            { "brx", "\u535a\u591a\u8bed" },
            { "Lana", "\u5170\u62ff\u6587" },
            { "kde", "\u9a6c\u5b54\u5fb7\u8bed" },
            { "%%VAIDIKA", "\u5420\u9640\u68b5\u6587" },
            { "Ethi", "\u57c3\u585e\u4fc4\u6bd4\u4e9a\u6587" },
            { "%%JYUTPING", "\u7ca4\u8bed\u62fc\u97f3" },
            { "type.hc.h12", "12\u5c0f\u65f6\u5236\uff081\u201312\uff09" },
            { "type.hc.h11", "12\u5c0f\u65f6\u5236\uff080\u201311\uff09" },
            { "rm", "\u7f57\u66fc\u4ec0\u8bed" },
            { "rn", "\u9686\u8fea\u8bed" },
            { "key.cu", "\u8d27\u5e01" },
            { "ro", "\u7f57\u9a6c\u5c3c\u4e9a\u8bed" },
            { "%%SAAHO", "\u8428\u970d\u6587" },
            { "type.nu.orya", "\u5965\u91cc\u4e9a\u6570\u5b57" },
            { "type.nu.hanidec", "\u4e2d\u6587\u5341\u8fdb\u5236\u6570\u5b57" },
            { "ru", "\u4fc4\u8bed" },
            { "bss", "\u963f\u5e93\u8272\u8bed" },
            { "rw", "\u5362\u65fa\u8fbe\u8bed" },
            { "zbl", "\u5e03\u91cc\u65af\u7b26\u53f7" },
            { "kea", "\u5361\u5e03\u4f5b\u5f97\u9c81\u8bed" },
            { "mic", "\u5bc6\u514b\u9a6c\u514b\u8bed" },
            { "suk", "\u82cf\u5e93\u9a6c\u8bed" },
            { "en_AU", "\u6fb3\u5927\u5229\u4e9a\u82f1\u8bed" },
            { "Dupl", "\u675c\u666e\u6d1b\u4f0a\u901f\u8bb0" },
            { "sa", "\u68b5\u8bed" },
            { "%%UCCOR", "\u7edf\u4e00\u7684\u62fc\u5b57" },
            { "sc", "\u8428\u4e01\u8bed" },
            { "sus", "\u82cf\u82cf\u8bed" },
            { "sd", "\u4fe1\u5fb7\u8bed" },
            { "se", "\u5317\u65b9\u8428\u7c73\u8bed" },
            { "min", "\u7c73\u5357\u4f73\u4fdd\u8bed" },
            { "sg", "\u6851\u6208\u8bed" },
            { "sh", "\u585e\u5c14\u7ef4\u4e9a-\u514b\u7f57\u5730\u4e9a\u8bed" },
            { "si", "\u50e7\u4f3d\u7f57\u8bed" },
            { "sux", "\u82cf\u7f8e\u5c14\u8bed" },
            { "sk", "\u65af\u6d1b\u4f10\u514b\u8bed" },
            { "sl", "\u65af\u6d1b\u6587\u5c3c\u4e9a\u8bed" },
            { "Gran", "\u683c\u5170\u5854\u6587" },
            { "sm", "\u8428\u6469\u4e9a\u8bed" },
            { "%%BASICENG", "\u57fa\u672c\u82f1\u8bed" },
            { "sn", "\u7ecd\u7eb3\u8bed" },
            { "so", "\u7d22\u9a6c\u91cc\u8bed" },
            { "type.nu.arab", "\u963f\u62c9\u4f2f-\u5370\u5ea6\u6570\u5b57" },
            { "sq", "\u963f\u5c14\u5df4\u5c3c\u4e9a\u8bed" },
            { "sr", "\u585e\u5c14\u7ef4\u4e9a\u8bed" },
            { "ListKeyTypePattern", "{0}\uff1a{1}" },
            { "ss", "\u65af\u74e6\u8482\u8bed" },
            { "type.cf.account", "\u4f1a\u8ba1\u8d27\u5e01\u683c\u5f0f" },
            { "st", "\u5357\u7d22\u6258\u8bed" },
            { "Java", "\u722a\u54c7\u6587" },
            { "su", "\u5dfd\u4ed6\u8bed" },
            { "%%NEDIS", "Natisone \u65b9\u8a00" },
            { "sv", "\u745e\u5178\u8bed" },
            { "sw", "\u65af\u74e6\u5e0c\u91cc\u8bed" },
            { "type.nu.wcho", "\u4e07\u79cb\u6570\u5b57" },
            { "type.nu.hantfin", "\u7e41\u4f53\u4e2d\u6587\u5927\u5199\u6570\u5b57" },
            { "ibb", "\u4f0a\u6bd4\u6bd4\u5965\u8bed" },
            { "iba", "\u4f0a\u73ed\u8bed" },
            { "ta", "\u6cf0\u7c73\u5c14\u8bed" },
            { "142", "\u4e9a\u6d32" },
            { "bua", "\u5e03\u91cc\u4e9a\u7279\u8bed" },
            { "143", "\u4e2d\u4e9a" },
            { "te", "\u6cf0\u5362\u56fa\u8bed" },
            { "145", "\u897f\u4e9a" },
            { "tg", "\u5854\u5409\u514b\u8bed" },
            { "th", "\u6cf0\u8bed" },
            { "%%SPANGLIS", "\u897f\u73ed\u7259\u5f0f\u82f1\u8bed" },
            { "ti", "\u63d0\u683c\u5229\u5c3c\u4e9a\u8bed" },
            { "bug", "\u5e03\u5409\u8bed" },
            { "kfo", "\u514b\u7f57\u8bed" },
            { "en_CA", "\u52a0\u62ff\u5927\u82f1\u8bed" },
            { "tk", "\u571f\u5e93\u66fc\u8bed" },
            { "tl", "\u4ed6\u52a0\u7984\u8bed" },
            { "tn", "\u8328\u74e6\u7eb3\u8bed" },
            { "to", "\u6c64\u52a0\u8bed" },
            { "bum", "\u5e03\u9c81\u8bed" },
            { "dyo", "\u6731\u62c9\u8bed" },
            { "type.nu.jpan", "\u65e5\u6587\u6570\u5b57" },
            { "tr", "\u571f\u8033\u5176\u8bed" },
            { "ts", "\u806a\u52a0\u8bed" },
            { "swb", "\u79d1\u6469\u7f57\u8bed" },
            { "Cakm", "\u67e5\u514b\u9a6c\u6587" },
            { "tt", "\u9791\u977c\u8bed" },
            { "%%XSISTEMO", "\u897f\u897f\u65af\u7279\u83ab\u65b9\u8a00" },
            { "dyu", "\u8fea\u5c24\u62c9\u8bed" },
            { "tw", "\u5951\u7ef4\u8bed" },
            { "ty", "\u5854\u5e0c\u63d0\u8bed" },
            { "%%BISKE", "\u5723\u4e54\u6cbb/\u6bd4\u62c9\u65b9\u8a00" },
            { "150", "\u6b27\u6d32" },
            { "151", "\u4e1c\u6b27" },
            { "type.nu.rohg", "\u54c8\u4e43\u6590\u7f57\u5174\u4e9a\u6570\u5b57" },
            { "type.nu.mathsanb", "\u6570\u5b66\u65e0\u886c\u7ebf\u7c97\u4f53\u6570\u5b57" },
            { "154", "\u5317\u6b27" },
            { "dzg", "\u8fbe\u624e\u845b\u8bed" },
            { "155", "\u897f\u6b27" },
            { "ug", "\u7ef4\u543e\u5c14\u8bed" },
            { "Ital", "\u53e4\u610f\u5927\u5229\u6587" },
            { "Kore", "\u97e9\u6587" },
            { "Zyyy", "\u901a\u7528" },
            { "uk", "\u4e4c\u514b\u5170\u8bed" },
            { "type.ca.coptic", "\u79d1\u666e\u7279\u5386" },
            { "ur", "\u4e4c\u5c14\u90fd\u8bed" },
            { "%%1994", "\u6807\u51c6\u96f7\u897f\u4e9a\u62fc\u5b57" },
            { "xal", "\u5361\u5c14\u6885\u514b\u8bed" },
            { "zen", "\u6cfd\u7eb3\u52a0\u8bed" },
            { "uz", "\u4e4c\u5179\u522b\u514b\u8bed" },
            { "kha", "\u5361\u897f\u8bed" },
            { "%%1996", "1996 \u5e74\u5fb7\u6587\u62fc\u5b57" },
            { "nds_NL", "\u4f4e\u8428\u514b\u68ee\u8bed" },
            { "Sylo", "\u9521\u5c14\u8d6b\u7279\u6587" },
            { "ve", "\u6587\u8fbe\u8bed" },
            { "Wara", "\u74e6\u90ce\u5947\u8482\u6587\u5b57" },
            { "type.ca.roc", "\u6c11\u56fd\u7eaa\u5e74" },
            { "vi", "\u8d8a\u5357\u8bed" },
            { "kho", "\u548c\u7530\u8bed" },
            { "khq", "\u897f\u6851\u6d77\u8bed" },
            { "key.hc", "\u5c0f\u65f6\u5236\uff0812\u621624\uff09" },
            { "%%TARASK", "Taraskievica \u62fc\u5b57" },
            { "vo", "\u6c83\u62c9\u666e\u514b\u8bed" },
            { "syc", "\u53e4\u5178\u53d9\u5229\u4e9a\u8bed" },
            { "type.nu.mathsans", "\u6570\u5b66\u65e0\u886c\u7ebf\u6570\u5b57" },
            { "Osma", "\u5965\u65af\u66fc\u4e9a\u6587" },
            { "quc", "\u57fa\u5207\u8bed" },
            { "type.nu.gonm", metaValue_type_nu_gong },
            { "Newa", "\u5c3c\u74e6\u6587" },
            { "gaa", "\u52a0\u65cf\u8bed" },
            { "wa", "\u74e6\u9686\u8bed" },
            { "gag", "\u52a0\u544a\u5179\u8bed" },
            { "syr", "\u53d9\u5229\u4e9a\u8bed" },
            { "type.nu.gong", metaValue_type_nu_gong },
            { "Grek", "\u5e0c\u814a\u6587" },
            { "gan", "\u8d63\u8bed" },
            { "Lydi", "\u5415\u5e95\u4e9a\u6587" },
            { "Xsux", "\u82cf\u7f8e\u5c14-\u963f\u5361\u5fb7\u6954\u5f62\u6587\u5b57" },
            { "wo", "\u6c83\u6d1b\u592b\u8bed" },
            { "zgh", "\u6807\u51c6\u6469\u6d1b\u54e5\u5854\u9a6c\u585e\u7279\u8bed" },
            { "ar_001", "\u73b0\u4ee3\u6807\u51c6\u963f\u62c9\u4f2f\u8bed" },
            { "Cans", "\u52a0\u62ff\u5927\u571f\u8457\u7edf\u4e00\u97f3\u8282" },
            { "%%FONXSAMP", "X-SAMPA \u97f3\u6807" },
            { "gay", "\u8fe6\u7ea6\u8bed" },
            { "Mong", "\u8499\u53e4\u6587" },
            { "mnc", "\u6ee1\u8bed" },
            { "Latf", "\u62c9\u4e01\u6587\uff08\u54e5\u7279\u5f0f\u5b57\u4f53\u53d8\u4f53\uff09" },
            { "Hluw", "\u5b89\u90a3\u6258\u5229\u4e9a\u8c61\u5f62\u6587\u5b57" },
            { "gba", "\u683c\u5df4\u4e9a\u8bed" },
            { "mni", "\u66fc\u5c3c\u666e\u5c14\u8bed" },
            { "Latn", "\u62c9\u4e01\u6587" },
            { "Latg", "\u62c9\u4e01\u6587\uff08\u76d6\u5c14\u6587\u53d8\u4f53\uff09" },
            { "Nand", "\u6960\u8fea\u68b5\u6587" },
            { "type.nu.hans", "\u7b80\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "type.nu.hant", "\u7e41\u4f53\u4e2d\u6587\u6570\u5b57" },
            { "xh", "\u79d1\u8428\u8bed" },
            { "type.nu.romanlow", "\u7f57\u9a6c\u5c0f\u5199\u6570\u5b57" },
            { "byn", "\u6bd4\u6797\u8bed" },
            { "Dogr", "\u591a\u683c\u62c9\u6587" },
            { "%%PAMAKA", "Pamaka \u65b9\u8a00" },
            { "Lyci", "\u5229\u897f\u4e9a\u6587" },
            { "osa", "\u5965\u585e\u6cbb\u8bed" },
            { "byv", "\u6885\u6566\u5df4\u8bed" },
            { "Moon", "\u97e9\u6587\u8bed\u7cfb" },
            { "moh", "\u6469\u970d\u514b\u8bed" },
            { "kkj", "\u5361\u5e93\u8bed" },
            { "%%1694ACAD", "\u65e9\u671f\u73b0\u4ee3\u6cd5\u6587" },
            { "yi", "\u610f\u7b2c\u7eea\u8bed" },
            { "mos", "\u83ab\u897f\u8bed" },
            { "Syrc", "\u53d9\u5229\u4e9a\u6587" },
            { "Dsrt", "\u5fb7\u585e\u83b1\u7279\u6587" },
            { "yo", "\u7ea6\u9c81\u5df4\u8bed" },
            { "type.nu.traditional", "\u4f20\u7edf\u6570\u5b57" },
            { "es_MX", "\u58a8\u897f\u54e5\u897f\u73ed\u7259\u8bed" },
            { "Syrj", "\u897f\u53d9\u5229\u4e9a\u6587" },
            { "ota", "\u5965\u65af\u66fc\u571f\u8033\u5176\u8bed" },
            { "Syre", "\u798f\u97f3\u4f53\u53d9\u5229\u4e9a\u6587" },
            { "vai", "\u74e6\u4f0a\u8bed" },
            { "za", "\u58ee\u8bed" },
            { "Cari", "\u5361\u91cc\u4e9a\u6587" },
            { "kln", "\u5361\u4f26\u91d1\u8bed" },
            { "zh", "\u4e2d\u6587" },
            { "Afak", "\u963f\u6cd5\u5361\u6587" },
            { "Bopo", "\u6c49\u8bed\u62fc\u97f3" },
            { "Perm", "\u53e4\u5f7c\u5c14\u59c6\u6587" },
            { "key.lb", "\u6362\u884c\u7b26\u6837\u5f0f" },
            { "zu", "\u7956\u9c81\u8bed" },
            { "type.co.phonebook", "\u7535\u8bdd\u7c3f\u6392\u5e8f" },
            { "%%MONOTON", "\u5355\u97f3\u5b57\u6bcd" },
            { "Geor", "\u683c\u9c81\u5409\u4e9a\u6587" },
            { "Shrd", "\u590f\u62c9\u8fbe\u6587" },
            { "%%LENGADOC", "\u9686\u683c\u591a\u514b\u65b9\u8a00" },
            { "kmb", "\u91d1\u90a6\u675c\u8bed" },
            { "type.nu.jpanfin", "\u65e5\u6587\u5927\u5199\u6570\u5b57" },
            { "Cham", "\u5360\u6587" },
            { "gez", "\u5409\u5179\u8bed" },
            { "Syrn", "\u4e1c\u53d9\u5229\u4e9a\u6587" },
            { "type.nu.mymrshan", "\u7f05\u7538\u63b8\u6587\u6570\u5b57" },
            { "Elba", "\u7231\u5c14\u5df4\u6851\u6587" },
            { "Narb", "\u53e4\u5317\u65b9\u963f\u62c9\u4f2f\u6587" },
            { "type.nu.olck", "\u6851\u5854\u5229\u6587\u6570\u5b57" },
            { "type.co.reformed", "\u6539\u826f\u6392\u5e8f" },
            { "Tglg", "\u5854\u52a0\u8def\u6587" },
            { "Egyd", "\u540e\u671f\u57c3\u53ca\u6587" },
            { "Egyh", "\u53e4\u57c3\u53ca\u50e7\u4fa3\u4e66\u5199\u4f53" },
            { "Yezi", "\u96c5\u5179\u8fea\u6587" },
            { "%%ITIHASA", "\u53f2\u8bd7\u68b5\u6587" },
            { "Palm", "\u5e15\u5c14\u8fc8\u62c9\u6587" },
            { "ebu", "\u6069\u5e03\u8bed" },
            { "Egyp", "\u53e4\u57c3\u53ca\u8c61\u5f62\u6587" },
            { "Geok", "\u683c\u9c81\u5409\u4e9a\u6587\uff08\u6559\u5802\u4f53\uff09" },
            { "zh_Hans", "\u7b80\u4f53\u4e2d\u6587" },
            { "koi", "\u79d1\u7c73-\u5f7c\u5c14\u7c73\u4e9a\u514b\u8bed" },
            { "Hung", "\u53e4\u5308\u7259\u5229\u6587" },
            { "kok", "\u5b54\u5361\u5c3c\u8bed" },
            { "%%1901", "\u4f20\u7edf\u5fb7\u6587\u62fc\u5b57" },
            { "kos", "\u79d1\u65af\u62c9\u4f0a\u8bed" },
            { "%%PAHAWH2", "\u5e15\u54c8\u82d7\u65872\u4ee3" },
            { "%%PAHAWH3", "\u5e15\u54c8\u82d7\u65873\u4ee3" },
            { "%%PAHAWH4", "\u5e15\u54c8\u82d7\u65874\u4ee3" },
            { "type.nu.limb", "\u6797\u5e03\u6587\u6570\u5b57" },
            { "zh_Hant", "\u7e41\u4f53\u4e2d\u6587" },
            { "Sund", "\u5dfd\u4ed6\u6587" },
            { "vep", "\u7ef4\u666e\u68ee\u8bed" },
            { "kpe", "\u514b\u4f69\u5217\u8bed" },
            { "%%GRCLASS", "\u7c97\u7c92\u7ea7" },
            { "type.nu.khmr", "\u9ad8\u68c9\u6570\u5b57" },
            { "Tirh", "\u8fc8\u8482\u5229\u6587" },
            { "ilo", "\u4f0a\u6d1b\u5361\u8bfa\u8bed" },
            { "%%VALENCIA", "\u74e6\u4f26\u897f\u4e9a\u6587" },
            { "Cprt", "\u585e\u6d66\u8def\u65af\u6587" },
            { "Diak", "\u8fea\u7ef4\u897f\u963f\u5e93\u9c81\u6587" },
            { "%%BAKU1926", "\u7edf\u4e00\u571f\u8033\u5176\u62c9\u4e01\u5b57\u6bcd" },
            { "%%IJEKAVSK", "\u585e\u5c14\u7ef4\u4e9a\u8bed\u4f0a\u5409\u5361\u7ef4\u4e9a\u53d1\u97f3" },
            { "mua", "\u8499\u5f53\u8bed" },
            { "type.nu.guru", "\u679c\u9c81\u7a46\u5947\u6570\u5b57" },
            { "%%BORNHOLM", "\u535a\u6069\u970d\u5c14\u59c6\u65b9\u8a00" },
            { "mul", "\u591a\u8bed\u79cd" },
            { "%%PUTER", "\u745e\u58eb\u666e\u7279\u5c14\u65b9\u8a00" },
            { "cad", "\u5361\u591a\u8bed" },
            { "key.ms", "\u5ea6\u91cf\u8861\u5236" },
            { "mus", "\u514b\u91cc\u514b\u8bed" },
            { "Glag", "\u683c\u62c9\u54e5\u91cc\u6587" },
            { "gil", "\u5409\u5c14\u4f2f\u7279\u8bed" },
            { "%%KKCOR", "\u5e38\u7528\u62fc\u5b57" },
            { "Cher", "\u5207\u7f57\u57fa\u6587" },
            { "car", "\u52a0\u52d2\u6bd4\u8bed" },
            { "cay", "\u5361\u5c24\u52a0\u8bed" },
            { "type.nu.tamldec", "\u6cf0\u7c73\u5c14\u6570\u5b57" },
            { "krc", "\u5361\u62c9\u6070\u4f0a\u5df4\u5c14\u5361\u5c14\u8bed" },
            { "inh", "\u5370\u53e4\u4ec0\u8bed" },
            { "fa_AF", "\u8fbe\u91cc\u8bed" },
            { "krl", "\u5361\u7d2f\u5229\u963f\u8bed" },
            { "%%OXENDICT", "\u300a\u725b\u6d25\u82f1\u8bed\u8bcd\u5178\u300b\u62fc\u6cd5" },
            { "efi", "\u57c3\u83f2\u514b\u8bed" },
            { "key.nu", metaValue_key_nu },
            { "kru", "\u5e93\u9c81\u514b\u8bed" },
            { "ksb", "\u9999\u5df4\u62c9\u8bed" },
            { "Telu", "\u6cf0\u5362\u56fa\u6587" },
            { "ksf", "\u5df4\u83f2\u4e9a\u8bed" },
        };
        return data;
    }
}
