/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.runtime.ExceptionUtils;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;

class ImplicitTagLibraryInfo
extends TagLibraryInfo {
    private static final String WEB_INF_TAGS = "/WEB-INF/tags";
    private static final String TAG_FILE_SUFFIX = ".tag";
    private static final String TAGX_FILE_SUFFIX = ".tagx";
    private static final String TAGS_SHORTNAME = "tags";
    private static final String TLIB_VERSION = "1.0";
    private static final String JSP_VERSION = "2.0";
    private static final String IMPLICIT_TLD = "implicit.tld";
    private Hashtable<String, String> tagFileMap;
    private ParserController pc;
    private PageInfo pi;
    private Vector<TagFileInfo> vec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImplicitTagLibraryInfo(JspCompilationContext jspCompilationContext, ParserController parserController, PageInfo pageInfo, String string, String string2, ErrorDispatcher errorDispatcher) throws JasperException {
        super(string, null);
        this.pc = parserController;
        this.pi = pageInfo;
        this.tagFileMap = new Hashtable();
        this.vec = new Vector();
        this.functions = new FunctionInfo[0];
        this.tlibversion = TLIB_VERSION;
        this.jspversion = JSP_VERSION;
        if (!string2.startsWith(WEB_INF_TAGS)) {
            errorDispatcher.jspError("jsp.error.invalid.tagdir", string2);
        }
        if (string2.equals(WEB_INF_TAGS) || string2.equals("/WEB-INF/tags/")) {
            this.shortname = TAGS_SHORTNAME;
        } else {
            this.shortname = string2.substring(WEB_INF_TAGS.length());
            this.shortname = this.shortname.replace('/', '-');
        }
        Set<String> set = jspCompilationContext.getResourcePaths(string2);
        if (set != null) {
            for (String string3 : set) {
                String string4;
                Object object;
                if (string3.endsWith(TAG_FILE_SUFFIX) || string3.endsWith(TAGX_FILE_SUFFIX)) {
                    object = string3.endsWith(TAG_FILE_SUFFIX) ? TAG_FILE_SUFFIX : TAGX_FILE_SUFFIX;
                    string4 = string3.substring(string3.lastIndexOf(47) + 1);
                    string4 = string4.substring(0, string4.lastIndexOf((String)object));
                    this.tagFileMap.put(string4, string3);
                    continue;
                }
                if (!string3.endsWith(IMPLICIT_TLD)) continue;
                object = null;
                try {
                    String string5;
                    boolean bl;
                    boolean bl2;
                    ParserUtils parserUtils;
                    TreeNode treeNode;
                    object = jspCompilationContext.getResourceAsStream(string3);
                    if (object == null) continue;
                    if (pageInfo != null) {
                        pageInfo.addDependant(string3, jspCompilationContext.getLastModified(string3));
                    }
                    if ((treeNode = (parserUtils = new ParserUtils(bl2 = Boolean.parseBoolean((string4 = jspCompilationContext.getServletContext()).getInitParameter("org.apache.jasper.XML_VALIDATE_TLD")), bl = (string5 = string4.getInitParameter("org.apache.jasper.XML_BLOCK_EXTERNAL")) == null ? true : Boolean.parseBoolean(string5))).parseXMLDocument(this.uri, (InputStream)object)).findAttribute("version") != null) {
                        this.jspversion = treeNode.findAttribute("version");
                    }
                    Iterator<TreeNode> iterator = treeNode.findChildren();
                    while (iterator.hasNext()) {
                        TreeNode treeNode2 = iterator.next();
                        String string6 = treeNode2.getName();
                        if ("tlibversion".equals(string6) || "tlib-version".equals(string6)) {
                            this.tlibversion = treeNode2.getBody();
                            continue;
                        }
                        if ("jspversion".equals(string6) || "jsp-version".equals(string6)) {
                            this.jspversion = treeNode2.getBody();
                            continue;
                        }
                        if ("shortname".equals(string6) || "short-name".equals(string6)) continue;
                        errorDispatcher.jspError("jsp.error.invalid.implicit", string3);
                    }
                    try {
                        double d = Double.parseDouble(this.jspversion);
                        if (!(d < 2.0)) continue;
                        errorDispatcher.jspError("jsp.error.invalid.implicit.version", string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        errorDispatcher.jspError("jsp.error.invalid.implicit.version", string3);
                    }
                }
                finally {
                    if (object == null) continue;
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ExceptionUtils.handleThrowable(throwable);
                    }
                }
            }
        }
    }

    public TagFileInfo getTagFile(String string) {
        TagFileInfo tagFileInfo = super.getTagFile(string);
        if (tagFileInfo == null) {
            String string2 = this.tagFileMap.get(string);
            if (string2 == null) {
                return null;
            }
            TagInfo tagInfo = null;
            try {
                tagInfo = TagFileProcessor.parseTagFileDirectives(this.pc, string, string2, this.pc.getJspCompilationContext().getTagFileJarResource(string2), this);
            }
            catch (JasperException jasperException) {
                throw new RuntimeException(jasperException.toString(), (Throwable)((Object)jasperException));
            }
            tagFileInfo = new TagFileInfo(string, string2, tagInfo);
            this.vec.addElement(tagFileInfo);
            this.tagFiles = new TagFileInfo[this.vec.size()];
            this.vec.copyInto(this.tagFiles);
        }
        return tagFileInfo;
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        Collection<TagLibraryInfo> collection = this.pi.getTaglibs();
        return collection.toArray(new TagLibraryInfo[0]);
    }
}

