/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.apache.catalina.connector.CometEventImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class CometConnectionManagerValve
extends ValveBase
implements HttpSessionListener,
LifecycleListener {
    protected static final String info = "org.apache.catalina.valves.CometConnectionManagerValve/1.0";
    protected final List<Request> cometRequests = Collections.synchronizedList(new ArrayList());
    protected final String cometRequestsAttribute = "org.apache.tomcat.comet.connectionList";

    public CometConnectionManagerValve() {
        super(false);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.container instanceof Context) {
            this.container.addLifecycleListener(this);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this.container instanceof Context) {
            this.container.removeLifecycleListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_stop".equals(lifecycleEvent.getType())) {
            for (Request request : this.cometRequests) {
                HttpSession httpSession = request.getSession(false);
                if (httpSession != null) {
                    httpSession.removeAttribute("org.apache.tomcat.comet.connectionList");
                }
                CometEventImpl cometEventImpl = request.getEvent();
                try {
                    cometEventImpl.setEventType(CometEvent.EventType.END);
                    cometEventImpl.setEventSubType(CometEvent.EventSubType.WEBAPP_RELOAD);
                    this.getNext().event(request, request.getResponse(), cometEventImpl);
                }
                catch (Exception exception) {
                    this.container.getLogger().warn((Object)sm.getString("cometConnectionManagerValve.event"), (Throwable)exception);
                }
                finally {
                    try {
                        cometEventImpl.close();
                    }
                    catch (IOException iOException) {
                        this.container.getLogger().warn((Object)sm.getString("cometConnectionManagerValve.event"), (Throwable)iOException);
                    }
                }
            }
            this.cometRequests.clear();
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (request.isComet() && !response.isClosed()) {
            HttpSession httpSession = request.getSession(true);
            this.cometRequests.add(request);
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                Request[] requestArray = (Request[])httpSession.getAttribute("org.apache.tomcat.comet.connectionList");
                if (requestArray == null) {
                    requestArray = new Request[]{request};
                    httpSession.setAttribute("org.apache.tomcat.comet.connectionList", (Object)requestArray);
                } else {
                    Request[] requestArray2 = new Request[requestArray.length + 1];
                    for (int i = 0; i < requestArray.length; ++i) {
                        requestArray2[i] = requestArray[i];
                    }
                    requestArray2[requestArray.length] = request;
                    httpSession.setAttribute("org.apache.tomcat.comet.connectionList", (Object)requestArray2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, CometEvent cometEvent) throws IOException, ServletException {
        block35: {
            boolean bl = false;
            try {
                this.getNext().event(request, response, cometEvent);
                bl = true;
                if (bl && !response.isClosed() && cometEvent.getEventType() != CometEvent.EventType.END && (cometEvent.getEventType() != CometEvent.EventType.ERROR || cometEvent.getEventSubType() == CometEvent.EventSubType.TIMEOUT)) break block35;
                this.cometRequests.remove(request);
            }
            catch (Throwable throwable) {
                if (!bl || response.isClosed() || cometEvent.getEventType() == CometEvent.EventType.END || cometEvent.getEventType() == CometEvent.EventType.ERROR && cometEvent.getEventSubType() != CometEvent.EventSubType.TIMEOUT) {
                    this.cometRequests.remove(request);
                    HttpSession httpSession = request.getSession(false);
                    if (httpSession != null) {
                        HttpSession httpSession2 = httpSession;
                        synchronized (httpSession2) {
                            Request[] requestArray = null;
                            try {
                                requestArray = (Request[])httpSession.getAttribute("org.apache.tomcat.comet.connectionList");
                            }
                            catch (IllegalStateException illegalStateException) {
                                // empty catch block
                            }
                            if (requestArray != null) {
                                boolean bl2 = false;
                                for (int i = 0; !bl2 && i < requestArray.length; ++i) {
                                    bl2 = requestArray[i] == request;
                                }
                                if (bl2) {
                                    if (requestArray.length > 1) {
                                        Request[] requestArray2 = new Request[requestArray.length - 1];
                                        int n = 0;
                                        for (int i = 0; i < requestArray.length; ++i) {
                                            if (requestArray[i] == request) continue;
                                            requestArray2[n++] = requestArray[i];
                                        }
                                        try {
                                            httpSession.setAttribute("org.apache.tomcat.comet.connectionList", (Object)requestArray2);
                                        }
                                        catch (IllegalStateException illegalStateException) {}
                                    } else {
                                        try {
                                            httpSession.removeAttribute("org.apache.tomcat.comet.connectionList");
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw throwable;
            }
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                HttpSession httpSession3 = httpSession;
                synchronized (httpSession3) {
                    Request[] requestArray = null;
                    try {
                        requestArray = (Request[])httpSession.getAttribute("org.apache.tomcat.comet.connectionList");
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    if (requestArray != null) {
                        boolean bl3 = false;
                        for (int i = 0; !bl3 && i < requestArray.length; ++i) {
                            bl3 = requestArray[i] == request;
                        }
                        if (bl3) {
                            if (requestArray.length > 1) {
                                Request[] requestArray3 = new Request[requestArray.length - 1];
                                int n = 0;
                                for (int i = 0; i < requestArray.length; ++i) {
                                    if (requestArray[i] == request) continue;
                                    requestArray3[n++] = requestArray[i];
                                }
                                try {
                                    httpSession.setAttribute("org.apache.tomcat.comet.connectionList", (Object)requestArray3);
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                try {
                                    httpSession.removeAttribute("org.apache.tomcat.comet.connectionList");
                                }
                                catch (IllegalStateException illegalStateException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        Request[] requestArray = (Request[])httpSessionEvent.getSession().getAttribute("org.apache.tomcat.comet.connectionList");
        if (requestArray != null) {
            for (int i = 0; i < requestArray.length; ++i) {
                Request request = requestArray[i];
                try {
                    CometEventImpl cometEventImpl = request.getEvent();
                    cometEventImpl.setEventType(CometEvent.EventType.END);
                    cometEventImpl.setEventSubType(CometEvent.EventSubType.SESSION_END);
                    ((CometProcessor)request.getWrapper().getServlet()).event(cometEventImpl);
                    cometEventImpl.close();
                    continue;
                }
                catch (Exception exception) {
                    request.getWrapper().getParent().getLogger().warn((Object)sm.getString("cometConnectionManagerValve.listenerEvent"), (Throwable)exception);
                }
            }
        }
    }
}

