/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.google.protobuf.MessageLite;
import com.mysql.cj.api.io.PacketSentTimeHolder;
import com.mysql.cj.api.x.io.MessageWriter;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.CJCommunicationsException;
import com.mysql.cj.core.exceptions.CJPacketTooBigException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SyncMessageWriter
implements MessageWriter,
PacketSentTimeHolder {
    static final int HEADER_LEN = 5;
    private BufferedOutputStream outputStream;
    private long lastPacketSentTime = 0L;
    private int maxAllowedPacket = -1;

    public SyncMessageWriter(BufferedOutputStream os) {
        this.outputStream = os;
    }

    @Override
    public void write(MessageLite msg) {
        try {
            int type = MessageWriter.getTypeForMessageClass(msg.getClass());
            int size = 1 + msg.getSerializedSize();
            if (this.maxAllowedPacket > 0 && size > this.maxAllowedPacket) {
                throw new CJPacketTooBigException(Messages.getString("PacketTooBigException.1", new Object[]{size, this.maxAllowedPacket}));
            }
            byte[] sizeHeader = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(size).array();
            this.outputStream.write(sizeHeader);
            this.outputStream.write(type);
            msg.writeTo((OutputStream)this.outputStream);
            this.outputStream.flush();
            this.lastPacketSentTime = System.currentTimeMillis();
        }
        catch (IOException ex) {
            throw new CJCommunicationsException("Unable to write message", ex);
        }
    }

    @Override
    public long getLastPacketSentTime() {
        return this.lastPacketSentTime;
    }

    @Override
    public void setMaxAllowedPacket(int maxAllowedPacket) {
        this.maxAllowedPacket = maxAllowedPacket;
    }
}

