/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.filter.OSGiFilter;
import org.apache.ivy.osgi.filter.OSGiFilterParser;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class P2ArtifactParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;
    private final String repoUrl;

    public P2ArtifactParser(P2Descriptor p2Descriptor, String repoUrl) {
        this.p2Descriptor = p2Descriptor;
        this.repoUrl = repoUrl;
    }

    @Override
    public void parse(InputStream in) throws IOException, ParseException, SAXException {
        RepositoryHandler handler = new RepositoryHandler(this.p2Descriptor, this.repoUrl);
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    private static class RepositoryHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";
        private Map<OSGiFilter, String> artifactPatterns = new LinkedHashMap<OSGiFilter, String>();

        public RepositoryHandler(P2Descriptor p2Descriptor, String repoUrl) {
            super(REPOSITORY);
            this.addChild(new MappingsHandler(), new DelegatingHandler.ChildElementHandler<MappingsHandler>(){

                @Override
                public void childHandled(MappingsHandler child) {
                    for (Map.Entry<String, String> entry : child.outputByFilter.entrySet()) {
                        OSGiFilter filter;
                        try {
                            filter = OSGiFilterParser.parse(entry.getKey());
                        }
                        catch (ParseException e) {
                            throw new IllegalStateException();
                        }
                        artifactPatterns.put(filter, entry.getValue());
                    }
                }
            });
            this.addChild(new ArtifactsHandler(p2Descriptor, this.artifactPatterns, repoUrl), new DelegatingHandler.ChildElementHandler<ArtifactsHandler>(){

                @Override
                public void childHandled(ArtifactsHandler child) {
                }
            });
        }
    }

    private static class ArtifactHandler
    extends DelegatingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String CLASSIFIER = "classifier";
        private static final String ID = "id";
        private static final String VERSION = "version";
        private P2Artifact p2Artifact;
        private Map<String, String> properties;

        public ArtifactHandler() {
            super(ARTIFACT);
            this.addChild(new PropertiesParser.PropertiesHandler(new String[0]), new DelegatingHandler.ChildElementHandler<PropertiesParser.PropertiesHandler>(){

                @Override
                public void childHandled(PropertiesParser.PropertiesHandler child) {
                    properties = child.properties;
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            Version version = new Version(atts.getValue(VERSION));
            String classifier = atts.getValue(CLASSIFIER);
            this.p2Artifact = new P2Artifact(id, version, classifier);
        }
    }

    private static class ArtifactsHandler
    extends DelegatingHandler {
        private static final String ARTIFACTS = "artifacts";

        public ArtifactsHandler(final P2Descriptor p2Descriptor, final Map<OSGiFilter, String> artifactPatterns, final String repoUrl) {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegatingHandler.ChildElementHandler<ArtifactHandler>(){

                @Override
                public void childHandled(ArtifactHandler child) throws SAXParseException {
                    String url = this.getPattern(child.p2Artifact, child.properties);
                    if (url != null) {
                        URI uri;
                        url = url.replaceAll("\\$\\{repoUrl\\}", repoUrl);
                        url = url.replaceAll("\\$\\{id\\}", child.p2Artifact.getId());
                        url = url.replaceAll("\\$\\{version\\}", child.p2Artifact.getVersion().toString());
                        try {
                            uri = new URL(url).toURI();
                        }
                        catch (MalformedURLException | URISyntaxException e) {
                            throw new SAXParseException("Incorrect artifact url '" + url + "' (" + e.getMessage() + ")", this.getLocator(), e);
                        }
                        p2Descriptor.addArtifactUrl(child.p2Artifact.getClassifier(), child.p2Artifact.getId(), child.p2Artifact.getVersion(), uri, (String)child.properties.get("format"));
                    }
                }

                private String getPattern(P2Artifact p2Artifact, Map<String, String> properties) {
                    HashMap<String, String> props = new HashMap<String, String>(properties);
                    props.put("classifier", p2Artifact.getClassifier());
                    for (Map.Entry pattern : artifactPatterns.entrySet()) {
                        if (!((OSGiFilter)pattern.getKey()).eval(props)) continue;
                        return (String)pattern.getValue();
                    }
                    return null;
                }
            });
        }
    }

    private static class RuleHandler
    extends DelegatingHandler {
        private static final String RULE = "rule";
        private static final String FILTER = "filter";
        private static final String OUTPUT = "output";
        private String filter;
        private String output;

        public RuleHandler() {
            super(RULE);
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            this.filter = atts.getValue(FILTER);
            this.output = atts.getValue(OUTPUT);
        }
    }

    private static class MappingsHandler
    extends DelegatingHandler {
        private static final String MAPPINGS = "mappings";
        private static final String SIZE = "size";
        Map<String, String> outputByFilter;

        public MappingsHandler() {
            super(MAPPINGS);
            this.addChild(new RuleHandler(), new DelegatingHandler.ChildElementHandler<RuleHandler>(){

                @Override
                public void childHandled(RuleHandler child) {
                    outputByFilter.put(child.filter, child.output);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.outputByFilter = new LinkedHashMap<String, String>(size);
        }
    }
}

