/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.TileEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Fire;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Smoke;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class FireSmokeTileSkin
extends TileSkin {
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Text text;
    private Smoke smoke;
    private Fire fire;

    public FireSmokeTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text();
        this.valueText.setFill(this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode(this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(this.upperUnitText, this.unitText);
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(this.valueText, this.unitFlow);
        this.valueUnitFlow.setAlignment(Pos.BOTTOM_CENTER);
        this.valueUnitFlow.setMouseTransparent(true);
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.smoke = new Smoke();
        this.fire = new Fire();
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.valueUnitFlow, this.fractionLine, this.text, this.smoke, this.fire});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvent.EventType.VALUE.name().equals(EVENT_TYPE)) {
            this.handleCurrentValue(this.tile.getCurrentValue());
        } else if (TileEvent.EventType.VISIBILITY.name().equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
        } else if (TileEvent.EventType.SECTION.name().equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(Helper.clamp(this.minValue, this.maxValue, VALUE)));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, Helper.clamp(this.minValue, this.maxValue, VALUE)));
        }
        this.resizeDynamicText();
        if (VALUE > this.tile.getThreshold()) {
            this.smoke.start();
            this.fire.start();
        } else {
            this.smoke.stop();
            this.fire.stop();
        }
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.48;
        this.valueText.setFont(Fonts.latoBold(fontSize));
        double correctedFontSize = fontSize;
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            correctedFontSize = Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        double fontFactor = correctedFontSize / fontSize;
        maxWidth = this.size * 0.275;
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.24 : this.size * 0.2;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize * fontFactor));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.24 : this.size * 0.2;
        this.unitText.setFont(Fonts.latoRegular(fontSize * fontFactor));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.valueUnitFlow.relocate(this.size * 0.05, (this.height - this.valueUnitFlow.getLayoutBounds().getHeight()) * 0.5);
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
    }

    @Override
    protected void resize() {
        super.resize();
        this.smoke.setWidth(this.width);
        this.smoke.setHeight(this.height);
        this.fire.setWidth(this.width);
        this.fire.setHeight(this.height);
        Rectangle smokeClip = new Rectangle(this.width, this.height);
        Rectangle fireClip = new Rectangle(this.width, this.height);
        if (this.tile.getRoundedCorners()) {
            smokeClip.setArcWidth(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025));
            smokeClip.setArcHeight(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025));
            fireClip.setArcWidth(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025));
            fireClip.setArcHeight(Helper.clamp(0.0, Double.MAX_VALUE, this.size * 0.025));
        }
        this.smoke.setClip(smokeClip);
        this.fire.setClip(fireClip);
        this.resizeDynamicText();
        this.resizeStaticText();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, (this.height - this.valueUnitFlow.getLayoutBounds().getHeight()) * 0.5);
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue())));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, Helper.clamp(this.minValue, this.maxValue, this.tile.getCurrentValue())));
        }
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode(this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode(this.fractionLine, false);
        }
        this.resizeDynamicText();
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.upperUnitText.setFill(this.tile.getUnitColor());
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.unitText.setFill(this.tile.getUnitColor());
        this.text.setFill(this.tile.getTextColor());
    }
}

