/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs;

import com.thizzer.jtouchbar.JTouchBar;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPanel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.mac.touchbar.TouchBarUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.table.MVTable;
import org.apache.commons.lang3.SystemUtils;

public abstract class AGuiTabPanel
extends JPanel {
    protected MVTable tabelle;
    protected Daten daten;
    protected MediathekGui mediathekGui;
    protected JTouchBar touchBar;

    public abstract void showTouchBar();

    public abstract void hideTouchBar();

    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.tabelleNachDatenSchreiben();
        }
    }

    protected void setupTouchBar() {
    }

    protected abstract List<DatenFilm> getSelFilme();

    protected abstract Optional<DatenFilm> getCurrentlySelectedFilm();

    public abstract void installMenuEntries(JMenu var1);

    protected abstract void installTabInfoStatusBarControl();

    protected void initializeTouchBar() {
        if (SystemUtils.IS_OS_MAC_OSX && TouchBarUtils.isTouchBarSupported()) {
            this.setupTouchBar();
        }
    }

    public class MarkFilmAsUnseenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> listFilms = AGuiTabPanel.this.getSelFilme();
            try (SeenHistoryController controller = new SeenHistoryController();){
                controller.markUnseen(listFilms);
            }
        }
    }

    public class MarkFilmAsSeenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            List<DatenFilm> listFilms = AGuiTabPanel.this.getSelFilme();
            try (SeenHistoryController controller = new SeenHistoryController();){
                controller.markSeen(listFilms);
            }
        }
    }
}

